pub mod consts;
pub mod types;
pub mod utils;

use serde_json::json;
use serde_json::to_string;
use std::fs::create_dir_all;
use std::fs::File;
use std::fs::OpenOptions;
use std::io::Write;
pub use types::*;

impl PlayIt {
  pub fn new(playit_opts: Option<PlayItOpts>) -> Result<Self, String> {
    utils::get_defaults(playit_opts)
  }

  pub fn create_tunnel(&self, port: u16, proto: Prototype, ip: Option<&str>) -> Tunnel {
    let ip = ip.unwrap_or("127.0.0.1");

    let tunnel_id = self
      .req_client
      .post(self.api_path.join("/account/tunnels").unwrap())
      .body(
        to_string(&json!({
          "id": null,
          "game": format!("custom-{}", match proto {
            Prototype::Tcp => "tcp",
            Prototype::Udp => "udp",
          }),
          "local_port": port,
          "local_ip": ip,
          "local_proto": proto,
          "agent_id": &self
                        .req_client
                        .get(self.api_path.join("/account/agents").unwrap())
                        .send()
                        .unwrap()
                        .json::<Agents>()
                        .unwrap()
                        .agents
                        .into_iter()
                        .find(|agent| agent.key == self.agent_key)
                        .unwrap()
                        .id,
          "domain_id": null
        }))
        .unwrap(),
      )
      .send()
      .unwrap()
      .json::<Id>()
      .unwrap()
      .id;

    loop {
      let data = self
        .req_client
        .get(self.api_path.join("/account/tunnels").unwrap())
        .send()
        .unwrap()
        .json::<Tunnels>()
        .unwrap()
        .tunnels
        .into_iter()
        .find(|tunnel| tunnel.id == tunnel_id)
        .unwrap();

      if data.domain_id.is_some() && data.connect_address.is_some() {
        break data;
      }
    }
  }

  #[cfg(feature = "enable-tunnels")]
  pub fn enable_tunnel(&self, id: i32) {
    self
      .req_client
      .get(
        self
          .api_path
          .join(&format!("/account/tunnels/{}/enable", id))
          .unwrap(),
      )
      .send()
      .expect(&format!("Failed To Enable The Tunnel"));
  }

  #[cfg(feature = "disable-tunnels")]
  pub fn disable_tunnel(&self, id: i32) {
    self
      .req_client
      .get(
        self
          .api_path
          .join(&format!("/account/tunnels/{}/disable", id))
          .unwrap(),
      )
      .send()
      .expect(&format!("Failed To Failed The Tunnel"));
  }
}

#[cfg(test)]
mod tests;
