use crate::types::*;
use std::fs::OpenOptions;
use std::io::BufRead;
use std::io::BufReader;
use std::io::Write;
use std::net::TcpListener;
use std::process::exit;
use std::thread::sleep;
use std::thread::spawn;
use std::time::Duration;
use std::time::Instant;

#[test]
fn start() {
  spawn(|| {
    let listener: TcpListener = TcpListener::bind("127.0.0.1:4567").unwrap_or_else(|_| loop {});

    let response = "HTTP/1.1 200 OK\r\nContent-Length: 72\r\n\r\n<h1>It Works!</h1><br/><p>If You're Reading This, Then PlayIt Works!</p>";

    for stream in listener.incoming() {
      let mut stream = stream.unwrap();

      stream.write(response.as_bytes()).ok();
      stream.flush().ok();
    }
  });
  let mut playit: PlayIt = PlayIt::new(None).unwrap();

  let tunnel: Tunnel = playit.create_tunnel(CreateTunnelOptions {
    ip: None,
    proto: String::from("tcp"),
    port: 4567,
  });

  let time: Instant = Instant::now();
  print!("\n\n");
  println!("Architexture: {}", playit.arch);
  println!("Operating System: {}", playit.os);
  println!(
    "PlayIt Tunnel: http://{}",
    tunnel.connect_address.as_ref().unwrap()
  );
  println!("PlayIt Config File: {}", playit.config_file.display());
  println!("PlayIt Binary: {}", playit.binary.display());
  println!("PlayIt Version: {}", playit.version);
  println!("PlayIt Agent Key: {}", playit.agent_key);
  println!("PlayIt Server: {}", playit.server);
  println!("PlayIt First Lines Of PlayIt Output: \n{}", {
    let mut command_stderr: String = String::new();
    let mut command_stdout: String = String::new();

    BufReader::new(playit.playit.stderr.as_mut().unwrap())
      .read_line(&mut command_stderr)
      .unwrap();
    BufReader::new(playit.playit.stdout.as_mut().unwrap())
      .read_line(&mut command_stdout)
      .unwrap();
    [command_stdout, command_stderr].concat()
  });

  loop {
    let res = playit
      .req_client
      .get(format!(
        "http://{}",
        tunnel.connect_address.as_ref().unwrap()
      ))
      .send();

    if res.is_ok() && res.unwrap().text().unwrap().contains("It Works!") {
      let elapsed = format!("{:.2}", time.elapsed().as_secs_f32());
      println!("Tunnel Is Active In {} Seconds!", elapsed);
      OpenOptions::new()
        .create(true)
        .append(true)
        .open(playit.dir.join("activation-times.txt"))
        .unwrap()
        .write(&(elapsed + "\n").into_bytes())
        .ok();
      break;
    }
  }

  sleep(Duration::from_secs(30));

  exit(0)
}
