pub mod consts;
pub mod types;
pub mod utils;
use serde_json::json;
use serde_json::to_string;
pub use types::*;

pub fn new(playit_opts: Option<PlayItOpts>) -> Result<PlayIt, String> {
  return PlayIt::new(playit_opts);
}

impl PlayIt {
  pub fn new(playit_opts: Option<PlayItOpts>) -> Result<Self, String> {
    return utils::get_defaults(playit_opts);
  }

  pub fn create_tunnel(&self, mut options: CreateTunnelOptions) -> Tunnel {
    options.ip = Option::from(options.ip.unwrap_or(String::from("127.0.0.1")));

    let tunnel_id = self
      .req_client
      .post(self.api_path.join("/account/tunnels").unwrap())
      .body(
        to_string(&json!({
          "id": null,
          "game": format!("custom-{}", options.proto.to_lowercase()),
          "local_port": options.port,
          "local_ip": options.ip,
          "local_proto": options.proto,
          "agent_id": &self
                        .req_client
                        .get(self.api_path.join("/account/agents").unwrap())
                        .send()
                        .unwrap()
                        .json::<Agents>()
                        .unwrap()
                        .agents
                        .into_iter()
                        .find(|agent| agent.key == self.agent_key)
                        .unwrap()
                        .id,
          "domain_id": null
        }))
        .unwrap(),
      )
      .send()
      .unwrap()
      .json::<Id>()
      .unwrap()
      .id;

    return loop {
      let data = self
        .req_client
        .get(self.api_path.join("/account/tunnels").unwrap())
        .send()
        .unwrap()
        .json::<Tunnels>()
        .unwrap()
        .tunnels
        .into_iter()
        .find(|tunnel| tunnel.id == tunnel_id)
        .unwrap();

      if data.domain_id.is_some() && data.connect_address.is_some() {
        break data;
      }
    };
  }

  #[cfg(feature = "enable-tunnels")]
  pub fn enable_tunnel(&self, id: i32) {
    self
      .req_client
      .get(
        self
          .api_path
          .join(&format!("/account/tunnels/{}/enable", id))
          .unwrap(),
      )
      .send()
      .expect(&format!("Failed To Enable The Tunnel"));
  }

  #[cfg(feature = "disable-tunnels")]
  pub fn disable_tunnel(&self, id: i32) {
    self
      .req_client
      .get(
        self
          .api_path
          .join(&format!("/account/tunnels/{}/disable", id))
          .unwrap(),
      )
      .send()
      .expect(&format!("Failed To Failed The Tunnel"));
  }

  pub fn as_ref(&self) -> &Self {
    return &self;
  }
}

#[cfg(test)]
mod tests;
