use cfg_if::cfg_if;

cfg_if! {
  if #[cfg(any(
    target_os = "linux",
    target_os = "freebsd",
    target_os = "dragonfly",
    target_os = "openbsd",
    target_os = "netbsd"
  ))] {
    pub const OS: &str = "lin";
  } else if #[cfg(target_os = "windows")] {
    pub const OS: &str = "win";
  } else if #[cfg(target_os = "macos")] {
    pub const OS: &str = "mac";
  }
}

cfg_if! {
  if #[cfg(target_arch = "x86_64")] {
    pub const ARCH: &str = "x64";
  } else if #[cfg(target_arch = "aarch64")] {
    pub const ARCH: &str = "arm64";
  }else if #[cfg(target_arch = "arm")] {
    pub const ARCH: &str = "arm";
  } else {
    pub const ARCH: &str = "";
  }
}

pub const VERSION: &str = "0.4.7";
