use crate::types::*;
use std::io::BufRead;
use std::io::BufReader;
use tokio::spawn;
use warp::any;
use warp::serve;
use warp::Filter;
#[tokio::test]
async fn start() {
  let ws = spawn(async {
    serve(any().map(|| "It Works!\nIf You're Reading This, Then PlayIt Works!"))
      .run(([127, 0, 0, 1], 8080))
      .await
  });
  let mut playit = PlayIt::new(None).await.unwrap();

  let tunnel = playit
    .create_tunnel(CreateTunnelOptions {
      ip: None,
      proto: String::from("tcp"),
      port: 8080,
    })
    .await;

  print!("\n\n");
  println!("Architexture: {}", playit.arch);
  println!("Operating System: {}", playit.os);
  println!(
    "PlayIt Tunnel: http://{}",
    tunnel.connect_address.as_ref().unwrap()
  );
  println!(
    "PlayIt Config File: {}",
    playit.config_file.to_str().unwrap()
  );
  println!("PlayIt Binary: {}", playit.binary.to_str().unwrap());
  println!("PlayIt Version: {}", playit.version);
  println!("PlayIt Agent Key: {}", playit.agent_key);
  println!("PlayIt Server: {}", playit.server);
  println!("PlayIt First Lines Of PlayIt Output: \n{}", {
    let mut command_stderr: Vec<u8> = Vec::new();
    let mut command_stdout: Vec<u8> = Vec::new();

    BufReader::new(playit.playit.stderr.as_mut().unwrap())
      .read_until(b'\n', &mut command_stderr)
      .unwrap();
    BufReader::new(playit.playit.stdout.as_mut().unwrap())
      .read_until(b'\n', &mut command_stdout)
      .unwrap();
    String::from_utf8([command_stdout, command_stderr].concat()).unwrap()
  });
  print!("\n");

  loop {
    let res = playit
      .req_client
      .get(format!(
        "http://{}",
        tunnel.connect_address.as_ref().unwrap()
      ))
      .send()
      .await
      .ok();

    if !res.is_none() && res.unwrap().text().await.unwrap().contains("It Works!") {
      println!("Tunnel Is Active!");
      break;
    }
  }

  ws.await.unwrap();
}
