#![allow(non_snake_case)]
use reqwest::Client;
use serde::Deserialize;
use serde::Serialize;
use std::collections::HashMap;
use std::ops::Deref;
use std::ops::DerefMut;
use std::path::PathBuf;
use std::process::Child as _Child;
use url::Url;

#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct PlayItOpts {
  pub PREFERRED_TUNNEL: Option<String>,
  pub PREFERRED_THRESHOLD: Option<i64>,
  pub NO_SPECIAL_LAN: Option<bool>,
  pub KEEP_CONFIG: Option<bool>,
}

#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct Tunnel {
  pub id: u32,
  pub agent_id: u32,
  pub game: String,
  pub local_ip: String,
  pub local_port: u16,
  pub domain_id: Option<u32>,
  pub status: String,
  pub connect_address: Option<String>,
  pub is_custom_domain: bool,
  pub tunnel_version: u8,
}

#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct Tunnels {
  pub tunnels: Vec<Tunnel>,
}

#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct Connection {
  pub ip: String,
  pub tunnel: Tunnel,
  pub proto: String,
}

pub struct PlayIt {
  pub req_client: Client,
  pub os: String,
  pub config_file: PathBuf,
  pub arch: String,
  pub dir: PathBuf,
  pub destroyed: bool,
  pub tunnels: Vec<Tunnel>,
  pub agent_key: String,
  pub started: bool,
  pub playit: Child,
  pub server: String,
  pub used_packets: u8,
  pub free_packets: u8,
  pub connections: Vec<Connection>,
  pub version: String,
  pub download_urls: HashMap<String, Url>,
  pub binary: PathBuf,
  pub binary_type: String,
  pub output: Vec<String>,
  pub stdout: Vec<String>,
  pub stderr: Vec<String>,
  pub errors: Vec<String>,
  pub warnings: Vec<String>,
  pub api_path: Url,
}

#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct CreateTunnelOptions {
  pub proto: String,
  pub ip: Option<String>,
  pub port: u16,
}

#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct Agent {
  pub tunnel_server_name: Option<String>,
  pub host_ip: Option<String>,
  pub is_connected: bool,
  pub key: String,
  pub id: u32,
}

#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct Agents {
  pub agents: Vec<Agent>,
}

#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct Config {
  pub agent_key: Option<String>,
  pub preferred_tunnel: Option<String>,
}

#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct Id {
  pub id: u32,
}

pub struct Child(pub _Child);

impl Drop for Child {
  fn drop(&mut self) {
    self.0.kill().expect("Failed To Kill Child");
  }
}

impl Deref for Child {
  type Target = _Child;

  fn deref(&self) -> &Self::Target {
    return &self.0;
  }
}

impl DerefMut for Child {
  fn deref_mut(&mut self) -> &mut _Child {
    return &mut self.0;
  }
}
