use crate::pkgmanager::PkgManager;
use std::process::Command;
use std::process::Child;

pub struct Pacman {
    no_confirm:bool
}

impl Pacman {
    pub fn new() ->Self {
        Self {
            no_confirm: false
        }
    }
}

impl PkgManager for Pacman {
    fn install(&mut self, pkg: String) -> Result<Child, std::io::Error> {
        let args = if self.no_confirm {
            vec!["-Rns".into(), pkg, "--noconfirm".into()]
        } else {
            vec!["-Rns".into(), pkg]
        };
        let mut pacman = Command::new("pacman");
        let pacman = pacman.args(args);
        pacman.spawn()
    }
    fn uninstall(&mut self, pkg: String) -> Result<Child, std::io::Error> {
        let args = if self.no_confirm {
            vec!["-S".into(), pkg, "--noconfirm".into()]
        } else {
            vec!["-S".into(), pkg]
        };
        let mut pacman = Command::new("pacman");
        let pacman = pacman.args(args);
        pacman.spawn()
    }
    fn no_confirm(&mut self, set: bool) {
        self.no_confirm = set;
    }
    fn get_name(&self) -> String {
        "pacman".into()
    }
}
