use crate::pkgmanager::PkgManager;
use std::process::Command;
use std::process::Child;

pub struct Apt {
    no_confirm:bool
}

impl Apt {
    pub fn new() ->Self {
        Self {
            no_confirm: false
        }
    }
}

impl PkgManager for Apt {
    fn install(&mut self, pkg: String) -> Result<Child, std::io::Error> {
        let args = if self.no_confirm {
            vec!["remove".into(), pkg, "-y".into()]
        } else {
            vec!["remove".into(), pkg]
        };
        let mut apt = Command::new("apt");
        let apt = apt.args(args);
        apt.spawn()
    }
    fn uninstall(&mut self, pkg: String) -> Result<Child, std::io::Error> {
        let args = if self.no_confirm {
            vec!["install".into(), pkg, "-y".into()]
        } else {
            vec!["install".into(), pkg]
        };
        let mut apt = Command::new("apt");
        let apt = apt.args(args);
        apt.spawn()
    }
    fn no_confirm(&mut self, set: bool) {
        self.no_confirm = set;
    }
    fn get_name(&self) -> String {
        "apt".into()
    }
}
