use rsmpeg::avutil::AVPixelFormat;
use rsmpeg::ffi;

#[derive(Clone, Copy, Debug, Display, Hash, PartialEq, PartialOrd)]
pub enum PixelFormat {
	Y8,    Y16,
	Ya8,   Ya16,
	Rgb8,  Rgb16,
	Rgba8, Rgba16,
	Bgr8,  Bgr16,
	Bgra8, Bgra16,
}

impl PixelFormat {
	pub const fn bytes(&self) -> usize {
		match self {
			Self::Y8     => 1,
			Self::Y16    => 2,
			Self::Ya8    => 2,
			Self::Ya16   => 4,
			Self::Rgb8   => 3,
			Self::Rgb16  => 6,
			Self::Rgba8  => 4,
			Self::Rgba16 => 8,
			Self::Bgr8   => 4,
			Self::Bgr16  => 8,
			Self::Bgra8  => 4,
			Self::Bgra16 => 8,
		}
	}
}

impl From<PixelFormat> for AVPixelFormat {
	fn from(from: PixelFormat) -> Self {
		match from {
			PixelFormat::Y8     => ffi::AVPixelFormat_AV_PIX_FMT_GRAY8,
			PixelFormat::Y16    => ffi::AVPixelFormat_AV_PIX_FMT_GRAY16,
			PixelFormat::Ya8    => ffi::AVPixelFormat_AV_PIX_FMT_YA8,
			PixelFormat::Ya16   => ffi::AVPixelFormat_AV_PIX_FMT_YA16,
			PixelFormat::Rgb8   => ffi::AVPixelFormat_AV_PIX_FMT_RGB24,
			PixelFormat::Rgb16  => ffi::AVPixelFormat_AV_PIX_FMT_RGB48,
			PixelFormat::Rgba8  => ffi::AVPixelFormat_AV_PIX_FMT_RGBA,
			PixelFormat::Rgba16 => ffi::AVPixelFormat_AV_PIX_FMT_RGBA64,
			PixelFormat::Bgr8   => ffi::AVPixelFormat_AV_PIX_FMT_BGR24,
			PixelFormat::Bgr16  => ffi::AVPixelFormat_AV_PIX_FMT_BGR48,
			PixelFormat::Bgra8  => ffi::AVPixelFormat_AV_PIX_FMT_BGRA,
			PixelFormat::Bgra16 => ffi::AVPixelFormat_AV_PIX_FMT_BGRA64,
		}
	}
}
