import os
import random

def test_pithy(pagename: str, pagetext: str):
    #First, we save the text to a file under a random filename
    filename = str(random.randint(0, 1000000))
    with open(filename, "w") as f:
        f.write(pagetext)
    densities = [0.3, 0.4, 0.6, 1, 1.4, 1.8, 2.2, 2.6, 3, 3.4, 3.8, 4.2, 4.6, 5, 6]
    results: dict[str, float] = dict()
    for d in densities:
        indv = filename + "_" + str(d)
        os.system("pithy -f " + filename + f" --density {d} --nobar --no_context --sentences 1 > {indv}.pithy")
        with open(indv + ".pithy", "r") as f:
            results[f.read().replace('\n', '')] = d
        os.remove(indv + ".pithy")
    os.remove(filename)
    #Write the page, the density -> results to wikipedia.md
    with open("wikipedia.md", "a") as f:
        f.write(f"## {pagename}\n")
        for k, v in results.items():
            f.write(f"* **Density {v}** -> {k}\n")

import wikipediaapi #type: ignore
wiki = wikipediaapi.Wikipedia(
        language='en',
        extract_format=wikipediaapi.ExtractFormat.WIKI
)
import threading
pages = open("pages.txt", "r").read().split("\n")
def do_page(p):
    wiki_page = wiki.page(page)
    texts: dict[str, str] = dict()
    texts[wiki_page.title] = wiki_page.text
    links = list(wiki_page.links.keys())
    for link in links:
        if link not in texts:
            texts[link] = wiki.page(link)
            print("Fetching " + link)
            threading.Thread(target=test_pithy, args=(texts[link].title, texts[link].text)).start()

for page in pages:
    threading.Thread(target=do_page, args=(page,)).start()