# How to contribute to Piston

<a href="#donate_money">How to donate money</a>

Git commands, and the pull request process: https://github.com/PistonDevelopers/rust-empty/issues/31

We use the issue tracker heavily. We try to plan as much as possible up front and break the tasks down into 'Easy' tasks. You do not need to know a lot about Rust to work on the project. [Rust-Empty](https://github.com/pistondevelopers/rust-empty) contains a lot of information in the issue tracker for those new to Rust/Terminal/Vim/GitHub.

The most common way of contributing is by creating PRs.  
If you do not need write access, you do not have to be added as collaborator.  
If you need write access to a specific repository, people in the Admin group can invite you.  

### Getting started

Here is how you get started:

1. [Fork](https://github.com/PistonDevelopers/piston/fork) the repository.
2. Clone your repository to the local hard drive ([GitHub for Mac](https://mac.github.com/), [Github for Window](https://windows.github.com/)).
3. Open up the Terminal and navigate to the project directory.
4. If you have not installed Rust yet, download it [here](http://www.rust-lang.org/).
5. Type `cargo build` to build the library.

You work against the fork as you would do with personal projects. When you want review of your code, open up a pull request on GitHub. *Even if it is just a small change, a PR makes it easier for other people to follow the changes!*

Feel free to open issues, post comments about progress, questions, new ideas, brainstorming etc. The label "Information" is used to collect relevant information. You can remove and edit comments as a way of refining ideas in the issue tracker. This is very helpful because many concerns in this project are very complex. Many issues needs to be broken down into new issues before they can be implemented. Please add comments like "can copy code from X" that tells other people how you do it efficiently.

If you have an idea how to make collaboration better, open an issue.

### Becoming a part of the PistonCollaborator team

The PistonCollaborator team is a group of people with write access to all projects.  
For security reasons there are some rules:

To be added as collaborator, it is required that you need some experience contributing to The Piston Project.  
The judgement of experience is made informally by the people sending the invitation.  

Membership might be removed without warning if suspicious activity is discovered.

If you are not added as collaborator, post a message [here](https://github.com/PistonDevelopers/piston/issues/70) "I want to contribute to Piston" and @bvssvni or @mitchmindtree will add you as a collaborator. When you are a collaborator you can assign issues to yourself. Just look around and see if there are unassigned issues. We label tasks according to the amount of thinking involved: "Easy", "Medium" or "Hard".

### How to donate money
<a name="donate_money"></a>

If you feel charitable, these fine people accept donations:

| nick name | first name | last name | Transfer Options | comment |
|---------------|---------------|---------------|-------------------|--------------|
| bvssvni | Sven | Nilsen | PayPal: post at cutoutpro.com | I work on the core engine of Piston, Dyon, Turbine, general graphics, various smaller libraries and help administering repos and the Rust gamedev subreddit |
| mitchmindtree | Mitchell | Nordine | PayPal: mitchell.nordine at gmail.com | I work primarily on user-interface [(see Conrod)](https://github.com/PistonDevelopers/conrod) and audio/dsp [(see rust-dsp)](https://github.com/PistonDevelopers/rust-dsp) while contributing to the other crates where I can. |
