/*!
 * Copyright (c) 2015-present, Okta, Inc. and/or its affiliates. All rights reserved.
 * The Okta software accompanied by this notice is provided pursuant to the Apache License, Version 2.0 (the "License.")
 *
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 *
 */
import { OktaAuth, Token, TokenVerifyParams, AccessToken, IDToken, JWTObject, UserClaims, OAuthResponse, TokenParams, TokenResponse, CustomUrls, ParseFromUrlOptions } from './types';
declare function revokeToken(sdk: OktaAuth, token: AccessToken): Promise<any>;
declare function decodeToken(token: string): JWTObject;
declare function verifyToken(sdk: OktaAuth, token: IDToken, validationParams: TokenVerifyParams): Promise<IDToken>;
declare function handleOAuthResponse(sdk: OktaAuth, tokenParams: TokenParams, res: OAuthResponse, urls: CustomUrls): Promise<TokenResponse>;
declare function getToken(sdk: OktaAuth, options: TokenParams): Promise<TokenResponse>;
declare function getWithoutPrompt(sdk: OktaAuth, options: TokenParams): Promise<TokenResponse>;
declare function getWithPopup(sdk: OktaAuth, options: TokenParams): Promise<TokenResponse>;
declare function prepareTokenParams(sdk: OktaAuth, options: TokenParams): Promise<TokenParams>;
declare function getWithRedirect(sdk: OktaAuth, options: TokenParams): Promise<void>;
declare function renewToken(sdk: OktaAuth, token: Token): Promise<Token>;
declare function parseFromUrl(sdk: any, options: string | ParseFromUrlOptions): Promise<TokenResponse>;
declare function getUserInfo(sdk: any, accessTokenObject: any, idTokenObject: any): Promise<UserClaims>;
export { revokeToken, getToken, getWithoutPrompt, getWithPopup, getWithRedirect, parseFromUrl, decodeToken, renewToken, getUserInfo, verifyToken, handleOAuthResponse, prepareTokenParams };
