import { OktaAuth, CustomUrls, TokenVerifyParams, UserClaims, WellKnownResponse } from './types';
declare function generateState(): string;
declare function generateNonce(): string;
declare function addListener(eventTarget: any, name: any, fn: any): void;
declare function removeListener(eventTarget: any, name: any, fn: any): void;
declare function loadFrame(src: any): HTMLIFrameElement;
declare function loadPopup(src: any, options: any): Window;
declare function getWellKnown(sdk: OktaAuth, issuer: string): Promise<WellKnownResponse>;
declare function getKey(sdk: OktaAuth, issuer: string, kid: string): Promise<string>;
declare function validateClaims(sdk: OktaAuth, claims: UserClaims, validationParams: TokenVerifyParams): void;
declare function getOAuthUrls(sdk: OktaAuth, options?: CustomUrls): {
    issuer: any;
    authorizeUrl: any;
    userinfoUrl: any;
    tokenUrl: any;
    revokeUrl: any;
    logoutUrl: any;
};
declare function urlParamsToObject(hashOrSearch: string): {};
/**
 * Check if tokens or a code have been passed back into the url, which happens in
 * the social auth IDP redirect flow.
 */
declare function isLoginRedirect(sdk: OktaAuth): boolean;
export { generateState, generateNonce, getWellKnown, getKey, validateClaims, getOAuthUrls, loadFrame, loadPopup, urlParamsToObject, isLoginRedirect, addListener, removeListener };
