import { Token, TokenManagerOptions } from './types';
export declare class TokenManager {
    get: (key: string) => Promise<Token>;
    add: (key: string, token: Token) => void;
    clear: () => void;
    remove: (key: string) => void;
    renew: (key: string) => Promise<Token>;
    on: (event: string, handler: Function, context?: object) => void;
    off: (event: string, handler: Function) => void;
    hasExpired: (token: Token) => boolean;
    constructor(sdk: any, options: TokenManagerOptions);
}
