import { AuthTransaction } from './tx';
import { OktaAuth, OktaAuthOptions, SigninOptions, ForgotPasswordOptions, VerifyRecoveryTokenOptions, TransactionAPI, SessionAPI, SigninAPI } from './types';
export default class OktaAuthBase implements OktaAuth, SigninAPI {
    options: OktaAuthOptions;
    tx: TransactionAPI;
    userAgent: string;
    session: SessionAPI;
    constructor(args: OktaAuthOptions);
    signIn(opts: SigninOptions): Promise<AuthTransaction>;
    getIssuerOrigin(): string;
    forgotPassword(opts: any): Promise<AuthTransaction>;
    unlockAccount(opts: ForgotPasswordOptions): Promise<AuthTransaction>;
    verifyRecoveryToken(opts: VerifyRecoveryTokenOptions): Promise<AuthTransaction>;
}
