"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.default = void 0;

var _OktaAuthBase = _interopRequireDefault(require("../OktaAuthBase"));

var features = _interopRequireWildcard(require("./features"));

var _fetchRequest = _interopRequireDefault(require("../fetch/fetchRequest"));

var _browserStorage = _interopRequireDefault(require("./browserStorage"));

var _util = require("../util");

var _builderUtil = require("../builderUtil");

var _constants = require("../constants");

var _session = require("../session");

var _token = require("../token");

var _TokenManager = require("../TokenManager");

var _oauthUtil = require("../oauthUtil");

var _http = _interopRequireDefault(require("../http"));

var _PromiseQueue = _interopRequireDefault(require("../PromiseQueue"));

var _fingerprint = _interopRequireDefault(require("./fingerprint"));

var _tx = require("../tx");

/*!
 * Copyright (c) 2015-present, Okta, Inc. and/or its affiliates. All rights reserved.
 * The Okta software accompanied by this notice is provided pursuant to the Apache License, Version 2.0 (the "License.")
 *
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 */

/* eslint-disable complexity */

/* eslint-disable max-statements */

/* SDK_VERSION is defined in webpack config */

/* global SDK_VERSION */
const Emitter = require('tiny-emitter');

class OktaAuthBrowser extends _OktaAuthBase.default {
  constructor(args) {
    args = Object.assign({
      httpRequestClient: _fetchRequest.default,
      storageUtil: _browserStorage.default
    }, args);
    super(args);
    var cookieSettings = Object.assign({
      secure: true
    }, args.cookies);
    var isLocalhost = this.features.isLocalhost() && !this.features.isHTTPS();

    if (isLocalhost) {
      cookieSettings.secure = false; // Force secure=false if running on http://localhost
    }

    if (typeof cookieSettings.sameSite === 'undefined') {
      // Chrome >= 80 will block cookies with SameSite=None unless they are also Secure
      cookieSettings.sameSite = cookieSettings.secure ? 'none' : 'lax';
    }

    if (cookieSettings.secure && !this.features.isHTTPS()) {
      // eslint-disable-next-line no-console
      console.warn('The current page is not being served with the HTTPS protocol.\n' + 'For security reasons, we strongly recommend using HTTPS.\n' + 'If you cannot use HTTPS, set "cookies.secure" option to false.');
      cookieSettings.secure = false;
    }

    this.options = Object.assign(this.options, {
      clientId: args.clientId,
      authorizeUrl: (0, _util.removeTrailingSlash)(args.authorizeUrl),
      userinfoUrl: (0, _util.removeTrailingSlash)(args.userinfoUrl),
      tokenUrl: (0, _util.removeTrailingSlash)(args.tokenUrl),
      revokeUrl: (0, _util.removeTrailingSlash)(args.revokeUrl),
      logoutUrl: (0, _util.removeTrailingSlash)(args.logoutUrl),
      pkce: args.pkce === false ? false : true,
      redirectUri: args.redirectUri,
      postLogoutRedirectUri: args.postLogoutRedirectUri,
      responseMode: args.responseMode,
      transformErrorXHR: args.transformErrorXHR,
      cookies: cookieSettings
    });
    this.userAgent = (0, _builderUtil.getUserAgent)(args, `okta-auth-js/${SDK_VERSION}`); // Digital clocks will drift over time, so the server
    // can misalign with the time reported by the browser.
    // The maxClockSkew allows relaxing the time-based
    // validation of tokens (in seconds, not milliseconds).
    // It currently defaults to 300, because 5 min is the
    // default maximum tolerance allowed by Kerberos.
    // (https://technet.microsoft.com/en-us/library/cc976357.aspx)

    if (!args.maxClockSkew && args.maxClockSkew !== 0) {
      this.options.maxClockSkew = _constants.DEFAULT_MAX_CLOCK_SKEW;
    } else {
      this.options.maxClockSkew = args.maxClockSkew;
    } // Give the developer the ability to disable token signature
    // validation.


    this.options.ignoreSignature = !!args.ignoreSignature;
    this.session = {
      close: _session.closeSession.bind(null, this),
      exists: _session.sessionExists.bind(null, this),
      get: _session.getSession.bind(null, this),
      refresh: _session.refreshSession.bind(null, this),
      setCookieAndRedirect: _session.setCookieAndRedirect.bind(null, this)
    };
    this._tokenQueue = new _PromiseQueue.default();
    this.token = {
      getWithoutPrompt: _token.getWithoutPrompt.bind(null, this),
      getWithPopup: _token.getWithPopup.bind(null, this),
      getWithRedirect: _token.getWithRedirect.bind(null, this),
      parseFromUrl: _token.parseFromUrl.bind(null, this),
      decode: _token.decodeToken,
      revoke: _token.revokeToken.bind(null, this),
      renew: _token.renewToken.bind(null, this),
      getUserInfo: _token.getUserInfo.bind(null, this),
      verify: _token.verifyToken.bind(null, this),
      isLoginRedirect: _oauthUtil.isLoginRedirect.bind(null, this)
    }; // Wrap all async token API methods using MethodQueue to avoid issues with concurrency

    const syncMethods = ['decode', 'isLoginRedirect'];
    Object.keys(this.token).forEach(key => {
      if (syncMethods.indexOf(key) >= 0) {
        // sync methods should not be wrapped
        return;
      }

      var method = this.token[key];
      this.token[key] = _PromiseQueue.default.prototype.push.bind(this._tokenQueue, method, null);
    });
    Object.assign(this.token.getWithRedirect, {
      // This is exposed so we can set window.location in our tests
      _setLocation: function (url) {
        window.location = url;
      }
    });
    Object.assign(this.token.parseFromUrl, {
      // This is exposed so we can mock getting window.history in our tests
      _getHistory: function () {
        return window.history;
      },
      // This is exposed so we can mock getting window.location in our tests
      _getLocation: function () {
        return window.location;
      },
      // This is exposed so we can mock getting window.document in our tests
      _getDocument: function () {
        return window.document;
      }
    }); // Fingerprint API

    this.fingerprint = _fingerprint.default.bind(null, this);
    this.emitter = new Emitter();
    this.tokenManager = new _TokenManager.TokenManager(this, args.tokenManager);
  }

  signIn(opts) {
    opts = (0, _util.clone)(opts || {});

    const _postToTransaction = options => {
      delete opts.sendFingerprint;
      return (0, _tx.postToTransaction)(this, '/api/v1/authn', opts, options);
    };

    if (!opts.sendFingerprint) {
      return _postToTransaction();
    }

    return this.fingerprint().then(function (fingerprint) {
      return _postToTransaction({
        headers: {
          'X-Device-Fingerprint': fingerprint
        }
      });
    });
  } // Ends the current Okta SSO session without redirecting to Okta.


  closeSession() {
    // Clear all local tokens
    this.tokenManager.clear();
    return this.session.close() // DELETE /api/v1/sessions/me
    .catch(function (e) {
      if (e.name === 'AuthApiError' && e.errorCode === 'E0000007') {
        // Session does not exist or has already been closed
        return;
      }

      throw e;
    });
  } // Revokes the access token for the application session


  async revokeAccessToken(accessToken) {
    if (!accessToken) {
      accessToken = await this.tokenManager.get(_constants.ACCESS_TOKEN_STORAGE_KEY);
      this.tokenManager.remove(_constants.ACCESS_TOKEN_STORAGE_KEY);
    } // Access token may have been removed. In this case, we will silently succeed.


    if (!accessToken) {
      return Promise.resolve();
    }

    return this.token.revoke(accessToken);
  } // Revokes accessToken, clears all local tokens, then redirects to Okta to end the SSO session.


  async signOut(options) {
    options = Object.assign({}, options); // postLogoutRedirectUri must be whitelisted in Okta Admin UI

    var defaultUri = window.location.origin;
    var currentUri = window.location.href;
    var postLogoutRedirectUri = options.postLogoutRedirectUri || this.options.postLogoutRedirectUri || defaultUri;
    var accessToken = options.accessToken;
    var revokeAccessToken = options.revokeAccessToken !== false;
    var idToken = options.idToken;
    var logoutUrl = (0, _oauthUtil.getOAuthUrls)(this).logoutUrl;

    if (typeof idToken === 'undefined') {
      idToken = await this.tokenManager.get(_constants.ID_TOKEN_STORAGE_KEY);
    }

    if (revokeAccessToken && typeof accessToken === 'undefined') {
      accessToken = await this.tokenManager.get(_constants.ACCESS_TOKEN_STORAGE_KEY);
    } // Clear all local tokens


    this.tokenManager.clear();

    if (revokeAccessToken && accessToken) {
      await this.revokeAccessToken(accessToken);
    } // No idToken? This can happen if the storage was cleared.
    // Fallback to XHR signOut, then simulate a redirect to the post logout uri


    if (!idToken) {
      return this.closeSession() // can throw if the user cannot be signed out
      .then(function () {
        if (postLogoutRedirectUri === currentUri) {
          window.location.reload(); // force a hard reload if URI is not changing
        } else {
          window.location.assign(postLogoutRedirectUri);
        }
      });
    } // logout redirect using the idToken.


    var state = options.state;
    var idTokenHint = idToken.idToken; // a string

    var logoutUri = logoutUrl + '?id_token_hint=' + encodeURIComponent(idTokenHint) + '&post_logout_redirect_uri=' + encodeURIComponent(postLogoutRedirectUri); // State allows option parameters to be passed to logout redirect uri

    if (state) {
      logoutUri += '&state=' + encodeURIComponent(state);
    }

    window.location.assign(logoutUri);
  }

  webfinger(opts) {
    var url = '/.well-known/webfinger' + (0, _util.toQueryParams)(opts);
    var options = {
      headers: {
        'Accept': 'application/jrd+json'
      }
    };
    return _http.default.get(this, url, options);
  }

} // Hoist feature detection functions to static type


OktaAuthBrowser.features = OktaAuthBrowser.prototype.features = features;
var _default = OktaAuthBrowser;
exports.default = _default;
module.exports = exports.default;