"use strict";

var _ = require('lodash/fp');

var formatBadge = require('./format-badge');

var formatContributor = require('./format-contributor');

function injectListBetweenTags(newContent) {
  return function (previousContent) {
    var tagToLookFor = `<!-- ALL-CONTRIBUTORS-LIST:`;
    var closingTag = '-->';
    var startOfOpeningTagIndex = previousContent.indexOf(`${tagToLookFor}START`);
    var endOfOpeningTagIndex = previousContent.indexOf(closingTag, startOfOpeningTagIndex);
    var startOfClosingTagIndex = previousContent.indexOf(`${tagToLookFor}END`, endOfOpeningTagIndex);

    if (startOfOpeningTagIndex === -1 || endOfOpeningTagIndex === -1 || startOfClosingTagIndex === -1) {
      return previousContent;
    }

    return [previousContent.slice(0, endOfOpeningTagIndex + closingTag.length), '\n<!-- prettier-ignore-start -->', '\n<!-- markdownlint-disable -->', newContent, '<!-- markdownlint-restore -->', '\n<!-- prettier-ignore-end -->', '\n\n', previousContent.slice(startOfClosingTagIndex)].join('');
  };
}

function formatLine(contributors) {
  return `<td align="center">${contributors.join('</td>\n    <td align="center">')}</td>`;
}

function generateContributorsList(options, contributors) {
  return _.flow(_.sortBy(function (contributor) {
    if (options.contributorsSortAlphabetically) {
      return contributor.name;
    }
  }), _.map(function (contributor) {
    return formatContributor(options, contributor);
  }), _.chunk(options.contributorsPerLine), _.map(formatLine), _.join('\n  </tr>\n  <tr>\n    '), function (newContent) {
    return `\n<table>\n  <tr>\n    ${newContent}\n  </tr>\n</table>\n\n`;
  })(contributors);
}

function replaceBadge(newContent) {
  return function (previousContent) {
    var tagToLookFor = `<!-- ALL-CONTRIBUTORS-BADGE:`;
    var closingTag = '-->';
    var startOfOpeningTagIndex = previousContent.indexOf(`${tagToLookFor}START`);
    var endOfOpeningTagIndex = previousContent.indexOf(closingTag, startOfOpeningTagIndex);
    var startOfClosingTagIndex = previousContent.indexOf(`${tagToLookFor}END`, endOfOpeningTagIndex);

    if (startOfOpeningTagIndex === -1 || endOfOpeningTagIndex === -1 || startOfClosingTagIndex === -1) {
      return previousContent;
    }

    return [previousContent.slice(0, endOfOpeningTagIndex + closingTag.length), '\n', newContent, '\n', previousContent.slice(startOfClosingTagIndex)].join('');
  };
}

module.exports = function (options, contributors, fileContent) {
  var contributorsList = contributors.length === 0 ? '\n' : generateContributorsList(options, contributors);
  var badge = formatBadge(options, contributors);
  return _.flow(injectListBetweenTags(contributorsList), replaceBadge(badge))(fileContent);
};