/*!
 * Copyright (c) 2015-present, Okta, Inc. and/or its affiliates. All rights reserved.
 * The Okta software accompanied by this notice is provided pursuant to the Apache License, Version 2.0 (the "License.")
 *
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 */
import OktaAuthBase from '../OktaAuthBase';
import { TokenManager } from '../TokenManager';
import PromiseQueue from '../PromiseQueue';
import { OktaAuth, OktaAuthOptions, AccessToken, TokenAPI, FeaturesAPI, SignoutAPI, FingerprintAPI } from '../types';
declare const Emitter: any;
declare class OktaAuthBrowser extends OktaAuthBase implements OktaAuth, SignoutAPI {
    static features: FeaturesAPI;
    features: FeaturesAPI;
    token: TokenAPI;
    _tokenQueue: PromiseQueue;
    emitter: typeof Emitter;
    tokenManager: TokenManager;
    fingerprint: FingerprintAPI;
    constructor(args: OktaAuthOptions);
    signIn(opts: any): Promise<import("../tx").AuthTransaction>;
    closeSession(): Promise<void | object>;
    revokeAccessToken(accessToken?: AccessToken): Promise<void | object>;
    signOut(options?: any): Promise<void>;
    webfinger(opts: any): Promise<any>;
}
export default OktaAuthBrowser;
