"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.default = void 0;

var _OktaAuthBase = _interopRequireDefault(require("../OktaAuthBase"));

var _fetchRequest = _interopRequireDefault(require("../fetch/fetchRequest"));

var _builderUtil = require("../builderUtil");

var _serverStorage = _interopRequireDefault(require("./serverStorage"));

/*!
 * Copyright (c) 2018-present, Okta, Inc. and/or its affiliates. All rights reserved.
 * The Okta software accompanied by this notice is provided pursuant to the Apache License, Version 2.0 (the "License.")
 *
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 */

/* eslint-disable complexity */

/* eslint-disable max-statements */
const PACKAGE_JSON = require('../../package.json');

const SDK_VERSION = PACKAGE_JSON.version;

class OktaAuthNode extends _OktaAuthBase.default {
  constructor(args) {
    args = Object.assign({
      httpRequestClient: _fetchRequest.default,
      storageUtil: _serverStorage.default
    }, args);
    super(args);
    this.userAgent = (0, _builderUtil.getUserAgent)(args, `okta-auth-js-server/${SDK_VERSION}`);
  }

}

exports.default = OktaAuthNode;
module.exports = exports.default;