"use strict";

exports.default = void 0;

var _builderUtil = require("./builderUtil");

var _util = require("./util");

var _tx = require("./tx");

/*!
 * Copyright (c) 2015-present, Okta, Inc. and/or its affiliates. All rights reserved.
 * The Okta software accompanied by this notice is provided pursuant to the Apache License, Version 2.0 (the "License.")
 *
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 */
class OktaAuthBase {
  constructor(args) {
    (0, _builderUtil.assertValidConfig)(args);
    this.options = {
      issuer: (0, _util.removeTrailingSlash)(args.issuer),
      httpRequestClient: args.httpRequestClient,
      storageUtil: args.storageUtil,
      headers: args.headers
    };
    this.tx = {
      status: _tx.transactionStatus.bind(null, this),
      resume: _tx.resumeTransaction.bind(null, this),
      exists: Object.assign(_tx.transactionExists.bind(null, this), {
        _get: name => {
          const storage = this.options.storageUtil.storage;
          return storage.get(name);
        }
      }),
      introspect: _tx.introspect.bind(null, this)
    };
  } // { username, password, (relayState), (context) }


  signIn(opts) {
    return (0, _tx.postToTransaction)(this, '/api/v1/authn', opts);
  }

  getIssuerOrigin() {
    // Infer the URL from the issuer URL, omitting the /oauth2/{authServerId}
    return this.options.issuer.split('/oauth2/')[0];
  } // { username, (relayState) }


  forgotPassword(opts) {
    return (0, _tx.postToTransaction)(this, '/api/v1/authn/recovery/password', opts);
  } // { username, (relayState) }


  unlockAccount(opts) {
    return (0, _tx.postToTransaction)(this, '/api/v1/authn/recovery/unlock', opts);
  } // { recoveryToken }


  verifyRecoveryToken(opts) {
    return (0, _tx.postToTransaction)(this, '/api/v1/authn/recovery/token', opts);
  }

}

exports.default = OktaAuthBase;
module.exports = exports.default;