
# Table of Contents

1.  [Introduction](#orgeed5881)
2.  [Installation](#orged8b90d)
3.  [Discussion](#org1fad3c6)



<a id="orgeed5881"></a>

# Introduction

[pin](https://github.com/sp1ff/pin) is a minimal Rust command-line client for [Pinboard](https://pinboard.in) (and [Instapaper](https://www.instapaper.com)). It is by no means complete; it supports a few operations which I have found useful. I might add more operations in the future. I have chosen the version number (0.1) in the hopes of conveying that this is a preliminary release.

Here are a few examples of what you can do with [pin](https://github.com/sp1ff/pin):

You can send a link to [Pinboard](https://pinboard.in) with tags `a`, `b` & `c`:

    $> pin send -t a -t b -t c "http://foo.com/bar | splat"

You can setup canned tag clouds you use repeatedly & refer to them by name:

    $> cat ~/.pin
    token = "you:XXX"
    
    [targets]
    
    [targets.frobnitz]
    tags = ["@review", "frobinate"]
    read_later = true
    ...
    # This link will get tags @review & frobinate, and have the "read later" flag set:
    $> pin send -r frobnitz "http://foo.com/bar | splat"

You can send the link to [Instapaper](https://www.instapaper.com) at the same time:

    $> pin send -r frobnitz --with-instapaper "http://foo.com/bar | splat"

I began using it for tag maintenance:

    $> pin get-tags 
    | Tag                            | Use Count |
    +--------------------------------+-----------+
    | flapdoodl                      |         1 |
    | flapdoodle                     |     10000 |
    ...
    # Hmmm... likely a mis-spelling
    $> pin rename-tag flapdoodl flapdoodle

Type `pin --help` for a description of all flags & sub-commands.


<a id="orged8b90d"></a>

# Installation

This crate is available on [crates.io](https://crates.io), but you can also download an Autotools tarball:

    cd /tmp
    curl -O https://www.unwoundstack.com/dist/pin-0.1.3.tar.xz
    tar xf pin-0.1.3.tar.xz
    cd pin-0.1.3
    ./configure
    make
    make check
    sudo make install


<a id="org1fad3c6"></a>

# Discussion

[pin](https://github.com/sp1ff/pin) is at this time so simple that I've covered most of what it can do in the examples above. I should note that it is also one of my first Rust projects. Comments, code reviews & complaints welcome at [sp1ff@pobox.com](mailto:sp1ff@pobo.com).

