#version 460

#include <prelude.glsl>

// In the beginning, colours never existed. There's nothing that can be done before you...

/*
   Big credits to the example made by demofox
   https://blog.demofox.org/2020/05/25/casual-shadertoy-path-tracing-1-basic-camera-diffuse-emissive/
*/

layout(location = 0) in vec2 in_uv;
layout(location = 0) out vec4 out_color;

layout(set = 0, binding = 0) uniform sampler2D previous_frame;
layout(set = 0, binding = 1) uniform sampler2D generic_texture;
layout(set = 0, binding = 2) uniform sampler2D dummy_texture;
layout(set = 0, binding = 3) uniform sampler2D float_texture1;
layout(set = 0, binding = 4) uniform sampler2D float_texture2;
#define T(t) (texture(t, vec2(in_uv.x, -in_uv.y)))
#define T_off(t, off) (texture(t, vec2(in_uv.x + off.x, -(in_uv.y + off.y))))

layout(set = 1, binding = 0) uniform sampler1D fft_texture;

layout(std430, push_constant) uniform PushConstant {
    vec3 pos;
    float time;
    vec2 resolution;
    vec2 mouse;
    bool mouse_pressed;
    uint frame;
    float time_delta;
} pc;

void main() {
    vec3 color = texture(float_texture1, in_uv).rgb;
    color *= EXPOSURE;
    color = ACESFilm(color);
    color = linear_to_srgb(color);
    out_color = vec4(color, 1.0);
}
