//
//
// piedb.rs
// Copyright (C) 2022 Author zombie <zombie@zombie-ub2104>
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

extern crate msql_srv;
use gluesql::prelude::*;
use msql_srv::*;
use piedb::tablet::mysql_api::MySQLApi;
use std::net::TcpListener;
use std::thread;

fn main() {
    let listener = TcpListener::bind("127.0.0.1:3306").unwrap();
    let port = listener.local_addr().unwrap().port();
    println!("start piedb listening on 127.0.0.1:3306");
    let jh = thread::spawn(move || {
        if let Ok((s, _)) = listener.accept() {
            let storage = SledStorage::new("/tmp/piedb").unwrap();

            MysqlIntermediary::run_on_tcp(MySQLApi::new(storage), s).unwrap();
        }
    });
    jh.join().unwrap();
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn it_works() {}
}
