# piedb
piedb is hat(timeseries)p and mysql compatible database

## Build

```
cargo build
```

## Run

```
./target/debug/piedb
start piedb listening on 127.0.0.1:3306
```

## Use Mysql Cli

```
mysql -u root -h 127.0.0.1 --port 3306
Welcome to the MySQL monitor.  Commands end with ; or \g.
Your MySQL connection id is 8
Server version: 5.1.10-alpha-msql-proxy

Copyright (c) 2000, 2022, Oracle and/or its affiliates.

Oracle is a registered trademark of Oracle Corporation and/or its
affiliates. Other names may be trademarks of their respective
owners.

Type 'help;' or '\h' for help. Type '\c' to clear the current input statement.

mysql> DROP TABLE IF EXISTS cpu_usage;
Query OK, 1 row affected (0.01 sec)

mysql> CREATE TABLE cpu_usage (ts TIMESTAMP, util INTEGER);
Query OK, 1 row affected (0.00 sec)

mysql> insert into cpu_usage values("2020-06-11 11:23:11Z", 80);
Query OK, 1 row affected (0.00 sec)

mysql> insert into cpu_usage values("2020-06-12 11:23:11Z", 70);
Query OK, 1 row affected (0.00 sec)

mysql> insert into cpu_usage values("2020-06-14 11:23:11Z", 40);
Query OK, 1 row affected (0.01 sec)

mysql> select max(util), ts from cpu_usage;
+-----------+---------------------+
| max(util) | ts                  |
+-----------+---------------------+
| 80        | 2020-06-11 11:23:11 |
+-----------+---------------------+
1 row in set (0.01 sec)

```

## Use PyMySQL

```
import pymysql.cursors
# Connect to the database
connection = pymysql.connect(host='127.0.0.1',
                             user='root',
                             database='',
                             port=3306,
                             cursorclass=pymysql.cursors.DictCursor)
with connection:
    with connection.cursor() as cursor:
        # Create a new record
        sql = "INSERT INTO cpu_usage VALUES ('2020-06-11 11:23:11Z', 80);"
        cursor.execute(sql)
    with connection.cursor() as cursor:
        # Read a single record
        sql = "SELECT * FROM cpu_usage;"
        cursor.execute(sql)
        result = cursor.fetchall()
        print(result)
```

output

```
[{'ts': datetime.datetime(2020, 6, 11, 11, 23, 11)]
```
