#[derive(Clone, Copy, Debug, serde::Deserialize)]
pub(crate) enum Extension {
    #[serde(rename = "jpg")]
    Jpg,

    #[serde(rename = "webp")]
    Webp,
}

impl std::fmt::Display for Extension {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        match self {
            Self::Jpg => write!(f, "jpg"),
            Self::Webp => write!(f, "webp"),
        }
    }
}

#[derive(serde::Deserialize)]
pub(crate) struct Image {
    file: String,
    delete_token: String,
}

impl Image {
    pub(crate) fn file(&self) -> &str {
        &self.file
    }

    pub(crate) fn delete_token(&self) -> &str {
        &self.delete_token
    }
}

#[derive(serde::Deserialize)]
pub(crate) struct Images {
    msg: String,
    files: Option<Vec<Image>>,
}

impl Images {
    pub(crate) fn is_err(&self) -> bool {
        self.files.is_none()
    }

    pub(crate) fn message(&self) -> &str {
        &self.msg
    }

    pub(crate) fn files(&self) -> impl Iterator<Item = &Image> {
        self.files.iter().flat_map(|v| v.iter())
    }
}
