pub const PICO_DRIVER_VERSION: u32 = 0;
pub const PICO_USB_VERSION: u32 = 1;
pub const PICO_HARDWARE_VERSION: u32 = 2;
pub const PICO_VARIANT_INFO: u32 = 3;
pub const PICO_BATCH_AND_SERIAL: u32 = 4;
pub const PICO_CAL_DATE: u32 = 5;
pub const PICO_KERNEL_VERSION: u32 = 6;
pub const PICO_DIGITAL_HARDWARE_VERSION: u32 = 7;
pub const PICO_ANALOGUE_HARDWARE_VERSION: u32 = 8;
pub const PICO_FIRMWARE_VERSION_1: u32 = 9;
pub const PICO_FIRMWARE_VERSION_2: u32 = 10;
pub const PICO_MAC_ADDRESS: u32 = 11;
pub const PICO_SHADOW_CAL: u32 = 12;
pub const PICO_IPP_VERSION: u32 = 13;
pub const PICO_DRIVER_PATH: u32 = 14;
pub const PICO_FIRMWARE_VERSION_3: u32 = 15;
pub const PICO_FRONT_PANEL_FIRMWARE_VERSION: u32 = 16;
pub const PICO_OK: u32 = 0;
pub const PICO_MAX_UNITS_OPENED: u32 = 1;
pub const PICO_MEMORY_FAIL: u32 = 2;
pub const PICO_NOT_FOUND: u32 = 3;
pub const PICO_FW_FAIL: u32 = 4;
pub const PICO_OPEN_OPERATION_IN_PROGRESS: u32 = 5;
pub const PICO_OPERATION_FAILED: u32 = 6;
pub const PICO_NOT_RESPONDING: u32 = 7;
pub const PICO_CONFIG_FAIL: u32 = 8;
pub const PICO_KERNEL_DRIVER_TOO_OLD: u32 = 9;
pub const PICO_EEPROM_CORRUPT: u32 = 10;
pub const PICO_OS_NOT_SUPPORTED: u32 = 11;
pub const PICO_INVALID_HANDLE: u32 = 12;
pub const PICO_INVALID_PARAMETER: u32 = 13;
pub const PICO_INVALID_TIMEBASE: u32 = 14;
pub const PICO_INVALID_VOLTAGE_RANGE: u32 = 15;
pub const PICO_INVALID_CHANNEL: u32 = 16;
pub const PICO_INVALID_TRIGGER_CHANNEL: u32 = 17;
pub const PICO_INVALID_CONDITION_CHANNEL: u32 = 18;
pub const PICO_NO_SIGNAL_GENERATOR: u32 = 19;
pub const PICO_STREAMING_FAILED: u32 = 20;
pub const PICO_BLOCK_MODE_FAILED: u32 = 21;
pub const PICO_NULL_PARAMETER: u32 = 22;
pub const PICO_ETS_MODE_SET: u32 = 23;
pub const PICO_DATA_NOT_AVAILABLE: u32 = 24;
pub const PICO_STRING_BUFFER_TO_SMALL: u32 = 25;
pub const PICO_ETS_NOT_SUPPORTED: u32 = 26;
pub const PICO_AUTO_TRIGGER_TIME_TO_SHORT: u32 = 27;
pub const PICO_BUFFER_STALL: u32 = 28;
pub const PICO_TOO_MANY_SAMPLES: u32 = 29;
pub const PICO_TOO_MANY_SEGMENTS: u32 = 30;
pub const PICO_PULSE_WIDTH_QUALIFIER: u32 = 31;
pub const PICO_DELAY: u32 = 32;
pub const PICO_SOURCE_DETAILS: u32 = 33;
pub const PICO_CONDITIONS: u32 = 34;
pub const PICO_USER_CALLBACK: u32 = 35;
pub const PICO_DEVICE_SAMPLING: u32 = 36;
pub const PICO_NO_SAMPLES_AVAILABLE: u32 = 37;
pub const PICO_SEGMENT_OUT_OF_RANGE: u32 = 38;
pub const PICO_BUSY: u32 = 39;
pub const PICO_STARTINDEX_INVALID: u32 = 40;
pub const PICO_INVALID_INFO: u32 = 41;
pub const PICO_INFO_UNAVAILABLE: u32 = 42;
pub const PICO_INVALID_SAMPLE_INTERVAL: u32 = 43;
pub const PICO_TRIGGER_ERROR: u32 = 44;
pub const PICO_MEMORY: u32 = 45;
pub const PICO_SIG_GEN_PARAM: u32 = 46;
pub const PICO_SHOTS_SWEEPS_WARNING: u32 = 47;
pub const PICO_SIGGEN_TRIGGER_SOURCE: u32 = 48;
pub const PICO_AUX_OUTPUT_CONFLICT: u32 = 49;
pub const PICO_AUX_OUTPUT_ETS_CONFLICT: u32 = 50;
pub const PICO_WARNING_EXT_THRESHOLD_CONFLICT: u32 = 51;
pub const PICO_WARNING_AUX_OUTPUT_CONFLICT: u32 = 52;
pub const PICO_SIGGEN_OUTPUT_OVER_VOLTAGE: u32 = 53;
pub const PICO_DELAY_NULL: u32 = 54;
pub const PICO_INVALID_BUFFER: u32 = 55;
pub const PICO_SIGGEN_OFFSET_VOLTAGE: u32 = 56;
pub const PICO_SIGGEN_PK_TO_PK: u32 = 57;
pub const PICO_CANCELLED: u32 = 58;
pub const PICO_SEGMENT_NOT_USED: u32 = 59;
pub const PICO_INVALID_CALL: u32 = 60;
pub const PICO_GET_VALUES_INTERRUPTED: u32 = 61;
pub const PICO_NOT_USED: u32 = 63;
pub const PICO_INVALID_SAMPLERATIO: u32 = 64;
pub const PICO_INVALID_STATE: u32 = 65;
pub const PICO_NOT_ENOUGH_SEGMENTS: u32 = 66;
pub const PICO_DRIVER_FUNCTION: u32 = 67;
pub const PICO_RESERVED: u32 = 68;
pub const PICO_INVALID_COUPLING: u32 = 69;
pub const PICO_BUFFERS_NOT_SET: u32 = 70;
pub const PICO_RATIO_MODE_NOT_SUPPORTED: u32 = 71;
pub const PICO_RAPID_NOT_SUPPORT_AGGREGATION: u32 = 72;
pub const PICO_INVALID_TRIGGER_PROPERTY: u32 = 73;
pub const PICO_INTERFACE_NOT_CONNECTED: u32 = 74;
pub const PICO_RESISTANCE_AND_PROBE_NOT_ALLOWED: u32 = 75;
pub const PICO_POWER_FAILED: u32 = 76;
pub const PICO_SIGGEN_WAVEFORM_SETUP_FAILED: u32 = 77;
pub const PICO_FPGA_FAIL: u32 = 78;
pub const PICO_POWER_MANAGER: u32 = 79;
pub const PICO_INVALID_ANALOGUE_OFFSET: u32 = 80;
pub const PICO_PLL_LOCK_FAILED: u32 = 81;
pub const PICO_ANALOG_BOARD: u32 = 82;
pub const PICO_CONFIG_FAIL_AWG: u32 = 83;
pub const PICO_INITIALISE_FPGA: u32 = 84;
pub const PICO_EXTERNAL_FREQUENCY_INVALID: u32 = 86;
pub const PICO_CLOCK_CHANGE_ERROR: u32 = 87;
pub const PICO_TRIGGER_AND_EXTERNAL_CLOCK_CLASH: u32 = 88;
pub const PICO_PWQ_AND_EXTERNAL_CLOCK_CLASH: u32 = 89;
pub const PICO_UNABLE_TO_OPEN_SCALING_FILE: u32 = 90;
pub const PICO_MEMORY_CLOCK_FREQUENCY: u32 = 91;
pub const PICO_I2C_NOT_RESPONDING: u32 = 92;
pub const PICO_NO_CAPTURES_AVAILABLE: u32 = 93;
pub const PICO_TOO_MANY_TRIGGER_CHANNELS_IN_USE: u32 = 95;
pub const PICO_INVALID_TRIGGER_DIRECTION: u32 = 96;
pub const PICO_INVALID_TRIGGER_STATES: u32 = 97;
pub const PICO_NOT_USED_IN_THIS_CAPTURE_MODE: u32 = 94;
pub const PICO_GET_DATA_ACTIVE: u32 = 259;
pub const PICO_IP_NETWORKED: u32 = 260;
pub const PICO_INVALID_IP_ADDRESS: u32 = 261;
pub const PICO_IPSOCKET_FAILED: u32 = 262;
pub const PICO_IPSOCKET_TIMEDOUT: u32 = 263;
pub const PICO_SETTINGS_FAILED: u32 = 264;
pub const PICO_NETWORK_FAILED: u32 = 265;
pub const PICO_WS2_32_DLL_NOT_LOADED: u32 = 266;
pub const PICO_INVALID_IP_PORT: u32 = 267;
pub const PICO_COUPLING_NOT_SUPPORTED: u32 = 268;
pub const PICO_BANDWIDTH_NOT_SUPPORTED: u32 = 269;
pub const PICO_INVALID_BANDWIDTH: u32 = 270;
pub const PICO_AWG_NOT_SUPPORTED: u32 = 271;
pub const PICO_ETS_NOT_RUNNING: u32 = 272;
pub const PICO_SIG_GEN_WHITENOISE_NOT_SUPPORTED: u32 = 273;
pub const PICO_SIG_GEN_WAVETYPE_NOT_SUPPORTED: u32 = 274;
pub const PICO_INVALID_DIGITAL_PORT: u32 = 275;
pub const PICO_INVALID_DIGITAL_CHANNEL: u32 = 276;
pub const PICO_INVALID_DIGITAL_TRIGGER_DIRECTION: u32 = 277;
pub const PICO_SIG_GEN_PRBS_NOT_SUPPORTED: u32 = 278;
pub const PICO_ETS_NOT_AVAILABLE_WITH_LOGIC_CHANNELS: u32 = 279;
pub const PICO_WARNING_REPEAT_VALUE: u32 = 280;
pub const PICO_POWER_SUPPLY_CONNECTED: u32 = 281;
pub const PICO_POWER_SUPPLY_NOT_CONNECTED: u32 = 282;
pub const PICO_POWER_SUPPLY_REQUEST_INVALID: u32 = 283;
pub const PICO_POWER_SUPPLY_UNDERVOLTAGE: u32 = 284;
pub const PICO_CAPTURING_DATA: u32 = 285;
pub const PICO_USB3_0_DEVICE_NON_USB3_0_PORT: u32 = 286;
pub const PICO_NOT_SUPPORTED_BY_THIS_DEVICE: u32 = 287;
pub const PICO_INVALID_DEVICE_RESOLUTION: u32 = 288;
pub const PICO_INVALID_NUMBER_CHANNELS_FOR_RESOLUTION: u32 = 289;
pub const PICO_CHANNEL_DISABLED_DUE_TO_USB_POWERED: u32 = 290;
pub const PICO_SIGGEN_DC_VOLTAGE_NOT_CONFIGURABLE: u32 = 291;
pub const PICO_NO_TRIGGER_ENABLED_FOR_TRIGGER_IN_PRE_TRIG: u32 = 292;
pub const PICO_TRIGGER_WITHIN_PRE_TRIG_NOT_ARMED: u32 = 293;
pub const PICO_TRIGGER_WITHIN_PRE_NOT_ALLOWED_WITH_DELAY: u32 = 294;
pub const PICO_TRIGGER_INDEX_UNAVAILABLE: u32 = 295;
pub const PICO_AWG_CLOCK_FREQUENCY: u32 = 296;
pub const PICO_TOO_MANY_CHANNELS_IN_USE: u32 = 297;
pub const PICO_NULL_CONDITIONS: u32 = 298;
pub const PICO_DUPLICATE_CONDITION_SOURCE: u32 = 299;
pub const PICO_INVALID_CONDITION_INFO: u32 = 300;
pub const PICO_SETTINGS_READ_FAILED: u32 = 301;
pub const PICO_SETTINGS_WRITE_FAILED: u32 = 302;
pub const PICO_ARGUMENT_OUT_OF_RANGE: u32 = 303;
pub const PICO_HARDWARE_VERSION_NOT_SUPPORTED: u32 = 304;
pub const PICO_DIGITAL_HARDWARE_VERSION_NOT_SUPPORTED: u32 = 305;
pub const PICO_ANALOGUE_HARDWARE_VERSION_NOT_SUPPORTED: u32 = 306;
pub const PICO_UNABLE_TO_CONVERT_TO_RESISTANCE: u32 = 307;
pub const PICO_DUPLICATED_CHANNEL: u32 = 308;
pub const PICO_INVALID_RESISTANCE_CONVERSION: u32 = 309;
pub const PICO_INVALID_VALUE_IN_MAX_BUFFER: u32 = 310;
pub const PICO_INVALID_VALUE_IN_MIN_BUFFER: u32 = 311;
pub const PICO_SIGGEN_FREQUENCY_OUT_OF_RANGE: u32 = 312;
pub const PICO_EEPROM2_CORRUPT: u32 = 313;
pub const PICO_EEPROM2_FAIL: u32 = 314;
pub const PICO_SERIAL_BUFFER_TOO_SMALL: u32 = 315;
pub const PICO_SIGGEN_TRIGGER_AND_EXTERNAL_CLOCK_CLASH: u32 = 316;
pub const PICO_WARNING_SIGGEN_AUXIO_TRIGGER_DISABLED: u32 = 317;
pub const PICO_SIGGEN_GATING_AUXIO_NOT_AVAILABLE: u32 = 318;
pub const PICO_SIGGEN_GATING_AUXIO_ENABLED: u32 = 319;
pub const PICO_RESOURCE_ERROR: u32 = 320;
pub const PICO_TEMPERATURE_TYPE_INVALID: u32 = 321;
pub const PICO_TEMPERATURE_TYPE_NOT_SUPPORTED: u32 = 322;
pub const PICO_TIMEOUT: u32 = 323;
pub const PICO_DEVICE_NOT_FUNCTIONING: u32 = 324;
pub const PICO_INTERNAL_ERROR: u32 = 325;
pub const PICO_MULTIPLE_DEVICES_FOUND: u32 = 326;
pub const PICO_WARNING_NUMBER_OF_SEGMENTS_REDUCED: u32 = 327;
pub const PICO_CAL_PINS_STATES: u32 = 328;
pub const PICO_CAL_PINS_FREQUENCY: u32 = 329;
pub const PICO_CAL_PINS_AMPLITUDE: u32 = 330;
pub const PICO_CAL_PINS_WAVETYPE: u32 = 331;
pub const PICO_CAL_PINS_OFFSET: u32 = 332;
pub const PICO_PROBE_FAULT: u32 = 333;
pub const PICO_PROBE_IDENTITY_UNKNOWN: u32 = 334;
pub const PICO_PROBE_POWER_DC_POWER_SUPPLY_REQUIRED: u32 = 335;
pub const PICO_PROBE_NOT_POWERED_WITH_DC_POWER_SUPPLY: u32 = 336;
pub const PICO_PROBE_CONFIG_FAILURE: u32 = 337;
pub const PICO_PROBE_INTERACTION_CALLBACK: u32 = 338;
pub const PICO_UNKNOWN_INTELLIGENT_PROBE: u32 = 339;
pub const PICO_INTELLIGENT_PROBE_CORRUPT: u32 = 340;
pub const PICO_PROBE_COLLECTION_NOT_STARTED: u32 = 341;
pub const PICO_PROBE_POWER_CONSUMPTION_EXCEEDED: u32 = 342;
pub const PICO_WARNING_PROBE_CHANNEL_OUT_OF_SYNC: u32 = 343;
pub const PICO_ENDPOINT_MISSING: u32 = 344;
pub const PICO_UNKNOWN_ENDPOINT_REQUEST: u32 = 345;
pub const PICO_ADC_TYPE_ERROR: u32 = 346;
pub const PICO_FPGA2_FAILED: u32 = 347;
pub const PICO_FPGA2_DEVICE_STATUS: u32 = 348;
pub const PICO_ENABLE_PROGRAM_FPGA2_FAILED: u32 = 349;
pub const PICO_NO_CHANNELS_OR_PORTS_ENABLED: u32 = 350;
pub const PICO_INVALID_RATIO_MODE: u32 = 351;
pub const PICO_READS_NOT_SUPPORTED_IN_CURRENT_CAPTURE_MODE: u32 = 352;
pub const PICO_TRIGGER_READ_SELECTION_CHECK_FAILED: u32 = 353;
pub const PICO_DATA_READ1_SELECTION_CHECK_FAILED: u32 = 354;
pub const PICO_DATA_READ2_SELECTION_CHECK_FAILED: u32 = 356;
pub const PICO_DATA_READ3_SELECTION_CHECK_FAILED: u32 = 360;
pub const PICO_READ_SELECTION_OUT_OF_RANGE: u32 = 368;
pub const PICO_MULTIPLE_RATIO_MODES: u32 = 369;
pub const PICO_NO_SAMPLES_READ: u32 = 370;
pub const PICO_RATIO_MODE_NOT_REQUESTED: u32 = 371;
pub const PICO_NO_USER_READ_REQUESTS_SET: u32 = 372;
pub const PICO_ZERO_SAMPLES_INVALID: u32 = 373;
pub const PICO_ANALOGUE_HARDWARE_MISSING: u32 = 374;
pub const PICO_ANALOGUE_HARDWARE_PINS: u32 = 375;
pub const PICO_ANALOGUE_HARDWARE_SMPS_FAULT: u32 = 376;
pub const PICO_DIGITAL_ANALOGUE_HARDWARE_CONFLICT: u32 = 377;
pub const PICO_RATIO_MODE_BUFFER_NOT_SET: u32 = 378;
pub const PICO_RESOLUTION_NOT_SUPPORTED_BY_VARIANT: u32 = 379;
pub const PICO_THRESHOLD_OUT_OF_RANGE: u32 = 380;
pub const PICO_INVALID_SIMPLE_TRIGGER_DIRECTION: u32 = 381;
pub const PICO_AUX_NOT_SUPPORTED: u32 = 382;
pub const PICO_NULL_DIRECTIONS: u32 = 383;
pub const PICO_NULL_CHANNEL_PROPERTIES: u32 = 384;
pub const PICO_TRIGGER_CHANNEL_NOT_ENABLED: u32 = 385;
pub const PICO_CONDITION_HAS_NO_TRIGGER_PROPERTY: u32 = 386;
pub const PICO_RATIO_MODE_TRIGGER_MASKING_INVALID: u32 = 387;
pub const PICO_TRIGGER_DATA_REQUIRES_MIN_BUFFER_SIZE_OF_40_SAMPLES: u32 = 388;
pub const PICO_NO_OF_CAPTURES_OUT_OF_RANGE: u32 = 389;
pub const PICO_RATIO_MODE_SEGMENT_HEADER_DOES_NOT_REQUIRE_BUFFERS: u32 = 390;
pub const PICO_FOR_SEGMENT_HEADER_USE_GETTRIGGERINFO: u32 = 391;
pub const PICO_READ_NOT_SET: u32 = 392;
pub const PICO_ADC_SETTING_MISMATCH: u32 = 393;
pub const PICO_DATATYPE_INVALID: u32 = 394;
pub const PICO_RATIO_MODE_DOES_NOT_SUPPORT_DATATYPE: u32 = 395;
pub const PICO_CHANNEL_COMBINATION_NOT_VALID_IN_THIS_RESOLUTION: u32 = 396;
pub const PICO_USE_8BIT_RESOLUTION: u32 = 397;
pub const PICO_AGGREGATE_BUFFERS_SAME_POINTER: u32 = 398;
pub const PICO_OVERLAPPED_READ_VALUES_OUT_OF_RANGE: u32 = 399;
pub const PICO_OVERLAPPED_READ_SEGMENTS_OUT_OF_RANGE: u32 = 400;
pub const PICO_CHANNELFLAGSCOMBINATIONS_ARRAY_SIZE_TOO_SMALL: u32 = 401;
pub const PICO_CAPTURES_EXCEEDS_NO_OF_SUPPORTED_SEGMENTS: u32 = 402;
pub const PICO_TIME_UNITS_OUT_OF_RANGE: u32 = 403;
pub const PICO_NO_SAMPLES_REQUESTED: u32 = 404;
pub const PICO_INVALID_ACTION: u32 = 405;
pub const PICO_NO_OF_SAMPLES_NEED_TO_BE_EQUAL_WHEN_ADDING_BUFFERS: u32 = 406;
pub const PICO_WAITING_FOR_DATA_BUFFERS: u32 = 407;
pub const PICO_STREAMING_ONLY_SUPPORTS_ONE_READ: u32 = 408;
pub const PICO_CLEAR_DATA_BUFFER_INVALID: u32 = 409;
pub const PICO_INVALID_ACTION_FLAGS_COMBINATION: u32 = 410;
pub const PICO_BOTH_MIN_AND_MAX_NULL_BUFFERS_CANNOT_BE_ADDED: u32 = 411;
pub const PICO_CONFLICT_IN_SET_DATA_BUFFERS_CALL_REMOVE_DATA_BUFFER_TO_RESET: u32 = 412;
pub const PICO_REMOVING_DATA_BUFFER_ENTRIES_NOT_ALLOWED_WHILE_DATA_PROCESSING: u32 = 413;
pub const PICO_CYUSB_REQUEST_FAILED: u32 = 512;
pub const PICO_STREAMING_DATA_REQUIRED: u32 = 513;
pub const PICO_INVALID_NUMBER_OF_SAMPLES: u32 = 514;
pub const PICO_INVALID_DISTRIBUTION: u32 = 515;
pub const PICO_BUFFER_LENGTH_GREATER_THAN_INT32_T: u32 = 516;
pub const PICO_PLL_MUX_OUT_FAILED: u32 = 521;
pub const PICO_ONE_PULSE_WIDTH_DIRECTION_ALLOWED: u32 = 522;
pub const PICO_EXTERNAL_TRIGGER_NOT_SUPPORTED: u32 = 523;
pub const PICO_NO_TRIGGER_CONDITIONS_SET: u32 = 524;
pub const PICO_NO_OF_CHANNEL_TRIGGER_PROPERTIES_OUT_OF_RANGE: u32 = 525;
pub const PICO_PROBE_COMPONENT_ERROR: u32 = 526;
pub const PICO_INVALID_TRIGGER_CHANNEL_FOR_ETS: u32 = 528;
pub const PICO_NOT_AVAILABLE_WHEN_STREAMING_IS_RUNNING: u32 = 529;
pub const PICO_INVALID_TRIGGER_WITHIN_PRE_TRIGGER_STATE: u32 = 530;
pub const PICO_ZERO_NUMBER_OF_CAPTURES_INVALID: u32 = 531;
pub const PICO_TRIGGER_DELAY_OUT_OF_RANGE: u32 = 768;
pub const PICO_INVALID_THRESHOLD_DIRECTION: u32 = 769;
pub const PICO_INVALID_THRESHOLD_MODE: u32 = 770;
pub const PICO_INVALID_VARIANT: u32 = 4096;
pub const PICO_MEMORY_MODULE_ERROR: u32 = 4097;
pub const PICO_PULSE_WIDTH_QUALIFIER_LOWER_UPPER_CONFILCT: u32 = 8192;
pub const PICO_PULSE_WIDTH_QUALIFIER_TYPE: u32 = 8193;
pub const PICO_PULSE_WIDTH_QUALIFIER_DIRECTION: u32 = 8194;
pub const PICO_THRESHOLD_MODE_OUT_OF_RANGE: u32 = 8195;
pub const PICO_TRIGGER_AND_PULSEWIDTH_DIRECTION_IN_CONFLICT: u32 = 8196;
pub const PICO_THRESHOLD_UPPER_LOWER_MISMATCH: u32 = 8197;
pub const PICO_PULSE_WIDTH_LOWER_OUT_OF_RANGE: u32 = 8198;
pub const PICO_PULSE_WIDTH_UPPER_OUT_OF_RANGE: u32 = 8199;
pub const PICO_FRONT_PANEL_ERROR: u32 = 8200;
pub const PICO_FRONT_PANEL_MODE: u32 = 8203;
pub const PICO_FRONT_PANEL_FEATURE: u32 = 8204;
pub const PICO_NO_PULSE_WIDTH_CONDITIONS_SET: u32 = 8205;
pub const PICO_TRIGGER_PORT_NOT_ENABLED: u32 = 8206;
pub const PICO_DIGITAL_DIRECTION_NOT_SET: u32 = 8207;
pub const PICO_I2C_DEVICE_INVALID_READ_COMMAND: u32 = 8208;
pub const PICO_I2C_DEVICE_INVALID_RESPONSE: u32 = 8209;
pub const PICO_I2C_DEVICE_INVALID_WRITE_COMMAND: u32 = 8210;
pub const PICO_I2C_DEVICE_ARGUMENT_OUT_OF_RANGE: u32 = 8211;
pub const PICO_I2C_DEVICE_MODE: u32 = 8212;
pub const PICO_I2C_DEVICE_SETUP_FAILED: u32 = 8213;
pub const PICO_I2C_DEVICE_FEATURE: u32 = 8214;
pub const PICO_I2C_DEVICE_VALIDATION_FAILED: u32 = 8215;
pub const PICO_INTERNAL_HEADER_ERROR: u32 = 8216;
pub const PICO_FAILED_TO_WRITE_HARDWARE_FAULT: u32 = 8217;
pub const PICO_MSO_TOO_MANY_EDGE_TRANSITIONS_WHEN_USING_PULSE_WIDTH: u32 = 12288;
pub const PICO_INVALID_PROBE_LED_POSITION: u32 = 12289;
pub const PICO_PROBE_LED_POSITION_NOT_SUPPORTED: u32 = 12290;
pub const PICO_DUPLICATE_PROBE_CHANNEL_LED_POSITION: u32 = 12291;
pub const PICO_PROBE_LED_FAILURE: u32 = 12292;
pub const PICO_PROBE_NOT_SUPPORTED_BY_THIS_DEVICE: u32 = 12293;
pub const PICO_INVALID_PROBE_NAME: u32 = 12294;
pub const PICO_NO_PROBE_COLOUR_SETTINGS: u32 = 12295;
pub const PICO_NO_PROBE_CONNECTED_ON_REQUESTED_CHANNEL: u32 = 12296;
pub const PICO_PROBE_DOES_NOT_REQUIRE_CALIBRATION: u32 = 12297;
pub const PICO_PROBE_CALIBRATION_FAILED: u32 = 12298;
pub const PICO_PROBE_VERSION_ERROR: u32 = 12299;
pub const PICO_AUTO_TRIGGER_TIME_TOO_LONG: u32 = 16384;
pub const PICO_MSO_POD_VALIDATION_FAILED: u32 = 20480;
pub const PICO_NO_MSO_POD_CONNECTED: u32 = 20481;
pub const PICO_DIGITAL_PORT_HYSTERESIS_OUT_OF_RANGE: u32 = 20482;
pub const PICO_MSO_POD_FAILED_UNIT: u32 = 20483;
pub const PICO_ATTENUATION_FAILED: u32 = 20484;
pub const PICO_DC_50OHM_OVERVOLTAGE_TRIPPED: u32 = 20485;
pub const PICO_NOT_RESPONDING_OVERHEATED: u32 = 20496;
pub const PICO_HARDWARE_CAPTURE_TIMEOUT: u32 = 24576;
pub const PICO_HARDWARE_READY_TIMEOUT: u32 = 24577;
pub const PICO_HARDWARE_CAPTURING_CALL_STOP: u32 = 24578;
pub const PICO_TOO_FEW_REQUESTED_STREAMING_SAMPLES: u32 = 28672;
pub const PICO_STREAMING_REREAD_DATA_NOT_AVAILABLE: u32 = 28673;
pub const PICO_STREAMING_COMBINATION_OF_RAW_DATA_AND_ONE_AGGREGATION_DATA_TYPE_ALLOWED: u32 = 28674;
pub const PICO_DEVICE_TIME_STAMP_RESET: u32 = 16777216;
pub const PICO_TRIGGER_TIME_NOT_REQUESTED: u32 = 33554433;
pub const PICO_TRIGGER_TIME_BUFFER_NOT_SET: u32 = 33554434;
pub const PICO_TRIGGER_TIME_FAILED_TO_CALCULATE: u32 = 33554436;
pub const PICO_TRIGGER_WITHIN_A_PRE_TRIGGER_FAILED_TO_CALCULATE: u32 = 33554440;
pub const PICO_TRIGGER_TIME_STAMP_NOT_REQUESTED: u32 = 33554688;
pub const PICO_RATIO_MODE_TRIGGER_DATA_FOR_TIME_CALCULATION_DOES_NOT_REQUIRE_BUFFERS: u32 =
    35651584;
pub const PICO_RATIO_MODE_TRIGGER_DATA_FOR_TIME_CALCULATION_DOES_NOT_HAVE_BUFFERS: u32 = 35651585;
pub const PICO_RATIO_MODE_TRIGGER_DATA_FOR_TIME_CALCULATION_USE_GETTRIGGERINFO: u32 = 35651586;
pub const PICO_RATIO_MODE_REQUIRES_NUMBER_OF_SAMPLES_TO_BE_SET: u32 = 35651586;
pub const PICO_STREAMING_DOES_NOT_SUPPORT_TRIGGER_RATIO_MODES: u32 = 35651587;
pub const PICO_USE_THE_TRIGGER_READ: u32 = 35651588;
pub const PICO_USE_A_DATA_READ: u32 = 35651589;
pub const PICO_TRIGGER_READ_REQUIRES_INT16_T_DATA_TYPE: u32 = 35651590;
pub const PICO_SIGGEN_SETTINGS_MISMATCH: u32 = 50331664;
pub const PICO_SIGGEN_SETTINGS_CHANGED_CALL_APPLY: u32 = 50331665;
pub const PICO_SIGGEN_WAVETYPE_NOT_SUPPORTED: u32 = 50331666;
pub const PICO_SIGGEN_TRIGGERTYPE_NOT_SUPPORTED: u32 = 50331667;
pub const PICO_SIGGEN_TRIGGERSOURCE_NOT_SUPPORTED: u32 = 50331668;
pub const PICO_SIGGEN_FILTER_STATE_NOT_SUPPORTED: u32 = 50331669;
pub const PICO_SIGGEN_NULL_PARAMETER: u32 = 50331680;
pub const PICO_SIGGEN_EMPTY_BUFFER_SUPPLIED: u32 = 50331681;
pub const PICO_SIGGEN_RANGE_NOT_SUPPLIED: u32 = 50331682;
pub const PICO_SIGGEN_BUFFER_NOT_SUPPLIED: u32 = 50331683;
pub const PICO_SIGGEN_FREQUENCY_NOT_SUPPLIED: u32 = 50331684;
pub const PICO_SIGGEN_SWEEP_INFO_NOT_SUPPLIED: u32 = 50331685;
pub const PICO_SIGGEN_TRIGGER_INFO_NOT_SUPPLIED: u32 = 50331686;
pub const PICO_SIGGEN_CLOCK_FREQ_NOT_SUPPLIED: u32 = 50331687;
pub const PICO_SIGGEN_TOO_MANY_SAMPLES: u32 = 50331696;
pub const PICO_SIGGEN_DUTYCYCLE_OUT_OF_RANGE: u32 = 50331697;
pub const PICO_SIGGEN_CYCLES_OUT_OF_RANGE: u32 = 50331698;
pub const PICO_SIGGEN_PRESCALE_OUT_OF_RANGE: u32 = 50331699;
pub const PICO_SIGGEN_SWEEPTYPE_INVALID: u32 = 50331700;
pub const PICO_SIGGEN_SWEEP_WAVETYPE_MISMATCH: u32 = 50331701;
pub const PICO_SIGGEN_INVALID_SWEEP_PARAMETERS: u32 = 50331702;
pub const PICO_SIGGEN_SWEEP_PRESCALE_NOT_SUPPORTED: u32 = 50331703;
pub const PICO_AWG_OVER_VOLTAGE_RANGE: u32 = 50331704;
pub const PICO_NOT_LOCKED_TO_REFERENCE_FREQUENCY: u32 = 50331705;
pub const PICO_PERMISSIONS_ERROR: u32 = 50331712;
pub const PICO_PORTS_WITHOUT_ANALOGUE_CHANNELS_ONLY_ALLOWED_IN_8BIT_RESOLUTION: u32 = 50335744;
pub const PICO_ANALOGUE_FRONTEND_MISSING: u32 = 50343937;
pub const PICO_FRONT_PANEL_MISSING: u32 = 50343938;
pub const PICO_ANALOGUE_FRONTEND_AND_FRONT_PANEL_MISSING: u32 = 50343939;
pub const PICO_FIRMWARE_UPDATE_REQUIRED_TO_USE_DEVICE_WITH_THIS_DRIVER: u32 = 50348032;
pub const PICO_UPDATE_REQUIRED_NULL: u32 = 50348033;
pub const PICO_FIRMWARE_UP_TO_DATE: u32 = 50348034;
pub const PICO_FLASH_FAIL: u32 = 50348035;
pub const PICO_INTERNAL_ERROR_FIRMWARE_LENGTH_INVALID: u32 = 50348036;
pub const PICO_INTERNAL_ERROR_FIRMWARE_NULL: u32 = 50348037;
pub const PICO_FIRMWARE_FAILED_TO_BE_CHANGED: u32 = 50348038;
pub const PICO_FIRMWARE_FAILED_TO_RELOAD: u32 = 50348039;
pub const PICO_FIRMWARE_FAILED_TO_BE_UPDATE: u32 = 50348040;
pub const PICO_FIRMWARE_VERSION_OUT_OF_RANGE: u32 = 50348041;
pub const PICO_FRONTPANEL_FIRMWARE_UPDATE_REQUIRED_TO_USE_DEVICE_WITH_THIS_DRIVER: u32 = 50348042;
pub const PICO_NO_APPS_AVAILABLE: u32 = 50364416;
pub const PICO_UNSUPPORTED_APP: u32 = 50364417;
pub const PICO_ADC_POWERED_DOWN: u32 = 50339840;
pub const PICO_WATCHDOGTIMER: u32 = 268435456;
pub const PICO_IPP_NOT_FOUND: u32 = 268435457;
pub const PICO_IPP_NO_FUNCTION: u32 = 268435458;
pub const PICO_IPP_ERROR: u32 = 268435459;
pub const PICO_SHADOW_CAL_NOT_AVAILABLE: u32 = 268435460;
pub const PICO_SHADOW_CAL_DISABLED: u32 = 268435461;
pub const PICO_SHADOW_CAL_ERROR: u32 = 268435462;
pub const PICO_SHADOW_CAL_CORRUPT: u32 = 268435463;
pub const PICO_DEVICE_MEMORY_OVERFLOW: u32 = 268435464;
pub const PICO_ADC_TEST_FAILURE: u32 = 268435472;
pub const PICO_RESERVED_1: u32 = 285212672;
pub const PICO_SOURCE_NOT_READY: u32 = 536870912;
pub const PICO_SOURCE_INVALID_BAUD_RATE: u32 = 536870913;
pub const PICO_SOURCE_NOT_OPENED_FOR_WRITE: u32 = 536870914;
pub const PICO_SOURCE_FAILED_TO_WRITE_DEVICE: u32 = 536870915;
pub const PICO_SOURCE_EEPROM_FAIL: u32 = 536870916;
pub const PICO_SOURCE_EEPROM_NOT_PRESENT: u32 = 536870917;
pub const PICO_SOURCE_EEPROM_NOT_PROGRAMMED: u32 = 536870918;
pub const PICO_SOURCE_LIST_NOT_READY: u32 = 536870919;
pub const PICO_SOURCE_FTD2XX_NOT_FOUND: u32 = 536870920;
pub const PICO_SOURCE_FTD2XX_NO_FUNCTION: u32 = 536870921;
pub const PS2208_MAX_ETS_CYCLES: u32 = 500;
pub const PS2208_MAX_INTERLEAVE: u32 = 20;
pub const PS2207_MAX_ETS_CYCLES: u32 = 500;
pub const PS2207_MAX_INTERLEAVE: u32 = 20;
pub const PS2206_MAX_ETS_CYCLES: u32 = 250;
pub const PS2206_MAX_INTERLEAVE: u32 = 10;
pub const PS2000A_EXT_MAX_VALUE: u32 = 32767;
pub const PS2000A_EXT_MIN_VALUE: i32 = -32767;
pub const PS2000A_MAX_LOGIC_LEVEL: u32 = 32767;
pub const PS2000A_MIN_LOGIC_LEVEL: i32 = -32767;
pub const MIN_SIG_GEN_FREQ: f64 = 0.0;
pub const MAX_SIG_GEN_FREQ: f64 = 20000000.0;
pub const PS2000A_MAX_SIG_GEN_BUFFER_SIZE: u32 = 8192;
pub const PS2000A_MIN_SIG_GEN_BUFFER_SIZE: u32 = 1;
pub const PS2000A_MIN_DWELL_COUNT: u32 = 3;
pub const PS2000A_MAX_SWEEPS_SHOTS: u32 = 1073741823;
pub const PS2000A_MAX_ANALOGUE_OFFSET_50MV_200MV: f64 = 0.25;
pub const PS2000A_MIN_ANALOGUE_OFFSET_50MV_200MV: f64 = -0.25;
pub const PS2000A_MAX_ANALOGUE_OFFSET_500MV_2V: f64 = 2.5;
pub const PS2000A_MIN_ANALOGUE_OFFSET_500MV_2V: f64 = -2.5;
pub const PS2000A_MAX_ANALOGUE_OFFSET_5V_20V: f64 = 20.0;
pub const PS2000A_MIN_ANALOGUE_OFFSET_5V_20V: f64 = -20.0;
pub const PS2000A_SHOT_SWEEP_TRIGGER_CONTINUOUS_RUN: u32 = 4294967295;
pub const PS2000A_SINE_MAX_FREQUENCY: f64 = 1000000.0;
pub const PS2000A_SQUARE_MAX_FREQUENCY: f64 = 1000000.0;
pub const PS2000A_TRIANGLE_MAX_FREQUENCY: f64 = 1000000.0;
pub const PS2000A_SINC_MAX_FREQUENCY: f64 = 1000000.0;
pub const PS2000A_RAMP_MAX_FREQUENCY: f64 = 1000000.0;
pub const PS2000A_HALF_SINE_MAX_FREQUENCY: f64 = 1000000.0;
pub const PS2000A_GAUSSIAN_MAX_FREQUENCY: f64 = 1000000.0;
pub const PS2000A_PRBS_MAX_FREQUENCY: f64 = 1000000.0;
pub const PS2000A_PRBS_MIN_FREQUENCY: f64 = 0.03;
pub const PS2000A_MIN_FREQUENCY: f64 = 0.03;

pub type PICO_POINTER = *mut ::std::os::raw::c_void;
pub type PICO_INFO = u32;
pub type PICO_STATUS = u32;
pub const enPicoStringValue_PICO_SV_MEMORY: enPicoStringValue = 0;
pub const enPicoStringValue_PICO_SV_MEMORY_NO_OF_SEGMENTS: enPicoStringValue = 1;
pub const enPicoStringValue_PICO_SV_MEMORY_MAX_SAMPLES: enPicoStringValue = 2;
pub const enPicoStringValue_PICO_SV_NO_OF_CHANNELS: enPicoStringValue = 3;
pub const enPicoStringValue_PICO_SV_ARRAY_OF_CHANNELS: enPicoStringValue = 4;
pub const enPicoStringValue_PICO_SV_CHANNEL: enPicoStringValue = 5;
pub const enPicoStringValue_PICO_SV_CHANNEL_NAME: enPicoStringValue = 6;
pub const enPicoStringValue_PICO_SV_CHANNEL_RANGE: enPicoStringValue = 7;
pub const enPicoStringValue_PICO_SV_CHANNEL_COUPLING: enPicoStringValue = 8;
pub const enPicoStringValue_PICO_SV_CHANNEL_ENABLED: enPicoStringValue = 9;
pub const enPicoStringValue_PICO_SV_CHANNEL_ANALOGUE_OFFSET: enPicoStringValue = 10;
pub const enPicoStringValue_PICO_SV_CHANNEL_FILTER: enPicoStringValue = 11;
pub const enPicoStringValue_PICO_SV_TRIGGER: enPicoStringValue = 12;
pub const enPicoStringValue_PICO_SV_TRIGGER_AUXIO_OUTPUT_ENABLED: enPicoStringValue = 13;
pub const enPicoStringValue_PICO_SV_TRIGGER_AUTO_TRIGGER_MICROSECONDS: enPicoStringValue = 14;
pub const enPicoStringValue_PICO_SV_TRIGGER_PROPERTIES: enPicoStringValue = 15;
pub const enPicoStringValue_PICO_SV_NO_OF_TRIGGER_PROPERTIES: enPicoStringValue = 16;
pub const enPicoStringValue_PICO_SV_TRIGGER_PROPERTIES_CHANNEL: enPicoStringValue = 17;
pub const enPicoStringValue_PICO_SV_TRIGGER_PROPERTIES_THRESHOLD_UPPER: enPicoStringValue = 18;
pub const enPicoStringValue_PICO_SV_TRIGGER_PROPERTIES_THRESHOLD_UPPER_HYSTERESIS:
    enPicoStringValue = 19;
pub const enPicoStringValue_PICO_SV_TRIGGER_PROPERTIES_THRESHOLD_LOWER: enPicoStringValue = 20;
pub const enPicoStringValue_PICO_SV_TRIGGER_PROPERTIES_THRESHOLD_LOWER_HYSTERESIS:
    enPicoStringValue = 21;
pub const enPicoStringValue_PICO_SV_TRIGGER_PROPERTIES_THRESHOLD_MODE: enPicoStringValue = 22;
pub const enPicoStringValue_PICO_SV_TRIGGER_ARRAY_OF_BLOCK_CONDITIONS: enPicoStringValue = 23;
pub const enPicoStringValue_PICO_SV_TRIGGER_NO_OF_BLOCK_CONDITIONS: enPicoStringValue = 24;
pub const enPicoStringValue_PICO_SV_TRIGGER_CONDITIONS: enPicoStringValue = 25;
pub const enPicoStringValue_PICO_SV_TRIGGER_NO_OF_CONDITIONS: enPicoStringValue = 26;
pub const enPicoStringValue_PICO_SV_TRIGGER_CONDITION_SOURCE: enPicoStringValue = 27;
pub const enPicoStringValue_PICO_SV_TRIGGER_CONDITION_STATE: enPicoStringValue = 28;
pub const enPicoStringValue_PICO_SV_TRIGGER_DIRECTION: enPicoStringValue = 29;
pub const enPicoStringValue_PICO_SV_TRIGGER_NO_OF_DIRECTIONS: enPicoStringValue = 30;
pub const enPicoStringValue_PICO_SV_TRIGGER_DIRECTION_CHANNEL: enPicoStringValue = 31;
pub const enPicoStringValue_PICO_SV_TRIGGER_DIRECTION_DIRECTION: enPicoStringValue = 32;
pub const enPicoStringValue_PICO_SV_TRIGGER_DELAY: enPicoStringValue = 33;
pub const enPicoStringValue_PICO_SV_TRIGGER_DELAY_MS: enPicoStringValue = 34;
pub const enPicoStringValue_PICO_SV_FREQUENCY_COUNTER: enPicoStringValue = 35;
pub const enPicoStringValue_PICO_SV_FREQUENCY_COUNTER_ENABLED: enPicoStringValue = 36;
pub const enPicoStringValue_PICO_SV_FREQUENCY_COUNTER_CHANNEL: enPicoStringValue = 37;
pub const enPicoStringValue_PICO_SV_FREQUENCY_COUNTER_RANGE: enPicoStringValue = 38;
pub const enPicoStringValue_PICO_SV_FREQUENCY_COUNTER_TRESHOLDMAJOR: enPicoStringValue = 39;
pub const enPicoStringValue_PICO_SV_FREQUENCY_COUNTER_TRESHOLDMINOR: enPicoStringValue = 40;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_PROPERTIES: enPicoStringValue = 41;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_PROPERTIES_DIRECTION: enPicoStringValue = 42;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_PROPERTIES_LOWER: enPicoStringValue = 43;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_PROPERTIES_UPPER: enPicoStringValue = 44;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_PROPERTIES_TYPE: enPicoStringValue = 45;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_ARRAY_OF_BLOCK_CONDITIONS: enPicoStringValue = 46;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_NO_OF_BLOCK_CONDITIONS: enPicoStringValue = 47;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_CONDITIONS: enPicoStringValue = 48;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_NO_OF_CONDITIONS: enPicoStringValue = 49;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_CONDITIONS_SOURCE: enPicoStringValue = 50;
pub const enPicoStringValue_PICO_SV_PULSE_WIDTH_CONDITIONS_STATE: enPicoStringValue = 51;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES: enPicoStringValue = 52;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_PRE_TRIGGER_SAMPLES: enPicoStringValue = 53;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_POST_TRIGGER_SAMPLES: enPicoStringValue = 54;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_TIMEBASE: enPicoStringValue = 55;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_NO_OF_CAPTURES: enPicoStringValue = 56;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_RESOLUTION: enPicoStringValue = 57;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_OVERLAPPED: enPicoStringValue = 58;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_OVERLAPPED_DOWN_SAMPLE_RATIO:
    enPicoStringValue = 59;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_OVERLAPPED_DOWN_SAMPLE_RATIO_MODE:
    enPicoStringValue = 60;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_OVERLAPPED_REQUERSTED_NO_OF_SAMPLES:
    enPicoStringValue = 61;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_OVERLAPPED_SEGMENT_INDEX_FROM:
    enPicoStringValue = 62;
pub const enPicoStringValue_PICO_SV_SAMPLE_PROPERTIES_OVERLAPPED_SEGMENT_INDEX_TO:
    enPicoStringValue = 63;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR: enPicoStringValue = 64;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_BUILT_IN: enPicoStringValue = 65;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_BUILT_IN_WAVE_TYPE: enPicoStringValue = 66;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_BUILT_IN_START_FREQUENCY: enPicoStringValue =
    67;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_BUILT_IN_STOP_FREQUENCY: enPicoStringValue =
    68;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_BUILT_IN_INCREMENT: enPicoStringValue = 69;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_BUILT_IN_DWELL_TIME: enPicoStringValue = 70;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_AWG: enPicoStringValue = 71;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_AWG_START_DELTA_PHASE: enPicoStringValue = 72;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_AWG_STOP_DELTA_PHASE: enPicoStringValue = 73;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_AWG_DELTA_PHASE_INCREMENT: enPicoStringValue =
    74;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_AWG_DWELL_COUNT: enPicoStringValue = 75;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_AWG_INDEX_MODE: enPicoStringValue = 76;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_AWG_WAVEFORM_SIZE: enPicoStringValue = 77;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_ARRAY_OF_AWG_WAVEFORM_VALUES:
    enPicoStringValue = 78;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_OFFSET_VOLTAGE: enPicoStringValue = 79;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_PK_TO_PK: enPicoStringValue = 80;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_OPERATION: enPicoStringValue = 81;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_SHOTS: enPicoStringValue = 82;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_SWEEPS: enPicoStringValue = 83;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_SWEEP_TYPE: enPicoStringValue = 84;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_TRIGGER_TYPE: enPicoStringValue = 85;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_TRIGGER_SOURCE: enPicoStringValue = 86;
pub const enPicoStringValue_PICO_SV_SIGNAL_GENERATOR_EXT_IN_THRESHOLD: enPicoStringValue = 87;
pub const enPicoStringValue_PICO_SV_ETS: enPicoStringValue = 88;
pub const enPicoStringValue_PICO_SV_ETS_STATE: enPicoStringValue = 89;
pub const enPicoStringValue_PICO_SV_ETS_CYCLE: enPicoStringValue = 90;
pub const enPicoStringValue_PICO_SV_ETS_INTERLEAVE: enPicoStringValue = 91;
pub const enPicoStringValue_PICO_SV_ETS_SAMPLE_TIME_PICOSECONDS: enPicoStringValue = 92;
pub type enPicoStringValue = ::std::os::raw::c_uint;
pub use self::enPicoStringValue as PICO_STRING_VALUE;
pub const enPS2000AChannelBufferIndex_PS2000A_CHANNEL_A_MAX: enPS2000AChannelBufferIndex = 0;
pub const enPS2000AChannelBufferIndex_PS2000A_CHANNEL_A_MIN: enPS2000AChannelBufferIndex = 1;
pub const enPS2000AChannelBufferIndex_PS2000A_CHANNEL_B_MAX: enPS2000AChannelBufferIndex = 2;
pub const enPS2000AChannelBufferIndex_PS2000A_CHANNEL_B_MIN: enPS2000AChannelBufferIndex = 3;
pub const enPS2000AChannelBufferIndex_PS2000A_CHANNEL_C_MAX: enPS2000AChannelBufferIndex = 4;
pub const enPS2000AChannelBufferIndex_PS2000A_CHANNEL_C_MIN: enPS2000AChannelBufferIndex = 5;
pub const enPS2000AChannelBufferIndex_PS2000A_CHANNEL_D_MAX: enPS2000AChannelBufferIndex = 6;
pub const enPS2000AChannelBufferIndex_PS2000A_CHANNEL_D_MIN: enPS2000AChannelBufferIndex = 7;
pub const enPS2000AChannelBufferIndex_PS2000A_MAX_CHANNEL_BUFFERS: enPS2000AChannelBufferIndex = 8;
#[doc = " <summary>"]
#[doc = " The analogue channels index"]
#[doc = " </summary>"]
pub type enPS2000AChannelBufferIndex = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " The analogue channels index"]
#[doc = " </summary>"]
pub use self::enPS2000AChannelBufferIndex as PS2000A_CHANNEL_BUFFER_INDEX;
pub const enPS2000AChannel_PS2000A_CHANNEL_A: enPS2000AChannel = 0;
pub const enPS2000AChannel_PS2000A_CHANNEL_B: enPS2000AChannel = 1;
pub const enPS2000AChannel_PS2000A_CHANNEL_C: enPS2000AChannel = 2;
pub const enPS2000AChannel_PS2000A_CHANNEL_D: enPS2000AChannel = 3;
pub const enPS2000AChannel_PS2000A_EXTERNAL: enPS2000AChannel = 4;
pub const enPS2000AChannel_PS2000A_MAX_CHANNELS: enPS2000AChannel = 4;
pub const enPS2000AChannel_PS2000A_TRIGGER_AUX: enPS2000AChannel = 5;
pub const enPS2000AChannel_PS2000A_MAX_TRIGGER_SOURCES: enPS2000AChannel = 6;
#[doc = " <summary>"]
#[doc = " The analogue channels and trigger channels supported by the devices"]
#[doc = " </summary>"]
pub type enPS2000AChannel = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " The analogue channels and trigger channels supported by the devices"]
#[doc = " </summary>"]
pub use self::enPS2000AChannel as PS2000A_CHANNEL;
#[doc = " <summary>"]
#[doc = " Ignore the trigger settings"]
#[doc = " </summary>"]
pub const enPS2000ATriggerOperand_PS2000A_OPERAND_NONE: enPS2000ATriggerOperand = 0;
#[doc = " <summary>"]
#[doc = " Fire when either trigger is activated."]
#[doc = " </summary>"]
pub const enPS2000ATriggerOperand_PS2000A_OPERAND_OR: enPS2000ATriggerOperand = 1;
#[doc = " <summary>"]
#[doc = " Fire when both triggers are activated"]
#[doc = " </summary>"]
pub const enPS2000ATriggerOperand_PS2000A_OPERAND_AND: enPS2000ATriggerOperand = 2;
#[doc = " <summary>"]
#[doc = " Fire when one trigger is activated."]
#[doc = " </summary>"]
pub const enPS2000ATriggerOperand_PS2000A_OPERAND_THEN: enPS2000ATriggerOperand = 3;
#[doc = " <summary>"]
#[doc = " MSO models only."]
#[doc = " Defines how the analgoue and digital triggers are combined."]
#[doc = " </summary>"]
pub type enPS2000ATriggerOperand = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " MSO models only."]
#[doc = " Defines how the analgoue and digital triggers are combined."]
#[doc = " </summary>"]
pub use self::enPS2000ATriggerOperand as PS2000A_TRIGGER_OPERAND;
pub const enPS2000DigitalPort_PS2000A_DIGITAL_PORT0: enPS2000DigitalPort = 128;
pub const enPS2000DigitalPort_PS2000A_DIGITAL_PORT1: enPS2000DigitalPort = 129;
pub const enPS2000DigitalPort_PS2000A_DIGITAL_PORT2: enPS2000DigitalPort = 130;
pub const enPS2000DigitalPort_PS2000A_DIGITAL_PORT3: enPS2000DigitalPort = 131;
pub const enPS2000DigitalPort_PS2000A_MAX_DIGITAL_PORTS: enPS2000DigitalPort = 4;
#[doc = " <summary>"]
#[doc = " MSO ports"]
#[doc = " </summary>"]
pub type enPS2000DigitalPort = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " MSO ports"]
#[doc = " </summary>"]
pub use self::enPS2000DigitalPort as PS2000A_DIGITAL_PORT;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_0: enPS2000ADigitalChannel = 0;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_1: enPS2000ADigitalChannel = 1;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_2: enPS2000ADigitalChannel = 2;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_3: enPS2000ADigitalChannel = 3;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_4: enPS2000ADigitalChannel = 4;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_5: enPS2000ADigitalChannel = 5;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_6: enPS2000ADigitalChannel = 6;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_7: enPS2000ADigitalChannel = 7;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_8: enPS2000ADigitalChannel = 8;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_9: enPS2000ADigitalChannel = 9;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_10: enPS2000ADigitalChannel = 10;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_11: enPS2000ADigitalChannel = 11;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_12: enPS2000ADigitalChannel = 12;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_13: enPS2000ADigitalChannel = 13;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_14: enPS2000ADigitalChannel = 14;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_15: enPS2000ADigitalChannel = 15;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_16: enPS2000ADigitalChannel = 16;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_17: enPS2000ADigitalChannel = 17;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_18: enPS2000ADigitalChannel = 18;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_19: enPS2000ADigitalChannel = 19;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_20: enPS2000ADigitalChannel = 20;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_21: enPS2000ADigitalChannel = 21;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_22: enPS2000ADigitalChannel = 22;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_23: enPS2000ADigitalChannel = 23;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_24: enPS2000ADigitalChannel = 24;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_25: enPS2000ADigitalChannel = 25;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_26: enPS2000ADigitalChannel = 26;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_27: enPS2000ADigitalChannel = 27;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_28: enPS2000ADigitalChannel = 28;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_29: enPS2000ADigitalChannel = 29;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_30: enPS2000ADigitalChannel = 30;
pub const enPS2000ADigitalChannel_PS2000A_DIGITAL_CHANNEL_31: enPS2000ADigitalChannel = 31;
pub const enPS2000ADigitalChannel_PS2000A_MAX_DIGITAL_CHANNELS: enPS2000ADigitalChannel = 32;
#[doc = " <summary>"]
#[doc = " MSO digital channels"]
#[doc = " </summary>"]
pub type enPS2000ADigitalChannel = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " MSO digital channels"]
#[doc = " </summary>"]
pub use self::enPS2000ADigitalChannel as PS2000A_DIGITAL_CHANNEL;
pub const enPS2000ARange_PS2000A_10MV: enPS2000ARange = 0;
pub const enPS2000ARange_PS2000A_20MV: enPS2000ARange = 1;
pub const enPS2000ARange_PS2000A_50MV: enPS2000ARange = 2;
pub const enPS2000ARange_PS2000A_100MV: enPS2000ARange = 3;
pub const enPS2000ARange_PS2000A_200MV: enPS2000ARange = 4;
pub const enPS2000ARange_PS2000A_500MV: enPS2000ARange = 5;
pub const enPS2000ARange_PS2000A_1V: enPS2000ARange = 6;
pub const enPS2000ARange_PS2000A_2V: enPS2000ARange = 7;
pub const enPS2000ARange_PS2000A_5V: enPS2000ARange = 8;
pub const enPS2000ARange_PS2000A_10V: enPS2000ARange = 9;
pub const enPS2000ARange_PS2000A_20V: enPS2000ARange = 10;
pub const enPS2000ARange_PS2000A_50V: enPS2000ARange = 11;
pub const enPS2000ARange_PS2000A_MAX_RANGES: enPS2000ARange = 12;
#[doc = " <summary>"]
#[doc = " Ranges that the channels are set to:"]
#[doc = " Not all ranges are supported by every variant"]
#[doc = " </summary>"]
pub type enPS2000ARange = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " Ranges that the channels are set to:"]
#[doc = " Not all ranges are supported by every variant"]
#[doc = " </summary>"]
pub use self::enPS2000ARange as PS2000A_RANGE;
pub const enPS2000ACoupling_PS2000A_AC: enPS2000ACoupling = 0;
pub const enPS2000ACoupling_PS2000A_DC: enPS2000ACoupling = 1;
#[doc = " <summary>"]
#[doc = " Available coupling modes."]
#[doc = " </summary>"]
pub type enPS2000ACoupling = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " Available coupling modes."]
#[doc = " </summary>"]
pub use self::enPS2000ACoupling as PS2000A_COUPLING;
pub const enPS2000AChannelInfo_PS2000A_CI_RANGES: enPS2000AChannelInfo = 0;
pub type enPS2000AChannelInfo = ::std::os::raw::c_uint;
pub use self::enPS2000AChannelInfo as PS2000A_CHANNEL_INFO;
#[doc = " <summary>"]
#[doc = " disables"]
#[doc = " </summary>"]
pub const enPS2000AEtsMode_PS2000A_ETS_OFF: enPS2000AEtsMode = 0;
#[doc = " <summary>"]
#[doc = " enables ETS and provides etsCycles of data, which may contain data from previously returned cycles."]
#[doc = " </summary>"]
pub const enPS2000AEtsMode_PS2000A_ETS_FAST: enPS2000AEtsMode = 1;
#[doc = " <summary>"]
#[doc = " enables ETS and provides fresh data every etsCycles. This"]
#[doc = " mode takes longer to provide each data set, but the data sets are more stable and"]
#[doc = " are guaranteed to contain only new data."]
#[doc = " </summary>"]
pub const enPS2000AEtsMode_PS2000A_ETS_SLOW: enPS2000AEtsMode = 2;
#[doc = " <summary>"]
#[doc = " enables ETS and provides fresh data every etsCycles. This"]
#[doc = " mode takes longer to provide each data set, but the data sets are more stable and"]
#[doc = " are guaranteed to contain only new data."]
#[doc = " </summary>"]
pub const enPS2000AEtsMode_PS2000A_ETS_MODES_MAX: enPS2000AEtsMode = 3;
#[doc = " <summary>"]
#[doc = " Ets modes avialable"]
#[doc = " </summary>"]
pub type enPS2000AEtsMode = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " Ets modes avialable"]
#[doc = " </summary>"]
pub use self::enPS2000AEtsMode as PS2000A_ETS_MODE;
pub const enPS2000ATimeUnits_PS2000A_FS: enPS2000ATimeUnits = 0;
pub const enPS2000ATimeUnits_PS2000A_PS: enPS2000ATimeUnits = 1;
pub const enPS2000ATimeUnits_PS2000A_NS: enPS2000ATimeUnits = 2;
pub const enPS2000ATimeUnits_PS2000A_US: enPS2000ATimeUnits = 3;
pub const enPS2000ATimeUnits_PS2000A_MS: enPS2000ATimeUnits = 4;
pub const enPS2000ATimeUnits_PS2000A_S: enPS2000ATimeUnits = 5;
pub const enPS2000ATimeUnits_PS2000A_MAX_TIME_UNITS: enPS2000ATimeUnits = 6;
#[doc = " <summary>"]
#[doc = " Time units that the time paramaters are using."]
#[doc = " </summary>"]
pub type enPS2000ATimeUnits = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " Time units that the time paramaters are using."]
#[doc = " </summary>"]
pub use self::enPS2000ATimeUnits as PS2000A_TIME_UNITS;
pub const enPS2000ASweepType_PS2000A_UP: enPS2000ASweepType = 0;
pub const enPS2000ASweepType_PS2000A_DOWN: enPS2000ASweepType = 1;
pub const enPS2000ASweepType_PS2000A_UPDOWN: enPS2000ASweepType = 2;
pub const enPS2000ASweepType_PS2000A_DOWNUP: enPS2000ASweepType = 3;
pub const enPS2000ASweepType_PS2000A_MAX_SWEEP_TYPES: enPS2000ASweepType = 4;
#[doc = " <summary>"]
#[doc = " whether the frequency will sweep from startFrequency to"]
#[doc = " stopFrequency, or in the opposite direction, or repeatedly reverse direction"]
#[doc = " </summary>"]
pub type enPS2000ASweepType = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " whether the frequency will sweep from startFrequency to"]
#[doc = " stopFrequency, or in the opposite direction, or repeatedly reverse direction"]
#[doc = " </summary>"]
pub use self::enPS2000ASweepType as PS2000A_SWEEP_TYPE;
pub const enPS2000AWaveType_PS2000A_SINE: enPS2000AWaveType = 0;
pub const enPS2000AWaveType_PS2000A_SQUARE: enPS2000AWaveType = 1;
pub const enPS2000AWaveType_PS2000A_TRIANGLE: enPS2000AWaveType = 2;
pub const enPS2000AWaveType_PS2000A_RAMP_UP: enPS2000AWaveType = 3;
pub const enPS2000AWaveType_PS2000A_RAMP_DOWN: enPS2000AWaveType = 4;
pub const enPS2000AWaveType_PS2000A_SINC: enPS2000AWaveType = 5;
pub const enPS2000AWaveType_PS2000A_GAUSSIAN: enPS2000AWaveType = 6;
pub const enPS2000AWaveType_PS2000A_HALF_SINE: enPS2000AWaveType = 7;
pub const enPS2000AWaveType_PS2000A_DC_VOLTAGE: enPS2000AWaveType = 8;
pub const enPS2000AWaveType_PS2000A_MAX_WAVE_TYPES: enPS2000AWaveType = 9;
#[doc = " <summary>"]
#[doc = " Built in waveform types"]
#[doc = " </summary>"]
pub type enPS2000AWaveType = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " Built in waveform types"]
#[doc = " </summary>"]
pub use self::enPS2000AWaveType as PS2000A_WAVE_TYPE;
#[doc = " <summary>"]
#[doc = " Normal signal generator operation specified by wavetype."]
#[doc = " </summary>"]
pub const enPS2000AExtraOperations_PS2000A_ES_OFF: enPS2000AExtraOperations = 0;
#[doc = " <summary>"]
#[doc = " The signal generator produces white noise and ignores all settings except pkToPk and offsetVoltage."]
#[doc = " </summary>"]
pub const enPS2000AExtraOperations_PS2000A_WHITENOISE: enPS2000AExtraOperations = 1;
#[doc = " <summary>"]
#[doc = " produces a pseudorandom random binary sequence with a bit rate"]
#[doc = " specified by the start and stop frequency."]
#[doc = " </summary>"]
pub const enPS2000AExtraOperations_PS2000A_PRBS: enPS2000AExtraOperations = 2;
#[doc = " <summary>"]
#[doc = " The type of waveform to be produced, specified by one of the following"]
#[doc = " </summary>"]
pub type enPS2000AExtraOperations = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " The type of waveform to be produced, specified by one of the following"]
#[doc = " </summary>"]
pub use self::enPS2000AExtraOperations as PS2000A_EXTRA_OPERATIONS;
#[doc = " <summary>"]
#[doc = " Trigger on rising edge"]
#[doc = " </summary>"]
pub const enPS2000ASigGenTrigType_PS2000A_SIGGEN_RISING: enPS2000ASigGenTrigType = 0;
#[doc = " <summary>"]
#[doc = " Trigger on falling edge"]
#[doc = " </summary>"]
pub const enPS2000ASigGenTrigType_PS2000A_SIGGEN_FALLING: enPS2000ASigGenTrigType = 1;
#[doc = " <summary>"]
#[doc = " Run while trigger is high"]
#[doc = " </summary>"]
pub const enPS2000ASigGenTrigType_PS2000A_SIGGEN_GATE_HIGH: enPS2000ASigGenTrigType = 2;
#[doc = " <summary>"]
#[doc = " Run while trigger is low"]
#[doc = " </summary>"]
pub const enPS2000ASigGenTrigType_PS2000A_SIGGEN_GATE_LOW: enPS2000ASigGenTrigType = 3;
#[doc = " <summary>"]
#[doc = " The type of trigger that will be applied to the signal generator"]
#[doc = " </summary>"]
pub type enPS2000ASigGenTrigType = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " The type of trigger that will be applied to the signal generator"]
#[doc = " </summary>"]
pub use self::enPS2000ASigGenTrigType as PS2000A_SIGGEN_TRIG_TYPE;
#[doc = " <summary>"]
#[doc = " Run without waiting for trigger"]
#[doc = " </summary>"]
pub const enPS2000ASigGenTrigSource_PS2000A_SIGGEN_NONE: enPS2000ASigGenTrigSource = 0;
#[doc = " <summary>"]
#[doc = " Use scope trigger"]
#[doc = " </summary"]
pub const enPS2000ASigGenTrigSource_PS2000A_SIGGEN_SCOPE_TRIG: enPS2000ASigGenTrigSource = 1;
#[doc = " <summary>"]
#[doc = " Use AUXIO input"]
#[doc = " </summary>"]
pub const enPS2000ASigGenTrigSource_PS2000A_SIGGEN_AUX_IN: enPS2000ASigGenTrigSource = 2;
#[doc = " <summary>"]
#[doc = " Use external input"]
#[doc = " </summary>"]
pub const enPS2000ASigGenTrigSource_PS2000A_SIGGEN_EXT_IN: enPS2000ASigGenTrigSource = 3;
#[doc = " <summary>"]
#[doc = " Wait for software trigger"]
#[doc = " </summary>"]
pub const enPS2000ASigGenTrigSource_PS2000A_SIGGEN_SOFT_TRIG: enPS2000ASigGenTrigSource = 4;
#[doc = " <summary>"]
#[doc = " The source that will trigger the signal generator"]
#[doc = " </summary>"]
pub type enPS2000ASigGenTrigSource = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " The source that will trigger the signal generator"]
#[doc = " </summary>"]
pub use self::enPS2000ASigGenTrigSource as PS2000A_SIGGEN_TRIG_SOURCE;
#[doc = " <summary>"]
#[doc = " The generator outputs the raw contents of the buffer repeatedly ."]
#[doc = " </summary>"]
pub const enPS2000AIndexMode_PS2000A_SINGLE: enPS2000AIndexMode = 0;
#[doc = " <summary>"]
#[doc = " The generator outputs the contents of the buffer from beginning to end, and then does a second pass in the reverse"]
#[doc = " direction through the buffer"]
#[doc = " </summary>"]
pub const enPS2000AIndexMode_PS2000A_DUAL: enPS2000AIndexMode = 1;
#[doc = " <summary>"]
#[doc = " This is similiar to the Dual but passes through the buffer four time inverting, and inverting reversed"]
#[doc = " </summary>"]
pub const enPS2000AIndexMode_PS2000A_QUAD: enPS2000AIndexMode = 2;
#[doc = " <summary>"]
#[doc = " This is similiar to the Dual but passes through the buffer four time inverting, and inverting reversed"]
#[doc = " </summary>"]
pub const enPS2000AIndexMode_PS2000A_MAX_INDEX_MODES: enPS2000AIndexMode = 3;
#[doc = " <summary>"]
#[doc = " AWG index modes"]
#[doc = " </summary>"]
pub type enPS2000AIndexMode = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " AWG index modes"]
#[doc = " </summary>"]
pub use self::enPS2000AIndexMode as PS2000A_INDEX_MODE;
pub const enPS2000A_ThresholdMode_PS2000A_LEVEL: enPS2000A_ThresholdMode = 0;
pub const enPS2000A_ThresholdMode_PS2000A_WINDOW: enPS2000A_ThresholdMode = 1;
#[doc = " <summary>"]
#[doc = " The number of thershold that will be used for triggering."]
#[doc = " </summary>"]
pub type enPS2000A_ThresholdMode = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " The number of thershold that will be used for triggering."]
#[doc = " </summary>"]
pub use self::enPS2000A_ThresholdMode as PS2000A_THRESHOLD_MODE;
#[doc = " <summary>"]
#[doc = " For gated triggers: above the upper threshold."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_ABOVE: enPS2000AThresholdDirection = 0;
#[doc = " <summary>"]
#[doc = " For gated triggers: below the upper threshold."]
#[doc = " </summary"]
pub const enPS2000AThresholdDirection_PS2000A_BELOW: enPS2000AThresholdDirection = 1;
#[doc = " <summary>"]
#[doc = " For threshold triggers: rising edge, using upper threshold."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_RISING: enPS2000AThresholdDirection = 2;
#[doc = " <summary>"]
#[doc = " For threshold triggers: falling edge, using upper threshold."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_FALLING: enPS2000AThresholdDirection = 3;
#[doc = " <summary>"]
#[doc = " For threshold triggers: either edge."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_RISING_OR_FALLING: enPS2000AThresholdDirection = 4;
#[doc = " <summary>"]
#[doc = " For gated triggers: above the lower threshold."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_ABOVE_LOWER: enPS2000AThresholdDirection = 5;
#[doc = " <summary>"]
#[doc = " For gated triggers: below the lower threshold."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_BELOW_LOWER: enPS2000AThresholdDirection = 6;
#[doc = " <summary>"]
#[doc = " For threshold triggers: rising edge, using lower threshold."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_RISING_LOWER: enPS2000AThresholdDirection = 7;
#[doc = " <summary>"]
#[doc = " For threshold triggers: falling edge, using lower threshold."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_FALLING_LOWER: enPS2000AThresholdDirection = 8;
#[doc = " <summary>"]
#[doc = " For window-qualified triggers: inside window."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_INSIDE: enPS2000AThresholdDirection = 0;
#[doc = " <summary>"]
#[doc = " For window-qualified triggers: outside window."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_OUTSIDE: enPS2000AThresholdDirection = 1;
#[doc = " <summary>"]
#[doc = " For window triggers: entering the window."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_ENTER: enPS2000AThresholdDirection = 2;
#[doc = " <summary>"]
#[doc = " For window triggers: leaving the window."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_EXIT: enPS2000AThresholdDirection = 3;
#[doc = " <summary>"]
#[doc = " For window triggers: either entering or leaving the window."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_ENTER_OR_EXIT: enPS2000AThresholdDirection = 4;
#[doc = " <summary>"]
#[doc = " For window-qualified triggers."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_POSITIVE_RUNT: enPS2000AThresholdDirection = 9;
#[doc = " <summary>"]
#[doc = " For window-qualified triggers."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_NEGATIVE_RUNT: enPS2000AThresholdDirection = 10;
#[doc = " <summary>"]
#[doc = " No trigger."]
#[doc = " </summary>"]
pub const enPS2000AThresholdDirection_PS2000A_NONE: enPS2000AThresholdDirection = 2;
#[doc = " <summary>"]
#[doc = " The direction that the signal will pass through the trigger."]
#[doc = " </summary>"]
pub type enPS2000AThresholdDirection = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " The direction that the signal will pass through the trigger."]
#[doc = " </summary>"]
pub use self::enPS2000AThresholdDirection as PS2000A_THRESHOLD_DIRECTION;
pub const enPS2000ADigitalDirection_PS2000A_DIGITAL_DONT_CARE: enPS2000ADigitalDirection = 0;
pub const enPS2000ADigitalDirection_PS2000A_DIGITAL_DIRECTION_LOW: enPS2000ADigitalDirection = 1;
pub const enPS2000ADigitalDirection_PS2000A_DIGITAL_DIRECTION_HIGH: enPS2000ADigitalDirection = 2;
pub const enPS2000ADigitalDirection_PS2000A_DIGITAL_DIRECTION_RISING: enPS2000ADigitalDirection = 3;
pub const enPS2000ADigitalDirection_PS2000A_DIGITAL_DIRECTION_FALLING: enPS2000ADigitalDirection =
    4;
pub const enPS2000ADigitalDirection_PS2000A_DIGITAL_DIRECTION_RISING_OR_FALLING:
    enPS2000ADigitalDirection = 5;
pub const enPS2000ADigitalDirection_PS2000A_DIGITAL_MAX_DIRECTION: enPS2000ADigitalDirection = 6;
#[doc = " <summary>"]
#[doc = " Digital channel trigger dirction"]
#[doc = " </summary>"]
pub type enPS2000ADigitalDirection = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " Digital channel trigger dirction"]
#[doc = " </summary>"]
pub use self::enPS2000ADigitalDirection as PS2000A_DIGITAL_DIRECTION;
pub const enPS2000ATriggerState_PS2000A_CONDITION_DONT_CARE: enPS2000ATriggerState = 0;
pub const enPS2000ATriggerState_PS2000A_CONDITION_TRUE: enPS2000ATriggerState = 1;
pub const enPS2000ATriggerState_PS2000A_CONDITION_FALSE: enPS2000ATriggerState = 2;
pub const enPS2000ATriggerState_PS2000A_CONDITION_MAX: enPS2000ATriggerState = 3;
#[doc = " <summary>"]
#[doc = " The type of condition that should be applied to each channel."]
#[doc = " The channels that are set to True or False must all meet their conditions"]
#[doc = " simultaneously to produce a trigger. Channels set to DontCare are ignored."]
#[doc = " </summary>"]
pub type enPS2000ATriggerState = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " The type of condition that should be applied to each channel."]
#[doc = " The channels that are set to True or False must all meet their conditions"]
#[doc = " simultaneously to produce a trigger. Channels set to DontCare are ignored."]
#[doc = " </summary>"]
pub use self::enPS2000ATriggerState as PS2000A_TRIGGER_STATE;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct tPS2000ATriggerConditions {
    pub channelA: PS2000A_TRIGGER_STATE,
    pub channelB: PS2000A_TRIGGER_STATE,
    pub channelC: PS2000A_TRIGGER_STATE,
    pub channelD: PS2000A_TRIGGER_STATE,
    pub external: PS2000A_TRIGGER_STATE,
    pub aux: PS2000A_TRIGGER_STATE,
    pub pulseWidthQualifier: PS2000A_TRIGGER_STATE,
    pub digital: PS2000A_TRIGGER_STATE,
}

pub type PS2000A_TRIGGER_CONDITIONS = tPS2000ATriggerConditions;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct tPS2000APwqConditions {
    pub channelA: PS2000A_TRIGGER_STATE,
    pub channelB: PS2000A_TRIGGER_STATE,
    pub channelC: PS2000A_TRIGGER_STATE,
    pub channelD: PS2000A_TRIGGER_STATE,
    pub external: PS2000A_TRIGGER_STATE,
    pub aux: PS2000A_TRIGGER_STATE,
    pub digital: PS2000A_TRIGGER_STATE,
}

pub type PS2000A_PWQ_CONDITIONS = tPS2000APwqConditions;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct tPS2000ADigitalChannelDirections {
    #[doc = " <summary>"]
    #[doc = " The channel being configured. Channels supported by series SetChannel for allowable values."]
    #[doc = " </summary>"]
    pub channel: PS2000A_DIGITAL_CHANNEL,
    #[doc = " <summary>"]
    #[doc = " The trigger direction that should be applied to each channel."]
    #[doc = " </summary>"]
    pub direction: PS2000A_DIGITAL_DIRECTION,
}

pub type PS2000A_DIGITAL_CHANNEL_DIRECTIONS = tPS2000ADigitalChannelDirections;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct tPS2000ATriggerChannelProperties {
    #[doc = " <summary>"]
    #[doc = " The upper threshold at which the trigger must fire"]
    #[doc = " </summary>"]
    pub thresholdUpper: i16,
    #[doc = " <summary>"]
    #[doc = " The hysteresis by which the trigger must exceed the upper threshold before it will fire."]
    #[doc = " </summary>"]
    pub thresholdUpperHysteresis: u16,
    #[doc = " <summary>"]
    #[doc = " The lower threshold at which the trigger must fire."]
    #[doc = " </summary>"]
    pub thresholdLower: i16,
    #[doc = " <summary>"]
    #[doc = " The hysteresis by which the trigger must exceed the lower threshold before it will fire."]
    #[doc = " </summary>"]
    pub thresholdLowerHysteresis: u16,
    #[doc = " <summary>"]
    #[doc = " The channel to which the properties apply"]
    #[doc = " </summary>"]
    pub channel: PS2000A_CHANNEL,
    #[doc = " <summary>"]
    #[doc = " Either a level or window trigger"]
    #[doc = " </summary>"]
    pub thresholdMode: PS2000A_THRESHOLD_MODE,
}

pub type PS2000A_TRIGGER_CHANNEL_PROPERTIES = tPS2000ATriggerChannelProperties;
#[doc = " <summary>"]
#[doc = " No downsampling. Returns the raw data values."]
#[doc = " </summary>"]
pub const enPS2000ARatioMode_PS2000A_RATIO_MODE_NONE: enPS2000ARatioMode = 0;
#[doc = " <summary>"]
#[doc = " Reduces every block of n values to just two values: a minimum and a maximum."]
#[doc = " The minimum and maximum values are returned in two separate buffers."]
#[doc = " </summary>"]
pub const enPS2000ARatioMode_PS2000A_RATIO_MODE_AGGREGATE: enPS2000ARatioMode = 1;
#[doc = " <summary>"]
#[doc = " Reduces every block of n values to a single value representing the"]
#[doc = " average (arithmetic mean) of all the values."]
#[doc = " </summary>"]
pub const enPS2000ARatioMode_PS2000A_RATIO_MODE_DECIMATE: enPS2000ARatioMode = 2;
#[doc = " <summary>"]
#[doc = " Reduces every block of n values to just the first value in the block,"]
#[doc = " discarding all the other values."]
#[doc = " </summary>"]
pub const enPS2000ARatioMode_PS2000A_RATIO_MODE_AVERAGE: enPS2000ARatioMode = 4;
#[doc = " <summary>"]
#[doc = " Various methods of data reduction."]
#[doc = " Note that a single call to setting the buffers (ie. ps2000aSetDataBuffer) can only"]
#[doc = " associate one buffer with one downsampling mode. If you intend to retrieve more than one"]
#[doc = " downsampling mode from the get values functions, you must call set data buffer several"]
#[doc = "\ttimes to associate a separate buffer with each channel and downsampling mode."]
#[doc = " </summary>"]
pub type enPS2000ARatioMode = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " Various methods of data reduction."]
#[doc = " Note that a single call to setting the buffers (ie. ps2000aSetDataBuffer) can only"]
#[doc = " associate one buffer with one downsampling mode. If you intend to retrieve more than one"]
#[doc = " downsampling mode from the get values functions, you must call set data buffer several"]
#[doc = "\ttimes to associate a separate buffer with each channel and downsampling mode."]
#[doc = " </summary>"]
pub use self::enPS2000ARatioMode as PS2000A_RATIO_MODE;
#[doc = " <summary>"]
#[doc = " Do not use the pulse width qualifier"]
#[doc = " </summary>"]
pub const enPS2000APulseWidthType_PS2000A_PW_TYPE_NONE: enPS2000APulseWidthType = 0;
#[doc = " <summary>"]
#[doc = " Pulse width less than lower pulse width counter"]
#[doc = " </summary>"]
pub const enPS2000APulseWidthType_PS2000A_PW_TYPE_LESS_THAN: enPS2000APulseWidthType = 1;
#[doc = " <summary>"]
#[doc = " Pulse width greater than lower pulse width counter"]
#[doc = " </summary>"]
pub const enPS2000APulseWidthType_PS2000A_PW_TYPE_GREATER_THAN: enPS2000APulseWidthType = 2;
#[doc = " <summary>"]
#[doc = " Pulse width between lower and upper pulsee width counter"]
#[doc = " </summary>"]
pub const enPS2000APulseWidthType_PS2000A_PW_TYPE_IN_RANGE: enPS2000APulseWidthType = 3;
#[doc = " <summary>"]
#[doc = " Pulse width not between lower and upper pulse width counter"]
#[doc = " </summary>"]
pub const enPS2000APulseWidthType_PS2000A_PW_TYPE_OUT_OF_RANGE: enPS2000APulseWidthType = 4;
#[doc = " <summary>"]
#[doc = " The pulse-width type."]
#[doc = " </summary>"]
pub type enPS2000APulseWidthType = ::std::os::raw::c_uint;
#[doc = " <summary>"]
#[doc = " The pulse-width type."]
#[doc = " </summary>"]
pub use self::enPS2000APulseWidthType as PS2000A_PULSE_WIDTH_TYPE;
pub const enPS2000AHoldOffType_PS2000A_TIME: enPS2000AHoldOffType = 0;
pub const enPS2000AHoldOffType_PS2000A_MAX_HOLDOFF_TYPE: enPS2000AHoldOffType = 1;
pub type enPS2000AHoldOffType = ::std::os::raw::c_uint;
pub use self::enPS2000AHoldOffType as PS2000A_HOLDOFF_TYPE;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct tPS2000AScalingFactors {
    pub channelOrPort: PS2000A_CHANNEL,
    pub range: PS2000A_RANGE,
    pub offset: i16,
    pub scalingFactor: f64,
}

pub type PS2000A_SCALING_FACTORS_VALUES = tPS2000AScalingFactors;
#[doc = " <summary>"]
#[doc = " This callback function is part of your application. You register it with the ps3000a"]
#[doc = " driver using series RunBlock, and the driver calls it back when block-mode data is"]
#[doc = " ready. You can then download the data using series GetValues."]
#[doc = " </summary>"]
#[doc = " <param name=\"handle\">Device identifier returned by OpenUnit.</param>"]
#[doc = " <param name=\"status\">Indicates whether an error occurred during collection of the data.</param>"]
#[doc = " <param name=\"pParameter\">A void pointer passed from series RunBlock. Your callback function can write to this"]
#[doc = "  location to send any data, such as a status flag, back to your application.</param>"]
pub type ps2000aBlockReady = ::std::option::Option<
    unsafe extern "C" fn(handle: i16, status: PICO_STATUS, pParameter: *mut ::std::os::raw::c_void),
>;
#[doc = " <summary>"]
#[doc = " This callback function is part of your application. You register it with the driver using"]
#[doc = " series GetStreamingLatestValues, and the driver calls it back when streaming- mode data is"]
#[doc = " ready. You can then download the data using the series GetValuesAsync function."]
#[doc = " </summary>"]
#[doc = " <param name=\"handle\">Device identifier returned by OpenUnit.</param>"]
#[doc = " <param name=\"noOfSamples\">The number of samples available.</param>"]
#[doc = " <param name=\"startIndex\">An index to the first valid sample in the buffer. This is"]
#[doc = "  the buffer that was previously passed to series SetDataBuffer.</param>"]
#[doc = " <param name=\"overflow\">Returns a set of flags that indicate whether an overvoltage has occurred"]
#[doc = "  on any of the channels.It is a bit pattern with bit 0 denoting Channel.</param>"]
#[doc = " <param name=\"triggerAt\">An index to the buffer indicating the location of the trigger point relative"]
#[doc = "  to startIndex.This parameter is valid only when triggered is non-zero.</param>"]
#[doc = " <param name=\"triggered\">A flag indicating whether a trigger occurred. If non-zero,"]
#[doc = "  a trigger occurred at the location indicated by triggerAt.</param>"]
#[doc = " <param name=\"autoStop\">The flag that was set in the call to series RunStreaming.</param>"]
#[doc = " <param name=\"pParameter\">a void pointer passed from series GetStreamingLatestValues."]
#[doc = " The callback function can write to this locatio.</param>"]
pub type ps2000aStreamingReady = ::std::option::Option<
    unsafe extern "C" fn(
        handle: i16,
        noOfSamples: i32,
        startIndex: u32,
        overflow: i16,
        triggerAt: u32,
        triggered: i16,
        autoStop: i16,
        pParameter: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " <summary>"]
#[doc = " This is a callback function that you write to collect data from the driver. You supply a"]
#[doc = " pointer to the function when you call ps3000aGetValuesAsync, and the driver calls"]
#[doc = " your function back when the data is ready."]
#[doc = " </summary>"]
#[doc = " <param name=\"handle\">Device identifier returned by OpenUnit.</param>"]
#[doc = " <param name=\"status\">Indicates whether an error occurred during collection of the data.</param>"]
#[doc = " <param name=\"noOfSamples\">the number of samples collected.</param>"]
#[doc = " <param name=\"overflow\">A set of flags that indicates whether an overvoltage has"]
#[doc = " occurred and on which channels.It is a bit field with bit 0 representing Channel A.</param>"]
#[doc = " <param name=\"pParameter\">A void pointer passed from ps3000aGetValuesAsync. The callback function can"]
#[doc = " write to this location to send any data, such as a status flag, back to the application."]
#[doc = " The data type is defined by the application programmer.</param>"]
pub type ps2000aDataReady = ::std::option::Option<
    unsafe extern "C" fn(
        handle: i16,
        status: PICO_STATUS,
        noOfSamples: u32,
        overflow: i16,
        pParameter: *mut ::std::os::raw::c_void,
    ),
>;
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}

extern crate libloading;
pub struct PS2000ALoader {
    __library: ::libloading::Library,
    pub ps2000aApplyFix: Result<unsafe extern "C" fn(u32, u16), ::libloading::Error>,
    pub ps2000aOpenUnit: Result<
        unsafe extern "C" fn(handle: *mut i16, serial: *mut i8) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aOpenUnitAsync: Result<
        unsafe extern "C" fn(status: *mut i16, serial: *mut i8) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aOpenUnitProgress: Result<
        unsafe extern "C" fn(
            handle: *mut i16,
            progressPercent: *mut i16,
            complete: *mut i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetUnitInfo: Result<
        unsafe extern "C" fn(
            handle: i16,
            string: *mut i8,
            stringLength: i16,
            requiredSize: *mut i16,
            info: PICO_INFO,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aFlashLed:
        Result<unsafe extern "C" fn(handle: i16, start: i16) -> PICO_STATUS, ::libloading::Error>,
    pub ps2000aCloseUnit:
        Result<unsafe extern "C" fn(handle: i16) -> PICO_STATUS, ::libloading::Error>,
    pub ps2000aMemorySegments: Result<
        unsafe extern "C" fn(handle: i16, nSegments: u32, nMaxSamples: *mut i32) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetChannel: Result<
        unsafe extern "C" fn(
            handle: i16,
            channel: PS2000A_CHANNEL,
            enabled: i16,
            type_: PS2000A_COUPLING,
            range: PS2000A_RANGE,
            analogOffset: f32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetDigitalPort: Result<
        unsafe extern "C" fn(
            handle: i16,
            port: PS2000A_DIGITAL_PORT,
            enabled: i16,
            logicLevel: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetNoOfCaptures: Result<
        unsafe extern "C" fn(handle: i16, nCaptures: u32) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetTimebase: Result<
        unsafe extern "C" fn(
            handle: i16,
            timebase: u32,
            noSamples: i32,
            timeIntervalNanoseconds: *mut i32,
            oversample: i16,
            maxSamples: *mut i32,
            segmentIndex: u32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetTimebase2: Result<
        unsafe extern "C" fn(
            handle: i16,
            timebase: u32,
            noSamples: i32,
            timeIntervalNanoseconds: *mut f32,
            oversample: i16,
            maxSamples: *mut i32,
            segmentIndex: u32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetSigGenArbitrary: Result<
        unsafe extern "C" fn(
            handle: i16,
            offsetVoltage: i32,
            pkToPk: u32,
            startDeltaPhase: u32,
            stopDeltaPhase: u32,
            deltaPhaseIncrement: u32,
            dwellCount: u32,
            arbitraryWaveform: *mut i16,
            arbitraryWaveformSize: i32,
            sweepType: PS2000A_SWEEP_TYPE,
            operation: PS2000A_EXTRA_OPERATIONS,
            indexMode: PS2000A_INDEX_MODE,
            shots: u32,
            sweeps: u32,
            triggerType: PS2000A_SIGGEN_TRIG_TYPE,
            triggerSource: PS2000A_SIGGEN_TRIG_SOURCE,
            extInThreshold: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetSigGenBuiltIn: Result<
        unsafe extern "C" fn(
            handle: i16,
            offsetVoltage: i32,
            pkToPk: u32,
            waveType: i16,
            startFrequency: f32,
            stopFrequency: f32,
            increment: f32,
            dwellTime: f32,
            sweepType: PS2000A_SWEEP_TYPE,
            operation: PS2000A_EXTRA_OPERATIONS,
            shots: u32,
            sweeps: u32,
            triggerType: PS2000A_SIGGEN_TRIG_TYPE,
            triggerSource: PS2000A_SIGGEN_TRIG_SOURCE,
            extInThreshold: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetSigGenBuiltInV2: Result<
        unsafe extern "C" fn(
            handle: i16,
            offsetVoltage: i32,
            pkToPk: u32,
            waveType: i16,
            startFrequency: f64,
            stopFrequency: f64,
            increment: f64,
            dwellTime: f64,
            sweepType: PS2000A_SWEEP_TYPE,
            operation: PS2000A_EXTRA_OPERATIONS,
            shots: u32,
            sweeps: u32,
            triggerType: PS2000A_SIGGEN_TRIG_TYPE,
            triggerSource: PS2000A_SIGGEN_TRIG_SOURCE,
            extInThreshold: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetSigGenPropertiesArbitrary: Result<
        unsafe extern "C" fn(
            handle: i16,
            startDeltaPhase: u32,
            stopDeltaPhase: u32,
            deltaPhaseIncrement: u32,
            dwellCount: u32,
            sweepType: PS2000A_SWEEP_TYPE,
            shots: u32,
            sweeps: u32,
            triggerType: PS2000A_SIGGEN_TRIG_TYPE,
            triggerSource: PS2000A_SIGGEN_TRIG_SOURCE,
            extInThreshold: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetSigGenPropertiesBuiltIn: Result<
        unsafe extern "C" fn(
            handle: i16,
            startFrequency: f64,
            stopFrequency: f64,
            increment: f64,
            dwellTime: f64,
            sweepType: PS2000A_SWEEP_TYPE,
            shots: u32,
            sweeps: u32,
            triggerType: PS2000A_SIGGEN_TRIG_TYPE,
            triggerSource: PS2000A_SIGGEN_TRIG_SOURCE,
            extInThreshold: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSigGenFrequencyToPhase: Result<
        unsafe extern "C" fn(
            handle: i16,
            frequency: f64,
            indexMode: PS2000A_INDEX_MODE,
            bufferLength: u32,
            phase: *mut u32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSigGenArbitraryMinMaxValues: Result<
        unsafe extern "C" fn(
            handle: i16,
            minArbitraryWaveformValue: *mut i16,
            maxArbitraryWaveformValue: *mut i16,
            minArbitraryWaveformSize: *mut u32,
            maxArbitraryWaveformSize: *mut u32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSigGenSoftwareControl:
        Result<unsafe extern "C" fn(handle: i16, state: i16) -> PICO_STATUS, ::libloading::Error>,
    pub ps2000aSetEts: Result<
        unsafe extern "C" fn(
            handle: i16,
            mode: PS2000A_ETS_MODE,
            etsCycles: i16,
            etsInterleave: i16,
            sampleTimePicoseconds: *mut i32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetSimpleTrigger: Result<
        unsafe extern "C" fn(
            handle: i16,
            enable: i16,
            source: PS2000A_CHANNEL,
            threshold: i16,
            direction: PS2000A_THRESHOLD_DIRECTION,
            delay: u32,
            autoTrigger_ms: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetTriggerDigitalPortProperties: Result<
        unsafe extern "C" fn(
            handle: i16,
            directions: *mut PS2000A_DIGITAL_CHANNEL_DIRECTIONS,
            nDirections: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetDigitalAnalogTriggerOperand: Result<
        unsafe extern "C" fn(handle: i16, operand: PS2000A_TRIGGER_OPERAND) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetPulseWidthDigitalPortProperties: Result<
        unsafe extern "C" fn(
            handle: i16,
            directions: *mut PS2000A_DIGITAL_CHANNEL_DIRECTIONS,
            nDirections: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetTriggerChannelProperties: Result<
        unsafe extern "C" fn(
            handle: i16,
            channelProperties: *mut PS2000A_TRIGGER_CHANNEL_PROPERTIES,
            nChannelProperties: i16,
            auxOutputEnable: i16,
            autoTriggerMilliseconds: i32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetTriggerChannelConditions: Result<
        unsafe extern "C" fn(
            handle: i16,
            conditions: *mut PS2000A_TRIGGER_CONDITIONS,
            nConditions: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetTriggerChannelDirections: Result<
        unsafe extern "C" fn(
            handle: i16,
            channelA: PS2000A_THRESHOLD_DIRECTION,
            channelB: PS2000A_THRESHOLD_DIRECTION,
            channelC: PS2000A_THRESHOLD_DIRECTION,
            channelD: PS2000A_THRESHOLD_DIRECTION,
            ext: PS2000A_THRESHOLD_DIRECTION,
            aux: PS2000A_THRESHOLD_DIRECTION,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetTriggerDelay:
        Result<unsafe extern "C" fn(handle: i16, delay: u32) -> PICO_STATUS, ::libloading::Error>,
    pub ps2000aSetPulseWidthQualifier: Result<
        unsafe extern "C" fn(
            handle: i16,
            conditions: *mut PS2000A_PWQ_CONDITIONS,
            nConditions: i16,
            direction: PS2000A_THRESHOLD_DIRECTION,
            lower: u32,
            upper: u32,
            type_: PS2000A_PULSE_WIDTH_TYPE,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aIsTriggerOrPulseWidthQualifierEnabled: Result<
        unsafe extern "C" fn(
            handle: i16,
            triggerEnabled: *mut i16,
            pulseWidthQualifierEnabled: *mut i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetTriggerTimeOffset: Result<
        unsafe extern "C" fn(
            handle: i16,
            timeUpper: *mut u32,
            timeLower: *mut u32,
            timeUnits: *mut PS2000A_TIME_UNITS,
            segmentIndex: u32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetTriggerTimeOffset64: Result<
        unsafe extern "C" fn(
            handle: i16,
            time: *mut i64,
            timeUnits: *mut PS2000A_TIME_UNITS,
            segmentIndex: u32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetValuesTriggerTimeOffsetBulk: Result<
        unsafe extern "C" fn(
            handle: i16,
            timesUpper: *mut u32,
            timesLower: *mut u32,
            timeUnits: *mut PS2000A_TIME_UNITS,
            fromSegmentIndex: u32,
            toSegmentIndex: u32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetValuesTriggerTimeOffsetBulk64: Result<
        unsafe extern "C" fn(
            handle: i16,
            times: *mut i64,
            timeUnits: *mut PS2000A_TIME_UNITS,
            fromSegmentIndex: u32,
            toSegmentIndex: u32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetNoOfCaptures: Result<
        unsafe extern "C" fn(handle: i16, nCaptures: *mut u32) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetNoOfProcessedCaptures: Result<
        unsafe extern "C" fn(handle: i16, nProcessedCaptures: *mut u32) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetDataBuffer: Result<
        unsafe extern "C" fn(
            handle: i16,
            channelOrPort: i32,
            buffer: *mut i16,
            bufferLth: i32,
            segmentIndex: u32,
            mode: PS2000A_RATIO_MODE,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetDataBuffers: Result<
        unsafe extern "C" fn(
            handle: i16,
            channelOrPort: i32,
            bufferMax: *mut i16,
            bufferMin: *mut i16,
            bufferLth: i32,
            segmentIndex: u32,
            mode: PS2000A_RATIO_MODE,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetUnscaledDataBuffers: Result<
        unsafe extern "C" fn(
            handle: i16,
            channelOrPort: PS2000A_CHANNEL,
            bufferMax: *mut i8,
            bufferMin: *mut i8,
            bufferLth: i32,
            segmentIndex: u32,
            mode: PS2000A_RATIO_MODE,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetEtsTimeBuffer: Result<
        unsafe extern "C" fn(handle: i16, buffer: *mut i64, bufferLth: i32) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetEtsTimeBuffers: Result<
        unsafe extern "C" fn(
            handle: i16,
            timeUpper: *mut u32,
            timeLower: *mut u32,
            bufferLth: i32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aIsReady: Result<
        unsafe extern "C" fn(handle: i16, ready: *mut i16) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aRunBlock: Result<
        unsafe extern "C" fn(
            handle: i16,
            noOfPreTriggerSamples: i32,
            noOfPostTriggerSamples: i32,
            timebase: u32,
            oversample: i16,
            timeIndisposedMs: *mut i32,
            segmentIndex: u32,
            lpReady: ps2000aBlockReady,
            pParameter: *mut ::std::os::raw::c_void,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aRunStreaming: Result<
        unsafe extern "C" fn(
            handle: i16,
            sampleInterval: *mut u32,
            sampleIntervalTimeUnits: PS2000A_TIME_UNITS,
            maxPreTriggerSamples: u32,
            maxPostPreTriggerSamples: u32,
            autoStop: i16,
            downSampleRatio: u32,
            downSampleRatioMode: PS2000A_RATIO_MODE,
            overviewBufferSize: u32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetStreamingLatestValues: Result<
        unsafe extern "C" fn(
            handle: i16,
            lpPs2000aReady: ps2000aStreamingReady,
            pParameter: *mut ::std::os::raw::c_void,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aNoOfStreamingValues: Result<
        unsafe extern "C" fn(handle: i16, noOfValues: *mut u32) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetMaxDownSampleRatio: Result<
        unsafe extern "C" fn(
            handle: i16,
            noOfUnaggreatedSamples: u32,
            maxDownSampleRatio: *mut u32,
            downSampleRatioMode: PS2000A_RATIO_MODE,
            segmentIndex: u32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetValues: Result<
        unsafe extern "C" fn(
            handle: i16,
            startIndex: u32,
            noOfSamples: *mut u32,
            downSampleRatio: u32,
            downSampleRatioMode: PS2000A_RATIO_MODE,
            segmentIndex: u32,
            overflow: *mut i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetValuesBulk: Result<
        unsafe extern "C" fn(
            handle: i16,
            noOfSamples: *mut u32,
            fromSegmentIndex: u32,
            toSegmentIndex: u32,
            downSampleRatio: u32,
            downSampleRatioMode: PS2000A_RATIO_MODE,
            overflow: *mut i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetValuesAsync: Result<
        unsafe extern "C" fn(
            handle: i16,
            startIndex: u32,
            noOfSamples: u32,
            downSampleRatio: u32,
            downSampleRatioMode: PS2000A_RATIO_MODE,
            segmentIndex: u32,
            lpDataReady: *mut ::std::os::raw::c_void,
            pParameter: *mut ::std::os::raw::c_void,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetValuesOverlapped: Result<
        unsafe extern "C" fn(
            handle: i16,
            startIndex: u32,
            noOfSamples: *mut u32,
            downSampleRatio: u32,
            downSampleRatioMode: PS2000A_RATIO_MODE,
            segmentIndex: u32,
            overflow: *mut i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetValuesOverlappedBulk: Result<
        unsafe extern "C" fn(
            handle: i16,
            startIndex: u32,
            noOfSamples: *mut u32,
            downSampleRatio: u32,
            downSampleRatioMode: PS2000A_RATIO_MODE,
            fromSegmentIndex: u32,
            toSegmentIndex: u32,
            overflow: *mut i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aStop: Result<unsafe extern "C" fn(handle: i16) -> PICO_STATUS, ::libloading::Error>,
    pub ps2000aHoldOff: Result<
        unsafe extern "C" fn(handle: i16, holdoff: u64, type_: PS2000A_HOLDOFF_TYPE) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetChannelInformation: Result<
        unsafe extern "C" fn(
            handle: i16,
            info: PS2000A_CHANNEL_INFO,
            probe: i32,
            ranges: *mut i32,
            length: *mut i32,
            channels: i32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aEnumerateUnits: Result<
        unsafe extern "C" fn(count: *mut i16, serials: *mut i8, serialLth: *mut i16) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aPingUnit:
        Result<unsafe extern "C" fn(handle: i16) -> PICO_STATUS, ::libloading::Error>,
    pub ps2000aMaximumValue: Result<
        unsafe extern "C" fn(handle: i16, value: *mut i16) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aMinimumValue: Result<
        unsafe extern "C" fn(handle: i16, value: *mut i16) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetAnalogueOffset: Result<
        unsafe extern "C" fn(
            handle: i16,
            range: PS2000A_RANGE,
            coupling: PS2000A_COUPLING,
            maximumVoltage: *mut f32,
            minimumVoltage: *mut f32,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aGetMaxSegments: Result<
        unsafe extern "C" fn(handle: i16, maxSegments: *mut u32) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aQueryOutputEdgeDetect: Result<
        unsafe extern "C" fn(handle: i16, state: *mut i16) -> PICO_STATUS,
        ::libloading::Error,
    >,
    pub ps2000aSetOutputEdgeDetect:
        Result<unsafe extern "C" fn(handle: i16, state: i16) -> PICO_STATUS, ::libloading::Error>,
    pub ps2000aGetScalingValues: Result<
        unsafe extern "C" fn(
            handle: i16,
            scalingValues: *mut PS2000A_SCALING_FACTORS_VALUES,
            nChannels: i16,
        ) -> PICO_STATUS,
        ::libloading::Error,
    >,
}
impl PS2000ALoader {
    pub unsafe fn new<P>(path: P) -> Result<Self, ::libloading::Error>
    where
        P: AsRef<::std::ffi::OsStr>,
    {
        let __library = ::libloading::Library::new(path)?;
        let ps2000aApplyFix = __library.get(b"ps2000aApplyFix\0").map(|sym| *sym);
        let ps2000aOpenUnit = __library.get(b"ps2000aOpenUnit\0").map(|sym| *sym);
        let ps2000aOpenUnitAsync = __library.get(b"ps2000aOpenUnitAsync\0").map(|sym| *sym);
        let ps2000aOpenUnitProgress = __library.get(b"ps2000aOpenUnitProgress\0").map(|sym| *sym);
        let ps2000aGetUnitInfo = __library.get(b"ps2000aGetUnitInfo\0").map(|sym| *sym);
        let ps2000aFlashLed = __library.get(b"ps2000aFlashLed\0").map(|sym| *sym);
        let ps2000aCloseUnit = __library.get(b"ps2000aCloseUnit\0").map(|sym| *sym);
        let ps2000aMemorySegments = __library.get(b"ps2000aMemorySegments\0").map(|sym| *sym);
        let ps2000aSetChannel = __library.get(b"ps2000aSetChannel\0").map(|sym| *sym);
        let ps2000aSetDigitalPort = __library.get(b"ps2000aSetDigitalPort\0").map(|sym| *sym);
        let ps2000aSetNoOfCaptures = __library.get(b"ps2000aSetNoOfCaptures\0").map(|sym| *sym);
        let ps2000aGetTimebase = __library.get(b"ps2000aGetTimebase\0").map(|sym| *sym);
        let ps2000aGetTimebase2 = __library.get(b"ps2000aGetTimebase2\0").map(|sym| *sym);
        let ps2000aSetSigGenArbitrary = __library
            .get(b"ps2000aSetSigGenArbitrary\0")
            .map(|sym| *sym);
        let ps2000aSetSigGenBuiltIn = __library.get(b"ps2000aSetSigGenBuiltIn\0").map(|sym| *sym);
        let ps2000aSetSigGenBuiltInV2 = __library
            .get(b"ps2000aSetSigGenBuiltInV2\0")
            .map(|sym| *sym);
        let ps2000aSetSigGenPropertiesArbitrary = __library
            .get(b"ps2000aSetSigGenPropertiesArbitrary\0")
            .map(|sym| *sym);
        let ps2000aSetSigGenPropertiesBuiltIn = __library
            .get(b"ps2000aSetSigGenPropertiesBuiltIn\0")
            .map(|sym| *sym);
        let ps2000aSigGenFrequencyToPhase = __library
            .get(b"ps2000aSigGenFrequencyToPhase\0")
            .map(|sym| *sym);
        let ps2000aSigGenArbitraryMinMaxValues = __library
            .get(b"ps2000aSigGenArbitraryMinMaxValues\0")
            .map(|sym| *sym);
        let ps2000aSigGenSoftwareControl = __library
            .get(b"ps2000aSigGenSoftwareControl\0")
            .map(|sym| *sym);
        let ps2000aSetEts = __library.get(b"ps2000aSetEts\0").map(|sym| *sym);
        let ps2000aSetSimpleTrigger = __library.get(b"ps2000aSetSimpleTrigger\0").map(|sym| *sym);
        let ps2000aSetTriggerDigitalPortProperties = __library
            .get(b"ps2000aSetTriggerDigitalPortProperties\0")
            .map(|sym| *sym);
        let ps2000aSetDigitalAnalogTriggerOperand = __library
            .get(b"ps2000aSetDigitalAnalogTriggerOperand\0")
            .map(|sym| *sym);
        let ps2000aSetPulseWidthDigitalPortProperties = __library
            .get(b"ps2000aSetPulseWidthDigitalPortProperties\0")
            .map(|sym| *sym);
        let ps2000aSetTriggerChannelProperties = __library
            .get(b"ps2000aSetTriggerChannelProperties\0")
            .map(|sym| *sym);
        let ps2000aSetTriggerChannelConditions = __library
            .get(b"ps2000aSetTriggerChannelConditions\0")
            .map(|sym| *sym);
        let ps2000aSetTriggerChannelDirections = __library
            .get(b"ps2000aSetTriggerChannelDirections\0")
            .map(|sym| *sym);
        let ps2000aSetTriggerDelay = __library.get(b"ps2000aSetTriggerDelay\0").map(|sym| *sym);
        let ps2000aSetPulseWidthQualifier = __library
            .get(b"ps2000aSetPulseWidthQualifier\0")
            .map(|sym| *sym);
        let ps2000aIsTriggerOrPulseWidthQualifierEnabled = __library
            .get(b"ps2000aIsTriggerOrPulseWidthQualifierEnabled\0")
            .map(|sym| *sym);
        let ps2000aGetTriggerTimeOffset = __library
            .get(b"ps2000aGetTriggerTimeOffset\0")
            .map(|sym| *sym);
        let ps2000aGetTriggerTimeOffset64 = __library
            .get(b"ps2000aGetTriggerTimeOffset64\0")
            .map(|sym| *sym);
        let ps2000aGetValuesTriggerTimeOffsetBulk = __library
            .get(b"ps2000aGetValuesTriggerTimeOffsetBulk\0")
            .map(|sym| *sym);
        let ps2000aGetValuesTriggerTimeOffsetBulk64 = __library
            .get(b"ps2000aGetValuesTriggerTimeOffsetBulk64\0")
            .map(|sym| *sym);
        let ps2000aGetNoOfCaptures = __library.get(b"ps2000aGetNoOfCaptures\0").map(|sym| *sym);
        let ps2000aGetNoOfProcessedCaptures = __library
            .get(b"ps2000aGetNoOfProcessedCaptures\0")
            .map(|sym| *sym);
        let ps2000aSetDataBuffer = __library.get(b"ps2000aSetDataBuffer\0").map(|sym| *sym);
        let ps2000aSetDataBuffers = __library.get(b"ps2000aSetDataBuffers\0").map(|sym| *sym);
        let ps2000aSetUnscaledDataBuffers = __library
            .get(b"ps2000aSetUnscaledDataBuffers\0")
            .map(|sym| *sym);
        let ps2000aSetEtsTimeBuffer = __library.get(b"ps2000aSetEtsTimeBuffer\0").map(|sym| *sym);
        let ps2000aSetEtsTimeBuffers = __library.get(b"ps2000aSetEtsTimeBuffers\0").map(|sym| *sym);
        let ps2000aIsReady = __library.get(b"ps2000aIsReady\0").map(|sym| *sym);
        let ps2000aRunBlock = __library.get(b"ps2000aRunBlock\0").map(|sym| *sym);
        let ps2000aRunStreaming = __library.get(b"ps2000aRunStreaming\0").map(|sym| *sym);
        let ps2000aGetStreamingLatestValues = __library
            .get(b"ps2000aGetStreamingLatestValues\0")
            .map(|sym| *sym);
        let ps2000aNoOfStreamingValues = __library
            .get(b"ps2000aNoOfStreamingValues\0")
            .map(|sym| *sym);
        let ps2000aGetMaxDownSampleRatio = __library
            .get(b"ps2000aGetMaxDownSampleRatio\0")
            .map(|sym| *sym);
        let ps2000aGetValues = __library.get(b"ps2000aGetValues\0").map(|sym| *sym);
        let ps2000aGetValuesBulk = __library.get(b"ps2000aGetValuesBulk\0").map(|sym| *sym);
        let ps2000aGetValuesAsync = __library.get(b"ps2000aGetValuesAsync\0").map(|sym| *sym);
        let ps2000aGetValuesOverlapped = __library
            .get(b"ps2000aGetValuesOverlapped\0")
            .map(|sym| *sym);
        let ps2000aGetValuesOverlappedBulk = __library
            .get(b"ps2000aGetValuesOverlappedBulk\0")
            .map(|sym| *sym);
        let ps2000aStop = __library.get(b"ps2000aStop\0").map(|sym| *sym);
        let ps2000aHoldOff = __library.get(b"ps2000aHoldOff\0").map(|sym| *sym);
        let ps2000aGetChannelInformation = __library
            .get(b"ps2000aGetChannelInformation\0")
            .map(|sym| *sym);
        let ps2000aEnumerateUnits = __library.get(b"ps2000aEnumerateUnits\0").map(|sym| *sym);
        let ps2000aPingUnit = __library.get(b"ps2000aPingUnit\0").map(|sym| *sym);
        let ps2000aMaximumValue = __library.get(b"ps2000aMaximumValue\0").map(|sym| *sym);
        let ps2000aMinimumValue = __library.get(b"ps2000aMinimumValue\0").map(|sym| *sym);
        let ps2000aGetAnalogueOffset = __library.get(b"ps2000aGetAnalogueOffset\0").map(|sym| *sym);
        let ps2000aGetMaxSegments = __library.get(b"ps2000aGetMaxSegments\0").map(|sym| *sym);
        let ps2000aQueryOutputEdgeDetect = __library
            .get(b"ps2000aQueryOutputEdgeDetect\0")
            .map(|sym| *sym);
        let ps2000aSetOutputEdgeDetect = __library
            .get(b"ps2000aSetOutputEdgeDetect\0")
            .map(|sym| *sym);
        let ps2000aGetScalingValues = __library.get(b"ps2000aGetScalingValues\0").map(|sym| *sym);
        Ok(PS2000ALoader {
            __library,
            ps2000aApplyFix,
            ps2000aOpenUnit,
            ps2000aOpenUnitAsync,
            ps2000aOpenUnitProgress,
            ps2000aGetUnitInfo,
            ps2000aFlashLed,
            ps2000aCloseUnit,
            ps2000aMemorySegments,
            ps2000aSetChannel,
            ps2000aSetDigitalPort,
            ps2000aSetNoOfCaptures,
            ps2000aGetTimebase,
            ps2000aGetTimebase2,
            ps2000aSetSigGenArbitrary,
            ps2000aSetSigGenBuiltIn,
            ps2000aSetSigGenBuiltInV2,
            ps2000aSetSigGenPropertiesArbitrary,
            ps2000aSetSigGenPropertiesBuiltIn,
            ps2000aSigGenFrequencyToPhase,
            ps2000aSigGenArbitraryMinMaxValues,
            ps2000aSigGenSoftwareControl,
            ps2000aSetEts,
            ps2000aSetSimpleTrigger,
            ps2000aSetTriggerDigitalPortProperties,
            ps2000aSetDigitalAnalogTriggerOperand,
            ps2000aSetPulseWidthDigitalPortProperties,
            ps2000aSetTriggerChannelProperties,
            ps2000aSetTriggerChannelConditions,
            ps2000aSetTriggerChannelDirections,
            ps2000aSetTriggerDelay,
            ps2000aSetPulseWidthQualifier,
            ps2000aIsTriggerOrPulseWidthQualifierEnabled,
            ps2000aGetTriggerTimeOffset,
            ps2000aGetTriggerTimeOffset64,
            ps2000aGetValuesTriggerTimeOffsetBulk,
            ps2000aGetValuesTriggerTimeOffsetBulk64,
            ps2000aGetNoOfCaptures,
            ps2000aGetNoOfProcessedCaptures,
            ps2000aSetDataBuffer,
            ps2000aSetDataBuffers,
            ps2000aSetUnscaledDataBuffers,
            ps2000aSetEtsTimeBuffer,
            ps2000aSetEtsTimeBuffers,
            ps2000aIsReady,
            ps2000aRunBlock,
            ps2000aRunStreaming,
            ps2000aGetStreamingLatestValues,
            ps2000aNoOfStreamingValues,
            ps2000aGetMaxDownSampleRatio,
            ps2000aGetValues,
            ps2000aGetValuesBulk,
            ps2000aGetValuesAsync,
            ps2000aGetValuesOverlapped,
            ps2000aGetValuesOverlappedBulk,
            ps2000aStop,
            ps2000aHoldOff,
            ps2000aGetChannelInformation,
            ps2000aEnumerateUnits,
            ps2000aPingUnit,
            ps2000aMaximumValue,
            ps2000aMinimumValue,
            ps2000aGetAnalogueOffset,
            ps2000aGetMaxSegments,
            ps2000aQueryOutputEdgeDetect,
            ps2000aSetOutputEdgeDetect,
            ps2000aGetScalingValues,
        })
    }
    pub unsafe fn ps2000aApplyFix(&self, a: u32, b: u16) {
        let sym = self
            .ps2000aApplyFix
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(a, b)
    }
    pub unsafe fn ps2000aOpenUnit(&self, handle: *mut i16, serial: *mut i8) -> PICO_STATUS {
        let sym = self
            .ps2000aOpenUnit
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, serial)
    }
    pub unsafe fn ps2000aOpenUnitAsync(&self, status: *mut i16, serial: *mut i8) -> PICO_STATUS {
        let sym = self
            .ps2000aOpenUnitAsync
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(status, serial)
    }
    pub unsafe fn ps2000aOpenUnitProgress(
        &self,
        handle: *mut i16,
        progressPercent: *mut i16,
        complete: *mut i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aOpenUnitProgress
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, progressPercent, complete)
    }
    pub unsafe fn ps2000aGetUnitInfo(
        &self,
        handle: i16,
        string: *mut i8,
        stringLength: i16,
        requiredSize: *mut i16,
        info: PICO_INFO,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetUnitInfo
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, string, stringLength, requiredSize, info)
    }
    pub unsafe fn ps2000aFlashLed(&self, handle: i16, start: i16) -> PICO_STATUS {
        let sym = self
            .ps2000aFlashLed
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, start)
    }
    pub unsafe fn ps2000aCloseUnit(&self, handle: i16) -> PICO_STATUS {
        let sym = self
            .ps2000aCloseUnit
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle)
    }
    pub unsafe fn ps2000aMemorySegments(
        &self,
        handle: i16,
        nSegments: u32,
        nMaxSamples: *mut i32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aMemorySegments
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, nSegments, nMaxSamples)
    }
    pub unsafe fn ps2000aSetChannel(
        &self,
        handle: i16,
        channel: PS2000A_CHANNEL,
        enabled: i16,
        type_: PS2000A_COUPLING,
        range: PS2000A_RANGE,
        analogOffset: f32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetChannel
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, channel, enabled, type_, range, analogOffset)
    }
    pub unsafe fn ps2000aSetDigitalPort(
        &self,
        handle: i16,
        port: PS2000A_DIGITAL_PORT,
        enabled: i16,
        logicLevel: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetDigitalPort
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, port, enabled, logicLevel)
    }
    pub unsafe fn ps2000aSetNoOfCaptures(&self, handle: i16, nCaptures: u32) -> PICO_STATUS {
        let sym = self
            .ps2000aSetNoOfCaptures
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, nCaptures)
    }
    pub unsafe fn ps2000aGetTimebase(
        &self,
        handle: i16,
        timebase: u32,
        noSamples: i32,
        timeIntervalNanoseconds: *mut i32,
        oversample: i16,
        maxSamples: *mut i32,
        segmentIndex: u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetTimebase
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            timebase,
            noSamples,
            timeIntervalNanoseconds,
            oversample,
            maxSamples,
            segmentIndex,
        )
    }
    pub unsafe fn ps2000aGetTimebase2(
        &self,
        handle: i16,
        timebase: u32,
        noSamples: i32,
        timeIntervalNanoseconds: *mut f32,
        oversample: i16,
        maxSamples: *mut i32,
        segmentIndex: u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetTimebase2
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            timebase,
            noSamples,
            timeIntervalNanoseconds,
            oversample,
            maxSamples,
            segmentIndex,
        )
    }
    pub unsafe fn ps2000aSetSigGenArbitrary(
        &self,
        handle: i16,
        offsetVoltage: i32,
        pkToPk: u32,
        startDeltaPhase: u32,
        stopDeltaPhase: u32,
        deltaPhaseIncrement: u32,
        dwellCount: u32,
        arbitraryWaveform: *mut i16,
        arbitraryWaveformSize: i32,
        sweepType: PS2000A_SWEEP_TYPE,
        operation: PS2000A_EXTRA_OPERATIONS,
        indexMode: PS2000A_INDEX_MODE,
        shots: u32,
        sweeps: u32,
        triggerType: PS2000A_SIGGEN_TRIG_TYPE,
        triggerSource: PS2000A_SIGGEN_TRIG_SOURCE,
        extInThreshold: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetSigGenArbitrary
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            offsetVoltage,
            pkToPk,
            startDeltaPhase,
            stopDeltaPhase,
            deltaPhaseIncrement,
            dwellCount,
            arbitraryWaveform,
            arbitraryWaveformSize,
            sweepType,
            operation,
            indexMode,
            shots,
            sweeps,
            triggerType,
            triggerSource,
            extInThreshold,
        )
    }
    pub unsafe fn ps2000aSetSigGenBuiltIn(
        &self,
        handle: i16,
        offsetVoltage: i32,
        pkToPk: u32,
        waveType: i16,
        startFrequency: f32,
        stopFrequency: f32,
        increment: f32,
        dwellTime: f32,
        sweepType: PS2000A_SWEEP_TYPE,
        operation: PS2000A_EXTRA_OPERATIONS,
        shots: u32,
        sweeps: u32,
        triggerType: PS2000A_SIGGEN_TRIG_TYPE,
        triggerSource: PS2000A_SIGGEN_TRIG_SOURCE,
        extInThreshold: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetSigGenBuiltIn
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            offsetVoltage,
            pkToPk,
            waveType,
            startFrequency,
            stopFrequency,
            increment,
            dwellTime,
            sweepType,
            operation,
            shots,
            sweeps,
            triggerType,
            triggerSource,
            extInThreshold,
        )
    }
    pub unsafe fn ps2000aSetSigGenBuiltInV2(
        &self,
        handle: i16,
        offsetVoltage: i32,
        pkToPk: u32,
        waveType: i16,
        startFrequency: f64,
        stopFrequency: f64,
        increment: f64,
        dwellTime: f64,
        sweepType: PS2000A_SWEEP_TYPE,
        operation: PS2000A_EXTRA_OPERATIONS,
        shots: u32,
        sweeps: u32,
        triggerType: PS2000A_SIGGEN_TRIG_TYPE,
        triggerSource: PS2000A_SIGGEN_TRIG_SOURCE,
        extInThreshold: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetSigGenBuiltInV2
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            offsetVoltage,
            pkToPk,
            waveType,
            startFrequency,
            stopFrequency,
            increment,
            dwellTime,
            sweepType,
            operation,
            shots,
            sweeps,
            triggerType,
            triggerSource,
            extInThreshold,
        )
    }
    pub unsafe fn ps2000aSetSigGenPropertiesArbitrary(
        &self,
        handle: i16,
        startDeltaPhase: u32,
        stopDeltaPhase: u32,
        deltaPhaseIncrement: u32,
        dwellCount: u32,
        sweepType: PS2000A_SWEEP_TYPE,
        shots: u32,
        sweeps: u32,
        triggerType: PS2000A_SIGGEN_TRIG_TYPE,
        triggerSource: PS2000A_SIGGEN_TRIG_SOURCE,
        extInThreshold: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetSigGenPropertiesArbitrary
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            startDeltaPhase,
            stopDeltaPhase,
            deltaPhaseIncrement,
            dwellCount,
            sweepType,
            shots,
            sweeps,
            triggerType,
            triggerSource,
            extInThreshold,
        )
    }
    pub unsafe fn ps2000aSetSigGenPropertiesBuiltIn(
        &self,
        handle: i16,
        startFrequency: f64,
        stopFrequency: f64,
        increment: f64,
        dwellTime: f64,
        sweepType: PS2000A_SWEEP_TYPE,
        shots: u32,
        sweeps: u32,
        triggerType: PS2000A_SIGGEN_TRIG_TYPE,
        triggerSource: PS2000A_SIGGEN_TRIG_SOURCE,
        extInThreshold: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetSigGenPropertiesBuiltIn
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            startFrequency,
            stopFrequency,
            increment,
            dwellTime,
            sweepType,
            shots,
            sweeps,
            triggerType,
            triggerSource,
            extInThreshold,
        )
    }
    pub unsafe fn ps2000aSigGenFrequencyToPhase(
        &self,
        handle: i16,
        frequency: f64,
        indexMode: PS2000A_INDEX_MODE,
        bufferLength: u32,
        phase: *mut u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSigGenFrequencyToPhase
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, frequency, indexMode, bufferLength, phase)
    }
    pub unsafe fn ps2000aSigGenArbitraryMinMaxValues(
        &self,
        handle: i16,
        minArbitraryWaveformValue: *mut i16,
        maxArbitraryWaveformValue: *mut i16,
        minArbitraryWaveformSize: *mut u32,
        maxArbitraryWaveformSize: *mut u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSigGenArbitraryMinMaxValues
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            minArbitraryWaveformValue,
            maxArbitraryWaveformValue,
            minArbitraryWaveformSize,
            maxArbitraryWaveformSize,
        )
    }
    pub unsafe fn ps2000aSigGenSoftwareControl(&self, handle: i16, state: i16) -> PICO_STATUS {
        let sym = self
            .ps2000aSigGenSoftwareControl
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, state)
    }
    pub unsafe fn ps2000aSetEts(
        &self,
        handle: i16,
        mode: PS2000A_ETS_MODE,
        etsCycles: i16,
        etsInterleave: i16,
        sampleTimePicoseconds: *mut i32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetEts
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            mode,
            etsCycles,
            etsInterleave,
            sampleTimePicoseconds,
        )
    }
    pub unsafe fn ps2000aSetSimpleTrigger(
        &self,
        handle: i16,
        enable: i16,
        source: PS2000A_CHANNEL,
        threshold: i16,
        direction: PS2000A_THRESHOLD_DIRECTION,
        delay: u32,
        autoTrigger_ms: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetSimpleTrigger
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            enable,
            source,
            threshold,
            direction,
            delay,
            autoTrigger_ms,
        )
    }
    pub unsafe fn ps2000aSetTriggerDigitalPortProperties(
        &self,
        handle: i16,
        directions: *mut PS2000A_DIGITAL_CHANNEL_DIRECTIONS,
        nDirections: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetTriggerDigitalPortProperties
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, directions, nDirections)
    }
    pub unsafe fn ps2000aSetDigitalAnalogTriggerOperand(
        &self,
        handle: i16,
        operand: PS2000A_TRIGGER_OPERAND,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetDigitalAnalogTriggerOperand
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, operand)
    }
    pub unsafe fn ps2000aSetPulseWidthDigitalPortProperties(
        &self,
        handle: i16,
        directions: *mut PS2000A_DIGITAL_CHANNEL_DIRECTIONS,
        nDirections: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetPulseWidthDigitalPortProperties
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, directions, nDirections)
    }
    pub unsafe fn ps2000aSetTriggerChannelProperties(
        &self,
        handle: i16,
        channelProperties: *mut PS2000A_TRIGGER_CHANNEL_PROPERTIES,
        nChannelProperties: i16,
        auxOutputEnable: i16,
        autoTriggerMilliseconds: i32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetTriggerChannelProperties
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            channelProperties,
            nChannelProperties,
            auxOutputEnable,
            autoTriggerMilliseconds,
        )
    }
    pub unsafe fn ps2000aSetTriggerChannelConditions(
        &self,
        handle: i16,
        conditions: *mut PS2000A_TRIGGER_CONDITIONS,
        nConditions: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetTriggerChannelConditions
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, conditions, nConditions)
    }
    pub unsafe fn ps2000aSetTriggerChannelDirections(
        &self,
        handle: i16,
        channelA: PS2000A_THRESHOLD_DIRECTION,
        channelB: PS2000A_THRESHOLD_DIRECTION,
        channelC: PS2000A_THRESHOLD_DIRECTION,
        channelD: PS2000A_THRESHOLD_DIRECTION,
        ext: PS2000A_THRESHOLD_DIRECTION,
        aux: PS2000A_THRESHOLD_DIRECTION,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetTriggerChannelDirections
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, channelA, channelB, channelC, channelD, ext, aux)
    }
    pub unsafe fn ps2000aSetTriggerDelay(&self, handle: i16, delay: u32) -> PICO_STATUS {
        let sym = self
            .ps2000aSetTriggerDelay
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, delay)
    }
    pub unsafe fn ps2000aSetPulseWidthQualifier(
        &self,
        handle: i16,
        conditions: *mut PS2000A_PWQ_CONDITIONS,
        nConditions: i16,
        direction: PS2000A_THRESHOLD_DIRECTION,
        lower: u32,
        upper: u32,
        type_: PS2000A_PULSE_WIDTH_TYPE,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetPulseWidthQualifier
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            conditions,
            nConditions,
            direction,
            lower,
            upper,
            type_,
        )
    }
    pub unsafe fn ps2000aIsTriggerOrPulseWidthQualifierEnabled(
        &self,
        handle: i16,
        triggerEnabled: *mut i16,
        pulseWidthQualifierEnabled: *mut i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aIsTriggerOrPulseWidthQualifierEnabled
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, triggerEnabled, pulseWidthQualifierEnabled)
    }
    pub unsafe fn ps2000aGetTriggerTimeOffset(
        &self,
        handle: i16,
        timeUpper: *mut u32,
        timeLower: *mut u32,
        timeUnits: *mut PS2000A_TIME_UNITS,
        segmentIndex: u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetTriggerTimeOffset
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, timeUpper, timeLower, timeUnits, segmentIndex)
    }
    pub unsafe fn ps2000aGetTriggerTimeOffset64(
        &self,
        handle: i16,
        time: *mut i64,
        timeUnits: *mut PS2000A_TIME_UNITS,
        segmentIndex: u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetTriggerTimeOffset64
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, time, timeUnits, segmentIndex)
    }
    pub unsafe fn ps2000aGetValuesTriggerTimeOffsetBulk(
        &self,
        handle: i16,
        timesUpper: *mut u32,
        timesLower: *mut u32,
        timeUnits: *mut PS2000A_TIME_UNITS,
        fromSegmentIndex: u32,
        toSegmentIndex: u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetValuesTriggerTimeOffsetBulk
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            timesUpper,
            timesLower,
            timeUnits,
            fromSegmentIndex,
            toSegmentIndex,
        )
    }
    pub unsafe fn ps2000aGetValuesTriggerTimeOffsetBulk64(
        &self,
        handle: i16,
        times: *mut i64,
        timeUnits: *mut PS2000A_TIME_UNITS,
        fromSegmentIndex: u32,
        toSegmentIndex: u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetValuesTriggerTimeOffsetBulk64
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, times, timeUnits, fromSegmentIndex, toSegmentIndex)
    }
    pub unsafe fn ps2000aGetNoOfCaptures(&self, handle: i16, nCaptures: *mut u32) -> PICO_STATUS {
        let sym = self
            .ps2000aGetNoOfCaptures
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, nCaptures)
    }
    pub unsafe fn ps2000aGetNoOfProcessedCaptures(
        &self,
        handle: i16,
        nProcessedCaptures: *mut u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetNoOfProcessedCaptures
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, nProcessedCaptures)
    }
    pub unsafe fn ps2000aSetDataBuffer(
        &self,
        handle: i16,
        channelOrPort: i32,
        buffer: *mut i16,
        bufferLth: i32,
        segmentIndex: u32,
        mode: PS2000A_RATIO_MODE,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetDataBuffer
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, channelOrPort, buffer, bufferLth, segmentIndex, mode)
    }
    pub unsafe fn ps2000aSetDataBuffers(
        &self,
        handle: i16,
        channelOrPort: i32,
        bufferMax: *mut i16,
        bufferMin: *mut i16,
        bufferLth: i32,
        segmentIndex: u32,
        mode: PS2000A_RATIO_MODE,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetDataBuffers
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            channelOrPort,
            bufferMax,
            bufferMin,
            bufferLth,
            segmentIndex,
            mode,
        )
    }
    pub unsafe fn ps2000aSetUnscaledDataBuffers(
        &self,
        handle: i16,
        channelOrPort: PS2000A_CHANNEL,
        bufferMax: *mut i8,
        bufferMin: *mut i8,
        bufferLth: i32,
        segmentIndex: u32,
        mode: PS2000A_RATIO_MODE,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetUnscaledDataBuffers
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            channelOrPort,
            bufferMax,
            bufferMin,
            bufferLth,
            segmentIndex,
            mode,
        )
    }
    pub unsafe fn ps2000aSetEtsTimeBuffer(
        &self,
        handle: i16,
        buffer: *mut i64,
        bufferLth: i32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetEtsTimeBuffer
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, buffer, bufferLth)
    }
    pub unsafe fn ps2000aSetEtsTimeBuffers(
        &self,
        handle: i16,
        timeUpper: *mut u32,
        timeLower: *mut u32,
        bufferLth: i32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aSetEtsTimeBuffers
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, timeUpper, timeLower, bufferLth)
    }
    pub unsafe fn ps2000aIsReady(&self, handle: i16, ready: *mut i16) -> PICO_STATUS {
        let sym = self
            .ps2000aIsReady
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, ready)
    }
    pub unsafe fn ps2000aRunBlock(
        &self,
        handle: i16,
        noOfPreTriggerSamples: i32,
        noOfPostTriggerSamples: i32,
        timebase: u32,
        oversample: i16,
        timeIndisposedMs: *mut i32,
        segmentIndex: u32,
        lpReady: ps2000aBlockReady,
        pParameter: *mut ::std::os::raw::c_void,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aRunBlock
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            noOfPreTriggerSamples,
            noOfPostTriggerSamples,
            timebase,
            oversample,
            timeIndisposedMs,
            segmentIndex,
            lpReady,
            pParameter,
        )
    }
    pub unsafe fn ps2000aRunStreaming(
        &self,
        handle: i16,
        sampleInterval: *mut u32,
        sampleIntervalTimeUnits: PS2000A_TIME_UNITS,
        maxPreTriggerSamples: u32,
        maxPostPreTriggerSamples: u32,
        autoStop: i16,
        downSampleRatio: u32,
        downSampleRatioMode: PS2000A_RATIO_MODE,
        overviewBufferSize: u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aRunStreaming
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            sampleInterval,
            sampleIntervalTimeUnits,
            maxPreTriggerSamples,
            maxPostPreTriggerSamples,
            autoStop,
            downSampleRatio,
            downSampleRatioMode,
            overviewBufferSize,
        )
    }
    pub unsafe fn ps2000aGetStreamingLatestValues(
        &self,
        handle: i16,
        lpPs2000aReady: ps2000aStreamingReady,
        pParameter: *mut ::std::os::raw::c_void,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetStreamingLatestValues
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, lpPs2000aReady, pParameter)
    }
    pub unsafe fn ps2000aNoOfStreamingValues(
        &self,
        handle: i16,
        noOfValues: *mut u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aNoOfStreamingValues
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, noOfValues)
    }
    pub unsafe fn ps2000aGetMaxDownSampleRatio(
        &self,
        handle: i16,
        noOfUnaggreatedSamples: u32,
        maxDownSampleRatio: *mut u32,
        downSampleRatioMode: PS2000A_RATIO_MODE,
        segmentIndex: u32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetMaxDownSampleRatio
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            noOfUnaggreatedSamples,
            maxDownSampleRatio,
            downSampleRatioMode,
            segmentIndex,
        )
    }
    pub unsafe fn ps2000aGetValues(
        &self,
        handle: i16,
        startIndex: u32,
        noOfSamples: *mut u32,
        downSampleRatio: u32,
        downSampleRatioMode: PS2000A_RATIO_MODE,
        segmentIndex: u32,
        overflow: *mut i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetValues
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            startIndex,
            noOfSamples,
            downSampleRatio,
            downSampleRatioMode,
            segmentIndex,
            overflow,
        )
    }
    pub unsafe fn ps2000aGetValuesBulk(
        &self,
        handle: i16,
        noOfSamples: *mut u32,
        fromSegmentIndex: u32,
        toSegmentIndex: u32,
        downSampleRatio: u32,
        downSampleRatioMode: PS2000A_RATIO_MODE,
        overflow: *mut i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetValuesBulk
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            noOfSamples,
            fromSegmentIndex,
            toSegmentIndex,
            downSampleRatio,
            downSampleRatioMode,
            overflow,
        )
    }
    pub unsafe fn ps2000aGetValuesAsync(
        &self,
        handle: i16,
        startIndex: u32,
        noOfSamples: u32,
        downSampleRatio: u32,
        downSampleRatioMode: PS2000A_RATIO_MODE,
        segmentIndex: u32,
        lpDataReady: *mut ::std::os::raw::c_void,
        pParameter: *mut ::std::os::raw::c_void,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetValuesAsync
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            startIndex,
            noOfSamples,
            downSampleRatio,
            downSampleRatioMode,
            segmentIndex,
            lpDataReady,
            pParameter,
        )
    }
    pub unsafe fn ps2000aGetValuesOverlapped(
        &self,
        handle: i16,
        startIndex: u32,
        noOfSamples: *mut u32,
        downSampleRatio: u32,
        downSampleRatioMode: PS2000A_RATIO_MODE,
        segmentIndex: u32,
        overflow: *mut i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetValuesOverlapped
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            startIndex,
            noOfSamples,
            downSampleRatio,
            downSampleRatioMode,
            segmentIndex,
            overflow,
        )
    }
    pub unsafe fn ps2000aGetValuesOverlappedBulk(
        &self,
        handle: i16,
        startIndex: u32,
        noOfSamples: *mut u32,
        downSampleRatio: u32,
        downSampleRatioMode: PS2000A_RATIO_MODE,
        fromSegmentIndex: u32,
        toSegmentIndex: u32,
        overflow: *mut i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetValuesOverlappedBulk
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(
            handle,
            startIndex,
            noOfSamples,
            downSampleRatio,
            downSampleRatioMode,
            fromSegmentIndex,
            toSegmentIndex,
            overflow,
        )
    }
    pub unsafe fn ps2000aStop(&self, handle: i16) -> PICO_STATUS {
        let sym = self
            .ps2000aStop
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle)
    }
    pub unsafe fn ps2000aHoldOff(
        &self,
        handle: i16,
        holdoff: u64,
        type_: PS2000A_HOLDOFF_TYPE,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aHoldOff
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, holdoff, type_)
    }
    pub unsafe fn ps2000aGetChannelInformation(
        &self,
        handle: i16,
        info: PS2000A_CHANNEL_INFO,
        probe: i32,
        ranges: *mut i32,
        length: *mut i32,
        channels: i32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetChannelInformation
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, info, probe, ranges, length, channels)
    }
    pub unsafe fn ps2000aEnumerateUnits(
        &self,
        count: *mut i16,
        serials: *mut i8,
        serialLth: *mut i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aEnumerateUnits
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(count, serials, serialLth)
    }
    pub unsafe fn ps2000aPingUnit(&self, handle: i16) -> PICO_STATUS {
        let sym = self
            .ps2000aPingUnit
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle)
    }
    pub unsafe fn ps2000aMaximumValue(&self, handle: i16, value: *mut i16) -> PICO_STATUS {
        let sym = self
            .ps2000aMaximumValue
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, value)
    }
    pub unsafe fn ps2000aMinimumValue(&self, handle: i16, value: *mut i16) -> PICO_STATUS {
        let sym = self
            .ps2000aMinimumValue
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, value)
    }
    pub unsafe fn ps2000aGetAnalogueOffset(
        &self,
        handle: i16,
        range: PS2000A_RANGE,
        coupling: PS2000A_COUPLING,
        maximumVoltage: *mut f32,
        minimumVoltage: *mut f32,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetAnalogueOffset
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, range, coupling, maximumVoltage, minimumVoltage)
    }
    pub unsafe fn ps2000aGetMaxSegments(&self, handle: i16, maxSegments: *mut u32) -> PICO_STATUS {
        let sym = self
            .ps2000aGetMaxSegments
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, maxSegments)
    }
    pub unsafe fn ps2000aQueryOutputEdgeDetect(&self, handle: i16, state: *mut i16) -> PICO_STATUS {
        let sym = self
            .ps2000aQueryOutputEdgeDetect
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, state)
    }
    pub unsafe fn ps2000aSetOutputEdgeDetect(&self, handle: i16, state: i16) -> PICO_STATUS {
        let sym = self
            .ps2000aSetOutputEdgeDetect
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, state)
    }
    pub unsafe fn ps2000aGetScalingValues(
        &self,
        handle: i16,
        scalingValues: *mut PS2000A_SCALING_FACTORS_VALUES,
        nChannels: i16,
    ) -> PICO_STATUS {
        let sym = self
            .ps2000aGetScalingValues
            .as_ref()
            .expect("Expected function, got error.");
        (sym)(handle, scalingValues, nChannels)
    }
}
