#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stddef.h>

#include "lowmc_192_192_30.h"

static const block_t precomputed_round_key_matrix_linear_part[] = {
  {{ UINT64_C(0xfaa97030b5e13d54), UINT64_C(0x71f180540b8394be), UINT64_C(0xde60453ea0d0ff6b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe215921eeefa56ff), UINT64_C(0xf6feb5d775a51c50), UINT64_C(0x558cf93355448248), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7d5041f1a76673d2), UINT64_C(0x7dffd6a64dc54a95), UINT64_C(0x9500a9145e3aea16), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbe5cdc66b147b85b), UINT64_C(0xfc51bcbd61ed2d86), UINT64_C(0xffbb030214a48804), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe0e41667b912b0f6), UINT64_C(0x2f1d13c89d4ab6b1), UINT64_C(0x281feee2f8881d16), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0d90da382ad3f762), UINT64_C(0xd969dfb94d1fe36f), UINT64_C(0xb140d27230de0cfe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3d2f5df2c040594c), UINT64_C(0xf95e0a83f4aeb2ec), UINT64_C(0x8ef0d5d0362a1bc9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x54a36ec6c21d7429), UINT64_C(0xa6c1957c0f09d522), UINT64_C(0xa6b75cd97e03b163), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xff7569cba3bc7a76), UINT64_C(0x017ba9d5c6ab5b8f), UINT64_C(0x138d2e5bd4b595b9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf34162518ba034c1), UINT64_C(0xcf61e46249d5f01b), UINT64_C(0xf352499a0ebcc6da), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xad2923ffd258e63f), UINT64_C(0xaa06c323810c0178), UINT64_C(0x2aa701eca84b55ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb1dc31e663a6c2f1), UINT64_C(0xb2e379360e542d6d), UINT64_C(0x71d744bb723a0778), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x306a9753714c2fdf), UINT64_C(0x2df3d96f4806419e), UINT64_C(0xcdd5d943109ff2c6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5238832f606ee207), UINT64_C(0x40a3a006b9853d74), UINT64_C(0x34820d6e3c930279), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf5a3b4f02602a476), UINT64_C(0xc727dd3af6cbeca0), UINT64_C(0x88d0d63b8fa74a16), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf9b321b8c5d35e83), UINT64_C(0x042571772d1d2ee6), UINT64_C(0x4288cc0e96a6bdc1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xedb1466ec259d010), UINT64_C(0x748a241304cca374), UINT64_C(0xd6e77f5bcce61a11), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x166ca2331455d702), UINT64_C(0xd7cedf35051a4276), UINT64_C(0xc75e7efd0260e01d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd41bf731ff3c59d5), UINT64_C(0x50271c2b36fdae24), UINT64_C(0x9d1af23687fb282a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac98ebde9b020a90), UINT64_C(0xa7cb3587610c1b37), UINT64_C(0x2ab6abe7c6708d4c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac41e687c7aee3f3), UINT64_C(0x6f73efd6a13eb3a5), UINT64_C(0x6f85f7aa0088d772), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3d2f43778591445b), UINT64_C(0x48640eea84cac02e), UINT64_C(0x6a49cb0f7872835c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x843cd237de3dc0a6), UINT64_C(0x5ca5fde10fc4ca64), UINT64_C(0xb22fb34e3dbac3cf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x51459cf852cd810a), UINT64_C(0xda80bea74d527cfa), UINT64_C(0x4863a94b2056748c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x772ea9e01657d124), UINT64_C(0x8dcff0c7b8a84fbb), UINT64_C(0x478c6fae5ae91f75), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x393703c4eb82a19f), UINT64_C(0xeb1dc4e3ddcb6ca1), UINT64_C(0x5b37fcf448c7b5ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf2ed3410b1254b10), UINT64_C(0xa889294ba22ee4e9), UINT64_C(0xe80bdb98a67bfcf3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2386846bee4331e4), UINT64_C(0x4e0ea95bd6515e1e), UINT64_C(0x6058f945beef51a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe193ecac3c1f34aa), UINT64_C(0x2a188ed0228fd11d), UINT64_C(0x28ddb0b0f57168eb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e248032bb1a24ea), UINT64_C(0x16282601f62128d4), UINT64_C(0x9629864218104bb9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa57b00a4c6a4bde2), UINT64_C(0xa9185c103a99de52), UINT64_C(0x60a607f9b1761ebb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x93c802a6ba18b6c7), UINT64_C(0x81b8cbb1b49e53e6), UINT64_C(0x04f67600a73e62d6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1cddcb1459832970), UINT64_C(0xa748aab7f8d17df1), UINT64_C(0xa6843bc96c53a54e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6c828813921e8783), UINT64_C(0xd51ae432b13b05d4), UINT64_C(0xe686e3bc07949c34), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xde4fe5216439fe4e), UINT64_C(0xfa5775b32836deda), UINT64_C(0xcbf954f2533ff70a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc1ccf0b477103af1), UINT64_C(0xafb551f44461e904), UINT64_C(0xd83929edafdf262a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xafed58cf286ffcc3), UINT64_C(0x11e521e5786d9fe3), UINT64_C(0xc5af16c39ef14e01), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdc746a3f78ce16e4), UINT64_C(0xc76d76510a06ca38), UINT64_C(0x4427f1809b5899a1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbc7cd847c7249141), UINT64_C(0x95f5f98d815d4b8c), UINT64_C(0x4d40f1b4ce871461), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc6dddd7feca522d2), UINT64_C(0xda8c414ee159ab50), UINT64_C(0x6670ce6e9ae88a61), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x47c7e2f6f3d78d5c), UINT64_C(0x8f7a85c4a61dc430), UINT64_C(0x3ce767f3f0f8b6a6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4b3645233612b58d), UINT64_C(0xa3035b62cca85b7b), UINT64_C(0x943e0d31d053b024), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5c3d25830e286643), UINT64_C(0x177ba0e3461f98fc), UINT64_C(0x1bb22ed789e2240b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71ae2069878bd9e8), UINT64_C(0x05c1a5f627949807), UINT64_C(0x93d26972784026ba), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7f35810f9f95a543), UINT64_C(0x07212646a01248d8), UINT64_C(0xb13c425a1c9ad749), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x955aef7da78f649e), UINT64_C(0x97111f0c37fc205d), UINT64_C(0x6b4a6b7de3e385ae), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf117fb280786589e), UINT64_C(0x8009c31e5644cbb1), UINT64_C(0xbe2fe0e15d46f53f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb5db822335d3b490), UINT64_C(0xdd387f2563ceba67), UINT64_C(0x3a97eab22e5baab6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa1eed250d970491c), UINT64_C(0x6ba4bc89dca4880d), UINT64_C(0x69ac11cc136de8ab), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xed8533e3aa4c6f3a), UINT64_C(0x1f7c2f0c39bf0c16), UINT64_C(0xa35fa1934252f747), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7e9f39ad4c9e804f), UINT64_C(0x20315e534b42bcc8), UINT64_C(0x80cc53b4cc123305), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa368a24bed96f2a4), UINT64_C(0x6bb259763cfcbcdb), UINT64_C(0xf8c53b9d50cb2bd6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9cd3c4acd7e56da5), UINT64_C(0xeb33526b06dc732b), UINT64_C(0x89b1e2979e691620), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x95633dee2999789f), UINT64_C(0xd6e7d84b4f528ffb), UINT64_C(0xfa84fcaba2d84eaf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0fa73ca085630985), UINT64_C(0x2a30557bdad95041), UINT64_C(0xbc27c65159f9a2ca), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x72abb3dceea05f20), UINT64_C(0x1c56172489a865eb), UINT64_C(0x73306c76f82738e7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa2ecf272b9b00aae), UINT64_C(0x1a08f321fcdea20f), UINT64_C(0x089c69de8393a667), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xafa31531ba949f95), UINT64_C(0xd1f8b256354b11d4), UINT64_C(0x66fdcdde5d4ef714), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0e5a47bae95d8b1d), UINT64_C(0xd1413ebb7b7e7c9c), UINT64_C(0xb0070f1c0cdd4660), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x08218d5434cf0058), UINT64_C(0x6225c1bdd403ca89), UINT64_C(0x5243b7907cff4b21), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0709bf8295e86c31), UINT64_C(0x0caa193ddceb5139), UINT64_C(0xc7fb4a3f91a39574), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa480aee91124b79a), UINT64_C(0x4dfc97f1ccf970c8), UINT64_C(0x3ba73e704cbf89dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2423142aacacffdf), UINT64_C(0x88d587965b7b9cc0), UINT64_C(0xb0862dce9b2fa6fc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x69ffe36cba8dd7de), UINT64_C(0x1668c7ef1fac4ea0), UINT64_C(0x6aaff8cb7a898dd1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5a11e487a4b40ed3), UINT64_C(0x7b61abe28cfd5717), UINT64_C(0x54b25e3385530133), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd937073c692c092c), UINT64_C(0xffa1567379ef3e88), UINT64_C(0x45d7a1e632a498c9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe3a585784f74d6d0), UINT64_C(0x0eb78e5b2cc5714f), UINT64_C(0x9ee745e44b68544c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x096ce756ed059dc4), UINT64_C(0xb5eef9fe065136f7), UINT64_C(0xa72e17e32e8b014e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa8d82901596c5da2), UINT64_C(0x65215cd04371337f), UINT64_C(0xfc2dea502f5225f6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x75bd053fb936861d), UINT64_C(0x9642ce014fb5ecb5), UINT64_C(0xc44124cefaa0e99f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfddf3e8e877b4a15), UINT64_C(0x43567e9ee3d3c08a), UINT64_C(0x806d21ebe9fcbd76), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x21dd015997b32270), UINT64_C(0x978f32c6c7ea4da5), UINT64_C(0x995bc5c4041343d9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4778c9a6d733a87b), UINT64_C(0x5d7a30ee03c78772), UINT64_C(0x9de5ee9a73189a5d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8ee3f1f4839b73d7), UINT64_C(0x7e696f4742ca1d19), UINT64_C(0x95f0ab977d4af43c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd00e950f847cd92a), UINT64_C(0xae1356dba23fbbaf), UINT64_C(0x74d3c1a0c8a06be3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc0d387d4a163a332), UINT64_C(0xe104fe287c5fb25e), UINT64_C(0x79941cd01ff0f54e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb09dd2c2f7eec50c), UINT64_C(0x0335a4d80aa2c2bd), UINT64_C(0x11aa1f46ea67ee89), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x47fd4196586aedb2), UINT64_C(0xa6e082cbc505d0db), UINT64_C(0x67c1e4daf014d2e4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8f1fec5a0d1f7796), UINT64_C(0xbf59023bc9418b83), UINT64_C(0xd3758f52ccabc0a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac3c0fb31b2acd1d), UINT64_C(0x1e6b0b04f08ecbb6), UINT64_C(0x806be4d66302f712), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf0e54d21b52c2743), UINT64_C(0xababf993c9a7a39f), UINT64_C(0x606cfab6693fd990), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x54629f0f56e72119), UINT64_C(0x6cfcfe8758d5462e), UINT64_C(0xcbb20f1b8b572e89), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb4f5382540dcf4e1), UINT64_C(0x48579f1630fda9a7), UINT64_C(0xdf7dcbafb9f624ef), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x33757c13c29f661c), UINT64_C(0xb4563b24930eab88), UINT64_C(0x4b0332e150abd0ab), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x113567ae08ad60f2), UINT64_C(0xb9af9cba20b96f01), UINT64_C(0xe6b4b0c70c5ba797), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd29070949871967c), UINT64_C(0x6706643db74edb76), UINT64_C(0xe525d518c67578c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x33e4e5c20e48cbfb), UINT64_C(0xc2af1ccceefda3e2), UINT64_C(0xd085707651216fbf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2b9749b1da44d841), UINT64_C(0x25dd7f4788622101), UINT64_C(0xa0bfcdd7f1029c13), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x604c0706da0076df), UINT64_C(0x5b829a800fdbbcfb), UINT64_C(0xe8c8ec9f587bb5e0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5c22708fecc2bd64), UINT64_C(0x4c9e356f204b5a09), UINT64_C(0xaabfcae3bfe1f4d7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6a936952236ea35f), UINT64_C(0x8b805f84f2fc8c0e), UINT64_C(0x8841764f3b93138b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4f79d74a69b5e5e9), UINT64_C(0x435ad8ad72a6c440), UINT64_C(0x19efdeaa275dbbaf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4458979347c65e29), UINT64_C(0xdb0b455fa10c2724), UINT64_C(0xc9b2d54b8d8b0141), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7c6a73990d87f8f8), UINT64_C(0xd536de01639a83af), UINT64_C(0x86efff17e576019c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x448c121fbb12cf80), UINT64_C(0xaa6c7191c713472f), UINT64_C(0x04addd5d5e02dcb9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1b4627ec4530f4e1), UINT64_C(0x43e34a4975b6175e), UINT64_C(0x49759c8bd347ec5f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc8107de329ac5972), UINT64_C(0x16858a6c6b4f0cc1), UINT64_C(0x375e8ce550312c77), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb0cb3f714688c628), UINT64_C(0x5bc037854e22c220), UINT64_C(0x21bc9ea4a2bf2c3c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x63940c924b52ab25), UINT64_C(0x29cab8db05e4d98e), UINT64_C(0x30e4c9fbd4d84889), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb64d69a74f38d99d), UINT64_C(0x02bce51dddb91a77), UINT64_C(0xeb35799642d31210), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4008364c22837656), UINT64_C(0x156d61011a2651c1), UINT64_C(0x5fb7fb6eefd32e1a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x91fb753410021f76), UINT64_C(0x22d707a7c2ff623e), UINT64_C(0xba08dcc88047fb94), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x95078a7a98169ccf), UINT64_C(0x1b72b8e81d8522ef), UINT64_C(0xcfe1f8831dac2306), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfcef854e3ca4c21b), UINT64_C(0xf857ce294cc681ed), UINT64_C(0x05ee9c8f94bdc12e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4b74d9b02217fdb5), UINT64_C(0x2edce4b6c7d1ade4), UINT64_C(0x01dc41ac82d83a2b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe84229e76ea138b2), UINT64_C(0x16042844b5d1f3e9), UINT64_C(0xed7c52db311ffb43), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x188701e5397d3384), UINT64_C(0xc3945da6a83e67fb), UINT64_C(0x0e29c2ad4ae978ff), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x80ce898d0daee172), UINT64_C(0x68df8dd702c7bd47), UINT64_C(0xed1efedd9311dae3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe03992304b9ac8cb), UINT64_C(0x5ffbe8df536a5312), UINT64_C(0xf2a2be7026f5c346), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb04069cee597ebf1), UINT64_C(0x77c6ee754b2a9792), UINT64_C(0x0e07395eae6796a1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x03e2f3bdcd7f8ad3), UINT64_C(0x16249669fffaa664), UINT64_C(0x18371d75490ea4f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x41a29d2db573ab80), UINT64_C(0x24d0411eb5e3fb5b), UINT64_C(0x62b0391c987ee305), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbc65d0603be2d02e), UINT64_C(0x9064ad81fe2e51ca), UINT64_C(0x7b86f197837cac42), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc211c0b370ef0c71), UINT64_C(0x09d1adb7610b4897), UINT64_C(0xf6895d8f93b3aa93), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8d1740ca42e04310), UINT64_C(0x2dd124685f3990e2), UINT64_C(0x010f864f098c9852), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1904a1c84ffb0e74), UINT64_C(0xc5c8281bc08929b7), UINT64_C(0x43ccfbc1c6023ee9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb4ec246227c4b575), UINT64_C(0xa88eb486b4dad398), UINT64_C(0x6a47bb332d1c20d4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x17c7e8923341c346), UINT64_C(0x59296db007a6a5ff), UINT64_C(0x7d694d9ee46ff1a7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xea46ef40c5315616), UINT64_C(0xb019892ccad80f25), UINT64_C(0x690b0858518d990a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x397ef725ddfbe956), UINT64_C(0x50dfa7e6eab311ac), UINT64_C(0x7ac76d39e4f0280d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x694181af69c30e8a), UINT64_C(0x011a0fab27926def), UINT64_C(0x5b93adc4c5198cf2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x42872b9a0fa3826d), UINT64_C(0x6d0845f66724b21a), UINT64_C(0xecc98f983883fd00), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa106fe84812e183b), UINT64_C(0x463d106a5fb46ea1), UINT64_C(0x0c134849812205ae), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2f384553d8398880), UINT64_C(0xf6d81df1902526fd), UINT64_C(0xf8512eb3823d1267), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4f182c6037622a05), UINT64_C(0x0ae7fa2cd256920d), UINT64_C(0xaf8394ee670bf2d7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x484b7f81b9038b2d), UINT64_C(0x6e8f246036253b6e), UINT64_C(0xb185ec2f17425a09), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe3b7af89c3967ae9), UINT64_C(0xfc9bd95e797aa427), UINT64_C(0x4e18a904730d8391), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x43858132bb25aaf2), UINT64_C(0x45851823fe4126a3), UINT64_C(0x34c9d809a77f9366), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x37fdcb33781e183a), UINT64_C(0xa34a2f997a65679e), UINT64_C(0xcebaccfab7f8f642), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4ba8959017cd2588), UINT64_C(0x1d3249b855861618), UINT64_C(0x9a0fe166aa3367f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeabdad8a39ab7da7), UINT64_C(0xcb9364a71f3a6a22), UINT64_C(0xb0b12808b2a810c4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0b6b9edbb0ac7630), UINT64_C(0xbad3fb269c46a1e0), UINT64_C(0x68f4ae4a1882fb7f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2541b7c391e6fe11), UINT64_C(0xd41c1ee289eee19e), UINT64_C(0x663cbebb07e05185), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2d6d52f630205697), UINT64_C(0x2f028830a387689e), UINT64_C(0xba0c9a5464414710), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb1b1c60dc985d687), UINT64_C(0x99386f1c130a8f0b), UINT64_C(0x96af3a080bc90d19), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8e4a3ab2fbf377b4), UINT64_C(0x96706432afd4264d), UINT64_C(0x2149bd728d0ca634), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x05e7d2f824e1f084), UINT64_C(0x7e58d61bd0d85fae), UINT64_C(0xd8df1bc714e9e23e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x49db939c82652b6a), UINT64_C(0x4c168005310e19b3), UINT64_C(0x94c532d8ddc62409), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x83adbb16e9c61b40), UINT64_C(0x7541bb871b513dd1), UINT64_C(0x57d1f5eafa3de9da), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xce0c5e04aa516105), UINT64_C(0x735239bccfa2c44b), UINT64_C(0xfa88e9e79b614a32), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9ad952d54f9f847c), UINT64_C(0xb35a80cf29790fb5), UINT64_C(0x7897ed0f68650334), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x298f1a892c08c3b8), UINT64_C(0x194f6dfec017d173), UINT64_C(0x04032e5e43482f2e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x358d109574dc613c), UINT64_C(0x8e2334ffd7e9472d), UINT64_C(0x8d77401584815ae1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xad1f50dac0cc1aad), UINT64_C(0x4add9e0bbd482394), UINT64_C(0xd385aa7170192efe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf78605bbd41a664c), UINT64_C(0xc9063eaf14d37032), UINT64_C(0x9ac60177ab64a211), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x07d4594dfe25f098), UINT64_C(0x382c858b3c7ab080), UINT64_C(0x408c33af635ec96b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x50ebb1e69d022dd4), UINT64_C(0x63e3511bb3665e1f), UINT64_C(0x9c8ce8deab0b90f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8b339dd060f6f62a), UINT64_C(0xeaa0fbcb60d53b32), UINT64_C(0x2b35469d4bd0e352), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc13e8929dfe4595b), UINT64_C(0x32dc8d8b5b36487d), UINT64_C(0x9d0ea990612a4d5e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf9f6de0bfbf88ea8), UINT64_C(0xb826cb5ab9a0eeaa), UINT64_C(0xd2b5952428cb176b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1447bd41b1b2afd7), UINT64_C(0xdc5d7dc28d3f10fe), UINT64_C(0x4d4bbf5373b43d2f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5924aa95fd3adbc0), UINT64_C(0xe600bf602cc3502d), UINT64_C(0x3972e2fbfbf492dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4b9e1e9ff9dea1a3), UINT64_C(0x2d101a628ea44e3c), UINT64_C(0x95497ffd3155c110), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x596b67e073c616af), UINT64_C(0x6e998e519eb0ee5b), UINT64_C(0x098e3ba21eec6ce0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd40031e8ec119874), UINT64_C(0xa69e7e5d0df3a8a8), UINT64_C(0xb04942d5966b01e3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf19c45068112cd2f), UINT64_C(0x144d8828b08b4640), UINT64_C(0xad18d04d2d023f00), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x563121cead208b5d), UINT64_C(0xe4c7d2a73e5fdca9), UINT64_C(0x0230410bbc5aaeb4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x74f54f785bcf5064), UINT64_C(0x5344e96bbb9eaf00), UINT64_C(0xade5e08137294bfe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5194d729c67902df), UINT64_C(0xc2caebdf32376bd9), UINT64_C(0x22ef63698e1ab467), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x91c216a203cdf177), UINT64_C(0xf9a81c3c333d4cff), UINT64_C(0xa77b1503025c0203), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8528728c78a0ecd3), UINT64_C(0x0162c42161a40953), UINT64_C(0xfb495270dbb3c4f2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdeb46c2d292e3a47), UINT64_C(0xdfbac4746ee55fd6), UINT64_C(0xa3f07c5f0ee645ea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3d90980613e58e1e), UINT64_C(0x4f81a9353de919d8), UINT64_C(0x1955cf711cdab56f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd7259f1176207eee), UINT64_C(0xf2a9c01d3ab22f89), UINT64_C(0x02dbe10715db2dbb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb5ae2cbdcc9032ee), UINT64_C(0x8f8ccabc0e7f5480), UINT64_C(0xabf312b0903b2166), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3fea99ed796e67f8), UINT64_C(0xf2834e4452ef236c), UINT64_C(0x00b819d167735dc2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe6b8af93d53e05ab), UINT64_C(0x639b5b1e72077f72), UINT64_C(0x8dc9ce87a55f5811), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb8e4591ec51e3abc), UINT64_C(0x8677287cda2440e8), UINT64_C(0xe7c7686cc9b73b7a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe98e3c93edaa5705), UINT64_C(0xff083795736a0466), UINT64_C(0xadd88c45affb40d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x24f0b789b660168f), UINT64_C(0xb662a0c9a97e1f98), UINT64_C(0xd780871d14ce0ef3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9e368e09a7976fb7), UINT64_C(0x6f629f4b46da230a), UINT64_C(0xbcd6ee4d792932f6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc412d0d3b80d1950), UINT64_C(0xc99dc1e6d24639fc), UINT64_C(0x9c350eedaac6d358), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7e9cb09080235ef6), UINT64_C(0xa28a2ec6a3715311), UINT64_C(0xfa332b507649aa7f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xedceac5a77da2859), UINT64_C(0x75c8d44168a2d279), UINT64_C(0xa66ea9c2750ddeb8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac335627a831c409), UINT64_C(0x9ef0c950f402078d), UINT64_C(0x910fd109810d2216), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1cf3b66cf32ddc1a), UINT64_C(0x2f1b9c7829cfa1e8), UINT64_C(0xbb26338e757bf260), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2cdfd6bbe4109a4d), UINT64_C(0xa6efc55c85b77466), UINT64_C(0xd082c37a437594a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8b84420084a3b22d), UINT64_C(0x68f8f854552a36c3), UINT64_C(0x2a26dede345d1efa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x08f0b07db3efc859), UINT64_C(0x3f4394b895296cdf), UINT64_C(0xb567c9837dfdecf6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x33bad76d97d3dd95), UINT64_C(0x774c6d0e8dc1a5e4), UINT64_C(0x25e1df7757bb4f60), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xda1a2701e448d2e7), UINT64_C(0xacd4e4bead4c38ac), UINT64_C(0x820f5999d5a14463), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x831372839fe81c0f), UINT64_C(0xb9604eb833fe54d5), UINT64_C(0xf590481300837cc9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1d0b08063be24ba3), UINT64_C(0x4ef895cadbde808b), UINT64_C(0x414b95383c7c36ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb817122815e11064), UINT64_C(0x63bf7ca1d36fabd1), UINT64_C(0x1fa9868a5721757f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfbd5837b5d9585d8), UINT64_C(0x0b4d237376be7728), UINT64_C(0x9b6aae2360e68f80), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x904bae3c44268bcb), UINT64_C(0xe8ecce394add3bbf), UINT64_C(0x0e0508b186e61b65), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x68a18690639e0015), UINT64_C(0xbc85ba444c3a374e), UINT64_C(0x338e0eeeab864b20), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfbe2a89194b1717d), UINT64_C(0x17db8270ac7c4472), UINT64_C(0x7816befecf22bca9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x971f102d67d27d7a), UINT64_C(0x055755fa70217b89), UINT64_C(0xfe6643a00234a08a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3ebb341e67f40b8a), UINT64_C(0x44519d7ef0924902), UINT64_C(0x664004b7f50cf584), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf1dd5331d6fd442f), UINT64_C(0x1c777f52052dd778), UINT64_C(0xf3d227869fc3a9c9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7f2bbfa8d34e9e02), UINT64_C(0xa07f4ac34485a930), UINT64_C(0x88520954dd34879e), UINT64_C(0x0000000000000000) }},
};

static const block_t precomputed_round_key_matrix_non_linear_part[] = {
  {{ UINT64_C(0x69adf2f45b463b10), UINT64_C(0x6008a3281cef52f8), UINT64_C(0x404f4ef05b5517bc), UINT64_C(0xd50ff77436c7fdc4) }}, {{ UINT64_C(0x077fc974a596a014), UINT64_C(0xf4e03cc4d48c9e3c), UINT64_C(0x6fd78b24e9ff1a44), UINT64_C(0xf722a89c17593ffc) }}, {{ UINT64_C(0x710969e8526cba80), UINT64_C(0x93ea789cef027a30), UINT64_C(0x266002e4fc859c58), UINT64_C(0x9f2450186d9159c4) }}, {{ UINT64_C(0x0b594234c2755f5c), UINT64_C(0x08b75054e19c8cdc), UINT64_C(0x5d3fa064187e1d10), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7549d24406ba2758), UINT64_C(0x8ca706c4af76c3f0), UINT64_C(0xb72795807dd6ff08), UINT64_C(0x065f30cc396ace54) }}, {{ UINT64_C(0xbe0b792c17d8f7f8), UINT64_C(0x037e4b687b35ef24), UINT64_C(0x3e0acf74653274dc), UINT64_C(0xf2ea5e808527d6fc) }}, {{ UINT64_C(0x3d5dfa60aa6cee74), UINT64_C(0xd2c7b4f063811b94), UINT64_C(0x9f1a7d34fcfdd7d8), UINT64_C(0x7688df685e20b8dc) }}, {{ UINT64_C(0x22d45f08666e640c), UINT64_C(0x24a741701f7c8574), UINT64_C(0x76f88a80c108492c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfce14f686e86ea28), UINT64_C(0xef2d81e08f4a24bc), UINT64_C(0xad681058d2a2c8c4), UINT64_C(0x8f3928acca608a80) }}, {{ UINT64_C(0xa3e5f5bc8afdc8b8), UINT64_C(0x155a670cb72b8dc8), UINT64_C(0x619a66d4773dc990), UINT64_C(0x99b640609a540dbc) }}, {{ UINT64_C(0x15b7746cc251af54), UINT64_C(0x3ef88880e2225338), UINT64_C(0x79be67ac5840f7c8), UINT64_C(0x013d89542873d29c) }}, {{ UINT64_C(0x3128bcd4427d7e04), UINT64_C(0x1c5e6e3c03479bfc), UINT64_C(0x87d646f492cfde30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe3986400c1a511c4), UINT64_C(0x3fd67ad014a64814), UINT64_C(0x7786d5a8c4116a80), UINT64_C(0x78f87e74b3a69350) }}, {{ UINT64_C(0xbabe46d4dbc28ce0), UINT64_C(0x368f416ca4811fd4), UINT64_C(0x217fb8e06128b6b0), UINT64_C(0x1b78949c0faa4648) }}, {{ UINT64_C(0xeaa7a7d0a3d68d10), UINT64_C(0x1070c17c8575db08), UINT64_C(0x2eb34ab002b00184), UINT64_C(0x198c6000b9e968cc) }}, {{ UINT64_C(0xecc0bb9c3479d8e8), UINT64_C(0x25d34d401af4a6a0), UINT64_C(0x8ac40f60b5def3c4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xea965fec425ba070), UINT64_C(0x7dde0e6802a6e408), UINT64_C(0x957128c0c97954a4), UINT64_C(0x38245e103515b3bc) }}, {{ UINT64_C(0x8abf30408ded39d4), UINT64_C(0xb01e5ebc91900d58), UINT64_C(0xe734ca2c38366064), UINT64_C(0x8b126024fa8db810) }}, {{ UINT64_C(0x97e7eb5c6217abcc), UINT64_C(0xbfaec3d42c519c44), UINT64_C(0xcba5f164f2b26e74), UINT64_C(0x71b111f0a892c1d8) }}, {{ UINT64_C(0x1a8bfaa0a8340144), UINT64_C(0x093f3f44b22c8180), UINT64_C(0x7d47581419c6254c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xffe824f49736987c), UINT64_C(0x3ad07efcf904ea9c), UINT64_C(0x7cb1ed102713cc20), UINT64_C(0x9d254254ec9cb620) }}, {{ UINT64_C(0xaf82fee0f0019cec), UINT64_C(0x96d1e640f0663924), UINT64_C(0xedc3380c5779180c), UINT64_C(0x6a03e74c4d52d294) }}, {{ UINT64_C(0x1a9b45d8d8c3a6dc), UINT64_C(0xa71bad2cefa9dce0), UINT64_C(0x797aac20c4a3025c), UINT64_C(0x1967d6503016eda0) }}, {{ UINT64_C(0x332323acce4f8378), UINT64_C(0x4e105d5cb8cb6bec), UINT64_C(0x467fe1dc44fca7bc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8ea330407359de64), UINT64_C(0x97a9f5cc72b547a0), UINT64_C(0xbe08d7701dc32290), UINT64_C(0xf0ad76b4538fb588) }}, {{ UINT64_C(0xbd0bffc884fcf6f4), UINT64_C(0xb4234884de3175d4), UINT64_C(0x1f9bb5682551fad4), UINT64_C(0x32712fc8fed65b0c) }}, {{ UINT64_C(0xa78ee55cef9f5770), UINT64_C(0x24b8a340b560bf04), UINT64_C(0xd14c45d07cd98fdc), UINT64_C(0x5d4cb7d44f916e90) }}, {{ UINT64_C(0x1d6b996ca36e54ac), UINT64_C(0x3f3faf141a1da5c0), UINT64_C(0x929f29c0a079bd90), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6eab44782ea3dea4), UINT64_C(0x6fee98287fd36f1c), UINT64_C(0x71100b007ce53d1c), UINT64_C(0x85a91008a3a054f4) }}, {{ UINT64_C(0xa5ea5fe016e62c88), UINT64_C(0xb9e23460cae4ea38), UINT64_C(0x0db54d7806c30be8), UINT64_C(0xe7268f5427c2645c) }}, {{ UINT64_C(0x054cf2d05454aac0), UINT64_C(0x0ab2614833985080), UINT64_C(0x5e7da1846b05f024), UINT64_C(0xff9207f4de9c013c) }}, {{ UINT64_C(0x85b26fd81a702528), UINT64_C(0xc940f1348a3e37a4), UINT64_C(0xa73a5750998d8200), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd6c8883c9d134bac), UINT64_C(0xc796c34c175709c4), UINT64_C(0x9cdf392848552984), UINT64_C(0x8e44fa483fef8750) }}, {{ UINT64_C(0x8d380ef4bd4ea504), UINT64_C(0x05f7acec9e287eb0), UINT64_C(0xcc192434e643f630), UINT64_C(0x34926eb473fef48c) }}, {{ UINT64_C(0xce24fb34cd764f28), UINT64_C(0xcb9679e498d385f0), UINT64_C(0xb15884a4534c0c6c), UINT64_C(0x0a05aec80985a30c) }}, {{ UINT64_C(0x4465f87c0565a54c), UINT64_C(0x6238af64d0e41070), UINT64_C(0x9311c7a46a608f40), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb338c36450e2087c), UINT64_C(0xc1742f541e707924), UINT64_C(0x0694d59cc8064b80), UINT64_C(0xecbb7364e7d41f44) }}, {{ UINT64_C(0xb25c10547ef350c0), UINT64_C(0x9ec86680f2f3d218), UINT64_C(0x80b5de3c99cec7c8), UINT64_C(0x7e6623e47a44ff44) }}, {{ UINT64_C(0x91b2c8500223c7a0), UINT64_C(0x5d3217642e8fc424), UINT64_C(0x4a88e1dc2ed348b4), UINT64_C(0x094dab3423a8b3e0) }}, {{ UINT64_C(0xf691a698d1b0d828), UINT64_C(0x75eaa65801f1c9a4), UINT64_C(0x89cef6c48273e2b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6c34a4bcffd7c050), UINT64_C(0xcdc545541e686744), UINT64_C(0x01134234f59f01bc), UINT64_C(0x74a20b785efcb1f4) }}, {{ UINT64_C(0xdecc55ec71fac8d0), UINT64_C(0xbc0941642e37445c), UINT64_C(0x8d22ab98cd931798), UINT64_C(0xb684b50001d67aec) }}, {{ UINT64_C(0x4dd226ec9db40b28), UINT64_C(0x52e5931861756e54), UINT64_C(0xc598b50498fc224c), UINT64_C(0xfe1f1370e3021f7c) }}, {{ UINT64_C(0xc0c136707777328c), UINT64_C(0x9cb0f5d84496a094), UINT64_C(0x8a2afd040c603ba0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfd48df9c257ba348), UINT64_C(0x0d150e78fca2d42c), UINT64_C(0xe5a8c56c103c1fc4), UINT64_C(0x84b2757c05491c88) }}, {{ UINT64_C(0x7d81d2fcfd570d80), UINT64_C(0x0bf755904b68dd68), UINT64_C(0x51ca12bc05f34cc0), UINT64_C(0x04a2a05088a51bb8) }}, {{ UINT64_C(0x6059d30cdecb6340), UINT64_C(0x5779741cba2fc1a0), UINT64_C(0x8095d718bb19bea4), UINT64_C(0xf1ad4c58f4d6dce0) }}, {{ UINT64_C(0x126f58f8129bf07c), UINT64_C(0x34b280604ff44ac0), UINT64_C(0xf08a5964f048a3f8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7bed2718a25e17dc), UINT64_C(0x2b48c1a8cb6a17c4), UINT64_C(0x3bd6d06cae11ef40), UINT64_C(0xa32a53203a99cfbc) }}, {{ UINT64_C(0x9037780c20a3ab14), UINT64_C(0xdf408d70016739d8), UINT64_C(0x66ea7e386d011f2c), UINT64_C(0xce71d7f4c6743394) }}, {{ UINT64_C(0x4ea2c7085718113c), UINT64_C(0xeb438e3c06ee1ca4), UINT64_C(0x06c7a7e83276f8c4), UINT64_C(0x2d94111447337184) }}, {{ UINT64_C(0xa9238a5091ce62ec), UINT64_C(0x9a53ca24656c7878), UINT64_C(0x309bf59c5d1f206c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeab125e0afbb3700), UINT64_C(0x6eca3a50501439dc), UINT64_C(0xdb2f8128186e37a8), UINT64_C(0x5e5d78884d0a6f50) }}, {{ UINT64_C(0x506ebe8857763fdc), UINT64_C(0x6042189423dc3fac), UINT64_C(0x07d77750f319e038), UINT64_C(0xb5f4ec3c80c8eb68) }}, {{ UINT64_C(0x12c7d1f09e65b320), UINT64_C(0x10cd9c30138f3e1c), UINT64_C(0xda579cb0b7540acc), UINT64_C(0x503be9a8c98a4140) }}, {{ UINT64_C(0x6268cd5c28114e9c), UINT64_C(0xd8522fc0cd269280), UINT64_C(0xd9caed64f78300ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0ed39e48566e5bb8), UINT64_C(0x1c6a2a94aaaed8fc), UINT64_C(0x42155ac890c12ad0), UINT64_C(0x78f3aff8e98af520) }}, {{ UINT64_C(0x062ad39c48ac3bd8), UINT64_C(0xbf8a33fc499c5924), UINT64_C(0xbfd3f9f06943dacc), UINT64_C(0xad52bf1cf49debec) }}, {{ UINT64_C(0x6ffd23148c2682c0), UINT64_C(0x730e61a8bc9ad850), UINT64_C(0xf05e2ee823242908), UINT64_C(0x3f95796003a2abd4) }}, {{ UINT64_C(0xeb14aca022b1e354), UINT64_C(0xa927652cc02e1694), UINT64_C(0xf60b18b431790b74), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5b58d12881c56b18), UINT64_C(0xd7f0f440b24bf230), UINT64_C(0x3f99bd3031eb374c), UINT64_C(0x48bd741c209e4b78) }}, {{ UINT64_C(0xca8541f46e380e3c), UINT64_C(0xa7c4ef4c61846ce4), UINT64_C(0x2c0afb0ce511d0d4), UINT64_C(0xdeaa21e89328eb58) }}, {{ UINT64_C(0x5834f9a898037cc8), UINT64_C(0x13458830d154c540), UINT64_C(0xd8c37774f46ea3f0), UINT64_C(0x72eef244f326e23c) }}, {{ UINT64_C(0x18b4f510e8030ba4), UINT64_C(0xe56aa0a0fde515d4), UINT64_C(0xeb4be2fc06355fdc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4bbaed687bb0bbd4), UINT64_C(0xcc22a04c55903258), UINT64_C(0x8d499d948f5720ac), UINT64_C(0xa9e7a660c90e0074) }}, {{ UINT64_C(0x2a87776484c391ac), UINT64_C(0x80175f80405c9220), UINT64_C(0x24ffc67820996fa0), UINT64_C(0xb9a0b11c33961404) }}, {{ UINT64_C(0xa25eda5822a7061c), UINT64_C(0xe7fe646c4b228c00), UINT64_C(0xd2bbd17057b2159c), UINT64_C(0x5cd19b8c41a29888) }}, {{ UINT64_C(0xa3c46c44aeea4b48), UINT64_C(0xcd23aa74d1da6528), UINT64_C(0x6f4588a4ce863e4c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8911e2ccb8058bf0), UINT64_C(0xb448147468f68540), UINT64_C(0x4ba100309bf97548), UINT64_C(0xea831c3c957daa24) }}, {{ UINT64_C(0x71142f3481254fc4), UINT64_C(0x9966e2f45bbd7b0c), UINT64_C(0x4a7b238800f9066c), UINT64_C(0x0eb46c4c8412c638) }}, {{ UINT64_C(0x1a005ca484e9f118), UINT64_C(0x29d1188858f39ba4), UINT64_C(0xf2b39c04c47d68b4), UINT64_C(0x1a7a963ceb38b480) }}, {{ UINT64_C(0xb4f820cc9159aa40), UINT64_C(0x1409d9a46c86852c), UINT64_C(0x85b853449a183564), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x31b2e638aaa888c0), UINT64_C(0x2d50f65c05746638), UINT64_C(0x2c39d314934e7754), UINT64_C(0xba47462490d59b20) }}, {{ UINT64_C(0x0524113c355209b4), UINT64_C(0x601439e8c1bc5e9c), UINT64_C(0xbc3c806c8187ad98), UINT64_C(0xf0eff960e4728ce8) }}, {{ UINT64_C(0x64414ca4cd7121e0), UINT64_C(0x2efc5f64ea0fb748), UINT64_C(0xc4fbee0c063eeea4), UINT64_C(0xfa6ee41048dd8f7c) }}, {{ UINT64_C(0xfcad3834395557c4), UINT64_C(0xfe80000c1e1b8098), UINT64_C(0x95d01908a825e3b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x673fa9bc7efb9d98), UINT64_C(0x8c8b765818c47c54), UINT64_C(0x5f774ea8ec3afde0), UINT64_C(0x4b31a9089f69b2e0) }}, {{ UINT64_C(0x211a80349bd02228), UINT64_C(0xa4de04682b470e7c), UINT64_C(0xa047f4e4eaa9c6e8), UINT64_C(0x713a53988d28b180) }}, {{ UINT64_C(0x95b6bf10852e6054), UINT64_C(0x4b18ab50d0e6e408), UINT64_C(0xaf2abacc748a73b0), UINT64_C(0xd255198084789d30) }}, {{ UINT64_C(0xeaaacda8afa2def8), UINT64_C(0x22d92308a03bb860), UINT64_C(0x13a954505f0bc848), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71db63f086549cb8), UINT64_C(0x047dd084f1869e78), UINT64_C(0xfb6643f879b568d8), UINT64_C(0x58bdfcaca3782eb4) }}, {{ UINT64_C(0x6916cc38d7740930), UINT64_C(0x9ac715348305dee4), UINT64_C(0x2864c19cf40174f0), UINT64_C(0xedc22f5c2a1f5570) }}, {{ UINT64_C(0x932a35c441052464), UINT64_C(0x68a37018e97dc41c), UINT64_C(0x63967a1cd7e6a8b8), UINT64_C(0xe6caf048f1ed4d80) }}, {{ UINT64_C(0x8025567405445658), UINT64_C(0x6893f5c075de2e68), UINT64_C(0x2457488c77792934), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0b18137c143308a4), UINT64_C(0xf60e64204f360ac0), UINT64_C(0x599fb0e060449508), UINT64_C(0x19479fe85e5f0c08) }}, {{ UINT64_C(0x811d8de870815284), UINT64_C(0x2eb38f24a187fbd8), UINT64_C(0x9f067c98f92046f8), UINT64_C(0x089a26b8404255f8) }}, {{ UINT64_C(0x298d6e7cfb60858c), UINT64_C(0xb2745d2ca264e248), UINT64_C(0x7111b5a4252db8c8), UINT64_C(0x25630d6c1e759828) }}, {{ UINT64_C(0xd2cde2c07b8ceb9c), UINT64_C(0x06db88e815b1bc98), UINT64_C(0x7f1c5aa84e8f21dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1f71f828c53d17d4), UINT64_C(0xca42197c3d0ae300), UINT64_C(0x54c9ebac6563287c), UINT64_C(0x4d2d93e8a9f1384c) }}, {{ UINT64_C(0x432844ec85f7c5b8), UINT64_C(0xa47a52dc63731428), UINT64_C(0x66e4169ca40f4e5c), UINT64_C(0xa6c78d04f18dfa00) }}, {{ UINT64_C(0xd98303088c804f58), UINT64_C(0xd76c9ce411834140), UINT64_C(0xc8598da0c822a5b4), UINT64_C(0xa5994dc4c598db48) }}, {{ UINT64_C(0x615e5c2c31c176d4), UINT64_C(0x54e7edc0f50ef080), UINT64_C(0xb5c8886c05e5de68), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7312c7109e48cba4), UINT64_C(0x0e6daf881464a0fc), UINT64_C(0xdb2137c0459226d0), UINT64_C(0x9d1bd5d8e42e1990) }}, {{ UINT64_C(0xf0158cf459899308), UINT64_C(0xa5bf9f688d440e4c), UINT64_C(0x1b87e10041c1df6c), UINT64_C(0x199977d89be6e088) }}, {{ UINT64_C(0x1b9ddf8c34870ce8), UINT64_C(0xbbfb1a1c6ccc3cdc), UINT64_C(0x255cc054e0182128), UINT64_C(0x812d68f8e3896f84) }}, {{ UINT64_C(0xa163ce28550cf614), UINT64_C(0x0c1379f839ec42f8), UINT64_C(0x6160dd24a6529a74), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb26ca924eeb5068c), UINT64_C(0x3bd768a465c0ed00), UINT64_C(0xd0bfff04e85fb4b0), UINT64_C(0x1a1d4384650a192c) }}, {{ UINT64_C(0xa2820008204d4008), UINT64_C(0xfbadf5b45a22847c), UINT64_C(0x50f92fb07057661c), UINT64_C(0xfd3a6c602418cef4) }}, {{ UINT64_C(0xd7753798d6a6ae68), UINT64_C(0x865980cc0ad81c08), UINT64_C(0x52be91985da47d68), UINT64_C(0x07ce54d0eae947b8) }}, {{ UINT64_C(0x3e883cf4adffed04), UINT64_C(0x81365998b05f26d8), UINT64_C(0x9a7cc634c0e9d1cc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbb53b3f8af51f638), UINT64_C(0x4adaf48cc0fa4154), UINT64_C(0x50d959843eaa5900), UINT64_C(0xb24e7cd4f85ab328) }}, {{ UINT64_C(0x6c9c08dc0244c628), UINT64_C(0x3a842150ffc3ae24), UINT64_C(0xae58b4287cbe931c), UINT64_C(0x1bd9e790d7657e28) }}, {{ UINT64_C(0x1e45c23c40de8a34), UINT64_C(0xb9ddcc5402cb7e48), UINT64_C(0x14906f74c28b4594), UINT64_C(0x1c579e1cc341c0dc) }}, {{ UINT64_C(0x5e0865542113568c), UINT64_C(0x645670a4a07fd1e4), UINT64_C(0x9ed897d8aef76570), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x240fd40463badb04), UINT64_C(0xf6a5c348bd1239c4), UINT64_C(0x0ad1ef5cad9560ec), UINT64_C(0x14407c08ccb49350) }}, {{ UINT64_C(0xd292e1e81a1e8618), UINT64_C(0xb6852a5493558e80), UINT64_C(0xfa8b35b4e1678e88), UINT64_C(0x6f2117fc38da6f3c) }}, {{ UINT64_C(0xe05e112c733e7f60), UINT64_C(0x2a550bf0fef66cec), UINT64_C(0x7a14f97caa888af8), UINT64_C(0x1d4fc2a04e4e7a6c) }}, {{ UINT64_C(0xc43927142b876c34), UINT64_C(0xdc872aa826ebe744), UINT64_C(0xb09e8fe0f76b56c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf3daac80e5ec4450), UINT64_C(0xaf28d4a8e2748b58), UINT64_C(0x304639d887461f0c), UINT64_C(0x2db504dcd5d32d18) }}, {{ UINT64_C(0xfe188000a093bbf0), UINT64_C(0x6ec0feac46fc3080), UINT64_C(0x2d865fa09f6e7bb8), UINT64_C(0xba68fd1872e98c78) }}, {{ UINT64_C(0xfcc20ae0822c2bfc), UINT64_C(0xd2c76d5495977434), UINT64_C(0x15b960b4a1c9e654), UINT64_C(0xb5366bd0f469d008) }}, {{ UINT64_C(0xf90affc4a4b83fa8), UINT64_C(0x812398bc8f21e8cc), UINT64_C(0x45ef3310aba165b0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd51e9a90c26e6e68), UINT64_C(0xc32eaac0a2769320), UINT64_C(0xafc64a8052810194), UINT64_C(0xfa1087343c67c7f8) }}, {{ UINT64_C(0x210b9c583ca0ceec), UINT64_C(0xfaa076905981ed74), UINT64_C(0xf38aac0879eb8254), UINT64_C(0x28c693fccd22eb40) }}, {{ UINT64_C(0x21373180a490e448), UINT64_C(0x7169642812c3a520), UINT64_C(0x71307b38ef0248fc), UINT64_C(0xe87a23f0e7a26e8c) }}, {{ UINT64_C(0x8a0e9fe80d944bd0), UINT64_C(0xc209067c9478c52c), UINT64_C(0xcf2ce52c80c7d140), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3703c1d0843c662c), UINT64_C(0x6abd9d48ce323fcc), UINT64_C(0xe1061c7c02bc5500), UINT64_C(0x9b2207647825c394) }}, {{ UINT64_C(0x2c25eec4fb4ecd08), UINT64_C(0x4c685f8c96af22a4), UINT64_C(0xa8cf17c8d504d324), UINT64_C(0xd5f6e358ee8f8d74) }}, {{ UINT64_C(0x499bd79082060be8), UINT64_C(0xfec9b9e8c3da5a54), UINT64_C(0x4ae46544b46da1ac), UINT64_C(0x3b0493601b9c2160) }}, {{ UINT64_C(0xaaca0138c8bfe40c), UINT64_C(0x1b9de3d0b52596e8), UINT64_C(0xf39978809f457e6c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5fd40874972ca0a4), UINT64_C(0x7d5b9e28220263b8), UINT64_C(0x781da5d051e67140), UINT64_C(0xf135888c2d644434) }}, {{ UINT64_C(0xc3f9cea46449bf10), UINT64_C(0x0d86a25c2634c1f0), UINT64_C(0x54d4caec635da7fc), UINT64_C(0x0cdd9684ce39cbdc) }}, {{ UINT64_C(0x2bf3e7d0945dce68), UINT64_C(0x805c5b44a0692e44), UINT64_C(0x3c27ffc8879d1e90), UINT64_C(0x666ce018e8e606bc) }}, {{ UINT64_C(0x2a2d930879b65ce4), UINT64_C(0xc474b63cb79dca38), UINT64_C(0x14eeb5b4d93d5ca4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9b9f56fcb33710a4), UINT64_C(0xcfb8b7c02551436c), UINT64_C(0x15e7db4063116c00), UINT64_C(0x8a44cddc15820758) }}, {{ UINT64_C(0x6b7bf534cf05f79c), UINT64_C(0x3753fbe8e7b16f48), UINT64_C(0x1ec9a9bcfca7fa8c), UINT64_C(0x654746243ec48364) }}, {{ UINT64_C(0xcce1d784a034a528), UINT64_C(0x6cdfe1c031060ca8), UINT64_C(0xe99f16c4ec72a168), UINT64_C(0xd3cb30f8950af818) }}, {{ UINT64_C(0x609d4a6cdb433fb0), UINT64_C(0x8aa857c421177cd8), UINT64_C(0x27b0af20786c3e3c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4209e2fc52668f20), UINT64_C(0x840a51184b166dc8), UINT64_C(0xf441a2bc0d032650), UINT64_C(0x7709081c31a0d6c4) }}, {{ UINT64_C(0x15e2d844d48d09f8), UINT64_C(0xaf7c0d546850d63c), UINT64_C(0x25ecff004fec9904), UINT64_C(0xd9b31a04c38282a4) }}, {{ UINT64_C(0x7f74b89cc32f4424), UINT64_C(0x002c188010d7b540), UINT64_C(0x428d154cb9fe9e34), UINT64_C(0xc2219c20edf8cb4c) }}, {{ UINT64_C(0xb3042e90bf149604), UINT64_C(0x773ab720face9998), UINT64_C(0x10953924cd2b688c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6c6ad1cc397d4f20), UINT64_C(0x3048fd60b64ced20), UINT64_C(0x726068306dbabbf8), UINT64_C(0xe53e21cc2931c98c) }}, {{ UINT64_C(0x8dbe895cdaf20ab8), UINT64_C(0x6466f3b8de9417e8), UINT64_C(0x245803c030241e84), UINT64_C(0x3e5b5cfcc1470b2c) }}, {{ UINT64_C(0x02a809a823597514), UINT64_C(0x29fe7920f510ec54), UINT64_C(0x9299303819e64818), UINT64_C(0x6a790850e6027744) }}, {{ UINT64_C(0x2eb7381c9210c620), UINT64_C(0xfdd328d4059939c0), UINT64_C(0xdd6f231474760c30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x70e7d0e473b1d554), UINT64_C(0x72a68f7cef3a5c0c), UINT64_C(0x86bba3b8ae086ac8), UINT64_C(0x560c2cb076586d60) }}, {{ UINT64_C(0xff73ba80f9e80088), UINT64_C(0x26ddfb3c3ebe96f0), UINT64_C(0x6f3bc868ffce4fe4), UINT64_C(0x410fe25c38f5d1ac) }}, {{ UINT64_C(0x4245aca04482815c), UINT64_C(0x6b6e1570141a05d0), UINT64_C(0xb3c3f2c0f27493c4), UINT64_C(0xef32f8cc75fd30ec) }}, {{ UINT64_C(0x257012b4f5f0dd1c), UINT64_C(0x12a54ad86f3fd8a0), UINT64_C(0xb9c4b29c9edc1890), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xefca0c8c3ec451e8), UINT64_C(0x263c8ae46ba30a70), UINT64_C(0xc0329bd4a24fc9f8), UINT64_C(0xf07eb984b8ca800c) }}, {{ UINT64_C(0x5e4b07705956a730), UINT64_C(0xdd8417cce9753394), UINT64_C(0x1ed66ac864fcb38c), UINT64_C(0xf2280714e5dcde08) }}, {{ UINT64_C(0xc040e544ff13c888), UINT64_C(0x2340399467caf048), UINT64_C(0x40f2a60806b0d570), UINT64_C(0xfddcfeb89f14d178) }}, {{ UINT64_C(0x09acd28c27756ac4), UINT64_C(0x3bf922289f06a7ac), UINT64_C(0x5c7f4fe4bca94708), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe33ae31cf76deab4), UINT64_C(0x670139fc37665c20), UINT64_C(0xb12d7440933f98d0), UINT64_C(0x1a1b6c709495efbc) }}, {{ UINT64_C(0x899a6934b57bbe78), UINT64_C(0x27e6b13c06929f80), UINT64_C(0x7a3a860cb247436c), UINT64_C(0x8761309cc5ebee40) }}, {{ UINT64_C(0x65b2b438f082a354), UINT64_C(0x6014afa03d91c970), UINT64_C(0x35049bf8b617331c), UINT64_C(0x6703c9ec80127a0c) }}, {{ UINT64_C(0xb14c7e40868ca8e8), UINT64_C(0x6b3302d44cf1e288), UINT64_C(0x0ac8c8e4bc6cd04c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x14f9c7e87f5eecf8), UINT64_C(0xc20539c8e02ab348), UINT64_C(0xc0048834e9d6d8d8), UINT64_C(0xb291f150c27e28d0) }}, {{ UINT64_C(0x8ddcb964752de058), UINT64_C(0xce3e8c24c95ebeb4), UINT64_C(0xd4e651106c2fc2a4), UINT64_C(0xac08a41c08bbec04) }}, {{ UINT64_C(0xf475acfc13d5c338), UINT64_C(0x6d16df2c92f79ca0), UINT64_C(0x86388ff849cb9970), UINT64_C(0xba1b4ebc46894960) }}, {{ UINT64_C(0x16bcb934a8f7ec6c), UINT64_C(0x4889cd1c58b31cd8), UINT64_C(0x343e9cf410c25c34), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdd330a2828873d14), UINT64_C(0xe5abd5a834a265f0), UINT64_C(0x4b022320ec73326c), UINT64_C(0x01ed46d4ce641dac) }}, {{ UINT64_C(0x4e17da642ab730f0), UINT64_C(0x21f9520cf9ce9a44), UINT64_C(0xa65c0e94c85dbb14), UINT64_C(0x52ff9a74ca3e1ac8) }}, {{ UINT64_C(0xf622a5782198d25c), UINT64_C(0x18675b90caec9020), UINT64_C(0xb12d99e0d06f2920), UINT64_C(0x8c0bbed43c96e9f0) }}, {{ UINT64_C(0x85e57b40b5339314), UINT64_C(0x8bbe088465a5ee08), UINT64_C(0x79d5cea482d94d94), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdab8b6fc6e512024), UINT64_C(0x1c2b57741480eb24), UINT64_C(0xd05817f87e9baee8), UINT64_C(0x33e6d20c338e3604) }}, {{ UINT64_C(0x5a772cacb8c33950), UINT64_C(0x9af7926c5ad58178), UINT64_C(0x661e6cb04b1abaa4), UINT64_C(0xdb0a7eb86af4e5e4) }}, {{ UINT64_C(0x995053305043b63c), UINT64_C(0xdbfa8d00c1b22180), UINT64_C(0xd644b4bc3ea8d488), UINT64_C(0xe41a8120f6fb115c) }}, {{ UINT64_C(0x10bc92446c4f3cd8), UINT64_C(0x31f64dc02fd9328c), UINT64_C(0x72164bd807b17f5c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x972858589617f5b8), UINT64_C(0x534261583adf9168), UINT64_C(0xbb6afbb8ca201ce0), UINT64_C(0xae6fc70029370200) }}, {{ UINT64_C(0xe4c6ce44dc6e1120), UINT64_C(0x67f25ac4fb0df018), UINT64_C(0x05f2e2d8aac0ad44), UINT64_C(0x4aab86ac1a6307d0) }}, {{ UINT64_C(0xd555adc037984a08), UINT64_C(0xe38258980a525070), UINT64_C(0x4feedeec812cb50c), UINT64_C(0x01801bc8bc0daae0) }}, {{ UINT64_C(0x4df16d3c612b9c18), UINT64_C(0x83e7fa3460cb3bb8), UINT64_C(0x9a3a7ed43e214b20), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5bbe343c105347f0), UINT64_C(0xf7feabdc93b9e960), UINT64_C(0x2c1e887cee2a50f0), UINT64_C(0x5074beeced705bfc) }}, {{ UINT64_C(0x177d1fe05fbcf274), UINT64_C(0x4a1a38b481d23eb0), UINT64_C(0x438e3ee46435d9cc), UINT64_C(0x0f0355785e86f644) }}, {{ UINT64_C(0x6c05fc2cf5107c68), UINT64_C(0xed422b54ab9676bc), UINT64_C(0x6c44a9a490dd7370), UINT64_C(0xdad18c54ab9bc704) }}, {{ UINT64_C(0xb37fa4e0091555b4), UINT64_C(0x21329140d6fc0370), UINT64_C(0x686519d4d9eed8f0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb0cbb6cc6befae28), UINT64_C(0x78400ddc02cab6b0), UINT64_C(0xf4411318a8d81708), UINT64_C(0x519eaa1c10f33f7c) }}, {{ UINT64_C(0x47077ebc861fbec8), UINT64_C(0x42f6a444102ef5e4), UINT64_C(0x3d0ef9d4a2425d14), UINT64_C(0x18d656c4282c6578) }}, {{ UINT64_C(0xdd72b8cc9deefb18), UINT64_C(0x08d8543c1c74d0d0), UINT64_C(0x7777965c1e88fc70), UINT64_C(0x2a59f1643ad34af8) }}, {{ UINT64_C(0x34f6f4e83bba3bfc), UINT64_C(0x6cbb08b066cbb870), UINT64_C(0xb960ff1c38c6ecb0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x235c417c7cc31458), UINT64_C(0xce463fc88dd1ac58), UINT64_C(0xb6ac1e001754e1e0), UINT64_C(0x5772eff06e578588) }}, {{ UINT64_C(0xeba9c3f40e7f7fec), UINT64_C(0x2a6e275020038e9c), UINT64_C(0x63cc72ac367b2ed4), UINT64_C(0xf16982446a8a7e3c) }}, {{ UINT64_C(0x9a5344ecfac58c9c), UINT64_C(0x73cff7c8b9abe5bc), UINT64_C(0xb4b1abb86523a318), UINT64_C(0x9478846c79db8814) }}, {{ UINT64_C(0x14956634c536b754), UINT64_C(0x7007e3506eec9ef0), UINT64_C(0x599b57608b2304bc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb39cd98a83b6524), UINT64_C(0x2f6304c8a5a3e5f8), UINT64_C(0x6d2d46902dc1e500), UINT64_C(0x18a4f658c4c5aaec) }}, {{ UINT64_C(0xd9fce25c5575ab80), UINT64_C(0x61bef2181fb40d84), UINT64_C(0x6ff8eeb85dad9de0), UINT64_C(0xc4c59a8c6c7f0294) }}, {{ UINT64_C(0xdfe5f20c837e602c), UINT64_C(0xa8a058486f8e189c), UINT64_C(0xa0d07cfc4251abec), UINT64_C(0x669b51a48860797c) }}, {{ UINT64_C(0x5b55c2bced97a7b4), UINT64_C(0xd5aa46a42c5dcf24), UINT64_C(0x545cf6606c0b6e30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x45bf1160454b0c8c), UINT64_C(0x41417f54148dace8), UINT64_C(0x59812cbc474a1510), UINT64_C(0x0fd5cad0b298c78c) }}, {{ UINT64_C(0x025fda6897a8ff00), UINT64_C(0x885ad680457c9700), UINT64_C(0x40ac90e8c5fb5848), UINT64_C(0x289c8b0c55c6e4b8) }}, {{ UINT64_C(0x9e610ec80ed06b60), UINT64_C(0xcf333e0cfd5a128c), UINT64_C(0xcd3b6a4c74971fb0), UINT64_C(0xb96c0340dc907e50) }}, {{ UINT64_C(0xa1344e40c032c054), UINT64_C(0x3e6219fcd2ffaebc), UINT64_C(0x5a8170a43e234008), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x797d511085e43260), UINT64_C(0x5d2c77382ca52eac), UINT64_C(0x7ba3e21830a5f404), UINT64_C(0x5beeb8c44f0a4f1c) }}, {{ UINT64_C(0xd3832af46461a868), UINT64_C(0x816da03c75599a54), UINT64_C(0x6e124028d67a448c), UINT64_C(0x07eb09344a11985c) }}, {{ UINT64_C(0xebc2a52c4d01a878), UINT64_C(0xd969e378fdbe0340), UINT64_C(0x4a2372c466827794), UINT64_C(0xac9725cc026932f4) }}, {{ UINT64_C(0xb9298cec9f53495c), UINT64_C(0x44d6b4d8eac1a5e4), UINT64_C(0x1f4062a428bcb800), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa5a852a4df431a00), UINT64_C(0x7229a038620547d4), UINT64_C(0xfe4529f844ceb030), UINT64_C(0x64401eec108847d8) }}, {{ UINT64_C(0xc88d462497b3f4a8), UINT64_C(0x6dd7b874a210eab0), UINT64_C(0x31109628649249f0), UINT64_C(0xaaae51f441630d98) }}, {{ UINT64_C(0x4311b1f8890ec1bc), UINT64_C(0x87021b64268140f0), UINT64_C(0x81d490342866ead8), UINT64_C(0x687c85d87b3bb450) }}, {{ UINT64_C(0x0e845eb8b9baed9c), UINT64_C(0x298085e8c65a31dc), UINT64_C(0x0506ef282ec1fb78), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x298b59b09011e2c4), UINT64_C(0x0d14f9f4d6f48d2c), UINT64_C(0x854549dc04d6828c), UINT64_C(0xddd2e4f83ad135e0) }}, {{ UINT64_C(0x71fa7ac081f050d8), UINT64_C(0x251cdb9c9cc80838), UINT64_C(0x77832f50078407f4), UINT64_C(0x54b8ca08c30fd59c) }}, {{ UINT64_C(0x57555e90d9e42d98), UINT64_C(0x49d2c2180513e974), UINT64_C(0x91e33418b60190e4), UINT64_C(0x8eabfb70be63f984) }}, {{ UINT64_C(0xa2b7850063ef7adc), UINT64_C(0x19a013900b2606c4), UINT64_C(0xbbfa03e8db1d43dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd2cefc108b5df748), UINT64_C(0x8b996f44d5b618c4), UINT64_C(0xb14bf0eca5b2e57c), UINT64_C(0x5130fae8cff3e114) }}, {{ UINT64_C(0xdd326a1cf4369d14), UINT64_C(0x5fa87030c77b1c98), UINT64_C(0xd08c3124d8c8ac08), UINT64_C(0xc5fd5a740803b3d4) }}, {{ UINT64_C(0xd5355550ddc36da0), UINT64_C(0x857abf38d151443c), UINT64_C(0xc53eaf1ce9a45a08), UINT64_C(0xe8d6fac8be88ec50) }}, {{ UINT64_C(0x6f7b0b3457cddbd0), UINT64_C(0x4d4c1038a64454d8), UINT64_C(0xe3ce494099ef03b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeff9af7cc2f34a6c), UINT64_C(0xfa26c5bc9e3f2e88), UINT64_C(0xe57bc55464142414), UINT64_C(0x58acbe505f399c10) }}, {{ UINT64_C(0x6293939caccc3954), UINT64_C(0x585daf883d20cf90), UINT64_C(0x795de958b2c1e174), UINT64_C(0x41d5f7c02b72c988) }}, {{ UINT64_C(0xbcc5b4805d4a3f4c), UINT64_C(0x6a95be20506cb4dc), UINT64_C(0x47035c1060f07e5c), UINT64_C(0x6762b298228e0b00) }}, {{ UINT64_C(0x2efef0b41eaaca40), UINT64_C(0x0edc38ccc894945c), UINT64_C(0xdc9edfd4628ecb88), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x870caaeccac1fa7c), UINT64_C(0xe0d4c8688f2c7550), UINT64_C(0xc23537f802d0a94c), UINT64_C(0x5f463d584311a934) }}, {{ UINT64_C(0xcf81ae2ccaabf7e0), UINT64_C(0x54363aa878476a20), UINT64_C(0x5ba75e6c11445338), UINT64_C(0xb595202092df6104) }}, {{ UINT64_C(0x27b42e1015a9e6f8), UINT64_C(0x6c87af7cf7ff75d8), UINT64_C(0x6378de90c14f9dc8), UINT64_C(0x2a8f26ece6049778) }}, {{ UINT64_C(0x446cb00c9b1f7b2c), UINT64_C(0xe6f968505fefb8c4), UINT64_C(0xf051735ce146fe30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x344ad67caeddb4b4), UINT64_C(0xd8408f4c77e8187c), UINT64_C(0x3cac2310a86311d8), UINT64_C(0x32a81ce4c090fb34) }}, {{ UINT64_C(0x46a4d8b0f85a9ff8), UINT64_C(0x20fa5b9822afe08c), UINT64_C(0x812cae3018cdd098), UINT64_C(0x59c34d64c3396de0) }}, {{ UINT64_C(0x943d0b882434f00c), UINT64_C(0xf4b874505fbd67e4), UINT64_C(0xde52577cef5f053c), UINT64_C(0x421504040b4d7b30) }}, {{ UINT64_C(0x3c6dd1cc94d419fc), UINT64_C(0x376b2c2810dc5ef4), UINT64_C(0x6d032d8ce80e99d8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x47313a6439c7fdd8), UINT64_C(0x37a9a4904316dbcc), UINT64_C(0x00a0792454a779bc), UINT64_C(0x19702d98335427f4) }}, {{ UINT64_C(0xaf914f94cfc8f6d0), UINT64_C(0x4388374c0ab0a458), UINT64_C(0x9066b81088eae918), UINT64_C(0x994b9450c187d78c) }}, {{ UINT64_C(0xc82fe6705737e200), UINT64_C(0x9cc7dcacdae73590), UINT64_C(0xcc12740c92f9e2e0), UINT64_C(0xcb0c036c9d4b42a4) }}, {{ UINT64_C(0x7be42168ea21bcd4), UINT64_C(0x23feb6d849bc9868), UINT64_C(0x218e375472da62e4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9ce2e25c7e73d6bc), UINT64_C(0x0070146c4c4d9d4c), UINT64_C(0x3c179750fee56d70), UINT64_C(0xd2f5e2c4ccd6134c) }}, {{ UINT64_C(0xafe25e9820e3e1c4), UINT64_C(0x291d1c34e05dadac), UINT64_C(0xab4caaf0074e7c8c), UINT64_C(0xf070060093a8eed0) }}, {{ UINT64_C(0x837b8fcc46374de8), UINT64_C(0xb32cfe3c5cc1fa64), UINT64_C(0x8d9f0ba0d1f570a0), UINT64_C(0xcd6b0d643596ba80) }}, {{ UINT64_C(0x42f1e06049f3e11c), UINT64_C(0x80e68c648a01b228), UINT64_C(0x869b1e9cf6755350), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcc18681cc89d705c), UINT64_C(0x420d1c40304de0b0), UINT64_C(0xd661ab70796f070c), UINT64_C(0xe1619354afd5ae08) }}, {{ UINT64_C(0xfcef2854676cdff0), UINT64_C(0x2bfc45504eddea6c), UINT64_C(0xfd729a38474063a8), UINT64_C(0x98fb37fc4abd55b0) }}, {{ UINT64_C(0xcd6df8189a8600c0), UINT64_C(0x326a666cce23ec08), UINT64_C(0xd96c590011bddfb8), UINT64_C(0xb1044d703a660bdc) }}, {{ UINT64_C(0xbf9dda0cd6ace784), UINT64_C(0x66320060959c9828), UINT64_C(0xc18c11ac3b86eae8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4444ffd4aebde6d0), UINT64_C(0xf25405c4a70e6b0c), UINT64_C(0x936e6b3c051b2614), UINT64_C(0x28dc271ced63b9bc) }}, {{ UINT64_C(0xed00dcd42c33a228), UINT64_C(0x830d868cc3c8bc60), UINT64_C(0x30d64af07d5cfb50), UINT64_C(0x54022344012a749c) }}, {{ UINT64_C(0x545fc104d8b901e8), UINT64_C(0x53e4a70ccb893008), UINT64_C(0xee5f6cac0868a0b8), UINT64_C(0xad3a90108d2dcff4) }}, {{ UINT64_C(0x88b30af0fb23c57c), UINT64_C(0x2a47e9a88b4d6f50), UINT64_C(0xc2c63fc4b1c1e0f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaa24f2989ac7f100), UINT64_C(0xa03da79c607dde54), UINT64_C(0xa5200e488dff0264), UINT64_C(0xf8c1e5d43667a090) }}, {{ UINT64_C(0xe537e1345afb2ca4), UINT64_C(0x7c10b840f33517cc), UINT64_C(0xaf01cc1c380a9a40), UINT64_C(0x045cf690aa40adf8) }}, {{ UINT64_C(0xd6ac6538ced162dc), UINT64_C(0xc88b1aa8cd29156c), UINT64_C(0x11c6a36c8e6be8a0), UINT64_C(0x0d4dac241feb3ff0) }}, {{ UINT64_C(0xaa0db7d4cb1cb0d4), UINT64_C(0x09f036103c7d562c), UINT64_C(0xe1367718d7e09e08), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd98d2248bf5b5e3c), UINT64_C(0xec54c920a587359c), UINT64_C(0x54a6623c95e286c4), UINT64_C(0x5420957c94be75f4) }}, {{ UINT64_C(0x71a0e5087a47df90), UINT64_C(0xf895e2f0437af58c), UINT64_C(0x9c94fdfc5b225228), UINT64_C(0x72070274ed7e0560) }}, {{ UINT64_C(0xda248eb07dc205e4), UINT64_C(0x097297e41d81948c), UINT64_C(0x09c96040bcc744e0), UINT64_C(0x90b49fc82d345dac) }}, {{ UINT64_C(0x68697b6081548640), UINT64_C(0xb5603978d0496218), UINT64_C(0x98c2913cf91534b0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9af85ec8d03f37e8), UINT64_C(0x593b642c2436914c), UINT64_C(0x2e2a36b41fda9354), UINT64_C(0x4e9d82803cde7a6c) }}, {{ UINT64_C(0x07dc7e64bce18e44), UINT64_C(0x67b6c58430652694), UINT64_C(0x85e3e92c3e0cbc58), UINT64_C(0x80c467308c9f1f84) }}, {{ UINT64_C(0x11e8c2dc54974f8c), UINT64_C(0xb91e821860d525c4), UINT64_C(0xee6ecde41453899c), UINT64_C(0xd40a5db436e7e5c4) }}, {{ UINT64_C(0xb906d1187ca78980), UINT64_C(0xc0753d78b1d76858), UINT64_C(0x4f460e0c1aea2e68), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x81d40d101ddcc734), UINT64_C(0xa0876d548e13839c), UINT64_C(0x555fe9eccc8cfcd4), UINT64_C(0x3a4bd4b44c5f53b4) }}, {{ UINT64_C(0xa1740f2cc3994880), UINT64_C(0x81923b4431933fdc), UINT64_C(0xce4053a8d44fb5a8), UINT64_C(0x95a06220eeab6664) }}, {{ UINT64_C(0xf29a8dacf8565698), UINT64_C(0xaed8814462396c5c), UINT64_C(0x661441bc7c45a468), UINT64_C(0x90843c5cd6e45998) }}, {{ UINT64_C(0x1306f314e0f05fc4), UINT64_C(0xe7d88b30ecca5b4c), UINT64_C(0x88c9618cb4d84904), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x769e4f4c9947ce90), UINT64_C(0x8e6fa3207131af64), UINT64_C(0x3342bbb0df6d9e34), UINT64_C(0x91143834fd64c414) }}, {{ UINT64_C(0x895afb08bcdc0bec), UINT64_C(0x48840fecf7cb04b4), UINT64_C(0x2267de94b7560578), UINT64_C(0x0d60181c3e8608d4) }}, {{ UINT64_C(0x6657fddc32386180), UINT64_C(0xbd2d67407cefd288), UINT64_C(0xba0b62540137523c), UINT64_C(0xd135fbb8f2449f14) }}, {{ UINT64_C(0x6b433814b781e998), UINT64_C(0xb00054b48f85e918), UINT64_C(0xc6fb3e74c010184c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7cc359f0c22bd82c), UINT64_C(0xcbd53cd8011d400c), UINT64_C(0xaad8b93857f05df4), UINT64_C(0x53d82cbcc5402824) }}, {{ UINT64_C(0x47c66c90f1453280), UINT64_C(0x0484c6fc87e93790), UINT64_C(0x766f95fc9bd47ff0), UINT64_C(0xea3999381c895514) }}, {{ UINT64_C(0x070ffc7cd0c795b0), UINT64_C(0x4f45f4240dfc38b0), UINT64_C(0xd0a3dd60d79f03c0), UINT64_C(0x1c29d660d19f683c) }}, {{ UINT64_C(0xfb44c84803f75ab4), UINT64_C(0x6fcd429418c1cea0), UINT64_C(0x2ad4b808ae9f3b94), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x94a6f8a0d0b46230), UINT64_C(0x6288fff4b283f0f4), UINT64_C(0xf51160f088e00158), UINT64_C(0x564391605de47c2c) }}, {{ UINT64_C(0x9046d4dcfb325800), UINT64_C(0x162fc678e7596544), UINT64_C(0x0c7e83944148b15c), UINT64_C(0xf4183e30a5eb4878) }}, {{ UINT64_C(0xa60655004425a0f4), UINT64_C(0x0ce0b9a04d5733c0), UINT64_C(0xa91b3950315d2978), UINT64_C(0x7af854d0a8962564) }}, {{ UINT64_C(0x180959c4fe3ef7d4), UINT64_C(0x840f467423c2f218), UINT64_C(0xbfc9d3385f5e3458), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf859df4424c8e650), UINT64_C(0x36cd5164e3b7a520), UINT64_C(0x0b25892c8855a518), UINT64_C(0xce26b298de403bf8) }}, {{ UINT64_C(0xb3f6c44862e29c58), UINT64_C(0xe7e3683c3b4bf5bc), UINT64_C(0x5c0a3250d4e788ec), UINT64_C(0x84edd6bcef27ea54) }}, {{ UINT64_C(0x35b3a04ce042f6fc), UINT64_C(0xc96c3604adf39d08), UINT64_C(0xe8ef77fc1cf495b0), UINT64_C(0x5e1828b89c7367b8) }}, {{ UINT64_C(0xa2fcab54a062616c), UINT64_C(0xc4ccd5dced56cabc), UINT64_C(0xd63a231047635660), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xff313c9065e05a08), UINT64_C(0x8349cc045fbebaf4), UINT64_C(0x37db9f04866f6278), UINT64_C(0xf7107c4ce171bbe4) }}, {{ UINT64_C(0x23405a949133a61c), UINT64_C(0xa8ffd8c89d369998), UINT64_C(0x75076c04d1eaf428), UINT64_C(0x528ee104888c580c) }}, {{ UINT64_C(0xf28e0850ddff1008), UINT64_C(0x5fbc89c4e87466ec), UINT64_C(0xe9b375507fbc06cc), UINT64_C(0x1cf837c8ac839840) }}, {{ UINT64_C(0x982e93f4babb1704), UINT64_C(0x7856b85006fb50e8), UINT64_C(0xa0b6c794ed79fb30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x615751e44bc29148), UINT64_C(0xdbaefb60f4be210c), UINT64_C(0x8c3b0ad8467f447c), UINT64_C(0x39443b449615af80) }}, {{ UINT64_C(0x3f072f80c46b263c), UINT64_C(0x2286894897755b98), UINT64_C(0x6751782413f7891c), UINT64_C(0x5595c938b0bc18ec) }}, {{ UINT64_C(0x15bb6fd083f3c648), UINT64_C(0xd31cbcb841c4e3a8), UINT64_C(0xc5e3e008e8fb632c), UINT64_C(0x2cde0854b00db948) }}, {{ UINT64_C(0x7604e57c02e5a7dc), UINT64_C(0xad77947cbbcbeaa8), UINT64_C(0xc4921f3881899190), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3decd648b1e51bf0), UINT64_C(0xc2f36024fbadebc4), UINT64_C(0xbd238214cea65168), UINT64_C(0xcb2bc0f4b9bca754) }}, {{ UINT64_C(0x52308d9c710b8638), UINT64_C(0xd7a8c3ecdc242e58), UINT64_C(0x0adb63040904212c), UINT64_C(0x4a48745c53aa021c) }}, {{ UINT64_C(0xe183274c2ee609f0), UINT64_C(0xb222e760c6ebc05c), UINT64_C(0x8c708158a23dbc7c), UINT64_C(0xac337c0c54bde130) }}, {{ UINT64_C(0x6cba66744bdef7cc), UINT64_C(0xa1e875e4eaa39704), UINT64_C(0xfa7f8c9c2aa6ede4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe037c9985e7d9f04), UINT64_C(0xec0e1470fdc9eccc), UINT64_C(0x1ce11800c253ee28), UINT64_C(0xd8a3aee4388d02f4) }}, {{ UINT64_C(0xb992bc5c434bdb44), UINT64_C(0x35c419081db4fafc), UINT64_C(0x0c2978d45145e78c), UINT64_C(0x831d321000a875ac) }}, {{ UINT64_C(0xa730bda01c606a98), UINT64_C(0x712a1bbc34ab518c), UINT64_C(0xf6e8e870c1853138), UINT64_C(0x571ef67c13d9d6b4) }}, {{ UINT64_C(0xdd42299022d4a838), UINT64_C(0x6d140138ae201e1c), UINT64_C(0x6d9cc1a860bdf0a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x69d96c0890b94dd0), UINT64_C(0x625376e8db90c728), UINT64_C(0xbaed62ccab580fac), UINT64_C(0xf34f8858fd753274) }}, {{ UINT64_C(0x1e5465e84df21f14), UINT64_C(0x15a91528c7750454), UINT64_C(0x4c877bf0b0407d28), UINT64_C(0x45fc7df81d595494) }}, {{ UINT64_C(0xe136a980f91d4138), UINT64_C(0x6ce639e8b8abb718), UINT64_C(0xe601cf94de890408), UINT64_C(0x98cdc12c92a75358) }}, {{ UINT64_C(0xf3f3f58c27780674), UINT64_C(0xe60c7fe4ec78ff8c), UINT64_C(0x39bb9f0cdcdd3de4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x58428ca49d1573e0), UINT64_C(0x8c8987ace35742fc), UINT64_C(0x0cebb7487a55b818), UINT64_C(0xe835d99c09e13cf4) }}, {{ UINT64_C(0x5115065408125c58), UINT64_C(0x1284d4c4fcff4d7c), UINT64_C(0x34835f68ef71a95c), UINT64_C(0xe307f0bc0ab70e7c) }}, {{ UINT64_C(0x57c2979ca895a210), UINT64_C(0xf64f7284bbbab6fc), UINT64_C(0x02eb395cb83f8320), UINT64_C(0x61fb60782a5dcc24) }}, {{ UINT64_C(0xedf6f3b8f45718e4), UINT64_C(0xae8e7d409b5f1f20), UINT64_C(0xc7a0e26064fcc224), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xebdeb62cc44123e0), UINT64_C(0x967f8bf031c45e64), UINT64_C(0x9f36a4a84c316fb8), UINT64_C(0x7628d9b4137be9e0) }}, {{ UINT64_C(0xf381d0e0d2e66548), UINT64_C(0xd27910cce04c23d0), UINT64_C(0x40cd17f03c987a2c), UINT64_C(0xffc87d8867b0a5fc) }}, {{ UINT64_C(0x6a0aeabc090e17dc), UINT64_C(0x927227043657af24), UINT64_C(0xf03ab3b8beb72e34), UINT64_C(0x5e1b0338167762ec) }}, {{ UINT64_C(0x65740278b2c5ac50), UINT64_C(0x0f98f0c0e3ce367c), UINT64_C(0xf30a19742985f4e4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0aead5f0dfb19820), UINT64_C(0x680e6dc8d89c8570), UINT64_C(0x61dddfd4fabae090), UINT64_C(0x5e950890330c4548) }}, {{ UINT64_C(0x28b7676c08fb0804), UINT64_C(0x3392b984dd23da94), UINT64_C(0xa4da77706e813590), UINT64_C(0xf8a53080d38837b4) }}, {{ UINT64_C(0xa1ad53e8ad11be5c), UINT64_C(0xdbd23ef815d7d5a8), UINT64_C(0x357c92b442ce325c), UINT64_C(0x679f9838460a1f78) }}, {{ UINT64_C(0xe343c3b0e7ebb820), UINT64_C(0x4efd322866774290), UINT64_C(0xb971e5740f2d364c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x99ecd0786340ea10), UINT64_C(0x7f60f0d05cc46cc8), UINT64_C(0x5ef6294c9134ad3c), UINT64_C(0xa4142aa85825d714) }}, {{ UINT64_C(0xf4e58744f65f2a24), UINT64_C(0xe6440d1077bc7e6c), UINT64_C(0x732d506cd6fcf4c4), UINT64_C(0x97984ca468c34f80) }}, {{ UINT64_C(0x8c750a7ceca4b460), UINT64_C(0xd023b6503b742ee0), UINT64_C(0x58b6c2642c0323e0), UINT64_C(0xec7bb608ec1f1320) }}, {{ UINT64_C(0x82cb8fc403f08318), UINT64_C(0x2b1bfec8cea42b1c), UINT64_C(0xf5c4322412e5ef7c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x424061f81a155530), UINT64_C(0xf730cf100db556f4), UINT64_C(0xe6537d44f65fda40), UINT64_C(0x099e4e0809df5bc0) }}, {{ UINT64_C(0xa632bc5841eed254), UINT64_C(0x6f255ae8f4b2d684), UINT64_C(0xdb3ec250ab606954), UINT64_C(0xb7220b88aafde498) }}, {{ UINT64_C(0x2d29100c27bef190), UINT64_C(0x977d475cbf6959b0), UINT64_C(0x0900951c4b3c34a4), UINT64_C(0x6b3779f8c28345e4) }}, {{ UINT64_C(0xfd0c83bcb4157ba0), UINT64_C(0x3c08d5a8983be540), UINT64_C(0x1d966618e3d75e44), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb52f19e030763074), UINT64_C(0xca082e6c56463ce4), UINT64_C(0x73fe7e1484022390), UINT64_C(0xdcbf98240569f274) }}, {{ UINT64_C(0xf1d18f44a9341098), UINT64_C(0xb571fe7802751850), UINT64_C(0x4cd1f6a48fa1bbcc), UINT64_C(0xdf9dd380ebb70cb4) }}, {{ UINT64_C(0x4e75622867dd1e98), UINT64_C(0x3c84c454468d0870), UINT64_C(0x8c531788b74cfef0), UINT64_C(0x11e01b2849844b54) }}, {{ UINT64_C(0xf3eca6545e1ed9e4), UINT64_C(0xcb6a84acbb57962c), UINT64_C(0x15f3786c68f8b548), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf811d8c85201e540), UINT64_C(0x6df2f8dc3e274c80), UINT64_C(0x0a7afea47b2d5238), UINT64_C(0xf230744826dcf254) }}, {{ UINT64_C(0x81d52bd0e7c4dc98), UINT64_C(0x331532080c8a6f44), UINT64_C(0x5c1b6120a9755cb8), UINT64_C(0x1ef898e4a8d47960) }}, {{ UINT64_C(0x964df43837ff77e4), UINT64_C(0xe6fbdf343a119818), UINT64_C(0x2a4d90c48ef1e834), UINT64_C(0x9c6d3b0c27a05000) }}, {{ UINT64_C(0xfb0d39005b197dd8), UINT64_C(0xd4190ff0d02ccc70), UINT64_C(0x9278450890fe0e8c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1424f13c84e8b174), UINT64_C(0x98b05718e3935120), UINT64_C(0x64460ea4d5f3e978), UINT64_C(0xcf3bbff8664760ac) }}, {{ UINT64_C(0x8517c9142c8a4fd0), UINT64_C(0x1784828cad66ff38), UINT64_C(0xc9ace2308759c8ac), UINT64_C(0xc24e08940b4fd094) }}, {{ UINT64_C(0x61aaa864c0e0878c), UINT64_C(0xd900dee4497aaf20), UINT64_C(0x33d85f74968a15b0), UINT64_C(0xc00081e07e7d86a8) }}, {{ UINT64_C(0xe1ce2f08fa31a164), UINT64_C(0xfc1ffcb07600320c), UINT64_C(0xa14a2a180ab6c254), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x62ec0448074a8c38), UINT64_C(0xdf2cf1e8ba739aec), UINT64_C(0x7138e8fc6ce19878), UINT64_C(0x883da4d0333405f4) }}, {{ UINT64_C(0xc677b9e40d2083e4), UINT64_C(0xef5bd34404e9e668), UINT64_C(0x0d00d8d8c478ab98), UINT64_C(0xb51c4ff0c3e2b098) }}, {{ UINT64_C(0xd8f80854e33c8bac), UINT64_C(0x8190c7c090e9c3a8), UINT64_C(0x9db158dc111b75b0), UINT64_C(0xc86588705c402008) }}, {{ UINT64_C(0xa073eb609da38b28), UINT64_C(0xb0f3d4c498ded2f0), UINT64_C(0x1f819360b8b21c1c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2959f1ccfbd52528), UINT64_C(0x8a1b1174c310d9a8), UINT64_C(0x825be36c372fca9c), UINT64_C(0xb9f2e828126c784c) }}, {{ UINT64_C(0x6d84ccb449aabfc0), UINT64_C(0xaafd86d82796b68c), UINT64_C(0xb065913094995348), UINT64_C(0x76fee46450c636d4) }}, {{ UINT64_C(0x9be602980765c6b8), UINT64_C(0x340e133422372d60), UINT64_C(0xb8cd769851680934), UINT64_C(0xe774bf04369a5504) }}, {{ UINT64_C(0x146c9fec0e870680), UINT64_C(0x6fd691a8ff2398c8), UINT64_C(0xb5f171009656f6c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x16d8c8a09b1e70b0), UINT64_C(0x9e8ac3e8fa596ca8), UINT64_C(0x21666adcd32c2b84), UINT64_C(0x04f4c77c4545952c) }}, {{ UINT64_C(0x4696432441157a0c), UINT64_C(0x400caa9876c7feb8), UINT64_C(0xc3477e488999ae9c), UINT64_C(0x64d85e1cacf8255c) }}, {{ UINT64_C(0xa5bd14cc35b55344), UINT64_C(0x6ee317c07bda4f48), UINT64_C(0x9c98ad64b1b02bb4), UINT64_C(0xd1e5d614054f7b60) }}, {{ UINT64_C(0x5dbcaa541b54ff9c), UINT64_C(0x211c418093f3bad0), UINT64_C(0xffa66bd0313378a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x306b54c4ee745fb4), UINT64_C(0x4b4c83c007b5a6c0), UINT64_C(0xb923eebc850b6fb8), UINT64_C(0x70dbfc14aa18ba54) }}, {{ UINT64_C(0x0015d2a8150cff5c), UINT64_C(0x3e8147e45a5927d0), UINT64_C(0x180e758c1f165a1c), UINT64_C(0x41b27c44e82ad8d4) }}, {{ UINT64_C(0x74d0b00c024a3b24), UINT64_C(0xc87e4250d6a4db0c), UINT64_C(0x7217592cd228798c), UINT64_C(0x9acb60e85d1ee8f0) }}, {{ UINT64_C(0xcd335c0c10fa414c), UINT64_C(0xe4c297687caa2c4c), UINT64_C(0xf470b81cc707fea8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x740a837464be5a90), UINT64_C(0xdf6b975c004d9960), UINT64_C(0x82ebfcf0c8da2bac), UINT64_C(0xd3131b88cebcabbc) }}, {{ UINT64_C(0x14ca6e407d429484), UINT64_C(0xdb217fc0efa36b14), UINT64_C(0xe4641b683eae4614), UINT64_C(0xee89b488e8f4f278) }}, {{ UINT64_C(0x4dd5271801dc11d0), UINT64_C(0x818cb6ec51dd19d0), UINT64_C(0xaa8f070076833f38), UINT64_C(0xcdc63fe4307af964) }}, {{ UINT64_C(0x9d3ebf08c73ad830), UINT64_C(0x55d27ebc75dfc3dc), UINT64_C(0x603fef3cb6e1836c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3cb6b59c65feda50), UINT64_C(0x6450a2dc1986fdd8), UINT64_C(0x64a6b650b2eb98ec), UINT64_C(0x9ab5338814e8ce64) }}, {{ UINT64_C(0xd464714c6151fb5c), UINT64_C(0xa568a774a55ea3e0), UINT64_C(0xdfed2e200be8a6d8), UINT64_C(0x466897e0bef47890) }}, {{ UINT64_C(0x8849212c68742f40), UINT64_C(0x754c16407f092034), UINT64_C(0xa127bb90f32c9640), UINT64_C(0x2026af88e99dea28) }}, {{ UINT64_C(0xdd758650f8d92b10), UINT64_C(0x1189453418b6b758), UINT64_C(0xa732dfa02d50eda8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd3697464587af45c), UINT64_C(0x94fb7ca0f926e970), UINT64_C(0x0a824cc061a273c8), UINT64_C(0xc54590d44143a438) }}, {{ UINT64_C(0xbb04295496c06fa8), UINT64_C(0xd8dd5e905d0a02c4), UINT64_C(0xd0ea81dc9cb42c44), UINT64_C(0xae71008c48cad0ec) }}, {{ UINT64_C(0x0000758c71d2f5b0), UINT64_C(0x8a80d7c8c93dfd64), UINT64_C(0x08d495a0742a9634), UINT64_C(0x8e0ff85c7eeb38f0) }}, {{ UINT64_C(0x89d1c88450aba970), UINT64_C(0xa9760940a6eb0858), UINT64_C(0x0416dab0ef528d90), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x25308d407bd0c0e8), UINT64_C(0x6f41d3c017e9cbb8), UINT64_C(0xb2dd0e749c334c88), UINT64_C(0x856a8be02f6899d4) }}, {{ UINT64_C(0x029f271ca70fade0), UINT64_C(0x732d8ff0c9445720), UINT64_C(0x9bebf2b09f7576c4), UINT64_C(0x58e2aa1cdc03eb40) }}, {{ UINT64_C(0xd522dbd0097c31dc), UINT64_C(0x09fc1ee8ec9769c8), UINT64_C(0xef7ca91074ecaff4), UINT64_C(0x38f4f0f89f3fbb20) }}, {{ UINT64_C(0x430ecdd4c14cee10), UINT64_C(0x9b9c6e30769179ac), UINT64_C(0x60af67a4b98e9c44), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9bb3dc3821698078), UINT64_C(0xaf1b97c46859b890), UINT64_C(0x2e3ed014eb0e5d68), UINT64_C(0xebf7de10fe118284) }}, {{ UINT64_C(0x48b8a33876dfbf10), UINT64_C(0x596fd8c03bd95008), UINT64_C(0xf03bcfb046fb60f4), UINT64_C(0xe503a04083eb3a08) }}, {{ UINT64_C(0x0566918c940c96c4), UINT64_C(0x3b5c1958e69e1eb0), UINT64_C(0xcc05c21c4a73ea34), UINT64_C(0x69f17abc0e18e130) }}, {{ UINT64_C(0xea1cd6ace4ba44c8), UINT64_C(0xa22fd19c95ab3b1c), UINT64_C(0x2b31092858cf1100), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbb1c9ae011d329ac), UINT64_C(0x550d34ec7500d368), UINT64_C(0x67ca12f4b9aac10c), UINT64_C(0x91fc7ac0ecfb98a4) }}, {{ UINT64_C(0x675739ec45c435ec), UINT64_C(0xc3b77904159c56f8), UINT64_C(0xba76a74463395834), UINT64_C(0x27b285c0011554cc) }}, {{ UINT64_C(0xcdbf6f34f687157c), UINT64_C(0xa3843b4ca3251e30), UINT64_C(0xb10a3a50c8111e68), UINT64_C(0x4447dbdc75e8b46c) }}, {{ UINT64_C(0x63f876585e0ec680), UINT64_C(0xc7288f3c7c2522b4), UINT64_C(0x0fb27ce4cd2a0db8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3d08ba6c37177a18), UINT64_C(0x8a11a554e55c6524), UINT64_C(0x2ab6b0b01a1fd7dc), UINT64_C(0xf2416a982b9a7d98) }}, {{ UINT64_C(0x3e74d0b4d2b73f78), UINT64_C(0x1b1649d4d0344480), UINT64_C(0x520928a0fd46f518), UINT64_C(0xd6e92b4831d289bc) }}, {{ UINT64_C(0x92860aa030445d10), UINT64_C(0xde5241744aac1a50), UINT64_C(0x46407d8ce76113c8), UINT64_C(0x4779673cc46e355c) }}, {{ UINT64_C(0x196be9c07f90dfa4), UINT64_C(0x21bff88c1d759038), UINT64_C(0xe80967dca8803580), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc79c9438c1097ddc), UINT64_C(0xa2156684033cca54), UINT64_C(0x5b35e9c4a62ea1b8), UINT64_C(0x57c20cbc34a5aca0) }}, {{ UINT64_C(0xc4c8957cda787d84), UINT64_C(0xe5c125ecf8fc1f88), UINT64_C(0x9ea0721ce265e480), UINT64_C(0x2001d3d4964cb64c) }}, {{ UINT64_C(0x2e8111e0c48c4e9c), UINT64_C(0x6b0e16009d591d90), UINT64_C(0xd6faad3c31544274), UINT64_C(0x1def16c0a223ec3c) }}, {{ UINT64_C(0x8a42fbc0fef7ef54), UINT64_C(0xbefa1670a37437d0), UINT64_C(0x0cf56d34e8699344), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf55c680881158c64), UINT64_C(0x6499724460ccb2f8), UINT64_C(0xf576f100f9fe3270), UINT64_C(0x99a1af989652f148) }}, {{ UINT64_C(0x7a8fc9d47d4f0604), UINT64_C(0xbc0a631037db1140), UINT64_C(0xb9b91434963507c0), UINT64_C(0x33408d5c4f869a5c) }}, {{ UINT64_C(0xf64fae10ed6ffe7c), UINT64_C(0xe9f2f3f08b90f760), UINT64_C(0xf86844985284f3ac), UINT64_C(0x8caacf547fbc224c) }}, {{ UINT64_C(0x244a805c2fb93b68), UINT64_C(0x5a0631a0cda6cc9c), UINT64_C(0x27b5b89481a67dc0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc642bf00b76ef804), UINT64_C(0x79d26d74ec0000c8), UINT64_C(0x0de464a47cd4ec38), UINT64_C(0x172e4cbc7b577b94) }}, {{ UINT64_C(0xb3b628c0df12d038), UINT64_C(0xc9bb0e989f484838), UINT64_C(0xc3de36ccdbcfe2f4), UINT64_C(0xdbab45bc76df0208) }}, {{ UINT64_C(0x8a128ee4a5415860), UINT64_C(0x8845769414d4af78), UINT64_C(0xdd9c9b84b8c394d0), UINT64_C(0xa53e3898129a9e90) }}, {{ UINT64_C(0xcfd766b4e5d8e708), UINT64_C(0x454747bc5b312cec), UINT64_C(0x490a9544f8c06a28), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xae36745cf6b08080), UINT64_C(0xf539c8d46ec3f5dc), UINT64_C(0x0b6bcf8c27fe5a14), UINT64_C(0xc85884504b241880) }}, {{ UINT64_C(0x95128ad4364d7c2c), UINT64_C(0x1b94cbc00d09b3f4), UINT64_C(0x3f775208c31e49fc), UINT64_C(0x7e9f4f14de7ccd14) }}, {{ UINT64_C(0xb0b06c0067bcc070), UINT64_C(0xbdca63042f4d2814), UINT64_C(0x1b46fa38638cab58), UINT64_C(0xc4acdb180b128268) }}, {{ UINT64_C(0x7e7653e8de8b3fdc), UINT64_C(0x9a8e4fbc4af69f78), UINT64_C(0x201b64b4888f6b1c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x17d56f2c2db68f68), UINT64_C(0xd9726cdcb3ae837c), UINT64_C(0x1253c7a413b42ff8), UINT64_C(0x19b24decc18b6790) }}, {{ UINT64_C(0xbaa4febc1a041088), UINT64_C(0x8cf38c783954a02c), UINT64_C(0x012791b4f3859058), UINT64_C(0xc2ce3ffc04f04984) }}, {{ UINT64_C(0x9739b494e4ae1784), UINT64_C(0x28b11b288b8174fc), UINT64_C(0x8d6f8d64965f2620), UINT64_C(0xb3133b78ff14b030) }}, {{ UINT64_C(0x68aedae8503278fc), UINT64_C(0x58606ffc3f7d50b4), UINT64_C(0xf0047b34ce7cf990), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x22156d24457bbeb8), UINT64_C(0xfc4c0618640cd850), UINT64_C(0xe1a17420fb612f04), UINT64_C(0x3f81866c0369a234) }}, {{ UINT64_C(0x749c069c42450130), UINT64_C(0x5630d63820199e78), UINT64_C(0xfa1ea544ab2d36c8), UINT64_C(0xcbef79048247e600) }}, {{ UINT64_C(0x14d498543603b1ac), UINT64_C(0xcd6bf004886ee484), UINT64_C(0x7b11784415c26170), UINT64_C(0xf35476708f3b6ce8) }}, {{ UINT64_C(0x8a907098bc92eedc), UINT64_C(0xb5a50cc04d5392cc), UINT64_C(0xf58a5028a35f7c6c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3dc3e6f82ab5530c), UINT64_C(0x6eb3bfe851504024), UINT64_C(0x547f6aa49081a8f0), UINT64_C(0x8db80530b5c7a340) }}, {{ UINT64_C(0xf4242844e5471b34), UINT64_C(0x27e2e0a8102d7030), UINT64_C(0xf55d77d03b72ed94), UINT64_C(0xa2844150a2b89024) }}, {{ UINT64_C(0xa183d8581deea060), UINT64_C(0x3b7e8554144af6bc), UINT64_C(0x868cb698aaeb76bc), UINT64_C(0xd66759642f17e708) }}, {{ UINT64_C(0x5cf4a6d8cb6c0ab4), UINT64_C(0xb448f3ecf00b7798), UINT64_C(0x2719389016d2b9e0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0e9bcfd8481091c8), UINT64_C(0x996fa790ced34d44), UINT64_C(0x4789465ce35fb900), UINT64_C(0xb0c0c020577356e0) }}, {{ UINT64_C(0xe24f6528648e8944), UINT64_C(0x0cdb1c0cc2b80218), UINT64_C(0xbdf755f8a24eb468), UINT64_C(0x5b510df87df7cd9c) }}, {{ UINT64_C(0x41cc9e14e8583f5c), UINT64_C(0x7ab82ea8c5802fcc), UINT64_C(0xfe6c3ab83c4fc04c), UINT64_C(0x74e20e58a526c5b0) }}, {{ UINT64_C(0x8fedad68c82d35ac), UINT64_C(0x50f02f1cb083d550), UINT64_C(0x438f8740ced45ed4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2d8f9138807b3940), UINT64_C(0xee5ad8740476c250), UINT64_C(0xb11b17800c33dab8), UINT64_C(0x7f55fe10d32aeec0) }}, {{ UINT64_C(0x77f761903c9ca528), UINT64_C(0x04a9ff6c39b33d14), UINT64_C(0x011d44047cdbdfd0), UINT64_C(0xceae72d034e35bd0) }}, {{ UINT64_C(0x7d224becda518c88), UINT64_C(0x542f8290ba144024), UINT64_C(0x2f8cf57ca8cd394c), UINT64_C(0xbca5f584009a19cc) }}, {{ UINT64_C(0xe97b984cd7bd1a7c), UINT64_C(0xd481ac34dc62ee78), UINT64_C(0xb7c89fc8705d6b04), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x070f4b6458614b54), UINT64_C(0xef30333828a9cdfc), UINT64_C(0xe71f0b3043207614), UINT64_C(0xb44fbd946e1c0dac) }}, {{ UINT64_C(0xc158c7302cd6666c), UINT64_C(0x9d116a00dc8da278), UINT64_C(0xd1a0c11c8b286d90), UINT64_C(0x064894e4e491f6dc) }}, {{ UINT64_C(0xc975df788d770b58), UINT64_C(0x4d8e714049326348), UINT64_C(0x7bc82b58bae8a404), UINT64_C(0xdad21250ceac6424) }}, {{ UINT64_C(0x40546dd81722e01c), UINT64_C(0x28005d248e135f44), UINT64_C(0x54a2efe4e1bf8e88), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8ae178dc24a9fe50), UINT64_C(0x020598d072c4046c), UINT64_C(0x3608141033174e8c), UINT64_C(0x407a13245f4fde68) }}, {{ UINT64_C(0x8ea8587c1a2585f8), UINT64_C(0xeb240998c9aba86c), UINT64_C(0x0193b4b00882ce54), UINT64_C(0xdc39aec4d3fbbff0) }}, {{ UINT64_C(0xd58d45684d04ef94), UINT64_C(0x150f1224d5e3db28), UINT64_C(0x9e49ec64be45c070), UINT64_C(0x8dfbc9f86bd07f10) }}, {{ UINT64_C(0x4a9c30ecd4f9c5c0), UINT64_C(0x20dbcba058713a0c), UINT64_C(0xd990b1f88dd570cc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6dcd8d44b5df382c), UINT64_C(0x577ebba4699fbdd8), UINT64_C(0xb7ff84ac03021544), UINT64_C(0x72c9d4849f384e80) }}, {{ UINT64_C(0x9b643a889719daa0), UINT64_C(0xc3386bf85522ea14), UINT64_C(0x9e16a3306e620720), UINT64_C(0x30df537001e99174) }}, {{ UINT64_C(0x7f3df458cb12125c), UINT64_C(0x7c8bb8a01e5a6704), UINT64_C(0xf1c2c34c213364d8), UINT64_C(0x77fb8fc068919da4) }}, {{ UINT64_C(0x73975388dcd174bc), UINT64_C(0x20acc44008e2d490), UINT64_C(0x675b32642f78ea48), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x357680fc6ac45cd4), UINT64_C(0x60fc79088e27f034), UINT64_C(0xec7de02c0fff6948), UINT64_C(0x4cbb0cbcaedcc538) }}, {{ UINT64_C(0x2e822afc9ff06628), UINT64_C(0x5294fe24b4f6b668), UINT64_C(0x5ecf03c8399718a8), UINT64_C(0x0aeecf3405ea852c) }}, {{ UINT64_C(0x15bee9445da19154), UINT64_C(0x81a8773c73a2f1f4), UINT64_C(0xe96b6e7cdf2dac14), UINT64_C(0xeb8be86821a383d8) }}, {{ UINT64_C(0x2ef412d0a549207c), UINT64_C(0x061acdcc62707624), UINT64_C(0xc6c9923cfc7ad0a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x73d65ad474978a84), UINT64_C(0x7146763ccd7f95c4), UINT64_C(0xed88db94b1b23310), UINT64_C(0x5d48c6ac48282684) }}, {{ UINT64_C(0x6df4c3d8d511bd00), UINT64_C(0x9a20b6d4ce04f7c4), UINT64_C(0xc21eac544aa51cb4), UINT64_C(0x93721294fd9ac184) }}, {{ UINT64_C(0x4a9678e835da4618), UINT64_C(0xc54c4c8c1784a108), UINT64_C(0x7aff3f6420103da4), UINT64_C(0xa2311aa471762300) }}, {{ UINT64_C(0xe8d757f40a679930), UINT64_C(0xa792efb857beae9c), UINT64_C(0x72204624c0e5512c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9a6b7b488d605914), UINT64_C(0x6d1fd94c98097804), UINT64_C(0xb6baedb8e65d8538), UINT64_C(0x2674959c6126072c) }}, {{ UINT64_C(0xa0814620c523af28), UINT64_C(0x9460a690b3f64dc8), UINT64_C(0x3bdbd9e47a6d27ac), UINT64_C(0x2147b0b826f0c5b8) }}, {{ UINT64_C(0x42fea828e076fd5c), UINT64_C(0xc54185188f3939b8), UINT64_C(0x2786f8909c75c668), UINT64_C(0x07a5346c530545b4) }}, {{ UINT64_C(0x005ce7d065d353dc), UINT64_C(0xde9da53c52106d00), UINT64_C(0x7faaf604a2535130), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6cd71340d0376b18), UINT64_C(0xccade35c670f20d4), UINT64_C(0x6a9285dc2eb06ae0), UINT64_C(0x025b10540e1486cc) }}, {{ UINT64_C(0xc5238b7cbc307318), UINT64_C(0x54cdf4b80288b0e4), UINT64_C(0x1793419411eb7964), UINT64_C(0xb1801b90a26547b0) }}, {{ UINT64_C(0xfe729d9c047db434), UINT64_C(0xbf4b141cebc2a3f8), UINT64_C(0x334a2310ce4db880), UINT64_C(0x674449b08a46b018) }}, {{ UINT64_C(0x9afc93d41978be64), UINT64_C(0xec975f88c89b7824), UINT64_C(0x12a3ad140f549fd0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbb0e15b487380b40), UINT64_C(0xd9f5b97c7b921ba4), UINT64_C(0x0bb767fc9c04325c), UINT64_C(0x88e91b807270f048) }}, {{ UINT64_C(0x25916844fe0e18e4), UINT64_C(0xdd8d20501a272bd0), UINT64_C(0xa812f0d06fefc610), UINT64_C(0x6f70a0cc472d20f8) }}, {{ UINT64_C(0xbecff19cbf352554), UINT64_C(0xa3b863c0179fe918), UINT64_C(0x6ea72e085d90a310), UINT64_C(0x0764799c274d54c0) }}, {{ UINT64_C(0x4d0cbe0cce3f1570), UINT64_C(0xbacd7b64c2f91d58), UINT64_C(0x5b769b4c6ca9d160), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x386429606e1fb6d4), UINT64_C(0xd07d653cfb257614), UINT64_C(0x3406df543ef00aa8), UINT64_C(0x7496b6646f36a5e4) }}, {{ UINT64_C(0xac71e748aa608808), UINT64_C(0xc69b2e6ca201b1cc), UINT64_C(0xa3f392cc1142d838), UINT64_C(0xc1f756247ad2abb0) }}, {{ UINT64_C(0x576f2408e1020858), UINT64_C(0xf47cb3245fe3eb8c), UINT64_C(0xd193264c8ffc0360), UINT64_C(0xc3bf584ce0eadb70) }}, {{ UINT64_C(0xb53dd8f0b26f9684), UINT64_C(0x2fb3fafcdf504edc), UINT64_C(0x513ef424894103b0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x08d84654ae43f6b8), UINT64_C(0x09c213f8e2af9f1c), UINT64_C(0xdc5c06dcced22124), UINT64_C(0x0d319a54ea6febbc) }}, {{ UINT64_C(0x1cde78e8c7f23a90), UINT64_C(0x50971d449e30e918), UINT64_C(0xf3700fec6a4f56ac), UINT64_C(0x7993ccd8c51deebc) }}, {{ UINT64_C(0x0bd469b401ecc710), UINT64_C(0xfab2c24c789ff318), UINT64_C(0x2823fd504b8e1838), UINT64_C(0x8de43c28636059e4) }}, {{ UINT64_C(0xfe1586d8e879dc64), UINT64_C(0x0280999c18fac8c0), UINT64_C(0x1e3a04f42e68d71c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x22dfd11898bebfa8), UINT64_C(0xcf16c1c4809e98f0), UINT64_C(0x521152506e939f20), UINT64_C(0xe430800c0d1559b0) }}, {{ UINT64_C(0xd054ed78bcd61200), UINT64_C(0xb43efde4d76628cc), UINT64_C(0x462a605409e66b1c), UINT64_C(0x76a4419c66af680c) }}, {{ UINT64_C(0x2315dbe441f98e1c), UINT64_C(0xf19b4038d95018d0), UINT64_C(0xf891c904f8896f58), UINT64_C(0xdf80a784543be6cc) }}, {{ UINT64_C(0xd952a560d417d178), UINT64_C(0x8e9faf84f2922888), UINT64_C(0xa9a7620802ad88b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb58384c7a6f1134), UINT64_C(0x88e078b83793d9fc), UINT64_C(0xeed3d7303ea4e238), UINT64_C(0xa7c4dad8daf4fa94) }}, {{ UINT64_C(0xc767f000793ebcbc), UINT64_C(0x363139486d36f270), UINT64_C(0xb104d4184e063ad8), UINT64_C(0x5ee3e52087624bf4) }}, {{ UINT64_C(0xced6eda80a8458c4), UINT64_C(0x215b729878cf3098), UINT64_C(0x3bada5b88e91bd34), UINT64_C(0xbe43c4f8ac2ac764) }}, {{ UINT64_C(0xb7bf5e543d3368d0), UINT64_C(0x03bc5278bb2196c0), UINT64_C(0x723dfac0daf8b080), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa386c5acf0446820), UINT64_C(0x7334165cbdc269fc), UINT64_C(0xd69d05d04e9323bc), UINT64_C(0x899f50f8fda90a04) }}, {{ UINT64_C(0x4ebf1dfc7bcefd30), UINT64_C(0x4a699adcfbb734bc), UINT64_C(0xa8a00738649c5354), UINT64_C(0xeada309c665faad4) }}, {{ UINT64_C(0xba70cfe8f5e74088), UINT64_C(0x6f6130c4d368ae10), UINT64_C(0xb3cf468c7a2895a0), UINT64_C(0x721e549c22cc46ac) }}, {{ UINT64_C(0xc8a833844163e2a4), UINT64_C(0x7eab642c514cac7c), UINT64_C(0xe01db5cc8d0f7d70), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7e7f48443f290c1c), UINT64_C(0xd9fbdbe44e797adc), UINT64_C(0x3238f634bdbd456c), UINT64_C(0xfd1c9d90d612464c) }}, {{ UINT64_C(0xa77aab20971c0278), UINT64_C(0xe5e2ec885cbeb3a8), UINT64_C(0xe7da7a242f5b9974), UINT64_C(0x9e771cd8b36ea084) }}, {{ UINT64_C(0xf4f5cc505b1b1758), UINT64_C(0x99eec87cd1cdc500), UINT64_C(0x6e25ce187a99ce88), UINT64_C(0xfff81c20609633e0) }}, {{ UINT64_C(0x88ed866c1bc1c9e0), UINT64_C(0x97b36738ebf44228), UINT64_C(0x7c32c07c58dd9c78), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x822d3a188729ea60), UINT64_C(0x790a9b00a3a63de4), UINT64_C(0xf9f855a4ef11df74), UINT64_C(0xa395e6846b1c9e08) }}, {{ UINT64_C(0xdd776228d253f580), UINT64_C(0x5e2fc4806082fbbc), UINT64_C(0x48a8b19c7e95222c), UINT64_C(0xdce3063c469f2270) }}, {{ UINT64_C(0x291fb588fbd4f428), UINT64_C(0x0032bcb88834c3b4), UINT64_C(0x4065302cafe5497c), UINT64_C(0x83a5cc0cd3164e64) }}, {{ UINT64_C(0x35c1ff642cd0a6c4), UINT64_C(0x7d5688cc06aaaf14), UINT64_C(0x5710ba004d7772cc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0c0deac8e31cf034), UINT64_C(0x9c78fba81b66056c), UINT64_C(0x9802e70c9967854c), UINT64_C(0xd3372df4e3b2de10) }}, {{ UINT64_C(0x2e54b0986e0b6f88), UINT64_C(0xd992d37c3d73d2dc), UINT64_C(0x5e01e07cd06d64b0), UINT64_C(0xc9a5475c4b082638) }}, {{ UINT64_C(0x5f48fb6c2c0636ac), UINT64_C(0x17b04c08ef8fba7c), UINT64_C(0x997bf358db8634b0), UINT64_C(0x4c81ee2c480102ec) }}, {{ UINT64_C(0x0a6e0c2cdc130390), UINT64_C(0x50de96146ed26220), UINT64_C(0xda719bd08feab02c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x787167a0bb4542e8), UINT64_C(0x0581b350fd263698), UINT64_C(0x47168fa0e38e8ba8), UINT64_C(0x2dccb928e2840dc4) }}, {{ UINT64_C(0x014e611cd6c1128c), UINT64_C(0x2e19ca7cdc7cdb5c), UINT64_C(0xc95af440c5442e64), UINT64_C(0x6aadbe703c627e50) }}, {{ UINT64_C(0x56a009701ddac578), UINT64_C(0xbb54d774763389f0), UINT64_C(0x7f2c577c033178d4), UINT64_C(0x442d824c84c623cc) }}, {{ UINT64_C(0x2487f6786b3c2048), UINT64_C(0x8f827a30b526c1f0), UINT64_C(0x888f8c9cff893250), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcc23aa08f3383ccc), UINT64_C(0xc29145d8b9ea09a4), UINT64_C(0x75e9890c63bd9594), UINT64_C(0x1572e864e4cd84a4) }}, {{ UINT64_C(0x6452955cc960941c), UINT64_C(0x85dd4c90dddc4080), UINT64_C(0xbca804b0258cd6d8), UINT64_C(0x5dcf6204925edb48) }}, {{ UINT64_C(0x0b6c8c34b425cb98), UINT64_C(0x93701ec8f711d68c), UINT64_C(0xbb2799d03203638c), UINT64_C(0xf4471a7c6e5eb794) }}, {{ UINT64_C(0xf963359461605210), UINT64_C(0x7dfad4d83f7428c4), UINT64_C(0x7cf40b3811689794), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x87f2a6142e58b21c), UINT64_C(0x11da96d0df9ec198), UINT64_C(0xcc9324746a6e05b0), UINT64_C(0xe6acb0d4f0aaa8f0) }}, {{ UINT64_C(0x768124a8dd6782c4), UINT64_C(0x5c97fc20ff7dd970), UINT64_C(0x095be9fc22d65cd8), UINT64_C(0xada0e468a5e7e818) }}, {{ UINT64_C(0x1eafd788f44c19d0), UINT64_C(0x40b3e8606665ba48), UINT64_C(0xd0a7ef40c99b89ac), UINT64_C(0x1b1ed320a501301c) }}, {{ UINT64_C(0x8e8d60806c0c91c4), UINT64_C(0xdd3c0f64ac56ac94), UINT64_C(0x57127d48acf4c290), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf723c98070a1df9c), UINT64_C(0xb2a41d2068cef540), UINT64_C(0x52fe451c9d42d0e8), UINT64_C(0x9c79222002c79810) }}, {{ UINT64_C(0x684a2ddc6832ff90), UINT64_C(0x8bc1950c0b053260), UINT64_C(0x9e80476054253424), UINT64_C(0x9f49e1588cc83304) }}, {{ UINT64_C(0x11f71c943a74bd0c), UINT64_C(0xcbab393c881054c4), UINT64_C(0xbb5f90644129ad74), UINT64_C(0x35c7c56c8a75212c) }}, {{ UINT64_C(0x9df671fcbdef0454), UINT64_C(0xa32d2840f90d164c), UINT64_C(0x1c0350f02f690de4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf3ec14685de59da4), UINT64_C(0x4807ba80599eb11c), UINT64_C(0xc700a1f4da63b220), UINT64_C(0x89e00c7ce87e51bc) }}, {{ UINT64_C(0x8d949a102a2fce08), UINT64_C(0x7629710c97e7d4ec), UINT64_C(0x315da8dc2c946014), UINT64_C(0x6a8dafc06a0d4794) }}, {{ UINT64_C(0x46f57d64e583db6c), UINT64_C(0xbaf86e8469ff442c), UINT64_C(0xb5ed698809b22e58), UINT64_C(0xb00bcdfca4b0ec98) }}, {{ UINT64_C(0x24ce91208b68290c), UINT64_C(0xa81e37c8b0730994), UINT64_C(0xac9405248b06d0a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x56d07fb4b29b2fb0), UINT64_C(0x5b8344b871c07c18), UINT64_C(0xc80248c86d87f188), UINT64_C(0x21d2f0a495dc3e8c) }}, {{ UINT64_C(0xa1151e4c416f265c), UINT64_C(0x2dc65880ae33eaf0), UINT64_C(0xb40c0a30f483a208), UINT64_C(0x26033a906551e5c4) }}, {{ UINT64_C(0x3365462c2ef507e0), UINT64_C(0xffa8895c13e88f00), UINT64_C(0x660bf90888c441c8), UINT64_C(0x7ae00a743a470460) }}, {{ UINT64_C(0x5d242f6860a5b700), UINT64_C(0x9ec5d948d95d0dbc), UINT64_C(0x59652fd027ea7938), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x937eb86c5fe6afb4), UINT64_C(0x37ae482c2b71260c), UINT64_C(0x16a77d38589b339c), UINT64_C(0x07466cd45fd3cdac) }}, {{ UINT64_C(0x54a0ddd47fc16888), UINT64_C(0x1b215774ab40f9b8), UINT64_C(0xb7eecf3c38cc13cc), UINT64_C(0x6e36f5bcc15b48a8) }}, {{ UINT64_C(0x910afd088553c1f4), UINT64_C(0xfc22fba8e60ebf54), UINT64_C(0x288988a8fc79a5e8), UINT64_C(0x8f34ec2833bcfa34) }}, {{ UINT64_C(0xa04d1cc4ed4e7ff4), UINT64_C(0xf579f9b4140b5684), UINT64_C(0xc4b47dd85c387c60), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3e1d8788a64dd560), UINT64_C(0xcce11ae474b98280), UINT64_C(0x11100644755a0ac0), UINT64_C(0xbb0e15ecf0e8e43c) }}, {{ UINT64_C(0x7c5363d838f2ed48), UINT64_C(0x98b96944d087128c), UINT64_C(0xe78b3d88d1946eb8), UINT64_C(0x55d08d5c5bbf2470) }}, {{ UINT64_C(0x455639e8d1e6b808), UINT64_C(0x5800c178dff89940), UINT64_C(0x997961241d9f2374), UINT64_C(0xd7a3235cb8ef7edc) }}, {{ UINT64_C(0x8ea52e584eeaec44), UINT64_C(0xa1e546741d4dbac0), UINT64_C(0x52c3dec8fec31120), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71f65e4c7a9988dc), UINT64_C(0xeb22a640bc27edcc), UINT64_C(0xcd5ffc60bf6cae38), UINT64_C(0x89426fc08ce97ca0) }}, {{ UINT64_C(0x82d19050d290e178), UINT64_C(0x3196a680f5c383e0), UINT64_C(0x5a3f5c9cef42aa30), UINT64_C(0xdaa9a01ce107443c) }}, {{ UINT64_C(0x839a3ab8e6194adc), UINT64_C(0x74e443a874725e80), UINT64_C(0xffa544d09c296c00), UINT64_C(0xe22598e416237d80) }}, {{ UINT64_C(0x870d3a987a03dc20), UINT64_C(0xf8fd1dc4f5d78768), UINT64_C(0xfdaa398c70de78d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc4fbce50798f31b8), UINT64_C(0x40fd858c2c83f4b4), UINT64_C(0x24a226c08818a2b0), UINT64_C(0x4be2dfb82e718b88) }}, {{ UINT64_C(0x59913444376e8fe0), UINT64_C(0x8661e6a070047d38), UINT64_C(0xcad13a5cb41990d4), UINT64_C(0x3f0a0c9cdec6bba0) }}, {{ UINT64_C(0xbff16278a4217904), UINT64_C(0xbe1d928c25a2d408), UINT64_C(0x1152c21075648c14), UINT64_C(0x7a3cec7897366350) }}, {{ UINT64_C(0x520a690cb2c45c50), UINT64_C(0xce7f04849d70cd44), UINT64_C(0x241ae1ac2468b928), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x951bb0c447e82810), UINT64_C(0xd25cd074ffaa0110), UINT64_C(0x33c26f043ce326d8), UINT64_C(0xe7148cc05f9e94e8) }}, {{ UINT64_C(0x2dc7ca284ea75dfc), UINT64_C(0x18076b4c4c757f0c), UINT64_C(0xe78ac87884239fe0), UINT64_C(0x7baba4c882e585ec) }}, {{ UINT64_C(0xabbf7e48fd3405f0), UINT64_C(0x8f645ca456867178), UINT64_C(0x5cfd3db0c982e8d0), UINT64_C(0xea08551084904714) }}, {{ UINT64_C(0x0e87c9bc9e93dd20), UINT64_C(0xc82b07f8f5cf62ac), UINT64_C(0x68b87b88ebe3fbb4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6b05097cb8875974), UINT64_C(0xd4646990ee86c394), UINT64_C(0x7a5a50040e58ac6c), UINT64_C(0xb8918204394c496c) }}, {{ UINT64_C(0x7a8f96d436fc5210), UINT64_C(0x98d1c0e0d90ac1b4), UINT64_C(0xe73d146ce5ed9028), UINT64_C(0xe18b17accbb95c78) }}, {{ UINT64_C(0xc7d7d6a437eecf98), UINT64_C(0xb640660400e8902c), UINT64_C(0x60e6eb8cb5afc824), UINT64_C(0xf3fd2b6c61ad2a58) }}, {{ UINT64_C(0x6de5cb841d376334), UINT64_C(0x124169640b9d1368), UINT64_C(0xdaffe8bc43352068), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcfeac88803b2d4f4), UINT64_C(0xb7e616f0e880a2c0), UINT64_C(0xea3f18fc02a1d9b8), UINT64_C(0x8c049ed8f0017f74) }}, {{ UINT64_C(0xa813c778e471222c), UINT64_C(0xfc3aff3c899162a0), UINT64_C(0x1020dbbc4601f850), UINT64_C(0x6f4dbdb003590bb8) }}, {{ UINT64_C(0x2a20e45c98181ed4), UINT64_C(0xfb8b35f43202faec), UINT64_C(0x6e327cec5423078c), UINT64_C(0x1ba849dcc386f378) }}, {{ UINT64_C(0x9bad22708932833c), UINT64_C(0x2890ebc01322ac7c), UINT64_C(0x71cd6bdca758e260), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc8fc2c686f8ec1a0), UINT64_C(0xb2e4ac80c17c729c), UINT64_C(0x3c1840f062103b94), UINT64_C(0xd7a16538222290fc) }}, {{ UINT64_C(0x462a133c754d6544), UINT64_C(0x892829788b455c5c), UINT64_C(0x0a47d3d8238fec88), UINT64_C(0x14eb587838dfd22c) }}, {{ UINT64_C(0xaadbe5d0f592a4e8), UINT64_C(0x6e39d32c5282fdb8), UINT64_C(0x92d614e0e0b11aa8), UINT64_C(0x818d489ca5f17c44) }}, {{ UINT64_C(0x20fdd52c5261ec7c), UINT64_C(0xb16ba5a4d70a349c), UINT64_C(0xe41c357c10b2fac0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3cce8558da5edba4), UINT64_C(0xde4d4018e5334518), UINT64_C(0x4a1898f0691ba028), UINT64_C(0xe8e0472cb2b8c238) }}, {{ UINT64_C(0xe07890b4410e35c4), UINT64_C(0x37a1e39ccb33eaf4), UINT64_C(0xf0e0746098e83e94), UINT64_C(0xb532f1f04b7f43fc) }}, {{ UINT64_C(0xae495030be54c3ac), UINT64_C(0x902355d4a949fa98), UINT64_C(0xccb4b290ce35c618), UINT64_C(0x2796cc284ed24008) }}, {{ UINT64_C(0xbd48832841a31950), UINT64_C(0x5a653eb4e5cbcd84), UINT64_C(0xe7d74d989ee300c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf5c6049c2ea58efc), UINT64_C(0x90b4f300340c1e8c), UINT64_C(0x458e6ce05ea846e4), UINT64_C(0xcd00f6706484e548) }}, {{ UINT64_C(0xc7975f7827c85e98), UINT64_C(0x88950a902c448060), UINT64_C(0x8c4cf79486ef2f38), UINT64_C(0xf26fe75c8c168564) }}, {{ UINT64_C(0x799083d05dcff004), UINT64_C(0x05865c0c45ee6cbc), UINT64_C(0xe193efa01038ce64), UINT64_C(0xce06918c77916bcc) }}, {{ UINT64_C(0x86bea5f81939e298), UINT64_C(0x84c0929014719e04), UINT64_C(0xe3c0ffcc8dc5658c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8fdc925432d7c400), UINT64_C(0x4f3e8cb0a16e7d14), UINT64_C(0xc024ba0c0b25f9b8), UINT64_C(0x56bf5dc4d7e35054) }}, {{ UINT64_C(0x05566800225b9998), UINT64_C(0x73d03e74b7af265c), UINT64_C(0xa12f90101a5747ac), UINT64_C(0xecd84518141e04d0) }}, {{ UINT64_C(0x069411407ee20828), UINT64_C(0xfe4f859062a15198), UINT64_C(0x5d87d0eca49d732c), UINT64_C(0xc911b61408e1c738) }}, {{ UINT64_C(0x74e8542cd2751768), UINT64_C(0xee5df6404b0e2d84), UINT64_C(0x600d0ed81a66c1a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfbfa4338a46087ec), UINT64_C(0x86076ab0c65197ac), UINT64_C(0xadc564c886e56474), UINT64_C(0xe7bf2ebc7cc41938) }}, {{ UINT64_C(0xb2221c304131d0a4), UINT64_C(0x066e0a08030b4430), UINT64_C(0xf01e05585e38e6a4), UINT64_C(0x82e997705d910ed8) }}, {{ UINT64_C(0xd1313c8848ffd830), UINT64_C(0x08d300d46b88a3c0), UINT64_C(0x367bf314d46acde4), UINT64_C(0x15b74da079d9c870) }}, {{ UINT64_C(0x119e6040b8f5c918), UINT64_C(0xc90379c8640669bc), UINT64_C(0x6670d34ca86960ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x41bc45a8f4df3b08), UINT64_C(0x4a9bc92457d79904), UINT64_C(0x5066e7a05f29e5a0), UINT64_C(0x921059cc36d6d500) }}, {{ UINT64_C(0x32e00450cfee278c), UINT64_C(0xef933e64bb6460f4), UINT64_C(0x70a084f0d6096294), UINT64_C(0xd04d4140e00dce04) }}, {{ UINT64_C(0xddc78ec420c8d018), UINT64_C(0x60c7b64821ebf59c), UINT64_C(0x0a5baa0cd46c23f0), UINT64_C(0xc8820870f3d657d8) }}, {{ UINT64_C(0x07f958a4146e7d70), UINT64_C(0x431e6d509a1a0c84), UINT64_C(0xbe00ab60d630e758), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x72d4a6fc749a9e4c), UINT64_C(0x27fda4b446334b2c), UINT64_C(0x6c7829981073611c), UINT64_C(0xa626989cb05b39e8) }}, {{ UINT64_C(0xfaf4e3649957b7ec), UINT64_C(0x009d61d0c8b55f28), UINT64_C(0x74bbf4d46d34ff88), UINT64_C(0x0a60c20c42f7cd98) }}, {{ UINT64_C(0x09d469d80419e3d0), UINT64_C(0x2c5630f42b88ae3c), UINT64_C(0xcc4c43d8fd2b000c), UINT64_C(0x7049b704def911a4) }}, {{ UINT64_C(0xd55f2920063987b0), UINT64_C(0xdec771fcd1a45cd0), UINT64_C(0x0f81a36cf8d4e640), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x07b9a2d4b1232894), UINT64_C(0xf9e50c54e31534f8), UINT64_C(0xc315b3785de22344), UINT64_C(0x58531e44aa6722c4) }}, {{ UINT64_C(0xdee080a0cc235878), UINT64_C(0xf82392ccdbca4474), UINT64_C(0x17d4c9489040d734), UINT64_C(0xccc39174d220cf6c) }}, {{ UINT64_C(0xfd92a2e8f764f0fc), UINT64_C(0x878597948d940024), UINT64_C(0x17384e0047edd6b8), UINT64_C(0xff1feeec0647c4a4) }}, {{ UINT64_C(0x91dbc0dc80f0badc), UINT64_C(0x0529682424846a20), UINT64_C(0x045a477ca911bcac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x271e4b0494e16d18), UINT64_C(0x478aa56803d40ff8), UINT64_C(0xad868f64cae8a458), UINT64_C(0xed3b4228cecae9cc) }}, {{ UINT64_C(0xaec24890c6bb5058), UINT64_C(0x8a73683821fe392c), UINT64_C(0x8bd66d209c76ff48), UINT64_C(0xb249389424331c74) }}, {{ UINT64_C(0x6e92e3c4f6da4e40), UINT64_C(0xdce4cd004acab600), UINT64_C(0x4b6e26b8cd40de8c), UINT64_C(0xcab2dc749c07db5c) }}, {{ UINT64_C(0xfe903a2041707b80), UINT64_C(0x27f16cb4469a1148), UINT64_C(0x3e054908d1f59a24), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8b1a52f87fb7d5b8), UINT64_C(0xe8f395c896c82964), UINT64_C(0x1ad07c24982cffc4), UINT64_C(0x620e3eacbb1950b4) }}, {{ UINT64_C(0xc45b3f24ceac429c), UINT64_C(0x6fb8b7649aa7dec8), UINT64_C(0x2028e4e429544f84), UINT64_C(0x079c6e847244c670) }}, {{ UINT64_C(0x2c3faeb8a43d82b0), UINT64_C(0xa36a0e58ceb9ea90), UINT64_C(0x99c82a4cc3ae7654), UINT64_C(0xbc45109ce34f019c) }}, {{ UINT64_C(0x6d9604f42d7849a8), UINT64_C(0x903cec2c15fbbcbc), UINT64_C(0x38837ea4213d4800), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x96a980f858baa174), UINT64_C(0x25b0e914ad8339e4), UINT64_C(0x7b6cb25cf29bf8d0), UINT64_C(0x9188e9c8876a4088) }}, {{ UINT64_C(0xf042297cfa493ea8), UINT64_C(0xc517ede4a2f3aa24), UINT64_C(0xead4a8e041c7992c), UINT64_C(0x92cde994477390f8) }}, {{ UINT64_C(0x9529173881baeaac), UINT64_C(0x24884df859f42c5c), UINT64_C(0xc9de0454e6f0e9a8), UINT64_C(0x84c3f44c39392b4c) }}, {{ UINT64_C(0xb336c5505ffc8ca8), UINT64_C(0x15da5f38bcf73eac), UINT64_C(0x044b0a08caffd1c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x547668e82361a9d0), UINT64_C(0x51aee4d81c0a9624), UINT64_C(0x196727040a3f493c), UINT64_C(0x32990e9cfcd15590) }}, {{ UINT64_C(0xfa4c36e4664c5a54), UINT64_C(0x7223215467d9e7e4), UINT64_C(0x2e7e49dc0097a058), UINT64_C(0x0107ad0895786734) }}, {{ UINT64_C(0x286e4058f5c78f38), UINT64_C(0x1ec025b812cfefd4), UINT64_C(0xa0d2251ca659386c), UINT64_C(0x79454e389ad1a048) }}, {{ UINT64_C(0x6efe2b2cd18e1654), UINT64_C(0xc8380268c374e3bc), UINT64_C(0xacbdde88f3485748), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x385a88b400911978), UINT64_C(0x9935890022623d64), UINT64_C(0x677beb540cff4188), UINT64_C(0x0c5e6b1c767c3ee0) }}, {{ UINT64_C(0x8b88fc7c4e8f3c34), UINT64_C(0x2c5888fcb2b53e14), UINT64_C(0x7759df20d5d03588), UINT64_C(0x3ccb07e008cee458) }}, {{ UINT64_C(0xca45c88c838a9490), UINT64_C(0xcf90027063d326a0), UINT64_C(0xe44f2e900892dcbc), UINT64_C(0x14b7fe344c34ab18) }}, {{ UINT64_C(0x17a3bd040679e0a8), UINT64_C(0xa4da26bc4a77767c), UINT64_C(0xad50c2d47ea67904), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x904f14648967dd50), UINT64_C(0x65ef416c158a4524), UINT64_C(0xc1cd57143879143c), UINT64_C(0x6b4aea2025116cbc) }}, {{ UINT64_C(0x3475fdd4f755c310), UINT64_C(0xee76aacc14c9badc), UINT64_C(0x88dccffc8fbd8bd0), UINT64_C(0xcd5f3838bef281ec) }}, {{ UINT64_C(0x7ed48b4c1c8292f4), UINT64_C(0x856cf82cd3ad46c8), UINT64_C(0x1244d6e04185125c), UINT64_C(0xf97d5974f110c744) }}, {{ UINT64_C(0x5e71bcfcc072f97c), UINT64_C(0x5d3ecdf85ccea2d8), UINT64_C(0x4ea695c81b102298), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x984360fcc4ce4a0c), UINT64_C(0x80eafe2071c3170c), UINT64_C(0x7ce67cfc9793d9b4), UINT64_C(0x842ba7d4a9063ac0) }}, {{ UINT64_C(0x74c297344a809844), UINT64_C(0x9f2312b4ee1f59dc), UINT64_C(0x43c2e2c84d8deb80), UINT64_C(0x7c28709c6d028a38) }}, {{ UINT64_C(0x1f97f2507d4e08dc), UINT64_C(0x774f44046b73fe4c), UINT64_C(0x458bd17880682620), UINT64_C(0x98bf9e14260c147c) }}, {{ UINT64_C(0x1d163ac41fe94da8), UINT64_C(0xa2207970e7d76e6c), UINT64_C(0x09b392387be963ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x00ba220c47a65a9c), UINT64_C(0x94c003704408f31c), UINT64_C(0x6b2ba740293b176c), UINT64_C(0xbaecca78eb7284cc) }}, {{ UINT64_C(0x52b618046fc78284), UINT64_C(0x244b2fcc5cf9a270), UINT64_C(0xa45d827c72d0ddbc), UINT64_C(0xe80aa854b2249944) }}, {{ UINT64_C(0x537b805471e29304), UINT64_C(0xb2f31f18d47fffd8), UINT64_C(0xf86f4114f1ccd0b8), UINT64_C(0xfee874207f30b518) }}, {{ UINT64_C(0x11a2516071c34a5c), UINT64_C(0xd4c23ca406c4e6ac), UINT64_C(0xb4d81aa081449294), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e0e2a30f4c123f4), UINT64_C(0x752c23fc224dd08c), UINT64_C(0xd2aa6af0d2b9d494), UINT64_C(0xb458963ca3d1aae4) }}, {{ UINT64_C(0x052f95386a95fc40), UINT64_C(0x1edbba14ee18698c), UINT64_C(0x3122355cd5fbc73c), UINT64_C(0xaa2d178847e75408) }}, {{ UINT64_C(0x2f59d7b019d3d10c), UINT64_C(0x5891845050da6b30), UINT64_C(0x1c6d1c00d0480ea8), UINT64_C(0x49935b0833ba70cc) }}, {{ UINT64_C(0xc298904883b11bc4), UINT64_C(0x58fa62688bd10dbc), UINT64_C(0x86e46b4ce786080c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe30a51d81a77ea88), UINT64_C(0x0f3f73f453876710), UINT64_C(0xc84f496866f3122c), UINT64_C(0xf22c4fa811edd1f4) }}, {{ UINT64_C(0x9892639ca45b6aac), UINT64_C(0xa581edd4d16571e4), UINT64_C(0x3d6d33c8b8b77a08), UINT64_C(0x654bc2d4b38801b4) }}, {{ UINT64_C(0x80414e4cd54c3180), UINT64_C(0x1c98f54c813cde1c), UINT64_C(0x5d5fa488bb856e70), UINT64_C(0x55e409b4e5594d30) }}, {{ UINT64_C(0x7e56b974965c0134), UINT64_C(0x616c5650b4ca0400), UINT64_C(0xeefda17c65410354), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0664b078343641a4), UINT64_C(0x225697a01d6968c0), UINT64_C(0x0e4844d40b6077c8), UINT64_C(0xf803296c38564730) }}, {{ UINT64_C(0xc68a23c47f3a4b88), UINT64_C(0x0538bea8f9d35d70), UINT64_C(0x4b12aaaca4c1bfb8), UINT64_C(0xf1e53bc473e90698) }}, {{ UINT64_C(0xaecd414cbe9d0594), UINT64_C(0xdf748a409c5ac77c), UINT64_C(0x527ebff833e893f0), UINT64_C(0x098b05f407f32c5c) }}, {{ UINT64_C(0x82cb0f6825392064), UINT64_C(0xf3ffaa289c2d62d4), UINT64_C(0xe65466445dbae2a8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x51a9db102b764468), UINT64_C(0xfdc669c4c8af0c08), UINT64_C(0xbba4e8307ba4a7b0), UINT64_C(0xa2e8a1182779b838) }}, {{ UINT64_C(0xf623fb1c2c8c1794), UINT64_C(0x61778f8c84dd1ad0), UINT64_C(0x7bc49e14e618167c), UINT64_C(0x34442ebcbc36be20) }}, {{ UINT64_C(0x92f6cee499a82550), UINT64_C(0xf82f4ebce919dddc), UINT64_C(0x4743ac3cfac3da68), UINT64_C(0x4c7a9f40eabfc234) }}, {{ UINT64_C(0x2fabeddc97ac5770), UINT64_C(0x44864684c9f83e80), UINT64_C(0x57fcdedcbc386f38), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc55e17c4d0e4f894), UINT64_C(0xe9bb73544926f5e8), UINT64_C(0x0b9243844176db4c), UINT64_C(0x0a7ff314e1b0c34c) }}, {{ UINT64_C(0xc3c7b61cea631b3c), UINT64_C(0x64948bb02409c414), UINT64_C(0xea59ed1875d259a8), UINT64_C(0x260de0ecdd44ac00) }}, {{ UINT64_C(0xf0232df480d67fac), UINT64_C(0x2545d5a00bb3dc68), UINT64_C(0x3c8c37cc821d7110), UINT64_C(0x99a1798c1b59ed28) }}, {{ UINT64_C(0x26ecab684395406c), UINT64_C(0xc5206984d5b03554), UINT64_C(0x2bc83804895757c4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x80911e0c3a636d80), UINT64_C(0x853fa33848efd808), UINT64_C(0xccfbf944fa8ade58), UINT64_C(0x947d85380f8c71cc) }}, {{ UINT64_C(0x4ec0d9581ca0499c), UINT64_C(0x08c5b6d0c19774fc), UINT64_C(0xe75fc29cf85091f0), UINT64_C(0x704b69f497406f9c) }}, {{ UINT64_C(0xa239b698e87e76bc), UINT64_C(0x3d41122cebbe1194), UINT64_C(0x314f2e08d1ef1be0), UINT64_C(0xe153a304a8d53da0) }}, {{ UINT64_C(0x97bf5c10b45f28f8), UINT64_C(0x53cca01439ca6584), UINT64_C(0xdf2dc2ccac8c2330), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x126934d0ca9087c4), UINT64_C(0x682bd3ccf11eaa5c), UINT64_C(0xf921dac4d65f5d80), UINT64_C(0xce9ecf60c8664dac) }}, {{ UINT64_C(0xbf90f95027d317dc), UINT64_C(0x88f688a02f43e3dc), UINT64_C(0x829d8fe08d302630), UINT64_C(0xe5768d04cdc8800c) }}, {{ UINT64_C(0x27cf616c544f1598), UINT64_C(0x24c2e4f4dee6a33c), UINT64_C(0xca17ce4c364611f0), UINT64_C(0x2d00218c220a5a1c) }}, {{ UINT64_C(0xb737bf50015ff0d8), UINT64_C(0x5fc19fc4faa5bad4), UINT64_C(0x4d7a48804ae3898c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa4d7789c4dd911ac), UINT64_C(0x1d4a3b003deaeac8), UINT64_C(0x4c3920387f6aaea0), UINT64_C(0xdb19c6a8404e8a7c) }}, {{ UINT64_C(0x0ec6747ca1f00dec), UINT64_C(0x3eeb2a8439c311ec), UINT64_C(0xd112a01c0943c0c4), UINT64_C(0xcbc871ec6715d37c) }}, {{ UINT64_C(0xb0698464984675a4), UINT64_C(0xef7484285690bfb8), UINT64_C(0x5606b0904309167c), UINT64_C(0x2f0753c459d26748) }}, {{ UINT64_C(0x93d01f5873b67ad4), UINT64_C(0x51d8d1c0367d9e08), UINT64_C(0x174112d8c2e87368), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3221d05cb259ad90), UINT64_C(0x2555ff20e196e660), UINT64_C(0xd4a5db88bcebb508), UINT64_C(0xed3770543b2e8b80) }}, {{ UINT64_C(0xcdf29e740cffd120), UINT64_C(0x35bcf504ccea6858), UINT64_C(0xd9d6def03def0358), UINT64_C(0x6d79e8a80877af58) }}, {{ UINT64_C(0x5ec9d704d5bb7f94), UINT64_C(0x01f463c86b032740), UINT64_C(0x6ce779e045882d58), UINT64_C(0xe52c3b40f92561f0) }}, {{ UINT64_C(0xc3c65740f256dd24), UINT64_C(0xfa4376d02a825e74), UINT64_C(0x3cee66a02a8dee18), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xae7f3184d7e700a8), UINT64_C(0x1b166b1c066ab3d4), UINT64_C(0x631521686fac3f7c), UINT64_C(0x3e053b880bc7d95c) }}, {{ UINT64_C(0x659b3aa4e681e1cc), UINT64_C(0x40b4a670382036f4), UINT64_C(0x22a9dbeca6a19b9c), UINT64_C(0x5e6f1198ccf0976c) }}, {{ UINT64_C(0x1a2224e091010e24), UINT64_C(0xda496034d24ee76c), UINT64_C(0xca425b4003d2b738), UINT64_C(0x4e4c542814c6d4d0) }}, {{ UINT64_C(0x8c48e35c11920f24), UINT64_C(0xb5f0d9a89eddc140), UINT64_C(0x2699a11c54f81ad4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x16beca6c3234c504), UINT64_C(0x9bb67f347a7df098), UINT64_C(0x7ef0d3e8f2c1f5d0), UINT64_C(0x8d643cb0f9f4b87c) }}, {{ UINT64_C(0x4aa91930f1165560), UINT64_C(0x4889d0e858cfc954), UINT64_C(0xfe81c1289fbe160c), UINT64_C(0x43d7d63455323810) }}, {{ UINT64_C(0xa73135e8f7277e4c), UINT64_C(0xadb3bd349bb58ab0), UINT64_C(0xac5d6d2c0ced5b80), UINT64_C(0xf8e01644e544d13c) }}, {{ UINT64_C(0x1188fbbc8386082c), UINT64_C(0x43eef5bc0b0a1200), UINT64_C(0xa1ccb414e483ec6c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x23796bcc7a6cfb84), UINT64_C(0xa83dd9fc21dc2870), UINT64_C(0x96ab5290e7ffccfc), UINT64_C(0x5bc901e82ff8e9c0) }}, {{ UINT64_C(0xd25ead4c481acc4c), UINT64_C(0xe71c40c85560eed8), UINT64_C(0x80d5b3e4534f5d68), UINT64_C(0x86a1f4f80f6d1d48) }}, {{ UINT64_C(0x57560ad47999383c), UINT64_C(0xb44adca4599413fc), UINT64_C(0x1c3018a454d53520), UINT64_C(0x8ad34270c9757838) }}, {{ UINT64_C(0x220e0c8cab56f7e4), UINT64_C(0x3c754efc5916a080), UINT64_C(0x54643facadea3ac0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x10fac6dc50e2d094), UINT64_C(0x52319c9c22aea400), UINT64_C(0x7da0f128228cc6ac), UINT64_C(0x7710c08ca206d47c) }}, {{ UINT64_C(0xf955a2848ac73dac), UINT64_C(0x400c375850da5fa0), UINT64_C(0x321ae794845fe400), UINT64_C(0x5d5d8188f7c05344) }}, {{ UINT64_C(0x1ee44b5878b768ac), UINT64_C(0x18a3f224ba91e3fc), UINT64_C(0x568a5de803d1aa18), UINT64_C(0x3474b0c43fc00d7c) }}, {{ UINT64_C(0x58ddef7cf85a41dc), UINT64_C(0x1c22cd20c4a60498), UINT64_C(0xeb0c0b68b955c184), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1df08fc0441d16ac), UINT64_C(0xad2566f8cd28bea8), UINT64_C(0x65a91b0872464868), UINT64_C(0xe29ca85834f62578) }}, {{ UINT64_C(0x3351fe18edfff120), UINT64_C(0x6d899f20998f7c58), UINT64_C(0xad37e848437052dc), UINT64_C(0xfa8a1ce4a9612ce4) }}, {{ UINT64_C(0x189c39ac412383a0), UINT64_C(0x9685c06cf44e2f94), UINT64_C(0x46cf474c42010c98), UINT64_C(0xd3f206b0bcc63220) }}, {{ UINT64_C(0x190da2a81960f11c), UINT64_C(0x4348627845403794), UINT64_C(0x40ab35f83c2ed09c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb17e41e4fb99f5dc), UINT64_C(0xadf61aac801a6a38), UINT64_C(0xd0a19e4c14756fc0), UINT64_C(0xb0984530f8fa8a84) }}, {{ UINT64_C(0x3c869eac0eb44b38), UINT64_C(0xf951e294eb273d34), UINT64_C(0x040ebe845a1069b0), UINT64_C(0x59b28ebc21594d50) }}, {{ UINT64_C(0xe6c82a44a1c760d0), UINT64_C(0x0a7b2fd00065e6e4), UINT64_C(0xd320ff20c14b4570), UINT64_C(0xf3f61de46693b9ec) }}, {{ UINT64_C(0x2c1e40fc5519f7b8), UINT64_C(0xe98e0a3034438cac), UINT64_C(0x874a21741033ae7c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4885e1b8185052c8), UINT64_C(0x7deb0d44bc568ab4), UINT64_C(0x7a817884c8666bf0), UINT64_C(0x91ac61ece374ad44) }}, {{ UINT64_C(0xf5c8e5c0a1629954), UINT64_C(0xdf62c64069d6421c), UINT64_C(0x138c241cffe99ee8), UINT64_C(0x3cc0cd9ccb574ab4) }}, {{ UINT64_C(0x8b260e084f6cf040), UINT64_C(0x8aed49b8ef693864), UINT64_C(0xaf5b74e88acebc48), UINT64_C(0x236734987f0fea28) }}, {{ UINT64_C(0x8e6f930cdc8080c8), UINT64_C(0xf7e50e742e94f6ec), UINT64_C(0x5ee9d354935798bc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x89eba6f40225d6bc), UINT64_C(0x01fe10b0da612f70), UINT64_C(0xf5c840984752525c), UINT64_C(0x998e36a43baeab0c) }}, {{ UINT64_C(0xda868934fba05158), UINT64_C(0x46a4fec81617b118), UINT64_C(0x108d112850f73a58), UINT64_C(0x4e509b6c2b9a7e50) }}, {{ UINT64_C(0x0585e950f8721638), UINT64_C(0x79d4bb84fd5a93f4), UINT64_C(0xf0f73234f42248b0), UINT64_C(0x8c46c9d89eff3dfc) }}, {{ UINT64_C(0x627d199c43e09748), UINT64_C(0xb483407462269438), UINT64_C(0xb7160e6014b105fc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6b862c98ee32f464), UINT64_C(0xdd8afa847422e624), UINT64_C(0x179daa38b586b608), UINT64_C(0x931779e0b5feeff8) }}, {{ UINT64_C(0x391ab64c6b6451b8), UINT64_C(0xc0c50d987f0be1e0), UINT64_C(0xcc4fa924b1dd8ef0), UINT64_C(0x49fdb6acf84b6378) }}, {{ UINT64_C(0x662060b8a5b16a18), UINT64_C(0xbae21eb4ac168c60), UINT64_C(0x45390e00087cc628), UINT64_C(0xbb02d054559ce630) }}, {{ UINT64_C(0x2c5dee64738653fc), UINT64_C(0xb351ff4879c71b0c), UINT64_C(0x8656eb400e705be8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x21796cb06e2ff9a4), UINT64_C(0xfe11adb87ad80d04), UINT64_C(0xa8b4a4b409879f10), UINT64_C(0x6a3d7404da0450b4) }}, {{ UINT64_C(0xcacf9d2046a671f0), UINT64_C(0x5276a9a466ed0fe8), UINT64_C(0x1438022404bf9af8), UINT64_C(0x57e04474101b6c34) }}, {{ UINT64_C(0x72bfebf4f6aec308), UINT64_C(0xfb3a57b03728a6fc), UINT64_C(0x448171f48e20c578), UINT64_C(0xe431b54826b8bc00) }}, {{ UINT64_C(0x386b533456a714d8), UINT64_C(0xe3cf4f50b568e6e0), UINT64_C(0xce84dbc8b73c4f00), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xba56d8a0c7fe90c4), UINT64_C(0x03d07efc00487168), UINT64_C(0x8ef2a6a8b48eb69c), UINT64_C(0xf69ad4701ef2012c) }}, {{ UINT64_C(0x940a47b0b3e964c8), UINT64_C(0x41208c44f323f688), UINT64_C(0x13e393bca7c44628), UINT64_C(0xaad6f38c79994098) }}, {{ UINT64_C(0xa29657a8f4a8e750), UINT64_C(0x05172dcc618913ac), UINT64_C(0x0abee310364ca3ec), UINT64_C(0xd8afa4605ed39a08) }}, {{ UINT64_C(0xc0ded4b4a6c2767c), UINT64_C(0x225e97b048b49e1c), UINT64_C(0x256182f0b915f4d8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x91dcf40844a19204), UINT64_C(0x9b5c0380d9cd4f24), UINT64_C(0xe22456287bd2a2a8), UINT64_C(0x7811a52460bb9428) }}, {{ UINT64_C(0x790dcca4b1dd2060), UINT64_C(0x6344e2904e616ff8), UINT64_C(0xb096001c501ea218), UINT64_C(0x9230d8fcf59c84dc) }}, {{ UINT64_C(0xa5ec868ce92def90), UINT64_C(0x66af72684b597360), UINT64_C(0x759aaa44c5e0bfc4), UINT64_C(0x57a39188c88f0474) }}, {{ UINT64_C(0xb4a48d0838b137dc), UINT64_C(0x677d681c3b957acc), UINT64_C(0xf89df1108b45ba40), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x847fba4880a27cb8), UINT64_C(0xea694ac00a5993fc), UINT64_C(0x3feb5e48e42b1254), UINT64_C(0x3f467fc04365766c) }}, {{ UINT64_C(0xe58dbbec671dddd8), UINT64_C(0xcd6e83a823c55434), UINT64_C(0xfabbccf8b2f4d148), UINT64_C(0xc0793cfc945f856c) }}, {{ UINT64_C(0x4b4b062c14daf894), UINT64_C(0xc29ef83c7a26dbb0), UINT64_C(0x5ff146d819018398), UINT64_C(0x97c6138cc1a2d068) }}, {{ UINT64_C(0xe4cb5a6c262ab154), UINT64_C(0x8aafddc407351d2c), UINT64_C(0x4fba01a0ec74380c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc980b1308a952fc8), UINT64_C(0x5e1082a410ac2464), UINT64_C(0xba7fe0dcf941712c), UINT64_C(0xc39a93041c39ed8c) }}, {{ UINT64_C(0xb288357c75291394), UINT64_C(0xa431639c38f23324), UINT64_C(0x3d30ce2cea0527fc), UINT64_C(0xbba04e2c006341e8) }}, {{ UINT64_C(0xb23621600dbf30b8), UINT64_C(0x2c3c17e4d4062bd0), UINT64_C(0x2b9c4834a29918d4), UINT64_C(0xabcc8d609fd27b3c) }}, {{ UINT64_C(0x1893c940e126b7a4), UINT64_C(0x6536486c1e1f9d24), UINT64_C(0x38a0bce0e3b21c78), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8cbed324787ae38c), UINT64_C(0x755242f4b028ee28), UINT64_C(0xa3ad1bcc104a74b0), UINT64_C(0x2a04360899e94054) }}, {{ UINT64_C(0x75bf3710987fbd7c), UINT64_C(0x403c5b50ee04380c), UINT64_C(0xc093d6e05fd70d1c), UINT64_C(0xb46d2f2cfaccef08) }}, {{ UINT64_C(0xcace1b5cca0539e8), UINT64_C(0x644b3af86c944bf0), UINT64_C(0xec48fc8ccee99258), UINT64_C(0xb6e07ccc25e15858) }}, {{ UINT64_C(0x22837f38f8ad7bec), UINT64_C(0x32c2a898f14b7adc), UINT64_C(0x7c4cffd0eca5ebb4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd498fbbcd971eaf0), UINT64_C(0x215c7f8046f15ca8), UINT64_C(0xe4db72902882ca78), UINT64_C(0x717e67986d1e3d00) }}, {{ UINT64_C(0x14abff1084fad418), UINT64_C(0xbdb4855026d02ccc), UINT64_C(0x0e76a5fcc2dec0c8), UINT64_C(0x6db2dd78816c1170) }}, {{ UINT64_C(0x425b69d07790a50c), UINT64_C(0x6eb1844c80ceed94), UINT64_C(0x4f14aa6047550f88), UINT64_C(0x42db98ccb43e3a48) }}, {{ UINT64_C(0x54f2a1c0309f3eb4), UINT64_C(0x5a691e3c9ca355a8), UINT64_C(0xadf5f7105bbae888), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbbc9ae3cf2b50bbc), UINT64_C(0x3c4a49ccaaa0da74), UINT64_C(0x9a2d6a94e497d810), UINT64_C(0x94970ff8b4a2b534) }}, {{ UINT64_C(0x7ed2ee4432b22c04), UINT64_C(0x88cf84b0dcc45818), UINT64_C(0xb26cda04f777c31c), UINT64_C(0xef6fd788ffbe0f40) }}, {{ UINT64_C(0x6f40608c584eda90), UINT64_C(0xa38ba0f821202ea4), UINT64_C(0xd38120ec7dad01b0), UINT64_C(0x83b97618f0d7cadc) }}, {{ UINT64_C(0x495812c4c6c1f204), UINT64_C(0x955a07dc4de52050), UINT64_C(0xbe3a5dc0065b4928), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd0ef007c43f4e720), UINT64_C(0x023810dc82581304), UINT64_C(0x7ff261f8c0908fd8), UINT64_C(0xeea39370c91ad9fc) }}, {{ UINT64_C(0x857f75f8c55cb178), UINT64_C(0x4dd53f0c18cf8270), UINT64_C(0xe24d3054244fe938), UINT64_C(0x36554ea86e44f4a0) }}, {{ UINT64_C(0x175c785494567284), UINT64_C(0xe8542e58b7bb100c), UINT64_C(0x4d8309bc4a195ff0), UINT64_C(0xe7b462e07e568418) }}, {{ UINT64_C(0x6392b69085934060), UINT64_C(0x80912b84e86f0234), UINT64_C(0xd0b4532877be7f1c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7fec913c0c5ba0d0), UINT64_C(0xc359cc04251bd1a8), UINT64_C(0xcffb98d4b1ab0f10), UINT64_C(0xf8ddc5f4fb19c3cc) }}, {{ UINT64_C(0x24c3eb586a9e612c), UINT64_C(0x0edfc67ccd338adc), UINT64_C(0x4c3212d0f297ad8c), UINT64_C(0xe238ac8cf9fa7410) }}, {{ UINT64_C(0x057eea082d01effc), UINT64_C(0xfd1281b0b0df79cc), UINT64_C(0xefd56a28abe299f4), UINT64_C(0x45af595c49c86688) }}, {{ UINT64_C(0xf325bfa0c0b0c920), UINT64_C(0x2de142a8e3725aac), UINT64_C(0xab9ed4fcd99ea48c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x134185d060cbbcec), UINT64_C(0xb9d2fb680961f950), UINT64_C(0x34b31920ee9bfa64), UINT64_C(0x19ce8da816c62f54) }}, {{ UINT64_C(0xdb1596cc12297388), UINT64_C(0x85b14dbc5dfb1460), UINT64_C(0x9181d4dcc174e74c), UINT64_C(0xc64641846e992c94) }}, {{ UINT64_C(0x3873890c4faf5c7c), UINT64_C(0x04692e94e812c150), UINT64_C(0xf7313294d7668000), UINT64_C(0xb4997500d8062b58) }}, {{ UINT64_C(0xa671cba0eb779258), UINT64_C(0x999169f8d68ab028), UINT64_C(0x6e09986498692820), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x48bcff2099ce4d04), UINT64_C(0x465c81580de91194), UINT64_C(0x272bafa48fd3dd4c), UINT64_C(0xef7893cc93078004) }}, {{ UINT64_C(0x6468e23c97152c24), UINT64_C(0x53a98db06848b394), UINT64_C(0xd5b22328919788a8), UINT64_C(0x1f9503a4209d5b54) }}, {{ UINT64_C(0x8930bd88b2050e58), UINT64_C(0xdb63db60d1d76b9c), UINT64_C(0x206298fcf061435c), UINT64_C(0xfd9851d44a43d74c) }}, {{ UINT64_C(0x0153d850170512e8), UINT64_C(0x9b3bbaac35ed2148), UINT64_C(0xc940e844e3d0b2b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x309d412052198550), UINT64_C(0x61b7efd4fc526c48), UINT64_C(0xd1fdd30c2c866300), UINT64_C(0x5ac75958bcd27a04) }}, {{ UINT64_C(0x25d9fa5c56159598), UINT64_C(0x486cf054904bcba4), UINT64_C(0x887f0da0a6f80658), UINT64_C(0x2164f514ecca0698) }}, {{ UINT64_C(0xa6037abcdd8e08c8), UINT64_C(0x5c1fa168a330afa4), UINT64_C(0xba0a33a4d03714c4), UINT64_C(0x9f1a8634f392e14c) }}, {{ UINT64_C(0xd3726e08d08e2204), UINT64_C(0xd4462f90fe5a6c88), UINT64_C(0x7f536b409a0b7008), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd294775884c0dd14), UINT64_C(0x06c1c908fd1c45f8), UINT64_C(0x7d91a8c86ef5e7b0), UINT64_C(0x41491d0ca5a8a010) }}, {{ UINT64_C(0xfdf1ef3c8dc18474), UINT64_C(0x3833a52829050d20), UINT64_C(0x16f4ad4c2e1d3134), UINT64_C(0x36e12c08806c20d8) }}, {{ UINT64_C(0x0decfde44aefb6d4), UINT64_C(0x05168d68b4442a70), UINT64_C(0x4c0754cc60cdf2b8), UINT64_C(0x9d6fa6ac4a227e44) }}, {{ UINT64_C(0x7cb75674e52509b8), UINT64_C(0x3b394ab89927373c), UINT64_C(0xd676a85c90652098), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc0d49774b6ee2120), UINT64_C(0xa45c7ce4b5016728), UINT64_C(0x56de4ccc02a06470), UINT64_C(0x24b3c994b3f43a80) }}, {{ UINT64_C(0x2fbcd954eae83538), UINT64_C(0x056ddf1877abaf70), UINT64_C(0x37239178ba0bf2e4), UINT64_C(0xe79c7afc53a4d024) }}, {{ UINT64_C(0x7b826e500afb9dd8), UINT64_C(0x9bcf2d40173a6398), UINT64_C(0xd505293c230f35dc), UINT64_C(0x0add2e3cec88ea84) }}, {{ UINT64_C(0xe23126081ae32e8c), UINT64_C(0xa624ee1c0a32ef70), UINT64_C(0xd6e6b92068750108), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x67e85444df4ce8b8), UINT64_C(0x472d725c9089ce14), UINT64_C(0x241397cc6a8aca48), UINT64_C(0xb817bf4c3c98ec1c) }}, {{ UINT64_C(0xf13d1a848d6eb7d4), UINT64_C(0xf8bcbb945c36bc28), UINT64_C(0x8e16b8f44c6e9bdc), UINT64_C(0x0c0de5c8a5ce4de0) }}, {{ UINT64_C(0xf2d385bc9ee1ecc8), UINT64_C(0xaaf48d78b37e2fd8), UINT64_C(0xd31f68b8383f5930), UINT64_C(0xbd05644c6e112700) }}, {{ UINT64_C(0xfe2262687725dd8c), UINT64_C(0x77bfd65099338b7c), UINT64_C(0x46f598c09948359c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac7d6c5c6c3cfe1c), UINT64_C(0xcbfef220f1ba3a80), UINT64_C(0xf3a71c604a9dbfbc), UINT64_C(0x23a718204bbc83e0) }}, {{ UINT64_C(0x4f257d587e6e809c), UINT64_C(0x6550ff087fcccd44), UINT64_C(0x271ae158d94d02f0), UINT64_C(0x1fbfaba8a2c4a0c8) }}, {{ UINT64_C(0xfefba5a046cd2c08), UINT64_C(0x8d6c6d08b60bdb74), UINT64_C(0x92e574d837814788), UINT64_C(0xc2c837d063947b44) }}, {{ UINT64_C(0xae45409c4781bf28), UINT64_C(0x49f6ea907ce49504), UINT64_C(0xa6316d10822fbdb0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xae21b0a4434d0720), UINT64_C(0xd4806bc87b4b32e4), UINT64_C(0x89467904028ac67c), UINT64_C(0x49f2e8c82644b0f8) }}, {{ UINT64_C(0x7534ca00b95fe2cc), UINT64_C(0xabc6e8005b97fa64), UINT64_C(0xac0241642ba6e5ac), UINT64_C(0xd27162f4df4d539c) }}, {{ UINT64_C(0xa7b6619cf73ccc88), UINT64_C(0xe3165c244765b1a0), UINT64_C(0x5b4234a0c6195710), UINT64_C(0x41b45cc417a2d024) }}, {{ UINT64_C(0x574da5e41d0a4328), UINT64_C(0xba6c0554d3916140), UINT64_C(0x1b4060ece93244ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8740e378b78622bc), UINT64_C(0x648b45583e72f090), UINT64_C(0x4f7360ec2cbe7a88), UINT64_C(0x88bab354f0010190) }}, {{ UINT64_C(0x63226e50f2726f34), UINT64_C(0x1d037804ffbdc068), UINT64_C(0xe31631d47bad0498), UINT64_C(0x97b47fcc8e9e413c) }}, {{ UINT64_C(0xea95da5ca3d988cc), UINT64_C(0x339e5b845176fd14), UINT64_C(0xdfecf7f0aab0d598), UINT64_C(0x60a47eb0a0e01484) }}, {{ UINT64_C(0xbd6226a0a3b91268), UINT64_C(0x37916d000d42b924), UINT64_C(0xe1034504d49957c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3c0b8ee8abe9402c), UINT64_C(0x0b8e0f18974711b4), UINT64_C(0xf1b795d4cdce0a9c), UINT64_C(0x4d0ebf847b7cc2c0) }}, {{ UINT64_C(0x5dcfd91036358160), UINT64_C(0x7565193cde03b08c), UINT64_C(0x7bece4c8c1da5c20), UINT64_C(0x9a64cb4439b72a68) }}, {{ UINT64_C(0x9df819d05fce5c18), UINT64_C(0x1f8ade90ad909270), UINT64_C(0x2b6494f860c8e124), UINT64_C(0x37b031d44a239484) }}, {{ UINT64_C(0xef080bdc1bcd3208), UINT64_C(0x409947b0dff8b068), UINT64_C(0xd3d94594c8376ff0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x96121e8c01588954), UINT64_C(0xe266158828aa1d80), UINT64_C(0xb351c06c781352a8), UINT64_C(0xd58dfe7443670aac) }}, {{ UINT64_C(0xb9596b88892550fc), UINT64_C(0x50979b6893ac4548), UINT64_C(0x318914b865497b74), UINT64_C(0x618ee3908c7ea6d8) }}, {{ UINT64_C(0x189e3848a6eb1d3c), UINT64_C(0x83360548f02e290c), UINT64_C(0xd9164910efcce1e8), UINT64_C(0xa2453524f7c6ee6c) }}, {{ UINT64_C(0xf9f3647ce9567ffc), UINT64_C(0x659fbf887e5e32e8), UINT64_C(0xdd8dcae839577298), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6fc64938fab39810), UINT64_C(0x16856568628bea10), UINT64_C(0x1a506f18e557a390), UINT64_C(0xab2daf24dafec130) }}, {{ UINT64_C(0xf56e33f05580eef0), UINT64_C(0x285cad5cfc5c1068), UINT64_C(0xedb644c862e7d5f8), UINT64_C(0x33b5442cf668f80c) }}, {{ UINT64_C(0x6d5b1e70dbec041c), UINT64_C(0xba11e2d0b052cb0c), UINT64_C(0xb1072db85d7d8c2c), UINT64_C(0x72e651f0de6f92c4) }}, {{ UINT64_C(0x9f24487ca5331adc), UINT64_C(0x8c1f87a07241c2a0), UINT64_C(0x1555765c7b6062a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3d3c2deca860fdb8), UINT64_C(0xa816e904b0b94c4c), UINT64_C(0xe23005c01cfdad0c), UINT64_C(0x3f32804078b028a8) }}, {{ UINT64_C(0x1387d610526f7720), UINT64_C(0x9372a408b86edcbc), UINT64_C(0xa60702f40ea828f0), UINT64_C(0x6a490b18f71e20f8) }}, {{ UINT64_C(0x7550f88c5c2c220c), UINT64_C(0xe19928d0caaffa4c), UINT64_C(0xb681859450222b80), UINT64_C(0x1b66ac4cc70827dc) }}, {{ UINT64_C(0x2b41599c66cfef40), UINT64_C(0x90a3643ce0936668), UINT64_C(0x32644f54191138d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9eeaf260424b57d4), UINT64_C(0xbfe5ac70e0484640), UINT64_C(0x4ff2745ca9e20c90), UINT64_C(0xe39caeac5986ded8) }}, {{ UINT64_C(0xe553418c3da1adc8), UINT64_C(0x5f6c7db828e52968), UINT64_C(0x5ed90974a85a6268), UINT64_C(0x2ce839b8a4ff3d2c) }}, {{ UINT64_C(0x66312250ca66d4e0), UINT64_C(0xbddfadd04f6d9198), UINT64_C(0x9ca2ff54a7da9c48), UINT64_C(0xc2492d44a04ec310) }}, {{ UINT64_C(0x18691de0196e3e90), UINT64_C(0xd4b39ea08fd57244), UINT64_C(0xd56a9c1cb32d6be4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb74f098489851d50), UINT64_C(0x1e8a77c0d77ad418), UINT64_C(0x1147be08e1a785bc), UINT64_C(0xd0f581f020375c94) }}, {{ UINT64_C(0x7b8b66983689b044), UINT64_C(0x9705b0acafe2bb70), UINT64_C(0xacc1088cdb2b7d54), UINT64_C(0xcea6c8340bb415b8) }}, {{ UINT64_C(0x93b3388c3bf02d74), UINT64_C(0x28dc57d0e725f6cc), UINT64_C(0x2d132354b98d7fdc), UINT64_C(0x0068ea087f45da80) }}, {{ UINT64_C(0x43d07a2456a9915c), UINT64_C(0xfdd3d1ecfeeab7ec), UINT64_C(0x39edbad4280a831c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe618d744eba1e760), UINT64_C(0xfcb284d4f6200a5c), UINT64_C(0x5d4b41788eb52e0c), UINT64_C(0xe373bf288d7d5c10) }}, {{ UINT64_C(0x37a32d102051bec0), UINT64_C(0x2126ea38697b3dcc), UINT64_C(0x66958f88be4258b8), UINT64_C(0x48c16d68a6862eac) }}, {{ UINT64_C(0xeb0e18e05e504680), UINT64_C(0x000f101c6e4bd588), UINT64_C(0x7c3ff618a93ab1f4), UINT64_C(0x07ce94d4d233f514) }}, {{ UINT64_C(0x577d9300ae7b39a0), UINT64_C(0xad77cac0bd514508), UINT64_C(0xde9d4e20b0dd6520), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xafcb72a83a9a3a78), UINT64_C(0x61042a90d457e2e4), UINT64_C(0x5a993e1814c31988), UINT64_C(0xd47a6058783d5190) }}, {{ UINT64_C(0xb7e299346bdae8c0), UINT64_C(0xcf7b8630c7825f78), UINT64_C(0xdaaeb6e846005f1c), UINT64_C(0x8c4327642e61076c) }}, {{ UINT64_C(0xea5af2b009adca4c), UINT64_C(0x732b54406d900838), UINT64_C(0x724022a021089d90), UINT64_C(0xb6a336580f370ce4) }}, {{ UINT64_C(0xc9704c6c113f14c4), UINT64_C(0x6bc96fc468745018), UINT64_C(0xae26fca47d9722e8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaeec9d606f9cb108), UINT64_C(0x6ea926f80f12a8dc), UINT64_C(0xc992a780ed855c78), UINT64_C(0x5f01301804eaa078) }}, {{ UINT64_C(0x156b4ae0d64e9764), UINT64_C(0xc42e4618ebc6954c), UINT64_C(0x3f44085074baa37c), UINT64_C(0x49002ea0388e0444) }}, {{ UINT64_C(0xa4a0e2b8642d8714), UINT64_C(0xb66fa230bec327d0), UINT64_C(0x61660db486a3b248), UINT64_C(0x7045387073ec16d8) }}, {{ UINT64_C(0xfbee0e88d5f88f7c), UINT64_C(0x73ae9070be774c24), UINT64_C(0x97bdace8e7836eac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd1a75e947cb682e4), UINT64_C(0xe542a83cba4e804c), UINT64_C(0xcfb6c398b9ac7068), UINT64_C(0x23d6bc846271d420) }}, {{ UINT64_C(0x8a7be84c1d37c0a4), UINT64_C(0x1e712fc0e08cf170), UINT64_C(0x2a1b746c55c2b3c4), UINT64_C(0x98a8a388fa0d3dac) }}, {{ UINT64_C(0xa192848c59caf468), UINT64_C(0x9745eaf0b848082c), UINT64_C(0xa4bf57fc6b55ddb8), UINT64_C(0x569d6ba84398bcec) }}, {{ UINT64_C(0xe8fe12c0f499e8e4), UINT64_C(0x424d9bccb3ee3a9c), UINT64_C(0x3d7764ac6416e860), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc55543a026c97308), UINT64_C(0x810f9730e0b62a90), UINT64_C(0xfcce3ec471f62620), UINT64_C(0xc1283a186165fcd4) }}, {{ UINT64_C(0x0730361c1f7bd2c0), UINT64_C(0xd36d4574f0e76960), UINT64_C(0x49a509d8743ebc34), UINT64_C(0x6a6e22709de68afc) }}, {{ UINT64_C(0x18cd2d388683b5c8), UINT64_C(0x0b34bec81e37cf60), UINT64_C(0x4fba9170da3d9c38), UINT64_C(0x40f0bce055e3eee4) }}, {{ UINT64_C(0xeca7513ce21926a4), UINT64_C(0x095219d84ef6474c), UINT64_C(0xee3cbea402f2f588), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6466a8986d6a5734), UINT64_C(0xe27090a4ae6dbbc4), UINT64_C(0xd909082c7aac7160), UINT64_C(0xf20e09fc46dad6dc) }}, {{ UINT64_C(0x934f02c81eb4db10), UINT64_C(0x66d2aee4fffa5de8), UINT64_C(0x13ea10d8e76790fc), UINT64_C(0x7229ff8423f89444) }}, {{ UINT64_C(0x31ae97a8eb8fc934), UINT64_C(0x1bce5c0c0c0de5a0), UINT64_C(0xccbd2a0876fd1084), UINT64_C(0x54c2d43c452f6d80) }}, {{ UINT64_C(0xb115c418a0e9add0), UINT64_C(0x03f44ef0716265c8), UINT64_C(0xd06db1805105a2f8), UINT64_C(0x0000000000000000) }},
};

static const block_t precomputed_constant_linear_part[] = {
  {{ UINT64_C(0x889b1cf503da659b), UINT64_C(0xec68223e774408b3), UINT64_C(0x000000030a547fac), UINT64_C(0x0000000000000000) }}};

static const block_t precomputed_constant_non_linear_part[] = {
  {{ UINT64_C(0x2131af1c51701a00), UINT64_C(0x0e393dc091890428), UINT64_C(0xb7b57a5c7de04b90), UINT64_C(0x7c84ff089d5b858c) }}, {{ UINT64_C(0x07ee1764f0c4f02c), UINT64_C(0x71379a7064bedb1c), UINT64_C(0x985ddd1ca27541cc), UINT64_C(0x72cccdb0144c3920) }}, {{ UINT64_C(0xc92f376c1096760c), UINT64_C(0x47e8d644bfda5160), UINT64_C(0xc6883df8bb1a6430), UINT64_C(0x07955aa0d372ba5c) }}, {{ UINT64_C(0x6b1ae9fc9f18805c), UINT64_C(0x93e6598ce9b87e48), UINT64_C(0x6025c0c8d35655a0), UINT64_C(0x0000000000000000) }}};

static const block_t Z_r[] = {
  {{ UINT64_C(0x5816a4ebde764428), UINT64_C(0x9ab7a0cbae5098b2), UINT64_C(0x6d7cb0489df96228), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe0c5aef4bae46a95), UINT64_C(0xe65222c4133856de), UINT64_C(0x411731df9a0d7d8f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x31722b1c10a24aec), UINT64_C(0x3c6234be9d8aa14d), UINT64_C(0x608c5f0a8c56f67c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x577c308df1db76ae), UINT64_C(0xda000f13a348e7fb), UINT64_C(0x21df99e2b9e9cdc3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x36b3968b8e9c3572), UINT64_C(0xb74642c5d7ba4564), UINT64_C(0x34ad710f760369e5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf8c714567e1fcff2), UINT64_C(0x4f87662dd6ec16bd), UINT64_C(0x0e37b7046eb6f1b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x18e9db4cc76c98c2), UINT64_C(0x19d62f500670bb79), UINT64_C(0x58a6970eb26fdb19), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9119cf47e9a24a1b), UINT64_C(0x0f0462e8ba0b8992), UINT64_C(0xf88bc8e0ecc1f23b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfb18e4248aaa1538), UINT64_C(0x5e831394f0298a5c), UINT64_C(0x1f16e22a8c440821), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x75ea0e5cfd8326fa), UINT64_C(0xe6b1fc74e0b0d28a), UINT64_C(0x7fddb98cbb9a7653), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5eae550b6bd84a71), UINT64_C(0x4fc04ba26253ea0f), UINT64_C(0xeb9a8799a93501a2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc9f8de974cf39404), UINT64_C(0x435b79721b48f25b), UINT64_C(0xe32defee89542fd2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2915fcbbb4ce5ebb), UINT64_C(0x24b8a28daea2746b), UINT64_C(0x58d7ddce0ce58d2b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x179753b8a0402e09), UINT64_C(0xf941f1a17a36ed74), UINT64_C(0x160d3115f07c8302), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x551209e295b59b8d), UINT64_C(0x2a2ea87491248e1d), UINT64_C(0x3925ac30431d5690), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x10ed2aca1bf641d2), UINT64_C(0x9ae874ee950f85b0), UINT64_C(0xe149944dd5a35f32), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6eaeafc4c0d96740), UINT64_C(0x8c58324f26153015), UINT64_C(0xf43b8599fdd034ea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf01cfb0505a02dc9), UINT64_C(0xa702a15a498fee25), UINT64_C(0xf64e26070b1e4b34), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x46e2a7348365aa55), UINT64_C(0x72495e9c7c0e3a71), UINT64_C(0x9a1b85bc5088fbcc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa250ebe378211cfe), UINT64_C(0x909a2ca606d404a2), UINT64_C(0x86da10e02f6e0bda), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3e42e6838ade7dd3), UINT64_C(0x304ba2424bf0ac45), UINT64_C(0x3934fa879de35138), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x997753ef3f48ce86), UINT64_C(0x20a76d9171a93d14), UINT64_C(0xa34058af1698cca1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xde8a16dd7edb6c56), UINT64_C(0x26a503faaf4c3b99), UINT64_C(0x7426f292eda63966), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x362a18276c806525), UINT64_C(0x0f053854be7af3e0), UINT64_C(0xd05f7559a1ef5c11), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x13ec714410ff5a53), UINT64_C(0xc7ec6c1ffcec5814), UINT64_C(0xa679bf987f98b636), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe19cfa7b9714aa12), UINT64_C(0xba3d83304456ba4c), UINT64_C(0x7dd1a82335baf9f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6b8bcbe4bd612aaf), UINT64_C(0x80a721e151c83a69), UINT64_C(0x522e492099cc5341), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb92ac57dc2130093), UINT64_C(0x4c914ec4dab1ce9c), UINT64_C(0x9d460bc50edd4aa3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x322b0f5efbfc07f3), UINT64_C(0x748cd7cfc4df77ec), UINT64_C(0x3d2bd93d44920195), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x32a49759f9f0cccb), UINT64_C(0xfae90d8e4b23fc26), UINT64_C(0x802b7983e922276e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x53f7e14d44a7823f), UINT64_C(0x0e7b4979721a803e), UINT64_C(0xc02fab0e92496cf3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x79bd71ab224ec2d5), UINT64_C(0xbfbc5cc1d0a54b5d), UINT64_C(0x92854a592253a3eb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x871525a835848a8f), UINT64_C(0x272cf45413ba6506), UINT64_C(0x8d54fb15ea55a0e2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2de615969142adfc), UINT64_C(0xc5a473b4fe1c68ce), UINT64_C(0xb36aabeb45435a46), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5690bb8742f1d170), UINT64_C(0x28493dac7a7a2592), UINT64_C(0x448028f27fa176ce), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x174342c5958984c4), UINT64_C(0x159e1c59f8ee5bf1), UINT64_C(0x6c8760d14f85ae48), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1d949f348207959f), UINT64_C(0x54fd57206b1020ab), UINT64_C(0x162d708ebd782cee), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x94b8e552bf8c9121), UINT64_C(0x217b79ee9cc90a81), UINT64_C(0x903eb4be92949f68), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x66b1f1cc7e697f8e), UINT64_C(0xb0d192a6a10f7088), UINT64_C(0x71ea0bf3728084a2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb4d6c7a285a09b3f), UINT64_C(0x246a77455e114d96), UINT64_C(0x8a3de0b0680df39f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xec93587c2f4c39dc), UINT64_C(0xbbf2ba05ff6dfed4), UINT64_C(0x46d33c1d1412be87), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1c73aad6007689f3), UINT64_C(0xa4fa031cd7dfccdd), UINT64_C(0xdc171ab63ea44c92), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9bdf56c387b817e2), UINT64_C(0xd5560386d642bd70), UINT64_C(0xd542fc6bddb189b6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xffa7ce08a1056b9f), UINT64_C(0x22f222639c1c79f5), UINT64_C(0x71af2b5423efc157), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0550dfa85c0c8e30), UINT64_C(0x08ac47a001f00b46), UINT64_C(0xefbe2afb1f085436), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa275cccd1c27e31e), UINT64_C(0x15687afcce20e17e), UINT64_C(0xd5ec07f32cc7ae13), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5f8842346782e5ce), UINT64_C(0x7a904bcb0596ce14), UINT64_C(0x0429ac3107d1594e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5b082ffb519780c4), UINT64_C(0x6f2355a7ff7a5caa), UINT64_C(0x62ccd6dee54dfc58), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5457d60088941bd5), UINT64_C(0x84aab970c2710e2b), UINT64_C(0xef2e193f2d542f04), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd1d9bb822f8dc7b4), UINT64_C(0xd2ef209225d01962), UINT64_C(0x9cd2772d7267cc4f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x777d711aa0095082), UINT64_C(0x304e09271dc4d256), UINT64_C(0x9d486eb4aa5af80f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdf0313df4874a188), UINT64_C(0xf30d5ac30049749e), UINT64_C(0x4e34aaed5fd185a7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc5069b14139ec627), UINT64_C(0x2c92e76a192600ab), UINT64_C(0x6fdba8455b1f330d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e5e510388e5339a), UINT64_C(0x13c80605329c803e), UINT64_C(0x1253efdd39f90659), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f20d079e3e107ea), UINT64_C(0xec33378f70e1523d), UINT64_C(0xe3ea57851cc41225), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1a9f765ff45870e5), UINT64_C(0xd81a5bc11cf42224), UINT64_C(0xdc6ed78eda59ea8a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x80fe7578502cc85e), UINT64_C(0x8bab90636794aa0d), UINT64_C(0x1e05a95592f3e764), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x63b6b9a7d9455f71), UINT64_C(0xe7e9b936ff657b7f), UINT64_C(0x5f422175b02bf962), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x17d336a7d9f8406e), UINT64_C(0x0a44102dfb84bfa7), UINT64_C(0xfbcdbafd16aadfec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc830c6075dd19fd5), UINT64_C(0xac7c00fb485da074), UINT64_C(0xa2efade55a4cdb96), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe7183c73c01e7ea1), UINT64_C(0xdee66f7a4b609673), UINT64_C(0xf91bbb778e6434a9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8afdcca9fb3b3ad5), UINT64_C(0xf6fb24b697396280), UINT64_C(0x7cba8d1ce818b67c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x43a141795bb016ad), UINT64_C(0xc37a52723469a117), UINT64_C(0x6b4ae324f101e3b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xca5e3f0598639157), UINT64_C(0xff362196b16e7e60), UINT64_C(0x27cd26b6333d6c5e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x00ae150643b9d7b0), UINT64_C(0x3935e81a71a6a6a2), UINT64_C(0xf67df6610306c596), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa8aad129ad7ef6e3), UINT64_C(0x17c00520e9e76560), UINT64_C(0x1bac0d1d3b4cf729), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb19bcf8c3f318b7d), UINT64_C(0x1ff1bbedb04b1d1a), UINT64_C(0x086afcbcbc5fa63b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc885d93232f6aaf6), UINT64_C(0x5118e9c3538f8f1d), UINT64_C(0x6e171d4a8aef0594), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdb4999087faef154), UINT64_C(0x77610ff0066f2507), UINT64_C(0x7934beb8433ddd56), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x685c740042dc806e), UINT64_C(0x5e47db0c537636f9), UINT64_C(0x00797b1e017b8cea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x90d8213e3c6ceb4d), UINT64_C(0xc9485e48e2a418a3), UINT64_C(0xc8915e1b51fa6fad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe91f006b162c18be), UINT64_C(0x8f6d5842ba043686), UINT64_C(0x446d971a2712f49d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb0428281bef2c5d), UINT64_C(0x9ed14364fc65d00c), UINT64_C(0x9903dff1a74af429), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7af36915ff15c7e6), UINT64_C(0x7f430c624f0f88ed), UINT64_C(0x9252dc0086589326), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x111c964a801dd104), UINT64_C(0x99cc148ccbe51256), UINT64_C(0x1125be101286dbe3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa50a58038e75e581), UINT64_C(0xcb6fac48ba34d06f), UINT64_C(0xfd7ddba72e76e56c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e48dd32ddc4b342), UINT64_C(0x1f32096972461d40), UINT64_C(0xef05dd2e1189ff7d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf89307f6c0e50096), UINT64_C(0xbdb65cee87edc093), UINT64_C(0x426a0cec3797b17c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x02920e83f573f9cc), UINT64_C(0x2b65ce18df4d5d86), UINT64_C(0x53260b9818ef9b7d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd214ed95e96b8c55), UINT64_C(0x8f8cbf8996f58d2d), UINT64_C(0x285cb3e74ed52363), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2c648148a34dffcc), UINT64_C(0xfd725b2659244d94), UINT64_C(0x3423180d05e7f2e9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6429e55e3ba4f104), UINT64_C(0x4c9682ec3c63c0b6), UINT64_C(0x98a78a93c79ae1ea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5bb8e1bdfc2cdca2), UINT64_C(0x0d4514e8c81a1b26), UINT64_C(0x6aa169d8d4ad8d98), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd474768991def05e), UINT64_C(0xe0a5b5f4def77bd0), UINT64_C(0xc1ef064eae81f034), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x29c48e7375af5c91), UINT64_C(0x16597400a3a88d46), UINT64_C(0x5fa755b155a8f022), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc52c8fd56ae155aa), UINT64_C(0xd0b238d7d5c31e16), UINT64_C(0x9ef761c7e3994479), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8eab1a35c8b73599), UINT64_C(0x6fd3b8065641822d), UINT64_C(0x6c6bb71f358c35b3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfdfd24a410d7e516), UINT64_C(0xfb772de4f3418f41), UINT64_C(0x10d3c7afb9e3e956), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf85c41f584a207b4), UINT64_C(0xe4a75bae036b4cf7), UINT64_C(0x3c17e1847e4d6438), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0e208c9adf6b3e17), UINT64_C(0x4897dad9f67d67a1), UINT64_C(0x7321576802938eb7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcf7820b8090dee54), UINT64_C(0x43574bd7c87f2243), UINT64_C(0xe8b90805af447174), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x68fa5a1104b8eda4), UINT64_C(0x57274404eac20f2f), UINT64_C(0xbd5fa5685f8a768d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x56a26bc00831f044), UINT64_C(0x02024e4e407f2b54), UINT64_C(0x552dcf3d9b4bc2b5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdc3389fc8a1ed546), UINT64_C(0x3432469ecd3af7be), UINT64_C(0x14f1991e0d7aff98), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x507f6e5cc8a34bd7), UINT64_C(0x1e5b3351e837f986), UINT64_C(0x5b25c106b6a9d10d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc7912ce68be18e07), UINT64_C(0xfe036542399ed7fe), UINT64_C(0x7a8b8fb230e45a1f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x76ecea47c0aa051d), UINT64_C(0x33b043018a988c40), UINT64_C(0xb285d654eb8a088d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5c8496d9eae76db6), UINT64_C(0xf96c3509ab19dadc), UINT64_C(0x74c6b21d62b45066), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xefd1666027cf8e04), UINT64_C(0x37e73040e3177560), UINT64_C(0x970e89dec93a5269), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5077e7c6155733d9), UINT64_C(0x20983a18f4c99eee), UINT64_C(0x1d0b8513835c8cfd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2dde6e28fad8f871), UINT64_C(0xf99965cb65fe11b9), UINT64_C(0x701fded4779a6845), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1fddae03882f8bdd), UINT64_C(0xd73e42fdcafa1a23), UINT64_C(0x1c821bec25be8916), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8d1e7f043871624a), UINT64_C(0x61ecd9dc0ae7471a), UINT64_C(0xcd21042395bb80ba), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x32d08e4f15f6409e), UINT64_C(0x59801e64f5f1aec3), UINT64_C(0x868eb077a7970c10), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x65525eb57cb825ce), UINT64_C(0xb36552862ce22b3f), UINT64_C(0x73583f7b81395d63), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7b617d24b53ffc4c), UINT64_C(0x4d65349b59af82cf), UINT64_C(0x67e9be0c9dca0a1a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x178df628f5185e5a), UINT64_C(0xc52591a5324ef5a1), UINT64_C(0xf3a84624a631c4e2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7015c81929935eb0), UINT64_C(0xe78541e1b046a8ca), UINT64_C(0x38b5b4a3f5154f4b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x157babe947861eac), UINT64_C(0xe3b9edbae5f974ea), UINT64_C(0xba91ea0d719b7ed3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdde5505eb025c9ef), UINT64_C(0x4eb1079b7a0cf1ba), UINT64_C(0xe220c107997fe072), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x030ed1abd878e3c7), UINT64_C(0x4c7a512b82092e88), UINT64_C(0xf10845c114ba87b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x658aaa7b5b0e4573), UINT64_C(0xabcd88ccea39149e), UINT64_C(0x2aa914531041f5a7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4ee45aedfa082eb2), UINT64_C(0x4e9902c5cc85e1dc), UINT64_C(0xd36209c7dad8b504), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71c820f1ae94b049), UINT64_C(0xae949be58564f84f), UINT64_C(0xfce790a132e373bd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfd7d534da58bce3c), UINT64_C(0x3365fbc729390fdb), UINT64_C(0x0441f78b602db422), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xecf35019299deccc), UINT64_C(0xbdab81b43f3a8969), UINT64_C(0x5df1d8a5b2946789), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8c2a297d76413da1), UINT64_C(0xb9f1afd4093a045f), UINT64_C(0xae41d604db70fa18), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5124141913ebd7f6), UINT64_C(0x3fd9756835710eee), UINT64_C(0x6d28c970589334a1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf1acb558713d5907), UINT64_C(0x169b31bc82c80849), UINT64_C(0xb055fcd8741e24c7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x32bb336348918f17), UINT64_C(0x493b6c641ced3bc8), UINT64_C(0x662c76c2db84cd4f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8e37cf6face36a18), UINT64_C(0x2902029b1f6bc4f7), UINT64_C(0x5f7ce1af10bf9e41), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb7e22f96596d02c6), UINT64_C(0x4e996247af92d178), UINT64_C(0xd00c3cae2b0c2e80), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x358cd6da408626ed), UINT64_C(0x4026e01655cf2d85), UINT64_C(0xb889bd2adc307f37), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5424d6885f856065), UINT64_C(0x593c532cb0af1851), UINT64_C(0x07248527ddeefafa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd3dab3072ecf4b5f), UINT64_C(0x9bc3c04558f971b2), UINT64_C(0x69ba4c74720702ff), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3afa3ee62d9ccb8e), UINT64_C(0xdcaae7808efe49d9), UINT64_C(0x788e84d45e8fab22), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb8d7d865be39ea42), UINT64_C(0x5edce83dc144f2a0), UINT64_C(0xec48eb4db53bee44), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf635a8c135f0ebe2), UINT64_C(0x71b433a5d584cfd0), UINT64_C(0x7add83a6d4c98693), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x35ba6d517c745407), UINT64_C(0xc98552f908e487f5), UINT64_C(0x88e7ecc26c7423e2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc59cd2484c80b119), UINT64_C(0xb4732a3ffed57ea0), UINT64_C(0x8673937f1cec1caa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x97a94ab0c356d04f), UINT64_C(0x181c7c6e33093a31), UINT64_C(0x0aad7507e23b8a70), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc4499d7411337bbf), UINT64_C(0x0cc297eaf653f48d), UINT64_C(0x75acda8b28743757), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x73f9d2f2b702a7ea), UINT64_C(0x87628809641a29a7), UINT64_C(0x15feb037573f4776), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x228f474f4b33e21b), UINT64_C(0x09cc95e4a92a5a52), UINT64_C(0xb4091606c4b8322d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd9bd62fa9f998e2), UINT64_C(0x4c06b127534310a3), UINT64_C(0x31df04d706ed22d6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x12c31f59e8fd82d2), UINT64_C(0xb66c88eea39f5269), UINT64_C(0xf0117ffaeb5cff41), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x765f4c669bd1a366), UINT64_C(0xa03c3a1e7138a2bf), UINT64_C(0x74d8b253c0530705), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9a0d88863dc0b529), UINT64_C(0x2b61484ae6bf79e2), UINT64_C(0xc3ab2fff63f0e5e7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1af9c6146794765c), UINT64_C(0x22254aed26963ac5), UINT64_C(0x444e3a4d885668e7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x214b1d6a859eaac6), UINT64_C(0xba93edc0e80dd249), UINT64_C(0xfe6079d76dc86bb1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdb882f1dadd2bb1e), UINT64_C(0xbde1d08c79893b7d), UINT64_C(0xcb831e7d8c5ea825), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x36a27e2acb8ad2ce), UINT64_C(0x113cb0ee99f15225), UINT64_C(0xea8d9a965dc535a3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x88aeb804a1b92ce6), UINT64_C(0xfcd2b8bd98010a47), UINT64_C(0x2d1d3969168c304c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x57b3bccb4a98f3d4), UINT64_C(0x4677a92dc517c3ab), UINT64_C(0xc593957e3958a98f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf2820effa8e1133e), UINT64_C(0xb5a137f3faa7b54b), UINT64_C(0xf81ca4e49a9691cc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf8d1f86983b83a21), UINT64_C(0xcec42f6d65484c04), UINT64_C(0xef8155f7c71f7061), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf728160b559b8fbc), UINT64_C(0x352cb996c0484050), UINT64_C(0xba5a609d5faf4585), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e2d301cea6074ae), UINT64_C(0x1b992547b893a2a7), UINT64_C(0xf7a9065c72f7ddff), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x14e4abf72006897b), UINT64_C(0xb85ef399658429d9), UINT64_C(0xc21c7772375c2f39), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd11c1d7b20403ff3), UINT64_C(0x2c77a6fe746dfe1f), UINT64_C(0xe0f9929d48dbea51), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb52194a68c590dd1), UINT64_C(0x7307348a73261b73), UINT64_C(0x094a5d5874623799), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xefd70cc044edd297), UINT64_C(0xffb4b2ed9b3a1756), UINT64_C(0xca08a0fc4ff89ced), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3443de65ee1e0404), UINT64_C(0x0024b110cf78f357), UINT64_C(0x4cd36a0b216d681b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7dcb83c40a9baba7), UINT64_C(0x77fe7dfef4170bf7), UINT64_C(0x39ca6a1b9f8e1c82), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdfe33a453e1cfa3f), UINT64_C(0x805425c3fcb863a4), UINT64_C(0xe17c37bdfe0c9a65), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa6af14b5d375e93c), UINT64_C(0x63455f60e4f139d7), UINT64_C(0x83d9120056ae89ca), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa3830c323cb71b18), UINT64_C(0x4bf4513260047d59), UINT64_C(0x5d17a6aab20df368), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2b06bd1e01ec4942), UINT64_C(0xa4b9054bf7c07531), UINT64_C(0x588d7847b90085c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x253bf0f129a8a373), UINT64_C(0x94807b52feabfa62), UINT64_C(0x83b67798cbf131ed), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f65e9b72ea1b883), UINT64_C(0x3a6d198912ec77d4), UINT64_C(0xcacd510ec8562520), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcfca6f0ad6404cc7), UINT64_C(0xe4093b960bfa4c48), UINT64_C(0x48d67c6d28c41422), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x78ff63fd537f14ad), UINT64_C(0xf110dae378e682a0), UINT64_C(0xdb9b164d7d5c0471), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x14feedf8e06a0884), UINT64_C(0xe36b7c7c70547255), UINT64_C(0xbae662ce2bfa8480), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc627019cc5a3f6ec), UINT64_C(0x19100fad879d3108), UINT64_C(0xc89f4d20fadfb50f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7ab1b0809b6b698f), UINT64_C(0x323dcb5884c7bfcd), UINT64_C(0xd92f59e84856246c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x062e52aceb983046), UINT64_C(0x0e0e1ecf24438f05), UINT64_C(0x9636b9520d5e3983), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa8079df8e9a7091b), UINT64_C(0xee066870bc8fbf7b), UINT64_C(0x8799397d223d7bea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7a5e3f605b4f016a), UINT64_C(0x6185e8e0d563e7b9), UINT64_C(0xa93ef12775deb2c7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x828d15da1443ac78), UINT64_C(0x1cab74d803c7b190), UINT64_C(0x0a04a5afa9c4232a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4fb4150a3d6a7d8b), UINT64_C(0x4a5ef30ccbbf7db7), UINT64_C(0xf7f56a44d9785cad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfc8b8d8cff5752dc), UINT64_C(0x94679b2b4d49a26f), UINT64_C(0x12911ee8ef21b071), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5275ccff410de663), UINT64_C(0xe21e840f7c5112b8), UINT64_C(0xd18ad63851593ac4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x746d4b882a66d343), UINT64_C(0x11bf23b99228deac), UINT64_C(0x31b1d5c03242d79c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5a6739ee98e3fe63), UINT64_C(0x7c7ddd41a8645eac), UINT64_C(0x58b4cda00cb15cc8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb7acb6f399f14814), UINT64_C(0xdfa91f1ed03a9185), UINT64_C(0x18ba391c0fa7676b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x36ee9771824c10e6), UINT64_C(0x90ab433de0060601), UINT64_C(0x9871f4dd457b7519), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5905665761be6551), UINT64_C(0xe625b876c6a88e27), UINT64_C(0x62578e00ab9a9dc1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc6734a4e1f3cc5c0), UINT64_C(0x28ba69f8bb0149df), UINT64_C(0x0994d3073145736b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xec72f75b577cec65), UINT64_C(0xc7e5445dde5f179a), UINT64_C(0x6382e7e9b82c254f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd7b73fd8e6fe695), UINT64_C(0x3da7d65f0c352683), UINT64_C(0x903698a8858ded6a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe15032c228ef4d8c), UINT64_C(0x6da1bf9e18b935ec), UINT64_C(0x90d48490bdc14f23), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x29a76f5a339e6e99), UINT64_C(0xca3ad0ddbd1a3a5c), UINT64_C(0x4a8c81e77738e39a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcd9ba33062340ffd), UINT64_C(0xeec3e087b248a6dc), UINT64_C(0x9b3d173cf2ff5c1c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x13839204b372d7d2), UINT64_C(0xb9a3e33a7b372c2a), UINT64_C(0x6a86aa3a2ae0d08f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xacb880f64529b7ff), UINT64_C(0x63d7ab4e908521ab), UINT64_C(0x76d3e016557320f1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1096c25ad532fe96), UINT64_C(0xb13b343ea3bf6c05), UINT64_C(0x031536e767959482), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e253ff2c8295335), UINT64_C(0x652c559ca8edde3a), UINT64_C(0x3ce739ebfbe2e8ee), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa100c6ef7ae36952), UINT64_C(0x57b47af1a651f220), UINT64_C(0x3a7310eea54ea581), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x211e555cc3e5b02f), UINT64_C(0xa983d436bd3ac949), UINT64_C(0xc5136e1d9465c70d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x96dd171742543186), UINT64_C(0x7b33dfdffe56cd22), UINT64_C(0x01f85ca0b7248d35), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb651942b1583e66a), UINT64_C(0x60ac6dcc4fe15780), UINT64_C(0xb81fd86964610436), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x67ee2ab239734b8f), UINT64_C(0xa3c0c8322a858137), UINT64_C(0x87225195ac45386e), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_0[] = {
  {{ UINT64_C(0x3b489f24975d544d), UINT64_C(0xebbdc5794da5eb5d), UINT64_C(0x4a923c2934d13f91), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5da20f9bf92eb669), UINT64_C(0x577d844af3e7f0f0), UINT64_C(0x99df2e44411ccc1f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x145055eeaeecba99), UINT64_C(0x851bc4b62d6640fb), UINT64_C(0xf1ca0467764171e5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4127d64130133454), UINT64_C(0x87898d2afc7c8cbc), UINT64_C(0x0a1380f3e1bda9b3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7addac4fe5f8ae55), UINT64_C(0x9b09dd1af9d2bf0c), UINT64_C(0xb1eb29928828d49b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3fd1599af63e5a7b), UINT64_C(0x93cf2aa0d63c4506), UINT64_C(0x459fff15be041f3a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x66e826d47932c4f2), UINT64_C(0x5c833de847ed181d), UINT64_C(0xc04347e3dcfc05d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb86bccd46e6749c7), UINT64_C(0x08ed7f8f609972f5), UINT64_C(0xf72395b51ec74903), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb0782cac166c9000), UINT64_C(0x2f251c9563e584f3), UINT64_C(0x5069dc36307831a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1826cd3d068c419d), UINT64_C(0xe2c01b9291702589), UINT64_C(0x5020fec16839f5e8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe2607bbe5c64481c), UINT64_C(0xe271d2dd9a73c0e9), UINT64_C(0xbdf909fdbb31e424), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1fc6f9775f13ff0b), UINT64_C(0x5e56e2d561f8e778), UINT64_C(0x2615a30ccb7b0ef2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x964f765dba2280ca), UINT64_C(0xcf72d29fa3285e0a), UINT64_C(0xc80a7a9977fed01b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd4b2e780b88ad36c), UINT64_C(0xceb0ea948a9a2b4a), UINT64_C(0x06e615ee7e7dab12), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x88dc2524167d58ce), UINT64_C(0x9b794ac2688e70fe), UINT64_C(0xef487f42737be5d9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x92078b88e7f3a730), UINT64_C(0x3d98bf8dbdbb65aa), UINT64_C(0x94bbc894835571c7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd7d76a31c4afb436), UINT64_C(0x63e903b4f284ed9f), UINT64_C(0x2e84241d01de39a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x714e7f2d347d077b), UINT64_C(0x3fd4d34466922a62), UINT64_C(0xfd57fd3d73ba46f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1979e25aef2b33e7), UINT64_C(0x267fa6d6d96932b7), UINT64_C(0xec881afccb733f14), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf8e7f4918c3f0b49), UINT64_C(0x5879b5fa2c795943), UINT64_C(0x33299771a1716612), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe1d930834fb54f66), UINT64_C(0xc45dfd0c248e2cf0), UINT64_C(0xf0381bdb2be15af0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa54168a4d3d3fa3c), UINT64_C(0x3a85549abd0ce508), UINT64_C(0xb713e0866c60fab6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xec2a39c35ea0435a), UINT64_C(0xfda469d5f765986d), UINT64_C(0xb978c16792eb522a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc2340626d40d5e51), UINT64_C(0x43f1c27fa7236516), UINT64_C(0x0795fa5b18297457), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf309c78b75ac1cda), UINT64_C(0x4541a58e95829700), UINT64_C(0x31b054401264f2bd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa4a66242d4635334), UINT64_C(0xec10dc0ed564f5b4), UINT64_C(0x34552e9cfc091f6b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa1914d7516ff1cc1), UINT64_C(0x9d9b6a2949329d44), UINT64_C(0x3c011c1d53646d30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd74a8ef0bd1eae07), UINT64_C(0xd59f80f2d4c5a143), UINT64_C(0xc0824499d2527f25), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x12ce9e36942f63e2), UINT64_C(0x0e8f8479455eaf8a), UINT64_C(0x4a6e61cfca35fb30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0e51a71a336076ca), UINT64_C(0xf15ab41f811f0a26), UINT64_C(0x46cd26e0d032b016), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_1[] = {
  {{ UINT64_C(0x3aa02fe84beecb3a), UINT64_C(0xac36e8bf83f848d9), UINT64_C(0x9c66fe22113ac881), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0f8ce63cf2f16f47), UINT64_C(0xc22aca2f34dec6d0), UINT64_C(0xe00c964b13bd4e3a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe7b53230e5430791), UINT64_C(0x898afa983c4ceba6), UINT64_C(0x00fe2c183f2c7519), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x66c2d342b9e9e826), UINT64_C(0x0143dbb0e30c7363), UINT64_C(0x47656c1bd315716c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3bd7c7043be7592b), UINT64_C(0xc4c415882ecb4e72), UINT64_C(0x5c2ab33071f1cace), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc8568b1614981c37), UINT64_C(0x64d9458383216ce5), UINT64_C(0x8f1f225e69aa58ca), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x574c9531d0eeaea9), UINT64_C(0x5c0d25226644c625), UINT64_C(0x1abce1c7384f373b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e18835f35655bf1), UINT64_C(0xec0373c7b7914675), UINT64_C(0x88ef6dca072e4d3a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd3eca839c5c94698), UINT64_C(0x70a65b1f3786f93d), UINT64_C(0xcccc440a7281af2b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7225c4cef2259c75), UINT64_C(0x3816fcad3e2f7621), UINT64_C(0x4f2d70f25f0f1511), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa7f3c36516943b8b), UINT64_C(0x468b15d610d101a9), UINT64_C(0xf12f78e45b0a9611), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xefa578378edcc68c), UINT64_C(0xfb2e8127845d1e7d), UINT64_C(0xf2d51506eac4c37d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf66be436dc19c475), UINT64_C(0xf0bce5e43c8f39f4), UINT64_C(0xca39e41f7ce6f966), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb522d6087654355e), UINT64_C(0xdd040737c622bdbb), UINT64_C(0x70832434c8ecef47), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf3cf599eed34cf1f), UINT64_C(0x2c34e52e02105ffa), UINT64_C(0xd91a3dd01b60e1e3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeae5c0dd716e3904), UINT64_C(0xfc98ce9c455596cd), UINT64_C(0x6d2859c455bda4c5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x828d2edec9e630c4), UINT64_C(0xc44c26694730de14), UINT64_C(0x12265069ce672f00), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa37fa2baba7e8065), UINT64_C(0xf2b1e6a0ac8186d2), UINT64_C(0x527929c9c7e4bfe5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd1081c4208803f54), UINT64_C(0x8fd01227a2e2d4e3), UINT64_C(0x96648fd9807f711d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc875601557052088), UINT64_C(0xdcdd002dcfe117c3), UINT64_C(0xf90c21720f7111b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x83ad22095bb6722d), UINT64_C(0x4b9cfd17a0c44c6e), UINT64_C(0xe03baaa53a5ef8c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2de0c7bcbc091ddb), UINT64_C(0x71753eb28d8056b9), UINT64_C(0xe68d4fa98e141711), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9cf8c47dc5ff9044), UINT64_C(0x582069bf7fea3ede), UINT64_C(0xb7cc3b60e0e4e7db), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb091fabfef623879), UINT64_C(0xba448207482bfcb6), UINT64_C(0xf732d3869ac297a9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xacaa4ecb232d6930), UINT64_C(0x1b022222c2d86552), UINT64_C(0x8abca8b33fcdfa93), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x04dd0ec7d1553185), UINT64_C(0x7f3ade26bcbd4e8a), UINT64_C(0x76d827dcb3477018), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6b1b5b74cc7c4a84), UINT64_C(0xad1317431d67e53d), UINT64_C(0x91b11fc914e2bb9d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x516bbc2a0644b1b1), UINT64_C(0xfdbaba377ce6e381), UINT64_C(0xeb5e727f76f169d2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe9da9ea294ee5bb2), UINT64_C(0xf1f7979121393988), UINT64_C(0x144edf3330025851), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd433fd740776f1c7), UINT64_C(0x7a06e7155f232b8c), UINT64_C(0xca86c6e4207be323), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_2[] = {
  {{ UINT64_C(0xd81d5ad9cec0f46d), UINT64_C(0x1c779a2a13043524), UINT64_C(0xe3124da77c5f0c3f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe3e2deec31ea7b44), UINT64_C(0xbaafe30d760df864), UINT64_C(0x581e3962db73d340), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x73e0765249330457), UINT64_C(0xead6561ffc9bdfdf), UINT64_C(0x1915dd276a669e69), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1095e8b436a78412), UINT64_C(0x3d62d18a44839285), UINT64_C(0x7abcc4affc963d6d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb822013fb8a9a131), UINT64_C(0xd69334c43ea52e3c), UINT64_C(0xc89c296839354e46), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb6c6d3b625d6976c), UINT64_C(0xb45a4d4c87b1fc5b), UINT64_C(0xdf680c9fe0b3e869), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x240e7e68a22ca8df), UINT64_C(0x14714066190de9dc), UINT64_C(0xf512f5f562a94d10), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3c21cfd2d5aed9ad), UINT64_C(0x1d97a807715ad84f), UINT64_C(0x22cc1ad18f70eac8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7cf29e3859c766c5), UINT64_C(0x7a9a9e906992d5ef), UINT64_C(0xb0bd3ff52a999ba8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x112c1b09b45ccf41), UINT64_C(0x608a5811c964378b), UINT64_C(0xa167b5be0a26e0d2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2d3b05af31764db1), UINT64_C(0xc4de271bc7f1d807), UINT64_C(0x95aae9e730632ca7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdc8e5ee8999cba77), UINT64_C(0xb84754b792cbf50b), UINT64_C(0xfd470fc0ef4f90d4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3681c1902195535a), UINT64_C(0x6fab454d389db8da), UINT64_C(0xe9adda12cb039c26), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4ff75d64ebe64733), UINT64_C(0x6f91a79cb8be1f25), UINT64_C(0xd766fa95040c57ca), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f87d0cdbcd57633), UINT64_C(0x768757f7561157cb), UINT64_C(0xcdb3d220c517dcb5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x50cf7fc60e33d1d5), UINT64_C(0x984c57260185aadf), UINT64_C(0xe4e5468c6e0f076b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x361843db9c5bbf15), UINT64_C(0xd89dcd1745e8de2f), UINT64_C(0x57f198af45eaf53d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9084b498d48dd615), UINT64_C(0xc8708f6317a981f1), UINT64_C(0xda5f5e580ac24ae9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5bce76a6b8203190), UINT64_C(0xf46ce002570e8a0b), UINT64_C(0x4e1448cf8fbb2202), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa72e5b13215697a6), UINT64_C(0xe535a88fa0310822), UINT64_C(0x4663376f6bda5685), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x021cea92247693f2), UINT64_C(0x8bcf08fa9c762170), UINT64_C(0xdb123a3302fccdc7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x881ad1557462c124), UINT64_C(0x576630b45a2e05bd), UINT64_C(0x00cb243f4fa42cac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc94872b9b3a6d541), UINT64_C(0x5064dbc78c52f893), UINT64_C(0x3ecc18cf55487d4c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e2bdcf838cbcb14), UINT64_C(0xe952c891ac5a9b15), UINT64_C(0x9d12b3f2518a56b2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x09e039754f0a13ae), UINT64_C(0xa9d854f25c6409ed), UINT64_C(0xd4e0353e97bede90), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x87e9fb4bfd6189f5), UINT64_C(0x5d24a8a3d8d965eb), UINT64_C(0xdc274ea12bba73ff), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5e1c695e146bc5f8), UINT64_C(0x900e8414e233fa82), UINT64_C(0x93265aa16625a86b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf010f3760dd26249), UINT64_C(0x8ba9d1744cd371fa), UINT64_C(0x763e33f716c4207d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3cffe0b34e18aa15), UINT64_C(0xf4df0d9cf267e597), UINT64_C(0x46635ccb4ddb9890), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x23ca4e0d9a07aae0), UINT64_C(0x0aad27a13457dcca), UINT64_C(0xcd5079505fe41dd1), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_3[] = {
  {{ UINT64_C(0x857226577d6e53f5), UINT64_C(0x0bf5471ab086efc3), UINT64_C(0x2cedc9caa98055b3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5bdc2d6fcf737068), UINT64_C(0x1bdaf96b4486f83e), UINT64_C(0xf245ec7ef64efa2a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x82ae5e31c5a6743f), UINT64_C(0x64db9d042ef73c36), UINT64_C(0x3b101602eb6f56e7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb92681bc54d96d6e), UINT64_C(0x1b3ace3b9cd44d99), UINT64_C(0x81f2b0e5627d677b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x17d8d153388119ce), UINT64_C(0xbd6ba8a36b6011e0), UINT64_C(0x37e98129a645825c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf929ddc7acfbfe7e), UINT64_C(0x326d3dd09ca19fc2), UINT64_C(0x3febdf4f1ee8208a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2e8ec9a012d7042b), UINT64_C(0x34ef85653a065840), UINT64_C(0x9d3b104c38e68c94), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd84d0e2d4c5e3415), UINT64_C(0x6b8f05afc6095e32), UINT64_C(0x173b08042fadedeb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc09d03f2bbaca588), UINT64_C(0x007e3071d62ef83e), UINT64_C(0x44e9fbd73327d8ed), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1722abd2a9e659ed), UINT64_C(0x66fea9aa5a93fcee), UINT64_C(0xe34ec1f5257930ce), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf6a642a9d2f1a469), UINT64_C(0x8dcaf47a3278497a), UINT64_C(0x4615ccfc3f86b191), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x84edae53b6547662), UINT64_C(0x17d4a01d0b66beb3), UINT64_C(0x88bc5cee918ea1f9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x762fb5a60efb3883), UINT64_C(0x4ad499ade1b7798a), UINT64_C(0x57d2cd0778496552), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4974c7d13eee378f), UINT64_C(0x64edd23cab9154c6), UINT64_C(0x3771a7610ecbf2e6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc52ca939ad5c0704), UINT64_C(0x96ed5edac02bbe5d), UINT64_C(0x457c4ad72bd4d8a2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0783745b9110db1c), UINT64_C(0x2fb40861392c9409), UINT64_C(0x756d692cd49f7577), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3b711e3a7291a62d), UINT64_C(0x2bbe931fd1e8b875), UINT64_C(0xc954384a541935a8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9810dbd1f390cc37), UINT64_C(0x430e2f749231ffe3), UINT64_C(0x1738ea99c65d8bf9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5197667bfc6ecb93), UINT64_C(0xa4dc3e1960f9fb82), UINT64_C(0x4ef933dbd1dd50e6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9272229195a8865d), UINT64_C(0x487b00e158a5fcf9), UINT64_C(0xd03a7b1a50d1014e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9caff3df35fa5d5c), UINT64_C(0x576fe5502210e328), UINT64_C(0x1f5fe1c1331dd75d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71e289a943a63c58), UINT64_C(0xc0ba81115067774e), UINT64_C(0x4ba41fa8c0838c38), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x049fe5a59f840010), UINT64_C(0x331829b36ea8c2a6), UINT64_C(0x001de69d71744e34), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x145101c4c45ead21), UINT64_C(0xac1643be2525bd19), UINT64_C(0xec923622cc7a6deb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9c8b76943a1b2b93), UINT64_C(0x9121975a22e96098), UINT64_C(0xd3bb1d8e2e03918e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3acd150cbea3697f), UINT64_C(0x39f095e2d4023bc2), UINT64_C(0x30aa8c4285cb69d7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x82a18110c1379d9b), UINT64_C(0x3cb56bd762f17e4b), UINT64_C(0x34ade5574195e48d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfc4855ab5571a7dd), UINT64_C(0xe0128df98c52df79), UINT64_C(0xc7d1a2b7ba634934), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe15a0ee7596567bf), UINT64_C(0xd718c9533fa9aa54), UINT64_C(0xf67f825a616d9a5c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeac5ff102f954273), UINT64_C(0x70e94ea90e3bd315), UINT64_C(0xf81a4397a33c5ffe), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_4[] = {
  {{ UINT64_C(0x7e0e433991e7e8a7), UINT64_C(0x435525b2025d88f5), UINT64_C(0xcac3691fa14c5a11), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdd5d52d1ffe72b22), UINT64_C(0x646f3e3bfee8505e), UINT64_C(0x7a5dd3849049d077), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x485a7686fd2010f5), UINT64_C(0xd4b76d9ccc322940), UINT64_C(0x15dcfbf335dd9433), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3481daa684e5a358), UINT64_C(0x7407618016bb95ce), UINT64_C(0x835a2cce561a841f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd6a4e9f5d9184eff), UINT64_C(0x687f1f2187e6aca9), UINT64_C(0xe8a04f0db4ee89e3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x02f57b344965b183), UINT64_C(0xfcb2ba2ebcddccf5), UINT64_C(0x3fc62ff46f2bbbcf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbc0751831469aa6c), UINT64_C(0x33adabacfdb42339), UINT64_C(0x8ffab7f02245893e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x343a8d7a2557288f), UINT64_C(0xfe497b9448956928), UINT64_C(0xc56988acdb41b336), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeee7bc03dda5f900), UINT64_C(0x31e19f61cf6fbe37), UINT64_C(0x7d986942366e607d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1d05c16854f409ed), UINT64_C(0x30ce4cd7181f42e9), UINT64_C(0xc0408cf6e853909f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x45b0c3cd8f5d1593), UINT64_C(0x980a6daa2adbc30c), UINT64_C(0xfe9beb51016f1de2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa9ae9e319c334dab), UINT64_C(0x69d5f8bdfde707be), UINT64_C(0x066a6e44956f6e97), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa89d988a1f7dd918), UINT64_C(0xf980557901ed3047), UINT64_C(0x3813effb90e8bb3d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5eed663dad6adbe2), UINT64_C(0xeddc1dbc1a892cd8), UINT64_C(0xab1a135164205bd6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3017135147c1c5af), UINT64_C(0x4d71160820200b3d), UINT64_C(0xfe84a03fb2eb4da8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf08837e738a5ac1d), UINT64_C(0xb8f90fabd2e3507b), UINT64_C(0x09619711c5440fc0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfc0db5f53df85b69), UINT64_C(0xe641087f80974166), UINT64_C(0xb749100db8872b58), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x154f2d37eb0a1d21), UINT64_C(0xf202edcb23829c46), UINT64_C(0x67b6e6b3a0b42c65), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4cc5a5752141f387), UINT64_C(0x6ab3533ae82cf3bc), UINT64_C(0xbcddd87e73e97f01), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeef3f2a1e8ef712a), UINT64_C(0xc8d7fc68c97a0a0b), UINT64_C(0xca431f6997fb6160), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3c9f6c5aa291f244), UINT64_C(0x17011e11fe754f9e), UINT64_C(0x7ac5c4336035a9c2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd08ac617cf96ad0a), UINT64_C(0xfa8a7b22c2e48436), UINT64_C(0xd9a784d29ba154d5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe945dfe77db13eb3), UINT64_C(0x2d9bed4f505287fc), UINT64_C(0xe7ba0a70ab0f999c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6603ffa2ff229815), UINT64_C(0x5b2850276f0163cd), UINT64_C(0x4bd59695e55bfc2d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc3db5892ac5b0841), UINT64_C(0x5688746b7ec37b1d), UINT64_C(0xf60572a4de8fd04d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x38d75fd43303234e), UINT64_C(0x1adc2778cd506623), UINT64_C(0x271b32282a4a9b67), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x14c6673e1160cf6e), UINT64_C(0x3b03d3ac1b4be99f), UINT64_C(0x84f88256eb872847), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xee335ba0d3281ef6), UINT64_C(0xab6857969f7c12c4), UINT64_C(0xdaadcc531e1c1d12), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1ef7213d6592c50f), UINT64_C(0x04f7cd72e87157c6), UINT64_C(0xd5b1063b09d99f2e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x39fda9bf14cb3934), UINT64_C(0x46fd118091d77398), UINT64_C(0xa6d1604bd3a86a96), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_5[] = {
  {{ UINT64_C(0x1d14904b0dc6c66a), UINT64_C(0x6e88e6508778d59f), UINT64_C(0x7bbab46db93b7a14), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9d31edd19898f0c5), UINT64_C(0x2f60b16d8b62eab7), UINT64_C(0x47785faf0c698a70), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6a378d38bf97af81), UINT64_C(0xfaa7ae6dfaf5ea83), UINT64_C(0x3d4c246a02840f28), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd5621de629f73a2b), UINT64_C(0x28c532039ac29926), UINT64_C(0x803dc6747a2bbe0c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb7645afed818e9cf), UINT64_C(0xe32a0f1fc3be8e05), UINT64_C(0xdd61b5cf08d98450), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xef66f55b1358ade4), UINT64_C(0xe8183a8e119d4c06), UINT64_C(0x073f44650f4bf5bc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x18d7e9099470f484), UINT64_C(0xb3d532b49c9ba075), UINT64_C(0x79a7f1691073f3e8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdf7167866a48e259), UINT64_C(0x85adf7982a9eb072), UINT64_C(0x77b5c42a0a902517), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0e07209e03b15548), UINT64_C(0x3ac099adf55b4a33), UINT64_C(0xbb3ea60e2b216efb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x19c2ca0f06a628cb), UINT64_C(0x5f3cd224c52747e4), UINT64_C(0x5bbb325643794457), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2a1feb2b027204bf), UINT64_C(0xf240f4e0f4a591e1), UINT64_C(0x43ec18210d01dab0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2e13bb1573fe24d2), UINT64_C(0xd21c69702fdcb731), UINT64_C(0x56959145ebcdcff0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd1daeedc7cde8f4a), UINT64_C(0x503555fddd81359f), UINT64_C(0x151db8f4d1b2216b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x919bf6d488432dae), UINT64_C(0xd91f092bb4c1d3ae), UINT64_C(0x8b710ddc9f927d6c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1810dcf3aa6e00e8), UINT64_C(0xcd47bf3b30d27e9f), UINT64_C(0xb1f5cf8d393852e0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0576859011b19658), UINT64_C(0x53a698ffece942e9), UINT64_C(0x3d3341316a77e90f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x372553e4dad5b48e), UINT64_C(0xf32639a193cf67b6), UINT64_C(0x1e5c310cebe71db1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe4f262ef318c0faa), UINT64_C(0x7649e11a1f1e0da7), UINT64_C(0xe1f95824a78d0b3e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xce33660d48e6cdf6), UINT64_C(0xf07f5ecf5b6485a3), UINT64_C(0x53cda87673fe25ca), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8de2323db0e8bdf6), UINT64_C(0x19c891ea1ca69852), UINT64_C(0x580dc5915cbe23ed), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb51fe11a91a4d6aa), UINT64_C(0x0c628353b185c8c2), UINT64_C(0x70118293f466ec02), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6c051e861ba273f0), UINT64_C(0xcc783cd8f4ad46a6), UINT64_C(0xc5868ff5c52648ff), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa6da2b6bb97adbb5), UINT64_C(0xd02c9655b4d9e6f9), UINT64_C(0xb843e4a34e4fffc1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xedaa19b041af99e6), UINT64_C(0x10d44365f3ff66dd), UINT64_C(0x75098faedb56ec7e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x20d50d1968c96752), UINT64_C(0xc01640366e346a01), UINT64_C(0x457603bddad0c0bd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x634025899b3c3fcd), UINT64_C(0xe27a0ee2c43752eb), UINT64_C(0x00870d61a2d60772), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0dbc5fd4f9cf029c), UINT64_C(0x1f979803bf8f6a0d), UINT64_C(0x180edc51e0432f4f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x88e9a3332076ece3), UINT64_C(0xc056124dcfc89b31), UINT64_C(0xcf302b2b84dbc968), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x52197a052ce30eeb), UINT64_C(0x7f174fb8540bfc64), UINT64_C(0xb58a9c8f352dba14), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcc5a9b9f4ac3b23c), UINT64_C(0x697d1d098c6cf342), UINT64_C(0x72a51c3c2cbfc2ab), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_6[] = {
  {{ UINT64_C(0xc8b4ed90a3e83bcb), UINT64_C(0xb9d99960ed4ce703), UINT64_C(0x1372123ff4ae58b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc0688046e2588e66), UINT64_C(0x5fa3e49a826aa6de), UINT64_C(0x6dc8da8cdbdff3c1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x88fc53accca6ba58), UINT64_C(0xf9c0c64f3846360a), UINT64_C(0x5cb6b6a1d642b792), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf67c319671db5ecb), UINT64_C(0x185599862dc387d9), UINT64_C(0x54cf72560e726efa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x076692eb6d6b82b7), UINT64_C(0x60452c580c2515bf), UINT64_C(0x5c979dbc8030f328), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaef00488e61d800f), UINT64_C(0x01c334f022f9c4bd), UINT64_C(0x9a318beef6f84b5e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2b25a52e2f404505), UINT64_C(0xe9108a893e4e65bb), UINT64_C(0x475fd66063044085), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x20af8009abea64c8), UINT64_C(0x27821e53dd9f740b), UINT64_C(0x4abcd4c5c9d43b21), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6bef286b781ab3ff), UINT64_C(0x1e7251c4712c9f8a), UINT64_C(0x54b66977b210fd46), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfd418fb5a69162b2), UINT64_C(0xa3305b0bc4d2fa1c), UINT64_C(0x0cad940d71d2974b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0fa85482eaad76fc), UINT64_C(0x358704b9231a5ba6), UINT64_C(0xe29420628966ea5b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfcb2e4beb909c8a2), UINT64_C(0xfcbc3bd5074028f0), UINT64_C(0xb5b73e4f53490065), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x323dc052af66420e), UINT64_C(0xf1dd1db79e4f3ca7), UINT64_C(0xee27ec7c47f3040d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0c30e9036ca28489), UINT64_C(0xdb9ac18ea7a975a1), UINT64_C(0xf06749cb0650a3e4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa68544a755b1983a), UINT64_C(0xb730ecbe62fc5959), UINT64_C(0x11f393535e5ad317), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa36735a45bc9fde2), UINT64_C(0xb0f934a4f17d7060), UINT64_C(0x788678ea1821053d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc7d4f3af18972297), UINT64_C(0x0bb505109405c3dc), UINT64_C(0x2678a63a73021002), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfc821f96b2de3761), UINT64_C(0xac08a5675dd463a8), UINT64_C(0x1c2933d4e571cdc5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xec7ceaddf62aaab4), UINT64_C(0xba53eadad66ecc7e), UINT64_C(0xa371f5db02706e98), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd7629674761dbde5), UINT64_C(0x8c024c4d2d59019c), UINT64_C(0x2ada2f084627e3c2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4904243e09ad2cd2), UINT64_C(0x0d2c843c2398db15), UINT64_C(0x99f13e1ffb8b51c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xedbf96e40a6d8746), UINT64_C(0x7b54ef180c66fa7b), UINT64_C(0x02d5b9770dc33131), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc9f4ba166c32bebb), UINT64_C(0x722ca6b5e7c93f93), UINT64_C(0x903864be11c61024), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfa21f337ba974c47), UINT64_C(0xc06b6e167f78d833), UINT64_C(0x008c852f69d36772), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb69844117f28500), UINT64_C(0xc568799187d6137f), UINT64_C(0xfd72831e62d5ed99), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7d455e923d5e2bcd), UINT64_C(0x7f9d48ffa0342170), UINT64_C(0xbc926ff381a055c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8beeb64501bf0ac6), UINT64_C(0x15113907d9fa7447), UINT64_C(0x43e690e7c3f87b0f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbaacedb50b810e82), UINT64_C(0x5e910277268d47cb), UINT64_C(0xe52b290d0b96eaa7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9582b7f5fbc674eb), UINT64_C(0x8ddd23e305d36372), UINT64_C(0xfc9e64edd8373d7c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc4c267ca1463c4ae), UINT64_C(0x85ab74d76af5254c), UINT64_C(0x59040f95ca9d9ef2), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_7[] = {
  {{ UINT64_C(0x965246b76015404d), UINT64_C(0xd3a8b00b848aa4fe), UINT64_C(0xc1102a4953a16e18), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1799532f3f2976ce), UINT64_C(0xa66269ae9b881eb0), UINT64_C(0x92c3edeb96c5355b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x03f748a84a9565cd), UINT64_C(0x15e6b39cc537dbef), UINT64_C(0xacfa94192b70c93c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x74c466fef05a630f), UINT64_C(0x7be8a031b85132af), UINT64_C(0xcbb4e69ef80d6d39), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1ba1da89bf83e59a), UINT64_C(0xa9ba10b3c92cf1b4), UINT64_C(0x5b03b9687f1020a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8b9e19023187ef55), UINT64_C(0x9164c7cad69f1911), UINT64_C(0x71094665eac60188), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x34e491f82a839b88), UINT64_C(0x1567479ada1fed7d), UINT64_C(0xfd05d10cbbbe343f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0b1084e9a67f6998), UINT64_C(0x334772e9bbc8f477), UINT64_C(0xd8c5fe0f7cf1f3e1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa28c45538e0df922), UINT64_C(0x378acaad82ee8582), UINT64_C(0xef53fce62fe3ca63), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc775ca2fc16e38b4), UINT64_C(0xcc7fdfd06efa53ee), UINT64_C(0xaf686b8fc175dcef), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa8f6432691f53c1b), UINT64_C(0xef0a4153406ce984), UINT64_C(0xdb67740178f0abf1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x67506b4d231d1ed6), UINT64_C(0x9c4a40bb6782bfff), UINT64_C(0x7beabeae9fc8b27c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3272e3574732542c), UINT64_C(0x34c91bc2f7504b9f), UINT64_C(0x9d199614a4f2a99b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x604ee2a98a1f2356), UINT64_C(0xee531c794d2dbf29), UINT64_C(0xf6738c8e5f7bf202), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x822d8bdb5424eb9c), UINT64_C(0xf29da78ecaf674d2), UINT64_C(0xcc3ac249e49af7df), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x544e19a991fcf23e), UINT64_C(0xe4b8927161ae78a6), UINT64_C(0x1c2619ce60ec8ce4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x75f501d6e9459e5d), UINT64_C(0x23ca3cfddf1d0e86), UINT64_C(0x876fe593f1f32def), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x779c2c4b37cedbda), UINT64_C(0xeee272b8ef9330a2), UINT64_C(0x2503c5c99a40a594), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0d74609e901ff4c3), UINT64_C(0x4d19c610e99565fb), UINT64_C(0xb24d420ccae73712), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xffc816f1fd4eb769), UINT64_C(0xd98765a61a81053f), UINT64_C(0x4014c9d895d945be), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc0e31da456d66939), UINT64_C(0x00529cf7f4171dbe), UINT64_C(0x7bab05bf45eb5d1b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6bee80c41e0d8d1b), UINT64_C(0xd845f556e31db0cf), UINT64_C(0xc5d7b0c70b0b0bf4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe0956b34f15d48b4), UINT64_C(0x6dd93b3ad886c8f9), UINT64_C(0x286159ad8341266b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x56a78e4a9a1eb205), UINT64_C(0x1d2ed52232af7c0e), UINT64_C(0xf413d5b661448314), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd9a541f261fd65f0), UINT64_C(0xaf2886c29af0b169), UINT64_C(0xa164a29bc82a8a7c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe729fc0e3367e429), UINT64_C(0x6da34ad3d24305a6), UINT64_C(0x549c6cda14edd6d6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfb9f8f94e2b28937), UINT64_C(0xec3af0eecf80854f), UINT64_C(0x2e9c6401b3e3ed1d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x831f566eb342e734), UINT64_C(0x0eef7294708ba998), UINT64_C(0x39f5fcf50f5ec6a3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd18bf32a11f3b030), UINT64_C(0x9c5a0b649fdda04c), UINT64_C(0x81ef6cb5457d25e9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x396215d94f66bc04), UINT64_C(0x20c70e2be880545f), UINT64_C(0x30e2e896b318a894), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_8[] = {
  {{ UINT64_C(0xaa5c0ad6a44251d7), UINT64_C(0x9a6dcd0d52491535), UINT64_C(0x749f896750bb1249), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x77320731e960dd24), UINT64_C(0xff964b951add972f), UINT64_C(0x954668535436908f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x12fda2606affbecb), UINT64_C(0x6feb60d73d327785), UINT64_C(0xbcf1977b5b3bb5d7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb8ea5492af21244a), UINT64_C(0x681e498627111ad0), UINT64_C(0xcd2b4359e064e400), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x54908044be959b76), UINT64_C(0xb7e92c8f994bfabe), UINT64_C(0x130da47f50926809), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc96d62223580bb38), UINT64_C(0x9a1c4adb9d48216a), UINT64_C(0x8c4c289e5311b033), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc750fb545276b86c), UINT64_C(0x66d3d483014c18a6), UINT64_C(0xc4c5741ca986beda), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x070dcda7626f386b), UINT64_C(0x9c9e07bb152d5ccb), UINT64_C(0x60f60a9c74b37853), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0c0f6b6474ab5b3d), UINT64_C(0xdee0dcf6f3094548), UINT64_C(0x4decfe18a7a4f1ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb8280265834936ec), UINT64_C(0xbd16d32a441faa7a), UINT64_C(0x339f8e5c9e0c1a2f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5141e19b1d9c1bac), UINT64_C(0x8a50578c808e1a02), UINT64_C(0x6a86b60abacd355d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaddf76e35aff652c), UINT64_C(0xc2f7604ce0a1de1f), UINT64_C(0xc96540601c841073), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7746549695649d37), UINT64_C(0x37cfc9363cf75a96), UINT64_C(0x960bfa0c3fe22467), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8a7a595028de135e), UINT64_C(0xbced6320b5443552), UINT64_C(0x72af97adc48f6408), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa6a4849d79a36b37), UINT64_C(0x99f4af49c86d51a3), UINT64_C(0x40a032c66e7434b3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1d527298ffdcc6a2), UINT64_C(0x97d9cdee1f6a8531), UINT64_C(0x78490377e8f78256), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x09dbd5dca22044b9), UINT64_C(0x2ea21b8141906b9f), UINT64_C(0xf4f6fdcbedb878f2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x29e7c005f1327c4d), UINT64_C(0x2147c273302a9016), UINT64_C(0xa3cc9b41fc5cf6b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x497361d7acd5b244), UINT64_C(0x2f9d2343002c29ec), UINT64_C(0x184c885af9458f15), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x990f5c2e620d8fc3), UINT64_C(0xd49ed993a97136c6), UINT64_C(0x71ef97b6ffcaa110), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf6c8de11467977e5), UINT64_C(0xce92800c7af45dea), UINT64_C(0x8ab79a1bcacc0602), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe71ae56f69ba6c9b), UINT64_C(0x91fa6fdd70a3fd06), UINT64_C(0x3ef4a26eb22d518c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf885844824f9db7d), UINT64_C(0x47110306d3a9b721), UINT64_C(0x9c9f67f0e1603100), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe5e0977fee0bc111), UINT64_C(0xf7f1dc672f284148), UINT64_C(0x3d135f933f8bedfd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4541e827f8a7972f), UINT64_C(0xec2f276616b35273), UINT64_C(0x01048e3789c0cdb0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xec792b12ccbea2b3), UINT64_C(0x374d6d4d7d3e116f), UINT64_C(0xe16861bf03389585), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3e52ba4d1089e917), UINT64_C(0x7bb97c8cc2d8616c), UINT64_C(0xb584972fef3ae245), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1c3b50e0163d4ad1), UINT64_C(0x770407f573aa62c3), UINT64_C(0x035d78ab20d3b867), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2b6fe103ac252120), UINT64_C(0x5cbc01da622b88f2), UINT64_C(0xe8bb157eb2a3f615), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc01f26f30b093c7b), UINT64_C(0x8a049979a66b3f83), UINT64_C(0x08f789c0b1df81ac), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_9[] = {
  {{ UINT64_C(0x585fd36ef9a5fd6f), UINT64_C(0x45481843f63bb663), UINT64_C(0x48e5f811ae898551), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7f2fef339a42c851), UINT64_C(0xbe0b536f34f902e9), UINT64_C(0x3e998a03a48533e1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x251b8d60fa00f3fb), UINT64_C(0xe4c3bd477476b2b6), UINT64_C(0x91e41e962d8a9a3d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7b7f85134dab6565), UINT64_C(0xd6b6321cd61c177f), UINT64_C(0x2e7ab3233d59feae), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x411dda3622f7ee2d), UINT64_C(0x6a536cb97819b0df), UINT64_C(0xc5ce80e884ec8177), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc0df274985999138), UINT64_C(0x35121d7f94a44af7), UINT64_C(0x741218f8a8d0f8d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5403e894275a0bf2), UINT64_C(0x7a928edd91043c6b), UINT64_C(0xd4d0b9501763a9eb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc5503761d2637a6a), UINT64_C(0x3415db4a69dfb71c), UINT64_C(0xf9b2ece1d49e25c3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0b7b9a5e7e80ffb4), UINT64_C(0x30c9d9556f7c0598), UINT64_C(0xd05ad26f9560a712), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6f72b477835ec4aa), UINT64_C(0x47bdea944f20c8cf), UINT64_C(0xa779f22189af8309), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x221e54317555bc5b), UINT64_C(0xa057f5f17e9f0ef8), UINT64_C(0x7f43314a0a2f37d5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2585761fed1e9644), UINT64_C(0xaa5eb6bb14c91c5d), UINT64_C(0xec5ebc88a8a68522), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe19d573e7fbfdb9), UINT64_C(0x6957c76b7e01ba87), UINT64_C(0xf327251e7abd66c4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x81df1459bd497ae5), UINT64_C(0x42112ddfcd9467a1), UINT64_C(0x0f977a7b500c5453), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x39ae1e9044e9e435), UINT64_C(0xdc3cb06c383cc86d), UINT64_C(0x09fb9e7b79cd2ef3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaf19a7fb846edd64), UINT64_C(0x3a1d319e239b32a6), UINT64_C(0x12b9055ac2e6dd19), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xda76c63a17cb318a), UINT64_C(0x8fe65da0f397d7b0), UINT64_C(0x1a64e656c38b24ba), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe0d3683bc6f53c2), UINT64_C(0x1b432c9fe78aee70), UINT64_C(0x631781aaa937b182), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4c6338675b0742c4), UINT64_C(0x548eb0b7a5747e6e), UINT64_C(0x79e85a3bddf20bc2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc61931197a517c77), UINT64_C(0x196a52fee8c6366a), UINT64_C(0x5345f4723ec7cd92), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa1b3ac1b493f2842), UINT64_C(0xf4153947469a9046), UINT64_C(0x23a6b9349afff4a8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd9fde936b9341e25), UINT64_C(0xe6e013d31e579969), UINT64_C(0xee310c03bfbda8ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1ad8320c98c175b3), UINT64_C(0xecf8181b45097d42), UINT64_C(0xef8621d4b4f0a4af), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x72290da439d7daa6), UINT64_C(0x953bd83b7ddff5bb), UINT64_C(0x0ea9a9df8daca9fb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe5cbc75f1142d8b9), UINT64_C(0x4091059fd1cb3549), UINT64_C(0xde2731f4403e816b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb3aa0a21234c3907), UINT64_C(0xf3c3e08f1b6a2362), UINT64_C(0x6c87a01c1613bcb8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaaa5efa31374f6c6), UINT64_C(0xb0614bc05ab609ed), UINT64_C(0x097ee43b56028abf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf421b57c72e1c87b), UINT64_C(0x2447c513ef70bc05), UINT64_C(0x1bc34a4095114502), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x655916f5131af106), UINT64_C(0xaeaf41c6cb1301d8), UINT64_C(0xf52f8065c4bfbc9a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x023f042a52616560), UINT64_C(0x56a291b6a590fcad), UINT64_C(0x60d2e2eae6e765a5), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_10[] = {
  {{ UINT64_C(0x4daea5a63eab266e), UINT64_C(0x60c3627b9e7bd414), UINT64_C(0xca218121c0db3a70), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x35a52578f215f1b4), UINT64_C(0x488707cc9d353e5e), UINT64_C(0x72def21839e21542), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0efd80c16c317140), UINT64_C(0x3af7291040ad46e9), UINT64_C(0x7a0788dc99cf86b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd7792f790b650fdf), UINT64_C(0x12bb5674345fb7c0), UINT64_C(0x5737f30f1610382c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x590b969fcc480615), UINT64_C(0x2fffac8c67b75ee4), UINT64_C(0xdb262eaa7921d947), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xafddcd0f2e063fc1), UINT64_C(0x7e5e9aeff5ea7e91), UINT64_C(0x8e0c7e017bd72a1d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x763ec4aa6b2dec49), UINT64_C(0x88cb51fdd92a8c4c), UINT64_C(0x31c022cc8633e244), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x150f9b873e64cbb5), UINT64_C(0xb34d979f6f31e94d), UINT64_C(0x1fdf69e0effbac69), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf1cd9985d84b1a9f), UINT64_C(0xa1418f1b7a0a6248), UINT64_C(0xcdd70a6d24f87ccd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd56e7a231fd8b4f3), UINT64_C(0x1d3152d5f1e8278b), UINT64_C(0x9a76f6f1e8bc586c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x92098af47aff43b9), UINT64_C(0x36c7644d3f4926e5), UINT64_C(0x96e97c1eef351d29), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x060ee8d84b158cfa), UINT64_C(0x6b1708c2f059d6c7), UINT64_C(0xa06f44f0effba4b2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbf1510995f6f2645), UINT64_C(0xfb46da64e56b4300), UINT64_C(0x6d97b1e3874084ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x89c0452033e54b20), UINT64_C(0xa44d4f74e67f1cff), UINT64_C(0x1af39f4189adb5c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdfd79ee9b78a5981), UINT64_C(0x8a8d6311f4c76195), UINT64_C(0x37e82b04f2c6e86a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa7f18931318ae4c4), UINT64_C(0x9a0e0e16aba43e98), UINT64_C(0x49d407cdf1c34244), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf73efdf21a8b39d9), UINT64_C(0x8aff13367e68e4d1), UINT64_C(0x140a38d646da1f69), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8998b07786b2d839), UINT64_C(0x7f02fc9f5c5001de), UINT64_C(0x0ee0b1ba962565d5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x804e24fb9a59b078), UINT64_C(0x2f98652cd5479cee), UINT64_C(0xf061de5feb15a441), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0d5d7d361d3d6d86), UINT64_C(0xebc9ffee7cf0331a), UINT64_C(0x5302e67dec88f8f0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x563695d0cea59241), UINT64_C(0xc3fe594bf79f7f90), UINT64_C(0x707dcbb63bc71036), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcef49a911d301d40), UINT64_C(0x7ebc22ed3a165c45), UINT64_C(0x000833e6a3193dda), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x07e84f8b991bd81d), UINT64_C(0x4c15084e30c0bca6), UINT64_C(0xf2c7a90b934623cb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7827ff607284f8bb), UINT64_C(0x74180dfa1dd4a55d), UINT64_C(0x6f8ccb5c68c452a6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x28b3094cafb92992), UINT64_C(0x2c06d3d9ae4f98eb), UINT64_C(0x81af632bb85edba3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd1bdc3156a4e647), UINT64_C(0xed4f4cc50b731b53), UINT64_C(0xbc75c1887bced3df), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe70857ad6b21f665), UINT64_C(0x74639a90cb036db5), UINT64_C(0x7bb53511e36057e7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x81e781075237d7ff), UINT64_C(0xc713d9bced0c4fd9), UINT64_C(0xd2d346486d4e313a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xae54cd895ce12f7c), UINT64_C(0x686dbf0267e2288e), UINT64_C(0x4e2b2e80e991d0ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6f05e4efa97575b0), UINT64_C(0xd46440098fe381f4), UINT64_C(0xfc09356c6cffda75), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_11[] = {
  {{ UINT64_C(0xe407eef56e1fdabe), UINT64_C(0xf8f8a6839b526c4f), UINT64_C(0x4f8e0b9cdec5defb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd599069ec9fa3b0f), UINT64_C(0x5c66e564c24023ff), UINT64_C(0xb85458862096b309), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf26667ff3ebcf5c8), UINT64_C(0x65c07e04e53828ce), UINT64_C(0xdb4e67c7c7f456ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8af6fdbae80bcf9d), UINT64_C(0x96c12805ae715c13), UINT64_C(0xa5b2c5c9a57eb31a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0cf1ef5fa987373e), UINT64_C(0x334885fba324f3c7), UINT64_C(0xdf883c5c2a3f7b69), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa7cefd339832a139), UINT64_C(0xba8c5cd008c1e6d6), UINT64_C(0xb410504d30426765), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb50e2c8a011e077c), UINT64_C(0x3373fa755ecb1801), UINT64_C(0x915e180866d67ec3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9245d6923f9b0e4a), UINT64_C(0x637fa52a8ffbad72), UINT64_C(0x57d1556308d6f912), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeb3a59613bac10a1), UINT64_C(0x2629de66be1a6604), UINT64_C(0xc38d4e1f7628365d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x267d5a4ec7c7b2a4), UINT64_C(0x91b8651e633264ee), UINT64_C(0xa23a579347f412ca), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8a6f9db6e2576596), UINT64_C(0xf6c09f061e9dccb9), UINT64_C(0x8ae33c2bda372754), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc47c864cbba12127), UINT64_C(0x033360e81c0994b0), UINT64_C(0x78eb976cb9f5e557), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6db041b10bf7190f), UINT64_C(0xb3da76bcf21c4749), UINT64_C(0x91b9d02d1d4edf37), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0f282a96c8d7f8aa), UINT64_C(0x91d4bf07e8debab5), UINT64_C(0xf5e02e19415cf9b1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4ede1ee63bfd3d60), UINT64_C(0x83df70193a88e1ec), UINT64_C(0x260c56797f7e806b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf6f1fadda0aeafe7), UINT64_C(0x482080a689ef9f18), UINT64_C(0x09417c70a66f0029), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x441b7ca35de747f1), UINT64_C(0xacf1375055377ad2), UINT64_C(0x849737ac1636fee9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xba5d0fb2b133034b), UINT64_C(0x12bc6ce85241ff41), UINT64_C(0x970e50eabb531094), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb1ae865b1e2e64fa), UINT64_C(0x9a55ef42cb763698), UINT64_C(0xbc6eb2c33b82b070), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x16916007dc098e56), UINT64_C(0x94282e6dfe4ae2e9), UINT64_C(0x4d9eb7c629381fb0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbdde17c3893b907a), UINT64_C(0x23f0224312b80729), UINT64_C(0xe5b84d978ca34158), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2a44395b800bbfbc), UINT64_C(0xf55ce027cb53d457), UINT64_C(0x899a70c8c5c7c6ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x984f1b260f9e8318), UINT64_C(0xc236fbdd5ce07f3c), UINT64_C(0x4b7b3f7135836169), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd9a6d3ae10916c18), UINT64_C(0x1f7883e4a14abeae), UINT64_C(0x7ca82b923647a36e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2a7300c878d02e7a), UINT64_C(0x2afd147c30f11cab), UINT64_C(0x847a6e275295fc15), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x451b1c9eac8a5b92), UINT64_C(0x935df3644d49f1c7), UINT64_C(0xb2c0924cc14f5d20), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd1efe58ae81313f7), UINT64_C(0xcca59bd36eba12a2), UINT64_C(0xe0f396d437d6d3de), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x233e41c0a0fdff28), UINT64_C(0xb200c8c46b4dd9ea), UINT64_C(0x41c1625162c5bcc7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x15aed3570c91f876), UINT64_C(0xb9499e67a2642792), UINT64_C(0x60b98d63606013d2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc97d46bfe68f1689), UINT64_C(0x5a91c0e9abe5212e), UINT64_C(0xe61ed80a2ff1651a), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_12[] = {
  {{ UINT64_C(0x1bc3f314ab83a6b1), UINT64_C(0x9a9ee863efeb4888), UINT64_C(0x77edb6bb17eedaff), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x712ac22b7704b7f3), UINT64_C(0x8c9bfc253a617ced), UINT64_C(0x8b63a81e9d286331), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3a489fe38ac25fb5), UINT64_C(0x388b4306d68288de), UINT64_C(0x67ae096bfdef95ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2ab06b94c0703d0a), UINT64_C(0x1005994f0b9d8c2c), UINT64_C(0xb8a5077a5d0d1966), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0567cbfcbe2e3a03), UINT64_C(0x3b128146eb1215de), UINT64_C(0x3a912d86b5f6da39), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5fcba16dec0b04ea), UINT64_C(0x7231c0c7692cd9f1), UINT64_C(0x3e6beb45dbc7a409), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd0fd6b030563c770), UINT64_C(0x38ed726741265956), UINT64_C(0x66ff839894a5fc2e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb63a2f93b968a659), UINT64_C(0x92fbbe08aca81d69), UINT64_C(0x848184349f26d4d8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3b285c2bc55e34bb), UINT64_C(0xb0cfe3edeb320522), UINT64_C(0x1c39c5d5e66bf20c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x18f79e25f46770a3), UINT64_C(0xbe34cfc44780c8d3), UINT64_C(0xc82ee0d46de1a23a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x913b799381c7b834), UINT64_C(0xeb1c09b1ea219ef6), UINT64_C(0x5fa0fe6970d77a22), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcbe5a6eb3d1527d8), UINT64_C(0x9f781e75031a4ccf), UINT64_C(0xd35448b513642abb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71d11daed09e019e), UINT64_C(0xbc6ca69346282bf7), UINT64_C(0x25970a7f5ae3f3a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x978587386e2b3a43), UINT64_C(0xc0898f3e9cb4f308), UINT64_C(0x6eddf08bcaed38e4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd8062ddcd1132154), UINT64_C(0x47eb702a4fadb22b), UINT64_C(0x9a9fa2af3ec01980), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6121cbd3e70670af), UINT64_C(0x555b0b6fe6bc2a8f), UINT64_C(0x6979da5f12b60987), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0d6cdb1e4ee07146), UINT64_C(0x78ce8cec06cde40e), UINT64_C(0x6bc211e56a8f68dd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x11d7bcac453ad6ee), UINT64_C(0xdf6183c0bdf8177f), UINT64_C(0xb1dafa2c21fc5d2a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac22758c1144cde1), UINT64_C(0xcce5cd772f0757da), UINT64_C(0xda2a31ea40cab98b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e2d513585c24875), UINT64_C(0x636de0f0f8abeb8f), UINT64_C(0xafd552b30e0f7923), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x123039733fc6e078), UINT64_C(0x4843168a06453e62), UINT64_C(0x7bf45bf7b6553236), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6742f4410a192e51), UINT64_C(0x74efc1609bfdf4cc), UINT64_C(0x32b68e6b1e8b07d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xea47d3af2b33a796), UINT64_C(0x2e90f01ef2b2e586), UINT64_C(0x0786edf301b535e1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa067a7ae59cfc4e7), UINT64_C(0xb9ad71c5b5d3ae6a), UINT64_C(0xd3347b109567b226), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x828b22c7a604c673), UINT64_C(0x8e4d1150f899fada), UINT64_C(0xef0e197fa6ec33f8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7078dc21a965dc85), UINT64_C(0x8a5449a75cfe76dc), UINT64_C(0xd765f425e509101b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x09db829ff3b2308e), UINT64_C(0xc21bd5df3d7574c3), UINT64_C(0xc410ae715e489396), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x22b2af38905a8b04), UINT64_C(0xa5b07b5e2d91a016), UINT64_C(0x1735e7bf680003f9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1f5a06707d954226), UINT64_C(0x5332d7fa0135eba2), UINT64_C(0x6f9b893b00e54754), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x97b9e65d0dd9e456), UINT64_C(0xf2173ce613e92251), UINT64_C(0xdcba031caf47d9fa), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_13[] = {
  {{ UINT64_C(0xc867d51ce49cd67e), UINT64_C(0x098a35709ea2f628), UINT64_C(0x6ff66c67d2f8bd18), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x042e5f7e4c3680fe), UINT64_C(0x2d4469ae570f03fc), UINT64_C(0xfa34f8e9fcd8248e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x34699612a6547aca), UINT64_C(0x87f3b0c0c0aa1715), UINT64_C(0xbf362b0763bd2682), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa564636627e4b6ba), UINT64_C(0x62fe695fb737d53f), UINT64_C(0x8684999ef0e72da9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb9202a9fb0f16ff4), UINT64_C(0xfa83e59fca1e9e2c), UINT64_C(0x04318d3936d5e681), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7f5e910b8bd74986), UINT64_C(0x149b97ed8eddb27f), UINT64_C(0xafc30b541fe8fc2b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x12e9cd7484c1b5d3), UINT64_C(0x12b311a9edc032af), UINT64_C(0x3206988139a1f04f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaee71cbc1a2876df), UINT64_C(0x37f4f21b39b54f9f), UINT64_C(0xe4cfb68050eaa16a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5cfdf02e0d14292c), UINT64_C(0x91e20a20b94bcbb7), UINT64_C(0xe623e3cf7908a4f3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcd8c6b5549c18538), UINT64_C(0xb538c52a43817072), UINT64_C(0x3d82057860e5f7a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4fab9f36ca6cbe05), UINT64_C(0xa1d894a64ab7e8bd), UINT64_C(0x8cb99828ef1fdf00), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe4c4e25979a9c50f), UINT64_C(0x8eea13745c78a20c), UINT64_C(0xca339e55c72644ee), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x18f31f83fe986eb2), UINT64_C(0xdba9b94b563ef16d), UINT64_C(0x0b06328216671d68), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd6daa0e25d1a6e15), UINT64_C(0x24cef1edae37d7bc), UINT64_C(0x074ab482350f1958), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4f85eca18301fbc9), UINT64_C(0x15138d6f9c744a2b), UINT64_C(0xd99c911ab6c13686), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9bc73e299bcc6fe1), UINT64_C(0x103620ec816ba0df), UINT64_C(0xe63ea77456443659), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb1af91b35bc93841), UINT64_C(0x44e71a73dd79d232), UINT64_C(0x6a3292c0115384ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x480979fcc1ae9ccf), UINT64_C(0x13a1e37daba29123), UINT64_C(0xa10179d317deea1a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd017a5fab7e6bc34), UINT64_C(0xbf3dcde6892b3d3f), UINT64_C(0x30528d2f8d5dcbf0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x68271486bdb7286d), UINT64_C(0x1a36b0c008d4d1ea), UINT64_C(0x6e260afca8180ca3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x948a155504c24165), UINT64_C(0xbcb8a943b2692b8c), UINT64_C(0xcd9339749eb73d6a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd0b91786b11dbe8b), UINT64_C(0x0e8c0aed26f6fac2), UINT64_C(0x2908e86df33de88b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2550143ebad197ab), UINT64_C(0x16ace3b48a76c31b), UINT64_C(0x65b98704bb0b309e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x85be92c9861bb12f), UINT64_C(0x1d0a134e7cf43d1a), UINT64_C(0x77af05a263803253), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4087d20467991d94), UINT64_C(0x323a454dacf29470), UINT64_C(0xcbbfc5c1b0d3a67b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1b89974c1d659d8f), UINT64_C(0xd6f638497db19246), UINT64_C(0xf1bf597d06e2fe45), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x80344f859e7389a9), UINT64_C(0x564f61ea95ec3223), UINT64_C(0x9a15e1c3022088f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8101a15c4bc0772c), UINT64_C(0x6269d222071daf6b), UINT64_C(0xecb06b3b6c08a899), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4aa83543601ceadb), UINT64_C(0x4b838dc67770a220), UINT64_C(0x1605513102091a11), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6f68e8405227803b), UINT64_C(0x434da7583bf9c723), UINT64_C(0x8f28c1a93994fa9f), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_14[] = {
  {{ UINT64_C(0x5d49d7d0f17cd948), UINT64_C(0x7e77eb2b99c9075a), UINT64_C(0x600e8e8602921d61), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbea99bb2f02e0e7c), UINT64_C(0x17af5b998b4df76d), UINT64_C(0x621068eada953be2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa97e319b9afed81b), UINT64_C(0x40281a771484dac0), UINT64_C(0xd11454ea39c2d070), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x61c5505cf6478523), UINT64_C(0xf015dcf54315a0f6), UINT64_C(0xb71d70c5ca6dc018), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71ac53b726000d1d), UINT64_C(0x7ffb8fdaeaca74ac), UINT64_C(0x7bb61dad9b12fbfd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb9a560a4b7d76a22), UINT64_C(0x198802ac49f67e45), UINT64_C(0x2c88edea11472a4c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8652aca223b89c70), UINT64_C(0xf42ca332e4ec85e8), UINT64_C(0x1cbba7c45cf7464c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e2587192f201289), UINT64_C(0x8246a94123379c56), UINT64_C(0x4cd9ba084b4dc2fc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x13a0f55d9cfbd5c0), UINT64_C(0x72a46b86fa653b57), UINT64_C(0x4148a11b11e4dd66), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xde3f4c5cc19d1fea), UINT64_C(0x3d1198f22fb5e92b), UINT64_C(0x7f5db6b6091beaa9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6fb671982848f4ee), UINT64_C(0x221eece9b90d136b), UINT64_C(0xc694aed3e86d2621), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6b676f36e068a756), UINT64_C(0xf6cd1833b360e34a), UINT64_C(0xa89a46f9fac3e0f1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfeebc9138abe5998), UINT64_C(0x9785116071d6868f), UINT64_C(0xd5b355a4ae0b24a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac8361c47c048a5b), UINT64_C(0x220d40431c9482a9), UINT64_C(0x52848410ae33cc5d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x430413799561a93e), UINT64_C(0x77139a368fd6cdd0), UINT64_C(0xc5c2d2e0a90b84d1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xce5a94357e391579), UINT64_C(0xc816e7baafe6efbd), UINT64_C(0x60ab3f21d7d882c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x087958354d1c3433), UINT64_C(0x27da5a23b69be41f), UINT64_C(0x14909665df5f74df), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5cef206af381f0ac), UINT64_C(0xaedd06ff0ce443e5), UINT64_C(0xd4aff7720f7159d1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xecd4af1d14da56f6), UINT64_C(0xc723ca323bde6c60), UINT64_C(0x1a67c7f968b62d3a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe6bd0b519a498b81), UINT64_C(0x05f1037700b4bb72), UINT64_C(0xe15b41a0a6be6c51), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf4910feb28465955), UINT64_C(0xa62418114b8ef181), UINT64_C(0x532ab3f9e7b6ebfb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb160e0d9aaa27238), UINT64_C(0xfdd9561005a7a4ce), UINT64_C(0xb5b3804b6bf2f721), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3ef073381a713cb7), UINT64_C(0xd5adf2579bc1cca4), UINT64_C(0x3152119cb3b18b24), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2729fc4df371addf), UINT64_C(0x352ebdca7bbb08a4), UINT64_C(0x354549359a5111cf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd0cb5613660e78d0), UINT64_C(0x6745217d0af10dfc), UINT64_C(0xdcecc14b28ca6ab8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x03c391be1b37933a), UINT64_C(0x1dee50089a280c0a), UINT64_C(0x9d171ad31ca195c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x576f9bdac27a8d78), UINT64_C(0x3fbd94ded54cd3d3), UINT64_C(0xa5a8151a31003c6b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e7323855011d8bb), UINT64_C(0x9c10365138871163), UINT64_C(0x03156253288f886c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbb3e519241cf6e00), UINT64_C(0xfb9b6cb7b28315af), UINT64_C(0x0fb948d90f736e26), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9b1d14cd87375aea), UINT64_C(0xf3a5caf5a01e07f2), UINT64_C(0xd930a46c705259ec), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_15[] = {
  {{ UINT64_C(0x2899f3fef6b9b015), UINT64_C(0x037bfab88f4d5931), UINT64_C(0xf3d710723682ae1e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7659f093d62ea80a), UINT64_C(0xda97689dbde21834), UINT64_C(0x7c771bdc14356840), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x42ac96a7887db93b), UINT64_C(0x8ea3204e00663bf2), UINT64_C(0x42c96a1edffc718a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6735715007325bbd), UINT64_C(0xcfd7ca6798a53ba7), UINT64_C(0xf242b80b23deb358), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4d652c5f3be7c1ee), UINT64_C(0x4eefe3881c1423b1), UINT64_C(0x9dc6060c4f5619fd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd9f29552790c9274), UINT64_C(0xd086e806f38c95ab), UINT64_C(0x08f9534abaf8a6c5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbb41ca3a4c602ca3), UINT64_C(0x4ede99e05f906290), UINT64_C(0xaaeb963379eec42a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbeada9f1d9e282d8), UINT64_C(0xa9068a11841f8b43), UINT64_C(0xd502758e622aa3a1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdd120e71404037ae), UINT64_C(0x09ca11a50c72b409), UINT64_C(0xb66551c589d9d0a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x82758d9e12476d64), UINT64_C(0x0a6e67bd2744869b), UINT64_C(0x4ef533f12ae377a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7d2eddd2a405ca2a), UINT64_C(0xdc8baebf0074fd47), UINT64_C(0x1cf89fe1cb797a72), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x664c0a8cab9601e7), UINT64_C(0xf65f522a9a6385d8), UINT64_C(0x5321bbb787a51129), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x78840dd2d25321d9), UINT64_C(0x7ba56f96656ed20d), UINT64_C(0x4fde9fcf6b69f2d8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3ed3ffc7742ec8d8), UINT64_C(0x3474282ba4b5ab7d), UINT64_C(0xd56cdb22d4ef5453), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcaac222dda601527), UINT64_C(0xa0bad3c6676b58b5), UINT64_C(0x7040509dd195c27b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x802ecb5eea21841f), UINT64_C(0x7285de35bb820aab), UINT64_C(0x53b64f5588125f48), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaaad89b473494887), UINT64_C(0xb116e7752f4e0d32), UINT64_C(0xcda66267bb24c8ca), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2abc69363fca3af4), UINT64_C(0x7d940ea34aa0ba46), UINT64_C(0x2e4bf7d31d0c7f64), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xed1f055bbc771867), UINT64_C(0x9e44c05bde7de255), UINT64_C(0xe64e8de45f8007dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1c175374e562eeb7), UINT64_C(0x376ab2852c21515a), UINT64_C(0xa3d1eb5db5f73a3b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x711ade05b0269e71), UINT64_C(0xb35b705a6469b0e9), UINT64_C(0x6afc7775b7eabc8c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5b742c18f57808a8), UINT64_C(0x4ed7c383252410ec), UINT64_C(0xced60049cb25589b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7cb28eab60a0c022), UINT64_C(0x2d69fffa5a55b761), UINT64_C(0x56408be41eea5e19), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x034053bf9521cd5a), UINT64_C(0x36b3486b8acf73b0), UINT64_C(0x842e7cb5b7681ddf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfed1e25f9f25709f), UINT64_C(0x7e2b9aaa5a19fcff), UINT64_C(0xaa19d9d53a3fd11e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x88379ee78d56e381), UINT64_C(0xe90ba642c1374d5e), UINT64_C(0x07961187f0c79929), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x975bb9d24d867efa), UINT64_C(0x40f552e16d8dad1c), UINT64_C(0xd8aa71b89dae480b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac4154807394699f), UINT64_C(0xf858698e41286c2a), UINT64_C(0x3927fe2ec904e6c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6c74941f327fdc31), UINT64_C(0x236b53f22b446691), UINT64_C(0xe26b47ccdd5039a1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe70090ecc1b25361), UINT64_C(0x4374de1cc8dc2c3f), UINT64_C(0x58f79d724236504e), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_16[] = {
  {{ UINT64_C(0xe4684397fa277cda), UINT64_C(0xe339e31911c86fdd), UINT64_C(0xea0b9ae24d5e322c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x34a65c9402cdac9c), UINT64_C(0x8864734dfb0326ce), UINT64_C(0x229c8a3e27248bf8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xede9ba9708186855), UINT64_C(0x5e1a061223bac317), UINT64_C(0x1ecbf8a104b64b0d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4196332fcb16a35d), UINT64_C(0xd0997f2809b20823), UINT64_C(0x531d976f84512c93), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe580a3327c3151d7), UINT64_C(0x7e20e6b82b75fb57), UINT64_C(0xfe749db73ff30a2f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x84dd28591778daa9), UINT64_C(0xdadc1ac3f17c0fc3), UINT64_C(0x52e73248c31467f9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x605a29062e8d0fd5), UINT64_C(0x683f10adfe97dcfd), UINT64_C(0x70cda73f11bec2ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6ac0c927565447b8), UINT64_C(0x2cb80c914fb55537), UINT64_C(0x17bbee6f5897ab4e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9abd59a600b353c4), UINT64_C(0x76a18d8e283c2881), UINT64_C(0x4382fb9199c2803c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb344aa43b9f04a0c), UINT64_C(0xc1c981f46b16d41a), UINT64_C(0x619649c6e824acab), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8424ea32209cb6db), UINT64_C(0x630da3407e3e5c43), UINT64_C(0x062632ea4c6a74c7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e2e60e5451c1dd1), UINT64_C(0x4c63dca37ad4aaed), UINT64_C(0x74754c78f8a1a3ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe959eb73629d6291), UINT64_C(0x8d351a07d9233d8d), UINT64_C(0x803eb1736741f36d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x86430b2b0a18e312), UINT64_C(0xc4de05060d463900), UINT64_C(0x684f9a7b495493ae), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa791f7fb7b9c3e1a), UINT64_C(0x90e40a8726bd3bfe), UINT64_C(0x7bcf0a0a3e9913e3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x44a79b5bcd2d0923), UINT64_C(0x9d2f0f65f768ad0c), UINT64_C(0xd1c9b71838490d67), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2d9852948c15fff7), UINT64_C(0xd70cdcb7d40fbd5e), UINT64_C(0x0ed4e6b68bb9f52e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbf6f4ccd09da2dfd), UINT64_C(0x5862f2bce81004b9), UINT64_C(0xb9666ccb2d2131ef), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6f722c6c5b6261cf), UINT64_C(0x7be66d38c52115b6), UINT64_C(0x45e1dd452f9ba9b6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4550807d1e9fcc6c), UINT64_C(0x791d574aa4ad3792), UINT64_C(0x2c7f11706fced53d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0901b7b3b133bb1a), UINT64_C(0x8dfdd0a7cef367ba), UINT64_C(0xa63b56924644bb39), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0bdf21cbb2f083db), UINT64_C(0x950054a4afd944be), UINT64_C(0xbf4852b7e4365310), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdfe982917767f6bb), UINT64_C(0x1cae1194a3c1546c), UINT64_C(0x534632742fef22f5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa593fcf296ebea7e), UINT64_C(0x4e28c3f9a2353aed), UINT64_C(0x10004baca41c6431), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x84f60498ee429e5e), UINT64_C(0xca4bd0431ec80716), UINT64_C(0x61a9ac0c249a3f79), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc3b7c0ed4c3f413c), UINT64_C(0xb07dfc2e06cac6c1), UINT64_C(0x7dc3c7675a72c0a6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb21570152d4fcc46), UINT64_C(0x78f853142592a534), UINT64_C(0x3cc84742871695d4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4cd27af630b2cc4c), UINT64_C(0x2a3d2ca4ffae1e46), UINT64_C(0xd98e8a48419fa3db), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x14bccc32307b0bb9), UINT64_C(0x9e75f4c20b4f70d1), UINT64_C(0x61287b416669099b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x032bd83010f92c0e), UINT64_C(0x1bbe357da69f9062), UINT64_C(0x714a5e86d15533cb), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_17[] = {
  {{ UINT64_C(0xfa9413ca81b944a1), UINT64_C(0xc60219f7be824361), UINT64_C(0x74409aed1b259369), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4fec2e27df607376), UINT64_C(0x714c06542ba4f2a4), UINT64_C(0xa4de913be6778e78), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x33f4df34793662ad), UINT64_C(0xb13621e12d871d44), UINT64_C(0x42622dac5297d364), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x984700b6bb0107c4), UINT64_C(0xebc007af7bc33e97), UINT64_C(0x15e5b7d7fc261bbe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc6bae72b24aef722), UINT64_C(0x5c7f0a7758a1a05b), UINT64_C(0xab317ce53b14dc28), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7da18c29d2525529), UINT64_C(0x608d9923bba04f4c), UINT64_C(0xc5734af84af6261c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2c342c58152ae5b3), UINT64_C(0x14cb592bf6d279d8), UINT64_C(0x304cf123552a7902), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2e69e01cb8336b20), UINT64_C(0x0db6f687cd534db6), UINT64_C(0x569679d313a0befb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71a0ed29db16bffe), UINT64_C(0x97c7b307847ef52b), UINT64_C(0xee44a221a88d5bb1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x21213ebb3dafecf2), UINT64_C(0xd0a93be97e2ac5c1), UINT64_C(0x4de83082cb378b5b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc73bf1d41c5ce3ac), UINT64_C(0xeecad8ca4238f0d0), UINT64_C(0x50276c0fa285ec77), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xab9079f6a207a39a), UINT64_C(0x06490afcbc78dbe8), UINT64_C(0x61b54b96743d2c12), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x81bde0ac22dfb980), UINT64_C(0x3900e3f2820199dc), UINT64_C(0xcfe231ba46e06b68), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfc9ede1424fbd1f1), UINT64_C(0x15d73cbaeaffd913), UINT64_C(0x8ee86ed86e5f46de), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb77abb6473295500), UINT64_C(0x7757028d8b368a4a), UINT64_C(0x1ed1ad0f40cd7257), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe6f45a9257e7c1b1), UINT64_C(0xd797556c5f5f97f2), UINT64_C(0x647e4223a1ca54dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac791a73c991aef3), UINT64_C(0xa84275de0b6def98), UINT64_C(0xece8b8056813bda9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xddae8cb5f4afd305), UINT64_C(0xe452eb27e4037848), UINT64_C(0xa55674dbd29a61c5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbb30d9a7ef8489aa), UINT64_C(0xb0ceafcdf71124c2), UINT64_C(0xe5945c16dff582dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3686074812838726), UINT64_C(0x19753bf487bb6fa5), UINT64_C(0x1e53483a09ac65ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0d12f840ca4931e7), UINT64_C(0x4256b8ce19d80a9d), UINT64_C(0xfe960ee2e554ec7c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5ae2f33c53a603f2), UINT64_C(0x6306f27d1dac1ed5), UINT64_C(0xc756c6f9619bce95), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x430f8e3abda80351), UINT64_C(0x3e46dc05cc14fc5d), UINT64_C(0x3cb520c91399873d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9ce78d3f298ef2f4), UINT64_C(0x97f8da05328cdfde), UINT64_C(0xc57e629ead8c71e0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x14be3e554fb75b53), UINT64_C(0x8fed5ce87bee3b5c), UINT64_C(0x17fa1e74d43053a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x27ef8834b7bb0469), UINT64_C(0x9d662f2bdc1c982d), UINT64_C(0x3fd99f2f844fdfe4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0fa257a6c0056f53), UINT64_C(0x75ed810cdf4ac494), UINT64_C(0x5d31be7e412a20a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb27aef3c16ea7644), UINT64_C(0x84edf393e546d56f), UINT64_C(0xf60f8bb01d2a1232), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3ea8f7c981de93b0), UINT64_C(0x066ee47cc2966fca), UINT64_C(0x5871707e745449e1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd97b35bd4ae88ff1), UINT64_C(0xf4e38a33cd6c2018), UINT64_C(0x440b4c6efd52aca4), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_18[] = {
  {{ UINT64_C(0x3725991ef3ffcc2d), UINT64_C(0xf9950dde213aac1e), UINT64_C(0xf4777cc3e06586f1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x63c927ba9b7ca457), UINT64_C(0x40d94d15791374c1), UINT64_C(0x25dcbd1feed33af3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x893303806e1d2452), UINT64_C(0xf833782f11d3e5d6), UINT64_C(0x1c03eede2a68d007), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x74e50b8ba79c656e), UINT64_C(0xfe5c82ab7f32c0e9), UINT64_C(0xe7b507aec9cdf1cc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9b090df6ec24d0eb), UINT64_C(0x5c1a3a328568d6fa), UINT64_C(0xdb28d4df3ee31c0b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeb4dfeef0dd5d57f), UINT64_C(0xd52ed9c262509999), UINT64_C(0xa54f1fbb9badac3f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x234b71e645237564), UINT64_C(0x62f908188cae1fba), UINT64_C(0xc4d6eacb6bbc52d1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x387cbe164ec59661), UINT64_C(0x88f40641e2ba4882), UINT64_C(0x2414a940c9cbccec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x094c12e848f3f7d1), UINT64_C(0x9aa02f98d47d55d6), UINT64_C(0x05b1377469319555), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfc17a18af877642b), UINT64_C(0x9ddbb93b1de72296), UINT64_C(0x264797583a704c33), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdb5deab5790aa5d5), UINT64_C(0x161e8b1d870b3e1e), UINT64_C(0x566a466952ca647e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0c778a3090fc9e6a), UINT64_C(0x61608a3d7a5700ad), UINT64_C(0xd3d26936676d335d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa98d23ff7707118f), UINT64_C(0x23bf64292e0785a2), UINT64_C(0x4c47e452c58fa8a6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb1225f63cacfffb1), UINT64_C(0xb24c7a99bc63ac6e), UINT64_C(0x06f7102c669fa1e2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc08fa4938cfb4f88), UINT64_C(0x080ae7bd3b9bbac5), UINT64_C(0xff0e667ded3af59f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x67dad84dfd66d593), UINT64_C(0x10289ac0422eccb2), UINT64_C(0x5cc072773ec22945), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfd9f7bd42c361193), UINT64_C(0x7c048e51de24944d), UINT64_C(0xed0014a7a3ac90db), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf86804783e736871), UINT64_C(0x6d990035f4963cbc), UINT64_C(0x7a03bc956ad18f52), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6b0e4da51e88bb10), UINT64_C(0xcef44c8b4d51cc6b), UINT64_C(0xd36daea954276603), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa7a2322db4e635d6), UINT64_C(0x44fae8db17fe4600), UINT64_C(0x488876c8e16c2594), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaa34eda5593ad610), UINT64_C(0x9fbc293904e75464), UINT64_C(0xb734ae18a9c52761), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9c596de2d4f842da), UINT64_C(0x55c4bbd13ac39d25), UINT64_C(0x719f6398309e49a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa73d9aa5e0291838), UINT64_C(0x7f25ccc785d6fb92), UINT64_C(0xab7fe47f91c7d36e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3327dd117112c4b2), UINT64_C(0xda2a96a3027fdd98), UINT64_C(0x0ec11c04c48f5b8b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2603fd5d15f07f91), UINT64_C(0xc4dbde4948bbb7ec), UINT64_C(0xb3f3a1ac9719a235), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x24d26329ec6c3140), UINT64_C(0xa0544c51319eed2e), UINT64_C(0x03200d88db17c976), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8b0ee01b02f13d41), UINT64_C(0x5340c8880d3c8f14), UINT64_C(0x39f881a06bc3d6d1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x85fc7f00af8d1a6d), UINT64_C(0xcd18cb60dee99bb6), UINT64_C(0xe3fa1f50260f0919), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbbb29ae59e60c495), UINT64_C(0x1563fca4cf9e5888), UINT64_C(0x213bcc61756b5389), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x42dbd0d9a39fa448), UINT64_C(0x61043bc6bc83bc88), UINT64_C(0x4859265d2a90ab1d), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_19[] = {
  {{ UINT64_C(0x8639fcbf1537f135), UINT64_C(0xa03d2fbd2de28cb4), UINT64_C(0x9e6abb01e294bbf9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x79d81b5656a57fdb), UINT64_C(0xbf25d01f62d694a2), UINT64_C(0x6249a0be5fa6d133), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x045c6a8f5db62d0a), UINT64_C(0xadbc76516eed539a), UINT64_C(0x0aafa7dce22da1de), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe7b81b39b4a13f7), UINT64_C(0xce39e345f856e604), UINT64_C(0xf1e0f2afd0aa3d43), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0eafe5df4dd1b212), UINT64_C(0x882a279ff41a32f2), UINT64_C(0x4b25a72d48eed1dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x11f7315c0dab5cb9), UINT64_C(0xa99999e055017024), UINT64_C(0xf444be79cc8c07f3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2c4ff633892003c7), UINT64_C(0x7c6120425c7847a7), UINT64_C(0x204d03eb2d7b5b71), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5c5f31d9e853899d), UINT64_C(0x8aacfb8eaecbb396), UINT64_C(0xc04e67fcec00fa1c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3b5c8d499bc5b938), UINT64_C(0xf163883739e35f26), UINT64_C(0x062ab8ff061ab48d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x79f62ffdc381bc35), UINT64_C(0x67785890ce438584), UINT64_C(0xa1c5eea280d8bc45), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2ea3fc6f33da0ac0), UINT64_C(0x9379466f94a958c5), UINT64_C(0xcece5c49651bb27f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x560313f28b038cc5), UINT64_C(0xf0fe76e4aff989e4), UINT64_C(0x13ba78079a2a5df8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3c6495a6738b9d63), UINT64_C(0x0f80755b4db6d228), UINT64_C(0xf7eb20628283223c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x629a47e8dfdea3d0), UINT64_C(0xfa8910812b01d0e4), UINT64_C(0x886075956498a5a8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9e86bcfd8946c116), UINT64_C(0x4e9d5f90a05caf11), UINT64_C(0x24c48efe94dad6c3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x430f0055a5b530f3), UINT64_C(0xa4b31efbb5728f43), UINT64_C(0x10d873d9821c8e99), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4babd9bdd8c4539f), UINT64_C(0x516362cdb7562985), UINT64_C(0xdba97b2b99cfc4b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf80fc946c86d2ce0), UINT64_C(0x345ddcce69988648), UINT64_C(0xc412d73b55d3abf7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8314c3821eca794d), UINT64_C(0x2bdc7230e163048b), UINT64_C(0x01876ef0f0ebc278), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4a217e73efcfd407), UINT64_C(0x422975b80935210c), UINT64_C(0xd7ccdce4522f10cf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf57252472649720a), UINT64_C(0x58ff1069a6502f22), UINT64_C(0xc20b496f027405ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3275768e6aeeddaf), UINT64_C(0xc3549cf1f78bddd6), UINT64_C(0x38fb4ca1256165a1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0c3a685c666fd6ae), UINT64_C(0x5a743470c4fe9c38), UINT64_C(0xb86289bad82b4f90), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xce5806bf273b01bd), UINT64_C(0xe8ef87401d2e5ce5), UINT64_C(0x539e428d6ae4ed2c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5304a606aa30f041), UINT64_C(0x776826cbb2aa1e2c), UINT64_C(0x8aed0bee4b445889), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb6c1359cfee9844b), UINT64_C(0xb85255fec7585512), UINT64_C(0xe1cbd796e695c1e6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7570613225891d02), UINT64_C(0x48d29ba3ba3e6e85), UINT64_C(0x84326b45ea332768), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa024d36ba2d20992), UINT64_C(0x2cd982d7adccba00), UINT64_C(0x1b99aa52d3de49db), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc39503951bc75d96), UINT64_C(0xfe6f8b90e4eb1653), UINT64_C(0x31247a86d0d97241), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x412916aad75c718d), UINT64_C(0x6d914aa2b4005255), UINT64_C(0x9d0ff103bd6ed9db), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_20[] = {
  {{ UINT64_C(0xba7d5d83e739a527), UINT64_C(0xd5dbc6527aa7683f), UINT64_C(0x947035eec05d57e0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x07bc962ea1be6779), UINT64_C(0x85aad62c62171b73), UINT64_C(0xb6b077efe971ddd8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4fb7a008250d00ad), UINT64_C(0xd1ae8ff1ba148dba), UINT64_C(0xafff4fe23d850c33), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x97c687ee16be3ae0), UINT64_C(0xc798773508abbd7b), UINT64_C(0xe9428c69a3a5313a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd114e2b7443253c8), UINT64_C(0xf6aa2b27c7373432), UINT64_C(0x612db9e6713d9759), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3098f6b457191962), UINT64_C(0x0dac283cef26e1c1), UINT64_C(0x8b8beca7c23cf4a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x649693723463b233), UINT64_C(0xb00ada52169aa211), UINT64_C(0x5220ed29976dc2a8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x625f50f0253f663f), UINT64_C(0x834725f3eefc72e1), UINT64_C(0x74a6a89c0818fc8c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xba329081653fb362), UINT64_C(0x06b25be7d9e52dfd), UINT64_C(0x05d9b5b4fd21384f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3946a56cd41f700a), UINT64_C(0xac935cc7b933821c), UINT64_C(0xc471d66f70c30412), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa1fd0ee818e1b104), UINT64_C(0x734675cb64d2587e), UINT64_C(0xc800fad8394f83b9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3bf97cfdcbdca701), UINT64_C(0xa01534f1697ca01e), UINT64_C(0xeaf54d90f4993547), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xda4eacecb5e93114), UINT64_C(0x87989a2b33dd4614), UINT64_C(0x3c28ef730b6779af), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x01beb0a841f20709), UINT64_C(0x08045f35c208ad7b), UINT64_C(0x282a57464ee42fe5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe016cd70446477ab), UINT64_C(0x53e10d0bd08c9860), UINT64_C(0x0551f377f9daefa8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x55b721a270855eef), UINT64_C(0xd9481b865d4498c8), UINT64_C(0x4780741dc4d1149c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x21ae2a769e3d8985), UINT64_C(0x9bd75ff2b15d18ec), UINT64_C(0xcfd0de08423038e8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4c2a90848824a335), UINT64_C(0x77183687fbf00688), UINT64_C(0xc619bf40647615aa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcbcb2bdc63c78887), UINT64_C(0x5d42748ea20ea2bb), UINT64_C(0x843776f5be70816d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfaf8498410e3df2a), UINT64_C(0xcf02f0263811e304), UINT64_C(0x54eb80201f5abb38), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x19699a515ecdf31f), UINT64_C(0x2adde1076a984e3e), UINT64_C(0xfb069bca0fd8a95f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0065b0d5855b371b), UINT64_C(0x3964c503ad6d630b), UINT64_C(0xd50addceacfb6004), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf9c8a1d51edb8f36), UINT64_C(0x5815e26b1936f825), UINT64_C(0x2e756747674e7c3a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8b0feb724e1a15a5), UINT64_C(0x77c4bce5c9b90aee), UINT64_C(0x7b76010dfc70179a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2e13653b00dda511), UINT64_C(0x060f3fadae2dc5f7), UINT64_C(0xf83f1213341f182f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x00c895ba8f3eaa50), UINT64_C(0xf26440caecbf4ed0), UINT64_C(0x3d34f9755b9af4ab), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbb6591f8c9383a86), UINT64_C(0xcaa0c82ffafe1dfc), UINT64_C(0xfd4eb5a80d783cef), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaa691e3e69a28562), UINT64_C(0x8c4749843ffaf219), UINT64_C(0x5c9a1b68951fdb48), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb10bcf40f4b3bc7a), UINT64_C(0x6d6cf09a3d3ac043), UINT64_C(0x81ced61b75c895e6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeefaf535706f46f8), UINT64_C(0xec9ea8ccf15aa22d), UINT64_C(0x3675623ec7666581), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_21[] = {
  {{ UINT64_C(0x6a722b76af4dd247), UINT64_C(0xfe677ecb12008688), UINT64_C(0xf789397e434c7722), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6186fe3b26292376), UINT64_C(0x6bb6d8cafdc62071), UINT64_C(0x450c719f5a593a8c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb39f9a61829c1f14), UINT64_C(0xc80a2bf9f9cb594d), UINT64_C(0x916a7390e751a938), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa27ef719a7b1224e), UINT64_C(0xd0578f9b6a3026ce), UINT64_C(0x437b1b0890972d1a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x814000a1f4615b2d), UINT64_C(0xb36be2414fd502fa), UINT64_C(0xf56a14f21d9c68a7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd0199df597eabcb6), UINT64_C(0xf83d2f738317b2a8), UINT64_C(0xeb0007b7007a1767), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6d8ffce12d32515f), UINT64_C(0x6d6ae2ee9a0af769), UINT64_C(0x70995dd6b2917ca5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x21fd8fb08a3f9672), UINT64_C(0x412cc5fdac052b16), UINT64_C(0x500b88e26a34a3d1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x877749a1c252cb1a), UINT64_C(0x485a9b090c939969), UINT64_C(0xb58536e6fb6ac7c4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8fbd6bfb65c7a417), UINT64_C(0x888a91ae25fd364f), UINT64_C(0x387861ec4d530fdb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xecb2d5967e5abca8), UINT64_C(0x2f381f1bac06400c), UINT64_C(0x161ccde857649eca), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x20cfa136eeb6e165), UINT64_C(0x5a00d20ed0203ed9), UINT64_C(0xa97c2fdb326c32ff), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x547ab51a0f6549db), UINT64_C(0x35bd9e67d87855b3), UINT64_C(0x5bc8468f0458e196), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x765a41ef245623af), UINT64_C(0x0aecaea101a528ca), UINT64_C(0x5e4c3ab10b14b1fd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4c557ed06b8af99e), UINT64_C(0xe848ff96e4b006f2), UINT64_C(0xefcaac8f38bc51e2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1a7b4958d8162faf), UINT64_C(0x3146889f8500a51f), UINT64_C(0xb12c1fa3ae50c03b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9922549b7d750c6b), UINT64_C(0x33fe7b5299152277), UINT64_C(0x679e1c53b449b5bb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6031b3eddbe71cd6), UINT64_C(0xebd639838190da2b), UINT64_C(0x57392650eff33537), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xad923b10b125f555), UINT64_C(0xb2ea99c29144ced1), UINT64_C(0xfd4be1aa02200848), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb329551ed41ea239), UINT64_C(0xb6d97fa7f76d2e23), UINT64_C(0xaadbc28af47daf28), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaf1785f2d446793a), UINT64_C(0x48d1d33aad4bd7ae), UINT64_C(0x21244177b3eef96f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf1cad8f42c9b5c68), UINT64_C(0xf99d20e078317534), UINT64_C(0x987ddb066a8f9d0b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x680e24c3b85664b6), UINT64_C(0xb842342a8414293d), UINT64_C(0x875431cb45943b93), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x354593ecae1bd3e6), UINT64_C(0x0ae2219776f8f35d), UINT64_C(0xd2bb91a78c6d709e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x35073e8cb1eb4f58), UINT64_C(0x1221de1f4f4ada6e), UINT64_C(0x04384195d0410d1d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x635349e8b8b949b8), UINT64_C(0xa39a6ab95a4db46b), UINT64_C(0xcb06f138436dbe54), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf62483c14c97008f), UINT64_C(0x902f3647c2f001ad), UINT64_C(0x4a090300e053f5a1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x57c1fab28d2635ff), UINT64_C(0x95fd989f491b14f4), UINT64_C(0xd2271b98d97284fe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa366e91516a9bbf3), UINT64_C(0x81972e1d1c1e76a7), UINT64_C(0x4fb685328796ec6e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1f294ec1c7ca1207), UINT64_C(0xfe1fa74184499877), UINT64_C(0x9dc29ba4ab64f332), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_22[] = {
  {{ UINT64_C(0x313c9619b825fbed), UINT64_C(0x3ff0ddbad24819fd), UINT64_C(0x470ea29b06248a20), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3aca4e138041c504), UINT64_C(0xf44e404e258ab805), UINT64_C(0x6a3985c3b7d3a6a9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf27d8ab23ef7277d), UINT64_C(0x8f40162abd108e33), UINT64_C(0xf520dc022c0980d8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x87739e3df462516e), UINT64_C(0x1246ee7538c3b433), UINT64_C(0x32dfab53325b0efe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf1a91dc36fd42f14), UINT64_C(0x5d6743ad4920c24b), UINT64_C(0x71f9a65c05d590bf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdf48178abb315637), UINT64_C(0x6840eb13d9f9bc71), UINT64_C(0xe4069303943f3c26), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa0b31e5b5b62da20), UINT64_C(0x7139168f3aa4fc4b), UINT64_C(0x134525c64a9883a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7cad21cbc99d96e1), UINT64_C(0x68fff2e887f24b54), UINT64_C(0x23aa2aa925943ab2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf8eb851571d0fdd8), UINT64_C(0x72862c3cf798fb85), UINT64_C(0xde4cafc236a320a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdb54c18009a012ff), UINT64_C(0x10956e96ba626428), UINT64_C(0xcaa88a96fbb59777), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0fff6df4460cfeab), UINT64_C(0x21ba7cada95c1d89), UINT64_C(0x4526a1fa3f900418), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x645c33ead273ee38), UINT64_C(0x9059d2ffc234013b), UINT64_C(0x06910bbd89966ec2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8e5603c53900c49c), UINT64_C(0x6526f9de80ed9bc2), UINT64_C(0x0e12ab78697a389d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd63a29475fb4ae98), UINT64_C(0xc33bf8bf9c78ef93), UINT64_C(0x56e3756d52186401), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd8b831938e467283), UINT64_C(0x6a5e08b68d146bc7), UINT64_C(0xf0f0fb852bcb8bf8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2331eb9ff2675cf4), UINT64_C(0xcccdaf5c84643329), UINT64_C(0xe428cf7654209693), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x921ebd4089abbdc7), UINT64_C(0x8cbc7bbae451b82c), UINT64_C(0x3e3a281714d9dfd2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf3200bcbe82bd2ec), UINT64_C(0x829f087c9a3e723b), UINT64_C(0x5583feadb07b7367), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x70647e3c4923c1ce), UINT64_C(0x90d323ff2a5ef321), UINT64_C(0xc8322aae46447f72), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71f24f9de27e2963), UINT64_C(0x050a292282860712), UINT64_C(0x21c73b8687771f6a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf3d9749fd6007fc0), UINT64_C(0xe4a5e49f1056cc12), UINT64_C(0x1aeb143d38be2828), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbf5ad8f5dc608c59), UINT64_C(0x48ef46e856625879), UINT64_C(0xfb8d01427f6e36fe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbc77ff2e7e65c8df), UINT64_C(0x51ef004c1cfcfbd4), UINT64_C(0x48e552f8a702ddd9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e72a94bd5e0012b), UINT64_C(0x8a38793452011092), UINT64_C(0x8538dc82f6e4cd95), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x28ed105877a2bce5), UINT64_C(0x34991bf483e9d546), UINT64_C(0x8e7c23628a5e5c57), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc4e4a09020313ef2), UINT64_C(0xb9345564d32561ec), UINT64_C(0x859eba7ba2fd2d91), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x25a9c7ca58125643), UINT64_C(0xf93a9b987e19400c), UINT64_C(0xcdc2f4a53d6e037d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe0e5dc217741f64e), UINT64_C(0xa4076b87de8764c4), UINT64_C(0x83458fc63ed03854), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x09c664f5ba92ea88), UINT64_C(0xf7ef052215adaa7b), UINT64_C(0xa822a2ca05cf864b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x113e7a21a60f2821), UINT64_C(0xda50ad828f795e9a), UINT64_C(0xd0c694a080dba672), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_23[] = {
  {{ UINT64_C(0x093358ad23aedfb6), UINT64_C(0xfcd7db6deb525eec), UINT64_C(0x8337a0fd8413eb82), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x21b4d1cc5fbbf6a5), UINT64_C(0x7079e8d457c9b929), UINT64_C(0x275e58197475d73e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x04f7af93c6437ee9), UINT64_C(0x06d6fd41556b2892), UINT64_C(0xad7fc41a19caf199), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1da0e2f799445b31), UINT64_C(0x855198ecdae4670b), UINT64_C(0xa3a40a1328761542), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0af970b7e9cc164b), UINT64_C(0x331fc724f4af641a), UINT64_C(0x9a7a63d7fb00d168), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaed2710815faf1a1), UINT64_C(0xe5bdc280a811f791), UINT64_C(0xee99b3cbb55dcdd5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7e26b1e594dcdee5), UINT64_C(0xa7048a6ce5143b3a), UINT64_C(0x26297f657906be7f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x444cd82367c908bc), UINT64_C(0x87211a96b0f096ca), UINT64_C(0x3c30713d1df771c5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7a8fb9e8ca0a2f98), UINT64_C(0xfd3f139c94c37aea), UINT64_C(0x61e39820d7ce98a2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e8f3fcfce44941f), UINT64_C(0xa527e05157228226), UINT64_C(0x9f2a8fd7dfe3425c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2bbe7015f76fd5ca), UINT64_C(0x5ecedd98aab5cd0f), UINT64_C(0x90dd38ca63a82e7a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3de96e7e7ad3f65a), UINT64_C(0x022e12ec04684472), UINT64_C(0x99a3eae9ad4355f5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa97338536963a720), UINT64_C(0xb4c5351b43fe49ec), UINT64_C(0xe8b551b09d5969b2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6f64a07e5f3ea021), UINT64_C(0x3002bd9b71e7054f), UINT64_C(0xe208990018ce0c2c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xca4601122a1a4a10), UINT64_C(0xa09379319fa0f6f1), UINT64_C(0x1442fd0e1373171e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4bb94a8936f7dd60), UINT64_C(0x65e30e528e7e2bae), UINT64_C(0xad58ca921d6d99de), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3fe4f69edeb02ca3), UINT64_C(0x827cb3b7d7861d8f), UINT64_C(0xf21acdb78812da2b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf904e5523f74559e), UINT64_C(0x0a5d1bf9590e498a), UINT64_C(0x401c7c2ec906c1b9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x48710613354ac9b7), UINT64_C(0xd7da16bc60c1ef13), UINT64_C(0x1936b4712973c115), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9379f67bcaa4961d), UINT64_C(0xd95f6f41fb3eb597), UINT64_C(0x5fbe887e927a13fe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x13114f2acba00741), UINT64_C(0xf98dddcddf786049), UINT64_C(0x4d72edf3e62e77b7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x66d529021a1cbd6a), UINT64_C(0x950540a672f1cbc8), UINT64_C(0xfb050603ecee8023), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3237a14d905abf19), UINT64_C(0x1ffb717451c525b2), UINT64_C(0x37088d95a892d59c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8e9615d7a7aa7802), UINT64_C(0x33eb23bb5eb4a1e1), UINT64_C(0xa549832d4df5e01e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e92545d282fb6dc), UINT64_C(0xfb9e3be509553e0d), UINT64_C(0xbfc26782dc31de2c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa0f9071945020734), UINT64_C(0x2f5f399876cdef14), UINT64_C(0x4b467b4b21ab04ee), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe533da1eb124d495), UINT64_C(0xf6d0b2eb400912dc), UINT64_C(0x673242d043403f09), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x46e0bc4c496b9d18), UINT64_C(0x3ee3f7622444abe7), UINT64_C(0x442315d65253d3fd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9f4c7b6c60f8d045), UINT64_C(0xdd812911f72613c8), UINT64_C(0xea5ea74083c2e077), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0758b5dcd422ac8a), UINT64_C(0x46cf91ac33196fdf), UINT64_C(0xaa9ce4247c1692fa), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_24[] = {
  {{ UINT64_C(0x353cd71e45b20919), UINT64_C(0xa3d5b43bbe3b3931), UINT64_C(0x30a80c1b5310a12d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x19fd2677f1ef0054), UINT64_C(0x3b654af000725635), UINT64_C(0x9b0b418192a0f5cb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb7a58fba0b072f13), UINT64_C(0x588272ab98eafffa), UINT64_C(0xc3d8fa31ab71dad1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc97aa9121e7c2bc0), UINT64_C(0xad0becafe6449f06), UINT64_C(0x4751c0d3e8cdb96d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x270746df09ec9d98), UINT64_C(0x25f61457db998a18), UINT64_C(0x987e308bcea1d2b5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x70baabc6125d934d), UINT64_C(0x4a02ef4d30e5b00f), UINT64_C(0x9af65bf03c23ec2c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x758a03fcba158937), UINT64_C(0xcfedf26941b828a7), UINT64_C(0x9c78a818e48e6c97), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd8ee2b6a96ab31da), UINT64_C(0xd75cd155dd318f56), UINT64_C(0xcfa85fe3775cfc20), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3a9bdce55b5e357a), UINT64_C(0x0bcbf1622459357e), UINT64_C(0xd93943d85c403967), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb9fa9cbdb13e9a78), UINT64_C(0x7dfad6c31317fe1e), UINT64_C(0xe4c9e38b4b9f0a3f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x82ac9966d0bf97c8), UINT64_C(0x03f34c5fe73b3f1f), UINT64_C(0x863bd28b01600eeb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5f0c0ccbdcbcbe0a), UINT64_C(0xfc2ef78a845788fb), UINT64_C(0x0381a1507900b176), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf1d0c5ecf7e52009), UINT64_C(0x99b046c52ba38a20), UINT64_C(0xf59162c6554ec122), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb2fc7b223c9b2208), UINT64_C(0x9b822b71b3c63646), UINT64_C(0x6458a1b454220bb3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4d0f74a81cb50ccf), UINT64_C(0x5c61a121b1e046ea), UINT64_C(0x75ab426a8333d085), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3440c2492d146285), UINT64_C(0xb4d16970d77671d8), UINT64_C(0x561448ae39731c42), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x51d44338138ef548), UINT64_C(0x75712fcdcef0a7eb), UINT64_C(0x26d636d555bdb24e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xff1517cd2a551d03), UINT64_C(0x18a054134723fdaf), UINT64_C(0xba229e1f4a1b37f8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x791bf707e96ee24c), UINT64_C(0x3124d1a9a6b35c02), UINT64_C(0x98fbd074912bbc53), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc25bf6e8f4e319ee), UINT64_C(0xc161112e0421f262), UINT64_C(0x0fb628b589fc2894), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe44465efea647d3f), UINT64_C(0x15f637d3c7678de9), UINT64_C(0xe511b2b317b063af), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd554012e0681e08d), UINT64_C(0xd0a46d06044af41a), UINT64_C(0xda828a52f03055e9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd2d694ce354bc988), UINT64_C(0x54074400c638e243), UINT64_C(0x5ebd2515fe0eb0e6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2c5ab88417ac5e87), UINT64_C(0x5ab6500a0fef4daf), UINT64_C(0xc77651b6c77d637c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb645b51245adb9bb), UINT64_C(0xa63a94aacb889aca), UINT64_C(0xcc777c3b7d7937d5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9c2ab555b4b79098), UINT64_C(0xee46acb8b9be18ef), UINT64_C(0x740c36e4dca3d0e6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe0349fe77b7e5adb), UINT64_C(0x0836fec1db59cbcb), UINT64_C(0xb1492ff0c5c43a12), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2393d2edfaa3d6aa), UINT64_C(0xc3ed17c75406fff9), UINT64_C(0x44fb1fbb643a614c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3d55b6d0e25d18f5), UINT64_C(0x66ae196d4272a5bc), UINT64_C(0xb16f92b773e113ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x17b3071462725850), UINT64_C(0x1d74142e3c685cd5), UINT64_C(0x4d876a4bf05b9d73), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_25[] = {
  {{ UINT64_C(0x7ebc2aaef5c0d1e5), UINT64_C(0xc7752defff7ed99d), UINT64_C(0x855b93b8642ff23d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x475f8d449a74ee90), UINT64_C(0x979fd6c3ab699217), UINT64_C(0x5f1e3b5cb6baf78c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x440907a65f7b27ec), UINT64_C(0x04c6c6433397ecf2), UINT64_C(0xfb06ec63cacbb771), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xccfc188d7ca4a44d), UINT64_C(0xf72f7807eb6bcf73), UINT64_C(0xe601f3a77088e89b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x55c25c1493773158), UINT64_C(0x295b83853e79282c), UINT64_C(0x465c9e8dc412ff17), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x327905457ccc955f), UINT64_C(0x7353da47e68996c3), UINT64_C(0x091a958766631a04), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x823d56711e6d371b), UINT64_C(0xe4e01650bd5e3589), UINT64_C(0xe5a04450083de453), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5e6fffccc3f692a0), UINT64_C(0xbe82cbf936db36fe), UINT64_C(0xbcb5838ce400f2d8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4729dd0a440aff6c), UINT64_C(0x8d9377fdb3ed99dd), UINT64_C(0x85de432fcf03b42f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x974e7e7db071b27f), UINT64_C(0xda9b3139cbd68af6), UINT64_C(0x6972020e3ef14689), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x009d1978af5a6b11), UINT64_C(0x17488b5e668b8304), UINT64_C(0x37061d921c15e128), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd001a7275eaa44a7), UINT64_C(0x393d42e380c7d3e9), UINT64_C(0x21a183a2e65220c6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x74cb0a7a5b1b122d), UINT64_C(0xd63f71507b6d6920), UINT64_C(0x757cc711fa8cc10e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc0e7352b769837c0), UINT64_C(0xc76f212ada2066b5), UINT64_C(0x53b1c4632ced21b0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xda7e587a3329a94d), UINT64_C(0x286e8bf41e1a32c0), UINT64_C(0xe12581620a64f6e9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x55cf51090b4d2352), UINT64_C(0xac4ce486972b240f), UINT64_C(0x703a5350463e6774), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x06469bc73926764f), UINT64_C(0x289af933cbd084d2), UINT64_C(0x17a55d4cf989e12f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x45f96e004bac0633), UINT64_C(0x83cbbfea0af867bf), UINT64_C(0x6ce68f03f56d7bb9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6c484aa1fc1ba2c0), UINT64_C(0xa1a6f9892b1f785f), UINT64_C(0x549c20ae23a2f368), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa04899f712425e50), UINT64_C(0x820355da6f9a59f0), UINT64_C(0x049223cca9c749c9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2b53589009082984), UINT64_C(0x11ba2fa2fa92069e), UINT64_C(0xe099f506577e8575), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xffb6cf37d90b3999), UINT64_C(0x99e0e8eab134e402), UINT64_C(0x958c74f368a2d6ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfb711509f16e2c08), UINT64_C(0x69f5fcaf2976238a), UINT64_C(0x780f6ae61aaac407), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9236f1cf658c4c2a), UINT64_C(0x22c6ea0d1e778c09), UINT64_C(0x08c110111692125b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x69985bba6044ec3c), UINT64_C(0xb85c0521c4320cc4), UINT64_C(0xf84e5494e1feaeab), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x671d29c95235d4aa), UINT64_C(0xd223d07e711617e2), UINT64_C(0xf15600d85231757c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1af63b49e007f41b), UINT64_C(0xc6a7abd1f876d40a), UINT64_C(0x397dff733aa4a01e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x93a45b3a827d8271), UINT64_C(0x2d2a86eeaee72e6a), UINT64_C(0xa6bd746df12b8939), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x780c18fefbe44983), UINT64_C(0xc8a9c5ee1672ea16), UINT64_C(0x1816ec313077a9ba), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x83348385eb45207c), UINT64_C(0x073c6b94fb8139fe), UINT64_C(0x29dce5a37dd7ab9a), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_26[] = {
  {{ UINT64_C(0xda1df3553f56f1ba), UINT64_C(0x1421cdbd21e2a8a1), UINT64_C(0x2069ab9a05e460ee), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5a668a83ef56651f), UINT64_C(0x53dc72880f2c3e31), UINT64_C(0x8177565c0d848b27), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9b200bf89d62f81c), UINT64_C(0x1e90c3835bf28994), UINT64_C(0x7b21fe54e9d219c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb6e66512f043a0e), UINT64_C(0xc84d79606818c1f6), UINT64_C(0xa025a8e7c51b4261), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa1617cb05565a3c5), UINT64_C(0x4ad355d6d1c619b8), UINT64_C(0xa9839e8ba030eb88), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8885defd982f586e), UINT64_C(0x2c5df9a987a30b02), UINT64_C(0xd4a8e987c94809c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1c19362fa7f89372), UINT64_C(0xb020297e568f4c24), UINT64_C(0x1faa4cd487e80a9a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x311e91f1d94840af), UINT64_C(0xec5b190a077f2848), UINT64_C(0x50ff93ef7c9581fe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x74a5e8bcaca299a0), UINT64_C(0xa8649b8c7d2bf9a5), UINT64_C(0x8f2fc3b4058d9a49), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5dd5a0d8e5a95c33), UINT64_C(0xd1b18f0445a28c2a), UINT64_C(0x1e69477e8158a8ce), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7e6b6a15523baabb), UINT64_C(0xb8fd1e0d1169c1ec), UINT64_C(0x92b88d6672099ceb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7731a3f289a4a018), UINT64_C(0x90d0513e6afdf9d4), UINT64_C(0xdf6dcea1e72cc3be), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3afb39b1438e85d0), UINT64_C(0xf0d417db778d7a44), UINT64_C(0xf85a66da2ed99812), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x897c3f074a45d94a), UINT64_C(0xe91ed61320815d79), UINT64_C(0xbcb34a342061d090), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd6b9b6da34d84212), UINT64_C(0x62ed33b0a25dd1a6), UINT64_C(0x652a5adf496c93cd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x579ecb822e2587fd), UINT64_C(0xf15364bd1505ee1b), UINT64_C(0xa454f7e4954752e2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeadd61c8720189d3), UINT64_C(0x37c6d0391602597a), UINT64_C(0x300b983da1a29232), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7d519c6e5c412b24), UINT64_C(0xb3e0092781850c4b), UINT64_C(0xafef316a1635f8d4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x657aea70cbf9c495), UINT64_C(0xce1ad35f1d03b620), UINT64_C(0xfc0de626306556f7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xff1627413e1050a7), UINT64_C(0x54534de8c0f7f1d8), UINT64_C(0xc7df653750a62823), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9a88cc885174391c), UINT64_C(0x4f919708bf3ae86e), UINT64_C(0x9ae2445a00cded5c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf9fe2cab475dee01), UINT64_C(0xf9362f59dcd99b07), UINT64_C(0x011abee9ab1165b1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x62d3183559c6739d), UINT64_C(0x7450bdac3d62bb4f), UINT64_C(0xf9e283e284de0eea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x34d054bcd13a62ea), UINT64_C(0x4906c28adab04030), UINT64_C(0x806fb41127a67e23), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8a1d71e176f3979f), UINT64_C(0xa249148371adcac6), UINT64_C(0xb350600fcdac42e1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5467ce86986fdae8), UINT64_C(0xf27683aa669eb2da), UINT64_C(0x859b1688b18056a6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x074123a655c9ecb6), UINT64_C(0x6cc554965a3a44e8), UINT64_C(0x0ac9ef05bfe6e07e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdb708a8b13043849), UINT64_C(0x98cafda1fc874f6b), UINT64_C(0x8d08ce8805f309f3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdb212d778137094a), UINT64_C(0xcb61f511e688040d), UINT64_C(0x7e2d6fac435d52f0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x183daef40da172b1), UINT64_C(0x499bbd730dd524ab), UINT64_C(0xe2d5f63af74edff7), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_27[] = {
  {{ UINT64_C(0xa2b5dffd69b58dd5), UINT64_C(0x2b51e36cf3aa15e5), UINT64_C(0x6967b01f2352c93c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa53ca4b7b50e8e2c), UINT64_C(0x2aaafc3a237bcf62), UINT64_C(0x53d5f9da87f38978), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x121be5a071990536), UINT64_C(0x15534af572d7114c), UINT64_C(0xb9f68d66b64c7278), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4580c876db2df0e5), UINT64_C(0x1f0acf9bbdc31b7d), UINT64_C(0x95198696353c585a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x529931ba90135ece), UINT64_C(0x596a348e0a39c363), UINT64_C(0xd9ec9a894ff0081e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4710feb0ea13281b), UINT64_C(0xe6d1868ee2c49655), UINT64_C(0x40e4fb443cb8bb41), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x84c64066c473bbaf), UINT64_C(0x743f53ea830a3b35), UINT64_C(0xe2396cb5f901e539), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd72ceed99c3d9d8), UINT64_C(0xdd2e2f9b08ac025e), UINT64_C(0x05c505751c4d0981), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x12f92af8fdc3b574), UINT64_C(0xc5ce70e4aa1d9c17), UINT64_C(0x51aade2aef71c7ed), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb5d55e7e6253d300), UINT64_C(0x79a80b29fe71f814), UINT64_C(0x4b2f8f86ca60d60b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4c79f49be4d9b471), UINT64_C(0x9abbc12419591d5d), UINT64_C(0xb03da552032dd64e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x84f9e0f00afb0c72), UINT64_C(0xefcf4ae7d6b75d67), UINT64_C(0xf6a0a2b39b159eb0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xace0ff7948c9c925), UINT64_C(0x0609a7344bb94fd4), UINT64_C(0x611b1e119aaa92ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc1a367f869689133), UINT64_C(0xc0e7573c9608771b), UINT64_C(0x1bcd12b257cfbf2b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71a51c4139102d5e), UINT64_C(0xd60b17ff874cb6d0), UINT64_C(0x565d217fcf0d6b75), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x99945e3566532593), UINT64_C(0x743f5b1a59635ec2), UINT64_C(0x033e797c8389cfe9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x629e4bcefde8fc62), UINT64_C(0xbc483955c3698089), UINT64_C(0x6d65bb540a7961f9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7fd742bb633fbbc8), UINT64_C(0x7f40269ba618effc), UINT64_C(0x6d7a955cc7adaf81), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xda6dc8b43a96ef69), UINT64_C(0x01f4704ecb10b308), UINT64_C(0x0b133acd5d6c7e1c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa71fe313754ff7ef), UINT64_C(0x11ca1be6d6985098), UINT64_C(0x70b6a7f8ff63f075), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc77753275c7cdd3d), UINT64_C(0x4f84b1e0dd827baf), UINT64_C(0x975a2f41f337bc31), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd79f1329be03413b), UINT64_C(0x48ef048d72d5ead5), UINT64_C(0xc48152feba1c415c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0b1740444fafa19e), UINT64_C(0xc5e8d7058008d869), UINT64_C(0xc44a5a998625e8cc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xddf689875f4325c1), UINT64_C(0x06794fb6eb6db4ab), UINT64_C(0xeb1f49402885fe6d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9a9d450b76234e2c), UINT64_C(0xa2369749f72c90eb), UINT64_C(0x73ad89128a2a8e7f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb1cfcbfdbc939416), UINT64_C(0xe67a862eb7c21c08), UINT64_C(0x1650ca80d7a44e3e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb6e47dbae8b1ceb), UINT64_C(0x3d67de8b9393c05d), UINT64_C(0x33f85bdd5e4ce269), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x520486f7d010f26c), UINT64_C(0x3964c5ec2bff712f), UINT64_C(0x4e28aafbe11942f3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd34e78be300aefaa), UINT64_C(0xe67de2dbd1d96ce0), UINT64_C(0xf0d16595731f04a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0245fd6ddd428558), UINT64_C(0x06d2da42ece61580), UINT64_C(0xe8b87f45d363971a), UINT64_C(0x0000000000000000) }},
};

static const block_t Zi_28[] = {
  {{ UINT64_C(0x2cc4344867117800), UINT64_C(0x3846ecc8815e97df), UINT64_C(0xee4f2fd2783d867a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb10bd7d17ba237d6), UINT64_C(0xce041e2f738676eb), UINT64_C(0xe75ef2c3b8f753c5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4dc1b078db7e6be0), UINT64_C(0x8fb04f61f2f90598), UINT64_C(0xf0b47bc94b24b1fc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xabc9ceb3c8973472), UINT64_C(0xae2bea45739aec74), UINT64_C(0x83297e5151bd7fd0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x56abb3fda50c1c82), UINT64_C(0x505e33988d5947e6), UINT64_C(0xa79e5eff52310104), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x94a60368084b78b7), UINT64_C(0x273c95cb9c7bbebc), UINT64_C(0xcd71ef34cedfaaca), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2a5b8cca146fd92e), UINT64_C(0xa432a54ccaf9c5cc), UINT64_C(0xd5c914114b63652b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa0c87b452ef19830), UINT64_C(0xc739fe0a8b96905b), UINT64_C(0x9b755424558443ea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e7e4692da647d99), UINT64_C(0x21022407003c04b0), UINT64_C(0xd744d8e48737d5b9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb6befbc92e417b18), UINT64_C(0xfe0f02ad87827be3), UINT64_C(0xb97b91cf31cce13c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd233c35165535938), UINT64_C(0x80d2e6b859124684), UINT64_C(0xfd7eb052516f031c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x00d24f4b019e2d6f), UINT64_C(0x86d1659acc5f06a6), UINT64_C(0x919639606ed21af5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x90bb92c7dc1699d3), UINT64_C(0xb8cdc9378a4a1518), UINT64_C(0xb90f455adaf4412b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0c67fb3eb0da2af9), UINT64_C(0x3f0831e5e4752ca9), UINT64_C(0x3b4415265df3501a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc2071dae01219e69), UINT64_C(0xbc3a1921305d6a6b), UINT64_C(0xb8c670aeb05414c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x29346bab99b44342), UINT64_C(0xe3e4ccb1ebc782a6), UINT64_C(0x3eebcd3e09ece313), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa1cf429988447dac), UINT64_C(0xe60906a31130ec6d), UINT64_C(0x8b7c7059117a4c92), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd54ec3434fa0bd5e), UINT64_C(0xd7bdf0d231b124af), UINT64_C(0x5788b85266a27a83), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2150a07b295db06a), UINT64_C(0x2d33e8a936dbf64e), UINT64_C(0x4d18c7d9fbeaee5b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xea214b7ede07f5c4), UINT64_C(0xb518441578e84d60), UINT64_C(0x4307979f5334fc1a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb207c0e4f99effbb), UINT64_C(0x6e8fbd62cc9dba44), UINT64_C(0x6c38317bc9f45659), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9068ec48dc3cd61d), UINT64_C(0xc1ff239587ac0023), UINT64_C(0x15bd66e019684428), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9d7c813f565cf08a), UINT64_C(0xef0829b7b00da572), UINT64_C(0xb25f3b5f12bf7718), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbe0c72c2d6d17e71), UINT64_C(0x4f4fa41283289bca), UINT64_C(0x52742204da55caf7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x95a0050916581245), UINT64_C(0x6a2e74bfb214fdde), UINT64_C(0xd5bc20e6cee3922d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x18de77e00c69339a), UINT64_C(0x7c8300fd50f0d6b8), UINT64_C(0x9a74c97529423217), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x22b701f29d227c15), UINT64_C(0x1cde9f540a15f4ee), UINT64_C(0x762bcb0a4eec2efc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9f0e88e9e0a5ec7e), UINT64_C(0x7d3cdc8f936a327b), UINT64_C(0x7182ef5d731b1a6c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x839f7dd6df3d338d), UINT64_C(0xc746d088a10c2999), UINT64_C(0x4de3d85944030365), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x85578c4c6df7c86c), UINT64_C(0x3c9ed7caf3890f64), UINT64_C(0x6207ab7ad2231434), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_0[] = {
  {{ UINT64_C(0xbdd39b6005dcbe97), UINT64_C(0xb655bef040431161), UINT64_C(0x0000000045475e44), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe129b47e5e3a3ffd), UINT64_C(0x53e823136e9a25b2), UINT64_C(0x0000000047876274), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x747ffd12e053d40b), UINT64_C(0x17cf1bd91ab959c4), UINT64_C(0x00000000b9b5debc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xde5d09d7baa688b4), UINT64_C(0x77035d37a58df743), UINT64_C(0x000000011cd993c3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x09b4091237d6b918), UINT64_C(0xeb5f3d3cfa0073e6), UINT64_C(0x0000000352246293), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1ce2ccdc006957f4), UINT64_C(0x574d880894d3cd0a), UINT64_C(0x00000003bfe9c4aa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1f2fd1c3b26baa27), UINT64_C(0x63ade79982e42873), UINT64_C(0x00000002253ec87f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x744e9d8e60cb5283), UINT64_C(0x7fc83a335a57d685), UINT64_C(0x0000000185579f04), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfa13c1bafa41914c), UINT64_C(0x5c758dde91d745f4), UINT64_C(0x00000003a3b13070), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaa30cdca4ee4a848), UINT64_C(0x511e0b33abeff3fa), UINT64_C(0x00000003a87a134e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7b8afce436b23c6c), UINT64_C(0x3962a2adf58bffc8), UINT64_C(0x0000000239abe5e7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf1bf023bb611f802), UINT64_C(0x04d55f38f3777fad), UINT64_C(0x00000002fdae7bac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x84a59957110309ef), UINT64_C(0xbeadce27db95f043), UINT64_C(0x0000000075164f94), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf877452c61a2bd08), UINT64_C(0xc4c8d6171032e0c5), UINT64_C(0x00000002cef9f878), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xad601fb7e50a5895), UINT64_C(0x1293db4fb5b1c029), UINT64_C(0x00000001cee7f3c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5e91134b045c563b), UINT64_C(0x1b48079203966b4d), UINT64_C(0x00000001d41057d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe8c7ffba4b94dff), UINT64_C(0xd05849d771e1c89d), UINT64_C(0x00000003a85a9965), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x02a8932b69b72e45), UINT64_C(0x214f3f005c5c7d86), UINT64_C(0x000000016fe23a18), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf49efb3339ddeeb8), UINT64_C(0xd6a499fe57b52036), UINT64_C(0x000000025d049ad2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7c354bbdf504980f), UINT64_C(0x5a718ade83d8a43a), UINT64_C(0x0000000291774b48), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfeb9a198bad69e91), UINT64_C(0x7e8795b8712e6efb), UINT64_C(0x0000000236f012df), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc76333bf6dcb91d1), UINT64_C(0x0ffce5339134f5b4), UINT64_C(0x00000002e9d0de0e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7a2def53118f7b94), UINT64_C(0x8317c0f150b263f4), UINT64_C(0x00000003d74eaefa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x179cfd446b2f0578), UINT64_C(0x879b1cd733cf1564), UINT64_C(0x000000008a579168), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xadd30ca9f53a4b37), UINT64_C(0xceda76afd3427b77), UINT64_C(0x00000000fcd0fea4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x641ead4eb4a514cf), UINT64_C(0xaf27c93fbe5a10c9), UINT64_C(0x00000003a0301c90), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x08ae9af66a101a92), UINT64_C(0x55ed91268de74f35), UINT64_C(0x000000018f720115), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x80f1953cc3c81567), UINT64_C(0x90b5acb8e2806a71), UINT64_C(0x000000014475e765), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd4e2109229043597), UINT64_C(0x40af48824a6541ce), UINT64_C(0x0000000360582d0f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6a0cca6dd6ff731d), UINT64_C(0x2ba2ecc1d87c4a56), UINT64_C(0x000000002a132bb7), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_1[] = {
  {{ UINT64_C(0xf139702bcc9df085), UINT64_C(0x983f3206408669fe), UINT64_C(0x000000009d78b30c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x24bd242c067d2238), UINT64_C(0x3d7c4780091232c2), UINT64_C(0x00000000b946f33c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa79fbddd2e1ab3a0), UINT64_C(0xf3f5f916e9e5e7ef), UINT64_C(0x0000000160ba809d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd8ef45768e4db9a4), UINT64_C(0x0b14fde84452b78d), UINT64_C(0x00000001366a9017), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x233829048367d17b), UINT64_C(0x040f1cc34b85d109), UINT64_C(0x000000002e2c0fe3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb04d10894c981b68), UINT64_C(0xf94155b90fa3dbba), UINT64_C(0x00000000bab0f6fa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf697ea7e1d0e642d), UINT64_C(0x5ea4b29d8dc5b007), UINT64_C(0x00000003d5a4c361), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x75d97e73d4535107), UINT64_C(0xe097588027d5eafd), UINT64_C(0x000000039e38876c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaa13c57e52d842aa), UINT64_C(0x6a1175117795ac18), UINT64_C(0x00000002301dd92c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd812a78399edfd87), UINT64_C(0x18a771860959bc59), UINT64_C(0x000000029d36acce), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc3835fe0678bbf2f), UINT64_C(0x9c00b59065c24e15), UINT64_C(0x0000000376f4b433), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x31f7540535dd1b32), UINT64_C(0xb740b8649110c947), UINT64_C(0x00000002f26ee8a2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x922bb54aef7d80c1), UINT64_C(0xa4a0e963587c1a92), UINT64_C(0x000000005544015f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x67c23d0c6ee235bd), UINT64_C(0x5a65d1a73e57eb25), UINT64_C(0x00000000fc9964ef), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3d87df3b6f55ef1b), UINT64_C(0xe7b200ae1c7ebcfe), UINT64_C(0x0000000391f3370d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa72d0dce7b80cfc5), UINT64_C(0x0d4db8b3fe41d410), UINT64_C(0x00000000fcf19643), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf85b4ab97fb19cdb), UINT64_C(0x125a20244ac34d55), UINT64_C(0x00000003795ceaa1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb911b9ce033373e4), UINT64_C(0x9fe87cbb979dbe74), UINT64_C(0x000000032b41222f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb360d1229902b7de), UINT64_C(0x8136b4147545f4cd), UINT64_C(0x00000000e50a56f0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xddfa1ab51a42b026), UINT64_C(0xf81b2b9ff557fc36), UINT64_C(0x000000036c979569), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3568af2b7d140ff5), UINT64_C(0x465d72cce4049678), UINT64_C(0x0000000096f3841f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x669ba6e9d2a6dd60), UINT64_C(0xefe2c4df373d3f1a), UINT64_C(0x0000000027c3696c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb95156c8b308aad1), UINT64_C(0xd7a41623d4bf73ef), UINT64_C(0x00000000b65040d6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x20721af122456c38), UINT64_C(0x3c7a36cfa3e7fb01), UINT64_C(0x00000002e8bef92c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x981a0191fb9a8cc5), UINT64_C(0x53450982cef8576f), UINT64_C(0x000000028f2aa469), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5b952443bd7fcdce), UINT64_C(0x8d58f90b36389e10), UINT64_C(0x00000003b2424baf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x12f0dc20dcb2890f), UINT64_C(0xa9f757a8fe27ef30), UINT64_C(0x000000035c6091e8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f0c372ffb89052f), UINT64_C(0x7b95276e73a655cd), UINT64_C(0x000000037f5c3a9f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb32ae245a387cfa), UINT64_C(0x929f2e063c703d48), UINT64_C(0x00000002777a8722), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xefa354cd73e8bfb0), UINT64_C(0x54659ec6731e06f2), UINT64_C(0x000000026e118dd3), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_2[] = {
  {{ UINT64_C(0x7583fbf447473839), UINT64_C(0x6449bd416413f1dd), UINT64_C(0x00000001abfa56f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2c6b2af161db7fd4), UINT64_C(0xaca1a442db965eb6), UINT64_C(0x000000005425dd5b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe66ff67dd98df209), UINT64_C(0x4945f98828f6d41c), UINT64_C(0x000000038e00ac18), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc8ce6b1bb7952558), UINT64_C(0x31711c43fa0693a1), UINT64_C(0x000000015698feed), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x312e6ba20c02ff8a), UINT64_C(0x8830d7bfcd801caa), UINT64_C(0x000000030c3cc8ee), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x96b798022dc05ced), UINT64_C(0x51b5f49a02af7cb1), UINT64_C(0x0000000294d1f1de), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb41ddc4c5f6e00ee), UINT64_C(0x61963aec7c9c61fd), UINT64_C(0x000000023af859be), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc70baee063da4074), UINT64_C(0xde4f6c384599660d), UINT64_C(0x000000021394bbbb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc41e41a7edaf088b), UINT64_C(0xa962d7bd255a99d5), UINT64_C(0x0000000063004b2f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x36656c3370ed9a23), UINT64_C(0xc86852fae8da83d3), UINT64_C(0x000000023354e9c7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x69e4bed19e1bf1dd), UINT64_C(0x09939d6950c985d9), UINT64_C(0x00000002590bbfe8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa11b0b36ebc701fc), UINT64_C(0x0494840cb61dc082), UINT64_C(0x0000000379e0d8fc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x84290a09b246ecc3), UINT64_C(0xe2626c8fae5222da), UINT64_C(0x00000002fbed6105), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7b56668843bfde9b), UINT64_C(0xde6ff0cd533b1416), UINT64_C(0x00000003566dffc7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x85d07ee5d31fc5a1), UINT64_C(0xf9d3ef148afaab80), UINT64_C(0x000000035ddaa455), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1c75111010a2f0c6), UINT64_C(0xb1cdb652bcaf1d62), UINT64_C(0x00000001007f3cb1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6161c7bcaaba256f), UINT64_C(0x172b5a178e37d8a4), UINT64_C(0x000000001d307d95), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x940f9b3d70b4e384), UINT64_C(0xf292bd461a06f027), UINT64_C(0x0000000378be6b73), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5ee01af241a467b0), UINT64_C(0x3d86fb60b127cf55), UINT64_C(0x00000003130d4089), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x842653eccd6f7de7), UINT64_C(0xdd0911acc5c85776), UINT64_C(0x00000001dcd7abc9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2747662062671c0e), UINT64_C(0x35e73153c0a55d63), UINT64_C(0x000000010f4bee2a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbfc6adc3de8825c3), UINT64_C(0x623fa4bd192ac4ab), UINT64_C(0x000000002bf4d21d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb5cec8aa7e59ef5c), UINT64_C(0x7cdfb6a771a3dd20), UINT64_C(0x000000036c931fbb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6886cefe957210bb), UINT64_C(0xe490fd3e41d2fe85), UINT64_C(0x00000000acc99218), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe450435ec30e4999), UINT64_C(0xb2b8ed619459f334), UINT64_C(0x00000003b544131a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x34d5e85d604a3826), UINT64_C(0x80861f0987861549), UINT64_C(0x00000002e6ffb012), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0fcdfdf161494435), UINT64_C(0xc0ef639bdab5ab0c), UINT64_C(0x00000003b0510f3d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9eaf64ae6c0f9026), UINT64_C(0x17eb98c55196c0d5), UINT64_C(0x00000003635676a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf8406e6f38f6b03c), UINT64_C(0x7322c231b355dc32), UINT64_C(0x00000002db401203), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xebb4e8892b21fd29), UINT64_C(0x69ff9cf866a1626d), UINT64_C(0x0000000062ac4911), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_3[] = {
  {{ UINT64_C(0xd1c6aca70faeab8c), UINT64_C(0x7e04d67067efa3e9), UINT64_C(0x00000000cc323a8a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5f66d6cdabf30125), UINT64_C(0xd7eaf6df6f2c0546), UINT64_C(0x00000001ab56ad21), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe8c92856299db414), UINT64_C(0xeaa61f7e5fdca1bb), UINT64_C(0x000000017eab8ab8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x04ff8dd33b73e96b), UINT64_C(0xb9b2fbb306664fc7), UINT64_C(0x00000001d26e7009), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd03823dd5fc3fdf), UINT64_C(0x4295bdbb4da16fc0), UINT64_C(0x0000000148215011), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x24a86e50d5372cc6), UINT64_C(0xd61691721be099f8), UINT64_C(0x0000000010ffc426), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x841dea9604ada703), UINT64_C(0x9af6c4f64fd6e547), UINT64_C(0x00000000ee282ade), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xff8cd31a3cbe79bb), UINT64_C(0xc75a2a8dca1a544c), UINT64_C(0x00000001216385d2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x109a18824d5ff28f), UINT64_C(0x93a3042cbc635e49), UINT64_C(0x00000002e16da57e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb8bbb616c52278d9), UINT64_C(0xb136837970ff363a), UINT64_C(0x000000038f37e0d6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf2b3cf0790bfd0aa), UINT64_C(0x4684240c62ebe97f), UINT64_C(0x00000003a2148579), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x67698c280ab511dd), UINT64_C(0x75fd28a437408cae), UINT64_C(0x000000035fbede7c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x299cada9a17f0dbf), UINT64_C(0xe7271154e06b551b), UINT64_C(0x000000002009b249), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb4c5398e605cf4fa), UINT64_C(0x1b6040a896d6d1b5), UINT64_C(0x00000002c7768003), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfed7b165ffac5019), UINT64_C(0x5094a3d47278d815), UINT64_C(0x0000000161c094ef), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6648565542f2cc57), UINT64_C(0x1b9a36580cdc867b), UINT64_C(0x00000003d0862d24), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5a0698b9b2efb3bb), UINT64_C(0x85165a6d95aa4983), UINT64_C(0x000000038530ae05), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x91ed8400cbc210c9), UINT64_C(0x5f06e434e48b18f4), UINT64_C(0x0000000221396ebd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8362301c324e7a0e), UINT64_C(0x81037a62a0b9c97a), UINT64_C(0x00000000ab7033b6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb11b1452a6ac41f6), UINT64_C(0x67ba9fb3fab8a05e), UINT64_C(0x000000036681ae93), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x67aed8e3108a6443), UINT64_C(0xe804b12a776f4c2e), UINT64_C(0x000000021894ba9d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1b21911dfd7617b4), UINT64_C(0xf4ce4511f789592b), UINT64_C(0x00000000cb5afb46), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x21d1cda889423c4c), UINT64_C(0xe6607f959fa25bd6), UINT64_C(0x000000035834d162), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6b4a00dbd1778004), UINT64_C(0x19b409a146f4f9a7), UINT64_C(0x0000000233a64e52), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3279467d7262d579), UINT64_C(0x270444b184e9c8a6), UINT64_C(0x0000000042d5746a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x79e6f37420440f0e), UINT64_C(0xcdd138ed92c303b9), UINT64_C(0x000000022e04bf65), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x30a40ff4c4eb4a79), UINT64_C(0x5dcd73cee3021c3c), UINT64_C(0x000000031d86901e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0c2b2f6db40c3875), UINT64_C(0xe33afc738b16f291), UINT64_C(0x0000000324bac5d9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7844d3763aa3c0a9), UINT64_C(0xe32996e0b7683ced), UINT64_C(0x000000000b6247b9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9f045591ea50d97b), UINT64_C(0x960449012bac90c4), UINT64_C(0x00000002b3856bb2), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_4[] = {
  {{ UINT64_C(0x2f51e4f2964e54ab), UINT64_C(0xff7d542ee54d7d27), UINT64_C(0x00000000acc688a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd93863740a019e38), UINT64_C(0x6b47d8f8bc9a4e9d), UINT64_C(0x000000000841d44f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5c8ed8d5875345a8), UINT64_C(0xe37ec8961a62c737), UINT64_C(0x00000000031ce7a2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8ee51d06cfa5df51), UINT64_C(0x9a4743bb62d92912), UINT64_C(0x0000000105344935), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x701424e7f37a3838), UINT64_C(0x22319f47658d6471), UINT64_C(0x00000000afe833b2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdca9f2d01fcbbb9c), UINT64_C(0x1f9003041aa02d8d), UINT64_C(0x00000002e14ddd56), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0d505bc13e3a3b28), UINT64_C(0x36acc37de0911db9), UINT64_C(0x0000000085eff9b2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe7f176e91936f37), UINT64_C(0x17aa4cae8489d0fa), UINT64_C(0x0000000175e48316), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x60b2082dfd726ee8), UINT64_C(0xc2716c2d118707f7), UINT64_C(0x000000037271c28b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc49371ee6418f5ed), UINT64_C(0x2f4a30734a1349b8), UINT64_C(0x00000002dafd2557), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdc6740c6ec560fe8), UINT64_C(0x75ca359cbcf35b2c), UINT64_C(0x000000032329d54f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x25c7fa3739290b93), UINT64_C(0xdfd7b99d3b5028ae), UINT64_C(0x0000000273fb34ea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x97577498d67a5e2a), UINT64_C(0xb9e6d8adb9c8e2fd), UINT64_C(0x00000001f8a85870), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc39c2b3b33689fb6), UINT64_C(0x11d687059edaf925), UINT64_C(0x00000001c42ee924), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa092ba09a0bacb30), UINT64_C(0xed85570c070c4c3e), UINT64_C(0x00000002882fa4dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfc6ba53ddebf4c8b), UINT64_C(0x172fb2165922cfbf), UINT64_C(0x00000001e9c8b224), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e51264842f74f77), UINT64_C(0xc07f7b7af7323e56), UINT64_C(0x000000000e71c3ca), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0252987b55214c3d), UINT64_C(0xb08b0da523bccd15), UINT64_C(0x00000002116b83d9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x73097921ae24886c), UINT64_C(0xa0171c9f2c3b0611), UINT64_C(0x0000000240976ea9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcdf14ff4e0cda025), UINT64_C(0x084dc64a41f2c582), UINT64_C(0x00000002738251aa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaa9a6e55c84694da), UINT64_C(0x26542a360bbe353b), UINT64_C(0x000000004e191330), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7add652451f0ce92), UINT64_C(0xcd73923c7feee998), UINT64_C(0x00000001e0004fd9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x46b97e5d64a28e84), UINT64_C(0xc6962be1ca7cc3eb), UINT64_C(0x0000000386cd9315), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd8b353afcf1e2f80), UINT64_C(0xdba5044898f51820), UINT64_C(0x0000000375047c9f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb89fc8a03a744eb6), UINT64_C(0xd3c8fc24d93a152a), UINT64_C(0x00000000f22e1461), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7884bfa911a9cd86), UINT64_C(0x3363700f66eca9fe), UINT64_C(0x00000002adc704ea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2b10b18c77dfb825), UINT64_C(0xb63956ee39003ff0), UINT64_C(0x00000003865299fe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xea5f295d456fea63), UINT64_C(0xf40d062d3cc146d0), UINT64_C(0x00000001a4061791), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2f94869e33a8b32b), UINT64_C(0x82987c7625c4d30e), UINT64_C(0x00000000bbf2c6f8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x532d14870b2ee670), UINT64_C(0x8b260728cb9c5c53), UINT64_C(0x000000030e49ed06), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_5[] = {
  {{ UINT64_C(0xe5f6ee7dad29861d), UINT64_C(0x4ab24407e8d1dbcc), UINT64_C(0x000000000328aebf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x37eeb11718161523), UINT64_C(0xbfdd74c00c4d9dce), UINT64_C(0x000000007a2e9580), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb2c3df3d3063f0ce), UINT64_C(0x684f56b223808be1), UINT64_C(0x00000000f28f510c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbe8e01f7fd407a20), UINT64_C(0xa659bddc1b3cf7b0), UINT64_C(0x000000007a8f96aa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x246b390c3aed7bb6), UINT64_C(0xd0ff0f38a34a269a), UINT64_C(0x000000022f1252de), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x803473a3fda001b6), UINT64_C(0x4dab6db0f1620a5e), UINT64_C(0x00000000c9ceae1c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x583fcbf90b7e0fe7), UINT64_C(0xc321b9752826b757), UINT64_C(0x000000011129c4d3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6372a6b632114222), UINT64_C(0x141b13c25fef7872), UINT64_C(0x00000000fb5ceb7b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xede8e326b8981951), UINT64_C(0x5726368ce892a7a6), UINT64_C(0x00000000ebd83740), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8b08606c23c89fd5), UINT64_C(0x7e7d4d5b0085bce5), UINT64_C(0x00000001d53f97e9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe8912f880fb1623), UINT64_C(0xf583607c0011f212), UINT64_C(0x00000003596263c7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x505cec7cd23a009b), UINT64_C(0x008e3b42b121ad50), UINT64_C(0x00000003d5e0ad40), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x26105d2a591b4a91), UINT64_C(0x497a2bcfa6c545d8), UINT64_C(0x00000001ef9584f9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfac2570401c518df), UINT64_C(0x4d648f57f262e736), UINT64_C(0x00000002737afc63), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x24dbedf1717f5f99), UINT64_C(0xdbce4c47285252f4), UINT64_C(0x000000021c2a8f6d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x977344fa880feb29), UINT64_C(0x11aa5b498cd38ec9), UINT64_C(0x0000000038cfbc82), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x990ecceb5d380b43), UINT64_C(0x4621c3ea854c1ea5), UINT64_C(0x0000000029ca45e9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3527d6ad91d9493a), UINT64_C(0x39b3f97f6f1f4f48), UINT64_C(0x0000000017c8e8aa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe7c11c188805fc35), UINT64_C(0xd3214c077234f360), UINT64_C(0x0000000044a16081), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5033ca0ff7230ca3), UINT64_C(0x7ff9c38bd4ad7cdf), UINT64_C(0x000000011519b69c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb08af842a4073a63), UINT64_C(0xa699c048eacc36ec), UINT64_C(0x000000013f15cd3f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdb99f5ec92ddbcdb), UINT64_C(0xd72e4d950b0e45e0), UINT64_C(0x000000029f1ec435), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf222e3d97992fc04), UINT64_C(0x467121738698ecc2), UINT64_C(0x00000002c39a1949), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe7249fcc502f2078), UINT64_C(0xe128fa18d7b02ca5), UINT64_C(0x00000002f1d9b21b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x68d0accbcc1978fa), UINT64_C(0xfca4f9fca6328e29), UINT64_C(0x0000000186d6d87f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x33222e649b8b8b27), UINT64_C(0xf7e10a6049c476ad), UINT64_C(0x0000000146282682), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x11e0f64779baee97), UINT64_C(0xce7faf3652922779), UINT64_C(0x00000003c0037dfe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x97ee4501201569a5), UINT64_C(0xfa4cbfa254b90e99), UINT64_C(0x000000014e65861f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb318480f352c573f), UINT64_C(0xf40e07c7c69b5d03), UINT64_C(0x000000009ec962b3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x12d4df124eff2392), UINT64_C(0x69d4c5ffc2a75788), UINT64_C(0x000000015e54710e), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_6[] = {
  {{ UINT64_C(0x05b8571ec1e1fe3a), UINT64_C(0x06ea40cc40cb4079), UINT64_C(0x000000002765a358), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf778aaffa0065221), UINT64_C(0x9f6dc9548f55948a), UINT64_C(0x00000000433e8020), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x701de0eb89f23403), UINT64_C(0x66ce0def290d67be), UINT64_C(0x00000000da211ee6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd6f18fcf58d955ef), UINT64_C(0x000d11029e5abd09), UINT64_C(0x00000001cd3285b0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc7a83df0037a4571), UINT64_C(0xb78cbaa876e84c50), UINT64_C(0x000000018b3787ee), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8e43443cd3f1b100), UINT64_C(0xfb3929ec03db9951), UINT64_C(0x00000000278733f7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xec8d5370be1c5816), UINT64_C(0x735c1279b88f01c3), UINT64_C(0x00000002bed59c89), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe8ce1751b0dc52b4), UINT64_C(0x7de6de15bcc72d37), UINT64_C(0x00000001763e99c9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5949922219492e2e), UINT64_C(0x7d2d77200bbe63be), UINT64_C(0x00000000e5e69f65), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x601c4ba564cf22da), UINT64_C(0x5e2b2d4a24408125), UINT64_C(0x000000012a287285), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe5eb7d4656bf5562), UINT64_C(0xb5d8d69f88da1c9f), UINT64_C(0x0000000021342c21), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x66520537e6b8d77a), UINT64_C(0x1a8bc2696664cbec), UINT64_C(0x00000003dc51e5a9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf37497bbe14aa138), UINT64_C(0x3c2556e286d98677), UINT64_C(0x000000039f23542a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7d0bc993a8c494c9), UINT64_C(0xa5e61f3cb17b3ed6), UINT64_C(0x00000003e3866376), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd55026a6ef5b29fc), UINT64_C(0xc40c67419ed936fa), UINT64_C(0x00000002ada04532), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x15e9b706ad3fc0c6), UINT64_C(0x6bee8e220de309f7), UINT64_C(0x0000000391415209), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe8cb88db7d6383e4), UINT64_C(0x9a6669827767c542), UINT64_C(0x000000028b534976), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x59e5e3c50364ec48), UINT64_C(0x4d32e51c9f29b3ec), UINT64_C(0x000000004748231f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4ce1eaecc7928b55), UINT64_C(0x11e5c5af618cb78a), UINT64_C(0x000000020c6bd790), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1bdfffc8c875d1d8), UINT64_C(0xc21dd5488df9d53e), UINT64_C(0x000000034931e2b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x251ad980c27706d6), UINT64_C(0x6662c776102d7a9c), UINT64_C(0x000000017eb0d49c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x72dbf7e7f7df1b50), UINT64_C(0xa8671b5bc903d616), UINT64_C(0x000000035e8f3d1f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2e46dca18035aac1), UINT64_C(0x639f8b7def2096f7), UINT64_C(0x000000015a4233f8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbc25d551fd122394), UINT64_C(0x0db22632511ad581), UINT64_C(0x00000003a3a17cd3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbb81926d4ad12e81), UINT64_C(0xc6e199521ac3ba18), UINT64_C(0x000000005e4c115e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e4338c3c37761cd), UINT64_C(0xd2ee3b84852f377a), UINT64_C(0x0000000278054510), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb96879da7bbe4afc), UINT64_C(0x02996108499c65ed), UINT64_C(0x0000000234037c36), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x88c4d13160734456), UINT64_C(0x810d81ecf07be532), UINT64_C(0x000000024edba9e9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8fb287df3d9dfa90), UINT64_C(0x65f54819e2127793), UINT64_C(0x000000034e7f95b5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5fea1c7288c65afd), UINT64_C(0x2c64a099f39f8a83), UINT64_C(0x000000000fa5d5b4), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_7[] = {
  {{ UINT64_C(0xe4b431c6e1a8985d), UINT64_C(0x2ea4951f5e3deb71), UINT64_C(0x0000000055f79e05), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdcec9e2191ecbc29), UINT64_C(0x539f4169bc938dd5), UINT64_C(0x00000001b8e96df2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc3a9c00e8d43dc6d), UINT64_C(0x82b86e2260c17694), UINT64_C(0x0000000300879f1c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9469c82e7a2281f2), UINT64_C(0xce526933257598e7), UINT64_C(0x000000004f2e64e7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb15cf30f8ecba0d4), UINT64_C(0x4d46e881a0f80040), UINT64_C(0x00000003c9ad5e01), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5012490cd4352a69), UINT64_C(0x6bfff930c6bad925), UINT64_C(0x000000002043107c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbf1b8d9185e704c6), UINT64_C(0xf7f5e38b73f686f0), UINT64_C(0x00000003cfcadb54), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0fbbf05702423fb2), UINT64_C(0x2cbc2a6962e0630e), UINT64_C(0x000000011998ee2d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x28276085fadbd0df), UINT64_C(0xa0d697792a27225b), UINT64_C(0x00000001cfcd0163), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x17deb617bc7cb9a1), UINT64_C(0x647b8c1ecd9c2f56), UINT64_C(0x00000001a977bbbd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8daa8e9c3a0fe6ed), UINT64_C(0x5fd70a4a1f20f7c5), UINT64_C(0x00000003fa3eea27), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc49aa75faa5955dc), UINT64_C(0x3f8f5e1b4fa765ec), UINT64_C(0x00000003297026b1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe53dff7ba5554e98), UINT64_C(0x9fa487c625d85ae0), UINT64_C(0x000000017eea0924), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5c5dc0abfdf19d0e), UINT64_C(0xa9d8a74de41c5338), UINT64_C(0x00000001875c807f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0eb2011a528b76aa), UINT64_C(0x017b746f0ed5da3a), UINT64_C(0x0000000056ee2395), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x936a048e9b8b091f), UINT64_C(0x617e7384b779e605), UINT64_C(0x000000011c558483), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4f770b5d62a0950c), UINT64_C(0x023e87aa908d7d43), UINT64_C(0x000000020c08ae56), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4d68a73628655034), UINT64_C(0x580a033055cda276), UINT64_C(0x00000000f6b9cb6e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2ca75d947e003f25), UINT64_C(0x8f03835f1f6fc82a), UINT64_C(0x00000003f15b059f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x77024b54120d0924), UINT64_C(0x354797e992a7d120), UINT64_C(0x00000002a2cc8ec6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x707d45ed34561867), UINT64_C(0x674bbe8be6aff644), UINT64_C(0x0000000185d9a197), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdc8549abcf81b209), UINT64_C(0x073ef9e64af07f62), UINT64_C(0x00000001456ae144), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2e8d271e080da86c), UINT64_C(0x80252648d6b8f804), UINT64_C(0x00000003bcafc423), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5ac546f3d76ea16b), UINT64_C(0xbc26c5a931115636), UINT64_C(0x000000038e2a8439), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf515d826f03f09cb), UINT64_C(0x5c9aa8adeb4fa903), UINT64_C(0x000000032358a617), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa54333bfbd133d2b), UINT64_C(0x047afdadcc065d00), UINT64_C(0x000000030a44e709), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc167429e061efed5), UINT64_C(0x377e1aad191f166d), UINT64_C(0x0000000002097923), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcbdd6b3bdcd012be), UINT64_C(0x5202c18aac9ec042), UINT64_C(0x0000000232ce45f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x229f6d044a28edb6), UINT64_C(0x20f254b727fe9d03), UINT64_C(0x00000001046b90fb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa6677f5d2da1a4c3), UINT64_C(0x3349ec04deab3959), UINT64_C(0x00000001a1ee48f5), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_8[] = {
  {{ UINT64_C(0x1aaa9c6bc3275840), UINT64_C(0x9f5c649cdd39378e), UINT64_C(0x0000000064cbb379), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x215f6752585fb85a), UINT64_C(0xeeef62ae87a9dd80), UINT64_C(0x00000000608540b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x93b6dc537a47129c), UINT64_C(0x7f52a1de41f9c528), UINT64_C(0x0000000203ec2be6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xafe533221a1aedcd), UINT64_C(0xf0df6993a3a187b7), UINT64_C(0x00000000f02cf274), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x152c8d8052e183c6), UINT64_C(0x3580bab7a4fad824), UINT64_C(0x00000001d4ea32ea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdf2c9107e936dae5), UINT64_C(0xa146129ec52fe5ff), UINT64_C(0x0000000387ef35e1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x602a7be8e4b14f06), UINT64_C(0x125e3e00bff75773), UINT64_C(0x0000000332f32b02), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa2db11e42b200c9e), UINT64_C(0x57062701b37a9cd0), UINT64_C(0x0000000197e05c25), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4cfdca4215f7a15c), UINT64_C(0xe06f261b71c3555e), UINT64_C(0x00000003572fed68), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf163edf745df803a), UINT64_C(0x84330b66e5dabd17), UINT64_C(0x000000039786b633), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb3ec4064387c0f51), UINT64_C(0xb03d80a2a19ae98e), UINT64_C(0x00000003a9244375), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2966e89f2038e687), UINT64_C(0xf6779494d4fc08a1), UINT64_C(0x000000028b06b2b9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6458afd9ec0ecec8), UINT64_C(0xd1f8ee77d28a6e1c), UINT64_C(0x00000000937778a8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x34fd595b35d31955), UINT64_C(0x4b8f8ea759634e5d), UINT64_C(0x0000000047bec736), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc34ce8d6995ea7e4), UINT64_C(0xbd397740e34dea82), UINT64_C(0x000000012f568802), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4a90c9275dc20943), UINT64_C(0xb10e95784ad75802), UINT64_C(0x00000000a74da4bc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0b5d501fdebaa642), UINT64_C(0xaf94dfe1ac832f34), UINT64_C(0x000000032979a2b6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x45663e4bee61ee90), UINT64_C(0xb4c8182bc722a0d6), UINT64_C(0x0000000000b40fea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x63630417a7f7a846), UINT64_C(0x9f9a4762f39d411a), UINT64_C(0x00000002f30b8902), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9af0439aa8984ad5), UINT64_C(0xb78c91e980ccd17c), UINT64_C(0x0000000117d59903), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xafc684e7387cc25c), UINT64_C(0x4d7fda76ebaac868), UINT64_C(0x00000003ac8bb0c7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6a6646a9e8f152ea), UINT64_C(0x7f63a285b0d46628), UINT64_C(0x00000001e1f671d8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcdd1c1697e94d669), UINT64_C(0x82c51bc9fc82f505), UINT64_C(0x000000014a849a80), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x60b620df30e236d1), UINT64_C(0x9e5c0eb211c88a17), UINT64_C(0x00000002d033fed8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1c7b434fc409d31f), UINT64_C(0x8e94fb0010e24caf), UINT64_C(0x00000003dbfbdfec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x437c150523c3aab0), UINT64_C(0x52ae61e4dae1df16), UINT64_C(0x00000001c30437fc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf5b91d4725266f34), UINT64_C(0x79e5152eb55408c3), UINT64_C(0x0000000359047a05), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x08e60daa33e855ef), UINT64_C(0xc43ac08c5e0a4f4e), UINT64_C(0x000000001a55f479), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e5bb753a2e61fee), UINT64_C(0x45cb22cef6098e70), UINT64_C(0x00000003f13bbe75), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1bfb52a4f4df212d), UINT64_C(0xfe259d23e905444c), UINT64_C(0x00000001d25971d5), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_9[] = {
  {{ UINT64_C(0x505300b7accf68d9), UINT64_C(0x34983b5289999838), UINT64_C(0x0000000012327ca3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x30896a37d3c2ff72), UINT64_C(0x701b0a91289c2b59), UINT64_C(0x0000000090e87895), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd191f5cd4139b018), UINT64_C(0x606622b699cf62fa), UINT64_C(0x0000000191d1d3ed), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x39cda7c7fa6c3a41), UINT64_C(0x0073d4beb1b59f5f), UINT64_C(0x0000000031ccbbbd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x368ae62b9d6afa76), UINT64_C(0xe948a1ff18745b07), UINT64_C(0x0000000345fe1561), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x09bda0ed873d895f), UINT64_C(0x6178bce662db0164), UINT64_C(0x000000020b7af1df), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8925468566effbe4), UINT64_C(0x2faa51b394a245eb), UINT64_C(0x00000001b91d2ec0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8a4301aa553e3a6a), UINT64_C(0xa172960645c674e6), UINT64_C(0x000000025b4ee794), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe73b3caedb94d036), UINT64_C(0xb2620988ba09a15f), UINT64_C(0x00000000f0e7aa62), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa6b60280e792936e), UINT64_C(0xf0a35d9db3f0faee), UINT64_C(0x000000022710db08), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf4fe4e2077ca6fcf), UINT64_C(0x8fde87b8279e8bd9), UINT64_C(0x00000000631d0c67), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb0a2a46a10995c56), UINT64_C(0x3081c4a0293db200), UINT64_C(0x00000003ab046aec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc482013020c76e0e), UINT64_C(0xc04124590fca1fd0), UINT64_C(0x00000003de1cdd71), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaf7d862e3bbc60fc), UINT64_C(0xe1532261b6245739), UINT64_C(0x000000025b037239), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8957188d4c274249), UINT64_C(0xa550b5e6d680993b), UINT64_C(0x00000001089910dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x51f652c798d08694), UINT64_C(0x77a813ba60b8e0f8), UINT64_C(0x00000003d007e877), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd1c9b3071247e46f), UINT64_C(0x9d098c762f835563), UINT64_C(0x00000000904e0081), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6bb52cfb6f644057), UINT64_C(0x32385ffd83bb8ac3), UINT64_C(0x00000001ceaf01d1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe6e470f3687ce6ee), UINT64_C(0x6d5011001391a78c), UINT64_C(0x000000004f1650cb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4f01946dbc1dc69c), UINT64_C(0x76f82a86c7fe66bd), UINT64_C(0x00000001ded8354a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x538f288f4d780bc8), UINT64_C(0xb7c6f205d55dda01), UINT64_C(0x00000000807f6c46), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xed5371fd4484f664), UINT64_C(0x4b4027687a281340), UINT64_C(0x0000000137f5a2d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x24f80db4ebddb5c4), UINT64_C(0x8faca4396529cf59), UINT64_C(0x0000000389d34bff), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0325f1ef19dc4f46), UINT64_C(0xe9e2168651d82088), UINT64_C(0x00000001c82e703d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x699ec02ae82d1cd8), UINT64_C(0x9891dbcce0013197), UINT64_C(0x0000000042f14962), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8fa40be5d3b1ba64), UINT64_C(0x2817aab1878e088d), UINT64_C(0x000000036e0dac45), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x98424b1b6965ef19), UINT64_C(0x2083cda5954ff4a5), UINT64_C(0x00000000976ae1f0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaacef2da87ab5e95), UINT64_C(0x8ba318220b424e5d), UINT64_C(0x00000001f46fdd43), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc122c96b98074b62), UINT64_C(0x3994414d487276da), UINT64_C(0x000000024bf2b03c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1fa80cb74a69a18d), UINT64_C(0xddcc1ae01d7eb3bb), UINT64_C(0x0000000331de5cdb), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_10[] = {
  {{ UINT64_C(0x120be4e2783f4bff), UINT64_C(0xb46dbb48e3827da5), UINT64_C(0x00000000464d72a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9aea76728eeb185b), UINT64_C(0x143cee6e1282d495), UINT64_C(0x0000000125d27fec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdef2db5166006ce5), UINT64_C(0x6fdffa0e74a4705a), UINT64_C(0x000000004e73bebc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x127e1101e8212f97), UINT64_C(0xad9b040fd0a8abb1), UINT64_C(0x0000000062e2784a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3de17865e859dd5e), UINT64_C(0xee1e6ff4e9596290), UINT64_C(0x00000002155b2d39), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9424076087e844aa), UINT64_C(0xa18f21f904008aae), UINT64_C(0x000000012eb7e064), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe03bf7a6c7f84953), UINT64_C(0x351db764dc6565e0), UINT64_C(0x0000000113eaf92f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcdf87b0ed16bfe6b), UINT64_C(0xc4849d4d5db9308b), UINT64_C(0x00000000c7b7292a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x58b222c3302e8008), UINT64_C(0x83be95cfa0166fea), UINT64_C(0x00000000fc7674ce), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x53fb16ac9b3d7eee), UINT64_C(0x8b63519901d447ac), UINT64_C(0x000000029373716b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x80a1cfe9313c8e78), UINT64_C(0x75752b52873fc24d), UINT64_C(0x00000001d6edc97e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5282ee35398f4c29), UINT64_C(0x8271c681782b15de), UINT64_C(0x000000026f17bce7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4a02ffa6de7fd8db), UINT64_C(0xdf41edc3ba707809), UINT64_C(0x00000001ac5977da), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe4dd3db57627cdc6), UINT64_C(0xc23bd0f2c78954c5), UINT64_C(0x00000001ff166e45), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd53d2cb893fbf402), UINT64_C(0xae0d28175fcf4f8b), UINT64_C(0x00000003e4e97655), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71a1a5b835748e5a), UINT64_C(0x2a6544da0889f5bb), UINT64_C(0x0000000369b53b81), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdceabf29f8f0cee5), UINT64_C(0x89fe2ae0bf0c89d4), UINT64_C(0x00000003b1573c57), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb4ed606735070a8f), UINT64_C(0xbcbc0a83542fb38a), UINT64_C(0x00000003605e2e98), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe6082add7bfde6aa), UINT64_C(0xb11372956ab86ff2), UINT64_C(0x000000026ec4d354), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x383d1444eb8b1241), UINT64_C(0x0509c50c88e63966), UINT64_C(0x00000000c1cded30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x96d02d341d4e3b21), UINT64_C(0x1f9e81018f72b365), UINT64_C(0x000000001f3967fb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6f2b31592278b1dd), UINT64_C(0x9ca7c8e9b96917b3), UINT64_C(0x000000016fc0dacb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x88e2f731f5116acf), UINT64_C(0xd5abcd3bf1ec5e24), UINT64_C(0x0000000388b2d60b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac9d94d4bca2d495), UINT64_C(0x7d1229b9cfc85fd4), UINT64_C(0x00000003840072d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3a56f35fa7a0f4a0), UINT64_C(0xcc82db62246d877e), UINT64_C(0x00000003e6e8a7a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6a23c76910fe7e67), UINT64_C(0x83c2757767ae74a4), UINT64_C(0x000000003e3a4c12), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2a5d656d50674ecd), UINT64_C(0x8159bbe5ced2e5fd), UINT64_C(0x0000000095a9b160), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe8acd43c64a0d902), UINT64_C(0x8b8aa06c609a1a39), UINT64_C(0x000000007cd8127b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x76163fc0b6b6ebb2), UINT64_C(0x734ad3cf9b67ec95), UINT64_C(0x0000000235444182), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x42c936898e55a825), UINT64_C(0xc6750ee16511736e), UINT64_C(0x00000000a61a3a45), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_11[] = {
  {{ UINT64_C(0xef2c73e188941c3c), UINT64_C(0x1cb59759ca7fc7da), UINT64_C(0x000000000c65534d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0b91b10be66fb94a), UINT64_C(0x652addd636123797), UINT64_C(0x000000007e538ca4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6a62a0f4e8ee530b), UINT64_C(0x260e8d85cf6953ae), UINT64_C(0x000000017f654810), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6c196f70b24f0e79), UINT64_C(0xaa9877462da55e3f), UINT64_C(0x00000001e1885400), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x76fd02ef18d6e8af), UINT64_C(0x0e6405121f1e6b7a), UINT64_C(0x0000000366372c78), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe4e947c8c1eaec11), UINT64_C(0x9dcfe65205fe2605), UINT64_C(0x0000000332c41f5e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb727393028e7f58), UINT64_C(0x31bf9316ff321fd4), UINT64_C(0x0000000109127a30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8329644fcc042f30), UINT64_C(0x385bd6fbbe335959), UINT64_C(0x00000000fb630470), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x60d286eb0442b926), UINT64_C(0xd1ac935b690b8f67), UINT64_C(0x000000009318ec0b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x049044860f3b5049), UINT64_C(0x913e540fda27e4ef), UINT64_C(0x00000001e97f98b2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6ab4ff6637216176), UINT64_C(0x82e58f9b54ba9e07), UINT64_C(0x00000001607ddd6a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3bf3406d44d56964), UINT64_C(0x2fe6d091d0cd31cf), UINT64_C(0x000000010e62ec16), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0412093069fec3f2), UINT64_C(0x645a6d933416ac3c), UINT64_C(0x00000003d4543050), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcf48e5dcbdf76467), UINT64_C(0x187a1c9df2033ac7), UINT64_C(0x00000002529f3663), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaab80477a6c55c6a), UINT64_C(0xe9e50be02639dda7), UINT64_C(0x000000029390b8c3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5fede1d2d4247cc1), UINT64_C(0xe96df82d8787056c), UINT64_C(0x000000030db9b3db), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x09fb971eaa3a9c97), UINT64_C(0x534b623f49e2b0b0), UINT64_C(0x00000002d8629e07), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x951a177d9072f66a), UINT64_C(0x983942eaff6a84cf), UINT64_C(0x0000000235670612), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe3e834f4d7645668), UINT64_C(0x85e1ca6da85a0e4e), UINT64_C(0x000000019532e748), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x77a91c79c827873d), UINT64_C(0x2f3e54b7316cf0b5), UINT64_C(0x00000001fb1c5ac7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0881a53fcd622176), UINT64_C(0xca7b816b1fb15853), UINT64_C(0x0000000215457ea7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x58b6324679d6c5ce), UINT64_C(0xe76754c1db739f72), UINT64_C(0x00000002322bd823), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3960641a01b33432), UINT64_C(0xd2b7fbc8def1a972), UINT64_C(0x00000003361fe57a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xee6725e769ce6439), UINT64_C(0x3b631007f7511ec4), UINT64_C(0x000000012f6561df), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x477b2d148e9c506e), UINT64_C(0x8990fd641bb3a517), UINT64_C(0x00000000e2d746ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5faf88012a57d8a6), UINT64_C(0xfb4af1a29258c016), UINT64_C(0x000000036a9b3d23), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1bde659ea17a3186), UINT64_C(0x537e77f646538c6c), UINT64_C(0x00000001f675d52e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfa67be37995cef5f), UINT64_C(0x912cf42240ed4eff), UINT64_C(0x00000000d2057a30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3c97c90c27ab8130), UINT64_C(0x16cf969f56875f3f), UINT64_C(0x00000003d0371078), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x39b35603c8f9da40), UINT64_C(0xc299ece016183135), UINT64_C(0x000000009c40be98), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_12[] = {
  {{ UINT64_C(0xf947a708515354dd), UINT64_C(0xf7ad15f9cb5687c4), UINT64_C(0x00000000f6f423b6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x353ddaba221923ec), UINT64_C(0x65646b44292f5a73), UINT64_C(0x00000000856194ae), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x65423274e2da530a), UINT64_C(0xb54153896e59a966), UINT64_C(0x00000002db7934f9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbdca7ab0ccfd6bcc), UINT64_C(0x31f2f864cbaa6f8c), UINT64_C(0x0000000241d71ade), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4479ff8465283e74), UINT64_C(0x979e83e4132d91b3), UINT64_C(0x0000000359198907), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9e26f810e62e9413), UINT64_C(0x3713f47069fdb4f5), UINT64_C(0x000000006110ff8d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdea390f1218df348), UINT64_C(0xef0469968926a0ac), UINT64_C(0x000000037117288b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x37bcc0785f503da9), UINT64_C(0x378f40e158348ea9), UINT64_C(0x000000016c70869d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7818325c45bc0e39), UINT64_C(0x8138791f47fb31d6), UINT64_C(0x000000003ca4b81e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc5109059a1efc449), UINT64_C(0x4472b42679112dbc), UINT64_C(0x000000021b1d0e57), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe7cfb7a6a41aeddb), UINT64_C(0x23ecd79a5ad4ec4c), UINT64_C(0x00000001cba3c8e6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0f95ab385a4abce2), UINT64_C(0xa576b639368f372e), UINT64_C(0x00000000d483f284), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0034532dbca0dfc5), UINT64_C(0x41aeccf5862947a2), UINT64_C(0x000000033576f406), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb504960ec03f7ec2), UINT64_C(0xb0b4fd1c58f3b49b), UINT64_C(0x000000005bd2fe9c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6510ede0a94b1747), UINT64_C(0x020dc696e6eb2287), UINT64_C(0x000000024f2b8294), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe7892f433a918690), UINT64_C(0xc0ea084da9240f88), UINT64_C(0x00000001e66b629c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb95f44b1c5b9a4d0), UINT64_C(0x34ae0d9dab77e799), UINT64_C(0x000000027f6ee372), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb7f9dd7cd3af04e6), UINT64_C(0x5cc19406ff1c35ce), UINT64_C(0x0000000237daea8c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf7d6480916784ec2), UINT64_C(0x3c460fbab3d4c309), UINT64_C(0x00000000d70702b0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0fc2f94327cd7904), UINT64_C(0xadd28f08d5501139), UINT64_C(0x00000002cd092bae), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3a3a1fd701ccbfc9), UINT64_C(0x654c041ca0b6dc7c), UINT64_C(0x000000031ab7a9ba), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdc164e623139b5ab), UINT64_C(0xc0c132a2e9532561), UINT64_C(0x000000004040671b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e651c4691bd13f3), UINT64_C(0x39b2d3b4a7ec2f09), UINT64_C(0x000000037e1f7db2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x89c415df2327adf6), UINT64_C(0x905102caa3980cd1), UINT64_C(0x000000024207e4a7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x51c0648d6a1d1667), UINT64_C(0xf7f90b26a1ed5407), UINT64_C(0x00000002952ee81a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6d6954a0ef8d7d5e), UINT64_C(0xbc341c7b63294a77), UINT64_C(0x00000002ea27f7e6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xee51aa47de596f23), UINT64_C(0x3cad7b0f89d5921e), UINT64_C(0x0000000242b8d85a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x386ce520fbb1a0d2), UINT64_C(0x79df95a0b1368a96), UINT64_C(0x0000000059bfe8d4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x94f8decb3608b8b4), UINT64_C(0x84010d812cf76aba), UINT64_C(0x00000001e361d530), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x86b1b562176744a7), UINT64_C(0x1acf2039b0985f62), UINT64_C(0x000000019fc75571), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_13[] = {
  {{ UINT64_C(0x2c1a3e45ede0783a), UINT64_C(0xa1c9a0850e7d9a3a), UINT64_C(0x000000002a31bfc9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4ca5ae0cbcffd0a6), UINT64_C(0xf6122f2cc567ed5d), UINT64_C(0x0000000046e8884a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4ac83b6add82c0fb), UINT64_C(0x148d70f22cda623b), UINT64_C(0x00000002c22a9da3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x150f0f00f26339cd), UINT64_C(0x291a6453a0acf801), UINT64_C(0x00000003d5612722), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6c5543e58b10627e), UINT64_C(0xc920ec79641f1e85), UINT64_C(0x00000003af7ed635), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x79a819f13d57dcb4), UINT64_C(0xc199192bd231587b), UINT64_C(0x00000001e54610e1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6b96ee350209f84d), UINT64_C(0xb93cac68b5db3d60), UINT64_C(0x0000000303165ebc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8c214487da1a37c3), UINT64_C(0xae4f3741674ae1b0), UINT64_C(0x000000028c4743cf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x00ecb786462c66cb), UINT64_C(0x505461247eaa28f5), UINT64_C(0x000000023e3b4715), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6df2bd4a543c8863), UINT64_C(0xc9609b7f1a1e62d1), UINT64_C(0x000000028b4d0367), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbc11938536d507de), UINT64_C(0x55004cdb9858375d), UINT64_C(0x00000003d63f2519), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x323dff2f7ac6dad3), UINT64_C(0x3940669cf729f56d), UINT64_C(0x00000000cfb2aeba), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xea5c09d845c036f4), UINT64_C(0x54d84bff9cb6fb4e), UINT64_C(0x00000002da784033), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5f7ba69f0caadcbd), UINT64_C(0xffadacf5305b06ff), UINT64_C(0x00000002ac34f79b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7c5794d7e80d3d06), UINT64_C(0x88063e7a7ca32b79), UINT64_C(0x0000000033ab028f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8da7286553cc9a47), UINT64_C(0xde28d55c5b6f2f5b), UINT64_C(0x0000000071bf6b2d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x04ebd14fd39a040e), UINT64_C(0x0e2c60c513b7c912), UINT64_C(0x000000011d38a3ff), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2db50ca53aed3875), UINT64_C(0x7e44fe8697013c97), UINT64_C(0x00000003f4a6fce3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe2374c3924e5a738), UINT64_C(0x1da69aa3a5018bdc), UINT64_C(0x00000000a971def9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x51bd9f28826c18ae), UINT64_C(0x366b9da01ac9ca0f), UINT64_C(0x00000002a0896886), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e891fb795e239ff), UINT64_C(0xd9734abe7df2e78e), UINT64_C(0x0000000227b72a53), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x998aaf54126b9736), UINT64_C(0xee723978ce326c27), UINT64_C(0x00000002c1b82e78), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x32ea53a0bef7b9f9), UINT64_C(0x9c6955ccbc47ae83), UINT64_C(0x0000000344a98227), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7b0f66639e2b1fe2), UINT64_C(0x9a464b8f5c0a61c5), UINT64_C(0x00000001dc381e95), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x09218513cef24a06), UINT64_C(0x0b6ed247bf28df7b), UINT64_C(0x00000001517c20bc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2e48d9f0ba4b8129), UINT64_C(0xc7ebe8ddff78062a), UINT64_C(0x00000003efe2089f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2e84f8f015b3aaba), UINT64_C(0x96b75ae636a39f18), UINT64_C(0x000000013ea2ce06), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9cf4105d2b58dcb1), UINT64_C(0x395ec44dbc3f4d26), UINT64_C(0x00000001d8656e0d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3472acfbb014a55e), UINT64_C(0xa3556548d862c049), UINT64_C(0x00000000f607651c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc1ab77eaade6ea99), UINT64_C(0xadde3e265c30bd3c), UINT64_C(0x00000000264f19b6), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_14[] = {
  {{ UINT64_C(0xfc6953aaf6514001), UINT64_C(0x7cb04b800139f273), UINT64_C(0x00000000cf9219d6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x282a90b52a24b29f), UINT64_C(0x918b3df1a7b19d5c), UINT64_C(0x00000000f91ba8fc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa8d09a22173ae524), UINT64_C(0x490850774b66c14b), UINT64_C(0x00000002f3bd3048), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaaad8f2b4b9e88fa), UINT64_C(0x55ebba2a2bdab8b2), UINT64_C(0x000000011973e368), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5574c28a2280b12c), UINT64_C(0x40f4a88b59f17c24), UINT64_C(0x00000002c42e5349), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6da73d82c454d0ca), UINT64_C(0xec6b13f2fee9f840), UINT64_C(0x00000001847108d5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa8f945c6f70e76c1), UINT64_C(0x3d18d593154c09f8), UINT64_C(0x00000001a7ae3354), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb33c56c4e6b0155a), UINT64_C(0x79afc8172139e38a), UINT64_C(0x00000003dd84a40a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x32e19d20128f82af), UINT64_C(0x05e90195021368fb), UINT64_C(0x000000024f49398a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x42cdfbec91e643cb), UINT64_C(0x22a0c87ce00dc2a0), UINT64_C(0x00000003e1ba0bac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1d1888083d365655), UINT64_C(0xcc99f2b135504fd2), UINT64_C(0x00000001d1c03fee), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x67b0ae53c50c5e6a), UINT64_C(0xf1e873c739cf97bf), UINT64_C(0x0000000088594fb5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe8cae4e6909eab88), UINT64_C(0x8ba48f9a5c7d20dd), UINT64_C(0x00000002d2be278a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc4adb626fe5b49bd), UINT64_C(0x361842dc52d6e419), UINT64_C(0x00000002f020cf16), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6acd323bb3e1fd1d), UINT64_C(0xb05c93735cf0d11e), UINT64_C(0x000000023ad1ca27), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac2e664326dcda7d), UINT64_C(0x2eef01db58bd7ab6), UINT64_C(0x000000014e362e30), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x03f488467e0073ae), UINT64_C(0xfaca210130828916), UINT64_C(0x00000003749f4a5b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdfd74662cc529f92), UINT64_C(0x0c2fc5af278728e6), UINT64_C(0x000000000f70e284), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4bbecced9c629f1b), UINT64_C(0xe5b7a5653cef753d), UINT64_C(0x00000000c4d7ef65), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd4fe9143d0b2fbc1), UINT64_C(0x00670eeb6c58ebf7), UINT64_C(0x0000000288c411bf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x74e4fd6172a25866), UINT64_C(0xc0acf2e6f7e2893f), UINT64_C(0x0000000373bd185c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x898ac0b7d451a688), UINT64_C(0xe01395094a0d40a8), UINT64_C(0x00000002b8c357dd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x06b4c1e0c6aff652), UINT64_C(0x70829d1832a8055a), UINT64_C(0x000000023b82203c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x03ecace3c0f92e86), UINT64_C(0xf59cf158304a31ea), UINT64_C(0x00000001b758f64b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3df3f4d9a4d063d9), UINT64_C(0xb0df5782d8d87301), UINT64_C(0x000000003e505160), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaa1e296f9764becd), UINT64_C(0x8e9204285e422e69), UINT64_C(0x0000000050baa1da), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x777a84c338de6710), UINT64_C(0xdc497d36c0f10bd6), UINT64_C(0x00000001a001f831), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7555dc711c56feca), UINT64_C(0xa59d1e64c9665d54), UINT64_C(0x000000004f834333), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8d38a650124235fa), UINT64_C(0xa5b2fe7168af2966), UINT64_C(0x00000001c2ea1989), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4dd3972f61e0582d), UINT64_C(0x5fcf805c8985bef8), UINT64_C(0x000000000c3e012d), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_15[] = {
  {{ UINT64_C(0x5c5d2e36da7fbcc4), UINT64_C(0xf21b768ef63cedc3), UINT64_C(0x0000000000e7d66d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x868b3f0a72c74218), UINT64_C(0xd169cf184553cda5), UINT64_C(0x00000003e84d8d17), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4b81db0743b6b324), UINT64_C(0x3013e79c7df356a7), UINT64_C(0x00000003110f0dc2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb794d389ced1b2ab), UINT64_C(0xa2e23fc853e4c2d5), UINT64_C(0x000000015dfce61f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa5dd8cc1383df1dc), UINT64_C(0xfc6ce59d832e6de3), UINT64_C(0x00000002f8744006), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc97a555c78078bbb), UINT64_C(0x05edfa5a7382f01d), UINT64_C(0x000000029c4e8efe), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3eb235b50ac41924), UINT64_C(0x6f311f7fe75e95e3), UINT64_C(0x0000000264b0e4e8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8baa21fcfd7a592e), UINT64_C(0xd2b63567a2bb64a0), UINT64_C(0x00000000f088dd3a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe3e59bcec3f723e7), UINT64_C(0x748ad6d8d79f8ed9), UINT64_C(0x000000037674e904), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x585d6cf01bba1c8f), UINT64_C(0x165ab58fe0cdfc8f), UINT64_C(0x00000000a341436f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1297529e8a90e2cc), UINT64_C(0x3c80dff9eea6030c), UINT64_C(0x0000000168ae33b7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd4ef299afc3c7e03), UINT64_C(0x29c2d7b6b6d38ec0), UINT64_C(0x00000000ed717bbc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc364557395a419bf), UINT64_C(0xabb1e615d54d69cb), UINT64_C(0x0000000238a69f7b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbb56b43d98bc8404), UINT64_C(0x052d1ad854b6f58f), UINT64_C(0x00000001037e23ae), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6761dbdb30d1abdd), UINT64_C(0xf065dcfc7c2ea006), UINT64_C(0x000000031742709c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x49e26b40bfea7c21), UINT64_C(0x801de91d65f31d4b), UINT64_C(0x00000001f467d4b6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x17fabebfbd1dd74d), UINT64_C(0xef5150e804c96f84), UINT64_C(0x00000001e9f2c36e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd51a5bdb46c1852c), UINT64_C(0xe0f19a0958af4710), UINT64_C(0x00000001cfb6d362), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x535ede222962804f), UINT64_C(0x8f54243489927077), UINT64_C(0x000000028815e34f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4f55e03d90956579), UINT64_C(0x0072c122f167634c), UINT64_C(0x0000000293265e63), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4d52080c74ec3636), UINT64_C(0xceb66beccb7fbdf1), UINT64_C(0x000000015047070a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x96939d84bf6218b8), UINT64_C(0x3a3f64ba85705cf8), UINT64_C(0x0000000242ae0556), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa7ba45068b4c6a16), UINT64_C(0xa7444e229fd835f8), UINT64_C(0x00000001580e415d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x93a3a87d6634c4ba), UINT64_C(0x01f05f29cba18aad), UINT64_C(0x0000000393d98001), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x87416c216b4c4ac0), UINT64_C(0x38dc41a9363d71aa), UINT64_C(0x00000000b2eca742), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0f9d9183353c133b), UINT64_C(0xdb7b73e8c5c06d33), UINT64_C(0x000000027df51ca4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6ca62fd185ea58ad), UINT64_C(0x210e3138dfdfb184), UINT64_C(0x00000003abe30b3e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x54551d6ad53818c6), UINT64_C(0xcaf36e3f3f9e5cf2), UINT64_C(0x000000011871f843), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdf66f13eae1fa620), UINT64_C(0x55a76b7966b31f0f), UINT64_C(0x00000003ec63d721), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe8150921e283f71), UINT64_C(0x6588dd632becae6c), UINT64_C(0x0000000211576ccf), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_16[] = {
  {{ UINT64_C(0xb3759fea793cd288), UINT64_C(0xe5366465406bd8a4), UINT64_C(0x0000000033c996a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5e7d8105f7623f19), UINT64_C(0x930bc1f791b028de), UINT64_C(0x00000000191ca079), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f9376eafea03026), UINT64_C(0x9b07edd5cc3930c6), UINT64_C(0x00000000228e7f40), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6725f0bc6a5976df), UINT64_C(0xa3c23b5adc9a4da9), UINT64_C(0x00000000cbb57315), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x89a18dc21b87ed0d), UINT64_C(0x932f9e5db6577f2e), UINT64_C(0x000000004b16f18e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe6e6f3a7597346c1), UINT64_C(0x409a8c54b263f9de), UINT64_C(0x00000001f3a29f2a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc81007a4dbc4aee2), UINT64_C(0x285b6a3c01e4d324), UINT64_C(0x000000027789e917), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x57eab9f5559fc087), UINT64_C(0x0e1590bd332edb7d), UINT64_C(0x00000003cbd1d5f0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4384964188c6cecb), UINT64_C(0xca6544df9549d55a), UINT64_C(0x0000000067e77013), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1d0979c5e1ff701a), UINT64_C(0xcff467af68b35f64), UINT64_C(0x0000000182d6737e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcdc7726e4f143547), UINT64_C(0xdd64f15c3d9ec750), UINT64_C(0x000000026968d199), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe2499f0e25a78a5), UINT64_C(0x6d867ff51cef8355), UINT64_C(0x00000003aa35ec2f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3e11239bcca2351a), UINT64_C(0x7dbef644036b49db), UINT64_C(0x00000000131b0ae5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb622dc236c1c6bd3), UINT64_C(0x04794f1ba6cf0975), UINT64_C(0x00000003bcb5b355), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe6365af4bdc36399), UINT64_C(0x41aae106e77c59a2), UINT64_C(0x0000000299fe9645), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x59188e91742f4e7a), UINT64_C(0x56b8a9c2315cc618), UINT64_C(0x0000000290cda8a5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1a8e80f33eb858f6), UINT64_C(0x88b89673747de2e6), UINT64_C(0x0000000334d7846c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7b05d3132d0e5d76), UINT64_C(0x35a37b1a1aecb1c7), UINT64_C(0x0000000279680f49), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x29592ac68bdc3106), UINT64_C(0x2a6d55e1ab7c7f13), UINT64_C(0x00000001ec583aa8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa05ea48d131ea3d7), UINT64_C(0xf26b7cb5848b0b85), UINT64_C(0x00000000ead5d712), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4cd95f613605362d), UINT64_C(0x36946e6001649811), UINT64_C(0x000000017d9a600a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6b9e1db5c7083a4a), UINT64_C(0xc9b540714c6a2802), UINT64_C(0x0000000228645830), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc87f1c9d7b19b5a3), UINT64_C(0x463a9817dbd50ab3), UINT64_C(0x00000000045c1be9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x50d997af611aa8bb), UINT64_C(0xdfec020a13879616), UINT64_C(0x000000034e10cb66), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8db3003497ace6cc), UINT64_C(0xc88265a711a9ff36), UINT64_C(0x000000015600eb34), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9458922a296ebfab), UINT64_C(0xfbcc9caa2007de8b), UINT64_C(0x00000001dcafb105), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8cb33d88c277a689), UINT64_C(0xa3d24f3b2f9c15c2), UINT64_C(0x0000000226e29d32), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3838762953fea878), UINT64_C(0xc583af4b162d06ae), UINT64_C(0x00000000edfb65c6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbde2edee50472ece), UINT64_C(0xea3c0ed4d999f5df), UINT64_C(0x00000001b52ace77), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f7b45df375afc7b), UINT64_C(0x97c51168d46bc691), UINT64_C(0x00000003fa19bcab), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_17[] = {
  {{ UINT64_C(0xe9bc737a2987f233), UINT64_C(0x5c3432ddadf016ca), UINT64_C(0x00000001fc2f8649), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2143b4989bf16630), UINT64_C(0xd91a72ac3efaba86), UINT64_C(0x000000007d633b50), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xef7a76ae0dc60e0a), UINT64_C(0xd5b7b66891b73c96), UINT64_C(0x000000006a580fc9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x59e06f26d273f12a), UINT64_C(0x0ba51cbdb5cec0bf), UINT64_C(0x000000003740e2dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e5d9b5767891295), UINT64_C(0xc9df9ef57dce00f4), UINT64_C(0x00000001c3122cf2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd6ed5a3b1c700fd), UINT64_C(0x680b4bffa2eac7c3), UINT64_C(0x000000026b97010e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbf14b53f66435910), UINT64_C(0x710ea56b55fa42e5), UINT64_C(0x00000002e40bc227), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x547610605c8ebea2), UINT64_C(0x568d0fe6d09eb286), UINT64_C(0x00000001acfa71a2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x77c2e4d08450a18c), UINT64_C(0x9f242d5881bd2bdc), UINT64_C(0x00000003b4eaeaf2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3a256ac5b8f8755a), UINT64_C(0x3b1ab196461c62f9), UINT64_C(0x00000000cda8cef9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9ae594961d646c7b), UINT64_C(0x6697e0c07edeff65), UINT64_C(0x00000003c1681474), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x189b5e352b9e5af1), UINT64_C(0x28a1acc9506e35cd), UINT64_C(0x0000000291fb88e6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x06c5ef84461a74a5), UINT64_C(0x260677d6df58f5a8), UINT64_C(0x00000003106ca0fd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd102baabd2d8d6b3), UINT64_C(0xb828a38270b63d8e), UINT64_C(0x000000029afb7906), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc14df38ce9adc46b), UINT64_C(0x87f0a3a0c9609975), UINT64_C(0x00000003a1dc42c9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x11b1de4fa8e3a0ca), UINT64_C(0xdbb23781096ee7ce), UINT64_C(0x000000035e24ea0a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7128d8471ba585a4), UINT64_C(0xeb01aabc566c8dd1), UINT64_C(0x000000022348eaf7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc6d2c79955ae07b2), UINT64_C(0x2486479f1c94f421), UINT64_C(0x000000001a6cddf9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe4748c4151460a78), UINT64_C(0x3dc2959bfa994bf4), UINT64_C(0x0000000387988d33), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaac4deae420108c9), UINT64_C(0x8c34ae10400d45ec), UINT64_C(0x00000003ea1f0a26), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f13b77f27c5dcd8), UINT64_C(0xad695600c159ee1b), UINT64_C(0x00000001782a7eb4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9cc6fc965c97ce8f), UINT64_C(0xc4877e16d4b26d0f), UINT64_C(0x00000001acdc675c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0c92655b2b575c9c), UINT64_C(0x743e44cb27dc3c87), UINT64_C(0x00000001862e2fe8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdcc4d7b74eca880e), UINT64_C(0xc0411a35372c582c), UINT64_C(0x00000003213fcddf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0dc0f7f9d561e0f4), UINT64_C(0xa88ff0b093d706c8), UINT64_C(0x000000015557b409), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2cc4921524e5e508), UINT64_C(0x3e6c54cffb7baf81), UINT64_C(0x000000015e5bdc4b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xff494dec62ce8d77), UINT64_C(0x59369c68614d8820), UINT64_C(0x000000001b5a0fd3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7126b8ebe855f44a), UINT64_C(0x21e9c6afef9c8621), UINT64_C(0x0000000210a0761f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf66cfd9260fd037c), UINT64_C(0xdb84e8df4c4523b9), UINT64_C(0x00000000ef0a1c63), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb7f9cfe10539fb4b), UINT64_C(0xdfded59a57a50ccf), UINT64_C(0x00000002ac119f41), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_18[] = {
  {{ UINT64_C(0x1393f55d1effccbb), UINT64_C(0x3b41c388561278d5), UINT64_C(0x00000000d33b5fd7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3b1d6f4c6f4a3f11), UINT64_C(0xb99b35c3abf7c9bd), UINT64_C(0x00000003e04fdc60), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2aeec55bd6667db5), UINT64_C(0xce7d06809cb354e4), UINT64_C(0x000000021ea21089), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd05222848d683f5), UINT64_C(0x314d223bed0a32ed), UINT64_C(0x00000001fbae6b47), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd2681fdfa5048b01), UINT64_C(0xc6bd49d88316b105), UINT64_C(0x00000001845fc62c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaeabeab4ecbca264), UINT64_C(0x28b39d33f896cd55), UINT64_C(0x00000003c858beaf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb69336a30ba17f7a), UINT64_C(0x34db50a6095d537a), UINT64_C(0x000000028262572b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb72c776113167910), UINT64_C(0x7b41af006f7fde2f), UINT64_C(0x000000035f971aae), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe23711e43d714f98), UINT64_C(0x96ce8ae0b8eb10bc), UINT64_C(0x000000034bc96823), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x25f5de552c59677e), UINT64_C(0x0d0c7bd7fd5e7365), UINT64_C(0x00000002abdaa0b1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa645b54619ba1bbe), UINT64_C(0x4c87f7f29405f9a9), UINT64_C(0x00000000983557fb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xffb2d88a9cc0b255), UINT64_C(0xf6c98104ad0caebf), UINT64_C(0x000000036fae04ea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa7e9c94cc9fdad5f), UINT64_C(0x3745429cfdeb0f55), UINT64_C(0x0000000321531acd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4bf1ac5cc0902d12), UINT64_C(0x2187b74e02532251), UINT64_C(0x0000000128109763), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6c887510552ad860), UINT64_C(0xebac595a6d5f1125), UINT64_C(0x00000003d0af3d61), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x29d9f5c41a22573c), UINT64_C(0xc3d1d415e0ffbbe4), UINT64_C(0x00000000b437725e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4c88cc0cd1ad7143), UINT64_C(0x477f7f7b17ed13e6), UINT64_C(0x00000001635a8655), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc4355b41a4505f88), UINT64_C(0x0f363c7cbff27c5a), UINT64_C(0x00000000f48c1c8e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8254f7fab236ef5a), UINT64_C(0x0b66c8ffc49421a8), UINT64_C(0x0000000062f66b4a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1eebcbcab4f29851), UINT64_C(0x2d73ef13db789815), UINT64_C(0x00000001bf9fff46), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1f14ebd1207d07f5), UINT64_C(0x7b12bc3ae5ea29dc), UINT64_C(0x00000001cf2d33ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd9f078616c5ce4a8), UINT64_C(0x5e237ed142253d6e), UINT64_C(0x00000000be78b84e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4cc129f0f335d39f), UINT64_C(0xd84b759e74778a1b), UINT64_C(0x0000000325d6a20d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5ec8b3748cf42380), UINT64_C(0x20490d500a29f1c8), UINT64_C(0x000000009c0273e9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdcb828b19af0c160), UINT64_C(0x0132ec95e9c0c6e4), UINT64_C(0x00000003cd6775c5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x479f279854ae2563), UINT64_C(0x0432deae73e477ae), UINT64_C(0x0000000053cfebd9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdd1dc0cb62050a56), UINT64_C(0x7baffb14bf07f0e5), UINT64_C(0x000000030918d2df), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf7b4cade03f9c57e), UINT64_C(0x12da18b7dbeca241), UINT64_C(0x0000000303a4db05), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x849d8d86b10ae8be), UINT64_C(0xf8261c7c219d12a6), UINT64_C(0x00000002b35db175), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xae523a675fed8e4f), UINT64_C(0x76a7e468460622a1), UINT64_C(0x00000003d311666b), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_19[] = {
  {{ UINT64_C(0xc152b6ce4616898f), UINT64_C(0x2c663c91f96a27fa), UINT64_C(0x000000009c9fe3da), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7dfdd163ee5fd549), UINT64_C(0xf5aa4e0eda206e38), UINT64_C(0x00000001fad160fb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe669abfe7b4e200), UINT64_C(0xbde53f229fb1e79d), UINT64_C(0x000000032f5b6c9d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x972e1f335178dabd), UINT64_C(0x673db2e9f8a81765), UINT64_C(0x0000000032b0f6ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa23667ddc36d1dd1), UINT64_C(0xf08920c4302ff071), UINT64_C(0x000000028cbbb4c1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x371c4c436dcf8972), UINT64_C(0x8840790b142985d3), UINT64_C(0x000000018cb63e08), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x79583a71f70593ac), UINT64_C(0x118a81fdb72a123d), UINT64_C(0x0000000216642943), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe629f65877ac1dcf), UINT64_C(0x2dc5206263f946c4), UINT64_C(0x00000003b16205ed), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x78014132dc4190cc), UINT64_C(0x128c716d8feb5946), UINT64_C(0x00000003b485327f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf6e90c9f03866eac), UINT64_C(0x1b9e5671b30011e9), UINT64_C(0x000000006eff3903), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa73d14591ff5e9d8), UINT64_C(0x8d78298bcf02e140), UINT64_C(0x000000024b275f13), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1d4fd22248792c37), UINT64_C(0xb55669353587babd), UINT64_C(0x0000000305c9fc5c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd02d565a71fdbe3), UINT64_C(0x064712e8e8a3fbb4), UINT64_C(0x0000000087f7d6b1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7a1a9d5936368f23), UINT64_C(0xa9c51b2d9bd99e14), UINT64_C(0x00000000d68cb39d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc08ed71dcb9ee7df), UINT64_C(0xe47353998eeb78a2), UINT64_C(0x00000002f0680f20), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6ddeabca436390c9), UINT64_C(0x6e584c774ef64c59), UINT64_C(0x00000001651372ef), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e191c331c3979bd), UINT64_C(0x4133fc6a9de88eb2), UINT64_C(0x00000003e9fd0543), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xde63ed941532538e), UINT64_C(0xa2c39b1155d32f2b), UINT64_C(0x000000035e995947), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x73b0eddbc68e5b52), UINT64_C(0x47d03bc3df2323e7), UINT64_C(0x000000015960b7c1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfa2dcb070135c8c4), UINT64_C(0x93f89d8a132b1737), UINT64_C(0x0000000088c97a67), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5a7e9523855ee8d2), UINT64_C(0xb2d66864ba554967), UINT64_C(0x000000001b9b869b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x360e33c0d92737fd), UINT64_C(0x5a34473a584d5040), UINT64_C(0x00000003f93b00cc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x23ab753e4e6951d5), UINT64_C(0x51e129a03d420d7e), UINT64_C(0x00000001a676b6e2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf847b621083b3635), UINT64_C(0x9037cc89c6dcbe09), UINT64_C(0x00000002d9586624), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfb888a93a5ae7a13), UINT64_C(0x17547bab52e1aaf0), UINT64_C(0x00000000ff932662), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x01f69ee34a9967c8), UINT64_C(0xb5d004a2d6b92a3d), UINT64_C(0x000000033ff45604), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9036ce8e03abfb6d), UINT64_C(0x58a3926faf0b634a), UINT64_C(0x0000000221d95078), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x01650c0bb0b17379), UINT64_C(0xa507dbac94f8f14d), UINT64_C(0x00000001dbcfce4e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc4ac420e08cab77b), UINT64_C(0x4f5012793b34c5ed), UINT64_C(0x000000000b9e12d8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2766abff1842fa29), UINT64_C(0x48bd57bc4bf40b34), UINT64_C(0x000000008d3e68c6), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_20[] = {
  {{ UINT64_C(0x95ab4e6f34494a05), UINT64_C(0x92c2ff65056e7c72), UINT64_C(0x00000000179e04db), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x06e5fb9b95408860), UINT64_C(0x8168d9bd9ce53879), UINT64_C(0x0000000049c2b3a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9e4689ba7d70f091), UINT64_C(0x8bd25cedeaddbc7d), UINT64_C(0x0000000098a2b8bc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfd87822c869bb2d3), UINT64_C(0xd739d7e9f893080d), UINT64_C(0x000000017e493fce), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x240af594080faaa5), UINT64_C(0x2154923d3cefb297), UINT64_C(0x000000004d1269ed), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6cbf25bbbd3b6842), UINT64_C(0xc7275894192dae6f), UINT64_C(0x00000000985d3d11), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3e02ce7548b6f0d5), UINT64_C(0xbfb9468944944347), UINT64_C(0x00000000a12836b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd019e92117396721), UINT64_C(0xf3ba4bf86c83ba2a), UINT64_C(0x00000003f544b615), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe6090deec62686b2), UINT64_C(0xf7dc2f4d608e618e), UINT64_C(0x0000000328dc813f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x30f7735c960683b7), UINT64_C(0xa7afce840935f272), UINT64_C(0x00000003259405f6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa1d3d73185727415), UINT64_C(0xca89e431ee22d963), UINT64_C(0x00000003fbf793a1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x64d10ed9644c8457), UINT64_C(0xcc125633f794a814), UINT64_C(0x00000002042585c9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf128fe981f281ca4), UINT64_C(0x910ed06ab8eec443), UINT64_C(0x000000037b62a7d5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5bd7d08ff5616851), UINT64_C(0xf9734fb32aa8e9aa), UINT64_C(0x00000001910a5814), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd774e18ce9831827), UINT64_C(0xfea886ff7083d4e1), UINT64_C(0x00000001b55281e5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9bf788f83973bf03), UINT64_C(0x653731ba39b06c45), UINT64_C(0x00000000038bd558), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x81570bc93d3ed94f), UINT64_C(0x916fe983359c85ea), UINT64_C(0x00000000cbb4ac79), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc2367a0e99f8d205), UINT64_C(0x14b7e06a77b0a775), UINT64_C(0x00000003da0c873a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf50106bfe43733e4), UINT64_C(0xb8c5379649147dc9), UINT64_C(0x000000008a0ddc90), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x05bdc1db20a1b9c4), UINT64_C(0xb794b111692ca3fd), UINT64_C(0x00000000792a746b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x51fc7cba240769b1), UINT64_C(0xf98ac397daa1189e), UINT64_C(0x0000000055432d58), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x645b1752168960a8), UINT64_C(0x410402cd64d68ad7), UINT64_C(0x00000002e94a420b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdd188bfa4bc6c278), UINT64_C(0xb51efd5f32999347), UINT64_C(0x0000000226bd17d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0cfc6e6fb84435c0), UINT64_C(0x655858144aa6b35e), UINT64_C(0x000000011f5d81c5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xefaabcc89e73a9a9), UINT64_C(0x99c138b1656aa214), UINT64_C(0x00000001c62529e1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1f799a53c85fb0b0), UINT64_C(0x166285224c4fa324), UINT64_C(0x00000003304c8530), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x611e196cb2bec693), UINT64_C(0x329f2fdaea8cee0d), UINT64_C(0x000000011e7f1b05), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x79352e66091f20ba), UINT64_C(0xc344dc66813c46eb), UINT64_C(0x000000019dc01518), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa1d8c38551cdb97c), UINT64_C(0xe2e9c7f3b54ac34c), UINT64_C(0x00000001942bdc62), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x218117047b17d06b), UINT64_C(0xff51bd74f2204492), UINT64_C(0x0000000102853035), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_21[] = {
  {{ UINT64_C(0xc8df5a7087504a30), UINT64_C(0x057cf9559422749b), UINT64_C(0x000000001e31b89e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x37c04abd9d0d9756), UINT64_C(0x94179a05c6c66112), UINT64_C(0x00000000b5d26992), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5cbec9b34f324235), UINT64_C(0xacf722cdfc50df7d), UINT64_C(0x000000034e97690b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x03f756532258a201), UINT64_C(0x1ca09a8eebacce4f), UINT64_C(0x00000002dabf3b2c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xae67822c27d57df8), UINT64_C(0x741e43d48fa3d42f), UINT64_C(0x0000000315fd0c4d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x73f343287745e83e), UINT64_C(0x8bd5777f6509defa), UINT64_C(0x000000006fc54a5b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7753938bfc177d1b), UINT64_C(0x6ee8023244f48992), UINT64_C(0x00000000508a70e2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7d5bad64ce5a457c), UINT64_C(0xe0131dfd21cd7026), UINT64_C(0x000000018590fffb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbda219c2a52c2549), UINT64_C(0x35514fe9746a394a), UINT64_C(0x0000000272efd9ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeb3197e1acc73e59), UINT64_C(0x184d51ead6077e90), UINT64_C(0x00000001b119ae69), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x03156a6ec0107f3c), UINT64_C(0x421eae46057b858b), UINT64_C(0x0000000377b4c7e3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd1e4b397c13ee61f), UINT64_C(0x2bef09ef6669f42d), UINT64_C(0x000000020582c2e6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0535aed5d2ecde40), UINT64_C(0x4f6b0c93229bc280), UINT64_C(0x00000000b43e0f59), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa241338ba1c695b8), UINT64_C(0x2aa55e7e4a818502), UINT64_C(0x0000000092e233bf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0888863f3ce3b279), UINT64_C(0xd9ff6ee616d2261f), UINT64_C(0x000000025122017a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdb6f1a6a2ee864d0), UINT64_C(0xaf350a5490dd3cac), UINT64_C(0x0000000196c49a13), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc9d8b8b4883ba8ac), UINT64_C(0xe3c2ea0d58a27979), UINT64_C(0x000000031048b73c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb0d745add2f06426), UINT64_C(0x2a707eff366cf8ce), UINT64_C(0x00000001f11eb30c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0f49fbf2dd52fc16), UINT64_C(0xc10d68b94f4df05b), UINT64_C(0x00000000426ba517), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1c4e6cf7ac799b5f), UINT64_C(0xd3227314e99eff6c), UINT64_C(0x00000003bb9cc1eb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5cfda5c845d111cf), UINT64_C(0xb8d66fcd358fc183), UINT64_C(0x00000000c7ced175), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8fd5beff66700f3e), UINT64_C(0xb8b1d4fa53586bff), UINT64_C(0x00000000242c00b1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e443a071f5573b9), UINT64_C(0xd4132a91dfaa44c4), UINT64_C(0x00000002a5188f72), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf02b2af6967e4831), UINT64_C(0xfdfb9743af26b3f9), UINT64_C(0x000000026aa3254f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x624e1ee7bf411a52), UINT64_C(0x86226eb0bd8f4556), UINT64_C(0x00000002414f3184), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x14881196bde0a6c2), UINT64_C(0x2a625112f49e5749), UINT64_C(0x00000000f9f499f6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5fd578e61ede2e97), UINT64_C(0x8bf76f97533ba6aa), UINT64_C(0x00000000d6e5b76d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x18e29cdb51890a8a), UINT64_C(0x25b10bec5a5260b5), UINT64_C(0x00000002beaa174e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4d5a6d55a2471f39), UINT64_C(0x349a697628fea5b8), UINT64_C(0x00000002c97b4dd0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x574895b35692a02a), UINT64_C(0xa11d9f75397a54bc), UINT64_C(0x000000017cc0e0c9), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_22[] = {
  {{ UINT64_C(0x891ba1035a38877f), UINT64_C(0x1d6f81909aa0c2f2), UINT64_C(0x0000000129d0009d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x91083f3036d248d3), UINT64_C(0x8e57c01fb540593a), UINT64_C(0x000000001dbe7811), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd513212a5a2f697c), UINT64_C(0x29c26b62b3d99c08), UINT64_C(0x0000000030db774b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdc8424b3edcb13e3), UINT64_C(0x968484fba8f90e15), UINT64_C(0x00000000cbdbf149), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9bf31d26210ddf09), UINT64_C(0xf2e143ada5d29691), UINT64_C(0x00000003afb7324e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x78d4ca513052f4fe), UINT64_C(0x1905f7a1401bc672), UINT64_C(0x000000020995f038), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xff1b149e94849af6), UINT64_C(0xdd09ba31f6bf4c51), UINT64_C(0x00000003a657d3af), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd50ed780ed48b947), UINT64_C(0xa220bd6d6af0da0d), UINT64_C(0x000000033b6c6b5e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xccf18468eac59026), UINT64_C(0x78fa1ecdafe0055f), UINT64_C(0x000000007cc6991e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa4781e99af5b37ed), UINT64_C(0x69bbd4615ebb8185), UINT64_C(0x00000001f9553143), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7353dcb6be2420fa), UINT64_C(0x280e3103aa6a6213), UINT64_C(0x000000032a13d2ad), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd3053b1e2c0bad2e), UINT64_C(0xa8e8936e75c61086), UINT64_C(0x000000035864456d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x67aa425fbf9732a5), UINT64_C(0xaf9e30b97300b7f2), UINT64_C(0x000000003a7cfd88), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x731ea4e49f0850a4), UINT64_C(0x575f0b436f567c9b), UINT64_C(0x00000003c06059a9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1fb6fc5844f1433e), UINT64_C(0xbc5b8f87bcdf6dcc), UINT64_C(0x00000000eb48ee36), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcd740e6b0114c57b), UINT64_C(0xbecd5cc9adb35f8c), UINT64_C(0x00000001562012b2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa48f0b0c711df4b0), UINT64_C(0x88c4fbddb6b2aac4), UINT64_C(0x000000002640f6da), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x801385cbfbfacf1f), UINT64_C(0xefd8860dfe82548d), UINT64_C(0x00000002064cdd43), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2af4cf43d3e14172), UINT64_C(0xbea4264619359def), UINT64_C(0x0000000197e481c3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x05f320d433d7621e), UINT64_C(0x1f1dcc9f162de600), UINT64_C(0x000000037386be15), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x74bf6e12ddc29d3e), UINT64_C(0x7d31eea90711be65), UINT64_C(0x00000000070d8310), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0cad4d98eeb51c60), UINT64_C(0xab0c9edaebf1ad32), UINT64_C(0x0000000089840499), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x212a98acabb61c26), UINT64_C(0x16bbe70da93f4065), UINT64_C(0x00000002361e715e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc54cbaa94391d519), UINT64_C(0x69648bdfdbebf261), UINT64_C(0x0000000157fcecfa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa95b6c705eef16bd), UINT64_C(0x85b0f9efc8081d87), UINT64_C(0x000000018b0bfac0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5fe50f628889ad91), UINT64_C(0xab4f7bb9f078ec81), UINT64_C(0x00000002fbaad0d3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc6dd6b70bb44fc43), UINT64_C(0xdbb9d3e50de4470a), UINT64_C(0x00000003da44a432), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x32115b3c83493a27), UINT64_C(0x8ac6ee1259b4a8bc), UINT64_C(0x00000003e44e8c44), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x69ed617899d56400), UINT64_C(0x1609dbba5c72fc7d), UINT64_C(0x00000000e75593e9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5e68d9a9d231a024), UINT64_C(0x947bf134650199c7), UINT64_C(0x0000000281043b17), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_23[] = {
  {{ UINT64_C(0x9144fd3c45f74720), UINT64_C(0xbea8926430a115dd), UINT64_C(0x00000000f1e30309), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x22fb02a2c08650f0), UINT64_C(0x7d2cd79597642858), UINT64_C(0x00000003892df667), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbf5f55433c76d735), UINT64_C(0x70898f6cb05f2d96), UINT64_C(0x0000000146674ddc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8e3b558d5578eb38), UINT64_C(0x5bec6b7ecf749546), UINT64_C(0x000000032d0eb83c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x37cf104996a9883c), UINT64_C(0x58ad9efd62b3fa38), UINT64_C(0x000000038eef30d1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x19712150220fc8c0), UINT64_C(0xdd01520fb07b7634), UINT64_C(0x00000001b7069a13), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb502bf0d27d69d71), UINT64_C(0xcb25e6c1cddbb2bc), UINT64_C(0x000000025e3eb2d3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x14687c74853cf8b9), UINT64_C(0x1d5efbd9ebe220c8), UINT64_C(0x0000000100421111), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xecbc2b7fbf9915fc), UINT64_C(0x09f17ac795ca1d85), UINT64_C(0x00000000a62e05aa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb69ce537f910a750), UINT64_C(0xc781d12a6d0acd53), UINT64_C(0x0000000366f41b2c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x68eb059e94002d4e), UINT64_C(0xf42d8fac47506e3a), UINT64_C(0x00000001b6539346), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1beb4d3ca4896a97), UINT64_C(0x5dc2007b8b57dd8c), UINT64_C(0x00000003e17d7f61), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0783611776661cf6), UINT64_C(0x6de796bcc71c81d3), UINT64_C(0x000000030fe461da), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3738263224214c0f), UINT64_C(0xde16f16a8b9ffe7c), UINT64_C(0x00000000a5d87e72), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc4ada7ae0c90c6d5), UINT64_C(0x8b1f3ba4ee67ae80), UINT64_C(0x00000002068279b3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x579c2ee7a89dcc25), UINT64_C(0x659573debfc21808), UINT64_C(0x0000000320301ca2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x34c1f1c35ffb738e), UINT64_C(0xcb0f15b2e49b7376), UINT64_C(0x000000026e48bb71), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8ce1d5f574ad9194), UINT64_C(0xc6fbf8642e7fedd8), UINT64_C(0x00000002b25b5adb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2f12e64802d0de63), UINT64_C(0xc82d9870917f2b0b), UINT64_C(0x00000002ea0ec700), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaced967e56aa1a14), UINT64_C(0x70606e9d0c4e58ca), UINT64_C(0x00000002ec33c793), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc46ea9ac565aff50), UINT64_C(0xd8319c602c3f9161), UINT64_C(0x00000000f811863c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb78813f291912cae), UINT64_C(0x6c5b32d24cdf0cd5), UINT64_C(0x00000001cf832c34), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbe850356c74acf11), UINT64_C(0x0e49e4ea9d9fb539), UINT64_C(0x000000021262602f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf1bab302acc26e09), UINT64_C(0x8462117cc1ec0ce8), UINT64_C(0x000000031ebceb84), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4d55f87264c47b81), UINT64_C(0xf4cd2fd9f39a0c2c), UINT64_C(0x00000000c0b1a4f3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x44220b8b47517098), UINT64_C(0x65d19ae1e62c45d2), UINT64_C(0x00000001ba21a4ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf03a49942cd572bd), UINT64_C(0x9211d1b834b60895), UINT64_C(0x0000000110df46ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xde7fece60d9c5ca6), UINT64_C(0x91d099e333205ca2), UINT64_C(0x000000032fece8a6), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5a17ca5c636dafe5), UINT64_C(0xabf3b73fd37c8c1d), UINT64_C(0x00000001a1d45a68), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x34eb32c48a1a5a95), UINT64_C(0xbcff2ee463ee1299), UINT64_C(0x00000002edaf6c14), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_24[] = {
  {{ UINT64_C(0xb2810049e80035fe), UINT64_C(0xf75c5804146cc5f0), UINT64_C(0x000000008ef6217a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x92a42654b875946d), UINT64_C(0xa32bffbdf5add4f0), UINT64_C(0x00000001709b5884), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7251313e9cb04b80), UINT64_C(0xe5003f9a7c64f4b2), UINT64_C(0x00000002c83de332), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb920e5b51ebf90e7), UINT64_C(0x0cd4a59225fb6ef6), UINT64_C(0x000000036913dfc1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7a95df448060465d), UINT64_C(0x2846eee6b51b7533), UINT64_C(0x00000002a017faf3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc42c742694139a6a), UINT64_C(0xf93b1e36e2545717), UINT64_C(0x000000022fb082d9), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x907021f74e02588c), UINT64_C(0xec6f8e23f6e9db97), UINT64_C(0x000000000e50b631), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc610be5e903aae1a), UINT64_C(0x7022484d7a8868c3), UINT64_C(0x00000001f8e6d804), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6cd93ec2d52b068f), UINT64_C(0x83d24a93e9f75e48), UINT64_C(0x0000000192d347d1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x410fc7e62b48703e), UINT64_C(0xd26da41821bbcbed), UINT64_C(0x0000000175a18f1a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9e02e86bc07fc343), UINT64_C(0xf2fe56567b9a34aa), UINT64_C(0x00000003ed71c544), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x24d5cd287639255e), UINT64_C(0x99687409316b6d96), UINT64_C(0x000000031455b71e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x35a59e502e60a906), UINT64_C(0x066ee1dccd63a77a), UINT64_C(0x00000002f46a32b3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe063cbcac36225b5), UINT64_C(0xdefb1afd0a4a9826), UINT64_C(0x0000000024eeaf53), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6362d0f3f163fad5), UINT64_C(0x2ea1e904d211bc56), UINT64_C(0x000000009a5b77d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x65b6def7b76d3897), UINT64_C(0xfdecfc8c86d656a4), UINT64_C(0x000000021be91998), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd3607a76f6d6f26), UINT64_C(0x32516990023de7b4), UINT64_C(0x000000001d558a59), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe6b8f7ccb90a85e6), UINT64_C(0x654f544d9ed83c96), UINT64_C(0x0000000220156985), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x30d04afad958986d), UINT64_C(0x554c9c84a938aef4), UINT64_C(0x00000002e1ce8e47), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd369ae7a57963e6c), UINT64_C(0x044db83ea6300ab2), UINT64_C(0x000000007dab1d3b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x11a020ee66796d90), UINT64_C(0x435651ac7dace9e6), UINT64_C(0x00000000cefd0b81), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1aa3522b7bfb669a), UINT64_C(0xbaf59858210dfb7e), UINT64_C(0x00000003cb107990), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8e3835f6041ba89f), UINT64_C(0x7c5e09769c2d35f2), UINT64_C(0x00000003204dfa0f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f3b27e24e4638ce), UINT64_C(0xe16bcead44af2dcc), UINT64_C(0x0000000359bb039b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf3021519d4be736d), UINT64_C(0x14cc2486ff3c3730), UINT64_C(0x00000003d463518b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2ea122e3d8d85836), UINT64_C(0x1ae5a56058b5e417), UINT64_C(0x00000002c310996e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x375cdd08e39839b6), UINT64_C(0x1386920eecde63ed), UINT64_C(0x000000035c79c711), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe1dc4b0c9de4d740), UINT64_C(0xef361d902c59ee38), UINT64_C(0x00000002b93af927), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd6c6fa93b5780ec5), UINT64_C(0x978536234aa17bd0), UINT64_C(0x000000039a8bd35c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4f0dd6dfa1f47ee4), UINT64_C(0x16f13d812a2cd66f), UINT64_C(0x0000000021992bcb), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_25[] = {
  {{ UINT64_C(0xeeb2b19a2185ce66), UINT64_C(0x0260a0d44fd01ee9), UINT64_C(0x000000013d6bd2b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeacf68f68224ab09), UINT64_C(0xc6ef3bb61e83cc50), UINT64_C(0x0000000002b9cff3), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x153523861b59bce0), UINT64_C(0x4d6775cac25a2ed8), UINT64_C(0x00000001ca668486), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1bf6c299a82d2da8), UINT64_C(0xa7484a3a8e7fa965), UINT64_C(0x000000014d0daf77), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x16d9f42a40595edc), UINT64_C(0x027b6d9c21f66167), UINT64_C(0x00000000dcf88955), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x372e9fbf8739816e), UINT64_C(0xe44cb278f939e862), UINT64_C(0x00000000d2d7dc5e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x87d963d5e76f48b7), UINT64_C(0x453d7e1ffd3df375), UINT64_C(0x000000012cbd3803), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x561eba9add41de36), UINT64_C(0x769de49ef38f6b71), UINT64_C(0x00000003a221644a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9d52a35527446bba), UINT64_C(0x74917d2e738827bc), UINT64_C(0x00000001deccd9da), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe335cac1c19f197f), UINT64_C(0x95f7caec194cb19c), UINT64_C(0x00000000e4fd0683), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaf00c7b4dbf92ad1), UINT64_C(0x27d5f47b582faa62), UINT64_C(0x00000001ad390ca0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8b692ce7a2e80973), UINT64_C(0x57adb436948076b6), UINT64_C(0x000000010a10d721), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x51c2759896fb9260), UINT64_C(0xd73d5075c90abb1f), UINT64_C(0x00000002ab1e3a4c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe151dd77d3717ed), UINT64_C(0xdd3063f3add93240), UINT64_C(0x000000003869eb8e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x27cdaea48361c84c), UINT64_C(0xc27208663a687a23), UINT64_C(0x000000012301f46a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xab9788abff2627c7), UINT64_C(0x1f0ce9dd987bed50), UINT64_C(0x000000022a6423bf), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa0f72a70812119ec), UINT64_C(0xd499df11561019e2), UINT64_C(0x000000028f9ae825), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa476fd6a2d19723c), UINT64_C(0x648320b36704ea3b), UINT64_C(0x00000002e6e9af48), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e3e3881906e8a76), UINT64_C(0x5cc3c3ce06df9c0b), UINT64_C(0x000000013ecf8534), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8a15004d3b34c07d), UINT64_C(0xca604abbcf3d675f), UINT64_C(0x0000000390a9b467), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xca7e88fc15c4722c), UINT64_C(0x5f4f419a301b9948), UINT64_C(0x00000003637b0e9c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa609b2ebcf76d90d), UINT64_C(0xb68789df4f65ab6c), UINT64_C(0x0000000238022e14), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbe793eb48a7ab931), UINT64_C(0x6994d15b3622546d), UINT64_C(0x00000000ed487a0e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe5b876343065fbaa), UINT64_C(0xd713ae39b755bd1b), UINT64_C(0x000000027408ff80), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaca8a3272ab98692), UINT64_C(0x82843a95ebd410e0), UINT64_C(0x0000000124c20615), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xca5a0fa32afc2be5), UINT64_C(0x61df1d3fe304da08), UINT64_C(0x00000001ac82f4b2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0b5cac970e611ab4), UINT64_C(0x3231e13e6f8e57ee), UINT64_C(0x00000001b53f6074), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x727a335c53a8e35d), UINT64_C(0xf67f5210ccb3965e), UINT64_C(0x000000028e41184f), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc9f420a0b93a01c9), UINT64_C(0x1b64d15b6ea5516e), UINT64_C(0x00000000f4b556ce), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd5ec2d66f5976f79), UINT64_C(0xf8acd2c125f89b34), UINT64_C(0x000000020490e826), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_26[] = {
  {{ UINT64_C(0x746dcb28607971ab), UINT64_C(0xc2ca54093c3e5184), UINT64_C(0x00000000fb2224ae), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa89f87261170a4d0), UINT64_C(0x30f8019df7d3f2df), UINT64_C(0x00000001730e69bb), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3980c72085e40483), UINT64_C(0x239f8462f3ba11d2), UINT64_C(0x000000017a912113), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe75c46f445eb5bc5), UINT64_C(0xed2db03ba6a15980), UINT64_C(0x0000000214da05aa), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x00c5ca9d4facb982), UINT64_C(0x68060328fc72ca4d), UINT64_C(0x00000002738ad0ed), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e1d2a85ec99782a), UINT64_C(0x9df937ff2319b3e1), UINT64_C(0x000000011cf815d5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x70a9042f8b76baa8), UINT64_C(0xde69c7d08e9b33a5), UINT64_C(0x000000037662a7ed), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb58074b7285df86), UINT64_C(0x36a52367026f8feb), UINT64_C(0x0000000158a6cd22), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x817ce952ce82af71), UINT64_C(0x853dc1fa11f185fc), UINT64_C(0x000000008f5b5f3a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8b1c47350f010635), UINT64_C(0xdac4a09c2879e03b), UINT64_C(0x00000002bb29b5b7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaccc623f65d7ea55), UINT64_C(0xd042e5d029a7bceb), UINT64_C(0x00000003884004dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x46f54003eccd878b), UINT64_C(0x92ef3377731e06e6), UINT64_C(0x00000001abe5bb36), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5a3bec5e71975aa9), UINT64_C(0x32f3d80e337d0f6c), UINT64_C(0x00000002c92f54b7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x44523d3950672ec2), UINT64_C(0xbe11eae85e775b6e), UINT64_C(0x000000014890e543), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x824eb9a0b59d34b4), UINT64_C(0xd346411d8a1838ad), UINT64_C(0x00000002233e6f38), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x260103a4e0008300), UINT64_C(0x96cba14013ef8317), UINT64_C(0x00000001d8e19f27), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0db97116c65889d1), UINT64_C(0x08e95cf3c52872ee), UINT64_C(0x00000003b199d416), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x076376cc5ab24319), UINT64_C(0x120d8d728df50d83), UINT64_C(0x000000027955ca43), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9739610917880bfc), UINT64_C(0x80ac931db5c80a35), UINT64_C(0x00000003f76c9278), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xef9ab504790b7d85), UINT64_C(0xb802dd82bc5e8c43), UINT64_C(0x0000000285939646), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9eecb06abb57c676), UINT64_C(0x2057a660e92b766c), UINT64_C(0x000000029b847bd5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x83342fd615317d35), UINT64_C(0x095d1c3a3118694c), UINT64_C(0x0000000086d22299), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xab0ebfb7230b0cff), UINT64_C(0x5c91a2bc3ee30a1c), UINT64_C(0x00000002769bbb62), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x184b2b619bf17dd1), UINT64_C(0x40d08efd6de296ea), UINT64_C(0x00000002d0d6b3cd), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x89835bdab381127b), UINT64_C(0xf970ca84bd306f4e), UINT64_C(0x0000000204b253d2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x795bd72c731475b5), UINT64_C(0x896c389deec93148), UINT64_C(0x00000003cf41fc28), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x00821414d29d063e), UINT64_C(0x0aa6ccde9f393043), UINT64_C(0x000000001aec2e1a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x63f91698641b3763), UINT64_C(0xb346972a9a3e498d), UINT64_C(0x00000002f7d1fb96), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xddd6f27a43d89ee0), UINT64_C(0x84b62c1d2b5199a5), UINT64_C(0x00000000346d8908), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc0e0c428d7ebb519), UINT64_C(0x8458a3dee1f3c31d), UINT64_C(0x0000000167e7fbfa), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_27[] = {
  {{ UINT64_C(0xb05516a71a7a0ccf), UINT64_C(0x70f760620e85c15b), UINT64_C(0x000000016d70322c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8a9a9c0302872652), UINT64_C(0xc2524a718ccee592), UINT64_C(0x000000004b7c472d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf76efbe79bc5bf41), UINT64_C(0xfe556fa6b197d356), UINT64_C(0x00000001f2a5a910), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe9397cd0eadde04), UINT64_C(0x6ff7f1002fef933e), UINT64_C(0x00000003edc72b54), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x250a628acbfec196), UINT64_C(0xda01c7bd5b10c461), UINT64_C(0x00000000ef185815), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4d4d73bc530de66d), UINT64_C(0x010f341426730166), UINT64_C(0x0000000235985677), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd9e98265bd417b54), UINT64_C(0x37788d1021081bec), UINT64_C(0x000000030a981767), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x450ce581b68c3c39), UINT64_C(0x8fecba07cf8168d6), UINT64_C(0x00000000afa9c685), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x67b6272e1e176509), UINT64_C(0x0d7560a823795db6), UINT64_C(0x00000001e20e3350), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe5a155d477903138), UINT64_C(0x812535a2d9d56d42), UINT64_C(0x000000011a2c6262), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x12f15cdb57ad0faf), UINT64_C(0xac5f111cf2d0ee8e), UINT64_C(0x00000000a50b6902), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3fffd694c8a0d1c0), UINT64_C(0x22da3fa364357554), UINT64_C(0x00000003b0417dd1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd465a3f0d919bb77), UINT64_C(0x1cfd82c552f974e9), UINT64_C(0x00000003c534b750), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9fd233d8ad7def51), UINT64_C(0xe4fc197ccded13ce), UINT64_C(0x00000001577ffb0a), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8bc00f027d2a03c1), UINT64_C(0x4777d225de6b5a11), UINT64_C(0x000000009b2d83b2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3a2dccf92298eff7), UINT64_C(0xe194fdaa0861c5f3), UINT64_C(0x00000000b84ac0b1), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb4cfbe625f5ccd58), UINT64_C(0x172d2e2a99591146), UINT64_C(0x0000000056ddcd26), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x75a8d7816908dd37), UINT64_C(0xad6491631a26567f), UINT64_C(0x00000001875f6478), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfeb7d7dfb8dc7ca4), UINT64_C(0xb15b5cd8d60cfeab), UINT64_C(0x00000000a0cc6b8d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x77d9a7520a2a69dc), UINT64_C(0xc6918204df204142), UINT64_C(0x0000000319a38378), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd04ea6935d605699), UINT64_C(0xca2893d83f9874dc), UINT64_C(0x00000000391a3011), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x351f8aa249e9b29b), UINT64_C(0xf24863264db1fb63), UINT64_C(0x00000001d49185a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0f0a1dcd56254cfb), UINT64_C(0xc59755a382e4b3ef), UINT64_C(0x00000003ac49796d), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0bd6b19e543f5e9f), UINT64_C(0xe7c8b6cf3462d6be), UINT64_C(0x00000002b416a793), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x66f215ce1311f831), UINT64_C(0x41426e3a07cc7474), UINT64_C(0x00000003abb06301), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0a6ccf53928377d1), UINT64_C(0x40d4a6379340c2e8), UINT64_C(0x000000004432f86c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5389ae18525c53af), UINT64_C(0x88973e542c16b530), UINT64_C(0x00000001e7f6ed27), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd9c49c731d004da8), UINT64_C(0x4df97d1049e6ea65), UINT64_C(0x0000000306efb496), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5247cd96f85e2046), UINT64_C(0x0b45edd312f7f796), UINT64_C(0x000000022d889311), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd47e73c09cb25110), UINT64_C(0x035a7298b0c6defe), UINT64_C(0x00000003e2af6f66), UINT64_C(0x0000000000000000) }},
};

static const block_t Ri_28[] = {
  {{ UINT64_C(0x78870e60afbecfa9), UINT64_C(0x73f3bae68060847f), UINT64_C(0x000000019be977fc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x513beedae99d8d0e), UINT64_C(0x31540ecdb4831bd4), UINT64_C(0x00000001321c8f98), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x60f29fd1f704d666), UINT64_C(0x984154318c65fa1b), UINT64_C(0x00000001ad5f1d48), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6230375239185546), UINT64_C(0xd53ff82efa5a9079), UINT64_C(0x000000013978d5ea), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x326402fd076a27cf), UINT64_C(0xf1ae3110c64211c1), UINT64_C(0x000000012a064879), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x95a4dc62475aed0d), UINT64_C(0xb24089ce72462bd8), UINT64_C(0x000000011cfb2dd7), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x94b8f1ab863ed1e9), UINT64_C(0x80eaa70b074bda8e), UINT64_C(0x00000001479ad545), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5c146991288e3c08), UINT64_C(0x6f577554d6311f3b), UINT64_C(0x00000001440fff64), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x49b455b97a87c6e6), UINT64_C(0x6dcb641e6ab33f6e), UINT64_C(0x0000000026a36664), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1509db7cd1910707), UINT64_C(0xf48acacfa4700ffc), UINT64_C(0x00000003e819ad4e), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc1db5e46e2fd5f1e), UINT64_C(0xd925a08087669e55), UINT64_C(0x00000003531705e5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x226a123473467202), UINT64_C(0x0e4ab52147afa3dc), UINT64_C(0x00000002a8cfcd5b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9d88eef45820a2b2), UINT64_C(0x4dfd88de9f654872), UINT64_C(0x00000001f28c9214), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbf71aa37b6837336), UINT64_C(0x8d8495de90d5568c), UINT64_C(0x0000000031a6f0f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x61efa7b0d9fbdf90), UINT64_C(0x07ce9294ff5226f0), UINT64_C(0x0000000313a64a10), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x594db8bca82fdd9f), UINT64_C(0x66ea0e6eee598b6c), UINT64_C(0x00000002e6e5f705), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa35f68e650517132), UINT64_C(0xfd6c135729bae8e8), UINT64_C(0x00000003fe669bc4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x180c5493302d0188), UINT64_C(0xd6d5c3a20a506ceb), UINT64_C(0x000000019b1c2516), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9c4b6c187c54715e), UINT64_C(0x919de8749967f838), UINT64_C(0x0000000247ad97a2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x12a5ec44ef29e843), UINT64_C(0x49bade18547b0ae0), UINT64_C(0x00000001b77de8b5), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb8640e439e903205), UINT64_C(0x8170615e885392b0), UINT64_C(0x00000003f84c9c98), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfdcd1d096de164da), UINT64_C(0x04b0fd0658ad3b83), UINT64_C(0x000000037803be93), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf0cdc6dc6572a02d), UINT64_C(0x73c3e152a51495cf), UINT64_C(0x00000003a6540dac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2586965d6bdd3e84), UINT64_C(0x978bfaebf5ff7c96), UINT64_C(0x00000001f0158a53), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc210a4f571d584c0), UINT64_C(0xb1c4b6b5a0e74c35), UINT64_C(0x000000019f0e3643), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe4bc3e17ebde831d), UINT64_C(0x8c3bbc31d37c635d), UINT64_C(0x00000003a4bf6912), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8c9971490b0f1e31), UINT64_C(0x3ab66623418db295), UINT64_C(0x00000002838a938b), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbb4f88397ba54386), UINT64_C(0x2040c6ed8d62d887), UINT64_C(0x00000000658d9ca2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb96718e0b7e1000c), UINT64_C(0xfefd03de0f7df58f), UINT64_C(0x00000001d9b9daf2), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfdac1bafe20de979), UINT64_C(0x1cb7d5df32b6e43f), UINT64_C(0x000000013019a2e7), UINT64_C(0x0000000000000000) }},
};


static const lowmc_partial_round_t rounds[30] = {
  {
    Zi_0, Ri_0, UINT64_C(0xffffffde00000000),
  },
  {
    Zi_1, Ri_1, UINT64_C(0xffffffde00000000),
  },
  {
    Zi_2, Ri_2, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_3, Ri_3, UINT64_C(0xffffffed00000000),
  },
  {
    Zi_4, Ri_4, UINT64_C(0xffffffbd00000000),
  },
  {
    Zi_5, Ri_5, UINT64_C(0xfffffff210000000),
  },
  {
    Zi_6, Ri_6, UINT64_C(0xffffffec80000000),
  },
  {
    Zi_7, Ri_7, UINT64_C(0xfffffff880000000),
  },
  {
    Zi_8, Ri_8, UINT64_C(0xfffffff500000000),
  },
  {
    Zi_9, Ri_9, UINT64_C(0xffffffdc20000000),
  },
  {
    Zi_10, Ri_10, UINT64_C(0xfffffff900000000),
  },
  {
    Zi_11, Ri_11, UINT64_C(0xffffffde00000000),
  },
  {
    Zi_12, Ri_12, UINT64_C(0xfffffff900000000),
  },
  {
    Zi_13, Ri_13, UINT64_C(0xfffffff500000000),
  },
  {
    Zi_14, Ri_14, UINT64_C(0xfffffff900000000),
  },
  {
    Zi_15, Ri_15, UINT64_C(0xfffffff808000000),
  },
  {
    Zi_16, Ri_16, UINT64_C(0xffffffaf00000000),
  },
  {
    Zi_17, Ri_17, UINT64_C(0xffffffee00000000),
  },
  {
    Zi_18, Ri_18, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_19, Ri_19, UINT64_C(0xfffffff900000000),
  },
  {
    Zi_20, Ri_20, UINT64_C(0xffffff7620000000),
  },
  {
    Zi_21, Ri_21, UINT64_C(0xfffffff280000000),
  },
  {
    Zi_22, Ri_22, UINT64_C(0xffffffee00000000),
  },
  {
    Zi_23, Ri_23, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_24, Ri_24, UINT64_C(0xfffffff600000000),
  },
  {
    Zi_25, Ri_25, UINT64_C(0xffffff7e00000000),
  },
  {
    Zi_26, Ri_26, UINT64_C(0xfffffff500000000),
  },
  {
    Zi_27, Ri_27, UINT64_C(0xfffffffa00000000),
  },
  {
    Zi_28, Ri_28, UINT64_C(0xfffffff600000000),
  },
  {
    NULL, NULL, 0,
  },
};

const lowmc_partial_t lowmc_192_192_30 = {
  precomputed_round_key_matrix_linear_part,
  Z_r,
  rounds,
  precomputed_round_key_matrix_non_linear_part,
  precomputed_constant_linear_part,
  precomputed_constant_non_linear_part,
};

