#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stddef.h>

#include "lowmc_256_256_38.h"

static const block_t precomputed_round_key_matrix_linear_part[] = {
  {{ UINT64_C(0xfc104fadfd8e1d30), UINT64_C(0x4f792ab4bfd126f1), UINT64_C(0x2e1f9b288edc0fec), UINT64_C(0xee51da9710ed3d32) }},
  {{ UINT64_C(0xe1d5d3bc4539f88f), UINT64_C(0x01dc73f3f9adfddc), UINT64_C(0x180e119999fe6e1d), UINT64_C(0x4e764d8b68a90ff1) }},
  {{ UINT64_C(0x6cf699744c0b7c12), UINT64_C(0xd3f807dcf9763819), UINT64_C(0xa9f86ef26748ac21), UINT64_C(0x67ce7020163d2ce8) }},
  {{ UINT64_C(0x5919d64762d53580), UINT64_C(0x7dacbda06eb18eaa), UINT64_C(0x426784c6c748770a), UINT64_C(0x452bd44980d52bdb) }},
  {{ UINT64_C(0x7d2a3f7373e65412), UINT64_C(0xeb92993c79fb6c59), UINT64_C(0x884835b3e2b5d4e8), UINT64_C(0x895ce4a506863980) }},
  {{ UINT64_C(0x529e4efce3a5f4ac), UINT64_C(0x2d970ddfa50cad17), UINT64_C(0xdf10b028e9adbdb5), UINT64_C(0x90e8f16737241b20) }},
  {{ UINT64_C(0x8699663ac5b79964), UINT64_C(0x27f01787548b8a1c), UINT64_C(0xa5861b7aa3b2c300), UINT64_C(0x2102208c9aaa4a15) }},
  {{ UINT64_C(0x5a37a41c4224fc7e), UINT64_C(0xbeea32da7f346c92), UINT64_C(0xae8b92dfaae4b07b), UINT64_C(0x69ea6446c198d346) }},
  {{ UINT64_C(0x39cdcc777afd0888), UINT64_C(0x7d6261af51f5c148), UINT64_C(0xdcfcf685540f1fbc), UINT64_C(0xb422ad36e4252360) }},
  {{ UINT64_C(0x39884be30a4c32ac), UINT64_C(0x79f0ec499956b65e), UINT64_C(0x8464a4ae15e1aee1), UINT64_C(0xe1ad449cabb47d14) }},
  {{ UINT64_C(0xee8fc1391a7bfe3c), UINT64_C(0x722ecfb37760c7da), UINT64_C(0xd689e68cc378604e), UINT64_C(0xcc41a7c3a106f744) }},
  {{ UINT64_C(0xb47e8f1756165e50), UINT64_C(0x496af102dd8610af), UINT64_C(0x2173ca9cde71d130), UINT64_C(0x64350a49a0f7b13f) }},
  {{ UINT64_C(0xe973ded716e3e468), UINT64_C(0xb06b15476af4677a), UINT64_C(0xbf7872fae04f95c3), UINT64_C(0x1018f9eaf6b59d16) }},
  {{ UINT64_C(0x286798a16a6a19dd), UINT64_C(0x84eadf6caa7b02a5), UINT64_C(0x868a6de34da1a6ff), UINT64_C(0xff3c7395bb9886a9) }},
  {{ UINT64_C(0xfdd64f7474644aea), UINT64_C(0xee06b96363470513), UINT64_C(0x50cac180e61eb1d0), UINT64_C(0xa3ae641b83723817) }},
  {{ UINT64_C(0xec017eab543e83da), UINT64_C(0x255e399031350b97), UINT64_C(0xddbbe1d1e29a4343), UINT64_C(0x17af359fda3a8fa3) }},
  {{ UINT64_C(0x2aaf4d2c889395f7), UINT64_C(0xc2b21bbde7a525d2), UINT64_C(0x012644d24d6df2c6), UINT64_C(0x976fe9d674bad195) }},
  {{ UINT64_C(0xed5e566250dff107), UINT64_C(0x21176c1f8707af79), UINT64_C(0x5cad57bfc77d3c75), UINT64_C(0xda0ecf2d5d52b92e) }},
  {{ UINT64_C(0x74216b486ca666dc), UINT64_C(0x349fd378ce15123b), UINT64_C(0x3cd71e182de0bb8b), UINT64_C(0x514abfb89eda2545) }},
  {{ UINT64_C(0x29adfec0f725ca64), UINT64_C(0x3a6a76ccd41bc56e), UINT64_C(0x316d35eb27e8c2dc), UINT64_C(0x7d5b099d73e3bc69) }},
  {{ UINT64_C(0xa6f6afcbec2cde12), UINT64_C(0x6511216788abcd13), UINT64_C(0xef193cc5072eea49), UINT64_C(0xb3526349adb52959) }},
  {{ UINT64_C(0x4b1d7c0dfcf16c04), UINT64_C(0xe0cef613fab97d38), UINT64_C(0x4ddde8784aa3ccbc), UINT64_C(0xde1f32ee8e573577) }},
  {{ UINT64_C(0xe92ff81e92e74a8a), UINT64_C(0x169331d29c4f9c77), UINT64_C(0x3650b5eb84587f2e), UINT64_C(0x34c92204b533691c) }},
  {{ UINT64_C(0x8a6bc1f502412fef), UINT64_C(0xc0a6f55e34a462c5), UINT64_C(0x60449f7caf2a5bdc), UINT64_C(0xcd5c7c47a5731cf4) }},
  {{ UINT64_C(0x06e27b9a4291a9ce), UINT64_C(0x35cfcb8470b8da4d), UINT64_C(0x918fb0f66fdaf1ee), UINT64_C(0x28a212d4b86e8092) }},
  {{ UINT64_C(0x7203ca0b4cbdf353), UINT64_C(0x1d2e9ee0d0108e67), UINT64_C(0xe72308ac517c246b), UINT64_C(0xc1df00ce86ab4fce) }},
  {{ UINT64_C(0x03cdcefb3bdc9ff7), UINT64_C(0x2ee466701a59def9), UINT64_C(0xbce44010d18fdfc8), UINT64_C(0x28c4a63e5db35291) }},
  {{ UINT64_C(0x2031254348de0f5d), UINT64_C(0xd8c0f25308a343b2), UINT64_C(0xaafb1a7ebaec27b5), UINT64_C(0x5885dc211c8556d8) }},
  {{ UINT64_C(0x03fcfac7e37804ad), UINT64_C(0xd1cd872b367e29ef), UINT64_C(0xaf70c63144ea7cf3), UINT64_C(0x525b2f6ae18faac5) }},
  {{ UINT64_C(0x30b0009a65f00268), UINT64_C(0x2f2b3a1d00e45f3e), UINT64_C(0xa82a355660eb2c95), UINT64_C(0xcbd66cf0d30da8cb) }},
  {{ UINT64_C(0x548daa0d6fa2ecd2), UINT64_C(0x7b274137d514e37b), UINT64_C(0x92aedf9fb8b9fb10), UINT64_C(0x675330b364960356) }},
  {{ UINT64_C(0x54578e4be1a4718c), UINT64_C(0xfc532e13edc28392), UINT64_C(0x502462281458b4b9), UINT64_C(0x3afba2aac91409d7) }},
  {{ UINT64_C(0x2bf66f047544da68), UINT64_C(0x949ba1f886af7a27), UINT64_C(0x9401d4a054f9df15), UINT64_C(0xa30216347b04624f) }},
  {{ UINT64_C(0xe7539920ac7802c0), UINT64_C(0x6b3873a91ed1499c), UINT64_C(0x81b9ddcf7fed3313), UINT64_C(0x38e9b864c2169635) }},
  {{ UINT64_C(0x6de10026bc36616b), UINT64_C(0xc62cba82e45672fb), UINT64_C(0x3ddf13b782b0d234), UINT64_C(0x18d248e9c8f7efcd) }},
  {{ UINT64_C(0x945db16c64b1a723), UINT64_C(0x7eecef2ab954d3d6), UINT64_C(0x5234b69be7a60b9b), UINT64_C(0xaa486f35e28a8a15) }},
  {{ UINT64_C(0x94faaa2f68ef4263), UINT64_C(0x596162f0d02147b9), UINT64_C(0xac12d0384ee0c6ec), UINT64_C(0x37d38c218193ed2c) }},
  {{ UINT64_C(0x5ef5bfdd924b7e8a), UINT64_C(0x4b01af34f9d2c210), UINT64_C(0x9ea7cb61393714c3), UINT64_C(0xcff8ee0ca9035401) }},
  {{ UINT64_C(0x02e71a8d0a038767), UINT64_C(0x0288352ca519f8e4), UINT64_C(0x0a7e269e72dcf842), UINT64_C(0xd80ce996f63cba04) }},
  {{ UINT64_C(0x7d30ec29b526db58), UINT64_C(0xeac346549ee3dc32), UINT64_C(0x592650b059954c2b), UINT64_C(0xb22c729c761aeb55) }},
  {{ UINT64_C(0xd332126e3b93f7ab), UINT64_C(0x7a4e2e1957ac5228), UINT64_C(0xa4f453e2ae294987), UINT64_C(0x0f2401df1395cb40) }},
  {{ UINT64_C(0x9ea83ae612fc8888), UINT64_C(0x02fdf688ca194557), UINT64_C(0x2e4004b37e61d043), UINT64_C(0xb607551fd36eacfb) }},
  {{ UINT64_C(0x8b0beffee2289752), UINT64_C(0x77c8685d4961b0c6), UINT64_C(0xcae1060db85e6655), UINT64_C(0xd17f52bf9ac62166) }},
  {{ UINT64_C(0xd77e502f9105b0c1), UINT64_C(0x7ec90f211634ee75), UINT64_C(0x1e452d306d7c4222), UINT64_C(0x08537f4990f66697) }},
  {{ UINT64_C(0x7c91679ae9e98d01), UINT64_C(0xa86c4f081c402765), UINT64_C(0x7f1907304abdb09a), UINT64_C(0x778c4ecdec4fe8f6) }},
  {{ UINT64_C(0x5acf2eb2d8925aea), UINT64_C(0x029d62603ef0cc8f), UINT64_C(0xdcce1818112ed604), UINT64_C(0xa97d7ae40cfa1812) }},
  {{ UINT64_C(0x91e2eab18591f2c9), UINT64_C(0xa8e4081f54183600), UINT64_C(0x912f8f37550314be), UINT64_C(0xe8525ba5b95aa96e) }},
  {{ UINT64_C(0xd0f6a9eea597b105), UINT64_C(0x8cdaf610868c3f40), UINT64_C(0x2877b54f4cc1b5e4), UINT64_C(0xc41c410ceb4d0510) }},
  {{ UINT64_C(0xd9cfeead7da8b659), UINT64_C(0x34f2e494c628a215), UINT64_C(0x90b84d19a2d6b651), UINT64_C(0x5ba0505d8ef218c8) }},
  {{ UINT64_C(0xccfb6d1d9ce4d171), UINT64_C(0xfb6f42ff91c42d04), UINT64_C(0xf3a16869bdae3ece), UINT64_C(0x6c5056f767d33994) }},
  {{ UINT64_C(0x0fe9b786b64fa8e7), UINT64_C(0x80f20c71273bbb2e), UINT64_C(0x1846e1de997e0415), UINT64_C(0xab7173032790a5c2) }},
  {{ UINT64_C(0xf148f508fc65b3be), UINT64_C(0xbd08be887e583333), UINT64_C(0x0a90f5c5341bbbba), UINT64_C(0x4d8b0748c3b30ff7) }},
  {{ UINT64_C(0x2007632567b47d2b), UINT64_C(0xf05794daf450f340), UINT64_C(0x99e086c2ed1c3373), UINT64_C(0xb125318e5f5620f4) }},
  {{ UINT64_C(0x6a5ca6e1d34c059f), UINT64_C(0xe678aa6526d4e77d), UINT64_C(0x0b3fd082206bba37), UINT64_C(0xfbac5f312cf862bc) }},
  {{ UINT64_C(0x4faef6de2d4eb570), UINT64_C(0x737e03c690e7a144), UINT64_C(0xd572f0d440a13073), UINT64_C(0x83b501e7b19f5f7a) }},
  {{ UINT64_C(0xc7ab9d6cf273d1f6), UINT64_C(0x9e07fc59ac9b09f8), UINT64_C(0x774e30e227d3f4ee), UINT64_C(0xbfb62afb8a46c0db) }},
  {{ UINT64_C(0xd675a0912dade904), UINT64_C(0xd43ffb72f3a9966f), UINT64_C(0x384d6f588de4bb8b), UINT64_C(0xd0abddafbda2935f) }},
  {{ UINT64_C(0x0a7d925879a6374d), UINT64_C(0xcab6a5686979e703), UINT64_C(0x3a7f2c0257078bbc), UINT64_C(0xe94152713e3a2369) }},
  {{ UINT64_C(0x116cb4484325ac86), UINT64_C(0x99bd8f3555257c73), UINT64_C(0x44b19760bf928306), UINT64_C(0x3687081e7e077c32) }},
  {{ UINT64_C(0x07d7e3a94a77147e), UINT64_C(0x9589e1008c7bff54), UINT64_C(0xf4785fe34045665b), UINT64_C(0x16de624663d495ec) }},
  {{ UINT64_C(0x21ceba3ec65b9334), UINT64_C(0x4ac21c2b674a8d05), UINT64_C(0x3541299789e4307f), UINT64_C(0xf2450d61d358e21e) }},
  {{ UINT64_C(0x0dc13c9d693bf258), UINT64_C(0x92166cf87cb18bc2), UINT64_C(0xb66340dc6cd0ab30), UINT64_C(0xe98beccc202426ad) }},
  {{ UINT64_C(0x1662a851f094cab2), UINT64_C(0xbfba782dcb2f6afe), UINT64_C(0x7228719696635000), UINT64_C(0x98d46c3947a1d783) }},
  {{ UINT64_C(0xb2af80dd733d5360), UINT64_C(0xab8c9d79e9d68729), UINT64_C(0xb428b84a0ad0c06e), UINT64_C(0x03523285a01fba05) }},
  {{ UINT64_C(0x640b1507fff4cb55), UINT64_C(0x2cfc8b7ba0c32c43), UINT64_C(0x63201b428a918fb9), UINT64_C(0x5d642b55443a29d4) }},
  {{ UINT64_C(0xfb37cb1c971efeef), UINT64_C(0x99c79f8f92dfef03), UINT64_C(0xe8ebc344c724fdb5), UINT64_C(0x0041070949b61273) }},
  {{ UINT64_C(0x6c36e93ebb043129), UINT64_C(0x941b6d00537af9c1), UINT64_C(0xb35663b386db2eb7), UINT64_C(0x204cc9d51874fe8f) }},
  {{ UINT64_C(0x80b6d1d2a4e340b7), UINT64_C(0x3cc544683d4502ab), UINT64_C(0x703a118db86d9e59), UINT64_C(0x373a690b2379a056) }},
  {{ UINT64_C(0xe22b6eef45084565), UINT64_C(0xfbb80e9bdaf3ae51), UINT64_C(0xf7f8fa723a5396ca), UINT64_C(0xde0293f39b98f6c0) }},
  {{ UINT64_C(0xc4b76294fe3936d6), UINT64_C(0x55c4f5818046e7d2), UINT64_C(0xb1ae52a4ca25e0b1), UINT64_C(0x40759f45b0a65fa8) }},
  {{ UINT64_C(0x4b87116747bc5a74), UINT64_C(0x9b52da62458dee18), UINT64_C(0xebd8886396179ea8), UINT64_C(0x288e39151d69a683) }},
  {{ UINT64_C(0xf2aa3b1bb5aa4eff), UINT64_C(0x34ee447ba8f10760), UINT64_C(0x7d949e1129cf6cb4), UINT64_C(0xaa153da36b366f6d) }},
  {{ UINT64_C(0xd564368564dc786f), UINT64_C(0x6ffefc28925e300f), UINT64_C(0x14d5bcd076954ed2), UINT64_C(0x1b25dc02d0a74e3f) }},
  {{ UINT64_C(0x08fb5541b150c60b), UINT64_C(0x2d105a92c6cd2d7e), UINT64_C(0xce267433358d0a25), UINT64_C(0x782379ac942d594d) }},
  {{ UINT64_C(0x582561b0fd11b736), UINT64_C(0x809c99d1bbf46451), UINT64_C(0x7ff3b021c8979009), UINT64_C(0x930db1b833a7a044) }},
  {{ UINT64_C(0x3afa272bb3a9e82a), UINT64_C(0xd438669aa5c2324d), UINT64_C(0xf088b5ed255ca777), UINT64_C(0x0b60020eca9759a1) }},
  {{ UINT64_C(0xea68884ae90e8f58), UINT64_C(0xa3ae943fde93b7bb), UINT64_C(0x8eafa5b0619bb437), UINT64_C(0x340eb6e871bd1cfd) }},
  {{ UINT64_C(0x7d5b26caec2b31c8), UINT64_C(0x616cf1a5d2071bfa), UINT64_C(0x30fe325e08987815), UINT64_C(0x6fe3754abc49083e) }},
  {{ UINT64_C(0x8a93f6a5abddca71), UINT64_C(0x7b9e95d26a2b4ab2), UINT64_C(0x8c4e16c1676fed06), UINT64_C(0x60be0e837cfef7f2) }},
  {{ UINT64_C(0x2401ad54fc1e0e31), UINT64_C(0xf4e400c344598bd7), UINT64_C(0x08c2a1f01f2d9fa9), UINT64_C(0xf10a56881cfa1e60) }},
  {{ UINT64_C(0xa4411cb0548905b1), UINT64_C(0x13dedd392712d634), UINT64_C(0x89316a8b03109ac0), UINT64_C(0xc17ee90aab390d87) }},
  {{ UINT64_C(0xa98895899b1ef0be), UINT64_C(0x8f58c09a48143f05), UINT64_C(0x69d5873a7992728d), UINT64_C(0x3e35ec229e96d18b) }},
  {{ UINT64_C(0x5a3fa8460bd443de), UINT64_C(0x42b83f957935f3b3), UINT64_C(0x6151cc966a12afa2), UINT64_C(0xbbf67d0b58f5216f) }},
  {{ UINT64_C(0xcdf00a8f951705c8), UINT64_C(0x6d5d92f9ca9a9672), UINT64_C(0x4a126888948e446a), UINT64_C(0xcddc250f9c82515a) }},
  {{ UINT64_C(0xa8f7e499ca939c25), UINT64_C(0x1c3d6d13eefc2e8d), UINT64_C(0xa53a243ad05ae30f), UINT64_C(0xf27d02256c8a0904) }},
  {{ UINT64_C(0xd30c2b691c1905c1), UINT64_C(0x1f53f33b78fb2e44), UINT64_C(0xcbd5ec5252b98f05), UINT64_C(0x82490a8b6c9adaae) }},
  {{ UINT64_C(0x47674bd9efb9997c), UINT64_C(0x8b22e19111a7d473), UINT64_C(0x900105393585a67a), UINT64_C(0x9c5c3333d6642ff9) }},
  {{ UINT64_C(0x47e710a45d867ba7), UINT64_C(0xbbd25b84c614da16), UINT64_C(0x0320f178cab583de), UINT64_C(0x323628f5d8d076b6) }},
  {{ UINT64_C(0x0ec58bc6c3bcb234), UINT64_C(0x21b58f9f9cc676ae), UINT64_C(0xedc11ebf4096d596), UINT64_C(0x674d7cacebe2ee85) }},
  {{ UINT64_C(0x4d77ee9b07f3e32c), UINT64_C(0xc1fec1d6c15a11c2), UINT64_C(0x7d83630fab7d2b62), UINT64_C(0xee8780809dc7a37b) }},
  {{ UINT64_C(0x175aeddf2d6d6864), UINT64_C(0x2361cb210031e287), UINT64_C(0x33d6cbd730ad8b59), UINT64_C(0xdcc86daabbaa20c0) }},
  {{ UINT64_C(0x50a3578ecfc65400), UINT64_C(0xdc203d8f1a6856d7), UINT64_C(0x96f37ba9ef9c05db), UINT64_C(0x3fbfffb174628974) }},
  {{ UINT64_C(0x4f0af33db398cc79), UINT64_C(0x03a306fb4baf492f), UINT64_C(0x043afedd630e0505), UINT64_C(0x52622aa0f4a03954) }},
  {{ UINT64_C(0xad46c6ced3d85399), UINT64_C(0x1dcbf9ec2d63854c), UINT64_C(0x987b3ad513ba068f), UINT64_C(0x1eca9680e86af0ab) }},
  {{ UINT64_C(0xefe1f0f234f177a7), UINT64_C(0xa1cb2cae8a376f6e), UINT64_C(0x06cdc2efaa51060f), UINT64_C(0xad74de9b04749807) }},
  {{ UINT64_C(0x35f78ea6ee180310), UINT64_C(0x509f8a5b4645252c), UINT64_C(0xd2cd4cf93536e868), UINT64_C(0x580cc8c68dd87499) }},
  {{ UINT64_C(0x71adc260801dac79), UINT64_C(0x94a3c583a93c5f46), UINT64_C(0xc6265c229d62476d), UINT64_C(0xf2dbd508b29f3cb9) }},
  {{ UINT64_C(0x99373710b3247541), UINT64_C(0x44d02b2c9ef61e49), UINT64_C(0x602fe4fd9dd7a9f2), UINT64_C(0xac6fa50c67d4870a) }},
  {{ UINT64_C(0x074d330468e21e36), UINT64_C(0x4677f75970b94889), UINT64_C(0x9ecd44c54362388a), UINT64_C(0x88f29cbc9e6e3ce0) }},
  {{ UINT64_C(0xfbe0c258cc1452f5), UINT64_C(0xbcc66c638dc2fadd), UINT64_C(0xa88ca521cccff615), UINT64_C(0x559c170acfedafc3) }},
  {{ UINT64_C(0xc1598a80a5459b2b), UINT64_C(0x0bf4f9e3dbd8d993), UINT64_C(0xe555b8d78f052251), UINT64_C(0xb81cca0e7407c3b5) }},
  {{ UINT64_C(0xe947f4f47db1b0d9), UINT64_C(0x7cb53422096161bd), UINT64_C(0x967d1f8603f6b7cf), UINT64_C(0x52c235177b15aed5) }},
  {{ UINT64_C(0xb6d8c217a214647c), UINT64_C(0x1525ba667a144018), UINT64_C(0x721fe60b032fe3bd), UINT64_C(0xd28cf3bc9be0b6c8) }},
  {{ UINT64_C(0xa806175d249ebe27), UINT64_C(0x8659ac7c732bd0c8), UINT64_C(0xa8682ee963d12ff6), UINT64_C(0xb34a983a2fd99ad3) }},
  {{ UINT64_C(0x248472408a0961ad), UINT64_C(0xd84180e9bb9420a9), UINT64_C(0x97dee3634f0e1cbc), UINT64_C(0x5c134020965a21a6) }},
  {{ UINT64_C(0xbcf7ca856b141a27), UINT64_C(0x3fc339f61999734a), UINT64_C(0xc9107d6e65105a5a), UINT64_C(0xfd29a90cf9c69751) }},
  {{ UINT64_C(0xd088c3ffdcdbced4), UINT64_C(0x19c7e282fbb66b7e), UINT64_C(0xa65b9120e9cf84b1), UINT64_C(0x24713002ef3ef6d5) }},
  {{ UINT64_C(0xcae08c1da9e13afe), UINT64_C(0x8b2e85502bac33e1), UINT64_C(0xd114e9e18800a2e6), UINT64_C(0xe4bda898502f46d0) }},
  {{ UINT64_C(0x8aa6a0854256b593), UINT64_C(0x73ee71018eab68ae), UINT64_C(0x876ee2cfce979d3b), UINT64_C(0x427e8e39602736dd) }},
  {{ UINT64_C(0xf4d97ff0b75c896e), UINT64_C(0x90524290400f4448), UINT64_C(0x6e6171a8fd817fe9), UINT64_C(0x9eca69cdf7c56d8c) }},
  {{ UINT64_C(0x623096000d796c8e), UINT64_C(0x23122f127a487434), UINT64_C(0x02870877067d83bb), UINT64_C(0x6fc9113d9ba3d7e6) }},
  {{ UINT64_C(0xd6fca916a63d83bb), UINT64_C(0x278516342ff861c5), UINT64_C(0x0eae35308e041281), UINT64_C(0x5a4374f312b85867) }},
  {{ UINT64_C(0x0cd5b873450cc8f7), UINT64_C(0x1fa3bfdb0721da71), UINT64_C(0xf6ba64dd635525a4), UINT64_C(0xdbd90f33b0850b03) }},
  {{ UINT64_C(0xc89feb9cad633f84), UINT64_C(0xb42586328cb20462), UINT64_C(0xd407d418848d3511), UINT64_C(0x8e52fe1cde4d600b) }},
  {{ UINT64_C(0x6021bc998881e120), UINT64_C(0xa07fecca0f878f5f), UINT64_C(0x9c6ccf802a5ecd38), UINT64_C(0x561704a7f686e5ac) }},
  {{ UINT64_C(0x16523c21f50397b1), UINT64_C(0x37c98e7837e40506), UINT64_C(0xa3b12c8cc4309176), UINT64_C(0x078bd1dd936c38ca) }},
  {{ UINT64_C(0x63b09e26d5b9819a), UINT64_C(0x51145bf4f6aba0b0), UINT64_C(0xb4ed59dafc873d27), UINT64_C(0xbd83d287fa605f33) }},
  {{ UINT64_C(0x20a71a58b2f0c062), UINT64_C(0x7c488eb151a05427), UINT64_C(0x260a511a92c537a1), UINT64_C(0xae46dd5d274079a8) }},
  {{ UINT64_C(0xe96d8c23e066e2bb), UINT64_C(0x62688807148b284a), UINT64_C(0x5691ddc4d5386dae), UINT64_C(0x887b794d3c62f51d) }},
  {{ UINT64_C(0xe278bf1d17392d4c), UINT64_C(0xfbaa7ab7327e85a5), UINT64_C(0x741bba4c81271a8f), UINT64_C(0x283c6798fafabcb3) }},
  {{ UINT64_C(0xe680445c3eff1252), UINT64_C(0x1387b073b7bc08bf), UINT64_C(0xb3c8642fc56fd252), UINT64_C(0x9cbcf9dd6c7b5ede) }},
  {{ UINT64_C(0x549a5b3d994c0d49), UINT64_C(0x203758ddda7b0378), UINT64_C(0xb5dc9fb2d3e51402), UINT64_C(0x3e82e9f49b73d958) }},
  {{ UINT64_C(0x89455a577be8eca2), UINT64_C(0x0dc71b61a0a04f20), UINT64_C(0x47e8eb578bb725d2), UINT64_C(0xef86cc288dc25a0c) }},
  {{ UINT64_C(0x4dcf8260108f078f), UINT64_C(0x07ce55c4bf39fd25), UINT64_C(0x3c16e54fd482fa56), UINT64_C(0x42c68b73b2d818eb) }},
  {{ UINT64_C(0x1788c0c82a7c68e5), UINT64_C(0xf07a69ae915b874f), UINT64_C(0x05ce4a9b71268167), UINT64_C(0xfaae3bff79a70b02) }},
  {{ UINT64_C(0x50697f3d367e06d2), UINT64_C(0x3ccd6b7d8d8f2540), UINT64_C(0x75004823c9324aee), UINT64_C(0x9609e11ff3a8fb45) }},
  {{ UINT64_C(0xc9eaeb22d87cec7b), UINT64_C(0x8a08a7d72db30438), UINT64_C(0xb76c67a825ab7f09), UINT64_C(0x0d8fb1bbb1855243) }},
  {{ UINT64_C(0xbf28626e38782080), UINT64_C(0xc39f8fce3de9039a), UINT64_C(0xb298a617c5b85759), UINT64_C(0xe221707890d65b44) }},
  {{ UINT64_C(0xeb859264e6a69908), UINT64_C(0xc53800a04fc2b41c), UINT64_C(0xd7062e894b12d76b), UINT64_C(0x4ed3767a5abd90fe) }},
  {{ UINT64_C(0x78073fac73a9f3ee), UINT64_C(0x4f776351c7108e83), UINT64_C(0xf17304c5391dd124), UINT64_C(0x9909e351a1b84761) }},
  {{ UINT64_C(0x362521dd029100cd), UINT64_C(0xe030d9e8d8cfba91), UINT64_C(0x87779a689478ae1f), UINT64_C(0x9bd86e7e111bcbdc) }},
  {{ UINT64_C(0xecd7da72abe77cc5), UINT64_C(0x7550d447b68c7b4e), UINT64_C(0x810002ef9be1ed1b), UINT64_C(0x3051f074a94bc422) }},
  {{ UINT64_C(0x920fcd51a7c2c1fd), UINT64_C(0x0f736a6c1362bcec), UINT64_C(0xbc55f22f383897ad), UINT64_C(0xb101e48f1b5e9d66) }},
  {{ UINT64_C(0x39b687aad2e577a2), UINT64_C(0xa1a8b3e5c943ba60), UINT64_C(0xbc6b375662dea585), UINT64_C(0x95d46cbad0ef75db) }},
  {{ UINT64_C(0xc9369102d42baebc), UINT64_C(0x9d61c3e2beaa53d1), UINT64_C(0x531b62215cf3557c), UINT64_C(0x8984b40ae62202e0) }},
  {{ UINT64_C(0x60836d559faabbdf), UINT64_C(0xfe58fbedea8d9a12), UINT64_C(0x20b4eac556a3f94f), UINT64_C(0x54cfca9126f22730) }},
  {{ UINT64_C(0xb2dd3e1a8d165534), UINT64_C(0x65562b6ca47176c2), UINT64_C(0x7c9f96bc395b9c2b), UINT64_C(0xc92d953ff7338e50) }},
  {{ UINT64_C(0xc84e0a2dafa0f228), UINT64_C(0x896a38f63bb20d97), UINT64_C(0xf7b837f67d98c6bd), UINT64_C(0xb423aedb460171b4) }},
  {{ UINT64_C(0x0c94f36f4fc6514c), UINT64_C(0x25f4de64359d67b7), UINT64_C(0x8eacaeaf0ab75b63), UINT64_C(0xdf042f3353ef9d08) }},
  {{ UINT64_C(0x7697f3dd2d1efa43), UINT64_C(0x3c8452a5aea23d6e), UINT64_C(0x9c5bbd3b33999b11), UINT64_C(0x702e288a53e372f4) }},
  {{ UINT64_C(0x27cea30a405df99a), UINT64_C(0xac8cbb266d995e6d), UINT64_C(0x5b56e3f3cbef7bf5), UINT64_C(0x5140529549afcf14) }},
  {{ UINT64_C(0x0b4bf32e30dba82e), UINT64_C(0xca120fc7c823fcaa), UINT64_C(0xe706fd215b49e575), UINT64_C(0x99224c8a20e88a52) }},
  {{ UINT64_C(0xff1b0faae2fab8e2), UINT64_C(0x256e2f2a6973f4cb), UINT64_C(0x8c5d240097bdca3e), UINT64_C(0x5527ad1446624fb9) }},
  {{ UINT64_C(0xee76637ec8c41081), UINT64_C(0xaad4cee3dc9be955), UINT64_C(0x58b847ca38cdd13c), UINT64_C(0x4020fe9c1050c938) }},
  {{ UINT64_C(0x20ab4903b2555ee4), UINT64_C(0x82080b28b3cb5e67), UINT64_C(0x9ee5e34606c99332), UINT64_C(0x8c3de85cb0c9c3f9) }},
  {{ UINT64_C(0xb03b79f62a8ce906), UINT64_C(0x414faf91642e6c28), UINT64_C(0xb622b821adfa4738), UINT64_C(0x0a41e7c6eaf3ac68) }},
  {{ UINT64_C(0x926250fb4358f7b3), UINT64_C(0x28e41d4b7b7e9f69), UINT64_C(0x886ac4c77cfb8d99), UINT64_C(0xd03476fe4de1cdf6) }},
  {{ UINT64_C(0xe63e309be9a7419e), UINT64_C(0xde1376828066ebf6), UINT64_C(0xb0d57c274afaec70), UINT64_C(0x171ceb18c9de94eb) }},
  {{ UINT64_C(0xf9bb8c61c5ce3797), UINT64_C(0x7b81d787c71838aa), UINT64_C(0x660bc51e23111010), UINT64_C(0x42ad8363421528b5) }},
  {{ UINT64_C(0x316792a2eedfe1b0), UINT64_C(0xab50d081c2d3c1a0), UINT64_C(0xb2c58a70e883725a), UINT64_C(0x4ee35860fffc44d7) }},
  {{ UINT64_C(0xdb4af15e21b58e60), UINT64_C(0x60412f41e7e5bdcb), UINT64_C(0xb252ceaa4a6db80e), UINT64_C(0x68219b3c9f097dcf) }},
  {{ UINT64_C(0x4d1d876e820b1651), UINT64_C(0x83353bad123ac46c), UINT64_C(0xab3d7caf939c6543), UINT64_C(0xff1f265e8e5a1f5c) }},
  {{ UINT64_C(0xa90cb92a6ba8884c), UINT64_C(0xb8d5ddd32c33d980), UINT64_C(0xb699617d7a336061), UINT64_C(0xf58a93a07f1115f5) }},
  {{ UINT64_C(0xa63f585881c9ea5e), UINT64_C(0x57695e7771d50f6f), UINT64_C(0x5443d7762226af83), UINT64_C(0x094e627a58217307) }},
  {{ UINT64_C(0xbf3db9da247bb3bc), UINT64_C(0x7732b1eb170e3f7c), UINT64_C(0x09de9a55195564c1), UINT64_C(0x1707a5ee0d8a32a1) }},
  {{ UINT64_C(0xf7ba2ec8f6bcbde3), UINT64_C(0x0e343f7d68bdc7d2), UINT64_C(0x8c2f14c9779e419f), UINT64_C(0xf1375921d370636f) }},
  {{ UINT64_C(0x174d95392e248bc7), UINT64_C(0xacc8f71c4b5c8a6c), UINT64_C(0xbe6fdee477bdff05), UINT64_C(0x7f5b5459fec19318) }},
  {{ UINT64_C(0x2267bc4dac3f13e0), UINT64_C(0x54140f4539d39555), UINT64_C(0x38914953a6790943), UINT64_C(0x7af2e8b82126c1b4) }},
  {{ UINT64_C(0x943b31269c63784e), UINT64_C(0x7306a3d36f5e38d3), UINT64_C(0x619592c8a47d33c6), UINT64_C(0x05e9044ceb54ed98) }},
  {{ UINT64_C(0x8f3a4363b3e56f96), UINT64_C(0x89d6cb4f2b7de7aa), UINT64_C(0x50243afddcb71580), UINT64_C(0xb033b22fc082eefd) }},
  {{ UINT64_C(0xf64c28a84da00204), UINT64_C(0xb278dd9d0d63c3b8), UINT64_C(0xdcfe70d61daae731), UINT64_C(0x85ef2572756289e6) }},
  {{ UINT64_C(0x8310067031e9d453), UINT64_C(0x20ab0ab029f5db71), UINT64_C(0xf0649dc56c9632f0), UINT64_C(0x20f69f2be1a804d0) }},
  {{ UINT64_C(0x7adc452357e5ee3e), UINT64_C(0xd249a50b800cea91), UINT64_C(0x0ab682d09c231ba5), UINT64_C(0x68cfe2f30c978e83) }},
  {{ UINT64_C(0x2b0844abfe43c768), UINT64_C(0xb37687d41df1b8a4), UINT64_C(0x0b5dde99df0d1e1b), UINT64_C(0xe3a5bad8762ae20b) }},
  {{ UINT64_C(0xb46499b7251f69bc), UINT64_C(0x47483898db798ea2), UINT64_C(0xa01270629f19694d), UINT64_C(0xf5f25042dc655d42) }},
  {{ UINT64_C(0xb36474d283037f58), UINT64_C(0x2a6249a156f99eb5), UINT64_C(0x629c0be0769cdaf4), UINT64_C(0x2072aaad6ba65987) }},
  {{ UINT64_C(0x21efeffc09440f5f), UINT64_C(0x49de8282d503b4bb), UINT64_C(0xc9a10fd93356848c), UINT64_C(0x56de5728da2e7445) }},
  {{ UINT64_C(0x73b9abb2c0995991), UINT64_C(0xba3ae539599886d2), UINT64_C(0xa948d8a5fc5b7c22), UINT64_C(0x0ffeb670ccb9f7ab) }},
  {{ UINT64_C(0x7d1d0360a2c581c9), UINT64_C(0xab8d41f9ab0037ac), UINT64_C(0x83ce127af9ddde7a), UINT64_C(0x984907bc8fccd9aa) }},
  {{ UINT64_C(0xe3fc3a49d0e746c8), UINT64_C(0x445a0c0750a8cd0b), UINT64_C(0x61576b9eb90e9b8e), UINT64_C(0xf0c413f8c1dfb432) }},
  {{ UINT64_C(0x47c42e6e95a5e995), UINT64_C(0xebebe08c332abf90), UINT64_C(0x94e6ef72da0ca431), UINT64_C(0x94d4aab0699d29e3) }},
  {{ UINT64_C(0x99ae782df0110dd0), UINT64_C(0x3fcd3152a2457ff1), UINT64_C(0xdd85a4ff98baa6fc), UINT64_C(0xe4a915491540eed4) }},
  {{ UINT64_C(0xc91ca7364b040619), UINT64_C(0x0da47f8152f6adbb), UINT64_C(0x80b4ddfc4392eeab), UINT64_C(0xf2df2291e72525ac) }},
  {{ UINT64_C(0x32f222a3cef6d1c4), UINT64_C(0x06235eee5e1f0a49), UINT64_C(0xa8b54ce35fea758c), UINT64_C(0xf946f86e01b0e73f) }},
  {{ UINT64_C(0x13d7aa9cb6250678), UINT64_C(0xe6a3dab6f0310ae0), UINT64_C(0x8be0eb90f928a173), UINT64_C(0xf5778913e8c3996f) }},
  {{ UINT64_C(0x74c83398ebd9037f), UINT64_C(0xbf2dba97d35babd4), UINT64_C(0x5272b0b4d8376368), UINT64_C(0x7304ce330fa53467) }},
  {{ UINT64_C(0x099407d7fdd484b6), UINT64_C(0x4049a5557b7becdb), UINT64_C(0x5b54ab9003972fe6), UINT64_C(0x31432ebfb69b8689) }},
  {{ UINT64_C(0xab337abec6519cfb), UINT64_C(0x862620e7b7288b9a), UINT64_C(0x6e6ea09376d413cc), UINT64_C(0xdde569317c7d980d) }},
  {{ UINT64_C(0x0f656bfe2194fa7a), UINT64_C(0xa7304098af14d26f), UINT64_C(0xfccb86fe6f842117), UINT64_C(0x75df540a2b62d0f8) }},
  {{ UINT64_C(0xb3c4d9f77b98519c), UINT64_C(0xb79dfa4a1a2e384b), UINT64_C(0xc298b8ec7a5ad679), UINT64_C(0x10721f723cf5813d) }},
  {{ UINT64_C(0x4d218f40fdc9ad5c), UINT64_C(0x335c76be908c8495), UINT64_C(0x485878de083ecdcf), UINT64_C(0xa680cd3298fa0c52) }},
  {{ UINT64_C(0x54ebc9af39ef0ec6), UINT64_C(0xc75da7179ae52009), UINT64_C(0x7d991459fa25f3ae), UINT64_C(0x9ef412c9adcdd8e9) }},
  {{ UINT64_C(0xe6046aaa00325649), UINT64_C(0xe3925d7a9357c924), UINT64_C(0x3d5e75601041db48), UINT64_C(0xd5bbea4edef4542a) }},
  {{ UINT64_C(0x2b0954b22511d38f), UINT64_C(0x3133eb62a51a93d5), UINT64_C(0x428fc8dc6de0bc61), UINT64_C(0xbec061b53b7ddf8a) }},
  {{ UINT64_C(0x9c028c375fd5b7e9), UINT64_C(0x45139e948edd378d), UINT64_C(0xda671cf21d0067f7), UINT64_C(0x5b9e4b47427c2565) }},
  {{ UINT64_C(0xaf0da720da135a06), UINT64_C(0x58d41aaa6ed31dd8), UINT64_C(0x920782ed54e90931), UINT64_C(0xb8b6f5a88379eb2f) }},
  {{ UINT64_C(0x683081ac2df46f9f), UINT64_C(0x03672c40a6979125), UINT64_C(0x307678d08c69a01f), UINT64_C(0x715c14c81b94dcbe) }},
  {{ UINT64_C(0xbb077b634f3a2546), UINT64_C(0x194eb2acf9b80c51), UINT64_C(0x8944611f550aabcd), UINT64_C(0x676f27c25ab14b3d) }},
  {{ UINT64_C(0xa9a75f34f6028163), UINT64_C(0xf63620a930d7b70a), UINT64_C(0xa9751e03439b0faf), UINT64_C(0x9f32ab32a02fc45a) }},
  {{ UINT64_C(0xc50a6133562e7370), UINT64_C(0xfaa950e0277bda71), UINT64_C(0x2679a0fd8fa99c13), UINT64_C(0x7ce9ccd2580f42d9) }},
  {{ UINT64_C(0x7ebe5edc197c1896), UINT64_C(0x785ed0ba9987ce5d), UINT64_C(0x58ab8b26e7171825), UINT64_C(0xc2063872763be57c) }},
  {{ UINT64_C(0xc35012b6b359385e), UINT64_C(0xd0f100d9c3ea1909), UINT64_C(0xd7c0f41dd2ac880b), UINT64_C(0xb18200b0a415f987) }},
  {{ UINT64_C(0x516f726005d11cad), UINT64_C(0xcc9553d3512a6a10), UINT64_C(0xd9e647235416115e), UINT64_C(0x13344a2e5493af7d) }},
  {{ UINT64_C(0xc5afc4ad93a807f7), UINT64_C(0x96fe3d3823cd0939), UINT64_C(0x2dd343c16f437a5a), UINT64_C(0x0ee4b9d9dfc809b6) }},
  {{ UINT64_C(0x0bad088d0c45d226), UINT64_C(0x5502c0890922460b), UINT64_C(0x3b704a40a807c0f3), UINT64_C(0x4190d516d1437c9c) }},
  {{ UINT64_C(0x916ecaad8267017f), UINT64_C(0xc84e63989cbd0ba6), UINT64_C(0x40889ee2508c726b), UINT64_C(0x2d020feb963d8f04) }},
  {{ UINT64_C(0xad378877f7dda504), UINT64_C(0xe390d27619314374), UINT64_C(0x0a8f169b1be874d3), UINT64_C(0xd097b91a583a4ab6) }},
  {{ UINT64_C(0x47812803e5880b5a), UINT64_C(0xc11dbf2e12ef8a04), UINT64_C(0xaaff89f3545d7c04), UINT64_C(0x52bc164678fa3705) }},
  {{ UINT64_C(0xfe6c2d7205189746), UINT64_C(0xa3c9bf6b54b1c6a1), UINT64_C(0xc19fc5eb598f958b), UINT64_C(0x3fba56a21507e1bf) }},
  {{ UINT64_C(0x95e5200cee02bec8), UINT64_C(0x5d89a7f13279290e), UINT64_C(0xe79817c681f0160d), UINT64_C(0x3b2548060ea0fb80) }},
  {{ UINT64_C(0xdd7b91033cd39ebc), UINT64_C(0xe4b7988a3293602f), UINT64_C(0x9df2e3c8971d7d63), UINT64_C(0x00ff9396a5a7c9c8) }},
  {{ UINT64_C(0xa44dbdfd799ede14), UINT64_C(0x9a7b433f2dd15e83), UINT64_C(0x1b4aa5d7361e5bbb), UINT64_C(0x4fb1ab3ecc06b078) }},
  {{ UINT64_C(0xb51a0213ab8e2a9c), UINT64_C(0x3ee756a4f5581986), UINT64_C(0x59420c1e1a981f15), UINT64_C(0x36b369c70e9e6efd) }},
  {{ UINT64_C(0x0a5b072ab3db20c1), UINT64_C(0x5f5412bc233d152a), UINT64_C(0x836e043b7deb0e98), UINT64_C(0x6cc7a2f4c5bf157e) }},
  {{ UINT64_C(0x6a7571108ec2dbf3), UINT64_C(0xbd9f737c9cc43d57), UINT64_C(0x8169d72d64b7b4df), UINT64_C(0xc93a1a3a06756fd7) }},
  {{ UINT64_C(0xcc7c9ccd6aebacc0), UINT64_C(0xd36b7a6dc3d5ce9b), UINT64_C(0xfbf79c075d045f19), UINT64_C(0x6b618c6debbd81e6) }},
  {{ UINT64_C(0x44c5961c8c58e932), UINT64_C(0xcbcd280f34e8bab1), UINT64_C(0x7af45b40c8b5096c), UINT64_C(0x02d33a75a03cde76) }},
  {{ UINT64_C(0xd2cf468b9a065742), UINT64_C(0xc3eab03383d492ec), UINT64_C(0x719ec1b4443aee75), UINT64_C(0xe98ec200c4b01c42) }},
  {{ UINT64_C(0xaefe1d5354a63330), UINT64_C(0x57cf8b8b0132230a), UINT64_C(0x5012b4c0cbf283a8), UINT64_C(0xe3198aef21c644f0) }},
  {{ UINT64_C(0x8137be74b2fced3c), UINT64_C(0x5e1c349b9d5a19c1), UINT64_C(0x4b86ffbcf2a1c948), UINT64_C(0xe382f3cbb27819ed) }},
  {{ UINT64_C(0x5b2c523ada581174), UINT64_C(0x42acd3eecc66aea4), UINT64_C(0x3b6504ec4c703443), UINT64_C(0x6495b3d15cae4f7e) }},
  {{ UINT64_C(0x55474a188314b482), UINT64_C(0x80402e1fd2bf83d4), UINT64_C(0x9fb2fb3b7d1e442c), UINT64_C(0xdead6e793650e53b) }},
  {{ UINT64_C(0xfc890b30ec0e68e5), UINT64_C(0xa87487d792fd84db), UINT64_C(0xf74aefc8bd0a4696), UINT64_C(0x14d1a673d1485fac) }},
  {{ UINT64_C(0x36aeabeefe55fb71), UINT64_C(0x6284267f56999424), UINT64_C(0x7f789038d39f889d), UINT64_C(0x8baf14ac922ea7eb) }},
  {{ UINT64_C(0x2a1c8eb3fb51f60e), UINT64_C(0x229c1457365fea99), UINT64_C(0x3061b8f1dfd441de), UINT64_C(0x038b7bd99d4cb17e) }},
  {{ UINT64_C(0x53972f24e11d2304), UINT64_C(0x130f6905aa9ab1c4), UINT64_C(0x43802565d3c36bcf), UINT64_C(0x17fbfb1cd9f29555) }},
  {{ UINT64_C(0xe033c8b64dbc0d80), UINT64_C(0x29adf5e8e6f77eb2), UINT64_C(0x4554469110777b59), UINT64_C(0xc0647b136729920d) }},
  {{ UINT64_C(0x9c7fd79b2a9f0672), UINT64_C(0xed7cc41064273bc0), UINT64_C(0x129add3131c0a496), UINT64_C(0x3c562fe0325aef5a) }},
  {{ UINT64_C(0xcbe9c5c32a051cba), UINT64_C(0xab485c73533ee4f6), UINT64_C(0xb3b216ad8c1e064a), UINT64_C(0x2ea875ae87fce0e8) }},
  {{ UINT64_C(0x7a647dfc9999a211), UINT64_C(0x2d881f5eb980d59a), UINT64_C(0x6d8f00b773b4a699), UINT64_C(0x50413e577927e14c) }},
  {{ UINT64_C(0x7e1b53d545e4b68b), UINT64_C(0xe92c8450a1229d1f), UINT64_C(0x97754d1fd426a9a2), UINT64_C(0xe03daf095b695639) }},
  {{ UINT64_C(0x1253fb4cac48a4a2), UINT64_C(0xd394de52b1d753ec), UINT64_C(0x32be2da12988423f), UINT64_C(0x01c1613c543f3a56) }},
  {{ UINT64_C(0x1c5d2d96713d37bc), UINT64_C(0xb15f41633d9f2d85), UINT64_C(0xb679748b49097f81), UINT64_C(0x7f29c4d9c3e86cf8) }},
  {{ UINT64_C(0x619ed8bd56d9c61b), UINT64_C(0x1dac095b57b25856), UINT64_C(0xf89fbbbfbafcc121), UINT64_C(0x478a87498407f340) }},
  {{ UINT64_C(0xe19780fce0ab61d8), UINT64_C(0xad0989e53d163586), UINT64_C(0xbba3a0513ef75c22), UINT64_C(0x7912e0414a50ed41) }},
  {{ UINT64_C(0x6960e1824a5e2cf9), UINT64_C(0x48a568a4729bdc6f), UINT64_C(0x1913bab467e0efba), UINT64_C(0x936fafaf5fcaa835) }},
  {{ UINT64_C(0x35de1def9a8667db), UINT64_C(0xd64c1ac0f6a6193c), UINT64_C(0x2a47309e0ae8ff8f), UINT64_C(0x5fe3e3a00adbee9a) }},
  {{ UINT64_C(0xb286c97a12699204), UINT64_C(0x0630e9edafdabe77), UINT64_C(0x1dc3483aa57bdbc0), UINT64_C(0xc23d4f1c82a3f005) }},
  {{ UINT64_C(0xc83a69f8088863ac), UINT64_C(0x743c1b35253f7aa6), UINT64_C(0x00f0264bee9ecb92), UINT64_C(0x6aeae442bf6a5c3f) }},
  {{ UINT64_C(0xcc2521408a97d947), UINT64_C(0xfb91d1b73f199e66), UINT64_C(0x506d3f28894b4a27), UINT64_C(0x137cce7f9f69f273) }},
  {{ UINT64_C(0x3716fe4e5d62b088), UINT64_C(0xc4da4a61fd73d073), UINT64_C(0xdc1ec98232d2878c), UINT64_C(0xc87d922842929e46) }},
  {{ UINT64_C(0x5ef704a948485f84), UINT64_C(0xf8ebd7dded8cadbe), UINT64_C(0x4883f656b69209d8), UINT64_C(0x2821fab8cc5032b3) }},
  {{ UINT64_C(0xc352478be9443a06), UINT64_C(0xb801e9fe9068ed97), UINT64_C(0xd92cef87dbe922e0), UINT64_C(0x2c0557addf3835b8) }},
  {{ UINT64_C(0x66bb8b6fa8b98f09), UINT64_C(0x97379fddb294ee99), UINT64_C(0xf5ed8afa21e7cb00), UINT64_C(0x9c1424f152177752) }},
  {{ UINT64_C(0x9cf435dbe138d435), UINT64_C(0xe192f663a0b0d2db), UINT64_C(0x992659fd864f028a), UINT64_C(0xf76811fa7faf872d) }},
  {{ UINT64_C(0x084ab9dd6cdf0982), UINT64_C(0x54c290fd31a4477d), UINT64_C(0xa942c3d53e4aab4c), UINT64_C(0xb646ecbedb3ff62b) }},
  {{ UINT64_C(0x4271087cc87b83fd), UINT64_C(0xfa0ad474d19e45b6), UINT64_C(0x68e6ff9e8748298b), UINT64_C(0x01700b1b66a786b7) }},
  {{ UINT64_C(0x5863de63b5726432), UINT64_C(0x14ed71feccd80833), UINT64_C(0x0ec97757b40736df), UINT64_C(0x9c105bcf79e3dfb1) }},
  {{ UINT64_C(0x44d861fbb32aa422), UINT64_C(0x2049d5278f38771a), UINT64_C(0xdf20da8b93a53439), UINT64_C(0xd185c00830690680) }},
  {{ UINT64_C(0xe372ac78aec42c16), UINT64_C(0xf96a255d42a4dde2), UINT64_C(0xcc863b575b88be34), UINT64_C(0xd3bce0f847c775c3) }},
  {{ UINT64_C(0x87036dc370ab1b09), UINT64_C(0xe9e03e83b74ff5d9), UINT64_C(0xd02b179e81bf0d4c), UINT64_C(0x3716316f2d35f724) }},
  {{ UINT64_C(0x76db860e5d61809d), UINT64_C(0xaf84cfb340f0522e), UINT64_C(0x42da579f857d02a0), UINT64_C(0x626271f420f12a00) }},
  {{ UINT64_C(0x7bf22a9c0990bbdd), UINT64_C(0xe70a18ab39fd640a), UINT64_C(0x73c3a70f0e7c8e8c), UINT64_C(0x68627b1dfc8c4257) }},
  {{ UINT64_C(0xeab9640b5abc7dd1), UINT64_C(0xc6559209ad4c7407), UINT64_C(0x6e6f7fb3c2488f45), UINT64_C(0x52aa6b14192aa7aa) }},
  {{ UINT64_C(0xbde2d4837e214c84), UINT64_C(0x2fdf6d2b270c7493), UINT64_C(0xfb1ce6682cfdf8a6), UINT64_C(0x31c1150c7ff5d641) }},
  {{ UINT64_C(0x90cffba4f08456bc), UINT64_C(0x8aebd14b4e53c9af), UINT64_C(0xa8cb3e876bc67c52), UINT64_C(0xe21c0578db2cc16c) }},
  {{ UINT64_C(0xe9ff9160dafb0863), UINT64_C(0x738fe0ea004c5466), UINT64_C(0x1dd59e10dea7378c), UINT64_C(0x16d929c536b7ca46) }},
  {{ UINT64_C(0x11a56bc3294408e0), UINT64_C(0x39d0db0ce1de8968), UINT64_C(0x98c3855539343463), UINT64_C(0x07f34a8fbbcd7ba2) }},
  {{ UINT64_C(0x83b8734258cbabd4), UINT64_C(0xdb5a0d176b9a357e), UINT64_C(0xcdd05f0bb6bfd4e2), UINT64_C(0x8dd7d82045c1d281) }},
  {{ UINT64_C(0xa1cfad846022f5db), UINT64_C(0xc1f95bf9854c8d34), UINT64_C(0xf21810694d520f8f), UINT64_C(0x9b31a1e29630d60d) }},
  {{ UINT64_C(0x189887b8cae80a56), UINT64_C(0x4c1195a4406c2df3), UINT64_C(0xf330502538c59140), UINT64_C(0x324115a487ed764b) }},
  {{ UINT64_C(0x1c4e28c6d7b5ba9c), UINT64_C(0x5e437b7cbe8b65e2), UINT64_C(0xb61c7be46c79fa95), UINT64_C(0xa620047c973f101b) }},
  {{ UINT64_C(0x7db0ba8489959ef6), UINT64_C(0xbf7dd2905f62ac3b), UINT64_C(0x4b33093480b29d7d), UINT64_C(0xb7909463dece2558) }},
  {{ UINT64_C(0xb87f15ac520f34e6), UINT64_C(0x9f36940c8b2a5092), UINT64_C(0x7aaaf58bc090779d), UINT64_C(0xab34de5efffe6f98) }},
  {{ UINT64_C(0x1883ba9234d1ced3), UINT64_C(0xad52f92fa652ce72), UINT64_C(0x9708d38b8222745e), UINT64_C(0xccf3bf90ad647429) }},
  {{ UINT64_C(0x6e07332082a3813b), UINT64_C(0xf43c8d076fe58932), UINT64_C(0x0e6d6105f0d87b0a), UINT64_C(0x2f33a43241c08531) }},
};

static const block_t precomputed_round_key_matrix_non_linear_part[] = {
  {{ UINT64_C(0x49c9698425278c08), UINT64_C(0x29366bdce81ab63c), UINT64_C(0xccb35d7891ebb0b8), UINT64_C(0x559031c4063e7280) }}, {{ UINT64_C(0xd78d8028e1f920ec), UINT64_C(0xcda872145cd279d0), UINT64_C(0x3bfc617cdd71bdf0), UINT64_C(0x3d6c464c57373f14) }}, {{ UINT64_C(0xe526e100470cb85c), UINT64_C(0xd638af18cd8b12c8), UINT64_C(0x3aff5b74b7f24308), UINT64_C(0x7440043c21b49f20) }}, {{ UINT64_C(0xc335a3b4f007bb24), UINT64_C(0xad172d8c5218fa0c), UINT64_C(0xff9d5cf861b0bcc8), UINT64_C(0x7d76289c18607148) }}, {{ UINT64_C(0x32ba73bc437063fc), UINT64_C(0x7ef0dcb4323bb364), UINT64_C(0x3f65f618e7709558), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5543689c9433c894), UINT64_C(0x03044b5c4d678128), UINT64_C(0x926ff3b8d55a68a8), UINT64_C(0x61241fa48473b424) }}, {{ UINT64_C(0x4b53e3848be29f3c), UINT64_C(0x903858044af31228), UINT64_C(0x1e06eea078461c3c), UINT64_C(0x451dea648d7a0324) }}, {{ UINT64_C(0x19c83648f8e284f0), UINT64_C(0x7acec5ec808dfe6c), UINT64_C(0x68ee4b2ceba3b1b4), UINT64_C(0x8be94264f40971d0) }}, {{ UINT64_C(0x09f9c844a5a8d920), UINT64_C(0xcdc76cf4e25b49c4), UINT64_C(0x36529d50740cbe04), UINT64_C(0x3b48c7e86b8b1ee0) }}, {{ UINT64_C(0x716672a4cb13d3c8), UINT64_C(0x4239f75c82625500), UINT64_C(0x5c9677f4339d06c4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5d5f1ad8ec222b5c), UINT64_C(0x101653fce096a9b4), UINT64_C(0xbd6872349bfe7fd8), UINT64_C(0x0785a7c461c99608) }}, {{ UINT64_C(0x60d120c071787ce0), UINT64_C(0xf78ff8204a13e7a0), UINT64_C(0x51adc6006709d070), UINT64_C(0x1c165730be0e58f8) }}, {{ UINT64_C(0x26750c58a8962fb4), UINT64_C(0xa0c347e8f20b2a3c), UINT64_C(0xfed5abfc039473a4), UINT64_C(0xeb03d8189bc24f48) }}, {{ UINT64_C(0x781e10ccd4e601f8), UINT64_C(0xd4ebf0646df9e980), UINT64_C(0xff02972456ea3158), UINT64_C(0x4e2b15481e048178) }}, {{ UINT64_C(0x0c5fff4c803125d4), UINT64_C(0x3ea7dd243ba12334), UINT64_C(0x0052ee101e4e4218), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9af23300b22f6cdc), UINT64_C(0x9de34c6424f96528), UINT64_C(0x14b62678368240a8), UINT64_C(0xeed1e4f46c2940ec) }}, {{ UINT64_C(0xd61045a4f351ef10), UINT64_C(0xb70be2203690f628), UINT64_C(0xad9c13380b83e500), UINT64_C(0xc3401724262aaecc) }}, {{ UINT64_C(0xa0cec1e86a7dae90), UINT64_C(0x5739640c42207e0c), UINT64_C(0x395f05c43ac18f04), UINT64_C(0x2bf6672014207690) }}, {{ UINT64_C(0xcf3bd2883a16ca20), UINT64_C(0xe69055fc155db9b4), UINT64_C(0xa3db252cc921bc68), UINT64_C(0xb1d8cc2c37a1c788) }}, {{ UINT64_C(0x72c94b24a6e74a78), UINT64_C(0x74801f683fa191a8), UINT64_C(0x92fb42980e55b1f0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f977150edd2eb28), UINT64_C(0xee13f948abf8418c), UINT64_C(0x045da4f07b910d38), UINT64_C(0x8d15f86c4246e69c) }}, {{ UINT64_C(0x3a923fdcad173354), UINT64_C(0x1a0c3a807593d408), UINT64_C(0xd48317fc337103fc), UINT64_C(0x5881bc10b9608630) }}, {{ UINT64_C(0xb746ee6ce542feb0), UINT64_C(0xd8c74f44fe55d0f4), UINT64_C(0x229876f85bf39340), UINT64_C(0x79e5e8fc3bdf2d08) }}, {{ UINT64_C(0x7636731cb1cc2ad4), UINT64_C(0x8bc9a3008625a938), UINT64_C(0xb0a703e4014e4f40), UINT64_C(0xbe840c0ccc990618) }}, {{ UINT64_C(0xcd7d3d48a9cc45c8), UINT64_C(0x0d0e0ddc0a2dcd48), UINT64_C(0xb0c08bac94d13964), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x437d85946953b22c), UINT64_C(0x433e5c10fdcb2f70), UINT64_C(0x6db4821c04be2ef8), UINT64_C(0x702aacc0833bf084) }}, {{ UINT64_C(0xd0b7a17cab537564), UINT64_C(0xf25e5db426ead308), UINT64_C(0xed14bd346e42bb38), UINT64_C(0x631ff43c419d4460) }}, {{ UINT64_C(0xa2879b28fca58a4c), UINT64_C(0x626a4d5cbbd643f0), UINT64_C(0xb068c1d453fcf31c), UINT64_C(0xb3558d84a3f951a8) }}, {{ UINT64_C(0xb8247f38f09de684), UINT64_C(0x842ff4d0f16c4db4), UINT64_C(0xdf73a7f0fd682808), UINT64_C(0x046bb0b0fe0d03c4) }}, {{ UINT64_C(0xb9e49eac4d0bcdb0), UINT64_C(0xbeb3e9f4cbf297dc), UINT64_C(0x66cf518853c292ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3db59f20b7fc71f4), UINT64_C(0x76e42910d88281c0), UINT64_C(0x3c4f4164f3228014), UINT64_C(0xc628376c3ba3374c) }}, {{ UINT64_C(0xfd1331bc7d4cc2d0), UINT64_C(0x68bae3ac160533d8), UINT64_C(0xd9c5047432f575c8), UINT64_C(0xc7779aa0d054f24c) }}, {{ UINT64_C(0x1b69352880e1e130), UINT64_C(0x6cd916cce1efbf70), UINT64_C(0x5aac0edcff697e60), UINT64_C(0x5c7bfcb0ab7b2d3c) }}, {{ UINT64_C(0x4991d634096c5c5c), UINT64_C(0x64653d243d842a64), UINT64_C(0xabf6b080e0be17b8), UINT64_C(0x2851110c7a62fb08) }}, {{ UINT64_C(0xd4d8542ca11aa6fc), UINT64_C(0xf9023fcc725866dc), UINT64_C(0xdfa556b01ecab618), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe2fec360ac532b14), UINT64_C(0xcb69082ce573bd00), UINT64_C(0x8b9dd58c5b550440), UINT64_C(0xaa495ca8b853ced8) }}, {{ UINT64_C(0x8c97fefccd5fa93c), UINT64_C(0xd349e7b479bf1f9c), UINT64_C(0x396209988717efe4), UINT64_C(0x8d772bc034fe237c) }}, {{ UINT64_C(0x53ab831849eb5c00), UINT64_C(0x51193a04a3cd2764), UINT64_C(0x1e5c1e6c71aadd0c), UINT64_C(0x1ff2ad1010dd2fa4) }}, {{ UINT64_C(0x7dd6e364a692d6d4), UINT64_C(0x58bf65107d15d2ac), UINT64_C(0x31f51f88d7414160), UINT64_C(0xb6514b1cebf134a4) }}, {{ UINT64_C(0x4f98b6882552ec2c), UINT64_C(0xe9c94808bb8eb460), UINT64_C(0xd4b881846527c2a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa34964d05e90a210), UINT64_C(0xdc9945a0521e0dcc), UINT64_C(0xe5c1ed64617c088c), UINT64_C(0x82579318001142f0) }}, {{ UINT64_C(0x64213090d60e9ad4), UINT64_C(0x6f317fa06d0662e0), UINT64_C(0x775bfd8c67a4c75c), UINT64_C(0x6ddf54182409b450) }}, {{ UINT64_C(0x2d96e654aef55504), UINT64_C(0xd52c0ecc02d00a80), UINT64_C(0x3259749c3ac904ac), UINT64_C(0x3735489c6495c90c) }}, {{ UINT64_C(0xe2e10afcb7944350), UINT64_C(0x31e562c8db8c0c7c), UINT64_C(0xeb5a25a0efcd4c8c), UINT64_C(0x9c599958dfb65638) }}, {{ UINT64_C(0x479af8e0cab487c0), UINT64_C(0xb3c5fb0410ba63d0), UINT64_C(0x22890f2454eb51c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb1f75c24a0676108), UINT64_C(0x806012e40d17dddc), UINT64_C(0x6af2960c4755db18), UINT64_C(0x204cc9e845c2f648) }}, {{ UINT64_C(0x0024a4fca4ee5390), UINT64_C(0x80033f18f535c578), UINT64_C(0x088e54148ea45128), UINT64_C(0x19e12fa8564a9e50) }}, {{ UINT64_C(0xaacdc1b0a9ac1c44), UINT64_C(0xbcdc2b60788fb080), UINT64_C(0xf3b719ece026c650), UINT64_C(0xb3fe26a40bf1e664) }}, {{ UINT64_C(0x59a2341051cefadc), UINT64_C(0x0c882274f6afc014), UINT64_C(0x1fb0fff4cf398c10), UINT64_C(0x41edc1d45ac2e1d0) }}, {{ UINT64_C(0x3376d5680167d458), UINT64_C(0x458d4478636f6710), UINT64_C(0x7daefb801634bbec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x755c79dcffafb04c), UINT64_C(0x9e89a59cc02b2698), UINT64_C(0x49fdfc78c86e2188), UINT64_C(0x2bd0473403feca20) }}, {{ UINT64_C(0xdbe4aca01dde9148), UINT64_C(0x8b1ee0e488c2f3d8), UINT64_C(0xb00dbb9037f459d4), UINT64_C(0x85219b90035e3dfc) }}, {{ UINT64_C(0xa9f61d7022e41698), UINT64_C(0x33bda0dc6592e7d8), UINT64_C(0xb11fd2ecfa254174), UINT64_C(0x00293bac1c8e5e80) }}, {{ UINT64_C(0xb699b08ce5e8fbe8), UINT64_C(0xfa808c4422610240), UINT64_C(0xee10bf60be255898), UINT64_C(0xa0f03a9caabc014c) }}, {{ UINT64_C(0x15e2ecb868157de4), UINT64_C(0x077a48d8e24f47cc), UINT64_C(0xb746dbd0afb88028), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2e60134cb629ac4c), UINT64_C(0xdce24e4c64655d40), UINT64_C(0x2b8cc37810c81b48), UINT64_C(0x69e00bf49bb7c9c0) }}, {{ UINT64_C(0x5792b354bebb4fd8), UINT64_C(0xe9af7b9cecabee18), UINT64_C(0x00ccbdc8da8e9c0c), UINT64_C(0x1af635786379b6ac) }}, {{ UINT64_C(0x8cd6a21c5d0d8be0), UINT64_C(0xba91fa3cfbc858cc), UINT64_C(0xf6f5eeb8b8208ae0), UINT64_C(0xefaaad58f47f371c) }}, {{ UINT64_C(0xa0ff043c67776214), UINT64_C(0x63e0b198069b273c), UINT64_C(0x64ea9748a76c6434), UINT64_C(0x72ffe7b87931bba8) }}, {{ UINT64_C(0x8d43405c29ccc5e8), UINT64_C(0x051015b41cd96218), UINT64_C(0x28662128d26766f0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x641cd99059442ea0), UINT64_C(0xb8f1256cdc047b44), UINT64_C(0xf58715001a631188), UINT64_C(0x00a17ea098c675ec) }}, {{ UINT64_C(0x5a3c01086f6f7d60), UINT64_C(0x7d55a83cc139b548), UINT64_C(0xb148ec2853839580), UINT64_C(0x168599c4bac362b4) }}, {{ UINT64_C(0x5bc59800004890f4), UINT64_C(0x675831c402feb918), UINT64_C(0x25413accacb4f128), UINT64_C(0xf4f208f87dbc5a14) }}, {{ UINT64_C(0xcd67524c176e6378), UINT64_C(0xdf303a08d93ed534), UINT64_C(0x0dc09714dd461568), UINT64_C(0x24f2c5ec82b45da0) }}, {{ UINT64_C(0x81622bfc1253b970), UINT64_C(0xfec56bc8031ae694), UINT64_C(0x488c819c26fafb80), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4f8686d09cf755b4), UINT64_C(0x780d22406cd07f50), UINT64_C(0x3e6bf3086524c548), UINT64_C(0xb98fa244d11d7d3c) }}, {{ UINT64_C(0xf0773ffca21b8cb0), UINT64_C(0x4c6ef42c46d35b68), UINT64_C(0xee5ca1d0f5d92678), UINT64_C(0x04b899683a286f0c) }}, {{ UINT64_C(0x6a1e110c172e3370), UINT64_C(0xc1d6b1748fccb538), UINT64_C(0xc83ea77c3eb9cf6c), UINT64_C(0xe912f04c1b6a12d4) }}, {{ UINT64_C(0xf52d203821883a74), UINT64_C(0x6a7545200bfa3dc8), UINT64_C(0x2223751864422bc8), UINT64_C(0x9eaa9efc17d113cc) }}, {{ UINT64_C(0x145718bc30d33fe0), UINT64_C(0x61cb9af4e25b5c58), UINT64_C(0xc818a9b051e11df8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x389797500ae739b4), UINT64_C(0x67ee984092922d88), UINT64_C(0x30164108a81d24b4), UINT64_C(0x23086768c44c05b8) }}, {{ UINT64_C(0xb847ec44ebedffbc), UINT64_C(0x8972d9d04379a654), UINT64_C(0x3715e78c2f1466e4), UINT64_C(0xf398cc9805012904) }}, {{ UINT64_C(0x36cf82d09b0de3a4), UINT64_C(0x146a751416d058e4), UINT64_C(0x64060174f63e7e2c), UINT64_C(0xc4b1fafcdb4ebf88) }}, {{ UINT64_C(0x3ea6f34c8db9aee0), UINT64_C(0xf81078601ea934c8), UINT64_C(0xa038acfc9a2d250c), UINT64_C(0x5b5912a4ad8f254c) }}, {{ UINT64_C(0xe71629d40cfab3d8), UINT64_C(0xea9c38cc7b90f0a8), UINT64_C(0x83e67a944619f2d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x15caa9447f1e6fb4), UINT64_C(0x2d636e7ccf59d2f8), UINT64_C(0x5ef2fbf47fffef34), UINT64_C(0x80310d38c4fb68a4) }}, {{ UINT64_C(0xb96429cc9b8f11e0), UINT64_C(0xbd590b4c5d1f5ac0), UINT64_C(0xdcab7efc602d8814), UINT64_C(0x6481d75c45c815f8) }}, {{ UINT64_C(0x47ff6dd431311d14), UINT64_C(0x4e3669707cc9eb5c), UINT64_C(0x846531903c706e18), UINT64_C(0x236e43b096aa1840) }}, {{ UINT64_C(0x17ce04b4a98ec1dc), UINT64_C(0x8a18c420d809507c), UINT64_C(0x59fc4878a2f06ba8), UINT64_C(0x5123592023cb6e10) }}, {{ UINT64_C(0x95a647ac40233a8c), UINT64_C(0x094e2fa4c37a848c), UINT64_C(0xe4a68ba803ba7c08), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x075beba843408ba4), UINT64_C(0x175a64b083d7ef2c), UINT64_C(0x6e89ff245c681994), UINT64_C(0x2b944e8cc2d64c44) }}, {{ UINT64_C(0x3940fe088e6efa90), UINT64_C(0x2be1df2cdd2da27c), UINT64_C(0xf47294b41282beb4), UINT64_C(0x67777430e1279944) }}, {{ UINT64_C(0x86b54588ceebb4f8), UINT64_C(0x5903f8c013490728), UINT64_C(0xd941fba006d1bc44), UINT64_C(0x451559d8cd7debe0) }}, {{ UINT64_C(0x5d587ca45790ea34), UINT64_C(0x59ec8d64579879e4), UINT64_C(0xd9fe18ac24c114a0), UINT64_C(0xa28f6b8ca4f976a8) }}, {{ UINT64_C(0x22a6a0dc776b4520), UINT64_C(0xa291e358a09735cc), UINT64_C(0x0d4d423ca44bfcf8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6be3279c4ffc3860), UINT64_C(0x17214dccda5c57b0), UINT64_C(0x81357cb0a53c2994), UINT64_C(0xae44c37c8ed319f8) }}, {{ UINT64_C(0x4984a6447ddfcd58), UINT64_C(0x2e6688c0bd75dd1c), UINT64_C(0xaa97afc81aa92e14), UINT64_C(0x40c83f2054ea0d28) }}, {{ UINT64_C(0x8aced4002862be3c), UINT64_C(0x4bb308349967baf0), UINT64_C(0x5598c528a7629468), UINT64_C(0xcbdb32e49bd2448c) }}, {{ UINT64_C(0x81ab2608dc837914), UINT64_C(0x52a965dc2be2e3c8), UINT64_C(0x60b2bad4221f123c), UINT64_C(0xc9be5a7870fa05ec) }}, {{ UINT64_C(0xc19f1c607625a188), UINT64_C(0x6d987aa0bc1b7968), UINT64_C(0x43133c9c771132f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb213c5049b78f0d0), UINT64_C(0xb79e6db000dd164c), UINT64_C(0xa6e5d96c567ececc), UINT64_C(0x052ccce020bdec78) }}, {{ UINT64_C(0x42c74310f02ef5e4), UINT64_C(0x52e8b788a34da208), UINT64_C(0x16a43570bc5b9ccc), UINT64_C(0x9f25d2f00b6f4320) }}, {{ UINT64_C(0x2651871c52a2a674), UINT64_C(0xd63d35106d548274), UINT64_C(0xa7ac3c9c11d392d0), UINT64_C(0x6a17b3c4a7e0de24) }}, {{ UINT64_C(0xb6ec79ccb9dd9fa0), UINT64_C(0x62cd8c703345f8ac), UINT64_C(0xe76acf30a75ec1e8), UINT64_C(0xd3c1b23c422198ec) }}, {{ UINT64_C(0x7d919c1808ca9ad4), UINT64_C(0xe6167740bd13f318), UINT64_C(0x527c8c0cb6827f98), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa59327649f7db05c), UINT64_C(0x9d38f504adcdd34c), UINT64_C(0x9ff0884cccedfb0c), UINT64_C(0x1454140876c8dc40) }}, {{ UINT64_C(0x56d2fd703f534cc8), UINT64_C(0xb2b69fb056ff0004), UINT64_C(0x39a12e58d18c8a88), UINT64_C(0x6a9188740d7d6750) }}, {{ UINT64_C(0x1e050164417df66c), UINT64_C(0xa9c50c68efd9e410), UINT64_C(0x77778bdc7675c578), UINT64_C(0xf193986847a10e6c) }}, {{ UINT64_C(0x9a21e234ec560820), UINT64_C(0xa15c29e06cc7bc90), UINT64_C(0x7cca47e4b68a59ac), UINT64_C(0xf1476044b5574b74) }}, {{ UINT64_C(0xabd7bcbc1c367034), UINT64_C(0x21dbf66c181dcc1c), UINT64_C(0x4fb79b00a227ab2c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x46eebc1030e93a0c), UINT64_C(0x1c976a8069b3ebe4), UINT64_C(0xf04dd688232f664c), UINT64_C(0x6ec01bc8b4ae256c) }}, {{ UINT64_C(0x56100884b74dc58c), UINT64_C(0x019baed0141742a8), UINT64_C(0xe45f1f6826035220), UINT64_C(0x56e9a5e8ed2e6e04) }}, {{ UINT64_C(0xc299bfa87cf46918), UINT64_C(0xc202e404690cd540), UINT64_C(0xc001dbe0d4c44998), UINT64_C(0x21dd2694a8137660) }}, {{ UINT64_C(0xb5e227e81e3fbad8), UINT64_C(0x8a9600d0f1d24cf4), UINT64_C(0x8d44d7ac567f0908), UINT64_C(0xc06f3ff056aae3bc) }}, {{ UINT64_C(0xc76ea21c414c4054), UINT64_C(0x33a7d1785b76e9d0), UINT64_C(0x93c3d71461c82dc0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x05e23e908eeddfec), UINT64_C(0x1e500f4443a492c8), UINT64_C(0x8d988514b99ec8a0), UINT64_C(0xaaa5ff5c0ae36970) }}, {{ UINT64_C(0xf3d2bafcda49a550), UINT64_C(0x6446f310641f8a38), UINT64_C(0xb8ebea3cf6bd24d0), UINT64_C(0x0ce23968297fe3d8) }}, {{ UINT64_C(0x9c09d5b0b73def9c), UINT64_C(0xf3dc0c44f65fd8a8), UINT64_C(0xb7aea5b4e3bc3234), UINT64_C(0x4cb84fb85090c910) }}, {{ UINT64_C(0x688468a028ee5e14), UINT64_C(0xaba831dc5f4e74d8), UINT64_C(0x736f25006af8f09c), UINT64_C(0xc0dcb8c829ea44e8) }}, {{ UINT64_C(0x1d896308c90f7048), UINT64_C(0xa013c2b038dc3314), UINT64_C(0x093ec12cd11f431c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x00ac371878f1b9c0), UINT64_C(0x5e3c1fe82719211c), UINT64_C(0x63e5b7042a3a4920), UINT64_C(0x3b06da98070c3188) }}, {{ UINT64_C(0xdd8fd18c4e221b90), UINT64_C(0x94dda8c8265b8e3c), UINT64_C(0x2b70e8ac55933ea4), UINT64_C(0x4176e7c0aa190040) }}, {{ UINT64_C(0x9d01f358c2471da8), UINT64_C(0xce20914c4e341938), UINT64_C(0xba958c5031c3e19c), UINT64_C(0x5c2ee764bc479338) }}, {{ UINT64_C(0xa9d0184c1253b7a8), UINT64_C(0x0a4f7444a780a054), UINT64_C(0x56f1f0d0981aa154), UINT64_C(0x475c2a28c046c1b8) }}, {{ UINT64_C(0xa1fee358242569a8), UINT64_C(0x8763b42817683dfc), UINT64_C(0xd28d6ecc03c1a174), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7643b1d0c4eb680c), UINT64_C(0x3ec0394cb3245c68), UINT64_C(0xf69480289a1533e0), UINT64_C(0x760e1778368e943c) }}, {{ UINT64_C(0x10a73a64eb41836c), UINT64_C(0x8717cc88171dd688), UINT64_C(0xb0b754d4b50b0c44), UINT64_C(0x2aea6b281dae66a8) }}, {{ UINT64_C(0x80e2eb684d7d8bec), UINT64_C(0x16737b1412309378), UINT64_C(0x76b139945e52d768), UINT64_C(0xf7142ea0560e7a30) }}, {{ UINT64_C(0xec9c627cd90df600), UINT64_C(0xa4255348c2b4190c), UINT64_C(0xdcb67a182ea3f398), UINT64_C(0xae4a47fc5e4c9598) }}, {{ UINT64_C(0x39898c14d2d6dda8), UINT64_C(0x6b300d546e14c888), UINT64_C(0x54b0b7a4db3b2688), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x896158e08a3b244c), UINT64_C(0x1c8c987424b50348), UINT64_C(0xaa376bd46f7cffc0), UINT64_C(0x651d3750c1eb57c4) }}, {{ UINT64_C(0x4201c3ec3289349c), UINT64_C(0xa230a780246f3760), UINT64_C(0xbec8be9022103ff8), UINT64_C(0x0073eefcd0e2e92c) }}, {{ UINT64_C(0xd37dc6c05240a5b8), UINT64_C(0x9f46a240923e88d8), UINT64_C(0xf2680538d0a1defc), UINT64_C(0x3a1aa6982a3eec40) }}, {{ UINT64_C(0x7ccf6a089d8994b4), UINT64_C(0xa0c0244c74f070f8), UINT64_C(0xc7ae710890f0729c), UINT64_C(0x9406a27061a21248) }}, {{ UINT64_C(0x3399b2e48c2a252c), UINT64_C(0xeb82f2a89cf64224), UINT64_C(0x6de1bf80f40831c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb62bc4cc413bfad0), UINT64_C(0x783854b49957f8c0), UINT64_C(0x13e4b21040b73f98), UINT64_C(0x7f8308a071cdb7d4) }}, {{ UINT64_C(0x04aa114881fcc35c), UINT64_C(0x0a15c9c0cf2cb778), UINT64_C(0xd368e5683deb96b0), UINT64_C(0x7dffa62082b74874) }}, {{ UINT64_C(0x4376235480243cf8), UINT64_C(0xbca8d118b55276e4), UINT64_C(0xe2f8226c11057cc8), UINT64_C(0xe3baa8d4b43ad2c0) }}, {{ UINT64_C(0x01fc7fc02cbe10e8), UINT64_C(0x074993fc49491318), UINT64_C(0x081db384f2d5ceec), UINT64_C(0x53d4079cbf1a5b84) }}, {{ UINT64_C(0x65d43b0c65459d18), UINT64_C(0x1bc4d52c61d285dc), UINT64_C(0x2f83db58499f666c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x46c2e8e84be5ee38), UINT64_C(0xb7e97858873d897c), UINT64_C(0x9a95b7a03872bb6c), UINT64_C(0x96eff2a0085590a8) }}, {{ UINT64_C(0xc8cf7554d0209e64), UINT64_C(0xc4475d2453186d4c), UINT64_C(0x5557bff81450c6d8), UINT64_C(0x43b748349c787ea4) }}, {{ UINT64_C(0x7ef0ddbc4d5d5a68), UINT64_C(0xbc8955c06a83e2b0), UINT64_C(0x3bfbacdc0a0c2f14), UINT64_C(0xc0793134842f2fe8) }}, {{ UINT64_C(0x6b081ab0a3b1848c), UINT64_C(0xa3dabcd46ec19938), UINT64_C(0x4cc00e7cf78ca268), UINT64_C(0x0704c54ce98fe2d0) }}, {{ UINT64_C(0x2ab81518cb57396c), UINT64_C(0xa535d5e07e059bb0), UINT64_C(0xcedf6df4380ef814), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6958f700ae2ad9ec), UINT64_C(0xccfb7624df953560), UINT64_C(0x242e509054bf535c), UINT64_C(0xd53e8230b90b5b10) }}, {{ UINT64_C(0x1199b098ac4234ec), UINT64_C(0x9e3f5868a9b68f38), UINT64_C(0xd7698ca450d6c2d4), UINT64_C(0x7bf42144aca7e99c) }}, {{ UINT64_C(0xc586922088fee9d4), UINT64_C(0x9dbbdf101d1b6f00), UINT64_C(0xa176fffcce76a994), UINT64_C(0x20f4bd8ceb334d48) }}, {{ UINT64_C(0xef3ad1541a1a58ec), UINT64_C(0x7aaaf28863556654), UINT64_C(0xb64b1b1ca1b1d038), UINT64_C(0xdf28dfd08268b380) }}, {{ UINT64_C(0x78ad57fc40053b40), UINT64_C(0xd730394820a01140), UINT64_C(0x80a074acb81f4a58), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1a0a3958f7674d28), UINT64_C(0x160de840aa01ec90), UINT64_C(0xc7f3b56cc60bcffc), UINT64_C(0x0f60fd9c420dea14) }}, {{ UINT64_C(0x0e6ff4202d8b0ee0), UINT64_C(0x60d80aa8caf813d4), UINT64_C(0xc2eeaae899cf91a0), UINT64_C(0x6c8a01e8378b451c) }}, {{ UINT64_C(0x934131807d59a018), UINT64_C(0x3ecf125c93f2b7a8), UINT64_C(0xea54b2a0a9aedf00), UINT64_C(0x61bad0d03c82fec8) }}, {{ UINT64_C(0x871c1ebc1fa952e4), UINT64_C(0x6b06f5fc288d870c), UINT64_C(0x999c3e1c9e15d48c), UINT64_C(0x213acb6071fc508c) }}, {{ UINT64_C(0xe8de23b81c820308), UINT64_C(0xd9db2c94c2d5d760), UINT64_C(0xcf1de560a39b1fc0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x12d2d3a4b15edffc), UINT64_C(0x303c2a70efc3cf48), UINT64_C(0x0b5dcc2cc690a3d8), UINT64_C(0xd8a1d6fc237f6f34) }}, {{ UINT64_C(0x5e00fe40a76506dc), UINT64_C(0xc3b4c6d449c1b704), UINT64_C(0x674ee75099ef7cd4), UINT64_C(0x72d2a068d3d396a0) }}, {{ UINT64_C(0x490011e4579759fc), UINT64_C(0x3a9c37f064eb7f00), UINT64_C(0x0ab5d1a85977784c), UINT64_C(0x944102d83020924c) }}, {{ UINT64_C(0x1105cd40aa9fa228), UINT64_C(0xd15934ec4493af4c), UINT64_C(0x11046bd0b91a69a0), UINT64_C(0x3388670c1396eedc) }}, {{ UINT64_C(0x387277fcad28d4d4), UINT64_C(0x2c43ca50958ac9ac), UINT64_C(0x115e49442de82abc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1c9748d847265670), UINT64_C(0x09c97b88582e85b8), UINT64_C(0x35e4d158f09bceb4), UINT64_C(0x43cceca05d3b4b9c) }}, {{ UINT64_C(0xa5452f6880e7d43c), UINT64_C(0x15a8f454d5234698), UINT64_C(0x3f814ff0dbffb0d0), UINT64_C(0xe871ebb02dbffb80) }}, {{ UINT64_C(0x8963c4445aebf0ac), UINT64_C(0x23e7c31c05d659a4), UINT64_C(0xe848cef4c2050c44), UINT64_C(0x5c130e084e43bf2c) }}, {{ UINT64_C(0x6b20cbc067a4b2dc), UINT64_C(0x71bef7907f6fb030), UINT64_C(0x968d78a042460320), UINT64_C(0x08aaab7c1ba6af80) }}, {{ UINT64_C(0xfaf8d6d04bd78b50), UINT64_C(0x9cdb324cb7b47798), UINT64_C(0x9b102a506ac09f48), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x09538cac09491108), UINT64_C(0xdc0026acadf1f2b8), UINT64_C(0x82d330d813ef71c8), UINT64_C(0xed83bc6c98ac96e4) }}, {{ UINT64_C(0x2e385d60bacac914), UINT64_C(0xe20f1a10ca051054), UINT64_C(0xbaf2f734b9a41fd0), UINT64_C(0xc5e7a0448e06ab70) }}, {{ UINT64_C(0xee6aa9e8f21a706c), UINT64_C(0xe82157eccbd03218), UINT64_C(0xee6d7150db261e64), UINT64_C(0x5324dbec19e64630) }}, {{ UINT64_C(0x4e3a1fdccb65935c), UINT64_C(0xaf9a952c43591e48), UINT64_C(0xb9bc601431199870), UINT64_C(0x9701a4e0cd89f1f0) }}, {{ UINT64_C(0x3939da4435bb34e0), UINT64_C(0xb00b497808c16ee0), UINT64_C(0x76aa149c0f71e2d4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3eae8b6c12367c80), UINT64_C(0x88e80250b37436dc), UINT64_C(0xdb2d17b44d16892c), UINT64_C(0x88fa90bc820d3268) }}, {{ UINT64_C(0xe5f736549519e834), UINT64_C(0xb91db778184a4484), UINT64_C(0x1b80c3f8754043d8), UINT64_C(0x913f6bf4fbcfee68) }}, {{ UINT64_C(0x56f51e1895cead04), UINT64_C(0xfd8e3f087327c9a0), UINT64_C(0xd1185894d9451438), UINT64_C(0xee19042c2411f120) }}, {{ UINT64_C(0xe1576f005a646398), UINT64_C(0xeb84917c7af23dfc), UINT64_C(0xe34a7b0c6fb0391c), UINT64_C(0xe75639a843589f40) }}, {{ UINT64_C(0x57bce4e0aedbc5b8), UINT64_C(0x0a379e5046b9d7b0), UINT64_C(0xb7d04fd0a3f959e8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd18986c6f9e3d10), UINT64_C(0xa2bc2cd8a06d8f4c), UINT64_C(0xdc80c4f4b9ececa4), UINT64_C(0x70e98928cd758958) }}, {{ UINT64_C(0x61d22010327b666c), UINT64_C(0x4999e39c84e1dec8), UINT64_C(0x78cde734a2c61dec), UINT64_C(0x6fd280b488be3434) }}, {{ UINT64_C(0xd0686ac014b435b4), UINT64_C(0x82b0dbdcf0e689b4), UINT64_C(0xe1b37a48912b9844), UINT64_C(0xf655938caf45a300) }}, {{ UINT64_C(0xed242224a4ccaf30), UINT64_C(0x75698fc81e5c5694), UINT64_C(0xa7d1e51023522fd0), UINT64_C(0xa5228250f8b555c0) }}, {{ UINT64_C(0xb04be448576c7b78), UINT64_C(0x739057c8e23b2c50), UINT64_C(0x8a391ca4e8575578), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x955bdbc42f5602bc), UINT64_C(0xe4779e88153198ec), UINT64_C(0xfd46fd18f2504d4c), UINT64_C(0x20ea6808abf2f9c8) }}, {{ UINT64_C(0xa3596fe0fc693848), UINT64_C(0x73fea934af4db278), UINT64_C(0x56503ef426a1f0f0), UINT64_C(0xc2242c1ca30ed7dc) }}, {{ UINT64_C(0xfc19d5989d4c1374), UINT64_C(0xac399538a17d4abc), UINT64_C(0xfb70dd90085b1574), UINT64_C(0xb9c2c8fc31a4d798) }}, {{ UINT64_C(0x2309fbdc2c6d7920), UINT64_C(0xc0bd5d50ab56a8dc), UINT64_C(0xbbec9d10b1b86278), UINT64_C(0x04f493901b4fbcf4) }}, {{ UINT64_C(0x5cb6e120b5445124), UINT64_C(0xa05e660084629578), UINT64_C(0x24e868e4bfac2e2c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xddda97444c18f818), UINT64_C(0xd2c44c94865b3854), UINT64_C(0x78ab77cc4b36e864), UINT64_C(0xd176eb10f319dae4) }}, {{ UINT64_C(0x5d0362286217df34), UINT64_C(0x5dd706b8dec2e368), UINT64_C(0xb163a4d0e9126610), UINT64_C(0x1b6346dc6ea9e4e0) }}, {{ UINT64_C(0x454217003942ca14), UINT64_C(0xed224d28da87a408), UINT64_C(0x81238f68155a0540), UINT64_C(0x7da5b730b6f67b04) }}, {{ UINT64_C(0x4dbcc4f89ca04bc4), UINT64_C(0x4bded514d8e5e60c), UINT64_C(0x1c348984d7cbe018), UINT64_C(0x9e11541466f74f9c) }}, {{ UINT64_C(0xb2bece7c78753de4), UINT64_C(0x6b9c9b14a82c6e08), UINT64_C(0x537813981967a6a8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5d65c044cf484d1c), UINT64_C(0x953276bc30eac728), UINT64_C(0xf896a474f2197a24), UINT64_C(0x0b6a7ff010a38dd8) }}, {{ UINT64_C(0x7a0ae1e41e185af4), UINT64_C(0x3cb210202738067c), UINT64_C(0x164b36a4dfd42c9c), UINT64_C(0x7dfdc98cdbe5bbcc) }}, {{ UINT64_C(0x81407ba0212b9754), UINT64_C(0xdbbda3fcabebe720), UINT64_C(0x74d4c12805f60fd8), UINT64_C(0xd24442e0b5ad0d84) }}, {{ UINT64_C(0x79267968c7c528e4), UINT64_C(0x9239c1045f74075c), UINT64_C(0x2dcb23f87307d2fc), UINT64_C(0x7cf19adc3d321cfc) }}, {{ UINT64_C(0x8c5c0e3479db2b70), UINT64_C(0x9d0f26c488e9fcfc), UINT64_C(0x325fe2a4762bb974), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2ae9a9383d63f47c), UINT64_C(0x1d07d59cb055d8d8), UINT64_C(0x4e0cd7bc8cd8a3d8), UINT64_C(0x3eebd398d2491710) }}, {{ UINT64_C(0x7cee52cc7a0e2c40), UINT64_C(0xba8160a022655f78), UINT64_C(0x89a30acc52ef1358), UINT64_C(0x010f07889983e170) }}, {{ UINT64_C(0x9e146f1471d34794), UINT64_C(0x10443d74b85d9b94), UINT64_C(0x1b2168187913ca80), UINT64_C(0x3a1ca59c12170858) }}, {{ UINT64_C(0x0035febcbeb8ee94), UINT64_C(0xcb709084021c431c), UINT64_C(0x975aed8c154f470c), UINT64_C(0xc524d6bcdc9d465c) }}, {{ UINT64_C(0x473a1e2429df8d64), UINT64_C(0x3b85a160a103abd8), UINT64_C(0x4d3cda74852f9228), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x61720a10e506c710), UINT64_C(0x8124ef08e8554d18), UINT64_C(0x94d1ef3477e5dad0), UINT64_C(0x2d784ef8adcf1b84) }}, {{ UINT64_C(0x835db12898de60ac), UINT64_C(0x863edd04120e7b18), UINT64_C(0x9de80bfc2d3f3644), UINT64_C(0x8c8b9ae4c8079e80) }}, {{ UINT64_C(0x9ae9ea908f8c1be4), UINT64_C(0xb0988e642b8cd548), UINT64_C(0x4404b7949934cab8), UINT64_C(0xbccdc4d0355e9ccc) }}, {{ UINT64_C(0xf32414343f131bb0), UINT64_C(0x6fce8020360ae698), UINT64_C(0x4f568e34d3d2b420), UINT64_C(0x46a3db4c0d581b74) }}, {{ UINT64_C(0xad77aa2c073ef29c), UINT64_C(0xb02d99ac19cdf848), UINT64_C(0xde373a4cb4561688), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x81b54c4008432680), UINT64_C(0x297361b4de3e755c), UINT64_C(0xf05ecf8cddb5ea88), UINT64_C(0x93cb6ac495128c2c) }}, {{ UINT64_C(0x2b45e90c5fd0c6e4), UINT64_C(0xbc5e787898472a1c), UINT64_C(0xca1afeb0c7688764), UINT64_C(0x9c3de31ca612392c) }}, {{ UINT64_C(0x2f0964585d1f53c8), UINT64_C(0xa0376f743c39a560), UINT64_C(0x66cf3d20ff694e04), UINT64_C(0xacddc554d1ae4e94) }}, {{ UINT64_C(0xf5442fec01ab9408), UINT64_C(0x9af682a021ea9fe4), UINT64_C(0x5d18803c5f3521ac), UINT64_C(0x74b7bec0c40c3fec) }}, {{ UINT64_C(0x180c1e54bdb3f0d0), UINT64_C(0x90b64b246605ec10), UINT64_C(0xbae50c801d39eb10), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x907e8c6013d7d59c), UINT64_C(0x90c178680ee26094), UINT64_C(0x35e355883dee6910), UINT64_C(0xf53a65c40ed2b878) }}, {{ UINT64_C(0x966331e8130fc840), UINT64_C(0xeed6fe6cd1c7506c), UINT64_C(0xb1b3ab3c45c48088), UINT64_C(0xc4b7b2c45da9a92c) }}, {{ UINT64_C(0x747a4618a98922b8), UINT64_C(0x611d7da4e1672bbc), UINT64_C(0x018c0efc4871cf58), UINT64_C(0x2cfe1180b4a5a11c) }}, {{ UINT64_C(0xf51a0a800927043c), UINT64_C(0x4335fa30a2226470), UINT64_C(0x0b7ae2a839418588), UINT64_C(0x0fb47d60e24a4a20) }}, {{ UINT64_C(0xec99cc64408a755c), UINT64_C(0x3c7d268c10fa14ec), UINT64_C(0x6028fc6c40eaf0ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa337e7d424c5d0ec), UINT64_C(0x977695c42f60d04c), UINT64_C(0x0b3a7d2453dcce54), UINT64_C(0xa41445545d5fbd4c) }}, {{ UINT64_C(0x7a46532cf317b880), UINT64_C(0x5a5e7164a596f630), UINT64_C(0x21af5bf08b520134), UINT64_C(0x20764d882cb95e7c) }}, {{ UINT64_C(0x414c97d408bf9dbc), UINT64_C(0xd52619702b48c140), UINT64_C(0x279e0660e0d74b28), UINT64_C(0x3d1b3720f1cdfc08) }}, {{ UINT64_C(0xe2068918bf402824), UINT64_C(0x7699bcbc98ec97c4), UINT64_C(0x06615d4c922ea35c), UINT64_C(0xdc3caa00e4e52744) }}, {{ UINT64_C(0x57e993a8d235a3b4), UINT64_C(0xd148d6f80844b124), UINT64_C(0x03678b084adb5c04), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8f92a5f03e1f892c), UINT64_C(0x4a8895506f980ef8), UINT64_C(0x5db6f34c9daddc68), UINT64_C(0xb78a787086225de8) }}, {{ UINT64_C(0xeac20764af03c564), UINT64_C(0x55983a8c417fb214), UINT64_C(0x9f4eedf0aa2b5c48), UINT64_C(0x9679fe4cd7e85fe4) }}, {{ UINT64_C(0xb99d61645be0c034), UINT64_C(0x137437d407f50fac), UINT64_C(0xe4ef627838cb89cc), UINT64_C(0xd31ddaf40336ebb8) }}, {{ UINT64_C(0xe8374e640f71bcd8), UINT64_C(0x9a51a29847094bec), UINT64_C(0x9b7a88f0526e54ec), UINT64_C(0x12693aa0955c15e4) }}, {{ UINT64_C(0x13c6e17412c3f2b8), UINT64_C(0xdb9330d40b42bb10), UINT64_C(0xb2c0ab3cc8702230), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb8b62be4dc031010), UINT64_C(0xfffdab844272e0c0), UINT64_C(0x0ac1f4f01a3d4d34), UINT64_C(0xda0a4178ac7fb3a0) }}, {{ UINT64_C(0x0b0ebc30117192fc), UINT64_C(0x7bffa364201ced80), UINT64_C(0x1fc264dc8e8a86c8), UINT64_C(0x9c282dfcb8d58bc4) }}, {{ UINT64_C(0xedec974cd4c230dc), UINT64_C(0x5c8444643fb6f46c), UINT64_C(0x02714b982fc51c74), UINT64_C(0x23ead550053870a0) }}, {{ UINT64_C(0xe1c0f980b7e2a2c4), UINT64_C(0x31927c8822ff3fac), UINT64_C(0xeb1124f857a599dc), UINT64_C(0x04088c5cf738f6a4) }}, {{ UINT64_C(0x1af3629c4ece0ddc), UINT64_C(0xc8716aa0568872d0), UINT64_C(0x92d3c188a8522c14), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfe11afb84e8c1f9c), UINT64_C(0x667047a02433f3cc), UINT64_C(0xb24032c449509ce0), UINT64_C(0x6acb69ccfd721db4) }}, {{ UINT64_C(0x5ff0684c21a608e8), UINT64_C(0xf737364cb7107400), UINT64_C(0x6de8ae388b9870d4), UINT64_C(0x987f056858db2a60) }}, {{ UINT64_C(0xff5c4524eb865530), UINT64_C(0xa9d57f74ecd46628), UINT64_C(0x5f021a3c57ac8050), UINT64_C(0x3d322e70a5faf284) }}, {{ UINT64_C(0xb694857c8b840ddc), UINT64_C(0x06b2f0881e38f2f8), UINT64_C(0x732214f4306f4c10), UINT64_C(0x75727f608d96f8e8) }}, {{ UINT64_C(0xc21078d085157a80), UINT64_C(0x8fbd324816f67258), UINT64_C(0x2d4deb44c8d04860), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd835af3cf867c014), UINT64_C(0xbe99e344dd23e520), UINT64_C(0x3810f010df81d114), UINT64_C(0x8b8da780ad77c938) }}, {{ UINT64_C(0x5234cf2043896cec), UINT64_C(0x0050ece0b067368c), UINT64_C(0xb9d3ca245333e1a0), UINT64_C(0x926657e0ecdeb604) }}, {{ UINT64_C(0x82c69b482724e158), UINT64_C(0x847e47fc8de4a49c), UINT64_C(0xf5335b90e9cf923c), UINT64_C(0x9def9d082ee5ec04) }}, {{ UINT64_C(0x432686a03263a944), UINT64_C(0x16b79a704b745a20), UINT64_C(0x4c54f4d86114cb18), UINT64_C(0xbf4ca1981c0e8ffc) }}, {{ UINT64_C(0x1a6bf0fc798be298), UINT64_C(0x0dfa427c29fd6050), UINT64_C(0xf339f7fcecfc7544), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb12769c0446a3908), UINT64_C(0x322b1a601c8acc58), UINT64_C(0x8d9d8d08bb55dcec), UINT64_C(0x71d61220f835a9d8) }}, {{ UINT64_C(0xc2ea62f0a45b4740), UINT64_C(0x08d08c80924a7798), UINT64_C(0x21ce8ec0bc5ef66c), UINT64_C(0x05b1ea405423c7f8) }}, {{ UINT64_C(0x8ebec7c4cbb13470), UINT64_C(0xdbfdd42449436c34), UINT64_C(0xd6dd0288d39ccbd8), UINT64_C(0x5248aab0133809bc) }}, {{ UINT64_C(0x408c5e6c9de007a8), UINT64_C(0x9e3ada5415ca95f4), UINT64_C(0x921e42d0019b7dc8), UINT64_C(0xf196c680f2d09928) }}, {{ UINT64_C(0x2ab35a5438acb9b0), UINT64_C(0x92660d1c2efd64a8), UINT64_C(0xf852fbbc6c6257c4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xafba3968dd7cc798), UINT64_C(0x04affecc2a4a5298), UINT64_C(0x36fca0b035fb19a0), UINT64_C(0x0f26c4606fc532b0) }}, {{ UINT64_C(0x535fca8870dc7c3c), UINT64_C(0x491eba585bd051f4), UINT64_C(0x14a7ffe0c8969970), UINT64_C(0x19aa4a1431609934) }}, {{ UINT64_C(0x17ed73dc62f22ce0), UINT64_C(0x11f53fbc614b5bd4), UINT64_C(0x4a5c86f4ce85672c), UINT64_C(0xe9ed27fc0650654c) }}, {{ UINT64_C(0x194e73c004b66f64), UINT64_C(0x6fb6c588fd37ca90), UINT64_C(0x894240904aafe584), UINT64_C(0xe7507024fcdcb9f4) }}, {{ UINT64_C(0x857612fc718a1b24), UINT64_C(0xfb6a0558d2c90790), UINT64_C(0xc9dd4e6cdb1a3728), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x47cd9660486063e0), UINT64_C(0x92c966cc022bbb64), UINT64_C(0xba7f4f7c3545fbb8), UINT64_C(0xf497437020e882d4) }}, {{ UINT64_C(0x304dc9f806bbfce4), UINT64_C(0xb08a4194f92ea628), UINT64_C(0x82cdca60dd0cf710), UINT64_C(0x75c0491099fa5b3c) }}, {{ UINT64_C(0x772d4704d7326114), UINT64_C(0xfd689e5094d685f4), UINT64_C(0xb07422b4a48da644), UINT64_C(0x7ff24d34f1d6c898) }}, {{ UINT64_C(0xfac3782873e76430), UINT64_C(0xb64ed424d0fb1048), UINT64_C(0x061f32642a62d14c), UINT64_C(0x0c3a82bcc1dfcae8) }}, {{ UINT64_C(0x330525a4cc935e38), UINT64_C(0xa6a8e7981a659174), UINT64_C(0x24ff3128ee334778), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x16cb15a84b2684b4), UINT64_C(0x2c0170bcc1621a68), UINT64_C(0x6aa6a8503b5c1d40), UINT64_C(0x305f7a10e4d09f3c) }}, {{ UINT64_C(0x831b1e80ce9fe4c4), UINT64_C(0xb54bd94096adbe20), UINT64_C(0xd5ed8c440a32f528), UINT64_C(0x0d061c44aa00a030) }}, {{ UINT64_C(0xe95ce3b0556f71b8), UINT64_C(0x6c2a0b2c8de23b3c), UINT64_C(0x412ce79466777344), UINT64_C(0x7463546c0913b524) }}, {{ UINT64_C(0xb959eff88b34fb94), UINT64_C(0x5897ca5001855b24), UINT64_C(0x931d35243b71cde0), UINT64_C(0xb39b4398c2b248b4) }}, {{ UINT64_C(0x2a735e68fdbf6100), UINT64_C(0xc693a86401f518ec), UINT64_C(0x05add0bcad544128), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x97f74cacd43da328), UINT64_C(0x532dc8e454c49fb8), UINT64_C(0x6541081c8c5cab9c), UINT64_C(0x1860b98c906620f0) }}, {{ UINT64_C(0x4032d7041d81cf5c), UINT64_C(0x1ca2852000b74558), UINT64_C(0x0ce778102460b0f4), UINT64_C(0x6cdf2f04ae01761c) }}, {{ UINT64_C(0x42732d2cc9d71668), UINT64_C(0xd4c62f00d1593e50), UINT64_C(0x58d731c8f65258f8), UINT64_C(0x6b4d0b2c04d04820) }}, {{ UINT64_C(0x59fdab3cfc03b660), UINT64_C(0x9cafb0ec38000f70), UINT64_C(0x2fad2d24fcdfcc28), UINT64_C(0x06d43f646ad2f15c) }}, {{ UINT64_C(0x909443bc10f9d940), UINT64_C(0x4fa2fd74c3620f08), UINT64_C(0x2997c294dc47aefc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x70b316b08141d81c), UINT64_C(0xb9cd78c43f44a410), UINT64_C(0xb16ec0941dc96014), UINT64_C(0x06907d44caf9e98c) }}, {{ UINT64_C(0x1ab902f4bc422240), UINT64_C(0xfe20b82469634d4c), UINT64_C(0x42cb18485919cfa0), UINT64_C(0xa1145a3cf8dcccc8) }}, {{ UINT64_C(0x331ad6584f339c50), UINT64_C(0xde2c34400d0cfa98), UINT64_C(0xf7ba5310a31b24d4), UINT64_C(0x720c7d643dd37598) }}, {{ UINT64_C(0x6a92ba6491834ebc), UINT64_C(0xb36c04acbf0f5b30), UINT64_C(0x1e7de7d47e976418), UINT64_C(0xb4ef2e00335a2350) }}, {{ UINT64_C(0x978fea084e24e6c8), UINT64_C(0x4fbad3c8546e6384), UINT64_C(0xcaaabf8cefef44b0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2383118039ea7854), UINT64_C(0xa62604446c44d4c8), UINT64_C(0xca9970ec40706f9c), UINT64_C(0x1f4f176c836e64e8) }}, {{ UINT64_C(0x7e52b544b5e9e1e4), UINT64_C(0xf5fe41cc6b362194), UINT64_C(0xf0d737ec09e49ea4), UINT64_C(0x27625a04efc84340) }}, {{ UINT64_C(0xb27b49b0cc92f03c), UINT64_C(0x95423a142e639a34), UINT64_C(0x2abaa3d433e93b08), UINT64_C(0x4a8ad988abb714a8) }}, {{ UINT64_C(0x098844e830a06354), UINT64_C(0x6b678bb05c31c938), UINT64_C(0xe63c7bf8c5e7d6c0), UINT64_C(0xc36a539448f97d44) }}, {{ UINT64_C(0xf057a89c0739965c), UINT64_C(0x7ec4fbf478566c24), UINT64_C(0x50cf7358227bec08), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5e34f4d471a7f224), UINT64_C(0xc848f14493d74734), UINT64_C(0x4148db0c2e30e7b0), UINT64_C(0xe0b315f08d086dd8) }}, {{ UINT64_C(0xfe96a3ccbd95cf34), UINT64_C(0xa349e53cfc687114), UINT64_C(0x4ed67f080a2b95e4), UINT64_C(0xfa5bb958ce17b080) }}, {{ UINT64_C(0x55aa19680bd03a78), UINT64_C(0x8d583260e045f7f8), UINT64_C(0xb0a214c078e5eef8), UINT64_C(0x3f849068023dace4) }}, {{ UINT64_C(0xa105c2cc0969129c), UINT64_C(0x926e2fa423e8d704), UINT64_C(0x21518e30e206a650), UINT64_C(0x807c3978005917ac) }}, {{ UINT64_C(0x1e03b48c08ba1df8), UINT64_C(0xb983bc507493b5c4), UINT64_C(0x0d42e1ac4df895d0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x387d1d74e1d15f68), UINT64_C(0x094fd6184d582b3c), UINT64_C(0xfeed3e38fd67d0c8), UINT64_C(0x6977563c2b97e2a0) }}, {{ UINT64_C(0xc77eb35437178abc), UINT64_C(0x47b3ef885a57c6d8), UINT64_C(0xee4a42a06b1d1820), UINT64_C(0x51d1bbb099f30688) }}, {{ UINT64_C(0x25aadedc7a921180), UINT64_C(0x3dbe05f0b7f10d78), UINT64_C(0x907e4a500294b020), UINT64_C(0xaed117d4fa767d98) }}, {{ UINT64_C(0xa7b32ee020a2abd8), UINT64_C(0x150bbe1c02b13930), UINT64_C(0xf2bf85c0e0a7de48), UINT64_C(0x716f5e605dac33f8) }}, {{ UINT64_C(0x32b0391c05f730cc), UINT64_C(0xc2aa3188596f86a0), UINT64_C(0xa2dd085465ec0610), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xedf989dc7ccabff8), UINT64_C(0x72ff59e414ee1b40), UINT64_C(0x58f7b4805ceb0d88), UINT64_C(0x9d8a1a4866be79d4) }}, {{ UINT64_C(0xd6c7f3f09f71dd00), UINT64_C(0x1cd71fec30f8c604), UINT64_C(0x8d85688cbc07af50), UINT64_C(0xb6057e545ac8f9f8) }}, {{ UINT64_C(0x21f6c3d4bb2ead5c), UINT64_C(0xe2ef6258098925f8), UINT64_C(0x4fec7750e051d258), UINT64_C(0xb56d0ec0ed47c668) }}, {{ UINT64_C(0x5cc8337c03d03b98), UINT64_C(0x7360ec28a1960300), UINT64_C(0x50f5f498e2410dec), UINT64_C(0x370c0b40ac09cd10) }}, {{ UINT64_C(0xd614541054cd5b08), UINT64_C(0xdf93d848ba5413b4), UINT64_C(0x7b3cee286287ba38), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2f3c905425088bc4), UINT64_C(0x20d4f064fff4412c), UINT64_C(0x31c553dce06c6ee4), UINT64_C(0x2ecfe5d85ed54710) }}, {{ UINT64_C(0x4bf3fae4d29bd6dc), UINT64_C(0x927bbb601ac662b0), UINT64_C(0x50de6e448a37c7ec), UINT64_C(0xe7be5720f80b4aac) }}, {{ UINT64_C(0x9b75ea98900bc858), UINT64_C(0x2c01fa387e32edd4), UINT64_C(0xc6070df0033723ac), UINT64_C(0x5189a9e0f3549cb0) }}, {{ UINT64_C(0x7b5ff8340f665880), UINT64_C(0xcf51c5f0edb84028), UINT64_C(0x2038d694753a2b58), UINT64_C(0xfc633a8c5520d614) }}, {{ UINT64_C(0x2f2013780b96aaac), UINT64_C(0xf96663f098defba4), UINT64_C(0xb615257c8b7d0840), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa9b4909437159310), UINT64_C(0x86dd77f4100ac484), UINT64_C(0x8cbe1ff0e756ae80), UINT64_C(0x34f77d484b892e50) }}, {{ UINT64_C(0xd04a2198322428e0), UINT64_C(0x29610358cfc88c38), UINT64_C(0x2626c2d4810fe948), UINT64_C(0x7890c1741a1dffe0) }}, {{ UINT64_C(0xc85b67c84c985ad0), UINT64_C(0x89c3b468d2712f68), UINT64_C(0xb98b1f9c8293b638), UINT64_C(0xd836a640821d7650) }}, {{ UINT64_C(0xbc6c7928a88043c4), UINT64_C(0x43e5d6f8be19c0e0), UINT64_C(0xd88b10a0019e6fd0), UINT64_C(0xca77bdc05ac1f374) }}, {{ UINT64_C(0x1b22ea205851d77c), UINT64_C(0xcc4a260c786f9878), UINT64_C(0xb32196c0078fe0a8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb345f9182e5024b0), UINT64_C(0xc749b07c6e6b7564), UINT64_C(0xc75d702cf88b802c), UINT64_C(0xdd2961783970fa44) }}, {{ UINT64_C(0x8ea05e54c3184aa4), UINT64_C(0x4321300093fe3cbc), UINT64_C(0x76b1eb44821eda24), UINT64_C(0x192ab6e873475ea0) }}, {{ UINT64_C(0xc57b8938da9bf0a0), UINT64_C(0x778c1298fae0ba00), UINT64_C(0x16988f9c82fdc9bc), UINT64_C(0x7dced254914a52fc) }}, {{ UINT64_C(0x201263ecce7345b0), UINT64_C(0xe527eaa42ec036f8), UINT64_C(0x02021700f1fe7774), UINT64_C(0x20422b903cddf7c8) }}, {{ UINT64_C(0x598ff5187e890498), UINT64_C(0xa51840382c8cc5b8), UINT64_C(0xc2b4ddccecc25ee8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe863726c9e7b9fb0), UINT64_C(0xb5d4076ce00bb188), UINT64_C(0xb3651028a282208c), UINT64_C(0x192644c0048ea078) }}, {{ UINT64_C(0x5070dd98e3acfae8), UINT64_C(0x8944a260ec3612d0), UINT64_C(0x899dac7c6ba47164), UINT64_C(0x287def2cc51739c8) }}, {{ UINT64_C(0xe9fba54c35c09898), UINT64_C(0xf6dfbf88f20cace0), UINT64_C(0xf0aa5e4c9a718118), UINT64_C(0x307cc4287a858b48) }}, {{ UINT64_C(0xb4dc81eca875a580), UINT64_C(0x6e1b6f4017df687c), UINT64_C(0x177402e023b48d9c), UINT64_C(0xe51d1f4c424794dc) }}, {{ UINT64_C(0xbd52005c186b5e28), UINT64_C(0x5d4543a006b4dfd8), UINT64_C(0x2254ef942177f768), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe803608813889a34), UINT64_C(0x040ffa74f73be9f8), UINT64_C(0xfee5723408605518), UINT64_C(0x62cc6f48f575eca0) }}, {{ UINT64_C(0x24a077183e559d80), UINT64_C(0x8e88b70cc9955c30), UINT64_C(0x51eb58c06558935c), UINT64_C(0xcf0da93ca510a4dc) }}, {{ UINT64_C(0x31946ae8217f9420), UINT64_C(0x822ffec06dd4bef8), UINT64_C(0xc5afa50c482e3968), UINT64_C(0xb2c81dd0fb6e7198) }}, {{ UINT64_C(0x64d6da7cd4bd98c0), UINT64_C(0x3cb5fbfcebdafbd8), UINT64_C(0x9bfe366053ab3010), UINT64_C(0xc186e5bc7b7413d8) }}, {{ UINT64_C(0x93246fc0edff6984), UINT64_C(0x72f3aed88ebe842c), UINT64_C(0xf7d298700c16c194), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc67b07544e8fcb40), UINT64_C(0xf017773cd20ba74c), UINT64_C(0x270278380b514ba0), UINT64_C(0xd08cc43c2fc27bd0) }}, {{ UINT64_C(0x5bf3e06454319428), UINT64_C(0x2a1782685cd83698), UINT64_C(0xaab7eb4086bca3fc), UINT64_C(0x062bf0bc04239df4) }}, {{ UINT64_C(0x6fdfa80823a564e8), UINT64_C(0x081e53dc5f4f959c), UINT64_C(0xb239f35ca891d4b4), UINT64_C(0x85c1e8ace2fc4470) }}, {{ UINT64_C(0x2b14b57882b847d4), UINT64_C(0x23466fb0635c99d8), UINT64_C(0x131904a41561cfd8), UINT64_C(0x65bcf98c73a6ef1c) }}, {{ UINT64_C(0x37997608896fbfb8), UINT64_C(0x2314f17c74b64c4c), UINT64_C(0x421620385632e5b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7dd7ed84e428cdb8), UINT64_C(0x1a5d6060e667bff0), UINT64_C(0x79d50550573381e0), UINT64_C(0xd02980e496464a98) }}, {{ UINT64_C(0x5771e38cc6293274), UINT64_C(0xd76c10f86ffe6dac), UINT64_C(0x00bab4f412dcc280), UINT64_C(0xb61593e450246cf0) }}, {{ UINT64_C(0xa256d784eb83e4e0), UINT64_C(0x0b35be0cf829560c), UINT64_C(0xbb902304f966b5f4), UINT64_C(0x58e8b9008e93fac4) }}, {{ UINT64_C(0x50502828ec263ea8), UINT64_C(0xd8c8c63018e34450), UINT64_C(0x266155ec389c4020), UINT64_C(0x48fb4bd0224d56f4) }}, {{ UINT64_C(0x969896a8f0c4e704), UINT64_C(0x02df0c68d30f959c), UINT64_C(0x59854d3021ac9c60), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x74d028e8d5744fc4), UINT64_C(0xef032904f373b374), UINT64_C(0xe7a7382c64247b04), UINT64_C(0xdb377df8b14a2ebc) }}, {{ UINT64_C(0xef6b6470cf101554), UINT64_C(0x8cae2fd4e5baa248), UINT64_C(0xa2afc9704fb993d8), UINT64_C(0x2e09a15c5bfaa344) }}, {{ UINT64_C(0xc2a8428487ddd8e4), UINT64_C(0x967592108e9882f4), UINT64_C(0x4659e3aca1418d68), UINT64_C(0x8ef819ec45e5396c) }}, {{ UINT64_C(0xe6ff747cd7f36624), UINT64_C(0x3da5b9480f85edd0), UINT64_C(0xb631cae0a5f3916c), UINT64_C(0xb0573688dba7a8a8) }}, {{ UINT64_C(0x68abb1408febba18), UINT64_C(0x36988fc4013b57b0), UINT64_C(0xd6251abcddd14c70), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbf491bd8bfb85718), UINT64_C(0x3cf12bf0ed4e4d2c), UINT64_C(0x0dfef270419e0224), UINT64_C(0x0b55b3ec08574e18) }}, {{ UINT64_C(0xa53109dcb05573d8), UINT64_C(0xe9f857c43115d86c), UINT64_C(0x9d71f570fdf2fbc8), UINT64_C(0xc7b762f0272424f8) }}, {{ UINT64_C(0x59a0df842bdc2760), UINT64_C(0x792a760cadeb05e0), UINT64_C(0xfd50cfc868fecf24), UINT64_C(0x2ff7f52c900fec40) }}, {{ UINT64_C(0x44b82a205d32e500), UINT64_C(0xcd210f68c41235f8), UINT64_C(0x58d2c938616d905c), UINT64_C(0x7d41927c945ab728) }}, {{ UINT64_C(0xbba24800db94c174), UINT64_C(0xc57b85b4b6496de4), UINT64_C(0xe2bb9ae81b7496c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfaa8011c91b3d93c), UINT64_C(0x6f91f21c1482b0c4), UINT64_C(0x8de815b4801ded74), UINT64_C(0xec59de689c9d4bc4) }}, {{ UINT64_C(0xa93bc6a07ffcff40), UINT64_C(0x45c06778eac690b0), UINT64_C(0xae4cc284dfe7f27c), UINT64_C(0x81ef6b34c156b8c8) }}, {{ UINT64_C(0x115151f4d743b4d8), UINT64_C(0xab39a53c7676c33c), UINT64_C(0x96e8a0605f291e44), UINT64_C(0x6cc1960045d45db8) }}, {{ UINT64_C(0x8d9f5028c14ee69c), UINT64_C(0x3b9e4504b1b1934c), UINT64_C(0xd0d4c7100b7015a4), UINT64_C(0xe89f64fca8c722ec) }}, {{ UINT64_C(0xfe9565f8924cc244), UINT64_C(0x4871ddc01a799c40), UINT64_C(0x3c7a12309247501c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0253baa0e5d7188c), UINT64_C(0x6db1b42409627fec), UINT64_C(0xadec0e2036b555f4), UINT64_C(0xa412d278bc959590) }}, {{ UINT64_C(0xc61bf4e8a3d89130), UINT64_C(0x53de4e3ca642b514), UINT64_C(0xcc46317ccb770f74), UINT64_C(0x3244bf646f89695c) }}, {{ UINT64_C(0xfbe80844e4010064), UINT64_C(0x26490ec8675a0e74), UINT64_C(0x50af53d852e49ecc), UINT64_C(0xa90cdf78963133f0) }}, {{ UINT64_C(0x69874554e1e23e74), UINT64_C(0x356071a4460208fc), UINT64_C(0x763187c8a30bf568), UINT64_C(0xf8ce46fcc5492e08) }}, {{ UINT64_C(0x23f076c016515f80), UINT64_C(0x3b4b9f148dbd6fe0), UINT64_C(0x4d8ada587246900c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf3b74984af7fe728), UINT64_C(0x1893a290ef0d0c24), UINT64_C(0x32def43ccde00440), UINT64_C(0x60be5a4c5c6ac9dc) }}, {{ UINT64_C(0x0fe42b2cf663adf0), UINT64_C(0xabb57b3ca92f40d0), UINT64_C(0x7e5a9d58a85a52d4), UINT64_C(0xef5afa24a8b9ff30) }}, {{ UINT64_C(0x7a4e2ce0c0c77f7c), UINT64_C(0x1e20b1b4aebd3b98), UINT64_C(0x8e9033ec1e25b3b4), UINT64_C(0xdf0a66008ab7e314) }}, {{ UINT64_C(0x3a5ad59ca8ddba00), UINT64_C(0xa3d09cd0b5aba11c), UINT64_C(0xc55f2e8c60852dfc), UINT64_C(0x5c27f41489905474) }}, {{ UINT64_C(0x91dae7a857cb7d28), UINT64_C(0xf5eb8b80e6c9f9c0), UINT64_C(0x7817bae0a7363f60), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x22ff108caef994cc), UINT64_C(0x9e2d054c1770a0f0), UINT64_C(0xf9b10168ba2213ac), UINT64_C(0xdf0f728c9d4896f8) }}, {{ UINT64_C(0x5726051810ddc9cc), UINT64_C(0xee28fc14d40b1ef0), UINT64_C(0x860a65e449733280), UINT64_C(0x6b3beddce11e1338) }}, {{ UINT64_C(0xa9d28a5c75fdb0b4), UINT64_C(0xac9003e8e85cd294), UINT64_C(0x2a172dccbd048304), UINT64_C(0xa1049eccd14fb0c4) }}, {{ UINT64_C(0x1dd1359043ebf054), UINT64_C(0xfc096308065e1080), UINT64_C(0xbc49c6e08e1b6890), UINT64_C(0x2812e70c4e67992c) }}, {{ UINT64_C(0xf221df08bc9c31d0), UINT64_C(0x789b8e746b7d7824), UINT64_C(0xc3e2a8c4ed0966c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xde4119acffefc3c0), UINT64_C(0xfc4d94106b3ad8e8), UINT64_C(0xe5a36790a771e710), UINT64_C(0x81b86588c12c9d90) }}, {{ UINT64_C(0xe1614750257103b4), UINT64_C(0xa58d4b8890817838), UINT64_C(0xda945f547cfacd98), UINT64_C(0x66a3a99857ce1fbc) }}, {{ UINT64_C(0x9f94df305df3c294), UINT64_C(0xfd958480a1dc8cb4), UINT64_C(0x215658c8db666314), UINT64_C(0x4fa0ec08892df7ec) }}, {{ UINT64_C(0x93c2f0b8ff804720), UINT64_C(0x54fdd0a8c33742e8), UINT64_C(0xe2d9089c91a281fc), UINT64_C(0x2a450044dd54464c) }}, {{ UINT64_C(0xabf085b8fb2abed4), UINT64_C(0x282c295c6277ca20), UINT64_C(0x539332801ce59030), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfcf0b4bcb844a5ec), UINT64_C(0x9b0642e4406b1fe8), UINT64_C(0x2f750d6c70dc7998), UINT64_C(0x4d5c32bc7d326838) }}, {{ UINT64_C(0x8ed35c24f26bab38), UINT64_C(0xed1456747b519b00), UINT64_C(0xf782677c30289a14), UINT64_C(0x032d0b280598fe44) }}, {{ UINT64_C(0x66340e98a2b6b1a8), UINT64_C(0x10fe9fa0880c669c), UINT64_C(0x3c05dd10781ea0e4), UINT64_C(0xf5efd208d0f66694) }}, {{ UINT64_C(0xa044b9684c44e9ac), UINT64_C(0x40b34ec469ffabf0), UINT64_C(0x87fb4058fcc2760c), UINT64_C(0x48facd64ead9ed40) }}, {{ UINT64_C(0xf664a728a1b164dc), UINT64_C(0xb8279358ce6ca6cc), UINT64_C(0xbfc4ee6cdc80b050), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x724ed98c214193a4), UINT64_C(0x0aa63d60a1da14a0), UINT64_C(0xe7541db00185f2cc), UINT64_C(0x02003b60d20f6c34) }}, {{ UINT64_C(0xf15f03185b389058), UINT64_C(0x4b169030ffa8fdc4), UINT64_C(0x2975692c0d35fe94), UINT64_C(0x0936dc54714f22e8) }}, {{ UINT64_C(0xee32df7466c48c20), UINT64_C(0x1a7a26009f9c07f4), UINT64_C(0xfc111ae4851ff808), UINT64_C(0x63c9d534de88cfe0) }}, {{ UINT64_C(0x2cd8626cb33c5a20), UINT64_C(0xcdb881acd548eab8), UINT64_C(0xff7f1cd4f24ce298), UINT64_C(0x5114438c6977f38c) }}, {{ UINT64_C(0x52a45ce8b6d679e0), UINT64_C(0x6a3dc42c3d1da50c), UINT64_C(0x82b1512076b99f4c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa831aa3c06d7b368), UINT64_C(0x004f0dd85470b1b4), UINT64_C(0xcf079fdca70f5514), UINT64_C(0xe85f15a413c4fef4) }}, {{ UINT64_C(0x20ed1de401fe6fd0), UINT64_C(0x93b7c6f8a2b0e778), UINT64_C(0x81d84ee8daedbabc), UINT64_C(0xeb19d794a28d274c) }}, {{ UINT64_C(0x5d401cbcd657f3ec), UINT64_C(0x542fcf78794413d4), UINT64_C(0x122fd8c40a577e90), UINT64_C(0x634f51e4f91e76c0) }}, {{ UINT64_C(0x9a8e7428e21152e8), UINT64_C(0xbf04c0cc73cdf6a8), UINT64_C(0xc0b920c40a577358), UINT64_C(0xcf3c91d4ff77006c) }}, {{ UINT64_C(0xdb44ef447d9c988c), UINT64_C(0xc8c23988ad494248), UINT64_C(0x4c62caec50edcf2c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8e770f0488897204), UINT64_C(0x7e1e03740f8ec798), UINT64_C(0x55e3b02491ae8db4), UINT64_C(0x1c8dd26c0174bfb4) }}, {{ UINT64_C(0x0ebdc7ccd289cf5c), UINT64_C(0x85cd2840bea70660), UINT64_C(0x1a08a5b8ef63731c), UINT64_C(0x1020ebd80769197c) }}, {{ UINT64_C(0x418260a4622a5368), UINT64_C(0x5228ac94bb481290), UINT64_C(0x2c3edc6cf5fef140), UINT64_C(0x8f348684cc2cd8e0) }}, {{ UINT64_C(0x0fbb4784214a2894), UINT64_C(0x8ef92b18378d3130), UINT64_C(0xe27f0fdc454859c8), UINT64_C(0xa9196f8810679118) }}, {{ UINT64_C(0x4d722f48e214e19c), UINT64_C(0x8838adf8f1146f7c), UINT64_C(0x9d357ddc739fe648), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2c9e54bc7b1e348c), UINT64_C(0xb16c171046a4c184), UINT64_C(0xb759db3c4ee8b20c), UINT64_C(0x9247da3c67088e38) }}, {{ UINT64_C(0x7adce8f0ed4ee7f0), UINT64_C(0x52c5dda41757611c), UINT64_C(0x8a8a7b602a007f9c), UINT64_C(0x6310bd04830c3af0) }}, {{ UINT64_C(0x7137ea8836caba48), UINT64_C(0x31ec80bc87ab8ee8), UINT64_C(0xf497f2b8798d3b2c), UINT64_C(0x91f20aa064a94afc) }}, {{ UINT64_C(0x31e8b9607c77354c), UINT64_C(0xf02b1294162c67dc), UINT64_C(0x2cf6eb20ac38af68), UINT64_C(0xed9881f09591c3d8) }}, {{ UINT64_C(0xe983d26cbfab6500), UINT64_C(0x9fcffea02bc4d6d4), UINT64_C(0x803d9024c8fab5cc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x70bcae984075e8b4), UINT64_C(0x93f85d58d719fae4), UINT64_C(0xbb54799040c38a70), UINT64_C(0x9eb981e4ed7a2b50) }}, {{ UINT64_C(0xd319e5f8fa1edf30), UINT64_C(0x8dff21e02fa7fc70), UINT64_C(0xe46e8b98940da170), UINT64_C(0x82189804f0a7d060) }}, {{ UINT64_C(0x3cc9785cb60f2224), UINT64_C(0xc2a628f478b6315c), UINT64_C(0xe2f6cbb44092c6ec), UINT64_C(0x7c3cdb80da12b500) }}, {{ UINT64_C(0x8bd186807db446dc), UINT64_C(0xdbc8f254a3c21b78), UINT64_C(0x4bd47b14cd6ddc90), UINT64_C(0x772e8290d7c34f28) }}, {{ UINT64_C(0x708811403ed74c30), UINT64_C(0x27158214b38fe060), UINT64_C(0xbb7da2d4a1f02768), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x690d494c52cbfa14), UINT64_C(0xa2aaf2a894ba2f44), UINT64_C(0xf61ed15cf232cf40), UINT64_C(0x330f92d4f02399f0) }}, {{ UINT64_C(0x5df7d59c2f698bbc), UINT64_C(0x5599e1a8e456c6d8), UINT64_C(0xfa7576a08934c354), UINT64_C(0x0dff69dca6b91b38) }}, {{ UINT64_C(0xb2593b50621249d8), UINT64_C(0xe49ebbe48549421c), UINT64_C(0x7db0bd1055ce05c8), UINT64_C(0xdd5b440c6c5e9964) }}, {{ UINT64_C(0xfbfa0e3809a067d0), UINT64_C(0xf48b1ddc5463cc30), UINT64_C(0xf0a4363c69e3bb64), UINT64_C(0x3e5c9254b3afb4b4) }}, {{ UINT64_C(0xb923cf5c1612b004), UINT64_C(0x2f90c48c4d77a120), UINT64_C(0xb549d92cd7f5d968), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x705b0738b81f3574), UINT64_C(0x6fdc6b9c4987db04), UINT64_C(0xfeaf9ad82ac0c6cc), UINT64_C(0xe2a2a4a056db15b8) }}, {{ UINT64_C(0x5f685ae0c8d24bb4), UINT64_C(0x576d43fc1e6b9480), UINT64_C(0xede7fee0ca8ddf8c), UINT64_C(0x59897ca896bc14d0) }}, {{ UINT64_C(0x366a02d48af684c4), UINT64_C(0x6ca121f079d9abb8), UINT64_C(0xa22bcaf859e12470), UINT64_C(0x2fbeb75c2a8e53b0) }}, {{ UINT64_C(0x2c7f0e70ad18d828), UINT64_C(0x614b7e80dfed8038), UINT64_C(0x9f13eeb8fc186ac0), UINT64_C(0x4b1225502f6676a0) }}, {{ UINT64_C(0x873f18e4a2ff20d8), UINT64_C(0x711b472895cf6e48), UINT64_C(0x40293e202c859fd0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2372029c7345ff90), UINT64_C(0x12e87fb4c6ab03fc), UINT64_C(0x6afbd848d9446430), UINT64_C(0xd045e89cbf0b7d2c) }}, {{ UINT64_C(0x9b23b0d44316bf34), UINT64_C(0xe5ae2dc4c8112be0), UINT64_C(0xb6f78530f54eb198), UINT64_C(0x1c25ca709a693134) }}, {{ UINT64_C(0x515a4f2051f50080), UINT64_C(0xe0ceddb0bba22360), UINT64_C(0xf26c5c1c71caec50), UINT64_C(0xf9fe642c9d9b74c8) }}, {{ UINT64_C(0x767e1d18777f8584), UINT64_C(0xffebed043bb9a824), UINT64_C(0xe885c81012721908), UINT64_C(0xf42011e462f5d3dc) }}, {{ UINT64_C(0x55c961b4c49e5d88), UINT64_C(0x99b9696486b3e89c), UINT64_C(0xf94264c40aec9550), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x65086c2c03aa975c), UINT64_C(0x75d4bf807545565c), UINT64_C(0x08d236441a43a284), UINT64_C(0xa49da2ec2eeddb88) }}, {{ UINT64_C(0x3e4ec8281ff3edd8), UINT64_C(0x9d2bd100c735fd9c), UINT64_C(0x80f8ad70940e2028), UINT64_C(0xdcf70750f0f3ea64) }}, {{ UINT64_C(0x95fb1da041eb2b78), UINT64_C(0xd5fd6358d9ca7da4), UINT64_C(0x749c43f8ee356480), UINT64_C(0xa387e88c42f9efe8) }}, {{ UINT64_C(0xe20e1e602da17100), UINT64_C(0x89fa54d49b46a48c), UINT64_C(0x7ae998c4ac187d44), UINT64_C(0xfce41ac0ea2f6918) }}, {{ UINT64_C(0xddd3fd0c9e32c1d8), UINT64_C(0xeb6f534893cc7208), UINT64_C(0xd97da76ca29f5614), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x76449d28e5451388), UINT64_C(0x2564e6a8d3223e98), UINT64_C(0x320cc0f4530e250c), UINT64_C(0x8a0024a8d9d57fa4) }}, {{ UINT64_C(0x82f1e940b5fa325c), UINT64_C(0x937e330c22c5ac70), UINT64_C(0x022d0568e0bad814), UINT64_C(0xfda35a8cbad69f94) }}, {{ UINT64_C(0xaa1ca8f083e621c4), UINT64_C(0xa1a5fa6cbd6e9d60), UINT64_C(0xc7e33bfcb960a934), UINT64_C(0xc418a53c92ce697c) }}, {{ UINT64_C(0xb61eb6b44495b834), UINT64_C(0xbc2ab194c3fc99b8), UINT64_C(0xa040fd5c10cc9894), UINT64_C(0xd7f4c298490850f0) }}, {{ UINT64_C(0x6521310c5cc2e24c), UINT64_C(0x1b8208b09860f0e0), UINT64_C(0x390ead7c271cd35c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5325e79c332dc310), UINT64_C(0xafa9bda01f1ffef4), UINT64_C(0x52604df8929560bc), UINT64_C(0xad4aa72018891c2c) }}, {{ UINT64_C(0xfd0f4f306af38bf0), UINT64_C(0x0aad260ce11a6008), UINT64_C(0x9c5209c04c5a0154), UINT64_C(0x4ffa543caf2851b4) }}, {{ UINT64_C(0xbc59a7c06171ee78), UINT64_C(0xb3931c74a0362120), UINT64_C(0x6722defc302cdab8), UINT64_C(0x1d70271c468b1e88) }}, {{ UINT64_C(0xa22f84e0e3ad8694), UINT64_C(0x4db7fe484e4314f8), UINT64_C(0x72f68530330565a4), UINT64_C(0xd93ea5289df68e28) }}, {{ UINT64_C(0x39103e2049be1bd8), UINT64_C(0x19b6fab8c1166150), UINT64_C(0x05de72b4eed46e74), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8ba04ab4135a7d6c), UINT64_C(0x82ce98a0c4941ddc), UINT64_C(0xb40093f4a07b7388), UINT64_C(0x2dc36440f89af224) }}, {{ UINT64_C(0xe53e4d346ac4779c), UINT64_C(0xe29715d4e8537288), UINT64_C(0xeb9816207db9938c), UINT64_C(0x630b3664dec260dc) }}, {{ UINT64_C(0xe13d6178f963942c), UINT64_C(0xfc27c4a8d93a58dc), UINT64_C(0x649810cc764f8cc4), UINT64_C(0xd19cf0fc8b15a014) }}, {{ UINT64_C(0x2080e3c8f6f1b8ac), UINT64_C(0xdce6ee3cf31b97f4), UINT64_C(0x8cadd2d89c8473f8), UINT64_C(0xafd97bf8ec78f288) }}, {{ UINT64_C(0x4de6782c46c70e78), UINT64_C(0xd4185f0ceb040874), UINT64_C(0xeb73e83ced8c2c90), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd773d1c4371a7e30), UINT64_C(0x4bedb9ccc0ce3b48), UINT64_C(0x914b633c9307feb8), UINT64_C(0x14160b346c781434) }}, {{ UINT64_C(0x711c0d5ca320a200), UINT64_C(0x48f8c10033566960), UINT64_C(0xb021c090e676b1e0), UINT64_C(0xae111734b6152488) }}, {{ UINT64_C(0xefcade9464c48a84), UINT64_C(0x798ff39c8f8ca138), UINT64_C(0xcac46ea4a82ca820), UINT64_C(0x9d04a708daeb2534) }}, {{ UINT64_C(0x8c8369bc140c9ae4), UINT64_C(0xcd26c558a2f50470), UINT64_C(0xc9455d9cd71a9ea0), UINT64_C(0x950cf344ea34b8ec) }}, {{ UINT64_C(0xcb80b444e2be4e60), UINT64_C(0x0da838d4c430e8d8), UINT64_C(0xdf852c98d7f3b21c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8ab09a6caf562980), UINT64_C(0x4ea2db6406b84220), UINT64_C(0xda4b777cbdd6ced8), UINT64_C(0xc3edfc542fa57c08) }}, {{ UINT64_C(0xdae11c08043258e8), UINT64_C(0x8a20483086fb672c), UINT64_C(0x4a4f6ad4fe09b75c), UINT64_C(0x3b716a2867dff39c) }}, {{ UINT64_C(0x2c41e4087ed980d8), UINT64_C(0xccd0c034dcb4c2d0), UINT64_C(0x4c69177c305f8528), UINT64_C(0x41fe24f40b6b9638) }}, {{ UINT64_C(0xdba504f4899b8c70), UINT64_C(0x852cfb189bcdc53c), UINT64_C(0x7273e62815b9a89c), UINT64_C(0xe3f3d7008289e5c4) }}, {{ UINT64_C(0x7a47d80804e4ae20), UINT64_C(0x1eca93888fa65d20), UINT64_C(0x1ff1b3c0d8d0e054), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x408dbe007b095c50), UINT64_C(0x86ae8a80f298a1b8), UINT64_C(0x04d1a07c6e42e688), UINT64_C(0x0f3e5e747cb46830) }}, {{ UINT64_C(0x520f324c8d04d948), UINT64_C(0x0411142c2f94b214), UINT64_C(0x5c6b8690aa8cd164), UINT64_C(0x9de9e8a0e976bb54) }}, {{ UINT64_C(0x296869440cbce154), UINT64_C(0x7605ab3c259951d4), UINT64_C(0x59c0c480dd91b390), UINT64_C(0x88a366b03ace4404) }}, {{ UINT64_C(0x34a86c5045633214), UINT64_C(0x37a6d36cc58dcbe4), UINT64_C(0x56dc165861a98df4), UINT64_C(0xeb1fe25ca33c009c) }}, {{ UINT64_C(0xea3bc060996c208c), UINT64_C(0xa0b4c4e0b70f92e4), UINT64_C(0x024dca04594686e4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7e85df6441e3b278), UINT64_C(0x1ac52908769b7968), UINT64_C(0x4fe3779002628284), UINT64_C(0x08b078c4d1178f60) }}, {{ UINT64_C(0x574ddeb46c9645bc), UINT64_C(0xcbbde14c463c3afc), UINT64_C(0x942e6be0ed65ada4), UINT64_C(0x8ae649bc3f2c973c) }}, {{ UINT64_C(0x17b6a1183ec31d10), UINT64_C(0xcd2a2010b504d198), UINT64_C(0x68fd91c472704564), UINT64_C(0x5a626f98260521b0) }}, {{ UINT64_C(0xf2b9b6c8f3aeffc8), UINT64_C(0x106b70cc19f79b68), UINT64_C(0x40f4848c3b4a6c30), UINT64_C(0xd8746508ff2f1750) }}, {{ UINT64_C(0x8627de244d31d9c8), UINT64_C(0x7859b2202fe49b84), UINT64_C(0x2468321095a7be18), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1a3316b87a608eb8), UINT64_C(0xd94dcb583603cd8c), UINT64_C(0x2a14a17cc5285e74), UINT64_C(0x77834b7c40533bc8) }}, {{ UINT64_C(0x3e3e650086e50db4), UINT64_C(0xbc1aca883886eeec), UINT64_C(0x54f51444965cd130), UINT64_C(0x50d55e045a2f290c) }}, {{ UINT64_C(0x0ec58848fc330944), UINT64_C(0xad1a4658a7ff794c), UINT64_C(0x4c874fb423f6651c), UINT64_C(0xe440a4a87c0c1908) }}, {{ UINT64_C(0x6dd6e87cf74456d8), UINT64_C(0x0b2df8f00093bb84), UINT64_C(0x7cafdbe8a62962dc), UINT64_C(0x3085e630533ece54) }}, {{ UINT64_C(0xd9023c780523d480), UINT64_C(0xfc761754eb0dd3a8), UINT64_C(0xb99aabf4411b7044), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x815521d8b95825bc), UINT64_C(0xcdeefa688fdb0a14), UINT64_C(0xaffd0698ec0c4df4), UINT64_C(0x374711d86fa31194) }}, {{ UINT64_C(0x5dfaaaecaaf3da4c), UINT64_C(0xd2cc0de4e3efa9a0), UINT64_C(0xabf54e98f5abf4cc), UINT64_C(0xe216ea5430cdfb70) }}, {{ UINT64_C(0x79b29d2c5a9fa1a0), UINT64_C(0x0d6b4bb0d63f19a8), UINT64_C(0x7a95445014bcff5c), UINT64_C(0x1a43c8e4c8071bbc) }}, {{ UINT64_C(0x87c7c860a2a937cc), UINT64_C(0xeeff73b0b1807818), UINT64_C(0x941015b085a15560), UINT64_C(0x97481dc0d0848aa8) }}, {{ UINT64_C(0x1096deb8c0f4d4a4), UINT64_C(0xec84ae94007c0f98), UINT64_C(0x5945a26c48f9c430), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8cb3a4f4ba0b0d0c), UINT64_C(0x1c3747bc2985a7c0), UINT64_C(0x59d454585a25ffb8), UINT64_C(0xbe1203fcfe9cbaa4) }}, {{ UINT64_C(0x655798f8ae839db0), UINT64_C(0x543c2ea009f1e614), UINT64_C(0xd9a27060638ad1ec), UINT64_C(0x13b700885694e3a0) }}, {{ UINT64_C(0x6ba34eac43b54e98), UINT64_C(0x7a81d1d42aaff3c8), UINT64_C(0xfaf103a0ac6053c8), UINT64_C(0x432354281e3bad90) }}, {{ UINT64_C(0x2e6181b4bdbc5f80), UINT64_C(0x8945c51c74b4fef0), UINT64_C(0xdc89ca98d2792a5c), UINT64_C(0x6ef0321c452ae6f8) }}, {{ UINT64_C(0x10b86540a09dfd24), UINT64_C(0xecc20618349dc898), UINT64_C(0x5355e80cda5d6ab8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbeb30780ff117638), UINT64_C(0x631b567cf58572d0), UINT64_C(0xa981035c6b43369c), UINT64_C(0x1168ff481c28fb3c) }}, {{ UINT64_C(0x50f526c4c06f3a0c), UINT64_C(0xa12d86b00a3b5f54), UINT64_C(0xf2d651a03b2405b8), UINT64_C(0x527dd72c6c595540) }}, {{ UINT64_C(0x8a3986745ebeab88), UINT64_C(0x5b295524bc9915b0), UINT64_C(0x2886d48c3309d3b8), UINT64_C(0x053ff00cc34ace6c) }}, {{ UINT64_C(0x52e3742083c8dd04), UINT64_C(0xab9ea550e126ef6c), UINT64_C(0x638035c8b26e2e20), UINT64_C(0x6321e738f9a68160) }}, {{ UINT64_C(0xaaf26ae4ddb131c4), UINT64_C(0x2a3cb9cc605ee42c), UINT64_C(0x7f437c34a45952e0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x503461106292a5b4), UINT64_C(0xa24e2494171ecc78), UINT64_C(0xd0897a2c32c5e98c), UINT64_C(0xa4c47438ee402518) }}, {{ UINT64_C(0x09f4ca60f0b0f3f4), UINT64_C(0x67bbbb6870184094), UINT64_C(0x50d30034928db950), UINT64_C(0xf9366f7046062c04) }}, {{ UINT64_C(0xed9aca40cef9e7e4), UINT64_C(0xb9f7e4949d92cb00), UINT64_C(0xc60ac85cabcfece4), UINT64_C(0xf145b18c5e4c78fc) }}, {{ UINT64_C(0x4d8f4ea0bf0cd518), UINT64_C(0xf893ef2894b636e4), UINT64_C(0xbf322b8039a7d274), UINT64_C(0x591ecc3c53a8b0d8) }}, {{ UINT64_C(0x9fab2fecc43d5bf0), UINT64_C(0x28ae5a247c5c1a38), UINT64_C(0x8d1832704b1a0010), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf9d4693092bf28ec), UINT64_C(0xd9b70b400126b300), UINT64_C(0x317b8b7411a70d8c), UINT64_C(0x26a87a643886c5f0) }}, {{ UINT64_C(0x962320302ef02024), UINT64_C(0xa253ea58b14eae20), UINT64_C(0x55b93c2857576e00), UINT64_C(0x1e2c8db47464afbc) }}, {{ UINT64_C(0xfeab00641f4c0c60), UINT64_C(0xe05af190d0eb5624), UINT64_C(0xeeb8a6600fd6c09c), UINT64_C(0x43c5e0cc14fb5498) }}, {{ UINT64_C(0x2dd8c2dc670f44c8), UINT64_C(0x1b0d844ca906c56c), UINT64_C(0xc0fc26945c59f760), UINT64_C(0xf8a73a2cd3079f6c) }}, {{ UINT64_C(0x51898630e4bcfdf0), UINT64_C(0xdd3de608dde7e864), UINT64_C(0x452ebffcda5b86d4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x03bbd20c25baca20), UINT64_C(0x53209864c4b83cb0), UINT64_C(0x7d8c674033a0fa34), UINT64_C(0xdba4f360b615c850) }}, {{ UINT64_C(0xc9d56d587e9b3cbc), UINT64_C(0x0a510e50f3a09bc0), UINT64_C(0xfdb2a20cf5dcde00), UINT64_C(0x0f5f36b80ea74a14) }}, {{ UINT64_C(0xc10dc7e4b138e054), UINT64_C(0xb531b1bc0c97a0cc), UINT64_C(0xa3758f94b7e7655c), UINT64_C(0xe893b0b05f9539ac) }}, {{ UINT64_C(0x677a37a473bcb4d4), UINT64_C(0x68da9bb87ae6cce8), UINT64_C(0xc8059304d21f9244), UINT64_C(0x662cdcdcaeac814c) }}, {{ UINT64_C(0x4116756491916430), UINT64_C(0x74b3a8f085098f1c), UINT64_C(0x4ec9b4ece4ac9504), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9e30a210d912c4fc), UINT64_C(0x86c39ab4f10f7248), UINT64_C(0xd2b2a150f4bfc4fc), UINT64_C(0xef7502f873ef9250) }}, {{ UINT64_C(0x328a7ef0e9da0d70), UINT64_C(0xb78fc188ca3624a8), UINT64_C(0xdd0dfe30849fd198), UINT64_C(0x868d0ab837b36554) }}, {{ UINT64_C(0x82e107b8838ad3cc), UINT64_C(0x2ce95c04e26dc8c8), UINT64_C(0xb56b94c86ef7cdc0), UINT64_C(0xa97b59f095a72844) }}, {{ UINT64_C(0xa15289047f3abf2c), UINT64_C(0x1f99fbd41bb85458), UINT64_C(0xe86ae6944dbc14bc), UINT64_C(0x79f89d742df5b378) }}, {{ UINT64_C(0x4d0da580a0a8e780), UINT64_C(0x13b2e5806f23725c), UINT64_C(0x47b3a8781aa32780), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x87513380907b10cc), UINT64_C(0xd2d5b978d175fcc4), UINT64_C(0x61d85e40978ab7ec), UINT64_C(0xc0eec370b5305b44) }}, {{ UINT64_C(0x375aeae02bf8801c), UINT64_C(0x44c7566811af47f4), UINT64_C(0x2f9dab60872dbc50), UINT64_C(0xfb31d1287edbac58) }}, {{ UINT64_C(0x5c3ec1b01a954654), UINT64_C(0xd7d3f7500b0ee060), UINT64_C(0x1a3ede2cfcaa908c), UINT64_C(0x55f4cffc0708d7cc) }}, {{ UINT64_C(0x3932472c5cf93484), UINT64_C(0xe2cc21bc54729d44), UINT64_C(0x06319990cbbcc968), UINT64_C(0x7f3e68ecb768a6e0) }}, {{ UINT64_C(0x03f1648802a6039c), UINT64_C(0xc49052b0d2fb86e0), UINT64_C(0x04306908b667fdb0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1babbd80dc2aabd8), UINT64_C(0x89b96d3c9a233f0c), UINT64_C(0x7babcc6c7a376f44), UINT64_C(0x6f16e20c6cc7f440) }}, {{ UINT64_C(0x4a33e7a4d4602634), UINT64_C(0xe3decaa8af379d08), UINT64_C(0xb1e5c09c390dc670), UINT64_C(0xc4597de48775b124) }}, {{ UINT64_C(0x2b41ef78db789f44), UINT64_C(0xf8b0d3a8a01f79a4), UINT64_C(0xbfb704a0dc4544d8), UINT64_C(0x7c9cffb85c333c84) }}, {{ UINT64_C(0x2e1f67980fd2f2a0), UINT64_C(0x03ac42b40ab2b2cc), UINT64_C(0x8869f604389cb55c), UINT64_C(0xd22563e0deadf624) }}, {{ UINT64_C(0xb61bd050a475a7ac), UINT64_C(0x048764f0633a0cf4), UINT64_C(0x1a9e64789f6385dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbe401870d7955d4c), UINT64_C(0x47046a14444de134), UINT64_C(0x1810a598f6864de0), UINT64_C(0x4795e24c7bdcd030) }}, {{ UINT64_C(0xf06408a866be85a4), UINT64_C(0xfbac9bb47e71ce10), UINT64_C(0x06d21be85f1bb780), UINT64_C(0xb7786ec00278a200) }}, {{ UINT64_C(0xf4d8bf50c3242d40), UINT64_C(0x970ac7980a43ac2c), UINT64_C(0x7a1ad3c423d8121c), UINT64_C(0xa044825c8da2c190) }}, {{ UINT64_C(0x4abfec6c7c4a4ecc), UINT64_C(0x9a7a4a28bf4b60cc), UINT64_C(0xa257dbc058e8ee20), UINT64_C(0xf0688d64f6ef62f0) }}, {{ UINT64_C(0x1980e9e04c05805c), UINT64_C(0xca3769208c978ac4), UINT64_C(0xe5227ca8bad67d50), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x92f20a0cbf4f771c), UINT64_C(0xb7b9190016eb8d30), UINT64_C(0x080d98889376ae54), UINT64_C(0xbbc5e6306d7ecc94) }}, {{ UINT64_C(0xdd3e31a0cb24e094), UINT64_C(0xe793292cbfe74780), UINT64_C(0x57c8a1002561d214), UINT64_C(0x6d9cf48cb30bcf94) }}, {{ UINT64_C(0xb61b5ec06074c4e0), UINT64_C(0x9fbedf88b03d44bc), UINT64_C(0x4a54a458b7ada7a4), UINT64_C(0xb3515e8c6517ddf0) }}, {{ UINT64_C(0xf069ae70e0b485dc), UINT64_C(0xb47e269c93a8a554), UINT64_C(0xf54a4d546d6ebe88), UINT64_C(0xc4e246249aea3d4c) }}, {{ UINT64_C(0x36468f4c10f3f44c), UINT64_C(0x579f495c67862e10), UINT64_C(0x7eaccfe0c8bc87a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9f5dbbb480e30d40), UINT64_C(0x3466981cefa78c0c), UINT64_C(0x8bd24be0ae227210), UINT64_C(0xc6b97840ee504654) }}, {{ UINT64_C(0x7dd291203badc6f4), UINT64_C(0x408cd3c0f079519c), UINT64_C(0x3a88c3349e6720c8), UINT64_C(0x4bbcaac8e9c672c4) }}, {{ UINT64_C(0xdc5be1a46e969424), UINT64_C(0x26aa4b9409db2f78), UINT64_C(0x98e0c3184dbac59c), UINT64_C(0x3c97d690d451c4ec) }}, {{ UINT64_C(0x433ac8b8ce29c3ac), UINT64_C(0x0d38d0a065cb860c), UINT64_C(0xb8ef648087e3a2e0), UINT64_C(0xfce8ac8ce5065ad0) }}, {{ UINT64_C(0x973f6410169f10d0), UINT64_C(0x96b29c58762fd24c), UINT64_C(0xeeb90d8c0cfdf25c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xadf7ad748cd92558), UINT64_C(0x511b604cb360d750), UINT64_C(0x9f1dd794c5a1b348), UINT64_C(0xcca48dc8fc666f7c) }}, {{ UINT64_C(0x9be137ec603410fc), UINT64_C(0x45df7b60191aaf80), UINT64_C(0x82609d00d0c6d568), UINT64_C(0xaba5b2bce2539b48) }}, {{ UINT64_C(0x78fa1280a32d3d20), UINT64_C(0x924c9400d5b82974), UINT64_C(0x7e5931dcc367b5d0), UINT64_C(0x70a0fd6cc33d7010) }}, {{ UINT64_C(0xbf975be46b618ce8), UINT64_C(0x2f7ddbe44369fc80), UINT64_C(0x083ff114e1e234ec), UINT64_C(0x4a16c8e862e8465c) }}, {{ UINT64_C(0x1599e830b3c3e958), UINT64_C(0x796f5fd4c8d9ca78), UINT64_C(0xf6d90f08e17e01e0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xeb709424db35ea04), UINT64_C(0x57c7729c600e39b0), UINT64_C(0x4a2861648e19f994), UINT64_C(0xb05db2acb49707cc) }}, {{ UINT64_C(0xd9d3dd30306e45ec), UINT64_C(0x4dbaa7542a651800), UINT64_C(0xc5d576c057693f20), UINT64_C(0x4f2517a4bd5e71f8) }}, {{ UINT64_C(0xc5851d4476ee90d8), UINT64_C(0xc14ed8fc5a207808), UINT64_C(0x369e519840f53f38), UINT64_C(0x415eee20fbe5b820) }}, {{ UINT64_C(0x4bf681d414fb090c), UINT64_C(0xd95b975877bd9ccc), UINT64_C(0x32b7313408f14858), UINT64_C(0x300639e42149fb90) }}, {{ UINT64_C(0x67bc1738d78f0b58), UINT64_C(0x81a98058bf63f60c), UINT64_C(0xfa0ebf38c79218f8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8dad392845472210), UINT64_C(0x55a324501ce4d16c), UINT64_C(0x6e26d18018d8b474), UINT64_C(0xbee4049808bfa200) }}, {{ UINT64_C(0x85652384dc4e6114), UINT64_C(0xf4f7758890348b08), UINT64_C(0x7eb153bce817d63c), UINT64_C(0xe39415586884a6a0) }}, {{ UINT64_C(0xd9345fac39ae5b18), UINT64_C(0xd647d4d087aa4764), UINT64_C(0x18887e5007dbc0b0), UINT64_C(0x6a29c940a46cdf50) }}, {{ UINT64_C(0x5ca3adf0569be270), UINT64_C(0x5d64d00493888200), UINT64_C(0xfe60f58ccab96508), UINT64_C(0x9bf9ced0264a463c) }}, {{ UINT64_C(0xc26fc0c0607345fc), UINT64_C(0x7441891838365684), UINT64_C(0x59ec4384b63be5dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x932764b8f64017ec), UINT64_C(0xf8850ef49651a824), UINT64_C(0xc64dc3706388bd38), UINT64_C(0x7e7587786ba2f150) }}, {{ UINT64_C(0x44b86d4427e4a77c), UINT64_C(0xb6db207c1f18bc38), UINT64_C(0xb0b84188026085b8), UINT64_C(0xc5885468f3d09b1c) }}, {{ UINT64_C(0xc1fe100cbd0fa6c4), UINT64_C(0x81f655e82b663948), UINT64_C(0x8fa171f445892ba0), UINT64_C(0x053feb00ed7b7670) }}, {{ UINT64_C(0x712d5d18d4ee8d50), UINT64_C(0x1f1522fc3ebe7d08), UINT64_C(0x89cbbe4cef87938c), UINT64_C(0x4633cc74430a1228) }}, {{ UINT64_C(0x1a70be945547e9d4), UINT64_C(0x8d80d22447999548), UINT64_C(0x3553f9cc54915cb8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x800426b04b894040), UINT64_C(0x2f927170e37bd7c4), UINT64_C(0x0d78ac14b3c94900), UINT64_C(0x299a0a5cbb3f1d34) }}, {{ UINT64_C(0xfbc0aa703faa2360), UINT64_C(0x75b884f030029708), UINT64_C(0x4351f4d4d27c70c8), UINT64_C(0x71876d9ca6910c64) }}, {{ UINT64_C(0xae696478d75575b0), UINT64_C(0x933014f41b062ef8), UINT64_C(0x0dded5005af3cc64), UINT64_C(0xea0d98f4f401e930) }}, {{ UINT64_C(0xfec5e4f4fed82754), UINT64_C(0xbdfc891ccd6ee9d4), UINT64_C(0x5efde410d327ee7c), UINT64_C(0x5be8e224f5526658) }}, {{ UINT64_C(0x7e2aaa9c7bec8514), UINT64_C(0x19fe9e306602a3fc), UINT64_C(0x861728f04867781c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8d1f0f004a50910c), UINT64_C(0xff5a5cc4a890addc), UINT64_C(0x57d68470caa5aa08), UINT64_C(0x4f8c6030d427aea8) }}, {{ UINT64_C(0x2e790604cf9432dc), UINT64_C(0x6ca9991490b17768), UINT64_C(0xbbc183540e659efc), UINT64_C(0x2876a2b05d81e4b8) }}, {{ UINT64_C(0x46e5a5a4b6d04be4), UINT64_C(0x16fd33f826ec85d4), UINT64_C(0x96697c0c2f57a5e8), UINT64_C(0xa2459cc486f14250) }}, {{ UINT64_C(0x0e7856488dda9b7c), UINT64_C(0x888c6008c1fcef5c), UINT64_C(0xa30714744b1f8a58), UINT64_C(0x13618904b4d085bc) }}, {{ UINT64_C(0x52c669a8ccb066dc), UINT64_C(0xf5715cecb9087c28), UINT64_C(0x9f48f434815a5b8c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd5363510192f4220), UINT64_C(0x7e4681e88ee5a598), UINT64_C(0xb9b33e2c89985cf0), UINT64_C(0x4e52940cc3d48334) }}, {{ UINT64_C(0x64643ba0c85fbc40), UINT64_C(0x673c0f78e3327cd4), UINT64_C(0xecf4e36045bf31e4), UINT64_C(0x68769218d5e79d6c) }}, {{ UINT64_C(0x58a0dd3cc991cf90), UINT64_C(0xc335a49028aefea4), UINT64_C(0x3e85973cd891c880), UINT64_C(0xe2e62b201c45605c) }}, {{ UINT64_C(0x16ffa268b0319ca4), UINT64_C(0xb848bca89d4aa4d4), UINT64_C(0xe4e95680e3367b8c), UINT64_C(0xaecfd65cb8f6bb64) }}, {{ UINT64_C(0x493986a8d5f4c8b4), UINT64_C(0x0e5afb004d231eb8), UINT64_C(0xeb9d00c8249d45a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1600b568409e9fb0), UINT64_C(0xb17f244482c642d0), UINT64_C(0x472856f05e5e4b1c), UINT64_C(0x8e7810dc6cab4a50) }}, {{ UINT64_C(0x05a2673c9509bf48), UINT64_C(0x49fe8f4475f97ed8), UINT64_C(0xf7b30b2c75dca10c), UINT64_C(0x4c855adc9ce413d8) }}, {{ UINT64_C(0x01dfa280e45d02d0), UINT64_C(0xbd06277cecded514), UINT64_C(0xd525494c257453b0), UINT64_C(0x7b271508e94118a4) }}, {{ UINT64_C(0xc70af7dc26881718), UINT64_C(0x1c7d4d40d55a1588), UINT64_C(0x646a9e241884929c), UINT64_C(0x0e9030b04bd631cc) }}, {{ UINT64_C(0x567aa86828271784), UINT64_C(0x4931e13cc5864f30), UINT64_C(0x796857e89fe2df50), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x30ae724498353a90), UINT64_C(0x3aef8250a8ccf834), UINT64_C(0xf28e08b8b12abed4), UINT64_C(0x9b751d5c34e17c1c) }}, {{ UINT64_C(0xf4e7e2b886624784), UINT64_C(0xff81f04c75c568cc), UINT64_C(0xa8c35d88b68048c4), UINT64_C(0xf309f85cde2ca980) }}, {{ UINT64_C(0xb1af320455e9e1ac), UINT64_C(0xda06bd806f5116c0), UINT64_C(0xc9afa9540ce8025c), UINT64_C(0xf9e196b0e12a9100) }}, {{ UINT64_C(0x6496a13414f8441c), UINT64_C(0x26aad82cdc4172d0), UINT64_C(0x2a17b91888e3ec38), UINT64_C(0x5c30f67c910104bc) }}, {{ UINT64_C(0xaa4b58b8d4cc00d0), UINT64_C(0x65ec51c4767fc51c), UINT64_C(0xc0d809f0197f1734), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x984d54386c837908), UINT64_C(0x2a9ec804b11f3620), UINT64_C(0x2d11cbd89316de6c), UINT64_C(0x384e1464030713c8) }}, {{ UINT64_C(0xd67f81cc52b87828), UINT64_C(0xf8c024bcd1af242c), UINT64_C(0xdca8a924ae6bb8e4), UINT64_C(0x56896fec738d62f8) }}, {{ UINT64_C(0x593f236471c54974), UINT64_C(0x89f8b6e04161a4f8), UINT64_C(0x43183458d12a6fa4), UINT64_C(0x094a570487ef45a4) }}, {{ UINT64_C(0x134a6d104f3ffd70), UINT64_C(0x6d7ad8c0acbada28), UINT64_C(0xb57a28d09f77e1bc), UINT64_C(0xf570cd54ada68068) }}, {{ UINT64_C(0x78c704443053720c), UINT64_C(0xb46e8728f6db58bc), UINT64_C(0x6b613a5095d277f8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x74b81dc896a5cd8c), UINT64_C(0x599665f8f6d83e20), UINT64_C(0x9aab4970d7d522e8), UINT64_C(0xbac2d3c823c2913c) }}, {{ UINT64_C(0x14e766603d1a9f18), UINT64_C(0xe9f08548f1d80060), UINT64_C(0xf3c4be885fbf2664), UINT64_C(0xcdbdc84411e2419c) }}, {{ UINT64_C(0x1cb8289454149ec8), UINT64_C(0xfbe745f457b11cdc), UINT64_C(0xeb4ef1b85202cb4c), UINT64_C(0x29630eecb67883fc) }}, {{ UINT64_C(0x30eb28b06cbc7470), UINT64_C(0xff5ac5345c2980b4), UINT64_C(0x76813c68e719298c), UINT64_C(0x69b4eb54453720e4) }}, {{ UINT64_C(0x46dc9514b2435630), UINT64_C(0x6538bb1ced164270), UINT64_C(0x1b48b74c9bafb0ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8ebc9de8983b81e8), UINT64_C(0xe31bb2f4bf8958e8), UINT64_C(0x9f3f3df0e3b44308), UINT64_C(0x0ed1f9ecbfa164c8) }}, {{ UINT64_C(0x092e40cc97bf03f0), UINT64_C(0x439c5b2420d88608), UINT64_C(0x60d677185f317a88), UINT64_C(0x0438ae08337b8118) }}, {{ UINT64_C(0x826da2107fa64af0), UINT64_C(0xb422fb2c30665114), UINT64_C(0x817a6bd856dc5654), UINT64_C(0xa13289745ef13520) }}, {{ UINT64_C(0xbce13ea48655bd2c), UINT64_C(0xefccae0062249430), UINT64_C(0xc59421e878c59958), UINT64_C(0x91dd3460e0659f24) }}, {{ UINT64_C(0x9dc9285c4adea4d8), UINT64_C(0x03b59308dd3c8418), UINT64_C(0x7f220820d15d11cc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x043a2d98f8a2ce20), UINT64_C(0x39fed10c3fdd97b0), UINT64_C(0x4f14de48f7fb7b18), UINT64_C(0xd8890aa07d567be0) }}, {{ UINT64_C(0x183267e80d7a03c4), UINT64_C(0x628acbbce4255a60), UINT64_C(0xa244d1b049370b10), UINT64_C(0xcddc817c30bbb0cc) }}, {{ UINT64_C(0xb55f6c48e71c0bb4), UINT64_C(0x0108f1787ec2e8b4), UINT64_C(0x630f66182639f364), UINT64_C(0x34864da4ad0cc760) }}, {{ UINT64_C(0x261e03c082d2a8d4), UINT64_C(0xcf2b258c2d19a1b8), UINT64_C(0xd94116f0938355e4), UINT64_C(0x8086d144d936b400) }}, {{ UINT64_C(0x8955c57449906a78), UINT64_C(0x6d9395ace39508cc), UINT64_C(0x37ae7ac8242bf5f4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5d0cd404f6e9785c), UINT64_C(0x5e5d48b8a731bde4), UINT64_C(0xc0123ed8c4b652c4), UINT64_C(0xf97c9c74a22e7d84) }}, {{ UINT64_C(0x1ade300c9b3a4ec4), UINT64_C(0x72dae8e85cb2f8b8), UINT64_C(0x0869a10ce5197240), UINT64_C(0x0e86f0e8b9ff271c) }}, {{ UINT64_C(0x87c419a0f1b99ea4), UINT64_C(0x9637d474a8769934), UINT64_C(0x6f1c16703d89b004), UINT64_C(0x3c5744bc99f254d4) }}, {{ UINT64_C(0x0543df74d54eec84), UINT64_C(0x6d0726f869add294), UINT64_C(0xba44f3d0eaa86ca8), UINT64_C(0xc0ec5800c6ed7a50) }}, {{ UINT64_C(0x6182ec84472d5f74), UINT64_C(0xe6f56368678460a0), UINT64_C(0xba3e08387c822be0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdc67e6408576eab0), UINT64_C(0x4a975a8c29fab13c), UINT64_C(0xdf1058d07c6ede38), UINT64_C(0xa5b211f4d652f6c4) }}, {{ UINT64_C(0x317650800a9cc76c), UINT64_C(0x275a48aca58d5604), UINT64_C(0xa753dc4434df2820), UINT64_C(0x492abb943369579c) }}, {{ UINT64_C(0xa4b57e207e6a5314), UINT64_C(0x2d89d9380e4799cc), UINT64_C(0xb6c79e5c633d4ec8), UINT64_C(0x1324538474279204) }}, {{ UINT64_C(0x68399f68a6889d74), UINT64_C(0x26a850dc1143b918), UINT64_C(0x1d694f389dfc2ab0), UINT64_C(0x04d67af022620a80) }}, {{ UINT64_C(0x42b8087896bcc3d4), UINT64_C(0x7029b7ac359cfe9c), UINT64_C(0x7e141730d4bc05bc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc807ca740279714c), UINT64_C(0xf56625a811070cb8), UINT64_C(0x2d4804b42620eaf8), UINT64_C(0x0827a19c4dbad93c) }}, {{ UINT64_C(0x6c758b90217595cc), UINT64_C(0xdec5b5b4bec5e964), UINT64_C(0xff714f78227a8e90), UINT64_C(0xcddddb04fdc25f34) }}, {{ UINT64_C(0x284b54147f9a8f3c), UINT64_C(0x36f02b8cc8344110), UINT64_C(0xf55b1534f7692858), UINT64_C(0x9b1f17fc62d867c0) }}, {{ UINT64_C(0x1694c9b4403274bc), UINT64_C(0x432d69280b82000c), UINT64_C(0x392fb6440471ab84), UINT64_C(0x3be803704da4afa0) }}, {{ UINT64_C(0x2a279c74550ce720), UINT64_C(0x31a2121828e3714c), UINT64_C(0xd55c92ecc6906ba4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e861bc859916364), UINT64_C(0x2aea5b345e853e70), UINT64_C(0xe10c8748ae94ba6c), UINT64_C(0xcae0c28430d8f1c4) }}, {{ UINT64_C(0x9d43359426fe9d80), UINT64_C(0x69ec07e8d8509938), UINT64_C(0xf2738644b680f3d0), UINT64_C(0x221616c0a4603694) }}, {{ UINT64_C(0xe74beb00b79b9f90), UINT64_C(0xa641ae5c8ac72018), UINT64_C(0x229d3e607585c370), UINT64_C(0xcab8ce40ef7ff858) }}, {{ UINT64_C(0x99d672189b97f2e8), UINT64_C(0x7deb71544b505e94), UINT64_C(0x97bb7354c6979ad0), UINT64_C(0x7013277c4c11ac74) }}, {{ UINT64_C(0x0ecf5b20bc0375fc), UINT64_C(0x2d3e2c18fa70f450), UINT64_C(0xaa58d24cd138d488), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf3907784715411d0), UINT64_C(0x089279684c8eb644), UINT64_C(0x67774a2cb32ec6f4), UINT64_C(0xf467cdb047018fb0) }}, {{ UINT64_C(0x8e1b0060d1729648), UINT64_C(0x9b3111047ddf6bb8), UINT64_C(0x10c670902bd891fc), UINT64_C(0xd96a81bcc88d43a4) }}, {{ UINT64_C(0x0d3dbe3c88c7b9b4), UINT64_C(0x1e62ada02d139ef8), UINT64_C(0x4ea2790c09ae656c), UINT64_C(0x04794e0412f184c4) }}, {{ UINT64_C(0x10b3241463979590), UINT64_C(0x80a3babc2bac64c4), UINT64_C(0xf4bf7f8041eedff0), UINT64_C(0x8883b40cd390a39c) }}, {{ UINT64_C(0x77e10024a81fc81c), UINT64_C(0x33f990f4cda654a8), UINT64_C(0xc4b13c9c79f67d84), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf3e6fe10ed8339ac), UINT64_C(0x6a3e83b43a4c64c0), UINT64_C(0xdf27d810b90144a4), UINT64_C(0xf6cb99288c51a540) }}, {{ UINT64_C(0x6980b064498830e0), UINT64_C(0x80084f48e08076bc), UINT64_C(0xd31a0a6cdcf45304), UINT64_C(0xc76a44c03fcf7258) }}, {{ UINT64_C(0x7077428ca97b6fbc), UINT64_C(0x0ade6a441d9bb3f8), UINT64_C(0x9620c27c19411838), UINT64_C(0x9a7cec247629a46c) }}, {{ UINT64_C(0x1f0dbd3c47b76c34), UINT64_C(0xebcc1c248321d068), UINT64_C(0xf9ab97440b72d1ec), UINT64_C(0xa6b4292cf09334c8) }}, {{ UINT64_C(0xa206c1ec2bcf5c58), UINT64_C(0xbf47f4d425c41a90), UINT64_C(0xc0285e84705bdec4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x305de9cc671c821c), UINT64_C(0x242a80f8272cfedc), UINT64_C(0x11c9cc980fa262b8), UINT64_C(0xc2ffd4bc6a65b878) }}, {{ UINT64_C(0x84c36b20fb080f14), UINT64_C(0x110c997474ac47b8), UINT64_C(0x5a3dfecc444a8750), UINT64_C(0x0fb0153c92ced598) }}, {{ UINT64_C(0xdfa3a404349959d4), UINT64_C(0x5bed73f812e18868), UINT64_C(0x2beb0e14f865929c), UINT64_C(0xc37834bcd4e2a04c) }}, {{ UINT64_C(0xab23c978ec55462c), UINT64_C(0x9ad879c81b03eb24), UINT64_C(0x6b4ee19cb4a09e68), UINT64_C(0xbf11a274d8a251c0) }}, {{ UINT64_C(0xfa980298e869f6a4), UINT64_C(0xe8a55a2c4fe5166c), UINT64_C(0xd1194f3c3b78d140), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc8d72860838cdfc0), UINT64_C(0x587fe704b3840f2c), UINT64_C(0xc5371be8fa88e248), UINT64_C(0x13aa83249139d698) }}, {{ UINT64_C(0x2c080d44f2563404), UINT64_C(0x80d065086b5a22e8), UINT64_C(0x3a5606f8592ebe4c), UINT64_C(0x99580884c050995c) }}, {{ UINT64_C(0xa4dfa5102cea689c), UINT64_C(0x987535b0ffbc3e1c), UINT64_C(0x7baca26c34d16c3c), UINT64_C(0x418801fc9a82a5a0) }}, {{ UINT64_C(0x1919201c5c9bc858), UINT64_C(0x9f01adac965d1328), UINT64_C(0xfa37708c6cee4f4c), UINT64_C(0xe39ed598f58dc604) }}, {{ UINT64_C(0x96a18bfcd22eb0a4), UINT64_C(0x43ce27108e497338), UINT64_C(0x3aa768b8644b0834), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfc951dd422e46af8), UINT64_C(0xc7e5eb407d319884), UINT64_C(0x266ffc50528b3480), UINT64_C(0x207f587c6f259710) }}, {{ UINT64_C(0xb820e870fa92259c), UINT64_C(0xdf84e07c0f646318), UINT64_C(0xf06d7ec8843d0c7c), UINT64_C(0x49d6c03c416b8550) }}, {{ UINT64_C(0xd99bdcc875ab235c), UINT64_C(0x920d7b54d7717790), UINT64_C(0x0e2c51842ae49994), UINT64_C(0xb7a8dc7c8724b3b0) }}, {{ UINT64_C(0xfcc6c808f7742a0c), UINT64_C(0x55e4445cbccf1bb0), UINT64_C(0x36d481701051b40c), UINT64_C(0xa6a7edb4e1d9ceb8) }}, {{ UINT64_C(0xe420850463e8afcc), UINT64_C(0x0b2ad6a49cb00fb0), UINT64_C(0x1ec887f497645948), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6abe8f788e5bad44), UINT64_C(0x4c39fb087c4bce98), UINT64_C(0x59b8d56c9bbd2648), UINT64_C(0x275c7f0c57de055c) }}, {{ UINT64_C(0x1205f6782f05fc5c), UINT64_C(0xc4be9f2c4c1ebbdc), UINT64_C(0x0a108e60d83e1408), UINT64_C(0x1766a138db155f7c) }}, {{ UINT64_C(0x31a5c7c0e62625e4), UINT64_C(0x4b6a1ef47bc74c64), UINT64_C(0xf99134bcbbe93cf8), UINT64_C(0xa58dc2282a01fc74) }}, {{ UINT64_C(0xa135f9f4fab434ac), UINT64_C(0x9e97a4584ecd2e4c), UINT64_C(0x030d8a6ce395ec24), UINT64_C(0xfdd8e0482c5d18cc) }}, {{ UINT64_C(0xc912693c6f78064c), UINT64_C(0x2dfbed744ff02148), UINT64_C(0x8af80364fd4b3cfc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6f5ba03431dca618), UINT64_C(0x2a846f5435ab7124), UINT64_C(0xab8ce2c4d59a67a0), UINT64_C(0xabc91ac468a1b3d4) }}, {{ UINT64_C(0xd59ec17006ebd8f0), UINT64_C(0xb527c5647cbca7c4), UINT64_C(0x36a364bc0b11f48c), UINT64_C(0x8eafb4bcdea60438) }}, {{ UINT64_C(0xc67eb30849f7bcd8), UINT64_C(0x470a51d453075e68), UINT64_C(0x9e02ef70108095ec), UINT64_C(0xb02ae7a40590ec24) }}, {{ UINT64_C(0x09b50e1083ee4de0), UINT64_C(0x024e229c5aa2b4a4), UINT64_C(0xa81342f0895bee90), UINT64_C(0xe6286c64de3574fc) }}, {{ UINT64_C(0x771feb144a25fb94), UINT64_C(0x3d3769e8d899cb88), UINT64_C(0x134b7f600a1f7530), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7edd0b20a34ccf14), UINT64_C(0x32ae37ec35a692cc), UINT64_C(0xe9be3b745e4b2ea4), UINT64_C(0x80d98f5ca2b2c690) }}, {{ UINT64_C(0xedbf71cc263ff508), UINT64_C(0x065ea1282ac262cc), UINT64_C(0x0af6c3e03c3e1c30), UINT64_C(0x97c1098c354fed70) }}, {{ UINT64_C(0xb76c42f84b906d00), UINT64_C(0x171d7c7c4a776040), UINT64_C(0xce1aa6f4b6e73fb4), UINT64_C(0xb10ef998662673e0) }}, {{ UINT64_C(0x0777f04cb762ab40), UINT64_C(0x2fc3e850c6460b80), UINT64_C(0x57c3db60f3542dc8), UINT64_C(0xd6659dd49bef3bdc) }}, {{ UINT64_C(0x8e5f8f0c9255c6e4), UINT64_C(0x19852da4b266e6bc), UINT64_C(0x09144360e3e78390), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5b991fd0439590e4), UINT64_C(0xf4c876a82d9a552c), UINT64_C(0xda10ac6022c28610), UINT64_C(0x9b85e168bda1dc38) }}, {{ UINT64_C(0xabb0b940436f74c0), UINT64_C(0x9a36f8881d1c8294), UINT64_C(0xa90ec29821a1dec4), UINT64_C(0x11b440447510cbd4) }}, {{ UINT64_C(0xa17caa041d3f13e8), UINT64_C(0x16d14b7cef152fac), UINT64_C(0x3f51dec80a74ce3c), UINT64_C(0x49aa1a90e6ad7218) }}, {{ UINT64_C(0xab6f01a430b5dc54), UINT64_C(0xc2b3422c08b68084), UINT64_C(0xf6260f147c1680d4), UINT64_C(0x6574d0c0225ff7d0) }}, {{ UINT64_C(0x3250186c3868a968), UINT64_C(0x145b39d4e33ba264), UINT64_C(0x1428b45427a95dd8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x27286f5030744660), UINT64_C(0xb76e09608d050de4), UINT64_C(0x0a92484894c12d6c), UINT64_C(0xccd64f5c2a7e51b8) }}, {{ UINT64_C(0xeac66000e7023a20), UINT64_C(0x06ca845869974df8), UINT64_C(0xb6366944ed424f64), UINT64_C(0x844ca3645d43ce98) }}, {{ UINT64_C(0xeb813ebc2d27d248), UINT64_C(0xb7ba534c1244aa78), UINT64_C(0x42040cd8442f4890), UINT64_C(0x672bc9e8734deb14) }}, {{ UINT64_C(0xbbae7b0c1c3f73c0), UINT64_C(0x121220385463c0cc), UINT64_C(0x8ad8805490786278), UINT64_C(0x6917ddfc2389bc64) }}, {{ UINT64_C(0x7ada53604fa303f4), UINT64_C(0x6937478cf9a5aff8), UINT64_C(0xb1f37f8ca361b458), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x20378f7408e2d2f4), UINT64_C(0x01654c04b2dc4c90), UINT64_C(0xe675e3348e407570), UINT64_C(0x0bbf15185c1efefc) }}, {{ UINT64_C(0xb43800f839a883c8), UINT64_C(0xe5e79854ad6ca070), UINT64_C(0x94b7db448131ee2c), UINT64_C(0x3ac78e644e5d30b4) }}, {{ UINT64_C(0xc6085ecc55c48288), UINT64_C(0xeac9acb8a2bc7248), UINT64_C(0x80fc33649fbf0b38), UINT64_C(0xefaf90a092c275d4) }}, {{ UINT64_C(0x1d7a1f10769cb324), UINT64_C(0x38f9c76c58c8c94c), UINT64_C(0xdecde05cdf7ae09c), UINT64_C(0xb4131e44e84b23bc) }}, {{ UINT64_C(0x36cbeb60ed09da50), UINT64_C(0x3e2b3fa4e3032a98), UINT64_C(0x3fb59a18968f0c8c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb3808bd889a31758), UINT64_C(0xd4275bf45b3c5420), UINT64_C(0xff4dc88c772f4bcc), UINT64_C(0xc86a29688c5ef554) }}, {{ UINT64_C(0x3238158c2e9619a8), UINT64_C(0x7019efd46f159e80), UINT64_C(0x75227d30187cbeb8), UINT64_C(0xc36dcf74d4326224) }}, {{ UINT64_C(0x322ee068cd1be980), UINT64_C(0x6db03104bee70840), UINT64_C(0xb7d1d10cbb02cc94), UINT64_C(0xf68a620889427d64) }}, {{ UINT64_C(0xcd471a001af443ec), UINT64_C(0x54335dc891b485dc), UINT64_C(0x8b94b6185cd06f04), UINT64_C(0x1629b0dc39f8e72c) }}, {{ UINT64_C(0x208fbdecc4bfe828), UINT64_C(0x1451647c4274a3c4), UINT64_C(0x896f3250d5362d38), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8a3d472c46fb68a8), UINT64_C(0x684a1de4af6c01d0), UINT64_C(0xb67df144ce1f4b20), UINT64_C(0x3d21021472e81030) }}, {{ UINT64_C(0x4ae29d647d254920), UINT64_C(0x26f9b6ecbe498fb8), UINT64_C(0x8c74d4002d20365c), UINT64_C(0xa4df3a608527b978) }}, {{ UINT64_C(0xd16636548441ec74), UINT64_C(0x8cb07a103ff3ba78), UINT64_C(0xf4bd3f8c2fab9744), UINT64_C(0x405933444b6f62d0) }}, {{ UINT64_C(0xd0315f60703df8d0), UINT64_C(0xc691b884ee1e2aa8), UINT64_C(0x36caffcc9479cf44), UINT64_C(0xb5c75094748da344) }}, {{ UINT64_C(0xa73e82306f575388), UINT64_C(0x175b78e020483298), UINT64_C(0x1f31743c4f8d5e6c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb86ffbdc92b884d4), UINT64_C(0x9a32ad342d7ea890), UINT64_C(0x2ea0c1e0597181a0), UINT64_C(0x96d20d9c74e1b9e8) }}, {{ UINT64_C(0xf3e80ddc81ec95c4), UINT64_C(0xf253b8180b862bd8), UINT64_C(0x6aa5673893fdc11c), UINT64_C(0xec95b0acb48b68d4) }}, {{ UINT64_C(0xe057a568dbadd088), UINT64_C(0xbe1225b0089849a0), UINT64_C(0x0544e43085d74834), UINT64_C(0xc81f7268fb339d4c) }}, {{ UINT64_C(0x690cab10496205d8), UINT64_C(0x948b2ab804456850), UINT64_C(0x591c26bc5a1d52d4), UINT64_C(0x85740cdcc7f7c108) }}, {{ UINT64_C(0xdf19dc4c4b240680), UINT64_C(0xadbc55384f9218d0), UINT64_C(0xbd5e0d7c338e539c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xef62fd2ce721a230), UINT64_C(0x815bb7cc90baa568), UINT64_C(0xcc91199427375958), UINT64_C(0x762553a447a3e4d8) }}, {{ UINT64_C(0xd0dfae1c3744ba98), UINT64_C(0xdba502902389bef8), UINT64_C(0xcc56584833fd296c), UINT64_C(0x22e82bb463f08528) }}, {{ UINT64_C(0x0113351c66157a20), UINT64_C(0x65f984c4bf0502c0), UINT64_C(0x63ca54288a4752d0), UINT64_C(0x8efdec3035316340) }}, {{ UINT64_C(0x8999d4d006d7c0d4), UINT64_C(0xceaa94a4fec883c4), UINT64_C(0xabbd915c05ee6e70), UINT64_C(0xf8375950b148a138) }}, {{ UINT64_C(0x24bcd824b8765128), UINT64_C(0xb46e4a906dcb309c), UINT64_C(0xd79a00a8d28ead84), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x970159d0247bcf68), UINT64_C(0x31176a84dfe61bb4), UINT64_C(0x6b173c807dd5fa8c), UINT64_C(0xdac04860f471f7dc) }}, {{ UINT64_C(0x8852360075e4b7c4), UINT64_C(0xae3092fc56415050), UINT64_C(0x42b19f0424486d84), UINT64_C(0x66d57630706bff18) }}, {{ UINT64_C(0x82833d745a2bbd5c), UINT64_C(0x21083ca81c55a820), UINT64_C(0x95454744f13f7784), UINT64_C(0xb13b6a40b590b118) }}, {{ UINT64_C(0xf5beb9a05f6e5a04), UINT64_C(0xe5d65258466bc508), UINT64_C(0x9e14328493490e78), UINT64_C(0xa69457d08e84fa10) }}, {{ UINT64_C(0xdbd1f588a5e846c8), UINT64_C(0xc171f96432caa428), UINT64_C(0x25236c5c69edd230), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf79f9474ef90d2b8), UINT64_C(0xa7ba83946dea4a84), UINT64_C(0x00fbd5e488b7a494), UINT64_C(0x8a22cff8293958e4) }}, {{ UINT64_C(0xd59e2b28e57b63fc), UINT64_C(0x038994ec47f49c14), UINT64_C(0x5b71a9b0181bbe70), UINT64_C(0x9ac041b0c010383c) }}, {{ UINT64_C(0xf83e5d90cdffb718), UINT64_C(0xd079844caa1ed538), UINT64_C(0x27f03a0cc91f0e94), UINT64_C(0xb6d74f241a307a48) }}, {{ UINT64_C(0xa95a860862c990bc), UINT64_C(0x0870db204f025d0c), UINT64_C(0x27e8cad0312fae40), UINT64_C(0x1f29a39408be166c) }}, {{ UINT64_C(0x5b8b7bb4549681d8), UINT64_C(0xcaec53a0c487b178), UINT64_C(0x4b69080c4dfaea90), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x331f8b48fdd06b50), UINT64_C(0x335926c08d35409c), UINT64_C(0x43c756a894f50664), UINT64_C(0x3200b6342f3fbda4) }}, {{ UINT64_C(0xa175e628e9f93cf8), UINT64_C(0xf96d8de0f32530c8), UINT64_C(0xe44826b020a97804), UINT64_C(0x6d84a14860182f30) }}, {{ UINT64_C(0x15b4b62ce319e118), UINT64_C(0xb21278d0ff311764), UINT64_C(0x30b2766027863e48), UINT64_C(0xfd29253c112a34b4) }}, {{ UINT64_C(0xddc87e0493e109c0), UINT64_C(0x8b37bb64488b6e64), UINT64_C(0x409aad48a98994e4), UINT64_C(0xed92deec19c28abc) }}, {{ UINT64_C(0x9304201cf21219dc), UINT64_C(0x7927e6042bdcd9c0), UINT64_C(0x481f595494503c84), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb13a1f1ce75606d4), UINT64_C(0x471fc8f40f2071f4), UINT64_C(0x72453fd4839c5114), UINT64_C(0xfd05578863cc40ec) }}, {{ UINT64_C(0x0bb3084ca397bd84), UINT64_C(0x78f5627431a89f9c), UINT64_C(0x674b808c82ff45c8), UINT64_C(0x362fd40cb3125bf8) }}, {{ UINT64_C(0xc633dbc09f3dba0c), UINT64_C(0xdc65d570f86aea68), UINT64_C(0x2a79212cb14fa3bc), UINT64_C(0xd9b4f068b80b9fcc) }}, {{ UINT64_C(0xcb842794e0574a18), UINT64_C(0x077c1590f04d4248), UINT64_C(0x06bf0aac67186bbc), UINT64_C(0x4d5ee5486ea32038) }}, {{ UINT64_C(0xcd976e1ca439f590), UINT64_C(0xb8cad4001912c738), UINT64_C(0xfc8994d4594b1bc4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8c8f6830a014426c), UINT64_C(0x867e4af4589a6eb4), UINT64_C(0x41d791301e4960c8), UINT64_C(0xa2f0681cb9eae4e8) }}, {{ UINT64_C(0x42cdb9fcea137478), UINT64_C(0x5a6b9dd0b9280014), UINT64_C(0x08c502b054a34d68), UINT64_C(0xbf3e4658c7e96c2c) }}, {{ UINT64_C(0x86588b7404d058b0), UINT64_C(0xa55a61e0e738b1ec), UINT64_C(0x85622c6817e250a8), UINT64_C(0x97d47668b996d5d0) }}, {{ UINT64_C(0x512c6840957f40c4), UINT64_C(0x0258e4bc7a7529cc), UINT64_C(0xe5b6d7348719240c), UINT64_C(0xcd0f47ccccb40e34) }}, {{ UINT64_C(0x79c9dfa81c84cd4c), UINT64_C(0x853424801f748b0c), UINT64_C(0xa1ea325c384c55d4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb167640bc2e61ec), UINT64_C(0x55de81904cde76ec), UINT64_C(0x34c73ac4e93aab04), UINT64_C(0x8aa67bdc09317a1c) }}, {{ UINT64_C(0xb44f59340a46c3c4), UINT64_C(0x287c019833f4e470), UINT64_C(0xfbb31438fe7606e4), UINT64_C(0x4b41159468b98244) }}, {{ UINT64_C(0x59da9e785e7ea204), UINT64_C(0xbe314ee0cbb45e58), UINT64_C(0xc6f25a10ab05e26c), UINT64_C(0x92a938dc386efe90) }}, {{ UINT64_C(0x426a722023f46f60), UINT64_C(0xc48f99e4486f8cc0), UINT64_C(0x884fbaccbaeed820), UINT64_C(0xea1007b042555ee8) }}, {{ UINT64_C(0x317431a85603cbec), UINT64_C(0xf00246d0246c0728), UINT64_C(0xce0fd33c11b6adc4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5966e3f0cbaf621c), UINT64_C(0xfb8d1ea87938fb98), UINT64_C(0x4f24d45043e9776c), UINT64_C(0x663487f4dfb82d08) }}, {{ UINT64_C(0x28870408cd717988), UINT64_C(0x6e75f7d80ebbbb94), UINT64_C(0xb98250904c015b04), UINT64_C(0x5660b06033076d8c) }}, {{ UINT64_C(0x3a55062ca18be9e8), UINT64_C(0x8a901a244c7c6020), UINT64_C(0x8f931e542daf3048), UINT64_C(0x247b36b8b9b4d6a4) }}, {{ UINT64_C(0x0a0ce98432999ee8), UINT64_C(0x152ff008c0d46a24), UINT64_C(0x5328ae5c2c2e95d0), UINT64_C(0xc3bd83f8694f8688) }}, {{ UINT64_C(0x0d8cea84377d4974), UINT64_C(0xf6e88fc8440afc60), UINT64_C(0x81ed46e0b3fcb5a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x51eaf5e423140a1c), UINT64_C(0xac7b8c049b925d1c), UINT64_C(0x76a030148a8758bc), UINT64_C(0xf44d1738d0c1c6e0) }}, {{ UINT64_C(0xe37db8646a3edd8c), UINT64_C(0xca2614545a0c505c), UINT64_C(0x5a18b9f4ee58f59c), UINT64_C(0x88e08398817809f8) }}, {{ UINT64_C(0x19f8430497616f20), UINT64_C(0xe58ab78866e79bb4), UINT64_C(0x827168082e7bf0ac), UINT64_C(0x5ae6cdccca0902dc) }}, {{ UINT64_C(0x0f84bde0da918cf4), UINT64_C(0x0e0d8a9c566b1c68), UINT64_C(0x189e7a50bf293418), UINT64_C(0xa469478066debe68) }}, {{ UINT64_C(0xe2d41b0cfa48cfe0), UINT64_C(0x516917c0246c4cac), UINT64_C(0x78a6f36c77abbf38), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6c70128c557d8300), UINT64_C(0x431996c06e818ba0), UINT64_C(0xa58ab25802e48634), UINT64_C(0x88114c9865975d00) }}, {{ UINT64_C(0x141b9b3c060d7244), UINT64_C(0x780ddd60ed4b14f4), UINT64_C(0x237e5244637c2474), UINT64_C(0x381bb060dcfe14c4) }}, {{ UINT64_C(0xb14cd6e437843660), UINT64_C(0xad1062b4aca13838), UINT64_C(0xeb7bd6004830f320), UINT64_C(0x73e34660bcdc33e4) }}, {{ UINT64_C(0x3bd4c620f27e7bd8), UINT64_C(0x75ac0d3cf4ddee20), UINT64_C(0x44fd60987ba07954), UINT64_C(0xf02bcadc2d829234) }}, {{ UINT64_C(0xe5487ff008f9fc30), UINT64_C(0x664bd37839daee30), UINT64_C(0x8439cf80f0a3c93c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e1e0174c75e7468), UINT64_C(0xd1f798d47e6d86b0), UINT64_C(0x68d206684e632288), UINT64_C(0xd30b62d4c3dbf91c) }}, {{ UINT64_C(0x3fef7c1026dc9dbc), UINT64_C(0xd3f25028c693220c), UINT64_C(0x7972b258a9ded17c), UINT64_C(0xa96ec0e4757d7a48) }}, {{ UINT64_C(0x60025b3cc82207b4), UINT64_C(0x526603585d354138), UINT64_C(0x31a0d4b022dd6e7c), UINT64_C(0xc9434c38d77b7b94) }}, {{ UINT64_C(0x0fb277dcaa7419a4), UINT64_C(0x1e83c75c7fe70f4c), UINT64_C(0x5c626c74f03d0ae0), UINT64_C(0x43058a7ce5347890) }}, {{ UINT64_C(0xcd7dace874b74b6c), UINT64_C(0xeedec6f8db02e870), UINT64_C(0xeb5dc178ea5820e4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x143635c049d2cf58), UINT64_C(0x15d5a19caa149b18), UINT64_C(0xfe2e02b8d78d3058), UINT64_C(0x37e53b6c9b63f468) }}, {{ UINT64_C(0xcb470a94a2541ae8), UINT64_C(0x0d444e68eeec8674), UINT64_C(0xcb13ef107fef6d40), UINT64_C(0x32c999d0c998c4f0) }}, {{ UINT64_C(0x039ba3d80a80059c), UINT64_C(0x352c3410748a9cd4), UINT64_C(0x9cdd47583310b818), UINT64_C(0x0105d458908b118c) }}, {{ UINT64_C(0x42dce06c23b741ac), UINT64_C(0x656885043aac1108), UINT64_C(0x82b8942465c516d8), UINT64_C(0x46203840cdc7e83c) }}, {{ UINT64_C(0x29b6bb28ee1cd8a8), UINT64_C(0x18ed249ce898a3c4), UINT64_C(0xd1d72dc4c5511894), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x48e96ec41cf57a68), UINT64_C(0xcbe497489b0226e0), UINT64_C(0x3dd87380ad708fec), UINT64_C(0xc122ec8817da8530) }}, {{ UINT64_C(0x714c8478ed9b1978), UINT64_C(0x793ccfccee2a17dc), UINT64_C(0x43217e9c136f6b9c), UINT64_C(0x4578fa803f469060) }}, {{ UINT64_C(0xecf22764fc03857c), UINT64_C(0xfd008e4cb7ab2200), UINT64_C(0x9ed86c90666b96f0), UINT64_C(0xd73616d887b9d99c) }}, {{ UINT64_C(0x87cb9ca846738c48), UINT64_C(0xdce7d5fc36a58954), UINT64_C(0xa76b4750cf15ef3c), UINT64_C(0x9c20b80cabb5e318) }}, {{ UINT64_C(0xaa2ee560b2f27820), UINT64_C(0x748d21c8665b4178), UINT64_C(0x0a0f255062521204), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71939de037ed0a44), UINT64_C(0x21ed886459bd8e9c), UINT64_C(0xcbd885bc8edc5cc8), UINT64_C(0x5abc56b47685eefc) }}, {{ UINT64_C(0x57c3491c2cbee130), UINT64_C(0x93c3e9643399d088), UINT64_C(0x19724678c00019f8), UINT64_C(0x72202454226fb21c) }}, {{ UINT64_C(0xe803b8dc1b7e567c), UINT64_C(0xeb889dfca2978658), UINT64_C(0xed55e158925486b4), UINT64_C(0x8d7675f4854a1244) }}, {{ UINT64_C(0xf106c3d0ecf13d08), UINT64_C(0xd176d070f5de7768), UINT64_C(0x247599ac5d0d509c), UINT64_C(0x0167bc0c13a04ab8) }}, {{ UINT64_C(0xd3299770c48cb654), UINT64_C(0xd5d4d9ec4750a408), UINT64_C(0x02c0bb4c01834e4c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x70d6ab1c84c08378), UINT64_C(0x96919934346e9090), UINT64_C(0x2db29e8c491a66b4), UINT64_C(0x2f2b9d6898d4ad3c) }}, {{ UINT64_C(0x20d0f7501cf955a8), UINT64_C(0xf6221f78cc1775ec), UINT64_C(0x23da75f44153bf1c), UINT64_C(0x06555988bd7f8c50) }}, {{ UINT64_C(0xa4e7fe440ef96834), UINT64_C(0x760d01a82e0a22a0), UINT64_C(0x60785c5cf9403760), UINT64_C(0xf0eaf9a0581870a8) }}, {{ UINT64_C(0xd2c489a4f6f3aefc), UINT64_C(0x065f90b8585ad07c), UINT64_C(0x5f7a0730ef347cf8), UINT64_C(0xafe8de84efb374e0) }}, {{ UINT64_C(0xcf7bf66c0c99d1dc), UINT64_C(0x0096e2ec3775d8e8), UINT64_C(0x996f34c4d642a758), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x17679a30573fad84), UINT64_C(0xe84c3838791facc0), UINT64_C(0x11da2a8c9a1e7f90), UINT64_C(0xd3759ad8baac538c) }}, {{ UINT64_C(0x4b7b7e7458f930ac), UINT64_C(0x13b874009c7ed2d0), UINT64_C(0xf23c0d08ce1e5300), UINT64_C(0xaa9c07b0165b7abc) }}, {{ UINT64_C(0xfbf8f91cdb6e565c), UINT64_C(0x1397235ca91a9998), UINT64_C(0xfa6c6ebcbff31e08), UINT64_C(0xe88f2c30ac9b98e8) }}, {{ UINT64_C(0x6e464e584943ac84), UINT64_C(0x349fc3dcefb2ec00), UINT64_C(0x4021f0c874edcb54), UINT64_C(0x297da1a8f4aad884) }}, {{ UINT64_C(0x82b1f43c002ce6c8), UINT64_C(0xd9b854f8768ef384), UINT64_C(0x3708441cc065c790), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8e370aac580158ec), UINT64_C(0x3f296d18a2e89484), UINT64_C(0xda9575d47abf1e18), UINT64_C(0xca7cf290690cbe20) }}, {{ UINT64_C(0x859406a49a6dcfe4), UINT64_C(0xc9785c289762ead8), UINT64_C(0xaa590548a3488500), UINT64_C(0x441f001096e7b384) }}, {{ UINT64_C(0x973b180c663c9300), UINT64_C(0x9530db68ef25a8c4), UINT64_C(0x24cca0e4566f469c), UINT64_C(0x112748d00a986628) }}, {{ UINT64_C(0x0ca3be7026019e04), UINT64_C(0x18ea1c549a02250c), UINT64_C(0xcff1acac9b4fd4c8), UINT64_C(0xd402171026ba99e0) }}, {{ UINT64_C(0x38f46434449c00cc), UINT64_C(0x19f08e88c0f96d70), UINT64_C(0x425579e86bfaef88), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x28b4bd74509fc9b0), UINT64_C(0xf9238994dbde3d0c), UINT64_C(0x187b08a8c2d3ef50), UINT64_C(0x8ca4f144ad0f7aa8) }}, {{ UINT64_C(0x87720d34989ae710), UINT64_C(0x7a7ac1ac5b421d88), UINT64_C(0x689f99ac2f8554e4), UINT64_C(0xff2405cc15c79e18) }}, {{ UINT64_C(0xf37eb900f97a8408), UINT64_C(0xeb91d018a2e28c1c), UINT64_C(0xdcba82f48f265e80), UINT64_C(0x2664a8a459d53410) }}, {{ UINT64_C(0x2d810cac13c80184), UINT64_C(0x8a8a415c90a988ec), UINT64_C(0xe2635a18d38718c0), UINT64_C(0x51b8b6905cc5ab0c) }}, {{ UINT64_C(0x11cf6a68bc951124), UINT64_C(0x8255b61ce1419464), UINT64_C(0x8ee5b5281dab959c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x860c25683e0823e0), UINT64_C(0x5c567ea48402a4e0), UINT64_C(0xd7400700319b97e4), UINT64_C(0xaac5797c2a0ddd90) }}, {{ UINT64_C(0x94edda40b4250b54), UINT64_C(0xe9441f84fbc7aa14), UINT64_C(0x4f181430af0edeb8), UINT64_C(0xa7a6e3f4b5c1860c) }}, {{ UINT64_C(0xd3c7d9c411118324), UINT64_C(0x9ace1f18075131b8), UINT64_C(0x7b034254afae9e94), UINT64_C(0x2c0478a0446cb624) }}, {{ UINT64_C(0x73da20cce9ebf664), UINT64_C(0xe4ad354056bbb43c), UINT64_C(0xadf034a88d2256b0), UINT64_C(0x9454bf40d35f8450) }}, {{ UINT64_C(0x13fa080427a622d8), UINT64_C(0x819354e05717bfa8), UINT64_C(0x4a3cee68370f8df0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe535b4a8f59ded04), UINT64_C(0x64f3bf746e8acd50), UINT64_C(0xf6b86d18be9a220c), UINT64_C(0x0f1f8f10af9bed4c) }}, {{ UINT64_C(0xc420622012ac0f84), UINT64_C(0x7f1b123c228eb250), UINT64_C(0xf08cd2987c52d520), UINT64_C(0x8ef5162c751a1c20) }}, {{ UINT64_C(0xe2434e6c69449e14), UINT64_C(0xa5ca276049a6d060), UINT64_C(0xa12b961ce75671d0), UINT64_C(0x9ace32c014e30c98) }}, {{ UINT64_C(0x3d6e277057343ba0), UINT64_C(0x6e9aee80b8c21cb4), UINT64_C(0x4c23a300cbe71564), UINT64_C(0x7db0f3e0a8804030) }}, {{ UINT64_C(0xd6b849d0be3e2f58), UINT64_C(0xbb3ce74807671c54), UINT64_C(0x46a397c0cccbe658), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd34d716c9220b314), UINT64_C(0x072657f0f3969b6c), UINT64_C(0x4d61eb50f834bec0), UINT64_C(0x2581bce0d69de984) }}, {{ UINT64_C(0xe69257f4429606b0), UINT64_C(0xb8adea6c8a962188), UINT64_C(0x57b5a27c8500efc0), UINT64_C(0x609a2c70f957b0c0) }}, {{ UINT64_C(0xfa5f5548d2857ca4), UINT64_C(0x11f6ffd4a4fb6678), UINT64_C(0xbe3fbd88d210dce0), UINT64_C(0xa0d7a52011551e60) }}, {{ UINT64_C(0x97cf41a4e6b77d24), UINT64_C(0x97b7a378dd177b84), UINT64_C(0x1d1de7948bf9c5b0), UINT64_C(0x31152268022d9798) }}, {{ UINT64_C(0xedad5d64ad707768), UINT64_C(0xd99c2440bdba1dd4), UINT64_C(0x31faeac845beb8a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd2ba68389ae7d70c), UINT64_C(0x64f1b9b09f90a004), UINT64_C(0xc710040400108f74), UINT64_C(0xb8284824cce5c21c) }}, {{ UINT64_C(0x023260a805b6c16c), UINT64_C(0xb37b1950042d7dec), UINT64_C(0xf2ba9f58c5deccfc), UINT64_C(0xdb314d3c99999418) }}, {{ UINT64_C(0x274e2e140c0b231c), UINT64_C(0x4ef5609473d8ba4c), UINT64_C(0x38c9bea0352a7574), UINT64_C(0x9ae57e00b3ae2c30) }}, {{ UINT64_C(0x42aace24c7296b54), UINT64_C(0x172604b441a05530), UINT64_C(0xa3fb2aa8154aa600), UINT64_C(0x9a45b844628a5dc0) }}, {{ UINT64_C(0x3a7db13ccc6f8c14), UINT64_C(0x760e6698427bd810), UINT64_C(0xebcdf98073b87d80), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x71c44050b32f4f30), UINT64_C(0x2cb479a840903984), UINT64_C(0x89a710c449c8d480), UINT64_C(0x04a6949889e8b618) }}, {{ UINT64_C(0xd422da3ca5693ccc), UINT64_C(0x06f26324fdd41940), UINT64_C(0x937de9004a5d65dc), UINT64_C(0xac667a9809fd05c8) }}, {{ UINT64_C(0x93862f1c35084ce0), UINT64_C(0x281fbf7c7109d4e4), UINT64_C(0x3d612c0058bd7884), UINT64_C(0x507bb7ac2ea6a038) }}, {{ UINT64_C(0x50336a8c684cb3e8), UINT64_C(0xbd6e917ce75de858), UINT64_C(0x1aa83558e6321c30), UINT64_C(0x396ff89cbc1327d4) }}, {{ UINT64_C(0x62fe9a0c3aac3e38), UINT64_C(0x270b4c34f345f35c), UINT64_C(0xa11f18246a300bd4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaac91bd0fd1eca74), UINT64_C(0x2769aa2cd23ebb48), UINT64_C(0x38e6b7c4937b7220), UINT64_C(0x000271f051f1110c) }}, {{ UINT64_C(0x1d07d18432cb3530), UINT64_C(0x7f71887c450dbb28), UINT64_C(0x9d009f84c772320c), UINT64_C(0xe2a8330856efd440) }}, {{ UINT64_C(0xef93cb004b61c528), UINT64_C(0xf037322454798e9c), UINT64_C(0x7f18386c2c338dc8), UINT64_C(0x10b80c54f1643b18) }}, {{ UINT64_C(0x1b36640cc20660c8), UINT64_C(0xaf1281a000c47580), UINT64_C(0xad5d0c60161669b4), UINT64_C(0xc0d127bc40e1b574) }}, {{ UINT64_C(0xcbd2c3accbb8e5bc), UINT64_C(0xf5959164a22f4918), UINT64_C(0xe86714d484a502f8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x50f5b290d3cf5650), UINT64_C(0xc170c764067155ec), UINT64_C(0x088e609429941304), UINT64_C(0xd3bf2e489d3ca4e0) }}, {{ UINT64_C(0xc5275d9828964db4), UINT64_C(0xe8f6e09874b8a740), UINT64_C(0x362eb6f0573bbe74), UINT64_C(0xd1e6ee44f8c76640) }}, {{ UINT64_C(0x4975c7d432e5276c), UINT64_C(0xfecdb31859637e60), UINT64_C(0xa61b890488b9cbbc), UINT64_C(0xa49cbe8ca05dbc08) }}, {{ UINT64_C(0x6a4442c89fe0ae04), UINT64_C(0xe511da5897f6b77c), UINT64_C(0x0d925d1447c4391c), UINT64_C(0xe863aa900ba3e14c) }}, {{ UINT64_C(0xc9c52c6ca9f3e410), UINT64_C(0x5923d30499f10e10), UINT64_C(0x44e2a60c5db3620c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x29c85f84725fa2dc), UINT64_C(0x43cfc2582a3c8dc8), UINT64_C(0x9d2e3f8cbc2fe4cc), UINT64_C(0xf6b60e549747a870) }}, {{ UINT64_C(0x2cc33c18f22d10c8), UINT64_C(0xf06d368819204d74), UINT64_C(0xcf17450cf22a66e8), UINT64_C(0xa4b8ad8c91164794) }}, {{ UINT64_C(0xf3cf30505c478b10), UINT64_C(0xca7765882132cc40), UINT64_C(0xaf7fd71040396a44), UINT64_C(0xa0111d90cc8eaf84) }}, {{ UINT64_C(0x03d30870970d26d8), UINT64_C(0x79fffc44e80d1884), UINT64_C(0xd10bdb904467bb68), UINT64_C(0xd3e5fa3cff0fee2c) }}, {{ UINT64_C(0x899fd96427f2ad80), UINT64_C(0xd44c8a08d82d0810), UINT64_C(0x157450dcdb5b1180), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x178fe1d03cea8060), UINT64_C(0xb9440a508450b5f0), UINT64_C(0x7a6f2ff8aafeb16c), UINT64_C(0x315a29a855eb0e64) }}, {{ UINT64_C(0x1d3d7be0314f3e60), UINT64_C(0xea41af64d467096c), UINT64_C(0xa7574f2ca4efdee8), UINT64_C(0x809a90e03fa858f0) }}, {{ UINT64_C(0x65510db0cdc75b2c), UINT64_C(0x6a354eb4e334efd8), UINT64_C(0xf3f484989c3fad50), UINT64_C(0x8332e3387d6ed008) }}, {{ UINT64_C(0xf0273cb4497527d4), UINT64_C(0x44a529386870fed8), UINT64_C(0x099ab760aacb3ab0), UINT64_C(0x1837f12c93d9fb08) }}, {{ UINT64_C(0x272ea47c7c1d9cfc), UINT64_C(0x49df60c847858398), UINT64_C(0x5d87b924c465816c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f8f3318cc84fe50), UINT64_C(0xed8125a46c8245f0), UINT64_C(0x6cfe4a088bd4f864), UINT64_C(0x44b8f22467a25308) }}, {{ UINT64_C(0xb417acd45e698da8), UINT64_C(0x71d828fcc8f8c638), UINT64_C(0x09c51abce16ecfc0), UINT64_C(0xa1adfb789fcdbf2c) }}, {{ UINT64_C(0x046857c86e269938), UINT64_C(0x11549f440d8b4274), UINT64_C(0x831d58a4d9328e2c), UINT64_C(0xdec434ec14c753c0) }}, {{ UINT64_C(0x2e23bb6003a60254), UINT64_C(0xe99cb6f4bf8aa42c), UINT64_C(0xab50fc10471a60c4), UINT64_C(0xdaed5984fb9ec4d0) }}, {{ UINT64_C(0x45304398c8a741e4), UINT64_C(0xacf4cf687c5f9b28), UINT64_C(0xd2c5b62cecc03d88), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x302406108a38e4f4), UINT64_C(0x62de7ce0e916d764), UINT64_C(0xa7b356742e80a134), UINT64_C(0x00ca1d147d8c4820) }}, {{ UINT64_C(0x751e81484636b480), UINT64_C(0x347aebe81ec059a4), UINT64_C(0x6222dc2cc7f021c8), UINT64_C(0xaf4a171083f99284) }}, {{ UINT64_C(0xbb6445a899c24338), UINT64_C(0x885b45b45f6046b0), UINT64_C(0x4909542c519d042c), UINT64_C(0x0548a9c04f247f08) }}, {{ UINT64_C(0xfcafb32881cc52b4), UINT64_C(0x707a27809bd48dec), UINT64_C(0x6ef550e0ab5cbd24), UINT64_C(0x25b4c2a8c86e41e4) }}, {{ UINT64_C(0x7f6fef588ed9520c), UINT64_C(0x43ffe0dc42f6fa7c), UINT64_C(0x651fb6a8c2f9f6a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4703efe03f8f5640), UINT64_C(0x014de4f8ad88d410), UINT64_C(0x607a8f1866712bd8), UINT64_C(0xfc847484089a0cc0) }}, {{ UINT64_C(0xf39f6d8c1be9c430), UINT64_C(0x605d7354c723488c), UINT64_C(0x4e41fc9c4f97b0a4), UINT64_C(0x72c2a834e9edc054) }}, {{ UINT64_C(0x13676e30572a4850), UINT64_C(0x2cafb9343ea48b6c), UINT64_C(0x1e2e97c06445cd98), UINT64_C(0xd700340c6c1a98e8) }}, {{ UINT64_C(0x32f1d9d814d8ed78), UINT64_C(0x68551c9ce0a5eec4), UINT64_C(0x3a161e7031acdcc0), UINT64_C(0xdfde10b0d8033458) }}, {{ UINT64_C(0xc4887a941916e3e8), UINT64_C(0x2969eaa421dc9b40), UINT64_C(0x90ef1c78be6a58b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x33cb8488094f4dbc), UINT64_C(0x7c9a79581ca6f840), UINT64_C(0x8d453b2ca76c61bc), UINT64_C(0xf79dd2bc2ce8175c) }}, {{ UINT64_C(0xd20d7fa8baa2c90c), UINT64_C(0x8ec131ecc7775260), UINT64_C(0xa2f5c9c0a291847c), UINT64_C(0x82ed007cd2ae3ce4) }}, {{ UINT64_C(0x569a36b41eb007ec), UINT64_C(0x8edbc04808b46cd0), UINT64_C(0xf4ba5da4dc618700), UINT64_C(0xd01cff1078e38110) }}, {{ UINT64_C(0xfea1040034476dec), UINT64_C(0x6c1d0d48311f9d7c), UINT64_C(0xb088a8709a706f1c), UINT64_C(0x1479f930a25efb70) }}, {{ UINT64_C(0x795c785c0fc81e30), UINT64_C(0xd26bc440152692ac), UINT64_C(0xd3aa12104bf1cd50), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8dbb17d002ad3bc0), UINT64_C(0x693d2468cfe23b08), UINT64_C(0x6e15528869ba5b8c), UINT64_C(0xb3e85714c25f0cec) }}, {{ UINT64_C(0x8168f3409de842ac), UINT64_C(0x523f3b803eaa8ab0), UINT64_C(0x42323500966d4038), UINT64_C(0xbf52cb441ade0828) }}, {{ UINT64_C(0x5f385504f92e8740), UINT64_C(0x580d12f881dead30), UINT64_C(0xfe8acb3cf7cd17ec), UINT64_C(0xf50266f8105df2ec) }}, {{ UINT64_C(0x42f753bceefdbecc), UINT64_C(0x3a69f4c8bae1b220), UINT64_C(0xa60e1478cc2f9050), UINT64_C(0xf15e70142b6babf0) }}, {{ UINT64_C(0x0166adbc2ea8043c), UINT64_C(0x60a78ea0e7dce568), UINT64_C(0x8d19c57c2e4e1f18), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1082a778c2656388), UINT64_C(0x3bd379b4eeb0c550), UINT64_C(0xf68bd69cac1a3d38), UINT64_C(0x0b00bcb81408b378) }}, {{ UINT64_C(0x13c1b90454da47cc), UINT64_C(0xca612d088558091c), UINT64_C(0x906aff44337c0f90), UINT64_C(0xa7ef8b18fac65af0) }}, {{ UINT64_C(0x8263cbd4dd7ce39c), UINT64_C(0x5cb7a0f82526efd0), UINT64_C(0x24b6e7ec7315a024), UINT64_C(0x42dbbbc800328fb4) }}, {{ UINT64_C(0xba5e967c774e1a10), UINT64_C(0x3dc6305cfe80df5c), UINT64_C(0xd5e349646def5c2c), UINT64_C(0x875c87f8bb81029c) }}, {{ UINT64_C(0xe8942aecd070e904), UINT64_C(0x9200f3201d359f84), UINT64_C(0xe60fb890d0830cc0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdc92cd086f8d3a20), UINT64_C(0x80351b64a8d9edc8), UINT64_C(0xaa47af0429343b38), UINT64_C(0xc9594d34f98550a8) }}, {{ UINT64_C(0x4b91b4fc9be05b30), UINT64_C(0x7f1f7ddc60123e74), UINT64_C(0x63a5de90d6163cb0), UINT64_C(0xe3bf275893be5528) }}, {{ UINT64_C(0x99c221dc49753180), UINT64_C(0x33277d008f4357c8), UINT64_C(0x804c0dccfb89db20), UINT64_C(0x114c8b6c0c794dc0) }}, {{ UINT64_C(0x13db9514322c5f24), UINT64_C(0x7f787af459383470), UINT64_C(0x561c48b04bd43cc8), UINT64_C(0x8468ce88e4330a34) }}, {{ UINT64_C(0x853070d44901cfbc), UINT64_C(0x2eb82180a75f7ee0), UINT64_C(0x03a47048dd91d338), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x64d4713c2d01e5e8), UINT64_C(0x17c5678446223770), UINT64_C(0xd54cc3ec38823b08), UINT64_C(0xe91391a8ad7023b0) }}, {{ UINT64_C(0x86f7ba44f27c91b0), UINT64_C(0x8e464f44d188b604), UINT64_C(0x8c5c0a44ad034d38), UINT64_C(0xe2001d14d30b7bcc) }}, {{ UINT64_C(0xb055606ca19c08d8), UINT64_C(0x7cccfdecadab7a88), UINT64_C(0xa365c840f23ef114), UINT64_C(0xd0237070b04f9354) }}, {{ UINT64_C(0xb6ade8c0f384388c), UINT64_C(0x1cbcc184f87f8b40), UINT64_C(0x97404534478950a4), UINT64_C(0x53b9c4d0e76a2414) }}, {{ UINT64_C(0x1e957e784b4b33a8), UINT64_C(0x51b10684a36f9398), UINT64_C(0x019a64e430ea0eec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x09bdbc0430fc41e8), UINT64_C(0x93e748002ba36afc), UINT64_C(0xcfcdc5d490ae5740), UINT64_C(0x37ae4bf491eb12c4) }}, {{ UINT64_C(0x035001e8b1e1dc04), UINT64_C(0xa8cc0028547e9be0), UINT64_C(0xced7dae0116dc278), UINT64_C(0xd69f5cf0fd68d858) }}, {{ UINT64_C(0xd684e3c0e46763c8), UINT64_C(0x9174faac1b62a4d8), UINT64_C(0x382c35ecdca86764), UINT64_C(0x28bad9542d292a18) }}, {{ UINT64_C(0x1cf2a450a6c37c54), UINT64_C(0x899624f48cc8fba4), UINT64_C(0xa7e2880c4b71e780), UINT64_C(0x84b9757c47f4b6a4) }}, {{ UINT64_C(0x858fa204ac03d698), UINT64_C(0xc3482410d56b66a4), UINT64_C(0x2431a7a42895e890), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x79a0950ccab6e76c), UINT64_C(0x7e91e6fc9f6a45f8), UINT64_C(0x1e178f60ac66e6ac), UINT64_C(0x25870aa01a597488) }}, {{ UINT64_C(0x1e7972ec3fa523b4), UINT64_C(0xdb99344088a37ba0), UINT64_C(0xef91429caeb74e98), UINT64_C(0x758d8588920b589c) }}, {{ UINT64_C(0x3498fd0892d7ac08), UINT64_C(0x3039eb2498ceadd8), UINT64_C(0x21a2ad6ca9c97c3c), UINT64_C(0x2f9a221ccc30a288) }}, {{ UINT64_C(0x2b02dd905b0b9188), UINT64_C(0x7ff9f53c1fa5ecb0), UINT64_C(0x5feb25705b9a4abc), UINT64_C(0x197a12cc7de1143c) }}, {{ UINT64_C(0xfab613b8f6c7ab64), UINT64_C(0xa7e85068ddf64e34), UINT64_C(0xa89b3464f2284750), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x97193ffcb7803594), UINT64_C(0x95cfb88cd95d6b5c), UINT64_C(0x19b9050cc10fcd90), UINT64_C(0x9ab0fee43dc91ff8) }}, {{ UINT64_C(0x09f788e42c0d8950), UINT64_C(0x824167f09d234c0c), UINT64_C(0x3ab5a9e431d298fc), UINT64_C(0xf59272e85627e4ec) }}, {{ UINT64_C(0x07beff4ce9dd4810), UINT64_C(0xfd24b0b07794d184), UINT64_C(0xea1c0d9099dcafe0), UINT64_C(0x2c4e33d4caf4feb0) }}, {{ UINT64_C(0x5e0361d829519f54), UINT64_C(0xeed488c01b5b195c), UINT64_C(0x8f1eb680097ea1e4), UINT64_C(0x5ad6ff6406511ec8) }}, {{ UINT64_C(0xdfc3568067614d60), UINT64_C(0xd8a3ca8c7892b378), UINT64_C(0xb5b036285d0bc9ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0d177120b5acd084), UINT64_C(0xb02a791c49c8ae20), UINT64_C(0x18184dd462b9d3bc), UINT64_C(0x38242878ba1c1dac) }}, {{ UINT64_C(0xbc217584105fea10), UINT64_C(0x38abdd6cd2143e0c), UINT64_C(0xff22f7848c9987b4), UINT64_C(0x1af70b0020e3ccd0) }}, {{ UINT64_C(0xae40f36c8e7dbcb0), UINT64_C(0x53198904748e4494), UINT64_C(0x9c58d97c54e723ac), UINT64_C(0x09e457e83ca24908) }}, {{ UINT64_C(0xcf580c5ca3cdba18), UINT64_C(0xe4741ab0e3f0c5c8), UINT64_C(0x1c9cc90c9ce1950c), UINT64_C(0x5596d1581624881c) }}, {{ UINT64_C(0x1c808a1c446dccdc), UINT64_C(0x1820b63020884d4c), UINT64_C(0x8e1008f8161a0994), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x16c6c234aa02d520), UINT64_C(0x9a7613805c0decfc), UINT64_C(0x52ba43a8b59f7984), UINT64_C(0xbf4f485c029d49f4) }}, {{ UINT64_C(0x3e60f090518d0990), UINT64_C(0x5ee27b48c5c3649c), UINT64_C(0x65ea4cb0c552a41c), UINT64_C(0x1d3d38740230b204) }}, {{ UINT64_C(0x468b8570147fde40), UINT64_C(0x05f83db4ee18ed5c), UINT64_C(0xd4c9009ce15714e4), UINT64_C(0xae7e631cfa7ebb74) }}, {{ UINT64_C(0x3a4e6e74128dadd4), UINT64_C(0x311a8384282d7a18), UINT64_C(0x218a55245185bff8), UINT64_C(0xc11bfa6ca9581e98) }}, {{ UINT64_C(0x370b89887ab752bc), UINT64_C(0x34d25bf06ffe5700), UINT64_C(0x174c7b844322ad00), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x065778dc2f474210), UINT64_C(0x13ed1f58126cc5b0), UINT64_C(0xd94c4c7c78760e98), UINT64_C(0xbec16a501d035ca0) }}, {{ UINT64_C(0xab5b0540b4c5fd68), UINT64_C(0xc59d7e0039dcc808), UINT64_C(0x1a455a90514968d8), UINT64_C(0x5604f14050d0bb40) }}, {{ UINT64_C(0x88635c80a8f86228), UINT64_C(0x6deaae4445253754), UINT64_C(0x0d03c0c8f00867b0), UINT64_C(0xd5d26018a7a475c4) }}, {{ UINT64_C(0x2009b87c1b963c78), UINT64_C(0xcf579494a94e596c), UINT64_C(0x4f7953f4d3459e48), UINT64_C(0x675eaaf429bb8008) }}, {{ UINT64_C(0xa2eb48e0cb66fbcc), UINT64_C(0xdbee297c27bc54fc), UINT64_C(0x126259742d9be1a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9ff04c30c1fcfa8c), UINT64_C(0x8cc54ccc7eedceac), UINT64_C(0x782c3bcc8e332bd8), UINT64_C(0xdb17b4c4508084f4) }}, {{ UINT64_C(0x72bef8a498810a20), UINT64_C(0x7e061d7084b8fd30), UINT64_C(0x3d831b6c74667cfc), UINT64_C(0x2325c9c480565c80) }}, {{ UINT64_C(0x2451cd7826d67740), UINT64_C(0x87a6d660cd9efbbc), UINT64_C(0xa6db8b40ef5467f4), UINT64_C(0x5efb1dfcb7a9ebf0) }}, {{ UINT64_C(0x7d7835e831b50838), UINT64_C(0xda1cc604f711a2b8), UINT64_C(0x660e8bacf7311434), UINT64_C(0x06bf1e2c8e92f848) }}, {{ UINT64_C(0x54e3e8487a4cd9b4), UINT64_C(0xc69280a490704ce4), UINT64_C(0x9aee65842a2c7734), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x90aa9f4cb6394d9c), UINT64_C(0x4d6152c439747ff4), UINT64_C(0xb0e1fb9c9809a690), UINT64_C(0xb81511f4dfb2f5f0) }}, {{ UINT64_C(0xde3a64cc9f8e1e78), UINT64_C(0x60fceca4fb33cde0), UINT64_C(0x49af0518eb2cf29c), UINT64_C(0x6bea7b1054d685ec) }}, {{ UINT64_C(0xd2d44d4cac264478), UINT64_C(0x710d0924751414a0), UINT64_C(0x04f06954d46a954c), UINT64_C(0x9d80f7ec141f6adc) }}, {{ UINT64_C(0x7a3aea44329578bc), UINT64_C(0xa75e5c88ced015dc), UINT64_C(0x361ecfe014a34200), UINT64_C(0x9946cee04d5d92cc) }}, {{ UINT64_C(0xed0343b0fdf8a7cc), UINT64_C(0x8bb5905c629fc0a4), UINT64_C(0xa3252ba035fd0160), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x92f57b7080816fec), UINT64_C(0x19d6f0e4b9316cd4), UINT64_C(0x4025c5fcdeda0cbc), UINT64_C(0xe7b5ea88fbbc342c) }}, {{ UINT64_C(0x176600d44902be94), UINT64_C(0x9fcfbac4e9f14260), UINT64_C(0xdefb6cdc5245b738), UINT64_C(0x8d4ad188be5d6804) }}, {{ UINT64_C(0x9498391c8388d5ac), UINT64_C(0xf31719d4543b96a0), UINT64_C(0xb282bb1416f0ad20), UINT64_C(0x8c00b86495a0fe50) }}, {{ UINT64_C(0x8aa0efb0faed5148), UINT64_C(0x0dd24fc09c356220), UINT64_C(0x42ffc1d04406bccc), UINT64_C(0xace774ac15eeec00) }}, {{ UINT64_C(0x1fb853881f61a568), UINT64_C(0x87c8120827cb18f4), UINT64_C(0x626999acff8af5d8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb8afaf583fbd7058), UINT64_C(0x78d77e203767a258), UINT64_C(0xf942c9acb605b610), UINT64_C(0x08d6110401e3b4bc) }}, {{ UINT64_C(0xb2dda7d817149024), UINT64_C(0x0535562c75e51a24), UINT64_C(0x0385fd3c6c09213c), UINT64_C(0xac499e5055e9d558) }}, {{ UINT64_C(0xeb7bc65c713f14d8), UINT64_C(0x87bd8780d6b2ac70), UINT64_C(0x599ddc94d0e5f560), UINT64_C(0x67e739541a366fc0) }}, {{ UINT64_C(0xcc8b8810bbae73c4), UINT64_C(0x93e230e8ffe70a48), UINT64_C(0xb5230c0c768e7d98), UINT64_C(0x96e38d90e569112c) }}, {{ UINT64_C(0x643b5b74b4d0af8c), UINT64_C(0x339cc5b87317aa30), UINT64_C(0xbb3b4500ecb3a5e0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2775245c23f30ae8), UINT64_C(0x2477aa749a5265f8), UINT64_C(0x52f467e0098794ec), UINT64_C(0x0c384f40edbfcca4) }}, {{ UINT64_C(0x35fd26c8db016130), UINT64_C(0x904d945824e28cc4), UINT64_C(0xdc3ab64482f85cb8), UINT64_C(0x7d114f38aca40550) }}, {{ UINT64_C(0xae680e4c0e1f0f74), UINT64_C(0x0e002b887237e6c8), UINT64_C(0x080abad0a93117b0), UINT64_C(0x102a9fe0f79b7fbc) }}, {{ UINT64_C(0x75c956a8922b2d30), UINT64_C(0xb7883da02619a3ec), UINT64_C(0xe33f4e20f9e0b288), UINT64_C(0xd4e7d04828efc5c8) }}, {{ UINT64_C(0x84006c38c0e0b90c), UINT64_C(0x125bec341ba79750), UINT64_C(0xdaeffb241364d6a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1526277881c25644), UINT64_C(0xabdf42e4c0f5a610), UINT64_C(0x05dbc5948dc01270), UINT64_C(0x502e27c47b042938) }}, {{ UINT64_C(0x8d61c238b8a7050c), UINT64_C(0xf0ded9b0dd207480), UINT64_C(0xc3d0d110c331eea0), UINT64_C(0x9f4afbac1fe77a20) }}, {{ UINT64_C(0x3760e7a43fea8524), UINT64_C(0x29d65be82a124e98), UINT64_C(0xb2dfe72489a587b8), UINT64_C(0xa5fc6c64bdad43b0) }}, {{ UINT64_C(0xd9327568091c61f4), UINT64_C(0x538493285644e060), UINT64_C(0xeacc144c0a2b6f84), UINT64_C(0x61fe32a401bf8f4c) }}, {{ UINT64_C(0x47ebc31ce3f00740), UINT64_C(0x14889ccc4ee45dec), UINT64_C(0x42a34984bbf7b6ac), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x22bf69645683bed4), UINT64_C(0x08ff44b4c9e4b0c8), UINT64_C(0x65c123fc4e4a0700), UINT64_C(0x8bdb48940337d66c) }}, {{ UINT64_C(0x9ae51e34749f4edc), UINT64_C(0xf6b80208189ffcd8), UINT64_C(0xd9d791b4c5ba8434), UINT64_C(0x85e990bce4252668) }}, {{ UINT64_C(0x6a4a042c337eb724), UINT64_C(0x19908f08b61f50e4), UINT64_C(0x5dfe6a042bc9d8f4), UINT64_C(0xcae62a388b6ec58c) }}, {{ UINT64_C(0x9ca4d5bc4a758490), UINT64_C(0x2334e734e3456c40), UINT64_C(0x554cd53899ee8204), UINT64_C(0x96007768ed53f180) }}, {{ UINT64_C(0xd009620c678206b0), UINT64_C(0x9d09d818b3c11618), UINT64_C(0xbb8680b493cc73ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x70a812f8311b0020), UINT64_C(0x8a8b0c9020dd23f4), UINT64_C(0x852f767823ec7ca4), UINT64_C(0x1b2c2ef4a48171b8) }}, {{ UINT64_C(0xb332808c41d15644), UINT64_C(0xfd6b72883bc09f00), UINT64_C(0x874121986c3ad800), UINT64_C(0xe10985c0ceb64054) }}, {{ UINT64_C(0xe913e5c05a4872e0), UINT64_C(0xb586bc2865c6ff54), UINT64_C(0xc3b460f007e0ba58), UINT64_C(0xa2fa694cef143550) }}, {{ UINT64_C(0xba2b06a45b546920), UINT64_C(0x862f8a647ed52cd4), UINT64_C(0x1da137dc72b19f78), UINT64_C(0xc24d40309ebbdce4) }}, {{ UINT64_C(0xc8d05650ea46dfcc), UINT64_C(0x4b703dac234eab24), UINT64_C(0x364ce5a069caf154), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc443e7e8e8ff5d78), UINT64_C(0x196434c429b22590), UINT64_C(0x2c7533c84cf45818), UINT64_C(0x680bf70cf5573b10) }}, {{ UINT64_C(0x67bd23e476955eb0), UINT64_C(0x5a3703744e77aaa8), UINT64_C(0xc0082c204f31318c), UINT64_C(0x6f95ea54acf7084c) }}, {{ UINT64_C(0x1292ce482ca46fa8), UINT64_C(0x5377d0c84b7013b4), UINT64_C(0x3880200890aca1a0), UINT64_C(0x43ccdf48c12f91bc) }}, {{ UINT64_C(0x46010958aeabf64c), UINT64_C(0xb3157b70fb361410), UINT64_C(0x0b94fc70171bd4f8), UINT64_C(0xd1cda410cf4b1424) }}, {{ UINT64_C(0x1a725d4888d9f37c), UINT64_C(0x87dc787495fcde08), UINT64_C(0x0638c7543e0b5054), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xac581acc9859a740), UINT64_C(0xcee7e364226ecca0), UINT64_C(0x9c6ea52cbafbf030), UINT64_C(0x54a79b88e47a0458) }}, {{ UINT64_C(0x76b56f64fc785ca4), UINT64_C(0xd126af24ab3b5ba0), UINT64_C(0xc9bc04f46edc2824), UINT64_C(0xa6a180d0ca8f5900) }}, {{ UINT64_C(0x9b80d4ac7bc53d20), UINT64_C(0x2213fca816f6c630), UINT64_C(0xca2d80a065b70438), UINT64_C(0x31228630f01fef6c) }}, {{ UINT64_C(0xf39e29201168a3d8), UINT64_C(0x0cdf903436ebae9c), UINT64_C(0x4725d3d442122fd0), UINT64_C(0x4991eb98df95aab0) }}, {{ UINT64_C(0x3fc2b93c7b7176b8), UINT64_C(0xef9822580a6c0f70), UINT64_C(0xd0a16e8ccd3d9028), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x17878d3c94703ef8), UINT64_C(0xcf78a760c9eee254), UINT64_C(0x22b9f9c41c0105d0), UINT64_C(0xb0344ee0db6fcfcc) }}, {{ UINT64_C(0x5917d374217fd224), UINT64_C(0x880848ec92afd768), UINT64_C(0x50d89be07e9ba124), UINT64_C(0xf9b186e469c5d17c) }}, {{ UINT64_C(0x8a20f1a8c04110d4), UINT64_C(0x684ed6081a165524), UINT64_C(0xac25ad5481159304), UINT64_C(0x92080c7062e125cc) }}, {{ UINT64_C(0xf4102c84e7cf36c8), UINT64_C(0xf0640e84ef7c6220), UINT64_C(0x3d402444f4c45e38), UINT64_C(0xd02a5d8080db8780) }}, {{ UINT64_C(0x269aa8501cbdd2b4), UINT64_C(0x8b49ba9cb67a6798), UINT64_C(0xd4646c20bca06570), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3247c928981fe87c), UINT64_C(0xd158f35ce63a23dc), UINT64_C(0xb4bcb5107904b5ec), UINT64_C(0x59dd32840a5faf6c) }}, {{ UINT64_C(0x71d006940e4814e4), UINT64_C(0xaec185b87776cbbc), UINT64_C(0xd491bbc4002c3dc4), UINT64_C(0x45b4df705381be88) }}, {{ UINT64_C(0x8284bb405b517ca0), UINT64_C(0x34286920a00dea78), UINT64_C(0xfd9153d4e645f24c), UINT64_C(0x0770458879ba65c0) }}, {{ UINT64_C(0x38e00240a9270aa4), UINT64_C(0x0ff5ac983b1e4c5c), UINT64_C(0x5eea1dfc94d481d0), UINT64_C(0x8a2056705660c160) }}, {{ UINT64_C(0x1415195c5be8c974), UINT64_C(0x8ab5e6e4310399c4), UINT64_C(0x710dca681bf3f538), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x77d297409849297c), UINT64_C(0x3354408403160680), UINT64_C(0x93fde82801ee4944), UINT64_C(0x81af96d4f568c578) }}, {{ UINT64_C(0x4e3f5f3806c1ec84), UINT64_C(0x3c5e57945b88c2b0), UINT64_C(0x27d3321400efe0cc), UINT64_C(0xe471292497398de4) }}, {{ UINT64_C(0x73581c98559f69fc), UINT64_C(0x3fa93310a8b27a28), UINT64_C(0xb0e9cfa48d34640c), UINT64_C(0x276f4f04e9897130) }}, {{ UINT64_C(0x42a8d2c4d95e0c9c), UINT64_C(0xa5690bfcafde4e10), UINT64_C(0xf78ea688619f1a14), UINT64_C(0x5ffd443cf283dcc0) }}, {{ UINT64_C(0x20faa4fc481fb6d4), UINT64_C(0xa947c4947bbb8170), UINT64_C(0xaaa648d079b9ae18), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x334cc4e0680d6874), UINT64_C(0x7e51778ce10a9274), UINT64_C(0x5c00dbc807838570), UINT64_C(0x7dfbb9049119a4d0) }}, {{ UINT64_C(0x867aafec2f24a564), UINT64_C(0x542bbc0487482040), UINT64_C(0x204de28c9ea095e8), UINT64_C(0xb46c03c8a3d1334c) }}, {{ UINT64_C(0x86214044b409449c), UINT64_C(0x0d8ec824a42c55ac), UINT64_C(0x61c50bc0495548ec), UINT64_C(0x65c5d228d8ea58b8) }}, {{ UINT64_C(0xf86988787afd2ccc), UINT64_C(0x4b5a00d8ace0443c), UINT64_C(0x65e07794ec1d6fb4), UINT64_C(0x50a10c046bfad11c) }}, {{ UINT64_C(0xebf919dcdaefc838), UINT64_C(0x7e81239cb5ca5428), UINT64_C(0x28202460b955593c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x016000a050468890), UINT64_C(0xf3fe9270c852b388), UINT64_C(0xbf8c817090f89220), UINT64_C(0x9e2ff91c75bb8ab4) }}, {{ UINT64_C(0x8f8dcb10b558d428), UINT64_C(0x07efcc880463b6d8), UINT64_C(0x7d195d3c62014700), UINT64_C(0x02e42620e5e08db0) }}, {{ UINT64_C(0xf701025c01af3b80), UINT64_C(0xcef6a740336da3e4), UINT64_C(0xb29cb99c37736984), UINT64_C(0xda9845081b2439a4) }}, {{ UINT64_C(0x94a816606da50644), UINT64_C(0x9c19ae6c4da94a80), UINT64_C(0x009f9804df696cbc), UINT64_C(0xf23b451cdd1b4cf0) }}, {{ UINT64_C(0x170ca3540a4f3740), UINT64_C(0x08624ec49a760a94), UINT64_C(0x06854b2cc7b7fda8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x420772ec087b2774), UINT64_C(0xfa4311e807823e98), UINT64_C(0x1c806348b65acbb4), UINT64_C(0xe21848ac92a97650) }}, {{ UINT64_C(0x58a06e60f8be9128), UINT64_C(0xd150caa4ebc75b3c), UINT64_C(0xa0b707a47d8ea19c), UINT64_C(0x2a0620a45efa67d0) }}, {{ UINT64_C(0x9d058010230c51cc), UINT64_C(0x9debfdc803bf1b7c), UINT64_C(0xdce87e2097ac97d0), UINT64_C(0xb0e5fe50cebafa94) }}, {{ UINT64_C(0x107662f8befdc120), UINT64_C(0x053349cccf22097c), UINT64_C(0x34ee1fb0253e92c0), UINT64_C(0x3cab23d0cc8561d0) }}, {{ UINT64_C(0xfaa8e85850238df4), UINT64_C(0x63f42bfc027a0958), UINT64_C(0xa23512a4304dc04c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa9d72db8c9bee428), UINT64_C(0x4a929014f23291c0), UINT64_C(0x89bc3bc069045604), UINT64_C(0x22431ddc72abc32c) }}, {{ UINT64_C(0x9a21db90249b1744), UINT64_C(0xad91aa0080e0b0f0), UINT64_C(0xee3f12bc1ed0ede0), UINT64_C(0x8179c8e483817a64) }}, {{ UINT64_C(0x6aa89d04df646ecc), UINT64_C(0x901bc7243d427c68), UINT64_C(0x7dd90c44aed6cdf4), UINT64_C(0xa3537184b9f057ec) }}, {{ UINT64_C(0x91b6495c1045968c), UINT64_C(0x9fb2c42c09dd5960), UINT64_C(0xe172fcc03f9fbe84), UINT64_C(0xa94ba188e9864f20) }}, {{ UINT64_C(0xfce626a0c90cb3e0), UINT64_C(0x5902f8043e6febc0), UINT64_C(0x0c6ff1d0f1ce03dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe728e3ecd43fabec), UINT64_C(0x90b5145cd045c044), UINT64_C(0x0bd5616807673cf8), UINT64_C(0xeb0f3e48e9147c84) }}, {{ UINT64_C(0xb0f65970f1133b08), UINT64_C(0x6b2772140edfdf38), UINT64_C(0x6fe0905480967928), UINT64_C(0xa9aa80804343b774) }}, {{ UINT64_C(0x777f40049f22068c), UINT64_C(0x0e9c77b81e9364c0), UINT64_C(0x1c4f38ace70408f0), UINT64_C(0x84495be0698511c8) }}, {{ UINT64_C(0xe3a927a8e666049c), UINT64_C(0x85beadf4fa478bb0), UINT64_C(0x8f05570089f8a8ec), UINT64_C(0x3ceee4dcca565b14) }}, {{ UINT64_C(0x83d85bd4fd0be358), UINT64_C(0xc59ced0c49dc27e0), UINT64_C(0xc366aa647337f1a0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdabefae8469c2db4), UINT64_C(0xd255b84c991abf2c), UINT64_C(0xae219e30ff7c1188), UINT64_C(0xe3d3a5709af29fd8) }}, {{ UINT64_C(0xaf76a96cee75e544), UINT64_C(0x1059d20439dcfba0), UINT64_C(0x5d84b058df32d134), UINT64_C(0x4f49a9d8996c287c) }}, {{ UINT64_C(0xe5ac3ebceaef4734), UINT64_C(0xce24029038ce7858), UINT64_C(0xb2702978d189a9a0), UINT64_C(0xf13743381c7b3d10) }}, {{ UINT64_C(0x702f403c4d6495d0), UINT64_C(0xce0bdf30455014a8), UINT64_C(0x9987c4a80714a380), UINT64_C(0x924afa006f4f771c) }}, {{ UINT64_C(0xdeeeca0c053ed83c), UINT64_C(0xe754f4009910834c), UINT64_C(0x339967187c246370), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4d648ca0e29758ac), UINT64_C(0x4f5d9198d988480c), UINT64_C(0xac762cd0c55d90d0), UINT64_C(0x2de16a48b5691bd4) }}, {{ UINT64_C(0x678a036c47018580), UINT64_C(0x9de059402d71dc68), UINT64_C(0xb2829c445fc80da0), UINT64_C(0x324a154022152464) }}, {{ UINT64_C(0xf2a67a7c8ef081fc), UINT64_C(0x374fed781a6201d8), UINT64_C(0x39c197c4015e1c80), UINT64_C(0x8c038a50cba914dc) }}, {{ UINT64_C(0xfd3096d873b68b9c), UINT64_C(0x44f23c3c1d1d4458), UINT64_C(0xf42d779ca5059ed0), UINT64_C(0xd75c73e00a1b74ac) }}, {{ UINT64_C(0x0351b484d81a8680), UINT64_C(0x300680d06f04a2a0), UINT64_C(0xbba627d0a4f5a940), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1f5759bc275f449c), UINT64_C(0x397396cc58847128), UINT64_C(0x9984f2c08cce49ac), UINT64_C(0x46bd0f84c1866514) }}, {{ UINT64_C(0xd1c0502cdde8663c), UINT64_C(0x528ea6904d705380), UINT64_C(0x8e8308b80accd070), UINT64_C(0xda9672d462448914) }}, {{ UINT64_C(0x8e6c31a0cc681124), UINT64_C(0x6b771554e01d00fc), UINT64_C(0xd3745bb88a085148), UINT64_C(0xcb6354049053c03c) }}, {{ UINT64_C(0x59d2c054e1514624), UINT64_C(0xdda1047494b7d790), UINT64_C(0xc398ac685e6661fc), UINT64_C(0x6d90c1ec1367d3dc) }}, {{ UINT64_C(0x69ec8ff4fa8100b8), UINT64_C(0x74e53db895365864), UINT64_C(0x58eb2940fa0c62b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe62deab06806fabc), UINT64_C(0x128c5d24b81905c8), UINT64_C(0x21a0cac0ac915a30), UINT64_C(0x7d2becb82226c5e8) }}, {{ UINT64_C(0x531a5f5096eb9554), UINT64_C(0x9d15c3341bf392c0), UINT64_C(0x7d4ddd207d55a840), UINT64_C(0x3e43930821b06fa0) }}, {{ UINT64_C(0xfa2f6d68ab8e19b8), UINT64_C(0xb513aa9440fd6578), UINT64_C(0x18cf7f14b575532c), UINT64_C(0xcf399e582129b8c4) }}, {{ UINT64_C(0x29d1a64c4e3ea3a4), UINT64_C(0x783efb80df5a1400), UINT64_C(0xdaf211d4aa69bfd8), UINT64_C(0xfdc29034242d7dc8) }}, {{ UINT64_C(0xb6a21c146f482c3c), UINT64_C(0xad5c7f4841f9af50), UINT64_C(0x4eccf15880586530), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x807dcca8ffd215f0), UINT64_C(0xd7c45b84dc551b0c), UINT64_C(0xbce5d2bc6b73d130), UINT64_C(0xd32e5c508b1abd28) }}, {{ UINT64_C(0x8675e64034781b14), UINT64_C(0xc638f3b46e9b2b0c), UINT64_C(0xedd7470ce2eda588), UINT64_C(0xf455a4e838a994d8) }}, {{ UINT64_C(0xd268ca10ea4309ec), UINT64_C(0xa26bf4d4f4e04bb8), UINT64_C(0x023969a045e36f58), UINT64_C(0x21255958d6bda1e4) }}, {{ UINT64_C(0xa11017f47d20c2c8), UINT64_C(0x413a9d104ad45fc8), UINT64_C(0x9762d3bcc46b63fc), UINT64_C(0x4cc8682081c45fdc) }}, {{ UINT64_C(0xe966ab109dd49734), UINT64_C(0x82e99d40d1e2dc68), UINT64_C(0xfd983a54aac0d7e8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8e158c187274aef0), UINT64_C(0x829b0cd40d4be148), UINT64_C(0x2c60f6f0b464c384), UINT64_C(0xcc7527ccd5e589dc) }}, {{ UINT64_C(0xf0579db4a20211f0), UINT64_C(0x5b6376acd64a41f4), UINT64_C(0xd1b8f6e029cd0aa8), UINT64_C(0xf468d3b8474ece6c) }}, {{ UINT64_C(0x2e1f8f441ce90c80), UINT64_C(0x6ff80354b7f17578), UINT64_C(0x27f01830dc0e3c0c), UINT64_C(0x01009cdc0be63e6c) }}, {{ UINT64_C(0x94a3c01c3cb8fe94), UINT64_C(0x632bd8b82243e388), UINT64_C(0x05b13998efaeb028), UINT64_C(0xad1885e0af689858) }}, {{ UINT64_C(0x5ec783301600d918), UINT64_C(0x4a94fd0c263b2158), UINT64_C(0x014672101234a744), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbde0cb3c320a94f8), UINT64_C(0x95b766f8254c7f70), UINT64_C(0x360c21c0e73b7700), UINT64_C(0xbedafed4ea72cae4) }}, {{ UINT64_C(0xcbcb045c2e203750), UINT64_C(0xdcd0123cbc2f7080), UINT64_C(0x058413c0bef29778), UINT64_C(0x380a5c549475388c) }}, {{ UINT64_C(0xfaacb78c782a3cdc), UINT64_C(0x48b773ac451bb7d0), UINT64_C(0x442440505c0a9510), UINT64_C(0x4d7056c4520ec1e0) }}, {{ UINT64_C(0xb5a2f29c1e9a9430), UINT64_C(0x3d1ee6302ffafa30), UINT64_C(0xb036efec7bae1cec), UINT64_C(0x657a0148cbec4118) }}, {{ UINT64_C(0xaa06dc0c64987064), UINT64_C(0x703ec24430e99db0), UINT64_C(0x04814378529a2d88), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcb081b1084c08f74), UINT64_C(0xc7b7e148b5bbf6fc), UINT64_C(0xfa625f38a4aac780), UINT64_C(0x6fc5100090bfddac) }}, {{ UINT64_C(0x85d38d40806526b0), UINT64_C(0xdabd6048d1387874), UINT64_C(0x3fd48a2889aff9e4), UINT64_C(0x313302f4f0adb510) }}, {{ UINT64_C(0x884cb3e8cb304328), UINT64_C(0x9822d1d4093b916c), UINT64_C(0xf2ce0878801bf8f8), UINT64_C(0xc2c5be4c5de8dcac) }}, {{ UINT64_C(0x0ceec5083a9f118c), UINT64_C(0x1c4c740051218ce8), UINT64_C(0x85ea8690655155f0), UINT64_C(0xff467074c4e85d10) }}, {{ UINT64_C(0x695860785b9806c0), UINT64_C(0x9c09cd7815a6faa4), UINT64_C(0x5435a3886c148fc8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe4c66bc82d9a71fc), UINT64_C(0x66e4ce483e388bbc), UINT64_C(0x8427bc5cf96545c0), UINT64_C(0x599dd7541a486724) }}, {{ UINT64_C(0xf1ca47f0b03483f0), UINT64_C(0x723ca35ccfa7c524), UINT64_C(0xf12459a006834d9c), UINT64_C(0x419db7d8fc4efc28) }}, {{ UINT64_C(0x1bd7f7786c4a8bb8), UINT64_C(0xe25e5cb0017a2a10), UINT64_C(0xf4c93894e3d96cf8), UINT64_C(0x4743eac8b01c3a68) }}, {{ UINT64_C(0x36b45f000bab9288), UINT64_C(0x99ee9f08e86d4954), UINT64_C(0x7845195c7077a8fc), UINT64_C(0xdf0cef50791b92d0) }}, {{ UINT64_C(0x9366226027f25bd4), UINT64_C(0x6638e3cc18630ee0), UINT64_C(0x5cef9dc01c7016f0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x426e76ac0058e8f0), UINT64_C(0x601353500164f1e0), UINT64_C(0x0bcd5b48d0329a74), UINT64_C(0x987cbce0d8de939c) }}, {{ UINT64_C(0xa2bdffac2e25d1b0), UINT64_C(0x321aa6d8cf325274), UINT64_C(0xb2a57e90fb552664), UINT64_C(0x271eeb78bbb1523c) }}, {{ UINT64_C(0xf1acb044fd79005c), UINT64_C(0x1e561e0cbba7851c), UINT64_C(0xa8a69f2cc03d37b0), UINT64_C(0xc99bcef83e37e714) }}, {{ UINT64_C(0x8793d3282d260750), UINT64_C(0xe5401b287d8424d8), UINT64_C(0x6a620860b56fe928), UINT64_C(0xb87d5620cebac040) }}, {{ UINT64_C(0x61d42f58fd940474), UINT64_C(0x44f266c8fd26d114), UINT64_C(0x25435cc011e5c8b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf8280bb482af1590), UINT64_C(0xa3b13ec49cb3496c), UINT64_C(0x1c279af458fc68d8), UINT64_C(0x237ffce0a80e8c78) }}, {{ UINT64_C(0x4f5f9064d7e882e0), UINT64_C(0xa25f7c74e26ae75c), UINT64_C(0x11b2d9b8805b508c), UINT64_C(0xb66277a8cdf7051c) }}, {{ UINT64_C(0x195223dc2c47d824), UINT64_C(0xc36f7f0027de3084), UINT64_C(0x857a0ffca2e0d8fc), UINT64_C(0x03d7dee804c7f1d8) }}, {{ UINT64_C(0xf59fbb945b32dec4), UINT64_C(0xead1c860b22c3be8), UINT64_C(0xbade4f4c4a32d9a8), UINT64_C(0xa12ede84a9d4bd78) }}, {{ UINT64_C(0xceb20d0840cce168), UINT64_C(0x78f0c10863f60d48), UINT64_C(0xb174c434606fb34c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e7b28dcb718e520), UINT64_C(0xa14b75f0517043b0), UINT64_C(0xf14aade42e773f18), UINT64_C(0xc5563eecfbf4ee70) }}, {{ UINT64_C(0x83d28870ed7d8b5c), UINT64_C(0x152839d400cd6a34), UINT64_C(0x7b9ba50c290dbf28), UINT64_C(0x415b2aac5e93b98c) }}, {{ UINT64_C(0x2f809200685ddbe8), UINT64_C(0x71b851603b2fb4fc), UINT64_C(0x22998180a2aeb0c4), UINT64_C(0xaaaba90006ea6010) }}, {{ UINT64_C(0xa67cd6608dafc030), UINT64_C(0xcb6bc64cda681148), UINT64_C(0x40fc6c80708daee0), UINT64_C(0xe454e13c2bf4ff98) }}, {{ UINT64_C(0x1d584f74d0558ae8), UINT64_C(0x56aeb5c463220b8c), UINT64_C(0xe394b0088e4778c0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x765f661c52ffed34), UINT64_C(0x0154fc903554c4b4), UINT64_C(0x6ae06dd8c5382ce8), UINT64_C(0x4c7bfc1457464650) }}, {{ UINT64_C(0xf10e0afcf7cccf80), UINT64_C(0x7772a31450073698), UINT64_C(0xbfc04a343b2dc780), UINT64_C(0xa50493e8d58bf674) }}, {{ UINT64_C(0xb2442f7407056ef8), UINT64_C(0x1bd4dd4ccb7a299c), UINT64_C(0x25edb380b8d306c0), UINT64_C(0x283315287f4d90d8) }}, {{ UINT64_C(0x7d6a230835636780), UINT64_C(0xb16b50f03e2ab544), UINT64_C(0x234912a8bcc529d8), UINT64_C(0x5c93a5d4498891fc) }}, {{ UINT64_C(0x6ea9995c7b8c7660), UINT64_C(0x2e04a0789eae4b1c), UINT64_C(0x2a005eac16851494), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x774735287fcc8b98), UINT64_C(0xb74b88b4c37225cc), UINT64_C(0x54f509587d8dc88c), UINT64_C(0x9195ca88fdcc73fc) }}, {{ UINT64_C(0x6eabbb0c3a12c33c), UINT64_C(0x90c3610c81454c44), UINT64_C(0xea3f6d1032d45840), UINT64_C(0xb0de697c36e2b024) }}, {{ UINT64_C(0x67510c7888279920), UINT64_C(0xdce6aae009b850f0), UINT64_C(0xb6496fa8e8258a78), UINT64_C(0xf3a374b8f759677c) }}, {{ UINT64_C(0xc2badad8ac007cbc), UINT64_C(0x4e7044b8cd50eecc), UINT64_C(0x20eb30846e3e0190), UINT64_C(0xaddcc49c1ce049ac) }}, {{ UINT64_C(0xccefed0c3b9ebf80), UINT64_C(0xb3b6a7d894714374), UINT64_C(0x74c22bf49cccf988), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfeb2e340c6313878), UINT64_C(0x392ffd54466dd78c), UINT64_C(0x69363c48d94d3690), UINT64_C(0x4d70e86c8a311d78) }}, {{ UINT64_C(0x379328a4a5774950), UINT64_C(0x272016a875ea4f64), UINT64_C(0x4c48eef042f3d974), UINT64_C(0x8d515950518821a8) }}, {{ UINT64_C(0x77ef21740dc24094), UINT64_C(0xa3c099f87fde43d8), UINT64_C(0xfe029da480d1af6c), UINT64_C(0x428965d470e4ba6c) }}, {{ UINT64_C(0xadacf38c77ea88c4), UINT64_C(0x91def5488e2e6cc4), UINT64_C(0x7b97a288e5c03b2c), UINT64_C(0x9466db400a25bc8c) }}, {{ UINT64_C(0x295e4f9c705e6860), UINT64_C(0x66c40fccd3ad7b54), UINT64_C(0xa071a28041d53f38), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xfbdb77a8b92854b8), UINT64_C(0xee2f6f54499ee494), UINT64_C(0xb4084ed42a2d9f1c), UINT64_C(0x8a76feb8cebfc398) }}, {{ UINT64_C(0xfa397434c368ba50), UINT64_C(0xf112374c4fc056f8), UINT64_C(0x5c8167a4b8f70120), UINT64_C(0x18b269c8c43b20fc) }}, {{ UINT64_C(0x1edf9b706f19c978), UINT64_C(0xffd3bc986d763a8c), UINT64_C(0xe1772260ca700654), UINT64_C(0xf5e223a46d5f49a4) }}, {{ UINT64_C(0x4218fca05ce2ab10), UINT64_C(0x2f181afc756f2780), UINT64_C(0x111036244801d34c), UINT64_C(0x14b64334a797fd04) }}, {{ UINT64_C(0xf743bbb4d7fefdec), UINT64_C(0xf112da30895f6bf0), UINT64_C(0x67c69e5c78c9a554), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x470b7418fccc70ac), UINT64_C(0x1d996394469d95c0), UINT64_C(0x99d19dc8d446a0a4), UINT64_C(0xe65fc4bcd22114d0) }}, {{ UINT64_C(0x93c40944ed7c640c), UINT64_C(0xbd2354047b950884), UINT64_C(0xd45bf1bcf4d6f00c), UINT64_C(0x0c6e300c1b90bf70) }}, {{ UINT64_C(0x0fa56e385b460bdc), UINT64_C(0x83b419f4a14dcfe8), UINT64_C(0xef11b188d9e0ea00), UINT64_C(0x3a67772c5f447cac) }}, {{ UINT64_C(0x7ec4c538a2c3c5a0), UINT64_C(0x157eae78e1d0d900), UINT64_C(0xfb4b5d245e419944), UINT64_C(0x17b5cb74b4bb4a68) }}, {{ UINT64_C(0x7963a6f0563564cc), UINT64_C(0x03d54b9c302fe6e0), UINT64_C(0x9cc0ecd0732842b0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8531d2d4282077c0), UINT64_C(0x3f307240d30e3f08), UINT64_C(0xba0d3d08f697b0ec), UINT64_C(0xd43c692c21e7e978) }}, {{ UINT64_C(0x5e3cabd096873584), UINT64_C(0x667346b0cfccea5c), UINT64_C(0x43819e4cbf86ba10), UINT64_C(0x5021282ca2dedf70) }}, {{ UINT64_C(0xbdc52b9c3525ee90), UINT64_C(0x8faa53f0dc9f2468), UINT64_C(0x0819a8d0c271c398), UINT64_C(0xa6d90060193157c4) }}, {{ UINT64_C(0x71602930e8a3cfb4), UINT64_C(0x36f45e6046aed76c), UINT64_C(0x965cceb8f5519ca8), UINT64_C(0x92270c901fca3e30) }}, {{ UINT64_C(0x6ab2a0b0f750e1a8), UINT64_C(0xa0e368b838a9664c), UINT64_C(0x898ef054d4863748), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0354c2f4622a2954), UINT64_C(0x1a8f175c3d4465ec), UINT64_C(0x8b409b883249a0d0), UINT64_C(0x7edd15307ecb08e8) }}, {{ UINT64_C(0xa0b097087bef3d1c), UINT64_C(0x4b7f98a8728ce91c), UINT64_C(0xceb263c8c356cb38), UINT64_C(0x1e76a82cad566d3c) }}, {{ UINT64_C(0x8c9de770da531140), UINT64_C(0x90a827f435b4dd54), UINT64_C(0xae3055b856873754), UINT64_C(0xb6e9171c7619161c) }}, {{ UINT64_C(0x838ae39cc05da61c), UINT64_C(0x36942160276239ac), UINT64_C(0x452acc5c872c97dc), UINT64_C(0x21568df8a4d25af4) }}, {{ UINT64_C(0xbca11a20160d13e8), UINT64_C(0x83478360b518b43c), UINT64_C(0x0c1965eca9314d34), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x92dc68f433fe2970), UINT64_C(0x30728cb4ee9ef58c), UINT64_C(0x9b2b803c79393b78), UINT64_C(0xcbfe6a8064826e88) }}, {{ UINT64_C(0x611b0d98a04b8878), UINT64_C(0x2edd371c863ec3b8), UINT64_C(0xcb96d55069bb8f40), UINT64_C(0xb4e4607cea4190dc) }}, {{ UINT64_C(0x3bfbae6ccf012c44), UINT64_C(0xf9ed8dd8b3729564), UINT64_C(0x81cab484b5bd749c), UINT64_C(0xe5b33d9cc7c18c14) }}, {{ UINT64_C(0xc5502e4429ede120), UINT64_C(0x40ae201c01a7c6e8), UINT64_C(0x7fa8536482ee195c), UINT64_C(0x28faf6acf98c4dd4) }}, {{ UINT64_C(0x477aec9cc7754af0), UINT64_C(0x117f13b8a232c294), UINT64_C(0xa6eb54306da6da0c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x69c629acb8680804), UINT64_C(0x17f097ece2fec238), UINT64_C(0xc7205660560486b4), UINT64_C(0x3059e638ad15a72c) }}, {{ UINT64_C(0x28eb1904c3453cb8), UINT64_C(0xb957142cbde57c94), UINT64_C(0xcf320840fc8d5f10), UINT64_C(0x7b04971c56229a00) }}, {{ UINT64_C(0x7f3ccbacdfaa992c), UINT64_C(0x25e0f6086f997394), UINT64_C(0x8e72ad58b8fcf264), UINT64_C(0x382a4a00d8b3dd58) }}, {{ UINT64_C(0x377cc5e439ffc4a0), UINT64_C(0xd461d5fcbe4f90fc), UINT64_C(0x672d02b837b9b36c), UINT64_C(0x1cfa02dc4fccd1e8) }}, {{ UINT64_C(0x5e191c60bd2a2ba8), UINT64_C(0xe2d406e4e652a5f8), UINT64_C(0x4aa86c1c89704b90), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x14b9dc6c89f9f8bc), UINT64_C(0xe70538883011eb20), UINT64_C(0x89c3c7909e9c507c), UINT64_C(0x0a90653c5cb30570) }}, {{ UINT64_C(0xc35e9fb4d6d5f7a8), UINT64_C(0xb7cb84485a572450), UINT64_C(0xb1c60150db16181c), UINT64_C(0x972308e49a08a6c4) }}, {{ UINT64_C(0xd4803b44ac67434c), UINT64_C(0x6345a004949b1890), UINT64_C(0x951d8170928b6478), UINT64_C(0x578e5e7ccb2a04c4) }}, {{ UINT64_C(0xd985c5785e9a417c), UINT64_C(0x2c52e860e838b95c), UINT64_C(0x76a6f8f45244bb1c), UINT64_C(0x7e9cf2fc370dac50) }}, {{ UINT64_C(0xf300685001c9f5c4), UINT64_C(0x8fba3e24247c65f4), UINT64_C(0x711ac3708cbed848), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e78d320d9d4ef8c), UINT64_C(0x0d868ae861e00ba8), UINT64_C(0x80a0e71cd31df498), UINT64_C(0xc3b81e08cbd5b78c) }}, {{ UINT64_C(0x0bd977a44ed2e990), UINT64_C(0xbaaa092c98098590), UINT64_C(0x3dd037b087c14cf8), UINT64_C(0x81854d44d7039cb4) }}, {{ UINT64_C(0xe02b5540735ac87c), UINT64_C(0xc152b5d8915149ec), UINT64_C(0x48e33554a3e204bc), UINT64_C(0xc0195e401ea25d4c) }}, {{ UINT64_C(0xed815ca0ebdefd8c), UINT64_C(0xc3ca3bf8c8f5ceb0), UINT64_C(0xf543f42033e4c440), UINT64_C(0x02888134664d99fc) }}, {{ UINT64_C(0xea792d84958f163c), UINT64_C(0xbf544308202fa5ac), UINT64_C(0x07a1a5acfa6e7c3c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe0d3efe8c968cd1c), UINT64_C(0x6626d360ce2e5f2c), UINT64_C(0x11d218a8d4f53084), UINT64_C(0xc3405cec04c94e1c) }}, {{ UINT64_C(0x2960d0f8adc71148), UINT64_C(0xd6708e90d590588c), UINT64_C(0x757a08d4f774abb0), UINT64_C(0xa91199ac26216e14) }}, {{ UINT64_C(0xc3cbdb6c8f5c212c), UINT64_C(0x89784ce0a05aef00), UINT64_C(0x863a8c2c08b2d1c4), UINT64_C(0x8552ee7426c58bfc) }}, {{ UINT64_C(0xb95d2d841a297948), UINT64_C(0xf71288e0da995518), UINT64_C(0xb2a651b409567bbc), UINT64_C(0x2b26cd205c322004) }}, {{ UINT64_C(0xc7f4319c18d0e2b4), UINT64_C(0x77f3688074281620), UINT64_C(0x012d6e203ff79f60), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e2adb44656bd85c), UINT64_C(0x084d93081ccbd3a4), UINT64_C(0xd9d839d890947218), UINT64_C(0x0fe9afd0ae50c088) }}, {{ UINT64_C(0x896178e81b20f7a0), UINT64_C(0xafd07488724a22c0), UINT64_C(0xa2c5481841225950), UINT64_C(0x24672f2847413234) }}, {{ UINT64_C(0x6881c9fcefb051cc), UINT64_C(0x2111c3b4026fd424), UINT64_C(0xe6ea447c3ebae098), UINT64_C(0x1e4b16883ae3ccc8) }}, {{ UINT64_C(0x7a9bab78d05ce5d8), UINT64_C(0xac1fed34d79b9b28), UINT64_C(0x9f855438e1e87734), UINT64_C(0x09c64384857b2ad8) }}, {{ UINT64_C(0xf2577dcc1634f014), UINT64_C(0x5cf26ba8df741f7c), UINT64_C(0x9c3e8150e7664868), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x569b632073cfb014), UINT64_C(0xb388608cc0f96d20), UINT64_C(0xa2d5b6a07c0db6b0), UINT64_C(0x926c783ca9bb0480) }}, {{ UINT64_C(0x13ca2fcc82a86b4c), UINT64_C(0xe80e00b42fc0332c), UINT64_C(0x8f64ac583538993c), UINT64_C(0x5514925075bcaf80) }}, {{ UINT64_C(0x8a856e5ce61962e0), UINT64_C(0xcd0af020de2ca530), UINT64_C(0xed2b6a94454fea5c), UINT64_C(0x515b2c489352817c) }}, {{ UINT64_C(0xc79cb300d4271ab8), UINT64_C(0xfee71564f360e80c), UINT64_C(0x69463ff816970250), UINT64_C(0x91d6dfe02d927e90) }}, {{ UINT64_C(0x570e3108e0179eec), UINT64_C(0x8921613c88733c70), UINT64_C(0x4839b8a8ef0e993c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc6b43a18dd18c618), UINT64_C(0x0a79a3283e8656cc), UINT64_C(0xa0ca61dc79ce549c), UINT64_C(0x5f6f0d70aca3fc98) }}, {{ UINT64_C(0xe492ef387d92cf5c), UINT64_C(0x1c662508287f61dc), UINT64_C(0x0b56eaa875be5b18), UINT64_C(0x26c05f2866efb668) }}, {{ UINT64_C(0xae12d1b00e914ac4), UINT64_C(0x4f45bec85c29ec70), UINT64_C(0x7df2561c454471e0), UINT64_C(0xce823a1c2511d8f8) }}, {{ UINT64_C(0x03b9980876f514d0), UINT64_C(0xc24630908175a294), UINT64_C(0x1cbbe6a0d72574b8), UINT64_C(0xadebefa003cde930) }}, {{ UINT64_C(0x8c1864580ecd5708), UINT64_C(0x82f48e8c449415ec), UINT64_C(0x2191987465ebe9c8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcf10cb085a5d6f78), UINT64_C(0xe726a3901218b080), UINT64_C(0x44552c9c1518aaa4), UINT64_C(0x26068a3407ef70b4) }}, {{ UINT64_C(0x8cc93c948dfc6fe4), UINT64_C(0x10b70af4c59fd950), UINT64_C(0x22cbeba40e44eee4), UINT64_C(0x0f2dcf305b8547a0) }}, {{ UINT64_C(0x2c5b7f38e8bd1b6c), UINT64_C(0x683d5bd8fd4a53d0), UINT64_C(0x64d05ad490cc3c6c), UINT64_C(0x07e64e6479ffb414) }}, {{ UINT64_C(0x317e04981f73bf04), UINT64_C(0x04f00688de2b349c), UINT64_C(0xd2489740069b6160), UINT64_C(0xdaf1306c26433754) }}, {{ UINT64_C(0x5fa51370c6d624b0), UINT64_C(0x465afa647b85cbe0), UINT64_C(0xa633eaa033a30208), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x569c7e4c0a829e9c), UINT64_C(0xdbae509462bc25e8), UINT64_C(0xca08b0e89a458c3c), UINT64_C(0x0609c35cfa12f480) }}, {{ UINT64_C(0x031745fcb42ab918), UINT64_C(0x83f87dd0032e82d0), UINT64_C(0x6b6692d42e296538), UINT64_C(0x59de0514d6dd44b0) }}, {{ UINT64_C(0xb1cae93cbcb21ee4), UINT64_C(0xb3994ab88daf61f8), UINT64_C(0x00e4edec86510d7c), UINT64_C(0xc79668c4b9167080) }}, {{ UINT64_C(0x83c3cf682525098c), UINT64_C(0x82c2858c8fbc5d0c), UINT64_C(0xf217b1fc1a90ca44), UINT64_C(0x97b4a6207c9d968c) }}, {{ UINT64_C(0xc9704c4478efa4f8), UINT64_C(0xb2d96dec1d4a9cb0), UINT64_C(0xe74c6228b86f7134), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x91828a2433b0ad4c), UINT64_C(0xb50bb2383f9bc3a4), UINT64_C(0x525b21106cb49ce8), UINT64_C(0xec22fc7c351c4b54) }}, {{ UINT64_C(0x74d63cc87a5f9b68), UINT64_C(0xd0f6ae94fe1b8094), UINT64_C(0x704b448076ba17dc), UINT64_C(0x6da70b9c4a960ce0) }}, {{ UINT64_C(0x4a4d5ab09737a3c0), UINT64_C(0xf2f38c94f222aa28), UINT64_C(0x08caeb84dddb57fc), UINT64_C(0x3925530843e4d31c) }}, {{ UINT64_C(0x44847614186ac828), UINT64_C(0x4ce13e9c77741b38), UINT64_C(0xc2f39f904a26fe48), UINT64_C(0x792f1ae80e410c34) }}, {{ UINT64_C(0xe40f69c03ee3ecc4), UINT64_C(0x8033af984c64be84), UINT64_C(0xb715f6b400e0c140), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa9946600a7b63664), UINT64_C(0x09e00174f567c3f4), UINT64_C(0x3ce53ca800ff8b20), UINT64_C(0xf72130586df7e0c4) }}, {{ UINT64_C(0x9d9b4bcce3b77f08), UINT64_C(0x5097a908d0a918a4), UINT64_C(0xdf4119a0379b72f0), UINT64_C(0x56eeb610bd2637a8) }}, {{ UINT64_C(0xdd46513814c8f544), UINT64_C(0x2aa934588a0f4bfc), UINT64_C(0x6c855fe0c48c8e70), UINT64_C(0x6968862c3b76a418) }}, {{ UINT64_C(0xbe15a104e929b9f4), UINT64_C(0xaace6288c3968120), UINT64_C(0xdee9d3347423d5f4), UINT64_C(0x4562ced07bfbea08) }}, {{ UINT64_C(0xd3608ed000b59444), UINT64_C(0xf319da84ef0493f0), UINT64_C(0x23a745e07b674080), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x03ee97b84bf3a9cc), UINT64_C(0xd948a548152d1108), UINT64_C(0x6dbe2e04311ed6fc), UINT64_C(0x42901cf0b8a6bc94) }}, {{ UINT64_C(0x0b6d7fd0f7e920cc), UINT64_C(0xb3020984b4b0e42c), UINT64_C(0x70ea9d18f97d6bd0), UINT64_C(0x82ecd7004973d8a4) }}, {{ UINT64_C(0x373a19e05a0e4d6c), UINT64_C(0xaa33c138f6aeef74), UINT64_C(0x67e7f19c41779f74), UINT64_C(0x8335c794685b4004) }}, {{ UINT64_C(0xe437fbf824bf003c), UINT64_C(0x2b3b2e94870418c0), UINT64_C(0x13f54bec28693b7c), UINT64_C(0xbb61167088010f6c) }}, {{ UINT64_C(0x5639e25cd16762fc), UINT64_C(0xcb8b9bc0fc98b6e4), UINT64_C(0x2e2058541eda26b4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaf5e5b6c03e4cf80), UINT64_C(0x17bfb3e0a4a12a34), UINT64_C(0x8c7972f05e64b194), UINT64_C(0xbf6d1230abad620c) }}, {{ UINT64_C(0x05f5ff2038ccbad8), UINT64_C(0x2b056c8c4a9e6758), UINT64_C(0xe45934a8f5a340a4), UINT64_C(0x63fcdbd8f038cf9c) }}, {{ UINT64_C(0x80b6d608523c2450), UINT64_C(0x5c2fe8fcff7568bc), UINT64_C(0x608a4d60cabc5d7c), UINT64_C(0xc46f947c5a3ec228) }}, {{ UINT64_C(0xf0fa9f789945ec24), UINT64_C(0xd605c7a406c823b4), UINT64_C(0x0fd5c944430728bc), UINT64_C(0xdbbb05540df94490) }}, {{ UINT64_C(0x0c825d088e53fcbc), UINT64_C(0x3f00805460bf8314), UINT64_C(0xd79c2c806edcdaa4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc8552398b35b9928), UINT64_C(0x1b4b949440807914), UINT64_C(0xa975e3d4f878dea8), UINT64_C(0x84327eacd1cbeccc) }}, {{ UINT64_C(0xf5ad6ac46e5ef40c), UINT64_C(0x503ea1bc936c4bf8), UINT64_C(0x224bcd2c6acf6450), UINT64_C(0xb948889c22a7c038) }}, {{ UINT64_C(0x09bf3de0d7cfb788), UINT64_C(0xb32fef20472e9378), UINT64_C(0xa19ec6c8aa49d9f0), UINT64_C(0x5d8cf1e0b822c830) }}, {{ UINT64_C(0x4978054c3319aa48), UINT64_C(0x0fcd256452082030), UINT64_C(0xfad7f85c7c72a65c), UINT64_C(0x7b4c1860cbce6134) }}, {{ UINT64_C(0x49c4b0fc721381b0), UINT64_C(0xbd47cc68d1a3e628), UINT64_C(0x48a24f0849965ed8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd6676f2cadd2620c), UINT64_C(0x97c250fc9478c1c8), UINT64_C(0xe47c943c6bc7bca0), UINT64_C(0xa82ea5a8e78dccf4) }}, {{ UINT64_C(0xd590b53c5cf51b84), UINT64_C(0x69ecf758214e64ec), UINT64_C(0x07526374bb570444), UINT64_C(0xf52bc684821200d0) }}, {{ UINT64_C(0xa63d297ca147e240), UINT64_C(0xcffd44f01addc62c), UINT64_C(0x6c1051e433334804), UINT64_C(0xc5f220acfcc1409c) }}, {{ UINT64_C(0x3cb3d5b4ca10f588), UINT64_C(0x167f14bc7228af1c), UINT64_C(0xbc5bedec4b86389c), UINT64_C(0x3577273419770190) }}, {{ UINT64_C(0x12d3bfdca71aa36c), UINT64_C(0x82c820ec0f9dd42c), UINT64_C(0xeaa01e04abd11848), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x406ebe443cb3629c), UINT64_C(0x397ff2dc20489cec), UINT64_C(0x83467b747789df84), UINT64_C(0x6c579a44e6b1b510) }}, {{ UINT64_C(0x9f3f069c85a95430), UINT64_C(0x940c8a944074d3e4), UINT64_C(0x744ee70844c26410), UINT64_C(0xb6e9fc9ccb128e74) }}, {{ UINT64_C(0x971f4684ba08a7ec), UINT64_C(0x097e7e802f0c0d30), UINT64_C(0xf81549585446e078), UINT64_C(0xf18c31dc98f9fdf4) }}, {{ UINT64_C(0xf3669a38efeaca74), UINT64_C(0x204e62a8a34f14b0), UINT64_C(0xe55c2c00f33fcf20), UINT64_C(0xdeeaa8d01fecda84) }}, {{ UINT64_C(0xd50b007c60a5ba00), UINT64_C(0xa63f18c81fb016c0), UINT64_C(0x034984f4ae1feefc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x02fa10d0cfb5bd3c), UINT64_C(0x7414e70484219030), UINT64_C(0xc68c28b825bb4874), UINT64_C(0xd5c87de8485e718c) }}, {{ UINT64_C(0xf1c697e4fb1d5230), UINT64_C(0x69338db064cb165c), UINT64_C(0xdc7e03a0dbff0904), UINT64_C(0xdfa8c840eb9943fc) }}, {{ UINT64_C(0xbbf334043735ea28), UINT64_C(0xfdbaf714ddcc4a9c), UINT64_C(0x4bf0d01021dcd780), UINT64_C(0xff4dac6ce833ba14) }}, {{ UINT64_C(0x9585f464e9373968), UINT64_C(0x3e78714c64cfe474), UINT64_C(0x5e139f5816a396d4), UINT64_C(0xae94a02c48c1185c) }}, {{ UINT64_C(0x71fc8db4a9b727a8), UINT64_C(0xaeaa27a826784fac), UINT64_C(0xbc7a6cd4f45a9894), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa7fae4c0de7c7294), UINT64_C(0xa446d1b8ef134ac8), UINT64_C(0x0026b7c8bcef0854), UINT64_C(0xc09283dc52af8cfc) }}, {{ UINT64_C(0xe9438f2c256c3c74), UINT64_C(0x52b0e1786b995528), UINT64_C(0x08070474584700dc), UINT64_C(0xdbece3dc5b8ef114) }}, {{ UINT64_C(0x2b6c8f2cd6f1d634), UINT64_C(0xa2aa47587ef2f354), UINT64_C(0x9aae5858181be438), UINT64_C(0xaec7b354e21c96d0) }}, {{ UINT64_C(0x1362a2089b07df44), UINT64_C(0x7c1b31680e6a3834), UINT64_C(0xe4eee9e4170531ac), UINT64_C(0x01d2b3d49693cb08) }}, {{ UINT64_C(0xb58d0eb8caad1888), UINT64_C(0x139086801e18db90), UINT64_C(0xe272a02cfa5ac7dc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9ca79c28b40ec18c), UINT64_C(0xbcefb05c9a668214), UINT64_C(0x30d505587790df04), UINT64_C(0x51fd2a044652baf8) }}, {{ UINT64_C(0x9ec6d1a810d1a488), UINT64_C(0x057dfd6c8c58f4a8), UINT64_C(0xbc35b240b80b63ec), UINT64_C(0xc0bfabc82fe04c0c) }}, {{ UINT64_C(0x9f251b489dd87a80), UINT64_C(0xe8b752a8af629ba8), UINT64_C(0x09903e90e8849658), UINT64_C(0xf970e99c003879ec) }}, {{ UINT64_C(0xb10d6ba82a428514), UINT64_C(0x6a1c515477d6e434), UINT64_C(0x9d2400d05138e718), UINT64_C(0xf2944cf4bc37db30) }}, {{ UINT64_C(0x2a9202e0cf81c7a0), UINT64_C(0xf0c6ba18866ba17c), UINT64_C(0x30c321ccb95577c4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4de96c5806012240), UINT64_C(0x24f2e5684cadecac), UINT64_C(0xf85b73a0beaf8b68), UINT64_C(0xf1d92e6c98709d50) }}, {{ UINT64_C(0x2a9033dc523e67d8), UINT64_C(0xb34ef564c59504f0), UINT64_C(0xb1888ff87412d0d4), UINT64_C(0x17cd68d01007f07c) }}, {{ UINT64_C(0xadf3b2cc855a109c), UINT64_C(0x6d222c988d0b5b1c), UINT64_C(0x251cc4100ecb0198), UINT64_C(0x974e94204705d2e4) }}, {{ UINT64_C(0xbdf241a074aab018), UINT64_C(0x3c9c9960616bbb90), UINT64_C(0xfde641c0b5227f84), UINT64_C(0x5497efbc8de5f4e8) }}, {{ UINT64_C(0xfee922585ee6ab68), UINT64_C(0x49a90874a25a92b0), UINT64_C(0xc697b784b297fc8c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x573bc2248ebe8194), UINT64_C(0xbb8ffec483671ba0), UINT64_C(0x031513585445cbc0), UINT64_C(0xc737f2a0596f6398) }}, {{ UINT64_C(0x3528575486aee040), UINT64_C(0x6c5829b0cb3c55b8), UINT64_C(0x7e231cd40b0ef3f0), UINT64_C(0x85af5698050bc8d8) }}, {{ UINT64_C(0x55cf47843918ab84), UINT64_C(0xe2c5ab006dae737c), UINT64_C(0x70bf598411d88774), UINT64_C(0x851d12f0a269ac00) }}, {{ UINT64_C(0x948da934f4bec258), UINT64_C(0x26259748e26e6954), UINT64_C(0xafa5ac0491ff43b8), UINT64_C(0x9a7d204c0dff8650) }}, {{ UINT64_C(0xc95337881b44f954), UINT64_C(0x7cfba1f00e5d00fc), UINT64_C(0x3613f5f4a5fed06c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x14a1cb387b286f40), UINT64_C(0x09a75890abe2ceb8), UINT64_C(0xf94687c827ab0a40), UINT64_C(0x384172b872323d2c) }}, {{ UINT64_C(0x79fc9cfc7400bd0c), UINT64_C(0xf47c9bec53c69970), UINT64_C(0xfc9ddc346c6b4d08), UINT64_C(0x26e72740ad9a0998) }}, {{ UINT64_C(0x24b35ce8f685c648), UINT64_C(0x27b342f443e6f104), UINT64_C(0xa90cf4e06a0fcefc), UINT64_C(0xd0919e904fa6bf14) }}, {{ UINT64_C(0x7906eeb49b9beeec), UINT64_C(0xf3159548c10ad3b4), UINT64_C(0x83d831341d0e8218), UINT64_C(0xe55b20dc16d883e8) }}, {{ UINT64_C(0x88eba8bcaaf2aa4c), UINT64_C(0xd8686d048754a4f8), UINT64_C(0xf60cddcca5a65728), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd15cf1b8409ccb1c), UINT64_C(0x5bafd75c275c4870), UINT64_C(0x51167bb48b2974fc), UINT64_C(0xea148594b2ee68bc) }}, {{ UINT64_C(0x27d5a3b8582cef8c), UINT64_C(0x17233ef0b5772310), UINT64_C(0xba874ed8898f50dc), UINT64_C(0x1afe82402f7dc7fc) }}, {{ UINT64_C(0x47464e8409bd5438), UINT64_C(0xb7891b38343ace40), UINT64_C(0x3e2551445160a150), UINT64_C(0x0b9e84d4c32e7d70) }}, {{ UINT64_C(0xb3c3d11c4d02dfe4), UINT64_C(0x172cedd0f50f32ec), UINT64_C(0xa18ef458253a2f08), UINT64_C(0x7d6fb6f8a5c12234) }}, {{ UINT64_C(0x383b539c443bf230), UINT64_C(0x60b01a506e79e710), UINT64_C(0x86245a2cd5515330), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x455f25c82ebb3c5c), UINT64_C(0x9f6c7518b5bb19bc), UINT64_C(0x77945aa4509a68a0), UINT64_C(0x6654adec3d37e3b0) }}, {{ UINT64_C(0x152352dca0501fdc), UINT64_C(0x473c930c8a553b60), UINT64_C(0x9bb2b5a885d1d54c), UINT64_C(0xedd8303ceca877b0) }}, {{ UINT64_C(0x4187067cc357b87c), UINT64_C(0x40c0c168c8bd3374), UINT64_C(0xcc7f17842053c42c), UINT64_C(0x52224ff87eb11c4c) }}, {{ UINT64_C(0x4379bb2c680984a0), UINT64_C(0x061e980c187512b0), UINT64_C(0x12250f24bf74b3d8), UINT64_C(0x25c25888dfde1648) }}, {{ UINT64_C(0x79d1ca74cd676f28), UINT64_C(0xf967cdc8a8d5ef38), UINT64_C(0x8c81f8ac03a0cdb4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x36acc8089fee1424), UINT64_C(0x1c5c90bce8b8e9fc), UINT64_C(0x12bbf3c4cb63ea28), UINT64_C(0x85bcac44c0644164) }}, {{ UINT64_C(0xb52143a4c48ed710), UINT64_C(0x7172fc2c69e5f078), UINT64_C(0xdb3e0f18f244f784), UINT64_C(0x46d1328838c45e88) }}, {{ UINT64_C(0xe380011430401764), UINT64_C(0x7014aea4634b1ca4), UINT64_C(0xbe673f90b65369f8), UINT64_C(0xd1a869a4caae3f3c) }}, {{ UINT64_C(0x4434ffcc5cf3dd18), UINT64_C(0x068e1164579c7154), UINT64_C(0x1b86f97c4e2bec18), UINT64_C(0x35c09e2049ab16e0) }}, {{ UINT64_C(0x8697813c379c3c30), UINT64_C(0x072bc54ca27eec58), UINT64_C(0xcaa1eb9c3eb83264), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9db3792c662b6c54), UINT64_C(0x3785d894206148f4), UINT64_C(0x71105f001ded7e54), UINT64_C(0xb7602b10eedfe148) }}, {{ UINT64_C(0x129b1b5c4ca92e28), UINT64_C(0x3fd559dc467b5c64), UINT64_C(0x799853c84a3468e8), UINT64_C(0x0f44b85458bd491c) }}, {{ UINT64_C(0x2ff306c0a4054e88), UINT64_C(0x1e86c334dcc08448), UINT64_C(0x355830f8bba90a08), UINT64_C(0xe2e1c9b4c6590010) }}, {{ UINT64_C(0x2bf95250112e2664), UINT64_C(0x5cae45b493c3df44), UINT64_C(0xc9c9cebcf785d168), UINT64_C(0xe42ad93c33b86d88) }}, {{ UINT64_C(0x79e091d02f45ab88), UINT64_C(0xd7ab8bdc5d285788), UINT64_C(0x56ea9bf0641168f0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x34e9ab0484db429c), UINT64_C(0xae41ff94c26d5984), UINT64_C(0x227638601cf371e4), UINT64_C(0xe46f917088a40250) }}, {{ UINT64_C(0x64f23d781edbe928), UINT64_C(0xc81c8e983990a2d0), UINT64_C(0xbfc01fc06386811c), UINT64_C(0x3f9962cc036c650c) }}, {{ UINT64_C(0xa9e8ec987e64827c), UINT64_C(0xfbeb81747e095e08), UINT64_C(0x83d6c20caa248fd4), UINT64_C(0x9b438c7c518aa400) }}, {{ UINT64_C(0x2b0d64d0a9ad0944), UINT64_C(0x57993c6809ae4638), UINT64_C(0x0172450092b48f18), UINT64_C(0x636126c4ba1c0804) }}, {{ UINT64_C(0xbb7f4fdca96bb250), UINT64_C(0x0abccde8cf5e2c74), UINT64_C(0xf45c389ca097d2e4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc54b7428f7892ee8), UINT64_C(0xb15c7b9c9702ea1c), UINT64_C(0x16339914135d94bc), UINT64_C(0xbdc76858a95684ac) }}, {{ UINT64_C(0x1efd0eec49d9e3a0), UINT64_C(0xfa5a4d5804a89234), UINT64_C(0x8df7f648885e63e8), UINT64_C(0x708a4994523f87fc) }}, {{ UINT64_C(0x2099e310d583905c), UINT64_C(0xfb901990f64cdda4), UINT64_C(0x54ccebb4360fe6cc), UINT64_C(0xb335f57c96c3f6b8) }}, {{ UINT64_C(0x80f2f45cc851fbfc), UINT64_C(0x4ce4c774332e6e98), UINT64_C(0x6ce10e0cc9d954dc), UINT64_C(0x5c636ff05ab7f508) }}, {{ UINT64_C(0x1c600c342e2a4b54), UINT64_C(0x6759c684ed52e284), UINT64_C(0x21636ad075870dcc), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4ee844d84c6b48ac), UINT64_C(0xf57220a8b004aac0), UINT64_C(0x491bdfdcd24fde48), UINT64_C(0xf03ecfa0976870f0) }}, {{ UINT64_C(0x197615447492c8c0), UINT64_C(0xa6b044200b34eb60), UINT64_C(0xb24729dc508fd6e8), UINT64_C(0xcc2a0330cf8e5cd4) }}, {{ UINT64_C(0xb2c524401dd320e8), UINT64_C(0x8726c72c31224c50), UINT64_C(0x8074af8489c5eb70), UINT64_C(0xa41808a880b09834) }}, {{ UINT64_C(0xb3357edccdfa4d9c), UINT64_C(0xf7c6df6c3d4f46ec), UINT64_C(0xc2948a58335c6b8c), UINT64_C(0x2a902ef41bc1388c) }}, {{ UINT64_C(0x0cf7fe645fa50900), UINT64_C(0xa46cd21885838c98), UINT64_C(0x16e460a8e7fc44ec), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa39be4c01e4e7518), UINT64_C(0xaf840038a293a3f0), UINT64_C(0x7b1fd994a5928b50), UINT64_C(0xbdbd879c47ab6648) }}, {{ UINT64_C(0x59bc2610fe3f66a8), UINT64_C(0x6e1359d4e35f87b4), UINT64_C(0x2873315cbefb4b98), UINT64_C(0xf4b647c89d2edbec) }}, {{ UINT64_C(0x62523818e816a658), UINT64_C(0x53d5f41818530a40), UINT64_C(0x97a16b28d589753c), UINT64_C(0xf6b766d4d62f1ba0) }}, {{ UINT64_C(0xf6491ed8d7db8120), UINT64_C(0xfd56961cc5c4b7e4), UINT64_C(0xede8fb78ae0cfe04), UINT64_C(0x128e8fd4920e6e90) }}, {{ UINT64_C(0xfa4e733891d5be64), UINT64_C(0x27d3c64054e4b024), UINT64_C(0x58e60dfc4f495ac0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x08cbfe3c4eeac224), UINT64_C(0x91ccc9b497819610), UINT64_C(0x7af50264922f3684), UINT64_C(0x8581cf6491aa7edc) }}, {{ UINT64_C(0x57c0de64aaf8c8b0), UINT64_C(0x357a3b74e0551850), UINT64_C(0xfe0227cc780ee99c), UINT64_C(0x783416f050657280) }}, {{ UINT64_C(0x396a7e34ad91dee8), UINT64_C(0x2db3442457463568), UINT64_C(0xd67d95f4e561fcf0), UINT64_C(0x7f0c59bc4f6ff888) }}, {{ UINT64_C(0x2d8be594a8f9ab04), UINT64_C(0x7a3d8158353cfb0c), UINT64_C(0x90eb1ab80716bebc), UINT64_C(0x26e231889136a010) }}, {{ UINT64_C(0x304a171caa50339c), UINT64_C(0x55175734a92f2e64), UINT64_C(0x3633f844b2feac1c), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe84546e4eacb4ca4), UINT64_C(0x4104b388f4c8b6dc), UINT64_C(0x9dce10244a6d5588), UINT64_C(0x6160f36c689e897c) }}, {{ UINT64_C(0x1dc1aba4c5245698), UINT64_C(0x9a94098423499dec), UINT64_C(0x41d15254a46599dc), UINT64_C(0x3e8e3a7cce9eaa9c) }}, {{ UINT64_C(0xb6f27a60bda09fa8), UINT64_C(0xb26271848ca9ac2c), UINT64_C(0x2a760fc8aafb8928), UINT64_C(0x01c92580ba3d9b4c) }}, {{ UINT64_C(0xb3eb938c6ad9b744), UINT64_C(0x9b8ce288993a0980), UINT64_C(0xa0c94fac76119738), UINT64_C(0x5071dcf803d559a8) }}, {{ UINT64_C(0xb6e5f10cb0bb4768), UINT64_C(0x49ebd8f0c711b838), UINT64_C(0x697346c8abe9b778), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc842fa7cb0470f84), UINT64_C(0xfb9077844804aeb0), UINT64_C(0x5df3f8d8603cf02c), UINT64_C(0x6d880a98a8b05358) }}, {{ UINT64_C(0x02ce9850c88b6440), UINT64_C(0x7282eaa037fe86c4), UINT64_C(0xdf16e1e48866cc70), UINT64_C(0x97b8f9840d1ce5fc) }}, {{ UINT64_C(0x9a95fd28d900e184), UINT64_C(0x2bc28e34511bcf34), UINT64_C(0xe870f8f0986c7148), UINT64_C(0x7ac82910091d5d70) }}, {{ UINT64_C(0xaf137684cd5935ec), UINT64_C(0xbee2436cf7ac0a68), UINT64_C(0x2c1fbed05a940238), UINT64_C(0x4539c7fcc7a41cf0) }}, {{ UINT64_C(0xd3bf3b88f2033004), UINT64_C(0x371671a8e7631dd4), UINT64_C(0x4abec03064863488), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3aa011b00b749094), UINT64_C(0x1cfed934f5fd1d24), UINT64_C(0x5462e254c74474c0), UINT64_C(0x352f2d20fda492a0) }}, {{ UINT64_C(0x75610bb8081155a4), UINT64_C(0xd431e4f0709f1b18), UINT64_C(0xf5e2e7e031618f74), UINT64_C(0xdf3206b0fbd21ed4) }}, {{ UINT64_C(0x1ae7bee820ff1cf4), UINT64_C(0x2e4bb4348c0e0d50), UINT64_C(0x7e5131843f912364), UINT64_C(0xc875c9a8e3c17e34) }}, {{ UINT64_C(0x947a4f4c9fa39fc4), UINT64_C(0x300cd048e44d2674), UINT64_C(0x24a6d46cd02ab324), UINT64_C(0x7961daf0c4534aa8) }}, {{ UINT64_C(0x2ce89308f5f92274), UINT64_C(0x64934b60b0d770ac), UINT64_C(0x2ec8cf4458ac53a4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb46803f45a78b3b0), UINT64_C(0xcafe093028cf8c1c), UINT64_C(0x7b7fccd4eeff1cc8), UINT64_C(0x9925726402cce494) }}, {{ UINT64_C(0xe776c6088a8a3be0), UINT64_C(0x46ea217c52b2ee14), UINT64_C(0x2e63e3608a0f800c), UINT64_C(0x508485186472d3fc) }}, {{ UINT64_C(0x9c25e45421b38284), UINT64_C(0x83da62d407bba224), UINT64_C(0xbb0f4e182055b63c), UINT64_C(0x2da13b6cda1f4800) }}, {{ UINT64_C(0xbf889e344b010e84), UINT64_C(0xe1985cc4f06e628c), UINT64_C(0xd19bf958354eb28c), UINT64_C(0x3a26209837abe820) }}, {{ UINT64_C(0x368c64e04f52176c), UINT64_C(0x1108dd8cf95f67d8), UINT64_C(0x0c0eb6acedd13c08), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcc22385ceeb73bbc), UINT64_C(0x688718bcc1497a60), UINT64_C(0x57147c6c1a14c8e4), UINT64_C(0xe8e8d36c0cdffc1c) }}, {{ UINT64_C(0x6aa36728047b62d4), UINT64_C(0xf469c6d00cd45ea0), UINT64_C(0xa095716cc68bb350), UINT64_C(0x21b413742095e768) }}, {{ UINT64_C(0x5a097ef819671d50), UINT64_C(0x38b944e4435108fc), UINT64_C(0x1e71a604c6d527f8), UINT64_C(0xe20824b4db7edc84) }}, {{ UINT64_C(0x7a27284cf6597748), UINT64_C(0x5e2f25906a86c444), UINT64_C(0xdb5d3738cc96b62c), UINT64_C(0x8104823c994a16f0) }}, {{ UINT64_C(0xa2c585886c99299c), UINT64_C(0xcd907aa89c65774c), UINT64_C(0x5fcad48020f96e78), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbd80d394602c78d0), UINT64_C(0xde28e90085b0d734), UINT64_C(0xbc3fa1980022b7fc), UINT64_C(0x8a40610817400eac) }}, {{ UINT64_C(0xb09e59e0337f9d08), UINT64_C(0xb90365083bb7eecc), UINT64_C(0xb28d7b0cabe477a0), UINT64_C(0x57b468384d0683c0) }}, {{ UINT64_C(0xde1800ec5e47f174), UINT64_C(0xac21b3c0cfa558d4), UINT64_C(0xd6cd547ce55d65d0), UINT64_C(0xe745053865863fa4) }}, {{ UINT64_C(0x8e7eae7431e91340), UINT64_C(0x64876f408fbae1bc), UINT64_C(0xd577f370fde86020), UINT64_C(0x25815aa8376a6e94) }}, {{ UINT64_C(0x7f7174cc5ea11484), UINT64_C(0x93b39874245f0b80), UINT64_C(0x87a59174a9a35e38), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xab93d3287249e0e0), UINT64_C(0x74fd39dcdaa46994), UINT64_C(0x7e878878d6599758), UINT64_C(0x35c5968c012f71c4) }}, {{ UINT64_C(0x9530bcc0fffdc388), UINT64_C(0xc67e8ae022ead8c0), UINT64_C(0x694a548863cf8a70), UINT64_C(0x43d12be8b0eb8984) }}, {{ UINT64_C(0xac80217cd49a6dc8), UINT64_C(0x6d01d0000bfbe3f0), UINT64_C(0x65fff4e420cea87c), UINT64_C(0x52c954fcf60edf5c) }}, {{ UINT64_C(0x44e72ea40c63a31c), UINT64_C(0xb069e12024a979bc), UINT64_C(0xc3ff8ac4eb1b12c0), UINT64_C(0x4fea3704578c4c44) }}, {{ UINT64_C(0x9b136b5c9f76eabc), UINT64_C(0x1442550c84ffa748), UINT64_C(0x1cca8d4411fdd0c4), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0abdfd48e5023a3c), UINT64_C(0x41ace1a4751e2d7c), UINT64_C(0x0838bf4ce29a2700), UINT64_C(0xe67ad5f414d586dc) }}, {{ UINT64_C(0x31ecee48cd22d01c), UINT64_C(0xb040f064fd82f2c4), UINT64_C(0x3f324ba81b7822cc), UINT64_C(0x1b8825e860c6e7d8) }}, {{ UINT64_C(0xd161fab870ebbb34), UINT64_C(0x6607f11c51e09364), UINT64_C(0xdc5ffad8a3822058), UINT64_C(0xaf3ed1f48aa51f50) }}, {{ UINT64_C(0x1a2d095021200158), UINT64_C(0x02c652e8f4102d90), UINT64_C(0xa8748e94327296d4), UINT64_C(0x56777a202e8692f0) }}, {{ UINT64_C(0x797c41500394d100), UINT64_C(0xcaa199ec6aaafadc), UINT64_C(0x2970d0ec1ff125b8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6ddbc26c31870978), UINT64_C(0xe3cd95543062c5b8), UINT64_C(0x38fa8e8c1727197c), UINT64_C(0x9659d164aa7f2f70) }}, {{ UINT64_C(0x3b2f8d58d01c9acc), UINT64_C(0xea759d50259efaa0), UINT64_C(0xf693b1481953f158), UINT64_C(0xb15fa954bc5b5c50) }}, {{ UINT64_C(0x52e9b10c84c62f48), UINT64_C(0x27cd4c94fd0cc210), UINT64_C(0x4c525d64e25edaf0), UINT64_C(0xc97ef620666db9b4) }}, {{ UINT64_C(0x722f2b844808e380), UINT64_C(0x80d389b0d6e4acf0), UINT64_C(0x3b6e9818646481a4), UINT64_C(0xe4634e7c56b87bf4) }}, {{ UINT64_C(0x34ed20b0a18fdb68), UINT64_C(0x74950fec1d7716b8), UINT64_C(0x3ebfad2c879c2cc8), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6755c150a41e32dc), UINT64_C(0x6e9b93fc844c09d4), UINT64_C(0xd65ab42c45f236ac), UINT64_C(0x6dc771409b582580) }}, {{ UINT64_C(0x2aa03f00cd376ca4), UINT64_C(0x6e4ca37027d845e8), UINT64_C(0xf8e86868b6fa17b0), UINT64_C(0x2aa5a3b48a19e394) }}, {{ UINT64_C(0xb86273b8a6bd72ec), UINT64_C(0x329c587c7fa050f0), UINT64_C(0x1c7ca21c6b9e4804), UINT64_C(0x258e83d80459019c) }}, {{ UINT64_C(0xd9bdbf6cea72176c), UINT64_C(0xe96e23100000ac2c), UINT64_C(0xe1f3f348835a0058), UINT64_C(0x5a3a8b98051ba318) }}, {{ UINT64_C(0xb91303bcae6237bc), UINT64_C(0xfaec7838497d1f18), UINT64_C(0xf95ab2148459f498), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6cec5d10a0d71474), UINT64_C(0xf701cbb4daf03d70), UINT64_C(0x79dd3a102f36de78), UINT64_C(0x95d38818c1fad65c) }}, {{ UINT64_C(0x32273a6c398b413c), UINT64_C(0xd89e0ac0fed05f10), UINT64_C(0xb5c22e942fb74018), UINT64_C(0x90bb1f94312be390) }}, {{ UINT64_C(0x95855b0c8b0b6fc4), UINT64_C(0x27da16345e79cf8c), UINT64_C(0xd2c99adc3c7b5318), UINT64_C(0xb6909ccc4469ebf4) }}, {{ UINT64_C(0xc4784ea4ac94ec38), UINT64_C(0xe07359b848fcad70), UINT64_C(0xb59e225c0dd7e5c0), UINT64_C(0xcdc0d6649afe5648) }}, {{ UINT64_C(0x7823f9f4d5b59780), UINT64_C(0x755e1264cb0ad984), UINT64_C(0xec372020e3cda580), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x841e65c866aaa500), UINT64_C(0x939eb0f47cb738e4), UINT64_C(0xec7f5b40707bfa48), UINT64_C(0x336d9abc80e9b1bc) }}, {{ UINT64_C(0xf7fe0d3cb15d37d0), UINT64_C(0x9f3567b072fbe1b4), UINT64_C(0x4103dd9453fde7c0), UINT64_C(0x09f715a0ad6e82ec) }}, {{ UINT64_C(0x18209fbc0899655c), UINT64_C(0xb612753860921a84), UINT64_C(0xa97f6c30d9915548), UINT64_C(0x93867c20b0abd5cc) }}, {{ UINT64_C(0x1528d5b85d14c5b8), UINT64_C(0xe64f6f9034aa7664), UINT64_C(0xf9eca690838a3474), UINT64_C(0x20717a10c19dfc08) }}, {{ UINT64_C(0x2a13fc44b46b5418), UINT64_C(0xe77b171cb495fdac), UINT64_C(0xf38d829c15c31bb0), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x95169298e7953e30), UINT64_C(0x084190c0c5cd3928), UINT64_C(0x74a55fecb0ee6444), UINT64_C(0x84a0b37465da3984) }}, {{ UINT64_C(0x3c7ea3a0214592e0), UINT64_C(0xa0179c348c6949b4), UINT64_C(0x2086b60010b5b398), UINT64_C(0x929259d011cdbc70) }}, {{ UINT64_C(0x7149a998a3c5d1e4), UINT64_C(0x690e04345557aa58), UINT64_C(0xeb1a0b38b4879a14), UINT64_C(0xc4ce83d8729b5a94) }}, {{ UINT64_C(0xf4be4750abdd375c), UINT64_C(0x00c82034243f8060), UINT64_C(0x9fea9a8015b0c098), UINT64_C(0x6529e44c61f64ddc) }}, {{ UINT64_C(0x0f4f2eec6f7ec004), UINT64_C(0xb215ce24fd9b3d8c), UINT64_C(0x07147420200f3280), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3e03138cf02a38f8), UINT64_C(0xafe4f08089a9b124), UINT64_C(0x4eda4be8ed940388), UINT64_C(0xb8c6ec4049db2b4c) }}, {{ UINT64_C(0x3ad77330bbfd4cf0), UINT64_C(0x4229275ccaf65760), UINT64_C(0x235954a07a7bae3c), UINT64_C(0x575d0574a38a3b0c) }}, {{ UINT64_C(0x61ee589831bab220), UINT64_C(0x831a6b74bd531ed0), UINT64_C(0x61b9de64ab7f9770), UINT64_C(0x39bf840026dbcb7c) }}, {{ UINT64_C(0x0859eff8d5c9cce4), UINT64_C(0xdcd8b28c56eca34c), UINT64_C(0xfa577d04d5b7d160), UINT64_C(0xf0e6561881f69b08) }}, {{ UINT64_C(0xe464112c52368918), UINT64_C(0xf5d269a02df451cc), UINT64_C(0x816b24c006696424), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe393f5fc0e413de8), UINT64_C(0x5399c89ca91d12dc), UINT64_C(0x7a0c978811ef3c48), UINT64_C(0x69f11304a236ec38) }}, {{ UINT64_C(0xc6d36f747108d7a0), UINT64_C(0x38e4e1f4df1237e4), UINT64_C(0x66cea5fc4406bc68), UINT64_C(0xe9265a58a409bae8) }}, {{ UINT64_C(0x37f70878b89e4724), UINT64_C(0xb035641487d7a230), UINT64_C(0xc86c7a90cb3e10e4), UINT64_C(0xc64ba2a41a6823a4) }}, {{ UINT64_C(0x8b2f8f04f5af4fa0), UINT64_C(0x0d07ffc06c70da14), UINT64_C(0x5c1f5118a8d8dd08), UINT64_C(0x541d4f488f1f16f8) }}, {{ UINT64_C(0x19777290615a0b38), UINT64_C(0x44e3418c03d771a8), UINT64_C(0xa367151c00d098b0), UINT64_C(0x0000000000000000) }},
};

static const block_t precomputed_constant_linear_part[] = {
  {{ UINT64_C(0x7c1b282f0dc8646b), UINT64_C(0xc2f342290e3d7ea9), UINT64_C(0xd802e401d2796754), UINT64_C(0x00000000809d4042) }}};

static const block_t precomputed_constant_non_linear_part[] = {
  {{ UINT64_C(0x9aee008cd4e350ec), UINT64_C(0x6a0b87cc68ec7230), UINT64_C(0x0da78aec9534a984), UINT64_C(0x8ba8ff5420084828) }}, {{ UINT64_C(0x91f226e8ed21a190), UINT64_C(0x8fc5781870644004), UINT64_C(0x8228858c8a82c538), UINT64_C(0x0471c9bcb5cf1500) }}, {{ UINT64_C(0x75a5457866159910), UINT64_C(0xeea080148003bc84), UINT64_C(0x8823ffe0c0d2cd80), UINT64_C(0x142907e05005e0a0) }}, {{ UINT64_C(0x63b739b4cab63024), UINT64_C(0xe9d8674cbde88b24), UINT64_C(0x4dc5e1b87a207e48), UINT64_C(0x899d4b38073d8f44) }}, {{ UINT64_C(0x12b012a8a29a1644), UINT64_C(0xa56a7504678a2968), UINT64_C(0xbe675164b22d3870), UINT64_C(0x0000000000000000) }}};

static const block_t Z_r[] = {
  {{ UINT64_C(0x8c168b83d381e046), UINT64_C(0xd4886fe7abc8619a), UINT64_C(0x9cc9181db7becc43), UINT64_C(0x69c5d25dbfe767e5) }},
  {{ UINT64_C(0x6faa9a20137a0829), UINT64_C(0x46cca4d347351dae), UINT64_C(0xff987732c6f4e46f), UINT64_C(0x5c8019c46d2f9881) }},
  {{ UINT64_C(0x77dc17b30d3d6a72), UINT64_C(0x5cdb941760eba830), UINT64_C(0xeee34620ef73fa38), UINT64_C(0x9c32c014f5fb584b) }},
  {{ UINT64_C(0x91648482a08b5e01), UINT64_C(0x86cc496229fd4367), UINT64_C(0x07ade13f225da36a), UINT64_C(0x8725dd8d5d7d68e6) }},
  {{ UINT64_C(0xe380f7b514dee7ae), UINT64_C(0x34c2ef0c181c5962), UINT64_C(0xff977cb617d1c2f0), UINT64_C(0xf3c55b0d5b09522b) }},
  {{ UINT64_C(0x71150faeddb22802), UINT64_C(0x8a131c9ab853fa3a), UINT64_C(0x94251f28cb5fef19), UINT64_C(0xc44cfa38a8b1c341) }},
  {{ UINT64_C(0xd031959caeed7178), UINT64_C(0x1a8ac7301fb9d95d), UINT64_C(0xa595624dbbc047cc), UINT64_C(0xe3f260580c33cc26) }},
  {{ UINT64_C(0xcb829bf165c00c7a), UINT64_C(0x022212305e1a31d8), UINT64_C(0x87fdc899aa63cdc1), UINT64_C(0x06d67f1dc9390a7d) }},
  {{ UINT64_C(0xa9ba9288b55129e3), UINT64_C(0x3f8d99fb26fdf63c), UINT64_C(0xda3f26de0faa16f1), UINT64_C(0x04b09898f93e3fea) }},
  {{ UINT64_C(0x94d5748dd81b5653), UINT64_C(0xb7f6d836f740892c), UINT64_C(0x09b3707a531c5757), UINT64_C(0x68ac3ccf137482d2) }},
  {{ UINT64_C(0x2bab20570a99697f), UINT64_C(0xcfc028c3f65a1e1c), UINT64_C(0xb9369eb4e19ca19f), UINT64_C(0xafc2cdcc21d74ec7) }},
  {{ UINT64_C(0x0624772b7a1caf4f), UINT64_C(0x80019104dcf1140b), UINT64_C(0xf3d5fdf83afcf63c), UINT64_C(0x3a77b3a654bdef37) }},
  {{ UINT64_C(0xf364a0fa4bb3a287), UINT64_C(0xb1d5978d2480b264), UINT64_C(0x11d1a28e30dc4382), UINT64_C(0x0be4a2bd5288ca22) }},
  {{ UINT64_C(0x332a73869bb5cb85), UINT64_C(0xe88bdb1f690d8bb1), UINT64_C(0x179b8df65e3cb699), UINT64_C(0x5a5e9a1ce2173227) }},
  {{ UINT64_C(0x518a73fe814b323f), UINT64_C(0x50a1e717232f1b40), UINT64_C(0x3701b36122c60605), UINT64_C(0xe0ec28890132d353) }},
  {{ UINT64_C(0x5c88b8173b0b37db), UINT64_C(0xb1cb511eb971a27d), UINT64_C(0x4854763e177da6b0), UINT64_C(0xc28a51edc4eb1f17) }},
  {{ UINT64_C(0x2f8e3bca42320630), UINT64_C(0x4b242a7184a8272f), UINT64_C(0xe17d5493be3fb9af), UINT64_C(0x7c8caba2b7acbf3d) }},
  {{ UINT64_C(0x83a2fa66f83fcd70), UINT64_C(0xaf2ef2bf55e1da0c), UINT64_C(0xd4fbf9207595845d), UINT64_C(0x67941b90cba052dd) }},
  {{ UINT64_C(0x0c8442548c98def4), UINT64_C(0x324d9168f624a3cf), UINT64_C(0x9605fe9dad053864), UINT64_C(0xb0b52954aac98f5a) }},
  {{ UINT64_C(0x16b2b0072da45097), UINT64_C(0x97ca32b4483773bd), UINT64_C(0xf0b700b70f11e45a), UINT64_C(0x32069f9564e30ddc) }},
  {{ UINT64_C(0x06676a92ff6500f1), UINT64_C(0x9fc6fed91e9ac0f1), UINT64_C(0x27dd8647cece0209), UINT64_C(0x69420d2413c0ae15) }},
  {{ UINT64_C(0xf77eaa5c1636552c), UINT64_C(0xca38c86a9a17339f), UINT64_C(0x052a2dcceab9528a), UINT64_C(0xee31965714fba0e3) }},
  {{ UINT64_C(0x394eac476e9e1166), UINT64_C(0x563e8828c6195406), UINT64_C(0xfc59e28358f96da5), UINT64_C(0x446e6ae05b797e31) }},
  {{ UINT64_C(0x3fdf3029b42b0684), UINT64_C(0xd7a8ae288d5639f5), UINT64_C(0xb7be175b831c69b3), UINT64_C(0x8c5cc1cf6d235a69) }},
  {{ UINT64_C(0x7abd3b4d8aa7a6e4), UINT64_C(0x85edb62a2a634310), UINT64_C(0x1d78d42eb6676bff), UINT64_C(0xf7a8a113cb72f937) }},
  {{ UINT64_C(0xb3f7cae60a85a204), UINT64_C(0x5bef1a599115e829), UINT64_C(0x4b04b7035bec824e), UINT64_C(0x98222282dc3658be) }},
  {{ UINT64_C(0xefa6361b623d3fac), UINT64_C(0xe2ae41b36c7633c9), UINT64_C(0xf876f1bcdc5bd5cf), UINT64_C(0x1778661b8291c79b) }},
  {{ UINT64_C(0x649b8aad53f7de87), UINT64_C(0xc9e1d45e1e15a878), UINT64_C(0x68e6c18afd307b82), UINT64_C(0xc521d9536725711f) }},
  {{ UINT64_C(0xb0d523eee0140689), UINT64_C(0x2745adf99290151c), UINT64_C(0xea947bfda30422ee), UINT64_C(0xd60fc1c29fbb5104) }},
  {{ UINT64_C(0x2de8761fa48233fa), UINT64_C(0x2c787bcb8c1d10f5), UINT64_C(0x2650c16466962388), UINT64_C(0xdafe6c0b183a295e) }},
  {{ UINT64_C(0x1ed1d55068b1c84c), UINT64_C(0x4b91a4819d951c99), UINT64_C(0x833cefc44ef2462f), UINT64_C(0x0b0634c85eb0a1c0) }},
  {{ UINT64_C(0xf72f47d41346551f), UINT64_C(0x16020d0401d329d8), UINT64_C(0x8d84a0565c2dbcb3), UINT64_C(0x1079ff3a53173a71) }},
  {{ UINT64_C(0x64457a6b9685fed3), UINT64_C(0x31521ed37d6328d1), UINT64_C(0x95b4dcacbfffd899), UINT64_C(0xf2b44f259054a991) }},
  {{ UINT64_C(0xb5ef90c74d49d8e5), UINT64_C(0xd88f749337d0b08f), UINT64_C(0xd91a63478952c676), UINT64_C(0x5fda8f084b91ea36) }},
  {{ UINT64_C(0x2c5cb541cd118526), UINT64_C(0x7232382241d2744d), UINT64_C(0x1e8530a19b140f87), UINT64_C(0xe6cbb39b50509fa9) }},
  {{ UINT64_C(0x3d68bf783b7eccd5), UINT64_C(0x3cf0dd8f1e2e8520), UINT64_C(0x3c9defcfab3966c2), UINT64_C(0xa147ecbe71d7e5b8) }},
  {{ UINT64_C(0x5e6e398a7eb62829), UINT64_C(0x52b8a20750378b80), UINT64_C(0xdba682ad80040d1e), UINT64_C(0x7bae60a48a6610c0) }},
  {{ UINT64_C(0xa4ab459b1a111030), UINT64_C(0x5340613f06e396b4), UINT64_C(0x736540e63063d2b1), UINT64_C(0x4920d4e312026e8d) }},
  {{ UINT64_C(0xbfc4abd3c22f2f0e), UINT64_C(0x5c3e624d208ca0c1), UINT64_C(0xef330dcff3e0d6d0), UINT64_C(0x6a782f48558d9a7e) }},
  {{ UINT64_C(0x9e7a423261fe1858), UINT64_C(0x9a64ddcff1e72255), UINT64_C(0x49dbbba8d85ea7d6), UINT64_C(0xfe4a6ca091478a82) }},
  {{ UINT64_C(0x735d0965b60dc947), UINT64_C(0x07c0f16ea1082bc1), UINT64_C(0x92fdf24b76a89a8b), UINT64_C(0x95b39e22968639e2) }},
  {{ UINT64_C(0xea534327d495fe8e), UINT64_C(0x0afb6da724c09f52), UINT64_C(0x9d64ab67a331ef3c), UINT64_C(0xa2c8d4bf37a13fea) }},
  {{ UINT64_C(0x042f08ca246c11b5), UINT64_C(0xfb94383ca671700d), UINT64_C(0x65fd2af94c05680d), UINT64_C(0x64484c5d52129341) }},
  {{ UINT64_C(0x1df24faafc81e683), UINT64_C(0xf8639a3cc092f4e7), UINT64_C(0xd1a111799c03e3a2), UINT64_C(0x3eb3c4c2c09c5721) }},
  {{ UINT64_C(0x5f3c148f378cfd92), UINT64_C(0x156237dbf30b3edc), UINT64_C(0x5c925ad15bb2ec8e), UINT64_C(0x399397ca2b5a419c) }},
  {{ UINT64_C(0x2362c375369b5d89), UINT64_C(0x13d0ed14f022586a), UINT64_C(0x7788c26f581e2975), UINT64_C(0x58ad1b04485b3e3c) }},
  {{ UINT64_C(0xff37e8bf24a1cc6c), UINT64_C(0x211412112272ce07), UINT64_C(0x69ebbaf7d85a5bc6), UINT64_C(0x8eeaeadda92ba002) }},
  {{ UINT64_C(0xcf6571d37765e701), UINT64_C(0x9fce7158e11e51ae), UINT64_C(0xaa2530b7a4b27f98), UINT64_C(0x6eaaba79c266bac9) }},
  {{ UINT64_C(0x5959c1a07c1a4f36), UINT64_C(0xfa41a9332caf4eb8), UINT64_C(0x44886a07b73cfc5e), UINT64_C(0x72a59a95de902843) }},
  {{ UINT64_C(0x46cfb9fca81fe3f6), UINT64_C(0x84a8c4d5ca8ce393), UINT64_C(0x410f86b6dc6f02d3), UINT64_C(0x63a75ae01597c843) }},
  {{ UINT64_C(0x817d9cf3ef3b1bda), UINT64_C(0x7212c340e0b3255e), UINT64_C(0x9482cefd5cb8b5a3), UINT64_C(0x9885348d389e4e92) }},
  {{ UINT64_C(0x88be94c3c8543704), UINT64_C(0x17504065ed07cf3d), UINT64_C(0xdaaab0224b607afa), UINT64_C(0xdc5774878bda3cbd) }},
  {{ UINT64_C(0x0914e275a05c13f3), UINT64_C(0x4aebaacf838c25f8), UINT64_C(0xb5f54d8e77bb4c8d), UINT64_C(0xb0c0159aa5b2454c) }},
  {{ UINT64_C(0x40d6f9614769342d), UINT64_C(0x3614b42467eaab8d), UINT64_C(0xdeaa0adea1f0ae3b), UINT64_C(0xbf6d61282c6df319) }},
  {{ UINT64_C(0x298c52ad65c97b93), UINT64_C(0x7901ba55396a7e5b), UINT64_C(0x5ce4e22325f3af2f), UINT64_C(0x05a1bda7ab08c338) }},
  {{ UINT64_C(0x2a4854031c5377ec), UINT64_C(0x9f2b23dbbd08ebcf), UINT64_C(0x15bc721af1095165), UINT64_C(0x64cbf05d19583b9e) }},
  {{ UINT64_C(0x46a014b1a1dd1d38), UINT64_C(0xe7ccda7cd695cd3a), UINT64_C(0x5522c58db62cf279), UINT64_C(0xb16918afd8c9ac28) }},
  {{ UINT64_C(0x07fdbd30c1b43bb4), UINT64_C(0xc423ee581b3968c5), UINT64_C(0xfcddb494ff95243b), UINT64_C(0xff25a3dfec5f13f5) }},
  {{ UINT64_C(0xf959fa6e1606a932), UINT64_C(0xe36cbd2b6b94c38f), UINT64_C(0xb2b609b525d19c33), UINT64_C(0x95ffac0d5623c4ff) }},
  {{ UINT64_C(0xaa689a39a69841ce), UINT64_C(0x143b1c45a77acab5), UINT64_C(0x779095e288128e64), UINT64_C(0x34b5edac47d3c2c8) }},
  {{ UINT64_C(0x45788e5660d89452), UINT64_C(0xe9026ce0c8485bf5), UINT64_C(0xfc9dc50f4492ec0d), UINT64_C(0x1ff67ce80ca287d6) }},
  {{ UINT64_C(0x452588f1ca0b58a9), UINT64_C(0xb544022aa52340a0), UINT64_C(0x34ffda49cc49c838), UINT64_C(0x079332986da2a585) }},
  {{ UINT64_C(0x303c58f4097e4b91), UINT64_C(0x7aaab134b87d4f07), UINT64_C(0x4c876344e16e6389), UINT64_C(0x6e785a8bfe526fab) }},
  {{ UINT64_C(0xede6efff82c18d18), UINT64_C(0x777c658324ac7bf5), UINT64_C(0xf406d4115c9da257), UINT64_C(0xd9571fa9f2827599) }},
  {{ UINT64_C(0x0e400677307d9e41), UINT64_C(0x5268817ef9d99ca0), UINT64_C(0xad76494c721c3886), UINT64_C(0x76803df541c05e9a) }},
  {{ UINT64_C(0x73964b6a94f602cc), UINT64_C(0xe7da14f026dd8f4b), UINT64_C(0x19238e6c953040ee), UINT64_C(0xc575ca5e562dd669) }},
  {{ UINT64_C(0xc4faf147d5956992), UINT64_C(0x3b0cd803f5de9150), UINT64_C(0x309ba61997f8a7a5), UINT64_C(0x9f158badbc3150a5) }},
  {{ UINT64_C(0x5062a1fe91390d0c), UINT64_C(0x22f022ca5cc66600), UINT64_C(0x6ff2440bf54b9a09), UINT64_C(0xddde0c7d89292db0) }},
  {{ UINT64_C(0x73c55e7f774a1d99), UINT64_C(0x202d160b7814a299), UINT64_C(0x4df76055451459f5), UINT64_C(0x7c0645e72fc2a51d) }},
  {{ UINT64_C(0x84ea26c5def9ac2f), UINT64_C(0xa6ec409f6f401259), UINT64_C(0x0a21828d00a43d2a), UINT64_C(0xaf0735d9f6833b3e) }},
  {{ UINT64_C(0x906d16a426cac572), UINT64_C(0xc3ac689f8dd1b6a2), UINT64_C(0x7c7b818a44145b02), UINT64_C(0xb6a76c71128f6089) }},
  {{ UINT64_C(0x23c8bf06c79e4729), UINT64_C(0x94869e012ca9c1b0), UINT64_C(0xe5644b7e460d1348), UINT64_C(0x9337291e0b9b8d62) }},
  {{ UINT64_C(0x0bfdfbcf6d0a7163), UINT64_C(0x3715e72c6a55a2ea), UINT64_C(0x31ed92f3c0c609a2), UINT64_C(0xdac635ee63d77d44) }},
  {{ UINT64_C(0x270ee11915e4c66e), UINT64_C(0x1f9a890631a94232), UINT64_C(0x96f6b848ff774df3), UINT64_C(0xdd747e26f2ad7ce6) }},
  {{ UINT64_C(0x61d409d1aa487207), UINT64_C(0xdc11b3e97038f5f8), UINT64_C(0x4e0073f6060bb087), UINT64_C(0xa2e4ace6892378bd) }},
  {{ UINT64_C(0x6e83d637db95fd8c), UINT64_C(0x70115b1dcbb964ed), UINT64_C(0x5f14f908473cfebc), UINT64_C(0xf30750e6121a005f) }},
  {{ UINT64_C(0x601902adbad5844e), UINT64_C(0x9cb91aa657a4eb4b), UINT64_C(0x5034b1749e7d6701), UINT64_C(0xf155f0c093d50a74) }},
  {{ UINT64_C(0xd0efc12b624bc11f), UINT64_C(0x63f231dc32cdd463), UINT64_C(0xe2f91ca532219279), UINT64_C(0xb6df451f0b3b5547) }},
  {{ UINT64_C(0x6165a5bce3a11e0c), UINT64_C(0x676f67156c2e61e7), UINT64_C(0x548ae02159bec424), UINT64_C(0x493a500cab53389e) }},
  {{ UINT64_C(0xf727333577ad8624), UINT64_C(0x0e2c61d6144dc368), UINT64_C(0x1eb56b805d567cb0), UINT64_C(0x66aef74224312145) }},
  {{ UINT64_C(0xec3f51cda404fa48), UINT64_C(0x36d1b74f37160ad6), UINT64_C(0xc0a345f302c2db05), UINT64_C(0x3a5bc3e786781c11) }},
  {{ UINT64_C(0xa36d307d615c2533), UINT64_C(0xe691dd6b872413f2), UINT64_C(0x3530172e31e231f4), UINT64_C(0x78fc815f74b9b99d) }},
  {{ UINT64_C(0xf275002a8ea1dec6), UINT64_C(0xcd3e80c8e8505aa9), UINT64_C(0x7a27384769784547), UINT64_C(0x804d7d98490414c6) }},
  {{ UINT64_C(0x0c3e67dc828644b4), UINT64_C(0xad216a2a0a81b4b5), UINT64_C(0x6a2e48b11236340a), UINT64_C(0x9247ae9bc3a96fb0) }},
  {{ UINT64_C(0x4cecb3223829ed4e), UINT64_C(0xd1c42dfb38628520), UINT64_C(0x6e36b4bc02bc3fe7), UINT64_C(0xe981bf8be4abf474) }},
  {{ UINT64_C(0x4cfeb78949b713a4), UINT64_C(0xe1b067d230626cdd), UINT64_C(0x64d352a6d33018a1), UINT64_C(0x3dd7525734ab8ff8) }},
  {{ UINT64_C(0x941dc562c141f467), UINT64_C(0x00dfbe4f8e737975), UINT64_C(0x043b63e4221fd2ae), UINT64_C(0x4d80b32a970f25ad) }},
  {{ UINT64_C(0x90e2f6c0de4157c4), UINT64_C(0x7275c48f6fdf3085), UINT64_C(0x5cc323db1f965ea7), UINT64_C(0x5079f2c113fa6656) }},
  {{ UINT64_C(0x1d9442f59ccd18a6), UINT64_C(0x753ceffc680f8de4), UINT64_C(0x553da3e82644054b), UINT64_C(0x678fe73f9ae9074d) }},
  {{ UINT64_C(0x9246c661ec3eab5d), UINT64_C(0x55b86917287a311e), UINT64_C(0xeba0c98bbb5bd5a1), UINT64_C(0x2a087813d24da447) }},
  {{ UINT64_C(0x2202e66a76d12b12), UINT64_C(0x0cc44fe95ac4594c), UINT64_C(0xa1fdc81f704e09a6), UINT64_C(0x4e61f06f737dfac1) }},
  {{ UINT64_C(0xdce31082497aeca1), UINT64_C(0xdc21e22eba4a70cd), UINT64_C(0xb8f5f5a1bcc258f1), UINT64_C(0x4d95ee20f10fbaa5) }},
  {{ UINT64_C(0x6a461b8d84876393), UINT64_C(0xaa11461292b1ea08), UINT64_C(0xa1bb907b8c639abe), UINT64_C(0xce98ec67eb30250f) }},
  {{ UINT64_C(0x6b58747dee1aa803), UINT64_C(0xb35223b1455b4f36), UINT64_C(0x34614f87215b028c), UINT64_C(0x321e6e04718832d1) }},
  {{ UINT64_C(0xa66a5e375b93112c), UINT64_C(0x3b7104ff72398f03), UINT64_C(0x30f55db7934b504e), UINT64_C(0x8a7633929fe1cbb6) }},
  {{ UINT64_C(0x4cca73fcfd9ed5fb), UINT64_C(0x42a572ea425b7d5d), UINT64_C(0x9906dc0a0ea8c123), UINT64_C(0xddf962c65c67952c) }},
  {{ UINT64_C(0x3728565c172b2abd), UINT64_C(0x800756d66a6b5b76), UINT64_C(0x452c93d7fb396189), UINT64_C(0xdbbc4fe9f73e4acd) }},
  {{ UINT64_C(0x08705f2d9019cb2f), UINT64_C(0x1e12e219f917a37a), UINT64_C(0x0f7176a56bdbe39c), UINT64_C(0x04ef0b94c2805ce8) }},
  {{ UINT64_C(0xd890d5bd013c3484), UINT64_C(0xc8243485d5ae6de4), UINT64_C(0xd481de539d4e8496), UINT64_C(0x11d9e6c185a230dc) }},
  {{ UINT64_C(0x238748d2aa727579), UINT64_C(0xd6093e5f499589e6), UINT64_C(0x9a6e4a48ed2bd753), UINT64_C(0x53af6c68d11c9229) }},
  {{ UINT64_C(0x366d87fe69efeb84), UINT64_C(0xeb9f0a271ccf6f07), UINT64_C(0xa8f3ae7458a947ec), UINT64_C(0x3fe4843363083a8a) }},
  {{ UINT64_C(0x362005aadf4145a8), UINT64_C(0x7aebcdd73038620b), UINT64_C(0x5272d9e15085fb6e), UINT64_C(0x64175ab0971da265) }},
  {{ UINT64_C(0xb9baf5870da24978), UINT64_C(0xf0a09ce9c1a80164), UINT64_C(0x33ae201bd3bd8cef), UINT64_C(0x0252567380aa2630) }},
  {{ UINT64_C(0xa8ad94b9b8f97526), UINT64_C(0x7bb0a968b0e044c1), UINT64_C(0xd61d74886130e93c), UINT64_C(0xafe233551b9dade3) }},
  {{ UINT64_C(0xc4e27f24a749a083), UINT64_C(0xfafea1985fe4fa11), UINT64_C(0x7664b56df4497581), UINT64_C(0x51825b4c5406a83a) }},
  {{ UINT64_C(0xd078b417f4717268), UINT64_C(0xbc067982372701a4), UINT64_C(0x31ebf16c493a71a6), UINT64_C(0x84ab14bc61ebafc4) }},
  {{ UINT64_C(0x35a2123eacc6580a), UINT64_C(0x4e493ddf54e3ce90), UINT64_C(0x28efe0d21454b012), UINT64_C(0x35874da8d0ea5e0a) }},
  {{ UINT64_C(0x4c7655aceec41bee), UINT64_C(0xe3aefec056c8c243), UINT64_C(0xbe54d811bafdb3d9), UINT64_C(0xe48ecb60fbb6621d) }},
  {{ UINT64_C(0x951eb68526c42c58), UINT64_C(0xe07ee47a4d281c71), UINT64_C(0xcef0bbf233843e6b), UINT64_C(0x6fc8a4b0e69996f4) }},
  {{ UINT64_C(0x2e28460a22b60ab2), UINT64_C(0x9abfa1cdbf843819), UINT64_C(0x7596c0f338ec8a0b), UINT64_C(0xb979b3b845d42173) }},
  {{ UINT64_C(0x3faac57acb0391c4), UINT64_C(0xc9a2cb289646786f), UINT64_C(0x555eafb57b932d15), UINT64_C(0xa0bc4dfd895f8a1d) }},
  {{ UINT64_C(0x883beaaf142bf996), UINT64_C(0xc319eff3e2b485da), UINT64_C(0x718ba4acd83e6be0), UINT64_C(0xba5232052d5d7b6c) }},
  {{ UINT64_C(0x600680f88b8bd648), UINT64_C(0x73936880918f4d60), UINT64_C(0xe4e4d72db0bce798), UINT64_C(0x92b30c5d94056a10) }},
  {{ UINT64_C(0x9b4e72aea6e848d1), UINT64_C(0x5bd20a4dde5541c1), UINT64_C(0x981f76fbec8b469a), UINT64_C(0x0b8fda786c6cecad) }},
  {{ UINT64_C(0x00cefc00aa3a9336), UINT64_C(0x2d2fd510b217b8c5), UINT64_C(0xb1b1c6f5a11bc835), UINT64_C(0x93402c7f52225cd4) }},
  {{ UINT64_C(0xa96486addb6db65c), UINT64_C(0xa38071cb3b51e18e), UINT64_C(0x47acaf40ba3baf57), UINT64_C(0x883c8049fdd7608c) }},
  {{ UINT64_C(0xd5ccd1a74eeb5833), UINT64_C(0x682c9e8605680d99), UINT64_C(0x078f1c0f0ef01525), UINT64_C(0x8f94d67246e58ef7) }},
  {{ UINT64_C(0x1e9212ceff208980), UINT64_C(0x4404f8be76f66050), UINT64_C(0xe0a1fc965ead5e50), UINT64_C(0x41caa86afa6955bd) }},
  {{ UINT64_C(0xe42868ed3d231b45), UINT64_C(0xc98583e3f7942e3b), UINT64_C(0x8bfc37a9d602fa02), UINT64_C(0x289bc401a767b9e3) }},
  {{ UINT64_C(0x5cf26854ea785405), UINT64_C(0xae0e857e4b18f254), UINT64_C(0x662fe23270fc4c64), UINT64_C(0x44745190f52d5db3) }},
  {{ UINT64_C(0xb69341feceb831a9), UINT64_C(0x744cf002c1cdc293), UINT64_C(0x9f340f2ce08778b4), UINT64_C(0xb27297eb691b1bab) }},
  {{ UINT64_C(0x863b27206a6009b5), UINT64_C(0xa238fd0858468b40), UINT64_C(0x1a79c9ca1c421469), UINT64_C(0xeeef8afe994a6487) }},
  {{ UINT64_C(0x69dc2917f4a4ac49), UINT64_C(0x89a58b828370fa8b), UINT64_C(0x797e9801e8e47726), UINT64_C(0x028b082994e5904b) }},
  {{ UINT64_C(0xc653478bbdbd9451), UINT64_C(0xd7fa53d5fab4d015), UINT64_C(0x61d008d930c236ad), UINT64_C(0xcbf9aa6d59234954) }},
  {{ UINT64_C(0x37258def3dd94559), UINT64_C(0x53dc3a33be97a5cb), UINT64_C(0xb4ffa6d156e02cb9), UINT64_C(0x2fd86d47c23b8e05) }},
  {{ UINT64_C(0xfd6bef5fc489b7f9), UINT64_C(0xe3bf8b453a1b2fbe), UINT64_C(0x20ed31664fbe6ed4), UINT64_C(0xbf5dedab51e9678a) }},
  {{ UINT64_C(0x18b6d26be3ee0fc2), UINT64_C(0x89c195275188ff2a), UINT64_C(0x1a58b8bb4730b84f), UINT64_C(0x23d978729e57b712) }},
  {{ UINT64_C(0x527a46c55414dc67), UINT64_C(0x3da81596b989a2bf), UINT64_C(0xc5ba217b8f6f4d88), UINT64_C(0xabc25cd15ad96260) }},
  {{ UINT64_C(0x82e9b2eac4281747), UINT64_C(0xeb86b44b374248e9), UINT64_C(0x976edccaa02b3c36), UINT64_C(0x4b6bbf38c1496e38) }},
  {{ UINT64_C(0xb729a696de9c45a3), UINT64_C(0x3e371017008fc086), UINT64_C(0xd2df328d6494bbf3), UINT64_C(0x56e4345173a602b2) }},
  {{ UINT64_C(0x9f5071fea51e848b), UINT64_C(0x24939fbb22d4846d), UINT64_C(0x389b1c9b873c82ca), UINT64_C(0x73f5925e8a0c2421) }},
  {{ UINT64_C(0x0a00326c66cc4f84), UINT64_C(0xa219aab8bf8ece26), UINT64_C(0xb27a98c000cc26c3), UINT64_C(0x6665b99fab6deaec) }},
  {{ UINT64_C(0x99f72c134ee876e0), UINT64_C(0x587945619faa3fb3), UINT64_C(0x4c3606013a1fc904), UINT64_C(0xb9fe7f7a3b52f116) }},
  {{ UINT64_C(0xdf0cfa577c44b42d), UINT64_C(0x84b3e501099ca581), UINT64_C(0xc2a6638a36a08d07), UINT64_C(0x4633f9e1e0c43533) }},
  {{ UINT64_C(0xfcec261a4ed531e2), UINT64_C(0xa10f1026e4d6dea0), UINT64_C(0x95b333d9f4f49f60), UINT64_C(0x5647689a7bf893c3) }},
  {{ UINT64_C(0x8dd6e44cd9b0475c), UINT64_C(0x58e771ff8f0f0bca), UINT64_C(0x4825b8bc8ae3c562), UINT64_C(0xc5f10af9e52e3b03) }},
  {{ UINT64_C(0xaa1e183e70da8c4c), UINT64_C(0x44a9e12ff5e26a48), UINT64_C(0xc8a81f54e0a440b0), UINT64_C(0x6be8cc338f56a374) }},
  {{ UINT64_C(0x6ab6d64aa4369142), UINT64_C(0xe93628992739a54c), UINT64_C(0x49ff777f39c0de24), UINT64_C(0xc279fa76aa8397fd) }},
  {{ UINT64_C(0x5964e6e72029be4f), UINT64_C(0xd23df20ee7e113d8), UINT64_C(0x63486df53edc17d5), UINT64_C(0x476e5a478a82e17b) }},
  {{ UINT64_C(0x1fa06b72ea5bb804), UINT64_C(0x901c45ad9f310f0d), UINT64_C(0x7d93e218f8537c22), UINT64_C(0xf49acd346a1b5e48) }},
  {{ UINT64_C(0x89bf46a0913166c1), UINT64_C(0x016901a7f8016fbd), UINT64_C(0xa4b3ae68a419cc2d), UINT64_C(0x14d59d6664676387) }},
  {{ UINT64_C(0xc22068b2c5ed6381), UINT64_C(0x996b47f91a531943), UINT64_C(0x81521b983ce470dd), UINT64_C(0x8c0fb709b8568728) }},
  {{ UINT64_C(0x65d6c702ab675d85), UINT64_C(0x3c3bb8cd5a166d94), UINT64_C(0x9965c50aad67bf51), UINT64_C(0x78d31988be19744a) }},
  {{ UINT64_C(0xf33b3a7f1734009e), UINT64_C(0xec14ad82e61d278f), UINT64_C(0xdf12f6a239ccc80a), UINT64_C(0xd006728a4aa9d984) }},
  {{ UINT64_C(0xbcd5f07fde356e9a), UINT64_C(0xc406dab7a6c01ad5), UINT64_C(0x2972e5662a42aa8a), UINT64_C(0xb3e62020263f6935) }},
  {{ UINT64_C(0x2844c98e1e94d152), UINT64_C(0x6bcb2f334ad17328), UINT64_C(0x1085d7a4d3d2f7fd), UINT64_C(0x21e8985fdfe4ea4f) }},
  {{ UINT64_C(0x5f46b3534112a8b4), UINT64_C(0x462fdcd2b338922e), UINT64_C(0x8b83dfc8d651f6df), UINT64_C(0x42815c56cb007813) }},
  {{ UINT64_C(0x0c02c91931be25b8), UINT64_C(0xde5a7810e227564d), UINT64_C(0xc5e94bdd49dd00fa), UINT64_C(0xab21206407231d97) }},
  {{ UINT64_C(0xe4a69c4b4f8ffbf7), UINT64_C(0xe95e903a86b13d5b), UINT64_C(0x3de7e41da5c4aecd), UINT64_C(0xbe3349b38e0e57e6) }},
  {{ UINT64_C(0xb83ecec6d1bc8e93), UINT64_C(0x76d868abebfd7846), UINT64_C(0xf82502066535d381), UINT64_C(0x1fa105ea7a7b4e8c) }},
  {{ UINT64_C(0xbabc1a8bb59c7475), UINT64_C(0x874c8fe48d5d2131), UINT64_C(0x7a1415f1fed2b94c), UINT64_C(0x74377ec3f2deda25) }},
  {{ UINT64_C(0xfcedc5a9b1cf0f33), UINT64_C(0x9048092617040ffd), UINT64_C(0x9d4fd2afd5809566), UINT64_C(0x742a4049488b3393) }},
  {{ UINT64_C(0x9e20970ac6917433), UINT64_C(0x80847bbd8f4d9543), UINT64_C(0x0d21f074014c4b22), UINT64_C(0x9998432471782abd) }},
  {{ UINT64_C(0xd5a765754fbf69e9), UINT64_C(0xe19afc894cee2755), UINT64_C(0xc78a7358980bbaa4), UINT64_C(0xa550ee350f2047b1) }},
  {{ UINT64_C(0x4c5915931f497a01), UINT64_C(0x90750d88bb95b931), UINT64_C(0x53ac88b8f22df33b), UINT64_C(0xcd4dc546afe74134) }},
  {{ UINT64_C(0xfbb8737b38f2e845), UINT64_C(0x258be049beef3c25), UINT64_C(0x247c7b812b27bd47), UINT64_C(0x245b3630253959fd) }},
  {{ UINT64_C(0x491db4a2bc1ccbc1), UINT64_C(0xc5c0b28f57292c9d), UINT64_C(0x05384ceb0933d8d6), UINT64_C(0x7516cd13ec3f8e38) }},
  {{ UINT64_C(0xdc020452f1e503f1), UINT64_C(0xb632ae17aad87b24), UINT64_C(0x27cc054d3f21f096), UINT64_C(0xcfbe2223e86c2046) }},
  {{ UINT64_C(0x4e70d3a6d45823c2), UINT64_C(0x35a068a40c5823b2), UINT64_C(0xf2684787f4eef798), UINT64_C(0x04f97696009f1c82) }},
  {{ UINT64_C(0x03b97f6e29f6c2f4), UINT64_C(0x97060028b9233437), UINT64_C(0x3c24595bce11d0e9), UINT64_C(0x43d914c0e360aebe) }},
  {{ UINT64_C(0x2212a814628fb7b4), UINT64_C(0x131a4cf63ff3f3df), UINT64_C(0x0fb1027d223f1062), UINT64_C(0x7c3a9626e82d79bf) }},
  {{ UINT64_C(0x046e922371a990ff), UINT64_C(0x30ce3ee36f96e00d), UINT64_C(0x0e9ab8c5d9a483b8), UINT64_C(0x11759cc008abb323) }},
  {{ UINT64_C(0x2c384935222a46a8), UINT64_C(0x97fce74489a1a29b), UINT64_C(0xef826c35f484d315), UINT64_C(0x855240fa39127c92) }},
  {{ UINT64_C(0xb1dac135b0cd17ce), UINT64_C(0x85c6e304b9e317bd), UINT64_C(0x04112076d6a2f84b), UINT64_C(0xb9bc1899a815790d) }},
  {{ UINT64_C(0x8363a552f5113c02), UINT64_C(0x02a1c8db0e8e7698), UINT64_C(0x0cc78a52617649c4), UINT64_C(0xc2acca8ae13a5b0f) }},
  {{ UINT64_C(0x8e5367e678be4802), UINT64_C(0xeb0dc48bbf46c6a5), UINT64_C(0x040ba83e26e069c4), UINT64_C(0xda0bf5ee092330dc) }},
  {{ UINT64_C(0x976defb8244ccc50), UINT64_C(0x409722e39ee8693e), UINT64_C(0x401257a0cbf747d1), UINT64_C(0x5916e15c639dd96b) }},
  {{ UINT64_C(0x061d36f1a9b831be), UINT64_C(0x32d6bd681876acc8), UINT64_C(0xc57ab52e625f41dd), UINT64_C(0x50038ad095239ab4) }},
  {{ UINT64_C(0xb6537331fd7d15f1), UINT64_C(0x69349fb4786ce42a), UINT64_C(0x41bd3816145e6dec), UINT64_C(0x1de5963deccc1979) }},
  {{ UINT64_C(0xb8714235b98467f8), UINT64_C(0x69572d926e1c575b), UINT64_C(0xc1cd3ab75529cfda), UINT64_C(0x89321b546f9a4e77) }},
  {{ UINT64_C(0xb9fe78b79245397b), UINT64_C(0x6d4a7b62a4f9901b), UINT64_C(0x10fa5b536a8e7fe2), UINT64_C(0x57d54f05f7cd7cb7) }},
  {{ UINT64_C(0x9f0bdc5d8a7dd6ea), UINT64_C(0x6aed42fbb8db1f49), UINT64_C(0xb9ee24ba428edd9e), UINT64_C(0xd74cb8ea474bd970) }},
  {{ UINT64_C(0x9e71c393ef9993d7), UINT64_C(0x8ccbb6dde5f7d993), UINT64_C(0x82c7716924ba5146), UINT64_C(0x455f1f3b493a4295) }},
  {{ UINT64_C(0x8ee191392f6f409c), UINT64_C(0xf64fa24cf90a7d58), UINT64_C(0x81cc1485c7e27827), UINT64_C(0xf6325501aa262ffb) }},
  {{ UINT64_C(0xeb150c30dcc9a219), UINT64_C(0x49281448898b8dde), UINT64_C(0x1655325bc5b55f92), UINT64_C(0xa3173e8c7ca84e56) }},
  {{ UINT64_C(0x964d860ca038565c), UINT64_C(0x69ebe0c5d6073ab3), UINT64_C(0xf41994ab2d2bc68c), UINT64_C(0xe3e01667c97adcb0) }},
  {{ UINT64_C(0x479211745a6900a8), UINT64_C(0x474bb08a67495020), UINT64_C(0x9fec8d23bbc69294), UINT64_C(0x667bc83a38b64f9e) }},
  {{ UINT64_C(0xf026c0bd7fe3134f), UINT64_C(0xc0ae7a93e66cd560), UINT64_C(0x1e197845d06772d6), UINT64_C(0x911eb0e21e0c1fc1) }},
  {{ UINT64_C(0xbb1eb7f8973c4772), UINT64_C(0x77d2d5cdfa9112f7), UINT64_C(0xa96140483ceec54a), UINT64_C(0x85c2f91acb93c79c) }},
  {{ UINT64_C(0x1d16ea68c4c41850), UINT64_C(0x26a6b39da4fc3bbe), UINT64_C(0xee057f2de038a844), UINT64_C(0xd22a4c1d336ca34c) }},
  {{ UINT64_C(0x7f5696d4ecca055a), UINT64_C(0x630d361b772d7949), UINT64_C(0x96603e5e4c814bbd), UINT64_C(0x4c1c032b692e946c) }},
  {{ UINT64_C(0x5d3166628239cb3c), UINT64_C(0xaf51e9d38ec53030), UINT64_C(0x0d8a8f6c79f0eb2e), UINT64_C(0x2f3f533f776db8d8) }},
  {{ UINT64_C(0x2c74ddb528928475), UINT64_C(0x3efe7cb9e95d6edc), UINT64_C(0xfab4226e286d9724), UINT64_C(0x439282dd0b519643) }},
  {{ UINT64_C(0xb7552071937b79f9), UINT64_C(0x18def3f885b4fccf), UINT64_C(0xcfd0f7c5c2771c55), UINT64_C(0xf5a32c2b5f176c9e) }},
  {{ UINT64_C(0x2a7e2ccd295a0857), UINT64_C(0xa894f813eb2863ea), UINT64_C(0xbdc0e64084f04e9e), UINT64_C(0x92c4f08358c04754) }},
  {{ UINT64_C(0x42c5a606c7a77caa), UINT64_C(0x27170c96b635e2f9), UINT64_C(0xd6acaa59ffc5aff1), UINT64_C(0x29464f7c2a11a911) }},
  {{ UINT64_C(0xe79652a457510640), UINT64_C(0x43751e6f607d0be8), UINT64_C(0x6a67e8596e656cb4), UINT64_C(0x37bce91328d975a8) }},
  {{ UINT64_C(0xc3227ea7356dfb68), UINT64_C(0x14397c05ca9415e5), UINT64_C(0x2b9cac6fd70fe965), UINT64_C(0x05452ac853e48a5b) }},
  {{ UINT64_C(0xf0a46d8de13bef50), UINT64_C(0xefc825e11b48b04c), UINT64_C(0xe17abf23d276abe3), UINT64_C(0x97d72e21d8cb206e) }},
  {{ UINT64_C(0x3f7bc89ed7c1e9f9), UINT64_C(0xef3205f1b09a3d6a), UINT64_C(0x8a567abee89cf362), UINT64_C(0x91b9bfbdfccd05a5) }},
  {{ UINT64_C(0xe2fde4cb2952d4f6), UINT64_C(0x2746aff3377c8e2b), UINT64_C(0xee0da192f5adc76c), UINT64_C(0x7c2c108fbdcb4005) }},
  {{ UINT64_C(0x2991b2eba769dde4), UINT64_C(0xcf89fc3c8a341d86), UINT64_C(0xa396f701e8f2d4e1), UINT64_C(0x16ca9a6c70c83248) }},
  {{ UINT64_C(0xdf56dc044c48f1f4), UINT64_C(0xf7176f6b9e937286), UINT64_C(0x4a212a4152748e14), UINT64_C(0x2735ec5c125ae7a2) }},
  {{ UINT64_C(0x31fef79919a28ab0), UINT64_C(0x35c96e9dcabdb52f), UINT64_C(0x88cacb98776b9dba), UINT64_C(0xc217e8b0cad1f4b8) }},
  {{ UINT64_C(0xe21b58bd715be281), UINT64_C(0x14f76807a3c6ee0a), UINT64_C(0xaf4b0fc45314c60c), UINT64_C(0x8dc315e2c0c28bae) }},
  {{ UINT64_C(0xe136c2c7eb488a0f), UINT64_C(0xcd169f714f0de2e6), UINT64_C(0xe06d62d2e9bc98e8), UINT64_C(0xd3d8c238289088a0) }},
  {{ UINT64_C(0x7db237e5771bb6c8), UINT64_C(0x53401da1b85c6832), UINT64_C(0x15237bbf2e75b082), UINT64_C(0x67fdf3c8c8b30e9e) }},
  {{ UINT64_C(0xfb1a9ff5e9fc7836), UINT64_C(0x36ff53663a641196), UINT64_C(0x1483715599f108b4), UINT64_C(0xf833813fe8652abc) }},
  {{ UINT64_C(0x7f50be6c6738a2ff), UINT64_C(0xc916dea253d179c9), UINT64_C(0xa2596d2522ccd8b7), UINT64_C(0xc1c0b22e9dcde224) }},
  {{ UINT64_C(0x1766ec18851d5dac), UINT64_C(0x83a571d00a764b75), UINT64_C(0xbff7723616325203), UINT64_C(0x2f48416d8583a70c) }},
  {{ UINT64_C(0xddfdc11e6e1048af), UINT64_C(0x920148512d8ae546), UINT64_C(0xd35f9cc086c8366b), UINT64_C(0xbcb81e5dd4978eb7) }},
  {{ UINT64_C(0x9b41cbf229f63fb1), UINT64_C(0x3cf4fb1c5910e7dd), UINT64_C(0x1abf21c305dc12aa), UINT64_C(0x9f4c35dad80bbb8f) }},
  {{ UINT64_C(0x2668c1a34950fe09), UINT64_C(0xeb2977eab38840f4), UINT64_C(0x40a254d89fc21029), UINT64_C(0x730fd1243aba264f) }},
  {{ UINT64_C(0xf69d933529e29446), UINT64_C(0xcd0439ec225108d0), UINT64_C(0x161cef76de2d1d42), UINT64_C(0x8a500bc1c6c3598f) }},
  {{ UINT64_C(0x0f9c50913784cbeb), UINT64_C(0x1d9972c5d8df3eab), UINT64_C(0xdea6d1eb2b5af3a8), UINT64_C(0xe5deebf75393e233) }},
  {{ UINT64_C(0xaf7b29ae81809bda), UINT64_C(0x5a7a7e5c54a2e7ef), UINT64_C(0x0e832b97f9b81975), UINT64_C(0x742306f60ac995bb) }},
  {{ UINT64_C(0xca7b235c584d9f02), UINT64_C(0xab3498ce7a1927f5), UINT64_C(0x2f478002da63e469), UINT64_C(0xd3baeedd4fa6b392) }},
  {{ UINT64_C(0x800e1786d91a97e5), UINT64_C(0xa5eb7b08d74d31e2), UINT64_C(0x07271b12e00b5558), UINT64_C(0xb9dac9000a4ecad1) }},
  {{ UINT64_C(0x9f7dae4d3554705f), UINT64_C(0x75ca66c0b15f4a61), UINT64_C(0xda0853c97f2bed3d), UINT64_C(0xdea3a5545f2839e0) }},
  {{ UINT64_C(0x3d8c55cea439097e), UINT64_C(0x360e65e2874be6e3), UINT64_C(0xf25609750649f0d5), UINT64_C(0x35ae70715c1c87ab) }},
  {{ UINT64_C(0xd23ea20ca3d137fa), UINT64_C(0x65942a7f7748247b), UINT64_C(0x661b9935d719701b), UINT64_C(0x034394303935594b) }},
  {{ UINT64_C(0x41269cae54f41026), UINT64_C(0xdec7a7c3a5d282e3), UINT64_C(0x6ac52708da8bbed9), UINT64_C(0x010e4e332e52ff99) }},
  {{ UINT64_C(0x2e60650070abd9d2), UINT64_C(0x42cf8abac39680c7), UINT64_C(0x565aa5be48081ba2), UINT64_C(0x0c0163dd3bba5bdc) }},
  {{ UINT64_C(0xbbbf7d92f57d400b), UINT64_C(0x13a081f1f2bd42b4), UINT64_C(0x3008501df14716df), UINT64_C(0x51a78eda272e935e) }},
  {{ UINT64_C(0x4ed935d7023c05ef), UINT64_C(0xf7756cbda3ab7b55), UINT64_C(0x4aed223d4a843311), UINT64_C(0x0a3e85aa74bd0e5b) }},
  {{ UINT64_C(0x530511ecfd525273), UINT64_C(0x7f64405c9828e87a), UINT64_C(0x9feb90b262ad4f4b), UINT64_C(0x10580df4a9c53c46) }},
  {{ UINT64_C(0xe65233b76c80c615), UINT64_C(0x7fdc52e8c365c4c8), UINT64_C(0xfceccc3b87e8b1a4), UINT64_C(0x5f2f27297d8bbf8a) }},
  {{ UINT64_C(0x7d28d58ec79f76c9), UINT64_C(0x414ea37b2b60c2bf), UINT64_C(0x686c2b16dc57bc6a), UINT64_C(0xa05d6853f70653ec) }},
  {{ UINT64_C(0xa3aca583f1b4147f), UINT64_C(0x3aaca42718dd4bbc), UINT64_C(0x5f70ef87b27e172d), UINT64_C(0x310089e52bed7492) }},
  {{ UINT64_C(0x4e0107386c80d6b7), UINT64_C(0x7c144be196c8e9e2), UINT64_C(0xdaf03186d1e0b151), UINT64_C(0x3c49d992a4dfed6d) }},
  {{ UINT64_C(0x837f5171191312c6), UINT64_C(0x665d00fad73d53c2), UINT64_C(0xd0f1facd04a1c70f), UINT64_C(0xbe30ce4cede0859d) }},
  {{ UINT64_C(0x1d8c6b7a0d018f2d), UINT64_C(0x914937007c3840b5), UINT64_C(0x165656289e7f46d2), UINT64_C(0x7b1c873bc709ab6a) }},
  {{ UINT64_C(0xc3a7cd4e2bdf43b5), UINT64_C(0x67fc2e6d5adbdb28), UINT64_C(0xcd0bc434bd8b78a4), UINT64_C(0x7a4f70064f967ae4) }},
  {{ UINT64_C(0x564026a11e75464b), UINT64_C(0xe53e588d7e22b828), UINT64_C(0xf2da122ced5b1428), UINT64_C(0x0dad17d4b132700d) }},
  {{ UINT64_C(0x81b1f1c55e386a09), UINT64_C(0xb5c4f32450ec6ad8), UINT64_C(0x8dcf5194597bf78d), UINT64_C(0xd00f7a4a253df1d3) }},
  {{ UINT64_C(0xb70ba2e98f26d556), UINT64_C(0x1c2dedad4553cd24), UINT64_C(0x115d406705ce681d), UINT64_C(0x9a77f2c80c24fe62) }},
  {{ UINT64_C(0x705c362d3e1334e3), UINT64_C(0x3a9f019c606087ea), UINT64_C(0xd001501d02ea11b9), UINT64_C(0x677fc65ef28f87cd) }},
  {{ UINT64_C(0x308aa2ba92aea153), UINT64_C(0xc67350a91b89f947), UINT64_C(0x313033440f76644b), UINT64_C(0x8d2d6751ecdc0720) }},
  {{ UINT64_C(0x44ab0f958c56a521), UINT64_C(0xcbf4d7e5c2f32728), UINT64_C(0x2f62b75b6611559b), UINT64_C(0xdb810d2e2f92e6aa) }},
  {{ UINT64_C(0x91927e8a65f759b2), UINT64_C(0xb483dcceb6de0674), UINT64_C(0x7a9923180f545225), UINT64_C(0x3a4d5fe5f37e17ca) }},
  {{ UINT64_C(0xd52cc09a7a921cc9), UINT64_C(0x3f8fbbba1f4d25ec), UINT64_C(0x403a8398c3a678e1), UINT64_C(0x96ac02a82c0e0ff5) }},
  {{ UINT64_C(0x0176b44697cee4b7), UINT64_C(0x7e345ed9505dcd94), UINT64_C(0xb7abf19af8d3bd40), UINT64_C(0xaf55fbf8a9f6775a) }},
  {{ UINT64_C(0x8aed031868bc94b1), UINT64_C(0x3d56849bb7aff159), UINT64_C(0x2149ccd74c56af03), UINT64_C(0x26f0dc236d3364c4) }},
  {{ UINT64_C(0x541211bb93591dfe), UINT64_C(0x5af863b095781c99), UINT64_C(0xfa5b43c46dc446f4), UINT64_C(0xd31fa6647fb259e2) }},
  {{ UINT64_C(0xd8d20ac2c1cd2ac8), UINT64_C(0x0259b7bccb8be1a2), UINT64_C(0xba0fc7b46fc7a54c), UINT64_C(0x9b6898798a32d684) }},
  {{ UINT64_C(0x2a2488ec1023f721), UINT64_C(0x7c434e7d006e1c7f), UINT64_C(0xf0cec405a642132f), UINT64_C(0x6ba4943b31bd60da) }},
  {{ UINT64_C(0x4bf0a2e793b0b483), UINT64_C(0x61e4aa9103eb2705), UINT64_C(0x8263577a1d37cecf), UINT64_C(0x37f8dc1ecf9db892) }},
  {{ UINT64_C(0x80261a04575f6e33), UINT64_C(0x97650967db86508b), UINT64_C(0x49fe6d123d30636a), UINT64_C(0x27fe30026e1d65a3) }},
  {{ UINT64_C(0xb9112ed35e11d691), UINT64_C(0xbae1d0422590f32d), UINT64_C(0xe596bae09de0fa9a), UINT64_C(0x6702bbf602adb181) }},
  {{ UINT64_C(0x0d7681f4f1e9a429), UINT64_C(0xf90afbf65bf2fc04), UINT64_C(0x601f71beba91cf5a), UINT64_C(0x8ff31f0f3480abee) }},
  {{ UINT64_C(0x85d8228d942f5f49), UINT64_C(0x571e53eb3bdfd221), UINT64_C(0x5dc4372f9bafa9ec), UINT64_C(0x8ccef61959d15fe9) }},
  {{ UINT64_C(0xdae4f3dad55e2870), UINT64_C(0xb6e65ca396528175), UINT64_C(0x99e3b0a640a7d8b4), UINT64_C(0xfa66014f450aa599) }},
  {{ UINT64_C(0xf325272586f92df3), UINT64_C(0x279c3d2f86b74c3c), UINT64_C(0xd064ff95d0f61da1), UINT64_C(0xfa13edc632190d15) }},
  {{ UINT64_C(0x4bc23d30c1226118), UINT64_C(0x2f753ef3324a3177), UINT64_C(0x0c3be41785ce2f14), UINT64_C(0xa94435173e82ef40) }},
  {{ UINT64_C(0x053e661678681151), UINT64_C(0xe2f69717d2349468), UINT64_C(0xc6c4b91e92015df6), UINT64_C(0x9ea631f5d8b42a17) }},
  {{ UINT64_C(0xbc20ab15e903455d), UINT64_C(0x3ee9c9f97a98a42e), UINT64_C(0xfb972b13d04dc67c), UINT64_C(0xf7e9646f34cb8bf0) }},
  {{ UINT64_C(0x1b4dee74d598beec), UINT64_C(0xd5ca427e6aeda024), UINT64_C(0xd8ff496877943b4d), UINT64_C(0xd0d05a601a1fa90f) }},
  {{ UINT64_C(0xa814c0b4f738efbf), UINT64_C(0xd053ca1492ba18f4), UINT64_C(0xb754654fbbf1b496), UINT64_C(0xddb0a81cdc12def1) }},
  {{ UINT64_C(0x554731e31ebdba8e), UINT64_C(0x520e4ef130ec4693), UINT64_C(0x35cd9704b339f13e), UINT64_C(0x5fbf5a12cb3a72d1) }},
  {{ UINT64_C(0x1ecb964fbaba626f), UINT64_C(0xf8f1845a9bc4058b), UINT64_C(0x4170f54069d04e3e), UINT64_C(0x1a3f739e51e74d97) }},
  {{ UINT64_C(0x8097c7f5e2c87645), UINT64_C(0x6d9057bb05f95a72), UINT64_C(0x1720f85d5367b431), UINT64_C(0x9887b334deb38877) }},
  {{ UINT64_C(0x2106f8de294f740f), UINT64_C(0xa3d7ea0db91a4e82), UINT64_C(0x73f12d6b185c0d9e), UINT64_C(0xc4b6d32162e0654a) }},
  {{ UINT64_C(0x026e15f83d50a59a), UINT64_C(0xaa9c00e24b132593), UINT64_C(0x97475b2b1cff6ecf), UINT64_C(0xc145d12e1c40b7ab) }},
  {{ UINT64_C(0x00b41516fe08ed1e), UINT64_C(0x2af023c7404c4154), UINT64_C(0x74b720f4cb28e4a2), UINT64_C(0x5222dbd27214bce5) }},
  {{ UINT64_C(0x4b9adaca80e69e86), UINT64_C(0x9f5237addc156c8e), UINT64_C(0xdf790a40d72ba32b), UINT64_C(0x148aca2f563ebfac) }},
  {{ UINT64_C(0x0612d09a6a75466b), UINT64_C(0x610a70f013e4544e), UINT64_C(0x8441c2eff622c864), UINT64_C(0x8885926a16757307) }},
};

static const block_t Zi_0[] = {
  {{ UINT64_C(0x7bf21d841e2cd20c), UINT64_C(0x8c1959ca9247a9d0), UINT64_C(0x84e7352efb180324), UINT64_C(0x8fcbf4e74311f405) }},
  {{ UINT64_C(0x1684036753a614de), UINT64_C(0x93f837828edd1562), UINT64_C(0xed178a5f19af2462), UINT64_C(0x8a62542f624ea545) }},
  {{ UINT64_C(0x8deef43b9189e3a4), UINT64_C(0x6dc5a32e1f793a4b), UINT64_C(0x545e3183072c0608), UINT64_C(0x1499c8a9bd7e8867) }},
  {{ UINT64_C(0xd245071e46124962), UINT64_C(0x575d31e568831b7d), UINT64_C(0x9cbd310a0e74d7a1), UINT64_C(0xaa8992983f7428e5) }},
  {{ UINT64_C(0x4803b9b7ec877482), UINT64_C(0xf3c09b4138874c75), UINT64_C(0x881c85e08a6cf0cb), UINT64_C(0x24d90d3935635cf5) }},
  {{ UINT64_C(0xc205ce02819684a0), UINT64_C(0x274e79d08ca4e1f7), UINT64_C(0x976ea4f3ab65b3fa), UINT64_C(0x28d1753fb75ea8ce) }},
  {{ UINT64_C(0x7f5011d5a7269cac), UINT64_C(0x5fa8428dff32b0f8), UINT64_C(0xd43d2351667fd79e), UINT64_C(0x78f6a113f21142b1) }},
  {{ UINT64_C(0x1abad444c3389874), UINT64_C(0xccb8d00d36000c3d), UINT64_C(0xdb3769d57f50d2e2), UINT64_C(0x6e581f8e8eda4823) }},
  {{ UINT64_C(0x0000bb8193ab5be5), UINT64_C(0x856f0238439084fa), UINT64_C(0xea1f711691c6e3df), UINT64_C(0xf10a0519de2bb2d4) }},
  {{ UINT64_C(0x2025c4671ed40298), UINT64_C(0x02ee3b782071aa10), UINT64_C(0x1583987dc6fedf28), UINT64_C(0x6c873e4ddbf416e4) }},
  {{ UINT64_C(0xd94375610aa29b74), UINT64_C(0x959e199641658a2a), UINT64_C(0x632713d0e2f09dee), UINT64_C(0xe57f12b6845345c3) }},
  {{ UINT64_C(0x75d901dac50d4f53), UINT64_C(0x5c5fdf8ebc7c3275), UINT64_C(0x436a101d748433ce), UINT64_C(0xabbf0e5b49f2d4be) }},
  {{ UINT64_C(0x620f5637714c2c6c), UINT64_C(0x581ee6827979cc62), UINT64_C(0xd72932cf10dd6a63), UINT64_C(0x16a7a5a8d3fc75b7) }},
  {{ UINT64_C(0xae157ee4826d8848), UINT64_C(0xd378edd27cb69131), UINT64_C(0xb7c12e5103673a6c), UINT64_C(0x1522ff0b7320fda9) }},
  {{ UINT64_C(0xe3f62464a39c6028), UINT64_C(0x80c2cf36dea3ac37), UINT64_C(0x37fb03e572dbe0b3), UINT64_C(0xb6c714e154b43782) }},
  {{ UINT64_C(0x8c42d5b880a48ecb), UINT64_C(0xdf6c35705ab4f3dd), UINT64_C(0x7f63b0ed493352a3), UINT64_C(0x3ab029c2158e156f) }},
  {{ UINT64_C(0x5db27bceb1bb11c3), UINT64_C(0x26bba7771c407a69), UINT64_C(0x06de8c7b3f34dc76), UINT64_C(0x7114b151813490b0) }},
  {{ UINT64_C(0x313ba37e29c6190f), UINT64_C(0x7e10d1aa87d12e04), UINT64_C(0x55d630fab75ee77b), UINT64_C(0x2f0f2d86ef8b4438) }},
  {{ UINT64_C(0x2006b4f3084f57de), UINT64_C(0xd30486f502d5f8c5), UINT64_C(0xc4a0330607ba0e30), UINT64_C(0xa8ce387c51a91bb2) }},
  {{ UINT64_C(0xa7f3a83b15968e03), UINT64_C(0xcd976d276642f7e8), UINT64_C(0x926ce0dc0118c97f), UINT64_C(0x1f61e762f1896771) }},
  {{ UINT64_C(0x1cd92d1d62195845), UINT64_C(0xf4113301084c595b), UINT64_C(0x2da6a9bc6457a49a), UINT64_C(0x01c3929d693145db) }},
  {{ UINT64_C(0xf6f78a263a89edd7), UINT64_C(0x20f65ec2b3e91429), UINT64_C(0x5c4950a3797702e2), UINT64_C(0x6e34dd4cd1a970db) }},
  {{ UINT64_C(0x52b559f1b9857d9f), UINT64_C(0x1b26e33405dff60b), UINT64_C(0x3c256801c67022f6), UINT64_C(0x01618ce073aca3dd) }},
  {{ UINT64_C(0x2781b68b070a6c19), UINT64_C(0xb9ff59ae92809ac8), UINT64_C(0xbc6bb736aa73de89), UINT64_C(0xe1c69ec27020a9cc) }},
  {{ UINT64_C(0x952b38b36dc454b4), UINT64_C(0x17fe252fecf594aa), UINT64_C(0x9b66e85352966bb8), UINT64_C(0xf4b73573261a4ea7) }},
  {{ UINT64_C(0x888b78b655197710), UINT64_C(0xd2c79c3e69da0ae4), UINT64_C(0x23df1129b8e84383), UINT64_C(0xc10ce703eac3720a) }},
  {{ UINT64_C(0xad79d858b022ede4), UINT64_C(0xf79dfbe62f5929a5), UINT64_C(0xff53657787038481), UINT64_C(0x910d34a9a1511f64) }},
  {{ UINT64_C(0xc41523bf353ea55d), UINT64_C(0x73c8bbaee4a74d8b), UINT64_C(0xe92a65d0359d95df), UINT64_C(0x69e052323f4380e3) }},
  {{ UINT64_C(0x38c415ba69605686), UINT64_C(0x71667e2b6c44541b), UINT64_C(0x508c8c8f1eed4f26), UINT64_C(0xed444206d485ff14) }},
  {{ UINT64_C(0xfd3d5044dec394a3), UINT64_C(0xae452083a456d93d), UINT64_C(0x501276029d7320d0), UINT64_C(0x4b056980cd707ace) }},
};

static const block_t Zi_1[] = {
  {{ UINT64_C(0xd11d34d5e740a866), UINT64_C(0x26f5d84d600fc70a), UINT64_C(0xcbab516e2909d0aa), UINT64_C(0x5ee0e293c0374bba) }},
  {{ UINT64_C(0xad9229316db657fd), UINT64_C(0x2c34956646840ace), UINT64_C(0x2d108e5d6f674f7b), UINT64_C(0x9c88df8ccd87844d) }},
  {{ UINT64_C(0x71f4dff69a9900d2), UINT64_C(0xe31eecd45532a815), UINT64_C(0xbc1d9d472e307527), UINT64_C(0xa3ba30f22908da1f) }},
  {{ UINT64_C(0x630c420a3cca5a81), UINT64_C(0xf4482cfb23bb3ef7), UINT64_C(0xb66f856d57648703), UINT64_C(0x73e45f80fa530ef2) }},
  {{ UINT64_C(0x31f952800a468b8d), UINT64_C(0xe1e29c955bfd7b48), UINT64_C(0xd83c12c0b2725825), UINT64_C(0x12dd97a7373afd4b) }},
  {{ UINT64_C(0x9809c4a7957e0f63), UINT64_C(0x9d30b11dd2d5332d), UINT64_C(0x09f8f8cb8be21bf3), UINT64_C(0xcdb26fa11bc9e5c2) }},
  {{ UINT64_C(0x832f4750077bd6d4), UINT64_C(0x9fe17f050486c583), UINT64_C(0x6e84ecbc863bc289), UINT64_C(0xb062300089441648) }},
  {{ UINT64_C(0xa1cac67a1723da9e), UINT64_C(0xa63b5bad5b8c20a2), UINT64_C(0x58ed0ba8c4fc6af6), UINT64_C(0xfc735af3f29db355) }},
  {{ UINT64_C(0x0ebddaa3281819b4), UINT64_C(0xecf9b3d8c6c3fd7b), UINT64_C(0x351a824969c76577), UINT64_C(0xaf8c54801aa99e30) }},
  {{ UINT64_C(0x30b81c85bb514f3c), UINT64_C(0x995a2082281c0649), UINT64_C(0xd163bb40d841dfae), UINT64_C(0xc0d6e1824160b578) }},
  {{ UINT64_C(0x01428605f1472168), UINT64_C(0xed79d6912f87f73c), UINT64_C(0x1606cc7ca9653539), UINT64_C(0xf85d802112426d9c) }},
  {{ UINT64_C(0x4c02f1ff71e1a524), UINT64_C(0xe9e543186162571f), UINT64_C(0x0f645d0f076bf964), UINT64_C(0xc8a935679cd1c41d) }},
  {{ UINT64_C(0x9e9643299694a2f1), UINT64_C(0xfcd95bf3add10a4d), UINT64_C(0x1e8afd4390b45a81), UINT64_C(0xa30a2b19b4e93ea5) }},
  {{ UINT64_C(0x21a08a0fde8c634d), UINT64_C(0x9c395ef54fcec79c), UINT64_C(0xb2977d306ecdbd15), UINT64_C(0xc8235f6ac4daa56c) }},
  {{ UINT64_C(0xa16e3de841a6f6a9), UINT64_C(0x5c9a8f0b61420291), UINT64_C(0xea7421ebcaade567), UINT64_C(0x130d4a88f597318f) }},
  {{ UINT64_C(0xd9aa9449404f513e), UINT64_C(0x9a8d1ee3a035abde), UINT64_C(0xc7800fd152deccb5), UINT64_C(0x596d921c996f5471) }},
  {{ UINT64_C(0x7b94a10188d47a6e), UINT64_C(0x3e0e91ab39ed157d), UINT64_C(0x143586df7ae378d1), UINT64_C(0x8e4ae6534c626df2) }},
  {{ UINT64_C(0xf34b4a180c00f79a), UINT64_C(0x2aa0fb8809043ad6), UINT64_C(0x41e30e8aaaf1d3c7), UINT64_C(0x03d20778d040e25d) }},
  {{ UINT64_C(0x41c767a2cc4f5328), UINT64_C(0xbd39b16be836f2ce), UINT64_C(0x7d20f759a3fa8d69), UINT64_C(0x086c69662f5f23a0) }},
  {{ UINT64_C(0x335fb787d4f85019), UINT64_C(0xe1450e1491e7b292), UINT64_C(0x5eddbb6582d25ca8), UINT64_C(0xabe65de066813518) }},
  {{ UINT64_C(0x057f60762b2e4f09), UINT64_C(0x4bd98bfb5145c9f2), UINT64_C(0x56e7e1306d53e76a), UINT64_C(0x89efa611b0258646) }},
  {{ UINT64_C(0x7fc0b52ba2956a1d), UINT64_C(0x33f6093691792516), UINT64_C(0x7035c05d0938e937), UINT64_C(0x6ebbdd6ea7ef1543) }},
  {{ UINT64_C(0xcba7f1bb64735a27), UINT64_C(0xc91e5d6cb325a708), UINT64_C(0xbdd18e655b5f9ada), UINT64_C(0x6fb2c5bf38051dc0) }},
  {{ UINT64_C(0x5cf8883bf6c99bc9), UINT64_C(0xe0a0d6a2e0232f5a), UINT64_C(0xa1f9f1afa13e82de), UINT64_C(0x06307093727a2741) }},
  {{ UINT64_C(0xa65b82f715429c50), UINT64_C(0x058f66247fd6049b), UINT64_C(0x99430f1cce57be22), UINT64_C(0xf53e08b78293d762) }},
  {{ UINT64_C(0xb5e45453ec16b203), UINT64_C(0x9760c2e1d86b488c), UINT64_C(0xffeb097a50661215), UINT64_C(0x0c396db4858301f2) }},
  {{ UINT64_C(0x885af42bde49939b), UINT64_C(0x88c42a877d6a77b8), UINT64_C(0xd92cc7fc805049c6), UINT64_C(0x6aca640f28f28527) }},
  {{ UINT64_C(0xedddb4c67ae0f238), UINT64_C(0xf40f584e018140a6), UINT64_C(0xb95635a65514ad38), UINT64_C(0x2684ad107b43f9bb) }},
  {{ UINT64_C(0xa5ce7f4af31ac958), UINT64_C(0x3e315874bdc84e5f), UINT64_C(0xec840e796165a10b), UINT64_C(0xe55880b29ccc37f5) }},
  {{ UINT64_C(0xb79dbf876cc4a0f7), UINT64_C(0xf1304c122963bafd), UINT64_C(0xdcf5a94f9f6f461c), UINT64_C(0x6ddcb8f37bb36e68) }},
};

static const block_t Zi_2[] = {
  {{ UINT64_C(0x0661dfaf0fe39749), UINT64_C(0xa2c7b48b2db7cd9a), UINT64_C(0x24a4d12fdf902c29), UINT64_C(0x1815333a106a4c7b) }},
  {{ UINT64_C(0x7d72d3bc40022b23), UINT64_C(0xf6ac0e8117bd846b), UINT64_C(0x89eb6ae520de65bf), UINT64_C(0x035f429235feb9bf) }},
  {{ UINT64_C(0xe69fb420d3ae665a), UINT64_C(0x5762dbc42c6720bf), UINT64_C(0x05aa8e81e8da62c5), UINT64_C(0x390281b5c8ebf907) }},
  {{ UINT64_C(0x9d95f3ecb021b2c5), UINT64_C(0xd5f902029823e913), UINT64_C(0x7de38d3adc7070ad), UINT64_C(0xe22afb55095f1e50) }},
  {{ UINT64_C(0x7a120fe0bd2bc10f), UINT64_C(0x2dbfdb52cbc98859), UINT64_C(0xdcc7eaa8d5a16d7b), UINT64_C(0xe1605446930f861e) }},
  {{ UINT64_C(0x4b47c7cedb26ee3b), UINT64_C(0xa57d22edbd641f08), UINT64_C(0xe60663da8f23990f), UINT64_C(0x8376a950aa5a723a) }},
  {{ UINT64_C(0xabac0806c20d75b7), UINT64_C(0x5127b9fdd823e351), UINT64_C(0x2ca7569b429045d5), UINT64_C(0x20f4cbb7b3feab31) }},
  {{ UINT64_C(0xa33b032470d7a255), UINT64_C(0xe6dcb3f93feeafda), UINT64_C(0x34f2aaaa3aad263d), UINT64_C(0x8bd192d547c5ede6) }},
  {{ UINT64_C(0x3dace93785bb0b2d), UINT64_C(0x660852473ba71ef2), UINT64_C(0x7fb2c3940928cc11), UINT64_C(0xa2853c6433833f1f) }},
  {{ UINT64_C(0xa7485a9fcce8da8a), UINT64_C(0xb41098e68bf8bcd1), UINT64_C(0x689b3b36683137fe), UINT64_C(0xee4ea694fc68e931) }},
  {{ UINT64_C(0xb35d2282534d0053), UINT64_C(0x76b3becbde9aa9c0), UINT64_C(0xf5754bd195a8ffb4), UINT64_C(0xd6eed5db14b0ed1c) }},
  {{ UINT64_C(0x1bcf377eb75571fa), UINT64_C(0xa0ca844471c9314a), UINT64_C(0x71419612a1a5c755), UINT64_C(0x59acdc0cc0d595d7) }},
  {{ UINT64_C(0xfc9cf163a6fa3d0d), UINT64_C(0xf3731cab22a72a4b), UINT64_C(0xa36c394230c5f4a1), UINT64_C(0xeba55f5491fad407) }},
  {{ UINT64_C(0x2e2154eea4a89781), UINT64_C(0x19533a1768baecec), UINT64_C(0x26c5b97cc3166116), UINT64_C(0xd7dfaf3b09bc8f31) }},
  {{ UINT64_C(0x5337ff3a85b076cb), UINT64_C(0x0f772eef343a14c3), UINT64_C(0x07df4e167fdf1f31), UINT64_C(0x10459758034fcca1) }},
  {{ UINT64_C(0x104301129dd62cb4), UINT64_C(0x82e629d31ee93a6f), UINT64_C(0x4051013a905e302b), UINT64_C(0xc9256377b9b5dcf9) }},
  {{ UINT64_C(0x1d0be1bb30b604ca), UINT64_C(0x293f5e87ee871073), UINT64_C(0xe5e95f257ca66921), UINT64_C(0x9442fde04a48a522) }},
  {{ UINT64_C(0xb7088398da5ad2af), UINT64_C(0x0c8122e0d01c802d), UINT64_C(0xaf65f532a2ffba7c), UINT64_C(0xa797dc3121d62c39) }},
  {{ UINT64_C(0xb9d1c16f19d6c40b), UINT64_C(0x0c2416ff902067d4), UINT64_C(0x8450595c377f8b7b), UINT64_C(0x40aa4ccefe5a7a76) }},
  {{ UINT64_C(0x6809d874173fe507), UINT64_C(0x0df64e186e5aa8d1), UINT64_C(0x5fb82e7725c42b7e), UINT64_C(0x2317d2ba179bd8f0) }},
  {{ UINT64_C(0x447e686f8eeb1bc9), UINT64_C(0xc973335e5b3ddc43), UINT64_C(0x98acaa8a6c783477), UINT64_C(0x14f72a5d8d4d8048) }},
  {{ UINT64_C(0x06b28fa681ae9630), UINT64_C(0x30e9814f95ebe5ef), UINT64_C(0xed595e336473a4df), UINT64_C(0x38aa769ed47c9f82) }},
  {{ UINT64_C(0xdb5096c930fa0fbc), UINT64_C(0x64226eaea78d6ead), UINT64_C(0x42f1d2b947ed63f6), UINT64_C(0xbe44f5fa8de71269) }},
  {{ UINT64_C(0xf911d7969a90df60), UINT64_C(0x646c33c0c8e42bc5), UINT64_C(0x93d8138b90fc46b1), UINT64_C(0x5d0a069e55088075) }},
  {{ UINT64_C(0x368a839a5af98580), UINT64_C(0x5ca0fd3bb1c9f6c5), UINT64_C(0x17cd674a921bb4cb), UINT64_C(0x14e95ac2ca4cf3f4) }},
  {{ UINT64_C(0x6a241c067123e7ce), UINT64_C(0x7dc2a78cf3df1810), UINT64_C(0x7de9b5203733e0b4), UINT64_C(0x3b43b93a6ae30750) }},
  {{ UINT64_C(0xb81eef893f4db568), UINT64_C(0x02e1b7ccc9ca54c6), UINT64_C(0x6c1d5cbc81fa172d), UINT64_C(0xe25e0082e76deeed) }},
  {{ UINT64_C(0x8ed6329d40dd63d8), UINT64_C(0x65cb6e244f6ca08a), UINT64_C(0x5b837e47807ad88c), UINT64_C(0x6d054e6a1baeea83) }},
  {{ UINT64_C(0x04100a0e360301fb), UINT64_C(0x5ea4ec4aeadadc15), UINT64_C(0xeeaa88e5515d2206), UINT64_C(0x58d16dba0417f944) }},
  {{ UINT64_C(0xa0792ac06f4c686f), UINT64_C(0xce315c2771926a5c), UINT64_C(0x01fea116165d295f), UINT64_C(0x29baca6ce2c8f3e1) }},
};

static const block_t Zi_3[] = {
  {{ UINT64_C(0x452beeb68380f83d), UINT64_C(0x9ccb0b89dc3ee292), UINT64_C(0x04118c562e31d164), UINT64_C(0x41fc3bcdb3eccc18) }},
  {{ UINT64_C(0xc498c3bbfdbc3a67), UINT64_C(0x37faa391a95306db), UINT64_C(0x570d2538137b18ff), UINT64_C(0x4d957aff9a62beaa) }},
  {{ UINT64_C(0xf2b2d91aaa4c831b), UINT64_C(0x3a14ee700ff770b7), UINT64_C(0x599fdfbb729a95bd), UINT64_C(0x508571dd279a697d) }},
  {{ UINT64_C(0xac2178a92cdb448b), UINT64_C(0xcc45dbd0fd59f7e8), UINT64_C(0x8a0132ad960d2dfe), UINT64_C(0x2f08ebe419dafe8e) }},
  {{ UINT64_C(0xc78ed915979a14d9), UINT64_C(0x95f4439ac14e2ef9), UINT64_C(0x10f1245d0df08b42), UINT64_C(0x5533ae2a1e061da3) }},
  {{ UINT64_C(0x43897f67ab61b909), UINT64_C(0x23c21ea0896f9350), UINT64_C(0x15367bb0df0da0d6), UINT64_C(0x545c633f49493803) }},
  {{ UINT64_C(0xcf31dfa21a6e62ae), UINT64_C(0xf243687fe1d4d3a6), UINT64_C(0x9a446a4c6cbcdc31), UINT64_C(0xe0528f27e0882d3a) }},
  {{ UINT64_C(0x298ecedf6487ee14), UINT64_C(0x1f873409542abafa), UINT64_C(0x4807df06589c9612), UINT64_C(0xe4f2091633bd6be4) }},
  {{ UINT64_C(0xf400a976720f5c4e), UINT64_C(0x319b142a443f31a6), UINT64_C(0x5fc8121d471bacc5), UINT64_C(0xa8eafd7ff05cc674) }},
  {{ UINT64_C(0xf4c4ef805a456b01), UINT64_C(0x228e7a8679dde0b7), UINT64_C(0x2c252714007736dd), UINT64_C(0x6205bb0fde61c25d) }},
  {{ UINT64_C(0xf80be9c403096665), UINT64_C(0x60fc6784dbfa8168), UINT64_C(0xc8cb07e8d52d64cb), UINT64_C(0x3504fa04d3b0ea53) }},
  {{ UINT64_C(0x80c44627cc5c1d90), UINT64_C(0xded7e623f70c6730), UINT64_C(0x26047d68f8d913bb), UINT64_C(0x5ddbf930d8c3ed74) }},
  {{ UINT64_C(0xa26095dada4a02c7), UINT64_C(0x52ceec300133b9bf), UINT64_C(0x21fa10f35d5fa4ac), UINT64_C(0xbf2551d25586a019) }},
  {{ UINT64_C(0x6f2fa2659a7935d8), UINT64_C(0x2ea9c5a5e37c1be0), UINT64_C(0x84aa3bb0cd720fca), UINT64_C(0x08deca09964e990d) }},
  {{ UINT64_C(0x94d81ad5c4d9f68f), UINT64_C(0x488116ed92738f2b), UINT64_C(0x840bedf80eaed9e7), UINT64_C(0x8ff89e692ea3dcf0) }},
  {{ UINT64_C(0xf576fc629e72c1f1), UINT64_C(0x16b89848ee1948f4), UINT64_C(0x77b87c021fef0a86), UINT64_C(0x3b11716118a6ab4e) }},
  {{ UINT64_C(0xed6547fa37ac6f5d), UINT64_C(0xe22215991070d896), UINT64_C(0xc0e3cd8f63bf31d3), UINT64_C(0x3eee184aeb209e12) }},
  {{ UINT64_C(0xdf51068f625070ab), UINT64_C(0x86b6841d66162a61), UINT64_C(0x49437bdfba4e8085), UINT64_C(0xbac3422270f6db8c) }},
  {{ UINT64_C(0xbfa18e0e6f25e983), UINT64_C(0x3c73df89f343bb75), UINT64_C(0xfb1cb9acf68ad550), UINT64_C(0xc046cba020bbcc21) }},
  {{ UINT64_C(0xdf0659e8270d4deb), UINT64_C(0xcac6447fd06bdb64), UINT64_C(0x7c814ce92543c37c), UINT64_C(0x1fa995b749b7ab1b) }},
  {{ UINT64_C(0xbc081fce51ce3dfa), UINT64_C(0xdde1f99a4f5d87ee), UINT64_C(0x44122e0c1be78394), UINT64_C(0x00fdd3355bed55b4) }},
  {{ UINT64_C(0x941078c7943f360e), UINT64_C(0x13859f863260ab7b), UINT64_C(0x303104f7be9b9f46), UINT64_C(0xb1ba183741f13d44) }},
  {{ UINT64_C(0x0e276427da993130), UINT64_C(0xfc86a66d8b0351b6), UINT64_C(0x5c89596e7d42651c), UINT64_C(0xa0ac4e5ae3ee3c85) }},
  {{ UINT64_C(0x7b75e1d34a5754e1), UINT64_C(0x48d508303a9693a6), UINT64_C(0xa6b36cf8f2377a6a), UINT64_C(0x7a2f049151fc5efb) }},
  {{ UINT64_C(0x1939e81e3883bba8), UINT64_C(0xa523dc08264e0ec7), UINT64_C(0x7936e8320b91f1d4), UINT64_C(0xb83ac3c45984a86b) }},
  {{ UINT64_C(0x1afaa0c8edc9e8e2), UINT64_C(0xfb7bb14177c4da31), UINT64_C(0x7fb692494584aad8), UINT64_C(0xb1537bf6bf2b774f) }},
  {{ UINT64_C(0x1291285dbef5a181), UINT64_C(0x9e61b90a5f61b2af), UINT64_C(0xb1b35ce093e313c0), UINT64_C(0x6c24a4ada9c7511d) }},
  {{ UINT64_C(0xdc2d50a7a215efdc), UINT64_C(0x689eeed21512a27e), UINT64_C(0x5100f704a0d3a2bb), UINT64_C(0x76c25e9019a9439c) }},
  {{ UINT64_C(0x3564570eb15070cb), UINT64_C(0x653043aaf5702cbf), UINT64_C(0x4d920b11f7b83ce0), UINT64_C(0xc302fbcad90aa63f) }},
  {{ UINT64_C(0xa5cc79d34c194efb), UINT64_C(0x1dc0597ec11ec8ba), UINT64_C(0x1798207c241a91ff), UINT64_C(0x7feeaf5f058d841d) }},
};

static const block_t Zi_4[] = {
  {{ UINT64_C(0x5ba75d668cd8a1e4), UINT64_C(0xa7a8bdf9fa8c9fc3), UINT64_C(0x7252be55db1399e5), UINT64_C(0x7086af8e21724d64) }},
  {{ UINT64_C(0x9c7045e41a48cc22), UINT64_C(0xed75b5a1361ed4a4), UINT64_C(0x0b6d92cfd21044a3), UINT64_C(0x3592700595d69faa) }},
  {{ UINT64_C(0xd251c11d8aadb1c2), UINT64_C(0x97e7947a4b193fb8), UINT64_C(0x41a93f9e36acf8a2), UINT64_C(0xed0685f6c5d8e56a) }},
  {{ UINT64_C(0x64a22a35e6d24aa1), UINT64_C(0x8b392dfe0861e11c), UINT64_C(0xd232ef751687cb48), UINT64_C(0xde47687dc4730dfc) }},
  {{ UINT64_C(0x2fe19c2ac3ad6cae), UINT64_C(0x618a4c9f7aee6d05), UINT64_C(0xb023a2956adfa2bf), UINT64_C(0xaaa41613f218ffaf) }},
  {{ UINT64_C(0xb129c67844448614), UINT64_C(0xd55ddc474df35c03), UINT64_C(0x9752862443915482), UINT64_C(0xa5f5c5d7039bc4ef) }},
  {{ UINT64_C(0x94a763886f3e15e8), UINT64_C(0xc3ffe05a98767eed), UINT64_C(0x3a3d4b693031806d), UINT64_C(0x5b1a1f794535c18c) }},
  {{ UINT64_C(0xe3fe573674c6b7a3), UINT64_C(0x5ade6e116cbb4fa6), UINT64_C(0x52979dde83b48b48), UINT64_C(0xb62998dbc1ea47ff) }},
  {{ UINT64_C(0x2a1e69a65f47bc27), UINT64_C(0x3f2164bfc1658141), UINT64_C(0xe4ccddd4db5cfe00), UINT64_C(0xa755ce14b6373b0d) }},
  {{ UINT64_C(0x21faed9b4b61a216), UINT64_C(0x8d8385f8ebc7d1c7), UINT64_C(0x6f21a0eb7cc18b2f), UINT64_C(0xb3654bb45c73e430) }},
  {{ UINT64_C(0x7285e00c781bf8de), UINT64_C(0x7a1ce7b16d35ff5a), UINT64_C(0x2dc7f8b66f23ffab), UINT64_C(0x42f4f74e6532f203) }},
  {{ UINT64_C(0x883bf78519dfd5e4), UINT64_C(0x441e93550154f082), UINT64_C(0xc84e78688d83d9d9), UINT64_C(0x1de18f66652b332d) }},
  {{ UINT64_C(0x11fcaaea8e458ee5), UINT64_C(0x3774e6aad2272550), UINT64_C(0x3ff492effa895af1), UINT64_C(0xa7f3f50d9f3c6a95) }},
  {{ UINT64_C(0x3d1faa26af27dc23), UINT64_C(0xa0d457de2f01ee54), UINT64_C(0x798068d18d407280), UINT64_C(0xae3ad23c72494741) }},
  {{ UINT64_C(0x51b80a3a0d5e4ee4), UINT64_C(0x2bf0c9cf6c48347f), UINT64_C(0x06b588a42a05206c), UINT64_C(0x2efbbfed3f9e4895) }},
  {{ UINT64_C(0x121522a0cfb04f55), UINT64_C(0xd322d846b78407c9), UINT64_C(0xce016f7ea0b24413), UINT64_C(0xd7a4175241882b4c) }},
  {{ UINT64_C(0x873389dc0794711b), UINT64_C(0x91d9f7a32ffd0614), UINT64_C(0x906bc360061d5cea), UINT64_C(0x08edc75bccc6a1e3) }},
  {{ UINT64_C(0x1a2eb0ac237f0617), UINT64_C(0x4611201d6485b08e), UINT64_C(0xb9a66baf6d1ca498), UINT64_C(0xa37b50a700a9c744) }},
  {{ UINT64_C(0xe59cf28113e87590), UINT64_C(0x12479c37424ab20e), UINT64_C(0x37a7c597e8c8a25a), UINT64_C(0x0bc4b6c2f80b0738) }},
  {{ UINT64_C(0xcf1a372e2d5b3788), UINT64_C(0x31832a594fbcb2e4), UINT64_C(0xd7278389806112a1), UINT64_C(0x4635faf67fe69a4e) }},
  {{ UINT64_C(0x528f2adb8d404647), UINT64_C(0x306a0f811b43c981), UINT64_C(0x090b518378f956bb), UINT64_C(0xb2bc420d2b136e66) }},
  {{ UINT64_C(0x2ddf1f92be80f3a6), UINT64_C(0xc5d8d6f854073963), UINT64_C(0x8400219b81af89a4), UINT64_C(0xa875794c01ad6eee) }},
  {{ UINT64_C(0x55fcedc2801568fc), UINT64_C(0x86bdebe477183082), UINT64_C(0xd7a5c0a6787bb409), UINT64_C(0x290680ca43f0a98a) }},
  {{ UINT64_C(0x66cef1aa2c8e9bc9), UINT64_C(0xea92f9b83bb86bf1), UINT64_C(0x51236e0cc245b3b9), UINT64_C(0x19de7cf19323e44c) }},
  {{ UINT64_C(0xd178f5a355e29003), UINT64_C(0x727edf005614da39), UINT64_C(0xe1af847eade62fb6), UINT64_C(0xb5d156a20225a626) }},
  {{ UINT64_C(0x16c47826cbabda5c), UINT64_C(0xb0b9703af4dbc252), UINT64_C(0x5d106392fc88db8d), UINT64_C(0x0d4aad710ac0f3f2) }},
  {{ UINT64_C(0x359237cee5215b63), UINT64_C(0xd27bb33eacde3036), UINT64_C(0x1b017f1ca14ce3d4), UINT64_C(0x0f45c22e69761626) }},
  {{ UINT64_C(0xb8680e74de8e979f), UINT64_C(0x977dcf3db60732de), UINT64_C(0xbe716f10ee055264), UINT64_C(0x68d86c9a29f11f1f) }},
  {{ UINT64_C(0xc9ccb50bf60d842d), UINT64_C(0xdaff92fb4690fec9), UINT64_C(0x5415bd4666966861), UINT64_C(0xe40e1fbc66d05d11) }},
  {{ UINT64_C(0x4fa3dfb35e51b98b), UINT64_C(0xafb1aa006bc68ceb), UINT64_C(0x68c02e64a326932a), UINT64_C(0x5101e09a56da62fb) }},
};

static const block_t Zi_5[] = {
  {{ UINT64_C(0xb71e18a300a6cc8a), UINT64_C(0x693e68967950ed7c), UINT64_C(0x9cdac047c14e9514), UINT64_C(0x7c2ff1ade2fb701c) }},
  {{ UINT64_C(0x83afc39e79335a0d), UINT64_C(0x67d716e8cbe03a42), UINT64_C(0x93ef833960b51aad), UINT64_C(0x70f39395dac9b9a3) }},
  {{ UINT64_C(0x8cbf70b9ba5d8b6a), UINT64_C(0x4ba62c565b7c7c79), UINT64_C(0x098c8e6e6b6d9332), UINT64_C(0xaa025a9708e8cb8b) }},
  {{ UINT64_C(0x40c67419e3d011db), UINT64_C(0x835ec2d287960987), UINT64_C(0x0e13910daa4d67cf), UINT64_C(0x8a7a0ddaa8d8206c) }},
  {{ UINT64_C(0x77f9e3a96596e0c7), UINT64_C(0x399c1615d6f850d6), UINT64_C(0x39f929552dbf190c), UINT64_C(0xad2cb1baaa9c6ad8) }},
  {{ UINT64_C(0x3289be4916ac3950), UINT64_C(0x45000f2545283138), UINT64_C(0x5bdf1d5c3dff3714), UINT64_C(0x6c24d372bc3d1e22) }},
  {{ UINT64_C(0x6dcdf5110b2069e7), UINT64_C(0x21b81d0004bb0b7b), UINT64_C(0xee32e62e84275dc0), UINT64_C(0x6058abf3709c1ae0) }},
  {{ UINT64_C(0x83c513231074a625), UINT64_C(0xbb7bce178cfca328), UINT64_C(0x629335cca4ab7597), UINT64_C(0xb77dc97a8841d4f3) }},
  {{ UINT64_C(0x29b6d403dc8bca2e), UINT64_C(0x029b9793b0982ca9), UINT64_C(0x241167888bf53dea), UINT64_C(0xc49e271d554d58c3) }},
  {{ UINT64_C(0x31a8158b09c175da), UINT64_C(0xc541788c132c71d5), UINT64_C(0x3fe9dd78a08e69be), UINT64_C(0xe2f960565caa2af1) }},
  {{ UINT64_C(0x6400f98c5824cb92), UINT64_C(0x7660c8cb575d2619), UINT64_C(0xb098c01f7a58b595), UINT64_C(0x3a69cc3bbfb24baa) }},
  {{ UINT64_C(0xa01b16f1801164c4), UINT64_C(0xb69ab9df923b9de3), UINT64_C(0x6a0517811de9b436), UINT64_C(0xe4021a93b21464c9) }},
  {{ UINT64_C(0x9592186a743bf01a), UINT64_C(0xb0097aa644214da6), UINT64_C(0x18b6e48b51448cba), UINT64_C(0x17279d7c36d57b4d) }},
  {{ UINT64_C(0x13b7baf5cd44b63a), UINT64_C(0x854a6950e094c343), UINT64_C(0x32ea09e8badd30f9), UINT64_C(0xf491b4c60a43320b) }},
  {{ UINT64_C(0x75b1b3acaa505873), UINT64_C(0xf789f6d48e1f6f8e), UINT64_C(0x7b98cec313bab212), UINT64_C(0x198c7b5336a55183) }},
  {{ UINT64_C(0x2ca38d866db52c41), UINT64_C(0x40104244919694df), UINT64_C(0xfe807befc5a182c4), UINT64_C(0x078f2649e03f4e2d) }},
  {{ UINT64_C(0xb2c0af2011c90a81), UINT64_C(0x0de18fe5c5d6f3aa), UINT64_C(0xc571d16b9632c2b7), UINT64_C(0xc559ccf57b84254c) }},
  {{ UINT64_C(0x6dee941d7353085c), UINT64_C(0xc4ae0958249fa306), UINT64_C(0x82e694932edd2ad0), UINT64_C(0x82b1417ec3973625) }},
  {{ UINT64_C(0x61a6781e91144d1e), UINT64_C(0xae11d5e3974bbba7), UINT64_C(0x7439405dac48779d), UINT64_C(0xe06d6371f59ae16a) }},
  {{ UINT64_C(0x2ffde2371a601a2b), UINT64_C(0x8b64e1b726a289de), UINT64_C(0xe55348d99dde1630), UINT64_C(0x933af040251ddaf2) }},
  {{ UINT64_C(0x0afd9132252d0342), UINT64_C(0x95268b8aaa6a7f04), UINT64_C(0x71404464b0467979), UINT64_C(0x572204eca6d64b27) }},
  {{ UINT64_C(0xfaf36962a75b2c22), UINT64_C(0x6953638546cc673c), UINT64_C(0x13c9fcd9b488ad78), UINT64_C(0x8d1d3fec53b69d51) }},
  {{ UINT64_C(0x0cb6ed1b140ed186), UINT64_C(0x827cd2073356b0f1), UINT64_C(0xd2716ece932f08c9), UINT64_C(0x725848fb45405910) }},
  {{ UINT64_C(0x66a3f6794ede4e3a), UINT64_C(0x301e6e5e45ce11c3), UINT64_C(0x2cb6801f11bee354), UINT64_C(0xa0a158d851237798) }},
  {{ UINT64_C(0x7754f323a6c43098), UINT64_C(0xcef33c3f8ebb02aa), UINT64_C(0x2ff799bb7147bc0c), UINT64_C(0xdb06a2e8a2b1c6a7) }},
  {{ UINT64_C(0x42b72ead6d68959c), UINT64_C(0x2f5dd36f0eaabe8b), UINT64_C(0xb9bc1d2818e30632), UINT64_C(0xc4ff2ec95b572776) }},
  {{ UINT64_C(0x3403d9186f09600b), UINT64_C(0x47ddf461fa1ea891), UINT64_C(0x2474cb569fef535b), UINT64_C(0xae191d0a6004ff33) }},
  {{ UINT64_C(0xa2b7a3659b428261), UINT64_C(0x39aafefcff2ce9df), UINT64_C(0xb4bd730a7821cef5), UINT64_C(0x22b7ac2d6f90f54a) }},
  {{ UINT64_C(0x5c29e4ca6cf507e0), UINT64_C(0xef6d948d1077e08f), UINT64_C(0x709723a57e65b899), UINT64_C(0xff91afe3fcae9d7b) }},
  {{ UINT64_C(0xe9b78c33053c9d5d), UINT64_C(0xc91f34d8f9bdc86f), UINT64_C(0x16858e19c4225bd8), UINT64_C(0x0befcf90ecef229f) }},
};

static const block_t Zi_6[] = {
  {{ UINT64_C(0x76be5b619df0af0b), UINT64_C(0xf5756923190134f2), UINT64_C(0x9e3b832fb28bda30), UINT64_C(0x1abd7a9e7058781f) }},
  {{ UINT64_C(0x5f941af0d980bef4), UINT64_C(0xec0db11cd9ef6a11), UINT64_C(0xa86fd466da1d3da5), UINT64_C(0x97c7976f170fc497) }},
  {{ UINT64_C(0x5bc74674cd27ce2a), UINT64_C(0x3144b581ef3c1cac), UINT64_C(0x2898eb61d0e3dc11), UINT64_C(0x035baa7a0d127bcd) }},
  {{ UINT64_C(0x87ba279377a8e3ec), UINT64_C(0xceebbedd3b68824e), UINT64_C(0xd94152287b708259), UINT64_C(0x0934b1e5699321f1) }},
  {{ UINT64_C(0xb8e0fb69605643e4), UINT64_C(0x5d95ea8b55522fd3), UINT64_C(0x64a13cbc9b7b8c29), UINT64_C(0x6871ff68c16e62a7) }},
  {{ UINT64_C(0x2a69213001475a2f), UINT64_C(0x998d2b645177ad51), UINT64_C(0x4193afb2de262a7e), UINT64_C(0x4774e4bcad5b8f26) }},
  {{ UINT64_C(0x0cc256981ff2d502), UINT64_C(0x1a9437acee5ee3c8), UINT64_C(0x4ed26b807127018a), UINT64_C(0x08b471437261cbe7) }},
  {{ UINT64_C(0xac2171fdd9a680cd), UINT64_C(0xea6c45dbe05f2d99), UINT64_C(0x69bbd834d3badd1d), UINT64_C(0xd16ac2745d759299) }},
  {{ UINT64_C(0xb04eaf37ef0514f4), UINT64_C(0x498fb4839318d790), UINT64_C(0x8db3688d1d0650e3), UINT64_C(0x2cd01db47a8fdd59) }},
  {{ UINT64_C(0x2961e6f08a1a3689), UINT64_C(0xa8082e6d0615385a), UINT64_C(0xfc36fed927d2c6f3), UINT64_C(0x9edf4fe4e21d5cee) }},
  {{ UINT64_C(0x5edf622761f5e55b), UINT64_C(0xff20af6c01d6cb5b), UINT64_C(0x9b1628d88ee89668), UINT64_C(0x4d867405e40b41d9) }},
  {{ UINT64_C(0x4b91e9e9a2796579), UINT64_C(0x984019a45ab669fb), UINT64_C(0x9773bb8ac0aaafba), UINT64_C(0x1f4690faf307fc69) }},
  {{ UINT64_C(0x5563ce5bef810797), UINT64_C(0x8969138ebf112e93), UINT64_C(0x7f144467692ecaa0), UINT64_C(0x793a6b1aac75b6cf) }},
  {{ UINT64_C(0x9e8886ce53ba2f11), UINT64_C(0x6e756e922e6c5625), UINT64_C(0x93dfc4276e26b744), UINT64_C(0x35cb6c73184950a5) }},
  {{ UINT64_C(0x6e2a5780c794171f), UINT64_C(0xa9e8988e498a49e6), UINT64_C(0xe9215ffb364596d9), UINT64_C(0xc2f60a6472c2e7f5) }},
  {{ UINT64_C(0x209f8c19b0dbff24), UINT64_C(0x87ed05f5c984a2d7), UINT64_C(0x04cf88386535db52), UINT64_C(0x4c027da05748a137) }},
  {{ UINT64_C(0x61538511f4531cb7), UINT64_C(0x958ee6bbb48bc7e5), UINT64_C(0x44d91e12ec5ca814), UINT64_C(0xeb64c0fb053da6e3) }},
  {{ UINT64_C(0xb1296b97d28551c2), UINT64_C(0x74bca07e73ecbe2d), UINT64_C(0xd52caef7b154434c), UINT64_C(0x9b902d2e56cb326b) }},
  {{ UINT64_C(0x6ce5cdaf587734e2), UINT64_C(0xd708ed96ebfc0ee4), UINT64_C(0xfebb2415f45b4850), UINT64_C(0xfcfadc850bb7eae7) }},
  {{ UINT64_C(0xbfb684752319cf79), UINT64_C(0x4fd178667f5d9da0), UINT64_C(0xb602417aa4f58ebd), UINT64_C(0x2c287edcc189bfe3) }},
  {{ UINT64_C(0x8ef348edcbb7742c), UINT64_C(0x2fa4f93bf9eeaa04), UINT64_C(0x794ac9b09ccebc79), UINT64_C(0xd589d67ee726c5bb) }},
  {{ UINT64_C(0x5f368cf9a216c426), UINT64_C(0xb8f633552f7616af), UINT64_C(0xa31a4759d0cfe19f), UINT64_C(0x3facc0a6a8462952) }},
  {{ UINT64_C(0x36a3e4d412e6bec0), UINT64_C(0xe519bcf2ee9dc141), UINT64_C(0x443162ba6df9365f), UINT64_C(0x64cf81b9c4f09e35) }},
  {{ UINT64_C(0x62ab97a4c656e5cb), UINT64_C(0x5a66b25a19c50ccd), UINT64_C(0x5279f6234f42c28e), UINT64_C(0xbe092852d771108c) }},
  {{ UINT64_C(0xaa9aec13dc38749e), UINT64_C(0xc3cc7368b36a4b82), UINT64_C(0x0808e5298dd01582), UINT64_C(0x3c964faf87a4a6f3) }},
  {{ UINT64_C(0x36e8ca426ac4f950), UINT64_C(0x0d249d879bb927b7), UINT64_C(0xb095dddd826c789b), UINT64_C(0x4acac94001d18040) }},
  {{ UINT64_C(0xcf347c6ab34f8ff7), UINT64_C(0x56add6e56ddb57e1), UINT64_C(0xf793bf331bf952b2), UINT64_C(0xe3bbfe875f143058) }},
  {{ UINT64_C(0x5db9ad9a33d7dab7), UINT64_C(0x658fe4e04cc231c5), UINT64_C(0xa081e5a85ab01347), UINT64_C(0x823b7f3bb906d873) }},
  {{ UINT64_C(0x9ca57b72cc5c853b), UINT64_C(0x278f7980d7b1554d), UINT64_C(0x7f65d5e4955fae22), UINT64_C(0x555a719f550e23f1) }},
  {{ UINT64_C(0xcf77f4d1988b2567), UINT64_C(0xa17c06d022fa9ca9), UINT64_C(0xd64e3aa93c20339b), UINT64_C(0x94baeb5298be44cd) }},
};

static const block_t Zi_7[] = {
  {{ UINT64_C(0x1572328720d68da2), UINT64_C(0xc244326237e8cbc9), UINT64_C(0x2002ec0dea25d6a7), UINT64_C(0x06f8fed1b3713661) }},
  {{ UINT64_C(0xd0205e5f99792f6b), UINT64_C(0x1008de630758e9a7), UINT64_C(0x716635d057fdaddc), UINT64_C(0x1d24559f3618fbb6) }},
  {{ UINT64_C(0x38df01d1f0af3704), UINT64_C(0x9a5e1b24b9cb2867), UINT64_C(0x38eb606ad20d191c), UINT64_C(0x4a3bf24c190091db) }},
  {{ UINT64_C(0x53d51fd7d3fc0400), UINT64_C(0xc6aa199cffcde670), UINT64_C(0xa09a23c3667c1963), UINT64_C(0x972fb003f3923983) }},
  {{ UINT64_C(0x0f900e481fbe98e4), UINT64_C(0xbd8a1b17549314a1), UINT64_C(0x5a66de3f9a91f698), UINT64_C(0x7096f6f8e11de558) }},
  {{ UINT64_C(0x74fcbd69c63c1e96), UINT64_C(0x5b12f3f7996cb123), UINT64_C(0x5304f2bdbd9a2cec), UINT64_C(0xa5ea55f0193fa481) }},
  {{ UINT64_C(0x1ab90069181956a1), UINT64_C(0xaa35c52407cfae87), UINT64_C(0xdd87b246c551537c), UINT64_C(0x4033aba7978d1f72) }},
  {{ UINT64_C(0x6a9ab47409442b46), UINT64_C(0x68623bccd965e530), UINT64_C(0xf7bbb9930a0e1bd3), UINT64_C(0xd93ebafe52b906b9) }},
  {{ UINT64_C(0xf42da79fde228fe7), UINT64_C(0xb4950fc133e78978), UINT64_C(0xe338770067a54971), UINT64_C(0xa5bfde64ebabee59) }},
  {{ UINT64_C(0x95180f896c7471be), UINT64_C(0xac12bbb930552013), UINT64_C(0x32c4b9ad0c88179d), UINT64_C(0x6d1fc958bc0fdde9) }},
  {{ UINT64_C(0x32b1ebc744179e0e), UINT64_C(0x3eecb4cdeb111d04), UINT64_C(0x7096f8aa105b7059), UINT64_C(0xdc48689ae4eb07ee) }},
  {{ UINT64_C(0x0594030a351eda66), UINT64_C(0x47a1d36d4e46098e), UINT64_C(0x233997894c81bc45), UINT64_C(0x36afb2a502689f26) }},
  {{ UINT64_C(0x3a40c260ca39a97a), UINT64_C(0x9c8c69e94a79e7e6), UINT64_C(0x6e9dc2da26722dc4), UINT64_C(0x0c6b4979e9b2f5b2) }},
  {{ UINT64_C(0x45dceee0e8104133), UINT64_C(0xd0fbadb3fad67210), UINT64_C(0xb413134b5b796082), UINT64_C(0x57ee31bd4817dd24) }},
  {{ UINT64_C(0x1fba707f6ba7c650), UINT64_C(0x2e8ed15f86001f8b), UINT64_C(0xb8f7f90a508cc218), UINT64_C(0x72cd34eff662b039) }},
  {{ UINT64_C(0x8da4a0eeec420477), UINT64_C(0x2f4b48f1eaefe6de), UINT64_C(0x335b42d5f4029862), UINT64_C(0x8a2e0d437ce1dfc1) }},
  {{ UINT64_C(0x1a233793260a694e), UINT64_C(0x4c96f73b6ca9e1cf), UINT64_C(0x96ffaf763ab83961), UINT64_C(0x445c654200a382ae) }},
  {{ UINT64_C(0x56b80630da61db00), UINT64_C(0x4e637e2b28e62fcc), UINT64_C(0xfa4a99403c9b0601), UINT64_C(0xe4447b30d1982a16) }},
  {{ UINT64_C(0xfeb7362e5ce55644), UINT64_C(0xa4de305c2a387e8a), UINT64_C(0x566a277001c9e7a3), UINT64_C(0x74694ee10c52eacb) }},
  {{ UINT64_C(0x68a9dd875d490862), UINT64_C(0x8a1c9108ff778c35), UINT64_C(0x6445095b4c3aee2b), UINT64_C(0x32cd0d0a75983b1b) }},
  {{ UINT64_C(0x734101ae435eef1d), UINT64_C(0x5e9e6fa85824348c), UINT64_C(0x56201feaff4ecd89), UINT64_C(0x1a20a7fbb05713b0) }},
  {{ UINT64_C(0xeaf17bfcc69e522c), UINT64_C(0xf9475862d69696d3), UINT64_C(0xc1e5173824c31167), UINT64_C(0xff595f12286ce3f9) }},
  {{ UINT64_C(0xb054c0ee8d3406b8), UINT64_C(0x67c0888fc546005e), UINT64_C(0xda2ce44f65cccc18), UINT64_C(0xa822a81260d43d37) }},
  {{ UINT64_C(0x91eab35d12304476), UINT64_C(0xbebe4db946298650), UINT64_C(0xde6c277e67279d61), UINT64_C(0xfafccbc9fbdea0e5) }},
  {{ UINT64_C(0x666d7bfbbb760233), UINT64_C(0x02b7f2fbd662860e), UINT64_C(0xded4042bbbe0a171), UINT64_C(0x25d35905fc9ef82a) }},
  {{ UINT64_C(0xb8d2c7d16a430a1a), UINT64_C(0x74c8508f74e23cb8), UINT64_C(0xfc5f75ca89ea5783), UINT64_C(0x36bb9e4177486250) }},
  {{ UINT64_C(0x6f6f3ec9acf3ec05), UINT64_C(0xd31a9a33bec5ee3e), UINT64_C(0xb4e6181e7c049fdd), UINT64_C(0x39438a10785a29c5) }},
  {{ UINT64_C(0x882330b0a5516148), UINT64_C(0xb48f6d05803bd817), UINT64_C(0x114028534c99f2b2), UINT64_C(0x1bd8f6c0b97ac7a4) }},
  {{ UINT64_C(0x76d014c1592dc3e6), UINT64_C(0x6eefa61b7bc20486), UINT64_C(0xecf4049360ea2b8a), UINT64_C(0x224fb9ca379ace70) }},
  {{ UINT64_C(0xfb399c0cbf210778), UINT64_C(0xf6868c73c7aae9db), UINT64_C(0x30740ed57ddb3d05), UINT64_C(0xc5fd4e3c4bd3667b) }},
};

static const block_t Zi_8[] = {
  {{ UINT64_C(0x106c8d81f70d16fb), UINT64_C(0xb696e87d4b21ba6e), UINT64_C(0xb3a6887578d921bc), UINT64_C(0x29467fdc4d3911bb) }},
  {{ UINT64_C(0x6392aab3d485c45f), UINT64_C(0x29a928ba5414929f), UINT64_C(0xa6eb56a191df30ee), UINT64_C(0x9317a245634d39db) }},
  {{ UINT64_C(0x73a84665264ab8e7), UINT64_C(0xd4a64385e672427e), UINT64_C(0x9a276b11ffc0a95d), UINT64_C(0xea0ba1de442d186a) }},
  {{ UINT64_C(0xbb8c84eb3c4401a4), UINT64_C(0x40de3d1fa4c66710), UINT64_C(0xdb9276be447510ca), UINT64_C(0x9544a1588731e4f2) }},
  {{ UINT64_C(0x5408bc8dd6f17338), UINT64_C(0x1c9f901022934705), UINT64_C(0x0b98f0cda8b02964), UINT64_C(0xf8d666003ce60936) }},
  {{ UINT64_C(0x5aeac4df05b11b45), UINT64_C(0x95288c10d185bb17), UINT64_C(0x827def7284488b4c), UINT64_C(0x702aac3f4ee55d38) }},
  {{ UINT64_C(0x9089ebdce8a61d68), UINT64_C(0x60fb63c3819a6e93), UINT64_C(0x102686f68df041b6), UINT64_C(0x9aead3f8759c6d75) }},
  {{ UINT64_C(0xc8afeca503098762), UINT64_C(0x8ff38445c39d162e), UINT64_C(0xcfa3476ef620be02), UINT64_C(0xed234b7a16e74e88) }},
  {{ UINT64_C(0x0db4d6c61f2063a7), UINT64_C(0xb24a7766f4937b1a), UINT64_C(0x9f16df37560ab4ca), UINT64_C(0x9998f98d28713a7c) }},
  {{ UINT64_C(0x6c16d4fe6230d369), UINT64_C(0x2a19628f7b9d295b), UINT64_C(0xd2286a31d8818f25), UINT64_C(0xd8425dfcde8c45ff) }},
  {{ UINT64_C(0xc629997fd51159dc), UINT64_C(0x0a2311ad5c11d1c7), UINT64_C(0xaa63acd9903dc3fa), UINT64_C(0xafa0800176c88f42) }},
  {{ UINT64_C(0x212f5a30d2d26ecd), UINT64_C(0x4646d9931803f3e2), UINT64_C(0x0d4f3c616250f13e), UINT64_C(0x732cf7c4bc4228cd) }},
  {{ UINT64_C(0x9de4111d061ef584), UINT64_C(0x7d934f0d2d759d8e), UINT64_C(0xa0b47872372911e4), UINT64_C(0x2b30ed8eab76f0cf) }},
  {{ UINT64_C(0x36831c81f81402db), UINT64_C(0x5d062a264a29b334), UINT64_C(0x5fc0270f693f0c7b), UINT64_C(0x307057ee770de8b9) }},
  {{ UINT64_C(0x84fa2fb479bdbeb4), UINT64_C(0x9d93ed5c0897fed4), UINT64_C(0x6afaabe399b31baf), UINT64_C(0xaa216466f386bf94) }},
  {{ UINT64_C(0x12a6ada4347fa8b5), UINT64_C(0x084528b9418733b2), UINT64_C(0xe399f3819ff9da78), UINT64_C(0x3341aa17178d6600) }},
  {{ UINT64_C(0xa278b3c5381c67c2), UINT64_C(0xbdb610f206376de0), UINT64_C(0x66246d3423452a50), UINT64_C(0x262731f2d66395d9) }},
  {{ UINT64_C(0xba7f3cb048703a57), UINT64_C(0x9e6560a3f486907f), UINT64_C(0xae20b467eab2556b), UINT64_C(0x2d7a27138695d0fb) }},
  {{ UINT64_C(0xb3410d48e9574f7d), UINT64_C(0x98f89be00d11cc58), UINT64_C(0x665e8b6a5fa0cb15), UINT64_C(0xcd370198494c4e6c) }},
  {{ UINT64_C(0x3f52bdf443c8cb62), UINT64_C(0x79ea3d8a0098ae4c), UINT64_C(0x8fc0c47b3b3a1d5e), UINT64_C(0xe40295169c5cd708) }},
  {{ UINT64_C(0x84d4fd1f022c16b4), UINT64_C(0x26ec18d9b945c84c), UINT64_C(0x0c9f38f6f285cd88), UINT64_C(0xc9e4a609bd3a2d8b) }},
  {{ UINT64_C(0xa21abe8f544ea458), UINT64_C(0xea5ce6b8d741dc0e), UINT64_C(0x5ecdac30ae2d4d33), UINT64_C(0x27c6550e1382d534) }},
  {{ UINT64_C(0x3cbf095eabaef648), UINT64_C(0x5f0f126e226e3fe0), UINT64_C(0x10d507d7b0a846e4), UINT64_C(0x44f8ef5787b981db) }},
  {{ UINT64_C(0x8d3e51b1bf0cbb1a), UINT64_C(0xbf1900ae18a621c3), UINT64_C(0x5e0be6da8c2f1dae), UINT64_C(0x7b990a27b6bfc727) }},
  {{ UINT64_C(0x4202b4045dd8d8bd), UINT64_C(0x7f81028f7c9bfc94), UINT64_C(0xae77fb0d64c12fa9), UINT64_C(0x6ed2d6e831828ec6) }},
  {{ UINT64_C(0xb8ae17cde6aaa7c8), UINT64_C(0x938c2f1d1724dbbd), UINT64_C(0xcc1e7714d8810d5e), UINT64_C(0x1a07d5534e1804b6) }},
  {{ UINT64_C(0x03ef08a72ed31cc8), UINT64_C(0x3755a8fa62a5a48f), UINT64_C(0x1f2966fe3a6e9f05), UINT64_C(0x6e7aded0728de271) }},
  {{ UINT64_C(0x06d09dba8eb69399), UINT64_C(0x461533e6ee22266e), UINT64_C(0xbccf9535d8eb131f), UINT64_C(0x882838b4f19d28e6) }},
  {{ UINT64_C(0xe39ed5035f327d00), UINT64_C(0xb60a71552ba530d8), UINT64_C(0x9a477da0cc545513), UINT64_C(0xb11df439a8384327) }},
  {{ UINT64_C(0x68d9e001f76186b0), UINT64_C(0x141bb3ff25f05097), UINT64_C(0x00fce5203b7d02c3), UINT64_C(0xcb63864f4000e4c5) }},
};

static const block_t Zi_9[] = {
  {{ UINT64_C(0xe534f61adf576da1), UINT64_C(0x5995fa07bd27ff06), UINT64_C(0xaa3c70c2d16b414d), UINT64_C(0xca12cf173a4fc93a) }},
  {{ UINT64_C(0x7638eae58928af7f), UINT64_C(0x6578ed4a247ecd22), UINT64_C(0xed6eb62539bcad34), UINT64_C(0x80c0a3ecf9ae4891) }},
  {{ UINT64_C(0xfadbaeb7f5012c69), UINT64_C(0xde70dcc288546c4f), UINT64_C(0x20a2592bb7ae30ba), UINT64_C(0x283aa63fa8c9c241) }},
  {{ UINT64_C(0x5b98da62995676a7), UINT64_C(0x1f9871593c652127), UINT64_C(0x42302913442c8005), UINT64_C(0x3d152005e22734aa) }},
  {{ UINT64_C(0x76c9cd8b1c2483d0), UINT64_C(0x000d8b0bfc622464), UINT64_C(0xdb41143d8c282f49), UINT64_C(0xf71bf7ef0cd3948e) }},
  {{ UINT64_C(0xd5a170c8c48a5f80), UINT64_C(0x355c89f44b4c1373), UINT64_C(0x80ce0cb88c64d305), UINT64_C(0x82ae2b40807bb5e7) }},
  {{ UINT64_C(0x246a69657ce832de), UINT64_C(0xd75dfce7d1176086), UINT64_C(0x74bf878750350eb1), UINT64_C(0xb291eed445d2df09) }},
  {{ UINT64_C(0x3f2bbf5a7d865d5f), UINT64_C(0x629330d298abfba6), UINT64_C(0x5295e6708bd24720), UINT64_C(0x5399cd08752ad9c5) }},
  {{ UINT64_C(0x6cc07aba19675692), UINT64_C(0x16068af17273a0d1), UINT64_C(0x63442a15b008a45b), UINT64_C(0xddf090e40dba7fce) }},
  {{ UINT64_C(0xc937effbd44258ba), UINT64_C(0xe152e8cd0ab990ee), UINT64_C(0xfc9c9eb518ad22b7), UINT64_C(0x02ef3fe391e4449b) }},
  {{ UINT64_C(0x0d0f9d5120729c41), UINT64_C(0xc186f980e6bb7680), UINT64_C(0x25f90505ca0e2632), UINT64_C(0x17a7490c9246b982) }},
  {{ UINT64_C(0xc7a71348e827209c), UINT64_C(0x1748397076655d6f), UINT64_C(0x4e248dbb719e76e1), UINT64_C(0x597047bdb20e7eed) }},
  {{ UINT64_C(0x2e9c5cc98744597c), UINT64_C(0x3aef1c6fd9db3094), UINT64_C(0x3e8960a3956b207a), UINT64_C(0xd631865246fb73bf) }},
  {{ UINT64_C(0x31e0b6414ce94eb5), UINT64_C(0xf3367632ab2c8a3f), UINT64_C(0x72cd181d194e6b89), UINT64_C(0x923aa4f38a6e4f98) }},
  {{ UINT64_C(0xbf50df5a513245c9), UINT64_C(0xb5377f5ed4989199), UINT64_C(0xe1235dbb91d4c4e7), UINT64_C(0x2f84484c92e70f6c) }},
  {{ UINT64_C(0x4d7ef488fb659659), UINT64_C(0xe9cb0511a318e432), UINT64_C(0xf04b7a8412f309df), UINT64_C(0xb603f7472ff07b4c) }},
  {{ UINT64_C(0xf447e8ee7155584c), UINT64_C(0xaf8d1746942fbe87), UINT64_C(0xdab34fcdd04e39d0), UINT64_C(0xdcbd650aa35d6884) }},
  {{ UINT64_C(0x60428ce0ea626aa6), UINT64_C(0x142fb34aaae04761), UINT64_C(0x26f7348923c5164e), UINT64_C(0x9ac79309305379e4) }},
  {{ UINT64_C(0xdf0626cb776689f2), UINT64_C(0x7b0ce0d18cad6714), UINT64_C(0x5e01ae0893c4d740), UINT64_C(0xb40f78da5bbe061a) }},
  {{ UINT64_C(0xb866c8cd7371a51e), UINT64_C(0x1111055e4853a421), UINT64_C(0x17213294640b3a18), UINT64_C(0xdb719e5ca6809bbc) }},
  {{ UINT64_C(0xb8287328b49f1cc4), UINT64_C(0x64d079ed2f33fda0), UINT64_C(0x8400bad63ff953a2), UINT64_C(0x0a23cc30b613855a) }},
  {{ UINT64_C(0x133f7b1d1a2fb8f4), UINT64_C(0xe8b146f4a61e4077), UINT64_C(0x565da1f90324255a), UINT64_C(0x0164d39e49a9e8fa) }},
  {{ UINT64_C(0xef96f44f09aa5d85), UINT64_C(0x0c837f287f848f17), UINT64_C(0x4ee76830ac52200a), UINT64_C(0xe43b3d6d968370ec) }},
  {{ UINT64_C(0x8d2564c2694669ec), UINT64_C(0x10c311004d44b033), UINT64_C(0x5be24c0688768d99), UINT64_C(0x31eed534810ad479) }},
  {{ UINT64_C(0x34d706b343c50f77), UINT64_C(0x2fb3d21759d00b65), UINT64_C(0x2b65a0d8d4810084), UINT64_C(0x45876b7d24aa088b) }},
  {{ UINT64_C(0xbdb60f53a6af5bf7), UINT64_C(0xfd6bf50ce49ccd7a), UINT64_C(0xb468d25685494f6e), UINT64_C(0x3f5afd90b47f9936) }},
  {{ UINT64_C(0xaf122ad4a0ae7e51), UINT64_C(0xe696408c2a223d12), UINT64_C(0x83bc1eeaa2a9549f), UINT64_C(0xbdb9b4f91826d713) }},
  {{ UINT64_C(0xd0b36e97a7988561), UINT64_C(0x940519b50cdd1623), UINT64_C(0x6cf5904bcab66ee6), UINT64_C(0x4c465e6a9126e565) }},
  {{ UINT64_C(0x0e508fa7e50da714), UINT64_C(0xa3892f6b4fad4bda), UINT64_C(0xf547f8a05bdfb9b2), UINT64_C(0x886481c8ecec4cf4) }},
  {{ UINT64_C(0x2c30f0337b5dfe62), UINT64_C(0x872a84b241911206), UINT64_C(0x068fe6b07d868106), UINT64_C(0x5472575f3eb87670) }},
};

static const block_t Zi_10[] = {
  {{ UINT64_C(0xdcb5b449e15ae60a), UINT64_C(0x3bacf71e06fb22e8), UINT64_C(0x032867cb75d22fd5), UINT64_C(0x9994bc8f0e0d1e9f) }},
  {{ UINT64_C(0x3cdf4f0989f3a8fb), UINT64_C(0x30aef0926e1a33b6), UINT64_C(0xc2d21add81aab2eb), UINT64_C(0xd1d1990379d788de) }},
  {{ UINT64_C(0x70a47ca1e32be86a), UINT64_C(0x0e604986b91e13b3), UINT64_C(0x09153103e957137e), UINT64_C(0xcdc768246f02e3a9) }},
  {{ UINT64_C(0x504ef8f064c2cda8), UINT64_C(0x2ffc6cdde6c0e489), UINT64_C(0x885330f3f240622a), UINT64_C(0x96d9124bc755e06d) }},
  {{ UINT64_C(0xde057bc186df3cf2), UINT64_C(0x8c738f070d56188b), UINT64_C(0x799d78fb6b60141f), UINT64_C(0xfaee1db0b23b0b78) }},
  {{ UINT64_C(0xefbf54c682dc0ae4), UINT64_C(0xf9d79e34e1feefa5), UINT64_C(0x762469925f2bbb85), UINT64_C(0x2240ab224fea44ca) }},
  {{ UINT64_C(0xc8f4787feb88bd1c), UINT64_C(0xb7974bf509d4be17), UINT64_C(0x0d64a022aeea7c29), UINT64_C(0x96a7766d2b39a863) }},
  {{ UINT64_C(0xd881749b2707cb09), UINT64_C(0xcc8876f150607455), UINT64_C(0xede61fde644330dc), UINT64_C(0x9da3c936a3eaeed0) }},
  {{ UINT64_C(0xe7bf092bdbcd2be0), UINT64_C(0x5bdc1e4b57a0530c), UINT64_C(0x58d6c57ba3b6d8a6), UINT64_C(0x7e9ec54d2e81f82d) }},
  {{ UINT64_C(0x130f8304b4ba5b42), UINT64_C(0xd57a23777837e998), UINT64_C(0x0076ec11713ca506), UINT64_C(0xfb37b036211edc6d) }},
  {{ UINT64_C(0x685f7d9c49abc535), UINT64_C(0x80be40638cfbf2dc), UINT64_C(0x14058758c89a2a17), UINT64_C(0xc9356efb681e7aae) }},
  {{ UINT64_C(0x2369a97b9037bf66), UINT64_C(0xc49a121ad9104bef), UINT64_C(0xc830273df1948354), UINT64_C(0x53665e493da2f37a) }},
  {{ UINT64_C(0xeb510b7f90cb1d90), UINT64_C(0xa6efbf9d05c844eb), UINT64_C(0x1f67e235aeb6a8de), UINT64_C(0xa81d260931da9df6) }},
  {{ UINT64_C(0x8029c628897aa35a), UINT64_C(0x683e26eda83fb312), UINT64_C(0x5d96d53a9ab54015), UINT64_C(0xb717fdc6d90ae270) }},
  {{ UINT64_C(0xbacbe7d1007ee07b), UINT64_C(0xecceda5eac8ae770), UINT64_C(0x5276406bb0107b33), UINT64_C(0x8ebdf892114884d2) }},
  {{ UINT64_C(0x5556265331ccb865), UINT64_C(0x519953589d8f3f97), UINT64_C(0xc6fff1c96373d408), UINT64_C(0x51782921c8ddea82) }},
  {{ UINT64_C(0xe50a689007e399b7), UINT64_C(0x3a3dc251793fe8cd), UINT64_C(0xd8d3548dcd31e216), UINT64_C(0xacab58281fa130f5) }},
  {{ UINT64_C(0xd9377cfe9cad66a6), UINT64_C(0x354a1e3eb6874d4c), UINT64_C(0x01dd0292dcbfb517), UINT64_C(0xa44c05b08809fd24) }},
  {{ UINT64_C(0x09c826203498c840), UINT64_C(0xa254236333b5585a), UINT64_C(0x95b836d6a9cbcd16), UINT64_C(0xd6e14c79f343b863) }},
  {{ UINT64_C(0xf86dfa652da4e052), UINT64_C(0xa12a23ee3745bed4), UINT64_C(0xf3468308e80d521c), UINT64_C(0x0523c3a1dc8c97be) }},
  {{ UINT64_C(0xdc094b778da30102), UINT64_C(0x7109a3f6570534b5), UINT64_C(0x156fd55e7685fb1e), UINT64_C(0x42335e9977df68e3) }},
  {{ UINT64_C(0x7086e6bf90fa6ec2), UINT64_C(0x2ccc2a9d242ded25), UINT64_C(0x690266d07ae2dfe6), UINT64_C(0x6f6566d34a7d400b) }},
  {{ UINT64_C(0xfc36acb875c664c6), UINT64_C(0xb69e0775d0bf309a), UINT64_C(0x58e7d0834f6312f8), UINT64_C(0x4ea3661b835c4989) }},
  {{ UINT64_C(0xf985817e36ff8ff4), UINT64_C(0x5be6fbb5c513c515), UINT64_C(0x03755a7ce24e57b7), UINT64_C(0x061605cadc68d6da) }},
  {{ UINT64_C(0xa65c8bc0a441eedb), UINT64_C(0x395887666b9105e2), UINT64_C(0x1f4c127aed7d2d5f), UINT64_C(0xb02f2e726257d7c6) }},
  {{ UINT64_C(0x4fc493c7d08042b3), UINT64_C(0xc5b7b15e753077ac), UINT64_C(0x8202b21821b95e81), UINT64_C(0x6e4cc0268cc3e9c1) }},
  {{ UINT64_C(0xe93872d9e3cbe053), UINT64_C(0xab3aabc9c88e9abe), UINT64_C(0xd395b570671d6c42), UINT64_C(0x69ed0b1c786d6d05) }},
  {{ UINT64_C(0xd9d62530c9f68069), UINT64_C(0x6aabc6cc4909da07), UINT64_C(0x900fa00a4a50b67d), UINT64_C(0x8d68b8efa7895349) }},
  {{ UINT64_C(0xf9025c8e49167393), UINT64_C(0xe69177f7bb3f1e15), UINT64_C(0x480466d989208050), UINT64_C(0x1654fdd1366abcdb) }},
  {{ UINT64_C(0x06eb4114619977bd), UINT64_C(0xc3596ec85fdf6bb8), UINT64_C(0x250ceb38de453820), UINT64_C(0xdb9bbb34eaea20be) }},
};

static const block_t Zi_11[] = {
  {{ UINT64_C(0x579ba64fc7f8fe5a), UINT64_C(0xcc1f51ac524c73b4), UINT64_C(0x711e21c77869301d), UINT64_C(0x9ab6c853d3a51c97) }},
  {{ UINT64_C(0x8051203d69667bbf), UINT64_C(0x21d8ba978cea07a9), UINT64_C(0xedca4d7d2725a430), UINT64_C(0x9cf352426930d62b) }},
  {{ UINT64_C(0xadf724489f16e047), UINT64_C(0x857b368b17a5e0e8), UINT64_C(0x2d12c2f935c06b72), UINT64_C(0x43ed95fba7b02bb2) }},
  {{ UINT64_C(0x12e0b0047210cbe5), UINT64_C(0xcd0bf9cd033b917f), UINT64_C(0xc86fe38302a1abc2), UINT64_C(0x684942b397310981) }},
  {{ UINT64_C(0x67b128083dcd108a), UINT64_C(0xfd074579264bb1f2), UINT64_C(0xe06f2344fb69fc26), UINT64_C(0x50eb08f72bbcb4b3) }},
  {{ UINT64_C(0x47597faf1c2e6788), UINT64_C(0xab70c2235645332c), UINT64_C(0x2c5e493bbe0384cd), UINT64_C(0x2799f3d1669d6101) }},
  {{ UINT64_C(0xcc1f66df35c56956), UINT64_C(0x6cd1fc56feab48a0), UINT64_C(0x5341ded50e82bfce), UINT64_C(0x7bb0e2ee33252cbd) }},
  {{ UINT64_C(0x40de2cce2a2b8a90), UINT64_C(0x85cdf79f7cc234bb), UINT64_C(0x9f6c79d41734958b), UINT64_C(0x7af1552ddce7d7ef) }},
  {{ UINT64_C(0xe0f3446dd1682d11), UINT64_C(0x7d4d0e4f607f74ec), UINT64_C(0x3315af46b71aa2bf), UINT64_C(0x465a7a7da4682fcd) }},
  {{ UINT64_C(0x1d6e43802bd80aa5), UINT64_C(0xd4448ce3101f132d), UINT64_C(0xea0ba55a07976f59), UINT64_C(0x4e804de996ca749d) }},
  {{ UINT64_C(0xec13949a07629913), UINT64_C(0x7c6a599b5b31b72b), UINT64_C(0x21849e090327b54e), UINT64_C(0x17eabbbac9f4fabd) }},
  {{ UINT64_C(0x9504bacdd058877f), UINT64_C(0xa4032ae153705ea8), UINT64_C(0x24cae76190f53022), UINT64_C(0xb206c9e36594e6fe) }},
  {{ UINT64_C(0xb8fa3995638eb282), UINT64_C(0xb243961c56df0250), UINT64_C(0x86701a3995d07fe2), UINT64_C(0xdd34a77f7bca945e) }},
  {{ UINT64_C(0x54c9ffa517dd7195), UINT64_C(0x3b5772c4fb86e3aa), UINT64_C(0x93f97be4d04e56ea), UINT64_C(0xece3da86403f8ce3) }},
  {{ UINT64_C(0x94af9cac755143af), UINT64_C(0x280cca75c301fae1), UINT64_C(0x22e2a44e058b5a39), UINT64_C(0x65c56b201eee4e87) }},
  {{ UINT64_C(0xd234f272dd1e5562), UINT64_C(0x2573f820a4103a63), UINT64_C(0xf05b172a749c6a4c), UINT64_C(0xcf2d87f4897da106) }},
  {{ UINT64_C(0x7570d4a715fddfc4), UINT64_C(0x1219f50a5f56b1f0), UINT64_C(0xc5354e463b4156c1), UINT64_C(0xae8f04e17d7b0313) }},
  {{ UINT64_C(0x17ad78588fb90664), UINT64_C(0x08d0b5a979e08000), UINT64_C(0xd511c1c5b8713b9b), UINT64_C(0xe9a35a1086485acd) }},
  {{ UINT64_C(0x50eb86e41bba99c6), UINT64_C(0x2c71c47ad313fbc5), UINT64_C(0x2306fcebd0e114ba), UINT64_C(0xdb22c43613ba6a12) }},
  {{ UINT64_C(0x96d379dc0fd4f580), UINT64_C(0x384bc169327a5948), UINT64_C(0x6561d263fccf5100), UINT64_C(0x658861a8aee6763b) }},
  {{ UINT64_C(0x104bc1505b345032), UINT64_C(0xc163a677afecbfb6), UINT64_C(0x5908b14cd05fd9f8), UINT64_C(0x8fd0965f8b8eb22b) }},
  {{ UINT64_C(0x6e1838b956226b27), UINT64_C(0xc7a709286db6831c), UINT64_C(0x1ac1c69fc9ad7784), UINT64_C(0x0802be334625f5de) }},
  {{ UINT64_C(0xcc09101ec27ffdec), UINT64_C(0x7c15b4354f77b69d), UINT64_C(0xb0275fa40b86af50), UINT64_C(0x7bf7baccd187aa0b) }},
  {{ UINT64_C(0x42aa2dbfd29b7721), UINT64_C(0x4ee89c126b631a5e), UINT64_C(0x2e49ae15f8c68e50), UINT64_C(0xf2353383eb34010d) }},
  {{ UINT64_C(0x46d8280b8d37969a), UINT64_C(0x2e6a915ff19d2790), UINT64_C(0x245cde1336ccc05d), UINT64_C(0xb695499bd1c034c4) }},
  {{ UINT64_C(0xb1ffa60f9539ee05), UINT64_C(0x87514a45a5aa45df), UINT64_C(0x8ca443b2772433ee), UINT64_C(0x8eec3e5cb78c5b85) }},
  {{ UINT64_C(0x9961266d2427515c), UINT64_C(0xb284674d72e05534), UINT64_C(0xb1e9772fbc71fe7a), UINT64_C(0x74b7a82b111069ac) }},
  {{ UINT64_C(0xac4d73792cea9b47), UINT64_C(0x643afcfc2e5ab4df), UINT64_C(0x7f7845f2d3759b5a), UINT64_C(0xd4a3c41cb99bb81e) }},
  {{ UINT64_C(0x2ed056cb3e12244c), UINT64_C(0xd49df6937f5f5b25), UINT64_C(0x08457031da289500), UINT64_C(0x65976a3dbe1a1a17) }},
  {{ UINT64_C(0x4486f85ee23430db), UINT64_C(0x3aa2a92870a895a9), UINT64_C(0x8fc295ce767974e6), UINT64_C(0x7dcf00848e233ad5) }},
};

static const block_t Zi_12[] = {
  {{ UINT64_C(0x5549ab790777a7e8), UINT64_C(0xa001cbf44f15c1ec), UINT64_C(0x983e754d5f9c9536), UINT64_C(0x4db60607491d0d8a) }},
  {{ UINT64_C(0xd1c8d90fedc98213), UINT64_C(0x238293544c1c5e25), UINT64_C(0x03e1c9eafa383d80), UINT64_C(0x1064bcd246de23d8) }},
  {{ UINT64_C(0x3cdd673536003316), UINT64_C(0x4b9e7a10e10d7df0), UINT64_C(0x85d644c825d95082), UINT64_C(0x8c71c2af9342ccc9) }},
  {{ UINT64_C(0x679c979f009a4bdc), UINT64_C(0xc64c19f3646896b5), UINT64_C(0xf9e04282ed55395b), UINT64_C(0xdb3d339baa005396) }},
  {{ UINT64_C(0x0c1d8924686d480a), UINT64_C(0x2ebba548cdc427c1), UINT64_C(0xb8730b22f63201d9), UINT64_C(0x1de90feae674dc46) }},
  {{ UINT64_C(0xf522250323624259), UINT64_C(0xe8e2073f6de192e2), UINT64_C(0xb553102813748c62), UINT64_C(0x48ec79e74692a8d6) }},
  {{ UINT64_C(0x309ac2c94ce7b5ce), UINT64_C(0x97c6ab06954120bb), UINT64_C(0xe9077a41a70c57ca), UINT64_C(0xe4629a3a4dd87a9b) }},
  {{ UINT64_C(0x18cc352530699a8b), UINT64_C(0x71231471743eadb7), UINT64_C(0xf04015539331c690), UINT64_C(0x679c277eebddb248) }},
  {{ UINT64_C(0x39a3999e843eb950), UINT64_C(0x78cd42fb3909cd3e), UINT64_C(0x3ca3e53a66dd8950), UINT64_C(0x80745d4912f0317f) }},
  {{ UINT64_C(0x44f85587ad3c51a4), UINT64_C(0xfc6625b873b88174), UINT64_C(0x19a5df99e023752c), UINT64_C(0xe84c0e3cc30e6a16) }},
  {{ UINT64_C(0x52e1c82fcd7cf8aa), UINT64_C(0x64bad87ff5b710f7), UINT64_C(0xd033a55942cc45fe), UINT64_C(0xb4c806b21b4a1abd) }},
  {{ UINT64_C(0x0db1f6f157214bc2), UINT64_C(0x56fb1dd53ec62cf0), UINT64_C(0x7582a69359708488), UINT64_C(0x38767e328a29743e) }},
  {{ UINT64_C(0x5638e012a84f7785), UINT64_C(0x54b39b3a5b777a60), UINT64_C(0xe641f5791c9f907e), UINT64_C(0xe16ee500f121b3d1) }},
  {{ UINT64_C(0xda12911dbce5af87), UINT64_C(0xd109a4246399be7c), UINT64_C(0x773fe7361898ce47), UINT64_C(0xd79e1a4f16980347) }},
  {{ UINT64_C(0xf3de18e4f0368a9d), UINT64_C(0x5194fa310e4c9eac), UINT64_C(0x6a3413de2079bbd8), UINT64_C(0x2eefa50b4f12bc94) }},
  {{ UINT64_C(0x0ff6c79d7f955fd7), UINT64_C(0xf0917b026d0e273b), UINT64_C(0x9aa65e92cb845e00), UINT64_C(0xcb388963c98de88c) }},
  {{ UINT64_C(0xdf3fc49c2110b68b), UINT64_C(0x4259fcedbe70e2ab), UINT64_C(0x36722e0f23a63ed7), UINT64_C(0x9fb49a484b5ee887) }},
  {{ UINT64_C(0x3bf25c251411fe8e), UINT64_C(0x51a278ef7fc4f0c9), UINT64_C(0x2b65b0392a22131f), UINT64_C(0x35d74dc34a7c90fa) }},
  {{ UINT64_C(0x1a59b48ac930a5a3), UINT64_C(0x3ca32bb2ae2fdd76), UINT64_C(0xb92c49cd3d372fad), UINT64_C(0x8705b1040b9755f8) }},
  {{ UINT64_C(0x4874dc830fafe2a5), UINT64_C(0x0b1b585ce402b73f), UINT64_C(0x5c2d3c434eb75610), UINT64_C(0x3a4fd7091dfff70e) }},
  {{ UINT64_C(0xb6b0f7ff7f1f22db), UINT64_C(0x000a03fa15dbbc84), UINT64_C(0x043dcd1fc79c437b), UINT64_C(0x58e828d2ea77e43c) }},
  {{ UINT64_C(0xc1a6f45d32b91d51), UINT64_C(0xaca453867fbe0c00), UINT64_C(0x8377a6dfe8c83683), UINT64_C(0x43ec12503fce6624) }},
  {{ UINT64_C(0xa7558d94563be0e5), UINT64_C(0x8c8ec95cf9fe69b9), UINT64_C(0x80fd51b15925c3e1), UINT64_C(0xf86671dd475d8a0e) }},
  {{ UINT64_C(0x24d59c72ff4b5dc5), UINT64_C(0x94bd6119317fc145), UINT64_C(0x557022caf901602a), UINT64_C(0x0c42c7fefca0733c) }},
  {{ UINT64_C(0x53fc5710752b0497), UINT64_C(0x6b813c7c5c69e973), UINT64_C(0x8a0e4f4c1ab90939), UINT64_C(0x55b0fe7563b67261) }},
  {{ UINT64_C(0x4884af2603ef50f9), UINT64_C(0x9ad8ef699748c97a), UINT64_C(0xfbb4f5a64265dd45), UINT64_C(0x08d0f1dd69eaf34f) }},
  {{ UINT64_C(0x5afce388bbee16ae), UINT64_C(0xa28a5547087cd895), UINT64_C(0x16ea7d1a6fd46b7a), UINT64_C(0x9629feece9db3f4c) }},
  {{ UINT64_C(0x5199c43077c28c90), UINT64_C(0x5b66334621fa9933), UINT64_C(0xd055f0e7bd4f3884), UINT64_C(0xf1b8f773ba04d8b2) }},
  {{ UINT64_C(0x7a77a75b8dfdb625), UINT64_C(0x555369d8def143f1), UINT64_C(0x304ab9bbe5c77dc3), UINT64_C(0xe01bb93b949f1cfd) }},
  {{ UINT64_C(0x7f0a0e5e57252f73), UINT64_C(0xd3cce10159c336cf), UINT64_C(0xf10606158dd5d1af), UINT64_C(0xaa56706df8155df6) }},
};

static const block_t Zi_13[] = {
  {{ UINT64_C(0x37d31174a2cd9265), UINT64_C(0x48ecd6837ac8339f), UINT64_C(0x7c65c68f28fdfdd0), UINT64_C(0x20080fea814cf80f) }},
  {{ UINT64_C(0x9a3284f53c776d57), UINT64_C(0xbb55049df18d5da4), UINT64_C(0x5fc009ddaa92988b), UINT64_C(0x866e9b0bd7d57caf) }},
  {{ UINT64_C(0x5b2c9415fe57086d), UINT64_C(0xac1dab52fe3e26e7), UINT64_C(0xea79c8172fb710a5), UINT64_C(0x648cd331895bbcdd) }},
  {{ UINT64_C(0xc0cbf04d97c6d696), UINT64_C(0x0c74e12ecf1e8706), UINT64_C(0xc07b3dc2ff61683a), UINT64_C(0x59187c89d4c92f61) }},
  {{ UINT64_C(0x23a3764f80e28cb0), UINT64_C(0x0864624a50398f3d), UINT64_C(0x2a26ff8affbabc32), UINT64_C(0x46d9e893d4d916e0) }},
  {{ UINT64_C(0x37d5a00ef9792b8b), UINT64_C(0x245f9305578da4f5), UINT64_C(0x28c7ce7d8789754d), UINT64_C(0xac20585b3c546c74) }},
  {{ UINT64_C(0x1a69d49e2a8b5d87), UINT64_C(0x7bbc35cc1b43487c), UINT64_C(0xd191b1dc55dbdb79), UINT64_C(0x99481110467fc7df) }},
  {{ UINT64_C(0x4137e90a0396412a), UINT64_C(0x64e87234ec3bfcd3), UINT64_C(0x9a22f83d8bf6c721), UINT64_C(0xd2d61e2f35061cdb) }},
  {{ UINT64_C(0x4af38c0714013246), UINT64_C(0x7cbd9b1a474e28ee), UINT64_C(0x56d957ef0b4f0554), UINT64_C(0xdc8328a9f350a604) }},
  {{ UINT64_C(0xe72283152042e38f), UINT64_C(0x6b28a12249ffefeb), UINT64_C(0x21f5585fee27f982), UINT64_C(0x4233e9c3b1c65695) }},
  {{ UINT64_C(0x67beab4c283f30ab), UINT64_C(0x4810fe8ad2073575), UINT64_C(0x9d40d69459bcbed1), UINT64_C(0x53ec2c2d79e7d3f1) }},
  {{ UINT64_C(0xc466a5040aaf0398), UINT64_C(0xb8a4fcda538befc6), UINT64_C(0x5b4376a925cb3d67), UINT64_C(0x27690734d852037e) }},
  {{ UINT64_C(0x0574c6d567f27c22), UINT64_C(0x258439acf601305d), UINT64_C(0xf80c2d88860d8e79), UINT64_C(0xcf40cfede591c951) }},
  {{ UINT64_C(0x974c1a89ad35c8b6), UINT64_C(0xc37e665a919a6b6a), UINT64_C(0xccf96bdbfd31badf), UINT64_C(0x684da17eb3b4bee3) }},
  {{ UINT64_C(0xa6533103cb22fa91), UINT64_C(0x93fa8a4e444f7749), UINT64_C(0x751575f172df74b2), UINT64_C(0xc0fcfdb6367021c0) }},
  {{ UINT64_C(0xdbf24a16bb4e7a39), UINT64_C(0x9d1f834bc2f29653), UINT64_C(0x944bb76ecbe3128f), UINT64_C(0x43f1a781bb635a24) }},
  {{ UINT64_C(0xfad30728114bf224), UINT64_C(0x6afe51ee4f131d8f), UINT64_C(0x621120b9cd111714), UINT64_C(0xdcd8580294a09a61) }},
  {{ UINT64_C(0x77a1bdbc3d7636a0), UINT64_C(0xea57905d87f6c35c), UINT64_C(0xe109b9bd11b96d47), UINT64_C(0x1dd3591069c266af) }},
  {{ UINT64_C(0xd4a764f21e952dc6), UINT64_C(0xa205dc2108f7507b), UINT64_C(0x9b05261158577eaa), UINT64_C(0xff80815d283688a0) }},
  {{ UINT64_C(0x7467446d0b278e89), UINT64_C(0x2cea49ab0e3fe462), UINT64_C(0xee49b5f2e75526fb), UINT64_C(0x27d7c48fb6bcd343) }},
  {{ UINT64_C(0x2380783cdd6c1e9a), UINT64_C(0xe0b00c7eb53f216e), UINT64_C(0x41e9568521dde40e), UINT64_C(0xccbbbba40d3b6b2f) }},
  {{ UINT64_C(0x32bdd22e9b39a817), UINT64_C(0xcbddd3cb7aecbce5), UINT64_C(0x6efd0bf969d1bf22), UINT64_C(0xe359e69129b74c4a) }},
  {{ UINT64_C(0x86ee36583922c812), UINT64_C(0xb55f83ca57cad503), UINT64_C(0x6f3d0038033f3f75), UINT64_C(0xe231e47f70c1cb45) }},
  {{ UINT64_C(0xb7739cc6f385b145), UINT64_C(0xcc211f5b9c8e68e6), UINT64_C(0x9689f3f5bdac5308), UINT64_C(0x98858aca08ec37cf) }},
  {{ UINT64_C(0xad44189cf078105b), UINT64_C(0xea3a221a1c5bee7d), UINT64_C(0x852d9e9f2f2ad4bd), UINT64_C(0x06db9552366de7e6) }},
  {{ UINT64_C(0x81828133ea4f3544), UINT64_C(0x4e5b5994dfb57602), UINT64_C(0xc5c1ccbb08b08c45), UINT64_C(0x44ed6f92fad538f0) }},
  {{ UINT64_C(0x27962c93f14621af), UINT64_C(0x6582345a82482096), UINT64_C(0x8898c2b765e9ce08), UINT64_C(0x196a87d49d707d0c) }},
  {{ UINT64_C(0x22fe3e57926475b7), UINT64_C(0xb04e8ee3d5acb63a), UINT64_C(0x02c4a036dc0fad0d), UINT64_C(0x71f442e85cfc5b1a) }},
  {{ UINT64_C(0x515a18385f22f3c2), UINT64_C(0x032b850d07e71a36), UINT64_C(0x88afb6d52fe8730d), UINT64_C(0x32c13e5a38c0a07e) }},
  {{ UINT64_C(0x84a4ae07946126bc), UINT64_C(0xa23084b177413712), UINT64_C(0x307f8ccca321dd51), UINT64_C(0x18e848d5679fce47) }},
};

static const block_t Zi_14[] = {
  {{ UINT64_C(0x6947ca6c775f8d78), UINT64_C(0x8c2e39489fc0b7b3), UINT64_C(0x1d8bf2ab42d40d29), UINT64_C(0xd37b6493d5df44f7) }},
  {{ UINT64_C(0x0a4e8df6fa5875a7), UINT64_C(0xc6fdc744ba9f07f7), UINT64_C(0xaafa0b2ff6686753), UINT64_C(0x5dd3f6b1970e2ac6) }},
  {{ UINT64_C(0x704e66472fa4f47a), UINT64_C(0x9e09681aa9969ca0), UINT64_C(0x90028d4d1e7c64e4), UINT64_C(0x034347841b406e2c) }},
  {{ UINT64_C(0xa8ad019e897532fb), UINT64_C(0xeda83386cc631b7b), UINT64_C(0xaf5c2461d899b531), UINT64_C(0xead01ae9d120cd51) }},
  {{ UINT64_C(0x2d247424e10a5622), UINT64_C(0x04daa298c2f1fbaf), UINT64_C(0x3f6ae73642afb7b1), UINT64_C(0xc1d1bb016efc2348) }},
  {{ UINT64_C(0x873fd5617b1ef87c), UINT64_C(0x5997cf3ae11411d6), UINT64_C(0x978299018ca228df), UINT64_C(0xf4a596a43d837412) }},
  {{ UINT64_C(0x9561c177033584a3), UINT64_C(0x4f2df3d0046184b1), UINT64_C(0xa1fce12a16ceb402), UINT64_C(0xd7f79e9b90ca77fc) }},
  {{ UINT64_C(0x2af463713bda3b50), UINT64_C(0xf16149fb32170139), UINT64_C(0xc008cbdbc35710ee), UINT64_C(0xce73a014666ebe45) }},
  {{ UINT64_C(0xe5aa36a9dfcc67cd), UINT64_C(0x1b8b8db8a7c29ccd), UINT64_C(0xb3e1ccabaa701e30), UINT64_C(0x8dc925e0447a855c) }},
  {{ UINT64_C(0x89519506a58e0f7e), UINT64_C(0x14c0f9106a88aeb5), UINT64_C(0x025a66e9869f72f6), UINT64_C(0xfb330355cdce1c56) }},
  {{ UINT64_C(0x2e7ad90133b07834), UINT64_C(0xff4c59bb48a183a8), UINT64_C(0x9ebbcb0f5cc80291), UINT64_C(0xf627050d0fffaebb) }},
  {{ UINT64_C(0xfb8e9f73f3750611), UINT64_C(0xc57d66b1d4a25518), UINT64_C(0x25e800cb52a6c059), UINT64_C(0x6a0a40361842cd3d) }},
  {{ UINT64_C(0x79e9723462303204), UINT64_C(0xd06e6b5204e9e2ba), UINT64_C(0xa771c28c6c93c568), UINT64_C(0xbf4f603206d0749e) }},
  {{ UINT64_C(0x72b3e913d3f47a6c), UINT64_C(0x2d1fa958fe421c59), UINT64_C(0x18f0115702afab02), UINT64_C(0xa28789183d9cd61d) }},
  {{ UINT64_C(0x9b3531c8fb49f13d), UINT64_C(0x33494b0b141ad63d), UINT64_C(0xcf3a1dcbeedfe4d1), UINT64_C(0x4179cd314088ed27) }},
  {{ UINT64_C(0xcfe6869811c76ea0), UINT64_C(0x7c4bbe2b3f0ed08d), UINT64_C(0x24522551041befb5), UINT64_C(0x3421f0d02c1c9d78) }},
  {{ UINT64_C(0xf737c37a6176ec43), UINT64_C(0x6a5fc3653f5605fe), UINT64_C(0x9ee872e482a82889), UINT64_C(0x72dcb10142c223c9) }},
  {{ UINT64_C(0x1f26bea86a7f67bf), UINT64_C(0xf400213953b4b2ac), UINT64_C(0xb3f06b9320e02cc9), UINT64_C(0xf36677074c993021) }},
  {{ UINT64_C(0xcdbdfa37c0aaae50), UINT64_C(0x6f3e28acabd36daa), UINT64_C(0x9ac121c3a5f1996d), UINT64_C(0x4340b84f2ac27559) }},
  {{ UINT64_C(0xe8b93927b9e389c8), UINT64_C(0x6702ee9cec646aeb), UINT64_C(0xa18e18e39de95317), UINT64_C(0x72db244f57e2552a) }},
  {{ UINT64_C(0xf9a22c1cb8b87a1e), UINT64_C(0x185233ccd08198ec), UINT64_C(0xb34361678c601d5a), UINT64_C(0x0b6e616ee32dbf66) }},
  {{ UINT64_C(0x70fa10eeaf7779a1), UINT64_C(0x84be212ea1e5acd3), UINT64_C(0x3b9f8700bb04e85e), UINT64_C(0x0aba93deec9ca176) }},
  {{ UINT64_C(0x48dff620dcf8863c), UINT64_C(0xe1a47353f188e811), UINT64_C(0xddae3df46be7bcd4), UINT64_C(0x73eee7acf4b766ac) }},
  {{ UINT64_C(0x401203fc5d245c56), UINT64_C(0x545a5ab70cac3210), UINT64_C(0xb25e05224cbf4422), UINT64_C(0x4eb7bfdff2fc21ba) }},
  {{ UINT64_C(0x861d8a42afde48d7), UINT64_C(0xb7808bf90453ff4d), UINT64_C(0x00b11bd26a712c90), UINT64_C(0x3b0ee04c9853dc6a) }},
  {{ UINT64_C(0x57c284a6064869de), UINT64_C(0x94f64c665ca09e96), UINT64_C(0x018ca357f62e5d48), UINT64_C(0x3f84118692f8bec6) }},
  {{ UINT64_C(0x7610d061ebd587e6), UINT64_C(0xf566d8accf370f50), UINT64_C(0xbfbdcf1a328feda3), UINT64_C(0x215c0c89c148fd60) }},
  {{ UINT64_C(0x988d3c56a0ed847c), UINT64_C(0x5b5d168bb461b795), UINT64_C(0x3b8e6c742267fa4d), UINT64_C(0x03f8ea3d53650b48) }},
  {{ UINT64_C(0x9b304171111c0616), UINT64_C(0x297e28098176d15c), UINT64_C(0xee6c7168c5d3befe), UINT64_C(0xf12107d46dbad2d6) }},
  {{ UINT64_C(0x153ca44fa961e485), UINT64_C(0x76b949250c5af26e), UINT64_C(0xf1155c952d7b1e6b), UINT64_C(0x4672a70435a49a4a) }},
};

static const block_t Zi_15[] = {
  {{ UINT64_C(0xe9f56125fde0f30b), UINT64_C(0x2bd2ecd8b1f71bb7), UINT64_C(0xfbe5b35a8fbcfe6b), UINT64_C(0xe3f4d16807fc0537) }},
  {{ UINT64_C(0xe4c74807fc7b5aad), UINT64_C(0xb6bad6db8f875d0f), UINT64_C(0xe2f27c1a670bf7f0), UINT64_C(0xe75a8a04a2d32872) }},
  {{ UINT64_C(0xc906c6b4dbcf981b), UINT64_C(0x1be46a535e904e92), UINT64_C(0xa6621f2676c33727), UINT64_C(0x549a755d6237948b) }},
  {{ UINT64_C(0xd3bf395cc5ab46f2), UINT64_C(0xee7abcad7fbc87ef), UINT64_C(0xedb7389f79891067), UINT64_C(0xd06f7315fbb3f44f) }},
  {{ UINT64_C(0xa881efda154c1fec), UINT64_C(0xac9de1388ae182b3), UINT64_C(0x19dfb509c8e4eb44), UINT64_C(0x28d1dcd6ee1b225d) }},
  {{ UINT64_C(0xa6c91326ffd87c77), UINT64_C(0x8fbc940b650f75f8), UINT64_C(0x601c4819ddd929e6), UINT64_C(0x12f910bb17be5ab2) }},
  {{ UINT64_C(0xbf9305832ec9d4f1), UINT64_C(0x84dd7bf8dbc8f54b), UINT64_C(0x18172b25a47fae6e), UINT64_C(0xc57d150259f7a6c8) }},
  {{ UINT64_C(0x3ca7df37c1b27711), UINT64_C(0x3ff0f87af1a58c9d), UINT64_C(0x8a7a7dce7ce964d9), UINT64_C(0xb7bdaf7c9c2a40c7) }},
  {{ UINT64_C(0x6e57f629bd3c0e41), UINT64_C(0x2567fb4b4dab6f01), UINT64_C(0x011ff2c3d4530ee4), UINT64_C(0xbd160232f5c387b4) }},
  {{ UINT64_C(0xbfd10ed60f37544c), UINT64_C(0x36c41baa1cf64a46), UINT64_C(0xc9f270c462a2cc2d), UINT64_C(0xf752473674c3ed22) }},
  {{ UINT64_C(0xd50f7a093b885751), UINT64_C(0x46aff666280a6f41), UINT64_C(0x665c141e085fdcf9), UINT64_C(0xfdadcb362c6f810e) }},
  {{ UINT64_C(0x7a29b284b3c8948a), UINT64_C(0xb8ab7ab3ce046a43), UINT64_C(0x79141d52815bc3f1), UINT64_C(0xea7a605ff7a5de8f) }},
  {{ UINT64_C(0x0b936a66a4278dc5), UINT64_C(0x3d79451c06f8ba23), UINT64_C(0x14ccd64285af0d7b), UINT64_C(0x84fef99be0bd2701) }},
  {{ UINT64_C(0x0da821f249643e4d), UINT64_C(0x36e6f503e61180f0), UINT64_C(0x2df424de6cf32159), UINT64_C(0x45681defb71a2c1e) }},
  {{ UINT64_C(0x7d197001a68c303f), UINT64_C(0xb583ce5dded64941), UINT64_C(0xa2843c1d68e2c6b7), UINT64_C(0x6d6c84eb43caa2a9) }},
  {{ UINT64_C(0xfb3fd011d156b276), UINT64_C(0x1b7bd2c0dff5b505), UINT64_C(0x415385402bdab797), UINT64_C(0xc75e8383790fb0b1) }},
  {{ UINT64_C(0x9e558dd90e33108f), UINT64_C(0x03b9bb62a69f9806), UINT64_C(0x251f7f3c7bba2514), UINT64_C(0xb1aed9bdac7aa82a) }},
  {{ UINT64_C(0x6d8c6dc862e6ddf8), UINT64_C(0xc2092375f5557863), UINT64_C(0x6c5019a17d9b8c9b), UINT64_C(0x99ad6a76a288a36e) }},
  {{ UINT64_C(0x0161a944c6ccc930), UINT64_C(0xde3f06393f99744c), UINT64_C(0xbdba86e7416eae32), UINT64_C(0x8c9f56571e0a2c36) }},
  {{ UINT64_C(0x3ae62c7f958f0e85), UINT64_C(0xfa64a184493d6e37), UINT64_C(0x35c58f250a5eea74), UINT64_C(0x49ac88cccd18eb42) }},
  {{ UINT64_C(0x0688f8ba81101c00), UINT64_C(0x440846b60361ea50), UINT64_C(0x5ff7e4e5158097a0), UINT64_C(0x175cae40097ff09a) }},
  {{ UINT64_C(0x3a1b1e62a72a1389), UINT64_C(0x0f58ccd38e82dc0d), UINT64_C(0xbf582ee914e0758c), UINT64_C(0x6e07d5e4d29436a4) }},
  {{ UINT64_C(0x3a3e5a5a1d1f1855), UINT64_C(0x1af54284be7ddd6c), UINT64_C(0x7b22d6265f424568), UINT64_C(0x05211828c624f7ba) }},
  {{ UINT64_C(0xf26ddf900184ace8), UINT64_C(0x859d3e13366671cc), UINT64_C(0x55de6ce2609093ca), UINT64_C(0x309f484af1db0c3f) }},
  {{ UINT64_C(0xf1ee1992353a40a1), UINT64_C(0x75c1d741bc793152), UINT64_C(0x7003f14f14429443), UINT64_C(0x1219dae1363abd1f) }},
  {{ UINT64_C(0xfb1f2f021038f20f), UINT64_C(0x7e3354c3b7e5d726), UINT64_C(0x0149cd36c4ad78de), UINT64_C(0x6a2034e473a09b1f) }},
  {{ UINT64_C(0x4adbf9e5b567ba8e), UINT64_C(0x6f02ec1f8854a4b3), UINT64_C(0x470600842023ed03), UINT64_C(0xcbfa8a6c139a2bc3) }},
  {{ UINT64_C(0xf3ccbf9b93a7c3e8), UINT64_C(0xc4350c876cf92c49), UINT64_C(0x930349bdfbd5354f), UINT64_C(0x6fabf3c0f04ec49c) }},
  {{ UINT64_C(0xb3d7005b3469b02f), UINT64_C(0x5c8cc65140d915ce), UINT64_C(0x53ba5e84191d8183), UINT64_C(0x1152f14194f0fb21) }},
  {{ UINT64_C(0xe83c65c10c35d9eb), UINT64_C(0x862e27343635f3a9), UINT64_C(0xad4f8ef0dee5b96a), UINT64_C(0xae846d54cc61b8df) }},
};

static const block_t Zi_16[] = {
  {{ UINT64_C(0xdc3ca87747104404), UINT64_C(0xdbe403dda77a74fe), UINT64_C(0x1cd66b490fba5aa6), UINT64_C(0xeb0ed8900747a6db) }},
  {{ UINT64_C(0x7e86f2ee70abbd90), UINT64_C(0x78e53bca40d4a058), UINT64_C(0x9d6ceb53a692d372), UINT64_C(0x5b6e5e49460f13b4) }},
  {{ UINT64_C(0x5ac66b1a2c5d8754), UINT64_C(0xa11eb5794c94a4a2), UINT64_C(0xf6005c7cc494baaf), UINT64_C(0xfe1255cdf5ec137d) }},
  {{ UINT64_C(0xe2acad5a20839850), UINT64_C(0xd088bad944e3f2fe), UINT64_C(0xa2f72f1884fd061a), UINT64_C(0x043c7b4a1693a911) }},
  {{ UINT64_C(0x7d11adc06edad93a), UINT64_C(0xe7d786620f9b06ca), UINT64_C(0x35f276fda1b4b191), UINT64_C(0x8ffdaab21c7539f9) }},
  {{ UINT64_C(0x1ff9352d8a56d88b), UINT64_C(0xa67f11f1d1002151), UINT64_C(0xf26f026b453f0ee5), UINT64_C(0xa747cce8d6de23c0) }},
  {{ UINT64_C(0x7ef020e57d842ac0), UINT64_C(0xb51a19e8e6e80659), UINT64_C(0xaed1051d4649045a), UINT64_C(0x2a86b59e94b5ba96) }},
  {{ UINT64_C(0x5bcde1d6407b94e0), UINT64_C(0x798a93cfdba2ec15), UINT64_C(0x2844d2c9cc351c19), UINT64_C(0x7451f83cce955d37) }},
  {{ UINT64_C(0x4c80620f5f9ceff3), UINT64_C(0x9b21f2a3fe0b0326), UINT64_C(0x6b281af90df8cf68), UINT64_C(0xdab68cdcf1d8d34c) }},
  {{ UINT64_C(0xa05ebd82875cfe2b), UINT64_C(0x823aca9b865fd0fd), UINT64_C(0x8a8b1782be6f03d8), UINT64_C(0xfc48a871cd3d3543) }},
  {{ UINT64_C(0x1ccb1e80749f672b), UINT64_C(0x4a44a0089736c914), UINT64_C(0xb69f2e04a41216aa), UINT64_C(0x3a05be971e10fafc) }},
  {{ UINT64_C(0xfc1137120e5ca7c5), UINT64_C(0xac77809757d40447), UINT64_C(0x6f557a410f345e49), UINT64_C(0x63521ea864d3f559) }},
  {{ UINT64_C(0x6adc7675513cd942), UINT64_C(0x5b8fb433a6a77e8f), UINT64_C(0x5126f59f9ef7318e), UINT64_C(0xd3d14da96b7d9ecc) }},
  {{ UINT64_C(0x2a6dac2e7922f7a8), UINT64_C(0x90beac91b9ee79bf), UINT64_C(0x8bc9c00173978cd6), UINT64_C(0xe46c81f7b6bfa83f) }},
  {{ UINT64_C(0x69d5905da53017ee), UINT64_C(0xb4087e5217a1801b), UINT64_C(0x1d1b44783b91aed2), UINT64_C(0x0432721940f3d2ca) }},
  {{ UINT64_C(0xb471b3f35a4d122f), UINT64_C(0xb5a0a10f6709548d), UINT64_C(0xc76340f174e8ee14), UINT64_C(0xe3fd40fb3e5156eb) }},
  {{ UINT64_C(0x2bcf0d79c07e4133), UINT64_C(0x35655e190133578d), UINT64_C(0xf58c8eaf159aa8ec), UINT64_C(0x00802baf197ee8a3) }},
  {{ UINT64_C(0x8a55729448d00c23), UINT64_C(0x2479c6e52efa4ffb), UINT64_C(0xeb7b334acab55d58), UINT64_C(0x9466dc0874e5042b) }},
  {{ UINT64_C(0xb75a8705365a0414), UINT64_C(0xe4dd1d0951bc550c), UINT64_C(0xcd68cd5cc5f2b61b), UINT64_C(0x5f35a12aefec5725) }},
  {{ UINT64_C(0x3d395af0ddc5413b), UINT64_C(0x6d0a2b4a15416b66), UINT64_C(0x3c0e7ba1e5330024), UINT64_C(0xf4ff48c3f51ef7f4) }},
  {{ UINT64_C(0x59c9d9a30db4f25c), UINT64_C(0x47ce59d01b35a5f3), UINT64_C(0x15b9acde317a805c), UINT64_C(0x8d76be956b09d984) }},
  {{ UINT64_C(0x84018c68cf31cb06), UINT64_C(0x1d0a3862ecb1edf3), UINT64_C(0xbc871f043c3055cf), UINT64_C(0xfdae8371fda7402a) }},
  {{ UINT64_C(0x3040e1e3bf5bfe84), UINT64_C(0xae6d79d27620192a), UINT64_C(0xc96f8308636fb864), UINT64_C(0xbdb4b936db5789c7) }},
  {{ UINT64_C(0x11e764e1bfbad375), UINT64_C(0x379d8a8a2c792876), UINT64_C(0xab2ce87f537ff857), UINT64_C(0x086a72b69ce5dbc6) }},
  {{ UINT64_C(0x63b7b828557700e5), UINT64_C(0x8316bae4f101b612), UINT64_C(0x51775b6c68e445b3), UINT64_C(0x5ab37b49a8bbae58) }},
  {{ UINT64_C(0x9a507c915f74e641), UINT64_C(0xb861f2adccd48404), UINT64_C(0x31744d94f50f9181), UINT64_C(0x23e494e7a7ce034f) }},
  {{ UINT64_C(0x8da3a1d56cf6576e), UINT64_C(0xa7dab35d146c1da8), UINT64_C(0x013f48f07274537b), UINT64_C(0xd41af7bc7f9ec515) }},
  {{ UINT64_C(0x6cb01f188d5f37d8), UINT64_C(0xdddddb52e022add6), UINT64_C(0x239f4f26505f39d4), UINT64_C(0x7788d374a5c0bfec) }},
  {{ UINT64_C(0x45e2c44eaff116ed), UINT64_C(0x243f421a72d9b3bd), UINT64_C(0x499371151e8da21c), UINT64_C(0xa48b7904cc58b96f) }},
  {{ UINT64_C(0xc612c711ade54172), UINT64_C(0x7c113d1c670fe433), UINT64_C(0x2c602e774a945803), UINT64_C(0xf73357ab6415a2c0) }},
};

static const block_t Zi_17[] = {
  {{ UINT64_C(0x993892b27f64ff41), UINT64_C(0xc0c75f7eb25c8924), UINT64_C(0x40a5eac705676c93), UINT64_C(0xc502457bf1962b5c) }},
  {{ UINT64_C(0x10c5450a96f04443), UINT64_C(0xa4610e5c98b84a3a), UINT64_C(0x7558f4b2f47ad544), UINT64_C(0xf71b2dc1c0d08f7e) }},
  {{ UINT64_C(0xd1c0d104a422c8ac), UINT64_C(0xe8023fe16422f9cb), UINT64_C(0xecc6287fa4893293), UINT64_C(0xad85368eb06b5fca) }},
  {{ UINT64_C(0x5cdc48be0fdd430d), UINT64_C(0xd2ce8bd9d21ec5ac), UINT64_C(0xc656d580e40f9221), UINT64_C(0xb0c316986d394b5a) }},
  {{ UINT64_C(0xdcbc912b766f3c62), UINT64_C(0x6eeac3dd8ccf95fa), UINT64_C(0x579f5479a2221535), UINT64_C(0x7e92870481bd9c76) }},
  {{ UINT64_C(0x9b9f914849c64712), UINT64_C(0x710c024174f77d52), UINT64_C(0x8fe583d67a01a5a8), UINT64_C(0xd6f47a67ca8390f4) }},
  {{ UINT64_C(0x829bdfd575958329), UINT64_C(0x4b5b94169057332b), UINT64_C(0x8f7eb3b9662a1bfb), UINT64_C(0xf4cb94de9a02bd33) }},
  {{ UINT64_C(0xd7ce8ddd54e5e0fe), UINT64_C(0x75ef086d24e5f4e9), UINT64_C(0x5454e9a10d130f49), UINT64_C(0xfd29b78d38052fea) }},
  {{ UINT64_C(0xcef3123cc9e83364), UINT64_C(0x84beafecb42410bd), UINT64_C(0xaff51058c205510b), UINT64_C(0xe70195f705e38256) }},
  {{ UINT64_C(0x0aafae5794053588), UINT64_C(0x577f081f789057fa), UINT64_C(0x69ca4b60c0283536), UINT64_C(0xbdd23cb06b029511) }},
  {{ UINT64_C(0x06688353db6dfcc0), UINT64_C(0xa92da67ee03111e5), UINT64_C(0x26d2f022e715a40b), UINT64_C(0x6a65ef6bb92ca64a) }},
  {{ UINT64_C(0xb07557f68606b9f4), UINT64_C(0xf47875c86f3d7d81), UINT64_C(0x84d19f44909d8070), UINT64_C(0xb0666c079b33ba66) }},
  {{ UINT64_C(0xd4a69ec53ddd8162), UINT64_C(0x16e3236005504b71), UINT64_C(0x1abd719bc944a8f9), UINT64_C(0x497a1b1087a7ab26) }},
  {{ UINT64_C(0x8de151eb90d76e43), UINT64_C(0x459f4503789759d8), UINT64_C(0xfaf1ef480321b2ad), UINT64_C(0xcc009193b756caf7) }},
  {{ UINT64_C(0xa9aba41ece0563ac), UINT64_C(0x79099f57010364d9), UINT64_C(0x232f19056d05a735), UINT64_C(0x9740e224b29a31c5) }},
  {{ UINT64_C(0x8e965df29bf98a5a), UINT64_C(0xc78dabfc66f30eb0), UINT64_C(0x1b0458a189d98df6), UINT64_C(0x385505b08979d9bf) }},
  {{ UINT64_C(0xc518695d00318b70), UINT64_C(0xceb80d246c8b048a), UINT64_C(0x31c527a84a95e5c8), UINT64_C(0x4358c2e03243c13c) }},
  {{ UINT64_C(0xf676689b201a9c01), UINT64_C(0xbc40cc5285108604), UINT64_C(0x059a2b4b83e0297f), UINT64_C(0x27f9d8da28449d08) }},
  {{ UINT64_C(0x6419063169b573a4), UINT64_C(0x530fb91fadea9f11), UINT64_C(0xd0ee9d9cda664cb5), UINT64_C(0x542aa67114d89a44) }},
  {{ UINT64_C(0x17d92734d3fca994), UINT64_C(0x66816655a237e8df), UINT64_C(0x258315a098317189), UINT64_C(0x89f04e95ea05a07f) }},
  {{ UINT64_C(0x84941d2e31834095), UINT64_C(0x1a0a80f11ed6eaf7), UINT64_C(0x8c2a7c83eff4653a), UINT64_C(0x6d4e7ce524967a3e) }},
  {{ UINT64_C(0xd8fbe99834a1da94), UINT64_C(0xbb2710cef9200c93), UINT64_C(0x364946573f6b664c), UINT64_C(0xe4e176f9a008b9e2) }},
  {{ UINT64_C(0x9358388fbe1bac6f), UINT64_C(0x068cfc1dacf5900f), UINT64_C(0x682e6423ce7999b2), UINT64_C(0x34161756d06765fa) }},
  {{ UINT64_C(0x3dc068ce74f24725), UINT64_C(0xe8d9b0f7e27d1754), UINT64_C(0x3f69a9afa8821fda), UINT64_C(0x7f5ce1491df23f38) }},
  {{ UINT64_C(0x9c0c0ebde3966c4b), UINT64_C(0xa0b77bc4bca005db), UINT64_C(0x027d5d917de1fd52), UINT64_C(0xbe0f0be5791af33e) }},
  {{ UINT64_C(0xd8d3bc98e5001e1a), UINT64_C(0x47f70474180edccb), UINT64_C(0x867f268bf7c57cef), UINT64_C(0xa5b4c816adb4a593) }},
  {{ UINT64_C(0x8960524d951bbd20), UINT64_C(0x81448738c874dfd5), UINT64_C(0xbfed199a1c13c922), UINT64_C(0x07160123a62a2346) }},
  {{ UINT64_C(0xce2a96c0ec29f4f1), UINT64_C(0x58704b879a17102a), UINT64_C(0x6beb29731da1a34e), UINT64_C(0x0405ce3ef07c27d6) }},
  {{ UINT64_C(0xe57594845df6d5fc), UINT64_C(0x3afc2f192930f1a6), UINT64_C(0x439e43a645ef7ef3), UINT64_C(0x0a9ee951ab3ac549) }},
  {{ UINT64_C(0xee52f22b9289ae9a), UINT64_C(0x5e3a9def1fc7ba3c), UINT64_C(0x3b7386c631d3bf6f), UINT64_C(0x190713547cd76a7b) }},
};

static const block_t Zi_18[] = {
  {{ UINT64_C(0x7d4cc64e992d11ff), UINT64_C(0x9e585c2eaf44eb89), UINT64_C(0x21e36b6f305d5d09), UINT64_C(0xc651d6d4ede4d4b6) }},
  {{ UINT64_C(0x9367ce63e3c70ceb), UINT64_C(0x7c311a6ef7472de3), UINT64_C(0xfdba1eef6cc89ea0), UINT64_C(0x352bdd5d8688de81) }},
  {{ UINT64_C(0xbde52f73b5e109f7), UINT64_C(0xe52862173bc6d508), UINT64_C(0x0b237c1edc46a256), UINT64_C(0x3048fa6fc90eacf2) }},
  {{ UINT64_C(0xadcaba5f319c8cbf), UINT64_C(0xe48225cc649741b7), UINT64_C(0x159a739dcd6e6309), UINT64_C(0xeefe6a34c9c61e78) }},
  {{ UINT64_C(0x7303f56af6bfcdc6), UINT64_C(0x9cce19da34757f2d), UINT64_C(0xa97197052e915707), UINT64_C(0xf6dede3e09cb6eb7) }},
  {{ UINT64_C(0x285deefa4cc19307), UINT64_C(0xf6007dce48c45b03), UINT64_C(0xd8b0da9556e3baed), UINT64_C(0x71e36680e7730be7) }},
  {{ UINT64_C(0x86a5413fc103dcd6), UINT64_C(0x610fb5ec7461f7a7), UINT64_C(0x5b1123f75f48f282), UINT64_C(0x465a990553c41fe7) }},
  {{ UINT64_C(0x59960ebb7b0dd690), UINT64_C(0x1752d0f51a6dec2a), UINT64_C(0xd51cdb5745c54e75), UINT64_C(0xc545b67d5a7827ce) }},
  {{ UINT64_C(0x8f590f10f79ae678), UINT64_C(0x52a65f5df186a023), UINT64_C(0xc75d5564ee235993), UINT64_C(0xd5bb544ad39dfe48) }},
  {{ UINT64_C(0x3a4db9a1ce1cecdd), UINT64_C(0xeaedc4dcd33875ea), UINT64_C(0xa3abd42f16588b4b), UINT64_C(0x31778db13dd2b97b) }},
  {{ UINT64_C(0x4ab8a45544aac526), UINT64_C(0xec0eda30c8e04c8f), UINT64_C(0x5943120b4b099d2b), UINT64_C(0x11e73012c443067f) }},
  {{ UINT64_C(0x1c416a17e141910b), UINT64_C(0x13f7b9d0149836b6), UINT64_C(0x9e170b1fb61a5b25), UINT64_C(0x373a34eb4f7c6d71) }},
  {{ UINT64_C(0xbf7657e72b752100), UINT64_C(0x43f440099233b882), UINT64_C(0xa1c85cff975b221d), UINT64_C(0xf9d352b9f1f4bea9) }},
  {{ UINT64_C(0xda729499a5e0e135), UINT64_C(0xc544cd03c2694433), UINT64_C(0x87b6a31c602b8f70), UINT64_C(0xf6122ac887710c17) }},
  {{ UINT64_C(0x5bab06e2e481df82), UINT64_C(0x95591939f8e7228b), UINT64_C(0xbacf66e146509914), UINT64_C(0x24f4b3e2649532c0) }},
  {{ UINT64_C(0xa9057a503c112f02), UINT64_C(0x4bc089b36a80d5e8), UINT64_C(0x278f109b5ae6988b), UINT64_C(0x8014d0b9a5d0d911) }},
  {{ UINT64_C(0xdae43f3359389b57), UINT64_C(0x8d2de85d52062420), UINT64_C(0xff0d44f37b2461b3), UINT64_C(0xaea26f0b76e91ab0) }},
  {{ UINT64_C(0x7624b1c4edd1a4b4), UINT64_C(0xbf44647af8b9bf40), UINT64_C(0xecc42c8534f85754), UINT64_C(0x37d05bf0e3fbfc63) }},
  {{ UINT64_C(0xd18e73356baf6b0c), UINT64_C(0x8126275ad1505c5a), UINT64_C(0x8c9828f0c460f091), UINT64_C(0x50ae726cfb9b66cd) }},
  {{ UINT64_C(0xc02e34d1b6a98966), UINT64_C(0x4065f47577f8b83a), UINT64_C(0xfd44940081ad6256), UINT64_C(0x70fafca41b17d4f0) }},
  {{ UINT64_C(0x380cf82c03f6e198), UINT64_C(0x7aa8e2b50b5eb1c5), UINT64_C(0x7929625ffd36bb16), UINT64_C(0xe1cc9ff7f0fea2ce) }},
  {{ UINT64_C(0xdeec0d870379e1a2), UINT64_C(0x1dfdad13cf3f3f41), UINT64_C(0x6b496d42e251f2c5), UINT64_C(0xce74afffdd6e43bf) }},
  {{ UINT64_C(0x8badd513defc8b19), UINT64_C(0x24366ce658d19a12), UINT64_C(0xaff9f0db42f8747e), UINT64_C(0x4e16d4982a1bcbde) }},
  {{ UINT64_C(0xb861f42ef8b83848), UINT64_C(0x247522a0581e8bcf), UINT64_C(0x190f566524e95421), UINT64_C(0x0c7a0a0467d21ce5) }},
  {{ UINT64_C(0xada695a20687730c), UINT64_C(0x6a8e7adc11f7b744), UINT64_C(0x7ea5b9a79242b62f), UINT64_C(0x7ee73a6c55123f13) }},
  {{ UINT64_C(0x5e1cf34f56fe4e0a), UINT64_C(0x77c326d501b38fe1), UINT64_C(0xee6934ad5d100f02), UINT64_C(0xe2decc8138f9afae) }},
  {{ UINT64_C(0xd71bde5847ad19eb), UINT64_C(0xe957a2fd2bece503), UINT64_C(0x99cbea96c9490b48), UINT64_C(0x4d3247b77c634951) }},
  {{ UINT64_C(0xb8807053d197e5ab), UINT64_C(0xd243a97fca21b26e), UINT64_C(0x630417436dac23ef), UINT64_C(0xc6c40f727acc8604) }},
  {{ UINT64_C(0x72ae616c9a37782b), UINT64_C(0xcbbe5dc753bdf816), UINT64_C(0x3d9404a59eabdabd), UINT64_C(0x8655be9bf666f852) }},
  {{ UINT64_C(0x2043bc4d7cde1fb4), UINT64_C(0xe0e9f2d7b86d3a61), UINT64_C(0xcad0bd38d225854f), UINT64_C(0x26a559584d75133c) }},
};

static const block_t Zi_19[] = {
  {{ UINT64_C(0xe354e04e4da3dcec), UINT64_C(0xd2eb46f81c962fe0), UINT64_C(0x5ed456f0ec485b86), UINT64_C(0x3aea1ce21516fc2d) }},
  {{ UINT64_C(0x0c45d0f89946ae4d), UINT64_C(0x23b462bdc0e4805f), UINT64_C(0x1a26f2d263180695), UINT64_C(0xe6d10832148e189d) }},
  {{ UINT64_C(0xf5859284bf4b23a8), UINT64_C(0x50048c7f4ceb192a), UINT64_C(0xbbecf2f9f531ae06), UINT64_C(0x672cee37800c533d) }},
  {{ UINT64_C(0x3bd83c245b9e09dd), UINT64_C(0xe6bf9ade6b30f0b5), UINT64_C(0x5006994922c2a0bb), UINT64_C(0x3cc72fa82bae0289) }},
  {{ UINT64_C(0x0f10e01552d40a10), UINT64_C(0xde46634b54f37306), UINT64_C(0xa9ad23c4c751367e), UINT64_C(0x47d959ce05f6a6e2) }},
  {{ UINT64_C(0xbe4ef31cfcc72438), UINT64_C(0x4a2d0992d9cddc70), UINT64_C(0x91228e3f9bfd5e04), UINT64_C(0xcf868e35cbbacbd0) }},
  {{ UINT64_C(0x3cf7992d5d8fcdca), UINT64_C(0xde1e426b9af51b57), UINT64_C(0x24945e89a34674b7), UINT64_C(0xc6a1f5bff6130168) }},
  {{ UINT64_C(0xa5c664ba992c7fb7), UINT64_C(0xc8277958dfd32906), UINT64_C(0xe5443d65c00e7f94), UINT64_C(0x242a14642c49b37b) }},
  {{ UINT64_C(0x392b68e5031ea07f), UINT64_C(0xfed5a16384ff4af9), UINT64_C(0xa792edf53b9297f0), UINT64_C(0x3af1c6f6045bb6ae) }},
  {{ UINT64_C(0xc77880442d47eaf2), UINT64_C(0xd8feb9aa42e62c03), UINT64_C(0xc9f31856d08b9096), UINT64_C(0xc6c18b7e7f95a2f0) }},
  {{ UINT64_C(0x8d52420cfa75ae79), UINT64_C(0xafd429c57e4be0f2), UINT64_C(0x3677aa851c8cd510), UINT64_C(0xd8c4cd7c68132f9f) }},
  {{ UINT64_C(0x8f6ac042e00dc2af), UINT64_C(0x7c30600a0af2a84c), UINT64_C(0x8742573d39ca81cb), UINT64_C(0x153c90b6a1921a66) }},
  {{ UINT64_C(0x5f6fdeb9da730224), UINT64_C(0x65d169e53cfeffb9), UINT64_C(0xa1f409bbbd3336ba), UINT64_C(0xd72a260ec6b3f915) }},
  {{ UINT64_C(0x9c780862bbece169), UINT64_C(0xa1bc415ad4d79eba), UINT64_C(0x118faed8da2e7786), UINT64_C(0xfefc76e916249da7) }},
  {{ UINT64_C(0x50911a24b843b289), UINT64_C(0x41c4b2ca192c72f3), UINT64_C(0xd771604722f08a52), UINT64_C(0x77327cabc72dfbc6) }},
  {{ UINT64_C(0xaa6740f786f7d1ef), UINT64_C(0x55eccbe904326e6c), UINT64_C(0xb75ba9f8acf1705b), UINT64_C(0x6611b13f6f261240) }},
  {{ UINT64_C(0xe02a5c76c1fe9527), UINT64_C(0xbd37e5070a136b4a), UINT64_C(0x4617ad4cb2f0ee26), UINT64_C(0x986c879b54ae40c3) }},
  {{ UINT64_C(0x2b627b37211d1d30), UINT64_C(0xabb5dc271361aa05), UINT64_C(0xab063eb570164b97), UINT64_C(0x533b75c5908baaa1) }},
  {{ UINT64_C(0xb7a2c4df9a246f8f), UINT64_C(0xd73389e30af94a80), UINT64_C(0xa456a95ea2f9f5b8), UINT64_C(0x0086c56c05a8f029) }},
  {{ UINT64_C(0x3f9bbfd022df0739), UINT64_C(0x9e40d9447f034602), UINT64_C(0xe6b11f2b79d15a3a), UINT64_C(0xf19ea69bde0cb961) }},
  {{ UINT64_C(0x58b19209165c00e1), UINT64_C(0xbcf860cde9345967), UINT64_C(0xbcc9e050389afeb4), UINT64_C(0x38a9d396b8c52b3e) }},
  {{ UINT64_C(0xf415b970c1c39e91), UINT64_C(0x4c826dca2b671da6), UINT64_C(0x60cb13a678bda4bb), UINT64_C(0x8a484dedd61b858d) }},
  {{ UINT64_C(0x1ea2ca84363adf97), UINT64_C(0x475bcccac18e8a69), UINT64_C(0x9709f23228bb36cc), UINT64_C(0x2edf055af53b77d5) }},
  {{ UINT64_C(0xa856edacd07d7eaf), UINT64_C(0xdd72d526d63ddf1e), UINT64_C(0x02228b6dd6777860), UINT64_C(0xd2c513795dc9c911) }},
  {{ UINT64_C(0x0a65223ef2d2bb57), UINT64_C(0x400251bfc466120b), UINT64_C(0xba35ab88fd9d1bbb), UINT64_C(0x4b22f271230882b2) }},
  {{ UINT64_C(0xc0d594ba320fe4ac), UINT64_C(0xa427b20fdacc2ac6), UINT64_C(0xa490b9600b52a2af), UINT64_C(0x263530254098259d) }},
  {{ UINT64_C(0xf1219e244499459b), UINT64_C(0xb6657584a34d070b), UINT64_C(0x6f7d00a2ec3d22df), UINT64_C(0xdd527183b56ca0dd) }},
  {{ UINT64_C(0x4ce7cc85b10f6487), UINT64_C(0x8c68fa44c30b9d68), UINT64_C(0xf004fb77430571be), UINT64_C(0x01b546b3893af5b6) }},
  {{ UINT64_C(0x5a33b74260266e49), UINT64_C(0xb8b2cbcc695804d7), UINT64_C(0xaae521c592b0b3c2), UINT64_C(0x331a3b777f3133df) }},
  {{ UINT64_C(0x1c5b7027f26a2812), UINT64_C(0x0be50a6d960c5a9f), UINT64_C(0x31ee590bf95d1eef), UINT64_C(0xc52de8a0524a61dd) }},
};

static const block_t Zi_20[] = {
  {{ UINT64_C(0xc528471d5b8e7be0), UINT64_C(0xd45de29119c6cca8), UINT64_C(0x3731c047e50162a0), UINT64_C(0x7d5a13f66ba46a40) }},
  {{ UINT64_C(0x5a2cb699177fcdbf), UINT64_C(0x14c6137478ac6055), UINT64_C(0x4dc7a303f68bbf7b), UINT64_C(0x005d153b1455764a) }},
  {{ UINT64_C(0x8fe594e876a8050a), UINT64_C(0x8c4b1529ba8093e6), UINT64_C(0x8dee23d58fd9134f), UINT64_C(0xc9c98c222af5791d) }},
  {{ UINT64_C(0xccf4db7351e1c22f), UINT64_C(0x9a6f795bf6936c24), UINT64_C(0xc37f8d4969ba097b), UINT64_C(0xb94930170bc6669c) }},
  {{ UINT64_C(0x74c8bd70fa65063a), UINT64_C(0x8d7568aaa42c6355), UINT64_C(0x440001152c4b1f35), UINT64_C(0xb3bbb8139c64056d) }},
  {{ UINT64_C(0x6f61da64f4d5a640), UINT64_C(0x3fe5411470637a3b), UINT64_C(0x2290f5ffea738640), UINT64_C(0xbe7433d786e4f2f1) }},
  {{ UINT64_C(0xdd35cc18fdf25955), UINT64_C(0xb54ea6cade872bd4), UINT64_C(0xa920415155a873b0), UINT64_C(0x6f9feea8df23f377) }},
  {{ UINT64_C(0xb2a564446be27fa7), UINT64_C(0x5444c9dd8d0d1461), UINT64_C(0xcaed763bf2a430c5), UINT64_C(0x3ca088aec1e04d36) }},
  {{ UINT64_C(0xe9366920432c3075), UINT64_C(0x264d511c7dc90c45), UINT64_C(0x7ffd6e6e7a5de32c), UINT64_C(0x7e149aa44e1da516) }},
  {{ UINT64_C(0xde083dbc27e577c3), UINT64_C(0x91f409316c48d47a), UINT64_C(0xce7cbd04bd12e2a3), UINT64_C(0xed09abf29866c2d0) }},
  {{ UINT64_C(0xe11b9d88966ac652), UINT64_C(0x919614839c60394c), UINT64_C(0xa480f9d758e455e4), UINT64_C(0x9ea8cc502309d452) }},
  {{ UINT64_C(0x5a46d19dd732ddde), UINT64_C(0x5812ce468e16f903), UINT64_C(0xa61574d1ea9d0c80), UINT64_C(0x4d4e1dd456c04174) }},
  {{ UINT64_C(0xd14116d931196a77), UINT64_C(0x994f5bd938e016d7), UINT64_C(0xb2853680c95e2b66), UINT64_C(0x187ce88a7d486ac9) }},
  {{ UINT64_C(0x41587f9c987d6ab9), UINT64_C(0x6cac22b375922a33), UINT64_C(0xec8762f4efd747ab), UINT64_C(0x292617092eea8b4a) }},
  {{ UINT64_C(0x68da6ec43d4bba3b), UINT64_C(0xefa8f1d1b703b5b0), UINT64_C(0x0836d4e574a524c9), UINT64_C(0xee87d0918c5476d8) }},
  {{ UINT64_C(0x65409ebad0562abc), UINT64_C(0x4c643bb225bb61dc), UINT64_C(0x154128f22d45af28), UINT64_C(0xdcd8967343d2aeea) }},
  {{ UINT64_C(0x520837037af314b0), UINT64_C(0x7aa4730fc577733c), UINT64_C(0xb0a145184370e1b1), UINT64_C(0x83cea3d69aa179ea) }},
  {{ UINT64_C(0x45736747ba9b1458), UINT64_C(0x69ce0fb45bf1a88c), UINT64_C(0x656329fa0e29819f), UINT64_C(0xa12a5a460a2fc7e5) }},
  {{ UINT64_C(0x8d85ea04bc4f3586), UINT64_C(0xc212e4acaf3e20c0), UINT64_C(0x08b7a081b0729326), UINT64_C(0x82ce9912cdd9d5be) }},
  {{ UINT64_C(0x2131edb93355e5b5), UINT64_C(0x7ec5bd9268a902a2), UINT64_C(0xdead8592b29ec5d8), UINT64_C(0xcf8c434790a6bc75) }},
  {{ UINT64_C(0x68f26265fdfac540), UINT64_C(0x4b2e9fd1030e16e6), UINT64_C(0x99715bec30476347), UINT64_C(0xa5926a28281a3704) }},
  {{ UINT64_C(0xcf12991e286098bd), UINT64_C(0x3435f9058d8934a9), UINT64_C(0x6be123d5720cd357), UINT64_C(0x1d106c4db5bf8a8e) }},
  {{ UINT64_C(0x6adbe7cb47485ba2), UINT64_C(0xaab1da222780fa25), UINT64_C(0x47d75f4dfe04863a), UINT64_C(0x4f188de540b44fc1) }},
  {{ UINT64_C(0xc92be01f486ac0c3), UINT64_C(0xc6760dce238b415d), UINT64_C(0x4cae0fbe2077fc44), UINT64_C(0x51b9ae00521a1ccb) }},
  {{ UINT64_C(0xf2f87e6186a9d31a), UINT64_C(0xd9f664ff185116b5), UINT64_C(0x0099ffe78d23904e), UINT64_C(0x1ba8c251527f1ddc) }},
  {{ UINT64_C(0x09953bd70dfce54b), UINT64_C(0x68daa09348944c6f), UINT64_C(0xf5d564dd95967243), UINT64_C(0x3b02ec513d0a5352) }},
  {{ UINT64_C(0x112c73a1b10c8dfb), UINT64_C(0xbee21ead282cc1e9), UINT64_C(0x24ebea10e2b20c18), UINT64_C(0x8df5f46328aa0fd9) }},
  {{ UINT64_C(0x2a932fdf807fabfc), UINT64_C(0xdab2159b54e01c88), UINT64_C(0xa7c9f5c3b85fda34), UINT64_C(0x37e3963d90c2fcae) }},
  {{ UINT64_C(0xea9bfaedda1cd28f), UINT64_C(0x68100df51f5e2e41), UINT64_C(0x2eb307787c6a6da4), UINT64_C(0xdc9e6fccc98fee32) }},
  {{ UINT64_C(0x9373270e8c0e1063), UINT64_C(0x3c415e9e68085c76), UINT64_C(0xec6dc141f2c85476), UINT64_C(0x6bf3f24aba15621e) }},
};

static const block_t Zi_21[] = {
  {{ UINT64_C(0x7200fdbc185cbac6), UINT64_C(0x29b9a56248266d10), UINT64_C(0x483919b73dfbf86c), UINT64_C(0x4a2eaad012a68470) }},
  {{ UINT64_C(0x937ee012aeb09730), UINT64_C(0x87f07dd721341568), UINT64_C(0x35ef61bfae33dc36), UINT64_C(0x4bc4cc5630123175) }},
  {{ UINT64_C(0xafa51dfdac4dce9d), UINT64_C(0x93b7e8b4e1d3da34), UINT64_C(0xe2a36edd4ee36269), UINT64_C(0x9ca0241e277fb026) }},
  {{ UINT64_C(0x98b2764e059a4158), UINT64_C(0x511a2f06d196c159), UINT64_C(0x2d3dce212ac692b6), UINT64_C(0x60833b7d1d289f81) }},
  {{ UINT64_C(0x312439424b66ec14), UINT64_C(0xa3d680b3adfcf48f), UINT64_C(0xceff548b9f560cc5), UINT64_C(0xb148d5a46f691a5a) }},
  {{ UINT64_C(0x3d791c56320d348f), UINT64_C(0x7fd82532ab790a43), UINT64_C(0x915abb3aaa98ee9d), UINT64_C(0xe5407c9fe0ff9042) }},
  {{ UINT64_C(0x5a51637717368bf3), UINT64_C(0x32b7b925b816f00a), UINT64_C(0x1edf7eed2e2b3fa0), UINT64_C(0x40f1a841a234681b) }},
  {{ UINT64_C(0xd62c4f168d7a0f44), UINT64_C(0xb61acde07f84c20c), UINT64_C(0x5b31d2fbd8083866), UINT64_C(0xa3e0c715fa86805c) }},
  {{ UINT64_C(0x894a65c79ef87d1a), UINT64_C(0x9f5f8d13ec670e8a), UINT64_C(0x5746b790e643c110), UINT64_C(0x4c598c82a5047b9b) }},
  {{ UINT64_C(0x26dee875ff15f6f4), UINT64_C(0x10badbee6f7672e5), UINT64_C(0xcc7e02fae3671eff), UINT64_C(0x73abf44ca447511a) }},
  {{ UINT64_C(0x83b4e36439876629), UINT64_C(0xe882702d8c137f64), UINT64_C(0x77c1e2d781c72500), UINT64_C(0x056d26d15a3af105) }},
  {{ UINT64_C(0xec4bf8567036c91a), UINT64_C(0xdb4d20b43f94a102), UINT64_C(0xf51f84a671c0c120), UINT64_C(0xfb3a7c400436483c) }},
  {{ UINT64_C(0x5108e7936ad663f5), UINT64_C(0x9e5f678de52a312e), UINT64_C(0xbc9934c398034735), UINT64_C(0x9ebab9f8235f3dd6) }},
  {{ UINT64_C(0x2c5fdde536d26806), UINT64_C(0x4e0e8815bdfdf615), UINT64_C(0x7576e49fa721b320), UINT64_C(0x695e45498ac2c32d) }},
  {{ UINT64_C(0xe025b70d95e72f2a), UINT64_C(0xe46cd4e6ef987d74), UINT64_C(0xec7e62045b8987fb), UINT64_C(0x69545ce62c6a0504) }},
  {{ UINT64_C(0x065ede81d35acfa9), UINT64_C(0x1dc618f03af13bbe), UINT64_C(0xc1219d4d9338c119), UINT64_C(0x170e97f129c86501) }},
  {{ UINT64_C(0x0be6d097d0532c23), UINT64_C(0x0a605e1b62c9df7d), UINT64_C(0x92574194b9fbe525), UINT64_C(0x15f63cd92d6ee6c6) }},
  {{ UINT64_C(0x5b0192f76f8f7e54), UINT64_C(0xe905810ace6d2c8e), UINT64_C(0xe4cbf9148db9d184), UINT64_C(0xa4901dc09ac677d6) }},
  {{ UINT64_C(0xd25c15ced5335737), UINT64_C(0xb47a04db0b5e5163), UINT64_C(0x308ce1c9ec9af23a), UINT64_C(0x00ef7e06e31ea1cb) }},
  {{ UINT64_C(0xfd9f400ab6ac828e), UINT64_C(0x8d344f37d5b425ea), UINT64_C(0xd558988455cc6b04), UINT64_C(0x415e7b91369d767f) }},
  {{ UINT64_C(0x1bc7134cc9d8888b), UINT64_C(0xb4836a39111fb5c0), UINT64_C(0xd385062229f5a156), UINT64_C(0x7d12eeff4b97989c) }},
  {{ UINT64_C(0xdf82d7836d231d35), UINT64_C(0x5d0631a6dbf28cd1), UINT64_C(0x921799868370f0f7), UINT64_C(0x230dc3eb83769b8c) }},
  {{ UINT64_C(0x24f673ddedd7061a), UINT64_C(0x33342c8a45946052), UINT64_C(0x36f90b0e8e23deeb), UINT64_C(0x36a3327138c7b293) }},
  {{ UINT64_C(0xccdd310bd3b2bbcb), UINT64_C(0x5cbad5d9db52cddf), UINT64_C(0xa09bb035aaa355dd), UINT64_C(0x0d532876f95320e0) }},
  {{ UINT64_C(0x6c61612594ddf44f), UINT64_C(0x2db1b06dc5c345bf), UINT64_C(0x27cca4f54331ecc1), UINT64_C(0x91728758f389387f) }},
  {{ UINT64_C(0x43f1ef46f09929c2), UINT64_C(0xd46d72ca0cb947ce), UINT64_C(0x7b3934ab49c9a8ec), UINT64_C(0xbc4155f017f0274f) }},
  {{ UINT64_C(0xf923117524ef59ea), UINT64_C(0x4132fe43484147c1), UINT64_C(0xd4076fec7614a38a), UINT64_C(0xe10d9c8eeb3c8ad4) }},
  {{ UINT64_C(0x545202667e112c82), UINT64_C(0xa1d26d0e69787df3), UINT64_C(0x6819477c75878d51), UINT64_C(0xd6197227083096fa) }},
  {{ UINT64_C(0x793309db79e86670), UINT64_C(0xd5b2f183b5790b1f), UINT64_C(0xf9bfb6c251f06834), UINT64_C(0x1675564ab04c302d) }},
  {{ UINT64_C(0x579b61dd513faf50), UINT64_C(0xeaa859e87de53aca), UINT64_C(0x86704860e74a9c53), UINT64_C(0xf9e47576060ae0d3) }},
};

static const block_t Zi_22[] = {
  {{ UINT64_C(0x5858b22290d23314), UINT64_C(0x5cb69d09d461a6a6), UINT64_C(0x348b4cb88a46c4f0), UINT64_C(0x2dc4f6b8efcb5851) }},
  {{ UINT64_C(0x6d816f3a6073720f), UINT64_C(0xdf3e97a3640aa374), UINT64_C(0xf54f3fcb600506ab), UINT64_C(0xa38181097d34e91e) }},
  {{ UINT64_C(0xf96e72a6efe691fb), UINT64_C(0xd1ea39b7b926e9f6), UINT64_C(0xc623fd24670353ee), UINT64_C(0x0ecdee6548c5bf32) }},
  {{ UINT64_C(0x07509fadf12ccb3a), UINT64_C(0xda3d7cc3a94af567), UINT64_C(0xf0a9de813eb80d8e), UINT64_C(0xb139ef56ca8696b6) }},
  {{ UINT64_C(0xf69a57475903a8ef), UINT64_C(0xa6539c7089305a8d), UINT64_C(0x8fb366b2d5da1feb), UINT64_C(0xc10b89527c7a3b90) }},
  {{ UINT64_C(0xa88f831945eba6bc), UINT64_C(0x0fe012e20e78c1d2), UINT64_C(0xa85b4eb945d2c411), UINT64_C(0xe29f6de8b707c9ff) }},
  {{ UINT64_C(0x5ddb8d19827b1292), UINT64_C(0x35fcf79d4560c745), UINT64_C(0xbbbb0432bf2dd0dd), UINT64_C(0x7976ed02c8bbff9e) }},
  {{ UINT64_C(0x22046e74676dd4d0), UINT64_C(0xfac76b480b68f642), UINT64_C(0x51dd2142cd3e71a9), UINT64_C(0xa3072208740d45e6) }},
  {{ UINT64_C(0xccee4cc3c0bfc655), UINT64_C(0xf2b1cfef14a1d5df), UINT64_C(0x210f0049fb8c352a), UINT64_C(0x6b130bd4e816142d) }},
  {{ UINT64_C(0xc5bc6ad85b4c169b), UINT64_C(0x7d9cc7202c8e98a3), UINT64_C(0x13e60ba5aa64afe9), UINT64_C(0x7969bbda86420c3e) }},
  {{ UINT64_C(0xf9a4781f5ca9cbc0), UINT64_C(0x2fd209242fee8065), UINT64_C(0xd4f6923abd5f89ee), UINT64_C(0x2c1f7e1b1921d153) }},
  {{ UINT64_C(0xf5106ba7ea8a3133), UINT64_C(0x0caad6f7e98b6745), UINT64_C(0x6772a76b4e514a6f), UINT64_C(0x2a81cf98d86d3f2e) }},
  {{ UINT64_C(0xa95bd16ddadf10e7), UINT64_C(0x53b659efe11c48f8), UINT64_C(0x971d2dbf9d29fc7a), UINT64_C(0x3567168c317e810e) }},
  {{ UINT64_C(0x41d537fc21643d2a), UINT64_C(0xaf12f51d02221acd), UINT64_C(0x673b53968be7cd81), UINT64_C(0xe8c8fd3f8f8ff002) }},
  {{ UINT64_C(0xddf52bf9b8f87ec6), UINT64_C(0xe81a1378d721230f), UINT64_C(0x3668952db95585f3), UINT64_C(0xddeebb7557a45fdb) }},
  {{ UINT64_C(0xf1b82c445355eb05), UINT64_C(0xee10d0a2f262f1b1), UINT64_C(0xf5765f17d4a69e95), UINT64_C(0x70d0c490d5c0212d) }},
  {{ UINT64_C(0x6b2ba73bbbdd14df), UINT64_C(0x81a3cb32a869f68d), UINT64_C(0xe54fd16509848a1e), UINT64_C(0xc46c9db3bf0811d5) }},
  {{ UINT64_C(0x2db839c577c7ac6c), UINT64_C(0x740b36c9bdf5ec1f), UINT64_C(0x4445d6abb5c5f69f), UINT64_C(0xe18b4953cca002bf) }},
  {{ UINT64_C(0x7795d033404760f6), UINT64_C(0xf1826e33e71db2b9), UINT64_C(0xfb33dc81a45e5f97), UINT64_C(0x5f3c761b21658b28) }},
  {{ UINT64_C(0xcb39bce11ec402e0), UINT64_C(0x922f5703d2c34816), UINT64_C(0x72353720e30be8f5), UINT64_C(0x3b261bf00fcd31f0) }},
  {{ UINT64_C(0x01261bdfc90e6bde), UINT64_C(0xcbcc25bca7a82e24), UINT64_C(0x048da3afcb35bdd7), UINT64_C(0xf8dadab5a63a32fd) }},
  {{ UINT64_C(0x6803cc46759608a0), UINT64_C(0x20b011deeb74f1a3), UINT64_C(0x79689d13bbbd8f25), UINT64_C(0x0c2eb66d63362df2) }},
  {{ UINT64_C(0x4b9aa233bfdb30c2), UINT64_C(0xe9f56286cee1d89f), UINT64_C(0xb69fe27b96875958), UINT64_C(0x8f13a7cd5d38fff0) }},
  {{ UINT64_C(0x719b5bad03c0d654), UINT64_C(0xc2d97f62c22004d9), UINT64_C(0x3dbd6416afb179f6), UINT64_C(0x9ad01968f38bc6d7) }},
  {{ UINT64_C(0x6a2857263d97817f), UINT64_C(0xaae9a0233f6931cb), UINT64_C(0x3394544e6dd9c7c7), UINT64_C(0x8c1bbd4b68639515) }},
  {{ UINT64_C(0x8ab8a766c3c4fe38), UINT64_C(0x975ad431d28a7383), UINT64_C(0xaa367e32351a0a25), UINT64_C(0xe0f5a8f3f311c106) }},
  {{ UINT64_C(0x64d46edf924218e7), UINT64_C(0x7d90da83e80ceb3d), UINT64_C(0x4104315f2d526377), UINT64_C(0x8ec02b68c69f9a35) }},
  {{ UINT64_C(0xb8e0a92460986068), UINT64_C(0x517303c76ecfda75), UINT64_C(0x15fd3a5d90199901), UINT64_C(0xa7451e15c74ac241) }},
  {{ UINT64_C(0xb60e7e873664f53f), UINT64_C(0x95a826eb808a004d), UINT64_C(0x8c19464c006b1acd), UINT64_C(0x6e32c29871663429) }},
  {{ UINT64_C(0xff55faa0fd0305fd), UINT64_C(0xcb3c5eac4439e50e), UINT64_C(0x0bb0670f11571c14), UINT64_C(0x89628ed91bdcc1c8) }},
};

static const block_t Zi_23[] = {
  {{ UINT64_C(0xdc44cc4746215194), UINT64_C(0xb41b9625bf23c46d), UINT64_C(0xa42a87c3ba735d38), UINT64_C(0xec7d12e5933b7840) }},
  {{ UINT64_C(0x829f2e95ed67fdd9), UINT64_C(0x84cdf7ae16c74058), UINT64_C(0xcfc4aa484cf6c4c9), UINT64_C(0x59fe2b7e489f0db8) }},
  {{ UINT64_C(0xf61176edddc8a560), UINT64_C(0x57c41fe7c041dc18), UINT64_C(0x5a5dee90d8ea1dc8), UINT64_C(0x90d83660ee8d8eb9) }},
  {{ UINT64_C(0xbbfe796523ff4aec), UINT64_C(0xf95c1de9b1e67fc0), UINT64_C(0x5f72c56da6e099f4), UINT64_C(0xe2af48576b4e0235) }},
  {{ UINT64_C(0x0da7ea0276aeb6f8), UINT64_C(0x882355904ae1b631), UINT64_C(0x832c08ac10d35595), UINT64_C(0xea161a73d0d6b8e0) }},
  {{ UINT64_C(0x42a9909a829e8cdb), UINT64_C(0x9abb5dd162f239a6), UINT64_C(0x2edd64c3079f66ab), UINT64_C(0x7cc69c7466754a67) }},
  {{ UINT64_C(0xa07069c57b118853), UINT64_C(0xebff1056bf396ead), UINT64_C(0xb0d3768f34e2b2cd), UINT64_C(0xfc0e8dce33ecb32e) }},
  {{ UINT64_C(0x887e273415f03623), UINT64_C(0x2da8b8093fa1b65c), UINT64_C(0x4855eea37ae2c0ca), UINT64_C(0x8fe9493b291fca29) }},
  {{ UINT64_C(0x2a142836040a97f0), UINT64_C(0x2278a9c34d610d04), UINT64_C(0x037f4d8dcfdd11e6), UINT64_C(0x08127c394b6d4299) }},
  {{ UINT64_C(0xa398326ea1e84359), UINT64_C(0x9683dcbd50c23031), UINT64_C(0xd33babfcfe6a65c0), UINT64_C(0xa6a9c1c21e5e3e87) }},
  {{ UINT64_C(0x5b89295b4c6d570b), UINT64_C(0x1dd14656e91763f2), UINT64_C(0x4f3cf67ca43db3c7), UINT64_C(0xa2f402d50e68677a) }},
  {{ UINT64_C(0xaf5340ce7f1daff8), UINT64_C(0x272ab981002d55cc), UINT64_C(0xe73d00b4196897c7), UINT64_C(0xadb1fce386b26c0d) }},
  {{ UINT64_C(0xe3d6cab5d0980b5b), UINT64_C(0x31208fa8fd4122fc), UINT64_C(0x5ee96164bccc479c), UINT64_C(0x08db8d1bcb911452) }},
  {{ UINT64_C(0xc7ceffd7ac1a59ec), UINT64_C(0xb8bbc40cc059dfd5), UINT64_C(0x61c70b5ac1b44006), UINT64_C(0xbe569f87d777a87e) }},
  {{ UINT64_C(0xa4406d1d3a8ebcb0), UINT64_C(0xd68ddd3779cf3131), UINT64_C(0x92e29ee7e07eadfc), UINT64_C(0xd6e833b8993a39a7) }},
  {{ UINT64_C(0x9fbb4b3a70d9bf47), UINT64_C(0x259fdd88a021553a), UINT64_C(0x5546e224cc8fffef), UINT64_C(0x7a4cba8e5d66a9f5) }},
  {{ UINT64_C(0x9cc87040f560d490), UINT64_C(0xacb027f13fbd2ec6), UINT64_C(0x86e62ff27f3950ff), UINT64_C(0x00c0a71f413a3325) }},
  {{ UINT64_C(0xe8a2b491600732d6), UINT64_C(0xd8d3d0e8ad61a8c0), UINT64_C(0x629f379c57d95475), UINT64_C(0x825b0b0ba2a5e86b) }},
  {{ UINT64_C(0xf253e49cc907469d), UINT64_C(0x8a78f2d4a458daad), UINT64_C(0xde4919cd7ad75a26), UINT64_C(0x8d13e7bf66567c36) }},
  {{ UINT64_C(0xb6d6201b5aae4373), UINT64_C(0x4201ae8d20c1539d), UINT64_C(0xa2ae70f748c45649), UINT64_C(0xfbff251ef61dd549) }},
  {{ UINT64_C(0x136d41f1e451d1f9), UINT64_C(0xeaf6613c54642243), UINT64_C(0x58d34712d7f3cba8), UINT64_C(0xf6070e824679865d) }},
  {{ UINT64_C(0x71645b184ef41cdf), UINT64_C(0x4398f5561f385842), UINT64_C(0x5a228e37629c9d51), UINT64_C(0xbc44fe8cd6099f2b) }},
  {{ UINT64_C(0xe29f6edc49f6fd6a), UINT64_C(0xbc760bd1d9c81a9f), UINT64_C(0xf6600f7684ff5b99), UINT64_C(0x5784f1ac46fad582) }},
  {{ UINT64_C(0xef85a48035500ead), UINT64_C(0x583960185c25e277), UINT64_C(0x2023fc36128c1e9f), UINT64_C(0x69bbc89c24fcf627) }},
  {{ UINT64_C(0xcf0c0e504e3ff039), UINT64_C(0x7df8da9949156bf2), UINT64_C(0xdb7db7a39a86372e), UINT64_C(0x0226ffd6d1ab869c) }},
  {{ UINT64_C(0x6df7f7132776ad24), UINT64_C(0xb147dc174a3d31a2), UINT64_C(0xe4d8924c9f50ce35), UINT64_C(0x37ba61fc24d2f064) }},
  {{ UINT64_C(0xf5e7adbe9382ef22), UINT64_C(0x6e83f9863ed46dda), UINT64_C(0x87f7e062d7a9a1cf), UINT64_C(0xe051ff684661f61e) }},
  {{ UINT64_C(0x3828cab42a313caf), UINT64_C(0xf857f0d87a4ed50b), UINT64_C(0x39bc61b82b926a76), UINT64_C(0x84244e9052016786) }},
  {{ UINT64_C(0x625bb159b3f595ec), UINT64_C(0xf409c4dbb9d6b097), UINT64_C(0xf07b881eb7fbdb5c), UINT64_C(0x69fdc95c7f419e67) }},
  {{ UINT64_C(0x9dc09a3b632043ff), UINT64_C(0x363fb0fe04f6d8a7), UINT64_C(0xeba72f1014cf1ae3), UINT64_C(0xfafa2b71a1ec4bd7) }},
};

static const block_t Zi_24[] = {
  {{ UINT64_C(0x8c7a0531fef6e783), UINT64_C(0x909b868c768040b5), UINT64_C(0x4f6a1cf042ba629a), UINT64_C(0x1c605d636f7f9fb7) }},
  {{ UINT64_C(0x234bfaee037e39b9), UINT64_C(0xfba892c697f71682), UINT64_C(0xa466032fd61741a7), UINT64_C(0xcd1d8138f8e90173) }},
  {{ UINT64_C(0xe81a85658f742599), UINT64_C(0xd4a0c4fbff8dba96), UINT64_C(0x36416bab85ce6307), UINT64_C(0x2d32b5b1f4279eba) }},
  {{ UINT64_C(0xbaec5d49bb7c918e), UINT64_C(0x057caf1dbb68eb6a), UINT64_C(0x9cf27ecca0d555fb), UINT64_C(0x8d93a9ca0cde12af) }},
  {{ UINT64_C(0x1cabf42aa6bd81c8), UINT64_C(0x1ccbe22be80beab5), UINT64_C(0x978979b820b2d5f4), UINT64_C(0xdb304dc3bcca48c6) }},
  {{ UINT64_C(0x762f7eb3d4dfa8bf), UINT64_C(0x7287c692a9698eeb), UINT64_C(0x77117e5db0ab41d0), UINT64_C(0xa93ccbad17285710) }},
  {{ UINT64_C(0x6e47f18a33002418), UINT64_C(0xd15e2f6fa126508d), UINT64_C(0x06521d5bff098948), UINT64_C(0x961f0ae9b0e34531) }},
  {{ UINT64_C(0x94160a105934b677), UINT64_C(0x6671d8ac77798bf6), UINT64_C(0xae6866f6f019f534), UINT64_C(0x620568eb7f2ef3b0) }},
  {{ UINT64_C(0x48267be7ccf9a9df), UINT64_C(0x4ecf0b08827e74c8), UINT64_C(0x10cd3909d5c68c6a), UINT64_C(0x4fbb0c0ee9ac75b1) }},
  {{ UINT64_C(0x8efcfc5b6faf8f38), UINT64_C(0x7490ae9b7cee9f1c), UINT64_C(0xae7cd0bd27b5bd75), UINT64_C(0x02bd94e232997b56) }},
  {{ UINT64_C(0x5c003bb6052d8cdd), UINT64_C(0x0d1d70e8c5d4fbc9), UINT64_C(0x16eac2c6275489ab), UINT64_C(0x98ce952d2e2318a9) }},
  {{ UINT64_C(0x9b6d5794650ed098), UINT64_C(0xb6c53c7a8b1d8382), UINT64_C(0xbdbabe52178aa984), UINT64_C(0x80e66036aaad4a7d) }},
  {{ UINT64_C(0x9d2f8fa0960f48a7), UINT64_C(0x62e83b4f5fd23d40), UINT64_C(0x5a387e93e6818f97), UINT64_C(0x7ed4e6dc878afc47) }},
  {{ UINT64_C(0x205b929c6857f3cf), UINT64_C(0x6f95e11c87eb8944), UINT64_C(0x2ec72406724832cb), UINT64_C(0xdf48fa833ad7de92) }},
  {{ UINT64_C(0x3fca7f785bf5b4dc), UINT64_C(0x36c3e5dd171ce199), UINT64_C(0x2731c0ff8e5d1c04), UINT64_C(0xd15b157969d722a5) }},
  {{ UINT64_C(0xdeb76b7711d9792f), UINT64_C(0x7627ed19a1fc9ed4), UINT64_C(0x03fd7198a6b469f3), UINT64_C(0x13cb3d549e2bd464) }},
  {{ UINT64_C(0x6b8cb7f4a4b4cf0d), UINT64_C(0xc54226b64f178d40), UINT64_C(0x0ae682aa3e1ce8a6), UINT64_C(0xce9f5d029c350387) }},
  {{ UINT64_C(0x99f1fb934256eadb), UINT64_C(0x0b9addc83ac02942), UINT64_C(0xa6373fd1c2b0a6e7), UINT64_C(0x7dc86ed93df9c2f8) }},
  {{ UINT64_C(0xbd9276f9182eed22), UINT64_C(0x8b902c2e8021205f), UINT64_C(0xf9b3f933aeb07fc3), UINT64_C(0x1d8f114bd934103c) }},
  {{ UINT64_C(0x62353c2c581d0cf6), UINT64_C(0x63224cb941e8325d), UINT64_C(0x3cfb7876e00bf780), UINT64_C(0x6f4a1c342d001047) }},
  {{ UINT64_C(0x0888b83ca9518fbf), UINT64_C(0x06b65f5740aa8d6d), UINT64_C(0x11b9ee5066031cf6), UINT64_C(0x9b3971de869a90e2) }},
  {{ UINT64_C(0xad6ee33028fe50b8), UINT64_C(0x7a9d6c7880f15d78), UINT64_C(0xebf6e5394e8e24d7), UINT64_C(0x554d6fcb226ff7a8) }},
  {{ UINT64_C(0xb471fc177d2facaf), UINT64_C(0xb84185f5f6432a81), UINT64_C(0x501a07f49e84f5be), UINT64_C(0x7a50ebd5b04533b1) }},
  {{ UINT64_C(0xedc54e583b320bfb), UINT64_C(0x878fc234fc9765be), UINT64_C(0x44dd0a36d16fe080), UINT64_C(0xac2cbdd3aff66365) }},
  {{ UINT64_C(0xa7778ea0799c64a9), UINT64_C(0xf0d1ec89bd714b04), UINT64_C(0xabd95b6075674ea7), UINT64_C(0x30a560db118ff8bb) }},
  {{ UINT64_C(0x5e4e34305edd0e43), UINT64_C(0x647df8c9da802061), UINT64_C(0x4bad61ec218b8c80), UINT64_C(0x5059c60b5d86dc15) }},
  {{ UINT64_C(0xf13c3aa086aa22a4), UINT64_C(0x961d1d71035ed66b), UINT64_C(0x8a74687a27eb2862), UINT64_C(0xbb6aa72d8d381a02) }},
  {{ UINT64_C(0xac445ba87d4c8799), UINT64_C(0xa940d609d685b6cf), UINT64_C(0x427aec9effba77c7), UINT64_C(0x2c0894fcf9723c72) }},
  {{ UINT64_C(0x80ea31fc49b44492), UINT64_C(0xb15c645d1d4b5d9d), UINT64_C(0xe424965de2bf9bee), UINT64_C(0xcf439fda896bb48f) }},
  {{ UINT64_C(0x78199d174ee07957), UINT64_C(0xab5f89d966c750c1), UINT64_C(0x003126ade4f379eb), UINT64_C(0x7a557e1f643191ef) }},
};

static const block_t Zi_25[] = {
  {{ UINT64_C(0x2ab90fddb6f854de), UINT64_C(0x67289951bcee21cd), UINT64_C(0x0c5abb9ba4033e14), UINT64_C(0x6f5d4d66c5cb9231) }},
  {{ UINT64_C(0xdc0e29f739c9158f), UINT64_C(0xfe63d635cc1e62b7), UINT64_C(0x9f5d7e3aaa516daa), UINT64_C(0x39ced9bf28a71f46) }},
  {{ UINT64_C(0x2e619909a2fbba38), UINT64_C(0xa0f8edca99bb18c3), UINT64_C(0xc16f7d867090502b), UINT64_C(0x7adb032be8987cc5) }},
  {{ UINT64_C(0x00a2ec4712606bb0), UINT64_C(0xd8015a6987f1f970), UINT64_C(0x324a7628b28b1394), UINT64_C(0xb11807a976d1b8f3) }},
  {{ UINT64_C(0xad1506b5fa60a4c6), UINT64_C(0x8a4b22ec79dbacfe), UINT64_C(0x3e9df685508d86a4), UINT64_C(0x3d51cc88736e08e4) }},
  {{ UINT64_C(0x3f081fdfb7e82a78), UINT64_C(0x42b6e59058ea62f4), UINT64_C(0x120b01c3b4c35b1b), UINT64_C(0x7f1e623b360de865) }},
  {{ UINT64_C(0x84650ec6e1857257), UINT64_C(0x252de165c020cc06), UINT64_C(0x251c446203e11c58), UINT64_C(0xe7a7910427086e58) }},
  {{ UINT64_C(0x18424eb468fdbde0), UINT64_C(0x50831c023b933517), UINT64_C(0x610cb155cf9ed069), UINT64_C(0x74d8b27af6f52fbc) }},
  {{ UINT64_C(0xf5c27e5648d06267), UINT64_C(0x66122a17c064e88a), UINT64_C(0x8d460acdc5446181), UINT64_C(0x703edc6478268efb) }},
  {{ UINT64_C(0x2c96ca54fe854bdc), UINT64_C(0x7d3f6180e98202ec), UINT64_C(0x3766817c19c9c731), UINT64_C(0xed41bff018cb694a) }},
  {{ UINT64_C(0x9679ce031111325a), UINT64_C(0x7cabfc89a653b912), UINT64_C(0x46716faab531f946), UINT64_C(0xf9a78376191c086d) }},
  {{ UINT64_C(0x12cdb3cf01aaea9a), UINT64_C(0xbe34558c9839627a), UINT64_C(0x2c07d45e2f2b1790), UINT64_C(0x8b0648ef4ab77532) }},
  {{ UINT64_C(0x6f35a5399072e811), UINT64_C(0xe6af38d64a9dd9e7), UINT64_C(0x8b81522c94fc3215), UINT64_C(0xe144d540c4114f37) }},
  {{ UINT64_C(0xd2bfb0d226a75621), UINT64_C(0xb29143ba3f40d8e4), UINT64_C(0x89cc073668dd714f), UINT64_C(0xd08e0b7bd3e30c61) }},
  {{ UINT64_C(0xc7d3f0ab04e3c1fa), UINT64_C(0x627c951aa3ae8734), UINT64_C(0x237386beef6a9bdd), UINT64_C(0xb205aefe3eb08576) }},
  {{ UINT64_C(0x21b29a1289d0df1b), UINT64_C(0xde81873f00865f5f), UINT64_C(0x4578e7dd08780350), UINT64_C(0x50b8893d09ab5b44) }},
  {{ UINT64_C(0xa06c036503a53c99), UINT64_C(0x0aa26c2208bcf166), UINT64_C(0x855f1e3f3f90dcc5), UINT64_C(0xb59df6889f93eda2) }},
  {{ UINT64_C(0x64c7825d3284f681), UINT64_C(0x03faeaf24244c303), UINT64_C(0x1752ff7d81afb4dd), UINT64_C(0xa9ee0029fa61950d) }},
  {{ UINT64_C(0x8e74e3206e3cc4c2), UINT64_C(0xe752f13e3be8ce76), UINT64_C(0x75a89cd8f96ce4c1), UINT64_C(0x374ed5c68e718eb1) }},
  {{ UINT64_C(0x322e693c7094b012), UINT64_C(0xec4fb5fdbe7f54db), UINT64_C(0xe9c23ed3b2165613), UINT64_C(0x6397dcb19753e7db) }},
  {{ UINT64_C(0x7d23f641aadc5785), UINT64_C(0x2a2c486dc9c27e49), UINT64_C(0xc392f5b2ff3dcecf), UINT64_C(0x7125362054c703dc) }},
  {{ UINT64_C(0xf2bab1e578d960cf), UINT64_C(0xc845350a34e8d86d), UINT64_C(0x7ad68d1b46005ded), UINT64_C(0x8d6416e085d955d9) }},
  {{ UINT64_C(0xcb0198ab5c4ddd25), UINT64_C(0xd9d8ea67cdffb1ca), UINT64_C(0xea8eb4dc1753b578), UINT64_C(0x0946a566589324c4) }},
  {{ UINT64_C(0xf0055e8adb1f42d8), UINT64_C(0x94d3d5714f496a90), UINT64_C(0xc2698e361afa9590), UINT64_C(0x3dade91b1a68996f) }},
  {{ UINT64_C(0xae0350e126826fdd), UINT64_C(0x6ec0ec7e6255481d), UINT64_C(0x7e65bce71bf8c45b), UINT64_C(0x35cea6ff66bcbdef) }},
  {{ UINT64_C(0xfcd244790a414ea7), UINT64_C(0xded76b7bce98a381), UINT64_C(0xe10e1ac033133cb2), UINT64_C(0x6836062f8d16bca4) }},
  {{ UINT64_C(0xfc3a190dd93454df), UINT64_C(0x7d50d7f1afd7e975), UINT64_C(0x0e0ed818cb5c1c0c), UINT64_C(0xfe45998cfee4dca1) }},
  {{ UINT64_C(0x5ae5690270e065e8), UINT64_C(0x8079f7dca0a86bf8), UINT64_C(0x477b9f929b729e2f), UINT64_C(0xb4b17dfc6660c7fa) }},
  {{ UINT64_C(0xe7fb259655a30c45), UINT64_C(0x844faeef80d4543d), UINT64_C(0xe869f679fb2afd0e), UINT64_C(0xa1ec7b3fec07dd77) }},
  {{ UINT64_C(0xc7ed6c7a3f4a1eeb), UINT64_C(0x0c28ccffcc6e4dc9), UINT64_C(0x89bfcf5e44921b08), UINT64_C(0xe4016d3fb9c005d7) }},
};

static const block_t Zi_26[] = {
  {{ UINT64_C(0x72b435b2ca5206b7), UINT64_C(0x12114de87dd7f3da), UINT64_C(0x24e58513470ed565), UINT64_C(0xb6aa1e544ccf088c) }},
  {{ UINT64_C(0xc3c2dd5f06486757), UINT64_C(0x0472074ee0e34f4a), UINT64_C(0x0bab978d2d4f8543), UINT64_C(0x08ed01506854def5) }},
  {{ UINT64_C(0xbda8c6608db5d3e2), UINT64_C(0x69cf0dbd67e1281c), UINT64_C(0x5e6f09873dc11711), UINT64_C(0xd641db77065c810c) }},
  {{ UINT64_C(0x6f848755797cf154), UINT64_C(0x03a557a472d91e5d), UINT64_C(0x794e42d4f454c237), UINT64_C(0x7c2c6e5512a56f36) }},
  {{ UINT64_C(0x9920f4611f0a23e2), UINT64_C(0xc8eda867ca4c8c02), UINT64_C(0x2766f84f2b0e9b9f), UINT64_C(0xda592cd44b1276e3) }},
  {{ UINT64_C(0x2858d46b56a4add9), UINT64_C(0xe8325ce06b0843d4), UINT64_C(0x98787f7b5ba242ee), UINT64_C(0xeef8f4fbbea493a2) }},
  {{ UINT64_C(0x58f9076b020ca6fd), UINT64_C(0xb1a6b5e255b8b20e), UINT64_C(0xbb269ad26c9cc66f), UINT64_C(0x7bcbc8d6be9f6c2a) }},
  {{ UINT64_C(0x5dfa3e37b6715f31), UINT64_C(0x60d92973344fc49a), UINT64_C(0x29020370a7a71003), UINT64_C(0xcc5eec7cebaae405) }},
  {{ UINT64_C(0x6281944be6f47644), UINT64_C(0x7666bba79dca9cf8), UINT64_C(0x07a3e4421c56fa7b), UINT64_C(0x68e192de2962167a) }},
  {{ UINT64_C(0xfaf1786a6c1681e4), UINT64_C(0xd5006f9c46d27229), UINT64_C(0x7b8e4e159d11d082), UINT64_C(0x857519c0fd685a9a) }},
  {{ UINT64_C(0x9ad59ff96397c7bb), UINT64_C(0xcc28a67fff3dfdc1), UINT64_C(0x593a69e811b66a5c), UINT64_C(0xa075b72e29bb965a) }},
  {{ UINT64_C(0x64cb227cbe83aded), UINT64_C(0xa671d43cb8bd57c4), UINT64_C(0x4dc8a2725542d05e), UINT64_C(0x49bc35459bf6dd46) }},
  {{ UINT64_C(0x04d93fa2a3bd48c2), UINT64_C(0x8997a9c62611ec2c), UINT64_C(0x608f68f3a4db145f), UINT64_C(0xc79b351aae912469) }},
  {{ UINT64_C(0xc0a7f8c6f51061d1), UINT64_C(0xaf4fd3427e85ebe3), UINT64_C(0x88e17b65b273f1ee), UINT64_C(0x9db6a1e579f9c2ea) }},
  {{ UINT64_C(0xb2700d691a86b2ca), UINT64_C(0x83410f7744029bcf), UINT64_C(0x45e1c961482e59bd), UINT64_C(0x339bb0ced85687c4) }},
  {{ UINT64_C(0xee57bd193f9d4dc7), UINT64_C(0x2d158509dbaf091b), UINT64_C(0xf0e62774e8824fb6), UINT64_C(0xc370adc99dca09ef) }},
  {{ UINT64_C(0x3356f490ef8c2fc2), UINT64_C(0xb496d7ec2fc087f3), UINT64_C(0x4df8ebb42cc51622), UINT64_C(0xe461b93cb6389e49) }},
  {{ UINT64_C(0x77b38aa433009cdb), UINT64_C(0x40709a3ff1cff9c3), UINT64_C(0x63635f0855159819), UINT64_C(0x7f549cb268d7ab46) }},
  {{ UINT64_C(0x70371fe9610cc6cc), UINT64_C(0xa285da96a702c0d3), UINT64_C(0x63b657588439b774), UINT64_C(0xfd721a716a44015a) }},
  {{ UINT64_C(0xcfd1b59c6cd4d4ad), UINT64_C(0xcf7ecd543597f6cd), UINT64_C(0x69b4205b7ce1c5d6), UINT64_C(0x384afbad6aaca234) }},
  {{ UINT64_C(0xb8dcdcb09b753e19), UINT64_C(0xa3f51a9cdd6e013f), UINT64_C(0x8ef0d3895dfaa224), UINT64_C(0x6b0530dfc4a3d6e7) }},
  {{ UINT64_C(0x7af27e03d3d78cb9), UINT64_C(0xaa7704aee563a62d), UINT64_C(0x76c4b483d6b2244f), UINT64_C(0xaa030f2a02eed178) }},
  {{ UINT64_C(0xad82dca4138942fe), UINT64_C(0x0d23132570cb4173), UINT64_C(0x85ec351ec6aa166c), UINT64_C(0xa897f88cb31352f4) }},
  {{ UINT64_C(0x72a8d7adff8146b0), UINT64_C(0x1d81ff7a3ed2011f), UINT64_C(0x7ddac6764a4bbc3b), UINT64_C(0xe60bcc240e184735) }},
  {{ UINT64_C(0x2263090294135ab7), UINT64_C(0x58fa90ea6cf4d200), UINT64_C(0xdffaa021f592e4ac), UINT64_C(0x765497cc0cf1daf6) }},
  {{ UINT64_C(0xfa70e2dbde88c727), UINT64_C(0x33262b0508ab6158), UINT64_C(0xaee9c7f6c6b36a58), UINT64_C(0x847f4ef55e400519) }},
  {{ UINT64_C(0x1731fb629f0e33f3), UINT64_C(0xf96cd5df4968d1a6), UINT64_C(0x7c75bd3caaa5a031), UINT64_C(0xb725708b5350311b) }},
  {{ UINT64_C(0xf7c499b87b82f59f), UINT64_C(0x0471bafa90c7c006), UINT64_C(0xdab2567329a856bb), UINT64_C(0x13de00adef68a23c) }},
  {{ UINT64_C(0xa8dcc52ef8eb55d4), UINT64_C(0x2fed8073961f52b5), UINT64_C(0x5c2a3204f76b9715), UINT64_C(0xa4ffcc52f5a0a449) }},
  {{ UINT64_C(0xe491f17a69e50590), UINT64_C(0xe62fb15f9953c521), UINT64_C(0xcf97cf06669dddc4), UINT64_C(0xfb186fa1338cfb09) }},
};

static const block_t Zi_27[] = {
  {{ UINT64_C(0x7a6a762780c13978), UINT64_C(0xd93c2dc15a1b8679), UINT64_C(0x09b32d4a90aa3089), UINT64_C(0x2bf7a28182a56b99) }},
  {{ UINT64_C(0xeccde690e7200b20), UINT64_C(0xe2c156d6a48fd602), UINT64_C(0x753cbe4f2cf789b7), UINT64_C(0xadddbe72658bfcd2) }},
  {{ UINT64_C(0xcd1c7bebfc0bded2), UINT64_C(0x7e1d497d739b65db), UINT64_C(0x16b7d7b7aabedc62), UINT64_C(0x0e4af6de14610f4b) }},
  {{ UINT64_C(0x543f4ab860c090f8), UINT64_C(0x8e6850a27f66ab0b), UINT64_C(0x39dd00ba7b4c417d), UINT64_C(0x22e175731965c47e) }},
  {{ UINT64_C(0xca5529d382b08e58), UINT64_C(0x31520834c0289cf3), UINT64_C(0x9e46e83207178755), UINT64_C(0xa566ffe65e1f7a15) }},
  {{ UINT64_C(0xaa6cdece356d44ca), UINT64_C(0x677d84d2f1f3aade), UINT64_C(0xa2ccde45ec011d0f), UINT64_C(0x1f0a39340a3033a8) }},
  {{ UINT64_C(0xd8d599f0cf7a33af), UINT64_C(0x444a67953758ed11), UINT64_C(0x708b3307cfcd6a36), UINT64_C(0x7408f78b66a260dc) }},
  {{ UINT64_C(0xfeb8fc24053bc82b), UINT64_C(0x86cbe8fd3e34e753), UINT64_C(0x22449ebff8d15140), UINT64_C(0xff6ede2e89932e41) }},
  {{ UINT64_C(0xd031ce29cceeed0e), UINT64_C(0x43f97b2351e4c36e), UINT64_C(0x192e66dc7dd0dd1f), UINT64_C(0x6d494e7a594f4e72) }},
  {{ UINT64_C(0xcb9ca6001a22ea62), UINT64_C(0xc98a7a4879d7cbce), UINT64_C(0x59fdb894265769c9), UINT64_C(0xad4ec5ec627efee8) }},
  {{ UINT64_C(0xc8ca83a83a1523e2), UINT64_C(0xbe762751dad1c641), UINT64_C(0xdd4daf898094d959), UINT64_C(0x5eff5f42c4b94850) }},
  {{ UINT64_C(0x9adee5dd4f74af35), UINT64_C(0xe66505e48f4a3ea1), UINT64_C(0xfa6b5aa86322d893), UINT64_C(0x7291f27446c95fcc) }},
  {{ UINT64_C(0xfbfbb61fca78eed9), UINT64_C(0xba2d46b712428ddc), UINT64_C(0xdfce1e9ecfa6c803), UINT64_C(0x84f3d1a8319e2b4a) }},
  {{ UINT64_C(0x888b81698aa23237), UINT64_C(0xecfed69e818e5077), UINT64_C(0xe67c34b1201d944e), UINT64_C(0x96c869e312d7e619) }},
  {{ UINT64_C(0xfcfd0dd13e4b13bb), UINT64_C(0x7294d0a19e794875), UINT64_C(0xcf428d343c031de2), UINT64_C(0x70db8bd32b191c29) }},
  {{ UINT64_C(0x7d865275559a1fef), UINT64_C(0x2d961a0f31822033), UINT64_C(0x872a05d5eebbf692), UINT64_C(0x63b1fbf81c1ffcc1) }},
  {{ UINT64_C(0x2983245d1585df42), UINT64_C(0xd448a2a27c4075ab), UINT64_C(0x7c966395ae568ded), UINT64_C(0x96affc643c2aaee3) }},
  {{ UINT64_C(0x62ab12d5c0aca35c), UINT64_C(0xff4babc3e7b3035f), UINT64_C(0x293625c2597a9605), UINT64_C(0x38f91e520d6add1d) }},
  {{ UINT64_C(0x759b91caaca97cc8), UINT64_C(0xa8fa085e2710f648), UINT64_C(0xe17cbec041b1ff3c), UINT64_C(0x8a74085fd2fee480) }},
  {{ UINT64_C(0x0984200cb3e6c843), UINT64_C(0x584ac0f8d693d308), UINT64_C(0xe09e42da612c8940), UINT64_C(0x0b5b156820124226) }},
  {{ UINT64_C(0x4b6b633a35717534), UINT64_C(0x4b5a96a83970c4a6), UINT64_C(0xe1134c6891cc326e), UINT64_C(0xeec11d7f185508c0) }},
  {{ UINT64_C(0x1636885c681db54f), UINT64_C(0x51cca999358d5cef), UINT64_C(0xd1f58fdbb18a003f), UINT64_C(0x8bf7fca03c113caa) }},
  {{ UINT64_C(0xbb6db830d6ef8f8a), UINT64_C(0xdb5ec11fd509ff2f), UINT64_C(0x5e61679aaf74dce5), UINT64_C(0x397a6450f8c88eba) }},
  {{ UINT64_C(0x193497c49244977b), UINT64_C(0x75a45c7a4e015395), UINT64_C(0x6aedeb9a35a61934), UINT64_C(0x60a4a7c80c3b1b5a) }},
  {{ UINT64_C(0x826016f39fe5e681), UINT64_C(0x2db8a188165d3a2f), UINT64_C(0xd5f268dca0ca78fc), UINT64_C(0x4bc7a594dc70295b) }},
  {{ UINT64_C(0xe0230722a7d233fc), UINT64_C(0x5c0955f7c8fa64a5), UINT64_C(0x714d9da961203cf1), UINT64_C(0xc45eced73ca4e32f) }},
  {{ UINT64_C(0x1effedee16677ebc), UINT64_C(0x2df4a93cf36643e9), UINT64_C(0xaf77ac5c79e26698), UINT64_C(0x96059346cf3da4e2) }},
  {{ UINT64_C(0x38219fa02a81c7ae), UINT64_C(0x9679c15b89d7c8ff), UINT64_C(0xe2b3df22fcf28d78), UINT64_C(0xcd8c4072d0d559f7) }},
  {{ UINT64_C(0xd802d0a9b3fd1ebb), UINT64_C(0x011e09a17c8cd672), UINT64_C(0xffe20f15519e9113), UINT64_C(0x5b1ec48c2d01036c) }},
  {{ UINT64_C(0x0d586adcdd32b8fe), UINT64_C(0x396018cd2e366c3b), UINT64_C(0x840c60d18675296a), UINT64_C(0xf99d6e04decdd625) }},
};

static const block_t Zi_28[] = {
  {{ UINT64_C(0x8fe19f8232b1e8b7), UINT64_C(0xf031494761e00ea3), UINT64_C(0xd36bf642b0ab1e79), UINT64_C(0x6781f76177c212ed) }},
  {{ UINT64_C(0xd2c680a3ad368d30), UINT64_C(0x45a94194ab8748e1), UINT64_C(0x0db8b8e8258f7944), UINT64_C(0x5b23af6b87519eb6) }},
  {{ UINT64_C(0xba3911fe7adf5e29), UINT64_C(0x04384cc699ed8b9a), UINT64_C(0x65368c17aa8098f2), UINT64_C(0x637da3fd35efa080) }},
  {{ UINT64_C(0xf0e7976a905b952a), UINT64_C(0x085d38e04bcb1c67), UINT64_C(0xa08345c5a66248ab), UINT64_C(0xea53d67354148edf) }},
  {{ UINT64_C(0x7191fa267536856a), UINT64_C(0x336b2669256bc4bb), UINT64_C(0x88210408f53d43b9), UINT64_C(0xf7b756506303e58f) }},
  {{ UINT64_C(0xfdcba5355fd55332), UINT64_C(0x24c2a9c2ff91bd55), UINT64_C(0x51e4c5060b69f54c), UINT64_C(0xdcbc1f9b4647ac40) }},
  {{ UINT64_C(0x92803c31633a4e1c), UINT64_C(0xda3a8199be58c6a3), UINT64_C(0x76dac433b0705f5c), UINT64_C(0x23e78e55dbc54320) }},
  {{ UINT64_C(0xeb396b0ebda6ec51), UINT64_C(0x097591dcb461f316), UINT64_C(0x8d4b62d07eadfc5e), UINT64_C(0x612305c5d124507b) }},
  {{ UINT64_C(0x002fa29132693c5a), UINT64_C(0x30f32bbe26f40c7e), UINT64_C(0x6e6207422a7236af), UINT64_C(0xc08b27ae149716b2) }},
  {{ UINT64_C(0xb54d902baea53097), UINT64_C(0x0c7fddbaeccab68b), UINT64_C(0xe3f1460cbb8213cf), UINT64_C(0xab95f54b998b22a5) }},
  {{ UINT64_C(0x965e6de7e7ef8a37), UINT64_C(0x578ca1c5eb9b421e), UINT64_C(0x728d9ff178e8f53c), UINT64_C(0x024f30ff16b53dfd) }},
  {{ UINT64_C(0xe25e7a3d21d3815a), UINT64_C(0xd7301833a314c621), UINT64_C(0x08ff4cac1ba9ceb0), UINT64_C(0xf845c2a0456e22a3) }},
  {{ UINT64_C(0x19128d868e207eef), UINT64_C(0xe10792395323a841), UINT64_C(0x712a3d1119e7f565), UINT64_C(0x0bbd2af3b0419c0d) }},
  {{ UINT64_C(0x84dd7897ea262fa4), UINT64_C(0x6cc0e4a88e17d8e8), UINT64_C(0x4401b1dc60077f5a), UINT64_C(0x1dd1e6c563a7aca7) }},
  {{ UINT64_C(0x9754f05c61c6b40e), UINT64_C(0x886513359b135572), UINT64_C(0x8fd4c61d5df08d95), UINT64_C(0x4b636f63643ae5b9) }},
  {{ UINT64_C(0xf6dc9f5746ce2f03), UINT64_C(0xd589989b6d177663), UINT64_C(0x3c05449d5736996d), UINT64_C(0xcb895f5041610418) }},
  {{ UINT64_C(0x3eeffde1aced60dd), UINT64_C(0x1b415373971b2ce0), UINT64_C(0x9d436a68c021cbcb), UINT64_C(0x70cea662a3eb1cfe) }},
  {{ UINT64_C(0x0aba64b8d9a8f7d0), UINT64_C(0x05d077c8f4fa1f01), UINT64_C(0x16c9a8220da2ed05), UINT64_C(0x77f045146a225b1f) }},
  {{ UINT64_C(0x5f8951dc720c83fa), UINT64_C(0x6de5d2a236ae19dd), UINT64_C(0x5c33cf6fc2285a86), UINT64_C(0xd5f5c01063a9f839) }},
  {{ UINT64_C(0x62a6f4909ac52cde), UINT64_C(0x0eeb2244b4068d7b), UINT64_C(0xcb8b839650d8e74d), UINT64_C(0x3b8ebf345e084086) }},
  {{ UINT64_C(0xed24387256564eb3), UINT64_C(0xc4ccad86a5e51198), UINT64_C(0xc803ab1ec65c0c4d), UINT64_C(0x795c8105002cacf1) }},
  {{ UINT64_C(0x3e10275db2c5c0c1), UINT64_C(0x1622b404542013f0), UINT64_C(0xe17aefc3f3efa7f3), UINT64_C(0x82b6907068823d6a) }},
  {{ UINT64_C(0x7cc075c274940bce), UINT64_C(0xa4465db4c9931e49), UINT64_C(0xbd29fa1c1746e46d), UINT64_C(0x334c15ba26e5f2f2) }},
  {{ UINT64_C(0x74e02ecd241ff8f9), UINT64_C(0x2ac654208164f794), UINT64_C(0x1f870c317ebb19e3), UINT64_C(0x8c26508c89e29af2) }},
  {{ UINT64_C(0x7ccfa4ef7b0312a2), UINT64_C(0x74db948741c93f4a), UINT64_C(0x5f3035396bb993d7), UINT64_C(0xa846180129771a62) }},
  {{ UINT64_C(0x4b60d0aa16ceb9c2), UINT64_C(0x9d22dbd9e28a3142), UINT64_C(0x3cf7a796a53f8096), UINT64_C(0x211f25313b6bf8f7) }},
  {{ UINT64_C(0xb855289c459f114a), UINT64_C(0x0595261a7813c2ed), UINT64_C(0x4b63aa549d6be50f), UINT64_C(0xc930b8c809f33647) }},
  {{ UINT64_C(0x4aa6fe984435b023), UINT64_C(0xf1eeb10a5438bd2c), UINT64_C(0x75f59a41936f8c95), UINT64_C(0xb59d81dd33c943ae) }},
  {{ UINT64_C(0xc5089181c1bbc209), UINT64_C(0xcace5dd7985bbf00), UINT64_C(0x58a171651a2ae96f), UINT64_C(0x9131f1a9f136ee06) }},
  {{ UINT64_C(0x18e81d2615f050ae), UINT64_C(0xe60fa44ed011d339), UINT64_C(0x7c1a661a0ab42c07), UINT64_C(0x92adcd3bc1a58d0f) }},
};

static const block_t Zi_29[] = {
  {{ UINT64_C(0xac64192df77ac9ac), UINT64_C(0x3af146e072d6b880), UINT64_C(0x574f1b6337fc8ba7), UINT64_C(0xc8a284ead5a44712) }},
  {{ UINT64_C(0x80181d0f327a8eb4), UINT64_C(0x9281cc37e4343603), UINT64_C(0xc58dcefa2019d8e5), UINT64_C(0x54756cb93e5b17c3) }},
  {{ UINT64_C(0xaa3fd046dbb43122), UINT64_C(0x1d1c87414115a798), UINT64_C(0x2b61f02231602b64), UINT64_C(0x891aad9ec5a45ec2) }},
  {{ UINT64_C(0x5b7f4073a0812288), UINT64_C(0x797157c55e8e1d46), UINT64_C(0xdd35fe04ee634c5f), UINT64_C(0x648cc6f6c98deb82) }},
  {{ UINT64_C(0x5f422560e41b5086), UINT64_C(0x95877d062ea44859), UINT64_C(0xfdb897124c8e1baf), UINT64_C(0x46339921c82e0d86) }},
  {{ UINT64_C(0x6116e5e4cb1f3098), UINT64_C(0xe8fb390dbc60e873), UINT64_C(0x6e7ed593a834774e), UINT64_C(0x5cee0ec6e7f05179) }},
  {{ UINT64_C(0x35b40eef7f0e7262), UINT64_C(0x2a59216f9bfee7ad), UINT64_C(0x0b0e61c3c6b78d8c), UINT64_C(0x4572cb0d5f49f833) }},
  {{ UINT64_C(0xe2e779e208b5ee26), UINT64_C(0xdff6a6523bc523bb), UINT64_C(0xa501efce036a61dc), UINT64_C(0xd076d7353616ba29) }},
  {{ UINT64_C(0x2e9cea1d74cf90f4), UINT64_C(0x0088873044edd06b), UINT64_C(0x29b9e548fb7a441f), UINT64_C(0x296ffb64792b896a) }},
  {{ UINT64_C(0xb9204fbb35b363f4), UINT64_C(0x8f70ba59c2334066), UINT64_C(0x0336ad6ea36bef8b), UINT64_C(0x58f85d432a0a14db) }},
  {{ UINT64_C(0x926a420a95cf0afd), UINT64_C(0x12c065739f012ff3), UINT64_C(0x6cb43d2a323c2b2e), UINT64_C(0x9a6d67146e488282) }},
  {{ UINT64_C(0x324f46f4f6768d08), UINT64_C(0x3e82a9a5824e8578), UINT64_C(0xefa3de0c10c72fc5), UINT64_C(0xa7a69e8a9e504db5) }},
  {{ UINT64_C(0x860c85bc5b86e3b9), UINT64_C(0x6fdcf756ceb9648d), UINT64_C(0xf57bfbfb7b5a7ed8), UINT64_C(0x4d14f7784939060a) }},
  {{ UINT64_C(0x314e5a6a7f5783ac), UINT64_C(0x0120cc7a1a77a0b7), UINT64_C(0xaf5155c47d7609e4), UINT64_C(0x9630d3805474edb2) }},
  {{ UINT64_C(0x9a8468d1d495b4e6), UINT64_C(0x13c0293ac44e7890), UINT64_C(0x942d8b6b2e79520e), UINT64_C(0x39bd3decab32436e) }},
  {{ UINT64_C(0x6722420a21f3baac), UINT64_C(0x96452118934391ad), UINT64_C(0xdcc0aa68aea09af5), UINT64_C(0x5c43fe9278d9d192) }},
  {{ UINT64_C(0xb9e91046ceeee035), UINT64_C(0x781e7fb03d7fba23), UINT64_C(0xd8e3e823c4ea928f), UINT64_C(0x9405058c43da045a) }},
  {{ UINT64_C(0xa5b86e6f630a1dcd), UINT64_C(0x4050e30811eb23d8), UINT64_C(0x22e1169e317a1b78), UINT64_C(0xc406d22ba4c57e94) }},
  {{ UINT64_C(0x410bd19d82860b64), UINT64_C(0xdcb7572f5eba61e3), UINT64_C(0x201d760b784622c2), UINT64_C(0x2ecde76a98125c19) }},
  {{ UINT64_C(0x6af90a0781781c1e), UINT64_C(0xdb86d750789c46a1), UINT64_C(0xac61aa2b33998009), UINT64_C(0xb9d6bf093e1a9909) }},
  {{ UINT64_C(0x8396909173ebb2f1), UINT64_C(0x597eb698ddb78739), UINT64_C(0xce9dde3b861fd7b3), UINT64_C(0xd443a2aa6b444778) }},
  {{ UINT64_C(0x57794067e50f50c4), UINT64_C(0x4c5ecc92c40b17c1), UINT64_C(0x348e732c27e0bad6), UINT64_C(0x6883acc51c684fde) }},
  {{ UINT64_C(0xd2ad6d2e7558db7c), UINT64_C(0xafd20764cc7bd036), UINT64_C(0x1a252e463d75c3f9), UINT64_C(0x0938b21b61e6a365) }},
  {{ UINT64_C(0x3cd17c3f2a8fffa9), UINT64_C(0x1c0a627d838a9f5b), UINT64_C(0xff8a745a67648d2c), UINT64_C(0x2870e9939e824fd7) }},
  {{ UINT64_C(0xc689beb58af1b860), UINT64_C(0xc4e478e507a17a07), UINT64_C(0xfd578e68b42dce61), UINT64_C(0xebe5482a41e5e0e9) }},
  {{ UINT64_C(0x5176dbe47c745b27), UINT64_C(0xe06104f7836f2523), UINT64_C(0xd92894aba310cab7), UINT64_C(0xb19c3ef582a0640f) }},
  {{ UINT64_C(0xd4ab07d8ebb79f59), UINT64_C(0x442042ee6e7e4122), UINT64_C(0x3f612b3cf45d8e06), UINT64_C(0x62ca07d2d6ace981) }},
  {{ UINT64_C(0x589e59297ee24e53), UINT64_C(0xf88c063a12c00425), UINT64_C(0xf221d964f6d8eac7), UINT64_C(0x0c17c859b72b2e6b) }},
  {{ UINT64_C(0x5e5e1190d12e353e), UINT64_C(0xd1bc1eac1c5979c7), UINT64_C(0xac6b6af38bba9260), UINT64_C(0x30cfe7e17e01ac7a) }},
  {{ UINT64_C(0x80a9403858dd5872), UINT64_C(0x17fae386625f951c), UINT64_C(0xebd3af1596fe16c3), UINT64_C(0x5da249a28d8253ec) }},
};

static const block_t Zi_30[] = {
  {{ UINT64_C(0x4bd17da244b2e984), UINT64_C(0x9efe6e69ac204a80), UINT64_C(0xb0a00dc7998cca50), UINT64_C(0x89dc4adc8805dc73) }},
  {{ UINT64_C(0xf19f462be38ae794), UINT64_C(0xd603714b3a888c6f), UINT64_C(0x46758c80b99c4378), UINT64_C(0xb014a2ec1f7ece5c) }},
  {{ UINT64_C(0x2d2aed655bbbbc33), UINT64_C(0x6757498adfed9eb4), UINT64_C(0xc8a0f840e7c33780), UINT64_C(0xcdbc39ada0222b74) }},
  {{ UINT64_C(0xdaf9a7288390d3c2), UINT64_C(0x1f153d940bbcfba5), UINT64_C(0xd2bc85766b4bb8e3), UINT64_C(0xffdad451eff38993) }},
  {{ UINT64_C(0x15382838188e39e6), UINT64_C(0xea4e9daa24d9e984), UINT64_C(0x74c7da70258ae625), UINT64_C(0xd61e7af440b69a93) }},
  {{ UINT64_C(0x9617fb02624695c2), UINT64_C(0x646b2b11c4fd741a), UINT64_C(0x5a804a562f86e2b9), UINT64_C(0x762d3bc02e7e5cc2) }},
  {{ UINT64_C(0x3073f480b271d3ed), UINT64_C(0x23e94a130176d2a8), UINT64_C(0xec6e390ace379627), UINT64_C(0x550ce4c82636ceb9) }},
  {{ UINT64_C(0x22b7a2bd5b45e21b), UINT64_C(0xdcaa85bae0c77651), UINT64_C(0x7f0fa48e49ca81da), UINT64_C(0x11256075fe04bbc4) }},
  {{ UINT64_C(0xf111e7f89c774dc5), UINT64_C(0x9497c2863726245b), UINT64_C(0x6e495787be65117d), UINT64_C(0x0346ae7307351204) }},
  {{ UINT64_C(0x4780d705520d25d2), UINT64_C(0x38a79a07b88fec47), UINT64_C(0x9014f560ea37914c), UINT64_C(0x5de6f76a65be545a) }},
  {{ UINT64_C(0x5ee52dbc135ad5dc), UINT64_C(0xfb151ed9953c3440), UINT64_C(0x92481249744e5eec), UINT64_C(0x20de125c8e7c6050) }},
  {{ UINT64_C(0xc1cefd1de262a37b), UINT64_C(0x51cb7572e0dc3bcc), UINT64_C(0xe9f18d99e6d69888), UINT64_C(0x06184989e43e109a) }},
  {{ UINT64_C(0x95b32f4071d4a373), UINT64_C(0x25d55d391b0da9eb), UINT64_C(0xbdc1f436b2a12ed5), UINT64_C(0xd651ebed07d55468) }},
  {{ UINT64_C(0x9f4e8ab1f6cbb94a), UINT64_C(0xe03964e409182716), UINT64_C(0xa0b84771a7d47906), UINT64_C(0x26e307f7a425f831) }},
  {{ UINT64_C(0x40601e9567456652), UINT64_C(0x5a12ef6242c7309a), UINT64_C(0x4b07d8acd96fdcda), UINT64_C(0x44f66eba4758133f) }},
  {{ UINT64_C(0x724d537614cfd236), UINT64_C(0x455e373815403e6c), UINT64_C(0xd66930b0df00530b), UINT64_C(0xc87ce84e9eae5d28) }},
  {{ UINT64_C(0xb071d58dfcc0bcd2), UINT64_C(0xf225c69fcc6ca117), UINT64_C(0x9126a3ec1408de62), UINT64_C(0x5d8dd264795239ec) }},
  {{ UINT64_C(0xb45ee560afd9a7ef), UINT64_C(0x3e493d84e9fa822a), UINT64_C(0xdc7d66f92c2fa43c), UINT64_C(0x28a27c61e96f663c) }},
  {{ UINT64_C(0x6218d5e129ad8cb4), UINT64_C(0xd35c41922db3fea9), UINT64_C(0x421af495aa97cc8e), UINT64_C(0x4abbc2e09eea3e15) }},
  {{ UINT64_C(0xbd7411456006bcca), UINT64_C(0x5fad70cb09e5edec), UINT64_C(0xf484b2a722bb2da1), UINT64_C(0x8f85045e6121f9db) }},
  {{ UINT64_C(0xa91e6f6166e7fafd), UINT64_C(0x16695f5adbf24dd9), UINT64_C(0x915bd7bfc5e96ec0), UINT64_C(0x9d2aad2ffcb357a6) }},
  {{ UINT64_C(0xa11e7b4e48ac2c46), UINT64_C(0x38c0fedacbb613a3), UINT64_C(0x92ec0f56887f2b36), UINT64_C(0xf2cc0d04725419ff) }},
  {{ UINT64_C(0x5ada5711c956305d), UINT64_C(0xbc4d50712fcc0864), UINT64_C(0xb8c15a86896a1c51), UINT64_C(0xc5c76d286611763a) }},
  {{ UINT64_C(0x560626fe851d420b), UINT64_C(0xb8007c28ce2abf19), UINT64_C(0x1b408b8b10e263be), UINT64_C(0x411d310e1c12dff9) }},
  {{ UINT64_C(0xd947475b6c88fa16), UINT64_C(0x6efa723f4a76a038), UINT64_C(0x66d5f5bda84fe351), UINT64_C(0x1ffe7b9be2a88bac) }},
  {{ UINT64_C(0x451df9e9f8ad22dc), UINT64_C(0x55a2ac7ead3abefe), UINT64_C(0x306224f88bd75bd6), UINT64_C(0x0279eb1a8073087e) }},
  {{ UINT64_C(0x83d5807f46ab5c58), UINT64_C(0x0f0f1af6b791ddbb), UINT64_C(0x8e4c38e21d28f91a), UINT64_C(0x5888549e869f138b) }},
  {{ UINT64_C(0x57fc5a6d48b018e3), UINT64_C(0xed3d206b366db88c), UINT64_C(0xa36c8aa5b61a8663), UINT64_C(0x43c27d33546dff13) }},
  {{ UINT64_C(0x432d9f633d81b83b), UINT64_C(0x6c4c38af24391976), UINT64_C(0x4f0eec92bf71c0a5), UINT64_C(0x2136056427834faf) }},
  {{ UINT64_C(0x3eef97db29eec73a), UINT64_C(0x9f2206b89011b5ac), UINT64_C(0xc56002da666c3879), UINT64_C(0x3399a7b50dee0f16) }},
};

static const block_t Zi_31[] = {
  {{ UINT64_C(0xcad3cd2450fac414), UINT64_C(0x713f35114a83b628), UINT64_C(0x3d0a59cadba3805a), UINT64_C(0xb7867a6f4a1b65a4) }},
  {{ UINT64_C(0x9ac3d0bad1e69ff2), UINT64_C(0x1bfe779c4f504394), UINT64_C(0x38a9eee89690e6af), UINT64_C(0xc3257cba19c04f24) }},
  {{ UINT64_C(0x415b21dbc47d3328), UINT64_C(0xb5513e4022c97780), UINT64_C(0x51694c6a14d693a4), UINT64_C(0x6388caa9c06982c7) }},
  {{ UINT64_C(0x27ed693d527c67f0), UINT64_C(0x0574651fb5f6b364), UINT64_C(0x5879dfba73c2c181), UINT64_C(0xee6d177216580c04) }},
  {{ UINT64_C(0x255c60bd4605f6fb), UINT64_C(0x6539fdafa991eddc), UINT64_C(0x5f433a6592dc5e16), UINT64_C(0x5f49cabf15b12f15) }},
  {{ UINT64_C(0xb9969947a9c838c2), UINT64_C(0xcbfaef8ef255bc32), UINT64_C(0x1b127d06def8597e), UINT64_C(0xae43f13a6ca5d59a) }},
  {{ UINT64_C(0xb18db3c64ab39a87), UINT64_C(0x7beec1fe3cfb6245), UINT64_C(0x02ee3531e4f6fcc2), UINT64_C(0x481f286315563e4f) }},
  {{ UINT64_C(0x03eaf8200e25b799), UINT64_C(0x2d0adb5d35ac0e30), UINT64_C(0xc92a36c0609d9092), UINT64_C(0x98f86296d8a4996b) }},
  {{ UINT64_C(0xc449c9fb49ccb5a6), UINT64_C(0xb76b11f11a935328), UINT64_C(0xaf08bd8c67442c65), UINT64_C(0x5600f5b58080ea93) }},
  {{ UINT64_C(0x196c77c8d9654d38), UINT64_C(0xee20d80e73c85223), UINT64_C(0x64457f6504d46fce), UINT64_C(0x60ed538bbcd90231) }},
  {{ UINT64_C(0x8b94d28312f2e982), UINT64_C(0xa24cd842d5b1b059), UINT64_C(0xb0d4e405e9a54f71), UINT64_C(0x202ef33d04635389) }},
  {{ UINT64_C(0x602a9c3ed3b03f3d), UINT64_C(0xd663daadfd60d869), UINT64_C(0x7e57c5b995ba7add), UINT64_C(0x442863a0c213dbd1) }},
  {{ UINT64_C(0xbd7717bff6cccc25), UINT64_C(0x6a454de826222b28), UINT64_C(0xd28998ddc516add7), UINT64_C(0x23e953f2fd924800) }},
  {{ UINT64_C(0x43810d6e861e9a0c), UINT64_C(0x2fb667f2cfc15659), UINT64_C(0x6c3da96ab8d02d34), UINT64_C(0x007cce6c018ae72d) }},
  {{ UINT64_C(0x943b0b0b43e43ebc), UINT64_C(0x4d0b9c22f5c209e4), UINT64_C(0x6dab673173aadfdc), UINT64_C(0xd9864b482ba28b03) }},
  {{ UINT64_C(0x89511d1a130c5302), UINT64_C(0x26ec46a6a65856d9), UINT64_C(0xc947074f7772d91d), UINT64_C(0x8e254535e93ac688) }},
  {{ UINT64_C(0x0ef990e87b5c5699), UINT64_C(0x669c8dfe4b53fdc3), UINT64_C(0x28c7b71ac2aea22d), UINT64_C(0x65ed179f9f7f2bd1) }},
  {{ UINT64_C(0x6c3ca2ff93adf51a), UINT64_C(0x0b147873a9bcf11f), UINT64_C(0x247e5acc0e796d8f), UINT64_C(0xbc9a389f388f0bfe) }},
  {{ UINT64_C(0xa8aeec78c8334f6a), UINT64_C(0x94c8fc87b5dd2a5f), UINT64_C(0x1a96640509dc6736), UINT64_C(0x0a7f708e81a30a7b) }},
  {{ UINT64_C(0xa4924cc856510ce8), UINT64_C(0x391ce3827d817c6c), UINT64_C(0x823bbc4a4e1766f8), UINT64_C(0xcff76ecaa656c3ae) }},
  {{ UINT64_C(0x69ecfaff061b45ae), UINT64_C(0x737b15713692c7fe), UINT64_C(0xbf104f4732c8acb8), UINT64_C(0xc4b43c1db3656035) }},
  {{ UINT64_C(0x76c45d6a716cdaa9), UINT64_C(0x10da38b2df4184d2), UINT64_C(0x81c69e99004ea5d2), UINT64_C(0xa4f6a507c98f53b5) }},
  {{ UINT64_C(0x84f690f8b5ee42dc), UINT64_C(0x7604f7aa68038b24), UINT64_C(0x569cd21f4312f199), UINT64_C(0x252f4e9aa4cc22e4) }},
  {{ UINT64_C(0xab7da3e45d71e03f), UINT64_C(0x15e4666584368f50), UINT64_C(0x13480d61d46ffed3), UINT64_C(0xe63a067a1be9e8fe) }},
  {{ UINT64_C(0xf38c2e16c1d1f85f), UINT64_C(0xc808f4f42c2ec135), UINT64_C(0x0f83c900c8080858), UINT64_C(0xb93ff69aa3d0c239) }},
  {{ UINT64_C(0x07fb4b9e64829961), UINT64_C(0x86e751a7831ee59f), UINT64_C(0x7544087631002c25), UINT64_C(0x10f497f5c21aad02) }},
  {{ UINT64_C(0x5d4f02fc26f16391), UINT64_C(0x44a555df996c314e), UINT64_C(0xa9e908a62998f895), UINT64_C(0x1b3ff8a2c8d9b157) }},
  {{ UINT64_C(0xaf7bb7e170e31002), UINT64_C(0xabf27e7bc87739b0), UINT64_C(0x78848fca7a3076d9), UINT64_C(0xeea82614e49961f3) }},
  {{ UINT64_C(0x4a7093e4be72ad0d), UINT64_C(0x1f7299c28ee5715a), UINT64_C(0x26fe1d418264c0f7), UINT64_C(0x8a06c4ec686557a6) }},
  {{ UINT64_C(0xd545ff8d090c9cf2), UINT64_C(0x1ef3efd039e68ee9), UINT64_C(0x6e7bf0e0959880ef), UINT64_C(0x29222bae9785d33a) }},
};

static const block_t Zi_32[] = {
  {{ UINT64_C(0x25d81e52ee3c6d07), UINT64_C(0x6f28525ae5163e9f), UINT64_C(0xcc0f53a67b089cd4), UINT64_C(0x11c23d3f1e27a16e) }},
  {{ UINT64_C(0x0b6100434c396b27), UINT64_C(0x13486f0ba622c072), UINT64_C(0xd3fae08c9696d17a), UINT64_C(0x28fb7bccde838834) }},
  {{ UINT64_C(0x38f24f053d8cc644), UINT64_C(0x302dca570c88dec3), UINT64_C(0x9967d3ebfe9c71df), UINT64_C(0xd8a6acdcac2ec031) }},
  {{ UINT64_C(0xabd380ee8fb42148), UINT64_C(0x298f9c47fb920714), UINT64_C(0x394c444db1bb5967), UINT64_C(0xdbcbded5acde3f45) }},
  {{ UINT64_C(0xcd8e732463ceab01), UINT64_C(0xef446c0027822373), UINT64_C(0x2c83cdf61e767ad3), UINT64_C(0x199274bf3adbbd4f) }},
  {{ UINT64_C(0x3b99286dc8375034), UINT64_C(0x3e4b974d7cef78dd), UINT64_C(0x9b65618fa8a723b2), UINT64_C(0x7edff90b48c0ac99) }},
  {{ UINT64_C(0xe1845e093a40b760), UINT64_C(0x4f638ffbbf64a891), UINT64_C(0xda9bd1d9dfe3c053), UINT64_C(0x65c01e09e4b670db) }},
  {{ UINT64_C(0x74b26f9c0f12160c), UINT64_C(0x27884db70524d3f0), UINT64_C(0x12a67edd99dcf367), UINT64_C(0x1f044c4ecf5d09f7) }},
  {{ UINT64_C(0xfa10a9cf31471a56), UINT64_C(0x4832ecaaf1ece243), UINT64_C(0x546521ac133170b4), UINT64_C(0xd50d0d2410206cea) }},
  {{ UINT64_C(0xe848644e1cba11f3), UINT64_C(0x46f3101a7609789d), UINT64_C(0x9e131f86e47b4f02), UINT64_C(0xe8db867692dfa686) }},
  {{ UINT64_C(0x3ceca21c7fb067f9), UINT64_C(0xf5877615e3d3985e), UINT64_C(0x1c6cf13457152fad), UINT64_C(0xbcc4b393240bc289) }},
  {{ UINT64_C(0xfc888b8cc66fd357), UINT64_C(0x6eb7510a6dddefa8), UINT64_C(0xd2cb70d0742ecbd0), UINT64_C(0x49cbfaefff199dcd) }},
  {{ UINT64_C(0x29e7d702f7e437f5), UINT64_C(0xb5b5afd2a6eb3033), UINT64_C(0xaa1adade4dc893a8), UINT64_C(0x825c6c09dbcf7733) }},
  {{ UINT64_C(0x26a114e890f608ae), UINT64_C(0x62a120ed19ed2942), UINT64_C(0xd3fc5582bb045e72), UINT64_C(0xc114dc62befcd33c) }},
  {{ UINT64_C(0xfafe0c24d041be26), UINT64_C(0xe5853c6302953227), UINT64_C(0xf07761d951258901), UINT64_C(0x1f14faaacacd00e2) }},
  {{ UINT64_C(0x7101b37507d1ecf4), UINT64_C(0xe456c75869321d12), UINT64_C(0x71d03e36b8d41347), UINT64_C(0x095b0404dadc924c) }},
  {{ UINT64_C(0x01dc5134877b01f5), UINT64_C(0x8f4002b10f85203c), UINT64_C(0xa565c7e3a41aa68b), UINT64_C(0x02e00968953a1ac5) }},
  {{ UINT64_C(0xb51f218ad269a691), UINT64_C(0x83e417b7b5684179), UINT64_C(0x3bc9c8af072579b9), UINT64_C(0xcb5a6a0c473188c0) }},
  {{ UINT64_C(0x4aed48bdb9ffa6bb), UINT64_C(0x51a826717f26273f), UINT64_C(0x0faa6dff9dd10bcc), UINT64_C(0xb694f1ae4ba57b72) }},
  {{ UINT64_C(0x5c31a10cac58f220), UINT64_C(0xcc6182adfb35a79a), UINT64_C(0xd93d48ee8b6e916d), UINT64_C(0xd0da0dabd92fb00a) }},
  {{ UINT64_C(0x055de120e61e8597), UINT64_C(0x2132b7be9f9e54a9), UINT64_C(0xd4af0bfc26ddc51a), UINT64_C(0x0601cefd0fa112dd) }},
  {{ UINT64_C(0xee54206f5730718b), UINT64_C(0x8185e82bff1f59f5), UINT64_C(0x7503fa212c359103), UINT64_C(0xaca1ff6033e18f79) }},
  {{ UINT64_C(0xe9b32be0e8b07165), UINT64_C(0xd306c95957e3e434), UINT64_C(0x1419b1bc05c29afe), UINT64_C(0x829a8602b0912242) }},
  {{ UINT64_C(0xe6089b238ce6acf2), UINT64_C(0xbc91b1a7b0eb5f69), UINT64_C(0xf606a97d357717de), UINT64_C(0xe2c66b38b9d8d0e0) }},
  {{ UINT64_C(0xc339867da453a0b4), UINT64_C(0x8612acd085ba782c), UINT64_C(0x9fb58af74c156d9e), UINT64_C(0x37b932c0fecbc5db) }},
  {{ UINT64_C(0x8694127cf788d3d0), UINT64_C(0xb4274126c5a91f2c), UINT64_C(0xc9a33b2a055917b7), UINT64_C(0x5b449645a5dfecab) }},
  {{ UINT64_C(0x24328fdae4d4e71d), UINT64_C(0x4d1fa0119a172317), UINT64_C(0xe87412c2c540fa69), UINT64_C(0xd595e5e9ac4b0cd5) }},
  {{ UINT64_C(0x83fa15c4c228dbcb), UINT64_C(0x3798165ab0dc7229), UINT64_C(0x05919e33ed16a3dc), UINT64_C(0x1762a53238846f9c) }},
  {{ UINT64_C(0x05109e59d76c82cd), UINT64_C(0x7cb7b1126367c7d7), UINT64_C(0xed3afbea33c17971), UINT64_C(0x30ac9772e5e6849b) }},
  {{ UINT64_C(0x75884eaff513956f), UINT64_C(0xa50fe6ff197b31b1), UINT64_C(0x9c92dad179b0c7fb), UINT64_C(0x042ba0e8c61959ca) }},
};

static const block_t Zi_33[] = {
  {{ UINT64_C(0x1c5e7417d75c790d), UINT64_C(0xfccd1af55edc6b23), UINT64_C(0x35133ed7dd1f8922), UINT64_C(0x85097b398ee412c2) }},
  {{ UINT64_C(0x607e70ffa39978ad), UINT64_C(0xe15fab6e8d35fa07), UINT64_C(0xa89d5d2d0e20d116), UINT64_C(0xa01d931c91cb21fa) }},
  {{ UINT64_C(0x81fcc391b29053b2), UINT64_C(0x68544b1d26f2c91e), UINT64_C(0x8814e54aa9eb6940), UINT64_C(0x02055b3f188c4b2a) }},
  {{ UINT64_C(0x4e42bcb36b84d33a), UINT64_C(0xe47120c8fcba8c5b), UINT64_C(0xf43a7852bc21ccb5), UINT64_C(0x4931094e78e19276) }},
  {{ UINT64_C(0x9db055291e02a1f5), UINT64_C(0x6702bbc01b7359f7), UINT64_C(0xbc20462edeb08b02), UINT64_C(0x5678bd65f6700a8c) }},
  {{ UINT64_C(0x126197b6a08261b4), UINT64_C(0x17208e595d15a0c0), UINT64_C(0x5c5a3b2a90c4cd4b), UINT64_C(0x067d840b2d091bb7) }},
  {{ UINT64_C(0x02c217625bbb2770), UINT64_C(0x1af43725eeefbf99), UINT64_C(0x39d159a3b3c5c2f9), UINT64_C(0xfa8d9a8c0f30d484) }},
  {{ UINT64_C(0x33aa0fe856afbd26), UINT64_C(0xb7bc07b930b4e644), UINT64_C(0x31b60d6f72397f9f), UINT64_C(0x3eb3be50619518a2) }},
  {{ UINT64_C(0x23c7ab106f90eb00), UINT64_C(0x4e2054e8d6a9dfa2), UINT64_C(0xae2c2d6e82edc50e), UINT64_C(0x5fe8b47966c5af1a) }},
  {{ UINT64_C(0x012eb4bff0007ce3), UINT64_C(0x7cf19c33a8e6fad2), UINT64_C(0x1fcf7b307b424ff6), UINT64_C(0xa6f3dd5ce70d93cd) }},
  {{ UINT64_C(0xa5cb55f99ccb2d5a), UINT64_C(0x42bfc56ed116e7f2), UINT64_C(0x23eaf5aef8fbf08b), UINT64_C(0x953d5edc834921ce) }},
  {{ UINT64_C(0x95a62536c2010a59), UINT64_C(0xb7dbecf0fbaeb213), UINT64_C(0x31db8efa04d2ff5f), UINT64_C(0x71adabd78f3879be) }},
  {{ UINT64_C(0x5f4f3e203b7d1985), UINT64_C(0xfb58b48f18b65c88), UINT64_C(0xaee88bea498ed9fc), UINT64_C(0xc3aca96ad7a61636) }},
  {{ UINT64_C(0xaafc744f9cec336e), UINT64_C(0xd62501be520eb6ab), UINT64_C(0x53b763c86d4ba1a5), UINT64_C(0x04feb9b65d9bb435) }},
  {{ UINT64_C(0xc8184cbb2da45272), UINT64_C(0x713662dd662956e2), UINT64_C(0x9161b610f8dd7b38), UINT64_C(0x3e5f26635787c454) }},
  {{ UINT64_C(0x676570bdc7189632), UINT64_C(0xe25f96f0e77107b5), UINT64_C(0x09f20fbb5f78d569), UINT64_C(0x8e5572bb621fb036) }},
  {{ UINT64_C(0xa37f82c9d3f4de28), UINT64_C(0x9c6ed21f093e8733), UINT64_C(0x6877e185791f04a1), UINT64_C(0x5da6206efd1a6fd5) }},
  {{ UINT64_C(0xe591cf2c4bba7ac1), UINT64_C(0xb983f0a0f4c3c365), UINT64_C(0x3994700f271b7caa), UINT64_C(0x132fb85471f332ff) }},
  {{ UINT64_C(0x5874b1039d7f7cef), UINT64_C(0x160bc314e15f67a7), UINT64_C(0x82420bcd3abc357b), UINT64_C(0x08ae214d96a80370) }},
  {{ UINT64_C(0x0e1d1f94e1178af5), UINT64_C(0xdaee41dd79194a8b), UINT64_C(0x11552a59580075eb), UINT64_C(0x0d3a7980012976d8) }},
  {{ UINT64_C(0x26935ea287a104e3), UINT64_C(0x6399b8178fcebc44), UINT64_C(0x21f9776fb0443c2f), UINT64_C(0x5b5a340e61b8a239) }},
  {{ UINT64_C(0xb6e88ece4d19d339), UINT64_C(0xa863a7ab52f8f779), UINT64_C(0x2e4bbd6fee39f7f9), UINT64_C(0x772ffe9639a786c4) }},
  {{ UINT64_C(0x85463b1d18310fff), UINT64_C(0x83e60bf3f3e77865), UINT64_C(0x3d8ac10b426e56c9), UINT64_C(0x9d5ad49bb574e33e) }},
  {{ UINT64_C(0x060ff86782dcb110), UINT64_C(0x1c807c77f2abc769), UINT64_C(0x03e350bad4f41bbc), UINT64_C(0xcd1163d1e52f54f7) }},
  {{ UINT64_C(0x29169623193aa43d), UINT64_C(0x68c3d261cb10f981), UINT64_C(0xb7beecfe257985ef), UINT64_C(0x6d57e330bde412ac) }},
  {{ UINT64_C(0x24ccfa8ab826cd70), UINT64_C(0x74242d602fd2c575), UINT64_C(0xb4dc2757eab24e02), UINT64_C(0x3c4cd740aef6090f) }},
  {{ UINT64_C(0xff9bdf1df03df506), UINT64_C(0x6b41edc85339afc1), UINT64_C(0x2db546fe712ac1dc), UINT64_C(0x1d61232a1dfc088e) }},
  {{ UINT64_C(0xfa8ab4bdc7cf47fa), UINT64_C(0x99ab9cf3145416eb), UINT64_C(0x2a6f49016a3a764e), UINT64_C(0xd2d35af9773c6d0f) }},
  {{ UINT64_C(0x908df05842d8be6d), UINT64_C(0x9ac1e9392484e150), UINT64_C(0x72f54885bfb13925), UINT64_C(0xd28987453fe5ccad) }},
  {{ UINT64_C(0x84632a027785c449), UINT64_C(0xb24c350606b15d44), UINT64_C(0x6a66bb41b6e9a355), UINT64_C(0xebde62e2d267a973) }},
};

static const block_t Zi_34[] = {
  {{ UINT64_C(0xbce23ccf5f99838b), UINT64_C(0x4a70d72da029ff36), UINT64_C(0xc463b8e8c30be0a8), UINT64_C(0x3aaceb463e573650) }},
  {{ UINT64_C(0x0955a7ac967005e5), UINT64_C(0x67cd867d0fe5bb1c), UINT64_C(0x9de5947c14b8d52c), UINT64_C(0x903c2615834016f6) }},
  {{ UINT64_C(0xa5fd428510910f15), UINT64_C(0xdc8f87a66df6199b), UINT64_C(0x8c928a222da05ed8), UINT64_C(0x7fc424313e5e8346) }},
  {{ UINT64_C(0xa2c77b7a9912fd88), UINT64_C(0x3bfb8989da196f47), UINT64_C(0x393a4f6db175d18f), UINT64_C(0xd59cbd504c57c897) }},
  {{ UINT64_C(0x63c82c45dde70554), UINT64_C(0x27c21582ccee90d0), UINT64_C(0x492759297817bbfa), UINT64_C(0xa39108b54fafe8e4) }},
  {{ UINT64_C(0xd114dcd4505ac836), UINT64_C(0x9e9a2d02ec781c63), UINT64_C(0x72b9730066a248f0), UINT64_C(0xd0a41e5b16581372) }},
  {{ UINT64_C(0xd0c313d291296f24), UINT64_C(0x4ea1a388bd2a76d3), UINT64_C(0xb2375a1dbd083db0), UINT64_C(0x7f2774eed3460a83) }},
  {{ UINT64_C(0xde70d9dd08253d95), UINT64_C(0x6a7a374837155cd5), UINT64_C(0x4dd773630cbe9989), UINT64_C(0x8233688bee4fefda) }},
  {{ UINT64_C(0xd887cfb42297a784), UINT64_C(0xa5efc9903d02b87b), UINT64_C(0xac326ced04fd7f92), UINT64_C(0xbc6a9b5b40096952) }},
  {{ UINT64_C(0x9ffb7bf8d2dcdb1d), UINT64_C(0xeaea23789ec6dbd6), UINT64_C(0x82ee670fe0b29070), UINT64_C(0x84e2e8ddbcf04889) }},
  {{ UINT64_C(0x0bdb5dd5a30e9e31), UINT64_C(0x78be5d3d2063f8d6), UINT64_C(0x2629bd91220237b7), UINT64_C(0xd7b1f0c7c4b998fa) }},
  {{ UINT64_C(0x046b5e8fada8ae6b), UINT64_C(0xe91c976041529c80), UINT64_C(0xf475e471cf92405f), UINT64_C(0xc3a3efd1e2653497) }},
  {{ UINT64_C(0x48bfb17562d6953d), UINT64_C(0x11c7b37a78f2e3e3), UINT64_C(0x168f49f7f5dfd425), UINT64_C(0x726fe65371369250) }},
  {{ UINT64_C(0xa5e82f4b76b3db2a), UINT64_C(0x151eb5545d079c6c), UINT64_C(0x9308430a621bf967), UINT64_C(0xb61d108a339074c1) }},
  {{ UINT64_C(0xbdae89d1a49b4b74), UINT64_C(0x42fa125e5d6c5864), UINT64_C(0x551648e0d4032981), UINT64_C(0xf3602db698ccef01) }},
  {{ UINT64_C(0xc17309f862030ff4), UINT64_C(0xed08299d29e298db), UINT64_C(0x3a88c49a1767c949), UINT64_C(0x0aeeb9ad5349f63e) }},
  {{ UINT64_C(0x1ca8f7cf3069a4f6), UINT64_C(0x42912d78e9109245), UINT64_C(0xa6daf5cb4c7b5f5e), UINT64_C(0xf5ddedc3276d223b) }},
  {{ UINT64_C(0x72887c65f23d789c), UINT64_C(0xde86c8c93d64ecef), UINT64_C(0xd05032df3f4334c0), UINT64_C(0x0ec76a64de33cd7f) }},
  {{ UINT64_C(0x7222d51306123acc), UINT64_C(0x65f0cbe225d12080), UINT64_C(0xd9b92338bd5a6aa3), UINT64_C(0x92b5b5a6030cbc4b) }},
  {{ UINT64_C(0x13cb18f9c859446c), UINT64_C(0x59f12a804a56e954), UINT64_C(0xef90dcd16a6f2f06), UINT64_C(0x1717b6d4dcbb362e) }},
  {{ UINT64_C(0x70181a60cca68dcd), UINT64_C(0x2c84d7039fc1550d), UINT64_C(0x072618af737325ba), UINT64_C(0x6d03725a80c25b7a) }},
  {{ UINT64_C(0x5e9b072a284e8712), UINT64_C(0x43f851470fe2717c), UINT64_C(0x169b26e9dbfdc22e), UINT64_C(0xd5609abbbf0d179e) }},
  {{ UINT64_C(0xb2b59b5cb975373b), UINT64_C(0x14db9e180b0a54ae), UINT64_C(0x20b0c8438227a2f7), UINT64_C(0x06a985310a651d1f) }},
  {{ UINT64_C(0xa2533c5da588d4e3), UINT64_C(0xdd1ec1a7513cf040), UINT64_C(0x55e7bb8e254532dc), UINT64_C(0x608114390003f1cd) }},
  {{ UINT64_C(0xea9467067dee9c18), UINT64_C(0x8a174a28461fc42e), UINT64_C(0xa357d8b9ffba36f4), UINT64_C(0xd1bfd4f515ae275e) }},
  {{ UINT64_C(0xdb42e29bcf216f7a), UINT64_C(0xbefeb4922526cca2), UINT64_C(0xd1e56d2ee924ccbe), UINT64_C(0xe583a5915056fb65) }},
  {{ UINT64_C(0xf1a0c39140012020), UINT64_C(0xed6f765c96a678c2), UINT64_C(0x35a772dd6b00423c), UINT64_C(0x9f07d1a7ba62a52f) }},
  {{ UINT64_C(0x8636df11ebb26356), UINT64_C(0x884cc9c020339679), UINT64_C(0x7aa51c493a2cf2ee), UINT64_C(0xfeb88b223737fbac) }},
  {{ UINT64_C(0xb11477b3d71d03c4), UINT64_C(0x00f3d9d796f88e1d), UINT64_C(0x369db33d07e79a59), UINT64_C(0x11ec68dd055257f2) }},
  {{ UINT64_C(0x21ce40105ba6ff0b), UINT64_C(0x6d503da81ba6beba), UINT64_C(0xca49a0673c9392ac), UINT64_C(0xd813c1cfeae2140b) }},
};

static const block_t Zi_35[] = {
  {{ UINT64_C(0x027a8434756dc940), UINT64_C(0xbb10a6d172a5b4e8), UINT64_C(0xfbd775014ca0c91c), UINT64_C(0xe468b686807c8bec) }},
  {{ UINT64_C(0x1566ac2237fea697), UINT64_C(0x8494d9711efa8fe7), UINT64_C(0x300ca12663a66cbc), UINT64_C(0x47ac63834e70a842) }},
  {{ UINT64_C(0x60dadff156f30fa8), UINT64_C(0x2840ff93bee6c2e3), UINT64_C(0x17f7b95436d9bb37), UINT64_C(0x13d88732e734d9d0) }},
  {{ UINT64_C(0x493a2daff4992539), UINT64_C(0xd66f0d0b28815bf6), UINT64_C(0x16f8ded559d4475e), UINT64_C(0x0adafef1cd07db78) }},
  {{ UINT64_C(0x1f25db5f916eccd2), UINT64_C(0xe99b4195c830f304), UINT64_C(0x652091959dd6c245), UINT64_C(0x7c842539e2d383ec) }},
  {{ UINT64_C(0x71c66ce835ec9801), UINT64_C(0x4099c241ddd58337), UINT64_C(0xbf4cd5995efc0947), UINT64_C(0x1741ca93239e4a24) }},
  {{ UINT64_C(0xb31ea8669fb081f9), UINT64_C(0xf290a5ea982e6dad), UINT64_C(0xceb1c0425174e716), UINT64_C(0x6e3e975aaf7eddc9) }},
  {{ UINT64_C(0x8c8ab53f13e71c02), UINT64_C(0x0bbc7abb4229f0c8), UINT64_C(0x627f887876b566b7), UINT64_C(0x1da9c41c007114f1) }},
  {{ UINT64_C(0x5a05457f7d737244), UINT64_C(0xee007978938caeea), UINT64_C(0xa3f4d9a5b8c2d257), UINT64_C(0x74f0236fd49305eb) }},
  {{ UINT64_C(0x3a8bcc9b38ea1930), UINT64_C(0x3634cf272a0d6afe), UINT64_C(0xdc14b406d4fc04f2), UINT64_C(0xfa713ef2362d7df5) }},
  {{ UINT64_C(0xdad35578cf61295a), UINT64_C(0xa91b90681391a296), UINT64_C(0xe17bc1f04a50be66), UINT64_C(0x7cdbce69cb892f19) }},
  {{ UINT64_C(0xff84fd1e2b648586), UINT64_C(0x89844fc7b59aff17), UINT64_C(0x5843d4858525716b), UINT64_C(0x57817c0b4ec12d9b) }},
  {{ UINT64_C(0xa5cd71b11e18b6ab), UINT64_C(0x734f09ee5a694634), UINT64_C(0x62bbe4193dfb0297), UINT64_C(0xa63d63bafaab8a0d) }},
  {{ UINT64_C(0xcd8e2baab7b23ff5), UINT64_C(0x586bc5ebdceedf1a), UINT64_C(0x90315172eeb60437), UINT64_C(0x7b5c3d8cef86ab49) }},
  {{ UINT64_C(0xce11f2c4fe54125a), UINT64_C(0xcc12b6c3de22b5d5), UINT64_C(0xd07425a17df2c8da), UINT64_C(0x608d18c89098984c) }},
  {{ UINT64_C(0x0a8c7bfb7004c22d), UINT64_C(0x11a1e7ea41c39864), UINT64_C(0xe5310d62e388684e), UINT64_C(0xa30c7638dca370af) }},
  {{ UINT64_C(0x452ce3d6edca3d2d), UINT64_C(0x8b18bbd71d392f9f), UINT64_C(0x3b48bc5330260c96), UINT64_C(0x2132ac031da791af) }},
  {{ UINT64_C(0x28a74b924c7b5be5), UINT64_C(0xb5a37dcd87487277), UINT64_C(0x86d13b206a048444), UINT64_C(0x3add4597e0a0b701) }},
  {{ UINT64_C(0x70904f351573c9e0), UINT64_C(0xbb2bf5883a36351f), UINT64_C(0x31937e3e786f8354), UINT64_C(0xfa380552b8b9fd59) }},
  {{ UINT64_C(0xe84d8677d771f4c7), UINT64_C(0xd47d56deaf6610eb), UINT64_C(0x11b38eee264232f7), UINT64_C(0x3d1f0703c951bf42) }},
  {{ UINT64_C(0x3ee7889e78407259), UINT64_C(0x7d54433bd3c6912c), UINT64_C(0x18a728fbecf4354d), UINT64_C(0x0140d8a4354eabae) }},
  {{ UINT64_C(0xbe6fb992e2a508df), UINT64_C(0x47ba6d26a3e82292), UINT64_C(0x7aeb71df7b886155), UINT64_C(0x45a72459a982b5c2) }},
  {{ UINT64_C(0x6b876761c83f9df4), UINT64_C(0x2f33abda565f17a6), UINT64_C(0xfe4e0a622e0786a9), UINT64_C(0x2062b433675195f2) }},
  {{ UINT64_C(0xcc78bbf5caca822d), UINT64_C(0x55c60659101fa90d), UINT64_C(0xc30f75ee147d24f3), UINT64_C(0x61fdcb88218c116d) }},
  {{ UINT64_C(0x168c9cea064e2bb1), UINT64_C(0x781e43f4ca6a6074), UINT64_C(0xf096619fad341f56), UINT64_C(0xa6299ca11b5d38d5) }},
  {{ UINT64_C(0x0f4aff99c1ae6ea4), UINT64_C(0x812acfbc7519ea86), UINT64_C(0x41d07c69466ff70b), UINT64_C(0x9a50b60e73283b4e) }},
  {{ UINT64_C(0xe0de2482c4948fcb), UINT64_C(0xef3dd2eb68d505b8), UINT64_C(0x21542260b9e63c7f), UINT64_C(0x4d36b55e0a889f18) }},
  {{ UINT64_C(0x80bbe54b521b3cd2), UINT64_C(0xe1b543313d14025d), UINT64_C(0xdbdb6bca0224f3a6), UINT64_C(0xde2a788672d7aadf) }},
  {{ UINT64_C(0x60e310a216eddbec), UINT64_C(0xa079983bca66c032), UINT64_C(0x57626ccf80da3281), UINT64_C(0x86938d1a74920f94) }},
  {{ UINT64_C(0xb763064f78e5e61a), UINT64_C(0xe0e44c42802b1696), UINT64_C(0xadb585d455953a11), UINT64_C(0xa77361cc2d0a6b19) }},
};

static const block_t Zi_36[] = {
  {{ UINT64_C(0xe7a66dbf6e0881b8), UINT64_C(0x86cc7c68619a874c), UINT64_C(0x958f21723ed5fa58), UINT64_C(0x1d702201d266e371) }},
  {{ UINT64_C(0xb6b531d686347a51), UINT64_C(0x002db9ee03c46b3b), UINT64_C(0x8b140758abff570c), UINT64_C(0x661a94c39dcd56d8) }},
  {{ UINT64_C(0xf4cea186beee4fa8), UINT64_C(0x5463b62832275f50), UINT64_C(0x737a1a10c9703827), UINT64_C(0x6c94c65e045b9bc6) }},
  {{ UINT64_C(0x3100d85bed7e6ba4), UINT64_C(0xf18d3d21ad633380), UINT64_C(0x82abc98ddd0ba055), UINT64_C(0x0478f8d61858a5f4) }},
  {{ UINT64_C(0xfb6199840ae202e2), UINT64_C(0x3d2c3a9ffab7fa0c), UINT64_C(0x15a68ee459ef12f9), UINT64_C(0xf968d91a048ba8e5) }},
  {{ UINT64_C(0x3188977e5926d8fe), UINT64_C(0x3ad697bec1b41b7a), UINT64_C(0xe20d0948d49d4e02), UINT64_C(0x9ce3a27578f98cc8) }},
  {{ UINT64_C(0xa1df93a74cacbc99), UINT64_C(0x0c0577bcbf73792d), UINT64_C(0xea071fd5515c7f68), UINT64_C(0x775d514f0e0b12ab) }},
  {{ UINT64_C(0x8a876f259648cc64), UINT64_C(0xd6a841d36e766ddb), UINT64_C(0xdf82ad304f7376f3), UINT64_C(0xbb7aa4a7fb049c3b) }},
  {{ UINT64_C(0x0e98ccccf60df303), UINT64_C(0x9fdff5f21f95116f), UINT64_C(0xc7d6f320a314a261), UINT64_C(0xa4cdd8f13de2b733) }},
  {{ UINT64_C(0x2eaea5d19798d7e1), UINT64_C(0xb5a4c306a9661d61), UINT64_C(0xe7960b59ea771664), UINT64_C(0x4a62901ce57a914c) }},
  {{ UINT64_C(0x2ccce3e583369154), UINT64_C(0xf8aadf7931cb2d09), UINT64_C(0x900c254eb344e3b1), UINT64_C(0xb1177895d1814022) }},
  {{ UINT64_C(0x1d6268bc3651a1eb), UINT64_C(0x13142e782bacccd9), UINT64_C(0xad55bf9b7d4e3809), UINT64_C(0x1c2561e85e660147) }},
  {{ UINT64_C(0x945afd0b85523c3d), UINT64_C(0x5389f351c0079034), UINT64_C(0x3ae74127acad28dd), UINT64_C(0x4abd068b2c1e9a28) }},
  {{ UINT64_C(0x1bebe0121b12b2f8), UINT64_C(0x1a5898db29455409), UINT64_C(0x599f0ecb8f2c46d6), UINT64_C(0x0d197da5f5ac4f8f) }},
  {{ UINT64_C(0x8ffd322876ba7e12), UINT64_C(0x9e293ef34be2a9b4), UINT64_C(0x77eeb4576ea8eb37), UINT64_C(0xa1227d2e52ef2d7d) }},
  {{ UINT64_C(0xa0ef413c391aa5fe), UINT64_C(0x9a8fcd18f57f3341), UINT64_C(0x0b0a8e1170a8ab9d), UINT64_C(0xd40d634db0e6a99b) }},
  {{ UINT64_C(0x28a529adee423059), UINT64_C(0x767201117b36eea7), UINT64_C(0x6c223715424fe6c7), UINT64_C(0x3e21d340d1f26332) }},
  {{ UINT64_C(0x0929ad316ba90e8c), UINT64_C(0x64281a1fe147acd3), UINT64_C(0x2a53c41ff05c9cac), UINT64_C(0x57ecdadc551edaba) }},
  {{ UINT64_C(0x4b50dba59fbe3803), UINT64_C(0xda316a6ae99ff4e4), UINT64_C(0xbb76ecf677731099), UINT64_C(0xf716ec66cf96d180) }},
  {{ UINT64_C(0xee060f839b1d0e4b), UINT64_C(0xc7cfc95920514d08), UINT64_C(0x2539a1c46c34e844), UINT64_C(0x44812823db5d4268) }},
  {{ UINT64_C(0x438cc48662d688d1), UINT64_C(0x73932fc44576aef6), UINT64_C(0x8a21d5ba8210d307), UINT64_C(0x1be9bc3f21639f8a) }},
  {{ UINT64_C(0xef452bd91f296216), UINT64_C(0xf57b868b4846ad52), UINT64_C(0xe2a947135ca4eb1d), UINT64_C(0x05dc866d7f637ca1) }},
  {{ UINT64_C(0xd9000e4dbdc8ea17), UINT64_C(0x550ae661890633e3), UINT64_C(0x7b38ff0a8e39dff2), UINT64_C(0xd74b7c4f5a71b7d2) }},
  {{ UINT64_C(0xe7b9fb3b8ecffe3f), UINT64_C(0x682962d490df8fb0), UINT64_C(0xf4896a21a5dc8a5b), UINT64_C(0x05d2ef76732a17c7) }},
  {{ UINT64_C(0x6d138faf927255c7), UINT64_C(0x403ad58d645a6006), UINT64_C(0x4c3b705152cbb433), UINT64_C(0x852004469e5bff0e) }},
  {{ UINT64_C(0x0d6d0216309d8d7d), UINT64_C(0x7911138c7da28e65), UINT64_C(0x8e31410e4c8aa296), UINT64_C(0xe23f8272b766e68c) }},
  {{ UINT64_C(0xf8c1af4cd8e30d1d), UINT64_C(0x588699c0bfbff4e0), UINT64_C(0x1669d26660e2f3ab), UINT64_C(0x461e4a9bb1360a1d) }},
  {{ UINT64_C(0x9cacff7672c7432f), UINT64_C(0xc20258dc7902e31b), UINT64_C(0x640c0a9d635f1109), UINT64_C(0x1107e348e8e274d3) }},
  {{ UINT64_C(0xbaa85b01db33674f), UINT64_C(0x54f3ed080492d682), UINT64_C(0xea553c1bef211ac7), UINT64_C(0xeb68d3837b28ea63) }},
  {{ UINT64_C(0x1ec4898d94821344), UINT64_C(0x59f5d383c80583a1), UINT64_C(0xdd9aa10bed251b3b), UINT64_C(0xe26339bce1d04d01) }},
};

static const block_t Ri_0[] = {
  {{ UINT64_C(0xbebed0365ee611fe), UINT64_C(0x92432aaaeeb8346a), UINT64_C(0x37ef320f7d0111eb), UINT64_C(0x000000015808dc5b) }},
  {{ UINT64_C(0xcf11cd8bb94dc2aa), UINT64_C(0x70a54b868ca58b7e), UINT64_C(0x68bd69eea8d92765), UINT64_C(0x00000000706837e7) }},
  {{ UINT64_C(0xa6a4918aab3fe5af), UINT64_C(0x2720ad5de90f7cf8), UINT64_C(0xab120e442b21b800), UINT64_C(0x000000011b025eb7) }},
  {{ UINT64_C(0xc3906f00f0cdd9bf), UINT64_C(0x9122c7c7b732a4f0), UINT64_C(0xf45cf5b55a195c14), UINT64_C(0x000000039a21b6b5) }},
  {{ UINT64_C(0x62caf8761e8af128), UINT64_C(0x3cc7bb25a985aae4), UINT64_C(0xc97d10dfd33cf1cd), UINT64_C(0x00000000bd0c15bd) }},
  {{ UINT64_C(0xbe5e88bd3b4c9ef5), UINT64_C(0xa895158f55978442), UINT64_C(0x4a82caae4d45e0c2), UINT64_C(0x00000003c0a2a6cf) }},
  {{ UINT64_C(0xe77a8eec34c1f724), UINT64_C(0xe9534fbcba1092e3), UINT64_C(0x6906a94549dba259), UINT64_C(0x00000000f1b5c7d7) }},
  {{ UINT64_C(0xec49dd797278cba7), UINT64_C(0x921b5a1672175818), UINT64_C(0x1494124f8cb857a9), UINT64_C(0x00000003c0b47900) }},
  {{ UINT64_C(0x9a9cd7c4a1c05c6b), UINT64_C(0xe47cc4cb45901773), UINT64_C(0x20d78a898f979be1), UINT64_C(0x0000000373ae04fc) }},
  {{ UINT64_C(0x978796e02d3918d5), UINT64_C(0xd27771e2aef020eb), UINT64_C(0x2ead07e309d606ec), UINT64_C(0x000000014203be04) }},
  {{ UINT64_C(0xbf51a208bcc9bcba), UINT64_C(0xa9ea6ae0ce4ed76d), UINT64_C(0xbee239659ac1ce7c), UINT64_C(0x000000027740a6fe) }},
  {{ UINT64_C(0x097d328bd33ea3cc), UINT64_C(0x03dcd68081f92d37), UINT64_C(0x095f141129105530), UINT64_C(0x000000007a69ff24) }},
  {{ UINT64_C(0x13dc4efa6ffcdf5b), UINT64_C(0xc4c80b3d6d1972d8), UINT64_C(0xd421320140c51f04), UINT64_C(0x00000001f82b8a27) }},
  {{ UINT64_C(0xd95add7fdead21ab), UINT64_C(0x092ec71a8eca3bb2), UINT64_C(0x2a56612cdf9915bb), UINT64_C(0x00000002cfac83ab) }},
  {{ UINT64_C(0x58294e6cc99b39c7), UINT64_C(0x83ec0d549dab91e5), UINT64_C(0x710ea7bef755a877), UINT64_C(0x00000002ecd5a34f) }},
  {{ UINT64_C(0x19d1996c668847e6), UINT64_C(0x72aecc7b537c90de), UINT64_C(0x6bd0bcc50c25808a), UINT64_C(0x00000001934f27f3) }},
  {{ UINT64_C(0xe3c6385052aa977f), UINT64_C(0x464ea6d4002cf239), UINT64_C(0xf5f92696cb0dcdfa), UINT64_C(0x000000025a9098b8) }},
  {{ UINT64_C(0x162929395cd6354b), UINT64_C(0x5f383c8054777493), UINT64_C(0x8f123d51f0e052d9), UINT64_C(0x0000000111408219) }},
  {{ UINT64_C(0x0292ace6cd324c17), UINT64_C(0xa833eaf0e6f188e0), UINT64_C(0x6d2664f605fd4792), UINT64_C(0x000000008e90c11f) }},
  {{ UINT64_C(0x9d6a5e6faa837fb0), UINT64_C(0x1c63c43c38e541f8), UINT64_C(0x88b6fb3b125796cd), UINT64_C(0x00000000aea35303) }},
  {{ UINT64_C(0x23fff6506690e658), UINT64_C(0x90a4a25c10d742a8), UINT64_C(0x00cd0dcb11ab6a4c), UINT64_C(0x0000000387245c3e) }},
  {{ UINT64_C(0xfb6340b186d8d5db), UINT64_C(0x56a843c2b382545e), UINT64_C(0x459e7c125d589e02), UINT64_C(0x0000000342300efc) }},
  {{ UINT64_C(0x1d62b76083abfd55), UINT64_C(0xe8fd8f49c6f48b1f), UINT64_C(0x374549f5f261d0d7), UINT64_C(0x000000008664979c) }},
  {{ UINT64_C(0x20147a65692d3083), UINT64_C(0x0dfd3459a6d09ae4), UINT64_C(0xf92fbc85c54644b2), UINT64_C(0x000000012aa0b0f1) }},
  {{ UINT64_C(0x029f853d3ccfa995), UINT64_C(0x3411a7c929ed241c), UINT64_C(0x86c4125b52cbc405), UINT64_C(0x0000000237b9d46b) }},
  {{ UINT64_C(0x412b2958ef030354), UINT64_C(0xbfcf16db196c64f2), UINT64_C(0x7369a352643d5e43), UINT64_C(0x0000000224dde4f2) }},
  {{ UINT64_C(0xbcfb82ac846248b0), UINT64_C(0xd9516aa915709eca), UINT64_C(0x5f38c2f969b8d131), UINT64_C(0x000000033db727d3) }},
  {{ UINT64_C(0xa8b957eda50104ef), UINT64_C(0x021183c084999b63), UINT64_C(0x9f232c4aaa60e132), UINT64_C(0x0000000328203831) }},
  {{ UINT64_C(0x99b9e929fec23f1e), UINT64_C(0x9c87b193072de429), UINT64_C(0x39caac57e82f81a7), UINT64_C(0x0000000109c12672) }},
  {{ UINT64_C(0x5bfe128fafffef67), UINT64_C(0x58af1e0666786a29), UINT64_C(0xd63bfdf49a003049), UINT64_C(0x000000028905ce3e) }},
};

static const block_t Ri_1[] = {
  {{ UINT64_C(0xf3ba577a171f6ca6), UINT64_C(0x5320bbde8eaf2d01), UINT64_C(0x32c34d716b5039f2), UINT64_C(0x00000000006b1605) }},
  {{ UINT64_C(0x9fbe214f6f8c65cf), UINT64_C(0xb139f611d826fbbf), UINT64_C(0x09f29ed81aef224d), UINT64_C(0x0000000131e53f41) }},
  {{ UINT64_C(0x1c52a3aa90ea2eaf), UINT64_C(0xec58c2e64dda7d75), UINT64_C(0xcdc16012e14e42da), UINT64_C(0x000000002324e45b) }},
  {{ UINT64_C(0x1a1c1b06f6c5c1aa), UINT64_C(0x1a976d7c77fb492f), UINT64_C(0x46ba98c2a2332f28), UINT64_C(0x00000001d8eda6bd) }},
  {{ UINT64_C(0x3fa8cbeb6805547b), UINT64_C(0x55a1f7ca61c4e1bf), UINT64_C(0x220af6fe450baa24), UINT64_C(0x00000000681f8a08) }},
  {{ UINT64_C(0x10337983fcd8a9f9), UINT64_C(0x7caa7b45dbeef3fe), UINT64_C(0xd9661fa1bff89c49), UINT64_C(0x00000002b23be47b) }},
  {{ UINT64_C(0x11c82bd038796e63), UINT64_C(0x3fb3e83e94e19c08), UINT64_C(0x1db8c9c84eb49684), UINT64_C(0x00000002b3fc89d7) }},
  {{ UINT64_C(0x55fade0b6f365dba), UINT64_C(0x0c512ddbe4c28d72), UINT64_C(0x231eef101b680eca), UINT64_C(0x000000006ede89b6) }},
  {{ UINT64_C(0xd363e31660bc4b03), UINT64_C(0x233825226ea484e0), UINT64_C(0x3da8f64280bd73d5), UINT64_C(0x00000000166ac4cb) }},
  {{ UINT64_C(0x93827b0f57ef5eb2), UINT64_C(0xb6b322d7a4101e3f), UINT64_C(0xb7f415241a032d4d), UINT64_C(0x00000000d48a7633) }},
  {{ UINT64_C(0x8ffa99af0a4eb5de), UINT64_C(0x2079a9637f7b9378), UINT64_C(0x514c81aeeb0db73a), UINT64_C(0x000000022fa22d10) }},
  {{ UINT64_C(0x37a24fff885aa285), UINT64_C(0xb6950f2d02a98f36), UINT64_C(0x5ba11461169efcfe), UINT64_C(0x00000002db322683) }},
  {{ UINT64_C(0x50b00aa3ac71bf6f), UINT64_C(0x423dba929c6e1d27), UINT64_C(0x9d36d10bbcd619d4), UINT64_C(0x0000000343f5f78f) }},
  {{ UINT64_C(0x0097b47e0b44888e), UINT64_C(0x5974da6404c42e1a), UINT64_C(0x0cb0a36c69d31f87), UINT64_C(0x0000000339d03033) }},
  {{ UINT64_C(0xe3b11a413147c0f3), UINT64_C(0x957266e4302b3bbc), UINT64_C(0x8d19f712bef7286a), UINT64_C(0x000000017c2ec537) }},
  {{ UINT64_C(0x93d4633f48da3ecf), UINT64_C(0xd8cd5bcb2db24a98), UINT64_C(0x1146baedb30fc81b), UINT64_C(0x0000000232d88ca8) }},
  {{ UINT64_C(0x273680f1c7d26df8), UINT64_C(0x2f535578d1adb16a), UINT64_C(0xefd5b80ec1dba5b3), UINT64_C(0x00000002a8fcb02f) }},
  {{ UINT64_C(0xb8fa1184ef510a04), UINT64_C(0x2cc8820569f9a1b3), UINT64_C(0xa4edc5672a9e9927), UINT64_C(0x00000002cc31a135) }},
  {{ UINT64_C(0x744444de577277bb), UINT64_C(0x29aebdef4a5f4143), UINT64_C(0x469ccd32715ecbd0), UINT64_C(0x00000002b159094f) }},
  {{ UINT64_C(0x98e65245d735d857), UINT64_C(0x6f00bb18d16de58d), UINT64_C(0xc8fe9a5cc943b0f8), UINT64_C(0x00000002dff80587) }},
  {{ UINT64_C(0x76bed8b8c6eb024d), UINT64_C(0x262c37a6f29b1219), UINT64_C(0xf74c4b83268d11fa), UINT64_C(0x0000000118f1f098) }},
  {{ UINT64_C(0x5a22c5c5b470c443), UINT64_C(0x9b8f97ddf6710bdb), UINT64_C(0x2ef813b5c75da47a), UINT64_C(0x0000000357015d90) }},
  {{ UINT64_C(0x4f5a071d3da847c0), UINT64_C(0xa1aac4e7dec71d63), UINT64_C(0xb0d0f844ed28ec6d), UINT64_C(0x00000001e673e5df) }},
  {{ UINT64_C(0xa04c161022e399f7), UINT64_C(0x7fa7d6ef448663be), UINT64_C(0x7f2e889c3cf8a73a), UINT64_C(0x000000039e532842) }},
  {{ UINT64_C(0x191184fc9b0ac360), UINT64_C(0x696de772fa76f974), UINT64_C(0x653dda7ebc2e7d71), UINT64_C(0x0000000361d468cd) }},
  {{ UINT64_C(0x40b410283ab2b1b5), UINT64_C(0xf82905a0db35eb3d), UINT64_C(0x098dbffcd35c8c3a), UINT64_C(0x00000001fe16478c) }},
  {{ UINT64_C(0x0634dbfe2c64c611), UINT64_C(0x751ad5d1df1288a6), UINT64_C(0x7e4d9ece7fdda18f), UINT64_C(0x00000000c94e6803) }},
  {{ UINT64_C(0xd95742b24b89fb03), UINT64_C(0x40ceb435ad518117), UINT64_C(0xcb8a41f7f6318cdb), UINT64_C(0x0000000008c0bdc7) }},
  {{ UINT64_C(0xfdece9772db2ba53), UINT64_C(0x5bede5de1158983f), UINT64_C(0xe3f9772a229dd72d), UINT64_C(0x0000000280594475) }},
  {{ UINT64_C(0xfd6f90a6fd4deb37), UINT64_C(0xbc90630ff3088b97), UINT64_C(0x3b14b298a9073935), UINT64_C(0x000000038c345efa) }},
};

static const block_t Ri_2[] = {
  {{ UINT64_C(0xa2221d35619626af), UINT64_C(0xc7a7e2acae210e30), UINT64_C(0xef671d49af7dc63e), UINT64_C(0x000000006b23c6a1) }},
  {{ UINT64_C(0x05b0b8d4e48c803f), UINT64_C(0x824006fb06b8309f), UINT64_C(0x30fddd648c1d4af0), UINT64_C(0x000000000d550989) }},
  {{ UINT64_C(0xdf6df3844f3e12de), UINT64_C(0xa3900d2877797424), UINT64_C(0x99dcbf6b10d96c60), UINT64_C(0x00000000239ac646) }},
  {{ UINT64_C(0x3278b8eb692b62c3), UINT64_C(0xb73ee784864bea81), UINT64_C(0xb563231a3cac7454), UINT64_C(0x0000000156a6d1ee) }},
  {{ UINT64_C(0xd7c2316efae13e58), UINT64_C(0xde4425ac840ef8e1), UINT64_C(0xd1454499003db576), UINT64_C(0x00000002e7556893) }},
  {{ UINT64_C(0x22a300fec053a212), UINT64_C(0x318145c36b7df815), UINT64_C(0xc55c004278c5e693), UINT64_C(0x00000003b159c646) }},
  {{ UINT64_C(0x7bde6d70ee7099f5), UINT64_C(0xf432100126cf7cb0), UINT64_C(0xc20f82351167b20a), UINT64_C(0x00000003ac6a78e9) }},
  {{ UINT64_C(0xa8dd3a830607a324), UINT64_C(0xa292cde52ff38d7e), UINT64_C(0x290a5b05c4d2759d), UINT64_C(0x00000000dad68fc0) }},
  {{ UINT64_C(0x9ec177b6566eadcd), UINT64_C(0x4e89408f579e678e), UINT64_C(0xea0f65990cfea740), UINT64_C(0x0000000052a9493d) }},
  {{ UINT64_C(0x5fc1182117fb83ad), UINT64_C(0x57355ad6c0f56c56), UINT64_C(0x723ea88c247bbb5c), UINT64_C(0x0000000112c2f1d9) }},
  {{ UINT64_C(0xb9f5921bca41c2cf), UINT64_C(0x2faa43625a076027), UINT64_C(0xaf6f74028a3bfd3a), UINT64_C(0x000000011858bed7) }},
  {{ UINT64_C(0x3adea7c0c48e951c), UINT64_C(0xbb69f276aff7209a), UINT64_C(0x8d4a073a4927bb71), UINT64_C(0x000000008313aa75) }},
  {{ UINT64_C(0x60997c45dcbafb17), UINT64_C(0xa83180b4bd78458c), UINT64_C(0x43a8e96981f58cdd), UINT64_C(0x00000000c35a2a2b) }},
  {{ UINT64_C(0xd284981d783e4ae7), UINT64_C(0x470aea08b4298338), UINT64_C(0x2036617a21ffcdb0), UINT64_C(0x00000001411f86b9) }},
  {{ UINT64_C(0x92e6a577c6e44dc0), UINT64_C(0x2dd55c97db83b0a2), UINT64_C(0x63b53f57740b3859), UINT64_C(0x000000032822c3e2) }},
  {{ UINT64_C(0xf49be3cfe896a6fe), UINT64_C(0xa94a5e37bb6d70c4), UINT64_C(0x94fbf71eaa10e107), UINT64_C(0x000000021551e44d) }},
  {{ UINT64_C(0x8e4d42e3a31fd802), UINT64_C(0x73d283ba385bf959), UINT64_C(0xe5851a96da0bfab0), UINT64_C(0x00000002c97bddb5) }},
  {{ UINT64_C(0x624829116d39aab2), UINT64_C(0x62c7a40f9c73761a), UINT64_C(0x57a57e20c3dd6997), UINT64_C(0x000000020191a7ff) }},
  {{ UINT64_C(0xd7ff92c1f6c16fa6), UINT64_C(0xa4f454b2418a9f76), UINT64_C(0xadb1de0a3a5b03b0), UINT64_C(0x000000024142036a) }},
  {{ UINT64_C(0x83c5bb4ec6aeb644), UINT64_C(0xc148eebda2268b31), UINT64_C(0xe24c307b888056b5), UINT64_C(0x00000001531df4ff) }},
  {{ UINT64_C(0x5c864afbbce40bc8), UINT64_C(0x2e8afc192eeb95b9), UINT64_C(0x8b3f3388dffb1657), UINT64_C(0x00000000d0a2884a) }},
  {{ UINT64_C(0xb052731ec758cb26), UINT64_C(0xa526e3ca6ac55db6), UINT64_C(0xc5164cb341c49801), UINT64_C(0x000000022aa722eb) }},
  {{ UINT64_C(0xd3b5bc0465ed19f0), UINT64_C(0xc6f84dc7424dfbe3), UINT64_C(0xf0934bf54011df0c), UINT64_C(0x00000001c9709160) }},
  {{ UINT64_C(0x4eee59401be5bd55), UINT64_C(0x2c2c46acf5605e5c), UINT64_C(0x82d61481357b20ba), UINT64_C(0x00000000e489afe3) }},
  {{ UINT64_C(0xc58a548e43039f9b), UINT64_C(0xb64d5c17e48103f0), UINT64_C(0xcaafd349d0a3a843), UINT64_C(0x00000001ae8bf547) }},
  {{ UINT64_C(0x5707fa4c1ce316a2), UINT64_C(0x6b4744c3c5e64ced), UINT64_C(0x917c66542eafecb8), UINT64_C(0x0000000334d22923) }},
  {{ UINT64_C(0xc5101c2007924916), UINT64_C(0xf03c8fbdb63ae7c5), UINT64_C(0xef67b85c3342009a), UINT64_C(0x000000004af05967) }},
  {{ UINT64_C(0xbaad230782397c65), UINT64_C(0x38818a5e07c583c4), UINT64_C(0x3b00dd5dfb0f6130), UINT64_C(0x000000005e24a1b5) }},
  {{ UINT64_C(0x2c85a7bceab3168d), UINT64_C(0xb2964bc5b42bd1b1), UINT64_C(0xa8ba0d503837d75d), UINT64_C(0x000000016c06492f) }},
  {{ UINT64_C(0x1fe9d150423a8575), UINT64_C(0xb4ebb0914d17e5e0), UINT64_C(0x946f8db7b44416bd), UINT64_C(0x000000007dbdd263) }},
};

static const block_t Ri_3[] = {
  {{ UINT64_C(0x60367e046399a400), UINT64_C(0xa2ea412d0d4ddd77), UINT64_C(0x20a784787d413e5c), UINT64_C(0x00000001c09090df) }},
  {{ UINT64_C(0xeb454c39e58c5e3c), UINT64_C(0xd6934c89b3a3cd41), UINT64_C(0xff652e427ab12869), UINT64_C(0x0000000051e0199d) }},
  {{ UINT64_C(0xe03757bb08f5bbe5), UINT64_C(0x3ddfc6aa6363b12e), UINT64_C(0xc600eb20bfd9cc89), UINT64_C(0x0000000057281a5c) }},
  {{ UINT64_C(0x85ec2282a456b74c), UINT64_C(0x4debeb14ab9322da), UINT64_C(0xe76451d8c7bf6b37), UINT64_C(0x00000001fffb2ca8) }},
  {{ UINT64_C(0x7098baa1084511b7), UINT64_C(0xbc9dd5cab2ac7157), UINT64_C(0x7d4171e7dfd96634), UINT64_C(0x000000008dfde570) }},
  {{ UINT64_C(0x360ef6efae62b0cd), UINT64_C(0xf97cc847cf58f0f5), UINT64_C(0x2714763bba9d4d5f), UINT64_C(0x000000012c3a4c29) }},
  {{ UINT64_C(0x787f79a3101d5e80), UINT64_C(0xfef340100b4110fd), UINT64_C(0xab209af1b412266c), UINT64_C(0x000000036bc3ecda) }},
  {{ UINT64_C(0x6d79afb70f1ffe44), UINT64_C(0x06a859f3f36cd681), UINT64_C(0x95f051204ccf6e31), UINT64_C(0x00000001f19dd663) }},
  {{ UINT64_C(0x47f03a2dc0776336), UINT64_C(0x4ef84e4d9475a7e7), UINT64_C(0xb67f1b612718a36b), UINT64_C(0x00000000152147b1) }},
  {{ UINT64_C(0x7da4ed3fddd59039), UINT64_C(0x3fcdaa1cb0517265), UINT64_C(0xeebef4918cbfa3c8), UINT64_C(0x00000003bf27ea93) }},
  {{ UINT64_C(0x64772369135182b3), UINT64_C(0x14364411e26a08db), UINT64_C(0x90a73d7b040cfc1f), UINT64_C(0x000000021b0ea765) }},
  {{ UINT64_C(0x466add29ab1369d5), UINT64_C(0x96d4de8f1fe46775), UINT64_C(0xcc83a3ca8a27f073), UINT64_C(0x000000016ea4fdae) }},
  {{ UINT64_C(0x19ea2e11c3eab7ec), UINT64_C(0x5d0b713a01cf51e0), UINT64_C(0x7170cdbaee3c92ab), UINT64_C(0x00000003ec877297) }},
  {{ UINT64_C(0xeb5c335831d93209), UINT64_C(0x22a1ae129805aa93), UINT64_C(0x23326ebee98f6eaa), UINT64_C(0x00000001bb41fd6e) }},
  {{ UINT64_C(0xe0da64c6dac2674b), UINT64_C(0x13f553d0e4aea70a), UINT64_C(0xed15ca082fb6085f), UINT64_C(0x00000000adfb57b6) }},
  {{ UINT64_C(0x770e769e74cf5be5), UINT64_C(0x2b0408dce8af224f), UINT64_C(0xf2b1d69c9bd5cdaa), UINT64_C(0x00000001ca6cf315) }},
  {{ UINT64_C(0x406588111b1c0344), UINT64_C(0xbba84d172c78c105), UINT64_C(0x0d54e6f1b3f4c748), UINT64_C(0x00000003bcec163a) }},
  {{ UINT64_C(0xd499485ce9934e65), UINT64_C(0xb9dd70118d7fee55), UINT64_C(0xcf3f57819126f8bb), UINT64_C(0x00000000ef1e76dd) }},
  {{ UINT64_C(0xd61f8256deee634d), UINT64_C(0x3e1a25299ffce55f), UINT64_C(0x7dfac8e992a25757), UINT64_C(0x000000007bad08af) }},
  {{ UINT64_C(0x02f943725bbfbf5d), UINT64_C(0xf57e7eb7cdcd3127), UINT64_C(0xd5d39fb5390ebf1b), UINT64_C(0x0000000244f3315d) }},
  {{ UINT64_C(0x374c6d5360b3ef06), UINT64_C(0x69cebba1553e62dd), UINT64_C(0xb2432d1bc5ba60ae), UINT64_C(0x00000001940bf93c) }},
  {{ UINT64_C(0xab420b5c0de4e000), UINT64_C(0x0489c9e59912070b), UINT64_C(0x06bf6058542939e0), UINT64_C(0x000000019d3022fe) }},
  {{ UINT64_C(0x7e1c94e86a934037), UINT64_C(0x6c58b94c5a40b307), UINT64_C(0xb45a8b8a0497af9e), UINT64_C(0x0000000084e19496) }},
  {{ UINT64_C(0x6e96eb62a2c0850f), UINT64_C(0x438556f953543cdb), UINT64_C(0xf90703c5a5fe7ffc), UINT64_C(0x00000001bde26ff1) }},
  {{ UINT64_C(0x51b8342a26c22ad8), UINT64_C(0x4c1fac9bf1ba3afc), UINT64_C(0x24732c69f974dcda), UINT64_C(0x000000006987238d) }},
  {{ UINT64_C(0xdcefbf478cad0c4c), UINT64_C(0x8f90f94ff6faa6d6), UINT64_C(0xdcbc7710720fc056), UINT64_C(0x00000001b24e1730) }},
  {{ UINT64_C(0x48566ce1cbf69675), UINT64_C(0x1e8a297f54da7f02), UINT64_C(0xb36d3ff43e2217e5), UINT64_C(0x00000003b0b8d9d2) }},
  {{ UINT64_C(0x69492eabdd27e6d3), UINT64_C(0xffdd9a68e4a7eaef), UINT64_C(0x7e0223be1c4932f0), UINT64_C(0x00000003e9bf6fc4) }},
  {{ UINT64_C(0x5e6ab44512a10c1c), UINT64_C(0x6d4f95f9cf53f896), UINT64_C(0x3867da79018d9036), UINT64_C(0x0000000204522796) }},
  {{ UINT64_C(0x6af082f1ad074678), UINT64_C(0x1c7fa68e3c7b35dd), UINT64_C(0x9b709ff65d6e55df), UINT64_C(0x0000000169b63aca) }},
};

static const block_t Ri_4[] = {
  {{ UINT64_C(0x48bfd93b5534df70), UINT64_C(0x2da4b2d45e72332d), UINT64_C(0x83b14e12a004463b), UINT64_C(0x000000032588454b) }},
  {{ UINT64_C(0x10dca2cd0e88d87d), UINT64_C(0x9b498a7dac1d5375), UINT64_C(0x1ef75a22e0387448), UINT64_C(0x000000037a521dfe) }},
  {{ UINT64_C(0x9035ec9751909ce0), UINT64_C(0xd5287086671771d9), UINT64_C(0x8e2109f4500b0fbb), UINT64_C(0x00000000e3bef5e1) }},
  {{ UINT64_C(0x40d6d4dbe8c6227a), UINT64_C(0xbba0bb302a8b5690), UINT64_C(0x8cb0e41020492359), UINT64_C(0x00000000a0c2939e) }},
  {{ UINT64_C(0x67e33563e66ade6f), UINT64_C(0x64828a30bd395e97), UINT64_C(0x56ae08285d55223f), UINT64_C(0x00000000cd9f4f8d) }},
  {{ UINT64_C(0xd6df88f230647644), UINT64_C(0x884cad2e9e474143), UINT64_C(0xe09122527ab82127), UINT64_C(0x00000001b24e01c0) }},
  {{ UINT64_C(0xfeb67cfc70e0b6e1), UINT64_C(0xedf30e7d60bd1bae), UINT64_C(0xe9f41da6e4932797), UINT64_C(0x0000000219e01f99) }},
  {{ UINT64_C(0x068a1cabc84fcf90), UINT64_C(0x19b6cd1c698ff64d), UINT64_C(0xfaec12a8dad8989c), UINT64_C(0x0000000162c338ef) }},
  {{ UINT64_C(0x2302040b8b373e18), UINT64_C(0x2ab4e929ad8db549), UINT64_C(0x0405c6e9800894a3), UINT64_C(0x000000005ab945b3) }},
  {{ UINT64_C(0x24ea41737e04fe34), UINT64_C(0x84ffbb374471f9df), UINT64_C(0x7cb13fff177174ef), UINT64_C(0x000000038eb5d099) }},
  {{ UINT64_C(0xbb1692842c779aa1), UINT64_C(0x3d047fbee3420379), UINT64_C(0x5b0832c94abee29d), UINT64_C(0x00000000a82c1b1f) }},
  {{ UINT64_C(0x16555d1795a157db), UINT64_C(0x0269a701ffdb8be6), UINT64_C(0xf0578378b16b1990), UINT64_C(0x00000000109094d3) }},
  {{ UINT64_C(0x259b43a9f22ad389), UINT64_C(0x42c2bd6447384200), UINT64_C(0xdb4ceda845538e56), UINT64_C(0x000000019825ae91) }},
  {{ UINT64_C(0xca086c08a37f8cc9), UINT64_C(0xc2aa52501164a1ad), UINT64_C(0xf53cc270c11613b1), UINT64_C(0x0000000296872094) }},
  {{ UINT64_C(0x28ee0392c5cf976b), UINT64_C(0x64a777c3908b7b02), UINT64_C(0xae5e9ca56e771215), UINT64_C(0x0000000373a91485) }},
  {{ UINT64_C(0x9cae6b5392541c30), UINT64_C(0xe42f882bffecf469), UINT64_C(0xad87872a0928de16), UINT64_C(0x000000029d3de8c3) }},
  {{ UINT64_C(0x8d4d9a4666086039), UINT64_C(0x4fd5d791154e3495), UINT64_C(0x394c869cdd7d4e83), UINT64_C(0x00000002596f2722) }},
  {{ UINT64_C(0x63a3dad378fc0729), UINT64_C(0xbddee7a83cc9beb1), UINT64_C(0x537d22bdecc18ad2), UINT64_C(0x00000003b9ba431f) }},
  {{ UINT64_C(0xdb8a18cc30657ea2), UINT64_C(0xeaed0bec5ee7ac30), UINT64_C(0xc69bfbb8e3abceaa), UINT64_C(0x00000001fc568f9b) }},
  {{ UINT64_C(0x8fbf14685361e320), UINT64_C(0x92c3784353a305ca), UINT64_C(0x897743b4db24cf78), UINT64_C(0x00000003381cb87d) }},
  {{ UINT64_C(0xaad67412b8967900), UINT64_C(0xd90e157f184a9850), UINT64_C(0xc9e8e20fee71040e), UINT64_C(0x00000003f313c264) }},
  {{ UINT64_C(0x9c1f21a45401b979), UINT64_C(0x0bb1169987a87829), UINT64_C(0x3d150a0e0982cc85), UINT64_C(0x000000024ca4fbac) }},
  {{ UINT64_C(0x076b3d91a67688c2), UINT64_C(0xec0959b697975f11), UINT64_C(0xf2894ac4b757bad7), UINT64_C(0x00000000f8eedf1b) }},
  {{ UINT64_C(0x8fc08445a774b174), UINT64_C(0x85041954d280ca67), UINT64_C(0x69b8a3823f9bec29), UINT64_C(0x00000002d7f2d07a) }},
  {{ UINT64_C(0x741410696af4a804), UINT64_C(0xc95c1c3b318ef77d), UINT64_C(0xc1607afd10c007db), UINT64_C(0x0000000068d8e8c3) }},
  {{ UINT64_C(0xd6c8b10cbcfbf11e), UINT64_C(0x5031e9b2d1b6003f), UINT64_C(0x73385055e2475ce6), UINT64_C(0x00000002fc966a43) }},
  {{ UINT64_C(0x87e3aa793e372cc1), UINT64_C(0x04170ac2252f023a), UINT64_C(0x5d2a88acb4625878), UINT64_C(0x00000002bcdbfb7f) }},
  {{ UINT64_C(0xb34e78308f9e0031), UINT64_C(0x3312f2b4982ad081), UINT64_C(0x8c52e0949f7708bf), UINT64_C(0x000000024182ad8c) }},
  {{ UINT64_C(0x544c0f1e2b421481), UINT64_C(0x46bb331053494454), UINT64_C(0xd95c09302d5c99e4), UINT64_C(0x000000021ba02e71) }},
  {{ UINT64_C(0x5bbd7774af0d9ef2), UINT64_C(0x34b6a48b5c2cc44c), UINT64_C(0x1ba42d6062f41a35), UINT64_C(0x000000037b162e1c) }},
};

static const block_t Ri_5[] = {
  {{ UINT64_C(0x8afab08ba088baf4), UINT64_C(0xea0076b189e593e8), UINT64_C(0xaae2ed06d3d8b25c), UINT64_C(0x00000000471e6ce4) }},
  {{ UINT64_C(0x1a3abc92fd947f5c), UINT64_C(0x7e2344ac42182aea), UINT64_C(0x4c51d61d5bfc50b3), UINT64_C(0x000000006e84c2b7) }},
  {{ UINT64_C(0x469d5e06d6382703), UINT64_C(0x0da40d5aa27449e5), UINT64_C(0x30ec23cdc2964edd), UINT64_C(0x000000010add7427) }},
  {{ UINT64_C(0x47d84100b0205449), UINT64_C(0x55ba5d0c00dda6ad), UINT64_C(0x8607961e7282997d), UINT64_C(0x000000017a95bed2) }},
  {{ UINT64_C(0xdf82a4a766e6ad96), UINT64_C(0xc95e4b12d28e06ad), UINT64_C(0xdc55f6d202470e4d), UINT64_C(0x0000000230341d1a) }},
  {{ UINT64_C(0x4e679a4c601da261), UINT64_C(0x9527cddde500015e), UINT64_C(0x7e1a652856b7106d), UINT64_C(0x00000003f00abaa1) }},
  {{ UINT64_C(0x462eead6a3f8b422), UINT64_C(0x58fd7afe91b28189), UINT64_C(0x4107dbbca4164baa), UINT64_C(0x00000002e8b00cf5) }},
  {{ UINT64_C(0xa838e062bd801a56), UINT64_C(0x13d41c178ce0a7c2), UINT64_C(0xe7c2759ead66fbf3), UINT64_C(0x00000000d27b08d3) }},
  {{ UINT64_C(0xea80dcc738e5a58b), UINT64_C(0x03130561023b8d36), UINT64_C(0x73d87d4a794c38e0), UINT64_C(0x00000003e58711c2) }},
  {{ UINT64_C(0x76d0892f93d7d247), UINT64_C(0xed4e5c080d39ed94), UINT64_C(0xf7ce212f821e5901), UINT64_C(0x000000020f22e29e) }},
  {{ UINT64_C(0xe5f608de6c3babcb), UINT64_C(0x2650b4071f25a660), UINT64_C(0x120d779cea00357e), UINT64_C(0x0000000261242cb0) }},
  {{ UINT64_C(0xefd1c5c3e76b35bb), UINT64_C(0xeea42600eb010450), UINT64_C(0x81ad16277836b6c1), UINT64_C(0x00000000855a8abe) }},
  {{ UINT64_C(0x3649da9d853ba0ac), UINT64_C(0xd278e96e5cdff0f6), UINT64_C(0x3d6f69141a469d59), UINT64_C(0x000000016c2f6208) }},
  {{ UINT64_C(0xf6854fd186d6bdec), UINT64_C(0xc29f07b5a1da43b8), UINT64_C(0x771985f0f4a5bb06), UINT64_C(0x00000001f48ec952) }},
  {{ UINT64_C(0x742017cacbbec203), UINT64_C(0x1b047da51de08897), UINT64_C(0xb7e6029f6df2d405), UINT64_C(0x00000002532c5419) }},
  {{ UINT64_C(0x8ce516597bcd9f34), UINT64_C(0xcbd469ded34e8e77), UINT64_C(0x5c7d459152997374), UINT64_C(0x00000003209ef95e) }},
  {{ UINT64_C(0xb59c408b9cd19ee9), UINT64_C(0xbfd6e2b92a0d3b32), UINT64_C(0x4b3284744c80af46), UINT64_C(0x00000001a8cd7bd9) }},
  {{ UINT64_C(0x35f4d19d7e533dcc), UINT64_C(0xceb6e04a40cade4e), UINT64_C(0xb4b2c0dea72912fd), UINT64_C(0x00000001d8d2fcc8) }},
  {{ UINT64_C(0x9802bb4eb53d0307), UINT64_C(0x4544e82e9bbb4938), UINT64_C(0x3fc35e145d7f5d1f), UINT64_C(0x000000037c36dd4d) }},
  {{ UINT64_C(0x073937068a89684c), UINT64_C(0x72428743ab66a5c4), UINT64_C(0x197f05a4e53f050e), UINT64_C(0x00000002cbc89d73) }},
  {{ UINT64_C(0x943c3722f92c76ea), UINT64_C(0x3c404c711bd2a93c), UINT64_C(0x90e02e5baa788c6b), UINT64_C(0x000000025844be18) }},
  {{ UINT64_C(0xfd9fb66c7303a697), UINT64_C(0x9d18558721e8ad6b), UINT64_C(0xbb6944d0ab523f67), UINT64_C(0x00000000f4417ed5) }},
  {{ UINT64_C(0x981c8f139458ff06), UINT64_C(0x404d4d9537f054e6), UINT64_C(0x4165f047fca6fda1), UINT64_C(0x00000001ea5d6fbe) }},
  {{ UINT64_C(0x4f2013e47150d832), UINT64_C(0xc6be252f31513d16), UINT64_C(0x2e91abafd54b39a9), UINT64_C(0x00000002fb1816ae) }},
  {{ UINT64_C(0x56a9204293120e33), UINT64_C(0xd29dc4e77cd48839), UINT64_C(0x7623a2bac0b32163), UINT64_C(0x00000002f6b28834) }},
  {{ UINT64_C(0xf40c86ddb7b6681a), UINT64_C(0xe38292ca5a443499), UINT64_C(0xc8120c32b9dfebaa), UINT64_C(0x00000002ce445e4e) }},
  {{ UINT64_C(0x7c7d16f8fe02b18d), UINT64_C(0x98363ad15840983d), UINT64_C(0x3c4bde7f5321f93f), UINT64_C(0x0000000226b9e4f8) }},
  {{ UINT64_C(0x4d6ae38d37c5d180), UINT64_C(0x7d8d6321bed64a0e), UINT64_C(0xe5ca2dfe330e16fb), UINT64_C(0x0000000164e63176) }},
  {{ UINT64_C(0x3eb010a57292cc23), UINT64_C(0x041d517d7cf9fb46), UINT64_C(0x3fe116608ad8cb3d), UINT64_C(0x00000000c2935c58) }},
  {{ UINT64_C(0x8d6213ac1369a1f5), UINT64_C(0xd9658826d9b8fdff), UINT64_C(0x3e26ffdf373596ac), UINT64_C(0x00000003caf69c4b) }},
};

static const block_t Ri_6[] = {
  {{ UINT64_C(0x36bfeefbc375cf43), UINT64_C(0xc93ec8d455c0af68), UINT64_C(0xf6775243835efd12), UINT64_C(0x00000000047ff33b) }},
  {{ UINT64_C(0x3730fcfce7098c86), UINT64_C(0xd9ebe238d38b1945), UINT64_C(0xe8b426afcd94a624), UINT64_C(0x000000017700813c) }},
  {{ UINT64_C(0xe95c8c6e18ded097), UINT64_C(0x60fec1e955368c9b), UINT64_C(0x4dbce1170190c793), UINT64_C(0x00000002a2992536) }},
  {{ UINT64_C(0x7672f05b0d3d77b8), UINT64_C(0xe8118395404f964e), UINT64_C(0x95c904e7480ce8c1), UINT64_C(0x000000009b60476c) }},
  {{ UINT64_C(0x4f2e46ac287e8aed), UINT64_C(0xb4d2c7e4f2400d1a), UINT64_C(0x5eb89fef093e9c91), UINT64_C(0x0000000111836fd4) }},
  {{ UINT64_C(0xce97d2ac8a4741e2), UINT64_C(0xd1770b5c75fd6168), UINT64_C(0x22a6741a09b0baff), UINT64_C(0x00000003bb4404f7) }},
  {{ UINT64_C(0x4069290106ec7f8f), UINT64_C(0x3116eea32ed6e111), UINT64_C(0x510aee32bd6ec869), UINT64_C(0x000000024549f86c) }},
  {{ UINT64_C(0x68d22f1f6992b539), UINT64_C(0xea45657bdcba1896), UINT64_C(0x6a6cf3e77a39511a), UINT64_C(0x0000000300879268) }},
  {{ UINT64_C(0x85d8fe57713c7bf3), UINT64_C(0xbf0515aed57b8ddb), UINT64_C(0x08e264cf2b35dad9), UINT64_C(0x0000000330828fd2) }},
  {{ UINT64_C(0x0c34af43f1a6183b), UINT64_C(0x5f069fb9334660a0), UINT64_C(0xd5b7645f40464f4c), UINT64_C(0x00000003e3f14d28) }},
  {{ UINT64_C(0x71022f60c9d48310), UINT64_C(0x7b5c2e89b4337645), UINT64_C(0x60b0e5b114b05263), UINT64_C(0x0000000133bb4428) }},
  {{ UINT64_C(0xe309bf4be4a10c5c), UINT64_C(0xc45f0a529dbe995a), UINT64_C(0xd706a73f5faf4491), UINT64_C(0x00000003f467d3c2) }},
  {{ UINT64_C(0xb60b123353c0b50d), UINT64_C(0x0a9771c801f95e31), UINT64_C(0xe0d4e0c31be9d1c5), UINT64_C(0x00000000e5941a4e) }},
  {{ UINT64_C(0x2370da4a70ff4a8b), UINT64_C(0x6b9f8635fa266c9e), UINT64_C(0x6f1768b82863ee82), UINT64_C(0x00000003ead28205) }},
  {{ UINT64_C(0x6ea1e7489bfadd63), UINT64_C(0x3d2c0b6aa3c63d26), UINT64_C(0xd1d29cccea770b8c), UINT64_C(0x00000000d1d81e45) }},
  {{ UINT64_C(0x3d80b89e7426aef8), UINT64_C(0x8b9aaecccb66c54c), UINT64_C(0xf14f8021223ce2fc), UINT64_C(0x00000003e6c02694) }},
  {{ UINT64_C(0x5486fac49fe13597), UINT64_C(0xb331b981efc19400), UINT64_C(0x51971f605d5c77fa), UINT64_C(0x0000000264c70d0a) }},
  {{ UINT64_C(0x2ac92a7ac597a7a6), UINT64_C(0xdab4dcdf9be0db73), UINT64_C(0xee520f297a879953), UINT64_C(0x00000003df0f38dd) }},
  {{ UINT64_C(0x7ab99de55be53621), UINT64_C(0xb0984242937ee9cc), UINT64_C(0xdc866997f7127704), UINT64_C(0x000000019788bf20) }},
  {{ UINT64_C(0x4db89a189d5e04aa), UINT64_C(0xa9b7578beb569a41), UINT64_C(0x93f3a1464488722c), UINT64_C(0x000000029db1b77a) }},
  {{ UINT64_C(0xd7010bc613c53e19), UINT64_C(0xe055ab5ee52e4163), UINT64_C(0x63835084167d2def), UINT64_C(0x000000016b8a4a92) }},
  {{ UINT64_C(0x7140f5bba90b24ae), UINT64_C(0xbcdf04d9cc786e4d), UINT64_C(0x8af92afafaa05f56), UINT64_C(0x000000013fffe198) }},
  {{ UINT64_C(0x246c2a3945e58cf2), UINT64_C(0xeca1eab391473fa7), UINT64_C(0x1643be1a5b02a0a0), UINT64_C(0x0000000086d7767b) }},
  {{ UINT64_C(0x8d3bca8f00cb8912), UINT64_C(0xa6a8cd8ebd251c14), UINT64_C(0xd6183e252bbd8981), UINT64_C(0x000000018ddaf9d1) }},
  {{ UINT64_C(0x8e0c36cac4866221), UINT64_C(0xc4cb639442315162), UINT64_C(0x8c5de7aa4a396e9b), UINT64_C(0x00000000e5ccf2fa) }},
  {{ UINT64_C(0x93ef624cdac839bd), UINT64_C(0xc19db802362641c0), UINT64_C(0xced147bbc6b43321), UINT64_C(0x0000000077a046a7) }},
  {{ UINT64_C(0x548c04eac93e78b8), UINT64_C(0x29f196e6719918db), UINT64_C(0x5782585b7a84b388), UINT64_C(0x0000000376014354) }},
  {{ UINT64_C(0xceffcd32f0e50dba), UINT64_C(0x63ba965e75003641), UINT64_C(0x5eb6c3167211dbe1), UINT64_C(0x000000002914da38) }},
  {{ UINT64_C(0x28cc4c169902bc0f), UINT64_C(0xdec0c426b3917a30), UINT64_C(0xd2cd9fd0daea549f), UINT64_C(0x00000000a0c91366) }},
  {{ UINT64_C(0x7df8ac060b85c27f), UINT64_C(0xf952746e65f89116), UINT64_C(0x1c54b529aa45926d), UINT64_C(0x000000006af432c5) }},
};

static const block_t Ri_7[] = {
  {{ UINT64_C(0x2a57e580d6c4a217), UINT64_C(0x01f7752c590691b4), UINT64_C(0x2f2a5eceb13a2e4b), UINT64_C(0x0000000113654cc2) }},
  {{ UINT64_C(0x163de298ddf5e626), UINT64_C(0x7d1495a2aab9d633), UINT64_C(0xf4b4b8f788ab80aa), UINT64_C(0x00000002f1d4791c) }},
  {{ UINT64_C(0xd0b096cddc63d647), UINT64_C(0x144e3db3a33817a9), UINT64_C(0x98e278d0889d68e3), UINT64_C(0x000000027c797a06) }},
  {{ UINT64_C(0x7192b738e6c9604a), UINT64_C(0xc948393d4053fa21), UINT64_C(0xb3c988e175adf87f), UINT64_C(0x000000025b5c4fef) }},
  {{ UINT64_C(0x5bf71a2c42715a72), UINT64_C(0xcb39344e219cda61), UINT64_C(0xf1b8f84e9c6d6cc2), UINT64_C(0x000000021485831d) }},
  {{ UINT64_C(0x31130c903148bdc2), UINT64_C(0x0e263cd8458aec41), UINT64_C(0xbc2b5db8402e18b8), UINT64_C(0x000000015b261254) }},
  {{ UINT64_C(0x3573339d3f9e8892), UINT64_C(0x381d8a5f17880bde), UINT64_C(0x6e4c6ba217e6344d), UINT64_C(0x000000024b30fdf4) }},
  {{ UINT64_C(0xa3e91cccdefd3232), UINT64_C(0x10f56515c78f8ccc), UINT64_C(0x6080813ccea09c4a), UINT64_C(0x00000003d4f5a701) }},
  {{ UINT64_C(0xe11044d21c730f29), UINT64_C(0x8ed5ce1e5113c51d), UINT64_C(0x3fc8dc3745df8916), UINT64_C(0x00000002a4e1fcc4) }},
  {{ UINT64_C(0x791026e525cf4ef9), UINT64_C(0xc3ae726dffb82249), UINT64_C(0xcc6d1349c3503057), UINT64_C(0x000000027bb08d4c) }},
  {{ UINT64_C(0xb91a20ee0337aac1), UINT64_C(0x0857da890de8c5ea), UINT64_C(0x9143cd9e4fb9aade), UINT64_C(0x00000002ee3c7d4f) }},
  {{ UINT64_C(0xe1385d85015def8c), UINT64_C(0x49b9c07dac578941), UINT64_C(0x34d00f26f818a1e6), UINT64_C(0x00000000d1a2ac2d) }},
  {{ UINT64_C(0xd209cec74da536d4), UINT64_C(0x9faf75785d2f5263), UINT64_C(0x91dae20eb9d6f69c), UINT64_C(0x000000037c4d8386) }},
  {{ UINT64_C(0xf18e070f4c567c50), UINT64_C(0x72244d96bada77ec), UINT64_C(0x8e4e670f9f38cc53), UINT64_C(0x00000000881ea68c) }},
  {{ UINT64_C(0x65ea72e8a8bcd630), UINT64_C(0xa0b894d256df703c), UINT64_C(0x8d3077a95be2c867), UINT64_C(0x000000026ef381ac) }},
  {{ UINT64_C(0xf1a5ec836cf75f0a), UINT64_C(0x0d9fa2fe120be88d), UINT64_C(0x877282832307bfde), UINT64_C(0x00000002c95d4210) }},
  {{ UINT64_C(0x747a34d81e383549), UINT64_C(0x5811767ed3ded441), UINT64_C(0x34da08e82551fa1e), UINT64_C(0x0000000102c859fb) }},
  {{ UINT64_C(0xec5492407e0cf931), UINT64_C(0x306106e5c40ddc91), UINT64_C(0x8bac6f7f288065d8), UINT64_C(0x00000000caaac71c) }},
  {{ UINT64_C(0x7f94f199ba5a998e), UINT64_C(0xd46508690eaf383b), UINT64_C(0x2bb0495b6bf079e1), UINT64_C(0x00000000ce1fbc1a) }},
  {{ UINT64_C(0xeb231eed0ee44644), UINT64_C(0x337d8e25e301fb0a), UINT64_C(0x4b91142030ba6d9e), UINT64_C(0x00000002e88fc4da) }},
  {{ UINT64_C(0x85826e07a0b13beb), UINT64_C(0x793c6652c37a8f47), UINT64_C(0x83f665b0d70387c9), UINT64_C(0x00000002adcf028c) }},
  {{ UINT64_C(0x8e4e1ec4f7114221), UINT64_C(0x5c7f6c97e3b592ee), UINT64_C(0xd16771e4812284ce), UINT64_C(0x0000000093159075) }},
  {{ UINT64_C(0x0b85176f68aa2ec0), UINT64_C(0xda6520e6feda2d88), UINT64_C(0x0bb91743d1cef37a), UINT64_C(0x000000012896625b) }},
  {{ UINT64_C(0x31281111098dcb45), UINT64_C(0x6cc2f66801e5e863), UINT64_C(0xde9ba50361b14dd9), UINT64_C(0x00000001a0ed4755) }},
  {{ UINT64_C(0x5867fb190943f361), UINT64_C(0xac6249e2402ad2a4), UINT64_C(0xeeb4d9f461e4e3c2), UINT64_C(0x000000002c1b3c2f) }},
  {{ UINT64_C(0x98d0723ecf27dfca), UINT64_C(0x9d2855050ccccad4), UINT64_C(0x4c1e66c517a01f2d), UINT64_C(0x00000002cb50e482) }},
  {{ UINT64_C(0x8a3d2486830e7c46), UINT64_C(0xa57e3b4314174428), UINT64_C(0x0bdb09969a625abf), UINT64_C(0x000000025ced7710) }},
  {{ UINT64_C(0xd37ee61ac2cfa7e7), UINT64_C(0xb2cf6cbbba826a42), UINT64_C(0x7395029a70b9a60b), UINT64_C(0x000000033514e33f) }},
  {{ UINT64_C(0x1c861b31e23ebb98), UINT64_C(0x5f0e760233f3809f), UINT64_C(0x69072c6fa23771a1), UINT64_C(0x00000001e6592a11) }},
  {{ UINT64_C(0x073a0fe7b6b01f52), UINT64_C(0x85fceb7018a9b08f), UINT64_C(0x2b653ee095b5d573), UINT64_C(0x0000000058fabba5) }},
};

static const block_t Ri_8[] = {
  {{ UINT64_C(0x224be4f28bdd3f32), UINT64_C(0x477d32c928e0910c), UINT64_C(0xc7b3fc5ae03a0c8d), UINT64_C(0x000000008decad6f) }},
  {{ UINT64_C(0x746f185e6b76bab5), UINT64_C(0x1b60b2b8f565d9ec), UINT64_C(0x9da7dbfb711e85fa), UINT64_C(0x0000000061cfa0c7) }},
  {{ UINT64_C(0x3f5015f70aa603c3), UINT64_C(0x46d8c09e26bdef9a), UINT64_C(0x1eb0d2003477e5ab), UINT64_C(0x00000003c337875e) }},
  {{ UINT64_C(0x14d9f8eabedc5548), UINT64_C(0x9f05e1d48af5959d), UINT64_C(0xfd7b46cc35c207f5), UINT64_C(0x0000000382c25abd) }},
  {{ UINT64_C(0x84af27a39332a4c8), UINT64_C(0x51720e909bfd3e48), UINT64_C(0x020fc4ad2623bcc4), UINT64_C(0x000000006ab606a6) }},
  {{ UINT64_C(0x22a7ca63870fd027), UINT64_C(0x2549a9bf70b65efe), UINT64_C(0x9b1dceb05c077079), UINT64_C(0x0000000090f9f7ba) }},
  {{ UINT64_C(0x1aa3c8b5a74c7fda), UINT64_C(0x08fb2d960d0db4be), UINT64_C(0x9a54b5a0634cf48b), UINT64_C(0x00000003da7b3e14) }},
  {{ UINT64_C(0x7f54660311045ca3), UINT64_C(0xd67fb293bcf650bf), UINT64_C(0xc2fae4c7073f82eb), UINT64_C(0x000000011b9b203a) }},
  {{ UINT64_C(0xd4ae54c9be6d4777), UINT64_C(0x67c5bd1be1ecfa79), UINT64_C(0xc0a4bf0e0d829f45), UINT64_C(0x00000003ff7c9af1) }},
  {{ UINT64_C(0xece164a4711c9614), UINT64_C(0x6b7fa829b83132ee), UINT64_C(0x803f78cf82999dff), UINT64_C(0x0000000052bb70eb) }},
  {{ UINT64_C(0x40f3892d023714a3), UINT64_C(0x35ea55e54599b6d3), UINT64_C(0xd13e6823f85bf70f), UINT64_C(0x0000000374d49f9d) }},
  {{ UINT64_C(0xa2177e7c17df40ab), UINT64_C(0xa8a6d734d324659c), UINT64_C(0x6352a846cb2260d9), UINT64_C(0x00000000714ffeea) }},
  {{ UINT64_C(0x9d512107908d3b94), UINT64_C(0x4fb6e2d134196606), UINT64_C(0x1a7d3acce7a24c56), UINT64_C(0x00000000b5377ecf) }},
  {{ UINT64_C(0x457cd30184bb93c9), UINT64_C(0x9294a20ef7ffe259), UINT64_C(0xcd044216173d5907), UINT64_C(0x00000000c4bb8014) }},
  {{ UINT64_C(0xa627e9ff0b99a6c4), UINT64_C(0x281e3ef554745d1f), UINT64_C(0x16b7bfad102cff27), UINT64_C(0x00000001c352c04a) }},
  {{ UINT64_C(0xa017157c97e6c8a8), UINT64_C(0x3f03989379c647ee), UINT64_C(0x1b306153d1469190), UINT64_C(0x00000003ed6afac8) }},
  {{ UINT64_C(0x5fa4f2df99bf9c00), UINT64_C(0xdb4f9e46795a5e94), UINT64_C(0xa17a105309fe3c62), UINT64_C(0x000000036dd34507) }},
  {{ UINT64_C(0x00c811607b00f7ec), UINT64_C(0x919b366b1600ad1e), UINT64_C(0x155b88f9b4f1fa31), UINT64_C(0x000000009a0ac64e) }},
  {{ UINT64_C(0x9c2671236378e5b5), UINT64_C(0xbc2731b6cc71d576), UINT64_C(0x1e90f2b9e2c2552d), UINT64_C(0x00000000446bc813) }},
  {{ UINT64_C(0xfe3f646cb131fbcf), UINT64_C(0xa0bb929278b89585), UINT64_C(0x25073c4f45a48a61), UINT64_C(0x00000002e8ee816b) }},
  {{ UINT64_C(0x6b4095b854510e9c), UINT64_C(0x8e98f17740eccf2e), UINT64_C(0x8beb59194ee455c8), UINT64_C(0x00000001a222ed2b) }},
  {{ UINT64_C(0xd1da92c002e64a9c), UINT64_C(0x94c051d1b5d8938e), UINT64_C(0xdcb3f0028739942e), UINT64_C(0x000000008901f4fb) }},
  {{ UINT64_C(0x2684829471a8ead4), UINT64_C(0x5c28d92f694697e3), UINT64_C(0xabb19a79f2fbb97c), UINT64_C(0x00000000784bb641) }},
  {{ UINT64_C(0x9598839f767846cf), UINT64_C(0xdb1a69c36a8a8f8f), UINT64_C(0x180778a08f1e53a8), UINT64_C(0x0000000038b096a9) }},
  {{ UINT64_C(0xee669ac883af93b4), UINT64_C(0xa90a5ea2cdb25911), UINT64_C(0x8152a1b33709d3a2), UINT64_C(0x000000039485194e) }},
  {{ UINT64_C(0xe5141a723566a736), UINT64_C(0xc84e7fa64c357686), UINT64_C(0xea91ecb9ecaf7ba2), UINT64_C(0x00000003f35d90e9) }},
  {{ UINT64_C(0xc4e2f91e7a86d6b4), UINT64_C(0x5d82e6d18bb1f352), UINT64_C(0xfd749224e3d28817), UINT64_C(0x00000002fc7a5014) }},
  {{ UINT64_C(0xe2004e7e3da478b9), UINT64_C(0x2c6caadf3403dd7b), UINT64_C(0x76299ca33d0c2371), UINT64_C(0x00000001c97627d4) }},
  {{ UINT64_C(0x328348b5da028354), UINT64_C(0xc5e4ec7cb8f278aa), UINT64_C(0x2c1e9e2f57dd364a), UINT64_C(0x00000000ce7db271) }},
  {{ UINT64_C(0x7310d5ae201de490), UINT64_C(0x443b43f37ed8f10a), UINT64_C(0x5e3081d68c3a2c9f), UINT64_C(0x0000000368633554) }},
};

static const block_t Ri_9[] = {
  {{ UINT64_C(0x2089efe02ba26e9c), UINT64_C(0x44f815c9536c1b02), UINT64_C(0x97102b11395125c4), UINT64_C(0x000000014f67e17d) }},
  {{ UINT64_C(0x0d5cabf364730328), UINT64_C(0xdac592cd489ad5ad), UINT64_C(0xcb73b844dbbe0a4a), UINT64_C(0x0000000389723d83) }},
  {{ UINT64_C(0x82eb6c1c93907746), UINT64_C(0xff2e5c2f812f244c), UINT64_C(0xc21e80f7109aa337), UINT64_C(0x00000000ff5e64c3) }},
  {{ UINT64_C(0xf4837937b662b516), UINT64_C(0x17770b5a386864a6), UINT64_C(0xdb12efaf1fe37ee1), UINT64_C(0x000000013a27d6f9) }},
  {{ UINT64_C(0xe14d628beff35a9a), UINT64_C(0xa91639306bc28d6a), UINT64_C(0xab51cefc2f3a7ed8), UINT64_C(0x0000000165844dc8) }},
  {{ UINT64_C(0xd503f09889d7cc15), UINT64_C(0xc0776d75d0fbb98b), UINT64_C(0x8b4d090153b4cf58), UINT64_C(0x00000003f59c374f) }},
  {{ UINT64_C(0x406c819359d4f408), UINT64_C(0xf45932d42b180e41), UINT64_C(0x2960ebc28fe34edf), UINT64_C(0x000000013f44c038) }},
  {{ UINT64_C(0x3ec09e4c8df07224), UINT64_C(0xa7671ddd11e7c942), UINT64_C(0x287719841c421c64), UINT64_C(0x0000000040ca7584) }},
  {{ UINT64_C(0xa11618487f087ac0), UINT64_C(0x4b95c9d01ea2e45b), UINT64_C(0x4a12d59f76f106ef), UINT64_C(0x000000002755419c) }},
  {{ UINT64_C(0x489ff007335c26f8), UINT64_C(0x5ddb535233afc642), UINT64_C(0xf7bc5e87787a5ae9), UINT64_C(0x000000025e0548d9) }},
  {{ UINT64_C(0xe458fa0ae55650f6), UINT64_C(0x9ede443d58110d5e), UINT64_C(0x7b6f9be2c6a0e3b4), UINT64_C(0x000000000be77aff) }},
  {{ UINT64_C(0xe4ce2ecc77651cdb), UINT64_C(0xd14fcb5da8ebd079), UINT64_C(0xdae18dae21d16c99), UINT64_C(0x00000002aeeb6824) }},
  {{ UINT64_C(0xa1243665bfc4559d), UINT64_C(0xad12bafde714f357), UINT64_C(0x6a015a9ae2f26c7f), UINT64_C(0x00000003375f1d45) }},
  {{ UINT64_C(0x0c0fc784e1a31392), UINT64_C(0xfb315130cc6118da), UINT64_C(0x2c16ab1212fe061b), UINT64_C(0x000000026c533b62) }},
  {{ UINT64_C(0xf39fd1c53e08b83e), UINT64_C(0xb23946c5f5327dac), UINT64_C(0xf7b8f27ac6ea5b8d), UINT64_C(0x0000000141dc589d) }},
  {{ UINT64_C(0xd54f6a094a6fb653), UINT64_C(0xf5233c98e6dbb3df), UINT64_C(0x60f5188639c7d235), UINT64_C(0x00000002e9629b34) }},
  {{ UINT64_C(0xed23c5da86f19895), UINT64_C(0x6e89a7747ba49b4f), UINT64_C(0x207f75eab2bc9eb7), UINT64_C(0x000000006e1eae58) }},
  {{ UINT64_C(0x68245b74e11c59c3), UINT64_C(0x10fcb66b53534f0e), UINT64_C(0xc9f77e8b10dff306), UINT64_C(0x000000000f641019) }},
  {{ UINT64_C(0xc1b07507874293ba), UINT64_C(0x13b9e966fa64723e), UINT64_C(0xb424a1d3c7514e7e), UINT64_C(0x00000002ac3ede82) }},
  {{ UINT64_C(0xc49c02863026de70), UINT64_C(0x7872414f5d11a756), UINT64_C(0x3219afb0acb02f3e), UINT64_C(0x000000000db947b9) }},
  {{ UINT64_C(0x9793ff3eef41b498), UINT64_C(0x62ba520aeed75345), UINT64_C(0x0afb7bc11a34566b), UINT64_C(0x00000001001e0d91) }},
  {{ UINT64_C(0x3f0f2fc5d519330c), UINT64_C(0x5fa21dd49cece1bf), UINT64_C(0x7474007852292177), UINT64_C(0x0000000128ec71a1) }},
  {{ UINT64_C(0x54a9e846c9f0bdd8), UINT64_C(0x572b671061c921a6), UINT64_C(0x7c045cd18652a35b), UINT64_C(0x00000003f7ec45ee) }},
  {{ UINT64_C(0x1efb0e9633a0f7d9), UINT64_C(0xa5a76251a883e341), UINT64_C(0xdfff764a63e03124), UINT64_C(0x00000001c78abdee) }},
  {{ UINT64_C(0x710be344181719f5), UINT64_C(0x3d339086620f40b9), UINT64_C(0xb7ba0fbda970aedd), UINT64_C(0x000000033bd729e4) }},
  {{ UINT64_C(0x8233b47bbeabb209), UINT64_C(0xa4169f2b85a6b313), UINT64_C(0x48b3789e63e02682), UINT64_C(0x0000000124d5d487) }},
  {{ UINT64_C(0xf5c8ff67588217b6), UINT64_C(0xc58160694bf4bb48), UINT64_C(0xeb03b3284bc54ace), UINT64_C(0x00000003e522037b) }},
  {{ UINT64_C(0x625979fe28fcbbae), UINT64_C(0x3307236b2bd7cb7b), UINT64_C(0x407102422009ad3f), UINT64_C(0x0000000034fe16ed) }},
  {{ UINT64_C(0x057bcf948487a536), UINT64_C(0xf3659603a8f27b7e), UINT64_C(0x0272b343d79e2d0a), UINT64_C(0x000000026b3c3ed5) }},
  {{ UINT64_C(0x380727de0792ae82), UINT64_C(0xc835bacdf04f5e3e), UINT64_C(0xb8945ae4c8ee56c8), UINT64_C(0x00000002f1e01ac1) }},
};

static const block_t Ri_10[] = {
  {{ UINT64_C(0xc25c0a9ab1d80e62), UINT64_C(0xcccfc46353d642f5), UINT64_C(0x4b94d3bbc2d95ac7), UINT64_C(0x00000000d9e6b58f) }},
  {{ UINT64_C(0x3678599af2c36725), UINT64_C(0xdc8cecbf2fff7899), UINT64_C(0x30ffd670eccb260c), UINT64_C(0x000000006948a7f6) }},
  {{ UINT64_C(0x5f3b3ec7bb66c42a), UINT64_C(0xe03240232e1150f2), UINT64_C(0x238e81fdee2d6f85), UINT64_C(0x00000000420494f0) }},
  {{ UINT64_C(0x63d6545a79b7301e), UINT64_C(0x872ce70d1e547fed), UINT64_C(0xf0a1485d978d2c7d), UINT64_C(0x00000001b3546e47) }},
  {{ UINT64_C(0xb4f3371d85c5baed), UINT64_C(0x149a46eb9e3e4926), UINT64_C(0xa7278e59a3cf23ca), UINT64_C(0x00000001b4afd24c) }},
  {{ UINT64_C(0x20b15dda65cce0a3), UINT64_C(0x1df39185a6c763a9), UINT64_C(0x5d42b3eefa41684e), UINT64_C(0x00000000665f9495) }},
  {{ UINT64_C(0x3271e7853188f409), UINT64_C(0x76fec0ae28218ce7), UINT64_C(0x900803de7660a2b6), UINT64_C(0x000000012caacd70) }},
  {{ UINT64_C(0xd6651c7c286072ea), UINT64_C(0x8cb95b7febf17ccf), UINT64_C(0x35acc33b507e5ebe), UINT64_C(0x000000039be257bf) }},
  {{ UINT64_C(0x497bd02c675d5ce9), UINT64_C(0xeaeeffb571ed9a49), UINT64_C(0xf94e2ada735826b6), UINT64_C(0x00000003fb0b850a) }},
  {{ UINT64_C(0x121b3d9f4fbe5a37), UINT64_C(0x07ddf5d9704899f5), UINT64_C(0xefe52327b722b211), UINT64_C(0x000000014d708f20) }},
  {{ UINT64_C(0x34c0edb4da98e5da), UINT64_C(0x7112046efa364d4e), UINT64_C(0xb1826b8785a268ad), UINT64_C(0x00000000dd7bb503) }},
  {{ UINT64_C(0x5c2e850323e5d10d), UINT64_C(0x759e9cd16f0a4d56), UINT64_C(0xa1b21cd84687be7b), UINT64_C(0x00000003225631c2) }},
  {{ UINT64_C(0x2d84a37300fb2c82), UINT64_C(0xc1d812eb21e8865a), UINT64_C(0xd947d86357a9fae8), UINT64_C(0x00000001cabdc371) }},
  {{ UINT64_C(0x5a1a95242cfa27ea), UINT64_C(0xd2229ca4c414ba1e), UINT64_C(0x23bfe012aa250c7e), UINT64_C(0x00000000e377a709) }},
  {{ UINT64_C(0x97ad7fe61b161780), UINT64_C(0x55bc7f0cf1336c8c), UINT64_C(0x9922b93e7bbe7acc), UINT64_C(0x00000001234676b3) }},
  {{ UINT64_C(0xd2d01b91e6ead2a5), UINT64_C(0x5571cbfae39a5511), UINT64_C(0x972db0d3d522f9cb), UINT64_C(0x00000001db5f2e99) }},
  {{ UINT64_C(0x00520140a014efd3), UINT64_C(0xf02162de927b071a), UINT64_C(0x600f767e9f9723d0), UINT64_C(0x000000005b588d44) }},
  {{ UINT64_C(0x8ffa2715d5a49026), UINT64_C(0x85f5b2280278cb8f), UINT64_C(0x71ca3ed387dea2d7), UINT64_C(0x000000011f94182b) }},
  {{ UINT64_C(0x6638ddf2c006b930), UINT64_C(0x1b7b382a6a19f2a9), UINT64_C(0xe69b032e45ccda95), UINT64_C(0x00000001cbaa6df2) }},
  {{ UINT64_C(0x4d2f102ce0ecf573), UINT64_C(0x203b3a6f7208c3f6), UINT64_C(0x5bb766b5b509d8ad), UINT64_C(0x00000003e884d29a) }},
  {{ UINT64_C(0xd125b052011a7c02), UINT64_C(0xa0e9a7c4faf8bc62), UINT64_C(0x9bdf0ae6ca47fd7b), UINT64_C(0x00000002cfb1aca9) }},
  {{ UINT64_C(0x705e5e430f8d02f6), UINT64_C(0x5a61cc1f31a5076c), UINT64_C(0xee619acf781d61db), UINT64_C(0x00000002bff0ba72) }},
  {{ UINT64_C(0x2a42e4d439875333), UINT64_C(0x2f58a1edb9112497), UINT64_C(0x771738a25aa8070b), UINT64_C(0x000000036136a988) }},
  {{ UINT64_C(0x7da333c9fa088bcf), UINT64_C(0x3281db00f888a56f), UINT64_C(0x28498f75e09f5519), UINT64_C(0x00000003a1c9116b) }},
  {{ UINT64_C(0xc974ebeb2419a45a), UINT64_C(0xb3827602d3b577c9), UINT64_C(0xca23b767c9f41630), UINT64_C(0x00000002b3bf9e32) }},
  {{ UINT64_C(0x62811098b591e477), UINT64_C(0xeb667d676c2263cb), UINT64_C(0xd46a07ee277c3d64), UINT64_C(0x000000037fb0f93b) }},
  {{ UINT64_C(0x7167480aec5a4d3f), UINT64_C(0x488241400b62e7e5), UINT64_C(0x8fc08b4ce5680878), UINT64_C(0x00000000b5e5c299) }},
  {{ UINT64_C(0x4095f253609662fe), UINT64_C(0x3db6461e0062cb0f), UINT64_C(0x7f2058d855446689), UINT64_C(0x000000029c8c5af3) }},
  {{ UINT64_C(0x27d4af2e47b56245), UINT64_C(0xb1ce3b3c5e1f4c01), UINT64_C(0xe24807869949e0d4), UINT64_C(0x000000027979ef28) }},
  {{ UINT64_C(0x4024b5bd3a206073), UINT64_C(0xd09ec7afb82d4164), UINT64_C(0xb96ee476da2ecf6c), UINT64_C(0x00000000f707debb) }},
};

static const block_t Ri_11[] = {
  {{ UINT64_C(0x9f6088432f0fbf05), UINT64_C(0x11c8be7e02dc96a3), UINT64_C(0xa2aa06f1f258bb13), UINT64_C(0x00000000003862f0) }},
  {{ UINT64_C(0x5c6ebebe839618a6), UINT64_C(0xa960b25c80a2d1ab), UINT64_C(0x5a9c61fc210877e4), UINT64_C(0x000000002bf52f30) }},
  {{ UINT64_C(0x09f35c669e02a607), UINT64_C(0xcae8bd1a48004cde), UINT64_C(0x4ccde9bdc1361f79), UINT64_C(0x000000003a1ac674) }},
  {{ UINT64_C(0x260f486ef3956626), UINT64_C(0x872ed2f5db934ac6), UINT64_C(0xe9c2eb25a695ea7a), UINT64_C(0x00000001453bb1c8) }},
  {{ UINT64_C(0x5bbf6d4875b4caf4), UINT64_C(0x5ff06e2c034300c3), UINT64_C(0xdd5e01f945075060), UINT64_C(0x000000021571f8dc) }},
  {{ UINT64_C(0x750f6680c6653f61), UINT64_C(0xc82ca9b50f96d6ce), UINT64_C(0x0c1ac2d4ad79150f), UINT64_C(0x00000000ec12bd69) }},
  {{ UINT64_C(0xb241181d2c15323c), UINT64_C(0x98026d35c6f08a24), UINT64_C(0xd216557a306c4a35), UINT64_C(0x000000003130ab74) }},
  {{ UINT64_C(0x645cd16ce1ed0d5a), UINT64_C(0x01a7b7e62e414bd3), UINT64_C(0x1b61fea94d70f6fa), UINT64_C(0x00000003b23c3335) }},
  {{ UINT64_C(0xc464c2e1fcc3021f), UINT64_C(0x82906020e66166e4), UINT64_C(0x576134cf95eb1b4f), UINT64_C(0x0000000260099402) }},
  {{ UINT64_C(0x0cc0aeb4df8be67d), UINT64_C(0xf4123b1feb96e89a), UINT64_C(0x241ab94ac488c718), UINT64_C(0x00000000122907de) }},
  {{ UINT64_C(0x73f316c898daca7b), UINT64_C(0xf304b2ee6bfd688a), UINT64_C(0xf8ed5162a0ef1c5a), UINT64_C(0x00000003a306d44f) }},
  {{ UINT64_C(0xa2ba0370950f923d), UINT64_C(0x8e64612a5f416073), UINT64_C(0xa039d549698ae9e0), UINT64_C(0x00000001d29b4e4c) }},
  {{ UINT64_C(0xbbd3e4ce48942330), UINT64_C(0x4da88486b8a1af90), UINT64_C(0x4cefd03abd3d5fcb), UINT64_C(0x0000000264ed96e6) }},
  {{ UINT64_C(0xbe3366617883a25c), UINT64_C(0xd7e7df51609b02da), UINT64_C(0x50c76be3870ca2f6), UINT64_C(0x00000002f8e3957a) }},
  {{ UINT64_C(0xacdff28daef48db4), UINT64_C(0xf22791e62a0833b3), UINT64_C(0xc0bea75f216ba733), UINT64_C(0x0000000168a07e80) }},
  {{ UINT64_C(0xdadfa8732c2465cf), UINT64_C(0xfdb0b0187481718c), UINT64_C(0x9a951e6908d17d77), UINT64_C(0x000000038ed23b4b) }},
  {{ UINT64_C(0x12894d1197607ade), UINT64_C(0xe95e63089a912c3e), UINT64_C(0x9fd899bf79f0d129), UINT64_C(0x000000022557fe38) }},
  {{ UINT64_C(0x0da1c8def8f036f1), UINT64_C(0x01260d1340b06ceb), UINT64_C(0x4f78f3a94f9567f5), UINT64_C(0x000000034db8b753) }},
  {{ UINT64_C(0x566532dc25b43559), UINT64_C(0x30225ab04b37cc56), UINT64_C(0xc00f7874e390d796), UINT64_C(0x000000029e7d0c32) }},
  {{ UINT64_C(0xea6330ba156ecc2f), UINT64_C(0x71725af09ea9bab6), UINT64_C(0xda912e74e37b9827), UINT64_C(0x00000002f4c00feb) }},
  {{ UINT64_C(0xad1d29151b6a29a7), UINT64_C(0x7309ceb11feb95cf), UINT64_C(0x0678e211064684aa), UINT64_C(0x00000002cec31bfe) }},
  {{ UINT64_C(0x0068aae628c1bbcc), UINT64_C(0xa0de968761552fcd), UINT64_C(0xb5d55c2e1b0ae955), UINT64_C(0x00000000f301acc9) }},
  {{ UINT64_C(0xb04ee7a31db53627), UINT64_C(0x88247d53cb9b6471), UINT64_C(0x4efe56d66b001c06), UINT64_C(0x00000001d8be89eb) }},
  {{ UINT64_C(0x71ef4d85eb32de26), UINT64_C(0x1b5aad41125448e0), UINT64_C(0x5d9420db916bd96c), UINT64_C(0x00000003600938a4) }},
  {{ UINT64_C(0x21c69a26e24a80dc), UINT64_C(0x2ada34857d2e3776), UINT64_C(0x5dcc569b74deed82), UINT64_C(0x000000032d7c9e46) }},
  {{ UINT64_C(0x8614ab77d258f9fb), UINT64_C(0x3d8e544590b80370), UINT64_C(0xc1d697f6ded2abac), UINT64_C(0x000000010c8305b7) }},
  {{ UINT64_C(0x2211e8fb3393c798), UINT64_C(0x1e07ff4cd1356ef6), UINT64_C(0x3443178987bbaadd), UINT64_C(0x00000002ee932027) }},
  {{ UINT64_C(0x1ce461f37887eefa), UINT64_C(0xaaff9f57503d4768), UINT64_C(0x2fa103060b360b0f), UINT64_C(0x00000001a6c038ff) }},
  {{ UINT64_C(0x92465ac440cd48ad), UINT64_C(0x306e4e94cf44104c), UINT64_C(0xf7c93cbd0325efb9), UINT64_C(0x000000033d1ea818) }},
  {{ UINT64_C(0x831b95d8ca9b7421), UINT64_C(0x5724c4923a9a852c), UINT64_C(0xb390b826e7a4abaf), UINT64_C(0x000000019e33e881) }},
};

static const block_t Ri_12[] = {
  {{ UINT64_C(0x4fa92b7571346707), UINT64_C(0x458bb7a2fb9fd179), UINT64_C(0x92edffb08c5265b6), UINT64_C(0x00000000c5952833) }},
  {{ UINT64_C(0x13387260a64de1da), UINT64_C(0x86596903b2fa8926), UINT64_C(0x82bacf8f7eed3c24), UINT64_C(0x000000038576c4a5) }},
  {{ UINT64_C(0xb5263cb7b8b6a1b4), UINT64_C(0x47bc17a9a72f165c), UINT64_C(0xce5f92886f654806), UINT64_C(0x0000000350572cb9) }},
  {{ UINT64_C(0x57f71e99030e0192), UINT64_C(0x00bbf5d12ec058de), UINT64_C(0xb935606f563ea0be), UINT64_C(0x00000003b3d40f9f) }},
  {{ UINT64_C(0x5a1a7d2fbf0b4ce6), UINT64_C(0x312283069628e7c1), UINT64_C(0xe5392ab7eeec075a), UINT64_C(0x000000032a9b7398) }},
  {{ UINT64_C(0xd21bea6e3883a764), UINT64_C(0x85c1db546744eed6), UINT64_C(0x428fc43569954032), UINT64_C(0x0000000274b076f7) }},
  {{ UINT64_C(0x623b12505841fb28), UINT64_C(0xb0ca2c7fc31f29bd), UINT64_C(0x0a96295398c74f49), UINT64_C(0x00000003b9195cc9) }},
  {{ UINT64_C(0x11b732bd2632cffe), UINT64_C(0x6e2ace7ddce50b56), UINT64_C(0x3358dc7a61365e45), UINT64_C(0x00000003941dd9c4) }},
  {{ UINT64_C(0x2eb834b5da9bc7c5), UINT64_C(0x20059395ede1a207), UINT64_C(0x946b3eab23ea3d70), UINT64_C(0x00000002b2837403) }},
  {{ UINT64_C(0xc3d57af0a06dbb32), UINT64_C(0x856f9a82dac4b031), UINT64_C(0x0b4eb3f44359f1f5), UINT64_C(0x0000000086644b3d) }},
  {{ UINT64_C(0x1bf10d1994a36790), UINT64_C(0xba9bce8989221eab), UINT64_C(0xbe4a7c1127032921), UINT64_C(0x00000000fd52fcab) }},
  {{ UINT64_C(0x35fc78da93dcecc3), UINT64_C(0x67405d9ef77a7c0e), UINT64_C(0x98617169505820d3), UINT64_C(0x000000008fa35cb8) }},
  {{ UINT64_C(0xe589f2603ea3a24b), UINT64_C(0x2d1099d940b2c518), UINT64_C(0x779792f2a27f1c3b), UINT64_C(0x000000021735c93f) }},
  {{ UINT64_C(0xfe4316ddbffe44d4), UINT64_C(0xdbf7caae3b4e7e0b), UINT64_C(0x729bb9a0a5c6701c), UINT64_C(0x0000000328392c9f) }},
  {{ UINT64_C(0xc73642edd93637aa), UINT64_C(0x49c6c74a802c44f2), UINT64_C(0x147c933c604b6b72), UINT64_C(0x00000001aead45e6) }},
  {{ UINT64_C(0x89358644b656cefd), UINT64_C(0xe4bf99a2de772a1e), UINT64_C(0x8fc09170250619de), UINT64_C(0x00000000390b4a16) }},
  {{ UINT64_C(0x3ef47581b80cd7ed), UINT64_C(0xe3688177f2b7c782), UINT64_C(0x20694188f57a0ed2), UINT64_C(0x00000003d18b0008) }},
  {{ UINT64_C(0xbbb2d8fd82e1ce8c), UINT64_C(0x39078eb92f1bdd75), UINT64_C(0xbf7e5544b6fca7c5), UINT64_C(0x00000002ba284153) }},
  {{ UINT64_C(0x0675846fa3271493), UINT64_C(0x652bba0a0fa65e3b), UINT64_C(0x285e3ee7b7e32235), UINT64_C(0x0000000270268f38) }},
  {{ UINT64_C(0xb7851d21e7aa8c55), UINT64_C(0xbe89b7ea4a066d5a), UINT64_C(0x98425fb62ac7e119), UINT64_C(0x00000001983ffc7c) }},
  {{ UINT64_C(0x83fbed4b442b3e47), UINT64_C(0x1d5d06c16d637d99), UINT64_C(0xbab12b2fda0aa06c), UINT64_C(0x00000000f29fca28) }},
  {{ UINT64_C(0x664edd3bd1149dbf), UINT64_C(0xa0fce174101f71f6), UINT64_C(0xbeb28419b1b4d75e), UINT64_C(0x00000003826c40b1) }},
  {{ UINT64_C(0x4c48c62dd76b3f7f), UINT64_C(0xf99f82cc33f14d48), UINT64_C(0x8bf39d92166be20a), UINT64_C(0x000000008be1f9c4) }},
  {{ UINT64_C(0x1bdac2a170d3e938), UINT64_C(0x1a6dccaab865eb0e), UINT64_C(0xc3ad83df081d7aeb), UINT64_C(0x000000034390cdd9) }},
  {{ UINT64_C(0xc369be7bbadb7427), UINT64_C(0x20db5f59d6596e5c), UINT64_C(0x67a05e085904fed0), UINT64_C(0x00000003fddc197f) }},
  {{ UINT64_C(0xe1c2fab311f3968b), UINT64_C(0x31f4f441454256b2), UINT64_C(0x8fb5a37cbc5c5456), UINT64_C(0x00000003eea93bdf) }},
  {{ UINT64_C(0x06be414819154efe), UINT64_C(0xa03b1579354d25e8), UINT64_C(0xf04aa7244b71f74f), UINT64_C(0x0000000259da8e80) }},
  {{ UINT64_C(0x8eaf9462e6b1ba88), UINT64_C(0x55196ea967e71922), UINT64_C(0xa7c8ffba940cdf0f), UINT64_C(0x00000002fd97572d) }},
  {{ UINT64_C(0x0589c3e5f023f0bf), UINT64_C(0x5fd7bad1e3d6101e), UINT64_C(0xe1f0225bcbb15905), UINT64_C(0x00000003dafb7842) }},
  {{ UINT64_C(0xcabb57b3a56d685d), UINT64_C(0x044faec2b4b6e61c), UINT64_C(0x6db61d0c2e5d070a), UINT64_C(0x000000022f5c0d5e) }},
};

static const block_t Ri_13[] = {
  {{ UINT64_C(0x47fdcf1bbd2a421e), UINT64_C(0xd0886abb72875562), UINT64_C(0x6a7617b31814cabf), UINT64_C(0x000000003a29fe4e) }},
  {{ UINT64_C(0x0847ca87acd6a4db), UINT64_C(0xc8e66c9763aafd7a), UINT64_C(0x2dd5ce71001548cc), UINT64_C(0x00000000fd7a6567) }},
  {{ UINT64_C(0xfa9a5432a4f69677), UINT64_C(0xfbb9f24b3622bae3), UINT64_C(0xe2b5c8a065b433e9), UINT64_C(0x00000001467e5763) }},
  {{ UINT64_C(0x951ff1248f1d24fd), UINT64_C(0xed9451968a60df3e), UINT64_C(0x6c06651e4566c0e5), UINT64_C(0x0000000046aca8ca) }},
  {{ UINT64_C(0x3d22b672eb35b7c7), UINT64_C(0xe9959d181dcfbb73), UINT64_C(0x2326de71dc841669), UINT64_C(0x000000033725ae65) }},
  {{ UINT64_C(0x23715f360a0202b7), UINT64_C(0x85a586f78a236389), UINT64_C(0xf3395839b175f678), UINT64_C(0x000000004adf80e7) }},
  {{ UINT64_C(0xe5353e796b22eba5), UINT64_C(0x447025a003b7562d), UINT64_C(0x9d94d7c56b61321c), UINT64_C(0x00000001bb0ca317) }},
  {{ UINT64_C(0xb7e8e936cab8fbb9), UINT64_C(0x9c0c989f5dbf059e), UINT64_C(0x11ccce26078f83a9), UINT64_C(0x0000000126b60a98) }},
  {{ UINT64_C(0x51e354a7c9329021), UINT64_C(0xe3db7acede21008c), UINT64_C(0xccd7eabb6f5c1fa9), UINT64_C(0x000000033f336c72) }},
  {{ UINT64_C(0x7ab1819c2d44c7d7), UINT64_C(0x3e77c354360f33ea), UINT64_C(0xde10d64ca799cc7d), UINT64_C(0x00000002105eb3a8) }},
  {{ UINT64_C(0x1c99c04ee67e9aae), UINT64_C(0xd39e9f5d9680a9c8), UINT64_C(0x997e427ef5f3a8b8), UINT64_C(0x00000003823661ef) }},
  {{ UINT64_C(0xe1ecc89fabce661c), UINT64_C(0x5fa0388802028c3c), UINT64_C(0x8f077eb57a2f5144), UINT64_C(0x0000000023649ecd) }},
  {{ UINT64_C(0x9324b599858904b8), UINT64_C(0xaa1c8d68c836aa3a), UINT64_C(0xdd3c89ece3512979), UINT64_C(0x00000001c6da2096) }},
  {{ UINT64_C(0xb7be1dc1e3f9cf3b), UINT64_C(0xea1714b2e96df0c8), UINT64_C(0xaa4c7dcdfdc093b8), UINT64_C(0x00000002bc13cedb) }},
  {{ UINT64_C(0x9a342bc43963444a), UINT64_C(0x519b60999a8f2a5d), UINT64_C(0xfe8c9a7502afc595), UINT64_C(0x00000001499a1e49) }},
  {{ UINT64_C(0xfb38e12955be9412), UINT64_C(0xf73c9450df334521), UINT64_C(0x616457231beb7045), UINT64_C(0x00000001f9132d7d) }},
  {{ UINT64_C(0x2e62020b7dd8226a), UINT64_C(0x8fbe78a927154830), UINT64_C(0x1f0b171b06c5d53b), UINT64_C(0x0000000033b94377) }},
  {{ UINT64_C(0x7b728136b638e7a3), UINT64_C(0xb6b0b36c78e93346), UINT64_C(0xca36822489cfe757), UINT64_C(0x0000000047594797) }},
  {{ UINT64_C(0xd53873425d305f5e), UINT64_C(0x994dbbda61a7a8ae), UINT64_C(0xceabf38b11d0e56b), UINT64_C(0x00000002334cbd89) }},
  {{ UINT64_C(0x95121d2d47bae088), UINT64_C(0xf9c272170abcad66), UINT64_C(0x053995c56d72d4da), UINT64_C(0x000000017c25b068) }},
  {{ UINT64_C(0x51e6f4c981102f39), UINT64_C(0xb5898ce9075ad6c2), UINT64_C(0x664ad1c84d30c6d2), UINT64_C(0x00000003c05afd53) }},
  {{ UINT64_C(0x6715600a24b05748), UINT64_C(0x7ffe48e34096fc5e), UINT64_C(0x6ccfb22c9e361b57), UINT64_C(0x00000000a2b96d0e) }},
  {{ UINT64_C(0xc48d19628696f30d), UINT64_C(0x0c462934830e6573), UINT64_C(0x829a8cc8ac6a9f2d), UINT64_C(0x000000021b4ddfde) }},
  {{ UINT64_C(0xcd2b58865b57b0dd), UINT64_C(0xc27817f0346ed21c), UINT64_C(0xc03cf929fa9c3935), UINT64_C(0x000000037a16dabd) }},
  {{ UINT64_C(0x03d2924f84109ee0), UINT64_C(0xabaac26ecf296d32), UINT64_C(0x635f536a36f74460), UINT64_C(0x00000001fddd367b) }},
  {{ UINT64_C(0x6bef99322249a9f8), UINT64_C(0x084d97794d491828), UINT64_C(0x6ffa3937a4dd9bbe), UINT64_C(0x0000000162c4e111) }},
  {{ UINT64_C(0x3b3294e17a0c6110), UINT64_C(0x090ef2388fa93813), UINT64_C(0xade252f7324e865a), UINT64_C(0x000000001894cc6c) }},
  {{ UINT64_C(0x503d37db883e5939), UINT64_C(0xf20cc8d1b5a7aa10), UINT64_C(0x363528403f8829aa), UINT64_C(0x00000000b8635d31) }},
  {{ UINT64_C(0xedd2269eeb857c29), UINT64_C(0xddaa1714a0d9910d), UINT64_C(0xe794e61ca06a6b36), UINT64_C(0x000000016e83b626) }},
  {{ UINT64_C(0xfa679bc24316e7c7), UINT64_C(0xca120dc42481b9ee), UINT64_C(0xcfee97771f7d9cde), UINT64_C(0x00000002f520e798) }},
};

static const block_t Ri_14[] = {
  {{ UINT64_C(0xb07329f0c65fa13f), UINT64_C(0x1185b242d92548ff), UINT64_C(0x909cf03ee20aa8a9), UINT64_C(0x00000000dfb955a5) }},
  {{ UINT64_C(0x8b0b9a039ecd55aa), UINT64_C(0x72014438f4c422a1), UINT64_C(0x87de4405a1cf3a6a), UINT64_C(0x0000000210109ab0) }},
  {{ UINT64_C(0xb6e03b0a6c6c9e10), UINT64_C(0xe9edde6edda5b15e), UINT64_C(0x3b44a9f3a617acdb), UINT64_C(0x00000002869a5cc7) }},
  {{ UINT64_C(0x166bf2825e7cac71), UINT64_C(0x9d155b91cc308d39), UINT64_C(0x606be4c0f5713986), UINT64_C(0x000000006c1fdbc7) }},
  {{ UINT64_C(0x979cb5e551a6879f), UINT64_C(0x2c3e7e606eeb1db5), UINT64_C(0x8137412f01aa9724), UINT64_C(0x00000002788f81e4) }},
  {{ UINT64_C(0x7f236a5e6f4de9b9), UINT64_C(0xa26942906cd525fc), UINT64_C(0xb3d7c821f2cf9870), UINT64_C(0x0000000190c800fd) }},
  {{ UINT64_C(0xfd7a754dad7d881e), UINT64_C(0x8a4376e532242e1f), UINT64_C(0xdb2b3ee3b89b7b09), UINT64_C(0x000000034f644edd) }},
  {{ UINT64_C(0x7573feb33ce163d3), UINT64_C(0x0be3c0de4b8b539f), UINT64_C(0xfc28915e5eff6770), UINT64_C(0x000000003714ddcd) }},
  {{ UINT64_C(0x407c69564b78837d), UINT64_C(0x4dcf560762f9aaca), UINT64_C(0x0616c716a979e12d), UINT64_C(0x00000001a2d8afd1) }},
  {{ UINT64_C(0x4221d05b709230c5), UINT64_C(0x131c0c0dc9303d33), UINT64_C(0x7497f8a0dbe80eaf), UINT64_C(0x00000000c5467eb0) }},
  {{ UINT64_C(0xdb416a30823d60e0), UINT64_C(0xb69aa77a0d2ee09a), UINT64_C(0x0681e1c52557163b), UINT64_C(0x00000002261d4e0f) }},
  {{ UINT64_C(0xd199f9064a16ace8), UINT64_C(0x8146ccb08fcb35f6), UINT64_C(0x6cfa35fbdaa8500c), UINT64_C(0x00000000f0da559e) }},
  {{ UINT64_C(0xe50f0b25ef677529), UINT64_C(0xe98070992d5962c2), UINT64_C(0x4393b9a35cb1e9f4), UINT64_C(0x00000003731bb3a9) }},
  {{ UINT64_C(0x8eda9648d0ad0a15), UINT64_C(0x460674a58d5d1fe6), UINT64_C(0x75c6737612014eb8), UINT64_C(0x0000000368145ac8) }},
  {{ UINT64_C(0x2269efca3bd5ab3d), UINT64_C(0xf344ca798dd52311), UINT64_C(0x5f66c8d2a98aa27e), UINT64_C(0x00000003890f91d1) }},
  {{ UINT64_C(0xb41a8511e5d47975), UINT64_C(0xb6aaab53cf595dda), UINT64_C(0x56002dbdf861f25b), UINT64_C(0x0000000195c7fd41) }},
  {{ UINT64_C(0x1946fbc2ebc14fd3), UINT64_C(0x5938efa871105cc2), UINT64_C(0x3d5baa198826555d), UINT64_C(0x00000000647e9215) }},
  {{ UINT64_C(0xe538eedfbe36dca6), UINT64_C(0xf8e2a44a0c99505d), UINT64_C(0x351d0796f508fd05), UINT64_C(0x000000018849b22f) }},
  {{ UINT64_C(0x60624bd03e3ccbd3), UINT64_C(0xae67d9e23020c5e3), UINT64_C(0x49d79f83e0e8c9e8), UINT64_C(0x00000000dbf5da41) }},
  {{ UINT64_C(0xc16971bf3f2f8c89), UINT64_C(0xe31ba1d01180c4b0), UINT64_C(0x95f432c0d7ced3a3), UINT64_C(0x00000001c947c2b9) }},
  {{ UINT64_C(0xba2bc828b6ed6be0), UINT64_C(0xf2b800c2eb26f33a), UINT64_C(0x34edbaf64d85c783), UINT64_C(0x000000018ed48a81) }},
  {{ UINT64_C(0xc8a68fe4d6eb52b5), UINT64_C(0xa78464e4d5a72ed6), UINT64_C(0x51778707dbdd5aa7), UINT64_C(0x00000000564a8b82) }},
  {{ UINT64_C(0x04baff8c480fb50a), UINT64_C(0x4231d77cb4698b5e), UINT64_C(0xa7ad07d3bcdd506d), UINT64_C(0x00000003c509e930) }},
  {{ UINT64_C(0xa4a4e034ade893a1), UINT64_C(0x9cf94d5ad448301e), UINT64_C(0x51331388cf3e334e), UINT64_C(0x00000000594352da) }},
  {{ UINT64_C(0xfa4281c23ec392e2), UINT64_C(0x5bdbcf2b53f3e42d), UINT64_C(0x726da904aaac2c17), UINT64_C(0x0000000145eb4468) }},
  {{ UINT64_C(0x824f70dcd6bc0033), UINT64_C(0x71a8e54133fdcef4), UINT64_C(0x036e120c6d228812), UINT64_C(0x00000003a50ad34e) }},
  {{ UINT64_C(0x947e85ab2c6e2546), UINT64_C(0xa43fabe7d556e9dd), UINT64_C(0xa1aab894663b9e57), UINT64_C(0x00000001e0e8a776) }},
  {{ UINT64_C(0x98f54b52d6c5e2a0), UINT64_C(0x66aee3d9cde0fccc), UINT64_C(0x533d0c9c0bfa1e78), UINT64_C(0x000000012a7dc4bc) }},
  {{ UINT64_C(0x637f99ffad2e79ba), UINT64_C(0x04e18cb6a8f42da9), UINT64_C(0xf021c408e61535ce), UINT64_C(0x000000024ef52e6a) }},
  {{ UINT64_C(0xba23248c01df33a4), UINT64_C(0x4552d84f7f763c05), UINT64_C(0x4df5ebb322e22444), UINT64_C(0x000000039b25ab7a) }},
};

static const block_t Ri_15[] = {
  {{ UINT64_C(0xb5d980ee787c6bfc), UINT64_C(0x5a94f37326ab461d), UINT64_C(0x606e887fb933a874), UINT64_C(0x00000001c4335f46) }},
  {{ UINT64_C(0x22bca1f9b169fdbf), UINT64_C(0xf3e02df881527453), UINT64_C(0x3d4fac5e0a0b4731), UINT64_C(0x00000003c37acb7c) }},
  {{ UINT64_C(0xea8fb68e3b058590), UINT64_C(0xacc15739915e02ce), UINT64_C(0x9d579895c11bb7f0), UINT64_C(0x0000000335c8ead6) }},
  {{ UINT64_C(0x7ed3ca8c2084f896), UINT64_C(0xc14df7dfa42b7c7c), UINT64_C(0x7c232174bd319581), UINT64_C(0x00000000331cac82) }},
  {{ UINT64_C(0xdf0527a0da027c98), UINT64_C(0xdb28da9d8c6f38b0), UINT64_C(0x5349bf3b74f4beb2), UINT64_C(0x000000034f1abdff) }},
  {{ UINT64_C(0x982aa903c92b33b8), UINT64_C(0xcd752049614e73e4), UINT64_C(0x78b946ce5abd5ceb), UINT64_C(0x0000000116886280) }},
  {{ UINT64_C(0xf51c6127cae530f8), UINT64_C(0xbcbe10075521e9f7), UINT64_C(0x8372aec74621451a), UINT64_C(0x000000010470d541) }},
  {{ UINT64_C(0x867afeefc72b647f), UINT64_C(0x07fbd9247ced7a37), UINT64_C(0x97586fcb4b4c4968), UINT64_C(0x00000003cfbadecb) }},
  {{ UINT64_C(0x373cbb8ac8dc32e2), UINT64_C(0xe97a810d918fa3c8), UINT64_C(0x0f2711d990641945), UINT64_C(0x00000001ad72b622) }},
  {{ UINT64_C(0x5aaa00f8d7bbdbd6), UINT64_C(0x69d4b07bffb598f9), UINT64_C(0xed120c35d778e2d9), UINT64_C(0x000000032ec0b5ca) }},
  {{ UINT64_C(0x737d9c289226446a), UINT64_C(0x4b6650b7c0de3d63), UINT64_C(0xb7708b0a50d7da36), UINT64_C(0x0000000331d6a251) }},
  {{ UINT64_C(0xb1ea9f88a185720d), UINT64_C(0x5268748e1d1fa788), UINT64_C(0x4d4e9895944e60ad), UINT64_C(0x00000001e49c0166) }},
  {{ UINT64_C(0x8e28170ab9d46761), UINT64_C(0xcd1f020aa4046356), UINT64_C(0xb0c288dbb7a70b97), UINT64_C(0x00000001ac459825) }},
  {{ UINT64_C(0x751a61ffabea9b9d), UINT64_C(0x4d5800cb98b3faa9), UINT64_C(0xd8e5c8c0f58a2124), UINT64_C(0x000000039937ddd1) }},
  {{ UINT64_C(0xb46c6e9b9a3cb6c4), UINT64_C(0x105656ea57a1336b), UINT64_C(0x89e9ee632ac3808f), UINT64_C(0x00000003ecd9f5c8) }},
  {{ UINT64_C(0x0e48b7c4ed0c211f), UINT64_C(0xdddbdb738e99cef1), UINT64_C(0xfc110533066296a5), UINT64_C(0x00000001450ec0d3) }},
  {{ UINT64_C(0xbe8765f75e9d5816), UINT64_C(0x66c3bb776f067803), UINT64_C(0xd7f02063ea2f93c1), UINT64_C(0x000000013302d1ad) }},
  {{ UINT64_C(0x36d2857c4d66f5d6), UINT64_C(0xc20fd58af13182cd), UINT64_C(0x49057982e40921a2), UINT64_C(0x000000009a051c6e) }},
  {{ UINT64_C(0xbab68b743cb8e4c9), UINT64_C(0x994e46da7a255c69), UINT64_C(0x9d7e6d25d6fac4da), UINT64_C(0x00000003de663adc) }},
  {{ UINT64_C(0xd9d52d770b8b440e), UINT64_C(0x562fa4c960d72f47), UINT64_C(0x0d1edce25bc78f77), UINT64_C(0x00000002ca053f5d) }},
  {{ UINT64_C(0x5b3d33281b8b7a24), UINT64_C(0x6b3da714c527b44f), UINT64_C(0xcf30343464cd471f), UINT64_C(0x000000000fb2becd) }},
  {{ UINT64_C(0x5356f0c1a477e299), UINT64_C(0x53950707b5b82229), UINT64_C(0x856efe42205c8d2e), UINT64_C(0x00000003ea866d5a) }},
  {{ UINT64_C(0x2103305cc6a0b040), UINT64_C(0x10db3fc3193bb097), UINT64_C(0xa28bc378541c2d52), UINT64_C(0x00000003226c15f9) }},
  {{ UINT64_C(0xb5677bcabfa1e1a3), UINT64_C(0x1e25d97d69565d9b), UINT64_C(0xb8f06f0dba46791b), UINT64_C(0x0000000003c9b6d5) }},
  {{ UINT64_C(0x788dc38a604d692d), UINT64_C(0xdb4b010ca76624fa), UINT64_C(0xcbb2d7662c8b0837), UINT64_C(0x00000003a0221661) }},
  {{ UINT64_C(0x54c66af476f5afb8), UINT64_C(0x95e1ccc192553c4d), UINT64_C(0x72b70356e6262e65), UINT64_C(0x000000012d34ea55) }},
  {{ UINT64_C(0xd0da2e70935113d2), UINT64_C(0x2447bc96841db902), UINT64_C(0xedc3e96cb8ef44ab), UINT64_C(0x00000000a90368b7) }},
  {{ UINT64_C(0x3a7e48f3d8bd9786), UINT64_C(0x7b8f3ddddfa04030), UINT64_C(0xed57bd1af358b9f9), UINT64_C(0x0000000210138d10) }},
  {{ UINT64_C(0xbb0df4278feb04db), UINT64_C(0x47aa92589780cd67), UINT64_C(0x3c8227d459bdd13d), UINT64_C(0x0000000111f7a3d8) }},
  {{ UINT64_C(0x33402a81b2c7c3d5), UINT64_C(0x048b1d3f69e92821), UINT64_C(0x1ea226194d543932), UINT64_C(0x000000020e618f69) }},
};

static const block_t Ri_16[] = {
  {{ UINT64_C(0x4cf8fe5375be482d), UINT64_C(0xb8836bc516602d50), UINT64_C(0x4ac32ffa56c20ae8), UINT64_C(0x00000002c4db5dbc) }},
  {{ UINT64_C(0x6677534a7723205d), UINT64_C(0x0937df4344adc741), UINT64_C(0x5aa6645aeef0352c), UINT64_C(0x00000000197a3718) }},
  {{ UINT64_C(0x799067332977074c), UINT64_C(0x7e547daecf9f5a57), UINT64_C(0x9794607d9dac0baf), UINT64_C(0x000000014b2b3b5f) }},
  {{ UINT64_C(0xc04dd9056729fc4f), UINT64_C(0xd4ab749d2c0a8778), UINT64_C(0x1b5d3cd55de9d9c8), UINT64_C(0x00000002926a8610) }},
  {{ UINT64_C(0xa576529280639fe2), UINT64_C(0xd2a180417be4882d), UINT64_C(0xc14b9efbc4564cae), UINT64_C(0x000000031666504a) }},
  {{ UINT64_C(0xca7850bba58d6fa3), UINT64_C(0x91f749406a2a35ca), UINT64_C(0xb9c5f0019bd4808f), UINT64_C(0x00000003327d7c06) }},
  {{ UINT64_C(0xe04e1ca02e62a1d5), UINT64_C(0xa56ac12b27172e08), UINT64_C(0xddfeae46c096de41), UINT64_C(0x00000000d93efc67) }},
  {{ UINT64_C(0xfb10142fbff3a2a4), UINT64_C(0x8dd9fb1ee26ff292), UINT64_C(0x3e94ae0b3c3013f1), UINT64_C(0x00000003b0f2c814) }},
  {{ UINT64_C(0xc8fe80836f0af395), UINT64_C(0x58fa6dd87ab24b40), UINT64_C(0xaf4e1a6a473701ff), UINT64_C(0x000000016e3c8177) }},
  {{ UINT64_C(0x5ffc2211d8c4a0c3), UINT64_C(0x71606151c79da0bd), UINT64_C(0xe321c884678310e2), UINT64_C(0x00000003bc1ecd5f) }},
  {{ UINT64_C(0x902cb6c09af6085f), UINT64_C(0x52512407e4ddf0ec), UINT64_C(0xb38da2acbda7b48c), UINT64_C(0x000000024b77e292) }},
  {{ UINT64_C(0x90c12f5578f69601), UINT64_C(0xfcd19dc6fd746294), UINT64_C(0xbb7715ca38b195d4), UINT64_C(0x00000001af2bb4bb) }},
  {{ UINT64_C(0xc464415f9b46ea9d), UINT64_C(0x5a1c204937caf6e4), UINT64_C(0x04500b0b7b871d2a), UINT64_C(0x00000000c09b8401) }},
  {{ UINT64_C(0xff075d74b52af423), UINT64_C(0xd2e2460a6d1797fb), UINT64_C(0x86b6e09eba9b039f), UINT64_C(0x00000000264d5aa2) }},
  {{ UINT64_C(0xf3ffa7bbee1f9543), UINT64_C(0xf9b9b03d6eec1c7f), UINT64_C(0x44e27b3d3c3db10f), UINT64_C(0x00000001282024f1) }},
  {{ UINT64_C(0x6c5751d0fddb73f8), UINT64_C(0xc71961ca92778046), UINT64_C(0xa84ce27d06eaeb9f), UINT64_C(0x0000000394fe38e2) }},
  {{ UINT64_C(0x76ab957288b140ad), UINT64_C(0x3506232023ae4bd5), UINT64_C(0x9969e6cd6c81575f), UINT64_C(0x00000002b81bb93d) }},
  {{ UINT64_C(0x423b79dd1406e518), UINT64_C(0xf98930f07d0058ed), UINT64_C(0xf97376dbdc8450d2), UINT64_C(0x000000021a3a5a7b) }},
  {{ UINT64_C(0x6bfc3cc04aef807e), UINT64_C(0x12fb1a3d6b5c8c4a), UINT64_C(0xdb9c4712e15b7998), UINT64_C(0x00000000b2414523) }},
  {{ UINT64_C(0xccf88502e379697a), UINT64_C(0x61e11776b5d6c20c), UINT64_C(0xf03bb513885e105e), UINT64_C(0x00000000613010ea) }},
  {{ UINT64_C(0x5c7eb8db4457b5fb), UINT64_C(0xc6bbd0efa8eb7a97), UINT64_C(0xcbfb3ddfb9a5f933), UINT64_C(0x00000000ab1768d9) }},
  {{ UINT64_C(0xb0ea3dd409dc8065), UINT64_C(0x3c4bde2e0b5bb8b2), UINT64_C(0xe06b6d8fbaf38346), UINT64_C(0x0000000041f3e14e) }},
  {{ UINT64_C(0x2b61b1243e79be47), UINT64_C(0xc6c621f7b8f17cce), UINT64_C(0x9c4a365d442b49ae), UINT64_C(0x00000003314bffc2) }},
  {{ UINT64_C(0x07b05be4d04e6e05), UINT64_C(0x075d2212a20aa589), UINT64_C(0x866bee6d9de3aaf4), UINT64_C(0x000000013eb87cd6) }},
  {{ UINT64_C(0xeefff1cc8085f687), UINT64_C(0x2dbcb82e71f64d5b), UINT64_C(0x18d1a802d55168fd), UINT64_C(0x000000016c0cac1b) }},
  {{ UINT64_C(0xcdb15fabb8616bc6), UINT64_C(0xc48cd8d42f4cf599), UINT64_C(0x7662fa60de7ea12b), UINT64_C(0x000000019c81103a) }},
  {{ UINT64_C(0x6d084e575b0e5a8a), UINT64_C(0x79dbcfdfd502d3da), UINT64_C(0xe47bf1609000dfd9), UINT64_C(0x0000000130490842) }},
  {{ UINT64_C(0x1a0663415a2b13c1), UINT64_C(0x16a7c32a9c54b71c), UINT64_C(0x625e707a8ac82a5a), UINT64_C(0x0000000199a3c650) }},
  {{ UINT64_C(0x55a116220624c0d8), UINT64_C(0x349d8f8bd1181264), UINT64_C(0x50547326823f8f41), UINT64_C(0x00000001a52a673f) }},
  {{ UINT64_C(0x6a3a6b58f7ad8924), UINT64_C(0xaebd51995ce15783), UINT64_C(0xb567fda41cdb5d36), UINT64_C(0x000000031d0657f7) }},
};

static const block_t Ri_17[] = {
  {{ UINT64_C(0x62f14d41344cd5d9), UINT64_C(0x7885405769cf75e1), UINT64_C(0x977c54f4eebd404e), UINT64_C(0x0000000125ab13a2) }},
  {{ UINT64_C(0xf87d2f5658f4d69f), UINT64_C(0x3f68e09d27973d69), UINT64_C(0xd65ae283b2b5a5a5), UINT64_C(0x0000000054fd5e1d) }},
  {{ UINT64_C(0x5c9a76663d64a7ef), UINT64_C(0xea8199d6001fdd60), UINT64_C(0x8ecf1a8db5f031b2), UINT64_C(0x000000000fc97b49) }},
  {{ UINT64_C(0xca31e4319be72dc4), UINT64_C(0x4f151b4662d6d791), UINT64_C(0x9b84827cde58e620), UINT64_C(0x000000011f12d550) }},
  {{ UINT64_C(0x8405ec3f5c5a597d), UINT64_C(0x553b95c115805a51), UINT64_C(0x341b8c7d12628a85), UINT64_C(0x0000000179e71947) }},
  {{ UINT64_C(0x3f4a8ac4159478fa), UINT64_C(0x3852c0b730168f57), UINT64_C(0xe2ca6d861b9e35f0), UINT64_C(0x00000001d287887e) }},
  {{ UINT64_C(0x3bb9d696c5538ba2), UINT64_C(0x0a29866ad367f487), UINT64_C(0xc7ba0a0dbe1881e5), UINT64_C(0x0000000084c04046) }},
  {{ UINT64_C(0x79ccb647593b64ee), UINT64_C(0xfd9ca3b7bbb098c5), UINT64_C(0x4c094bcba9cbc0b6), UINT64_C(0x000000034a3483f7) }},
  {{ UINT64_C(0xf8711cf29a9381e0), UINT64_C(0x6e9dd4394dbe9ca4), UINT64_C(0x275212ce6366c098), UINT64_C(0x00000000b08b3047) }},
  {{ UINT64_C(0xe5e99e0efd127e4d), UINT64_C(0xccaee0a6da37271d), UINT64_C(0x2ed571ddeb323b9d), UINT64_C(0x000000028cc626ec) }},
  {{ UINT64_C(0x2df4b06d16b7f226), UINT64_C(0xa05490957746ec50), UINT64_C(0xeed150c6eb93d89c), UINT64_C(0x00000001308e4cab) }},
  {{ UINT64_C(0x1bf99b0dcf1bae03), UINT64_C(0x0d25327e3030f807), UINT64_C(0xf98b3f9f5d66dc4a), UINT64_C(0x00000001b20e34ed) }},
  {{ UINT64_C(0x07d0f9622b957ede), UINT64_C(0xd455d47c9e030416), UINT64_C(0xf1544b0883ca8aed), UINT64_C(0x000000006829c223) }},
  {{ UINT64_C(0x18226888771cadda), UINT64_C(0x82106e9f96047ac1), UINT64_C(0x321dd37ac489e065), UINT64_C(0x000000030b2619b4) }},
  {{ UINT64_C(0x4a93b9da1be1cded), UINT64_C(0x8964cf6ca653aa0d), UINT64_C(0x0b2c271abaadbdb4), UINT64_C(0x000000026a823ff5) }},
  {{ UINT64_C(0x213a672495c3bc69), UINT64_C(0xea56510f37189a95), UINT64_C(0x426a7c137de7d5df), UINT64_C(0x00000000f0b4df07) }},
  {{ UINT64_C(0x2d65ba5dab080141), UINT64_C(0xab64987829b64c6c), UINT64_C(0x74d76382077b1756), UINT64_C(0x00000002c980a9a1) }},
  {{ UINT64_C(0xe1065895ecd270c6), UINT64_C(0x1281eca1c3fe84d6), UINT64_C(0xa4646f47be928e70), UINT64_C(0x000000029f623c64) }},
  {{ UINT64_C(0xc1551a54dcf36fdd), UINT64_C(0x5293ef27ae181029), UINT64_C(0xc8cb237156d74d86), UINT64_C(0x0000000126f32cae) }},
  {{ UINT64_C(0x243005e50787e21f), UINT64_C(0xa29ac3083d5a5547), UINT64_C(0xef69a378bc2a08af), UINT64_C(0x0000000198847686) }},
  {{ UINT64_C(0x7ff169f1485cccae), UINT64_C(0x221476400b571c2e), UINT64_C(0x9504ab821c79974d), UINT64_C(0x00000003ba114b61) }},
  {{ UINT64_C(0x2d612e53d162084b), UINT64_C(0x9fa50f31133ab04e), UINT64_C(0xd21abd8fd3b60be8), UINT64_C(0x000000008f56d531) }},
  {{ UINT64_C(0x9288cbe8f3e9f2d1), UINT64_C(0xbdacb6eea3a496ef), UINT64_C(0x4ff49ec70bd29ed6), UINT64_C(0x00000001401bfce6) }},
  {{ UINT64_C(0x86efe165fa701c41), UINT64_C(0x85d6c276381c7810), UINT64_C(0x330fdd6ae5cff67f), UINT64_C(0x00000001068e4cbf) }},
  {{ UINT64_C(0x8fd0d6b15ce72cb5), UINT64_C(0xe53b4fb4f97abf86), UINT64_C(0x70f6abd0225ab930), UINT64_C(0x000000025f94c1a3) }},
  {{ UINT64_C(0xed857e183ed1b3ad), UINT64_C(0xda87040c37d085fc), UINT64_C(0x7afe1d63b224d026), UINT64_C(0x0000000102c6f4dc) }},
  {{ UINT64_C(0xa2cde8a75f65fdeb), UINT64_C(0x5c25ba686bd06792), UINT64_C(0x06a7923cd74bc23b), UINT64_C(0x0000000236cbd9ef) }},
  {{ UINT64_C(0x8b36140cb475a7c9), UINT64_C(0x17387fffb4e476bf), UINT64_C(0xcd8c545567f6cce0), UINT64_C(0x00000000d8246b3f) }},
  {{ UINT64_C(0x129a0fa9cb5ea235), UINT64_C(0xc95d48f1fd98f71a), UINT64_C(0x09c2ba38926493b9), UINT64_C(0x0000000218e56631) }},
  {{ UINT64_C(0x136bd8c6e95cd775), UINT64_C(0x6577896dcc0d24b1), UINT64_C(0x6b8d110a29091f6f), UINT64_C(0x00000000141abb23) }},
};

static const block_t Ri_18[] = {
  {{ UINT64_C(0xe875aa2ac1e1ee16), UINT64_C(0x204012ea03764fc9), UINT64_C(0x1a2de85ce17edf16), UINT64_C(0x00000000252a76b9) }},
  {{ UINT64_C(0x05b73aa1bcd5e146), UINT64_C(0xa288ec34e9291ba3), UINT64_C(0x4047c1935d8036bd), UINT64_C(0x00000002abedaa20) }},
  {{ UINT64_C(0xca9cb583964e4186), UINT64_C(0xb78185cb3ec8559d), UINT64_C(0x1d3b9cec49327769), UINT64_C(0x00000000cffdeec3) }},
  {{ UINT64_C(0xc7f1c7c717358713), UINT64_C(0x4cd9e62882aed38c), UINT64_C(0x9d14a0416c748df1), UINT64_C(0x00000003996f071c) }},
  {{ UINT64_C(0x034adee40a34b724), UINT64_C(0x29e3b1ffd56fc17e), UINT64_C(0xf8a2da058494a52e), UINT64_C(0x00000001a2a3ace0) }},
  {{ UINT64_C(0x276459ada0fe1808), UINT64_C(0xea65832a5783ca78), UINT64_C(0xcd4849a5f8980f2a), UINT64_C(0x00000002881d4b18) }},
  {{ UINT64_C(0x6af793fa252af469), UINT64_C(0xb83b127e3fa978b9), UINT64_C(0xc2de2da0c1f6471f), UINT64_C(0x00000000f45712a3) }},
  {{ UINT64_C(0x78b1ce48c4f98895), UINT64_C(0x0d95446328ac86e1), UINT64_C(0xd2959bc5cd878967), UINT64_C(0x00000001314f26ae) }},
  {{ UINT64_C(0x274c6075a314bd86), UINT64_C(0x7ab8b128225fb0a2), UINT64_C(0xdac4827040356024), UINT64_C(0x00000002a3721607) }},
  {{ UINT64_C(0xe79fe945314becaa), UINT64_C(0x27852a0fbc3920df), UINT64_C(0x5b9aa8b70d85d90a), UINT64_C(0x00000003f3fc0055) }},
  {{ UINT64_C(0xe3ee460a492c6a6f), UINT64_C(0xdc18f9ceb777522d), UINT64_C(0x9145ec419e51ec7a), UINT64_C(0x000000025b128780) }},
  {{ UINT64_C(0x70142d2f8274fbc8), UINT64_C(0x63c49fcbb351b7f8), UINT64_C(0xf5f30f00aa3c2498), UINT64_C(0x00000002d4d2f708) }},
  {{ UINT64_C(0x18f3bdbcc487e57a), UINT64_C(0x1a5b8bd618a22930), UINT64_C(0x930d593240664226), UINT64_C(0x00000003a7f20be4) }},
  {{ UINT64_C(0xef51a587be5dd810), UINT64_C(0xd85cbdf7fc23a15b), UINT64_C(0xf5637d8dde652b44), UINT64_C(0x00000000ed25d032) }},
  {{ UINT64_C(0x26eb2aa0a0e5642f), UINT64_C(0xd96d218bd7fd7f59), UINT64_C(0x360aac2e41d4186a), UINT64_C(0x00000000b689a132) }},
  {{ UINT64_C(0x2aa347e215185e02), UINT64_C(0xe31be5911232df49), UINT64_C(0xfd5c3a8b4c459482), UINT64_C(0x000000005c4ec88b) }},
  {{ UINT64_C(0x5bbd5785121d35a8), UINT64_C(0x13e03b1f4276ae87), UINT64_C(0xb792e8eb3a862c43), UINT64_C(0x00000003e844c619) }},
  {{ UINT64_C(0x58ee358ccafc9d92), UINT64_C(0x762b3104eb9fa971), UINT64_C(0xb702ba85f7496bd9), UINT64_C(0x000000012e168034) }},
  {{ UINT64_C(0xd853a81f76275cea), UINT64_C(0xefdec270652a8e73), UINT64_C(0xc3f8580521eb2a24), UINT64_C(0x000000036dd03d2c) }},
  {{ UINT64_C(0x6ee01fe57d13a3b2), UINT64_C(0x9e6c5903d2c00e65), UINT64_C(0x6533242f686074b1), UINT64_C(0x0000000238256476) }},
  {{ UINT64_C(0xcf89b1a5920ce32c), UINT64_C(0xfbc2d783f2269343), UINT64_C(0x30b3ae936957ffc0), UINT64_C(0x000000031e492fbf) }},
  {{ UINT64_C(0x3ee19d874a360100), UINT64_C(0x79a17fbf9fccd3d7), UINT64_C(0x581be9e31e1cc774), UINT64_C(0x00000000015b0a01) }},
  {{ UINT64_C(0x242cb42a894b58cc), UINT64_C(0x6cdef035fed87831), UINT64_C(0x277c24aaa846c123), UINT64_C(0x0000000337a2dc09) }},
  {{ UINT64_C(0x9fb915e4ee8db73d), UINT64_C(0x3797beb44539f5b5), UINT64_C(0xd0392fb19e2c4a55), UINT64_C(0x0000000353080113) }},
  {{ UINT64_C(0xc4931343a355ee7d), UINT64_C(0x6ee59f0a3c94fa6d), UINT64_C(0xf257fdcc5d478527), UINT64_C(0x000000003ebb469c) }},
  {{ UINT64_C(0x9c3b239ac9d35519), UINT64_C(0xc3720c54694a0616), UINT64_C(0x08231409ec51f107), UINT64_C(0x00000002e623ed7f) }},
  {{ UINT64_C(0xb3d14288879d005f), UINT64_C(0xf431d6c93d58cd15), UINT64_C(0xb2516bfcb6609c11), UINT64_C(0x000000010f7c09db) }},
  {{ UINT64_C(0x808ecd625afa27aa), UINT64_C(0x233d3048d9f493d4), UINT64_C(0x150e7b4b12d0d764), UINT64_C(0x000000024740a327) }},
  {{ UINT64_C(0x70b8a045e4a06def), UINT64_C(0x40b2423c03d772cd), UINT64_C(0xa90cf72dbc3f811d), UINT64_C(0x000000017ec8c198) }},
  {{ UINT64_C(0x8f17b1be34f1a90f), UINT64_C(0xb429ddd1897b9d29), UINT64_C(0xc5981277a4b5b361), UINT64_C(0x000000033445faa9) }},
};

static const block_t Ri_19[] = {
  {{ UINT64_C(0x110778fb3261d988), UINT64_C(0x243e20f698a4c3f7), UINT64_C(0xeda08171d881b321), UINT64_C(0x00000000a93d1332) }},
  {{ UINT64_C(0xc0b2868c2c804c17), UINT64_C(0x541dde2724446194), UINT64_C(0x02f344cb004ba3c6), UINT64_C(0x0000000039b783c5) }},
  {{ UINT64_C(0x50ff1decbcb386ce), UINT64_C(0xd3a52c491f11075b), UINT64_C(0x5377229fbcb2f22f), UINT64_C(0x0000000356f1bafd) }},
  {{ UINT64_C(0x04692cb7f585908c), UINT64_C(0x0a41be416c92430d), UINT64_C(0xe860bd4d2bb19a50), UINT64_C(0x000000021a4ea0bd) }},
  {{ UINT64_C(0x5d667dfdb9311f41), UINT64_C(0x3ddb10b999a46cc6), UINT64_C(0x5dbb15668c751efa), UINT64_C(0x00000000a32b6ef4) }},
  {{ UINT64_C(0xe2b74ab6e8e6b61a), UINT64_C(0x0024cef97306f219), UINT64_C(0x52d609e83163de44), UINT64_C(0x00000003a1dcd697) }},
  {{ UINT64_C(0x4cf4633ace7d2229), UINT64_C(0x9d04dd940c73c6cb), UINT64_C(0xa8795a3989f896b7), UINT64_C(0x0000000084180f8f) }},
  {{ UINT64_C(0x9cd7820a65d618c7), UINT64_C(0x36adbd0f3caf8741), UINT64_C(0x4bb170e9bea1f727), UINT64_C(0x0000000399a754a6) }},
  {{ UINT64_C(0x6adc8cd39c71b4ae), UINT64_C(0x417afb379cf81d77), UINT64_C(0x018cb72056af01d3), UINT64_C(0x0000000227819e5f) }},
  {{ UINT64_C(0xe5444be0e0ba1388), UINT64_C(0xcabb002f4e499d5f), UINT64_C(0xf759a63ce7d65000), UINT64_C(0x0000000389a56bc3) }},
  {{ UINT64_C(0x2e8056207b581ee0), UINT64_C(0x0e6b1c5fa40e3df6), UINT64_C(0x14092d3d3a16fd13), UINT64_C(0x000000003a9f2427) }},
  {{ UINT64_C(0x75d8f30207510f20), UINT64_C(0xa45aa7dc06779890), UINT64_C(0xbbe3e3a76e16e44b), UINT64_C(0x00000002d5a4eacf) }},
  {{ UINT64_C(0xca2a22d6c6f97c55), UINT64_C(0xf0b95e3dc3d73f0b), UINT64_C(0x86fb8f7833235f50), UINT64_C(0x00000003cacb2ef8) }},
  {{ UINT64_C(0x32cafc943d69f159), UINT64_C(0x6c410b23e9d03266), UINT64_C(0x2baac57842029ad1), UINT64_C(0x000000003e223efe) }},
  {{ UINT64_C(0x7ab9b83ba04db056), UINT64_C(0x33ff616d953127ac), UINT64_C(0xfc05a36fd1ca7081), UINT64_C(0x000000011ea1f87e) }},
  {{ UINT64_C(0x0c2811b5e0a4ea35), UINT64_C(0x103badc2c960cb78), UINT64_C(0xdf630ec7478dcee5), UINT64_C(0x00000002530e99cd) }},
  {{ UINT64_C(0x3b739b251e3d6de0), UINT64_C(0x593347fef978dbce), UINT64_C(0x489c11f21033e7f2), UINT64_C(0x00000000024e2752) }},
  {{ UINT64_C(0x0af2f1a51d38ff34), UINT64_C(0xb53bb785dc75bbd5), UINT64_C(0x0678ffe48f500d7b), UINT64_C(0x000000008073d1cf) }},
  {{ UINT64_C(0x599204148cdda573), UINT64_C(0x47f829cd09a3c932), UINT64_C(0x460f555750f0b266), UINT64_C(0x0000000043df66e3) }},
  {{ UINT64_C(0xd76fb8c3e3fba4ad), UINT64_C(0x0a247eca2fd2d74a), UINT64_C(0xd3d20bf2ebee8533), UINT64_C(0x00000003a0906db0) }},
  {{ UINT64_C(0x53a1e24b5a764a26), UINT64_C(0x7652610eff62e79f), UINT64_C(0xed749eb9be436648), UINT64_C(0x0000000288cd94da) }},
  {{ UINT64_C(0xed3cbc2dadf51b90), UINT64_C(0x11eaf5288878a7f9), UINT64_C(0xb8b443ad6e0b957d), UINT64_C(0x0000000102664e63) }},
  {{ UINT64_C(0x09c4f7daf4bb2955), UINT64_C(0x0577a7ef9e75530b), UINT64_C(0x0f28022fdb2004a5), UINT64_C(0x00000003e6d5726e) }},
  {{ UINT64_C(0x18ce026b8ed14cb5), UINT64_C(0x292b1edeac59d04a), UINT64_C(0x163455e5a4e418d5), UINT64_C(0x000000006becc21b) }},
  {{ UINT64_C(0xe741e5cb002f5fa0), UINT64_C(0x9059fa213b8787d6), UINT64_C(0x2576728aa51ba032), UINT64_C(0x00000003d40c124c) }},
  {{ UINT64_C(0xf805ccf35933c677), UINT64_C(0x8bcfc2c5b5e4af20), UINT64_C(0xa6cb86114c9fe630), UINT64_C(0x000000021e6a8f45) }},
  {{ UINT64_C(0x4a4866143f1c45c8), UINT64_C(0x894057416dd14310), UINT64_C(0x9a16f7fe478c0f71), UINT64_C(0x00000000cacd17ad) }},
  {{ UINT64_C(0xa3ba4e91015ec904), UINT64_C(0x76d42fa7d90235e7), UINT64_C(0x5899223f37185ac5), UINT64_C(0x000000039b499cba) }},
  {{ UINT64_C(0x19391a2f154e50fc), UINT64_C(0xf1398e64ddb76b81), UINT64_C(0xa96b37c43ad5365b), UINT64_C(0x0000000052ac5309) }},
  {{ UINT64_C(0xf90bdf4f5c8b69cb), UINT64_C(0xfe245c560d5f95aa), UINT64_C(0x0950cb082b0a5dac), UINT64_C(0x00000002f5561368) }},
};

static const block_t Ri_20[] = {
  {{ UINT64_C(0x7374794023aa3611), UINT64_C(0x410f0e9dd9d09e92), UINT64_C(0x20d30d923dbba1e3), UINT64_C(0x00000000bb3b1825) }},
  {{ UINT64_C(0x8dc3d3bb97e028de), UINT64_C(0xea81c4834aaf8930), UINT64_C(0xcfe31fb2335cb843), UINT64_C(0x000000011555aefe) }},
  {{ UINT64_C(0x12b7942004238028), UINT64_C(0x1e3de2223d0f119a), UINT64_C(0x08237fa68534b89f), UINT64_C(0x0000000177ef2124) }},
  {{ UINT64_C(0x33420f8c8bb2f723), UINT64_C(0xb58eb907196405ed), UINT64_C(0x0c3ad5104c8329f3), UINT64_C(0x00000000b5528089) }},
  {{ UINT64_C(0x43901ba1457111cb), UINT64_C(0x367e17b54944ab2c), UINT64_C(0xf71c00f0aec6caef), UINT64_C(0x000000007795ffb8) }},
  {{ UINT64_C(0x5f58fb684335c70e), UINT64_C(0x06d554f387d5fd9b), UINT64_C(0x4c01772f6b360253), UINT64_C(0x0000000344fde527) }},
  {{ UINT64_C(0xbaea3286d893c2b9), UINT64_C(0xaa706cff27160aee), UINT64_C(0xea56f72a8effff01), UINT64_C(0x00000003460416f8) }},
  {{ UINT64_C(0x71e6746e914a10ed), UINT64_C(0x9307ece730580501), UINT64_C(0x94c092b9081b5008), UINT64_C(0x000000005a622465) }},
  {{ UINT64_C(0xc8d7a367fa3cb96f), UINT64_C(0xc3413e555cae85ba), UINT64_C(0xf4f845f9b66246f9), UINT64_C(0x0000000155eb23fc) }},
  {{ UINT64_C(0xe2407da6a2c3d9a7), UINT64_C(0x16707ec1055341db), UINT64_C(0x3fe0b9cbf8915c52), UINT64_C(0x00000001281e6e27) }},
  {{ UINT64_C(0xfda3a2da6609fe92), UINT64_C(0xb517f2cd65718d09), UINT64_C(0x7f33abf959d3599b), UINT64_C(0x00000002e7838555) }},
  {{ UINT64_C(0x39ada5983c92bec7), UINT64_C(0x77d3087144c0c1bf), UINT64_C(0x73e63b4b35737c31), UINT64_C(0x000000004d51d158) }},
  {{ UINT64_C(0xf9435eec9ca105b7), UINT64_C(0xcf319401577b125a), UINT64_C(0x498c0f30c893d855), UINT64_C(0x000000027941d9cb) }},
  {{ UINT64_C(0xefafaacc6670a680), UINT64_C(0x453a03cc378e51f5), UINT64_C(0x1d3d32741a7023ac), UINT64_C(0x0000000126766e66) }},
  {{ UINT64_C(0x658029797b1f540b), UINT64_C(0x259bd08fb23111e3), UINT64_C(0x480e3dccd5c2fdc0), UINT64_C(0x00000002611c3399) }},
  {{ UINT64_C(0x0310e0203e87b079), UINT64_C(0x1b4209bbeecc033c), UINT64_C(0xa0a8a237abb29689), UINT64_C(0x00000000e47d1e24) }},
  {{ UINT64_C(0xb4b3b63f2fc667e3), UINT64_C(0x6d3d733ecd4f3ecc), UINT64_C(0xc214c77e65715584), UINT64_C(0x00000000b359508d) }},
  {{ UINT64_C(0xbc05c767e974f0b6), UINT64_C(0x51a76ee6b6620ed6), UINT64_C(0xa709aa317cb89c19), UINT64_C(0x00000001d775f85a) }},
  {{ UINT64_C(0x4d548e9c5b61e0aa), UINT64_C(0x73b374a6f7fffbd3), UINT64_C(0x7d69017895f4cacf), UINT64_C(0x000000018a338934) }},
  {{ UINT64_C(0xd1aed7a649c2ff9d), UINT64_C(0xfa81f18f3bda2876), UINT64_C(0x50dbc21eaeb2eb1f), UINT64_C(0x0000000014b8a135) }},
  {{ UINT64_C(0xb3891ee9757a0335), UINT64_C(0x15134747ab8e4a4e), UINT64_C(0x7ba99aaba62f9c9b), UINT64_C(0x00000002cfd91b6e) }},
  {{ UINT64_C(0x65b03f9c8d2c5563), UINT64_C(0xeb82102f21f575a2), UINT64_C(0xb6e543396a695275), UINT64_C(0x00000000c34119c4) }},
  {{ UINT64_C(0x51e9808b22db0ab4), UINT64_C(0x1a8f30513eb9e8bd), UINT64_C(0x0bb498c2e277e2c0), UINT64_C(0x00000003464bef19) }},
  {{ UINT64_C(0x597942835a34d802), UINT64_C(0x80ad3f88f0b37e05), UINT64_C(0xd16dd86047be3678), UINT64_C(0x00000003c3554b84) }},
  {{ UINT64_C(0x26ef76f15aa1366b), UINT64_C(0x86f907d98b3a734f), UINT64_C(0x8ac2e141fbaeda78), UINT64_C(0x0000000047424778) }},
  {{ UINT64_C(0xb24b7404bd1b0070), UINT64_C(0x359a1db9bb763147), UINT64_C(0xfa8ad487f2046d3c), UINT64_C(0x00000001ca9c1eae) }},
  {{ UINT64_C(0x59fe69b1ac37f578), UINT64_C(0x7985766bcc5f3ab8), UINT64_C(0x2262452071179775), UINT64_C(0x000000025fe47951) }},
  {{ UINT64_C(0xaa687e2949bbe090), UINT64_C(0xecba162cbc216348), UINT64_C(0x393fb526b1e76a53), UINT64_C(0x0000000275cf0b42) }},
  {{ UINT64_C(0xda5b2c7b2812fef1), UINT64_C(0x180b5daa0d39aa2c), UINT64_C(0xdab7d596b957a499), UINT64_C(0x0000000275dcda06) }},
  {{ UINT64_C(0x4dbf0361594a2c54), UINT64_C(0x2e859e6460960681), UINT64_C(0x4c819048506630ac), UINT64_C(0x00000003ec204d47) }},
};

static const block_t Ri_21[] = {
  {{ UINT64_C(0x2a6b14aabe914154), UINT64_C(0xf97910fa074e822a), UINT64_C(0x4f2ac494262bfcb4), UINT64_C(0x00000000533763b3) }},
  {{ UINT64_C(0x43d69e90a20f6df8), UINT64_C(0x64fc5f1dca350dd6), UINT64_C(0x5ce023b522f9bb9c), UINT64_C(0x00000000470990b4) }},
  {{ UINT64_C(0x388315e5ae3e208c), UINT64_C(0xc026e989d2280248), UINT64_C(0x7924d42d8dce9a57), UINT64_C(0x000000034ccb4179) }},
  {{ UINT64_C(0xb6f9b6513326b831), UINT64_C(0x112e1dff80d411ff), UINT64_C(0xebcb7b673ae34581), UINT64_C(0x00000001618998e2) }},
  {{ UINT64_C(0x526e969c6153794f), UINT64_C(0x71859e4058cc8268), UINT64_C(0x0f774b3d83fad07d), UINT64_C(0x000000038567c809) }},
  {{ UINT64_C(0x145d803d14dc7aa5), UINT64_C(0x472bf67c10652133), UINT64_C(0x93d8e1ce61aa48c5), UINT64_C(0x000000021b64c552) }},
  {{ UINT64_C(0xa693854225b79737), UINT64_C(0x9912c421847249d5), UINT64_C(0x70d4e20aa8d86599), UINT64_C(0x00000002fb139ac9) }},
  {{ UINT64_C(0xd8f31c5fed73e722), UINT64_C(0xb226c03ea78e213a), UINT64_C(0xa47eaacf10ce6f14), UINT64_C(0x00000002115683f8) }},
  {{ UINT64_C(0x439a7803daf316a1), UINT64_C(0xcd265e7adf929421), UINT64_C(0x7d0a93d6c8f76dc3), UINT64_C(0x0000000269340b7f) }},
  {{ UINT64_C(0x8880baab450c767e), UINT64_C(0x8f8a068da7cdc279), UINT64_C(0x3c72a8fa5e4e3695), UINT64_C(0x00000000e7cf2d82) }},
  {{ UINT64_C(0xd0dee81a5f0904f1), UINT64_C(0x7e5f4248a9b452e2), UINT64_C(0xa8468798f9391fbe), UINT64_C(0x00000002cb89f53f) }},
  {{ UINT64_C(0x8c58c19f29e53f9f), UINT64_C(0x5026a97b6f499d36), UINT64_C(0xdc7a523467db52f6), UINT64_C(0x00000002eeaf9277) }},
  {{ UINT64_C(0xcf46c2fdd51b05c5), UINT64_C(0x0d359a1b4ac6080a), UINT64_C(0x533fcbf75eb019b9), UINT64_C(0x000000010f2f59db) }},
  {{ UINT64_C(0xdba7da9ff133b643), UINT64_C(0xd5fa1ae6e043ca22), UINT64_C(0x925eded861f1005c), UINT64_C(0x000000007644cdc5) }},
  {{ UINT64_C(0xc2ca193c55dade54), UINT64_C(0x6b6924665cdf12c7), UINT64_C(0x760214c8c77eb5d3), UINT64_C(0x000000031dc0a835) }},
  {{ UINT64_C(0x24360c8343698746), UINT64_C(0x3a2948624c66fb18), UINT64_C(0xe8955365b4390841), UINT64_C(0x000000037b435d81) }},
  {{ UINT64_C(0x53424507aa01f341), UINT64_C(0xf6ff86f9d7fde663), UINT64_C(0xe205edadb188157f), UINT64_C(0x00000001bd7f76ab) }},
  {{ UINT64_C(0xaf6aee7a7dec17dd), UINT64_C(0x7f6ca18033bfcbcf), UINT64_C(0x5eda42af52d903d0), UINT64_C(0x00000003b49521cc) }},
  {{ UINT64_C(0x52327ce1fbc4765b), UINT64_C(0x5a7b340c9ae8dc42), UINT64_C(0xa51f87192054687b), UINT64_C(0x00000002d8483a94) }},
  {{ UINT64_C(0x08b39144fe518306), UINT64_C(0xfb39c5db05399d57), UINT64_C(0xc1daf106dd8dafae), UINT64_C(0x000000012ddcfc57) }},
  {{ UINT64_C(0x5b17ddaae940456b), UINT64_C(0x0e65466acdde8034), UINT64_C(0x306bf396247dce16), UINT64_C(0x00000002a0546d0b) }},
  {{ UINT64_C(0x600d4e5209aeece7), UINT64_C(0xe3def6cb8aa2417d), UINT64_C(0xe1e269951d5de84a), UINT64_C(0x00000003ca5a3b01) }},
  {{ UINT64_C(0xd59b9489744e63ce), UINT64_C(0x5d4272e608f60117), UINT64_C(0x4848fc389122bb2f), UINT64_C(0x00000001baf4fc0d) }},
  {{ UINT64_C(0x3a197f1279ee9eea), UINT64_C(0x867245dca9ff8cdf), UINT64_C(0x7f0161d77293f306), UINT64_C(0x00000002fb704d20) }},
  {{ UINT64_C(0x0b8c5590cd04a207), UINT64_C(0xc6bd1ea3d36fb411), UINT64_C(0xb67c537e7175da98), UINT64_C(0x00000003e5abb7a7) }},
  {{ UINT64_C(0xce93c8359b517d86), UINT64_C(0x777ae220fa7af107), UINT64_C(0xb7d5889e6bb3ce9b), UINT64_C(0x0000000008346890) }},
  {{ UINT64_C(0xb17dd882d2673a5c), UINT64_C(0x7a7bbd5c56ed252c), UINT64_C(0x5f1600747c6f371b), UINT64_C(0x0000000327dc2c87) }},
  {{ UINT64_C(0xba8a911c5fa81522), UINT64_C(0xcc2f647f73e32b10), UINT64_C(0x9f15fb801558bfa3), UINT64_C(0x000000021fbc834e) }},
  {{ UINT64_C(0x219be209978ceb12), UINT64_C(0x10bab5960ca52a69), UINT64_C(0xa213700f8c48d0b5), UINT64_C(0x00000003e453042d) }},
  {{ UINT64_C(0xb4679cf130cdf039), UINT64_C(0x4c705eba72955345), UINT64_C(0x51c15d10c60f1f3b), UINT64_C(0x000000004c613dc5) }},
};

static const block_t Ri_22[] = {
  {{ UINT64_C(0x555b6638daf93623), UINT64_C(0xf59669cee8ed3042), UINT64_C(0x192743ef9eb02434), UINT64_C(0x00000001c4e4dceb) }},
  {{ UINT64_C(0x7a76a6a191ff63c4), UINT64_C(0xdcd34d415064acbe), UINT64_C(0x28234ee4860ded88), UINT64_C(0x00000002ff559698) }},
  {{ UINT64_C(0xbc1e3b8f8ea17805), UINT64_C(0x6f19327221b079f6), UINT64_C(0x555b140901fd676e), UINT64_C(0x0000000026137daf) }},
  {{ UINT64_C(0x5a08123dd33e91e9), UINT64_C(0xf009c8fa402d1c46), UINT64_C(0x53d1559c7002a3f1), UINT64_C(0x000000001c02710f) }},
  {{ UINT64_C(0xd7c72f4669380c6b), UINT64_C(0x292bd7089fa2f339), UINT64_C(0x5a51a50b788c06e3), UINT64_C(0x000000037d1eb6c5) }},
  {{ UINT64_C(0xe307db4a44bf1831), UINT64_C(0x5ecc85204cdc4033), UINT64_C(0x1ce5a7b10491292c), UINT64_C(0x00000002837ac2ef) }},
  {{ UINT64_C(0xea20ca890ef41dba), UINT64_C(0x19c4e54af61a3c5e), UINT64_C(0xfda116b2fe8cf7e5), UINT64_C(0x00000001159b7ecb) }},
  {{ UINT64_C(0x2e698aa99840ed00), UINT64_C(0x374a455a24c251ca), UINT64_C(0xf1d140f799f66042), UINT64_C(0x000000033b7c9ea3) }},
  {{ UINT64_C(0x893ea32216d6352d), UINT64_C(0xced62a32fa2fbd2a), UINT64_C(0xcb86b86f51c44697), UINT64_C(0x00000001a7a02f85) }},
  {{ UINT64_C(0x6562219563bbc0b8), UINT64_C(0xef1d9ae02844924b), UINT64_C(0xa8a2b403ebd80994), UINT64_C(0x00000002a549d32e) }},
  {{ UINT64_C(0x2c716a9a9a69db0b), UINT64_C(0x6b8b22ac05865aff), UINT64_C(0x5e9910a8f736864c), UINT64_C(0x00000003e4c8a2fe) }},
  {{ UINT64_C(0x0e762f7d25e2ad3a), UINT64_C(0x0c26d35f37015c68), UINT64_C(0x0a8d67056f9f047a), UINT64_C(0x000000030aa9b9ae) }},
  {{ UINT64_C(0xb1819351a7f19715), UINT64_C(0x0dc65517d6a64f66), UINT64_C(0xb6268f8ffc6f6572), UINT64_C(0x00000001c8b38fa4) }},
  {{ UINT64_C(0x788939a91e648f15), UINT64_C(0x92dcd38ebd2c70fb), UINT64_C(0xa4812f7c4fef6cb7), UINT64_C(0x00000000e777e905) }},
  {{ UINT64_C(0x772f0bd7179a3fbd), UINT64_C(0x37b8e3fbfd151592), UINT64_C(0x268bfdbf9b821054), UINT64_C(0x0000000126c46c53) }},
  {{ UINT64_C(0x726bffa6d33a5565), UINT64_C(0x22c0e4f23e42aaef), UINT64_C(0x9abf1368d1a71fc5), UINT64_C(0x0000000043833dd3) }},
  {{ UINT64_C(0x4a4fec775d3d8f5c), UINT64_C(0xa025b6896d5c473c), UINT64_C(0x912c8d73274b2905), UINT64_C(0x00000001f1f228d7) }},
  {{ UINT64_C(0xbfa775a25b168881), UINT64_C(0x13079a1b52968811), UINT64_C(0xfe86eb8130d4e615), UINT64_C(0x00000000c8d93805) }},
  {{ UINT64_C(0x8d05175bdc36c78f), UINT64_C(0x99ae90608df36ce9), UINT64_C(0xa8ca3860e0e8c03e), UINT64_C(0x00000000da01ba48) }},
  {{ UINT64_C(0x8087b650157743c0), UINT64_C(0xb230be01fd4f019d), UINT64_C(0xdc51313b0ec04872), UINT64_C(0x00000001e7820767) }},
  {{ UINT64_C(0xa91ed1dcfa82f055), UINT64_C(0xdee5a3ee4468ebb5), UINT64_C(0xdb8484832eae92ae), UINT64_C(0x0000000169f244de) }},
  {{ UINT64_C(0x265a6ee00133510b), UINT64_C(0xf1c2109f5eeb7cae), UINT64_C(0x7f190b5862a5a830), UINT64_C(0x00000000983f25f9) }},
  {{ UINT64_C(0x1f5f794d8dc67501), UINT64_C(0xa38e4afc4cc370d7), UINT64_C(0x8293d2a1b721c7b1), UINT64_C(0x0000000093f687fc) }},
  {{ UINT64_C(0x2d8197d97d1bb26a), UINT64_C(0x58e78b26827067c4), UINT64_C(0x182015d74c57e62a), UINT64_C(0x00000001a9df4c04) }},
  {{ UINT64_C(0xd6e3fd25662eb35a), UINT64_C(0x58a148224857fa52), UINT64_C(0xc8d1512b831125b2), UINT64_C(0x00000002ed2efeb9) }},
  {{ UINT64_C(0xd634543add24f154), UINT64_C(0x7dbeb4ad20074c6f), UINT64_C(0x6abe6194c6026c15), UINT64_C(0x0000000280f9eed9) }},
  {{ UINT64_C(0x198c32b4ca429b2e), UINT64_C(0x2548338e4d2eda95), UINT64_C(0xc0360452a8ba6224), UINT64_C(0x000000008acb9bc9) }},
  {{ UINT64_C(0xa129855fbf2dad7e), UINT64_C(0x92752d39291d8894), UINT64_C(0x338b71093514f7ed), UINT64_C(0x000000029fabaa7e) }},
  {{ UINT64_C(0x7b9a40bfc644f2b9), UINT64_C(0xfa61dc68f11a581d), UINT64_C(0x85a399debd238196), UINT64_C(0x00000002fc22b183) }},
  {{ UINT64_C(0x30905f719e4499cb), UINT64_C(0xf32bb7b5e2ff209a), UINT64_C(0xccb2c9df93159cef), UINT64_C(0x00000003dd83b2de) }},
};

static const block_t Ri_23[] = {
  {{ UINT64_C(0x38590730b4bee1bb), UINT64_C(0xbb9a3ad3fca97405), UINT64_C(0xef6b3325e2153954), UINT64_C(0x00000000003e72c3) }},
  {{ UINT64_C(0xfc9cac6401b120ce), UINT64_C(0x4c881a88b6970564), UINT64_C(0x3725cc2ec648a275), UINT64_C(0x00000000fe9a3200) }},
  {{ UINT64_C(0xf59a3cc4104a9e11), UINT64_C(0xf59cd29c703e3444), UINT64_C(0xc80100bce4c61eb2), UINT64_C(0x0000000091203b18) }},
  {{ UINT64_C(0xf102870950642895), UINT64_C(0x5dfd534efdc4ff3d), UINT64_C(0x24d01bd620ccc231), UINT64_C(0x00000003f3ce7c41) }},
  {{ UINT64_C(0x1ba6ded3939e100d), UINT64_C(0x06a3a4fe44f1d3d7), UINT64_C(0x5597bd2fc4d02fe7), UINT64_C(0x00000000f4cf0e48) }},
  {{ UINT64_C(0x1a72a60e26d03101), UINT64_C(0x21e6ea2ad19b7083), UINT64_C(0x613f770aa63727bb), UINT64_C(0x00000002f3413252) }},
  {{ UINT64_C(0xd5d0034997edb762), UINT64_C(0x7245c97dba1604e6), UINT64_C(0x5247828262d34a5a), UINT64_C(0x000000039c7b2cf0) }},
  {{ UINT64_C(0xeadd91017e95c2d4), UINT64_C(0x95b504a522fe52ae), UINT64_C(0xf69a3f400479fe72), UINT64_C(0x00000003a465e13b) }},
  {{ UINT64_C(0xc65b9f290e639951), UINT64_C(0xfcd980f2d1f93525), UINT64_C(0x18ed6ebe98d2bcff), UINT64_C(0x00000001a4f412fa) }},
  {{ UINT64_C(0xfa3f57614b884398), UINT64_C(0x495f3f9c2d62beb6), UINT64_C(0xd47924fa19cdc919), UINT64_C(0x000000032a3ef94f) }},
  {{ UINT64_C(0x2189c3e9c6f83fb7), UINT64_C(0x36c6f95b25b184f4), UINT64_C(0x5135b16c87712983), UINT64_C(0x00000002f83a8870) }},
  {{ UINT64_C(0x9b6070d1128fb586), UINT64_C(0xa62f9e16a1cf236f), UINT64_C(0x161115585623d486), UINT64_C(0x00000001ef52c129) }},
  {{ UINT64_C(0x2d91d4c526723c59), UINT64_C(0x7672755fd9e231e4), UINT64_C(0x5241fba74f1130b9), UINT64_C(0x00000002f9771b13) }},
  {{ UINT64_C(0x3d927fd9564ede0c), UINT64_C(0x2e5ad237d3cc9ad0), UINT64_C(0x72e85a1a06649d01), UINT64_C(0x000000022958c7a5) }},
  {{ UINT64_C(0x3cf671a21fadb36c), UINT64_C(0x9a8ab596c094f1b2), UINT64_C(0xf74d4917496db49f), UINT64_C(0x0000000398783f17) }},
  {{ UINT64_C(0x064065e4633fc3fb), UINT64_C(0x6df07cad6237f2c7), UINT64_C(0xbe4f3dba3eba6c43), UINT64_C(0x00000000820c0ddf) }},
  {{ UINT64_C(0x817ad62387bcc8e5), UINT64_C(0x6d35598a703d554e), UINT64_C(0x9a447701c892dd7f), UINT64_C(0x00000000c57c75ee) }},
  {{ UINT64_C(0x74f07d96a493ce3e), UINT64_C(0xa49b4f356de4e5f3), UINT64_C(0x736679049d0c3dc4), UINT64_C(0x00000001dad10537) }},
  {{ UINT64_C(0x2fe90ddcaed28825), UINT64_C(0xdc8675cd4ce8a15f), UINT64_C(0x971f7eb0863eee6d), UINT64_C(0x000000006cbb9868) }},
  {{ UINT64_C(0x8e541f163854de4c), UINT64_C(0x17f2ac04b8a287a6), UINT64_C(0x9978137ef90b8ba1), UINT64_C(0x00000002248ef993) }},
  {{ UINT64_C(0xbf65fdb472a24b7e), UINT64_C(0x88f3fac7a887ca44), UINT64_C(0x1f0f7e7cb445ebb1), UINT64_C(0x00000003c2750ce5) }},
  {{ UINT64_C(0xdcc222b3daa81316), UINT64_C(0x8ea854a72042d290), UINT64_C(0xbb0653cec8f6c45d), UINT64_C(0x00000003afc1f45e) }},
  {{ UINT64_C(0xa163469213a4b856), UINT64_C(0xde9ead4dc6b048b1), UINT64_C(0x3d3860f6676183ed), UINT64_C(0x00000000f3007afc) }},
  {{ UINT64_C(0x7c29f0234e14f6eb), UINT64_C(0xfea3c4e88df8a90e), UINT64_C(0xac0d6f2702f6dcf1), UINT64_C(0x00000002b2cada5b) }},
  {{ UINT64_C(0xa49bdd12d941d3c4), UINT64_C(0xd0c20fb9d4d6dd91), UINT64_C(0x2574190dd72861f3), UINT64_C(0x000000032dfafefa) }},
  {{ UINT64_C(0x37b74bef10fa7a8f), UINT64_C(0x9921c3abcfceff8e), UINT64_C(0x143c16f3685c03c1), UINT64_C(0x000000023a329ff8) }},
  {{ UINT64_C(0x79eadb0ffa532506), UINT64_C(0x387a9d55394e8b3b), UINT64_C(0xd6561cb5405bd7e8), UINT64_C(0x000000020db0fcab) }},
  {{ UINT64_C(0x7e8ae97a15c8702b), UINT64_C(0x94368ea6de577639), UINT64_C(0xb4be5f0ceb1b42af), UINT64_C(0x00000000f5e74c9f) }},
  {{ UINT64_C(0xb5e84776fe1bdd9e), UINT64_C(0xe1db3b99b5225e0c), UINT64_C(0xebb9b588ff1ee636), UINT64_C(0x000000020db427dd) }},
  {{ UINT64_C(0xdcb8ed91a25deb50), UINT64_C(0x5cad2badc436d789), UINT64_C(0xca087fba4c57196a), UINT64_C(0x0000000361ededff) }},
};

static const block_t Ri_24[] = {
  {{ UINT64_C(0xc0f74e5de4242d86), UINT64_C(0xcb7ebb4a67b31d29), UINT64_C(0xc7e094dd8c81b520), UINT64_C(0x00000000aac2db78) }},
  {{ UINT64_C(0xe70eac8e8e8913c1), UINT64_C(0x2ac73c766c9e9427), UINT64_C(0x496beffaf95ba34f), UINT64_C(0x00000002fd8a7e96) }},
  {{ UINT64_C(0x52d89ae3811a4997), UINT64_C(0x846e32c140f4216f), UINT64_C(0x8b3d7d2f937051f9), UINT64_C(0x0000000048cf5c3e) }},
  {{ UINT64_C(0x282264a4de97a127), UINT64_C(0xe368554e50779d27), UINT64_C(0x53070e017cbf328e), UINT64_C(0x00000002116fe6ed) }},
  {{ UINT64_C(0xcc03e51bded7d4e2), UINT64_C(0x5301433f489f3863), UINT64_C(0x4d6006dc0b23b0f1), UINT64_C(0x00000000dfabc679) }},
  {{ UINT64_C(0xdcc200924593b939), UINT64_C(0x0f3c0299609dee83), UINT64_C(0xffc586cb2fb8b63f), UINT64_C(0x000000002ff9272d) }},
  {{ UINT64_C(0x16fc86248ac4cf49), UINT64_C(0x5dce35c3839a8b2f), UINT64_C(0x233db2922bab2d37), UINT64_C(0x000000001df2f78a) }},
  {{ UINT64_C(0x632d401fb5bcf182), UINT64_C(0x9316331157dcd93e), UINT64_C(0x140a99b3ed550cde), UINT64_C(0x00000002b5d50a29) }},
  {{ UINT64_C(0x9f4caf645aa231cc), UINT64_C(0x3128249e840fe1cb), UINT64_C(0x43070675a64881c6), UINT64_C(0x00000001880e6385) }},
  {{ UINT64_C(0xd476864e4c7cfa23), UINT64_C(0xa86854a3e558667e), UINT64_C(0x1eb5e840984327fd), UINT64_C(0x000000031dfe6016) }},
  {{ UINT64_C(0x66f06360054fdd95), UINT64_C(0x356b7572ea4c52f1), UINT64_C(0xb61ee2dccdcdacaf), UINT64_C(0x00000003ce8d2d86) }},
  {{ UINT64_C(0xbdbe2a28566241a4), UINT64_C(0xdd76c8689a836d70), UINT64_C(0xbd6e59c128d0401b), UINT64_C(0x000000020fade0d5) }},
  {{ UINT64_C(0xb7765a8f7a077ae3), UINT64_C(0x4bec18963d263657), UINT64_C(0x0f191ed0593c37c6), UINT64_C(0x000000012ed8058b) }},
  {{ UINT64_C(0x932a1257f7d95b16), UINT64_C(0x752f3095c3527f00), UINT64_C(0xb56a0b9dd044937b), UINT64_C(0x0000000140b66ed8) }},
  {{ UINT64_C(0xe524cf1b838fb13a), UINT64_C(0xe66889d2747da94e), UINT64_C(0x84788edcbffde1fc), UINT64_C(0x000000014f4c5771) }},
  {{ UINT64_C(0x2865f80b101a0e87), UINT64_C(0x1c25eee373541b7c), UINT64_C(0x014a61a1639d86b4), UINT64_C(0x00000003286ebce2) }},
  {{ UINT64_C(0x140a47cf8b400b49), UINT64_C(0x346d531ff61e2c2b), UINT64_C(0x26143eeb16dd53ff), UINT64_C(0x000000010f609fc2) }},
  {{ UINT64_C(0x5dffb64d21c12e2f), UINT64_C(0x0df9a23c54e86ed6), UINT64_C(0x4f2c692d32b05366), UINT64_C(0x00000002e6b7818b) }},
  {{ UINT64_C(0x50dc758673569fe9), UINT64_C(0x39ba6cf263d3724d), UINT64_C(0x750f61e3743bedd1), UINT64_C(0x0000000335590a4a) }},
  {{ UINT64_C(0x8099616d6b2cabd3), UINT64_C(0xcbb4c68da702dbbe), UINT64_C(0xb6dbf78861ac46d6), UINT64_C(0x00000000d442bcca) }},
  {{ UINT64_C(0x07b57c1e2b8f9152), UINT64_C(0xa326b3a40e60146d), UINT64_C(0x9a610c98e0c0b95b), UINT64_C(0x00000000ddbc1d0e) }},
  {{ UINT64_C(0x6d12d15981c2e7ee), UINT64_C(0x30e201421a6979b4), UINT64_C(0x123e543aba9b638d), UINT64_C(0x00000001379a37d2) }},
  {{ UINT64_C(0x01d62797a88d4d3f), UINT64_C(0x6805722063a3d98a), UINT64_C(0xe51feaeb64040d5a), UINT64_C(0x00000000c9afde71) }},
  {{ UINT64_C(0x99485f0fdd7bd9b7), UINT64_C(0xd3f3597c6ca39ddb), UINT64_C(0x62d3894b7fb0faa8), UINT64_C(0x0000000272d61d44) }},
  {{ UINT64_C(0xeee8cabb021100ee), UINT64_C(0xa44c49a9ca932d33), UINT64_C(0x02cbcf5219a6f6bb), UINT64_C(0x000000027357861a) }},
  {{ UINT64_C(0x525de244589c77f5), UINT64_C(0x806d61d0d406236c), UINT64_C(0xef43ac70cea366d0), UINT64_C(0x000000019ac7d207) }},
  {{ UINT64_C(0xa36533c1b2bb5c11), UINT64_C(0xfac9a918bd071b60), UINT64_C(0xb3b7a8c162f50f6f), UINT64_C(0x000000023164be75) }},
  {{ UINT64_C(0x16aedd49f7fd3219), UINT64_C(0x9fc50974235d6dac), UINT64_C(0xc3c2ebee6b7c2467), UINT64_C(0x0000000378717617) }},
  {{ UINT64_C(0x667ee9cfa71a2411), UINT64_C(0x4e4ef59b03849a60), UINT64_C(0x978c6a8df977d691), UINT64_C(0x00000002bba9f2c0) }},
  {{ UINT64_C(0xf4cac39b7e446ab9), UINT64_C(0xbd13e5d6df49acc1), UINT64_C(0xbad5554c709c2c18), UINT64_C(0x00000002b6564dad) }},
};

static const block_t Ri_25[] = {
  {{ UINT64_C(0x1038f4291a90b683), UINT64_C(0x0d323dc41c3ab0fc), UINT64_C(0xa806800bda8ce308), UINT64_C(0x000000007991cd89) }},
  {{ UINT64_C(0x0df7f60a0e705454), UINT64_C(0xc7468efa6f103c13), UINT64_C(0x8f9913b9472b8a00), UINT64_C(0x000000005ca417d1) }},
  {{ UINT64_C(0x49ae518c2280ef8a), UINT64_C(0x1f57bd3c17a8fc3f), UINT64_C(0xca22f32d97208a42), UINT64_C(0x00000003f8d1f54e) }},
  {{ UINT64_C(0xd0ab0374a21271fd), UINT64_C(0xcd14ec5005662b4b), UINT64_C(0x817e58b786ed605f), UINT64_C(0x00000001d5e634b7) }},
  {{ UINT64_C(0x10ae811796f74869), UINT64_C(0x2ec35dd7093f88d9), UINT64_C(0xa18561fbcf83ee8f), UINT64_C(0x00000000b32187b7) }},
  {{ UINT64_C(0xe0e99350f01e0252), UINT64_C(0x4913ca9d2d3b5d3e), UINT64_C(0x1a0436867aaebc71), UINT64_C(0x0000000170900061) }},
  {{ UINT64_C(0x449a5eb879e6642a), UINT64_C(0x555c0855084bad03), UINT64_C(0x8ec55cbe6f17db7e), UINT64_C(0x00000003f3118e7d) }},
  {{ UINT64_C(0xcd902964c8f905af), UINT64_C(0x77fa0d593c2c1e23), UINT64_C(0xd4e007a8f20eb0d3), UINT64_C(0x0000000333282b0a) }},
  {{ UINT64_C(0xcb757aeef9c8ad26), UINT64_C(0x999febe784e126b2), UINT64_C(0x0721abf4377c0269), UINT64_C(0x0000000121ca5502) }},
  {{ UINT64_C(0x0de335578ffa1e7b), UINT64_C(0x90799725af92afe7), UINT64_C(0x6d39ba6472e2b9cb), UINT64_C(0x00000002e1b2524d) }},
  {{ UINT64_C(0x5b0f4967ef0117db), UINT64_C(0x7ab9bd82cbe06899), UINT64_C(0x3b3440efef7d9b6d), UINT64_C(0x000000006f909056) }},
  {{ UINT64_C(0xdd9dec697f92cad3), UINT64_C(0xfe57a0c4674da368), UINT64_C(0xdd93c640222cc347), UINT64_C(0x00000003d8f717b0) }},
  {{ UINT64_C(0x3b183fbad7b285a0), UINT64_C(0xcfbea52b90fc4714), UINT64_C(0x2976501e6114f09c), UINT64_C(0x000000006dffc7db) }},
  {{ UINT64_C(0xda4b530f945066f3), UINT64_C(0x43c4c8a34ceb4174), UINT64_C(0xe4e73e9ff1d27457), UINT64_C(0x0000000253b1bc8a) }},
  {{ UINT64_C(0x9e8fdd7bb31b2342), UINT64_C(0x388bee7a7082c56f), UINT64_C(0xb770b5338d9f9bca), UINT64_C(0x000000018f867192) }},
  {{ UINT64_C(0x3d28715fe34fc85c), UINT64_C(0x2ab38b160f195cdd), UINT64_C(0x4193dfc9490cb1a3), UINT64_C(0x00000001b3d0fac3) }},
  {{ UINT64_C(0xdb8bfd4d16176bf8), UINT64_C(0x3539b3e81d8e1d10), UINT64_C(0xfe17bc11ac09ebc6), UINT64_C(0x00000003bc1b5499) }},
  {{ UINT64_C(0x58087ca609cc5820), UINT64_C(0xff8ae1a94a8c53e3), UINT64_C(0x6e9afcfde4394134), UINT64_C(0x00000000219e1f08) }},
  {{ UINT64_C(0xeb3a0dbc671daa79), UINT64_C(0x64e9da6e1c5941de), UINT64_C(0x23a00df8d6aa3947), UINT64_C(0x00000003e09493da) }},
  {{ UINT64_C(0xc114b26ac07f3f4f), UINT64_C(0x2a0a61466028ff59), UINT64_C(0xaefacf79625ea667), UINT64_C(0x00000002c743dd9a) }},
  {{ UINT64_C(0x4d1ed8d651953dce), UINT64_C(0xf995157c377f8880), UINT64_C(0xba26b7104e42577d), UINT64_C(0x00000001168bfee3) }},
  {{ UINT64_C(0x2da50dc06da4b419), UINT64_C(0x25c7650a3d51ae72), UINT64_C(0x6151256784c8d402), UINT64_C(0x00000001fd049f14) }},
  {{ UINT64_C(0xa44fb4123fe25141), UINT64_C(0xbd583e8f3339c05d), UINT64_C(0x7baef91af59e4698), UINT64_C(0x00000001007219b0) }},
  {{ UINT64_C(0xb4597738181ba6aa), UINT64_C(0x49a2c37849adadc5), UINT64_C(0x467f7d429ac657b9), UINT64_C(0x0000000002921c31) }},
  {{ UINT64_C(0x801bef7461d8c1bd), UINT64_C(0x48efb0150ee73e34), UINT64_C(0xc2dcedd0eaacebce), UINT64_C(0x0000000118de0f27) }},
  {{ UINT64_C(0xbfef0749ee54a779), UINT64_C(0xc58f8107e5414fea), UINT64_C(0xf8ceead2628abe60), UINT64_C(0x00000003d5df23f2) }},
  {{ UINT64_C(0x10a2ea3be81651a7), UINT64_C(0x87d3d12482498073), UINT64_C(0x5ca79fa57086ace0), UINT64_C(0x00000000da720338) }},
  {{ UINT64_C(0x95374727ca59414a), UINT64_C(0x4ca3075e1ecfc9bb), UINT64_C(0xa22197c91fbedb83), UINT64_C(0x000000018f8b8e0d) }},
  {{ UINT64_C(0xfd9f0adb2b113713), UINT64_C(0x28450d7ff0d4ab53), UINT64_C(0xa57685594d421e0c), UINT64_C(0x00000000d2e218b5) }},
  {{ UINT64_C(0x5fd74e22e3f23f81), UINT64_C(0xd86163497afa1381), UINT64_C(0x1f8d1578f9c2e8b7), UINT64_C(0x0000000313dc6fbd) }},
};

static const block_t Ri_26[] = {
  {{ UINT64_C(0x8fedaf7ebf4b912a), UINT64_C(0xc28790818b398249), UINT64_C(0x7d8666f6583d6fe5), UINT64_C(0x000000016d17e5c5) }},
  {{ UINT64_C(0xfbec0a80151dd8fd), UINT64_C(0xd4165f59307f494f), UINT64_C(0x484aeff6607cac7c), UINT64_C(0x000000004bb83d7f) }},
  {{ UINT64_C(0x8b00451a32df1781), UINT64_C(0x68a044f353bf39ac), UINT64_C(0x003e778cb8bffc0f), UINT64_C(0x00000000d145edbf) }},
  {{ UINT64_C(0xb94d4f4e651b9891), UINT64_C(0xd12c2714bc996eaa), UINT64_C(0x8803449d259d9db0), UINT64_C(0x000000023f88c35e) }},
  {{ UINT64_C(0xdb29c3a177f4d8e7), UINT64_C(0x126f1f52d0bbda51), UINT64_C(0x608055e1e0fd6aaf), UINT64_C(0x00000002cb005161) }},
  {{ UINT64_C(0x4505af46129e3b70), UINT64_C(0xc993ffeb89047767), UINT64_C(0x46dddb83ec2e8fb9), UINT64_C(0x00000000aeb512d9) }},
  {{ UINT64_C(0x496fb20d8c24b5cf), UINT64_C(0x8b3d67ad119acd4b), UINT64_C(0x22c4f8f6ff065c30), UINT64_C(0x0000000137d4bd36) }},
  {{ UINT64_C(0x672e44e44bd6ce52), UINT64_C(0x543dc24a492ad8a7), UINT64_C(0x4cdf778d91fa222d), UINT64_C(0x00000000f62142fa) }},
  {{ UINT64_C(0x5491fe8fe10d29ff), UINT64_C(0x23af56c886afd8a9), UINT64_C(0x55f90cb3216e92b9), UINT64_C(0x00000002cdf28261) }},
  {{ UINT64_C(0xd4411dcf0e3ae3bb), UINT64_C(0x61b0b219c94c9e54), UINT64_C(0x114201274e9e8aca), UINT64_C(0x000000015077eb07) }},
  {{ UINT64_C(0x519e31a65eb09250), UINT64_C(0xf0e9bc46db86c49e), UINT64_C(0xbc0f01f97b6ca1e8), UINT64_C(0x0000000055ca1224) }},
  {{ UINT64_C(0x66c990f4cd808812), UINT64_C(0x6f2fd02d651b25ed), UINT64_C(0x5a4a1f7c48201c11), UINT64_C(0x0000000105611a21) }},
  {{ UINT64_C(0x8dc9e9b18e4ba727), UINT64_C(0x06f59891a756fd86), UINT64_C(0x908d393168fb18ea), UINT64_C(0x000000029060a97a) }},
  {{ UINT64_C(0xf0fcb56cba11ad6d), UINT64_C(0x1ce10452df905a35), UINT64_C(0xff006be44657f4da), UINT64_C(0x00000000e6e278f8) }},
  {{ UINT64_C(0xd3cda70fccc4d268), UINT64_C(0x2148bce196bd2394), UINT64_C(0x6af3e75327bfea1f), UINT64_C(0x000000010f2e1c36) }},
  {{ UINT64_C(0x543d5536d8bae9fd), UINT64_C(0x30ad21bf3b2b184b), UINT64_C(0x041cd8b5244cb26c), UINT64_C(0x0000000076d013a0) }},
  {{ UINT64_C(0x050f13cb2fc6af06), UINT64_C(0x505210cb0063f409), UINT64_C(0x94e8cf6242071d74), UINT64_C(0x00000001f366b8f3) }},
  {{ UINT64_C(0x61c31fee3048f3a4), UINT64_C(0xd25b63254aa2d051), UINT64_C(0xa0729cffe16afd13), UINT64_C(0x000000021210d97d) }},
  {{ UINT64_C(0x8cb243c2c7edf679), UINT64_C(0xd276ce08053c034a), UINT64_C(0x2ac70b198f3cafde), UINT64_C(0x0000000152903760) }},
  {{ UINT64_C(0x26c404690941a12c), UINT64_C(0x10f8af1a268bc989), UINT64_C(0xe5f8ed5e8b09bc85), UINT64_C(0x000000000e419574) }},
  {{ UINT64_C(0x26d9eb62d81c7c71), UINT64_C(0xb00ba2b6a545964e), UINT64_C(0x1693150477755ccb), UINT64_C(0x000000006e9906a0) }},
  {{ UINT64_C(0x121004c4686cb021), UINT64_C(0x31e55e6b74fdd8fd), UINT64_C(0x2fd7eeeb765ba13c), UINT64_C(0x000000039508250a) }},
  {{ UINT64_C(0x1ee036a1693fd1ee), UINT64_C(0x024472f0e0e6f79b), UINT64_C(0x10277d194ebd3bf6), UINT64_C(0x0000000285725ede) }},
  {{ UINT64_C(0xbe784db772d61518), UINT64_C(0x90c950fd50eaa2b7), UINT64_C(0x700b22e2dd9c40ef), UINT64_C(0x000000020bb4bdad) }},
  {{ UINT64_C(0x02b296996c6e8e9d), UINT64_C(0xc1235327e2db3aa3), UINT64_C(0xbe3555ed681a2df4), UINT64_C(0x000000021b77ddf4) }},
  {{ UINT64_C(0x2a6b3f6b45060f63), UINT64_C(0x2fc4af202b9fea18), UINT64_C(0x4d9bdd2ff969f326), UINT64_C(0x00000003d1cb1367) }},
  {{ UINT64_C(0xa2e28c1add8a9144), UINT64_C(0x50c61d7211e739c8), UINT64_C(0x1dc37d53bca01712), UINT64_C(0x000000037df9e658) }},
  {{ UINT64_C(0xcf3f907ae16b5615), UINT64_C(0x4ef3af307985627f), UINT64_C(0x5f8347a5a07f9364), UINT64_C(0x0000000009685880) }},
  {{ UINT64_C(0x1d9125647f8ba2e1), UINT64_C(0x88bee827e518416b), UINT64_C(0x345d4187094c6496), UINT64_C(0x000000031c296ae3) }},
  {{ UINT64_C(0x269ebb93c7f19496), UINT64_C(0x00b4e76b17df3bf3), UINT64_C(0x53e5d3ccf5a88b61), UINT64_C(0x000000001422970b) }},
};

static const block_t Ri_27[] = {
  {{ UINT64_C(0x6e790e5ad97d1692), UINT64_C(0x1b90647a2684a7c1), UINT64_C(0x345426b43b767d7f), UINT64_C(0x00000000bb2e2849) }},
  {{ UINT64_C(0xb323cf0f162762d6), UINT64_C(0xcd40e4f51dfe1032), UINT64_C(0x8e067695ae2bfae0), UINT64_C(0x0000000244e79a5c) }},
  {{ UINT64_C(0x2a2899f5247350fb), UINT64_C(0xbdc83e2f546ffa0f), UINT64_C(0xca27815ee4739854), UINT64_C(0x000000012f214c1c) }},
  {{ UINT64_C(0x771c3af5e0afccc9), UINT64_C(0x4ca4e2ed6f515551), UINT64_C(0x727366395c5b1b18), UINT64_C(0x00000002485b2fa8) }},
  {{ UINT64_C(0x0fd49badfceee868), UINT64_C(0xe6d50edfede6058a), UINT64_C(0xda102edff6e78d19), UINT64_C(0x00000003bb2d3c8a) }},
  {{ UINT64_C(0x1b25c98356a600f2), UINT64_C(0x2e2004e030e14722), UINT64_C(0xab49956656255762), UINT64_C(0x00000000e88f1bcc) }},
  {{ UINT64_C(0x99e84c31bcffe104), UINT64_C(0x02158592435d5237), UINT64_C(0x95ffd9d10e2640b6), UINT64_C(0x00000002dceaeded) }},
  {{ UINT64_C(0x602cf666c591d67d), UINT64_C(0x7b3fcb3d1efd7642), UINT64_C(0xc927b8cd917bb2a3), UINT64_C(0x00000003c42c467c) }},
  {{ UINT64_C(0x7b39eb9265865c8f), UINT64_C(0x1c52f2da1c9ac622), UINT64_C(0x680f0c81d2fe2278), UINT64_C(0x0000000146d18a82) }},
  {{ UINT64_C(0x7fc73065b2962f49), UINT64_C(0x97cc5338e56a3c33), UINT64_C(0xc58dee1172c63d36), UINT64_C(0x00000002892c5991) }},
  {{ UINT64_C(0x22efe4b47cf6b7b4), UINT64_C(0x5349c7af93370ada), UINT64_C(0x30198509a850f463), UINT64_C(0x00000002558ea5c4) }},
  {{ UINT64_C(0x02e5e0c4ca6349b3), UINT64_C(0xb86ed2ee415ea0e5), UINT64_C(0xa1ca1ddbba8423e4), UINT64_C(0x00000002c098010c) }},
  {{ UINT64_C(0x3d68041f3c878be6), UINT64_C(0xf1b7b1574f757ac2), UINT64_C(0xe737212507dba18c), UINT64_C(0x00000002b17f162f) }},
  {{ UINT64_C(0x44406eec3857e5ca), UINT64_C(0x9171cd05fe098d4c), UINT64_C(0x4d8c01be12cf59de), UINT64_C(0x000000032b4f0224) }},
  {{ UINT64_C(0x6f083c91fba70452), UINT64_C(0xcdc1b8fa1571fca0), UINT64_C(0xb42036dac9bd4503), UINT64_C(0x000000016217f029) }},
  {{ UINT64_C(0x6f9462b38338eef7), UINT64_C(0xffaf98164bff439b), UINT64_C(0x026b7c1f4ee94e02), UINT64_C(0x0000000288744265) }},
  {{ UINT64_C(0x503ed12dd5d5bec7), UINT64_C(0x84b1a1c77feb1f1f), UINT64_C(0x149e21f407753afc), UINT64_C(0x000000038203b1e8) }},
  {{ UINT64_C(0x0ca42ec7a102f66e), UINT64_C(0x76d7ba34555582ec), UINT64_C(0xec446661c8aa5beb), UINT64_C(0x000000019c3f5d07) }},
  {{ UINT64_C(0xa5d4ac58f2ad4d07), UINT64_C(0xc54b7c32d9bb66f6), UINT64_C(0x93c31152e50139a2), UINT64_C(0x00000002030f01a8) }},
  {{ UINT64_C(0xd6760f25e04f0455), UINT64_C(0xd24d6b0295a311d9), UINT64_C(0xe2a63a85ec3d880e), UINT64_C(0x00000001afdf966a) }},
  {{ UINT64_C(0x10044f97547ddf16), UINT64_C(0xa073a2e8d354f264), UINT64_C(0x6e5fb31c9aca1e91), UINT64_C(0x00000000ea731242) }},
  {{ UINT64_C(0x7d12ccee3918cc2a), UINT64_C(0x5506bafbd2cf70f1), UINT64_C(0xf1ac40f23ccb573b), UINT64_C(0x00000003c19e646a) }},
  {{ UINT64_C(0x29d3201674342215), UINT64_C(0x609c06a36a619025), UINT64_C(0x11955b2b190a62c6), UINT64_C(0x000000038194a63a) }},
  {{ UINT64_C(0xcbd64cea9e698363), UINT64_C(0x3b06881b6c7a6c91), UINT64_C(0xb03d81fe7d1a936b), UINT64_C(0x00000003fbbdcd72) }},
  {{ UINT64_C(0x8b4e51481e8f5b39), UINT64_C(0x18211cc51fe384c1), UINT64_C(0x1ee09ebbaa29fa93), UINT64_C(0x00000001559e63c0) }},
  {{ UINT64_C(0xf66d790c017f23ed), UINT64_C(0x0542068824ac6f11), UINT64_C(0x2c6c0906eb46bf4e), UINT64_C(0x00000000d8d34ed5) }},
  {{ UINT64_C(0xe1c2e7f6e58e0a0c), UINT64_C(0x437a4b7f65785eb1), UINT64_C(0x0419b2b6136031d5), UINT64_C(0x0000000035de4ba4) }},
  {{ UINT64_C(0xaca322e41fdcf1d2), UINT64_C(0x781a8904507c66c8), UINT64_C(0xcc35bc53027dfac9), UINT64_C(0x00000003b739276e) }},
  {{ UINT64_C(0x81968c9a541c7227), UINT64_C(0xb5bf5c77a94a0a52), UINT64_C(0xfd38ef788befc73b), UINT64_C(0x00000000f20018b4) }},
  {{ UINT64_C(0x732847aea7b6f700), UINT64_C(0xb9f2a7c5840bcc21), UINT64_C(0x102644d5e984d729), UINT64_C(0x00000001dc7862e3) }},
};

static const block_t Ri_28[] = {
  {{ UINT64_C(0x66b85c8730382411), UINT64_C(0x7e1e889f1e30db98), UINT64_C(0x323bc8bd4db26274), UINT64_C(0x00000002a57f6119) }},
  {{ UINT64_C(0x963a53ee91cf503a), UINT64_C(0x69715321ed66d8fa), UINT64_C(0xc0114d4982926e4c), UINT64_C(0x000000029aae0cc9) }},
  {{ UINT64_C(0xf329b61b3411783b), UINT64_C(0xe0e11021c2423445), UINT64_C(0xadca8546b60e4b54), UINT64_C(0x00000003bd1a73ea) }},
  {{ UINT64_C(0x1a586c514b45d046), UINT64_C(0x46989d4aef5f6d49), UINT64_C(0x07c83b66ed3697a1), UINT64_C(0x0000000245a2d292) }},
  {{ UINT64_C(0xda7c680a8f75b673), UINT64_C(0xd5da96b01f4b9491), UINT64_C(0xa121d266fbd7c07f), UINT64_C(0x000000015fba5efb) }},
  {{ UINT64_C(0x48a763d41544303b), UINT64_C(0xcd07d0b7a6347d54), UINT64_C(0x64c95c3602570721), UINT64_C(0x0000000132a0d3b5) }},
  {{ UINT64_C(0x4e1ba457e0b8538b), UINT64_C(0x4bf855a6eca92951), UINT64_C(0x15d7bae201d697f1), UINT64_C(0x0000000318869c45) }},
  {{ UINT64_C(0x9e626c17bb26a7ac), UINT64_C(0x1b9bb5bfc749bf21), UINT64_C(0x3a4ce7ac6df36d13), UINT64_C(0x00000001512e966b) }},
  {{ UINT64_C(0xc01564d478912212), UINT64_C(0x9e095269812d5214), UINT64_C(0x64f73a43177a3aae), UINT64_C(0x000000007ed86093) }},
  {{ UINT64_C(0x2813ab046a4c0db9), UINT64_C(0x52746076f1ecc20d), UINT64_C(0x036d17d68568aa8a), UINT64_C(0x000000017c9b6d9d) }},
  {{ UINT64_C(0x118e09da4e52e6ef), UINT64_C(0x482a0d1467d8b177), UINT64_C(0xbe2a799acd149289), UINT64_C(0x00000002b1b62ead) }},
  {{ UINT64_C(0x8c1c41edc8db0a72), UINT64_C(0xb9ea49725d5c1efd), UINT64_C(0xe618ef46984901bb), UINT64_C(0x00000002c4d84a05) }},
  {{ UINT64_C(0x042fe5cb889ea7bc), UINT64_C(0xcbd3270faa195092), UINT64_C(0xf4d900af424d69c1), UINT64_C(0x0000000029642e20) }},
  {{ UINT64_C(0xa541a785491e16b3), UINT64_C(0x1b43e1f355f1a43f), UINT64_C(0x4f0b15824ebfd273), UINT64_C(0x00000001de1c848f) }},
  {{ UINT64_C(0xbec9be0d901c825a), UINT64_C(0x6a9a9565c6875b18), UINT64_C(0x4cef4f595c758a64), UINT64_C(0x0000000314d1bfa3) }},
  {{ UINT64_C(0x85cf15a474d581d2), UINT64_C(0x9e827416f53a03ea), UINT64_C(0xd1261ab596140d93), UINT64_C(0x000000008bb0d6d1) }},
  {{ UINT64_C(0x5f8ec7d688f841f2), UINT64_C(0x2112127ce3d39adb), UINT64_C(0xcd1b6778b1ee422a), UINT64_C(0x000000025d1eb322) }},
  {{ UINT64_C(0xa554189d6ff129d7), UINT64_C(0xabe881018c649a0d), UINT64_C(0xcb22eb4fb1ed2195), UINT64_C(0x00000003d76e3437) }},
  {{ UINT64_C(0x71a8b56e86902449), UINT64_C(0x8e2d567ce35a49c0), UINT64_C(0x797458d44654ce67), UINT64_C(0x00000002e07deaf3) }},
  {{ UINT64_C(0x38473ce8a166af35), UINT64_C(0xffd1d8e7c346dc41), UINT64_C(0x132360c5610283cb), UINT64_C(0x00000000b3e0f03f) }},
  {{ UINT64_C(0x902e7f5092e13553), UINT64_C(0x59adf73a6ff90bee), UINT64_C(0x171d6553383ff6d8), UINT64_C(0x000000009e2b749d) }},
  {{ UINT64_C(0xa358b0fbed906cee), UINT64_C(0xe79935d376d91f35), UINT64_C(0x63dbc3e78cf944f6), UINT64_C(0x0000000204af138a) }},
  {{ UINT64_C(0x303ffea4b48eba29), UINT64_C(0xc6b25ebb34e3d72d), UINT64_C(0x23f2ec7d66d9cd3e), UINT64_C(0x000000029db1a32a) }},
  {{ UINT64_C(0xcc01294c3a38fe0c), UINT64_C(0x1f547337123731ef), UINT64_C(0x4121eced0d251190), UINT64_C(0x000000037982ff11) }},
  {{ UINT64_C(0x4959b7c4b0a0bbaa), UINT64_C(0x837e607870fcf05c), UINT64_C(0xe46225c01312043d), UINT64_C(0x00000003533c270a) }},
  {{ UINT64_C(0xefb2d8657442d8fc), UINT64_C(0x42372ab3c090b265), UINT64_C(0xb414672831576816), UINT64_C(0x000000023c2526b2) }},
  {{ UINT64_C(0x1ead01469d971939), UINT64_C(0x5f1bb4678816fec9), UINT64_C(0xb572d82e64d66397), UINT64_C(0x00000001097eba0e) }},
  {{ UINT64_C(0x37ea1f1305de1ecf), UINT64_C(0xa598a0a90cad78d3), UINT64_C(0x886ac8a3816f39a1), UINT64_C(0x000000027d449582) }},
  {{ UINT64_C(0xca46e70c0ef2ab1a), UINT64_C(0x37828334476fda44), UINT64_C(0xbdf341b42faf1167), UINT64_C(0x00000002f88e9324) }},
  {{ UINT64_C(0x3182f5179c01e354), UINT64_C(0x13d5254c67902048), UINT64_C(0xeac14871d89ecfd0), UINT64_C(0x00000002c02120fe) }},
};

static const block_t Ri_29[] = {
  {{ UINT64_C(0x1bfbc13f97ffb722), UINT64_C(0xdd968492a10e1221), UINT64_C(0xb9f78fec44921c15), UINT64_C(0x0000000066567470) }},
  {{ UINT64_C(0x71db5e59cb704935), UINT64_C(0x6ea21749b087435b), UINT64_C(0x0ad963240c94aad1), UINT64_C(0x00000000a4da5123) }},
  {{ UINT64_C(0xb420057e136198f8), UINT64_C(0x3463ab7d59f3a0d4), UINT64_C(0x63c476f9681926a3), UINT64_C(0x0000000068bb4393) }},
  {{ UINT64_C(0xdccf9ceaf5f861af), UINT64_C(0x10e3c86a9596221b), UINT64_C(0x35302640fffa9372), UINT64_C(0x00000000db1c230c) }},
  {{ UINT64_C(0x159ebe4cf198a10f), UINT64_C(0xade96180addf8fee), UINT64_C(0x1f42e9ba14df328f), UINT64_C(0x00000001da4dfff1) }},
  {{ UINT64_C(0x2a4d3f70f78a725b), UINT64_C(0x88ac8b5feecef5ac), UINT64_C(0x15a6de04e6c6c932), UINT64_C(0x00000000aa3976e5) }},
  {{ UINT64_C(0x04e0be892a9d823b), UINT64_C(0x828a0e6ae3b6f227), UINT64_C(0x59642919bd0feb97), UINT64_C(0x000000029b2c91cc) }},
  {{ UINT64_C(0x6846293471698646), UINT64_C(0x31b76b107fdcfd22), UINT64_C(0x48583c38b202f1d6), UINT64_C(0x00000001707f79b1) }},
  {{ UINT64_C(0x2fc5eb3cb102bdb7), UINT64_C(0x79446e6caad54230), UINT64_C(0xab886cbb784f87d9), UINT64_C(0x000000032bfffed4) }},
  {{ UINT64_C(0x92e7c5a3ca90ab5c), UINT64_C(0xddc0ad3b95c81517), UINT64_C(0x34507083fde006c1), UINT64_C(0x0000000266cdeca3) }},
  {{ UINT64_C(0xf32c51a6a5861c09), UINT64_C(0x711684f87dcadc99), UINT64_C(0x0bbcffd1567d0ba4), UINT64_C(0x0000000137e1bab7) }},
  {{ UINT64_C(0x87741b0a3ff0f3c0), UINT64_C(0x563a2714ecca2f3a), UINT64_C(0x91bd2ea237276042), UINT64_C(0x000000002404e9c8) }},
  {{ UINT64_C(0x0448f71fb73d1a57), UINT64_C(0xe92d37bf3a5a313d), UINT64_C(0x4543b2e785169418), UINT64_C(0x000000002739d4b9) }},
  {{ UINT64_C(0xead40d22c3753f77), UINT64_C(0xbb4f142b90048abd), UINT64_C(0xa173b61da7c70635), UINT64_C(0x00000002e25a618d) }},
  {{ UINT64_C(0xe97c7fa5938502e1), UINT64_C(0x6f7c148bfbc78740), UINT64_C(0x269fc4e21f3af7da), UINT64_C(0x00000002bc6baa1f) }},
  {{ UINT64_C(0xf67d27f0af170948), UINT64_C(0x71afd73c0c577069), UINT64_C(0x76e152cd5189d4ca), UINT64_C(0x000000038b724c61) }},
  {{ UINT64_C(0xcbd7c5138748963f), UINT64_C(0xb5f8aef95c58e5e8), UINT64_C(0x3b694d91c3ec1b66), UINT64_C(0x000000036f867316) }},
  {{ UINT64_C(0xf9fdefa4fe9c9126), UINT64_C(0x2f17f7ca8fdd0915), UINT64_C(0xd0d1537740a700fa), UINT64_C(0x000000014b309e2c) }},
  {{ UINT64_C(0xc53a3d0a368eb488), UINT64_C(0xa8489f5ee863ade2), UINT64_C(0x747a9ca716b838e6), UINT64_C(0x000000031f160aaf) }},
  {{ UINT64_C(0x1059232ddcdbc5fa), UINT64_C(0xb5be495fd6c1917a), UINT64_C(0x1c95a3557fba5a64), UINT64_C(0x00000003c48f7117) }},
  {{ UINT64_C(0x0bb3b3dfdd56168d), UINT64_C(0xcbd1f4e4e2dc294a), UINT64_C(0x6b39be99015cf8a6), UINT64_C(0x00000000c99b6104) }},
  {{ UINT64_C(0x58fa4879a8340d04), UINT64_C(0x71bdfe953a560678), UINT64_C(0x46f07c8dadb6604f), UINT64_C(0x0000000385f83465) }},
  {{ UINT64_C(0x2b943204bd1cef25), UINT64_C(0xc26803610ddba9f7), UINT64_C(0x711607990013da8b), UINT64_C(0x0000000159b48a1f) }},
  {{ UINT64_C(0x7b9c12364d82e960), UINT64_C(0xb6a438fa4b5b5a5c), UINT64_C(0x83ae022e7ffd1504), UINT64_C(0x00000000770f2568) }},
  {{ UINT64_C(0x2da5647529735189), UINT64_C(0xa47580b44cddef76), UINT64_C(0x36e8730b2c55d314), UINT64_C(0x000000006c614f1f) }},
  {{ UINT64_C(0x9711c6c18f4d62bf), UINT64_C(0x367faa172a53ccc8), UINT64_C(0x67516b1009569fb5), UINT64_C(0x000000039f1271d7) }},
  {{ UINT64_C(0x8eb28a7fdbd2fbde), UINT64_C(0x5cb1d99f23b9da5f), UINT64_C(0x99909d6ab910b989), UINT64_C(0x000000011e5ad71e) }},
  {{ UINT64_C(0x8c357818a3e85db8), UINT64_C(0x662c52c836b0e1ae), UINT64_C(0x34fe7a8457ac9534), UINT64_C(0x0000000248b7c25a) }},
  {{ UINT64_C(0xfdb7b747fa21740f), UINT64_C(0xa2283b97008c1b1e), UINT64_C(0xcd7f3fb9a4175897), UINT64_C(0x00000001f9564220) }},
  {{ UINT64_C(0xf43f6fa09ad36a04), UINT64_C(0x75af852a43512e99), UINT64_C(0x617a15f9149f48b5), UINT64_C(0x000000012228aafb) }},
};

static const block_t Ri_30[] = {
  {{ UINT64_C(0x1437ad1b97372e68), UINT64_C(0x0e076542eab2a451), UINT64_C(0x040c7206b21d135d), UINT64_C(0x000000007c353692) }},
  {{ UINT64_C(0x755b87a0f6ee7bdb), UINT64_C(0xef30941f04fb6bd7), UINT64_C(0x27663c2a77a2a08f), UINT64_C(0x00000001e61d0508) }},
  {{ UINT64_C(0xf2ae223a6e884463), UINT64_C(0x715370e06af68ae1), UINT64_C(0x6a75a7a5c1d1060c), UINT64_C(0x00000003b2c9b78c) }},
  {{ UINT64_C(0x4e7d35471c0a7cc9), UINT64_C(0xf9aaffcbba9143ac), UINT64_C(0x94e29fbdb2013b7e), UINT64_C(0x0000000142bd63c8) }},
  {{ UINT64_C(0xab8a825935f14b3f), UINT64_C(0x1354bf212e501511), UINT64_C(0x9858258b29a605b4), UINT64_C(0x0000000387a5b0aa) }},
  {{ UINT64_C(0x4af369b7174d6d36), UINT64_C(0xe34937c7beb91793), UINT64_C(0x6e327cfaab6b20ba), UINT64_C(0x0000000356a78970) }},
  {{ UINT64_C(0xff6fcb29d1b0e9cb), UINT64_C(0x608ad72068342b03), UINT64_C(0xcb93d0188d86277f), UINT64_C(0x00000002b4b56515) }},
  {{ UINT64_C(0x12f651d450bed51d), UINT64_C(0x7fe102ac26a25098), UINT64_C(0xf0e38bbb88437a1e), UINT64_C(0x000000012ae9ff35) }},
  {{ UINT64_C(0x9d06fedebb7cbf06), UINT64_C(0x97b891bd2c1e241a), UINT64_C(0xf9d6aec99cc62cba), UINT64_C(0x000000038b7fa626) }},
  {{ UINT64_C(0xd94d0aaf2bbc2573), UINT64_C(0x53049db1bc66f73b), UINT64_C(0x09fc1a7238455b4c), UINT64_C(0x000000034b74ceed) }},
  {{ UINT64_C(0x5090a492813f5c19), UINT64_C(0x50c9122021862419), UINT64_C(0x56378f5b38584992), UINT64_C(0x000000000c39523d) }},
  {{ UINT64_C(0xc96c77221b44fa1c), UINT64_C(0x33f953c5058e3ea5), UINT64_C(0xde8c1489e1c14688), UINT64_C(0x0000000284c4a6a5) }},
  {{ UINT64_C(0x68349e6acb671d5a), UINT64_C(0x4c79363155e3dee7), UINT64_C(0x4708db4bb789cfe2), UINT64_C(0x00000001ab9d1e71) }},
  {{ UINT64_C(0xc9bf0bf5513c1847), UINT64_C(0x6e297b4b1fb966d4), UINT64_C(0x603fb41976871a5b), UINT64_C(0x000000006a21d9d5) }},
  {{ UINT64_C(0x8c41ce04b763be7b), UINT64_C(0x6c2cf652edcc8ae8), UINT64_C(0xec1d1493fa2abf65), UINT64_C(0x00000003468d17c9) }},
  {{ UINT64_C(0xd2d26177b8d7693d), UINT64_C(0xf27e4b967f0b736b), UINT64_C(0x3713ca7e4b87de2a), UINT64_C(0x00000000dd6ca08a) }},
  {{ UINT64_C(0x7abe0919c3bde51a), UINT64_C(0x0b8f66bfce9e13cc), UINT64_C(0xa0c53cb15b709822), UINT64_C(0x000000021873fea8) }},
  {{ UINT64_C(0x0aaf48ba694f7aa1), UINT64_C(0xca3ece1c1bc2c327), UINT64_C(0x6b44cfba0122b64d), UINT64_C(0x00000000dfd6dfcc) }},
  {{ UINT64_C(0x6b2e5d6bfa0d68ac), UINT64_C(0xa6139d3bf7115835), UINT64_C(0xa144c083043a9674), UINT64_C(0x000000007e067f72) }},
  {{ UINT64_C(0x15925f08d38a1a6d), UINT64_C(0x831ebb3685ee839f), UINT64_C(0xa546bb538d906311), UINT64_C(0x00000003d1d49010) }},
  {{ UINT64_C(0x4967b630068f960b), UINT64_C(0x34ccd4ac7dc65020), UINT64_C(0x10c268da695edf27), UINT64_C(0x00000001d348a106) }},
  {{ UINT64_C(0xd8393894faaf95fa), UINT64_C(0x17e748640a607875), UINT64_C(0x74b0bf4d96a08dd3), UINT64_C(0x00000000fb79c256) }},
  {{ UINT64_C(0x8406e7faf5ce93ad), UINT64_C(0x73f920a3ac71f71b), UINT64_C(0x2481971e75267970), UINT64_C(0x000000002f966e18) }},
  {{ UINT64_C(0xbb2c53a87a618bf8), UINT64_C(0xaabe120594586e00), UINT64_C(0x2b3e6af7e2c4e434), UINT64_C(0x000000021219a87d) }},
  {{ UINT64_C(0xd01dce2df7b64ef0), UINT64_C(0xe01bd1ebbf05b4c5), UINT64_C(0xfb2653994f141d95), UINT64_C(0x0000000221584c4b) }},
  {{ UINT64_C(0x282035b8161c6194), UINT64_C(0xc7280334b676f1be), UINT64_C(0xd6f581a7635312be), UINT64_C(0x000000008e9d057d) }},
  {{ UINT64_C(0xc4e7d091a7e5ba72), UINT64_C(0xa7cfccbb718a5968), UINT64_C(0xaae0e73e1319e9e5), UINT64_C(0x00000002c54c794d) }},
  {{ UINT64_C(0x2f8d2297dad5ec09), UINT64_C(0x5b1f8977e85e87ba), UINT64_C(0xaa82691e2bb2bffb), UINT64_C(0x000000001145e973) }},
  {{ UINT64_C(0xa45ebecfa956f544), UINT64_C(0xb21c7d3d52a5576b), UINT64_C(0x9c71e99c800d19cb), UINT64_C(0x00000000242bc37b) }},
  {{ UINT64_C(0x9cc4826931d4dadd), UINT64_C(0x6c1f4b706c3a5a11), UINT64_C(0x8e3446c4d7d47037), UINT64_C(0x00000002ca743f2b) }},
};

static const block_t Ri_31[] = {
  {{ UINT64_C(0xffd8731972f85829), UINT64_C(0x13d55205843fd434), UINT64_C(0xe6dee4f6d342cc09), UINT64_C(0x000000001f9d260c) }},
  {{ UINT64_C(0x8e639f6187d846fd), UINT64_C(0x8b6e27428692aec1), UINT64_C(0x352f27119703ccf5), UINT64_C(0x00000001f41c9e8d) }},
  {{ UINT64_C(0xd0e70d7ca68f733d), UINT64_C(0x38b2cbd80d5be64d), UINT64_C(0x07e4de6e06c70f16), UINT64_C(0x00000000a4495fde) }},
  {{ UINT64_C(0x2ea649283b58402e), UINT64_C(0x39b44f6b1286bd7e), UINT64_C(0x7e6569132375152f), UINT64_C(0x0000000001387ee8) }},
  {{ UINT64_C(0x788b1bba3381f1b9), UINT64_C(0x35f33dd0cebc76cc), UINT64_C(0x55fd9113f72b08f6), UINT64_C(0x00000001fe86431a) }},
  {{ UINT64_C(0x6c95b935735d6814), UINT64_C(0x1f85087fa52414a4), UINT64_C(0xfddc326d34b600e6), UINT64_C(0x00000001cae3b1bb) }},
  {{ UINT64_C(0x42d0eb4f4695132f), UINT64_C(0xcb7999563114834e), UINT64_C(0x6ec876eff5e4fd2b), UINT64_C(0x0000000158d62f93) }},
  {{ UINT64_C(0x58fc948087d7bb0c), UINT64_C(0xa8fdd3c164ed6695), UINT64_C(0x50eea2c7a9bf848e), UINT64_C(0x0000000264cc61f9) }},
  {{ UINT64_C(0x7018f3900cac0e75), UINT64_C(0x186787653ec4f3db), UINT64_C(0x7aff410cbd358af0), UINT64_C(0x00000001e1049b57) }},
  {{ UINT64_C(0xbc81016b64479b21), UINT64_C(0x1aca1f792873ddeb), UINT64_C(0x9cef2c2c303cac86), UINT64_C(0x0000000161df058f) }},
  {{ UINT64_C(0x9070bbe3f8709a9d), UINT64_C(0xc9d06b772e320b1f), UINT64_C(0x550585cbfdf222ac), UINT64_C(0x00000000fae926f6) }},
  {{ UINT64_C(0x467d17403c6be68c), UINT64_C(0xa5259246e808c879), UINT64_C(0xeaf88f71e873fe12), UINT64_C(0x00000000a0bbc262) }},
  {{ UINT64_C(0x172407cf1daa2ec9), UINT64_C(0x3cedf309567554d8), UINT64_C(0xee29e15dcc1afa13), UINT64_C(0x000000035cfddafa) }},
  {{ UINT64_C(0xe3b46a7bf0441dd4), UINT64_C(0x67dd9869a42f398b), UINT64_C(0x73129cb372c62901), UINT64_C(0x00000002620989c1) }},
  {{ UINT64_C(0xb0bfe15b84d83b5f), UINT64_C(0xc97f067e0720522f), UINT64_C(0x7de76f35306847f0), UINT64_C(0x000000024243d730) }},
  {{ UINT64_C(0xb6e155d12f8a246c), UINT64_C(0x66d4eb9dd690d729), UINT64_C(0xccae97eb92faee7b), UINT64_C(0x00000000593a4d7f) }},
  {{ UINT64_C(0xfd2c5d1a99a49e9a), UINT64_C(0xf3c5a2d5a49553c5), UINT64_C(0xc6860e8f4d0f4487), UINT64_C(0x00000003724105ba) }},
  {{ UINT64_C(0xb6c32e257d079d7c), UINT64_C(0x163fd42b2220f97b), UINT64_C(0xfc22ca47815dbf51), UINT64_C(0x00000003badaf6e2) }},
  {{ UINT64_C(0x9c05344d11481f12), UINT64_C(0xb66a824bc7e95707), UINT64_C(0xa72e9b7f3db73132), UINT64_C(0x00000003768f3808) }},
  {{ UINT64_C(0x621b5d096367ea8f), UINT64_C(0xcc32bba462c83278), UINT64_C(0x3611cb9ad4590d4f), UINT64_C(0x0000000169348407) }},
  {{ UINT64_C(0xd44ccc67076750a3), UINT64_C(0xa05490150b1a56a3), UINT64_C(0xf459a87eb3aa707c), UINT64_C(0x00000002adba34b0) }},
  {{ UINT64_C(0x60fe328e2958e600), UINT64_C(0xb2c0888ed5c40c7e), UINT64_C(0x4fc52561156a1e7f), UINT64_C(0x000000010188d5b2) }},
  {{ UINT64_C(0xdc45aca9ccee9112), UINT64_C(0x1e314bc574b9fba2), UINT64_C(0x3de6e68413d9546a), UINT64_C(0x000000018802a99e) }},
  {{ UINT64_C(0x050b28abb34c2649), UINT64_C(0x312f5889760ae1b2), UINT64_C(0x3e8329df503e8702), UINT64_C(0x00000003287ddf1e) }},
  {{ UINT64_C(0x5a8f675925321579), UINT64_C(0xd8784243191dbdbc), UINT64_C(0xa07402a037ecb900), UINT64_C(0x00000002fc82f21e) }},
  {{ UINT64_C(0xf77c7f8b155ad486), UINT64_C(0xbf2a210fa6e1bd19), UINT64_C(0x287ef8ce0f3b2069), UINT64_C(0x00000000516768ff) }},
  {{ UINT64_C(0x3cb4a8a5a1707bd7), UINT64_C(0x6e916dfe86f48cd0), UINT64_C(0xbbb634d7b187ef34), UINT64_C(0x00000003b8d21683) }},
  {{ UINT64_C(0x6fbf846bed6eb745), UINT64_C(0x4386ddcc482b7b32), UINT64_C(0xaa7b9272c3fb357f), UINT64_C(0x00000001a925b6f0) }},
  {{ UINT64_C(0x00be1bb53ad19a70), UINT64_C(0xd0129a4f5758cff5), UINT64_C(0x2731150d270b0123), UINT64_C(0x00000003395d2ce1) }},
  {{ UINT64_C(0xa3d425dc5930465e), UINT64_C(0x1a7ec0d721855f10), UINT64_C(0x948082ad3c995356), UINT64_C(0x0000000011384976) }},
};

static const block_t Ri_32[] = {
  {{ UINT64_C(0x3856bc3e57153b8e), UINT64_C(0x7a622f8e77ca8e82), UINT64_C(0x272939b247dbe6ca), UINT64_C(0x00000001cc6867d8) }},
  {{ UINT64_C(0xb0825c8c30ab5926), UINT64_C(0xf7210eef0afb737d), UINT64_C(0x49e0bb3e985f7431), UINT64_C(0x000000009e94c037) }},
  {{ UINT64_C(0x440ae24960595c53), UINT64_C(0xf65de6ddb266fc19), UINT64_C(0xdca45e61397cdb78), UINT64_C(0x0000000091d6939c) }},
  {{ UINT64_C(0x9425629755a96aae), UINT64_C(0xe8862ee715fd5820), UINT64_C(0x77e233beba935f08), UINT64_C(0x00000000ee6617e5) }},
  {{ UINT64_C(0xcb4a01bbd826a9f7), UINT64_C(0xa0daec76bd03d7ce), UINT64_C(0x0e75d0001516ca89), UINT64_C(0x000000021d4a8f93) }},
  {{ UINT64_C(0x3a71b1b5ce234a0b), UINT64_C(0x5a19759cab2f5ba6), UINT64_C(0x1bee8d32cde2411e), UINT64_C(0x000000023f184fb0) }},
  {{ UINT64_C(0x0d9d143521b3f891), UINT64_C(0xd1a4da2748f3b9bb), UINT64_C(0x5ceee3025d88a7e7), UINT64_C(0x00000003f1f70a9f) }},
  {{ UINT64_C(0xe438cd6cc647973d), UINT64_C(0x1e65b28a06780885), UINT64_C(0x502165c1d7ff8b18), UINT64_C(0x00000000aec9c204) }},
  {{ UINT64_C(0x1f4a9a03f9fb9e37), UINT64_C(0x35078599c885e600), UINT64_C(0xa846e3bffe8c8797), UINT64_C(0x00000002cccdd0e3) }},
  {{ UINT64_C(0x1457b60bf1b99b46), UINT64_C(0x28c06940718934cf), UINT64_C(0x1122622d1e1ea5c7), UINT64_C(0x000000028ebf647e) }},
  {{ UINT64_C(0x6ba81cadcca5f6f1), UINT64_C(0xe5a98dc22806f71f), UINT64_C(0xa3106dabe6b9853b), UINT64_C(0x00000003fd20ec4e) }},
  {{ UINT64_C(0x21cfb4f8f9547b3f), UINT64_C(0x3778c73e99baf631), UINT64_C(0xa8d23a25c2319dc9), UINT64_C(0x00000000c8c4fbc4) }},
  {{ UINT64_C(0x29f551de3cb0de6d), UINT64_C(0xc7477d9fa656f802), UINT64_C(0xba7d1b55d8d07657), UINT64_C(0x0000000126915022) }},
  {{ UINT64_C(0x4b9aa3a0b16867c0), UINT64_C(0xd54346dc7bf06fb0), UINT64_C(0x78705d2c86d23340), UINT64_C(0x00000001a1970197) }},
  {{ UINT64_C(0x899d3bb40bcc59b3), UINT64_C(0x1f629fcb2a928603), UINT64_C(0xf4c7d1ab1d9666d0), UINT64_C(0x0000000069ec6bc6) }},
  {{ UINT64_C(0xb6cfd9c5e3824bfb), UINT64_C(0x77cdab2e616e074e), UINT64_C(0xf3bb51faef24e7cb), UINT64_C(0x00000001ca2a1542) }},
  {{ UINT64_C(0xddcaee2f9244b13b), UINT64_C(0x053a9ec192640eaa), UINT64_C(0x3ac401cf1af085be), UINT64_C(0x00000002bf993a90) }},
  {{ UINT64_C(0x2cf99156d88d5353), UINT64_C(0x99dcab0e9997aa65), UINT64_C(0x600788c943b5f45a), UINT64_C(0x0000000290787075) }},
  {{ UINT64_C(0xae864da358bd19ec), UINT64_C(0x96b4bc7e4ccc8fec), UINT64_C(0xe0d87079a7b895d9), UINT64_C(0x00000001e2d1e7ef) }},
  {{ UINT64_C(0x90a197c0ffbc60a6), UINT64_C(0xb86650337e4347ef), UINT64_C(0x288e1481d2a91789), UINT64_C(0x00000000f7488820) }},
  {{ UINT64_C(0xe8370464833c0563), UINT64_C(0x47440c6a8948589e), UINT64_C(0xff6c435d32b415ef), UINT64_C(0x00000000abb95370) }},
  {{ UINT64_C(0x879dab71d7b401cc), UINT64_C(0x3ddb26f4f5dcc369), UINT64_C(0xd4d7c3e9ef996e29), UINT64_C(0x00000000b59d4e6f) }},
  {{ UINT64_C(0xabe047a6f5b9093b), UINT64_C(0xa9dd75c028982b06), UINT64_C(0x195da5ac2c715cb6), UINT64_C(0x00000003ca8f9408) }},
  {{ UINT64_C(0x7f35c30ce781c107), UINT64_C(0x12a54b1a2eae5f96), UINT64_C(0xa5a29801cce15f4e), UINT64_C(0x00000000115a6f25) }},
  {{ UINT64_C(0x80c37d5c12e9fc03), UINT64_C(0x74a9c1105f8b633e), UINT64_C(0xadc7acb912927e00), UINT64_C(0x000000005189b786) }},
  {{ UINT64_C(0x5221dd3bd8d455ae), UINT64_C(0xdb291db9247741f0), UINT64_C(0x14b369995da95aac), UINT64_C(0x00000000ec785f2d) }},
  {{ UINT64_C(0x9990de727f0902f3), UINT64_C(0x210e0e3ba045cd79), UINT64_C(0xbf369119cd331f49), UINT64_C(0x00000002fb58cfa0) }},
  {{ UINT64_C(0x72f9a32d79ecb353), UINT64_C(0x0f7d578ae8bbbadc), UINT64_C(0x36b24993c1b20568), UINT64_C(0x00000001ec46e66c) }},
  {{ UINT64_C(0x2700878139799097), UINT64_C(0x09e7b595089a8106), UINT64_C(0xdaed88c1ac84673c), UINT64_C(0x0000000303e976e6) }},
  {{ UINT64_C(0x0677e87abfce5f49), UINT64_C(0xb104b2b32c72c200), UINT64_C(0x639213b34a50e956), UINT64_C(0x00000000697e5690) }},
};

static const block_t Ri_33[] = {
  {{ UINT64_C(0x21eea26c9c9636ba), UINT64_C(0xeeb351b7075e0549), UINT64_C(0x3d945871faa50379), UINT64_C(0x000000004402b9b2) }},
  {{ UINT64_C(0x4fe49c40d7701e78), UINT64_C(0x03ea5a7ff46e9312), UINT64_C(0x315053986d1b67a8), UINT64_C(0x0000000098cea26c) }},
  {{ UINT64_C(0x99179005e91ec733), UINT64_C(0x3e5c4fc0df69cbfa), UINT64_C(0x3470d02a01b1db6b), UINT64_C(0x00000001fb8d0a9e) }},
  {{ UINT64_C(0xc19d6cef0c08fd14), UINT64_C(0x9447de0c68d953d9), UINT64_C(0x3cd5769fdc3c125e), UINT64_C(0x0000000088716cee) }},
  {{ UINT64_C(0x7d85c64a990352ea), UINT64_C(0x7b1bdb539342f06c), UINT64_C(0xd068302a731d9f53), UINT64_C(0x00000002df1c8b72) }},
  {{ UINT64_C(0xaaabbd86492e3b66), UINT64_C(0xcc55a7f707b8de49), UINT64_C(0x944f5ad959e239e5), UINT64_C(0x0000000373aa8fbe) }},
  {{ UINT64_C(0xadbc55175964f4ab), UINT64_C(0xf14afd49d528c114), UINT64_C(0x2397348a575a63fe), UINT64_C(0x000000012443aa9f) }},
  {{ UINT64_C(0x45159a6705ffa0a8), UINT64_C(0xadb130817152ed78), UINT64_C(0x175593cfbc1b1540), UINT64_C(0x000000001ec0aed4) }},
  {{ UINT64_C(0xfb4afc67625091be), UINT64_C(0x8de7cdf324115748), UINT64_C(0x2dbf9f3aa716b727), UINT64_C(0x0000000314883ade) }},
  {{ UINT64_C(0xe07dcb9c940b512e), UINT64_C(0x0513c9181e68c96d), UINT64_C(0xc97371769322ec94), UINT64_C(0x000000003ca7a826) }},
  {{ UINT64_C(0x806e0103e5bf56c5), UINT64_C(0x09c8d06a52dbb5f2), UINT64_C(0x552445ac27b8efda), UINT64_C(0x00000001c1dc0101) }},
  {{ UINT64_C(0xcc9b289319e89aac), UINT64_C(0x2c0700011ecba320), UINT64_C(0xae5d75e0ef8dec2a), UINT64_C(0x00000001afb7413c) }},
  {{ UINT64_C(0xa492fb6f28d263f2), UINT64_C(0x522da6a1b15b9242), UINT64_C(0x8bd62a6594cd6c09), UINT64_C(0x00000001f97c211c) }},
  {{ UINT64_C(0x8f4df55d34070821), UINT64_C(0x8f8cf3090a46f724), UINT64_C(0x0db094a637991b23), UINT64_C(0x0000000351f28182) }},
  {{ UINT64_C(0x73c32bdc466c2bb4), UINT64_C(0xe613f137feb4f84d), UINT64_C(0x76ac04c391dc5cd1), UINT64_C(0x00000003b7db5136) }},
  {{ UINT64_C(0xb2c693a3917e38a1), UINT64_C(0x98db8d9a17c42579), UINT64_C(0x8bd632e4e8da45fe), UINT64_C(0x00000003a5e102d4) }},
  {{ UINT64_C(0xdc0d53b2cde6cbfc), UINT64_C(0xf679ed6a486db96d), UINT64_C(0x752e01c4ea502bc7), UINT64_C(0x0000000205d17803) }},
  {{ UINT64_C(0x1c488fc50dd3add4), UINT64_C(0x2d3cc24d4b0a82d5), UINT64_C(0xaea74cdadd9d50bb), UINT64_C(0x00000001899c5bab) }},
  {{ UINT64_C(0xb0cfe90d7fc55bb2), UINT64_C(0x15bae64518f3cee2), UINT64_C(0x96d628718834cabf), UINT64_C(0x000000018cadaac6) }},
  {{ UINT64_C(0x53b48f73f6afd0d7), UINT64_C(0x53b03f72315e91e4), UINT64_C(0xe5c80ffbcb3a0b83), UINT64_C(0x000000002580aff4) }},
  {{ UINT64_C(0xc6c47294a7274227), UINT64_C(0x3a595066f662cb04), UINT64_C(0xd33959c7a7ec9929), UINT64_C(0x000000027aedfc67) }},
  {{ UINT64_C(0x7fc2396ea352af39), UINT64_C(0x2981037a84df6274), UINT64_C(0x41d3c2b310e30a59), UINT64_C(0x000000033f77a0f7) }},
  {{ UINT64_C(0x4f02b233bf26b158), UINT64_C(0x2fef50f87869d85f), UINT64_C(0xd3959f45b67355c7), UINT64_C(0x0000000154649a37) }},
  {{ UINT64_C(0x9336bafacacbf9e5), UINT64_C(0x5eb7654e031a1477), UINT64_C(0x6b04dca05d4b70e2), UINT64_C(0x00000000bc05b722) }},
  {{ UINT64_C(0x685e4d2dfc07e75f), UINT64_C(0x98bccf7ea7707afa), UINT64_C(0x3efe07af5afc2be5), UINT64_C(0x00000000e01e141a) }},
  {{ UINT64_C(0x9d410fa6b4b73f9b), UINT64_C(0x2380f290f82d462b), UINT64_C(0x43bf343362330b22), UINT64_C(0x0000000128e699d5) }},
  {{ UINT64_C(0x4dc891ad4729574e), UINT64_C(0x296687cc949fd1e3), UINT64_C(0xcd1d612fe2280900), UINT64_C(0x00000003ac19a37f) }},
  {{ UINT64_C(0xacfe14b0349f6ddc), UINT64_C(0x2354c937015b3725), UINT64_C(0x67ff9c76152d6100), UINT64_C(0x00000001440d8314) }},
  {{ UINT64_C(0xb3d00b1eb34c3e38), UINT64_C(0x5ccbe12badb3adfd), UINT64_C(0xd9a14c99740ae9cc), UINT64_C(0x00000002aad1981f) }},
  {{ UINT64_C(0x757606740e395118), UINT64_C(0x4737007213f64e43), UINT64_C(0xd34cda9681a3eae8), UINT64_C(0x000000013840a7e6) }},
};

static const block_t Ri_34[] = {
  {{ UINT64_C(0xa81ad6d932482672), UINT64_C(0xf14d4f635aebcc05), UINT64_C(0x5e4f63cb1dcbcd63), UINT64_C(0x0000000192749608) }},
  {{ UINT64_C(0xe69bfe26e6f950cb), UINT64_C(0x4de09d380747ff02), UINT64_C(0x0b13b7ab32250f88), UINT64_C(0x000000004ab378c0) }},
  {{ UINT64_C(0xc2a163fa79b33924), UINT64_C(0x2313fd5a0aad20ed), UINT64_C(0x55b1f3827b4fa244), UINT64_C(0x0000000097a8ec5d) }},
  {{ UINT64_C(0x75c4345af00b5c8a), UINT64_C(0x5c3d8b8259aea721), UINT64_C(0xc1f962117825f876), UINT64_C(0x00000001fd011eeb) }},
  {{ UINT64_C(0x2add8d5f2c764034), UINT64_C(0x30ddd32f0212abeb), UINT64_C(0xd6e8835a13b77e5a), UINT64_C(0x00000003e016fbfb) }},
  {{ UINT64_C(0xeb44925f49628971), UINT64_C(0x421f1fa49007e433), UINT64_C(0x46d196d5e34eacac), UINT64_C(0x0000000383d822cd) }},
  {{ UINT64_C(0xcf03c6cbaa07db88), UINT64_C(0xb6f49bf6196218c1), UINT64_C(0x333b045bc7c98a5f), UINT64_C(0x0000000132cefb2f) }},
  {{ UINT64_C(0xe1184ecc00644615), UINT64_C(0xd69aafdfc0b8d1da), UINT64_C(0x5727af64379a2c2b), UINT64_C(0x00000001a8f7dea7) }},
  {{ UINT64_C(0x0317dd9d97492809), UINT64_C(0xf95a1e5ba438e7d0), UINT64_C(0xb3d09f9bb4e906cc), UINT64_C(0x00000002e473d80b) }},
  {{ UINT64_C(0x69a9fed10e0e9217), UINT64_C(0x9b623329154438e7), UINT64_C(0xab40eb38e837ea70), UINT64_C(0x00000000895d6eb5) }},
  {{ UINT64_C(0x812d5f19fc759970), UINT64_C(0xe32119112d1e6b5a), UINT64_C(0x025357332ab8064d), UINT64_C(0x00000001a045611d) }},
  {{ UINT64_C(0xb7eb7aac311310e7), UINT64_C(0x8578b655c2ac4ddc), UINT64_C(0xbaa76bd5d9ffc897), UINT64_C(0x000000026fb4ed33) }},
  {{ UINT64_C(0x182c900a34905845), UINT64_C(0x808edb92fac82dc4), UINT64_C(0x9edd4ea99f2e0ef6), UINT64_C(0x0000000362a641e1) }},
  {{ UINT64_C(0x1493ba929a0f0bbf), UINT64_C(0x8d7d2d5d2d7d7835), UINT64_C(0x67e27216752976a7), UINT64_C(0x000000013daa0d39) }},
  {{ UINT64_C(0xc0fe951d96a4d3f3), UINT64_C(0x41d52daa44ac7fc9), UINT64_C(0xe0b650c5eca789c7), UINT64_C(0x00000001c168c2c2) }},
  {{ UINT64_C(0xb4ffd6bbddbac11c), UINT64_C(0xb8644cb45a8ac50c), UINT64_C(0xfe38280719e027c7), UINT64_C(0x00000002744e9e37) }},
  {{ UINT64_C(0x91e037a3843c96b2), UINT64_C(0x39a50bd6fd4f1ca5), UINT64_C(0x39408e6cef6fb632), UINT64_C(0x0000000246a745fd) }},
  {{ UINT64_C(0xfba9fc1829e52cfa), UINT64_C(0x15991383f46731c5), UINT64_C(0xc6d5ccee6ab2b447), UINT64_C(0x00000002ceb07149) }},
  {{ UINT64_C(0x630bb93179529984), UINT64_C(0x8b263fc64314248e), UINT64_C(0xc284e88f90a078ea), UINT64_C(0x0000000300c872a0) }},
  {{ UINT64_C(0x5ad3d86b4589c33c), UINT64_C(0x9db0df516e45800d), UINT64_C(0xe943d64105122a62), UINT64_C(0x0000000330145061) }},
  {{ UINT64_C(0x363fe7553cdf0b5f), UINT64_C(0xdf2f8fffe0f39bdf), UINT64_C(0xf5dd47ef380ff764), UINT64_C(0x00000002df0867eb) }},
  {{ UINT64_C(0xb6ab2e445ace110b), UINT64_C(0x49d2c5ce47330fea), UINT64_C(0x3abbb07998a4a16f), UINT64_C(0x00000001fe5ad488) }},
  {{ UINT64_C(0xba9337d7c10816aa), UINT64_C(0xccdc1ec497c83326), UINT64_C(0xff783b23dc2cf517), UINT64_C(0x0000000399ccf1c2) }},
  {{ UINT64_C(0x3e300896e437fd80), UINT64_C(0xf219a9175e7d3bae), UINT64_C(0x7cd376fd217ad969), UINT64_C(0x00000002477a96c4) }},
  {{ UINT64_C(0xcf367f977f1c509d), UINT64_C(0x27946cfdda643fc7), UINT64_C(0xc154c22e06203d40), UINT64_C(0x00000001af7d9b43) }},
  {{ UINT64_C(0x6f07920f137805f3), UINT64_C(0xe87cea750ce95ebe), UINT64_C(0x4511b5188a325296), UINT64_C(0x000000015e05e4fa) }},
  {{ UINT64_C(0x866d8051ddc7fe35), UINT64_C(0x150dc9a3a105386e), UINT64_C(0x4aa21092ef86d14f), UINT64_C(0x0000000283849f28) }},
  {{ UINT64_C(0x58ab6f0a78050e26), UINT64_C(0x0911fa966a2f1411), UINT64_C(0xac044c9d0e7ee08b), UINT64_C(0x0000000360a64e3d) }},
  {{ UINT64_C(0x2be6febec38882e8), UINT64_C(0x9c3ec919ce492a79), UINT64_C(0xb0ad46f894ee8813), UINT64_C(0x000000029d80f8ad) }},
  {{ UINT64_C(0xfb6d307680f418df), UINT64_C(0xd032cf67ca2d4abe), UINT64_C(0xe5034f6b424a475a), UINT64_C(0x00000000421ecd94) }},
};

static const block_t Ri_35[] = {
  {{ UINT64_C(0xf4a76e6c8303f314), UINT64_C(0x4da487170f5f55ee), UINT64_C(0x5cb166fa5ee7a7e6), UINT64_C(0x000000021e7e03b1) }},
  {{ UINT64_C(0x29c1dccfc641b461), UINT64_C(0x31133f7e8562db64), UINT64_C(0xf578be55a7caee67), UINT64_C(0x00000003800d32ed) }},
  {{ UINT64_C(0xc2f35bf7e2471f64), UINT64_C(0x0bb7028291b0d825), UINT64_C(0x774e5a639c25b9ef), UINT64_C(0x00000001aae80508) }},
  {{ UINT64_C(0xa1690e139bc488f0), UINT64_C(0x4254f3ef5a9418ea), UINT64_C(0x2155f855fb2777b5), UINT64_C(0x0000000151759ee6) }},
  {{ UINT64_C(0x8ed6bd1cd3cc359d), UINT64_C(0x5a2e3a26cc7d5fe8), UINT64_C(0x1cb172fbd1913621), UINT64_C(0x000000007c16ca09) }},
  {{ UINT64_C(0x0148c1e838fb27fb), UINT64_C(0xcdae083779ee31dd), UINT64_C(0x057e5038e76ed8df), UINT64_C(0x00000003118f4f87) }},
  {{ UINT64_C(0xe3f0b943cf30a174), UINT64_C(0x4765d3991dd2ba03), UINT64_C(0x7aab4660eb0ff6e8), UINT64_C(0x00000003b9de81e1) }},
  {{ UINT64_C(0x0c16604605d46cb0), UINT64_C(0x358094f03fb63152), UINT64_C(0xe2766d9900e41d23), UINT64_C(0x000000009fc83cc2) }},
  {{ UINT64_C(0x8087862a07e87a2d), UINT64_C(0xa514ac823ec29147), UINT64_C(0x7ec0e2bd19350401), UINT64_C(0x000000009a2ec67e) }},
  {{ UINT64_C(0x1545d5ae962e7674), UINT64_C(0x29b0bb582b2a5323), UINT64_C(0x9a6087cf669db64f), UINT64_C(0x00000003a783b601) }},
  {{ UINT64_C(0x8893f06cc7f08862), UINT64_C(0xbfc3d103e9065680), UINT64_C(0x83b3347fa843f0a1), UINT64_C(0x00000002509f7d1e) }},
  {{ UINT64_C(0x194f4378f455d9c5), UINT64_C(0xb07f0ae9b90b8002), UINT64_C(0xa760b8c81f4bc561), UINT64_C(0x00000003be9f5644) }},
  {{ UINT64_C(0x6704564f8f98abcb), UINT64_C(0xb9f0ae3dfa56fbdc), UINT64_C(0xc53b038b16358c9e), UINT64_C(0x000000007270657d) }},
  {{ UINT64_C(0xe96d3e5737a6c03a), UINT64_C(0x7596293291303ac8), UINT64_C(0x5177f03dadbdd4d7), UINT64_C(0x00000002daa9893f) }},
  {{ UINT64_C(0x4465afba6cc55323), UINT64_C(0x005a9640e37caba6), UINT64_C(0x23ac00d89b586cf9), UINT64_C(0x00000002f2104737) }},
  {{ UINT64_C(0xdec4744535bf4e10), UINT64_C(0x3af64cb4419029dd), UINT64_C(0x9d28fafc5c08f39f), UINT64_C(0x00000000288c4424) }},
  {{ UINT64_C(0x9573146f8efb027a), UINT64_C(0xdd9419a170059d5e), UINT64_C(0xee955864a53751ce), UINT64_C(0x00000003455f69f6) }},
  {{ UINT64_C(0x12640aa747ad2687), UINT64_C(0x0fe0c9f53a37301a), UINT64_C(0x0aeea0034aaae24b), UINT64_C(0x000000038b1fa572) }},
  {{ UINT64_C(0x1726c3ec163a0e61), UINT64_C(0x4a176c83e4b82b1b), UINT64_C(0xcd2399fddbbd736c), UINT64_C(0x00000000520fc37e) }},
  {{ UINT64_C(0x7d0591781c40d955), UINT64_C(0x3b4efde43f6b48e4), UINT64_C(0xdef4555804361c67), UINT64_C(0x000000030e7b482c) }},
  {{ UINT64_C(0x2c999891828298a2), UINT64_C(0xdd8d53d597e0731b), UINT64_C(0x283e75d617ae8573), UINT64_C(0x00000002a24d33ba) }},
  {{ UINT64_C(0xec0a07a247ab0ba5), UINT64_C(0xd5fa7365a38cbbe4), UINT64_C(0x00851e92aed160af), UINT64_C(0x0000000205c7af0d) }},
  {{ UINT64_C(0x0645a4a8592139b7), UINT64_C(0xcac63d8b5f233b51), UINT64_C(0xdebc905f5831e053), UINT64_C(0x00000003732bfd90) }},
  {{ UINT64_C(0x30f10514df5d473f), UINT64_C(0xdac353fc41afdba5), UINT64_C(0x22fe2d7115f4b024), UINT64_C(0x000000025bb2fe82) }},
  {{ UINT64_C(0x7c5fc757d2300906), UINT64_C(0x580d16734dd6fa15), UINT64_C(0x209e4ed5335a5369), UINT64_C(0x000000000430f859) }},
  {{ UINT64_C(0xd6e3e2cd6d2eca9e), UINT64_C(0xb9bfb78eb3d65578), UINT64_C(0xe4f6f5d46d21e186), UINT64_C(0x0000000099c2e788) }},
  {{ UINT64_C(0x0adeace1e7bf2b95), UINT64_C(0x93ce89c763b0d70b), UINT64_C(0xb522f6cb1c0f3248), UINT64_C(0x000000014001e626) }},
  {{ UINT64_C(0x7db82d5304dedd04), UINT64_C(0x2b134e51bb92aeb1), UINT64_C(0xceb436ba1beac295), UINT64_C(0x00000001132a130e) }},
  {{ UINT64_C(0x3d07c44d4a2ac231), UINT64_C(0x8f95645dff0b81ca), UINT64_C(0x2a2a70878b0ed4a7), UINT64_C(0x0000000027c48567) }},
  {{ UINT64_C(0x697a16f214eca1cb), UINT64_C(0x3cdba1f8f822fa9c), UINT64_C(0xc84255a284793358), UINT64_C(0x000000002211c257) }},
};

static const block_t Ri_36[] = {
  {{ UINT64_C(0x29e6ea4100123014), UINT64_C(0x50c422cb48cd38af), UINT64_C(0x4fd6da3986a39110), UINT64_C(0x0000000089fd1f40) }},
  {{ UINT64_C(0xaff4b79aa359dbec), UINT64_C(0xc93837aa1bbac717), UINT64_C(0x69adc76f9c74782c), UINT64_C(0x0000000040523a55) }},
  {{ UINT64_C(0x3f2dddc37c9aad80), UINT64_C(0x22525788ad77970a), UINT64_C(0xd99f304f22a0cf31), UINT64_C(0x00000000e4b0ced5) }},
  {{ UINT64_C(0xc706bc44d58d30cc), UINT64_C(0x2b3c29d24a81be41), UINT64_C(0xe0c0869331d91567), UINT64_C(0x0000000010439b0a) }},
  {{ UINT64_C(0x34103325640f99e9), UINT64_C(0x6c72c92a4082de29), UINT64_C(0xde7e4e1a3ebab25d), UINT64_C(0x0000000066861783) }},
  {{ UINT64_C(0x61fd61b36022acf3), UINT64_C(0xc67188bd0c9eabaf), UINT64_C(0x8ce0ef4b88b6370c), UINT64_C(0x00000003cf1e74e2) }},
  {{ UINT64_C(0x3c59489972351187), UINT64_C(0xa193d401c6f09c51), UINT64_C(0x9f288b2d5330b4dd), UINT64_C(0x00000003a9fa2522) }},
  {{ UINT64_C(0x32d82aefbb3148be), UINT64_C(0xa4c0ce3f56c7f7de), UINT64_C(0xaab7861c355c69fc), UINT64_C(0x0000000382bea991) }},
  {{ UINT64_C(0x7e8f3a5f0c3ca838), UINT64_C(0x6870abf1f648930f), UINT64_C(0xafdbcf4f4b49041a), UINT64_C(0x0000000155afa44f) }},
  {{ UINT64_C(0x7ce2e34d9417005a), UINT64_C(0x564c528360c62330), UINT64_C(0x7fe078d830cc5c2a), UINT64_C(0x00000003460adb91) }},
  {{ UINT64_C(0x328678923a8e0efc), UINT64_C(0x12d2882d78ed94fc), UINT64_C(0xe1b6553dd97f11f7), UINT64_C(0x00000003b9f80d80) }},
  {{ UINT64_C(0xfabd3250bd6ba83c), UINT64_C(0xef7ff33efeaed554), UINT64_C(0xd706cb13600e377f), UINT64_C(0x000000032025bb37) }},
  {{ UINT64_C(0x3f4fcab2e50ac2e2), UINT64_C(0xf527a46314e3cbbc), UINT64_C(0xfc3459c0a4340b21), UINT64_C(0x00000001d390446d) }},
  {{ UINT64_C(0xc765794021e967b9), UINT64_C(0x2e61d410b7748e98), UINT64_C(0x1eab51100fd0318f), UINT64_C(0x00000003a3d462f5) }},
  {{ UINT64_C(0x86cd61c90d9156b8), UINT64_C(0xa58fb3fcce27976f), UINT64_C(0xc5fe6816baf29784), UINT64_C(0x00000002657dacb5) }},
  {{ UINT64_C(0x8877ab68b109c022), UINT64_C(0xcfbeb3e51fb7b5e9), UINT64_C(0xd92958e57425e7a6), UINT64_C(0x00000003aac2d1dd) }},
  {{ UINT64_C(0xe59d9b1d96b94cd8), UINT64_C(0x0eae4f10a1266bd7), UINT64_C(0xdf9ad3f5a835e31d), UINT64_C(0x0000000153fbda70) }},
  {{ UINT64_C(0xcb42ef655fae34e8), UINT64_C(0x0d9336bcbfa9d372), UINT64_C(0xcb5ac99ad40b0a65), UINT64_C(0x000000017d3d9fca) }},
  {{ UINT64_C(0xbf6cf6ae91f570ef), UINT64_C(0x0a5c632a206375cb), UINT64_C(0xc6bd18303453b9bd), UINT64_C(0x000000016f13f186) }},
  {{ UINT64_C(0x68d4845636860275), UINT64_C(0xa5e66a2acdde54cb), UINT64_C(0x163a58324147d2b0), UINT64_C(0x00000001c70ac691) }},
  {{ UINT64_C(0x5e5c133d2f8a7bf2), UINT64_C(0x1a2ecac69e4078f3), UINT64_C(0xa0c71b2df142717b), UINT64_C(0x00000000f77511b9) }},
  {{ UINT64_C(0xa20375d5d4de59fd), UINT64_C(0x09822b6219afacb8), UINT64_C(0x43d62ab279d2107b), UINT64_C(0x0000000205e609ad) }},
  {{ UINT64_C(0xd739afcfa0d35968), UINT64_C(0xf815635fadf3d0c1), UINT64_C(0x838fb6f72e49f66a), UINT64_C(0x00000000ff4e9755) }},
  {{ UINT64_C(0x2f47cbaa1d3daa3f), UINT64_C(0x926355d4b99ee6f6), UINT64_C(0xab76e70796d7eabc), UINT64_C(0x00000003144a7b1f) }},
  {{ UINT64_C(0x460ed7876f7aa3a7), UINT64_C(0xd44a7fcc1786f81b), UINT64_C(0x0523c399cecc1e50), UINT64_C(0x00000003142a8a1f) }},
  {{ UINT64_C(0x345974c6a9597a70), UINT64_C(0x72806492ca05331c), UINT64_C(0xf786d01231e72c48), UINT64_C(0x000000023ca5999c) }},
  {{ UINT64_C(0x0585954dd9e4896f), UINT64_C(0x5d3986ea6a42403f), UINT64_C(0x11fc8b3b4bc4d805), UINT64_C(0x0000000031e9afc8) }},
  {{ UINT64_C(0xe4167953e5497cd6), UINT64_C(0x94b965f156a4e6bd), UINT64_C(0xc9cebf24c01e3f64), UINT64_C(0x00000002465b9fac) }},
  {{ UINT64_C(0xdab0b39f05f4a43c), UINT64_C(0x8042a665cccbbd57), UINT64_C(0x5b55e5ff33001068), UINT64_C(0x00000001db78e5ca) }},
  {{ UINT64_C(0xa9cc4393657b9cd6), UINT64_C(0x1543a1646723c3bb), UINT64_C(0x4f615e58d05261cf), UINT64_C(0x00000000eb2ad020) }},
};


static const lowmc_partial_round_t rounds[38] = {

  {
    Zi_0, Ri_0, UINT64_C(0xffffffee00000000),
  },
  {
    Zi_1, Ri_1, UINT64_C(0xffffffdc40000000),
  },
  {
    Zi_2, Ri_2, UINT64_C(0xfffffff880000000),
  },
  {
    Zi_3, Ri_3, UINT64_C(0xffffffee00000000),
  },
  {
    Zi_4, Ri_4, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_5, Ri_5, UINT64_C(0xffffffe980000000),
  },
  {
    Zi_6, Ri_6, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_7, Ri_7, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_8, Ri_8, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_9, Ri_9, UINT64_C(0xfffffffa00000000),
  },
  {
    Zi_10, Ri_10, UINT64_C(0xffffffb700000000),
  },
  {
    Zi_11, Ri_11, UINT64_C(0xffffffd508000000),
  },
  {
    Zi_12, Ri_12, UINT64_C(0xfffffff900000000),
  },
  {
    Zi_13, Ri_13, UINT64_C(0xfffffffa00000000),
  },
  {
    Zi_14, Ri_14, UINT64_C(0xfffffff900000000),
  },
  {
    Zi_15, Ri_15, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_16, Ri_16, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_17, Ri_17, UINT64_C(0xffffffde00000000),
  },
  {
    Zi_18, Ri_18, UINT64_C(0xfffffff900000000),
  },
  {
    Zi_19, Ri_19, UINT64_C(0xfffffff300000000),
  },
  {
    Zi_20, Ri_20, UINT64_C(0xffffffed00000000),
  },
  {
    Zi_21, Ri_21, UINT64_C(0xfffffff300000000),
  },
  {
    Zi_22, Ri_22, UINT64_C(0xfffffffa00000000),
  },
  {
    Zi_23, Ri_23, UINT64_C(0xffffffec20000000),
  },
  {
    Zi_24, Ri_24, UINT64_C(0xfffffff900000000),
  },
  {
    Zi_25, Ri_25, UINT64_C(0xfffffff880000000),
  },
  {
    Zi_26, Ri_26, UINT64_C(0xfffffff600000000),
  },
  {
    Zi_27, Ri_27, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_28, Ri_28, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_29, Ri_29, UINT64_C(0xffffff7700000000),
  },
  {
    Zi_30, Ri_30, UINT64_C(0xfffffff600000000),
  },
  {
    Zi_31, Ri_31, UINT64_C(0xffffffbc40000000),
  },
  {
    Zi_32, Ri_32, UINT64_C(0xfffffffa00000000),
  },
  {
    Zi_33, Ri_33, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_34, Ri_34, UINT64_C(0xfffffff600000000),
  },
  {
    Zi_35, Ri_35, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_36, Ri_36, UINT64_C(0xffffffe700000000),
  },
  {
    NULL, NULL, 0,
  },
};

const lowmc_partial_t lowmc_256_256_38 = {
  precomputed_round_key_matrix_linear_part,
  Z_r,
  rounds,
  precomputed_round_key_matrix_non_linear_part,
  precomputed_constant_linear_part,
  precomputed_constant_non_linear_part,
};

