#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stddef.h>

#include "lowmc_128_128_20.h"

static const block_t precomputed_round_key_matrix_linear_part[] = {
  {{ UINT64_C(0x7f6e7b7adabc4318), UINT64_C(0x76818984b3248786), UINT64_C(0x3a3cd67b6c4c501d), UINT64_C(0xab37284643366193) }},
  {{ UINT64_C(0x5c1db5cfccda9501), UINT64_C(0xbab30ef977432daa), UINT64_C(0xf4b3d47a6986fef3), UINT64_C(0xe6cfc12efff6c47c) }},
  {{ UINT64_C(0x589b48f17a77b460), UINT64_C(0x725c55dad270b029), UINT64_C(0x3ab0d11d50a0959f), UINT64_C(0x0a159a293b8df0fc) }},
  {{ UINT64_C(0xb2b504b3d91f6260), UINT64_C(0x7628581ac936c4a5), UINT64_C(0xd9c5b16321bc5ff8), UINT64_C(0x5b9be376a84cd798) }},
  {{ UINT64_C(0x3ab9b4f9a0dac5a1), UINT64_C(0xa085e905c4dad127), UINT64_C(0x41386e58cedaa421), UINT64_C(0x37d9063b5e75dbfd) }},
  {{ UINT64_C(0x5f9b312d56ab4fd2), UINT64_C(0x2423b14e33891cfd), UINT64_C(0xddec189512b5b126), UINT64_C(0x974a076b5a8ceb07) }},
  {{ UINT64_C(0x7106fdad4576cb16), UINT64_C(0x038b1827801bd2e7), UINT64_C(0xe1a1e17ad5a54fa6), UINT64_C(0x7fa1788f724c33ab) }},
  {{ UINT64_C(0xf8b6c7971b9151e7), UINT64_C(0x2ac389525cb5214e), UINT64_C(0x9615bc0102b0ff62), UINT64_C(0x3e871d63be1e444e) }},
  {{ UINT64_C(0xf46eac974152110b), UINT64_C(0xc8c427f8feb14d77), UINT64_C(0x8eeaf5357dd36640), UINT64_C(0xd303d80a00042a05) }},
  {{ UINT64_C(0x86400d8018bda0a4), UINT64_C(0xb240e8648685c17e), UINT64_C(0x15878465ceeb5a23), UINT64_C(0xb3286dd65ed5c702) }},
  {{ UINT64_C(0x3fcfd812b8df9a1a), UINT64_C(0x45b4e8443cf73ce0), UINT64_C(0xd86880acf1a06e62), UINT64_C(0xa7b4ea199ec0a0e7) }},
  {{ UINT64_C(0xe7697dbe331a9827), UINT64_C(0xb2c60f88136ad895), UINT64_C(0x33965cf05e3ec81a), UINT64_C(0x1184c94642904587) }},
  {{ UINT64_C(0xaf3b203455d0af29), UINT64_C(0xa145e56372df32df), UINT64_C(0xd5e513fe491773f0), UINT64_C(0x6c7379e127f441d4) }},
  {{ UINT64_C(0xfb033003714e905c), UINT64_C(0xaef82e7b6858a0e2), UINT64_C(0x75f433b151d576fa), UINT64_C(0x315245f5ef6ae069) }},
  {{ UINT64_C(0x39643eae52e04557), UINT64_C(0xcb55b760e9f820a9), UINT64_C(0x1a3bff82055ffdd6), UINT64_C(0x704762da4d92e885) }},
  {{ UINT64_C(0xb879aa0794eb17b2), UINT64_C(0x579c65efa9d6f92f), UINT64_C(0xb127076fa5c45e4b), UINT64_C(0x65cf25c2c8c85cdc) }},
  {{ UINT64_C(0x751942f9de1c0ae8), UINT64_C(0x19d61e0eda34cbd8), UINT64_C(0x5f34551720f67afe), UINT64_C(0x2d46b60a6e378540) }},
  {{ UINT64_C(0xd0a37aed62ea0acd), UINT64_C(0x3062a3423f849c4e), UINT64_C(0xa51de6b9428ace79), UINT64_C(0xbc40cd136ab090df) }},
  {{ UINT64_C(0x344e3d689c80ab3e), UINT64_C(0xe51754f50606d71f), UINT64_C(0xef6b7aafbb589f37), UINT64_C(0x69a9ad099af62318) }},
  {{ UINT64_C(0x1c94c5fb667bc5c0), UINT64_C(0x73b40df491c8283e), UINT64_C(0xeec47b748a84ec09), UINT64_C(0xe0a4719232f89cf0) }},
  {{ UINT64_C(0x5fc8379888eab250), UINT64_C(0x4af339ecfc784fe9), UINT64_C(0x24c5086de2b175fb), UINT64_C(0x472cf81c56241ec5) }},
  {{ UINT64_C(0x05cb512ca0fcdde0), UINT64_C(0x766dd1cc46eb102f), UINT64_C(0x6bb2772b9d634203), UINT64_C(0xd4207eb2d55c6b8a) }},
  {{ UINT64_C(0xd427b0c28ba79cd5), UINT64_C(0x14365a6a34c55243), UINT64_C(0xbdae751572d86716), UINT64_C(0xa3c7f01533e92ddd) }},
  {{ UINT64_C(0x90a580e7586322c8), UINT64_C(0xd05cc466bf465ca2), UINT64_C(0x63b427b978c074af), UINT64_C(0x3a12ad6c96842760) }},
  {{ UINT64_C(0x9a4688ce7c8535be), UINT64_C(0x9ae964e706963c30), UINT64_C(0xe3a101def1984304), UINT64_C(0xf35e67e64ff2c89f) }},
  {{ UINT64_C(0x53727eb319ab4432), UINT64_C(0x8816e9fb24e147d7), UINT64_C(0xe3331af2f45dfc8b), UINT64_C(0x4a047693c541a917) }},
  {{ UINT64_C(0xe074f58fd39e9cb5), UINT64_C(0xd2d21a9ac4272fcc), UINT64_C(0x47272335769b3d03), UINT64_C(0x960202a8047a97d5) }},
  {{ UINT64_C(0xe7c037b1efc6e5ce), UINT64_C(0x7bdeea00e669fd39), UINT64_C(0x7fee51762c707096), UINT64_C(0xdfcc01fdfbc9f0f0) }},
  {{ UINT64_C(0x34a9490874546a72), UINT64_C(0x225349c7bba39ffc), UINT64_C(0xfd505438c08816c4), UINT64_C(0x561279158a8931d8) }},
  {{ UINT64_C(0x46f70c0ac6882cff), UINT64_C(0x6cebc913acad9b0d), UINT64_C(0x82c73c8ba2563194), UINT64_C(0x2b3787c98cd6947b) }},
  {{ UINT64_C(0x8bc3686b0b716aec), UINT64_C(0x9254039ca2b34997), UINT64_C(0x1bb81f3da59c17e5), UINT64_C(0xf35148d28d95f367) }},
  {{ UINT64_C(0x12d31b383e9f0765), UINT64_C(0x7cb721bc90f1772a), UINT64_C(0x5fd51ea5925002bf), UINT64_C(0xe21942bf1cce83f7) }},
  {{ UINT64_C(0x629d94e5770e2dac), UINT64_C(0x6585e28ff3d4412e), UINT64_C(0x8fb2e960864e56cd), UINT64_C(0x363db02f3720ee54) }},
  {{ UINT64_C(0x71a1b484def6fd7e), UINT64_C(0xde81a5e18785ca4e), UINT64_C(0xf469c0d607e8f048), UINT64_C(0x023e73335d46498a) }},
  {{ UINT64_C(0x1976e233cc823fcb), UINT64_C(0x18a8ed48f2528037), UINT64_C(0x033a8fd96b9fb55b), UINT64_C(0xb82ebfcf8445358c) }},
  {{ UINT64_C(0x493db1ba8a7dba2f), UINT64_C(0x61e6b1161bbfe4c4), UINT64_C(0xc26f4735f1092fcf), UINT64_C(0x52d7ebd2a96c3b44) }},
  {{ UINT64_C(0x97d9622cdf1f6d85), UINT64_C(0xc61ee012d8f4aa85), UINT64_C(0x7447e4c65727c46f), UINT64_C(0x5676ac48704f3d20) }},
  {{ UINT64_C(0xd0eec222d8f9d248), UINT64_C(0xb4d34dcb4dc53cb7), UINT64_C(0x1324512f9634eeab), UINT64_C(0x1ed3b877484105ff) }},
  {{ UINT64_C(0x12988fedc2fb099d), UINT64_C(0x1c3b1cf772840a54), UINT64_C(0x02f57e3337289351), UINT64_C(0x9e4ca2198199d075) }},
  {{ UINT64_C(0xf4c0718da33ec4c7), UINT64_C(0xdc5c8cecde7741ab), UINT64_C(0xce9fbf15363d002d), UINT64_C(0xf74cb369e48e801a) }},
  {{ UINT64_C(0x9b4e98595c366693), UINT64_C(0xdae82468396d7cc8), UINT64_C(0x3fc09ac8d69dc6bd), UINT64_C(0x215493749206736d) }},
  {{ UINT64_C(0xefd753d40eb6310d), UINT64_C(0xb8cbd75fc5b8bacb), UINT64_C(0x8c4f21d64a3065dd), UINT64_C(0x4bc5600918340ca9) }},
  {{ UINT64_C(0x44afcb25061e5bfc), UINT64_C(0xcfd706cd53f6cd60), UINT64_C(0x125061fa222eb052), UINT64_C(0xc2b22e4974ff25f8) }},
  {{ UINT64_C(0x1bd4b7c894cf6b2e), UINT64_C(0x1ca01419d2448328), UINT64_C(0x88b137f3fca1c614), UINT64_C(0xe6b5f86feaf9a14b) }},
  {{ UINT64_C(0x33bcf0b8f33bc53f), UINT64_C(0xad0088ea5d9123bb), UINT64_C(0xe95c48df616844b0), UINT64_C(0x7a05375982d90c5e) }},
  {{ UINT64_C(0x269e478f86bdf391), UINT64_C(0xfc38a1301c9267e3), UINT64_C(0x1e37732fc4802603), UINT64_C(0x96c2f08bb4df13e0) }},
  {{ UINT64_C(0x0c42fd604807be94), UINT64_C(0xe1a643c5ea65b96e), UINT64_C(0x5b89de485f5d0351), UINT64_C(0xb900453eb81e56f7) }},
  {{ UINT64_C(0x6ed183cef379a7a7), UINT64_C(0xa6077f506005a358), UINT64_C(0x455301a457cd5fbb), UINT64_C(0xbe15fa0961e8a6be) }},
  {{ UINT64_C(0x9e98f871873827cf), UINT64_C(0xf58860a751bce519), UINT64_C(0xf6603b9559ccbab5), UINT64_C(0x7554f26d85cd29f6) }},
  {{ UINT64_C(0x507078de7e488aff), UINT64_C(0x8885757e8ce19ec6), UINT64_C(0x3e0f8365c6fdd93a), UINT64_C(0x80583de01f2ead45) }},
  {{ UINT64_C(0xcd6e555f136f75f3), UINT64_C(0xce01e8a8107cbd62), UINT64_C(0xa7fd0e1fca30888b), UINT64_C(0xee53e5fc05f5e9af) }},
  {{ UINT64_C(0x4e80a72906b78716), UINT64_C(0xd8fc8222a01f08af), UINT64_C(0x6f97acfceb9daaa4), UINT64_C(0x85cc8848667ad81f) }},
  {{ UINT64_C(0x761c05d6ea18c08b), UINT64_C(0xc8bcbb1bbe5000ba), UINT64_C(0x7509910d72db21ef), UINT64_C(0x0f5e18d4fb261bf5) }},
  {{ UINT64_C(0x94fd479bd09f7e9e), UINT64_C(0x13c207454435ab9f), UINT64_C(0xa9f68d4fb2cd5d54), UINT64_C(0xc23f28530cc314fd) }},
  {{ UINT64_C(0x472d7e5180a6c638), UINT64_C(0x7df46a3545347f51), UINT64_C(0xd82f2e12a7a27f75), UINT64_C(0x3437ba910d2e76e2) }},
  {{ UINT64_C(0x9ee2cbce715c49a1), UINT64_C(0x0258a22b77cd2e3c), UINT64_C(0xbcb5a9882e7d43b6), UINT64_C(0xd63eac38a0687c09) }},
  {{ UINT64_C(0xa41eac73d8310b20), UINT64_C(0x9ff69751aef404c5), UINT64_C(0x5198b74f3f18f1cb), UINT64_C(0xbd8feb9a6859af07) }},
  {{ UINT64_C(0x96f50626583cd93a), UINT64_C(0xecab7344c21f599d), UINT64_C(0xb4a7da930c5b0c78), UINT64_C(0x5509ed700b990933) }},
  {{ UINT64_C(0x48c7c06dba92e08f), UINT64_C(0x3a389c21c30cb4e7), UINT64_C(0x1b713c736920364c), UINT64_C(0x891c3b0efa60ae1e) }},
  {{ UINT64_C(0x6b4ba3960c1f3118), UINT64_C(0x2a47a152fd49e526), UINT64_C(0x0cb81508e410906c), UINT64_C(0xc0e03602e9365c11) }},
  {{ UINT64_C(0x5b25ab764e71a76d), UINT64_C(0xecb65ac85ea90bbe), UINT64_C(0x22ed7375a085b47f), UINT64_C(0xa00621b634be2f4c) }},
  {{ UINT64_C(0x4ca5d108102ae94c), UINT64_C(0x0ba1e20627ec4245), UINT64_C(0xcb7e26ada8e67229), UINT64_C(0x8b70ccbf6da50e38) }},
  {{ UINT64_C(0x8d3abd65efd02e19), UINT64_C(0x170c5ba2bdf072e6), UINT64_C(0x5044794bc86c4067), UINT64_C(0xebc5773ae123f4da) }},
  {{ UINT64_C(0xea486f50ff43f145), UINT64_C(0x90be5f954e16c5e7), UINT64_C(0x998d749e77deb823), UINT64_C(0x2e42f818624b95bf) }},
};

static const block_t precomputed_round_key_matrix_non_linear_part[] = {
  {{ UINT64_C(0x076419e8419f4f0c), UINT64_C(0xdca02da4c0703930), UINT64_C(0xaddda21ce01d2150), UINT64_C(0x8e3bc7d0ab69aeac) }}, {{ UINT64_C(0xa54e6544fdda48c4), UINT64_C(0x518894b447bca750), UINT64_C(0x666853ec4e18caac), UINT64_C(0xea69e930f46ace68) }}, {{ UINT64_C(0xd6011e60a07efee8), UINT64_C(0xe3c504249b29a868), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xab99832c40c3b240), UINT64_C(0x9ac517682b9a1518), UINT64_C(0x5fa29414b974d868), UINT64_C(0x1eaed33865a9e524) }}, {{ UINT64_C(0xb92c9f841a58b5ac), UINT64_C(0xed29c0283bd1975c), UINT64_C(0x02f79fb033819e08), UINT64_C(0x87b3aa3475d87fe4) }}, {{ UINT64_C(0xfa30d134cf244aec), UINT64_C(0x922c749878e2a75c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e879bd458e1b6f4), UINT64_C(0x254a8fe4309df030), UINT64_C(0xdd70615468856b64), UINT64_C(0xe9b54d6c5d458528) }}, {{ UINT64_C(0x2dd37b28f74ad8a0), UINT64_C(0xe92541146c3cae40), UINT64_C(0x481839dca97c1044), UINT64_C(0x8665be906b90e83c) }}, {{ UINT64_C(0x4e397c6448ca467c), UINT64_C(0x9097e4f4bcaca4e4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaa559dd0d65ee3fc), UINT64_C(0xd57b5bfc9d4b5c44), UINT64_C(0x2573628c68ac1a60), UINT64_C(0xb6d6cce0ec8e069c) }}, {{ UINT64_C(0x141bb22c7f289368), UINT64_C(0xe7d46668961e4ce0), UINT64_C(0x5f92d8205e9dcf84), UINT64_C(0x819383c05a8f2644) }}, {{ UINT64_C(0xee7843d4832f01bc), UINT64_C(0x0f86e2c853713ee0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5a6ee304355ab314), UINT64_C(0xa5f252d422f6ac64), UINT64_C(0x15c42c5449c7f478), UINT64_C(0xd30cefb8a44d6e60) }}, {{ UINT64_C(0x311d2418dfa9dcd0), UINT64_C(0x2788a4f49e0fd988), UINT64_C(0x5eb0625cadf99934), UINT64_C(0x5a49baa80dd48328) }}, {{ UINT64_C(0xb67e9078666e35fc), UINT64_C(0x6d161fd4d586bf8c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9dd758602d740d70), UINT64_C(0x8591d78c76870f2c), UINT64_C(0x1425b5b0fd6f095c), UINT64_C(0x95af96e0bc77aee0) }}, {{ UINT64_C(0xbad6fe2076ab2ff8), UINT64_C(0x680317088e8015e0), UINT64_C(0xe1e532cc663103f0), UINT64_C(0x79263ca4e4706910) }}, {{ UINT64_C(0xb1b3426ca32b5b04), UINT64_C(0x03c07cdc64be74b0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e439580cfefc80c), UINT64_C(0x5dfb5500a2def2bc), UINT64_C(0xe4a49e207ffb2a00), UINT64_C(0x46516d642675ee70) }}, {{ UINT64_C(0x6fc784582bc313f0), UINT64_C(0x7fcc4480aaec7a14), UINT64_C(0xd0c2ac68324f11f0), UINT64_C(0xa830454411e15650) }}, {{ UINT64_C(0x89465d986bd74564), UINT64_C(0xeed55ebcf73062e4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0beb4094938daf4c), UINT64_C(0xfb49de3064dba7a8), UINT64_C(0x298ef8683a4cf9ac), UINT64_C(0x9175a6c4888f1700) }}, {{ UINT64_C(0x0ebca760f605a514), UINT64_C(0xca86e7e0d6291ee4), UINT64_C(0xb0d424acb2ab3a3c), UINT64_C(0x818d65046ca9b1d0) }}, {{ UINT64_C(0xe3e10cb8f0880480), UINT64_C(0x5008ff805a6633ec), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x867d0070c6a51360), UINT64_C(0x7c979c60148561f0), UINT64_C(0x21cfe4441de1dc44), UINT64_C(0xe0b5cc00dadc3cc0) }}, {{ UINT64_C(0xa960af981a228f74), UINT64_C(0xe0be6d0c3bc5e594), UINT64_C(0xb353c2c4f58ce964), UINT64_C(0x5a1477d41ca7e2c4) }}, {{ UINT64_C(0xa18c4a6c63140094), UINT64_C(0x9d837ea00f4308fc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xddb2c454d44c9aa4), UINT64_C(0x2098a2b0464eafa0), UINT64_C(0x340c9f70d1492848), UINT64_C(0x4cde1fbca0ad79b8) }}, {{ UINT64_C(0x3100378ce6705660), UINT64_C(0x3cdeaea4deaf77e0), UINT64_C(0xc1811e6c7aaaf3ec), UINT64_C(0x4a35005c3a18b928) }}, {{ UINT64_C(0x82b202f0c00d875c), UINT64_C(0x5c6f657852049560), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xda69f3b01ba3be34), UINT64_C(0x50ecc0bca864daf8), UINT64_C(0x29eb2f786407832c), UINT64_C(0x1fd4a1f88dcf09b8) }}, {{ UINT64_C(0x4970b084a2584048), UINT64_C(0x8a07e1381acdd43c), UINT64_C(0x895321e874bf8940), UINT64_C(0xa521139ce91fc78c) }}, {{ UINT64_C(0xbd84c978956b8c68), UINT64_C(0x46bca8ec2fdd621c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdb668f28d781dde0), UINT64_C(0xa8d533e07361e1c4), UINT64_C(0xc58b940c6e5e6a50), UINT64_C(0x56f7571838ec488c) }}, {{ UINT64_C(0x1e1f6de458f94894), UINT64_C(0xac1f76b01ca323f8), UINT64_C(0xdb4612f8ae98bf70), UINT64_C(0x08261ec45926aa68) }}, {{ UINT64_C(0x3305b7ccfe634744), UINT64_C(0x2d9d8d18cfa70008), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x579a7ac03081a1b8), UINT64_C(0x0818f28866e7f80c), UINT64_C(0xbe9b61284a1135e0), UINT64_C(0x30566690c8f65120) }}, {{ UINT64_C(0xf708aebc4a4c2b84), UINT64_C(0xe7726460752ecdb4), UINT64_C(0x9d78d1e433985934), UINT64_C(0xe95f085805844be8) }}, {{ UINT64_C(0x516ae2c8eac9f2b8), UINT64_C(0xd4c7543ca055f984), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x317bd44c34d4b36c), UINT64_C(0x2b3a80745e8cbc88), UINT64_C(0x55ee7ca42025b68c), UINT64_C(0xd59f3cfc9bb87bc4) }}, {{ UINT64_C(0xd498c27469face00), UINT64_C(0x00ab71b023d8ba60), UINT64_C(0x630942cc00a92dbc), UINT64_C(0x2de28da04e765fd8) }}, {{ UINT64_C(0x2246780c59be6cb8), UINT64_C(0x11c2ab6c0e4fad64), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x97c9e3c4146e4690), UINT64_C(0xc7d05ae476a70424), UINT64_C(0xf51b6660274e4de0), UINT64_C(0xf35f5b7019885664) }}, {{ UINT64_C(0x54d5d8e43b07203c), UINT64_C(0x2b9be3549e645130), UINT64_C(0x033ce49005149af0), UINT64_C(0x30ec4080d0eb3edc) }}, {{ UINT64_C(0x8a233aecde2a1810), UINT64_C(0x6c809770d40cd734), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb8ce408439f4f3e8), UINT64_C(0xe082ae0c6b36ec98), UINT64_C(0x88cf7f4c8f11c254), UINT64_C(0x2e433f2c31e6b670) }}, {{ UINT64_C(0x55a02338d60ab758), UINT64_C(0x5fc7b91884290f48), UINT64_C(0x1a01ebf042cd77bc), UINT64_C(0xf48588b8601b15f8) }}, {{ UINT64_C(0xd28691dc5f92e91c), UINT64_C(0xb80132109f85ef24), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x27df87dc65ef0d30), UINT64_C(0x7a4b109898ce4bbc), UINT64_C(0x67a7a768adf3bf74), UINT64_C(0x7c76c8b0bbba5118) }}, {{ UINT64_C(0xbe972c0407390f20), UINT64_C(0x4c04ed207c09e3f0), UINT64_C(0x1faaec047948a870), UINT64_C(0x8f85da34189d5e20) }}, {{ UINT64_C(0x36c5f3846d2bdb58), UINT64_C(0x6b99fa68d82e2d0c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe8f1be24b3fd1a48), UINT64_C(0x13c6a7d0ab484afc), UINT64_C(0x15465ca4ce04f904), UINT64_C(0x6662430041e12ac0) }}, {{ UINT64_C(0x3bf3e8746d8f8218), UINT64_C(0x50169d88162107b8), UINT64_C(0x057cef540a9ccf98), UINT64_C(0xf9df5e287ed1a114) }}, {{ UINT64_C(0x8917ac9c4313e9f8), UINT64_C(0x25879bf09e5e8d4c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa02596e04230a888), UINT64_C(0xec5ee2344f57d23c), UINT64_C(0x8961491018f72234), UINT64_C(0x43abfbb8d4bc4ce8) }}, {{ UINT64_C(0x22459c6c5eeba684), UINT64_C(0x3a32dcb0d6f72fbc), UINT64_C(0xabe8c6c473e9e228), UINT64_C(0x68768c5492aaa670) }}, {{ UINT64_C(0x791f07183a462060), UINT64_C(0xa4840fc06c8095c4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6dd5d7dc0311f058), UINT64_C(0xda39a424662f8f60), UINT64_C(0xfcaa51b85ee95cb4), UINT64_C(0xc004e10c5341d4e4) }}, {{ UINT64_C(0x0ee76a2c521b55f0), UINT64_C(0x4f7ee02c33398470), UINT64_C(0x305d0b801e1fee78), UINT64_C(0x74d98e9410ab0e04) }}, {{ UINT64_C(0x74cc1fc4ce66d908), UINT64_C(0xae78c090975149d8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xddf1bb587a2c2504), UINT64_C(0x2b715ba4c09e494c), UINT64_C(0xbb8f93248365cca8), UINT64_C(0x633b05a86892bfe4) }}, {{ UINT64_C(0x90b1b44cf9cc485c), UINT64_C(0xa9f511201e36ed0c), UINT64_C(0x4f7cfdc0b0e8efb4), UINT64_C(0xa0595c40aa7bcf4c) }}, {{ UINT64_C(0xa6ca700cab0f7f70), UINT64_C(0xc532aac0bdf7cf24), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8ab8594c2393533c), UINT64_C(0xfc384ebcc6f6c00c), UINT64_C(0x5146a938ff8fe8cc), UINT64_C(0x65558e54371a6a50) }}, {{ UINT64_C(0xabe465b062c299b4), UINT64_C(0x516d25ac3fcc7838), UINT64_C(0xf3335e9867a86790), UINT64_C(0x4f3143180534880c) }}, {{ UINT64_C(0xcc4401a8bd6bef74), UINT64_C(0x4700c59c6348c290), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5c664b84b6dfec3c), UINT64_C(0x00c08ad4ef7d8fb4), UINT64_C(0xbd47ed4cb8cff41c), UINT64_C(0xd046df8c1e844a0c) }}, {{ UINT64_C(0xe051771ce18d3914), UINT64_C(0x8576259c8a2cdee4), UINT64_C(0xf8fe8464ade044e8), UINT64_C(0xa62bd248a848dd28) }}, {{ UINT64_C(0x2fc863e42eaa4678), UINT64_C(0x9e245a00996391cc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x96e9a24c17b95104), UINT64_C(0x765018e896748dbc), UINT64_C(0x399cd39c438df13c), UINT64_C(0xbaa5e0086fc610bc) }}, {{ UINT64_C(0x01c3aec440905ea0), UINT64_C(0xad6010c4a518cf3c), UINT64_C(0xeb2bf6d4c8086c98), UINT64_C(0x3b2f12241b8e0e48) }}, {{ UINT64_C(0x5ca16bec10876f70), UINT64_C(0x78bf6ea481098b60), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3c045f780687a8d0), UINT64_C(0xf1e4d72c1de30a28), UINT64_C(0xbd9d9b58d5639a44), UINT64_C(0x84033bfc607e8a6c) }}, {{ UINT64_C(0x55832810ba1dfdb8), UINT64_C(0xe275414cd6f3f75c), UINT64_C(0x8cdda644418e9b24), UINT64_C(0x03862a60b64dd8e8) }}, {{ UINT64_C(0x11dbf1d468614354), UINT64_C(0x7dbf2fbc068d41b8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6dc242fcc79ffca4), UINT64_C(0xbd169ec0302a0914), UINT64_C(0x373571440b1ef7b4), UINT64_C(0x85bd2a643a7d4e14) }}, {{ UINT64_C(0x822829bcb50c7cec), UINT64_C(0xe4b3158cbb0ee4a0), UINT64_C(0xe6754fc4d0f74c5c), UINT64_C(0xa436f3086a8d8274) }}, {{ UINT64_C(0xd1ae26c8fe1b46fc), UINT64_C(0x71158908b778beb0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4e186ccc91dcb570), UINT64_C(0x7ad1bf48c6a54344), UINT64_C(0xd19d30d8e02763f4), UINT64_C(0xef9fd718010e06b8) }}, {{ UINT64_C(0xab0f40c0ce3f1330), UINT64_C(0xc86c76444b6183e8), UINT64_C(0x338304c83df5a0d0), UINT64_C(0x3fa02334de1ee18c) }}, {{ UINT64_C(0xdd140834050c811c), UINT64_C(0x105a8a289fb6fbd4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdf9d0c34a923cf18), UINT64_C(0x31b4b408faebeb10), UINT64_C(0xc5e36ce0709608ec), UINT64_C(0x2ecfb0a8020a43f0) }}, {{ UINT64_C(0xebafc990b0467d50), UINT64_C(0x74548bb4251f6ac8), UINT64_C(0x7806d1d8778115e0), UINT64_C(0x167d8a44b50e4b2c) }}, {{ UINT64_C(0x17c9ffb8168ba9c8), UINT64_C(0xda4b1e44f2ee61fc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2c57b7b89bb14e98), UINT64_C(0xb7924a1c69a1e400), UINT64_C(0x1b88a4acb66321e8), UINT64_C(0x49e24ab096306f50) }}, {{ UINT64_C(0xb9c36a44ac1993fc), UINT64_C(0x53007b2069c6edd0), UINT64_C(0x733c553c64edf45c), UINT64_C(0x43fbcae893e76a2c) }}, {{ UINT64_C(0x8365b60449e04298), UINT64_C(0xc03a477033333a30), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb5e26b806433fe28), UINT64_C(0x5cf3ac381e5508c4), UINT64_C(0xe6870dac190ff2a4), UINT64_C(0x8057c49ce1229430) }}, {{ UINT64_C(0xae482264e47376bc), UINT64_C(0xd9ae595088538148), UINT64_C(0x683d49cce5856bec), UINT64_C(0x774154ec2b8aeb2c) }}, {{ UINT64_C(0xf5134cd413a2de6c), UINT64_C(0x825dab806f68f8a4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7b73495c747019b0), UINT64_C(0x3ea5a53ca2e5bd9c), UINT64_C(0x751ccc20f7af8298), UINT64_C(0x6db5006c2c615a50) }}, {{ UINT64_C(0x891a5df4c51037d4), UINT64_C(0xf328b17cb355035c), UINT64_C(0x6f7ee5f4513f9e44), UINT64_C(0xc97134d4d628a684) }}, {{ UINT64_C(0x8c7256b89b238e34), UINT64_C(0x24e44dfcbfb45ff4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa7f336284877d5cc), UINT64_C(0x2a3fe3b4acdc8e94), UINT64_C(0xf94a7d9464236d9c), UINT64_C(0x71ca088c7f2fcc30) }}, {{ UINT64_C(0x00cb46d82f3882a8), UINT64_C(0xc15af9041ee37f00), UINT64_C(0x3e60d2e09f93a040), UINT64_C(0x6cdb616c4ef55880) }}, {{ UINT64_C(0x381609b444157dd8), UINT64_C(0x287f7238598bcf0c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x05f6e5e8d184eeac), UINT64_C(0xdab90e841ce85a38), UINT64_C(0x1918ab64eafbabb0), UINT64_C(0xe3171dc49f0c130c) }}, {{ UINT64_C(0x5bd0ba24464dd350), UINT64_C(0x6985597c87d0c134), UINT64_C(0x5ae0b39c09849830), UINT64_C(0xa51d5ef0da4bca14) }}, {{ UINT64_C(0xa49a5c00277f8428), UINT64_C(0x11c91a94c1332ed0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x17ff64a8ef76a9f0), UINT64_C(0xeb1b510cdbdb7acc), UINT64_C(0x5d53a7f8b71dde14), UINT64_C(0x3be984d060e67100) }}, {{ UINT64_C(0xcdc40314e9411eb8), UINT64_C(0x90a9d0e88c413348), UINT64_C(0x3ad38728e43e9b8c), UINT64_C(0xda06e648775ec328) }}, {{ UINT64_C(0x613040a4a5db7350), UINT64_C(0x6e293860ea23e88c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0ab9b1d4ebba4d0c), UINT64_C(0x316faf1466117b50), UINT64_C(0x3aa6d3a0708ee48c), UINT64_C(0x87585c0c8b020994) }}, {{ UINT64_C(0x99ae69e05edf9ff8), UINT64_C(0xd47bdb50259b16d8), UINT64_C(0xf1fbc8a08d56ffe8), UINT64_C(0xa102a6d011af7978) }}, {{ UINT64_C(0x0ae38d78f1d9bcdc), UINT64_C(0xdf0c6e20e9cf9d38), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb6a13758400a95b0), UINT64_C(0xffb5ca980f1d2e2c), UINT64_C(0x43d94d60dd29ac34), UINT64_C(0x1a04df880cd6b7c8) }}, {{ UINT64_C(0xece382bc0f32acac), UINT64_C(0xd91a58148a48fa34), UINT64_C(0x9b42f01cfbbb919c), UINT64_C(0x38055de42785ead8) }}, {{ UINT64_C(0x17b176d4e8d91e38), UINT64_C(0x5e8f6b70e4eea608), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9830219856b3b8e8), UINT64_C(0x11cb7f7cb33d690c), UINT64_C(0x434e2ad8c9941eec), UINT64_C(0x12dbb3003858882c) }}, {{ UINT64_C(0x1cb579d86c920e34), UINT64_C(0x83070560700580b8), UINT64_C(0xb47d1b786713b334), UINT64_C(0x752c3564ca91bd4c) }}, {{ UINT64_C(0x65c757c80d401540), UINT64_C(0xef3b8b2caded7a94), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x58ce663cf10d523c), UINT64_C(0x9d752d5c780f60f8), UINT64_C(0x0cde9dcc81aeeab8), UINT64_C(0xca5c9b20ceb11e38) }}, {{ UINT64_C(0xaf9528f8273f895c), UINT64_C(0xf7225e0874a74288), UINT64_C(0xfead0688d88c9758), UINT64_C(0x68ad8308a14f2140) }}, {{ UINT64_C(0x73aed8ecd6d1920c), UINT64_C(0xc28be4f8c45eaeb4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8df3daf05b06e39c), UINT64_C(0xd9f61ff4cd1e04d4), UINT64_C(0xb02954f8ec239abc), UINT64_C(0xd72bc7b0a01fbc40) }}, {{ UINT64_C(0x18b216c81285fb74), UINT64_C(0x3523e320969d6aac), UINT64_C(0x649072a0ad997788), UINT64_C(0xffe2ab84f2289114) }}, {{ UINT64_C(0x352bd2d83e8d1518), UINT64_C(0x7fd968801e22d4a8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa82a5dac17ad9114), UINT64_C(0xb5f26ea879e04b48), UINT64_C(0xd0d6f0742b39b9bc), UINT64_C(0xdccfed9ce9ed2338) }}, {{ UINT64_C(0x7cc4cbdc57b78354), UINT64_C(0x80ca4aac3b7f4b54), UINT64_C(0x09f280cc3d7a2890), UINT64_C(0xa0d0e044b65c6c28) }}, {{ UINT64_C(0xf9265288b30ca038), UINT64_C(0xbb1a0e0c6fcf2498), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe646c934e25fbf20), UINT64_C(0x5725ce14b9ff1398), UINT64_C(0xd6dd6a2856901f14), UINT64_C(0x93f1c66812ee3c1c) }}, {{ UINT64_C(0xd1d0bf58cc88d040), UINT64_C(0xe7d58cd4fc62d818), UINT64_C(0x252c04844dac05fc), UINT64_C(0x5fab5cc4a0d1cccc) }}, {{ UINT64_C(0x352f916025c1bf90), UINT64_C(0x4e2ba450696a7ee4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0ac79e0cb9fa22cc), UINT64_C(0x0ab405f89e0feeac), UINT64_C(0xa7593b28d451bdd4), UINT64_C(0xddb077c052a867c8) }}, {{ UINT64_C(0x7d1cd41005a8e2a8), UINT64_C(0x0193ed7065fc2b50), UINT64_C(0x5fe83478e5a6ad28), UINT64_C(0x532c0c007cb657cc) }}, {{ UINT64_C(0x05914cacd2b2a474), UINT64_C(0xd39bd2f418015b54), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9ed0dbbced115bc4), UINT64_C(0x114b0a5c7c48a508), UINT64_C(0x4285a75463018b84), UINT64_C(0x33d5a3484c34b9f4) }}, {{ UINT64_C(0x1c96ad681393a9f8), UINT64_C(0x8cd607684d513c00), UINT64_C(0x58d22ab0c5c158ec), UINT64_C(0x688562d422d93760) }}, {{ UINT64_C(0x75931630ab6737b8), UINT64_C(0xc992a18449f0e514), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7cfc3bc889fe71c8), UINT64_C(0xb2d8e170243a2828), UINT64_C(0xfa6ae500daa584e0), UINT64_C(0x31397b34bb04f3d4) }}, {{ UINT64_C(0xbd7c3ad0c40378c8), UINT64_C(0x9e9ed5cc7ad8cdcc), UINT64_C(0xff162898a9734d7c), UINT64_C(0xd3f4286c0bb0c938) }}, {{ UINT64_C(0x410139d4741db3f8), UINT64_C(0x34279a2ca864f540), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc33ff06822305d54), UINT64_C(0x278b2dc405b93438), UINT64_C(0x668f2de0ee364aac), UINT64_C(0xf7e9789cc85d40bc) }}, {{ UINT64_C(0xaed794dcb60c76f4), UINT64_C(0xedf47ac0d810c318), UINT64_C(0x844f8f5c1acb21b0), UINT64_C(0x66dee49c7d87a1c4) }}, {{ UINT64_C(0x21fb03c0793a28e8), UINT64_C(0x149a81a4efa7e63c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xab0d1ec423eca748), UINT64_C(0x24eedc24067faea0), UINT64_C(0xa68dd13866faab58), UINT64_C(0x32e77a5c59ce317c) }}, {{ UINT64_C(0x1fe88c3cfef3c6c4), UINT64_C(0xf4c429f4e82f9d2c), UINT64_C(0x221cb400371fe4f0), UINT64_C(0xbf08c0386f76f600) }}, {{ UINT64_C(0x109610a88806a6dc), UINT64_C(0xa88ddb789a606728), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb1008a0cbd58ca28), UINT64_C(0x8e56f0a48d365364), UINT64_C(0x9bee93301c306c28), UINT64_C(0x4121ac884f20b804) }}, {{ UINT64_C(0xd9cae36cc834f254), UINT64_C(0xcddee1c47a5ad694), UINT64_C(0x5b016264c752d0bc), UINT64_C(0x55d3540096b37fac) }}, {{ UINT64_C(0xa8b0d1b4169626dc), UINT64_C(0x8e33e8845ffddd8c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3cd77f60576b5b24), UINT64_C(0x99d5f82840b7ddec), UINT64_C(0xdc7faa547a38b248), UINT64_C(0x4a4d94d8dc89348c) }}, {{ UINT64_C(0x07c517b078c4b9a0), UINT64_C(0x730bd1544f2e8654), UINT64_C(0xfccbe4b4ead85644), UINT64_C(0xb2258f10fb055290) }}, {{ UINT64_C(0xb96f06c8ff58c590), UINT64_C(0x10e2d6b4237635a8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2bd8f89c51e20df8), UINT64_C(0x68e2b99c82a0b9dc), UINT64_C(0x39826f3c7c818cac), UINT64_C(0x547bd398d27349e4) }}, {{ UINT64_C(0xfa4fb38c2715e114), UINT64_C(0x5d817ef86ec78b68), UINT64_C(0x9d0b6df412ed30c4), UINT64_C(0x34c4d58076908804) }}, {{ UINT64_C(0xcdb4b9547f6fa740), UINT64_C(0xe392146c4a80586c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x359ae1f424d6d4d4), UINT64_C(0xdc0e04442bcfd754), UINT64_C(0xaa9b5f08633e1a78), UINT64_C(0x2593b63ca5f9ad5c) }}, {{ UINT64_C(0xd51a8db42b8c1eec), UINT64_C(0xfa9f4828f32d7e90), UINT64_C(0xbc8657a4bdf6a91c), UINT64_C(0x48ca952ca0e2c2fc) }}, {{ UINT64_C(0x08e9a768a681b678), UINT64_C(0x062d1d40acfb487c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8fc53e9485d0ed40), UINT64_C(0x20d81404f97d3b40), UINT64_C(0x047b807ca4758124), UINT64_C(0x35986e9494efeed4) }}, {{ UINT64_C(0x1ea49cec1e6b49fc), UINT64_C(0xb4268b887da868f8), UINT64_C(0x40c61af8641f5844), UINT64_C(0x111c848c9a64b90c) }}, {{ UINT64_C(0xa3763e3c0ace5768), UINT64_C(0x67a807f8519802bc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9fe10a8c16c2890c), UINT64_C(0xb6d4f754a61d8fec), UINT64_C(0xfde2f050538d21d4), UINT64_C(0xb7a7944c7aaa5bb4) }}, {{ UINT64_C(0x4755254c7d582ca4), UINT64_C(0xfc027c90a248d114), UINT64_C(0x2c4f99f81723d954), UINT64_C(0xd68c8a349842021c) }}, {{ UINT64_C(0xb02218cca42a4f48), UINT64_C(0x4eb37c201a27c134), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x347c7ca4d076966c), UINT64_C(0x8c02bda85b433010), UINT64_C(0xdc6f3b08338e787c), UINT64_C(0x212d705c3ccac260) }}, {{ UINT64_C(0xe7654014d3e190cc), UINT64_C(0xabcfee449014e484), UINT64_C(0x6f9cfb24a599a7c4), UINT64_C(0x710bec7050427c64) }}, {{ UINT64_C(0xaa34d6f0f4dd27ac), UINT64_C(0xe4a78a4842983bb4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc54384a4e0c6f5f4), UINT64_C(0xd7c4e728784f4520), UINT64_C(0xc510f3c80b903ec4), UINT64_C(0xf2c77ed03fd70250) }}, {{ UINT64_C(0xb9e3e6a8b8417dc8), UINT64_C(0x16c09d9cb204ed9c), UINT64_C(0x0c6eab249e41d114), UINT64_C(0xf051b2e4ae93b914) }}, {{ UINT64_C(0x13ff7f8c1a16fb38), UINT64_C(0x98a837fc26cbf058), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xee15c9cc0d83c134), UINT64_C(0x08d06d20aa91d9d8), UINT64_C(0xd7405dc458f89700), UINT64_C(0xa40848380d56987c) }}, {{ UINT64_C(0xa73c32d8ee4cc5c4), UINT64_C(0x53c87b603eec5900), UINT64_C(0x76fab7bcaa53176c), UINT64_C(0xe5d5bf88b06390cc) }}, {{ UINT64_C(0x8a32287c24e89864), UINT64_C(0xca2ea1a8a7524478), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5a3c1b48dc35ea0c), UINT64_C(0x49342d4c40015f10), UINT64_C(0x2309dbb0cdd7b350), UINT64_C(0x4ed803881af9e384) }}, {{ UINT64_C(0x67c631d0bf6cdbbc), UINT64_C(0xc37811fc2fa639b0), UINT64_C(0xfc82e7e06b55b1d8), UINT64_C(0x36365550e3ba1a28) }}, {{ UINT64_C(0xbf53b04817782894), UINT64_C(0x2a7388881e569abc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8f0a0a4c1fd18df8), UINT64_C(0xf46e22283c61f02c), UINT64_C(0x18c08270f8a23a4c), UINT64_C(0x079a15543c3b4eac) }}, {{ UINT64_C(0x1b610adcce4caffc), UINT64_C(0x66dec4702928a008), UINT64_C(0x0d479ae8f79cdb78), UINT64_C(0x59ee98d0b62a4a24) }}, {{ UINT64_C(0x778c78988325299c), UINT64_C(0xa167a898a1376b60), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdfea92687d9fd944), UINT64_C(0x59e8371ca7618498), UINT64_C(0x51195d2cee83edf0), UINT64_C(0x7c0108b495be8518) }}, {{ UINT64_C(0x43368980c27b87e8), UINT64_C(0x1cb74d04e9f6ab88), UINT64_C(0x786dd8b8b62ff93c), UINT64_C(0x087317b8fcd31890) }}, {{ UINT64_C(0x1febbeacf61ad99c), UINT64_C(0x72a0a68841dc4018), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2ef35964d1f49078), UINT64_C(0x9a9470f866dc5320), UINT64_C(0x4815de6c55d70aa8), UINT64_C(0x5cede4141ac84164) }}, {{ UINT64_C(0x1495a8781771fc38), UINT64_C(0x7f4f37b01ef011a0), UINT64_C(0x080d022c98d0de94), UINT64_C(0x38c4dec46c085c40) }}, {{ UINT64_C(0x497e03f0b39cd25c), UINT64_C(0x5bb7502074e17544), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5d6c97906579a334), UINT64_C(0x26ffd1bcee6a9208), UINT64_C(0x0119cb9c090a5b68), UINT64_C(0xf9b13a54e5cb0a00) }}, {{ UINT64_C(0x93db793cbdc89c0c), UINT64_C(0xb18da4146a8329c8), UINT64_C(0x46a4c44c0d63a4cc), UINT64_C(0x02f49a9430677624) }}, {{ UINT64_C(0x5cbfafa400f4a628), UINT64_C(0xfacbe6a8d72459e0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xcaf83d50d7b29078), UINT64_C(0x2fcd8490cfda69c8), UINT64_C(0x0934dac069e40e5c), UINT64_C(0x0091888c36260b48) }}, {{ UINT64_C(0xb88212501f615a44), UINT64_C(0x66df49403df09bb4), UINT64_C(0xd6aaa14c54ad142c), UINT64_C(0x1488fcbc8c89e564) }}, {{ UINT64_C(0x2803850ccf8eac7c), UINT64_C(0x303d60f8c49f12e4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc5a39224a10c92b0), UINT64_C(0x5ac43f183cbe5028), UINT64_C(0x774d50e47d59cc2c), UINT64_C(0x047aeab01b5a0308) }}, {{ UINT64_C(0x63bf6678a938b6ec), UINT64_C(0x409dedc072550ec8), UINT64_C(0x23660e1c9914c840), UINT64_C(0x306d3ce00949951c) }}, {{ UINT64_C(0x1ae1b2dc7443db2c), UINT64_C(0xcd4f6618a57fc53c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8bccc170c10dd5f0), UINT64_C(0xb34342582bd5114c), UINT64_C(0x5def0b8813c5bbd4), UINT64_C(0x200697ccfc368e00) }}, {{ UINT64_C(0x3c43b4ec288ab844), UINT64_C(0x9ef0f984c6f9b348), UINT64_C(0x8422d1ac45a8a430), UINT64_C(0x4fd91af09d7bdea4) }}, {{ UINT64_C(0x070938d4e2fe736c), UINT64_C(0x3508a010690fa6f0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc8fdbd608954f6f8), UINT64_C(0xc6dda7842612edf4), UINT64_C(0xb76ceb341034ae8c), UINT64_C(0xf1fc71a486d69ab0) }}, {{ UINT64_C(0xf60785a4886240a0), UINT64_C(0x1e797d44c641ccd0), UINT64_C(0xc4616c18ac4702d0), UINT64_C(0x33d170e0c6f6be60) }}, {{ UINT64_C(0xaf84d7980b3c00a0), UINT64_C(0xd7ffeae07143bcf0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4f6985945e1470a8), UINT64_C(0x09168b645f78d124), UINT64_C(0x10bb19e40a6bd754), UINT64_C(0xce26025420de8dec) }}, {{ UINT64_C(0xfb10df582bd19108), UINT64_C(0x16b1bcd479df8954), UINT64_C(0x5169ee0015ecc738), UINT64_C(0x87d1f2c86c3d7940) }}, {{ UINT64_C(0x311c6e2cbbd02c48), UINT64_C(0x36837accc1fd2f8c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdc6ee7ecf177de74), UINT64_C(0x829a9ef0dc71a0c8), UINT64_C(0x49e880f00019c124), UINT64_C(0xa12c094ca6735abc) }}, {{ UINT64_C(0x9c820b58a79c83e8), UINT64_C(0x0086ff24b1df7ff8), UINT64_C(0x103dd9a02c22b938), UINT64_C(0xc58e27b8d0df4db4) }}, {{ UINT64_C(0x5cce932cfaa27938), UINT64_C(0x8160df1c31083e28), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf832c5f4a41b7c98), UINT64_C(0xb528bb2cbd9c5538), UINT64_C(0x967482f892785260), UINT64_C(0xe52161dcd03f1144) }}, {{ UINT64_C(0xa34bbf2cdec2fab8), UINT64_C(0x42609bcc56968898), UINT64_C(0xc49b3280c514e764), UINT64_C(0xf57af9d8669b1ebc) }}, {{ UINT64_C(0x800aae2078d5c354), UINT64_C(0xa79e199c089f764c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe356c09482de7d8c), UINT64_C(0xc7835254ffc07608), UINT64_C(0xb2a11378a9e0661c), UINT64_C(0xefcf0b0018f66724) }}, {{ UINT64_C(0xeb890a7c7c64ecdc), UINT64_C(0x7cc6c6541ac1e7f0), UINT64_C(0x3f718b24fb587c2c), UINT64_C(0xc457b65052ee29b4) }}, {{ UINT64_C(0x85f4daa86b3af890), UINT64_C(0xf4ff030811e52cac), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8d17d3a4918ac414), UINT64_C(0x2d5a2834959a3670), UINT64_C(0xec208accf7f0fc00), UINT64_C(0x46e7a828f5073d2c) }}, {{ UINT64_C(0x1aa679949d193fa8), UINT64_C(0x027eca78f143d1a0), UINT64_C(0x1de08c50d1f22498), UINT64_C(0x6002d9246a3e7e9c) }}, {{ UINT64_C(0xb6891ac81228907c), UINT64_C(0x128400083a937650), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8d51c08012920e48), UINT64_C(0x68cff050194c6758), UINT64_C(0xbb2a94e037773b78), UINT64_C(0x85803330de689f04) }}, {{ UINT64_C(0xdf829068ddb833a4), UINT64_C(0xcee6c4906d6373e0), UINT64_C(0xb6c7af24b3ba9120), UINT64_C(0xb875d44c706e70e0) }}, {{ UINT64_C(0xd9e8ba24d968aadc), UINT64_C(0x62564c0069b3fc00), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x04607a5c36968a88), UINT64_C(0x38f911509ac84508), UINT64_C(0x90b838b00c0070a8), UINT64_C(0x0b940690c7692e50) }}, {{ UINT64_C(0x1a361ca0f3bbd2c4), UINT64_C(0x2e2a89505ac435e4), UINT64_C(0xab8448b80518c6b0), UINT64_C(0xd584d100380db5dc) }}, {{ UINT64_C(0x5f9126907fa89854), UINT64_C(0x6af59a70c1a6ca40), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x0f0b31bce61ddeb8), UINT64_C(0xc27581acd6d8fb2c), UINT64_C(0x9d8a00105a5bd17c), UINT64_C(0xd0a0f304ff79445c) }}, {{ UINT64_C(0x8736aea86d3636ac), UINT64_C(0xad234b2c63ba8f28), UINT64_C(0x00dec5587d7f4c60), UINT64_C(0x84e09224ce17dc5c) }}, {{ UINT64_C(0xef9b8c78cd1f71ac), UINT64_C(0xaf571f1c620441ac), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3d394c10248ce180), UINT64_C(0x6e69ccf4d1f86194), UINT64_C(0xeed4d2a018354214), UINT64_C(0xcf991520249f930c) }}, {{ UINT64_C(0xaaac1dd093de0214), UINT64_C(0x2ef7d428b8e75de4), UINT64_C(0x0d2168c4832dda10), UINT64_C(0x507fabacf6fcd4d4) }}, {{ UINT64_C(0xc0dda2d48dcee838), UINT64_C(0x8ee7a880e19f25ac), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe4127fc4bbf3ac74), UINT64_C(0x4fb435c8e7791b04), UINT64_C(0x1414e11cc2ae87bc), UINT64_C(0xb6e7b0a8fe38c5e4) }}, {{ UINT64_C(0xf3669aa092531204), UINT64_C(0xcaf731fc884788dc), UINT64_C(0x0327e8bc6cf110b8), UINT64_C(0xbd17f694a854f850) }}, {{ UINT64_C(0x1a73ea186c74733c), UINT64_C(0xaa2943048dd9aa78), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf0fd3824d30c64fc), UINT64_C(0x795d2f20076e4264), UINT64_C(0xa92aa6009dd011b8), UINT64_C(0xc1cb595846b7a950) }}, {{ UINT64_C(0x4c6bb4cc3be3f334), UINT64_C(0x65a72e58a66d0878), UINT64_C(0x71b46b808dd55898), UINT64_C(0x77421fb4e5a6b0c8) }}, {{ UINT64_C(0xbfaa3ffc799770f0), UINT64_C(0x1ce0677834a8b740), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f2b43c06b409504), UINT64_C(0x44640e507b085dd0), UINT64_C(0x394d6c38fcc3b85c), UINT64_C(0xed1866b44c616510) }}, {{ UINT64_C(0x59800c78e6313ef0), UINT64_C(0xbc6eb51870b449a4), UINT64_C(0xb4a44718e2d53be4), UINT64_C(0x587d5104eacba970) }}, {{ UINT64_C(0x42aa62d808272b48), UINT64_C(0x6dfe37dc02e0ac40), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x834afd9c91a1e174), UINT64_C(0x98cafa28afb146d8), UINT64_C(0xd133f314f562ee08), UINT64_C(0xc83bb4ec8b290b90) }}, {{ UINT64_C(0x4ae8d438772b2dc8), UINT64_C(0xc9872a68e44dc1a8), UINT64_C(0x85465bf49a108c60), UINT64_C(0x09d657cc6bcf99c0) }}, {{ UINT64_C(0x80d91730e79883a0), UINT64_C(0x70f6aa3c688241f4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x06350ae413df116c), UINT64_C(0x266af9a0cd8540cc), UINT64_C(0xf36f91104c93cddc), UINT64_C(0xb2ace610176b853c) }}, {{ UINT64_C(0x900f9674dcdb7d50), UINT64_C(0x2bca25dc23f86978), UINT64_C(0x8c6e336033b6e810), UINT64_C(0x98e8932c7b1ec498) }}, {{ UINT64_C(0xea4bbe286f295ab8), UINT64_C(0x204e75e0fdbebfc0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x37b91f40a340c888), UINT64_C(0x46c88ca41135fc14), UINT64_C(0xc53f525851a21274), UINT64_C(0x5c99256c4b33e98c) }}, {{ UINT64_C(0x5c4396148c0d47d0), UINT64_C(0x7136e7eca54eb4b4), UINT64_C(0x9fc6f480f626889c), UINT64_C(0x482004b4ac287308) }}, {{ UINT64_C(0xd4630a4c52eddb50), UINT64_C(0x3a4f5f68eef67cd8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa295c5cc6868d12c), UINT64_C(0x8336ea44aab067f0), UINT64_C(0x04e848a8e8db9104), UINT64_C(0x9f8d9174b66b8438) }}, {{ UINT64_C(0xf7d142a834af60fc), UINT64_C(0xaa17755c2e601310), UINT64_C(0xc633578c5150468c), UINT64_C(0xfe483c6c9b8eab40) }}, {{ UINT64_C(0x9f2220a4c57dc370), UINT64_C(0x67d6b6889a016a98), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7920b2b483add588), UINT64_C(0x1c820064a8859018), UINT64_C(0x733254b42dc9e900), UINT64_C(0x3e8e450c936867fc) }}, {{ UINT64_C(0x1c873c3c7731836c), UINT64_C(0x062eb50481602dd8), UINT64_C(0x5dc46064fa5f570c), UINT64_C(0xc4ba61fc480790c0) }}, {{ UINT64_C(0x13e63528e3be8024), UINT64_C(0x6bec09203f781b70), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x2a9ca3c430323b48), UINT64_C(0x314d9558ccffe080), UINT64_C(0x8ab0494c3c73d6e0), UINT64_C(0x654a6c7067ad5470) }}, {{ UINT64_C(0x3b28af78fc6d39c8), UINT64_C(0x1d56775455865940), UINT64_C(0xe0904d88d9ced2d8), UINT64_C(0xff95cf8807410cd4) }}, {{ UINT64_C(0x90f928b02d133e18), UINT64_C(0x5c1630c8ec825168), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3fce4798a8ca55d8), UINT64_C(0xe1681f50d2809e4c), UINT64_C(0x677db50c79617050), UINT64_C(0x29bc7a28faaf14dc) }}, {{ UINT64_C(0xa07c1e64b934d654), UINT64_C(0x0ddf1f2017867e88), UINT64_C(0x9f2eaddcdca4b930), UINT64_C(0x836be22cecaea33c) }}, {{ UINT64_C(0xec6279b035fa8698), UINT64_C(0xc3a68f548e7ea250), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6a318048e37e7288), UINT64_C(0x7a53bee8fd6b58bc), UINT64_C(0x36e72a9c2f2b1610), UINT64_C(0xadf6e4a8a231de38) }}, {{ UINT64_C(0xbfbd39ec8238ee3c), UINT64_C(0xb1fc35c44eb513e4), UINT64_C(0x6f68b6209fea593c), UINT64_C(0x21e5ff2823bf6db8) }}, {{ UINT64_C(0xa4748f98de137098), UINT64_C(0xb1b2aff08f25c98c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa0ed70602d0461c4), UINT64_C(0x3c2ed08cf67ff8b8), UINT64_C(0xbc166b509928c168), UINT64_C(0xf15be428ef2a939c) }}, {{ UINT64_C(0x259f1fccfcde0574), UINT64_C(0x6af91f0003cfa2c0), UINT64_C(0xb542897c37506830), UINT64_C(0x58b7e1c8857a5a68) }}, {{ UINT64_C(0xe3fa0d80379eab38), UINT64_C(0x4a74d8e4600c9414), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc94c5fac6ee92edc), UINT64_C(0x15e67b807b57c5b8), UINT64_C(0xafd36d7c059e89f0), UINT64_C(0x83caf9e075dbed0c) }}, {{ UINT64_C(0x7bf7d530b91964b8), UINT64_C(0x22c798dc07a8303c), UINT64_C(0xad3ba32c880538b4), UINT64_C(0xe4c8a1804943d924) }}, {{ UINT64_C(0x20a8827c43a34e40), UINT64_C(0xa4043f50616ede9c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc70374e4bcb7a204), UINT64_C(0xcef220804b18f5c8), UINT64_C(0x2a8668e0496a2554), UINT64_C(0xd9e071c8709856ac) }}, {{ UINT64_C(0x3f43c40c1bf8c6d0), UINT64_C(0x56e0b1646bde52b0), UINT64_C(0xf67ea06882116778), UINT64_C(0xf715a46ce6f83670) }}, {{ UINT64_C(0x12760f20a0a80fe0), UINT64_C(0xde8b31d02be2d3d0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3f012fd8226c57ac), UINT64_C(0xf560af48ad195b94), UINT64_C(0x90954a24115a65fc), UINT64_C(0x281c82b0d025d258) }}, {{ UINT64_C(0x961045180ea26420), UINT64_C(0x98319d3857d4c754), UINT64_C(0x90769ae84cffda24), UINT64_C(0x6bb900701f67a7b8) }}, {{ UINT64_C(0x3af8a36055802414), UINT64_C(0x80964db87a8c7e84), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaf13ecb085a62f98), UINT64_C(0x4278ccb457f83e48), UINT64_C(0xc5a8c2a8225f2930), UINT64_C(0xe437de6c202749d8) }}, {{ UINT64_C(0x628929c8dd96dab8), UINT64_C(0x67803a84464ea440), UINT64_C(0x8f716fa468d192c4), UINT64_C(0xdab4a84034f487a4) }}, {{ UINT64_C(0x93c53da47c12d4f8), UINT64_C(0x07b8f16c0de67b04), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa37695b49b6f8428), UINT64_C(0x76120808efbc3c38), UINT64_C(0x7cabaf1c27737790), UINT64_C(0x636777d8b4855cec) }}, {{ UINT64_C(0x4294f2048e5f3bb8), UINT64_C(0x6a8c75ac171ca2ec), UINT64_C(0x3e32ff7060350c38), UINT64_C(0x14a33f88c98be798) }}, {{ UINT64_C(0xc815baa0bc4be7f4), UINT64_C(0xb43632748a7d765c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x22ffac403086ae40), UINT64_C(0x822afa802ac6e3d4), UINT64_C(0x59f2ab48b635f074), UINT64_C(0xe8b2ca5407c42374) }}, {{ UINT64_C(0x49e14a905d087068), UINT64_C(0x31ea24d82c434d54), UINT64_C(0xb0087a5ce18a2298), UINT64_C(0x4475f970118357b0) }}, {{ UINT64_C(0x3d1c62e81f15d664), UINT64_C(0xba6a822c449b4fb8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x302e4a186ffa3f90), UINT64_C(0x76bf16c0f9f063dc), UINT64_C(0x994e3190f88b2bac), UINT64_C(0x5e8ef60cf88d3118) }}, {{ UINT64_C(0x61b784f0247d30b0), UINT64_C(0x4db2f0c0aa53fc04), UINT64_C(0xbe09042c662d5e5c), UINT64_C(0xf01a6f80ed95cb74) }}, {{ UINT64_C(0x6810fe545b39ac60), UINT64_C(0x28b839e4c7a290cc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x64b2cd64d2931d48), UINT64_C(0xfc832f88c50383fc), UINT64_C(0x458289b4ae888fc0), UINT64_C(0x1af9c5cc634d60f8) }}, {{ UINT64_C(0x8fc6e358d2cf2a38), UINT64_C(0xc6b52af83f0ad078), UINT64_C(0x5928fe9c95bea03c), UINT64_C(0x064973b07a5c6ab8) }}, {{ UINT64_C(0xe505971c61a671c8), UINT64_C(0xfe992814ea61ce54), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd477ebd44c821bb0), UINT64_C(0x41a9019829e3e114), UINT64_C(0xd3ac3f2cdacfb8d0), UINT64_C(0x3a5412d86dfd686c) }}, {{ UINT64_C(0x4ca8e694f50f3a04), UINT64_C(0x701396ac1f1a3074), UINT64_C(0xe8f662687f20d4bc), UINT64_C(0x403c13ecfb38c50c) }}, {{ UINT64_C(0xa67845ec69e85578), UINT64_C(0xb87a89e0128f282c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xdf5bde782e297010), UINT64_C(0xd90c487c1e61f6a4), UINT64_C(0x0ce24f00cc5dc714), UINT64_C(0xbc1a239cd8d00754) }}, {{ UINT64_C(0x748e7cb0f81b2864), UINT64_C(0x2de1ecd4706c30f8), UINT64_C(0x6a20e2781ab6bd00), UINT64_C(0x9a02935cbd50a268) }}, {{ UINT64_C(0x4c70fc8806bc6480), UINT64_C(0xc9fe7220ab511d94), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xd0fed61cee0774f8), UINT64_C(0xc5ae3fb4697cfbb0), UINT64_C(0x9ad89f5cbeb29d34), UINT64_C(0xab2ea3c03d95f8d4) }}, {{ UINT64_C(0x8bf30e08a4bd7ea0), UINT64_C(0x35ea95f42ef2af1c), UINT64_C(0x58ed6f80f163ab20), UINT64_C(0xb373bad012eee218) }}, {{ UINT64_C(0x02100858dbfeb6b0), UINT64_C(0x37d0d57c6e1fe690), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x97bff578b41d38d4), UINT64_C(0xafd3e1e04329f958), UINT64_C(0xd59c3304e2cae098), UINT64_C(0x84fe6d6815d4e9b4) }}, {{ UINT64_C(0x09a71fb827b8c0c0), UINT64_C(0xaddb12b4be3b8854), UINT64_C(0x8eaf90f4236ebc9c), UINT64_C(0x72bb19e09b11ac98) }}, {{ UINT64_C(0x58a9ae502547d970), UINT64_C(0x8918f5f8d41bce24), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xa159e6501d201290), UINT64_C(0xac97407cec478640), UINT64_C(0xd101dce4907a04bc), UINT64_C(0x1e9af26818b333b0) }}, {{ UINT64_C(0xf82b12e4998bfbf8), UINT64_C(0x3bed341c1bcca8c0), UINT64_C(0x0770323cd4d752a8), UINT64_C(0xf80f0418eaeb64e8) }}, {{ UINT64_C(0xc0f6f6604947da98), UINT64_C(0x2d138bc858b582c4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5f99d478d78caff4), UINT64_C(0xa128cbc4a3579860), UINT64_C(0x7d486c04d1078010), UINT64_C(0x757fe1646c85f69c) }}, {{ UINT64_C(0xb96250088f6aac50), UINT64_C(0x3d87c96c5fcd4ec8), UINT64_C(0x3383764c380c7b2c), UINT64_C(0x6a85ebfc065d88e0) }}, {{ UINT64_C(0x8bec24443fff7c28), UINT64_C(0xd31843c4d7acbc70), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc20f7e745c1cc280), UINT64_C(0x0aa73d5c9c3dfec4), UINT64_C(0x2cf93be8f90f30d4), UINT64_C(0xeb22764cf7624790) }}, {{ UINT64_C(0xec102334f5686af8), UINT64_C(0xb0d643444f85a414), UINT64_C(0x1256f9e484b0344c), UINT64_C(0x6c4962b44c03a11c) }}, {{ UINT64_C(0x3f50738404ea2d78), UINT64_C(0x09409db4d519ab2c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xc9d2705cdba0ac38), UINT64_C(0x185a20c8f7faa3ac), UINT64_C(0x61664c2c4b1d7cc4), UINT64_C(0xad09e6d0be0c4694) }}, {{ UINT64_C(0x3ac12d3c90a653a8), UINT64_C(0x20a28b4c1750efd0), UINT64_C(0x1ac6a7000c410338), UINT64_C(0x7f20fd1c2ece996c) }}, {{ UINT64_C(0xef355eb48a1ec7ec), UINT64_C(0xfd574e4c43fd3494), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xf55e86f4ca915e50), UINT64_C(0xf6b39c1caf4e3d78), UINT64_C(0xa97a6aac0d510fd8), UINT64_C(0xabd1ad202905fadc) }}, {{ UINT64_C(0xaa60e704e46fd0a4), UINT64_C(0x78e6c9bc92ddf53c), UINT64_C(0x67d3e614a6f6d870), UINT64_C(0xc099dffc1383fb54) }}, {{ UINT64_C(0x29c6b768d053391c), UINT64_C(0x18a8d2b47448b514), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe62ea9e4580cc638), UINT64_C(0x08482504bb3d4494), UINT64_C(0x719cef2432ebdf28), UINT64_C(0xe2a926f886adb374) }}, {{ UINT64_C(0x61d0e950c8f4b084), UINT64_C(0x7a89ce08056ac054), UINT64_C(0xb0a40e646a293488), UINT64_C(0x94dd4cd0b1ceb028) }}, {{ UINT64_C(0x561170e48322caa0), UINT64_C(0x9f0d1f00ca738c28), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xaa10eaf8799d5170), UINT64_C(0x581238ec38ee2bfc), UINT64_C(0xbfd1029412fca72c), UINT64_C(0x1f14165c0febb440) }}, {{ UINT64_C(0x08360f3c3c776a14), UINT64_C(0x8409017450fbc0a4), UINT64_C(0xf44d6d04b18c7ac8), UINT64_C(0xdf1c2ac0220b6eec) }}, {{ UINT64_C(0x1fc7923896ef45dc), UINT64_C(0x6d39db88886df724), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7a8e66a880d796dc), UINT64_C(0x1002c78cfeb0324c), UINT64_C(0x905effb0d05f76b0), UINT64_C(0xf06970403fdbafa4) }}, {{ UINT64_C(0x82edf25c1cd6d050), UINT64_C(0x1b188fd40704e80c), UINT64_C(0xb05bb29071178be8), UINT64_C(0x1812f9e0bbc71c2c) }}, {{ UINT64_C(0xa44352a4beda15c0), UINT64_C(0x0f78efc0b9724ab0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xbf93d8e09b0ee0a0), UINT64_C(0x1dafaf6cee5f0fa4), UINT64_C(0x1634b2ac3ba455f4), UINT64_C(0x53a7763cc0d97a4c) }}, {{ UINT64_C(0x13e1b8bc1140c538), UINT64_C(0xaaf477a443359770), UINT64_C(0x1cdeadf41719c448), UINT64_C(0xdeb339fc691ce3dc) }}, {{ UINT64_C(0x8b3d33d400556a84), UINT64_C(0xbe3ef378f50a6ffc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5dabbf84bdd61064), UINT64_C(0x7d30612858a2f548), UINT64_C(0xb30c4a58d5daa760), UINT64_C(0x87c9757c1a76c564) }}, {{ UINT64_C(0xf61bd13c38c83dac), UINT64_C(0xab4203fcc7731b60), UINT64_C(0xc00316003246f944), UINT64_C(0x3fbc64209f943c24) }}, {{ UINT64_C(0x4748b444ae316b94), UINT64_C(0xd06770cc7566c5a4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x7a3c7e30eaf598ac), UINT64_C(0x2d18dc98aababad8), UINT64_C(0x49b6ce2ceae6b698), UINT64_C(0x96898534a772183c) }}, {{ UINT64_C(0x6bad4eb858b555c4), UINT64_C(0x7b0fdab430028170), UINT64_C(0x8cd6d180dbb6b680), UINT64_C(0xfaaf7534dfa838d4) }}, {{ UINT64_C(0x35744788f23bd8cc), UINT64_C(0xfc354e2825bd0484), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x59428440b3b008b4), UINT64_C(0xa8be8e4082146f74), UINT64_C(0x4a85d5e4d708e320), UINT64_C(0xe7b7092072e424b4) }}, {{ UINT64_C(0x33eadc9469f1d7c4), UINT64_C(0xc7deb530a511fe58), UINT64_C(0x595f599cfef77c94), UINT64_C(0x6387805436802f38) }}, {{ UINT64_C(0xbabbf798f56ec81c), UINT64_C(0xe48878b4ca030a28), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x3b4298acdf4b8254), UINT64_C(0x7a3e659418dcecfc), UINT64_C(0x130a52f4ef40e604), UINT64_C(0xd5718e604f058008) }}, {{ UINT64_C(0xe75054e874604a44), UINT64_C(0x15db597cffef9140), UINT64_C(0x1081c8a4d1f9c5e0), UINT64_C(0x0ea0b9b8dc5f2204) }}, {{ UINT64_C(0x23226bbcd950e7fc), UINT64_C(0x10c18ed44fddaae0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x00215d44eaf98864), UINT64_C(0xac973fecbec3ce00), UINT64_C(0x4dc16cf4506a2634), UINT64_C(0xa692cb98453d0fc8) }}, {{ UINT64_C(0xa410a64443a01f5c), UINT64_C(0x21518a1807c1ca4c), UINT64_C(0xb71737b0ebea0a74), UINT64_C(0x6b5e70e8c117ba58) }}, {{ UINT64_C(0xe72a4e385724bae4), UINT64_C(0xa7589de07e1805e8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x5442336042188b00), UINT64_C(0xb6aff9cc16f06f88), UINT64_C(0xb6e5dd3c471de1dc), UINT64_C(0x9124931879e86aac) }}, {{ UINT64_C(0xedbd5940efc302c8), UINT64_C(0xdc6ad61089d3ce60), UINT64_C(0x5580e11043ef0008), UINT64_C(0x46689ac84fc803cc) }}, {{ UINT64_C(0x3af5777064cc7dc4), UINT64_C(0xe0a4b350e11aef48), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x8fcdc6b47ce23170), UINT64_C(0xca7a1f14e06ca758), UINT64_C(0xfb0abf94b438dcf0), UINT64_C(0x4daf7548855e3d20) }}, {{ UINT64_C(0xa7adde1434045c00), UINT64_C(0x191fe3f001749d3c), UINT64_C(0x824e90b01123999c), UINT64_C(0x09312ecccdb1c0d4) }}, {{ UINT64_C(0xee2db6344953a408), UINT64_C(0x3f3d0f88e147c484), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb0b575fccf77c7ac), UINT64_C(0x2c2e544ca7ea4b94), UINT64_C(0xefe1ef64b623b280), UINT64_C(0xe5d974b4998dbc9c) }}, {{ UINT64_C(0x43a0b35c8a8ef1a0), UINT64_C(0xde36b0e08ad7add0), UINT64_C(0xff313e6802cc80f8), UINT64_C(0xfee9363c17dc93bc) }}, {{ UINT64_C(0xa8664308c3e26c10), UINT64_C(0x427f13a89ea75a94), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xe52d51fc71b2ccb0), UINT64_C(0x179921ccff64d004), UINT64_C(0xdbe8a9e487bdbcc4), UINT64_C(0x4a31a6dcd91d3e4c) }}, {{ UINT64_C(0x6caa1a6401a8ee18), UINT64_C(0x577b8cf40d3ab69c), UINT64_C(0x5827088c321012a0), UINT64_C(0xccc1adb84a6e5f18) }}, {{ UINT64_C(0xf90adcb8598fb5bc), UINT64_C(0x70cfcef42583bb58), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x53a9d53cb62c2bcc), UINT64_C(0x79e887e410f9bda0), UINT64_C(0xdbd9a8787562713c), UINT64_C(0x3ae91dbc09c0ffcc) }}, {{ UINT64_C(0x5206ccccc590491c), UINT64_C(0x3cf4b7048756b060), UINT64_C(0xaf59668892eed2e0), UINT64_C(0x804e2cac5c496b1c) }}, {{ UINT64_C(0x4bbadbd870b7d1a4), UINT64_C(0xbda8b75cb54c2404), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xccf684940df13184), UINT64_C(0xf01502a4a9af2bc0), UINT64_C(0xe5c07de810a95424), UINT64_C(0xd7d60bf059445ce8) }}, {{ UINT64_C(0xd4c3709c8e48c568), UINT64_C(0xb971ae848128835c), UINT64_C(0x8681c71c468375f0), UINT64_C(0x9fbbcb60aaaa1518) }}, {{ UINT64_C(0x41f1ad045c962e50), UINT64_C(0x4878c9a032f3b248), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0xb1fdd884bb64a760), UINT64_C(0x58cfd78c8a53642c), UINT64_C(0x8dc8ea08d42c8f98), UINT64_C(0x6d3cef38f04ac2b0) }}, {{ UINT64_C(0x9779580c5c8a1168), UINT64_C(0xee07d968d6a4cdfc), UINT64_C(0x6d20d6dcbfe1f5b8), UINT64_C(0x3d9bcc34d15f19d8) }}, {{ UINT64_C(0x0e18263c3f9d06f0), UINT64_C(0xbff5c21c4cf980cc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x4f5315906bad57c0), UINT64_C(0xb8d45accc8e9c03c), UINT64_C(0x4adf80bc52500368), UINT64_C(0x565ba7705111b548) }}, {{ UINT64_C(0x648441ac644cc30c), UINT64_C(0x59962f58d47737b4), UINT64_C(0xf02b67acdc7efc24), UINT64_C(0xace8e3541909b3c4) }}, {{ UINT64_C(0x322d1434f67dd66c), UINT64_C(0x9894053c99aa1290), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x1e1f0a784493ad74), UINT64_C(0xed2726ece7ba3c70), UINT64_C(0xb824b7b087b54f0c), UINT64_C(0x474714680de29eec) }}, {{ UINT64_C(0x7dbc585091b5e030), UINT64_C(0xac3fe2e47e1ee330), UINT64_C(0xffc91004494cf1cc), UINT64_C(0x93aa90f45ce18ff0) }}, {{ UINT64_C(0x905a3e4027c644c4), UINT64_C(0x979452a092f76eec), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x02908b50a7e84a70), UINT64_C(0x89ed06544b04621c), UINT64_C(0x07c4f6a4287f2208), UINT64_C(0xf9042a3c285ba728) }}, {{ UINT64_C(0x029a6a3868c53a18), UINT64_C(0x7f271aa41180fd08), UINT64_C(0x46ed414cadc81808), UINT64_C(0x4cb0259c73702204) }}, {{ UINT64_C(0x535c0ea88904d028), UINT64_C(0x16eb00ec9bf01c5c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x50719b88fec7ef3c), UINT64_C(0xe1c757f8d0bbbdb4), UINT64_C(0xf605b3c06c25d210), UINT64_C(0x77b043c4d73002b4) }}, {{ UINT64_C(0x3a626124ce99f1fc), UINT64_C(0x09e07260e7bbe83c), UINT64_C(0x41da4aacfb492c5c), UINT64_C(0x61efdc38952f7ce8) }}, {{ UINT64_C(0x9f855a7cef665458), UINT64_C(0xa491dc38281b4d58), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9962d1b88a1828fc), UINT64_C(0x7bd2a16c11132794), UINT64_C(0xd34fcd24d0fa5f34), UINT64_C(0x3d53a5b0298c4890) }}, {{ UINT64_C(0xb82b4640011499b4), UINT64_C(0x6f9a7b14b97209f4), UINT64_C(0x50e14eb016fd387c), UINT64_C(0x3909fcdc9b2ec284) }}, {{ UINT64_C(0xa359a914738d8de0), UINT64_C(0xc38b37a895b50e0c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x04ccd5142f33c1b8), UINT64_C(0x3aabbdd0f2bbffa8), UINT64_C(0xb1287fdc2e2a54f8), UINT64_C(0x821203f067142690) }}, {{ UINT64_C(0xb9b12524fa615ae8), UINT64_C(0x4a8f2b40afd0123c), UINT64_C(0x390cdf68c2e964ec), UINT64_C(0x238596ec550f2230) }}, {{ UINT64_C(0x8292f0c448caf0cc), UINT64_C(0x585190c8409c6658), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x6e42d718d7622e44), UINT64_C(0x7cd5dc40ad00f708), UINT64_C(0x62a5a8a888dee928), UINT64_C(0x7f1472c81d89f284) }}, {{ UINT64_C(0x9b0e3228c55e0840), UINT64_C(0x7f7c1a9c0ce0fb64), UINT64_C(0x19bb93785f48eddc), UINT64_C(0xdacc924855bbb914) }}, {{ UINT64_C(0x64561408c25efd3c), UINT64_C(0xf6a0c91cd7c0f09c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x9b588b64d67a1fa8), UINT64_C(0x14e4055819ca7704), UINT64_C(0x5b4ab67027086360), UINT64_C(0xcf615d0003956db0) }}, {{ UINT64_C(0x78fc95a83941c76c), UINT64_C(0x0ee44694a07be4e0), UINT64_C(0xdb5d6100bdab77e4), UINT64_C(0x795abc043f3d3d10) }}, {{ UINT64_C(0xacf82becf5057b10), UINT64_C(0x231c40e81523337c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x234f55b4eb1a5b24), UINT64_C(0x6acfe3181cf39f7c), UINT64_C(0x9f2008e0e07594c4), UINT64_C(0x681f21a8b9b3e780) }}, {{ UINT64_C(0x136ff1249ee86e00), UINT64_C(0x22e02cc8f9a95a7c), UINT64_C(0xa0af64705cdec290), UINT64_C(0x5a7347646a65c4e0) }}, {{ UINT64_C(0xcad208cccacbc56c), UINT64_C(0x3fe6cd344f10e134), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
  {{ UINT64_C(0x92ef9a007d53e26c), UINT64_C(0xef3766c4e482c2a0), UINT64_C(0xc9c47318318236c8), UINT64_C(0xf16bffc0602dbe10) }}, {{ UINT64_C(0x0dd8a928d22f5740), UINT64_C(0xa928211c25ccd180), UINT64_C(0xf521b474881a11cc), UINT64_C(0x820211103fef3dec) }}, {{ UINT64_C(0x3fce85c046e08f84), UINT64_C(0x65b0dfe4ea42b43c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }},
};

static const block_t precomputed_constant_linear_part[] = {
  {{ UINT64_C(0x9278ab60a47f1a8e), UINT64_C(0x000000016ee01655), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }}};

static const block_t precomputed_constant_non_linear_part[] = {
  {{ UINT64_C(0xf2022c1c0c1eaaec), UINT64_C(0x48b20c3c80f6772c), UINT64_C(0xf8cdc194143b7e54), UINT64_C(0x4e7a8e804d79e9e8) }}, {{ UINT64_C(0x60ecd440f69dbeb4), UINT64_C(0x2e79594c7e6c4218), UINT64_C(0xf919ee049a212a04), UINT64_C(0xdecb9b7001bac034) }}, {{ UINT64_C(0xc8334a505f0cc2e8), UINT64_C(0x47d94960afcb8dcc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000) }}};

static const block_t Z_r[] = {
  {{ UINT64_C(0x2de1869e7dc3a13f), UINT64_C(0xe2d06c36848483d3), UINT64_C(0xf706d405b49aa563), UINT64_C(0x04dd87d50204db29) }},
  {{ UINT64_C(0x442a27258b8d5b7f), UINT64_C(0x0990a17494718c52), UINT64_C(0x5239c981d2423d2c), UINT64_C(0x1a70f5348c344078) }},
  {{ UINT64_C(0x31022be61b8ebfd9), UINT64_C(0x2079b13cb392d215), UINT64_C(0x8424c3bcf2ba165f), UINT64_C(0x678a5fe076ab0ada) }},
  {{ UINT64_C(0xdf515b96af151e63), UINT64_C(0xa34f917f007c5920), UINT64_C(0x144c747635b66140), UINT64_C(0xd9275b3ca665f108) }},
  {{ UINT64_C(0xd4fe57b127b42e89), UINT64_C(0xe566f14b9dbebd19), UINT64_C(0x947ef4ca3eb5a3dc), UINT64_C(0xb53d1f90dbc63291) }},
  {{ UINT64_C(0x29af3c034c9d76bc), UINT64_C(0x5854fc6066d36482), UINT64_C(0x8eb5249bad7df8c8), UINT64_C(0x828374cb3307c5e7) }},
  {{ UINT64_C(0x37c422bd6094aa90), UINT64_C(0xbf85140989ae68b3), UINT64_C(0x14b361ab63add5be), UINT64_C(0xbaf57e97e4712f67) }},
  {{ UINT64_C(0xf624eb5470e29290), UINT64_C(0x881fe6bfdbd2bd8e), UINT64_C(0x027c36f416dbd2a3), UINT64_C(0xf69f9a4dfa47c667) }},
  {{ UINT64_C(0xc5c0ea9f5b520b60), UINT64_C(0x52e2293f1628072d), UINT64_C(0x93d888fb0c280e5d), UINT64_C(0x0265b4e2c2653170) }},
  {{ UINT64_C(0x1a0092582c04d233), UINT64_C(0xe0fa79bd41c9b6e0), UINT64_C(0x0f5a1e688ff39528), UINT64_C(0x99b9524cbeff707f) }},
  {{ UINT64_C(0x8ec56ab4774fd1eb), UINT64_C(0x6886d057115e7598), UINT64_C(0xb0577147d52ceb85), UINT64_C(0xc06d76bcd21b9670) }},
  {{ UINT64_C(0x1134443ed89b446d), UINT64_C(0xe32f97ad19667c8b), UINT64_C(0x5ee8705363cdc98a), UINT64_C(0x520ce89146866982) }},
  {{ UINT64_C(0x3b32dea6a13e63d6), UINT64_C(0x00b684b19cf79be1), UINT64_C(0xde8fce5baa18a513), UINT64_C(0x7385f450ff393e49) }},
  {{ UINT64_C(0xff1925962029c15e), UINT64_C(0x7874dfab79360034), UINT64_C(0xa4203d2889d96772), UINT64_C(0x086edd9adf630b33) }},
  {{ UINT64_C(0x3e9d721270a34688), UINT64_C(0xf8572e383b039d28), UINT64_C(0x264f14d00c80dd85), UINT64_C(0x270a9ed2223a4ed0) }},
  {{ UINT64_C(0xd6a08b346ae5a364), UINT64_C(0x08c0576ac29c0f2e), UINT64_C(0xb977ad3ca91b4b64), UINT64_C(0x96ff610b94b42d8e) }},
  {{ UINT64_C(0x473f88e84c23fb73), UINT64_C(0xac0bd64b65fa0bef), UINT64_C(0xe263b60af26fdfcc), UINT64_C(0x40bbd9dbb7f2fb8b) }},
  {{ UINT64_C(0xf7e45761ed59faeb), UINT64_C(0xafaa9f30dec88e61), UINT64_C(0x65c88b37feeb923f), UINT64_C(0x54ef07dda66ab4b3) }},
  {{ UINT64_C(0xb8ef3b108c743445), UINT64_C(0x696bed077c178455), UINT64_C(0x9774d61259ce9246), UINT64_C(0xc2b81b6221954bf2) }},
  {{ UINT64_C(0xbd96c12d0f914b4e), UINT64_C(0x5f9d9a8da523cac1), UINT64_C(0xe4e094f2baa4214e), UINT64_C(0xc098b289a73fbcf5) }},
  {{ UINT64_C(0x3568429f273075e7), UINT64_C(0x49c23023aa577eb7), UINT64_C(0x8bd29321ff8a071e), UINT64_C(0x68e9f85417a33f02) }},
  {{ UINT64_C(0x49111e9b028e752c), UINT64_C(0xc9a4fd9b4d3d7356), UINT64_C(0x56333104ff605583), UINT64_C(0x05b1ffe81f8ddb1a) }},
  {{ UINT64_C(0x1e3f795e58ddabc1), UINT64_C(0xb77bbc5a51c18970), UINT64_C(0xd68025aef829ba04), UINT64_C(0xc3562803a667b85a) }},
  {{ UINT64_C(0xc5f682edd8db4081), UINT64_C(0xb79099c192f15c08), UINT64_C(0x5a52ee66076fcfe2), UINT64_C(0x8a542e8415ddb0be) }},
  {{ UINT64_C(0x9c82f27ce1884ac7), UINT64_C(0xcd847d2772806119), UINT64_C(0x8152d9ec89736ca4), UINT64_C(0xdf6b8eff1699b402) }},
  {{ UINT64_C(0xd6d26ff1fc0cd0e8), UINT64_C(0xfc92958d0ef5bac7), UINT64_C(0x2bf35a23e88e31d9), UINT64_C(0x6de8a9eec9ebbe3b) }},
  {{ UINT64_C(0xff800056fbc5a9bb), UINT64_C(0x142147e1f0725007), UINT64_C(0xd31ef81ccedc77c0), UINT64_C(0x760e2c0c8260d99b) }},
  {{ UINT64_C(0xb3c1b9379caa207b), UINT64_C(0x6be5860e6a33f286), UINT64_C(0x870af8456c0edb0d), UINT64_C(0x3034c97df7cc531f) }},
  {{ UINT64_C(0x33ef820a34392e8e), UINT64_C(0xeafdfb3fa274e405), UINT64_C(0x1c68eef40736b4a0), UINT64_C(0x04715228c2d581be) }},
  {{ UINT64_C(0x1b02bfaa2ac790b1), UINT64_C(0xc6e8a866bc220471), UINT64_C(0xc5b51fa2b798bdf1), UINT64_C(0xb69c9c6e5d03b68a) }},
  {{ UINT64_C(0xf7f8f1e67add128f), UINT64_C(0xbfa61530b4168131), UINT64_C(0xc8043df526076078), UINT64_C(0x8bac6f33c5d2da38) }},
  {{ UINT64_C(0x643e89775f7b6472), UINT64_C(0x0610f5415ea8f169), UINT64_C(0x3b633032eebce0c5), UINT64_C(0xe84402c0a07478fe) }},
  {{ UINT64_C(0xb6810508d72e3523), UINT64_C(0x7956d6144d227b3e), UINT64_C(0x066fa4b5e62a47a1), UINT64_C(0x407f73ea33300b5c) }},
  {{ UINT64_C(0x2bec52ca66df9eed), UINT64_C(0x5421051f3a0a6fa8), UINT64_C(0x17bc78c25ca5298b), UINT64_C(0xdc428fcdc168dabb) }},
  {{ UINT64_C(0x0507adf2d44c8ba4), UINT64_C(0xfb98dd483f9d9ab5), UINT64_C(0x7c6a6192f30e9cf0), UINT64_C(0x2ee4aa8d16b91d76) }},
  {{ UINT64_C(0x3cbecec76554cc4d), UINT64_C(0x3ad5d3f141cf767a), UINT64_C(0xa8311f2ffb15e3f0), UINT64_C(0xf8cc232fd9c1926b) }},
  {{ UINT64_C(0x2cd8b36c0c626b6d), UINT64_C(0x6b7ace6a9174b0e9), UINT64_C(0x1fdd9d6152ce80c2), UINT64_C(0xf60ec93ecebdb6b7) }},
  {{ UINT64_C(0xf64f632c5d7c004a), UINT64_C(0x1fa945f414949ae8), UINT64_C(0xbbb038190af2e286), UINT64_C(0xc9094f5cc19bb3ac) }},
  {{ UINT64_C(0x8ecd8718b63754cc), UINT64_C(0xebfd75f824608408), UINT64_C(0x9a35e4794d9199f0), UINT64_C(0x948b5ef75589fe2a) }},
  {{ UINT64_C(0xb1e37a5128f836c6), UINT64_C(0xb3f15d5f0d6db898), UINT64_C(0x6151e2c91eb632be), UINT64_C(0x9f27fc818da28e18) }},
  {{ UINT64_C(0xc036d76ecd83d2dc), UINT64_C(0x8d5db8b908d2122b), UINT64_C(0xe2474d00cc2cd264), UINT64_C(0x596a93ee732ffc5d) }},
  {{ UINT64_C(0xa22ad24b2f13485b), UINT64_C(0x4a33bd77114a0ae5), UINT64_C(0xdd82854b910661c9), UINT64_C(0x9fc5f64702f492b3) }},
  {{ UINT64_C(0x438eaacbbc2d8b83), UINT64_C(0xcb2bde3d924a6fc3), UINT64_C(0x8d8140cc1cefb39c), UINT64_C(0xde4bf30bbf5e9699) }},
  {{ UINT64_C(0xd58ac2bf60b37957), UINT64_C(0x2cd87a62b61a8d57), UINT64_C(0x7ecb2b6d0e26714b), UINT64_C(0x7e18f0b231b21ac9) }},
  {{ UINT64_C(0xb048d7b88ef19e55), UINT64_C(0x5cdc4bfeafa34431), UINT64_C(0x04ecd1bde776d472), UINT64_C(0xdc3a07f656ef57a9) }},
  {{ UINT64_C(0xc86075c2b5e4c279), UINT64_C(0xe2bf494532844b4b), UINT64_C(0xefaa7cedf438bac7), UINT64_C(0x9c71beb506a16367) }},
  {{ UINT64_C(0x690f9efd6682a5eb), UINT64_C(0x89dbc536df38aee2), UINT64_C(0x10a96b2cbe699dc2), UINT64_C(0x8798412cbc2e665f) }},
  {{ UINT64_C(0x352b46f599a525fc), UINT64_C(0xa2cf6befc7bef0a3), UINT64_C(0x4df6f45f79fd1b72), UINT64_C(0x569535f9018e1ce6) }},
  {{ UINT64_C(0xca1597e170301ee7), UINT64_C(0x071469a658036422), UINT64_C(0xb5eec1fca13fcb0b), UINT64_C(0x0612ca625d966f79) }},
  {{ UINT64_C(0xbbf897ef1c3bf436), UINT64_C(0x19b1e8695f7f927c), UINT64_C(0x7d13677c5a001f83), UINT64_C(0xf4473fe2e8a5f825) }},
  {{ UINT64_C(0xa5492dc1b147305c), UINT64_C(0x7fbc35b8fd46fbea), UINT64_C(0x7b5b665f355c68a5), UINT64_C(0x5a47cad9c7986b9f) }},
  {{ UINT64_C(0x6fb0622db41c3a4c), UINT64_C(0xce5a8c6dc9267a92), UINT64_C(0xb1bf2e647f959398), UINT64_C(0x1d5eadbed817d772) }},
  {{ UINT64_C(0x876a93d04582c0a6), UINT64_C(0xb4fef60f0ca29f0a), UINT64_C(0x8461220aee743e80), UINT64_C(0xbd76fdf825b4bb16) }},
  {{ UINT64_C(0xbdd3fdad0b758f91), UINT64_C(0xa1e2c84c6f1cad37), UINT64_C(0xc2c14869ea1e4f69), UINT64_C(0x0b18e1f6ebaca7d3) }},
  {{ UINT64_C(0xc488254a417ccf71), UINT64_C(0x2071f4fd83ca3d99), UINT64_C(0xda638b031481134f), UINT64_C(0x71408980e78fb6bf) }},
  {{ UINT64_C(0x8a3b19c75b0ff782), UINT64_C(0xbdda3523110d0eaf), UINT64_C(0x8e527fcbe6e18961), UINT64_C(0xfed3bb248ef73a47) }},
  {{ UINT64_C(0xabf2d2e004bbaea2), UINT64_C(0xe50fff24c073f221), UINT64_C(0xe9eb790498d6a8fa), UINT64_C(0x73fe20bf223c998a) }},
  {{ UINT64_C(0xef00315ff9b4baf8), UINT64_C(0x5f2d5e723c2f43e3), UINT64_C(0xaac8c9af0b053de3), UINT64_C(0x9c7fe49f639f0b4c) }},
  {{ UINT64_C(0xb5e27486eb7bc9b9), UINT64_C(0xc5f145e9e652ad7b), UINT64_C(0x8aa58f4caecf540f), UINT64_C(0x132e47dad1cf32ab) }},
  {{ UINT64_C(0x3296c20a0b071651), UINT64_C(0xd6dfbbcbe2759078), UINT64_C(0x33edf6db657f13f2), UINT64_C(0x78a0cebe9c5acc8a) }},
  {{ UINT64_C(0x57edc45ab1aaf53d), UINT64_C(0x39cfaf52ebb1af44), UINT64_C(0x1ed5b375bd77a4c4), UINT64_C(0x1ea1ad5be22b175d) }},
  {{ UINT64_C(0x5e58236ee1f39d35), UINT64_C(0x93dc874fa0516902), UINT64_C(0x8bddae64c1269c78), UINT64_C(0xa73207ff28aea68d) }},
  {{ UINT64_C(0x55532e3f90be302a), UINT64_C(0x0f48106ab83cafb1), UINT64_C(0x68710f516ef0aa31), UINT64_C(0xb992b6b4d7e07d60) }},
  {{ UINT64_C(0x52ff91be503dcc2c), UINT64_C(0xaaee58e4173af70a), UINT64_C(0x39474dd671da0ad1), UINT64_C(0x6f45dc29be76acd1) }},
};

static const block_t Zi_0[] = {
  {{ UINT64_C(0x921f3c5421796692), UINT64_C(0x1937dfa54e4c9940), UINT64_C(0xd4201f4d77dfc788), UINT64_C(0x34db8057ab9cf82b) }},
  {{ UINT64_C(0xa04bee0bf11d1092), UINT64_C(0x28ccbc181802fcd6), UINT64_C(0x7cf8dcd8dbe40498), UINT64_C(0x8370019947a81d26) }},
  {{ UINT64_C(0x085a4db47c2e8282), UINT64_C(0xc55678c0770419d7), UINT64_C(0x3c5d33c7b870e7c1), UINT64_C(0xef273e4ff9afccf1) }},
  {{ UINT64_C(0x55072f3c7634e841), UINT64_C(0xe56f68f22b4b3d77), UINT64_C(0xc868ae2445a00064), UINT64_C(0xc3d0839a423beba0) }},
  {{ UINT64_C(0x29f50cb19a871365), UINT64_C(0x1502ef5810a21d3f), UINT64_C(0xe8195df8e2be5d46), UINT64_C(0xcbaddb72abc93466) }},
  {{ UINT64_C(0xe81306aadec65d52), UINT64_C(0x5d2929dddeeecf48), UINT64_C(0x4d38acfc4be8c316), UINT64_C(0x5ca1943cd287a817) }},
  {{ UINT64_C(0x553eed6a7c794f69), UINT64_C(0x847901ef1b054de6), UINT64_C(0x19a5f1fe50b04f17), UINT64_C(0x842b2f82e9bffaae) }},
  {{ UINT64_C(0xadb713e74e484eb0), UINT64_C(0x5011e94850b95937), UINT64_C(0x80ea1bca1590268f), UINT64_C(0xd43b055f152beb22) }},
  {{ UINT64_C(0xd743dd1769840799), UINT64_C(0x40060c1b4a981341), UINT64_C(0xc243df5f873209c5), UINT64_C(0x975e5a3b184ae8b6) }},
  {{ UINT64_C(0x27dbb215f4bc22ba), UINT64_C(0xa007185bc452cca2), UINT64_C(0xda38336b478b2135), UINT64_C(0x125253555245044b) }},
  {{ UINT64_C(0x8495aef1acdf2cab), UINT64_C(0xaf02fe1bbfd65e17), UINT64_C(0xe0a0e9bde7a424a4), UINT64_C(0xe409e1a6f83592ef) }},
  {{ UINT64_C(0xf94ade5ee41793e9), UINT64_C(0x272da408db6f954a), UINT64_C(0x16a45868497de113), UINT64_C(0x369bc331cebda5cc) }},
  {{ UINT64_C(0xc1e7fafbdc1e8b8e), UINT64_C(0xc3efa04cba7dd140), UINT64_C(0x6524a0423de00fdb), UINT64_C(0xc9e751a6ca26f387) }},
  {{ UINT64_C(0x872227d87584520b), UINT64_C(0xd988de06b2c89315), UINT64_C(0xc8083c23f4c3b19f), UINT64_C(0xdbaa0b3e7b49c3d0) }},
  {{ UINT64_C(0x677c3e22b91d96e7), UINT64_C(0xb036e34f9f1dc42e), UINT64_C(0x782ad32fdd3aef3c), UINT64_C(0x5719802cf5c3053e) }},
};

static const block_t Zi_1[] = {
  {{ UINT64_C(0x2d8bcbb5ce22132e), UINT64_C(0xf161866f029d5a0f), UINT64_C(0x2857aa65304a33e4), UINT64_C(0xa63d99dd08e8f403) }},
  {{ UINT64_C(0x7ba7a4481b38f055), UINT64_C(0xc9260cca773f5885), UINT64_C(0x7c584be86b680595), UINT64_C(0x845001960f3b4777) }},
  {{ UINT64_C(0x9b84772e59ee849c), UINT64_C(0x84dcb0cde2641617), UINT64_C(0xb05c312880bc3018), UINT64_C(0xc89dbe748a36f69d) }},
  {{ UINT64_C(0x12e1d7fd254cde97), UINT64_C(0xa24cad5ad8876e54), UINT64_C(0x57ac0f6296a41fc8), UINT64_C(0xa21dad8b5e31c0f2) }},
  {{ UINT64_C(0xacf88802f80bc03e), UINT64_C(0x9312dd82df89895f), UINT64_C(0x4e38cc2dbdd28bfe), UINT64_C(0xe2f874ff69da5568) }},
  {{ UINT64_C(0x409dd4483670abe1), UINT64_C(0x388d9e9b34fcbd20), UINT64_C(0x9c4c3d6e46de8f07), UINT64_C(0x197cb4e987d60640) }},
  {{ UINT64_C(0x3f8f8146cfebdf98), UINT64_C(0x7527ff9d734d1511), UINT64_C(0xdc963b66523c951a), UINT64_C(0xf4035d0da30dc988) }},
  {{ UINT64_C(0x85d50b029e47fb09), UINT64_C(0xace224d9b3782987), UINT64_C(0x9ca642f8dc401657), UINT64_C(0x12f9b3066410d7e1) }},
  {{ UINT64_C(0x3edb88f9bf8c2b4f), UINT64_C(0x3b54a1fce40df4ce), UINT64_C(0xf5a17741ec18fa35), UINT64_C(0x4a09fe4ab34f1498) }},
  {{ UINT64_C(0x65b567f4e3cdb32f), UINT64_C(0x53c29f95559cd876), UINT64_C(0x52b445a39067d17d), UINT64_C(0x2132f5037a6787b9) }},
  {{ UINT64_C(0x7561b641c7e2ab7a), UINT64_C(0x87961a1e795bd94a), UINT64_C(0xf19968945a2bb17c), UINT64_C(0x90b348ceeee51b2e) }},
  {{ UINT64_C(0xdb357285c2e97b0b), UINT64_C(0xccc840ff5739411c), UINT64_C(0x727b08f6fe178ee5), UINT64_C(0x35a29964d37c1ec6) }},
  {{ UINT64_C(0x808bac57d5deab99), UINT64_C(0x46c5381c87d3bb86), UINT64_C(0xdeb20a7f2c486799), UINT64_C(0x0aa108b9a0cca5df) }},
  {{ UINT64_C(0x0e71f05e1ceda219), UINT64_C(0xea5f83fe61c7da8d), UINT64_C(0xbace1e649748eb8e), UINT64_C(0x2d62196563db1877) }},
  {{ UINT64_C(0x4c9fe96dbcffdc82), UINT64_C(0x387aaf0ac2f5c3fd), UINT64_C(0x9cf5dfaa0e449ac7), UINT64_C(0x52d47a696515d417) }},
};

static const block_t Zi_2[] = {
  {{ UINT64_C(0xf37c9a452865359d), UINT64_C(0x4a13d4f6a89aabda), UINT64_C(0x8a25938a4cbf6121), UINT64_C(0x1e8d3279bb874551) }},
  {{ UINT64_C(0x9c781f48a7852929), UINT64_C(0x7120a6f74eb9ac1c), UINT64_C(0x2998e1d22c194cbc), UINT64_C(0x5e837e8a7a45ac5e) }},
  {{ UINT64_C(0x8bb87832fcd91b70), UINT64_C(0xd9265efaddd9d29b), UINT64_C(0xeeef186e8c9eda46), UINT64_C(0x296b69ec6260e802) }},
  {{ UINT64_C(0xf4c1e4358d702559), UINT64_C(0xb85ace63940acba2), UINT64_C(0x9276ab66cc26f494), UINT64_C(0xdc20143419bc1ebd) }},
  {{ UINT64_C(0x002b29342141ad39), UINT64_C(0x59ef42d899db6746), UINT64_C(0x33d7835d81905281), UINT64_C(0xd178cc4ca91be9c2) }},
  {{ UINT64_C(0x4230bf6879263c1d), UINT64_C(0x9b562d050348f9bc), UINT64_C(0x914146aa82e1adc5), UINT64_C(0xcc5c2d028bb262fa) }},
  {{ UINT64_C(0x13aff459c0840a1a), UINT64_C(0x6ae16a7f08ced85c), UINT64_C(0x38220965ce8aa727), UINT64_C(0x305eb0e716634091) }},
  {{ UINT64_C(0x9bad884b73de3ae0), UINT64_C(0xb19ece223ba10e7d), UINT64_C(0x26cbe2dc07c37ff4), UINT64_C(0x34e0c5e1325196bc) }},
  {{ UINT64_C(0xfe4ebb4d961cc05e), UINT64_C(0x0f69ae903e3b1946), UINT64_C(0x30d047ba90f778ec), UINT64_C(0x01512df587a83d87) }},
  {{ UINT64_C(0xfe8ebe5929023c90), UINT64_C(0xee2c082ff52efbaa), UINT64_C(0xbb88a5276e720491), UINT64_C(0x75641a94c644f6e5) }},
  {{ UINT64_C(0x2c9df533d8eb95c9), UINT64_C(0x659b90560cf58b3a), UINT64_C(0x26bf57d64b0da3a2), UINT64_C(0xcd59e7640239951e) }},
  {{ UINT64_C(0x1ea7871d255710b3), UINT64_C(0x11c5187a64f07305), UINT64_C(0x0895ec8a04a82c97), UINT64_C(0xdb54c70053827f53) }},
  {{ UINT64_C(0x9be3a546ef5a7f00), UINT64_C(0xe3a69a1113d76e05), UINT64_C(0x050eeebf396bf10d), UINT64_C(0x0d7319850689ca80) }},
  {{ UINT64_C(0x6f378517a5eef2ac), UINT64_C(0xb6fd4868fab069c5), UINT64_C(0xbd6844c6a193bc89), UINT64_C(0xe52ccad114782f2c) }},
  {{ UINT64_C(0x38296a7d971491b1), UINT64_C(0x1955b9851f494175), UINT64_C(0x9cd36f87b1b455ec), UINT64_C(0x8f9a36532f9fff95) }},
};

static const block_t Zi_3[] = {
  {{ UINT64_C(0xc7006a389ce5ed20), UINT64_C(0x3d9757c8b813f0f1), UINT64_C(0x44dce1c246d8fe8f), UINT64_C(0x9e42c255a7112b29) }},
  {{ UINT64_C(0xab8d1f74ff595701), UINT64_C(0x7e4c5b412e9090a0), UINT64_C(0x8f631432922afd8e), UINT64_C(0xc4e4fcf68e94e908) }},
  {{ UINT64_C(0x2b30557ee89cc724), UINT64_C(0xba93f90e2eb3e0be), UINT64_C(0x29d83398fe9b90d5), UINT64_C(0xbd58f3ed2a0264a4) }},
  {{ UINT64_C(0x0b696613b8133aed), UINT64_C(0x3cc9841afbb026ff), UINT64_C(0x05c89d8bbfab58cc), UINT64_C(0x712bd1307ae0d408) }},
  {{ UINT64_C(0xbeebd7cb3e79238e), UINT64_C(0xf37bc4a06dba90f3), UINT64_C(0xc79b60a60896b22b), UINT64_C(0xe339919ee9e7a5f7) }},
  {{ UINT64_C(0x9e1e1a9b15a7cee2), UINT64_C(0x032c1918cca5f3e6), UINT64_C(0x18900774ed0676a7), UINT64_C(0x3fa740cf50c5ee73) }},
  {{ UINT64_C(0x8b0654a040337df6), UINT64_C(0x9c7d489183c6a1d9), UINT64_C(0x0bcc405780608ca2), UINT64_C(0x20c680dbf2547782) }},
  {{ UINT64_C(0xe7ce13feaba2c45b), UINT64_C(0x489dcb8c635e418e), UINT64_C(0x6023774a97fced51), UINT64_C(0xb8e8219ec39ee407) }},
  {{ UINT64_C(0x1c0b1ed0fbe2498b), UINT64_C(0xda178bbfe0e7777a), UINT64_C(0x7c9ffd88d4abc360), UINT64_C(0xebbdc57917a24046) }},
  {{ UINT64_C(0x5e7a2bf1e35c00cc), UINT64_C(0x5da20f9a960e40db), UINT64_C(0x314e5dcbdca59990), UINT64_C(0x99df2e455fa34ac8) }},
  {{ UINT64_C(0xf8bf4244c0e60608), UINT64_C(0x851bc4b47e4660db), UINT64_C(0x4308f0b700e96a4a), UINT64_C(0x4127d64091d9b037) }},
  {{ UINT64_C(0xc3d8c290df05d628), UINT64_C(0x0a1380f2509b405b), UINT64_C(0xcec6ae18dc3cd0a0), UINT64_C(0x9b09dd1ab9c1c718) }},
  {{ UINT64_C(0x7b5ef1ae8c29a2bf), UINT64_C(0x3fd15998d6d6d95f), UINT64_C(0x4770a25540929a72), UINT64_C(0x459fff14342c1bd9) }},
  {{ UINT64_C(0x1b393f26dea67e66), UINT64_C(0x5c833debe15a3f83), UINT64_C(0x2eec8010c0de97f4), UINT64_C(0xb86bccd64fe04058) }},
  {{ UINT64_C(0x11c26dd0830bf44b), UINT64_C(0xf72395b54381c3c9), UINT64_C(0x1c2085fb5bafcb57), UINT64_C(0x2f251c974090cc40) }},
};

static const block_t Zi_4[] = {
  {{ UINT64_C(0x6e73544964223d30), UINT64_C(0xb51176311e76848b), UINT64_C(0xcff856f3756b8b65), UINT64_C(0x9963fdbb4ea7012a) }},
  {{ UINT64_C(0xf8495620802dbc59), UINT64_C(0xc9d1f3db4f724b5c), UINT64_C(0x9847caf37dde7fa9), UINT64_C(0x8950f3796d78308a) }},
  {{ UINT64_C(0xfb1cf7e7e5841459), UINT64_C(0xbd489106b55d1286), UINT64_C(0x36c7977019b976ef), UINT64_C(0xd46ecdd6cc0310e3) }},
  {{ UINT64_C(0xa1b61714898fc2b5), UINT64_C(0x3d2e14e7750d4429), UINT64_C(0xc72c8fc3f03877cc), UINT64_C(0xb8eed0f86000f7a5) }},
  {{ UINT64_C(0xfe60fa80c75d4b56), UINT64_C(0x35365fbe2c37d92b), UINT64_C(0x79d07b897f106c09), UINT64_C(0x3dc48d8b2dcd12be) }},
  {{ UINT64_C(0xfa13e327cc73bb56), UINT64_C(0xf2e5144ad2303259), UINT64_C(0x1291eaf1077b9f67), UINT64_C(0x724d53ad660c495a) }},
  {{ UINT64_C(0xcccf84b5dede8f0f), UINT64_C(0x40b80d5be70614fd), UINT64_C(0x843f4b1c080ed857), UINT64_C(0x12f9fac9a1b907fc) }},
  {{ UINT64_C(0xaa111625e1b1aaaf), UINT64_C(0x5cb89232da17f70c), UINT64_C(0x4cdec44fc0869ec7), UINT64_C(0xca0fd233b6b9ca25) }},
  {{ UINT64_C(0x9d59a91e3a674bb1), UINT64_C(0xa095cc9207df49b8), UINT64_C(0xe451638032ba2ef2), UINT64_C(0x63b37a057c7a4d05) }},
  {{ UINT64_C(0x551fc57fa6379dc3), UINT64_C(0x4695b3c8933c05a0), UINT64_C(0x2c24d5d69b7bb06d), UINT64_C(0x32fdac4a642a050b) }},
  {{ UINT64_C(0x45c4c0f5038765a6), UINT64_C(0xd1fd84226f178bf4), UINT64_C(0x45d2644f142c3468), UINT64_C(0x1d76b26681bbfe9a) }},
  {{ UINT64_C(0xd5ab42be53bc51b0), UINT64_C(0x6795aa2e66c6b2cb), UINT64_C(0x1f202d577973498c), UINT64_C(0xe2eef6e2abe999b8) }},
  {{ UINT64_C(0xc572e22eae88f7d4), UINT64_C(0x97a8cf11e7ae65bc), UINT64_C(0xc3771db0ddf3987f), UINT64_C(0xf999d61dc6405794) }},
  {{ UINT64_C(0xefc9bf890d0b0ce7), UINT64_C(0x0328106de0bac37b), UINT64_C(0xa8089afbb4db915c), UINT64_C(0x6f7a49a9c2249fbd) }},
  {{ UINT64_C(0xda028e72f884f02a), UINT64_C(0xfbc096dd49877ac4), UINT64_C(0x87edcac8ac25aab8), UINT64_C(0xc56d5279b058cff4) }},
};

static const block_t Zi_5[] = {
  {{ UINT64_C(0x632813439d906e64), UINT64_C(0x12b082142e83b3b0), UINT64_C(0xa48d550e772a1392), UINT64_C(0xd59be01d04882980) }},
  {{ UINT64_C(0x826ecb01635f8df0), UINT64_C(0xa785fb8ac1002e34), UINT64_C(0x09a2703e5ccd8a65), UINT64_C(0xc54e719003714263) }},
  {{ UINT64_C(0x3487c87d1ee0104f), UINT64_C(0x4d99a8e351511311), UINT64_C(0xb7f1ae843c9d91b1), UINT64_C(0xe24bc0b357f3d566) }},
  {{ UINT64_C(0xf0f0adeef6966a89), UINT64_C(0x458194f50953fd6a), UINT64_C(0xc30bf8aaf2ac551e), UINT64_C(0xc9c78ad77763f954) }},
  {{ UINT64_C(0xa06b4fb41a79c63f), UINT64_C(0x5e77a589775fc10a), UINT64_C(0xc5b5bd91c26dd1e6), UINT64_C(0x4b8842dd8d5a2fe7) }},
  {{ UINT64_C(0xaacfd535c7c57e9e), UINT64_C(0x0400fc76b8ba73b2), UINT64_C(0x8ac94d1b062a0b0d), UINT64_C(0xd63b7e8049d0c559) }},
  {{ UINT64_C(0x2a1cc0d417aa49e5), UINT64_C(0x74d6d4135d254f8e), UINT64_C(0x69953b8a3693a2ed), UINT64_C(0x6ea27f1946beebdc) }},
  {{ UINT64_C(0x2d8fb0ffd2b98d09), UINT64_C(0x9c3f4ff6edaa9c49), UINT64_C(0x63d070d1df326f7e), UINT64_C(0xd37b2bdb70f2dc58) }},
  {{ UINT64_C(0xc6fe5d9c9aff5165), UINT64_C(0xacf89f0cb5f531bd), UINT64_C(0xe3322d56a2b44ee4), UINT64_C(0x2a7bd68efc2d75d5) }},
  {{ UINT64_C(0x292b67cf089cd771), UINT64_C(0x0931894ae15dedfb), UINT64_C(0x1974b2752721d760), UINT64_C(0xa5319fdb2acf40a1) }},
  {{ UINT64_C(0xfd92b6e770d87fb0), UINT64_C(0x954f71772850ec5a), UINT64_C(0x47087bd84d3be4b8), UINT64_C(0x07ca3019539bd633) }},
  {{ UINT64_C(0xf971fbdb77ece676), UINT64_C(0xceb2a00c0a93b476), UINT64_C(0x22dd0ce861e472d2), UINT64_C(0xf83abbafdbf79fcc) }},
  {{ UINT64_C(0x91241291087be572), UINT64_C(0xe6f1f1fd7e063f13), UINT64_C(0x395214a990e1aaea), UINT64_C(0x500f9de6a9f681d4) }},
  {{ UINT64_C(0x945f8bb34c407d73), UINT64_C(0x7ab041bd45dbe9fc), UINT64_C(0x6446d258affb5690), UINT64_C(0x991d18a8017c4f3e) }},
  {{ UINT64_C(0x55cc73f836ffbf78), UINT64_C(0x80f1d55b2e4cf3dd), UINT64_C(0x9a3de9be0cecb7ed), UINT64_C(0x4eec324ce5f4fa35) }},
};

static const block_t Zi_6[] = {
  {{ UINT64_C(0xa67cbedd759d2d5c), UINT64_C(0x1b47cbf89b56bd10), UINT64_C(0x705c900683423a57), UINT64_C(0x4e94d35ec3a8c990) }},
  {{ UINT64_C(0xbf1af3ce0adfad13), UINT64_C(0x1188534920e92077), UINT64_C(0x2c38d2f8464ec263), UINT64_C(0x85ec5a80f086064b) }},
  {{ UINT64_C(0x3fd8302d580dc6c7), UINT64_C(0x5de53052e333a490), UINT64_C(0x853792ecf70a7841), UINT64_C(0xc7f5694719452009) }},
  {{ UINT64_C(0xc06ec0549b860e38), UINT64_C(0x8c6a2f90d0009d3c), UINT64_C(0xcd89df0b9c17ede8), UINT64_C(0x7e59606133e73221) }},
  {{ UINT64_C(0x18895f1028af207e), UINT64_C(0x4c1015407ac0a075), UINT64_C(0x0e8028a12752ee0c), UINT64_C(0xe2da04be5d705549) }},
  {{ UINT64_C(0x3702142c87a0499c), UINT64_C(0x69e6db46b9cf75a6), UINT64_C(0xa998cfca5d49ff0d), UINT64_C(0x77c0f0807eb5faa6) }},
  {{ UINT64_C(0x9e66558670d94989), UINT64_C(0x280e2ce6573f7616), UINT64_C(0x5148a374299be97b), UINT64_C(0x09ed5e7c59fc3544) }},
  {{ UINT64_C(0x0451ee1bdf74bae5), UINT64_C(0x25957e96ba130f23), UINT64_C(0x108f7ceb87e4cb44), UINT64_C(0x8bf4680dbd587d41) }},
  {{ UINT64_C(0x3f6cd8b31623c63d), UINT64_C(0xc6bfb5abadb84b0a), UINT64_C(0xae827d96b64d6028), UINT64_C(0x5dc2c240922fc284) }},
  {{ UINT64_C(0xd81f64eda832e34b), UINT64_C(0x9957ab7641caaf75), UINT64_C(0xb258f9210e255c51), UINT64_C(0x2e39b6e653a3aa5c) }},
  {{ UINT64_C(0x8ea09cd2a58289d5), UINT64_C(0x01f87feb16f5d0c1), UINT64_C(0x123db7bfbc4f3d75), UINT64_C(0x5c2bbfc417d977c1) }},
  {{ UINT64_C(0x5f268ce5057efe2f), UINT64_C(0xa3e8cb3211cf3188), UINT64_C(0x4f71bcf8e2dd4ca1), UINT64_C(0x5f2e6eed270111f6) }},
  {{ UINT64_C(0xf5fae61f4b6d84f9), UINT64_C(0x25062e2685780167), UINT64_C(0x22701a54cf36ded1), UINT64_C(0x66fa01fc49741ec1) }},
  {{ UINT64_C(0x6a2b0ba50d8d0e1c), UINT64_C(0xe238f9d60e263322), UINT64_C(0xe511ed8bb39578d8), UINT64_C(0x0d9eef26131d0824) }},
  {{ UINT64_C(0x8e85cdf31f118cb3), UINT64_C(0xd84434b0f93794d2), UINT64_C(0xeb70cfa311586bc2), UINT64_C(0xa8b4970a513c9219) }},
};

static const block_t Zi_7[] = {
  {{ UINT64_C(0x71a7c077aae2c697), UINT64_C(0x94a41f0868dc4855), UINT64_C(0x85862b31b0721eba), UINT64_C(0x344319d58d6d95a4) }},
  {{ UINT64_C(0xfcfd760abfbbd8b6), UINT64_C(0x764a3301a3ba0719), UINT64_C(0xa4d0aa95e2f2763e), UINT64_C(0x2301aaba85f4e687) }},
  {{ UINT64_C(0x0d5db6a34bded929), UINT64_C(0xc0d173671124a429), UINT64_C(0xf4b3390e1a632df6), UINT64_C(0xaf7ae7f57baf4c1b) }},
  {{ UINT64_C(0x55c3d1bff3a2a293), UINT64_C(0x4aa7cc88f524bba5), UINT64_C(0x810a831ab1bf0f8f), UINT64_C(0x000410962b73fc7f) }},
  {{ UINT64_C(0x1c8ca7300a5b0062), UINT64_C(0xcb24c52249cdd2d8), UINT64_C(0x8cbf72ce004e60c2), UINT64_C(0xc2bedde7a57709a7) }},
  {{ UINT64_C(0x8652a3654c5f622c), UINT64_C(0x1ff378ba290447c8), UINT64_C(0x59a92eff1779621c), UINT64_C(0x365b3812c1da69b0) }},
  {{ UINT64_C(0xaca77bb3e0da3cd5), UINT64_C(0x275ca249f6113328), UINT64_C(0x47732473fc6b4476), UINT64_C(0x11995784e018364b) }},
  {{ UINT64_C(0xe644b0a35f83d08a), UINT64_C(0x7ca97a3bf561619c), UINT64_C(0x90692ee09974687b), UINT64_C(0x4f63076493b1a314) }},
  {{ UINT64_C(0x73af685df89a826f), UINT64_C(0x099e00c4bf42cb00), UINT64_C(0xbacf92d33a3b16ac), UINT64_C(0x61d3a76ad7214cf7) }},
  {{ UINT64_C(0x37f8465c8960a92a), UINT64_C(0x13e15f3a4624bb23), UINT64_C(0xa63e57ba79a4b853), UINT64_C(0xac1dd4f0c44ba7d5) }},
  {{ UINT64_C(0xb692586e4b5e5fd6), UINT64_C(0x62507b26c293fd3b), UINT64_C(0xd012746918a69230), UINT64_C(0x861e18cb0fc67a4a) }},
  {{ UINT64_C(0x9edfc84ab11d8c2e), UINT64_C(0xa91d3e309a4ed648), UINT64_C(0x17db6fc4c131fd9a), UINT64_C(0x0e00d62e1082e81f) }},
  {{ UINT64_C(0x1e8b69a003c1b9ba), UINT64_C(0x7d852490e49cc21e), UINT64_C(0x9f4c1c86488daeae), UINT64_C(0xd29c8dd28eb97574) }},
  {{ UINT64_C(0xc20d8b588325cf1f), UINT64_C(0x4eb96837b119e005), UINT64_C(0x2e7c1728f10c8585), UINT64_C(0xf01d38cf98d22d0e) }},
  {{ UINT64_C(0x634e807aa95e669e), UINT64_C(0x849c84119b57d58a), UINT64_C(0x6806553c373d55b0), UINT64_C(0x7c2482d38e066842) }},
};

static const block_t Zi_8[] = {
  {{ UINT64_C(0x1107fdff8e196cf9), UINT64_C(0xc45fbd600d2f4efa), UINT64_C(0x8fe6a0d15d923a8b), UINT64_C(0x92e5a7dbe0b7f060) }},
  {{ UINT64_C(0xc706ede4110adb02), UINT64_C(0x11930dd65e8f8e12), UINT64_C(0x62aabc495278ec8b), UINT64_C(0x9cc914326a2e541f) }},
  {{ UINT64_C(0x2b7cf1c2e65bd574), UINT64_C(0x2254242f1c3e26f9), UINT64_C(0xbc9af958a31b4ba4), UINT64_C(0x45cea76a6ee845bf) }},
  {{ UINT64_C(0xa70e8567a92d1bc0), UINT64_C(0x6d731c922db52a85), UINT64_C(0x63a4a03454df8f1f), UINT64_C(0xf6ebb9153843af98) }},
  {{ UINT64_C(0x6f38f62a7c5fe3b4), UINT64_C(0xf8b296b72d01d9fb), UINT64_C(0xcdbec5771ce1c04a), UINT64_C(0x3cacf11ef295f028) }},
  {{ UINT64_C(0x013b0e4723f508f2), UINT64_C(0xd0992eee4ec698a7), UINT64_C(0x061cef54c8a1a767), UINT64_C(0x32e37b0275b533da) }},
  {{ UINT64_C(0x0d8010743d4edbaa), UINT64_C(0x1678081a1bd1b0c0), UINT64_C(0x158bd417d8ba5bcb), UINT64_C(0xbd0fd8a1bf354cca) }},
  {{ UINT64_C(0xe4ef84ba716e930f), UINT64_C(0x3048dc9c95d3b37b), UINT64_C(0x192f035b12f6774e), UINT64_C(0x3f4b99cc59193432) }},
  {{ UINT64_C(0x50bf0481c5a80cfc), UINT64_C(0xd8e34ba397a9cf72), UINT64_C(0x2957399b78466f58), UINT64_C(0xfc240133068ebeb9) }},
  {{ UINT64_C(0x1b1ad83af8fe203e), UINT64_C(0x06d5e595c921736f), UINT64_C(0xf67d656df909a543), UINT64_C(0xb6a536ca2a67ba46) }},
  {{ UINT64_C(0x73a590aff9df334e), UINT64_C(0x9bf35bc3999cb49e), UINT64_C(0x81da04f557d76c95), UINT64_C(0xb0dc980c6e6146a1) }},
  {{ UINT64_C(0x663264fced54ffed), UINT64_C(0xb8a2af5de9341ac4), UINT64_C(0x239ff03b888b93c9), UINT64_C(0x5cc35884288e5024) }},
  {{ UINT64_C(0x61a1f9199653f204), UINT64_C(0x6a9ff1bb0708de32), UINT64_C(0x829eb072d9a321e9), UINT64_C(0xb3dc5123bdec7686) }},
  {{ UINT64_C(0x3164e4bee1fef1f0), UINT64_C(0x1c3d49fee69a5ef5), UINT64_C(0xa39841d9c5efcf1e), UINT64_C(0xb8364a8d97758423) }},
  {{ UINT64_C(0xa925a6d2f3f3c852), UINT64_C(0x4b59daeae8af91a7), UINT64_C(0x37d8c121c7596981), UINT64_C(0x25bc7c8d680044f1) }},
};

static const block_t Zi_9[] = {
  {{ UINT64_C(0xafda681f7a8ef49a), UINT64_C(0x2dd10107f97e5de6), UINT64_C(0x6ef1fa61d0c6ade1), UINT64_C(0xd337aec3c5ea7bb9) }},
  {{ UINT64_C(0xe9f6615b6bc54dc0), UINT64_C(0x698b24fc15daeea4), UINT64_C(0x95284c337692d4cb), UINT64_C(0x6a4a93bee6eb3e95) }},
  {{ UINT64_C(0x77b744130f936686), UINT64_C(0x0213896a8831e722), UINT64_C(0x8ad0c7408973e872), UINT64_C(0x280a58080db0bfdf) }},
  {{ UINT64_C(0x4ca87cde73f37e69), UINT64_C(0x9ef214bc8926acb2), UINT64_C(0x53c2f84919328a0d), UINT64_C(0xb91f4debf8ec6c5e) }},
  {{ UINT64_C(0xb432f55c299ecfbd), UINT64_C(0xa6358974664262a1), UINT64_C(0xfec0095a85110e5d), UINT64_C(0x4b587c3e3bb7f9ec) }},
  {{ UINT64_C(0x1b13003a74890153), UINT64_C(0x59cda7bdef604b48), UINT64_C(0xc9e63e62857b32e1), UINT64_C(0xffc0006584680a85) }},
  {{ UINT64_C(0x5789214ea028cadf), UINT64_C(0xf5f957f8cd8d2699), UINT64_C(0xfc6e096cdcfe875a), UINT64_C(0x9c018121b135c6a9) }},
  {{ UINT64_C(0xa3eeeac8fd95991d), UINT64_C(0xda9d867c0f6c0d32), UINT64_C(0x19ce8c083d6c5288), UINT64_C(0xbedaf2dd4d4b934f) }},
  {{ UINT64_C(0x6ac6f38e5fcb51e7), UINT64_C(0x41b13298ba4ded1f), UINT64_C(0xc4c0d87e01a2b4c4), UINT64_C(0x92032d218bf3bac7) }},
  {{ UINT64_C(0x6085550a817e279e), UINT64_C(0x4fafe0d8acfda09b), UINT64_C(0x93a223353d4e6b61), UINT64_C(0xc0a7c95df5dcba21) }},
  {{ UINT64_C(0x21cd20f69c8bb84a), UINT64_C(0x67ac9c8a0f4f776a), UINT64_C(0x9c432a0db378ebe8), UINT64_C(0xebc226ddb399581f) }},
  {{ UINT64_C(0x18864586fce6ae32), UINT64_C(0x11c82e55f89b5501), UINT64_C(0xc2b4b385b065cbfb), UINT64_C(0xa7e1c8741588a77e) }},
  {{ UINT64_C(0x7186e2fe41dfb48a), UINT64_C(0xf1e57159c0a15bc6), UINT64_C(0xdcb91dbad9097d27), UINT64_C(0xf74dd81a85fae06d) }},
  {{ UINT64_C(0x11b7cda979e7da02), UINT64_C(0xa240a91812efbb65), UINT64_C(0x6618455e1df2aa54), UINT64_C(0x811cfefaa031f767) }},
  {{ UINT64_C(0xf3502793b4849074), UINT64_C(0x9ff4d38294eed41e), UINT64_C(0xbc5232f8dbf48dbc), UINT64_C(0x76e899b12fda1c75) }},
};

static const block_t Zi_10[] = {
  {{ UINT64_C(0xfbb06fbad7be157e), UINT64_C(0x7b999412b7519917), UINT64_C(0x7e12a8bb528be74a), UINT64_C(0xa509de8d39c60326) }},
  {{ UINT64_C(0x5f10779fa12493cc), UINT64_C(0x9da7a74a476b95c6), UINT64_C(0x7d9c6d70356110b4), UINT64_C(0x0e13d0c8f97b1bf0) }},
  {{ UINT64_C(0x6bae7e7d731744ba), UINT64_C(0xb1dcef19ccafdc80), UINT64_C(0xcadf14981526cc8b), UINT64_C(0x6ce582c7b30adc05) }},
  {{ UINT64_C(0x1258ca3ee7d2f2a6), UINT64_C(0xa08ca3033a5fb2f1), UINT64_C(0x1d74b2ef1045650f), UINT64_C(0xed5332e3c9f43dcb) }},
  {{ UINT64_C(0x61249fe3db98028f), UINT64_C(0x0537a6d6eda2452a), UINT64_C(0x7a6dea5b3978b1e9), UINT64_C(0x791c7d1f1952b333) }},
  {{ UINT64_C(0x1d0ff34885d19ef8), UINT64_C(0xf79593f3b76dbddf), UINT64_C(0xe07b36273f50217d), UINT64_C(0xca87906815059248) }},
  {{ UINT64_C(0x1fcecd669c12188e), UINT64_C(0xf104814c0d0c315a), UINT64_C(0x605a8aea7fcdc73d), UINT64_C(0xcc455a0a9005e388) }},
  {{ UINT64_C(0x608e714a79de8e4a), UINT64_C(0x5dfac939bfc2c597), UINT64_C(0x7be2a4db925c83a4), UINT64_C(0x3209fb07044b4408) }},
  {{ UINT64_C(0xf11876f1abfece5f), UINT64_C(0x7c04080b8badb2f0), UINT64_C(0x9ceca4e8f7d103b3), UINT64_C(0xfb92d2af29876ee7) }},
  {{ UINT64_C(0x3f46963b74a72990), UINT64_C(0xea86f627b0798cdc), UINT64_C(0x0c60ec7420a29057), UINT64_C(0x7522b456dcf5e72e) }},
  {{ UINT64_C(0x39b4df3030afe3e0), UINT64_C(0x477eb6e2e5f2d658), UINT64_C(0x38646a562afed3dd), UINT64_C(0xa7ddd0272a6ed965) }},
  {{ UINT64_C(0x4cdee78fdfc7bf3b), UINT64_C(0xd61b25b698cc04af), UINT64_C(0xcc472f6441175665), UINT64_C(0x0b0e54a0ddfdfdf1) }},
  {{ UINT64_C(0x79930821f54d7110), UINT64_C(0x986ca56a1a8a23d8), UINT64_C(0xfef53ece1fb19966), UINT64_C(0x64211eaf8f7cb28e) }},
  {{ UINT64_C(0x8f60dc2dcce19c85), UINT64_C(0x9534818ce58ba623), UINT64_C(0xd67fa2b384c48465), UINT64_C(0x63b34eb48a4a4647) }},
  {{ UINT64_C(0x7b3cccf6f5f56cb6), UINT64_C(0xec4b357bc64e0349), UINT64_C(0xc079558c8fb6f940), UINT64_C(0xedc136ac42cb5d7f) }},
};

static const block_t Zi_11[] = {
  {{ UINT64_C(0x4aaabf1714f0c896), UINT64_C(0x5e8bd59859278239), UINT64_C(0xffc2051f4b56e261), UINT64_C(0xaeafe5efa672efa6) }},
  {{ UINT64_C(0xf29f350644c62e9d), UINT64_C(0x2ddf566d5050c72c), UINT64_C(0x2857838c1b6882b3), UINT64_C(0x872343789554cd5f) }},
  {{ UINT64_C(0x02df11ef1dd8b9e1), UINT64_C(0x2a141672f58722c1), UINT64_C(0x3c5e2ad26e43123f), UINT64_C(0x525d3783adea2e21) }},
  {{ UINT64_C(0xf1ca7d8b9c126b97), UINT64_C(0xb952db9c5169de42), UINT64_C(0x4f6c8c87161122f3), UINT64_C(0x07b7bc47ab9a5a2b) }},
  {{ UINT64_C(0xbbf03d1794d7accf), UINT64_C(0xe82531bd0e5d29df), UINT64_C(0xe81de2343a5d9098), UINT64_C(0x10135abff2ca989e) }},
  {{ UINT64_C(0x38709c2ff840a910), UINT64_C(0x83a4dac49ee6567c), UINT64_C(0xed878a693314fd89), UINT64_C(0xedc25c4a3a9cbe3e) }},
  {{ UINT64_C(0xaad06fc4032b58c8), UINT64_C(0xed76d9d53342f1ab), UINT64_C(0xdbe00070d32842ce), UINT64_C(0xdafb50ce9e890c10) }},
  {{ UINT64_C(0xafac4352855dfdce), UINT64_C(0xfb2f0d5bc2997802), UINT64_C(0xfe4342ef1ecf4c0e), UINT64_C(0x217fcfe69238f285) }},
  {{ UINT64_C(0xd53eb77620c550ab), UINT64_C(0x6cfa377fff603695), UINT64_C(0x1f62a51f88377a53), UINT64_C(0xe0722272d54e30cb) }},
  {{ UINT64_C(0xa1ef0dc9389f9f31), UINT64_C(0x0b13cbf5087af3a5), UINT64_C(0x57e6fc7480a44086), UINT64_C(0x69a8ac4f8b1e788a) }},
  {{ UINT64_C(0xb4b2000eacd00f0c), UINT64_C(0xbe7865566bafa5b1), UINT64_C(0x6238807e91a3f925), UINT64_C(0x5c86b22f6cb7ec28) }},
  {{ UINT64_C(0x1bb208f03606162e), UINT64_C(0xe1c8f7a190d45c2a), UINT64_C(0x026b5966901f0908), UINT64_C(0x25312b407a27413d) }},
  {{ UINT64_C(0x406c43dcc35fb2ac), UINT64_C(0x41ae15e146d679a7), UINT64_C(0x28e9d97f66c25f4a), UINT64_C(0xf83dc4eb84e04efb) }},
  {{ UINT64_C(0xab71abad818907ab), UINT64_C(0x61d83644e4988007), UINT64_C(0x058f3e7af2ca1fe7), UINT64_C(0x719bd08984cdbac7) }},
  {{ UINT64_C(0x68f40e906f5a1992), UINT64_C(0x6da878c0ad93ec57), UINT64_C(0x80c6265da3d19210), UINT64_C(0x50783247c565e1bb) }},
};

static const block_t Zi_12[] = {
  {{ UINT64_C(0x5af0b15d2fe5b6e9), UINT64_C(0x43c602b483ab61e2), UINT64_C(0x44054097f11c9ab0), UINT64_C(0x505318798ee0216d) }},
  {{ UINT64_C(0xa21fabf5d3c181ee), UINT64_C(0x11ac5a3e3cc1d002), UINT64_C(0xc318d1460182d5cb), UINT64_C(0x4c7cf9737d643ebc) }},
  {{ UINT64_C(0x03bc3301e9528290), UINT64_C(0x4c2415a7add26b61), UINT64_C(0x78f2d3557e68ec25), UINT64_C(0xc053875d7e91a863) }},
  {{ UINT64_C(0xfe207592b1438fe2), UINT64_C(0xb0987cbec0c7f820), UINT64_C(0x7ba88ef8d19e8d95), UINT64_C(0x092ebab241eb5381) }},
  {{ UINT64_C(0x040b0149a8720b78), UINT64_C(0x6ef60fff7ef74d62), UINT64_C(0xf0986a8cc3ddc157), UINT64_C(0x0ccdd6969b9d4c65) }},
  {{ UINT64_C(0x0e72efc4b2b1fdbf), UINT64_C(0x072de58191d311bd), UINT64_C(0x9ffcb861e2f895a5), UINT64_C(0x99f5114890ecf861) }},
  {{ UINT64_C(0xcfc0a6a43c5b6565), UINT64_C(0xf667cb81af391eb4), UINT64_C(0x8cd1df9941ca7b2a), UINT64_C(0x43b71b40b2f22937) }},
  {{ UINT64_C(0xdffcf1c8edbc4337), UINT64_C(0x243f630201926629), UINT64_C(0xbac64cb4d61e67d1), UINT64_C(0x272c086cc836b057) }},
  {{ UINT64_C(0x13c3cef6bb67094b), UINT64_C(0x5efe619cb2faaf45), UINT64_C(0x22d6019debcf892f), UINT64_C(0xf5021b0425915b1f) }},
  {{ UINT64_C(0xddaff312f303fd1b), UINT64_C(0x649ebae5474d7e85), UINT64_C(0xdcfb1778f4820803), UINT64_C(0x18627bcde5e5d2a0) }},
  {{ UINT64_C(0xcee59731ecba4d16), UINT64_C(0x133bca4374722068), UINT64_C(0xb006732f04bedc0a), UINT64_C(0xd70ed0c4e186cc9a) }},
  {{ UINT64_C(0xbc373ae6600c479b), UINT64_C(0xcab859041a1e8106), UINT64_C(0x4577cd7b2045f4d6), UINT64_C(0xecf101ce2ff3f707) }},
  {{ UINT64_C(0xdaf4d026cd9753ed), UINT64_C(0xc52cf9fd9f6c9967), UINT64_C(0x716c5ce52303aa25), UINT64_C(0x4399792dc6aed194) }},
  {{ UINT64_C(0x24a150f16380dc81), UINT64_C(0x2401a10f98e0d194), UINT64_C(0xbad79918211f81a7), UINT64_C(0xc56811b663bfd624) }},
  {{ UINT64_C(0xdff2b7aee63d8cb3), UINT64_C(0x610081f27d46bbdb), UINT64_C(0xae0586c24d5fd8fa), UINT64_C(0xb1f2cdf93623448f) }},
};

static const block_t Zi_13[] = {
  {{ UINT64_C(0xd579a5ab910e60ff), UINT64_C(0xa192a8db4be2bf60), UINT64_C(0xf249d480bd277a35), UINT64_C(0x70aaa7d5600b4e35) }},
  {{ UINT64_C(0x5ed49e949bbbd3c2), UINT64_C(0x5bab77cd83e6aef2), UINT64_C(0x2bbb18909c0db96d), UINT64_C(0xc77fba612cbf9232) }},
  {{ UINT64_C(0x548f31109f346418), UINT64_C(0x3114965eaff8ca8c), UINT64_C(0xd6cb02d3374ad16b), UINT64_C(0xa462b94b466f2406) }},
  {{ UINT64_C(0x5d97a54ab8113f04), UINT64_C(0xf86d18b50a2980f7), UINT64_C(0x4fe1d6d2b2921f05), UINT64_C(0x9078c09f9fca82cb) }},
  {{ UINT64_C(0x3d599bbab30c391a), UINT64_C(0xf5aa44b13859e7ca), UINT64_C(0x1c280f5b98b2bdcc), UINT64_C(0x6635ae2dbeeb3d97) }},
  {{ UINT64_C(0x01bf4402b2bb8c12), UINT64_C(0x9875dc6f85b371df), UINT64_C(0xe23602240689b44f), UINT64_C(0x25bbbf8247d27f57) }},
  {{ UINT64_C(0xc03192047a3dea54), UINT64_C(0x4b2e1541c6a3536a), UINT64_C(0x7de6d7c37bf2af00), UINT64_C(0x2ad453b85206bfe1) }},
  {{ UINT64_C(0xf988647fa07dae5c), UINT64_C(0xbef894849e67f2c8), UINT64_C(0x208627bf1e5d1cd4), UINT64_C(0x09e4b3dd016d83ca) }},
  {{ UINT64_C(0xc18f27602d3a4c3c), UINT64_C(0x7a26d6f90e203f36), UINT64_C(0x35e60418253d2900), UINT64_C(0xae394e3cf0eb3c14) }},
  {{ UINT64_C(0x43a91a9ee89323a4), UINT64_C(0x9c6f42af44487410), UINT64_C(0xf43d33d33939a1af), UINT64_C(0x5402ea88db6671ef) }},
  {{ UINT64_C(0x5e7ebcd3d58498f7), UINT64_C(0x5c05a9717e347b72), UINT64_C(0xc256dd1aeac0e983), UINT64_C(0x63cae68264dc07c1) }},
  {{ UINT64_C(0xc39cdbe6a95c6472), UINT64_C(0x1017228e6448ac19), UINT64_C(0x9d971a3909e18842), UINT64_C(0xb7bcb333ff22cf14) }},
  {{ UINT64_C(0xc878fbfae185239a), UINT64_C(0x497de27408a22122), UINT64_C(0xe2fb8bd81bf26f24), UINT64_C(0x5919c0b9195b0d88) }},
  {{ UINT64_C(0x318fe2e7538a7900), UINT64_C(0xd173411f0cec7c3b), UINT64_C(0xbcee477b2a0df886), UINT64_C(0xad1e1b56d19f52c0) }},
  {{ UINT64_C(0x166e343504a48f21), UINT64_C(0x05af863d9e1de6fe), UINT64_C(0xcb6a5f409178e85e), UINT64_C(0xe5a016f041630954) }},
};

static const block_t Zi_14[] = {
  {{ UINT64_C(0x4c74da4f590cb8cb), UINT64_C(0x5e2e1c72bb694210), UINT64_C(0x644c03e5b73090bf), UINT64_C(0x3b117160a8724a8a) }},
  {{ UINT64_C(0x03ba1227ee3d3c9d), UINT64_C(0xe4aa2dd4a7400833), UINT64_C(0x099956880ed894fb), UINT64_C(0x3eee184a2a1e072b) }},
  {{ UINT64_C(0x363d02e4feaaa3ca), UINT64_C(0xa8f5e63ef4526212), UINT64_C(0x34a7d271a735fea5), UINT64_C(0xbac342226779d194) }},
  {{ UINT64_C(0x6151070f7eabb7fb), UINT64_C(0x04c55f4edd7917de), UINT64_C(0x43c0ff7d9fbf5b58), UINT64_C(0xc046cba1d1dceef7) }},
  {{ UINT64_C(0xfaaaa88a42092e64), UINT64_C(0x25b426735becd74e), UINT64_C(0xb1236271d1103d7e), UINT64_C(0x1fa995b4d4bc6601) }},
  {{ UINT64_C(0x12bd8039ab054485), UINT64_C(0xc2e42e73bb2df128), UINT64_C(0xb1cbc6f39acd2e65), UINT64_C(0x00fdd335d2e4dfbb) }},
  {{ UINT64_C(0x2ee2c33b3fc23774), UINT64_C(0x2f32a8cc5860d316), UINT64_C(0xffee1cb468dbf524), UINT64_C(0xb1ba18342fc78e28) }},
  {{ UINT64_C(0xce7473ffa6d0e33d), UINT64_C(0xb8b9d6621e227903), UINT64_C(0x44f508838f736e2c), UINT64_C(0xa0ac4e5a321439b9) }},
  {{ UINT64_C(0x36fa28ed6462be70), UINT64_C(0x6a174bcfd52ae40f), UINT64_C(0xf24010cbf55551e5), UINT64_C(0x7a2f0493bbf396c6) }},
  {{ UINT64_C(0xc31e055ffd8340a3), UINT64_C(0x65171b3b5980ba12), UINT64_C(0xab9d84f5c141840b), UINT64_C(0xb83ac3c41b82fa45) }},
  {{ UINT64_C(0x0a65ee0a3cfca630), UINT64_C(0xcd602d191e8d389a), UINT64_C(0xf85d55add34071c2), UINT64_C(0xb1537bf46606b0a5) }},
  {{ UINT64_C(0x183a91eab3dd126e), UINT64_C(0xc6919b90f5dc26f4), UINT64_C(0x3ca473365701ffce), UINT64_C(0x6c24a4aedff7ef74) }},
  {{ UINT64_C(0x38d90a610058d1ee), UINT64_C(0x1ac7707368962b0d), UINT64_C(0x7ae5cfe623b5b406), UINT64_C(0x76c25e92f66be023) }},
  {{ UINT64_C(0x47ccfb30cfde68f6), UINT64_C(0x7ae1e1e1f77608c4), UINT64_C(0xa233d2fdf231214d), UINT64_C(0xc302fbc872fcc7fc) }},
  {{ UINT64_C(0x66a5a8e07e3d9ea7), UINT64_C(0x7e26dc1a2cd05bca), UINT64_C(0x95dfb3286e2589d8), UINT64_C(0x7feeaf5f9011a667) }},
};

static const block_t Zi_15[] = {
  {{ UINT64_C(0xd6145fc2be7ea651), UINT64_C(0x33a0501b6b8b9767), UINT64_C(0x3cd6d15793c7b374), UINT64_C(0xc846799c838e4837) }},
  {{ UINT64_C(0xda9124870cd8979b), UINT64_C(0x23b68b9941228749), UINT64_C(0x07015ba7c7e83c01), UINT64_C(0x1a4a26564fe17629) }},
  {{ UINT64_C(0xc9a85fbc81663982), UINT64_C(0x560483bfe1d5aeed), UINT64_C(0x4066f91ffff3eb05), UINT64_C(0x5dbf12af3114e707) }},
  {{ UINT64_C(0x4596adf7fa536290), UINT64_C(0xf10d01418fe75bdf), UINT64_C(0x009cfc615e2872d8), UINT64_C(0x0d1538efd7d51383) }},
  {{ UINT64_C(0xd546210be70a4376), UINT64_C(0x2bc93ce124d0e237), UINT64_C(0xe36b5a1bf9c9df2c), UINT64_C(0xf27834b7869bb382) }},
  {{ UINT64_C(0x09f5999e11845395), UINT64_C(0x863f3521c107a912), UINT64_C(0x25e18808fa7b55ba), UINT64_C(0x384b9ed1a5f1df95) }},
  {{ UINT64_C(0x58cc75c50802d332), UINT64_C(0x3f49b821a7582bf2), UINT64_C(0x6a7d45dae9ac0d12), UINT64_C(0xfa3fbff509fd1a80) }},
  {{ UINT64_C(0xb28c8465ef77cdfa), UINT64_C(0x8198d91d3095a562), UINT64_C(0x205b30aaadda248a), UINT64_C(0x634f84ea6880dec7) }},
  {{ UINT64_C(0x24f4d98719ab3f0e), UINT64_C(0xa5ad7996932a54f7), UINT64_C(0x24a0a4375ffa4e80), UINT64_C(0xbc17483a1a549ad0) }},
  {{ UINT64_C(0xc232e7729dc8898b), UINT64_C(0x48210034ea736061), UINT64_C(0xa15bdc9a2f6344fd), UINT64_C(0xcfaf3b6d15cb30f7) }},
  {{ UINT64_C(0xecc79fa56e1c7609), UINT64_C(0x319382bdc8f81d04), UINT64_C(0x534240be776a43a7), UINT64_C(0xa63d455125002149) }},
  {{ UINT64_C(0xdfda08906de31266), UINT64_C(0x759a2e5f2bbc6ae0), UINT64_C(0xc847cb86b3c786b6), UINT64_C(0x30389539e00d5d31) }},
  {{ UINT64_C(0x1ca8afbd083f3888), UINT64_C(0x31df182c0f548a11), UINT64_C(0x01963328581f1c1e), UINT64_C(0x363702a0c1b0bc2c) }},
  {{ UINT64_C(0xd1c5b7ca50cab929), UINT64_C(0x8a752de050d83b4a), UINT64_C(0xbc2aacc8ed6a85d3), UINT64_C(0xa8b7e8f862a9ad63) }},
  {{ UINT64_C(0x76b9b23565abc255), UINT64_C(0x00a3f928dc692101), UINT64_C(0xb594bd2ac9a2311d), UINT64_C(0xcaec1394f20dc5b8) }},
};

static const block_t Zi_16[] = {
  {{ UINT64_C(0xc19ca7fb219f634b), UINT64_C(0x2c16e35160299d76), UINT64_C(0xc48f15696b7be999), UINT64_C(0x79fa54af2f38e0db) }},
  {{ UINT64_C(0x941579b38aa491fa), UINT64_C(0x8b9d422bed2d8d84), UINT64_C(0x6f6bda9adebf217c), UINT64_C(0xbcc38b2f4db13d77) }},
  {{ UINT64_C(0xd56550b0bd267350), UINT64_C(0x34238118d612603b), UINT64_C(0x39102eda437b6768), UINT64_C(0xcc542d08860534c2) }},
  {{ UINT64_C(0xbc4b337b073c4748), UINT64_C(0xfeb789e3e1776ed2), UINT64_C(0x849b67fc59dfcf5e), UINT64_C(0xbdc1b7bd990f482a) }},
  {{ UINT64_C(0xf01331969f6c4394), UINT64_C(0xca01b071e8c8115a), UINT64_C(0x8898480cd8bf47dd), UINT64_C(0x9148d3658d5cb00b) }},
  {{ UINT64_C(0x1c162e37db3d3b99), UINT64_C(0x690ea9f82e6e183d), UINT64_C(0x607000eac4424de7), UINT64_C(0x15fc85c4d66ca4c6) }},
  {{ UINT64_C(0xe131a65eeaed005d), UINT64_C(0x8cbe35fef69c2b04), UINT64_C(0x75507c106b813397), UINT64_C(0x213f0360318d8444) }},
  {{ UINT64_C(0x6bc2920d3a241c9e), UINT64_C(0xdc203c8a6429dd5c), UINT64_C(0xdc26f5b46e55b17a), UINT64_C(0xa6b4bb569499cd06) }},
  {{ UINT64_C(0x66589a4d4abc688a), UINT64_C(0x78ef3101d4f019c8), UINT64_C(0x73d0ee19b2771d33), UINT64_C(0xd1ec6e7ad39a0f7f) }},
  {{ UINT64_C(0xa91de7012901ef9b), UINT64_C(0x531112577cfcc155), UINT64_C(0x9e2f47547c4646d6), UINT64_C(0x6fa7f78a272ff33f) }},
  {{ UINT64_C(0x7938d3b58b57d9d8), UINT64_C(0x990d5fbded30dad4), UINT64_C(0x875861c0d269ba0b), UINT64_C(0x718a919839d0afe7) }},
  {{ UINT64_C(0x5fa889d5e071eb8e), UINT64_C(0x1aa139b72b08ecca), UINT64_C(0x02aba5d9de27764e), UINT64_C(0x060330e6b4b82d38) }},
  {{ UINT64_C(0x17fa79a18eec9973), UINT64_C(0x92b325cdc8bf69a2), UINT64_C(0x3c55f8740413e595), UINT64_C(0x3572db7104692245) }},
  {{ UINT64_C(0x8bf80095b4908c08), UINT64_C(0xcb319be40cb89227), UINT64_C(0xd8cea4549333b381), UINT64_C(0x4a1113623b428166) }},
  {{ UINT64_C(0x519ce796f3a29891), UINT64_C(0xadc3183f0dbed6c9), UINT64_C(0x16f14204b2ee6bd9), UINT64_C(0x1bf3f9dfbe0fb04c) }},
};

static const block_t Zi_17[] = {
  {{ UINT64_C(0x8fb46551086c402f), UINT64_C(0x58fc3107b6bbbcc1), UINT64_C(0x563e06b3dabe793e), UINT64_C(0xd7a41751128fa928) }},
  {{ UINT64_C(0x5867c01cca276b07), UINT64_C(0x82ef7ef9d5e6c024), UINT64_C(0x1a2815bf5fb45bb4), UINT64_C(0x08edc759ff1d82f3) }},
  {{ UINT64_C(0x4cdd9bdec36e7002), UINT64_C(0xe4a300e3f82b9e41), UINT64_C(0x88531ffeb186c6f1), UINT64_C(0xa37b50a6bf55a19d) }},
  {{ UINT64_C(0xe0578c19883a4cf4), UINT64_C(0xb905804cb7485874), UINT64_C(0xb3335e59dc35d38c), UINT64_C(0x0bc4b6c12f4d4410) }},
  {{ UINT64_C(0x049c1b31574b82e9), UINT64_C(0x13c5d7ac8d591fb9), UINT64_C(0x14b012fa831ffafa), UINT64_C(0x4635faf51dd6e6c2) }},
  {{ UINT64_C(0xe8bb51b493db1213), UINT64_C(0x30e3142f8eedda1d), UINT64_C(0x7a58d5c5f9fb0d55), UINT64_C(0xb2bc420f7857f0b7) }},
  {{ UINT64_C(0x036d8ecc4bf5cb00), UINT64_C(0x5aa19bd7ef13a10b), UINT64_C(0xdf5e96efc76e8b12), UINT64_C(0xa875794c6fa0990f) }},
  {{ UINT64_C(0x12c8302133dab0be), UINT64_C(0x5c2c5ec907977224), UINT64_C(0x9c7f41b586ca5be7), UINT64_C(0x290680c83c0cf88b) }},
  {{ UINT64_C(0x2cfad3fc1f1cb8b0), UINT64_C(0x5ed42461b85f093c), UINT64_C(0xf24a5c11b17db94a), UINT64_C(0x19de7cf2beef6b6e) }},
  {{ UINT64_C(0x7356128b35b5f8a8), UINT64_C(0xcc60f5440d2b2b63), UINT64_C(0x27a9c0678e57f032), UINT64_C(0xb5d156a1f1337b1e) }},
  {{ UINT64_C(0x37914bdc9f6262df), UINT64_C(0x70d77cde169f6841), UINT64_C(0x83accc449fab78c0), UINT64_C(0x0d4aad73531ba046) }},
  {{ UINT64_C(0xcc31a83bfeb45e74), UINT64_C(0xc03c6531b3e62cf1), UINT64_C(0xe6ff3b841a68f9bc), UINT64_C(0x0f45c22c556f1f21) }},
  {{ UINT64_C(0x9bd4d0f38e9eb7ff), UINT64_C(0x65b1f37f1c7ae00a), UINT64_C(0x3c9f0f2d5cada782), UINT64_C(0x68d86c9a416ad1b0) }},
  {{ UINT64_C(0x2890784a31efc409), UINT64_C(0x52b188e99632920a), UINT64_C(0x785db1e58f74cb99), UINT64_C(0xe40e1fbd94827b0a) }},
  {{ UINT64_C(0xa7be3083fd7ca936), UINT64_C(0x85c9d5be685f9ae5), UINT64_C(0xb433aa3910948e17), UINT64_C(0x5101e09abb45864a) }},
};

static const block_t Zi_18[] = {
  {{ UINT64_C(0xbe968fa6b9eaeb29), UINT64_C(0xa3872b92d9f16ca4), UINT64_C(0xef1e63f767c537b0), UINT64_C(0xd986b4777c7ece75) }},
  {{ UINT64_C(0x5ba966c086714c63), UINT64_C(0xa0468ef6d6c54a4e), UINT64_C(0x71ee5400ac54ec95), UINT64_C(0x268c7700f77ce893) }},
  {{ UINT64_C(0x42b11c2c89c85535), UINT64_C(0x84290d421796e2c0), UINT64_C(0x3ced979ba78f7da5), UINT64_C(0xc7799cb53d2409af) }},
  {{ UINT64_C(0x45986e4d689d379a), UINT64_C(0x308f6df52c5b602c), UINT64_C(0xde895328d91270a9), UINT64_C(0xc0a0d8cde7d0d9d6) }},
  {{ UINT64_C(0xbc00870268ea8298), UINT64_C(0x8a878a0ec9a4bf13), UINT64_C(0x6ddcf599c1cfce8c), UINT64_C(0x957a58b307f36a00) }},
  {{ UINT64_C(0x2d7cc5f1741d4097), UINT64_C(0xe885a5bbdfccbc59), UINT64_C(0x759de79247472613), UINT64_C(0x02e19083db8bd854) }},
  {{ UINT64_C(0xa7a856d0109e42ed), UINT64_C(0x77566ad483833d99), UINT64_C(0x6d94376094becca0), UINT64_C(0xeb521dd6cc872558) }},
  {{ UINT64_C(0xe66b99fdb19d1953), UINT64_C(0xf1d6026a253016bd), UINT64_C(0x16268d010cfb3bb6), UINT64_C(0x6beb6b0ced02436d) }},
  {{ UINT64_C(0x3aa0177bc0fad96b), UINT64_C(0x50b60b37b9e8e998), UINT64_C(0x8d37b1bf03cda5bb), UINT64_C(0xf55daf22b96c8d65) }},
  {{ UINT64_C(0xd4f1af1ce07fe768), UINT64_C(0x80083c2cbfdb8241), UINT64_C(0x403ddbbf93106510), UINT64_C(0x61b07bf1135442cd) }},
  {{ UINT64_C(0x89e5c48c1b55dbd4), UINT64_C(0xdfe662163b52e994), UINT64_C(0x2989b4abc62d2973), UINT64_C(0xd27f78fffabd53cf) }},
  {{ UINT64_C(0xe19ea7d01a9ff1f4), UINT64_C(0xe69f22fa3cc8e39d), UINT64_C(0x26b33b168eb318bd), UINT64_C(0x352de037c257d176) }},
  {{ UINT64_C(0x642fb68170812db3), UINT64_C(0x5d6670b73ed97ff3), UINT64_C(0xf536edea9f87e73b), UINT64_C(0x91ebe4a0df0fad0b) }},
  {{ UINT64_C(0xe20c64fe4d350d8a), UINT64_C(0xe029149a1cc91a37), UINT64_C(0x64885f9c0fee6455), UINT64_C(0x5f361792807912bd) }},
  {{ UINT64_C(0xdfe9f6add2a79004), UINT64_C(0xb7e9ec0fb8228256), UINT64_C(0x6f25231fd9cfa76a), UINT64_C(0xcd6d900fb99745dd) }},
};

static const block_t Ri_0[] = {
  {{ UINT64_C(0x4f2896f139bb46ac), UINT64_C(0x000000002b8cb41a), UINT64_C(0x6e5be695ee1e1d9f), UINT64_C(0x00000000274b43e3) }},
  {{ UINT64_C(0xd330ffb3afa973cb), UINT64_C(0x00000000c2a3f976), UINT64_C(0x0d734bb7b69e86c2), UINT64_C(0x000000008627e704) }},
  {{ UINT64_C(0x18bf5c906672607a), UINT64_C(0x00000002e8279f08), UINT64_C(0x14eb18fb6116cdb3), UINT64_C(0x0000000339f107c4) }},
  {{ UINT64_C(0x3cc55dfc92b54589), UINT64_C(0x00000000428d2935), UINT64_C(0xbd8900ec044aa15f), UINT64_C(0x000000000a8be854) }},
  {{ UINT64_C(0x12df21c878108f02), UINT64_C(0x000000004c0bf351), UINT64_C(0xdc809ba355202bb7), UINT64_C(0x00000002705d1e6e) }},
  {{ UINT64_C(0x0fabca0f934ab22a), UINT64_C(0x000000012907aeb6), UINT64_C(0xe4252709e91ed887), UINT64_C(0x000000037781f6a1) }},
  {{ UINT64_C(0x0770f4169c5a1f0e), UINT64_C(0x0000000381207e22), UINT64_C(0xb7a9efd3d4e5b464), UINT64_C(0x00000001219ac1a5) }},
  {{ UINT64_C(0x138c86726e2424a6), UINT64_C(0x0000000253e12530), UINT64_C(0xc09302490770f607), UINT64_C(0x00000000ec482cd9) }},
  {{ UINT64_C(0x32c3033ec31b77b8), UINT64_C(0x00000003309de89a), UINT64_C(0xc89be178bea060be), UINT64_C(0x000000020a4842c3) }},
  {{ UINT64_C(0xca8ec6871257bb98), UINT64_C(0x00000003bc00ace5), UINT64_C(0x2c5cd7f41dc12053), UINT64_C(0x0000000162ffe2e9) }},
  {{ UINT64_C(0xa94227d6ba25a8c8), UINT64_C(0x00000003a651ae03), UINT64_C(0xdbabace74c62c7e8), UINT64_C(0x000000013f95002e) }},
  {{ UINT64_C(0xc0e32ec5d4e57f38), UINT64_C(0x0000000331352982), UINT64_C(0x44dcf4ac81882866), UINT64_C(0x000000023f49a9ab) }},
  {{ UINT64_C(0x169f92046d688f6c), UINT64_C(0x00000000c5ae4d71), UINT64_C(0x3d8e8004da6b90ce), UINT64_C(0x000000016f0edc10) }},
  {{ UINT64_C(0xc9273621b1d43fc9), UINT64_C(0x00000000bbee6178), UINT64_C(0x561fd0ad0f9fcf40), UINT64_C(0x000000009a8514d5) }},
  {{ UINT64_C(0x83c8fe4386a2052b), UINT64_C(0x000000028838d006), UINT64_C(0x326aebd4474a0959), UINT64_C(0x000000023b56cdbe) }},
};

static const block_t Ri_1[] = {
  {{ UINT64_C(0x35bfd38957c9ae3b), UINT64_C(0x000000005c125573), UINT64_C(0xa16026721e476f0f), UINT64_C(0x000000006884b46e) }},
  {{ UINT64_C(0x03dbec9565c9d01c), UINT64_C(0x000000005492e98e), UINT64_C(0x1ade429ae02b23d6), UINT64_C(0x00000001eb12f595) }},
  {{ UINT64_C(0x45a72f1ebb9fd623), UINT64_C(0x000000001a8973a0), UINT64_C(0x18de8c7cd638709a), UINT64_C(0x0000000256b757fd) }},
  {{ UINT64_C(0xc6c25cf5f07920c2), UINT64_C(0x00000000938e6915), UINT64_C(0xf85c7df03b829f09), UINT64_C(0x0000000337073607) }},
  {{ UINT64_C(0x83b5c900d1569cd3), UINT64_C(0x0000000097ee1282), UINT64_C(0x093ce13c4fe2b5d6), UINT64_C(0x00000001a8ae1ca1) }},
  {{ UINT64_C(0xed4fa6edfc893d0d), UINT64_C(0x0000000293ee5072), UINT64_C(0x1b0cdee1b6bd48d3), UINT64_C(0x0000000078f8e94e) }},
  {{ UINT64_C(0x0c0a930209741c90), UINT64_C(0x00000002cd81d5a7), UINT64_C(0x6f6fb081fc1f06e9), UINT64_C(0x00000002de965ac6) }},
  {{ UINT64_C(0x98cc1718459f57e1), UINT64_C(0x00000000e5815e45), UINT64_C(0xfecc94c527b878bb), UINT64_C(0x00000002b7773571) }},
  {{ UINT64_C(0xca86f4927a097723), UINT64_C(0x00000001b1061dae), UINT64_C(0x8b66030548089df4), UINT64_C(0x0000000076377965) }},
  {{ UINT64_C(0xc01ff1171083c1bb), UINT64_C(0x000000026131be3a), UINT64_C(0x15b3ec2e8d517cab), UINT64_C(0x00000002a061416d) }},
  {{ UINT64_C(0x02df280cce959fcf), UINT64_C(0x00000000b0ddcffb), UINT64_C(0x2cd7299961660bd7), UINT64_C(0x00000000266f6196) }},
  {{ UINT64_C(0x50ecf600b9ac5ea8), UINT64_C(0x000000002050f07b), UINT64_C(0x98e8dd437bca0b3b), UINT64_C(0x00000000cb9d0bae) }},
  {{ UINT64_C(0x07ddb7a1b960c529), UINT64_C(0x00000003d978d144), UINT64_C(0xbc4abadbcb0ace40), UINT64_C(0x00000001ca058941) }},
  {{ UINT64_C(0xa5991a29c3b5815a), UINT64_C(0x00000003cc14ad02), UINT64_C(0x7f306e471a5bdf47), UINT64_C(0x00000002da8ad4f3) }},
  {{ UINT64_C(0x87b52650dc3719f1), UINT64_C(0x000000035a06fc02), UINT64_C(0xda7e4a0446bb9f12), UINT64_C(0x000000035a2e9baf) }},
};

static const block_t Ri_2[] = {
  {{ UINT64_C(0xb62afe400ec40bff), UINT64_C(0x00000001f2755d55), UINT64_C(0xbfd2920722e5fafc), UINT64_C(0x000000000419718e) }},
  {{ UINT64_C(0x6d2bcec6ab792b88), UINT64_C(0x000000016d296597), UINT64_C(0x145fc323c9c1ba5e), UINT64_C(0x00000003e8a4408f) }},
  {{ UINT64_C(0xcdc652ec21115841), UINT64_C(0x000000039ba01d03), UINT64_C(0x5bd1ad8325ddf71f), UINT64_C(0x00000001514502fd) }},
  {{ UINT64_C(0xf8220dd7eb1ed9a6), UINT64_C(0x0000000068f4e7de), UINT64_C(0xd39e1692d78104b0), UINT64_C(0x000000005add9057) }},
  {{ UINT64_C(0x904ad6a0d307d829), UINT64_C(0x000000011eb11ccc), UINT64_C(0x7e830fe83d375ba7), UINT64_C(0x0000000043f53994) }},
  {{ UINT64_C(0x24339e1de860e3fb), UINT64_C(0x00000003676697f1), UINT64_C(0x84c35549f1f7526d), UINT64_C(0x00000003a1867732) }},
  {{ UINT64_C(0xfc163ae7b15806af), UINT64_C(0x00000002341c5324), UINT64_C(0xdbe332e61aada692), UINT64_C(0x00000001b6e6bf44) }},
  {{ UINT64_C(0xd3e0ba7e7e93afea), UINT64_C(0x0000000312732d43), UINT64_C(0x1fa8086c8ef6c81a), UINT64_C(0x00000000c3e30df9) }},
  {{ UINT64_C(0x270b7bae0b423fca), UINT64_C(0x00000003e400678c), UINT64_C(0xe477ec0b23a593f3), UINT64_C(0x00000001b9d97995) }},
  {{ UINT64_C(0x88acdfb3faca4ed9), UINT64_C(0x0000000296bdd6d3), UINT64_C(0x4b853c2eac11249d), UINT64_C(0x00000000c82b1b02) }},
  {{ UINT64_C(0xc5a7aeabe9f25221), UINT64_C(0x00000000323a9fa8), UINT64_C(0xc57682e1a1df3d35), UINT64_C(0x00000002a89260da) }},
  {{ UINT64_C(0xb827fec514bad500), UINT64_C(0x000000020bc5652b), UINT64_C(0xec2666ecafe52075), UINT64_C(0x00000001f25c8479) }},
  {{ UINT64_C(0x5fc210483d250b2b), UINT64_C(0x00000001f47962ba), UINT64_C(0x9c9ec123037a8dc7), UINT64_C(0x00000002b88dffed) }},
  {{ UINT64_C(0x5a27fb367b057287), UINT64_C(0x00000000534f8982), UINT64_C(0xdd2ad8afccbcd9a0), UINT64_C(0x00000003e914a803) }},
  {{ UINT64_C(0x51a9f2f9c20a7e28), UINT64_C(0x00000000a943c0f1), UINT64_C(0x9ba3ab06974c0a7b), UINT64_C(0x00000002617d62a9) }},
};

static const block_t Ri_3[] = {
  {{ UINT64_C(0x59f8c9e69849cf54), UINT64_C(0x000000000bb9c0eb), UINT64_C(0xb60f15237060ca94), UINT64_C(0x00000000c0abf203) }},
  {{ UINT64_C(0xfab97d2429ded286), UINT64_C(0x00000003309acc8c), UINT64_C(0xb0b98f8ddff23ea4), UINT64_C(0x00000001d28b1da3) }},
  {{ UINT64_C(0x0b6614554f7bc31e), UINT64_C(0x0000000098ff0f19), UINT64_C(0x153c0a4088eb3e22), UINT64_C(0x000000033949756b) }},
  {{ UINT64_C(0x9ec74a6f8b88d180), UINT64_C(0x000000018758e460), UINT64_C(0x766edc3988fee097), UINT64_C(0x000000032534744b) }},
  {{ UINT64_C(0x900f796ae5eada36), UINT64_C(0x00000003695f081a), UINT64_C(0x29686b9a431e2059), UINT64_C(0x000000039ef5066a) }},
  {{ UINT64_C(0x7522cc094812e1da), UINT64_C(0x000000024ae81165), UINT64_C(0x659e7f38e78193db), UINT64_C(0x00000003c1f9c98a) }},
  {{ UINT64_C(0x7850c164c264f7b2), UINT64_C(0x00000002447ac7b8), UINT64_C(0xb83aa5bb7aeafbfa), UINT64_C(0x00000001752d3923) }},
  {{ UINT64_C(0x7d5ddf8b6ab2e3bb), UINT64_C(0x0000000251f2e284), UINT64_C(0x2f0406d05b8579b2), UINT64_C(0x00000002a0109834) }},
  {{ UINT64_C(0xb3f2c7f85248a7fe), UINT64_C(0x000000011730008a), UINT64_C(0xd7c8e30023accf39), UINT64_C(0x00000001ce5c937d) }},
  {{ UINT64_C(0x3afbc197576352cf), UINT64_C(0x000000001303a684), UINT64_C(0xc6bbef0da8c4454d), UINT64_C(0x000000026ab20fe7) }},
  {{ UINT64_C(0xc33cebea3bfa5257), UINT64_C(0x000000028ca53e4a), UINT64_C(0xb35b2488b21ff3b9), UINT64_C(0x00000003306e452e) }},
  {{ UINT64_C(0x3a42c87527839cf0), UINT64_C(0x00000003e6b31da4), UINT64_C(0xdd160a8c0ac398d1), UINT64_C(0x0000000305cfc942) }},
  {{ UINT64_C(0x91061c5b652fcdd6), UINT64_C(0x0000000151e6b2a7), UINT64_C(0xad1d6cb56e6baa33), UINT64_C(0x00000003cd1b89bf) }},
  {{ UINT64_C(0x7cfdf8a5efa90144), UINT64_C(0x000000002c70ce4a), UINT64_C(0x7bccf637179f3183), UINT64_C(0x000000004f02e18f) }},
  {{ UINT64_C(0x6e09e59cf775ddd9), UINT64_C(0x0000000174375da9), UINT64_C(0xef3adfc67903e3b2), UINT64_C(0x00000001a3cde7f7) }},
};

static const block_t Ri_4[] = {
  {{ UINT64_C(0xa97163616405d44a), UINT64_C(0x00000003bc067c37), UINT64_C(0xbb42b6e77035add6), UINT64_C(0x00000003968b10cc) }},
  {{ UINT64_C(0xf2573653a58d6979), UINT64_C(0x00000003ae5cf981), UINT64_C(0xd4f8fdeccf0b787b), UINT64_C(0x00000003feceb8f7) }},
  {{ UINT64_C(0x59f9bb722f23ad10), UINT64_C(0x00000001b517e5be), UINT64_C(0x9de5196d4a281865), UINT64_C(0x00000000765c6cb9) }},
  {{ UINT64_C(0x7166f541ad82d21f), UINT64_C(0x00000002f1dc038c), UINT64_C(0x9689c0505b13948d), UINT64_C(0x00000000af86bffd) }},
  {{ UINT64_C(0xe64eb8d3e41861d6), UINT64_C(0x00000002d3998070), UINT64_C(0xdc923fbbb2a302fc), UINT64_C(0x0000000300535aef) }},
  {{ UINT64_C(0x2322e068ff08b856), UINT64_C(0x00000002712043c5), UINT64_C(0xe2ebd4c65c19b8d2), UINT64_C(0x00000003d63ff6be) }},
  {{ UINT64_C(0x5ef19efd4cc226c1), UINT64_C(0x000000013a380a2c), UINT64_C(0x8da81a592411d210), UINT64_C(0x000000001ce68c24) }},
  {{ UINT64_C(0xefaaaf91b37a2ec1), UINT64_C(0x0000000325baf4e0), UINT64_C(0x0cf4984027759441), UINT64_C(0x000000025cbc3ab4) }},
  {{ UINT64_C(0x61bd709f5afd320e), UINT64_C(0x00000001062094a8), UINT64_C(0xbad5787fdc0556c7), UINT64_C(0x0000000359ae05db) }},
  {{ UINT64_C(0xcfb8727d9da36c15), UINT64_C(0x00000002601b0d7f), UINT64_C(0x1d0e95ab3188d9db), UINT64_C(0x000000032841f6dd) }},
  {{ UINT64_C(0x70a01b820096828d), UINT64_C(0x000000004fba1b8e), UINT64_C(0xd9e6df1e31615ee9), UINT64_C(0x00000000fa38ce5b) }},
  {{ UINT64_C(0xea1dd08f9db3ca6f), UINT64_C(0x00000001366f5477), UINT64_C(0x6e5993ea3f3eef5c), UINT64_C(0x00000003938d098b) }},
  {{ UINT64_C(0x1086c40ec4e731b6), UINT64_C(0x000000031ff1f2cd), UINT64_C(0x3d54c1efcd3a8207), UINT64_C(0x0000000152bba2e5) }},
  {{ UINT64_C(0xf4f5db74eba372d6), UINT64_C(0x000000027f2484e3), UINT64_C(0xea993829e05cd442), UINT64_C(0x000000006ab91c52) }},
  {{ UINT64_C(0x23add4225e835602), UINT64_C(0x00000003224f87d0), UINT64_C(0x222302aee89f5a0e), UINT64_C(0x00000003fb38cdfa) }},
};

static const block_t Ri_5[] = {
  {{ UINT64_C(0xa38b7e9613acb4b7), UINT64_C(0x000000001a585fac), UINT64_C(0xddc989fdcc96607b), UINT64_C(0x00000000bdccee83) }},
  {{ UINT64_C(0xfda6b89b569aba36), UINT64_C(0x00000001f5b2948f), UINT64_C(0xcd26741b63863da5), UINT64_C(0x00000000e767a707) }},
  {{ UINT64_C(0xdb9cdf8282b53740), UINT64_C(0x0000000225422310), UINT64_C(0x89b209734b575e0a), UINT64_C(0x00000000033386be) }},
  {{ UINT64_C(0x7d1187f5f7d641e0), UINT64_C(0x00000001abde4a1c), UINT64_C(0x3dc000326c475329), UINT64_C(0x00000001df6ffd31) }},
  {{ UINT64_C(0x5280d45d802a0bc9), UINT64_C(0x00000003a284c857), UINT64_C(0x1c4f531452e885a1), UINT64_C(0x000000022b66c456) }},
  {{ UINT64_C(0xc1c6a00729406879), UINT64_C(0x000000021d6225e1), UINT64_C(0xb08769b8d50bebc3), UINT64_C(0x00000002e8cefd45) }},
  {{ UINT64_C(0x3bc0f6d2dd4b51df), UINT64_C(0x000000020278b642), UINT64_C(0xb88ed534523d10fe), UINT64_C(0x00000002b4df9d9f) }},
  {{ UINT64_C(0xcd3724f175939e95), UINT64_C(0x0000000133c5f84c), UINT64_C(0xc41fb72871f5f9f7), UINT64_C(0x000000007baa9c6d) }},
  {{ UINT64_C(0x4ff5bf5540c9e8eb), UINT64_C(0x0000000282d5a06a), UINT64_C(0x5658eb4364546441), UINT64_C(0x0000000299aa2523) }},
  {{ UINT64_C(0x5c47f7c9de71e28c), UINT64_C(0x0000000205ac9073), UINT64_C(0x69b41ec8e203cc84), UINT64_C(0x000000024e4576c7) }},
  {{ UINT64_C(0x27a54c929d0403c8), UINT64_C(0x00000001350df7b8), UINT64_C(0x98b72aed2ed51ff0), UINT64_C(0x00000002caaacfdf) }},
  {{ UINT64_C(0x234b959f20fd301f), UINT64_C(0x0000000389f3def4), UINT64_C(0x422d724bb1dd3f0b), UINT64_C(0x000000038ca37cff) }},
  {{ UINT64_C(0x77d1a03cec74468a), UINT64_C(0x00000003d83d4721), UINT64_C(0x8415bc5580cf481c), UINT64_C(0x00000000e6fcc0dc) }},
  {{ UINT64_C(0xf7d7e830852c58cf), UINT64_C(0x00000003ea330208), UINT64_C(0xd98c14b226757e26), UINT64_C(0x00000001edead5d3) }},
  {{ UINT64_C(0xb930086615496820), UINT64_C(0x00000000db3acd28), UINT64_C(0xb3a83caefd79a948), UINT64_C(0x00000001261faac0) }},
};

static const block_t Ri_6[] = {
  {{ UINT64_C(0xda9bcfc3d365319c), UINT64_C(0x0000000231a11c97), UINT64_C(0x5b5457e030274592), UINT64_C(0x0000000038b2ed84) }},
  {{ UINT64_C(0x345723a78db69ae7), UINT64_C(0x00000002c4faede5), UINT64_C(0x4682cedc34a1d259), UINT64_C(0x00000003b11c80bb) }},
  {{ UINT64_C(0x0948169ea5d5797e), UINT64_C(0x00000003335d32c4), UINT64_C(0x36bea2c5155fbb35), UINT64_C(0x00000000eb425287) }},
  {{ UINT64_C(0xd6b7cbd96f2b1529), UINT64_C(0x000000012fc5f1d4), UINT64_C(0xc90c22435c47a69b), UINT64_C(0x000000013497f677) }},
  {{ UINT64_C(0x99989899f71c1f4a), UINT64_C(0x0000000270a2b35b), UINT64_C(0x31d48618ad58c484), UINT64_C(0x000000028de1bb86) }},
  {{ UINT64_C(0x1304c80c921e86a9), UINT64_C(0x000000034831ee8b), UINT64_C(0x961579e2b07a38af), UINT64_C(0x0000000234809b9a) }},
  {{ UINT64_C(0xa168bdd179d6fd29), UINT64_C(0x00000002034fa79b), UINT64_C(0x4b558e72a657d8d4), UINT64_C(0x0000000372689ca1) }},
  {{ UINT64_C(0xe3b8a6887d6d1dc0), UINT64_C(0x00000002979d9265), UINT64_C(0x889483cf6f2d5b40), UINT64_C(0x00000003301a2961) }},
  {{ UINT64_C(0x37a582ac2dd8d87b), UINT64_C(0x000000022668d92c), UINT64_C(0xc948db383de0b157), UINT64_C(0x00000001f2974e2e) }},
  {{ UINT64_C(0x61aa8f045ed08041), UINT64_C(0x000000036d1c4abc), UINT64_C(0x2b0ed7e594f9fc77), UINT64_C(0x0000000172ea6c84) }},
  {{ UINT64_C(0xe51f179dc09da3de), UINT64_C(0x000000011b876f0a), UINT64_C(0x1c3ba59158d90725), UINT64_C(0x0000000261228e3f) }},
  {{ UINT64_C(0x12f40d7780bf2704), UINT64_C(0x00000000695036ca), UINT64_C(0xfcfc6956d37817f7), UINT64_C(0x000000027dcef116) }},
  {{ UINT64_C(0xfdd992a166a79b14), UINT64_C(0x00000000ace71609), UINT64_C(0x92cd84ef5dca6641), UINT64_C(0x0000000081c7eeea) }},
  {{ UINT64_C(0x42f2f3a937d3dac7), UINT64_C(0x000000013eb31b09), UINT64_C(0x5e03d67ac0f74e01), UINT64_C(0x00000001c04b539f) }},
  {{ UINT64_C(0xbaa8f35e2cf8e1b1), UINT64_C(0x0000000103be729b), UINT64_C(0xc9dd0b7b226ca9ed), UINT64_C(0x0000000002f8dbdb) }},
};

static const block_t Ri_7[] = {
  {{ UINT64_C(0x4651c1e0a6a825c8), UINT64_C(0x000000017c65ba2a), UINT64_C(0x6bd722280d364dc4), UINT64_C(0x00000002afdfc71a) }},
  {{ UINT64_C(0x953289fe7695ee79), UINT64_C(0x00000002b16374bd), UINT64_C(0x64262d39375a04fd), UINT64_C(0x00000002a5897e45) }},
  {{ UINT64_C(0x1237ac7dabce6f66), UINT64_C(0x000000027fbeb6a6), UINT64_C(0x0958a4c25d42ea30), UINT64_C(0x00000000c794eb46) }},
  {{ UINT64_C(0x2237bda4ccc9d22d), UINT64_C(0x00000001dad264d6), UINT64_C(0x91636c984af61a5f), UINT64_C(0x0000000042e23944) }},
  {{ UINT64_C(0xc02327adec655616), UINT64_C(0x00000000dcc8333f), UINT64_C(0x3cea14a45ada7c67), UINT64_C(0x00000003357a5a86) }},
  {{ UINT64_C(0x4f94f8a1f79a5dde), UINT64_C(0x00000003c2f41e77), UINT64_C(0x8261f715c45b50db), UINT64_C(0x00000001533f300a) }},
  {{ UINT64_C(0xaf5d000a807d1d11), UINT64_C(0x00000002ca98e722), UINT64_C(0x1e3bdec42d3b1abc), UINT64_C(0x000000002a6325df) }},
  {{ UINT64_C(0x7490f27a31c77056), UINT64_C(0x00000001b6519438), UINT64_C(0x1cc206c7b48eb12a), UINT64_C(0x0000000096461e1e) }},
  {{ UINT64_C(0xf2051eb3085f9262), UINT64_C(0x00000002379e758c), UINT64_C(0x618533360c999218), UINT64_C(0x00000001f40b3c40) }},
  {{ UINT64_C(0xdec1a12fec71de9d), UINT64_C(0x000000028f54166b), UINT64_C(0x30f6b2def54d9d5e), UINT64_C(0x00000001ed0741a2) }},
  {{ UINT64_C(0xa0dca60dfcc41329), UINT64_C(0x00000000e5367ba6), UINT64_C(0xac7c4d935ac683eb), UINT64_C(0x000000009303489e) }},
  {{ UINT64_C(0xd9408fdd31409603), UINT64_C(0x00000002ce17c2c0), UINT64_C(0x48e5332a75b625e6), UINT64_C(0x000000022fef29a7) }},
  {{ UINT64_C(0xda77bf0a1814e3fb), UINT64_C(0x000000013b84537b), UINT64_C(0xe0d910ca6c5e654e), UINT64_C(0x000000031b77bbb4) }},
  {{ UINT64_C(0x002362ddec11d869), UINT64_C(0x0000000029fb4a36), UINT64_C(0xc93bf79b22ea7211), UINT64_C(0x0000000201fb34d8) }},
  {{ UINT64_C(0xff76fa0c0dfe5557), UINT64_C(0x000000008611894e), UINT64_C(0xd15bb51baf5d8968), UINT64_C(0x000000020a7b15eb) }},
};

static const block_t Ri_8[] = {
  {{ UINT64_C(0x6fa1cbff6bff13ce), UINT64_C(0x000000023a358e9c), UINT64_C(0xba65f2f1ffd57840), UINT64_C(0x00000002cbf3f09c) }},
  {{ UINT64_C(0x7dfacc581397f9f7), UINT64_C(0x00000001487e6809), UINT64_C(0x9d61497a4ed1c4fb), UINT64_C(0x00000000a7688bac) }},
  {{ UINT64_C(0xfebf75869960ef47), UINT64_C(0x000000033bac4bfb), UINT64_C(0x24e109ec34994520), UINT64_C(0x00000001d28276f2) }},
  {{ UINT64_C(0x265ff18efb19b6e2), UINT64_C(0x0000000295b6b362), UINT64_C(0xa9425e04adcf97c5), UINT64_C(0x00000000697b6e38) }},
  {{ UINT64_C(0x0ccb19a0c5fc8194), UINT64_C(0x0000000372713e76), UINT64_C(0x5b625388adddb852), UINT64_C(0x00000001455ad64d) }},
  {{ UINT64_C(0x1851c387029b85a9), UINT64_C(0x00000003795d91dc), UINT64_C(0xd351756d6dc25b5b), UINT64_C(0x00000002710cdc61) }},
  {{ UINT64_C(0xbe4521df5a692c13), UINT64_C(0x0000000008edaf3f), UINT64_C(0xe02f34d42e34aeb9), UINT64_C(0x0000000101a475eb) }},
  {{ UINT64_C(0x672f0f16c28dbff8), UINT64_C(0x000000031bcf4c2d), UINT64_C(0xc4f982210b1e4b10), UINT64_C(0x0000000089125820) }},
  {{ UINT64_C(0xa5ae42ac951a108d), UINT64_C(0x00000001e3d29391), UINT64_C(0x0e817f22aa09b3ce), UINT64_C(0x0000000299e9b03e) }},
  {{ UINT64_C(0xd3f6504cdacacc13), UINT64_C(0x00000000ebd6252b), UINT64_C(0xebf18e94211a6d4d), UINT64_C(0x000000016e1e6368) }},
  {{ UINT64_C(0x0217b50dc91fd2ec), UINT64_C(0x0000000311e78c31), UINT64_C(0x6a660edcda63971d), UINT64_C(0x00000002f1bce17a) }},
  {{ UINT64_C(0xd9a105d7bb457c59), UINT64_C(0x00000001acc0ec21), UINT64_C(0x33a5191b8ef03493), UINT64_C(0x000000004894d756) }},
  {{ UINT64_C(0xdd100dc96b8117b3), UINT64_C(0x00000002e2a4d832), UINT64_C(0x705ec4d4154c0a05), UINT64_C(0x0000000061fe955d) }},
  {{ UINT64_C(0x3a412dcdc407e684), UINT64_C(0x00000002a67fb542), UINT64_C(0x76e108878b8168f5), UINT64_C(0x000000004c372dbd) }},
  {{ UINT64_C(0x17d643a8aab93679), UINT64_C(0x000000036e46af5d), UINT64_C(0x28c7b0da29da5553), UINT64_C(0x0000000170645409) }},
};

static const block_t Ri_9[] = {
  {{ UINT64_C(0xc6093ac4dfcb1b24), UINT64_C(0x000000000273a330), UINT64_C(0x391de2348c644ae3), UINT64_C(0x000000025171d913) }},
  {{ UINT64_C(0xea281f060b90c53e), UINT64_C(0x0000000145acbdcd), UINT64_C(0xde2ac48f22eef236), UINT64_C(0x000000025dee967d) }},
  {{ UINT64_C(0xcee11a8bd7ea50e8), UINT64_C(0x000000021f7b3495), UINT64_C(0x9a9888201c435089), UINT64_C(0x000000024284cacc) }},
  {{ UINT64_C(0xc05f5cc127db3a49), UINT64_C(0x00000001ab87faa3), UINT64_C(0x9baa6299224524bf), UINT64_C(0x0000000192ddad24) }},
  {{ UINT64_C(0x53980b8c68a07e35), UINT64_C(0x000000022e900af9), UINT64_C(0x1fe861c12c347972), UINT64_C(0x000000022e1719bd) }},
  {{ UINT64_C(0x1c59c10807177b6e), UINT64_C(0x00000001162f3331), UINT64_C(0xd6f0b2202dbf5283), UINT64_C(0x00000002148cfe27) }},
  {{ UINT64_C(0xe3f6c3e3ea9cf555), UINT64_C(0x00000003ece38b79), UINT64_C(0x52a414d3de18fa26), UINT64_C(0x00000003ff2d85aa) }},
  {{ UINT64_C(0x8b607bca74f4bc9d), UINT64_C(0x00000002bb4ddc77), UINT64_C(0xd026ad80b4deb45c), UINT64_C(0x00000002f7d92191) }},
  {{ UINT64_C(0x53a91cbb0c70c4d4), UINT64_C(0x00000002929a6732), UINT64_C(0x8e7cd01cb686a99c), UINT64_C(0x0000000357e93d28) }},
  {{ UINT64_C(0xd97caf7a5f4cf1f6), UINT64_C(0x00000003f9ea7a43), UINT64_C(0x1dbb6a4e61e8e2bc), UINT64_C(0x000000036d1e6a67) }},
  {{ UINT64_C(0x99a40aca8aaf3a1d), UINT64_C(0x00000002ea529b32), UINT64_C(0xd0c350622c819ff5), UINT64_C(0x00000003fad8c2dc) }},
  {{ UINT64_C(0x9208c482d5941b6e), UINT64_C(0x00000002efd7690f), UINT64_C(0x1994a0183b7b1b37), UINT64_C(0x00000003b4ee5516) }},
  {{ UINT64_C(0x7298a6061ef50f7a), UINT64_C(0x0000000205f93118), UINT64_C(0x0a6781b1895fadaa), UINT64_C(0x0000000214a13efb) }},
  {{ UINT64_C(0xc7b05385ef2e2dba), UINT64_C(0x00000001c8a71a87), UINT64_C(0xbd1d6d9c41b17914), UINT64_C(0x000000005eccbef2) }},
  {{ UINT64_C(0xbe9e586b5e58386d), UINT64_C(0x00000000cdad5cf1), UINT64_C(0x5b0c9d7240d5701e), UINT64_C(0x00000002616d4394) }},
};

static const block_t Ri_10[] = {
  {{ UINT64_C(0xb7f91fdf353eba68), UINT64_C(0x000000013da45ba0), UINT64_C(0x81d2434514ed2434), UINT64_C(0x000000004fa9473e) }},
  {{ UINT64_C(0x0e316aae96cc1482), UINT64_C(0x00000001b845f48f), UINT64_C(0x980c9b89f093d8c7), UINT64_C(0x000000002a02b93f) }},
  {{ UINT64_C(0x13f539e959d20c83), UINT64_C(0x00000003bbe5fd13), UINT64_C(0x6fd551bd9c05a7c5), UINT64_C(0x0000000278566d05) }},
  {{ UINT64_C(0x837925ca8408ae69), UINT64_C(0x000000007fb415ec), UINT64_C(0x26ecbf47a78caa20), UINT64_C(0x00000002da23e7d0) }},
  {{ UINT64_C(0xe31ee530b5f3db1a), UINT64_C(0x0000000110000c80), UINT64_C(0x460c3b7ae100b438), UINT64_C(0x00000002f1c9f6be) }},
  {{ UINT64_C(0x13900fc5eacda9de), UINT64_C(0x000000010f9c6ee8), UINT64_C(0x5a60ed717c925c33), UINT64_C(0x00000000f664912b) }},
  {{ UINT64_C(0xb804bf1597b66733), UINT64_C(0x0000000223f24e21), UINT64_C(0xec77851d85d2d0ac), UINT64_C(0x000000013e855413) }},
  {{ UINT64_C(0x5ca1de7f41ee3ff2), UINT64_C(0x00000001ecf87abb), UINT64_C(0xebd1140691af84ac), UINT64_C(0x000000023d8c83ce) }},
  {{ UINT64_C(0x822b58a1e2104c14), UINT64_C(0x000000017aa53428), UINT64_C(0xb9dafbb2476b2168), UINT64_C(0x00000001cf7d9170) }},
  {{ UINT64_C(0x5db87b4206930700), UINT64_C(0x00000003ff8be3b9), UINT64_C(0x2453fc45f739d405), UINT64_C(0x00000001de0ce934) }},
  {{ UINT64_C(0x25655e698e4be319), UINT64_C(0x0000000344455eaf), UINT64_C(0xf332a74d44d5354d), UINT64_C(0x00000002b63f56ef) }},
  {{ UINT64_C(0x5701d60d456707fc), UINT64_C(0x000000025365bd06), UINT64_C(0x1d8acf97502a189f), UINT64_C(0x00000003086797f4) }},
  {{ UINT64_C(0xe0210d383bcce502), UINT64_C(0x0000000242934f6b), UINT64_C(0xf2f05044f279070d), UINT64_C(0x000000019bd0d787) }},
  {{ UINT64_C(0x958426103275e8d7), UINT64_C(0x0000000072e2142d), UINT64_C(0x8530c6f03ad1bfd7), UINT64_C(0x0000000278626e01) }},
  {{ UINT64_C(0xbffb6b6c8d476f28), UINT64_C(0x00000003e4e36dff), UINT64_C(0x4101e3af06835d7c), UINT64_C(0x00000003bcec91d7) }},
};

static const block_t Ri_11[] = {
  {{ UINT64_C(0x8f9eda1b4d643ac6), UINT64_C(0x000000009731f032), UINT64_C(0xb22d1d7d70ca3ecd), UINT64_C(0x000000000876b4f7) }},
  {{ UINT64_C(0x8c1638a2a4d19aab), UINT64_C(0x00000000eb611969), UINT64_C(0xaa8e94d39936d283), UINT64_C(0x000000036224b714) }},
  {{ UINT64_C(0x1ac5805c38528f41), UINT64_C(0x0000000277aeffa3), UINT64_C(0x70ba99b2f92a33a6), UINT64_C(0x00000000eb7b9b01) }},
  {{ UINT64_C(0xff713ec9974682fa), UINT64_C(0x000000035a7550a9), UINT64_C(0xef9fa770951e9590), UINT64_C(0x00000001ba9fe86c) }},
  {{ UINT64_C(0x8c065b17b8d32e42), UINT64_C(0x000000009b06e4a7), UINT64_C(0xd5268897d0394169), UINT64_C(0x00000001f80a198a) }},
  {{ UINT64_C(0x80e2eddddc21acd7), UINT64_C(0x000000006eda7e33), UINT64_C(0x3932054ce9ad3f5c), UINT64_C(0x00000001488c38b2) }},
  {{ UINT64_C(0x1d50aa92a049967b), UINT64_C(0x000000029f2fc50e), UINT64_C(0x2d9f6b11026d37f1), UINT64_C(0x0000000357509bc1) }},
  {{ UINT64_C(0xfb140e5ca8d12c3b), UINT64_C(0x000000034dd6a8db), UINT64_C(0x2a83cb608bc7adce), UINT64_C(0x00000000d403e9b8) }},
  {{ UINT64_C(0xf5dafd31a110fd1d), UINT64_C(0x000000010b719913), UINT64_C(0x29738c70341379f7), UINT64_C(0x00000002ebf6587f) }},
  {{ UINT64_C(0x9543a06136614c88), UINT64_C(0x000000015229cae5), UINT64_C(0x9b7f03f72b74dc90), UINT64_C(0x000000036fd10732) }},
  {{ UINT64_C(0x8511e2b0ed9f12f6), UINT64_C(0x00000003c6b46125), UINT64_C(0x8f4fdeec2b31713b), UINT64_C(0x00000003ce964cda) }},
  {{ UINT64_C(0x7ad79778f7810a61), UINT64_C(0x00000000ee1154e7), UINT64_C(0xe69e252df895cc77), UINT64_C(0x0000000171869b59) }},
  {{ UINT64_C(0x6987ad6375844253), UINT64_C(0x000000028c821242), UINT64_C(0x4a066a91683b7b24), UINT64_C(0x000000006fc88236) }},
  {{ UINT64_C(0x0c3d835592622e3e), UINT64_C(0x00000002441759e9), UINT64_C(0x36afb1db71e795ef), UINT64_C(0x00000003909e2c27) }},
  {{ UINT64_C(0x3c8bb6663299fd18), UINT64_C(0x00000003402de8ff), UINT64_C(0x6b17fbec1933ecec), UINT64_C(0x00000002bf919258) }},
};

static const block_t Ri_12[] = {
  {{ UINT64_C(0x1b66a5099873f856), UINT64_C(0x00000000efcad672), UINT64_C(0xeb18e24c6ab3da02), UINT64_C(0x00000002e44c7ba5) }},
  {{ UINT64_C(0x181220a4929932b8), UINT64_C(0x00000000035f9aa2), UINT64_C(0x1ba02daa5ad9c5d8), UINT64_C(0x00000000092d558e) }},
  {{ UINT64_C(0x88af95d48190abf4), UINT64_C(0x00000000386cd55c), UINT64_C(0xd00d631a9a49d363), UINT64_C(0x00000002b8a1a1e0) }},
  {{ UINT64_C(0x5c972c4501ba471a), UINT64_C(0x000000033cace8a7), UINT64_C(0x06a2b974b30f2f59), UINT64_C(0x00000000bb4ca14f) }},
  {{ UINT64_C(0xf20ab0951705a414), UINT64_C(0x00000001a257f328), UINT64_C(0xd54e575456bbade2), UINT64_C(0x00000003313b51a1) }},
  {{ UINT64_C(0x4fc90086a96772f4), UINT64_C(0x000000021bca9104), UINT64_C(0x77e5435f28e78db8), UINT64_C(0x000000017821c676) }},
  {{ UINT64_C(0x63a8539850330266), UINT64_C(0x000000025e34a56b), UINT64_C(0xf6b847d61bc03a76), UINT64_C(0x000000004dc22502) }},
  {{ UINT64_C(0x472c8a08b88c0ae2), UINT64_C(0x00000001e4667e1e), UINT64_C(0x086c014f03954a97), UINT64_C(0x00000000276487b0) }},
  {{ UINT64_C(0xa559083177eae1bc), UINT64_C(0x000000039a635f32), UINT64_C(0xc6b2d41139f22ecc), UINT64_C(0x00000003a6ba3ddc) }},
  {{ UINT64_C(0x5bd75f548e3e1ad6), UINT64_C(0x00000003a30746de), UINT64_C(0x2b7b09879ca78144), UINT64_C(0x00000002288ab415) }},
  {{ UINT64_C(0x39d984b82a203e66), UINT64_C(0x000000003d3b1106), UINT64_C(0x80986f2d07d0bdc6), UINT64_C(0x0000000093e3b28a) }},
  {{ UINT64_C(0x554d024c992252f3), UINT64_C(0x00000003e9a7fa21), UINT64_C(0x0d3c2ee18776a970), UINT64_C(0x0000000298244cd7) }},
  {{ UINT64_C(0x480d0426f89e16c1), UINT64_C(0x000000011203b395), UINT64_C(0x3cbe3025135fc1ad), UINT64_C(0x000000017a3cf677) }},
  {{ UINT64_C(0x142f2b2125038f01), UINT64_C(0x0000000261f36f79), UINT64_C(0x2eb5fe73ca3fdce4), UINT64_C(0x00000000f6770087) }},
  {{ UINT64_C(0x415a608291da479c), UINT64_C(0x00000000f683395d), UINT64_C(0xe323a8fb2ead9bb0), UINT64_C(0x00000001caef552c) }},
};

static const block_t Ri_13[] = {
  {{ UINT64_C(0xa975fe46b67285fc), UINT64_C(0x00000002f4f2aad9), UINT64_C(0xb4c2797dd69b39f3), UINT64_C(0x000000016fdb1676) }},
  {{ UINT64_C(0xd5db82ceca22c2d8), UINT64_C(0x0000000315e30980), UINT64_C(0x9132dd05c28d5283), UINT64_C(0x000000033c66f780) }},
  {{ UINT64_C(0x6a174dd4f5ba0a87), UINT64_C(0x000000008ebc02ab), UINT64_C(0xe3262dd1b83cdaf5), UINT64_C(0x000000012eb45172) }},
  {{ UINT64_C(0x884fd230a757afbd), UINT64_C(0x000000018f1841a2), UINT64_C(0x7579437c4ad75fb0), UINT64_C(0x000000013284083a) }},
  {{ UINT64_C(0x9d179103542b1b35), UINT64_C(0x000000036cc48cf4), UINT64_C(0x2ea9f54f00335383), UINT64_C(0x00000000e832fe22) }},
  {{ UINT64_C(0x12a925a12e8e7386), UINT64_C(0x00000000f1019a49), UINT64_C(0xebe334ecb96a8318), UINT64_C(0x00000001835c0172) }},
  {{ UINT64_C(0x12cdd0bb4d56d594), UINT64_C(0x000000029bec2205), UINT64_C(0xcd553d7f4847b449), UINT64_C(0x000000008c3496ea) }},
  {{ UINT64_C(0xe3224c3b6b3c19e6), UINT64_C(0x000000039cf2c259), UINT64_C(0xe41b390b79bd2fe0), UINT64_C(0x0000000033be86fa) }},
  {{ UINT64_C(0x4588626d53e6f3f6), UINT64_C(0x000000032e204377), UINT64_C(0x046e77c2f6b98e72), UINT64_C(0x000000039046895e) }},
  {{ UINT64_C(0xfdac400a0ee3fc2d), UINT64_C(0x000000037bec18dd), UINT64_C(0x5b1520409195b095), UINT64_C(0x00000001d68c4466) }},
  {{ UINT64_C(0x47109c4d12a7174c), UINT64_C(0x00000001715e74ab), UINT64_C(0xeac21eba54cb9010), UINT64_C(0x000000011d851d61) }},
  {{ UINT64_C(0x91606729538f601c), UINT64_C(0x00000000a9b5dbae), UINT64_C(0xaf97fc78d9b63c70), UINT64_C(0x00000000f81b6aa0) }},
  {{ UINT64_C(0xfa555ccfceee3d6f), UINT64_C(0x00000001da57eba8), UINT64_C(0xe1bb8c06073a617e), UINT64_C(0x00000000793bb27f) }},
  {{ UINT64_C(0x9ac645d3e6ea34da), UINT64_C(0x000000033c2446f6), UINT64_C(0xf94eb02d428b9cad), UINT64_C(0x00000000a2d2cc75) }},
  {{ UINT64_C(0x003cf405b1026f15), UINT64_C(0x0000000061d3cab4), UINT64_C(0xd325ab2fd2399619), UINT64_C(0x000000019c209bce) }},
};

static const block_t Ri_14[] = {
  {{ UINT64_C(0x3a427e2fa926f709), UINT64_C(0x00000000bd4f765f), UINT64_C(0xbd5380a17f99c1b7), UINT64_C(0x000000009b476eae) }},
  {{ UINT64_C(0xffdf0dd9c7d5044d), UINT64_C(0x000000016c52aa72), UINT64_C(0x40f5e3d14f3b254c), UINT64_C(0x00000000e2324c5d) }},
  {{ UINT64_C(0xcd96ccfa3a96ee6a), UINT64_C(0x0000000089731e51), UINT64_C(0x8b65c3e241f3c811), UINT64_C(0x000000039ee53dd0) }},
  {{ UINT64_C(0x736604cc08c2e51f), UINT64_C(0x00000000f93bf0c7), UINT64_C(0xd2c985251d6b4117), UINT64_C(0x00000000148b3791) }},
  {{ UINT64_C(0x1be111ea3b1ba4e4), UINT64_C(0x000000004570cc5b), UINT64_C(0xfc08b28a65fb3305), UINT64_C(0x00000003cd6e6cf2) }},
  {{ UINT64_C(0x17812c9a5534cc6d), UINT64_C(0x00000002cb0665dd), UINT64_C(0x67fd5e7b9a4980e6), UINT64_C(0x00000003428a8d17) }},
  {{ UINT64_C(0xbde303959f99f3e8), UINT64_C(0x0000000087722db8), UINT64_C(0x0109eaa95dcdafb4), UINT64_C(0x0000000219369ef5) }},
  {{ UINT64_C(0x1e05b1db3505f06a), UINT64_C(0x000000035272fc54), UINT64_C(0x31d556d41953e2ca), UINT64_C(0x0000000364573157) }},
  {{ UINT64_C(0x14d41f053b2fa8b6), UINT64_C(0x00000002e15476bb), UINT64_C(0x57fca20b66d7c36c), UINT64_C(0x00000000c1d12227) }},
  {{ UINT64_C(0x962e0e93499548f6), UINT64_C(0x000000017f73fad7), UINT64_C(0x89a3b941c1b4c844), UINT64_C(0x0000000065646ede) }},
  {{ UINT64_C(0xdc538496d9844f85), UINT64_C(0x000000019bedf6a0), UINT64_C(0x712bcc3a2f802457), UINT64_C(0x00000002eadda7d5) }},
  {{ UINT64_C(0xba5736dd888efbf3), UINT64_C(0x000000030ea08520), UINT64_C(0x333532f9e508d133), UINT64_C(0x000000022cfb2508) }},
  {{ UINT64_C(0x1dd600a44d451456), UINT64_C(0x000000015682d01b), UINT64_C(0x28b6ae330784c019), UINT64_C(0x00000000da1281dc) }},
  {{ UINT64_C(0x9c42f0fc741232bb), UINT64_C(0x00000003f0f3d12d), UINT64_C(0x96cfc088694819bb), UINT64_C(0x000000016b80fa43) }},
  {{ UINT64_C(0xafd195a133a7fa32), UINT64_C(0x00000001e96ff351), UINT64_C(0x40ed5f6ce841769a), UINT64_C(0x00000000ff4fe870) }},
};

static const block_t Ri_15[] = {
  {{ UINT64_C(0xa53a39c72f508914), UINT64_C(0x0000000185d9de7e), UINT64_C(0x4e019eb7fed46550), UINT64_C(0x00000000785d13a2) }},
  {{ UINT64_C(0x895992a3e6cca3a8), UINT64_C(0x00000000239fc0cb), UINT64_C(0x19b86e46d88e9d15), UINT64_C(0x0000000012118744) }},
  {{ UINT64_C(0xd70c4358a4b09690), UINT64_C(0x000000013656017e), UINT64_C(0x18995fb924d6bd90), UINT64_C(0x0000000301a04f45) }},
  {{ UINT64_C(0x468f72a5d9799eae), UINT64_C(0x000000023fb7062c), UINT64_C(0xf61b28800f485000), UINT64_C(0x000000039704690a) }},
  {{ UINT64_C(0x3f36819b580f0595), UINT64_C(0x000000027ede9e54), UINT64_C(0x7a91baa6305bc85e), UINT64_C(0x00000003cc2c83e6) }},
  {{ UINT64_C(0x2ff9923437f064bd), UINT64_C(0x0000000351d178fc), UINT64_C(0x906d187c4c8f93b3), UINT64_C(0x0000000240d0ab98) }},
  {{ UINT64_C(0x7851e3ef540e6103), UINT64_C(0x00000002ac5252db), UINT64_C(0x183769e575fd473b), UINT64_C(0x000000009d6e3f47) }},
  {{ UINT64_C(0x36eb664feeb1608c), UINT64_C(0x00000003f0db5c71), UINT64_C(0x334fe90d297ae1ba), UINT64_C(0x00000000e02178f6) }},
  {{ UINT64_C(0x64b29a8b3177b530), UINT64_C(0x00000001bd40638f), UINT64_C(0x4b2f0d4684a2624e), UINT64_C(0x000000016c54f274) }},
  {{ UINT64_C(0x823743a919770c97), UINT64_C(0x00000001968138be), UINT64_C(0x50348598eb49a754), UINT64_C(0x0000000012504831) }},
  {{ UINT64_C(0xd758f8e78f5a66ed), UINT64_C(0x0000000028fe49c9), UINT64_C(0x05c3e7a8e417b954), UINT64_C(0x00000001c8a38d97) }},
  {{ UINT64_C(0x6d64b8477abc3a20), UINT64_C(0x00000001903cbd7b), UINT64_C(0x4015084163bcdb76), UINT64_C(0x000000013612ac7e) }},
  {{ UINT64_C(0x84bb44404c7f9a1e), UINT64_C(0x00000002055e719f), UINT64_C(0x5cc842a5a85551cb), UINT64_C(0x00000002c9bc7d59) }},
  {{ UINT64_C(0x0fba85fa026140a8), UINT64_C(0x000000009d442f5b), UINT64_C(0xdadeb094b35097df), UINT64_C(0x00000000afd908fa) }},
  {{ UINT64_C(0x21c803832ab6940b), UINT64_C(0x00000001464c6a34), UINT64_C(0x3e964702409a743d), UINT64_C(0x000000000a1c7e42) }},
};

static const block_t Ri_16[] = {
  {{ UINT64_C(0xbb37324ec547219b), UINT64_C(0x00000001910ae755), UINT64_C(0xcbe31b8ce799efc1), UINT64_C(0x00000000ad5e4c28) }},
  {{ UINT64_C(0x463fd2a745f4ead4), UINT64_C(0x00000003870d8e7c), UINT64_C(0x5a740203709bbf11), UINT64_C(0x00000002647d24fc) }},
  {{ UINT64_C(0x3cd2de8af3cfbf05), UINT64_C(0x00000001b8efa8b7), UINT64_C(0x65a63bd620cbdc75), UINT64_C(0x0000000060b3cced) }},
  {{ UINT64_C(0x9223449a69230742), UINT64_C(0x00000003b4fe39d0), UINT64_C(0x6a25b84bea1fe93d), UINT64_C(0x000000037b037141) }},
  {{ UINT64_C(0x4be33a4d787b2028), UINT64_C(0x000000009d521d04), UINT64_C(0xebc74a91c542a976), UINT64_C(0x00000000cbf97ba8) }},
  {{ UINT64_C(0x63a92ee3e28beadd), UINT64_C(0x0000000065f00afc), UINT64_C(0x5f5020f2e5c7247c), UINT64_C(0x00000000a0aae79e) }},
  {{ UINT64_C(0x2d53d5c8074ccfd5), UINT64_C(0x00000003bbd120a0), UINT64_C(0x3fab068589d14f8d), UINT64_C(0x0000000254174174) }},
  {{ UINT64_C(0x9c669823cc1f16b2), UINT64_C(0x000000018fbdd283), UINT64_C(0xc02ecb7ea6adc00e), UINT64_C(0x000000034e714f05) }},
  {{ UINT64_C(0x28aa92d9d62bc6fe), UINT64_C(0x000000038d21c98b), UINT64_C(0xe58e7d60fca5b378), UINT64_C(0x00000000a129a35a) }},
  {{ UINT64_C(0x75c49fa2938d6962), UINT64_C(0x0000000100f87628), UINT64_C(0x93f9ef38f0f5a88e), UINT64_C(0x000000007a405311) }},
  {{ UINT64_C(0xaad0ed3098e71f64), UINT64_C(0x000000037b5e67a2), UINT64_C(0x783326ed0f6f5331), UINT64_C(0x0000000051661a3c) }},
  {{ UINT64_C(0x2e49f9639abf8d31), UINT64_C(0x000000027d8fca80), UINT64_C(0xfcb3e973dd917223), UINT64_C(0x0000000045634399) }},
  {{ UINT64_C(0x47864660cf4a668a), UINT64_C(0x00000002cfc2ff31), UINT64_C(0x2aea6ebd69819a73), UINT64_C(0x00000001314f07e8) }},
  {{ UINT64_C(0xb6fbcce660a02d12), UINT64_C(0x0000000258f55d7a), UINT64_C(0x2eb4ac831c511b5f), UINT64_C(0x000000005eb4fc90) }},
  {{ UINT64_C(0x91714a02066cb4ea), UINT64_C(0x00000003e786ce39), UINT64_C(0x9b5176c4411c4b3e), UINT64_C(0x00000000fbfcdfad) }},
};

static const block_t Ri_17[] = {
  {{ UINT64_C(0x489126e1508eeb4d), UINT64_C(0x0000000139a333ac), UINT64_C(0x55958006707897a5), UINT64_C(0x00000002bcbfc6d7) }},
  {{ UINT64_C(0xf87d22887c4ece83), UINT64_C(0x000000006b4e5202), UINT64_C(0x1d2f282c82013e51), UINT64_C(0x00000003cbbf47a1) }},
  {{ UINT64_C(0x0be424a0f8019446), UINT64_C(0x00000002eba51807), UINT64_C(0xed75c1c624293102), UINT64_C(0x00000002b84bc549) }},
  {{ UINT64_C(0x9312230876a9952b), UINT64_C(0x0000000159a46e39), UINT64_C(0x2639d756ee2ba10d), UINT64_C(0x00000002708dd055) }},
  {{ UINT64_C(0x126e64b4ffdd3798), UINT64_C(0x000000019e317bc3), UINT64_C(0x6fcbcf0833693761), UINT64_C(0x000000025fe504f8) }},
  {{ UINT64_C(0x05412fa72efdeed9), UINT64_C(0x00000003f38d9fc8), UINT64_C(0x10f4e5aed9b75469), UINT64_C(0x00000000e3d6c0fe) }},
  {{ UINT64_C(0xe25007ea4a91040d), UINT64_C(0x00000001745e7461), UINT64_C(0xdc4f7561eeac3573), UINT64_C(0x00000000412ea76f) }},
  {{ UINT64_C(0xbc646ed7c7ee515d), UINT64_C(0x000000018e1ad0ec), UINT64_C(0xd55d956e61bcedfe), UINT64_C(0x000000013cbfcbae) }},
  {{ UINT64_C(0x34d60d6e8c9d2789), UINT64_C(0x000000039017494a), UINT64_C(0x678fcc2152cd3b67), UINT64_C(0x000000023bff47aa) }},
  {{ UINT64_C(0x02aaa268fbf8c4e0), UINT64_C(0x000000028cf043ad), UINT64_C(0xa9a596b610d1bea8), UINT64_C(0x000000007feed078) }},
  {{ UINT64_C(0x34d4579aafdffb0a), UINT64_C(0x000000035c844a7f), UINT64_C(0xa5587f0990611e7a), UINT64_C(0x0000000048787f92) }},
  {{ UINT64_C(0xf01f354f4d5d551f), UINT64_C(0x00000003dd4a5adb), UINT64_C(0x55d29c9cc80fec48), UINT64_C(0x000000019ec96f49) }},
  {{ UINT64_C(0x6dd31b552eb3d172), UINT64_C(0x000000022d03388b), UINT64_C(0x97f2a5fd3e24c38c), UINT64_C(0x00000002696064b2) }},
  {{ UINT64_C(0xf51a3370c7785a12), UINT64_C(0x00000000ca3f1a1e), UINT64_C(0x7d4a634b7c62eeaa), UINT64_C(0x00000001ed7eaf10) }},
  {{ UINT64_C(0x6f54b8fcd4359b22), UINT64_C(0x000000029ac1bcf7), UINT64_C(0xbc51e5464f3c0efd), UINT64_C(0x0000000217ce510a) }},
};

static const block_t Ri_18[] = {
  {{ UINT64_C(0x8e095827ac186f40), UINT64_C(0x00000000206f47f3), UINT64_C(0xf699550bfae723ed), UINT64_C(0x000000003509838f) }},
  {{ UINT64_C(0x908a0e172e85f853), UINT64_C(0x000000002454f53b), UINT64_C(0x25931e06c15c99ea), UINT64_C(0x00000003a3dbd7c0) }},
  {{ UINT64_C(0xdfd80d28220a8d1c), UINT64_C(0x0000000108c5ce10), UINT64_C(0x676fdd037c80511b), UINT64_C(0x00000001376f78fe) }},
  {{ UINT64_C(0xf4d72254479be09a), UINT64_C(0x00000003449feb72), UINT64_C(0x5df30c26bd9c6142), UINT64_C(0x00000001c6216e42) }},
  {{ UINT64_C(0x8278963362356626), UINT64_C(0x000000015f9ce871), UINT64_C(0x60b3eb88850ab6f7), UINT64_C(0x0000000289e6e186) }},
  {{ UINT64_C(0x95272b172d4111ed), UINT64_C(0x00000002e209fd52), UINT64_C(0x62b9c8c794dc893f), UINT64_C(0x000000023f2891d4) }},
  {{ UINT64_C(0x0ec663153f289f82), UINT64_C(0x00000000f0a2a30d), UINT64_C(0x1bb902be008e028d), UINT64_C(0x00000000e5eff608) }},
  {{ UINT64_C(0xf455ebb4de6ffe35), UINT64_C(0x00000000edd12935), UINT64_C(0x1f71db9a903703b4), UINT64_C(0x0000000124e88820) }},
  {{ UINT64_C(0xde4656b54ffadf7c), UINT64_C(0x000000020c7833ef), UINT64_C(0xcf6cfce82ec9cb52), UINT64_C(0x000000030e44a4fb) }},
  {{ UINT64_C(0xfc1d062a77e46f4a), UINT64_C(0x00000003a0d11e30), UINT64_C(0x098ec83e556fb5fd), UINT64_C(0x00000001ddae46a5) }},
  {{ UINT64_C(0x77d9debe650aa1b2), UINT64_C(0x00000002ac3bc0c1), UINT64_C(0x8d700429268766f0), UINT64_C(0x000000037e5b441a) }},
  {{ UINT64_C(0x84f508aef590697c), UINT64_C(0x0000000167ae1d94), UINT64_C(0xf82da87f0aeadda0), UINT64_C(0x00000001a2a32d8c) }},
  {{ UINT64_C(0xc7c45f0a2ea44a2c), UINT64_C(0x00000003d41affcf), UINT64_C(0x7992165562b101e7), UINT64_C(0x00000000df2f97fb) }},
  {{ UINT64_C(0x24d4f51608fd1a02), UINT64_C(0x00000002e6ac9df4), UINT64_C(0xd0f5c8b1f140423d), UINT64_C(0x00000000e3fb2d64) }},
  {{ UINT64_C(0xd1c81d521c125c81), UINT64_C(0x000000021ff6a7ff), UINT64_C(0x601ff085df5bea75), UINT64_C(0x00000003ab96995d) }},
};


static const lowmc_partial_round_t rounds[20] = {
  {
    Zi_0, Ri_0, UINT64_C(0xffffffda40000000),
  },
  {
    Zi_1, Ri_1, UINT64_C(0xffffffe700000000),
  },
  {
    Zi_2, Ri_2, UINT64_C(0xfffffffa00000000),
  },
  {
    Zi_3, Ri_3, UINT64_C(0xfffffff880000000),
  },
  {
    Zi_4, Ri_4, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_5, Ri_5, UINT64_C(0xffffffdc40000000),
  },
  {
    Zi_6, Ri_6, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_7, Ri_7, UINT64_C(0xfffffffa00000000),
  },
  {
    Zi_8, Ri_8, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_9, Ri_9, UINT64_C(0xfffffff840000000),
  },
  {
    Zi_10, Ri_10, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_11, Ri_11, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_12, Ri_12, UINT64_C(0xfffffffa00000000),
  },
  {
    Zi_13, Ri_13, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_14, Ri_14, UINT64_C(0xfffffffa00000000),
  },
  {
    Zi_15, Ri_15, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_16, Ri_16, UINT64_C(0xfffffffa00000000),
  },
  {
    Zi_17, Ri_17, UINT64_C(0xfffffffc00000000),
  },
  {
    Zi_18, Ri_18, UINT64_C(0xffffffe580000000),
  },
  {
    NULL, NULL, 0,
  },
};

const lowmc_partial_t lowmc_128_128_20 = {
  precomputed_round_key_matrix_linear_part,
  Z_r,
  rounds,
  precomputed_round_key_matrix_non_linear_part,
  precomputed_constant_linear_part,
  precomputed_constant_non_linear_part,
};

