# - Try to find m4ri
# Once done this will define
#  M4RI_FOUND - System has m4ri
#  M4RI::m4ri - imported library

find_package(PkgConfig)
pkg_check_modules(PC_M4RI QUIET m4ri)
set(M4RI_VERSION_STRING ${PC_M4RI_VERSION})

find_path(M4RI_INCLUDE_DIR m4ri.h
          HINTS ${PC_LIBM4RI_INCLUDEDIR} ${PC_M4RI_INCLUDE_DIRS}
          PATH_SUFFIXES m4ri)

find_library(M4RI_LIBRARY NAMES m4ri libm4ri
             HINTS ${PC_M4RI_LIBDIR} ${PC_M4RI_LIBRARY_DIRS})

include(FindPackageHandleStandardArgs)
# handle the QUIETLY and REQUIRED arguments and set M4RI_FOUND to TRUE
# if all listed variables are TRUE
find_package_handle_standard_args(m4ri
                                  FOUND_VAR M4RI_FOUND
                                  REQUIRED_VARS M4RI_LIBRARY M4RI_INCLUDE_DIR
                                  VERSION_VAR M4RI_VERSION_STRING)

mark_as_advanced(M4RI_INCLUDE_DIR M4RI_LIBRARY M4RI_VERSION_STRING)

if(M4RI_FOUND AND NOT TARGET M4RI::m4ri)
  add_library(M4RI::m4ri UNKNOWN IMPORTED)
  set_target_properties(M4RI::m4ri PROPERTIES
    IMPORTED_LOCATION "${M4RI_LIBRARY}"
    # INTERFACE_COMPILE_DEFINITIONS "${PC_M4RI_CFLAGS_OTHER}"
    INTERFACE_INCLUDE_DIRECTORIES "${M4RI_INCLUDE_DIR}")
endif()
