//! Peripheral access API for PIC32MX2xx microcontrollers
//! (generated using [svd2rust](https://github.com/rust-embedded/svd2rust)
//! version svd2rust 0.20.0 (89b54e8 2022-01-16))
//!
//! You can find an overview of the API here:
//! [svd2rust/#peripheral-api](https://docs.rs/svd2rust/0.19.0/svd2rust/#peripheral-api)
//!

#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]

mod generic;
pub use self::generic::*;

#[cfg(feature = "pic32mx1xxfxxxb")]
pub mod pic32mx1xxfxxxb;

#[cfg(feature = "pic32mx1xxfxxxc")]
pub mod pic32mx1xxfxxxc;

#[cfg(feature = "pic32mx1xxfxxxd")]
pub mod pic32mx1xxfxxxd;

#[cfg(feature = "pic32mx2xxfxxxb")]
pub mod pic32mx2xxfxxxb;

#[cfg(feature = "pic32mx2xxfxxxc")]
pub mod pic32mx2xxfxxxc;

#[cfg(feature = "pic32mx2xxfxxxd")]
pub mod pic32mx2xxfxxxd;

#[cfg(feature = "pic32mx1x4fxxxb")]
pub mod pic32mx1x4fxxxb;

#[cfg(feature = "pic32mx1x4fxxxd")]
pub mod pic32mx1x4fxxxd;

#[cfg(feature = "pic32mx2x4fxxxb")]
pub mod pic32mx2x4fxxxb;

#[cfg(feature = "pic32mx2x4fxxxd")]
pub mod pic32mx2x4fxxxd;
