#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "0 - CORE_TIMER"]
    CORE_TIMER = 0,
    #[doc = "1 - CORE_SOFTWARE_0"]
    CORE_SOFTWARE_0 = 1,
    #[doc = "2 - CORE_SOFTWARE_1"]
    CORE_SOFTWARE_1 = 2,
    #[doc = "3 - EXTERNAL_0"]
    EXTERNAL_0 = 3,
    #[doc = "4 - TIMER_1"]
    TIMER_1 = 4,
    #[doc = "5 - INPUT_CAPTURE_1"]
    INPUT_CAPTURE_1 = 5,
    #[doc = "6 - OUTPUT_COMPARE_1"]
    OUTPUT_COMPARE_1 = 6,
    #[doc = "7 - EXTERNAL_1"]
    EXTERNAL_1 = 7,
    #[doc = "8 - TIMER_2"]
    TIMER_2 = 8,
    #[doc = "9 - INPUT_CAPTURE_2"]
    INPUT_CAPTURE_2 = 9,
    #[doc = "10 - OUTPUT_COMPARE_2"]
    OUTPUT_COMPARE_2 = 10,
    #[doc = "11 - EXTERNAL_2"]
    EXTERNAL_2 = 11,
    #[doc = "12 - TIMER_3"]
    TIMER_3 = 12,
    #[doc = "13 - INPUT_CAPTURE_3"]
    INPUT_CAPTURE_3 = 13,
    #[doc = "14 - OUTPUT_COMPARE_3"]
    OUTPUT_COMPARE_3 = 14,
    #[doc = "15 - EXTERNAL_3"]
    EXTERNAL_3 = 15,
    #[doc = "16 - TIMER_4"]
    TIMER_4 = 16,
    #[doc = "17 - INPUT_CAPTURE_4"]
    INPUT_CAPTURE_4 = 17,
    #[doc = "18 - OUTPUT_COMPARE_4"]
    OUTPUT_COMPARE_4 = 18,
    #[doc = "19 - EXTERNAL_4"]
    EXTERNAL_4 = 19,
    #[doc = "20 - TIMER_5"]
    TIMER_5 = 20,
    #[doc = "21 - INPUT_CAPTURE_5"]
    INPUT_CAPTURE_5 = 21,
    #[doc = "22 - OUTPUT_COMPARE_5"]
    OUTPUT_COMPARE_5 = 22,
    #[doc = "23 - ADC"]
    ADC = 23,
    #[doc = "24 - FAIL_SAFE_MONITOR"]
    FAIL_SAFE_MONITOR = 24,
    #[doc = "25 - RTCC"]
    RTCC = 25,
    #[doc = "26 - FCE"]
    FCE = 26,
    #[doc = "27 - COMPARATOR_1"]
    COMPARATOR_1 = 27,
    #[doc = "28 - COMPARATOR_2"]
    COMPARATOR_2 = 28,
    #[doc = "29 - COMPARATOR_3"]
    COMPARATOR_3 = 29,
    #[doc = "31 - SPI_1"]
    SPI_1 = 31,
    #[doc = "32 - UART_1"]
    UART_1 = 32,
    #[doc = "33 - I2C_1"]
    I2C_1 = 33,
    #[doc = "34 - CHANGE_NOTICE"]
    CHANGE_NOTICE = 34,
    #[doc = "35 - PMP"]
    PMP = 35,
    #[doc = "36 - SPI_2"]
    SPI_2 = 36,
    #[doc = "37 - UART_2"]
    UART_2 = 37,
    #[doc = "38 - I2C_2"]
    I2C_2 = 38,
    #[doc = "39 - CTMU"]
    CTMU = 39,
    #[doc = "40 - DMA_0"]
    DMA_0 = 40,
    #[doc = "41 - DMA_1"]
    DMA_1 = 41,
    #[doc = "42 - DMA_2"]
    DMA_2 = 42,
    #[doc = "43 - DMA_3"]
    DMA_3 = 43,
}
#[derive(Debug, Copy, Clone)]
pub struct TryFromInterruptError(());
impl Interrupt {
    #[inline]
    pub fn try_from(value: u8) -> Result<Self, TryFromInterruptError> {
        match value {
            0 => Ok(Interrupt::CORE_TIMER),
            1 => Ok(Interrupt::CORE_SOFTWARE_0),
            2 => Ok(Interrupt::CORE_SOFTWARE_1),
            3 => Ok(Interrupt::EXTERNAL_0),
            4 => Ok(Interrupt::TIMER_1),
            5 => Ok(Interrupt::INPUT_CAPTURE_1),
            6 => Ok(Interrupt::OUTPUT_COMPARE_1),
            7 => Ok(Interrupt::EXTERNAL_1),
            8 => Ok(Interrupt::TIMER_2),
            9 => Ok(Interrupt::INPUT_CAPTURE_2),
            10 => Ok(Interrupt::OUTPUT_COMPARE_2),
            11 => Ok(Interrupt::EXTERNAL_2),
            12 => Ok(Interrupt::TIMER_3),
            13 => Ok(Interrupt::INPUT_CAPTURE_3),
            14 => Ok(Interrupt::OUTPUT_COMPARE_3),
            15 => Ok(Interrupt::EXTERNAL_3),
            16 => Ok(Interrupt::TIMER_4),
            17 => Ok(Interrupt::INPUT_CAPTURE_4),
            18 => Ok(Interrupt::OUTPUT_COMPARE_4),
            19 => Ok(Interrupt::EXTERNAL_4),
            20 => Ok(Interrupt::TIMER_5),
            21 => Ok(Interrupt::INPUT_CAPTURE_5),
            22 => Ok(Interrupt::OUTPUT_COMPARE_5),
            23 => Ok(Interrupt::ADC),
            24 => Ok(Interrupt::FAIL_SAFE_MONITOR),
            25 => Ok(Interrupt::RTCC),
            26 => Ok(Interrupt::FCE),
            27 => Ok(Interrupt::COMPARATOR_1),
            28 => Ok(Interrupt::COMPARATOR_2),
            29 => Ok(Interrupt::COMPARATOR_3),
            31 => Ok(Interrupt::SPI_1),
            32 => Ok(Interrupt::UART_1),
            33 => Ok(Interrupt::I2C_1),
            34 => Ok(Interrupt::CHANGE_NOTICE),
            35 => Ok(Interrupt::PMP),
            36 => Ok(Interrupt::SPI_2),
            37 => Ok(Interrupt::UART_2),
            38 => Ok(Interrupt::I2C_2),
            39 => Ok(Interrupt::CTMU),
            40 => Ok(Interrupt::DMA_0),
            41 => Ok(Interrupt::DMA_1),
            42 => Ok(Interrupt::DMA_2),
            43 => Ok(Interrupt::DMA_3),
            _ => Err(TryFromInterruptError(())),
        }
    }
}
#[cfg(feature = "rt")]
#[macro_export]
#[doc = r" Assigns a handler to an interrupt"]
#[doc = r""]
#[doc = r" This macro takes two arguments: the name of an interrupt and the path to the"]
#[doc = r" function that will be used as the handler of that interrupt. That function"]
#[doc = r" must have signature `fn()`."]
#[doc = r""]
#[doc = r" Optionally, a third argument may be used to declare interrupt local data."]
#[doc = r" The handler will have exclusive access to these *local* variables on each"]
#[doc = r" invocation. If the third argument is used then the signature of the handler"]
#[doc = r" function must be `fn(&mut $NAME::Locals)` where `$NAME` is the first argument"]
#[doc = r" passed to the macro."]
#[doc = r""]
#[doc = r" # Example"]
#[doc = r""]
#[doc = r" ``` ignore"]
#[doc = r" interrupt!(TIM2, periodic);"]
#[doc = r""]
#[doc = r" fn periodic() {"]
#[doc = r#"     print!(".");"#]
#[doc = r" }"]
#[doc = r""]
#[doc = r" interrupt!(TIM3, tick, locals: {"]
#[doc = r"     tick: bool = false;"]
#[doc = r" });"]
#[doc = r""]
#[doc = r" fn tick(locals: &mut TIM3::Locals) {"]
#[doc = r"     locals.tick = !locals.tick;"]
#[doc = r""]
#[doc = r"     if locals.tick {"]
#[doc = r#"         println!("Tick");"#]
#[doc = r"     } else {"]
#[doc = r#"         println!("Tock");"#]
#[doc = r"     }"]
#[doc = r" }"]
#[doc = r" ```"]
macro_rules ! interrupt { ( $ NAME : ident , $ path : path , locals : { $ ( $ lvar : ident : $ lty : ty = $ lval : expr ; ) * } ) => { # [ allow ( non_snake_case ) ] mod $ NAME { pub struct Locals { $ ( pub $ lvar : $ lty , ) * } } # [ allow ( non_snake_case ) ] # [ no_mangle ] pub extern "C" fn $ NAME ( ) { let _ = $ crate :: interrupt :: Interrupt :: $ NAME ; static mut LOCALS : self :: $ NAME :: Locals = self :: $ NAME :: Locals { $ ( $ lvar : $ lval , ) * } ; let f : fn ( & mut self :: $ NAME :: Locals ) = $ path ; f ( unsafe { & mut LOCALS } ) ; } } ; ( $ NAME : ident , $ path : path ) => { # [ allow ( non_snake_case ) ] # [ no_mangle ] pub extern "C" fn $ NAME ( ) { let _ = $ crate :: interrupt :: Interrupt :: $ NAME ; let f : fn ( ) = $ path ; f ( ) ; } } }
#[doc = r"Enumeration of all the interrupt sources"]
#[derive(Copy, Clone, Debug)]
#[repr(u8)]
pub enum InterruptSource {
    #[doc = "Core Timer"]
    CORE_TIMER = 0,
    #[doc = "Core Software 0"]
    CORE_SOFTWARE_0 = 1,
    #[doc = "Core Software 1"]
    CORE_SOFTWARE_1 = 2,
    #[doc = "Ext INT 0"]
    EXTERNAL_0 = 3,
    #[doc = "Timer 1"]
    TIMER_1 = 4,
    #[doc = "Input Capature 1 Error"]
    INPUT_CAPTURE_ERROR_1 = 5,
    #[doc = "Input Capture 1"]
    INPUT_CAPTURE_1 = 6,
    #[doc = "Output Compare 1"]
    OUTPUT_COMPARE_1 = 7,
    #[doc = "Ext INT 1"]
    EXTERNAL_1 = 8,
    #[doc = "Timer 2"]
    TIMER_2 = 9,
    #[doc = "Input Capture 2 Error"]
    INPUT_CAPTURE_ERROR_2 = 10,
    #[doc = "Input Capture 2"]
    INPUT_CAPTURE_2 = 11,
    #[doc = "Output Compare 2"]
    OUTPUT_COMPARE_2 = 12,
    #[doc = "External INT 2"]
    EXTERNAL_2 = 13,
    #[doc = "Timer 3"]
    TIMER_3 = 14,
    #[doc = "Input Capture 3 Error"]
    INPUT_CAPTURE_ERROR_3 = 15,
    #[doc = "Input Capture 3"]
    INPUT_CAPTURE_3 = 16,
    #[doc = "Output Compare 3"]
    OUTPUT_COMPARE_3 = 17,
    #[doc = "Ext INT 3"]
    EXTERNAL_3 = 18,
    #[doc = "Timer 4"]
    TIMER_4 = 19,
    #[doc = "Input Capture 4 Error"]
    INPUT_CAPTURE_ERROR_4 = 20,
    #[doc = "Input Capture 4"]
    INPUT_CAPTURE_4 = 21,
    #[doc = "Output Compare 4"]
    OUTPUT_COMPARE_4 = 22,
    #[doc = "Ext INT 4"]
    EXTERNAL_4 = 23,
    #[doc = "Timer 5"]
    TIMER_5 = 24,
    #[doc = "Input Capture 5 Error"]
    INPUT_CAPTURE_ERROR_5 = 25,
    #[doc = "Input Capture 5"]
    INPUT_CAPTURE_5 = 26,
    #[doc = "Output Compare 5"]
    OUTPUT_COMPARE_5 = 27,
    #[doc = "ADC1 Convert Done"]
    ADC = 28,
    #[doc = "Fail Safe Clock Monitor"]
    FAIL_SAFE_MONITOR = 29,
    #[doc = "Real Time Clock Calendar"]
    RTCC = 30,
    FLASH_CONTROL = 31,
    #[doc = "Comparator 1"]
    COMPARATOR_1 = 32,
    #[doc = "Comparator 2"]
    COMPARATOR_2 = 33,
    #[doc = "Comparator 3"]
    COMPARATOR_3 = 34,
    #[doc = "USB"]
    USB = 35,
    #[doc = "SPI1 Fault"]
    SPI1_ERR = 36,
    #[doc = "SPI1 Receive Done"]
    SPI1_RX = 37,
    #[doc = "SPI1 Transmit Done"]
    SPI1_TX = 38,
    #[doc = "UART1 Error"]
    UART1_ERR = 39,
    #[doc = "UART1 Receiver"]
    UART1_RX = 40,
    #[doc = "UART1 Trasmitter"]
    UART1_TX = 41,
    #[doc = "I2C1 Bus Collision Event"]
    I2C1_BUS = 42,
    #[doc = "I2C1 Slave Event"]
    I2C1_SLAVE = 43,
    #[doc = "I2C1 Master Event"]
    I2C1_MASTER = 44,
    #[doc = "Part A Change Notice"]
    CHANGE_NOTICE_A = 45,
    #[doc = "Part B Change Notice"]
    CHANGE_NOTICE_B = 46,
    #[doc = "Part C Change Notice"]
    CHANGE_NOTICE_C = 47,
    #[doc = "Parallel Master Port"]
    PMP = 48,
    #[doc = "PMP Error"]
    PMP_ERROR = 49,
    #[doc = "SPI2 Error"]
    SPI2_ERR = 50,
    #[doc = "SPI2 Receiver"]
    SPI2_RX = 51,
    #[doc = "SPI2 Trasmitter"]
    SPI2_TX = 52,
    #[doc = "UART2 Error"]
    UART2_ERR = 53,
    #[doc = "UART2 Receiver"]
    UART2_RX = 54,
    #[doc = "UART2 Trasmitter"]
    UART2_TX = 55,
    #[doc = "I2C2 Bus Collision Event"]
    I2C2_BUS = 56,
    #[doc = "I2C2 Slave Event"]
    I2C2_SLAVE = 57,
    #[doc = "I2C2 Master Event"]
    I2C2_MASTER = 58,
    #[doc = "CTMU Event"]
    CTMU = 59,
    DMA0 = 60,
    DMA1 = 61,
    DMA2 = 62,
    DMA3 = 63,
}
