#[doc = "Register `CNPU` reader"]
pub struct R(crate::R<CNPU_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CNPU_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CNPU_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CNPU_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CNPU` writer"]
pub struct W(crate::W<CNPU_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CNPU_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CNPU_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CNPU_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CNPUC0` reader - "]
pub struct CNPUC0_R(crate::FieldReader<bool, bool>);
impl CNPUC0_R {
    pub(crate) fn new(bits: bool) -> Self {
        CNPUC0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CNPUC0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CNPUC0` writer - "]
pub struct CNPUC0_W<'a> {
    w: &'a mut W,
}
impl<'a> CNPUC0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `CNPUC1` reader - "]
pub struct CNPUC1_R(crate::FieldReader<bool, bool>);
impl CNPUC1_R {
    pub(crate) fn new(bits: bool) -> Self {
        CNPUC1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CNPUC1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CNPUC1` writer - "]
pub struct CNPUC1_W<'a> {
    w: &'a mut W,
}
impl<'a> CNPUC1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `CNPUC3` reader - "]
pub struct CNPUC3_R(crate::FieldReader<bool, bool>);
impl CNPUC3_R {
    pub(crate) fn new(bits: bool) -> Self {
        CNPUC3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CNPUC3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CNPUC3` writer - "]
pub struct CNPUC3_W<'a> {
    w: &'a mut W,
}
impl<'a> CNPUC3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `CNPUC9` reader - "]
pub struct CNPUC9_R(crate::FieldReader<bool, bool>);
impl CNPUC9_R {
    pub(crate) fn new(bits: bool) -> Self {
        CNPUC9_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CNPUC9_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CNPUC9` writer - "]
pub struct CNPUC9_W<'a> {
    w: &'a mut W,
}
impl<'a> CNPUC9_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
impl R {
    #[doc = "Bit 0"]
    #[inline(always)]
    pub fn cnpuc0(&self) -> CNPUC0_R {
        CNPUC0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1"]
    #[inline(always)]
    pub fn cnpuc1(&self) -> CNPUC1_R {
        CNPUC1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 3"]
    #[inline(always)]
    pub fn cnpuc3(&self) -> CNPUC3_R {
        CNPUC3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 9"]
    #[inline(always)]
    pub fn cnpuc9(&self) -> CNPUC9_R {
        CNPUC9_R::new(((self.bits >> 9) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0"]
    #[inline(always)]
    pub fn cnpuc0(&mut self) -> CNPUC0_W {
        CNPUC0_W { w: self }
    }
    #[doc = "Bit 1"]
    #[inline(always)]
    pub fn cnpuc1(&mut self) -> CNPUC1_W {
        CNPUC1_W { w: self }
    }
    #[doc = "Bit 3"]
    #[inline(always)]
    pub fn cnpuc3(&mut self) -> CNPUC3_W {
        CNPUC3_W { w: self }
    }
    #[doc = "Bit 9"]
    #[inline(always)]
    pub fn cnpuc9(&mut self) -> CNPUC9_W {
        CNPUC9_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "CNPUC register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cnpu](index.html) module"]
pub struct CNPU_SPEC;
impl crate::RegisterSpec for CNPU_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [cnpu::R](R) reader structure"]
impl crate::Readable for CNPU_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cnpu::W](W) writer structure"]
impl crate::Writable for CNPU_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CNPU to value 0"]
impl crate::Resettable for CNPU_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
