use crate::Dim;
use typenum:: { Z0, P1, N1, Square, Cube, Quot, Prod };

pub type Dimensionless = Dim<Z0, Z0, Z0, Z0, Z0, Z0, Z0>;

pub type Length = Dim<P1, Z0, Z0, Z0, Z0, Z0, Z0>;
pub type Mass = Dim<Z0, P1, Z0, Z0, Z0, Z0, Z0>;
pub type Time = Dim<Z0, Z0, P1, Z0, Z0, Z0, Z0>;
pub type Temperature = Dim<Z0, Z0, Z0, P1, Z0, Z0, Z0>;
pub type Amount = Dim<Z0, Z0, Z0, Z0, P1, Z0, Z0>;
pub type Current = Dim<Z0, Z0, Z0, Z0, Z0, P1, Z0>;
pub type Luminous = Dim<Z0, Z0, Z0, Z0, Z0, Z0, P1>;

pub type Frequency = Dim<Z0, Z0, N1, Z0, Z0, Z0, Z0>;
pub type FrequencyAcceleration = Quot<Frequency, Time>;
pub type Area = Square<Length>;
pub type Volume = Cube<Length>;
pub type Velocity = Quot<Length, Time>;
pub type Acceleration = Quot<Velocity, Time>;
pub type Force = Prod<Mass, Acceleration>;
pub type Pressure = Quot<Force, Area>;
pub type Head = Quot<Pressure, Length>;
pub type Energy = Prod<Force, Length>;
pub type SpecificEnthalpy = Quot<Energy, Mass>;
pub type Power = Quot<Energy, Time>;
pub type Voltage = Quot<Power, Current>;
pub type ElectricFieldStrength = Quot<Voltage, Length>;
pub type ElectricResistance = Quot<Voltage, Current>;
pub type ElectricConductance = Quot<Current, Voltage>;
pub type ElectricalInductance = Quot<MagneticFlux, Current>;
pub type ElectricCharge = Prod<Current, Time>;
pub type Capacitance = Quot<ElectricCharge, Voltage>;
pub type RadiationExposure = Quot<ElectricCharge, Mass>;
pub type MagneticFlux = Prod<Voltage, Time>;
pub type MagneticFluxDensity = Quot<MagneticFlux, Area>;
pub type MagneticFieldStrength = Quot<Current, Length>;
pub type Illuminance = Quot<Luminous, Area>;
pub type Viscosity = Prod<Pressure, Time>;
pub type KinematicViscosity = Quot<Area, Time>;
pub type Density = Quot<Mass, Volume>;

pub const DIMENSIONLESS: Dimensionless = Dimensionless::new();

pub const LENGTH: Length = Length::new();
pub const MASS: Mass = Mass::new();
pub const TIME: Time = Time::new();
pub const TEMPERATURE: Temperature = Temperature::new();
pub const AMOUNT: Amount = Amount::new();
pub const CURRENT: Current = Current::new();
pub const LUMINOUS: Luminous = Luminous::new();

pub const FREQUENCY: Frequency = Frequency::new();
pub const FREQUENCY_ACCELERATION: FrequencyAcceleration = FrequencyAcceleration::new();
pub const AREA: Area = Area::new();
pub const VOLUME: Volume = Volume::new();
pub const VELOCITY: Velocity = Velocity::new();
pub const ACCELERATION: Acceleration = Acceleration::new();
pub const FORCE: Force = Force::new();
pub const PRESSURE: Pressure = Pressure::new();
pub const HEAD: Head = Head::new();
pub const ENERGY: Energy = Energy::new();
pub const SPECIFIC_ENTHALPY: SpecificEnthalpy = SpecificEnthalpy::new();
pub const POWER: Power = Power::new();
pub const VOLTAGE: Voltage = Voltage::new();
pub const ELECTRIC_FIELD_STRENGTH: ElectricFieldStrength = ElectricFieldStrength::new();
pub const ELECTRIC_RESISTANCE: ElectricResistance = ElectricResistance::new();
pub const ELECTRIC_CHARGE: ElectricCharge = ElectricCharge::new();
pub const CAPACITANCE: Capacitance = Capacitance::new();
pub const RADIATION_EXPOSURE: RadiationExposure = RadiationExposure::new();
pub const MAGNETIC_FLUX: MagneticFlux = MagneticFlux::new();
pub const MAGNETIC_FLUX_DENSITY: MagneticFluxDensity = MagneticFluxDensity::new();
pub const MAGNETIC_FIELD_STRENGTH: MagneticFieldStrength = MagneticFieldStrength::new();
pub const ILLUMINANCE: Illuminance = Illuminance::new();
pub const ELECTRIC_CONDUCTANCE: ElectricConductance = ElectricConductance::new();
pub const ELECTRICAL_INDUCTANCE: ElectricalInductance = ElectricalInductance::new();
pub const VISCOSITY: Viscosity = Viscosity::new();
pub const KINEMATIC_VISCOSITY: KinematicViscosity = KinematicViscosity::new();
pub const DENSITY: Density = Density::new();
