use const_frac;

#[cfg(feature = "ratio")]
use core:: {
    fmt::Debug,
};
#[cfg(feature = "ratio")]
use num_traits:: { Bounded, NumAssign, NumCast, Pow, Signed };
#[cfg(feature = "ratio")]
use num_integer::Integer;
#[cfg(feature = "ratio")]
use num_rational::Ratio;

pub trait Real: const_frac::Real
{}

impl Real for f64 {}
impl Real for const_frac::Frac {}
#[cfg(feature = "ratio")]
impl<T> Real for Ratio<T>
where
    T: Clone + Debug + From<i128>
     + Integer + NumAssign + Signed + Bounded + NumCast + Pow<u32, Output = T>,
{}