use const_frac;

#[cfg(feature = "ratio")]
use num::rational::Ratio;

pub trait Real: const_frac::Real
{}

impl Real for f64 {}
impl Real for const_frac::Frac {}
#[cfg(feature = "ratio")]
impl<T> Real for Ratio<T>
where
    T: Clone + Debug + From<i128>,
{}