use core:: {
    fmt:: { self, Debug, Display },
};

#[cfg(feature = "std")]
use std::error::Error;

#[derive(Debug)]
pub struct DimensionMismatch;

impl Display for DimensionMismatch {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> Result<(), fmt::Error> {
        Debug::fmt(self, f)
    }
}

#[cfg(feature = "std")]
impl Error for DimensionMismatch {}

#[derive(Debug)]
pub enum ConversionError<E: Debug> {
    DimensionMismatch(DimensionMismatch),
    IncompatibleValue(E),
    IncorrectDefinition,
    InvalidUnitString,
}

impl<E: Debug> Display for ConversionError<E> {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> Result<(), fmt::Error> {
        Debug::fmt(self, f)
    }
}

#[cfg(feature = "std")]
impl<E: Debug> Error for ConversionError<E> {}