# Description
dimension and unit system for general physical physical quantities.

# Badges
[![Latest Release](https://gitlab.com/fton/physical-quantity/-/badges/release.svg)](https://gitlab.com/fton/physical-quantity/-/releases)
[![pipeline status](https://gitlab.com/fton/physical-quantity/badges/main/pipeline.svg)](https://gitlab.com/fton/physical-quantity/-/commits/main)
[![coverage report](https://gitlab.com/fton/physical-quantity/badges/main/coverage.svg)](https://gitlab.com/fton/physical-quantity/-/commits/main)

# Usage
```
use ::physical_quantity::*;

let inch: Unit<f64, _> = "in.".parse().unwrap();
let pq = inch.pq(1f64);
let mm: Unit<f64, _> = "mm".parse().unwrap();
let inch2mm = mm.value(pq).unwrap();

assert_eq!(inch2mm, 25.4);
```
# Project status
This package is in the very early stage.