use crate as pg_sys;
use crate::PgNode;
#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const PG_DIAG_SEVERITY: u8 = 83u8;
pub const PG_DIAG_SEVERITY_NONLOCALIZED: u8 = 86u8;
pub const PG_DIAG_SQLSTATE: u8 = 67u8;
pub const PG_DIAG_MESSAGE_PRIMARY: u8 = 77u8;
pub const PG_DIAG_MESSAGE_DETAIL: u8 = 68u8;
pub const PG_DIAG_MESSAGE_HINT: u8 = 72u8;
pub const PG_DIAG_STATEMENT_POSITION: u8 = 80u8;
pub const PG_DIAG_INTERNAL_POSITION: u8 = 112u8;
pub const PG_DIAG_INTERNAL_QUERY: u8 = 113u8;
pub const PG_DIAG_CONTEXT: u8 = 87u8;
pub const PG_DIAG_SCHEMA_NAME: u8 = 115u8;
pub const PG_DIAG_TABLE_NAME: u8 = 116u8;
pub const PG_DIAG_COLUMN_NAME: u8 = 99u8;
pub const PG_DIAG_DATATYPE_NAME: u8 = 100u8;
pub const PG_DIAG_CONSTRAINT_NAME: u8 = 110u8;
pub const PG_DIAG_SOURCE_FILE: u8 = 70u8;
pub const PG_DIAG_SOURCE_LINE: u8 = 76u8;
pub const PG_DIAG_SOURCE_FUNCTION: u8 = 82u8;
pub const ALIGNOF_DOUBLE: u32 = 8;
pub const ALIGNOF_INT: u32 = 4;
pub const ALIGNOF_LONG: u32 = 8;
pub const ALIGNOF_PG_INT128_TYPE: u32 = 16;
pub const ALIGNOF_SHORT: u32 = 2;
pub const BLCKSZ: u32 = 8192;
pub const CONFIGURE_ARGS : & [u8 ; 107usize] = b" '--prefix=/Users/e_ridge/.pgx/14.1/pgx-install' '--with-pgport=28814' '--enable-debug' '--enable-cassert'\0" ;
pub const DEF_PGPORT: u32 = 28814;
pub const DEF_PGPORT_STR: &[u8; 6usize] = b"28814\0";
pub const ENABLE_THREAD_SAFETY: u32 = 1;
pub const HAVE_ATOMICS: u32 = 1;
pub const HAVE_BACKTRACE_SYMBOLS: u32 = 1;
pub const HAVE_CLOCK_GETTIME: u32 = 1;
pub const HAVE_COMPUTED_GOTO: u32 = 1;
pub const HAVE_COPYFILE: u32 = 1;
pub const HAVE_COPYFILE_H: u32 = 1;
pub const HAVE_DECL_FDATASYNC: u32 = 0;
pub const HAVE_DECL_F_FULLFSYNC: u32 = 1;
pub const HAVE_DECL_POSIX_FADVISE: u32 = 0;
pub const HAVE_DECL_PREADV: u32 = 1;
pub const HAVE_DECL_PWRITEV: u32 = 1;
pub const HAVE_DECL_RTLD_GLOBAL: u32 = 1;
pub const HAVE_DECL_RTLD_NOW: u32 = 1;
pub const HAVE_DECL_STRLCAT: u32 = 1;
pub const HAVE_DECL_STRLCPY: u32 = 1;
pub const HAVE_DECL_STRNLEN: u32 = 1;
pub const HAVE_DECL_STRTOLL: u32 = 1;
pub const HAVE_DECL_STRTOULL: u32 = 1;
pub const HAVE_DLOPEN: u32 = 1;
pub const HAVE_EXECINFO_H: u32 = 1;
pub const HAVE_FDATASYNC: u32 = 1;
pub const HAVE_FLS: u32 = 1;
pub const HAVE_FSEEKO: u32 = 1;
pub const HAVE_FUNCNAME__FUNC: u32 = 1;
pub const HAVE_GCC__ATOMIC_INT32_CAS: u32 = 1;
pub const HAVE_GCC__ATOMIC_INT64_CAS: u32 = 1;
pub const HAVE_GCC__SYNC_CHAR_TAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT32_CAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT32_TAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT64_CAS: u32 = 1;
pub const HAVE_GETADDRINFO: u32 = 1;
pub const HAVE_GETIFADDRS: u32 = 1;
pub const HAVE_GETOPT: u32 = 1;
pub const HAVE_GETOPT_H: u32 = 1;
pub const HAVE_GETOPT_LONG: u32 = 1;
pub const HAVE_GETPEEREID: u32 = 1;
pub const HAVE_GETPWUID_R: u32 = 1;
pub const HAVE_GETRLIMIT: u32 = 1;
pub const HAVE_GETRUSAGE: u32 = 1;
pub const HAVE_HISTORY_TRUNCATE_FILE: u32 = 1;
pub const HAVE_IFADDRS_H: u32 = 1;
pub const HAVE_INET_ATON: u32 = 1;
pub const HAVE_INTTYPES_H: u32 = 1;
pub const HAVE_INT_OPTERR: u32 = 1;
pub const HAVE_INT_OPTRESET: u32 = 1;
pub const HAVE_INT_TIMEZONE: u32 = 1;
pub const HAVE_IPV6: u32 = 1;
pub const HAVE_KQUEUE: u32 = 1;
pub const HAVE_LANGINFO_H: u32 = 1;
pub const HAVE_LIBM: u32 = 1;
pub const HAVE_LIBREADLINE: u32 = 1;
pub const HAVE_LIBZ: u32 = 1;
pub const HAVE_LINK: u32 = 1;
pub const HAVE_LOCALE_T: u32 = 1;
pub const HAVE_LONG_INT_64: u32 = 1;
pub const HAVE_MBSTOWCS_L: u32 = 1;
pub const HAVE_MEMORY_H: u32 = 1;
pub const HAVE_MEMSET_S: u32 = 1;
pub const HAVE_MKDTEMP: u32 = 1;
pub const HAVE_NETINET_TCP_H: u32 = 1;
pub const HAVE_NET_IF_H: u32 = 1;
pub const HAVE_POLL: u32 = 1;
pub const HAVE_POLL_H: u32 = 1;
pub const HAVE_PREAD: u32 = 1;
pub const HAVE_PTHREAD: u32 = 1;
pub const HAVE_PTHREAD_IS_THREADED_NP: u32 = 1;
pub const HAVE_PTHREAD_PRIO_INHERIT: u32 = 1;
pub const HAVE_PWRITE: u32 = 1;
pub const HAVE_RANDOM: u32 = 1;
pub const HAVE_READLINE_HISTORY_H: u32 = 1;
pub const HAVE_READLINE_READLINE_H: u32 = 1;
pub const HAVE_READLINK: u32 = 1;
pub const HAVE_READV: u32 = 1;
pub const HAVE_RL_COMPLETION_APPEND_CHARACTER: u32 = 1;
pub const HAVE_RL_COMPLETION_MATCHES: u32 = 1;
pub const HAVE_RL_FILENAME_COMPLETION_FUNCTION: u32 = 1;
pub const HAVE_SETENV: u32 = 1;
pub const HAVE_SETSID: u32 = 1;
pub const HAVE_SHM_OPEN: u32 = 1;
pub const HAVE_SPINLOCKS: u32 = 1;
pub const HAVE_SRANDOM: u32 = 1;
pub const HAVE_STDBOOL_H: u32 = 1;
pub const HAVE_STDINT_H: u32 = 1;
pub const HAVE_STDLIB_H: u32 = 1;
pub const HAVE_STRERROR_R: u32 = 1;
pub const HAVE_STRINGS_H: u32 = 1;
pub const HAVE_STRING_H: u32 = 1;
pub const HAVE_STRLCAT: u32 = 1;
pub const HAVE_STRLCPY: u32 = 1;
pub const HAVE_STRNLEN: u32 = 1;
pub const HAVE_STRSIGNAL: u32 = 1;
pub const HAVE_STRTOF: u32 = 1;
pub const HAVE_STRTOLL: u32 = 1;
pub const HAVE_STRTOULL: u32 = 1;
pub const HAVE_STRUCT_ADDRINFO: u32 = 1;
pub const HAVE_STRUCT_OPTION: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_SA_LEN: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE_SS_FAMILY: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE_SS_LEN: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_UN: u32 = 1;
pub const HAVE_STRUCT_TM_TM_ZONE: u32 = 1;
pub const HAVE_SYMLINK: u32 = 1;
pub const HAVE_SYSLOG: u32 = 1;
pub const HAVE_SYS_EVENT_H: u32 = 1;
pub const HAVE_SYS_IPC_H: u32 = 1;
pub const HAVE_SYS_RESOURCE_H: u32 = 1;
pub const HAVE_SYS_SELECT_H: u32 = 1;
pub const HAVE_SYS_SEM_H: u32 = 1;
pub const HAVE_SYS_SHM_H: u32 = 1;
pub const HAVE_SYS_SOCKIO_H: u32 = 1;
pub const HAVE_SYS_STAT_H: u32 = 1;
pub const HAVE_SYS_TYPES_H: u32 = 1;
pub const HAVE_SYS_UCRED_H: u32 = 1;
pub const HAVE_SYS_UIO_H: u32 = 1;
pub const HAVE_SYS_UN_H: u32 = 1;
pub const HAVE_TERMIOS_H: u32 = 1;
pub const HAVE_TYPEOF: u32 = 1;
pub const HAVE_UNION_SEMUN: u32 = 1;
pub const HAVE_UNISTD_H: u32 = 1;
pub const HAVE_UNSETENV: u32 = 1;
pub const HAVE_USELOCALE: u32 = 1;
pub const HAVE_WCSTOMBS_L: u32 = 1;
pub const HAVE_WCTYPE_H: u32 = 1;
pub const HAVE_WRITEV: u32 = 1;
pub const HAVE__BOOL: u32 = 1;
pub const HAVE__BUILTIN_BSWAP16: u32 = 1;
pub const HAVE__BUILTIN_BSWAP32: u32 = 1;
pub const HAVE__BUILTIN_BSWAP64: u32 = 1;
pub const HAVE__BUILTIN_CLZ: u32 = 1;
pub const HAVE__BUILTIN_CONSTANT_P: u32 = 1;
pub const HAVE__BUILTIN_CTZ: u32 = 1;
pub const HAVE__BUILTIN_OP_OVERFLOW: u32 = 1;
pub const HAVE__BUILTIN_POPCOUNT: u32 = 1;
pub const HAVE__BUILTIN_TYPES_COMPATIBLE_P: u32 = 1;
pub const HAVE__BUILTIN_UNREACHABLE: u32 = 1;
pub const HAVE__STATIC_ASSERT: u32 = 1;
pub const INT64_MODIFIER: &[u8; 2usize] = b"l\0";
pub const LOCALE_T_IN_XLOCALE: u32 = 1;
pub const MAXIMUM_ALIGNOF: u32 = 8;
pub const MEMSET_LOOP_LIMIT: u32 = 1024;
pub const PACKAGE_BUGREPORT: &[u8; 32usize] = b"pgsql-bugs@lists.postgresql.org\0";
pub const PACKAGE_NAME: &[u8; 11usize] = b"PostgreSQL\0";
pub const PACKAGE_STRING: &[u8; 16usize] = b"PostgreSQL 14.1\0";
pub const PACKAGE_TARNAME: &[u8; 11usize] = b"postgresql\0";
pub const PACKAGE_URL: &[u8; 28usize] = b"https://www.postgresql.org/\0";
pub const PACKAGE_VERSION: &[u8; 5usize] = b"14.1\0";
pub const PG_KRB_SRVNAM: &[u8; 9usize] = b"postgres\0";
pub const PG_MAJORVERSION: &[u8; 3usize] = b"14\0";
pub const PG_MAJORVERSION_NUM: u32 = 14;
pub const PG_MINORVERSION_NUM: u32 = 1;
pub const PG_USE_STDBOOL: u32 = 1;
pub const PG_VERSION: &[u8; 5usize] = b"14.1\0";
pub const PG_VERSION_NUM: u32 = 140001;
pub const PG_VERSION_STR : & [u8 ; 115usize] = b"PostgreSQL 14.1 on aarch64-apple-darwin21.3.0, compiled by Apple clang version 13.0.0 (clang-1300.0.29.30), 64-bit\0" ;
pub const RELSEG_SIZE: u32 = 131072;
pub const SIZEOF_BOOL: u32 = 1;
pub const SIZEOF_LONG: u32 = 8;
pub const SIZEOF_OFF_T: u32 = 8;
pub const SIZEOF_SIZE_T: u32 = 8;
pub const SIZEOF_VOID_P: u32 = 8;
pub const STDC_HEADERS: u32 = 1;
pub const STRERROR_R_INT: u32 = 1;
pub const USE_ARMV8_CRC32C: u32 = 1;
pub const USE_ASSERT_CHECKING: u32 = 1;
pub const USE_SYSV_SEMAPHORES: u32 = 1;
pub const USE_SYSV_SHARED_MEMORY: u32 = 1;
pub const WCSTOMBS_L_IN_XLOCALE: u32 = 1;
pub const XLOG_BLCKSZ: u32 = 8192;
pub const DEFAULT_XLOG_SEG_SIZE: u32 = 16777216;
pub const NAMEDATALEN: u32 = 64;
pub const FUNC_MAX_ARGS: u32 = 100;
pub const INDEX_MAX_KEYS: u32 = 32;
pub const PARTITION_MAX_KEYS: u32 = 32;
pub const USE_FLOAT8_BYVAL: u32 = 1;
pub const NUM_SPINLOCK_SEMAPHORES: u32 = 128;
pub const NUM_ATOMICS_SEMAPHORES: u32 = 64;
pub const MAXPGPATH: u32 = 1024;
pub const PG_SOMAXCONN: u32 = 10000;
pub const BITS_PER_BYTE: u32 = 8;
pub const ALIGNOF_BUFFER: u32 = 32;
pub const HAVE_WORKING_LINK: u32 = 1;
pub const DEFAULT_BACKEND_FLUSH_AFTER: u32 = 0;
pub const DEFAULT_BGWRITER_FLUSH_AFTER: u32 = 0;
pub const DEFAULT_CHECKPOINT_FLUSH_AFTER: u32 = 0;
pub const WRITEBACK_MAX_PENDING_FLUSHES: u32 = 256;
pub const DEFAULT_PGSOCKET_DIR: &[u8; 5usize] = b"/tmp\0";
pub const DEFAULT_EVENT_SOURCE: &[u8; 11usize] = b"PostgreSQL\0";
pub const PG_CACHE_LINE_SIZE: u32 = 128;
pub const TRACE_SORT: u32 = 1;
pub const __darwin__: u32 = 1;
pub const __DARWIN_ONLY_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const __DARWIN_ONLY_VERS_1050: u32 = 1;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_EXTSN: &[u8; 14usize] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __STDC_WANT_LIB_EXT1__: u32 = 1;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_VERS_1050: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __has_ptrcheck: u32 = 0;
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_14_6: u32 = 101406;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __MAC_10_16: u32 = 101600;
pub const __MAC_11_0: u32 = 110000;
pub const __MAC_11_1: u32 = 110100;
pub const __MAC_11_3: u32 = 110300;
pub const __MAC_11_4: u32 = 110400;
pub const __MAC_11_5: u32 = 110500;
pub const __MAC_11_6: u32 = 110600;
pub const __MAC_12_0: u32 = 120000;
pub const __MAC_12_1: u32 = 120100;
pub const __MAC_12_2: u32 = 120200;
pub const __MAC_12_3: u32 = 120300;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_12_4: u32 = 120400;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __IPHONE_13_5: u32 = 130500;
pub const __IPHONE_13_6: u32 = 130600;
pub const __IPHONE_13_7: u32 = 130700;
pub const __IPHONE_14_0: u32 = 140000;
pub const __IPHONE_14_1: u32 = 140100;
pub const __IPHONE_14_2: u32 = 140200;
pub const __IPHONE_14_3: u32 = 140300;
pub const __IPHONE_14_5: u32 = 140500;
pub const __IPHONE_14_6: u32 = 140600;
pub const __IPHONE_14_7: u32 = 140700;
pub const __IPHONE_14_8: u32 = 140800;
pub const __IPHONE_15_0: u32 = 150000;
pub const __IPHONE_15_1: u32 = 150100;
pub const __IPHONE_15_2: u32 = 150200;
pub const __IPHONE_15_3: u32 = 150300;
pub const __IPHONE_15_4: u32 = 150400;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_12_4: u32 = 120400;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __TVOS_14_0: u32 = 140000;
pub const __TVOS_14_1: u32 = 140100;
pub const __TVOS_14_2: u32 = 140200;
pub const __TVOS_14_3: u32 = 140300;
pub const __TVOS_14_5: u32 = 140500;
pub const __TVOS_14_6: u32 = 140600;
pub const __TVOS_14_7: u32 = 140700;
pub const __TVOS_15_0: u32 = 150000;
pub const __TVOS_15_1: u32 = 150100;
pub const __TVOS_15_2: u32 = 150200;
pub const __TVOS_15_3: u32 = 150300;
pub const __TVOS_15_4: u32 = 150400;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_5_3: u32 = 50300;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __WATCHOS_7_0: u32 = 70000;
pub const __WATCHOS_7_1: u32 = 70100;
pub const __WATCHOS_7_2: u32 = 70200;
pub const __WATCHOS_7_3: u32 = 70300;
pub const __WATCHOS_7_4: u32 = 70400;
pub const __WATCHOS_7_5: u32 = 70500;
pub const __WATCHOS_7_6: u32 = 70600;
pub const __WATCHOS_8_0: u32 = 80000;
pub const __WATCHOS_8_1: u32 = 80100;
pub const __WATCHOS_8_3: u32 = 80300;
pub const __WATCHOS_8_4: u32 = 80400;
pub const __WATCHOS_8_5: u32 = 80500;
pub const MAC_OS_X_VERSION_10_0: u32 = 1000;
pub const MAC_OS_X_VERSION_10_1: u32 = 1010;
pub const MAC_OS_X_VERSION_10_2: u32 = 1020;
pub const MAC_OS_X_VERSION_10_3: u32 = 1030;
pub const MAC_OS_X_VERSION_10_4: u32 = 1040;
pub const MAC_OS_X_VERSION_10_5: u32 = 1050;
pub const MAC_OS_X_VERSION_10_6: u32 = 1060;
pub const MAC_OS_X_VERSION_10_7: u32 = 1070;
pub const MAC_OS_X_VERSION_10_8: u32 = 1080;
pub const MAC_OS_X_VERSION_10_9: u32 = 1090;
pub const MAC_OS_X_VERSION_10_10: u32 = 101000;
pub const MAC_OS_X_VERSION_10_10_2: u32 = 101002;
pub const MAC_OS_X_VERSION_10_10_3: u32 = 101003;
pub const MAC_OS_X_VERSION_10_11: u32 = 101100;
pub const MAC_OS_X_VERSION_10_11_2: u32 = 101102;
pub const MAC_OS_X_VERSION_10_11_3: u32 = 101103;
pub const MAC_OS_X_VERSION_10_11_4: u32 = 101104;
pub const MAC_OS_X_VERSION_10_12: u32 = 101200;
pub const MAC_OS_X_VERSION_10_12_1: u32 = 101201;
pub const MAC_OS_X_VERSION_10_12_2: u32 = 101202;
pub const MAC_OS_X_VERSION_10_12_4: u32 = 101204;
pub const MAC_OS_X_VERSION_10_13: u32 = 101300;
pub const MAC_OS_X_VERSION_10_13_1: u32 = 101301;
pub const MAC_OS_X_VERSION_10_13_2: u32 = 101302;
pub const MAC_OS_X_VERSION_10_13_4: u32 = 101304;
pub const MAC_OS_X_VERSION_10_14: u32 = 101400;
pub const MAC_OS_X_VERSION_10_14_1: u32 = 101401;
pub const MAC_OS_X_VERSION_10_14_4: u32 = 101404;
pub const MAC_OS_X_VERSION_10_14_6: u32 = 101406;
pub const MAC_OS_X_VERSION_10_15: u32 = 101500;
pub const MAC_OS_X_VERSION_10_15_1: u32 = 101501;
pub const MAC_OS_X_VERSION_10_16: u32 = 101600;
pub const MAC_OS_VERSION_11_0: u32 = 110000;
pub const MAC_OS_VERSION_12_0: u32 = 120000;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __DRIVERKIT_20_0: u32 = 200000;
pub const __DRIVERKIT_21_0: u32 = 210000;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 120300;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const RENAME_SECLUDE: u32 = 1;
pub const RENAME_SWAP: u32 = 2;
pub const RENAME_EXCL: u32 = 4;
pub const RENAME_RESERVED1: u32 = 8;
pub const RENAME_NOFOLLOW_ANY: u32 = 16;
pub const __SLBF: u32 = 1;
pub const __SNBF: u32 = 2;
pub const __SRD: u32 = 4;
pub const __SWR: u32 = 8;
pub const __SRW: u32 = 16;
pub const __SEOF: u32 = 32;
pub const __SERR: u32 = 64;
pub const __SMBF: u32 = 128;
pub const __SAPP: u32 = 256;
pub const __SSTR: u32 = 512;
pub const __SOPT: u32 = 1024;
pub const __SNPT: u32 = 2048;
pub const __SOFF: u32 = 4096;
pub const __SMOD: u32 = 8192;
pub const __SALC: u32 = 16384;
pub const __SIGN: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 1024;
pub const EOF: i32 = -1;
pub const FOPEN_MAX: u32 = 20;
pub const FILENAME_MAX: u32 = 1024;
pub const P_tmpdir: &[u8; 10usize] = b"/var/tmp/\0";
pub const L_tmpnam: u32 = 1024;
pub const TMP_MAX: u32 = 308915776;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const L_ctermid: u32 = 1024;
pub const _USE_FORTIFY_LEVEL: u32 = 2;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _ARM_SIGNAL_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const __DARWIN_OPAQUE_ARM_THREAD_STATE64: u32 = 0;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const __WORDSIZE: u32 = 64;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const RSIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const PRIO_PROCESS: u32 = 0;
pub const PRIO_PGRP: u32 = 1;
pub const PRIO_USER: u32 = 2;
pub const PRIO_DARWIN_THREAD: u32 = 3;
pub const PRIO_DARWIN_PROCESS: u32 = 4;
pub const PRIO_MIN: i32 = -20;
pub const PRIO_MAX: u32 = 20;
pub const PRIO_DARWIN_BG: u32 = 4096;
pub const PRIO_DARWIN_NONUI: u32 = 4097;
pub const RUSAGE_SELF: u32 = 0;
pub const RUSAGE_CHILDREN: i32 = -1;
pub const RUSAGE_INFO_V0: u32 = 0;
pub const RUSAGE_INFO_V1: u32 = 1;
pub const RUSAGE_INFO_V2: u32 = 2;
pub const RUSAGE_INFO_V3: u32 = 3;
pub const RUSAGE_INFO_V4: u32 = 4;
pub const RUSAGE_INFO_V5: u32 = 5;
pub const RUSAGE_INFO_CURRENT: u32 = 5;
pub const RU_PROC_RUNS_RESLIDE: u32 = 1;
pub const RLIMIT_CPU: u32 = 0;
pub const RLIMIT_FSIZE: u32 = 1;
pub const RLIMIT_DATA: u32 = 2;
pub const RLIMIT_STACK: u32 = 3;
pub const RLIMIT_CORE: u32 = 4;
pub const RLIMIT_AS: u32 = 5;
pub const RLIMIT_RSS: u32 = 5;
pub const RLIMIT_MEMLOCK: u32 = 6;
pub const RLIMIT_NPROC: u32 = 7;
pub const RLIMIT_NOFILE: u32 = 8;
pub const RLIM_NLIMITS: u32 = 9;
pub const _RLIMIT_POSIX_FLAG: u32 = 4096;
pub const RLIMIT_WAKEUPS_MONITOR: u32 = 1;
pub const RLIMIT_CPU_USAGE_MONITOR: u32 = 2;
pub const RLIMIT_THREAD_CPULIMITS: u32 = 3;
pub const RLIMIT_FOOTPRINT_INTERVAL: u32 = 4;
pub const WAKEMON_ENABLE: u32 = 1;
pub const WAKEMON_DISABLE: u32 = 2;
pub const WAKEMON_GET_PARAMS: u32 = 4;
pub const WAKEMON_SET_DEFAULTS: u32 = 8;
pub const WAKEMON_MAKE_FATAL: u32 = 16;
pub const CPUMON_MAKE_FATAL: u32 = 4096;
pub const FOOTPRINT_INTERVAL_RESET: u32 = 1;
pub const IOPOL_TYPE_DISK: u32 = 0;
pub const IOPOL_TYPE_VFS_ATIME_UPDATES: u32 = 2;
pub const IOPOL_TYPE_VFS_MATERIALIZE_DATALESS_FILES: u32 = 3;
pub const IOPOL_TYPE_VFS_STATFS_NO_DATA_VOLUME: u32 = 4;
pub const IOPOL_TYPE_VFS_TRIGGER_RESOLVE: u32 = 5;
pub const IOPOL_TYPE_VFS_IGNORE_CONTENT_PROTECTION: u32 = 6;
pub const IOPOL_TYPE_VFS_IGNORE_PERMISSIONS: u32 = 7;
pub const IOPOL_TYPE_VFS_SKIP_MTIME_UPDATE: u32 = 8;
pub const IOPOL_TYPE_VFS_ALLOW_LOW_SPACE_WRITES: u32 = 9;
pub const IOPOL_SCOPE_PROCESS: u32 = 0;
pub const IOPOL_SCOPE_THREAD: u32 = 1;
pub const IOPOL_SCOPE_DARWIN_BG: u32 = 2;
pub const IOPOL_DEFAULT: u32 = 0;
pub const IOPOL_IMPORTANT: u32 = 1;
pub const IOPOL_PASSIVE: u32 = 2;
pub const IOPOL_THROTTLE: u32 = 3;
pub const IOPOL_UTILITY: u32 = 4;
pub const IOPOL_STANDARD: u32 = 5;
pub const IOPOL_APPLICATION: u32 = 5;
pub const IOPOL_NORMAL: u32 = 1;
pub const IOPOL_ATIME_UPDATES_DEFAULT: u32 = 0;
pub const IOPOL_ATIME_UPDATES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_DEFAULT: u32 = 0;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_ON: u32 = 2;
pub const IOPOL_VFS_STATFS_NO_DATA_VOLUME_DEFAULT: u32 = 0;
pub const IOPOL_VFS_STATFS_FORCE_NO_DATA_VOLUME: u32 = 1;
pub const IOPOL_VFS_TRIGGER_RESOLVE_DEFAULT: u32 = 0;
pub const IOPOL_VFS_TRIGGER_RESOLVE_OFF: u32 = 1;
pub const IOPOL_VFS_CONTENT_PROTECTION_DEFAULT: u32 = 0;
pub const IOPOL_VFS_CONTENT_PROTECTION_IGNORE: u32 = 1;
pub const IOPOL_VFS_IGNORE_PERMISSIONS_OFF: u32 = 0;
pub const IOPOL_VFS_IGNORE_PERMISSIONS_ON: u32 = 1;
pub const IOPOL_VFS_SKIP_MTIME_UPDATE_OFF: u32 = 0;
pub const IOPOL_VFS_SKIP_MTIME_UPDATE_ON: u32 = 1;
pub const IOPOL_VFS_ALLOW_LOW_SPACE_WRITES_OFF: u32 = 0;
pub const IOPOL_VFS_ALLOW_LOW_SPACE_WRITES_ON: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WCOREFLAG: u32 = 128;
pub const _WSTOPPED: u32 = 127;
pub const WEXITED: u32 = 4;
pub const WSTOPPED: u32 = 8;
pub const WCONTINUED: u32 = 16;
pub const WNOWAIT: u32 = 32;
pub const WAIT_ANY: i32 = -1;
pub const WAIT_MYPGRP: u32 = 0;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const RAND_MAX: u32 = 2147483647;
pub const __HAS_FIXED_CHK_PROTOTYPES: u32 = 1;
pub const __GNUC_VA_LIST: u32 = 1;
pub const __DARWIN_FD_SETSIZE: u32 = 1024;
pub const __DARWIN_NBBY: u32 = 8;
pub const NBBY: u32 = 8;
pub const FD_SETSIZE: u32 = 1024;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EDEADLK: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EAGAIN: u32 = 35;
pub const EWOULDBLOCK: u32 = 35;
pub const EINPROGRESS: u32 = 36;
pub const EALREADY: u32 = 37;
pub const ENOTSOCK: u32 = 38;
pub const EDESTADDRREQ: u32 = 39;
pub const EMSGSIZE: u32 = 40;
pub const EPROTOTYPE: u32 = 41;
pub const ENOPROTOOPT: u32 = 42;
pub const EPROTONOSUPPORT: u32 = 43;
pub const ESOCKTNOSUPPORT: u32 = 44;
pub const ENOTSUP: u32 = 45;
pub const EPFNOSUPPORT: u32 = 46;
pub const EAFNOSUPPORT: u32 = 47;
pub const EADDRINUSE: u32 = 48;
pub const EADDRNOTAVAIL: u32 = 49;
pub const ENETDOWN: u32 = 50;
pub const ENETUNREACH: u32 = 51;
pub const ENETRESET: u32 = 52;
pub const ECONNABORTED: u32 = 53;
pub const ECONNRESET: u32 = 54;
pub const ENOBUFS: u32 = 55;
pub const EISCONN: u32 = 56;
pub const ENOTCONN: u32 = 57;
pub const ESHUTDOWN: u32 = 58;
pub const ETOOMANYREFS: u32 = 59;
pub const ETIMEDOUT: u32 = 60;
pub const ECONNREFUSED: u32 = 61;
pub const ELOOP: u32 = 62;
pub const ENAMETOOLONG: u32 = 63;
pub const EHOSTDOWN: u32 = 64;
pub const EHOSTUNREACH: u32 = 65;
pub const ENOTEMPTY: u32 = 66;
pub const EPROCLIM: u32 = 67;
pub const EUSERS: u32 = 68;
pub const EDQUOT: u32 = 69;
pub const ESTALE: u32 = 70;
pub const EREMOTE: u32 = 71;
pub const EBADRPC: u32 = 72;
pub const ERPCMISMATCH: u32 = 73;
pub const EPROGUNAVAIL: u32 = 74;
pub const EPROGMISMATCH: u32 = 75;
pub const EPROCUNAVAIL: u32 = 76;
pub const ENOLCK: u32 = 77;
pub const ENOSYS: u32 = 78;
pub const EFTYPE: u32 = 79;
pub const EAUTH: u32 = 80;
pub const ENEEDAUTH: u32 = 81;
pub const EPWROFF: u32 = 82;
pub const EDEVERR: u32 = 83;
pub const EOVERFLOW: u32 = 84;
pub const EBADEXEC: u32 = 85;
pub const EBADARCH: u32 = 86;
pub const ESHLIBVERS: u32 = 87;
pub const EBADMACHO: u32 = 88;
pub const ECANCELED: u32 = 89;
pub const EIDRM: u32 = 90;
pub const ENOMSG: u32 = 91;
pub const EILSEQ: u32 = 92;
pub const ENOATTR: u32 = 93;
pub const EBADMSG: u32 = 94;
pub const EMULTIHOP: u32 = 95;
pub const ENODATA: u32 = 96;
pub const ENOLINK: u32 = 97;
pub const ENOSR: u32 = 98;
pub const ENOSTR: u32 = 99;
pub const EPROTO: u32 = 100;
pub const ETIME: u32 = 101;
pub const EOPNOTSUPP: u32 = 102;
pub const ENOPOLICY: u32 = 103;
pub const ENOTRECOVERABLE: u32 = 104;
pub const EOWNERDEAD: u32 = 105;
pub const EQFULL: u32 = 106;
pub const ELAST: u32 = 106;
pub const LC_ALL: u32 = 0;
pub const LC_COLLATE: u32 = 1;
pub const LC_CTYPE: u32 = 2;
pub const LC_MONETARY: u32 = 3;
pub const LC_NUMERIC: u32 = 4;
pub const LC_TIME: u32 = 5;
pub const LC_MESSAGES: u32 = 6;
pub const _LC_LAST: u32 = 7;
pub const HAVE_PG_ATTRIBUTE_NORETURN: u32 = 1;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const INT64_FORMAT: &[u8; 4usize] = b"%ld\0";
pub const UINT64_FORMAT: &[u8; 4usize] = b"%lu\0";
pub const HAVE_INT128: u32 = 1;
pub const PG_INT8_MIN: i32 = -128;
pub const PG_INT8_MAX: u32 = 127;
pub const PG_UINT8_MAX: u32 = 255;
pub const PG_INT16_MIN: i32 = -32768;
pub const PG_INT16_MAX: u32 = 32767;
pub const PG_UINT16_MAX: u32 = 65535;
pub const PG_INT32_MIN: i32 = -2147483648;
pub const PG_INT32_MAX: u32 = 2147483647;
pub const PG_UINT32_MAX: u32 = 4294967295;
pub const FLOAT8PASSBYVAL: u32 = 1;
pub const HAVE_UNIX_SOCKETS: u32 = 1;
pub const HIGHBIT: u32 = 128;
pub const ESCAPE_STRING_SYNTAX: u8 = 69u8;
pub const STATUS_OK: u32 = 0;
pub const STATUS_ERROR: i32 = -1;
pub const STATUS_EOF: i32 = -2;
pub const PG_BINARY: u32 = 0;
pub const PG_BINARY_A: &[u8; 2usize] = b"a\0";
pub const PG_BINARY_R: &[u8; 2usize] = b"r\0";
pub const PG_BINARY_W: &[u8; 2usize] = b"w\0";
pub const _CACHED_RUNES: u32 = 256;
pub const _CRMASK: i32 = -256;
pub const _RUNE_MAGIC_A: &[u8; 9usize] = b"RuneMagA\0";
pub const _CTYPE_A: u32 = 256;
pub const _CTYPE_C: u32 = 512;
pub const _CTYPE_D: u32 = 1024;
pub const _CTYPE_G: u32 = 2048;
pub const _CTYPE_L: u32 = 4096;
pub const _CTYPE_P: u32 = 8192;
pub const _CTYPE_S: u32 = 16384;
pub const _CTYPE_U: u32 = 32768;
pub const _CTYPE_X: u32 = 65536;
pub const _CTYPE_B: u32 = 131072;
pub const _CTYPE_R: u32 = 262144;
pub const _CTYPE_I: u32 = 524288;
pub const _CTYPE_T: u32 = 1048576;
pub const _CTYPE_Q: u32 = 2097152;
pub const _CTYPE_SW0: u32 = 536870912;
pub const _CTYPE_SW1: u32 = 1073741824;
pub const _CTYPE_SW2: u32 = 2147483648;
pub const _CTYPE_SW3: u32 = 3221225472;
pub const _CTYPE_SWM: u32 = 3758096384;
pub const _CTYPE_SWS: u32 = 30;
pub const KEV_INET_SUBCLASS: u32 = 1;
pub const KEV_INET_NEW_ADDR: u32 = 1;
pub const KEV_INET_CHANGED_ADDR: u32 = 2;
pub const KEV_INET_ADDR_DELETED: u32 = 3;
pub const KEV_INET_SIFDSTADDR: u32 = 4;
pub const KEV_INET_SIFBRDADDR: u32 = 5;
pub const KEV_INET_SIFNETMASK: u32 = 6;
pub const KEV_INET_ARPCOLLISION: u32 = 7;
pub const KEV_INET_PORTINUSE: u32 = 8;
pub const KEV_INET_ARPRTRFAILURE: u32 = 9;
pub const KEV_INET_ARPRTRALIVE: u32 = 10;
pub const KEV_DL_SUBCLASS: u32 = 2;
pub const KEV_DL_SIFFLAGS: u32 = 1;
pub const KEV_DL_SIFMETRICS: u32 = 2;
pub const KEV_DL_SIFMTU: u32 = 3;
pub const KEV_DL_SIFPHYS: u32 = 4;
pub const KEV_DL_SIFMEDIA: u32 = 5;
pub const KEV_DL_SIFGENERIC: u32 = 6;
pub const KEV_DL_ADDMULTI: u32 = 7;
pub const KEV_DL_DELMULTI: u32 = 8;
pub const KEV_DL_IF_ATTACHED: u32 = 9;
pub const KEV_DL_IF_DETACHING: u32 = 10;
pub const KEV_DL_IF_DETACHED: u32 = 11;
pub const KEV_DL_LINK_OFF: u32 = 12;
pub const KEV_DL_LINK_ON: u32 = 13;
pub const KEV_DL_PROTO_ATTACHED: u32 = 14;
pub const KEV_DL_PROTO_DETACHED: u32 = 15;
pub const KEV_DL_LINK_ADDRESS_CHANGED: u32 = 16;
pub const KEV_DL_WAKEFLAGS_CHANGED: u32 = 17;
pub const KEV_DL_IF_IDLE_ROUTE_REFCNT: u32 = 18;
pub const KEV_DL_IFCAP_CHANGED: u32 = 19;
pub const KEV_DL_LINK_QUALITY_METRIC_CHANGED: u32 = 20;
pub const KEV_DL_NODE_PRESENCE: u32 = 21;
pub const KEV_DL_NODE_ABSENCE: u32 = 22;
pub const KEV_DL_PRIMARY_ELECTED: u32 = 23;
pub const KEV_DL_ISSUES: u32 = 24;
pub const KEV_DL_IFDELEGATE_CHANGED: u32 = 25;
pub const KEV_DL_AWDL_RESTRICTED: u32 = 26;
pub const KEV_DL_AWDL_UNRESTRICTED: u32 = 27;
pub const KEV_DL_RRC_STATE_CHANGED: u32 = 28;
pub const KEV_DL_QOS_MODE_CHANGED: u32 = 29;
pub const KEV_DL_LOW_POWER_MODE_CHANGED: u32 = 30;
pub const KEV_INET6_SUBCLASS: u32 = 6;
pub const KEV_INET6_NEW_USER_ADDR: u32 = 1;
pub const KEV_INET6_CHANGED_ADDR: u32 = 2;
pub const KEV_INET6_ADDR_DELETED: u32 = 3;
pub const KEV_INET6_NEW_LL_ADDR: u32 = 4;
pub const KEV_INET6_NEW_RTADV_ADDR: u32 = 5;
pub const KEV_INET6_DEFROUTER: u32 = 6;
pub const KEV_INET6_REQUEST_NAT64_PREFIX: u32 = 7;
pub const SOCK_STREAM: u32 = 1;
pub const SOCK_DGRAM: u32 = 2;
pub const SOCK_RAW: u32 = 3;
pub const SOCK_RDM: u32 = 4;
pub const SOCK_SEQPACKET: u32 = 5;
pub const SO_DEBUG: u32 = 1;
pub const SO_ACCEPTCONN: u32 = 2;
pub const SO_REUSEADDR: u32 = 4;
pub const SO_KEEPALIVE: u32 = 8;
pub const SO_DONTROUTE: u32 = 16;
pub const SO_BROADCAST: u32 = 32;
pub const SO_USELOOPBACK: u32 = 64;
pub const SO_LINGER: u32 = 128;
pub const SO_OOBINLINE: u32 = 256;
pub const SO_REUSEPORT: u32 = 512;
pub const SO_TIMESTAMP: u32 = 1024;
pub const SO_TIMESTAMP_MONOTONIC: u32 = 2048;
pub const SO_DONTTRUNC: u32 = 8192;
pub const SO_WANTMORE: u32 = 16384;
pub const SO_WANTOOBFLAG: u32 = 32768;
pub const SO_SNDBUF: u32 = 4097;
pub const SO_RCVBUF: u32 = 4098;
pub const SO_SNDLOWAT: u32 = 4099;
pub const SO_RCVLOWAT: u32 = 4100;
pub const SO_SNDTIMEO: u32 = 4101;
pub const SO_RCVTIMEO: u32 = 4102;
pub const SO_ERROR: u32 = 4103;
pub const SO_TYPE: u32 = 4104;
pub const SO_LABEL: u32 = 4112;
pub const SO_PEERLABEL: u32 = 4113;
pub const SO_NREAD: u32 = 4128;
pub const SO_NKE: u32 = 4129;
pub const SO_NOSIGPIPE: u32 = 4130;
pub const SO_NOADDRERR: u32 = 4131;
pub const SO_NWRITE: u32 = 4132;
pub const SO_REUSESHAREUID: u32 = 4133;
pub const SO_NOTIFYCONFLICT: u32 = 4134;
pub const SO_UPCALLCLOSEWAIT: u32 = 4135;
pub const SO_LINGER_SEC: u32 = 4224;
pub const SO_RANDOMPORT: u32 = 4226;
pub const SO_NP_EXTENSIONS: u32 = 4227;
pub const SO_NUMRCVPKT: u32 = 4370;
pub const SO_NET_SERVICE_TYPE: u32 = 4374;
pub const SO_NETSVC_MARKING_LEVEL: u32 = 4377;
pub const NET_SERVICE_TYPE_BE: u32 = 0;
pub const NET_SERVICE_TYPE_BK: u32 = 1;
pub const NET_SERVICE_TYPE_SIG: u32 = 2;
pub const NET_SERVICE_TYPE_VI: u32 = 3;
pub const NET_SERVICE_TYPE_VO: u32 = 4;
pub const NET_SERVICE_TYPE_RV: u32 = 5;
pub const NET_SERVICE_TYPE_AV: u32 = 6;
pub const NET_SERVICE_TYPE_OAM: u32 = 7;
pub const NET_SERVICE_TYPE_RD: u32 = 8;
pub const NETSVC_MRKNG_UNKNOWN: u32 = 0;
pub const NETSVC_MRKNG_LVL_L2: u32 = 1;
pub const NETSVC_MRKNG_LVL_L3L2_ALL: u32 = 2;
pub const NETSVC_MRKNG_LVL_L3L2_BK: u32 = 3;
pub const SAE_ASSOCID_ANY: u32 = 0;
pub const SAE_CONNID_ANY: u32 = 0;
pub const CONNECT_RESUME_ON_READ_WRITE: u32 = 1;
pub const CONNECT_DATA_IDEMPOTENT: u32 = 2;
pub const CONNECT_DATA_AUTHENTICATED: u32 = 4;
pub const SONPX_SETOPTSHUT: u32 = 1;
pub const SOL_SOCKET: u32 = 65535;
pub const AF_UNSPEC: u32 = 0;
pub const AF_UNIX: u32 = 1;
pub const AF_LOCAL: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_IMPLINK: u32 = 3;
pub const AF_PUP: u32 = 4;
pub const AF_CHAOS: u32 = 5;
pub const AF_NS: u32 = 6;
pub const AF_ISO: u32 = 7;
pub const AF_OSI: u32 = 7;
pub const AF_ECMA: u32 = 8;
pub const AF_DATAKIT: u32 = 9;
pub const AF_CCITT: u32 = 10;
pub const AF_SNA: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_DLI: u32 = 13;
pub const AF_LAT: u32 = 14;
pub const AF_HYLINK: u32 = 15;
pub const AF_APPLETALK: u32 = 16;
pub const AF_ROUTE: u32 = 17;
pub const AF_LINK: u32 = 18;
pub const pseudo_AF_XTP: u32 = 19;
pub const AF_COIP: u32 = 20;
pub const AF_CNT: u32 = 21;
pub const pseudo_AF_RTIP: u32 = 22;
pub const AF_IPX: u32 = 23;
pub const AF_SIP: u32 = 24;
pub const pseudo_AF_PIP: u32 = 25;
pub const AF_NDRV: u32 = 27;
pub const AF_ISDN: u32 = 28;
pub const AF_E164: u32 = 28;
pub const pseudo_AF_KEY: u32 = 29;
pub const AF_INET6: u32 = 30;
pub const AF_NATM: u32 = 31;
pub const AF_SYSTEM: u32 = 32;
pub const AF_NETBIOS: u32 = 33;
pub const AF_PPP: u32 = 34;
pub const pseudo_AF_HDRCMPLT: u32 = 35;
pub const AF_RESERVED_36: u32 = 36;
pub const AF_IEEE80211: u32 = 37;
pub const AF_UTUN: u32 = 38;
pub const AF_VSOCK: u32 = 40;
pub const AF_MAX: u32 = 41;
pub const SOCK_MAXADDRLEN: u32 = 255;
pub const _SS_MAXSIZE: u32 = 128;
pub const PF_UNSPEC: u32 = 0;
pub const PF_LOCAL: u32 = 1;
pub const PF_UNIX: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_IMPLINK: u32 = 3;
pub const PF_PUP: u32 = 4;
pub const PF_CHAOS: u32 = 5;
pub const PF_NS: u32 = 6;
pub const PF_ISO: u32 = 7;
pub const PF_OSI: u32 = 7;
pub const PF_ECMA: u32 = 8;
pub const PF_DATAKIT: u32 = 9;
pub const PF_CCITT: u32 = 10;
pub const PF_SNA: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_DLI: u32 = 13;
pub const PF_LAT: u32 = 14;
pub const PF_HYLINK: u32 = 15;
pub const PF_APPLETALK: u32 = 16;
pub const PF_ROUTE: u32 = 17;
pub const PF_LINK: u32 = 18;
pub const PF_XTP: u32 = 19;
pub const PF_COIP: u32 = 20;
pub const PF_CNT: u32 = 21;
pub const PF_SIP: u32 = 24;
pub const PF_IPX: u32 = 23;
pub const PF_RTIP: u32 = 22;
pub const PF_PIP: u32 = 25;
pub const PF_NDRV: u32 = 27;
pub const PF_ISDN: u32 = 28;
pub const PF_KEY: u32 = 29;
pub const PF_INET6: u32 = 30;
pub const PF_NATM: u32 = 31;
pub const PF_SYSTEM: u32 = 32;
pub const PF_NETBIOS: u32 = 33;
pub const PF_PPP: u32 = 34;
pub const PF_RESERVED_36: u32 = 36;
pub const PF_UTUN: u32 = 38;
pub const PF_VSOCK: u32 = 40;
pub const PF_MAX: u32 = 41;
pub const NET_MAXID: u32 = 41;
pub const NET_RT_DUMP: u32 = 1;
pub const NET_RT_FLAGS: u32 = 2;
pub const NET_RT_IFLIST: u32 = 3;
pub const NET_RT_STAT: u32 = 4;
pub const NET_RT_TRASH: u32 = 5;
pub const NET_RT_IFLIST2: u32 = 6;
pub const NET_RT_DUMP2: u32 = 7;
pub const NET_RT_FLAGS_PRIV: u32 = 10;
pub const NET_RT_MAXID: u32 = 11;
pub const SOMAXCONN: u32 = 128;
pub const MSG_OOB: u32 = 1;
pub const MSG_PEEK: u32 = 2;
pub const MSG_DONTROUTE: u32 = 4;
pub const MSG_EOR: u32 = 8;
pub const MSG_TRUNC: u32 = 16;
pub const MSG_CTRUNC: u32 = 32;
pub const MSG_WAITALL: u32 = 64;
pub const MSG_DONTWAIT: u32 = 128;
pub const MSG_EOF: u32 = 256;
pub const MSG_WAITSTREAM: u32 = 512;
pub const MSG_FLUSH: u32 = 1024;
pub const MSG_HOLD: u32 = 2048;
pub const MSG_SEND: u32 = 4096;
pub const MSG_HAVEMORE: u32 = 8192;
pub const MSG_RCVMORE: u32 = 16384;
pub const MSG_NEEDSA: u32 = 65536;
pub const MSG_NOSIGNAL: u32 = 524288;
pub const SCM_RIGHTS: u32 = 1;
pub const SCM_TIMESTAMP: u32 = 2;
pub const SCM_CREDS: u32 = 3;
pub const SCM_TIMESTAMP_MONOTONIC: u32 = 4;
pub const SHUT_RD: u32 = 0;
pub const SHUT_WR: u32 = 1;
pub const SHUT_RDWR: u32 = 2;
pub const IPPROTO_IP: u32 = 0;
pub const IPPROTO_HOPOPTS: u32 = 0;
pub const IPPROTO_ICMP: u32 = 1;
pub const IPPROTO_IGMP: u32 = 2;
pub const IPPROTO_GGP: u32 = 3;
pub const IPPROTO_IPV4: u32 = 4;
pub const IPPROTO_IPIP: u32 = 4;
pub const IPPROTO_TCP: u32 = 6;
pub const IPPROTO_ST: u32 = 7;
pub const IPPROTO_EGP: u32 = 8;
pub const IPPROTO_PIGP: u32 = 9;
pub const IPPROTO_RCCMON: u32 = 10;
pub const IPPROTO_NVPII: u32 = 11;
pub const IPPROTO_PUP: u32 = 12;
pub const IPPROTO_ARGUS: u32 = 13;
pub const IPPROTO_EMCON: u32 = 14;
pub const IPPROTO_XNET: u32 = 15;
pub const IPPROTO_CHAOS: u32 = 16;
pub const IPPROTO_UDP: u32 = 17;
pub const IPPROTO_MUX: u32 = 18;
pub const IPPROTO_MEAS: u32 = 19;
pub const IPPROTO_HMP: u32 = 20;
pub const IPPROTO_PRM: u32 = 21;
pub const IPPROTO_IDP: u32 = 22;
pub const IPPROTO_TRUNK1: u32 = 23;
pub const IPPROTO_TRUNK2: u32 = 24;
pub const IPPROTO_LEAF1: u32 = 25;
pub const IPPROTO_LEAF2: u32 = 26;
pub const IPPROTO_RDP: u32 = 27;
pub const IPPROTO_IRTP: u32 = 28;
pub const IPPROTO_TP: u32 = 29;
pub const IPPROTO_BLT: u32 = 30;
pub const IPPROTO_NSP: u32 = 31;
pub const IPPROTO_INP: u32 = 32;
pub const IPPROTO_SEP: u32 = 33;
pub const IPPROTO_3PC: u32 = 34;
pub const IPPROTO_IDPR: u32 = 35;
pub const IPPROTO_XTP: u32 = 36;
pub const IPPROTO_DDP: u32 = 37;
pub const IPPROTO_CMTP: u32 = 38;
pub const IPPROTO_TPXX: u32 = 39;
pub const IPPROTO_IL: u32 = 40;
pub const IPPROTO_IPV6: u32 = 41;
pub const IPPROTO_SDRP: u32 = 42;
pub const IPPROTO_ROUTING: u32 = 43;
pub const IPPROTO_FRAGMENT: u32 = 44;
pub const IPPROTO_IDRP: u32 = 45;
pub const IPPROTO_RSVP: u32 = 46;
pub const IPPROTO_GRE: u32 = 47;
pub const IPPROTO_MHRP: u32 = 48;
pub const IPPROTO_BHA: u32 = 49;
pub const IPPROTO_ESP: u32 = 50;
pub const IPPROTO_AH: u32 = 51;
pub const IPPROTO_INLSP: u32 = 52;
pub const IPPROTO_SWIPE: u32 = 53;
pub const IPPROTO_NHRP: u32 = 54;
pub const IPPROTO_ICMPV6: u32 = 58;
pub const IPPROTO_NONE: u32 = 59;
pub const IPPROTO_DSTOPTS: u32 = 60;
pub const IPPROTO_AHIP: u32 = 61;
pub const IPPROTO_CFTP: u32 = 62;
pub const IPPROTO_HELLO: u32 = 63;
pub const IPPROTO_SATEXPAK: u32 = 64;
pub const IPPROTO_KRYPTOLAN: u32 = 65;
pub const IPPROTO_RVD: u32 = 66;
pub const IPPROTO_IPPC: u32 = 67;
pub const IPPROTO_ADFS: u32 = 68;
pub const IPPROTO_SATMON: u32 = 69;
pub const IPPROTO_VISA: u32 = 70;
pub const IPPROTO_IPCV: u32 = 71;
pub const IPPROTO_CPNX: u32 = 72;
pub const IPPROTO_CPHB: u32 = 73;
pub const IPPROTO_WSN: u32 = 74;
pub const IPPROTO_PVP: u32 = 75;
pub const IPPROTO_BRSATMON: u32 = 76;
pub const IPPROTO_ND: u32 = 77;
pub const IPPROTO_WBMON: u32 = 78;
pub const IPPROTO_WBEXPAK: u32 = 79;
pub const IPPROTO_EON: u32 = 80;
pub const IPPROTO_VMTP: u32 = 81;
pub const IPPROTO_SVMTP: u32 = 82;
pub const IPPROTO_VINES: u32 = 83;
pub const IPPROTO_TTP: u32 = 84;
pub const IPPROTO_IGP: u32 = 85;
pub const IPPROTO_DGP: u32 = 86;
pub const IPPROTO_TCF: u32 = 87;
pub const IPPROTO_IGRP: u32 = 88;
pub const IPPROTO_OSPFIGP: u32 = 89;
pub const IPPROTO_SRPC: u32 = 90;
pub const IPPROTO_LARP: u32 = 91;
pub const IPPROTO_MTP: u32 = 92;
pub const IPPROTO_AX25: u32 = 93;
pub const IPPROTO_IPEIP: u32 = 94;
pub const IPPROTO_MICP: u32 = 95;
pub const IPPROTO_SCCSP: u32 = 96;
pub const IPPROTO_ETHERIP: u32 = 97;
pub const IPPROTO_ENCAP: u32 = 98;
pub const IPPROTO_APES: u32 = 99;
pub const IPPROTO_GMTP: u32 = 100;
pub const IPPROTO_PIM: u32 = 103;
pub const IPPROTO_IPCOMP: u32 = 108;
pub const IPPROTO_PGM: u32 = 113;
pub const IPPROTO_SCTP: u32 = 132;
pub const IPPROTO_DIVERT: u32 = 254;
pub const IPPROTO_RAW: u32 = 255;
pub const IPPROTO_MAX: u32 = 256;
pub const IPPROTO_DONE: u32 = 257;
pub const __DARWIN_IPPORT_RESERVED: u32 = 1024;
pub const IPPORT_USERRESERVED: u32 = 5000;
pub const IPPORT_HIFIRSTAUTO: u32 = 49152;
pub const IPPORT_HILASTAUTO: u32 = 65535;
pub const IPPORT_RESERVEDSTART: u32 = 600;
pub const IN_CLASSA_NET: u32 = 4278190080;
pub const IN_CLASSA_NSHIFT: u32 = 24;
pub const IN_CLASSA_HOST: u32 = 16777215;
pub const IN_CLASSA_MAX: u32 = 128;
pub const IN_CLASSB_NET: u32 = 4294901760;
pub const IN_CLASSB_NSHIFT: u32 = 16;
pub const IN_CLASSB_HOST: u32 = 65535;
pub const IN_CLASSB_MAX: u32 = 65536;
pub const IN_CLASSC_NET: u32 = 4294967040;
pub const IN_CLASSC_NSHIFT: u32 = 8;
pub const IN_CLASSC_HOST: u32 = 255;
pub const IN_CLASSD_NET: u32 = 4026531840;
pub const IN_CLASSD_NSHIFT: u32 = 28;
pub const IN_CLASSD_HOST: u32 = 268435455;
pub const INADDR_NONE: u32 = 4294967295;
pub const IN_LOOPBACKNET: u32 = 127;
pub const INET_ADDRSTRLEN: u32 = 16;
pub const IP_OPTIONS: u32 = 1;
pub const IP_HDRINCL: u32 = 2;
pub const IP_TOS: u32 = 3;
pub const IP_TTL: u32 = 4;
pub const IP_RECVOPTS: u32 = 5;
pub const IP_RECVRETOPTS: u32 = 6;
pub const IP_RECVDSTADDR: u32 = 7;
pub const IP_RETOPTS: u32 = 8;
pub const IP_MULTICAST_IF: u32 = 9;
pub const IP_MULTICAST_TTL: u32 = 10;
pub const IP_MULTICAST_LOOP: u32 = 11;
pub const IP_ADD_MEMBERSHIP: u32 = 12;
pub const IP_DROP_MEMBERSHIP: u32 = 13;
pub const IP_MULTICAST_VIF: u32 = 14;
pub const IP_RSVP_ON: u32 = 15;
pub const IP_RSVP_OFF: u32 = 16;
pub const IP_RSVP_VIF_ON: u32 = 17;
pub const IP_RSVP_VIF_OFF: u32 = 18;
pub const IP_PORTRANGE: u32 = 19;
pub const IP_RECVIF: u32 = 20;
pub const IP_IPSEC_POLICY: u32 = 21;
pub const IP_FAITH: u32 = 22;
pub const IP_STRIPHDR: u32 = 23;
pub const IP_RECVTTL: u32 = 24;
pub const IP_BOUND_IF: u32 = 25;
pub const IP_PKTINFO: u32 = 26;
pub const IP_RECVPKTINFO: u32 = 26;
pub const IP_RECVTOS: u32 = 27;
pub const IP_DONTFRAG: u32 = 28;
pub const IP_FW_ADD: u32 = 40;
pub const IP_FW_DEL: u32 = 41;
pub const IP_FW_FLUSH: u32 = 42;
pub const IP_FW_ZERO: u32 = 43;
pub const IP_FW_GET: u32 = 44;
pub const IP_FW_RESETLOG: u32 = 45;
pub const IP_OLD_FW_ADD: u32 = 50;
pub const IP_OLD_FW_DEL: u32 = 51;
pub const IP_OLD_FW_FLUSH: u32 = 52;
pub const IP_OLD_FW_ZERO: u32 = 53;
pub const IP_OLD_FW_GET: u32 = 54;
pub const IP_NAT__XXX: u32 = 55;
pub const IP_OLD_FW_RESETLOG: u32 = 56;
pub const IP_DUMMYNET_CONFIGURE: u32 = 60;
pub const IP_DUMMYNET_DEL: u32 = 61;
pub const IP_DUMMYNET_FLUSH: u32 = 62;
pub const IP_DUMMYNET_GET: u32 = 64;
pub const IP_TRAFFIC_MGT_BACKGROUND: u32 = 65;
pub const IP_MULTICAST_IFINDEX: u32 = 66;
pub const IP_ADD_SOURCE_MEMBERSHIP: u32 = 70;
pub const IP_DROP_SOURCE_MEMBERSHIP: u32 = 71;
pub const IP_BLOCK_SOURCE: u32 = 72;
pub const IP_UNBLOCK_SOURCE: u32 = 73;
pub const IP_MSFILTER: u32 = 74;
pub const MCAST_JOIN_GROUP: u32 = 80;
pub const MCAST_LEAVE_GROUP: u32 = 81;
pub const MCAST_JOIN_SOURCE_GROUP: u32 = 82;
pub const MCAST_LEAVE_SOURCE_GROUP: u32 = 83;
pub const MCAST_BLOCK_SOURCE: u32 = 84;
pub const MCAST_UNBLOCK_SOURCE: u32 = 85;
pub const IP_DEFAULT_MULTICAST_TTL: u32 = 1;
pub const IP_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IP_MIN_MEMBERSHIPS: u32 = 31;
pub const IP_MAX_MEMBERSHIPS: u32 = 4095;
pub const IP_MAX_GROUP_SRC_FILTER: u32 = 512;
pub const IP_MAX_SOCK_SRC_FILTER: u32 = 128;
pub const IP_MAX_SOCK_MUTE_FILTER: u32 = 128;
pub const MCAST_UNDEFINED: u32 = 0;
pub const MCAST_INCLUDE: u32 = 1;
pub const MCAST_EXCLUDE: u32 = 2;
pub const IP_PORTRANGE_DEFAULT: u32 = 0;
pub const IP_PORTRANGE_HIGH: u32 = 1;
pub const IP_PORTRANGE_LOW: u32 = 2;
pub const IPPROTO_MAXID: u32 = 52;
pub const IPCTL_FORWARDING: u32 = 1;
pub const IPCTL_SENDREDIRECTS: u32 = 2;
pub const IPCTL_DEFTTL: u32 = 3;
pub const IPCTL_RTEXPIRE: u32 = 5;
pub const IPCTL_RTMINEXPIRE: u32 = 6;
pub const IPCTL_RTMAXCACHE: u32 = 7;
pub const IPCTL_SOURCEROUTE: u32 = 8;
pub const IPCTL_DIRECTEDBROADCAST: u32 = 9;
pub const IPCTL_INTRQMAXLEN: u32 = 10;
pub const IPCTL_INTRQDROPS: u32 = 11;
pub const IPCTL_STATS: u32 = 12;
pub const IPCTL_ACCEPTSOURCEROUTE: u32 = 13;
pub const IPCTL_FASTFORWARDING: u32 = 14;
pub const IPCTL_KEEPFAITH: u32 = 15;
pub const IPCTL_GIF_TTL: u32 = 16;
pub const IPCTL_MAXID: u32 = 17;
pub const __KAME_VERSION: &[u8; 18usize] = b"2009/apple-darwin\0";
pub const IPV6PORT_RESERVED: u32 = 1024;
pub const IPV6PORT_ANONMIN: u32 = 49152;
pub const IPV6PORT_ANONMAX: u32 = 65535;
pub const IPV6PORT_RESERVEDMIN: u32 = 600;
pub const IPV6PORT_RESERVEDMAX: u32 = 1023;
pub const INET6_ADDRSTRLEN: u32 = 46;
pub const __IPV6_ADDR_SCOPE_NODELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_INTFACELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_LINKLOCAL: u32 = 2;
pub const __IPV6_ADDR_SCOPE_SITELOCAL: u32 = 5;
pub const __IPV6_ADDR_SCOPE_ORGLOCAL: u32 = 8;
pub const __IPV6_ADDR_SCOPE_GLOBAL: u32 = 14;
pub const IPV6_ADDR_MC_FLAGS_TRANSIENT: u32 = 16;
pub const IPV6_ADDR_MC_FLAGS_PREFIX: u32 = 32;
pub const IPV6_ADDR_MC_FLAGS_UNICAST_BASED: u32 = 48;
pub const IPV6_SOCKOPT_RESERVED1: u32 = 3;
pub const IPV6_UNICAST_HOPS: u32 = 4;
pub const IPV6_MULTICAST_IF: u32 = 9;
pub const IPV6_MULTICAST_HOPS: u32 = 10;
pub const IPV6_MULTICAST_LOOP: u32 = 11;
pub const IPV6_JOIN_GROUP: u32 = 12;
pub const IPV6_LEAVE_GROUP: u32 = 13;
pub const IPV6_PORTRANGE: u32 = 14;
pub const ICMP6_FILTER: u32 = 18;
pub const IPV6_2292PKTINFO: u32 = 19;
pub const IPV6_2292HOPLIMIT: u32 = 20;
pub const IPV6_2292NEXTHOP: u32 = 21;
pub const IPV6_2292HOPOPTS: u32 = 22;
pub const IPV6_2292DSTOPTS: u32 = 23;
pub const IPV6_2292RTHDR: u32 = 24;
pub const IPV6_2292PKTOPTIONS: u32 = 25;
pub const IPV6_CHECKSUM: u32 = 26;
pub const IPV6_V6ONLY: u32 = 27;
pub const IPV6_BINDV6ONLY: u32 = 27;
pub const IPV6_IPSEC_POLICY: u32 = 28;
pub const IPV6_FAITH: u32 = 29;
pub const IPV6_FW_ADD: u32 = 30;
pub const IPV6_FW_DEL: u32 = 31;
pub const IPV6_FW_FLUSH: u32 = 32;
pub const IPV6_FW_ZERO: u32 = 33;
pub const IPV6_FW_GET: u32 = 34;
pub const IPV6_RECVTCLASS: u32 = 35;
pub const IPV6_TCLASS: u32 = 36;
pub const IPV6_BOUND_IF: u32 = 125;
pub const IPV6_RTHDR_LOOSE: u32 = 0;
pub const IPV6_RTHDR_STRICT: u32 = 1;
pub const IPV6_RTHDR_TYPE_0: u32 = 0;
pub const IPV6_DEFAULT_MULTICAST_HOPS: u32 = 1;
pub const IPV6_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IPV6_MIN_MEMBERSHIPS: u32 = 31;
pub const IPV6_MAX_MEMBERSHIPS: u32 = 4095;
pub const IPV6_MAX_GROUP_SRC_FILTER: u32 = 512;
pub const IPV6_MAX_SOCK_SRC_FILTER: u32 = 128;
pub const IPV6_PORTRANGE_DEFAULT: u32 = 0;
pub const IPV6_PORTRANGE_HIGH: u32 = 1;
pub const IPV6_PORTRANGE_LOW: u32 = 2;
pub const IPV6PROTO_MAXID: u32 = 104;
pub const IPV6CTL_FORWARDING: u32 = 1;
pub const IPV6CTL_SENDREDIRECTS: u32 = 2;
pub const IPV6CTL_DEFHLIM: u32 = 3;
pub const IPV6CTL_FORWSRCRT: u32 = 5;
pub const IPV6CTL_STATS: u32 = 6;
pub const IPV6CTL_MRTSTATS: u32 = 7;
pub const IPV6CTL_MRTPROTO: u32 = 8;
pub const IPV6CTL_MAXFRAGPACKETS: u32 = 9;
pub const IPV6CTL_SOURCECHECK: u32 = 10;
pub const IPV6CTL_SOURCECHECK_LOGINT: u32 = 11;
pub const IPV6CTL_ACCEPT_RTADV: u32 = 12;
pub const IPV6CTL_KEEPFAITH: u32 = 13;
pub const IPV6CTL_LOG_INTERVAL: u32 = 14;
pub const IPV6CTL_HDRNESTLIMIT: u32 = 15;
pub const IPV6CTL_DAD_COUNT: u32 = 16;
pub const IPV6CTL_AUTO_FLOWLABEL: u32 = 17;
pub const IPV6CTL_DEFMCASTHLIM: u32 = 18;
pub const IPV6CTL_GIF_HLIM: u32 = 19;
pub const IPV6CTL_KAME_VERSION: u32 = 20;
pub const IPV6CTL_USE_DEPRECATED: u32 = 21;
pub const IPV6CTL_RR_PRUNE: u32 = 22;
pub const IPV6CTL_V6ONLY: u32 = 24;
pub const IPV6CTL_RTEXPIRE: u32 = 25;
pub const IPV6CTL_RTMINEXPIRE: u32 = 26;
pub const IPV6CTL_RTMAXCACHE: u32 = 27;
pub const IPV6CTL_USETEMPADDR: u32 = 32;
pub const IPV6CTL_TEMPPLTIME: u32 = 33;
pub const IPV6CTL_TEMPVLTIME: u32 = 34;
pub const IPV6CTL_AUTO_LINKLOCAL: u32 = 35;
pub const IPV6CTL_RIP6STATS: u32 = 36;
pub const IPV6CTL_PREFER_TEMPADDR: u32 = 37;
pub const IPV6CTL_ADDRCTLPOLICY: u32 = 38;
pub const IPV6CTL_USE_DEFAULTZONE: u32 = 39;
pub const IPV6CTL_MAXFRAGS: u32 = 41;
pub const IPV6CTL_MCAST_PMTU: u32 = 44;
pub const IPV6CTL_NEIGHBORGCTHRESH: u32 = 46;
pub const IPV6CTL_MAXIFPREFIXES: u32 = 47;
pub const IPV6CTL_MAXIFDEFROUTERS: u32 = 48;
pub const IPV6CTL_MAXDYNROUTES: u32 = 49;
pub const ICMPV6CTL_ND6_ONLINKNSRFC4861: u32 = 50;
pub const IPV6CTL_ULA_USETEMPADDR: u32 = 51;
pub const IPV6CTL_MAXID: u32 = 51;
pub const _PATH_HEQUIV: &[u8; 17usize] = b"/etc/hosts.equiv\0";
pub const _PATH_HOSTS: &[u8; 11usize] = b"/etc/hosts\0";
pub const _PATH_NETWORKS: &[u8; 14usize] = b"/etc/networks\0";
pub const _PATH_PROTOCOLS: &[u8; 15usize] = b"/etc/protocols\0";
pub const _PATH_SERVICES: &[u8; 14usize] = b"/etc/services\0";
pub const NETDB_INTERNAL: i32 = -1;
pub const NETDB_SUCCESS: u32 = 0;
pub const HOST_NOT_FOUND: u32 = 1;
pub const TRY_AGAIN: u32 = 2;
pub const NO_RECOVERY: u32 = 3;
pub const NO_DATA: u32 = 4;
pub const NO_ADDRESS: u32 = 4;
pub const EAI_ADDRFAMILY: u32 = 1;
pub const EAI_AGAIN: u32 = 2;
pub const EAI_BADFLAGS: u32 = 3;
pub const EAI_FAIL: u32 = 4;
pub const EAI_FAMILY: u32 = 5;
pub const EAI_MEMORY: u32 = 6;
pub const EAI_NODATA: u32 = 7;
pub const EAI_NONAME: u32 = 8;
pub const EAI_SERVICE: u32 = 9;
pub const EAI_SOCKTYPE: u32 = 10;
pub const EAI_SYSTEM: u32 = 11;
pub const EAI_BADHINTS: u32 = 12;
pub const EAI_PROTOCOL: u32 = 13;
pub const EAI_OVERFLOW: u32 = 14;
pub const EAI_MAX: u32 = 15;
pub const AI_PASSIVE: u32 = 1;
pub const AI_CANONNAME: u32 = 2;
pub const AI_NUMERICHOST: u32 = 4;
pub const AI_NUMERICSERV: u32 = 4096;
pub const AI_ALL: u32 = 256;
pub const AI_V4MAPPED_CFG: u32 = 512;
pub const AI_ADDRCONFIG: u32 = 1024;
pub const AI_V4MAPPED: u32 = 2048;
pub const AI_DEFAULT: u32 = 1536;
pub const AI_UNUSABLE: u32 = 268435456;
pub const NI_MAXHOST: u32 = 1025;
pub const NI_MAXSERV: u32 = 32;
pub const NI_NOFQDN: u32 = 1;
pub const NI_NUMERICHOST: u32 = 2;
pub const NI_NAMEREQD: u32 = 4;
pub const NI_NUMERICSERV: u32 = 8;
pub const NI_NUMERICSCOPE: u32 = 256;
pub const NI_DGRAM: u32 = 16;
pub const NI_WITHSCOPEID: u32 = 32;
pub const SCOPE_DELIMITER: u8 = 37u8;
pub const _PATH_PWD: &[u8; 5usize] = b"/etc\0";
pub const _PATH_PASSWD: &[u8; 12usize] = b"/etc/passwd\0";
pub const _PASSWD: &[u8; 7usize] = b"passwd\0";
pub const _PATH_MASTERPASSWD: &[u8; 19usize] = b"/etc/master.passwd\0";
pub const _PATH_MASTERPASSWD_LOCK: &[u8; 10usize] = b"/etc/ptmp\0";
pub const _MASTERPASSWD: &[u8; 14usize] = b"master.passwd\0";
pub const _PATH_MP_DB: &[u8; 12usize] = b"/etc/pwd.db\0";
pub const _MP_DB: &[u8; 7usize] = b"pwd.db\0";
pub const _PATH_SMP_DB: &[u8; 13usize] = b"/etc/spwd.db\0";
pub const _SMP_DB: &[u8; 8usize] = b"spwd.db\0";
pub const _PATH_PWD_MKDB: &[u8; 19usize] = b"/usr/sbin/pwd_mkdb\0";
pub const _PW_KEYBYNAME: u8 = 49u8;
pub const _PW_KEYBYNUM: u8 = 50u8;
pub const _PW_KEYBYUID: u8 = 51u8;
pub const _PASSWORD_EFMT1: u8 = 95u8;
pub const _PASSWORD_LEN: u32 = 128;
pub const _PASSWORD_NOUID: u32 = 1;
pub const _PASSWORD_NOGID: u32 = 2;
pub const _PASSWORD_NOCHG: u32 = 4;
pub const _PASSWORD_NOEXP: u32 = 8;
pub const _PASSWORD_WARNDAYS: u32 = 14;
pub const _PASSWORD_CHGNOW: i32 = -1;
pub const PGINVALID_SOCKET: i32 = -1;
pub const PG_BACKEND_VERSIONSTR: &[u8; 28usize] = b"postgres (PostgreSQL) 14.1\n\0";
pub const EXE: &[u8; 1usize] = b"\0";
pub const DEVNULL: &[u8; 10usize] = b"/dev/null\0";
pub const USE_REPL_SNPRINTF: u32 = 1;
pub const PG_STRERROR_R_BUFLEN: u32 = 256;
pub const PG_IOLBF: u32 = 1;
pub const FP_SUPERNORMAL: u32 = 6;
pub const FP_FAST_FMA: u32 = 1;
pub const FP_FAST_FMAF: u32 = 1;
pub const FP_FAST_FMAL: u32 = 1;
pub const FP_ILOGB0: i32 = -2147483648;
pub const FP_ILOGBNAN: i32 = -2147483648;
pub const MATH_ERRNO: u32 = 1;
pub const MATH_ERREXCEPT: u32 = 2;
pub const M_E: f64 = 2.718281828459045;
pub const M_LOG2E: f64 = 1.4426950408889634;
pub const M_LOG10E: f64 = 0.4342944819032518;
pub const M_LN2: f64 = 0.6931471805599453;
pub const M_LN10: f64 = 2.302585092994046;
pub const M_PI: f64 = 3.141592653589793;
pub const M_PI_2: f64 = 1.5707963267948966;
pub const M_PI_4: f64 = 0.7853981633974483;
pub const M_1_PI: f64 = 0.3183098861837907;
pub const M_2_PI: f64 = 0.6366197723675814;
pub const M_2_SQRTPI: f64 = 1.1283791670955126;
pub const M_SQRT2: f64 = 1.4142135623730951;
pub const M_SQRT1_2: f64 = 0.7071067811865476;
pub const DOMAIN: u32 = 1;
pub const SING: u32 = 2;
pub const OVERFLOW: u32 = 3;
pub const UNDERFLOW: u32 = 4;
pub const TLOSS: u32 = 5;
pub const PLOSS: u32 = 6;
pub const _JBLEN: u32 = 48;
pub const DEBUG5: u32 = 10;
pub const DEBUG4: u32 = 11;
pub const DEBUG3: u32 = 12;
pub const DEBUG2: u32 = 13;
pub const DEBUG1: u32 = 14;
pub const LOG: u32 = 15;
pub const LOG_SERVER_ONLY: u32 = 16;
pub const COMMERROR: u32 = 16;
pub const INFO: u32 = 17;
pub const NOTICE: u32 = 18;
pub const WARNING: u32 = 19;
pub const PGWARNING: u32 = 19;
pub const WARNING_CLIENT_ONLY: u32 = 20;
pub const ERROR: u32 = 21;
pub const PGERROR: u32 = 21;
pub const FATAL: u32 = 22;
pub const PANIC: u32 = 23;
pub const LOG_DESTINATION_STDERR: u32 = 1;
pub const LOG_DESTINATION_SYSLOG: u32 = 2;
pub const LOG_DESTINATION_EVENTLOG: u32 = 4;
pub const LOG_DESTINATION_CSVLOG: u32 = 8;
pub const MCXT_ALLOC_HUGE: u32 = 1;
pub const MCXT_ALLOC_NO_OOM: u32 = 2;
pub const MCXT_ALLOC_ZERO: u32 = 4;
pub const VARLENA_EXTSIZE_BITS: u32 = 30;
pub const VARLENA_EXTSIZE_MASK: u32 = 1073741823;
pub const VARATT_SHORT_MAX: u32 = 127;
pub const FIELDNO_NULLABLE_DATUM_DATUM: u32 = 0;
pub const FIELDNO_NULLABLE_DATUM_ISNULL: u32 = 1;
pub const SIZEOF_DATUM: u32 = 8;
pub const InvalidAttrNumber: u32 = 0;
pub const MaxAttrNumber: u32 = 32767;
pub const AttributeRelationId: u32 = 1249;
pub const AttributeRelation_Rowtype_Id: u32 = 75;
pub const Anum_pg_attribute_attrelid: u32 = 1;
pub const Anum_pg_attribute_attname: u32 = 2;
pub const Anum_pg_attribute_atttypid: u32 = 3;
pub const Anum_pg_attribute_attstattarget: u32 = 4;
pub const Anum_pg_attribute_attlen: u32 = 5;
pub const Anum_pg_attribute_attnum: u32 = 6;
pub const Anum_pg_attribute_attndims: u32 = 7;
pub const Anum_pg_attribute_attcacheoff: u32 = 8;
pub const Anum_pg_attribute_atttypmod: u32 = 9;
pub const Anum_pg_attribute_attbyval: u32 = 10;
pub const Anum_pg_attribute_attalign: u32 = 11;
pub const Anum_pg_attribute_attstorage: u32 = 12;
pub const Anum_pg_attribute_attcompression: u32 = 13;
pub const Anum_pg_attribute_attnotnull: u32 = 14;
pub const Anum_pg_attribute_atthasdef: u32 = 15;
pub const Anum_pg_attribute_atthasmissing: u32 = 16;
pub const Anum_pg_attribute_attidentity: u32 = 17;
pub const Anum_pg_attribute_attgenerated: u32 = 18;
pub const Anum_pg_attribute_attisdropped: u32 = 19;
pub const Anum_pg_attribute_attislocal: u32 = 20;
pub const Anum_pg_attribute_attinhcount: u32 = 21;
pub const Anum_pg_attribute_attcollation: u32 = 22;
pub const Anum_pg_attribute_attacl: u32 = 23;
pub const Anum_pg_attribute_attoptions: u32 = 24;
pub const Anum_pg_attribute_attfdwoptions: u32 = 25;
pub const Anum_pg_attribute_attmissingval: u32 = 26;
pub const Natts_pg_attribute: u32 = 26;
pub const ATTRIBUTE_IDENTITY_ALWAYS: u8 = 97u8;
pub const ATTRIBUTE_IDENTITY_BY_DEFAULT: u8 = 100u8;
pub const ATTRIBUTE_GENERATED_STORED: u8 = 115u8;
pub const AttributeRelidNameIndexId: u32 = 2658;
pub const AttributeRelidNumIndexId: u32 = 2659;
pub const AGGSPLITOP_COMBINE: u32 = 1;
pub const AGGSPLITOP_SKIPFINAL: u32 = 2;
pub const AGGSPLITOP_SERIALIZE: u32 = 4;
pub const AGGSPLITOP_DESERIALIZE: u32 = 8;
pub const LP_UNUSED: u32 = 0;
pub const LP_NORMAL: u32 = 1;
pub const LP_REDIRECT: u32 = 2;
pub const LP_DEAD: u32 = 3;
pub const SpecTokenOffsetNumber: u32 = 65534;
pub const MovedPartitionsOffsetNumber: u32 = 65533;
pub const FIELDNO_HEAPTUPLEDATA_DATA: u32 = 3;
pub const O_RDONLY: u32 = 0;
pub const O_WRONLY: u32 = 1;
pub const O_RDWR: u32 = 2;
pub const O_ACCMODE: u32 = 3;
pub const FREAD: u32 = 1;
pub const FWRITE: u32 = 2;
pub const O_NONBLOCK: u32 = 4;
pub const O_APPEND: u32 = 8;
pub const O_SYNC: u32 = 128;
pub const O_SHLOCK: u32 = 16;
pub const O_EXLOCK: u32 = 32;
pub const O_ASYNC: u32 = 64;
pub const O_FSYNC: u32 = 128;
pub const O_NOFOLLOW: u32 = 256;
pub const O_CREAT: u32 = 512;
pub const O_TRUNC: u32 = 1024;
pub const O_EXCL: u32 = 2048;
pub const O_EVTONLY: u32 = 32768;
pub const O_NOCTTY: u32 = 131072;
pub const O_DIRECTORY: u32 = 1048576;
pub const O_SYMLINK: u32 = 2097152;
pub const O_DSYNC: u32 = 4194304;
pub const O_CLOEXEC: u32 = 16777216;
pub const O_NOFOLLOW_ANY: u32 = 536870912;
pub const AT_FDCWD: i32 = -2;
pub const AT_EACCESS: u32 = 16;
pub const AT_SYMLINK_NOFOLLOW: u32 = 32;
pub const AT_SYMLINK_FOLLOW: u32 = 64;
pub const AT_REMOVEDIR: u32 = 128;
pub const AT_REALDEV: u32 = 512;
pub const AT_FDONLY: u32 = 1024;
pub const AT_SYMLINK_NOFOLLOW_ANY: u32 = 2048;
pub const O_DP_GETRAWENCRYPTED: u32 = 1;
pub const O_DP_GETRAWUNENCRYPTED: u32 = 2;
pub const FAPPEND: u32 = 8;
pub const FASYNC: u32 = 64;
pub const FFSYNC: u32 = 128;
pub const FFDSYNC: u32 = 4194304;
pub const FNONBLOCK: u32 = 4;
pub const FNDELAY: u32 = 4;
pub const O_NDELAY: u32 = 4;
pub const CPF_OVERWRITE: u32 = 1;
pub const CPF_IGNORE_MODE: u32 = 2;
pub const CPF_MASK: u32 = 3;
pub const F_DUPFD: u32 = 0;
pub const F_GETFD: u32 = 1;
pub const F_SETFD: u32 = 2;
pub const F_GETFL: u32 = 3;
pub const F_SETFL: u32 = 4;
pub const F_GETOWN: u32 = 5;
pub const F_SETOWN: u32 = 6;
pub const F_GETLK: u32 = 7;
pub const F_SETLK: u32 = 8;
pub const F_SETLKW: u32 = 9;
pub const F_SETLKWTIMEOUT: u32 = 10;
pub const F_FLUSH_DATA: u32 = 40;
pub const F_CHKCLEAN: u32 = 41;
pub const F_PREALLOCATE: u32 = 42;
pub const F_SETSIZE: u32 = 43;
pub const F_RDADVISE: u32 = 44;
pub const F_RDAHEAD: u32 = 45;
pub const F_NOCACHE: u32 = 48;
pub const F_LOG2PHYS: u32 = 49;
pub const F_GETPATH: u32 = 50;
pub const F_FULLFSYNC: u32 = 51;
pub const F_PATHPKG_CHECK: u32 = 52;
pub const F_FREEZE_FS: u32 = 53;
pub const F_THAW_FS: u32 = 54;
pub const F_GLOBAL_NOCACHE: u32 = 55;
pub const F_ADDSIGS: u32 = 59;
pub const F_ADDFILESIGS: u32 = 61;
pub const F_NODIRECT: u32 = 62;
pub const F_GETPROTECTIONCLASS: u32 = 63;
pub const F_SETPROTECTIONCLASS: u32 = 64;
pub const F_LOG2PHYS_EXT: u32 = 65;
pub const F_GETLKPID: u32 = 66;
pub const F_SETBACKINGSTORE: u32 = 70;
pub const F_GETPATH_MTMINFO: u32 = 71;
pub const F_GETCODEDIR: u32 = 72;
pub const F_SETNOSIGPIPE: u32 = 73;
pub const F_GETNOSIGPIPE: u32 = 74;
pub const F_TRANSCODEKEY: u32 = 75;
pub const F_SINGLE_WRITER: u32 = 76;
pub const F_GETPROTECTIONLEVEL: u32 = 77;
pub const F_FINDSIGS: u32 = 78;
pub const F_ADDFILESIGS_FOR_DYLD_SIM: u32 = 83;
pub const F_BARRIERFSYNC: u32 = 85;
pub const F_ADDFILESIGS_RETURN: u32 = 97;
pub const F_CHECK_LV: u32 = 98;
pub const F_PUNCHHOLE: u32 = 99;
pub const F_TRIM_ACTIVE_FILE: u32 = 100;
pub const F_SPECULATIVE_READ: u32 = 101;
pub const F_GETPATH_NOFIRMLINK: u32 = 102;
pub const F_ADDFILESIGS_INFO: u32 = 103;
pub const F_ADDFILESUPPL: u32 = 104;
pub const F_GETSIGSINFO: u32 = 105;
pub const F_FSRESERVED: u32 = 106;
pub const FCNTL_FS_SPECIFIC_BASE: u32 = 65536;
pub const F_DUPFD_CLOEXEC: u32 = 67;
pub const FD_CLOEXEC: u32 = 1;
pub const F_RDLCK: u32 = 1;
pub const F_UNLCK: u32 = 2;
pub const F_WRLCK: u32 = 3;
pub const SEEK_HOLE: u32 = 3;
pub const SEEK_DATA: u32 = 4;
pub const S_IFMT: u32 = 61440;
pub const S_IFIFO: u32 = 4096;
pub const S_IFCHR: u32 = 8192;
pub const S_IFDIR: u32 = 16384;
pub const S_IFBLK: u32 = 24576;
pub const S_IFREG: u32 = 32768;
pub const S_IFLNK: u32 = 40960;
pub const S_IFSOCK: u32 = 49152;
pub const S_IFWHT: u32 = 57344;
pub const S_IRWXU: u32 = 448;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXG: u32 = 56;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXO: u32 = 7;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_ISTXT: u32 = 512;
pub const S_IREAD: u32 = 256;
pub const S_IWRITE: u32 = 128;
pub const S_IEXEC: u32 = 64;
pub const F_ALLOCATECONTIG: u32 = 2;
pub const F_ALLOCATEALL: u32 = 4;
pub const F_PEOFPOSMODE: u32 = 3;
pub const F_VOLPOSMODE: u32 = 4;
pub const USER_FSIGNATURES_CDHASH_LEN: u32 = 20;
pub const GETSIGSINFO_PLATFORM_BINARY: u32 = 1;
pub const LOCK_SH: u32 = 1;
pub const LOCK_EX: u32 = 2;
pub const LOCK_NB: u32 = 4;
pub const LOCK_UN: u32 = 8;
pub const O_POPUP: u32 = 2147483648;
pub const O_ALERT: u32 = 536870912;
pub const InvalidXLogRecPtr: u32 = 0;
pub const PG_O_DIRECT: u32 = 0;
pub const OPEN_SYNC_FLAG: u32 = 128;
pub const OPEN_DATASYNC_FLAG: u32 = 4194304;
pub const FirstGenbkiObjectId: u32 = 10000;
pub const FirstBootstrapObjectId: u32 = 12000;
pub const FirstNormalObjectId: u32 = 16384;
pub const TypeRelationId: u32 = 1247;
pub const TypeRelation_Rowtype_Id: u32 = 71;
pub const Anum_pg_type_oid: u32 = 1;
pub const Anum_pg_type_typname: u32 = 2;
pub const Anum_pg_type_typnamespace: u32 = 3;
pub const Anum_pg_type_typowner: u32 = 4;
pub const Anum_pg_type_typlen: u32 = 5;
pub const Anum_pg_type_typbyval: u32 = 6;
pub const Anum_pg_type_typtype: u32 = 7;
pub const Anum_pg_type_typcategory: u32 = 8;
pub const Anum_pg_type_typispreferred: u32 = 9;
pub const Anum_pg_type_typisdefined: u32 = 10;
pub const Anum_pg_type_typdelim: u32 = 11;
pub const Anum_pg_type_typrelid: u32 = 12;
pub const Anum_pg_type_typsubscript: u32 = 13;
pub const Anum_pg_type_typelem: u32 = 14;
pub const Anum_pg_type_typarray: u32 = 15;
pub const Anum_pg_type_typinput: u32 = 16;
pub const Anum_pg_type_typoutput: u32 = 17;
pub const Anum_pg_type_typreceive: u32 = 18;
pub const Anum_pg_type_typsend: u32 = 19;
pub const Anum_pg_type_typmodin: u32 = 20;
pub const Anum_pg_type_typmodout: u32 = 21;
pub const Anum_pg_type_typanalyze: u32 = 22;
pub const Anum_pg_type_typalign: u32 = 23;
pub const Anum_pg_type_typstorage: u32 = 24;
pub const Anum_pg_type_typnotnull: u32 = 25;
pub const Anum_pg_type_typbasetype: u32 = 26;
pub const Anum_pg_type_typtypmod: u32 = 27;
pub const Anum_pg_type_typndims: u32 = 28;
pub const Anum_pg_type_typcollation: u32 = 29;
pub const Anum_pg_type_typdefaultbin: u32 = 30;
pub const Anum_pg_type_typdefault: u32 = 31;
pub const Anum_pg_type_typacl: u32 = 32;
pub const Natts_pg_type: u32 = 32;
pub const TYPTYPE_BASE: u8 = 98u8;
pub const TYPTYPE_COMPOSITE: u8 = 99u8;
pub const TYPTYPE_DOMAIN: u8 = 100u8;
pub const TYPTYPE_ENUM: u8 = 101u8;
pub const TYPTYPE_MULTIRANGE: u8 = 109u8;
pub const TYPTYPE_PSEUDO: u8 = 112u8;
pub const TYPTYPE_RANGE: u8 = 114u8;
pub const TYPCATEGORY_INVALID: u8 = 0u8;
pub const TYPCATEGORY_ARRAY: u8 = 65u8;
pub const TYPCATEGORY_BOOLEAN: u8 = 66u8;
pub const TYPCATEGORY_COMPOSITE: u8 = 67u8;
pub const TYPCATEGORY_DATETIME: u8 = 68u8;
pub const TYPCATEGORY_ENUM: u8 = 69u8;
pub const TYPCATEGORY_GEOMETRIC: u8 = 71u8;
pub const TYPCATEGORY_NETWORK: u8 = 73u8;
pub const TYPCATEGORY_NUMERIC: u8 = 78u8;
pub const TYPCATEGORY_PSEUDOTYPE: u8 = 80u8;
pub const TYPCATEGORY_RANGE: u8 = 82u8;
pub const TYPCATEGORY_STRING: u8 = 83u8;
pub const TYPCATEGORY_TIMESPAN: u8 = 84u8;
pub const TYPCATEGORY_USER: u8 = 85u8;
pub const TYPCATEGORY_BITSTRING: u8 = 86u8;
pub const TYPCATEGORY_UNKNOWN: u8 = 88u8;
pub const TYPALIGN_CHAR: u8 = 99u8;
pub const TYPALIGN_SHORT: u8 = 115u8;
pub const TYPALIGN_INT: u8 = 105u8;
pub const TYPALIGN_DOUBLE: u8 = 100u8;
pub const TYPSTORAGE_PLAIN: u8 = 112u8;
pub const TYPSTORAGE_EXTERNAL: u8 = 101u8;
pub const TYPSTORAGE_EXTENDED: u8 = 120u8;
pub const TYPSTORAGE_MAIN: u8 = 109u8;
pub const BOOLOID: u32 = 16;
pub const BYTEAOID: u32 = 17;
pub const CHAROID: u32 = 18;
pub const NAMEOID: u32 = 19;
pub const INT8OID: u32 = 20;
pub const INT2OID: u32 = 21;
pub const INT2VECTOROID: u32 = 22;
pub const INT4OID: u32 = 23;
pub const REGPROCOID: u32 = 24;
pub const TEXTOID: u32 = 25;
pub const OIDOID: u32 = 26;
pub const TIDOID: u32 = 27;
pub const XIDOID: u32 = 28;
pub const CIDOID: u32 = 29;
pub const OIDVECTOROID: u32 = 30;
pub const JSONOID: u32 = 114;
pub const XMLOID: u32 = 142;
pub const PG_NODE_TREEOID: u32 = 194;
pub const PG_NDISTINCTOID: u32 = 3361;
pub const PG_DEPENDENCIESOID: u32 = 3402;
pub const PG_MCV_LISTOID: u32 = 5017;
pub const PG_DDL_COMMANDOID: u32 = 32;
pub const XID8OID: u32 = 5069;
pub const POINTOID: u32 = 600;
pub const LSEGOID: u32 = 601;
pub const PATHOID: u32 = 602;
pub const BOXOID: u32 = 603;
pub const POLYGONOID: u32 = 604;
pub const LINEOID: u32 = 628;
pub const FLOAT4OID: u32 = 700;
pub const FLOAT8OID: u32 = 701;
pub const UNKNOWNOID: u32 = 705;
pub const CIRCLEOID: u32 = 718;
pub const MONEYOID: u32 = 790;
pub const MACADDROID: u32 = 829;
pub const INETOID: u32 = 869;
pub const CIDROID: u32 = 650;
pub const MACADDR8OID: u32 = 774;
pub const ACLITEMOID: u32 = 1033;
pub const BPCHAROID: u32 = 1042;
pub const VARCHAROID: u32 = 1043;
pub const DATEOID: u32 = 1082;
pub const TIMEOID: u32 = 1083;
pub const TIMESTAMPOID: u32 = 1114;
pub const TIMESTAMPTZOID: u32 = 1184;
pub const INTERVALOID: u32 = 1186;
pub const TIMETZOID: u32 = 1266;
pub const BITOID: u32 = 1560;
pub const VARBITOID: u32 = 1562;
pub const NUMERICOID: u32 = 1700;
pub const REFCURSOROID: u32 = 1790;
pub const REGPROCEDUREOID: u32 = 2202;
pub const REGOPEROID: u32 = 2203;
pub const REGOPERATOROID: u32 = 2204;
pub const REGCLASSOID: u32 = 2205;
pub const REGCOLLATIONOID: u32 = 4191;
pub const REGTYPEOID: u32 = 2206;
pub const REGROLEOID: u32 = 4096;
pub const REGNAMESPACEOID: u32 = 4089;
pub const UUIDOID: u32 = 2950;
pub const PG_LSNOID: u32 = 3220;
pub const TSVECTOROID: u32 = 3614;
pub const GTSVECTOROID: u32 = 3642;
pub const TSQUERYOID: u32 = 3615;
pub const REGCONFIGOID: u32 = 3734;
pub const REGDICTIONARYOID: u32 = 3769;
pub const JSONBOID: u32 = 3802;
pub const JSONPATHOID: u32 = 4072;
pub const TXID_SNAPSHOTOID: u32 = 2970;
pub const PG_SNAPSHOTOID: u32 = 5038;
pub const INT4RANGEOID: u32 = 3904;
pub const NUMRANGEOID: u32 = 3906;
pub const TSRANGEOID: u32 = 3908;
pub const TSTZRANGEOID: u32 = 3910;
pub const DATERANGEOID: u32 = 3912;
pub const INT8RANGEOID: u32 = 3926;
pub const INT4MULTIRANGEOID: u32 = 4451;
pub const NUMMULTIRANGEOID: u32 = 4532;
pub const TSMULTIRANGEOID: u32 = 4533;
pub const TSTZMULTIRANGEOID: u32 = 4534;
pub const DATEMULTIRANGEOID: u32 = 4535;
pub const INT8MULTIRANGEOID: u32 = 4536;
pub const RECORDOID: u32 = 2249;
pub const RECORDARRAYOID: u32 = 2287;
pub const CSTRINGOID: u32 = 2275;
pub const ANYOID: u32 = 2276;
pub const ANYARRAYOID: u32 = 2277;
pub const VOIDOID: u32 = 2278;
pub const TRIGGEROID: u32 = 2279;
pub const EVENT_TRIGGEROID: u32 = 3838;
pub const LANGUAGE_HANDLEROID: u32 = 2280;
pub const INTERNALOID: u32 = 2281;
pub const ANYELEMENTOID: u32 = 2283;
pub const ANYNONARRAYOID: u32 = 2776;
pub const ANYENUMOID: u32 = 3500;
pub const FDW_HANDLEROID: u32 = 3115;
pub const INDEX_AM_HANDLEROID: u32 = 325;
pub const TSM_HANDLEROID: u32 = 3310;
pub const TABLE_AM_HANDLEROID: u32 = 269;
pub const ANYRANGEOID: u32 = 3831;
pub const ANYCOMPATIBLEOID: u32 = 5077;
pub const ANYCOMPATIBLEARRAYOID: u32 = 5078;
pub const ANYCOMPATIBLENONARRAYOID: u32 = 5079;
pub const ANYCOMPATIBLERANGEOID: u32 = 5080;
pub const ANYMULTIRANGEOID: u32 = 4537;
pub const ANYCOMPATIBLEMULTIRANGEOID: u32 = 4538;
pub const PG_BRIN_BLOOM_SUMMARYOID: u32 = 4600;
pub const PG_BRIN_MINMAX_MULTI_SUMMARYOID: u32 = 4601;
pub const BOOLARRAYOID: u32 = 1000;
pub const BYTEAARRAYOID: u32 = 1001;
pub const CHARARRAYOID: u32 = 1002;
pub const NAMEARRAYOID: u32 = 1003;
pub const INT8ARRAYOID: u32 = 1016;
pub const INT2ARRAYOID: u32 = 1005;
pub const INT2VECTORARRAYOID: u32 = 1006;
pub const INT4ARRAYOID: u32 = 1007;
pub const REGPROCARRAYOID: u32 = 1008;
pub const TEXTARRAYOID: u32 = 1009;
pub const OIDARRAYOID: u32 = 1028;
pub const TIDARRAYOID: u32 = 1010;
pub const XIDARRAYOID: u32 = 1011;
pub const CIDARRAYOID: u32 = 1012;
pub const OIDVECTORARRAYOID: u32 = 1013;
pub const PG_TYPEARRAYOID: u32 = 210;
pub const PG_ATTRIBUTEARRAYOID: u32 = 270;
pub const PG_PROCARRAYOID: u32 = 272;
pub const PG_CLASSARRAYOID: u32 = 273;
pub const JSONARRAYOID: u32 = 199;
pub const XMLARRAYOID: u32 = 143;
pub const XID8ARRAYOID: u32 = 271;
pub const POINTARRAYOID: u32 = 1017;
pub const LSEGARRAYOID: u32 = 1018;
pub const PATHARRAYOID: u32 = 1019;
pub const BOXARRAYOID: u32 = 1020;
pub const POLYGONARRAYOID: u32 = 1027;
pub const LINEARRAYOID: u32 = 629;
pub const FLOAT4ARRAYOID: u32 = 1021;
pub const FLOAT8ARRAYOID: u32 = 1022;
pub const CIRCLEARRAYOID: u32 = 719;
pub const MONEYARRAYOID: u32 = 791;
pub const MACADDRARRAYOID: u32 = 1040;
pub const INETARRAYOID: u32 = 1041;
pub const CIDRARRAYOID: u32 = 651;
pub const MACADDR8ARRAYOID: u32 = 775;
pub const ACLITEMARRAYOID: u32 = 1034;
pub const BPCHARARRAYOID: u32 = 1014;
pub const VARCHARARRAYOID: u32 = 1015;
pub const DATEARRAYOID: u32 = 1182;
pub const TIMEARRAYOID: u32 = 1183;
pub const TIMESTAMPARRAYOID: u32 = 1115;
pub const TIMESTAMPTZARRAYOID: u32 = 1185;
pub const INTERVALARRAYOID: u32 = 1187;
pub const TIMETZARRAYOID: u32 = 1270;
pub const BITARRAYOID: u32 = 1561;
pub const VARBITARRAYOID: u32 = 1563;
pub const NUMERICARRAYOID: u32 = 1231;
pub const REFCURSORARRAYOID: u32 = 2201;
pub const REGPROCEDUREARRAYOID: u32 = 2207;
pub const REGOPERARRAYOID: u32 = 2208;
pub const REGOPERATORARRAYOID: u32 = 2209;
pub const REGCLASSARRAYOID: u32 = 2210;
pub const REGCOLLATIONARRAYOID: u32 = 4192;
pub const REGTYPEARRAYOID: u32 = 2211;
pub const REGROLEARRAYOID: u32 = 4097;
pub const REGNAMESPACEARRAYOID: u32 = 4090;
pub const UUIDARRAYOID: u32 = 2951;
pub const PG_LSNARRAYOID: u32 = 3221;
pub const TSVECTORARRAYOID: u32 = 3643;
pub const GTSVECTORARRAYOID: u32 = 3644;
pub const TSQUERYARRAYOID: u32 = 3645;
pub const REGCONFIGARRAYOID: u32 = 3735;
pub const REGDICTIONARYARRAYOID: u32 = 3770;
pub const JSONBARRAYOID: u32 = 3807;
pub const JSONPATHARRAYOID: u32 = 4073;
pub const TXID_SNAPSHOTARRAYOID: u32 = 2949;
pub const PG_SNAPSHOTARRAYOID: u32 = 5039;
pub const INT4RANGEARRAYOID: u32 = 3905;
pub const NUMRANGEARRAYOID: u32 = 3907;
pub const TSRANGEARRAYOID: u32 = 3909;
pub const TSTZRANGEARRAYOID: u32 = 3911;
pub const DATERANGEARRAYOID: u32 = 3913;
pub const INT8RANGEARRAYOID: u32 = 3927;
pub const INT4MULTIRANGEARRAYOID: u32 = 6150;
pub const NUMMULTIRANGEARRAYOID: u32 = 6151;
pub const TSMULTIRANGEARRAYOID: u32 = 6152;
pub const TSTZMULTIRANGEARRAYOID: u32 = 6153;
pub const DATEMULTIRANGEARRAYOID: u32 = 6155;
pub const INT8MULTIRANGEARRAYOID: u32 = 6157;
pub const CSTRINGARRAYOID: u32 = 1263;
pub const PD_HAS_FREE_LINES: u32 = 1;
pub const PD_PAGE_FULL: u32 = 2;
pub const PD_ALL_VISIBLE: u32 = 4;
pub const PD_VALID_FLAG_BITS: u32 = 7;
pub const PG_PAGE_LAYOUT_VERSION: u32 = 4;
pub const PG_DATA_CHECKSUM_VERSION: u32 = 1;
pub const PAI_OVERWRITE: u32 = 1;
pub const PAI_IS_HEAP: u32 = 2;
pub const PIV_LOG_WARNING: u32 = 1;
pub const PIV_REPORT_STAT: u32 = 2;
pub const MaxTupleAttributeNumber: u32 = 1664;
pub const MaxHeapAttributeNumber: u32 = 1600;
pub const FIELDNO_HEAPTUPLEHEADERDATA_INFOMASK2: u32 = 2;
pub const FIELDNO_HEAPTUPLEHEADERDATA_INFOMASK: u32 = 3;
pub const FIELDNO_HEAPTUPLEHEADERDATA_HOFF: u32 = 4;
pub const FIELDNO_HEAPTUPLEHEADERDATA_BITS: u32 = 5;
pub const HEAP_HASNULL: u32 = 1;
pub const HEAP_HASVARWIDTH: u32 = 2;
pub const HEAP_HASEXTERNAL: u32 = 4;
pub const HEAP_HASOID_OLD: u32 = 8;
pub const HEAP_XMAX_KEYSHR_LOCK: u32 = 16;
pub const HEAP_COMBOCID: u32 = 32;
pub const HEAP_XMAX_EXCL_LOCK: u32 = 64;
pub const HEAP_XMAX_LOCK_ONLY: u32 = 128;
pub const HEAP_XMAX_SHR_LOCK: u32 = 80;
pub const HEAP_LOCK_MASK: u32 = 80;
pub const HEAP_XMIN_COMMITTED: u32 = 256;
pub const HEAP_XMIN_INVALID: u32 = 512;
pub const HEAP_XMIN_FROZEN: u32 = 768;
pub const HEAP_XMAX_COMMITTED: u32 = 1024;
pub const HEAP_XMAX_INVALID: u32 = 2048;
pub const HEAP_XMAX_IS_MULTI: u32 = 4096;
pub const HEAP_UPDATED: u32 = 8192;
pub const HEAP_MOVED_OFF: u32 = 16384;
pub const HEAP_MOVED_IN: u32 = 32768;
pub const HEAP_MOVED: u32 = 49152;
pub const HEAP_XACT_MASK: u32 = 65520;
pub const HEAP_XMAX_BITS: u32 = 7376;
pub const HEAP_NATTS_MASK: u32 = 2047;
pub const HEAP_KEYS_UPDATED: u32 = 8192;
pub const HEAP_HOT_UPDATED: u32 = 16384;
pub const HEAP_ONLY_TUPLE: u32 = 32768;
pub const HEAP2_XACT_MASK: u32 = 57344;
pub const HEAP_TUPLE_HAS_MATCH: u32 = 32768;
pub const MaxAttrSize: u32 = 10485760;
pub const SelfItemPointerAttributeNumber: i32 = -1;
pub const MinTransactionIdAttributeNumber: i32 = -2;
pub const MinCommandIdAttributeNumber: i32 = -3;
pub const MaxTransactionIdAttributeNumber: i32 = -4;
pub const MaxCommandIdAttributeNumber: i32 = -5;
pub const TableOidAttributeNumber: i32 = -6;
pub const FirstLowInvalidHeapAttributeNumber: i32 = -7;
pub const InvalidBuffer: u32 = 0;
pub const TTS_FLAG_EMPTY: u32 = 2;
pub const TTS_FLAG_SHOULDFREE: u32 = 4;
pub const TTS_FLAG_SLOW: u32 = 8;
pub const TTS_FLAG_FIXED: u32 = 16;
pub const FIELDNO_TUPLETABLESLOT_FLAGS: u32 = 1;
pub const FIELDNO_TUPLETABLESLOT_NVALID: u32 = 2;
pub const FIELDNO_TUPLETABLESLOT_TUPLEDESCRIPTOR: u32 = 4;
pub const FIELDNO_TUPLETABLESLOT_VALUES: u32 = 5;
pub const FIELDNO_TUPLETABLESLOT_ISNULL: u32 = 6;
pub const FIELDNO_HEAPTUPLETABLESLOT_TUPLE: u32 = 1;
pub const FIELDNO_HEAPTUPLETABLESLOT_OFF: u32 = 2;
pub const FIELDNO_MINIMALTUPLETABLESLOT_TUPLE: u32 = 1;
pub const FIELDNO_MINIMALTUPLETABLESLOT_OFF: u32 = 4;
pub const BITS_PER_BITMAPWORD: u32 = 64;
pub const TIME_UTC: u32 = 1;
pub const FIELDNO_FUNCTIONCALLINFODATA_ISNULL: u32 = 4;
pub const FIELDNO_FUNCTIONCALLINFODATA_ARGS: u32 = 6;
pub const PG_MAGIC_FUNCTION_NAME_STRING: &[u8; 14usize] = b"Pg_magic_func\0";
pub const AGG_CONTEXT_AGGREGATE: u32 = 1;
pub const AGG_CONTEXT_WINDOW: u32 = 2;
pub const PARAM_FLAG_CONST: u32 = 1;
pub const BTLessStrategyNumber: u32 = 1;
pub const BTLessEqualStrategyNumber: u32 = 2;
pub const BTEqualStrategyNumber: u32 = 3;
pub const BTGreaterEqualStrategyNumber: u32 = 4;
pub const BTGreaterStrategyNumber: u32 = 5;
pub const BTMaxStrategyNumber: u32 = 5;
pub const HTEqualStrategyNumber: u32 = 1;
pub const HTMaxStrategyNumber: u32 = 1;
pub const RTLeftStrategyNumber: u32 = 1;
pub const RTOverLeftStrategyNumber: u32 = 2;
pub const RTOverlapStrategyNumber: u32 = 3;
pub const RTOverRightStrategyNumber: u32 = 4;
pub const RTRightStrategyNumber: u32 = 5;
pub const RTSameStrategyNumber: u32 = 6;
pub const RTContainsStrategyNumber: u32 = 7;
pub const RTContainedByStrategyNumber: u32 = 8;
pub const RTOverBelowStrategyNumber: u32 = 9;
pub const RTBelowStrategyNumber: u32 = 10;
pub const RTAboveStrategyNumber: u32 = 11;
pub const RTOverAboveStrategyNumber: u32 = 12;
pub const RTOldContainsStrategyNumber: u32 = 13;
pub const RTOldContainedByStrategyNumber: u32 = 14;
pub const RTKNNSearchStrategyNumber: u32 = 15;
pub const RTContainsElemStrategyNumber: u32 = 16;
pub const RTAdjacentStrategyNumber: u32 = 17;
pub const RTEqualStrategyNumber: u32 = 18;
pub const RTNotEqualStrategyNumber: u32 = 19;
pub const RTLessStrategyNumber: u32 = 20;
pub const RTLessEqualStrategyNumber: u32 = 21;
pub const RTGreaterStrategyNumber: u32 = 22;
pub const RTGreaterEqualStrategyNumber: u32 = 23;
pub const RTSubStrategyNumber: u32 = 24;
pub const RTSubEqualStrategyNumber: u32 = 25;
pub const RTSuperStrategyNumber: u32 = 26;
pub const RTSuperEqualStrategyNumber: u32 = 27;
pub const RTPrefixStrategyNumber: u32 = 28;
pub const RTOldBelowStrategyNumber: u32 = 29;
pub const RTOldAboveStrategyNumber: u32 = 30;
pub const RTMaxStrategyNumber: u32 = 30;
pub const INNER_VAR: u32 = 65000;
pub const OUTER_VAR: u32 = 65001;
pub const INDEX_VAR: u32 = 65002;
pub const ROWID_VAR: u32 = 65003;
pub const PRS2_OLD_VARNO: u32 = 1;
pub const PRS2_NEW_VARNO: u32 = 2;
pub const __DARWIN_CLK_TCK: u32 = 100;
pub const CHAR_BIT: u32 = 8;
pub const MB_LEN_MAX: u32 = 6;
pub const CLK_TCK: u32 = 100;
pub const SCHAR_MAX: u32 = 127;
pub const SCHAR_MIN: i32 = -128;
pub const UCHAR_MAX: u32 = 255;
pub const CHAR_MAX: u32 = 127;
pub const CHAR_MIN: i32 = -128;
pub const USHRT_MAX: u32 = 65535;
pub const SHRT_MAX: u32 = 32767;
pub const SHRT_MIN: i32 = -32768;
pub const UINT_MAX: u32 = 4294967295;
pub const INT_MAX: u32 = 2147483647;
pub const INT_MIN: i32 = -2147483648;
pub const ULONG_MAX: i32 = -1;
pub const LONG_MAX: u64 = 9223372036854775807;
pub const LONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const LONG_BIT: u32 = 64;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const WORD_BIT: u32 = 32;
pub const SIZE_T_MAX: i32 = -1;
pub const UQUAD_MAX: i32 = -1;
pub const QUAD_MAX: u64 = 9223372036854775807;
pub const QUAD_MIN: i64 = -9223372036854775808;
pub const ARG_MAX: u32 = 1048576;
pub const CHILD_MAX: u32 = 266;
pub const GID_MAX: u32 = 2147483647;
pub const LINK_MAX: u32 = 32767;
pub const MAX_CANON: u32 = 1024;
pub const MAX_INPUT: u32 = 1024;
pub const NAME_MAX: u32 = 255;
pub const NGROUPS_MAX: u32 = 16;
pub const UID_MAX: u32 = 2147483647;
pub const OPEN_MAX: u32 = 10240;
pub const PATH_MAX: u32 = 1024;
pub const PIPE_BUF: u32 = 512;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const CHARCLASS_NAME_MAX: u32 = 14;
pub const COLL_WEIGHTS_MAX: u32 = 2;
pub const EQUIV_CLASS_MAX: u32 = 2;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 255;
pub const NZERO: u32 = 20;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_EQUIV_CLASS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_KEYS_MAX: u32 = 512;
pub const PTHREAD_STACK_MIN: u32 = 16384;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_SS_REPL_MAX: u32 = 4;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TRACE_EVENT_NAME_MAX: u32 = 30;
pub const _POSIX_TRACE_NAME_MAX: u32 = 8;
pub const _POSIX_TRACE_SYS_MAX: u32 = 8;
pub const _POSIX_TRACE_USER_EVENT_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const OFF_MIN: i64 = -9223372036854775808;
pub const OFF_MAX: u64 = 9223372036854775807;
pub const PASS_MAX: u32 = 128;
pub const NL_ARGMAX: u32 = 9;
pub const NL_LANGMAX: u32 = 14;
pub const NL_MSGMAX: u32 = 32767;
pub const NL_NMAX: u32 = 1;
pub const NL_SETMAX: u32 = 255;
pub const NL_TEXTMAX: u32 = 2048;
pub const _XOPEN_IOV_MAX: u32 = 16;
pub const IOV_MAX: u32 = 1024;
pub const _XOPEN_NAME_MAX: u32 = 255;
pub const _XOPEN_PATH_MAX: u32 = 1024;
pub const DSM_IMPL_POSIX: u32 = 1;
pub const DSM_IMPL_SYSV: u32 = 2;
pub const DSM_IMPL_WINDOWS: u32 = 3;
pub const DSM_IMPL_MMAP: u32 = 4;
pub const DEFAULT_DYNAMIC_SHARED_MEMORY_TYPE: u32 = 1;
pub const PG_DYNSHMEM_DIR: &[u8; 12usize] = b"pg_dynshmem\0";
pub const PG_DYNSHMEM_MMAP_FILE_PREFIX: &[u8; 6usize] = b"mmap.\0";
pub const DSM_CREATE_NULL_IF_MAXSEGMENTS: u32 = 1;
pub const DSM_HANDLE_INVALID: u32 = 0;
pub const SIZEOF_DSA_POINTER: u32 = 8;
pub const DSA_POINTER_FORMAT: &[u8; 7usize] = b"%016lx\0";
pub const DSA_ALLOC_HUGE: u32 = 1;
pub const DSA_ALLOC_NO_OOM: u32 = 2;
pub const DSA_ALLOC_ZERO: u32 = 4;
pub const DEFAULT_SPINS_PER_DELAY: u32 = 100;
pub const HASH_PARTITION: u32 = 1;
pub const HASH_SEGMENT: u32 = 2;
pub const HASH_DIRSIZE: u32 = 4;
pub const HASH_ELEM: u32 = 8;
pub const HASH_STRINGS: u32 = 16;
pub const HASH_BLOBS: u32 = 32;
pub const HASH_FUNCTION: u32 = 64;
pub const HASH_COMPARE: u32 = 128;
pub const HASH_KEYCOPY: u32 = 256;
pub const HASH_ALLOC: u32 = 512;
pub const HASH_CONTEXT: u32 = 1024;
pub const HASH_SHARED_MEM: u32 = 2048;
pub const HASH_ATTACH: u32 = 4096;
pub const HASH_FIXED_SIZE: u32 = 8192;
pub const NO_MAX_DSIZE: i32 = -1;
pub const __DARWIN_MAXNAMLEN: u32 = 255;
pub const __DARWIN_MAXPATHLEN: u32 = 1024;
pub const MAXNAMLEN: u32 = 255;
pub const DT_UNKNOWN: u32 = 0;
pub const DT_FIFO: u32 = 1;
pub const DT_CHR: u32 = 2;
pub const DT_DIR: u32 = 4;
pub const DT_BLK: u32 = 6;
pub const DT_REG: u32 = 8;
pub const DT_LNK: u32 = 10;
pub const DT_SOCK: u32 = 12;
pub const DT_WHT: u32 = 14;
pub const DIRBLKSIZ: u32 = 1024;
pub const DTF_HIDEW: u32 = 1;
pub const DTF_NODUP: u32 = 2;
pub const DTF_REWIND: u32 = 4;
pub const __DTF_READALL: u32 = 8;
pub const __DTF_SKIPREAD: u32 = 16;
pub const __DTF_ATEND: u32 = 32;
pub const PG_TEMP_FILES_DIR: &[u8; 10usize] = b"pgsql_tmp\0";
pub const PG_TEMP_FILE_PREFIX: &[u8; 10usize] = b"pgsql_tmp\0";
pub const SHARED_TUPLESTORE_SINGLE_PASS: u32 = 1;
pub const MAX_TIMESTAMP_PRECISION: u32 = 6;
pub const MAX_INTERVAL_PRECISION: u32 = 6;
pub const TS_PREC_INV: f64 = 1000000.0;
pub const DAYS_PER_YEAR: f64 = 365.25;
pub const MONTHS_PER_YEAR: u32 = 12;
pub const DAYS_PER_MONTH: u32 = 30;
pub const HOURS_PER_DAY: u32 = 24;
pub const SECS_PER_YEAR: u32 = 31557600;
pub const SECS_PER_DAY: u32 = 86400;
pub const SECS_PER_HOUR: u32 = 3600;
pub const SECS_PER_MINUTE: u32 = 60;
pub const MINS_PER_HOUR: u32 = 60;
pub const MAX_TZDISP_HOUR: u32 = 15;
pub const TZDISP_LIMIT: u32 = 57600;
pub const JULIAN_MINYEAR: i32 = -4713;
pub const JULIAN_MINMONTH: u32 = 11;
pub const JULIAN_MINDAY: u32 = 24;
pub const JULIAN_MAXYEAR: u32 = 5874898;
pub const JULIAN_MAXMONTH: u32 = 6;
pub const JULIAN_MAXDAY: u32 = 3;
pub const UNIX_EPOCH_JDATE: u32 = 2440588;
pub const POSTGRES_EPOCH_JDATE: u32 = 2451545;
pub const DATETIME_MIN_JULIAN: u32 = 0;
pub const DATE_END_JULIAN: u32 = 2147483494;
pub const TIMESTAMP_END_JULIAN: u32 = 109203528;
pub const RELCACHE_INIT_FILENAME: &[u8; 17usize] = b"pg_internal.init\0";
pub const INDEX_SIZE_MASK: u32 = 8191;
pub const INDEX_AM_RESERVED_BIT: u32 = 8192;
pub const INDEX_VAR_MASK: u32 = 16384;
pub const INDEX_NULL_MASK: u32 = 32768;
pub const NUM_TUPLESORTMETHODS: u32 = 4;
pub const EEO_FLAG_IS_QUAL: u32 = 1;
pub const FIELDNO_EXPRSTATE_RESNULL: u32 = 2;
pub const FIELDNO_EXPRSTATE_RESVALUE: u32 = 3;
pub const FIELDNO_EXPRSTATE_RESULTSLOT: u32 = 4;
pub const FIELDNO_EXPRSTATE_PARENT: u32 = 11;
pub const FIELDNO_EXPRCONTEXT_SCANTUPLE: u32 = 1;
pub const FIELDNO_EXPRCONTEXT_INNERTUPLE: u32 = 2;
pub const FIELDNO_EXPRCONTEXT_OUTERTUPLE: u32 = 3;
pub const FIELDNO_EXPRCONTEXT_AGGVALUES: u32 = 8;
pub const FIELDNO_EXPRCONTEXT_AGGNULLS: u32 = 9;
pub const FIELDNO_EXPRCONTEXT_CASEDATUM: u32 = 10;
pub const FIELDNO_EXPRCONTEXT_CASENULL: u32 = 11;
pub const FIELDNO_EXPRCONTEXT_DOMAINDATUM: u32 = 12;
pub const FIELDNO_EXPRCONTEXT_DOMAINNULL: u32 = 13;
pub const FIELDNO_AGGSTATE_CURAGGCONTEXT: u32 = 14;
pub const FIELDNO_AGGSTATE_CURPERTRANS: u32 = 16;
pub const FIELDNO_AGGSTATE_CURRENT_SET: u32 = 20;
pub const FIELDNO_AGGSTATE_ALL_PERGROUPS: u32 = 53;
pub const COMPLETION_TAG_BUFSIZE: u32 = 64;
pub const ACL_INSERT: u32 = 1;
pub const ACL_SELECT: u32 = 2;
pub const ACL_UPDATE: u32 = 4;
pub const ACL_DELETE: u32 = 8;
pub const ACL_TRUNCATE: u32 = 16;
pub const ACL_REFERENCES: u32 = 32;
pub const ACL_TRIGGER: u32 = 64;
pub const ACL_EXECUTE: u32 = 128;
pub const ACL_USAGE: u32 = 256;
pub const ACL_CREATE: u32 = 512;
pub const ACL_CREATE_TEMP: u32 = 1024;
pub const ACL_CONNECT: u32 = 2048;
pub const N_ACL_RIGHTS: u32 = 12;
pub const ACL_NO_RIGHTS: u32 = 0;
pub const ACL_SELECT_FOR_UPDATE: u32 = 4;
pub const FRAMEOPTION_NONDEFAULT: u32 = 1;
pub const FRAMEOPTION_RANGE: u32 = 2;
pub const FRAMEOPTION_ROWS: u32 = 4;
pub const FRAMEOPTION_GROUPS: u32 = 8;
pub const FRAMEOPTION_BETWEEN: u32 = 16;
pub const FRAMEOPTION_START_UNBOUNDED_PRECEDING: u32 = 32;
pub const FRAMEOPTION_END_UNBOUNDED_PRECEDING: u32 = 64;
pub const FRAMEOPTION_START_UNBOUNDED_FOLLOWING: u32 = 128;
pub const FRAMEOPTION_END_UNBOUNDED_FOLLOWING: u32 = 256;
pub const FRAMEOPTION_START_CURRENT_ROW: u32 = 512;
pub const FRAMEOPTION_END_CURRENT_ROW: u32 = 1024;
pub const FRAMEOPTION_START_OFFSET_PRECEDING: u32 = 2048;
pub const FRAMEOPTION_END_OFFSET_PRECEDING: u32 = 4096;
pub const FRAMEOPTION_START_OFFSET_FOLLOWING: u32 = 8192;
pub const FRAMEOPTION_END_OFFSET_FOLLOWING: u32 = 16384;
pub const FRAMEOPTION_EXCLUDE_CURRENT_ROW: u32 = 32768;
pub const FRAMEOPTION_EXCLUDE_GROUP: u32 = 65536;
pub const FRAMEOPTION_EXCLUDE_TIES: u32 = 131072;
pub const FRAMEOPTION_START_OFFSET: u32 = 10240;
pub const FRAMEOPTION_END_OFFSET: u32 = 20480;
pub const FRAMEOPTION_EXCLUSION: u32 = 229376;
pub const FRAMEOPTION_DEFAULTS: u32 = 1058;
pub const PARTITION_STRATEGY_HASH: u8 = 104u8;
pub const PARTITION_STRATEGY_LIST: u8 = 108u8;
pub const PARTITION_STRATEGY_RANGE: u8 = 114u8;
pub const FKCONSTR_ACTION_NOACTION: u8 = 97u8;
pub const FKCONSTR_ACTION_RESTRICT: u8 = 114u8;
pub const FKCONSTR_ACTION_CASCADE: u8 = 99u8;
pub const FKCONSTR_ACTION_SETNULL: u8 = 110u8;
pub const FKCONSTR_ACTION_SETDEFAULT: u8 = 100u8;
pub const FKCONSTR_MATCH_FULL: u8 = 102u8;
pub const FKCONSTR_MATCH_PARTIAL: u8 = 112u8;
pub const FKCONSTR_MATCH_SIMPLE: u8 = 115u8;
pub const OPCLASS_ITEM_OPERATOR: u32 = 1;
pub const OPCLASS_ITEM_FUNCTION: u32 = 2;
pub const OPCLASS_ITEM_STORAGETYPE: u32 = 3;
pub const CURSOR_OPT_BINARY: u32 = 1;
pub const CURSOR_OPT_SCROLL: u32 = 2;
pub const CURSOR_OPT_NO_SCROLL: u32 = 4;
pub const CURSOR_OPT_INSENSITIVE: u32 = 8;
pub const CURSOR_OPT_ASENSITIVE: u32 = 16;
pub const CURSOR_OPT_HOLD: u32 = 32;
pub const CURSOR_OPT_FAST_PLAN: u32 = 256;
pub const CURSOR_OPT_GENERIC_PLAN: u32 = 512;
pub const CURSOR_OPT_CUSTOM_PLAN: u32 = 1024;
pub const CURSOR_OPT_PARALLEL_OK: u32 = 2048;
pub const FETCH_ALL: u64 = 9223372036854775807;
pub const MaxAllocHugeSize: u32 = 0;
pub const ALLOCSET_DEFAULT_MINSIZE: u32 = 0;
pub const ALLOCSET_DEFAULT_INITSIZE: u32 = 8192;
pub const ALLOCSET_DEFAULT_MAXSIZE: u32 = 8388608;
pub const ALLOCSET_SMALL_MINSIZE: u32 = 0;
pub const ALLOCSET_SMALL_INITSIZE: u32 = 1024;
pub const ALLOCSET_SMALL_MAXSIZE: u32 = 8192;
pub const ALLOCSET_SEPARATE_THRESHOLD: u32 = 8192;
pub const SLAB_DEFAULT_BLOCK_SIZE: u32 = 8192;
pub const SLAB_LARGE_BLOCK_SIZE: u32 = 8388608;
pub const EXEC_FLAG_EXPLAIN_ONLY: u32 = 1;
pub const EXEC_FLAG_REWIND: u32 = 2;
pub const EXEC_FLAG_BACKWARD: u32 = 4;
pub const EXEC_FLAG_MARK: u32 = 8;
pub const EXEC_FLAG_SKIP_TRIGGERS: u32 = 16;
pub const EXEC_FLAG_WITH_NO_DATA: u32 = 32;
pub const TZ_STRLEN_MAX: u32 = 255;
pub const InvalidPid: i32 = -1;
pub const USE_POSTGRES_DATES: u32 = 0;
pub const USE_ISO_DATES: u32 = 1;
pub const USE_SQL_DATES: u32 = 2;
pub const USE_GERMAN_DATES: u32 = 3;
pub const USE_XSD_DATES: u32 = 4;
pub const DATEORDER_YMD: u32 = 0;
pub const DATEORDER_DMY: u32 = 1;
pub const DATEORDER_MDY: u32 = 2;
pub const INTSTYLE_POSTGRES: u32 = 0;
pub const INTSTYLE_POSTGRES_VERBOSE: u32 = 1;
pub const INTSTYLE_SQL_STANDARD: u32 = 2;
pub const INTSTYLE_ISO_8601: u32 = 3;
pub const MAXTZLEN: u32 = 10;
pub const SECURITY_LOCAL_USERID_CHANGE: u32 = 1;
pub const SECURITY_RESTRICTED_OPERATION: u32 = 2;
pub const SECURITY_NOFORCE_RLS: u32 = 4;
pub const MIN_XFN_CHARS: u32 = 16;
pub const MAX_XFN_CHARS: u32 = 40;
pub const VALID_XFN_CHARS: &[u8; 40usize] = b"0123456789ABCDEF.history.backup.partial\0";
pub const PGSTAT_NUM_PROGRESS_PARAM: u32 = 20;
pub const SOL_LOCAL: u32 = 0;
pub const LOCAL_PEERCRED: u32 = 1;
pub const LOCAL_PEERPID: u32 = 2;
pub const LOCAL_PEEREPID: u32 = 3;
pub const LOCAL_PEERUUID: u32 = 4;
pub const LOCAL_PEEREUUID: u32 = 5;
pub const LOCAL_PEERTOKEN: u32 = 6;
pub const MAX_STARTUP_PACKET_LENGTH: u32 = 10000;
pub const AUTH_REQ_OK: u32 = 0;
pub const AUTH_REQ_KRB4: u32 = 1;
pub const AUTH_REQ_KRB5: u32 = 2;
pub const AUTH_REQ_PASSWORD: u32 = 3;
pub const AUTH_REQ_CRYPT: u32 = 4;
pub const AUTH_REQ_MD5: u32 = 5;
pub const AUTH_REQ_SCM_CREDS: u32 = 6;
pub const AUTH_REQ_GSS: u32 = 7;
pub const AUTH_REQ_GSS_CONT: u32 = 8;
pub const AUTH_REQ_SSPI: u32 = 9;
pub const AUTH_REQ_SASL: u32 = 10;
pub const AUTH_REQ_SASL_CONT: u32 = 11;
pub const AUTH_REQ_SASL_FIN: u32 = 12;
pub const PG_WAIT_LWLOCK: u32 = 16777216;
pub const PG_WAIT_LOCK: u32 = 50331648;
pub const PG_WAIT_BUFFER_PIN: u32 = 67108864;
pub const PG_WAIT_ACTIVITY: u32 = 83886080;
pub const PG_WAIT_CLIENT: u32 = 100663296;
pub const PG_WAIT_EXTENSION: u32 = 117440512;
pub const PG_WAIT_IPC: u32 = 134217728;
pub const PG_WAIT_TIMEOUT: u32 = 150994944;
pub const PG_WAIT_IO: u32 = 167772160;
pub const PGSTAT_STAT_PERMANENT_DIRECTORY: &[u8; 8usize] = b"pg_stat\0";
pub const PGSTAT_STAT_PERMANENT_FILENAME: &[u8; 20usize] = b"pg_stat/global.stat\0";
pub const PGSTAT_STAT_PERMANENT_TMPFILE: &[u8; 19usize] = b"pg_stat/global.tmp\0";
pub const PG_STAT_TMP_DIR: &[u8; 12usize] = b"pg_stat_tmp\0";
pub const PGSTAT_MAX_MSG_SIZE: u32 = 1000;
pub const PGSTAT_FILE_FORMAT_ID: u32 = 27638946;
pub const SK_ISNULL: u32 = 1;
pub const SK_UNARY: u32 = 2;
pub const SK_ROW_HEADER: u32 = 4;
pub const SK_ROW_MEMBER: u32 = 8;
pub const SK_ROW_END: u32 = 16;
pub const SK_SEARCHARRAY: u32 = 32;
pub const SK_SEARCHNULL: u32 = 64;
pub const SK_SEARCHNOTNULL: u32 = 128;
pub const SK_ORDER_BY: u32 = 256;
pub const NoLock: u32 = 0;
pub const AccessShareLock: u32 = 1;
pub const RowShareLock: u32 = 2;
pub const RowExclusiveLock: u32 = 3;
pub const ShareUpdateExclusiveLock: u32 = 4;
pub const ShareLock: u32 = 5;
pub const ShareRowExclusiveLock: u32 = 6;
pub const ExclusiveLock: u32 = 7;
pub const AccessExclusiveLock: u32 = 8;
pub const MaxLockMode: u32 = 8;
pub const CATALOG_VERSION_NO: u32 = 202107181;
pub const OIDCHARS: u32 = 10;
pub const FORKNAMECHARS: u32 = 4;
pub const InvalidBackendId: i32 = -1;
pub const XLR_INFO_MASK: u32 = 15;
pub const XLR_RMGR_INFO_MASK: u32 = 240;
pub const XLR_SPECIAL_REL_UPDATE: u32 = 1;
pub const XLR_CHECK_CONSISTENCY: u32 = 2;
pub const BKPIMAGE_HAS_HOLE: u32 = 1;
pub const BKPIMAGE_IS_COMPRESSED: u32 = 2;
pub const BKPIMAGE_APPLY: u32 = 4;
pub const BKPBLOCK_FORK_MASK: u32 = 15;
pub const BKPBLOCK_FLAG_MASK: u32 = 240;
pub const BKPBLOCK_HAS_IMAGE: u32 = 16;
pub const BKPBLOCK_HAS_DATA: u32 = 32;
pub const BKPBLOCK_WILL_INIT: u32 = 64;
pub const BKPBLOCK_SAME_REL: u32 = 128;
pub const XLR_MAX_BLOCK_ID: u32 = 32;
pub const XLR_BLOCK_ID_DATA_SHORT: u32 = 255;
pub const XLR_BLOCK_ID_DATA_LONG: u32 = 254;
pub const XLR_BLOCK_ID_ORIGIN: u32 = 253;
pub const XLR_BLOCK_ID_TOPLEVEL_XID: u32 = 252;
pub const GIN_COMPARE_PROC: u32 = 1;
pub const GIN_EXTRACTVALUE_PROC: u32 = 2;
pub const GIN_EXTRACTQUERY_PROC: u32 = 3;
pub const GIN_CONSISTENT_PROC: u32 = 4;
pub const GIN_COMPARE_PARTIAL_PROC: u32 = 5;
pub const GIN_TRICONSISTENT_PROC: u32 = 6;
pub const GIN_OPTIONS_PROC: u32 = 7;
pub const GINNProcs: u32 = 7;
pub const GIN_SEARCH_MODE_DEFAULT: u32 = 0;
pub const GIN_SEARCH_MODE_INCLUDE_EMPTY: u32 = 1;
pub const GIN_SEARCH_MODE_ALL: u32 = 2;
pub const GIN_SEARCH_MODE_EVERYTHING: u32 = 3;
pub const GIN_FALSE: u32 = 0;
pub const GIN_TRUE: u32 = 1;
pub const GIN_MAYBE: u32 = 2;
pub const XLR_NORMAL_MAX_BLOCK_ID: u32 = 4;
pub const XLR_NORMAL_RDATAS: u32 = 20;
pub const REGBUF_FORCE_IMAGE: u32 = 1;
pub const REGBUF_NO_IMAGE: u32 = 2;
pub const REGBUF_WILL_INIT: u32 = 6;
pub const REGBUF_STANDARD: u32 = 8;
pub const REGBUF_KEEP_DATA: u32 = 16;
pub const SYNC_METHOD_FSYNC: u32 = 0;
pub const SYNC_METHOD_FDATASYNC: u32 = 1;
pub const SYNC_METHOD_OPEN: u32 = 2;
pub const SYNC_METHOD_FSYNC_WRITETHROUGH: u32 = 3;
pub const SYNC_METHOD_OPEN_DSYNC: u32 = 4;
pub const CHECKPOINT_IS_SHUTDOWN: u32 = 1;
pub const CHECKPOINT_END_OF_RECOVERY: u32 = 2;
pub const CHECKPOINT_IMMEDIATE: u32 = 4;
pub const CHECKPOINT_FORCE: u32 = 8;
pub const CHECKPOINT_FLUSH_ALL: u32 = 16;
pub const CHECKPOINT_WAIT: u32 = 32;
pub const CHECKPOINT_REQUESTED: u32 = 64;
pub const CHECKPOINT_CAUSE_XLOG: u32 = 128;
pub const CHECKPOINT_CAUSE_TIME: u32 = 256;
pub const XLOG_INCLUDE_ORIGIN: u32 = 1;
pub const XLOG_MARK_UNIMPORTANT: u32 = 2;
pub const XLOG_INCLUDE_XID: u32 = 4;
pub const RECOVERY_SIGNAL_FILE: &[u8; 16usize] = b"recovery.signal\0";
pub const STANDBY_SIGNAL_FILE: &[u8; 15usize] = b"standby.signal\0";
pub const BACKUP_LABEL_FILE: &[u8; 13usize] = b"backup_label\0";
pub const BACKUP_LABEL_OLD: &[u8; 17usize] = b"backup_label.old\0";
pub const TABLESPACE_MAP: &[u8; 15usize] = b"tablespace_map\0";
pub const TABLESPACE_MAP_OLD: &[u8; 19usize] = b"tablespace_map.old\0";
pub const PROMOTE_SIGNAL_FILE: &[u8; 8usize] = b"promote\0";
pub const GIST_CONSISTENT_PROC: u32 = 1;
pub const GIST_UNION_PROC: u32 = 2;
pub const GIST_COMPRESS_PROC: u32 = 3;
pub const GIST_DECOMPRESS_PROC: u32 = 4;
pub const GIST_PENALTY_PROC: u32 = 5;
pub const GIST_PICKSPLIT_PROC: u32 = 6;
pub const GIST_EQUAL_PROC: u32 = 7;
pub const GIST_DISTANCE_PROC: u32 = 8;
pub const GIST_FETCH_PROC: u32 = 9;
pub const GIST_OPTIONS_PROC: u32 = 10;
pub const GIST_SORTSUPPORT_PROC: u32 = 11;
pub const GISTNProcs: u32 = 11;
pub const F_LEAF: u32 = 1;
pub const F_DELETED: u32 = 2;
pub const F_TUPLES_DELETED: u32 = 4;
pub const F_FOLLOW_RIGHT: u32 = 8;
pub const F_HAS_GARBAGE: u32 = 16;
pub const GIST_PAGE_ID: u32 = 65409;
pub const SHAREDINVALCATALOG_ID: i32 = -1;
pub const SHAREDINVALRELCACHE_ID: i32 = -2;
pub const SHAREDINVALSMGR_ID: i32 = -3;
pub const SHAREDINVALRELMAP_ID: i32 = -4;
pub const SHAREDINVALSNAPSHOT_ID: i32 = -5;
pub const GIDSIZE: u32 = 200;
pub const XACT_READ_UNCOMMITTED: u32 = 0;
pub const XACT_READ_COMMITTED: u32 = 1;
pub const XACT_REPEATABLE_READ: u32 = 2;
pub const XACT_SERIALIZABLE: u32 = 3;
pub const XACT_FLAGS_ACCESSEDTEMPNAMESPACE: u32 = 1;
pub const XACT_FLAGS_ACQUIREDACCESSEXCLUSIVELOCK: u32 = 2;
pub const XLOG_XACT_COMMIT: u32 = 0;
pub const XLOG_XACT_PREPARE: u32 = 16;
pub const XLOG_XACT_ABORT: u32 = 32;
pub const XLOG_XACT_COMMIT_PREPARED: u32 = 48;
pub const XLOG_XACT_ABORT_PREPARED: u32 = 64;
pub const XLOG_XACT_ASSIGNMENT: u32 = 80;
pub const XLOG_XACT_INVALIDATIONS: u32 = 96;
pub const XLOG_XACT_OPMASK: u32 = 112;
pub const XLOG_XACT_HAS_INFO: u32 = 128;
pub const XACT_XINFO_HAS_DBINFO: u32 = 1;
pub const XACT_XINFO_HAS_SUBXACTS: u32 = 2;
pub const XACT_XINFO_HAS_RELFILENODES: u32 = 4;
pub const XACT_XINFO_HAS_INVALS: u32 = 8;
pub const XACT_XINFO_HAS_TWOPHASE: u32 = 16;
pub const XACT_XINFO_HAS_ORIGIN: u32 = 32;
pub const XACT_XINFO_HAS_AE_LOCKS: u32 = 64;
pub const XACT_XINFO_HAS_GID: u32 = 128;
pub const XACT_COMPLETION_APPLY_FEEDBACK: u32 = 536870912;
pub const XACT_COMPLETION_UPDATE_RELCACHE_FILE: u32 = 1073741824;
pub const XACT_COMPLETION_FORCE_SYNC_COMMIT: u32 = 2147483648;
pub const EOH_HEADER_MAGIC: i32 = -1;
pub const MAXDIM: u32 = 6;
pub const EA_MAGIC: u32 = 689375833;
pub const MAX_KILOBYTES: u32 = 2147483647;
pub const PG_AUTOCONF_FILENAME: &[u8; 21usize] = b"postgresql.auto.conf\0";
pub const GUC_QUALIFIER_SEPARATOR: u8 = 46u8;
pub const GUC_LIST_INPUT: u32 = 1;
pub const GUC_LIST_QUOTE: u32 = 2;
pub const GUC_NO_SHOW_ALL: u32 = 4;
pub const GUC_NO_RESET_ALL: u32 = 8;
pub const GUC_REPORT: u32 = 16;
pub const GUC_NOT_IN_SAMPLE: u32 = 32;
pub const GUC_DISALLOW_IN_FILE: u32 = 64;
pub const GUC_CUSTOM_PLACEHOLDER: u32 = 128;
pub const GUC_SUPERUSER_ONLY: u32 = 256;
pub const GUC_IS_NAME: u32 = 512;
pub const GUC_NOT_WHILE_SEC_REST: u32 = 1024;
pub const GUC_DISALLOW_IN_AUTO_FILE: u32 = 2048;
pub const GUC_UNIT_KB: u32 = 4096;
pub const GUC_UNIT_BLOCKS: u32 = 8192;
pub const GUC_UNIT_XBLOCKS: u32 = 12288;
pub const GUC_UNIT_MB: u32 = 16384;
pub const GUC_UNIT_BYTE: u32 = 32768;
pub const GUC_UNIT_MEMORY: u32 = 61440;
pub const GUC_UNIT_MS: u32 = 65536;
pub const GUC_UNIT_S: u32 = 131072;
pub const GUC_UNIT_MIN: u32 = 196608;
pub const GUC_UNIT_TIME: u32 = 983040;
pub const GUC_EXPLAIN: u32 = 1048576;
pub const GUC_UNIT: u32 = 1044480;
pub const RelationRelationId: u32 = 1259;
pub const RelationRelation_Rowtype_Id: u32 = 83;
pub const Anum_pg_class_oid: u32 = 1;
pub const Anum_pg_class_relname: u32 = 2;
pub const Anum_pg_class_relnamespace: u32 = 3;
pub const Anum_pg_class_reltype: u32 = 4;
pub const Anum_pg_class_reloftype: u32 = 5;
pub const Anum_pg_class_relowner: u32 = 6;
pub const Anum_pg_class_relam: u32 = 7;
pub const Anum_pg_class_relfilenode: u32 = 8;
pub const Anum_pg_class_reltablespace: u32 = 9;
pub const Anum_pg_class_relpages: u32 = 10;
pub const Anum_pg_class_reltuples: u32 = 11;
pub const Anum_pg_class_relallvisible: u32 = 12;
pub const Anum_pg_class_reltoastrelid: u32 = 13;
pub const Anum_pg_class_relhasindex: u32 = 14;
pub const Anum_pg_class_relisshared: u32 = 15;
pub const Anum_pg_class_relpersistence: u32 = 16;
pub const Anum_pg_class_relkind: u32 = 17;
pub const Anum_pg_class_relnatts: u32 = 18;
pub const Anum_pg_class_relchecks: u32 = 19;
pub const Anum_pg_class_relhasrules: u32 = 20;
pub const Anum_pg_class_relhastriggers: u32 = 21;
pub const Anum_pg_class_relhassubclass: u32 = 22;
pub const Anum_pg_class_relrowsecurity: u32 = 23;
pub const Anum_pg_class_relforcerowsecurity: u32 = 24;
pub const Anum_pg_class_relispopulated: u32 = 25;
pub const Anum_pg_class_relreplident: u32 = 26;
pub const Anum_pg_class_relispartition: u32 = 27;
pub const Anum_pg_class_relrewrite: u32 = 28;
pub const Anum_pg_class_relfrozenxid: u32 = 29;
pub const Anum_pg_class_relminmxid: u32 = 30;
pub const Anum_pg_class_relacl: u32 = 31;
pub const Anum_pg_class_reloptions: u32 = 32;
pub const Anum_pg_class_relpartbound: u32 = 33;
pub const Natts_pg_class: u32 = 33;
pub const RELKIND_RELATION: u8 = 114u8;
pub const RELKIND_INDEX: u8 = 105u8;
pub const RELKIND_SEQUENCE: u8 = 83u8;
pub const RELKIND_TOASTVALUE: u8 = 116u8;
pub const RELKIND_VIEW: u8 = 118u8;
pub const RELKIND_MATVIEW: u8 = 109u8;
pub const RELKIND_COMPOSITE_TYPE: u8 = 99u8;
pub const RELKIND_FOREIGN_TABLE: u8 = 102u8;
pub const RELKIND_PARTITIONED_TABLE: u8 = 112u8;
pub const RELKIND_PARTITIONED_INDEX: u8 = 73u8;
pub const RELPERSISTENCE_PERMANENT: u8 = 112u8;
pub const RELPERSISTENCE_UNLOGGED: u8 = 117u8;
pub const RELPERSISTENCE_TEMP: u8 = 116u8;
pub const REPLICA_IDENTITY_DEFAULT: u8 = 100u8;
pub const REPLICA_IDENTITY_NOTHING: u8 = 110u8;
pub const REPLICA_IDENTITY_FULL: u8 = 102u8;
pub const REPLICA_IDENTITY_INDEX: u8 = 105u8;
pub const ClassOidIndexId: u32 = 2662;
pub const ClassNameNspIndexId: u32 = 2663;
pub const ClassTblspcRelfilenodeIndexId: u32 = 3455;
pub const IndexRelationId: u32 = 2610;
pub const Anum_pg_index_indexrelid: u32 = 1;
pub const Anum_pg_index_indrelid: u32 = 2;
pub const Anum_pg_index_indnatts: u32 = 3;
pub const Anum_pg_index_indnkeyatts: u32 = 4;
pub const Anum_pg_index_indisunique: u32 = 5;
pub const Anum_pg_index_indisprimary: u32 = 6;
pub const Anum_pg_index_indisexclusion: u32 = 7;
pub const Anum_pg_index_indimmediate: u32 = 8;
pub const Anum_pg_index_indisclustered: u32 = 9;
pub const Anum_pg_index_indisvalid: u32 = 10;
pub const Anum_pg_index_indcheckxmin: u32 = 11;
pub const Anum_pg_index_indisready: u32 = 12;
pub const Anum_pg_index_indislive: u32 = 13;
pub const Anum_pg_index_indisreplident: u32 = 14;
pub const Anum_pg_index_indkey: u32 = 15;
pub const Anum_pg_index_indcollation: u32 = 16;
pub const Anum_pg_index_indclass: u32 = 17;
pub const Anum_pg_index_indoption: u32 = 18;
pub const Anum_pg_index_indexprs: u32 = 19;
pub const Anum_pg_index_indpred: u32 = 20;
pub const Natts_pg_index: u32 = 20;
pub const INDOPTION_DESC: u32 = 1;
pub const INDOPTION_NULLS_FIRST: u32 = 2;
pub const IndexIndrelidIndexId: u32 = 2678;
pub const IndexRelidIndexId: u32 = 2679;
pub const PublicationRelationId: u32 = 6104;
pub const Anum_pg_publication_oid: u32 = 1;
pub const Anum_pg_publication_pubname: u32 = 2;
pub const Anum_pg_publication_pubowner: u32 = 3;
pub const Anum_pg_publication_puballtables: u32 = 4;
pub const Anum_pg_publication_pubinsert: u32 = 5;
pub const Anum_pg_publication_pubupdate: u32 = 6;
pub const Anum_pg_publication_pubdelete: u32 = 7;
pub const Anum_pg_publication_pubtruncate: u32 = 8;
pub const Anum_pg_publication_pubviaroot: u32 = 9;
pub const Natts_pg_publication: u32 = 9;
pub const PublicationObjectIndexId: u32 = 6110;
pub const PublicationNameIndexId: u32 = 6111;
pub const HEAP_MIN_FILLFACTOR: u32 = 10;
pub const HEAP_DEFAULT_FILLFACTOR: u32 = 100;
pub const DEFAULT_TABLE_ACCESS_METHOD: &[u8; 5usize] = b"heap\0";
pub const TABLE_INSERT_SKIP_FSM: u32 = 2;
pub const TABLE_INSERT_FROZEN: u32 = 4;
pub const TABLE_INSERT_NO_LOGICAL: u32 = 8;
pub const TUPLE_LOCK_FLAG_LOCK_UPDATE_IN_PROGRESS: u32 = 1;
pub const TUPLE_LOCK_FLAG_FIND_LAST_VERSION: u32 = 2;
pub const SHMEM_INDEX_KEYSIZE: u32 = 48;
pub const SHMEM_INDEX_SIZE: u32 = 64;
pub const HEAP_INSERT_SKIP_FSM: u32 = 2;
pub const HEAP_INSERT_FROZEN: u32 = 4;
pub const HEAP_INSERT_NO_LOGICAL: u32 = 8;
pub const HEAP_INSERT_SPECULATIVE: u32 = 16;
pub const LWLOCK_PADDED_SIZE: u32 = 128;
pub const NUM_INDIVIDUAL_LWLOCKS: u32 = 48;
pub const NUM_BUFFER_PARTITIONS: u32 = 128;
pub const LOG2_NUM_LOCK_PARTITIONS: u32 = 4;
pub const NUM_LOCK_PARTITIONS: u32 = 16;
pub const LOG2_NUM_PREDICATELOCK_PARTITIONS: u32 = 4;
pub const NUM_PREDICATELOCK_PARTITIONS: u32 = 16;
pub const BUFFER_MAPPING_LWLOCK_OFFSET: u32 = 48;
pub const LOCK_MANAGER_LWLOCK_OFFSET: u32 = 176;
pub const PREDICATELOCK_MANAGER_LWLOCK_OFFSET: u32 = 192;
pub const NUM_FIXED_LWLOCKS: u32 = 208;
pub const INTERVAL_FULL_RANGE: u32 = 32767;
pub const INTERVAL_RANGE_MASK: u32 = 32767;
pub const INTERVAL_FULL_PRECISION: u32 = 65535;
pub const INTERVAL_PRECISION_MASK: u32 = 65535;
pub const InvalidLocalTransactionId: u32 = 0;
pub const MAX_LOCKMODES: u32 = 10;
pub const DEFAULT_LOCKMETHOD: u32 = 1;
pub const USER_LOCKMETHOD: u32 = 2;
pub const PERFORM_DELETION_INTERNAL: u32 = 1;
pub const PERFORM_DELETION_CONCURRENTLY: u32 = 2;
pub const PERFORM_DELETION_QUIETLY: u32 = 4;
pub const PERFORM_DELETION_SKIP_ORIGINAL: u32 = 8;
pub const PERFORM_DELETION_SKIP_EXTENSIONS: u32 = 16;
pub const PERFORM_DELETION_CONCURRENT_LOCK: u32 = 32;
pub const DEFAULT_INDEX_TYPE: &[u8; 6usize] = b"btree\0";
pub const REINDEXOPT_VERBOSE: u32 = 1;
pub const REINDEXOPT_REPORT_PROGRESS: u32 = 2;
pub const REINDEXOPT_MISSING_OK: u32 = 4;
pub const REINDEXOPT_CONCURRENTLY: u32 = 8;
pub const INDEX_CREATE_IS_PRIMARY: u32 = 1;
pub const INDEX_CREATE_ADD_CONSTRAINT: u32 = 2;
pub const INDEX_CREATE_SKIP_BUILD: u32 = 4;
pub const INDEX_CREATE_CONCURRENT: u32 = 8;
pub const INDEX_CREATE_IF_NOT_EXISTS: u32 = 16;
pub const INDEX_CREATE_PARTITIONED: u32 = 32;
pub const INDEX_CREATE_INVALID: u32 = 64;
pub const INDEX_CONSTR_CREATE_MARK_AS_PRIMARY: u32 = 1;
pub const INDEX_CONSTR_CREATE_DEFERRABLE: u32 = 2;
pub const INDEX_CONSTR_CREATE_INIT_DEFERRED: u32 = 4;
pub const INDEX_CONSTR_CREATE_UPDATE_INDEX: u32 = 8;
pub const INDEX_CONSTR_CREATE_REMOVE_OLD_DEPS: u32 = 16;
pub const REINDEX_REL_PROCESS_TOAST: u32 = 1;
pub const REINDEX_REL_SUPPRESS_INDEX_USE: u32 = 2;
pub const REINDEX_REL_CHECK_CONSTRAINTS: u32 = 4;
pub const REINDEX_REL_FORCE_INDEXES_UNLOGGED: u32 = 8;
pub const REINDEX_REL_FORCE_INDEXES_PERMANENT: u32 = 16;
pub const AuthIdRelationId: u32 = 1260;
pub const AuthIdRelation_Rowtype_Id: u32 = 2842;
pub const Anum_pg_authid_oid: u32 = 1;
pub const Anum_pg_authid_rolname: u32 = 2;
pub const Anum_pg_authid_rolsuper: u32 = 3;
pub const Anum_pg_authid_rolinherit: u32 = 4;
pub const Anum_pg_authid_rolcreaterole: u32 = 5;
pub const Anum_pg_authid_rolcreatedb: u32 = 6;
pub const Anum_pg_authid_rolcanlogin: u32 = 7;
pub const Anum_pg_authid_rolreplication: u32 = 8;
pub const Anum_pg_authid_rolbypassrls: u32 = 9;
pub const Anum_pg_authid_rolconnlimit: u32 = 10;
pub const Anum_pg_authid_rolpassword: u32 = 11;
pub const Anum_pg_authid_rolvaliduntil: u32 = 12;
pub const Natts_pg_authid: u32 = 12;
pub const BOOTSTRAP_SUPERUSERID: u32 = 10;
pub const ROLE_PG_DATABASE_OWNER: u32 = 6171;
pub const ROLE_PG_READ_ALL_DATA: u32 = 6181;
pub const ROLE_PG_WRITE_ALL_DATA: u32 = 6182;
pub const ROLE_PG_MONITOR: u32 = 3373;
pub const ROLE_PG_READ_ALL_SETTINGS: u32 = 3374;
pub const ROLE_PG_READ_ALL_STATS: u32 = 3375;
pub const ROLE_PG_STAT_SCAN_TABLES: u32 = 3377;
pub const ROLE_PG_READ_SERVER_FILES: u32 = 4569;
pub const ROLE_PG_WRITE_SERVER_FILES: u32 = 4570;
pub const ROLE_PG_EXECUTE_SERVER_PROGRAM: u32 = 4571;
pub const ROLE_PG_SIGNAL_BACKEND: u32 = 4200;
pub const PgAuthidToastTable: u32 = 4175;
pub const PgAuthidToastIndex: u32 = 4176;
pub const AuthIdRolnameIndexId: u32 = 2676;
pub const AuthIdOidIndexId: u32 = 2677;
pub const EnumRelationId: u32 = 3501;
pub const Anum_pg_enum_oid: u32 = 1;
pub const Anum_pg_enum_enumtypid: u32 = 2;
pub const Anum_pg_enum_enumsortorder: u32 = 3;
pub const Anum_pg_enum_enumlabel: u32 = 4;
pub const Natts_pg_enum: u32 = 4;
pub const EnumOidIndexId: u32 = 3502;
pub const EnumTypIdLabelIndexId: u32 = 3503;
pub const EnumTypIdSortOrderIndexId: u32 = 3534;
pub const OperatorRelationId: u32 = 2617;
pub const Anum_pg_operator_oid: u32 = 1;
pub const Anum_pg_operator_oprname: u32 = 2;
pub const Anum_pg_operator_oprnamespace: u32 = 3;
pub const Anum_pg_operator_oprowner: u32 = 4;
pub const Anum_pg_operator_oprkind: u32 = 5;
pub const Anum_pg_operator_oprcanmerge: u32 = 6;
pub const Anum_pg_operator_oprcanhash: u32 = 7;
pub const Anum_pg_operator_oprleft: u32 = 8;
pub const Anum_pg_operator_oprright: u32 = 9;
pub const Anum_pg_operator_oprresult: u32 = 10;
pub const Anum_pg_operator_oprcom: u32 = 11;
pub const Anum_pg_operator_oprnegate: u32 = 12;
pub const Anum_pg_operator_oprcode: u32 = 13;
pub const Anum_pg_operator_oprrest: u32 = 14;
pub const Anum_pg_operator_oprjoin: u32 = 15;
pub const Natts_pg_operator: u32 = 15;
pub const BooleanNotEqualOperator: u32 = 85;
pub const BooleanEqualOperator: u32 = 91;
pub const Int4EqualOperator: u32 = 96;
pub const Int4LessOperator: u32 = 97;
pub const TextEqualOperator: u32 = 98;
pub const NameEqualTextOperator: u32 = 254;
pub const NameLessTextOperator: u32 = 255;
pub const NameGreaterEqualTextOperator: u32 = 257;
pub const TIDEqualOperator: u32 = 387;
pub const TIDLessOperator: u32 = 2799;
pub const TIDGreaterOperator: u32 = 2800;
pub const TIDLessEqOperator: u32 = 2801;
pub const TIDGreaterEqOperator: u32 = 2802;
pub const Int8LessOperator: u32 = 412;
pub const OID_NAME_REGEXEQ_OP: u32 = 639;
pub const OID_TEXT_REGEXEQ_OP: u32 = 641;
pub const TextLessOperator: u32 = 664;
pub const TextGreaterEqualOperator: u32 = 667;
pub const Float8LessOperator: u32 = 672;
pub const BpcharEqualOperator: u32 = 1054;
pub const OID_BPCHAR_REGEXEQ_OP: u32 = 1055;
pub const BpcharLessOperator: u32 = 1058;
pub const BpcharGreaterEqualOperator: u32 = 1061;
pub const ARRAY_EQ_OP: u32 = 1070;
pub const ARRAY_LT_OP: u32 = 1072;
pub const ARRAY_GT_OP: u32 = 1073;
pub const OID_NAME_LIKE_OP: u32 = 1207;
pub const OID_TEXT_LIKE_OP: u32 = 1209;
pub const OID_BPCHAR_LIKE_OP: u32 = 1211;
pub const OID_NAME_ICREGEXEQ_OP: u32 = 1226;
pub const OID_TEXT_ICREGEXEQ_OP: u32 = 1228;
pub const OID_BPCHAR_ICREGEXEQ_OP: u32 = 1234;
pub const OID_INET_SUB_OP: u32 = 931;
pub const OID_INET_SUBEQ_OP: u32 = 932;
pub const OID_INET_SUP_OP: u32 = 933;
pub const OID_INET_SUPEQ_OP: u32 = 934;
pub const OID_INET_OVERLAP_OP: u32 = 3552;
pub const OID_NAME_ICLIKE_OP: u32 = 1625;
pub const OID_TEXT_ICLIKE_OP: u32 = 1627;
pub const OID_BPCHAR_ICLIKE_OP: u32 = 1629;
pub const ByteaEqualOperator: u32 = 1955;
pub const ByteaLessOperator: u32 = 1957;
pub const ByteaGreaterEqualOperator: u32 = 1960;
pub const OID_BYTEA_LIKE_OP: u32 = 2016;
pub const TextPatternLessOperator: u32 = 2314;
pub const TextPatternGreaterEqualOperator: u32 = 2317;
pub const BpcharPatternLessOperator: u32 = 2326;
pub const BpcharPatternGreaterEqualOperator: u32 = 2329;
pub const OID_ARRAY_OVERLAP_OP: u32 = 2750;
pub const OID_ARRAY_CONTAINS_OP: u32 = 2751;
pub const OID_ARRAY_CONTAINED_OP: u32 = 2752;
pub const RECORD_EQ_OP: u32 = 2988;
pub const RECORD_LT_OP: u32 = 2990;
pub const RECORD_GT_OP: u32 = 2991;
pub const OID_RANGE_LESS_OP: u32 = 3884;
pub const OID_RANGE_LESS_EQUAL_OP: u32 = 3885;
pub const OID_RANGE_GREATER_EQUAL_OP: u32 = 3886;
pub const OID_RANGE_GREATER_OP: u32 = 3887;
pub const OID_RANGE_OVERLAP_OP: u32 = 3888;
pub const OID_RANGE_CONTAINS_ELEM_OP: u32 = 3889;
pub const OID_RANGE_CONTAINS_OP: u32 = 3890;
pub const OID_RANGE_ELEM_CONTAINED_OP: u32 = 3891;
pub const OID_RANGE_CONTAINED_OP: u32 = 3892;
pub const OID_RANGE_LEFT_OP: u32 = 3893;
pub const OID_RANGE_RIGHT_OP: u32 = 3894;
pub const OID_RANGE_OVERLAPS_LEFT_OP: u32 = 3895;
pub const OID_RANGE_OVERLAPS_RIGHT_OP: u32 = 3896;
pub const OID_MULTIRANGE_LESS_OP: u32 = 2862;
pub const OID_MULTIRANGE_LESS_EQUAL_OP: u32 = 2863;
pub const OID_MULTIRANGE_GREATER_EQUAL_OP: u32 = 2864;
pub const OID_MULTIRANGE_GREATER_OP: u32 = 2865;
pub const OID_RANGE_OVERLAPS_MULTIRANGE_OP: u32 = 2866;
pub const OID_MULTIRANGE_OVERLAPS_RANGE_OP: u32 = 2867;
pub const OID_MULTIRANGE_OVERLAPS_MULTIRANGE_OP: u32 = 2868;
pub const OID_MULTIRANGE_CONTAINS_ELEM_OP: u32 = 2869;
pub const OID_MULTIRANGE_CONTAINS_RANGE_OP: u32 = 2870;
pub const OID_MULTIRANGE_CONTAINS_MULTIRANGE_OP: u32 = 2871;
pub const OID_MULTIRANGE_ELEM_CONTAINED_OP: u32 = 2872;
pub const OID_MULTIRANGE_RANGE_CONTAINED_OP: u32 = 2873;
pub const OID_MULTIRANGE_MULTIRANGE_CONTAINED_OP: u32 = 2874;
pub const OID_RANGE_CONTAINS_MULTIRANGE_OP: u32 = 4539;
pub const OID_RANGE_MULTIRANGE_CONTAINED_OP: u32 = 4540;
pub const OID_RANGE_OVERLAPS_LEFT_MULTIRANGE_OP: u32 = 2875;
pub const OID_MULTIRANGE_OVERLAPS_LEFT_RANGE_OP: u32 = 2876;
pub const OID_MULTIRANGE_OVERLAPS_LEFT_MULTIRANGE_OP: u32 = 2877;
pub const OID_RANGE_OVERLAPS_RIGHT_MULTIRANGE_OP: u32 = 3585;
pub const OID_MULTIRANGE_OVERLAPS_RIGHT_RANGE_OP: u32 = 4035;
pub const OID_MULTIRANGE_OVERLAPS_RIGHT_MULTIRANGE_OP: u32 = 4142;
pub const OID_RANGE_ADJACENT_MULTIRANGE_OP: u32 = 4179;
pub const OID_MULTIRANGE_ADJACENT_RANGE_OP: u32 = 4180;
pub const OID_MULTIRANGE_ADJACENT_MULTIRANGE_OP: u32 = 4198;
pub const OID_RANGE_LEFT_MULTIRANGE_OP: u32 = 4395;
pub const OID_MULTIRANGE_LEFT_RANGE_OP: u32 = 4396;
pub const OID_MULTIRANGE_LEFT_MULTIRANGE_OP: u32 = 4397;
pub const OID_RANGE_RIGHT_MULTIRANGE_OP: u32 = 4398;
pub const OID_MULTIRANGE_RIGHT_RANGE_OP: u32 = 4399;
pub const OID_MULTIRANGE_RIGHT_MULTIRANGE_OP: u32 = 4400;
pub const OperatorOidIndexId: u32 = 2688;
pub const OperatorNameNspIndexId: u32 = 2689;
pub const ProcedureRelationId: u32 = 1255;
pub const ProcedureRelation_Rowtype_Id: u32 = 81;
pub const Anum_pg_proc_oid: u32 = 1;
pub const Anum_pg_proc_proname: u32 = 2;
pub const Anum_pg_proc_pronamespace: u32 = 3;
pub const Anum_pg_proc_proowner: u32 = 4;
pub const Anum_pg_proc_prolang: u32 = 5;
pub const Anum_pg_proc_procost: u32 = 6;
pub const Anum_pg_proc_prorows: u32 = 7;
pub const Anum_pg_proc_provariadic: u32 = 8;
pub const Anum_pg_proc_prosupport: u32 = 9;
pub const Anum_pg_proc_prokind: u32 = 10;
pub const Anum_pg_proc_prosecdef: u32 = 11;
pub const Anum_pg_proc_proleakproof: u32 = 12;
pub const Anum_pg_proc_proisstrict: u32 = 13;
pub const Anum_pg_proc_proretset: u32 = 14;
pub const Anum_pg_proc_provolatile: u32 = 15;
pub const Anum_pg_proc_proparallel: u32 = 16;
pub const Anum_pg_proc_pronargs: u32 = 17;
pub const Anum_pg_proc_pronargdefaults: u32 = 18;
pub const Anum_pg_proc_prorettype: u32 = 19;
pub const Anum_pg_proc_proargtypes: u32 = 20;
pub const Anum_pg_proc_proallargtypes: u32 = 21;
pub const Anum_pg_proc_proargmodes: u32 = 22;
pub const Anum_pg_proc_proargnames: u32 = 23;
pub const Anum_pg_proc_proargdefaults: u32 = 24;
pub const Anum_pg_proc_protrftypes: u32 = 25;
pub const Anum_pg_proc_prosrc: u32 = 26;
pub const Anum_pg_proc_probin: u32 = 27;
pub const Anum_pg_proc_prosqlbody: u32 = 28;
pub const Anum_pg_proc_proconfig: u32 = 29;
pub const Anum_pg_proc_proacl: u32 = 30;
pub const Natts_pg_proc: u32 = 30;
pub const PROKIND_FUNCTION: u8 = 102u8;
pub const PROKIND_AGGREGATE: u8 = 97u8;
pub const PROKIND_WINDOW: u8 = 119u8;
pub const PROKIND_PROCEDURE: u8 = 112u8;
pub const PROVOLATILE_IMMUTABLE: u8 = 105u8;
pub const PROVOLATILE_STABLE: u8 = 115u8;
pub const PROVOLATILE_VOLATILE: u8 = 118u8;
pub const PROPARALLEL_SAFE: u8 = 115u8;
pub const PROPARALLEL_RESTRICTED: u8 = 114u8;
pub const PROPARALLEL_UNSAFE: u8 = 117u8;
pub const PROARGMODE_IN: u8 = 105u8;
pub const PROARGMODE_OUT: u8 = 111u8;
pub const PROARGMODE_INOUT: u8 = 98u8;
pub const PROARGMODE_VARIADIC: u8 = 118u8;
pub const PROARGMODE_TABLE: u8 = 116u8;
pub const ProcedureOidIndexId: u32 = 2690;
pub const ProcedureNameArgsNspIndexId: u32 = 2691;
pub const TriggerRelationId: u32 = 2620;
pub const Anum_pg_trigger_oid: u32 = 1;
pub const Anum_pg_trigger_tgrelid: u32 = 2;
pub const Anum_pg_trigger_tgparentid: u32 = 3;
pub const Anum_pg_trigger_tgname: u32 = 4;
pub const Anum_pg_trigger_tgfoid: u32 = 5;
pub const Anum_pg_trigger_tgtype: u32 = 6;
pub const Anum_pg_trigger_tgenabled: u32 = 7;
pub const Anum_pg_trigger_tgisinternal: u32 = 8;
pub const Anum_pg_trigger_tgconstrrelid: u32 = 9;
pub const Anum_pg_trigger_tgconstrindid: u32 = 10;
pub const Anum_pg_trigger_tgconstraint: u32 = 11;
pub const Anum_pg_trigger_tgdeferrable: u32 = 12;
pub const Anum_pg_trigger_tginitdeferred: u32 = 13;
pub const Anum_pg_trigger_tgnargs: u32 = 14;
pub const Anum_pg_trigger_tgattr: u32 = 15;
pub const Anum_pg_trigger_tgargs: u32 = 16;
pub const Anum_pg_trigger_tgqual: u32 = 17;
pub const Anum_pg_trigger_tgoldtable: u32 = 18;
pub const Anum_pg_trigger_tgnewtable: u32 = 19;
pub const Natts_pg_trigger: u32 = 19;
pub const TRIGGER_TYPE_ROW: u32 = 1;
pub const TRIGGER_TYPE_BEFORE: u32 = 2;
pub const TRIGGER_TYPE_INSERT: u32 = 4;
pub const TRIGGER_TYPE_DELETE: u32 = 8;
pub const TRIGGER_TYPE_UPDATE: u32 = 16;
pub const TRIGGER_TYPE_TRUNCATE: u32 = 32;
pub const TRIGGER_TYPE_INSTEAD: u32 = 64;
pub const TRIGGER_TYPE_LEVEL_MASK: u32 = 1;
pub const TRIGGER_TYPE_STATEMENT: u32 = 0;
pub const TRIGGER_TYPE_TIMING_MASK: u32 = 66;
pub const TRIGGER_TYPE_AFTER: u32 = 0;
pub const TRIGGER_TYPE_EVENT_MASK: u32 = 60;
pub const TriggerConstraintIndexId: u32 = 2699;
pub const TriggerRelidNameIndexId: u32 = 2701;
pub const TriggerOidIndexId: u32 = 2702;
pub const TypeOidIndexId: u32 = 2703;
pub const TypeNameNspIndexId: u32 = 2704;
pub const EventTriggerRelationId: u32 = 3466;
pub const Anum_pg_event_trigger_oid: u32 = 1;
pub const Anum_pg_event_trigger_evtname: u32 = 2;
pub const Anum_pg_event_trigger_evtevent: u32 = 3;
pub const Anum_pg_event_trigger_evtowner: u32 = 4;
pub const Anum_pg_event_trigger_evtfoid: u32 = 5;
pub const Anum_pg_event_trigger_evtenabled: u32 = 6;
pub const Anum_pg_event_trigger_evttags: u32 = 7;
pub const Natts_pg_event_trigger: u32 = 7;
pub const EventTriggerNameIndexId: u32 = 3467;
pub const EventTriggerOidIndexId: u32 = 3468;
pub const AT_REWRITE_ALTER_PERSISTENCE: u32 = 1;
pub const AT_REWRITE_DEFAULT_VAL: u32 = 2;
pub const AT_REWRITE_COLUMN_REWRITE: u32 = 4;
pub const TRIGGER_EVENT_INSERT: u32 = 0;
pub const TRIGGER_EVENT_DELETE: u32 = 1;
pub const TRIGGER_EVENT_UPDATE: u32 = 2;
pub const TRIGGER_EVENT_TRUNCATE: u32 = 3;
pub const TRIGGER_EVENT_OPMASK: u32 = 3;
pub const TRIGGER_EVENT_ROW: u32 = 4;
pub const TRIGGER_EVENT_BEFORE: u32 = 8;
pub const TRIGGER_EVENT_AFTER: u32 = 0;
pub const TRIGGER_EVENT_INSTEAD: u32 = 16;
pub const TRIGGER_EVENT_TIMINGMASK: u32 = 24;
pub const AFTER_TRIGGER_DEFERRABLE: u32 = 32;
pub const AFTER_TRIGGER_INITDEFERRED: u32 = 64;
pub const SESSION_REPLICATION_ROLE_ORIGIN: u32 = 0;
pub const SESSION_REPLICATION_ROLE_REPLICA: u32 = 1;
pub const SESSION_REPLICATION_ROLE_LOCAL: u32 = 2;
pub const TRIGGER_FIRES_ON_ORIGIN: u8 = 79u8;
pub const TRIGGER_FIRES_ALWAYS: u8 = 65u8;
pub const TRIGGER_FIRES_ON_REPLICA: u8 = 82u8;
pub const TRIGGER_DISABLED: u8 = 68u8;
pub const RI_TRIGGER_PK: u32 = 1;
pub const RI_TRIGGER_FK: u32 = 2;
pub const RI_TRIGGER_NONE: u32 = 0;
pub const StatisticRelationId: u32 = 2619;
pub const Anum_pg_statistic_starelid: u32 = 1;
pub const Anum_pg_statistic_staattnum: u32 = 2;
pub const Anum_pg_statistic_stainherit: u32 = 3;
pub const Anum_pg_statistic_stanullfrac: u32 = 4;
pub const Anum_pg_statistic_stawidth: u32 = 5;
pub const Anum_pg_statistic_stadistinct: u32 = 6;
pub const Anum_pg_statistic_stakind1: u32 = 7;
pub const Anum_pg_statistic_stakind2: u32 = 8;
pub const Anum_pg_statistic_stakind3: u32 = 9;
pub const Anum_pg_statistic_stakind4: u32 = 10;
pub const Anum_pg_statistic_stakind5: u32 = 11;
pub const Anum_pg_statistic_staop1: u32 = 12;
pub const Anum_pg_statistic_staop2: u32 = 13;
pub const Anum_pg_statistic_staop3: u32 = 14;
pub const Anum_pg_statistic_staop4: u32 = 15;
pub const Anum_pg_statistic_staop5: u32 = 16;
pub const Anum_pg_statistic_stacoll1: u32 = 17;
pub const Anum_pg_statistic_stacoll2: u32 = 18;
pub const Anum_pg_statistic_stacoll3: u32 = 19;
pub const Anum_pg_statistic_stacoll4: u32 = 20;
pub const Anum_pg_statistic_stacoll5: u32 = 21;
pub const Anum_pg_statistic_stanumbers1: u32 = 22;
pub const Anum_pg_statistic_stanumbers2: u32 = 23;
pub const Anum_pg_statistic_stanumbers3: u32 = 24;
pub const Anum_pg_statistic_stanumbers4: u32 = 25;
pub const Anum_pg_statistic_stanumbers5: u32 = 26;
pub const Anum_pg_statistic_stavalues1: u32 = 27;
pub const Anum_pg_statistic_stavalues2: u32 = 28;
pub const Anum_pg_statistic_stavalues3: u32 = 29;
pub const Anum_pg_statistic_stavalues4: u32 = 30;
pub const Anum_pg_statistic_stavalues5: u32 = 31;
pub const Natts_pg_statistic: u32 = 31;
pub const STATISTIC_KIND_MCV: u32 = 1;
pub const STATISTIC_KIND_HISTOGRAM: u32 = 2;
pub const STATISTIC_KIND_CORRELATION: u32 = 3;
pub const STATISTIC_KIND_MCELEM: u32 = 4;
pub const STATISTIC_KIND_DECHIST: u32 = 5;
pub const STATISTIC_KIND_RANGE_LENGTH_HISTOGRAM: u32 = 6;
pub const STATISTIC_KIND_BOUNDS_HISTOGRAM: u32 = 7;
pub const STATISTIC_NUM_SLOTS: u32 = 5;
pub const StatisticRelidAttnumInhIndexId: u32 = 2696;
pub const VACUUM_OPTION_NO_PARALLEL: u32 = 0;
pub const VACUUM_OPTION_PARALLEL_BULKDEL: u32 = 1;
pub const VACUUM_OPTION_PARALLEL_COND_CLEANUP: u32 = 2;
pub const VACUUM_OPTION_PARALLEL_CLEANUP: u32 = 4;
pub const VACUUM_OPTION_MAX_VALID_VALUE: u32 = 7;
pub const VACOPT_VACUUM: u32 = 1;
pub const VACOPT_ANALYZE: u32 = 2;
pub const VACOPT_VERBOSE: u32 = 4;
pub const VACOPT_FREEZE: u32 = 8;
pub const VACOPT_FULL: u32 = 16;
pub const VACOPT_SKIP_LOCKED: u32 = 32;
pub const VACOPT_PROCESS_TOAST: u32 = 64;
pub const VACOPT_DISABLE_PAGE_SKIPPING: u32 = 128;
pub const CACHEDPLANSOURCE_MAGIC: u32 = 195726186;
pub const CACHEDPLAN_MAGIC: u32 = 953717834;
pub const CACHEDEXPR_MAGIC: u32 = 838275847;
pub const SPI_ERROR_CONNECT: i32 = -1;
pub const SPI_ERROR_COPY: i32 = -2;
pub const SPI_ERROR_OPUNKNOWN: i32 = -3;
pub const SPI_ERROR_UNCONNECTED: i32 = -4;
pub const SPI_ERROR_CURSOR: i32 = -5;
pub const SPI_ERROR_ARGUMENT: i32 = -6;
pub const SPI_ERROR_PARAM: i32 = -7;
pub const SPI_ERROR_TRANSACTION: i32 = -8;
pub const SPI_ERROR_NOATTRIBUTE: i32 = -9;
pub const SPI_ERROR_NOOUTFUNC: i32 = -10;
pub const SPI_ERROR_TYPUNKNOWN: i32 = -11;
pub const SPI_ERROR_REL_DUPLICATE: i32 = -12;
pub const SPI_ERROR_REL_NOT_FOUND: i32 = -13;
pub const SPI_OK_CONNECT: u32 = 1;
pub const SPI_OK_FINISH: u32 = 2;
pub const SPI_OK_FETCH: u32 = 3;
pub const SPI_OK_UTILITY: u32 = 4;
pub const SPI_OK_SELECT: u32 = 5;
pub const SPI_OK_SELINTO: u32 = 6;
pub const SPI_OK_INSERT: u32 = 7;
pub const SPI_OK_DELETE: u32 = 8;
pub const SPI_OK_UPDATE: u32 = 9;
pub const SPI_OK_CURSOR: u32 = 10;
pub const SPI_OK_INSERT_RETURNING: u32 = 11;
pub const SPI_OK_DELETE_RETURNING: u32 = 12;
pub const SPI_OK_UPDATE_RETURNING: u32 = 13;
pub const SPI_OK_REWRITTEN: u32 = 14;
pub const SPI_OK_REL_REGISTER: u32 = 15;
pub const SPI_OK_REL_UNREGISTER: u32 = 16;
pub const SPI_OK_TD_REGISTER: u32 = 17;
pub const SPI_OPT_NONATOMIC: u32 = 1;
pub const BGWORKER_SHMEM_ACCESS: u32 = 1;
pub const BGWORKER_BACKEND_DATABASE_CONNECTION: u32 = 2;
pub const BGWORKER_CLASS_PARALLEL: u32 = 16;
pub const BGW_DEFAULT_RESTART_INTERVAL: u32 = 60;
pub const BGW_NEVER_RESTART: i32 = -1;
pub const BGW_MAXLEN: u32 = 96;
pub const BGW_EXTRALEN: u32 = 128;
pub const BGWORKER_BYPASS_ALLOWCONN: u32 = 1;
pub const TRANSACTION_STATUS_IN_PROGRESS: u32 = 0;
pub const TRANSACTION_STATUS_COMMITTED: u32 = 1;
pub const TRANSACTION_STATUS_ABORTED: u32 = 2;
pub const TRANSACTION_STATUS_SUB_COMMITTED: u32 = 3;
pub const CLOG_ZEROPAGE: u32 = 0;
pub const CLOG_TRUNCATE: u32 = 16;
pub const WL_LATCH_SET: u32 = 1;
pub const WL_SOCKET_READABLE: u32 = 2;
pub const WL_SOCKET_WRITEABLE: u32 = 4;
pub const WL_TIMEOUT: u32 = 8;
pub const WL_POSTMASTER_DEATH: u32 = 16;
pub const WL_EXIT_ON_PM_DEATH: u32 = 32;
pub const WL_SOCKET_CONNECTED: u32 = 4;
pub const WL_SOCKET_MASK: u32 = 6;
pub const PGPROC_MAX_CACHED_SUBXIDS: u32 = 64;
pub const PROC_IS_AUTOVACUUM: u32 = 1;
pub const PROC_IN_VACUUM: u32 = 2;
pub const PROC_IN_SAFE_IC: u32 = 4;
pub const PROC_VACUUM_FOR_WRAPAROUND: u32 = 8;
pub const PROC_IN_LOGICAL_DECODING: u32 = 16;
pub const PROC_VACUUM_STATE_MASK: u32 = 14;
pub const FP_LOCK_SLOTS_PER_BACKEND: u32 = 16;
pub const INVALID_PGPROCNO: u32 = 2147483647;
pub const NUM_AUXILIARY_PROCS: u32 = 5;
pub const HAVE_PLANNERINFO_TYPEDEF: u32 = 1;
pub const AMFLAG_HAS_TID_RANGE: u32 = 1;
pub const HAVE_INDEXOPTINFO_TYPEDEF: u32 = 1;
pub const HAVE_SPECIALJOININFO_TYPEDEF: u32 = 1;
pub const GROUPING_CAN_USE_SORT: u32 = 1;
pub const GROUPING_CAN_USE_HASH: u32 = 2;
pub const GROUPING_CAN_PARTIAL_AGG: u32 = 4;
pub const FSV_MISSING_OK: u32 = 1;
pub const FDW_MISSING_OK: u32 = 1;
pub const MAX_MULTIBYTE_CHAR_LEN: u32 = 4;
pub const SS2: u32 = 142;
pub const SS3: u32 = 143;
pub const LC_ISO8859_1: u32 = 129;
pub const LC_ISO8859_2: u32 = 130;
pub const LC_ISO8859_3: u32 = 131;
pub const LC_ISO8859_4: u32 = 132;
pub const LC_TIS620: u32 = 133;
pub const LC_ISO8859_7: u32 = 134;
pub const LC_ISO8859_6: u32 = 135;
pub const LC_ISO8859_8: u32 = 136;
pub const LC_JISX0201K: u32 = 137;
pub const LC_JISX0201R: u32 = 138;
pub const LC_KOI8_R: u32 = 139;
pub const LC_ISO8859_5: u32 = 140;
pub const LC_ISO8859_9: u32 = 141;
pub const LC_ISO8859_15: u32 = 142;
pub const LC_JISX0208_1978: u32 = 144;
pub const LC_GB2312_80: u32 = 145;
pub const LC_JISX0208: u32 = 146;
pub const LC_KS5601: u32 = 147;
pub const LC_JISX0212: u32 = 148;
pub const LC_CNS11643_1: u32 = 149;
pub const LC_CNS11643_2: u32 = 150;
pub const LC_JISX0213_1: u32 = 151;
pub const LC_BIG5_1: u32 = 152;
pub const LC_BIG5_2: u32 = 153;
pub const LCPRV1_A: u32 = 154;
pub const LCPRV1_B: u32 = 155;
pub const LCPRV2_A: u32 = 156;
pub const LCPRV2_B: u32 = 157;
pub const LC_SISHENG: u32 = 160;
pub const LC_IPA: u32 = 161;
pub const LC_VISCII_LOWER: u32 = 162;
pub const LC_VISCII_UPPER: u32 = 163;
pub const LC_ARABIC_DIGIT: u32 = 164;
pub const LC_ARABIC_1_COLUMN: u32 = 165;
pub const LC_ASCII_RIGHT_TO_LEFT: u32 = 166;
pub const LC_LAO: u32 = 167;
pub const LC_ARABIC_2_COLUMN: u32 = 168;
pub const LC_INDIAN_1_COLUMN: u32 = 240;
pub const LC_TIBETAN_1_COLUMN: u32 = 241;
pub const LC_UNICODE_SUBSET_2: u32 = 242;
pub const LC_UNICODE_SUBSET_3: u32 = 243;
pub const LC_UNICODE_SUBSET: u32 = 244;
pub const LC_ETHIOPIC: u32 = 245;
pub const LC_CNS11643_3: u32 = 246;
pub const LC_CNS11643_4: u32 = 247;
pub const LC_CNS11643_5: u32 = 248;
pub const LC_CNS11643_6: u32 = 249;
pub const LC_CNS11643_7: u32 = 250;
pub const LC_INDIAN_2_COLUMN: u32 = 251;
pub const LC_TIBETAN: u32 = 252;
pub const MAX_CONVERSION_GROWTH: u32 = 4;
pub const MAX_CONVERSION_INPUT_LENGTH: u32 = 16;
pub const MAX_UNICODE_EQUIVALENT_STRING: u32 = 16;
pub const EXTNODENAME_MAX_LEN: u32 = 64;
pub const CUSTOMPATH_SUPPORT_BACKWARD_SCAN: u32 = 1;
pub const CUSTOMPATH_SUPPORT_MARK_RESTORE: u32 = 2;
pub const QTW_IGNORE_RT_SUBQUERIES: u32 = 1;
pub const QTW_IGNORE_CTE_SUBQUERIES: u32 = 2;
pub const QTW_IGNORE_RC_SUBQUERIES: u32 = 3;
pub const QTW_IGNORE_JOINALIASES: u32 = 4;
pub const QTW_IGNORE_RANGE_TABLE: u32 = 8;
pub const QTW_EXAMINE_RTES_BEFORE: u32 = 16;
pub const QTW_EXAMINE_RTES_AFTER: u32 = 32;
pub const QTW_DONT_COPY_QUERY: u32 = 64;
pub const QTW_EXAMINE_SORTGROUP: u32 = 128;
pub const DEFAULT_SEQ_PAGE_COST: f64 = 1.0;
pub const DEFAULT_RANDOM_PAGE_COST: f64 = 4.0;
pub const DEFAULT_CPU_TUPLE_COST: f64 = 0.01;
pub const DEFAULT_CPU_INDEX_TUPLE_COST: f64 = 0.005;
pub const DEFAULT_CPU_OPERATOR_COST: f64 = 0.0025;
pub const DEFAULT_PARALLEL_TUPLE_COST: f64 = 0.1;
pub const DEFAULT_PARALLEL_SETUP_COST: f64 = 1000.0;
pub const DEFAULT_EFFECTIVE_CACHE_SIZE: u32 = 524288;
pub const PVC_INCLUDE_AGGREGATES: u32 = 1;
pub const PVC_RECURSE_AGGREGATES: u32 = 2;
pub const PVC_INCLUDE_WINDOWFUNCS: u32 = 4;
pub const PVC_RECURSE_WINDOWFUNCS: u32 = 8;
pub const PVC_INCLUDE_PLACEHOLDERS: u32 = 16;
pub const PVC_RECURSE_PLACEHOLDERS: u32 = 32;
pub const DEFAULT_CURSOR_TUPLE_FRACTION: f64 = 0.1;
pub const RBTXN_HAS_CATALOG_CHANGES: u32 = 1;
pub const RBTXN_IS_SUBXACT: u32 = 2;
pub const RBTXN_IS_SERIALIZED: u32 = 4;
pub const RBTXN_IS_SERIALIZED_CLEAR: u32 = 8;
pub const RBTXN_IS_STREAMED: u32 = 16;
pub const RBTXN_HAS_PARTIAL_CHANGE: u32 = 32;
pub const RBTXN_PREPARE: u32 = 64;
pub const RBTXN_SKIPPED_PREPARE: u32 = 128;
pub const OLD_SNAPSHOT_PADDING_ENTRIES: u32 = 10;
pub const MAX_IO_CONCURRENCY: u32 = 1000;
pub const BUFFER_LOCK_UNLOCK: u32 = 0;
pub const BUFFER_LOCK_SHARE: u32 = 1;
pub const BUFFER_LOCK_EXCLUSIVE: u32 = 2;
pub const XLOG_STANDBY_LOCK: u32 = 0;
pub const XLOG_RUNNING_XACTS: u32 = 16;
pub const XLOG_INVALIDATIONS: u32 = 32;
pub const STACK_DEPTH_SLOP: u32 = 524288;
pub const COMMAND_OK_IN_READ_ONLY_TXN: u32 = 1;
pub const COMMAND_OK_IN_PARALLEL_MODE: u32 = 2;
pub const COMMAND_OK_IN_RECOVERY: u32 = 4;
pub const COMMAND_IS_STRICTLY_READ_ONLY: u32 = 7;
pub const COMMAND_IS_NOT_READ_ONLY: u32 = 0;
pub const MAXSTRLEN: u32 = 2047;
pub const MAXSTRPOS: u32 = 1048575;
pub const MAXENTRYPOS: u32 = 16384;
pub const MAXNUMPOS: u32 = 256;
pub const QI_VAL: u32 = 1;
pub const QI_OPR: u32 = 2;
pub const QI_VALSTOP: u32 = 3;
pub const OP_NOT: u32 = 1;
pub const OP_AND: u32 = 2;
pub const OP_OR: u32 = 3;
pub const OP_PHRASE: u32 = 4;
pub const OP_COUNT: u32 = 4;
pub const TSL_ADDPOS: u32 = 1;
pub const TSL_PREFIX: u32 = 2;
pub const TSL_FILTER: u32 = 4;
pub const P_TSV_OPR_IS_DELIM: u32 = 1;
pub const P_TSV_IS_TSQUERY: u32 = 2;
pub const P_TSV_IS_WEB: u32 = 4;
pub const P_TSQ_PLAIN: u32 = 1;
pub const P_TSQ_WEB: u32 = 2;
pub const TS_EXEC_EMPTY: u32 = 0;
pub const TS_EXEC_SKIP_NOT: u32 = 1;
pub const TS_EXEC_PHRASE_NO_POS: u32 = 2;
pub const TSearchStrategyNumber: u32 = 1;
pub const TSearchWithClassStrategyNumber: u32 = 2;
pub const QTN_NEEDFREE: u32 = 1;
pub const QTN_NOCHANGE: u32 = 2;
pub const QTN_WORDFREE: u32 = 4;
pub const MAXINT8LEN: u32 = 20;
pub const FORMAT_TYPE_TYPEMOD_GIVEN: u32 = 1;
pub const FORMAT_TYPE_ALLOW_INVALID: u32 = 2;
pub const FORMAT_TYPE_FORCE_QUALIFY: u32 = 4;
pub const FORMAT_TYPE_INVALID_AS_NULL: u32 = 8;
pub const MAX_TIME_PRECISION: u32 = 6;
pub const DAGO: &[u8; 4usize] = b"ago\0";
pub const DCURRENT: &[u8; 8usize] = b"current\0";
pub const EPOCH: &[u8; 6usize] = b"epoch\0";
pub const INVALID: &[u8; 8usize] = b"invalid\0";
pub const EARLY: &[u8; 10usize] = b"-infinity\0";
pub const LATE: &[u8; 9usize] = b"infinity\0";
pub const NOW: &[u8; 4usize] = b"now\0";
pub const TODAY: &[u8; 6usize] = b"today\0";
pub const TOMORROW: &[u8; 9usize] = b"tomorrow\0";
pub const YESTERDAY: &[u8; 10usize] = b"yesterday\0";
pub const ZULU: &[u8; 5usize] = b"zulu\0";
pub const DMICROSEC: &[u8; 8usize] = b"usecond\0";
pub const DMILLISEC: &[u8; 8usize] = b"msecond\0";
pub const DSECOND: &[u8; 7usize] = b"second\0";
pub const DMINUTE: &[u8; 7usize] = b"minute\0";
pub const DHOUR: &[u8; 5usize] = b"hour\0";
pub const DDAY: &[u8; 4usize] = b"day\0";
pub const DWEEK: &[u8; 5usize] = b"week\0";
pub const DMONTH: &[u8; 6usize] = b"month\0";
pub const DQUARTER: &[u8; 8usize] = b"quarter\0";
pub const DYEAR: &[u8; 5usize] = b"year\0";
pub const DDECADE: &[u8; 7usize] = b"decade\0";
pub const DCENTURY: &[u8; 8usize] = b"century\0";
pub const DMILLENNIUM: &[u8; 11usize] = b"millennium\0";
pub const DA_D: &[u8; 3usize] = b"ad\0";
pub const DB_C: &[u8; 3usize] = b"bc\0";
pub const DTIMEZONE: &[u8; 9usize] = b"timezone\0";
pub const AM: u32 = 0;
pub const PM: u32 = 1;
pub const HR24: u32 = 2;
pub const AD: u32 = 0;
pub const BC: u32 = 1;
pub const RESERV: u32 = 0;
pub const MONTH: u32 = 1;
pub const YEAR: u32 = 2;
pub const DAY: u32 = 3;
pub const JULIAN: u32 = 4;
pub const TZ: u32 = 5;
pub const DTZ: u32 = 6;
pub const DYNTZ: u32 = 7;
pub const IGNORE_DTF: u32 = 8;
pub const AMPM: u32 = 9;
pub const HOUR: u32 = 10;
pub const MINUTE: u32 = 11;
pub const SECOND: u32 = 12;
pub const MILLISECOND: u32 = 13;
pub const MICROSECOND: u32 = 14;
pub const DOY: u32 = 15;
pub const DOW: u32 = 16;
pub const UNITS: u32 = 17;
pub const ADBC: u32 = 18;
pub const AGO: u32 = 19;
pub const ABS_BEFORE: u32 = 20;
pub const ABS_AFTER: u32 = 21;
pub const ISODATE: u32 = 22;
pub const ISOTIME: u32 = 23;
pub const WEEK: u32 = 24;
pub const DECADE: u32 = 25;
pub const CENTURY: u32 = 26;
pub const MILLENNIUM: u32 = 27;
pub const DTZMOD: u32 = 28;
pub const UNKNOWN_FIELD: u32 = 31;
pub const DTK_NUMBER: u32 = 0;
pub const DTK_STRING: u32 = 1;
pub const DTK_DATE: u32 = 2;
pub const DTK_TIME: u32 = 3;
pub const DTK_TZ: u32 = 4;
pub const DTK_AGO: u32 = 5;
pub const DTK_SPECIAL: u32 = 6;
pub const DTK_EARLY: u32 = 9;
pub const DTK_LATE: u32 = 10;
pub const DTK_EPOCH: u32 = 11;
pub const DTK_NOW: u32 = 12;
pub const DTK_YESTERDAY: u32 = 13;
pub const DTK_TODAY: u32 = 14;
pub const DTK_TOMORROW: u32 = 15;
pub const DTK_ZULU: u32 = 16;
pub const DTK_DELTA: u32 = 17;
pub const DTK_SECOND: u32 = 18;
pub const DTK_MINUTE: u32 = 19;
pub const DTK_HOUR: u32 = 20;
pub const DTK_DAY: u32 = 21;
pub const DTK_WEEK: u32 = 22;
pub const DTK_MONTH: u32 = 23;
pub const DTK_QUARTER: u32 = 24;
pub const DTK_YEAR: u32 = 25;
pub const DTK_DECADE: u32 = 26;
pub const DTK_CENTURY: u32 = 27;
pub const DTK_MILLENNIUM: u32 = 28;
pub const DTK_MILLISEC: u32 = 29;
pub const DTK_MICROSEC: u32 = 30;
pub const DTK_JULIAN: u32 = 31;
pub const DTK_DOW: u32 = 32;
pub const DTK_DOY: u32 = 33;
pub const DTK_TZ_HOUR: u32 = 34;
pub const DTK_TZ_MINUTE: u32 = 35;
pub const DTK_ISOYEAR: u32 = 36;
pub const DTK_ISODOW: u32 = 37;
pub const MAXDATELEN: u32 = 128;
pub const MAXDATEFIELDS: u32 = 25;
pub const TOKMAXLEN: u32 = 10;
pub const DTERR_BAD_FORMAT: i32 = -1;
pub const DTERR_FIELD_OVERFLOW: i32 = -2;
pub const DTERR_MD_FIELD_OVERFLOW: i32 = -3;
pub const DTERR_INTERVAL_OVERFLOW: i32 = -4;
pub const DTERR_TZDISP_OVERFLOW: i32 = -5;
pub const RADIANS_PER_DEGREE: f64 = 0.017453292519943295;
pub const NUMERIC_MAX_PRECISION: u32 = 1000;
pub const NUMERIC_MAX_DISPLAY_SCALE: u32 = 1000;
pub const NUMERIC_MIN_DISPLAY_SCALE: u32 = 0;
pub const NUMERIC_MAX_RESULT_SCALE: u32 = 2000;
pub const NUMERIC_MIN_SIG_DIGITS: u32 = 16;
pub const JsonbContainsStrategyNumber: u32 = 7;
pub const JsonbExistsStrategyNumber: u32 = 9;
pub const JsonbExistsAnyStrategyNumber: u32 = 10;
pub const JsonbExistsAllStrategyNumber: u32 = 11;
pub const JsonbJsonpathExistsStrategyNumber: u32 = 15;
pub const JsonbJsonpathPredicateStrategyNumber: u32 = 16;
pub const JGINFLAG_KEY: u32 = 1;
pub const JGINFLAG_NULL: u32 = 2;
pub const JGINFLAG_BOOL: u32 = 3;
pub const JGINFLAG_NUM: u32 = 4;
pub const JGINFLAG_STR: u32 = 5;
pub const JGINFLAG_HASHED: u32 = 16;
pub const JGIN_MAXLENGTH: u32 = 125;
pub const JENTRY_OFFLENMASK: u32 = 268435455;
pub const JENTRY_TYPEMASK: u32 = 1879048192;
pub const JENTRY_HAS_OFF: u32 = 2147483648;
pub const JENTRY_ISSTRING: u32 = 0;
pub const JENTRY_ISNUMERIC: u32 = 268435456;
pub const JENTRY_ISBOOL_FALSE: u32 = 536870912;
pub const JENTRY_ISBOOL_TRUE: u32 = 805306368;
pub const JENTRY_ISNULL: u32 = 1073741824;
pub const JENTRY_ISCONTAINER: u32 = 1342177280;
pub const JB_OFFSET_STRIDE: u32 = 32;
pub const JB_CMASK: u32 = 268435455;
pub const JB_FSCALAR: u32 = 268435456;
pub const JB_FOBJECT: u32 = 536870912;
pub const JB_FARRAY: u32 = 1073741824;
pub const ATTSTATSSLOT_VALUES: u32 = 1;
pub const ATTSTATSSLOT_NUMBERS: u32 = 2;
pub const DEFAULT_EQ_SEL: f64 = 0.005;
pub const DEFAULT_INEQ_SEL: f64 = 0.3333333333333333;
pub const DEFAULT_RANGE_INEQ_SEL: f64 = 0.005;
pub const DEFAULT_MULTIRANGE_INEQ_SEL: f64 = 0.005;
pub const DEFAULT_MATCH_SEL: f64 = 0.005;
pub const DEFAULT_MATCHING_SEL: f64 = 0.01;
pub const DEFAULT_NUM_DISTINCT: u32 = 200;
pub const DEFAULT_UNK_SEL: f64 = 0.005;
pub const DEFAULT_NOT_UNK_SEL: f64 = 0.995;
pub const SELFLAG_USED_DEFAULT: u32 = 1;
pub const TYPECACHE_EQ_OPR: u32 = 1;
pub const TYPECACHE_LT_OPR: u32 = 2;
pub const TYPECACHE_GT_OPR: u32 = 4;
pub const TYPECACHE_CMP_PROC: u32 = 8;
pub const TYPECACHE_HASH_PROC: u32 = 16;
pub const TYPECACHE_EQ_OPR_FINFO: u32 = 32;
pub const TYPECACHE_CMP_PROC_FINFO: u32 = 64;
pub const TYPECACHE_HASH_PROC_FINFO: u32 = 128;
pub const TYPECACHE_TUPDESC: u32 = 256;
pub const TYPECACHE_BTREE_OPFAMILY: u32 = 512;
pub const TYPECACHE_HASH_OPFAMILY: u32 = 1024;
pub const TYPECACHE_RANGE_INFO: u32 = 2048;
pub const TYPECACHE_DOMAIN_BASE_INFO: u32 = 4096;
pub const TYPECACHE_DOMAIN_CONSTR_INFO: u32 = 8192;
pub const TYPECACHE_HASH_EXTENDED_PROC: u32 = 16384;
pub const TYPECACHE_HASH_EXTENDED_PROC_FINFO: u32 = 32768;
pub const TYPECACHE_MULTIRANGE_INFO: u32 = 65536;
pub type Oid = ::std::os::raw::c_uint;
pub type pg_int64 = ::std::os::raw::c_long;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
}
impl Default for __mbstate_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
impl Default for __darwin_pthread_handler_rec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
impl Default for _opaque_pthread_attr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
impl Default for _opaque_pthread_cond_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
impl Default for _opaque_pthread_mutex_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
impl Default for _opaque_pthread_rwlock_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
impl Default for _opaque_pthread_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
pub type va_list = __darwin_va_list;
pub unsafe fn renameat(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn renameat(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        renameat(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn renamex_np(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: ::std::os::raw::c_uint,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn renamex_np(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int;
        }
        renamex_np(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn renameatx_np(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: *const ::std::os::raw::c_char,
    arg_arg5: ::std::os::raw::c_uint,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn renameatx_np(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: *const ::std::os::raw::c_char,
                arg_arg5: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int;
        }
        renameatx_np(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5)
    })
}
pub type fpos_t = __darwin_off_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sbuf {
    pub _base: *mut ::std::os::raw::c_uchar,
    pub _size: ::std::os::raw::c_int,
}
impl Default for __sbuf {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILEX {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILE {
    pub _p: *mut ::std::os::raw::c_uchar,
    pub _r: ::std::os::raw::c_int,
    pub _w: ::std::os::raw::c_int,
    pub _flags: ::std::os::raw::c_short,
    pub _file: ::std::os::raw::c_short,
    pub _bf: __sbuf,
    pub _lbfsize: ::std::os::raw::c_int,
    pub _cookie: *mut ::std::os::raw::c_void,
    pub _close: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub _read: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _seek: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: fpos_t,
            arg3: ::std::os::raw::c_int,
        ) -> fpos_t,
    >,
    pub _write: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _ub: __sbuf,
    pub _extra: *mut __sFILEX,
    pub _ur: ::std::os::raw::c_int,
    pub _ubuf: [::std::os::raw::c_uchar; 3usize],
    pub _nbuf: [::std::os::raw::c_uchar; 1usize],
    pub _lb: __sbuf,
    pub _blksize: ::std::os::raw::c_int,
    pub _offset: fpos_t,
}
impl Default for __sFILE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type FILE = __sFILE;
extern "C" {
    pub static mut __stdinp: *mut FILE;
}
extern "C" {
    pub static mut __stdoutp: *mut FILE;
}
extern "C" {
    pub static mut __stderrp: *mut FILE;
}
pub unsafe fn clearerr(arg_arg1: *mut FILE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clearerr(arg_arg1: *mut FILE);
        }
        clearerr(arg_arg1)
    })
}
pub unsafe fn fclose(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fclose(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        fclose(arg_arg1)
    })
}
pub unsafe fn feof(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn feof(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        feof(arg_arg1)
    })
}
pub unsafe fn ferror(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ferror(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        ferror(arg_arg1)
    })
}
pub unsafe fn fflush(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fflush(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        fflush(arg_arg1)
    })
}
pub unsafe fn fgetc(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fgetc(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        fgetc(arg_arg1)
    })
}
pub unsafe fn fgetpos(arg_arg1: *mut FILE, arg_arg2: *mut fpos_t) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fgetpos(arg_arg1: *mut FILE, arg_arg2: *mut fpos_t) -> ::std::os::raw::c_int;
        }
        fgetpos(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fgets(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: *mut FILE,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fgets(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: *mut FILE,
            ) -> *mut ::std::os::raw::c_char;
        }
        fgets(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn fopen(
    arg___filename: *const ::std::os::raw::c_char,
    arg___mode: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fopen(
                arg___filename: *const ::std::os::raw::c_char,
                arg___mode: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        fopen(arg___filename, arg___mode)
    })
}
pub unsafe fn fprintf(
    arg_arg1: *mut FILE,
    arg_arg2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fprintf(
                arg_arg1: *mut FILE,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        fprintf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fputc(arg_arg1: ::std::os::raw::c_int, arg_arg2: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fputc(arg_arg1: ::std::os::raw::c_int, arg_arg2: *mut FILE)
                -> ::std::os::raw::c_int;
        }
        fputc(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fputs(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fputs(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        fputs(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fread(
    arg___ptr: *mut ::std::os::raw::c_void,
    arg___size: ::std::os::raw::c_ulong,
    arg___nitems: ::std::os::raw::c_ulong,
    arg___stream: *mut FILE,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fread(
                arg___ptr: *mut ::std::os::raw::c_void,
                arg___size: ::std::os::raw::c_ulong,
                arg___nitems: ::std::os::raw::c_ulong,
                arg___stream: *mut FILE,
            ) -> ::std::os::raw::c_ulong;
        }
        fread(arg___ptr, arg___size, arg___nitems, arg___stream)
    })
}
pub unsafe fn freopen(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: *mut FILE,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn freopen(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: *mut FILE,
            ) -> *mut FILE;
        }
        freopen(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn fscanf(
    arg_arg1: *mut FILE,
    arg_arg2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fscanf(
                arg_arg1: *mut FILE,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        fscanf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fseek(
    arg_arg1: *mut FILE,
    arg_arg2: ::std::os::raw::c_long,
    arg_arg3: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fseek(
                arg_arg1: *mut FILE,
                arg_arg2: ::std::os::raw::c_long,
                arg_arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        fseek(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn fsetpos(arg_arg1: *mut FILE, arg_arg2: *const fpos_t) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fsetpos(arg_arg1: *mut FILE, arg_arg2: *const fpos_t) -> ::std::os::raw::c_int;
        }
        fsetpos(arg_arg1, arg_arg2)
    })
}
pub unsafe fn ftell(arg_arg1: *mut FILE) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ftell(arg_arg1: *mut FILE) -> ::std::os::raw::c_long;
        }
        ftell(arg_arg1)
    })
}
pub unsafe fn fwrite(
    arg___ptr: *const ::std::os::raw::c_void,
    arg___size: ::std::os::raw::c_ulong,
    arg___nitems: ::std::os::raw::c_ulong,
    arg___stream: *mut FILE,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fwrite(
                arg___ptr: *const ::std::os::raw::c_void,
                arg___size: ::std::os::raw::c_ulong,
                arg___nitems: ::std::os::raw::c_ulong,
                arg___stream: *mut FILE,
            ) -> ::std::os::raw::c_ulong;
        }
        fwrite(arg___ptr, arg___size, arg___nitems, arg___stream)
    })
}
pub unsafe fn getc(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getc(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        getc(arg_arg1)
    })
}
pub unsafe fn getchar() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getchar() -> ::std::os::raw::c_int;
        }
        getchar()
    })
}
pub unsafe fn gets(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gets(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        gets(arg_arg1)
    })
}
pub unsafe fn perror(arg_arg1: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn perror(arg_arg1: *const ::std::os::raw::c_char);
        }
        perror(arg_arg1)
    })
}
pub unsafe fn printf(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn printf(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        printf(arg_arg1)
    })
}
pub unsafe fn putc(arg_arg1: ::std::os::raw::c_int, arg_arg2: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putc(arg_arg1: ::std::os::raw::c_int, arg_arg2: *mut FILE) -> ::std::os::raw::c_int;
        }
        putc(arg_arg1, arg_arg2)
    })
}
pub unsafe fn putchar(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putchar(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        putchar(arg_arg1)
    })
}
pub unsafe fn puts(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn puts(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        puts(arg_arg1)
    })
}
pub unsafe fn remove(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remove(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        remove(arg_arg1)
    })
}
pub unsafe fn rename(
    arg___old: *const ::std::os::raw::c_char,
    arg___new: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rename(
                arg___old: *const ::std::os::raw::c_char,
                arg___new: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        rename(arg___old, arg___new)
    })
}
pub unsafe fn rewind(arg_arg1: *mut FILE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rewind(arg_arg1: *mut FILE);
        }
        rewind(arg_arg1)
    })
}
pub unsafe fn scanf(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scanf(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        scanf(arg_arg1)
    })
}
pub unsafe fn setbuf(arg_arg1: *mut FILE, arg_arg2: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setbuf(arg_arg1: *mut FILE, arg_arg2: *mut ::std::os::raw::c_char);
        }
        setbuf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn setvbuf(
    arg_arg1: *mut FILE,
    arg_arg2: *mut ::std::os::raw::c_char,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setvbuf(
                arg_arg1: *mut FILE,
                arg_arg2: *mut ::std::os::raw::c_char,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: usize,
            ) -> ::std::os::raw::c_int;
        }
        setvbuf(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn sprintf(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sprintf(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        sprintf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn sscanf(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sscanf(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        sscanf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn tmpfile() -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tmpfile() -> *mut FILE;
        }
        tmpfile()
    })
}
pub unsafe fn tmpnam(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tmpnam(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        tmpnam(arg_arg1)
    })
}
pub unsafe fn ungetc(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ungetc(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        ungetc(arg_arg1, arg_arg2)
    })
}
pub unsafe fn vfprintf(
    arg_arg1: *mut FILE,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: __builtin_va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vfprintf(
                arg_arg1: *mut FILE,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: __builtin_va_list,
            ) -> ::std::os::raw::c_int;
        }
        vfprintf(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn vprintf(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: __builtin_va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vprintf(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: __builtin_va_list,
            ) -> ::std::os::raw::c_int;
        }
        vprintf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn vsprintf(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: __builtin_va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vsprintf(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: __builtin_va_list,
            ) -> ::std::os::raw::c_int;
        }
        vsprintf(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn ctermid(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ctermid(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        ctermid(arg_arg1)
    })
}
pub unsafe fn fdopen(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdopen(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        fdopen(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fileno(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fileno(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        fileno(arg_arg1)
    })
}
pub unsafe fn pclose(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pclose(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        pclose(arg_arg1)
    })
}
pub unsafe fn popen(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn popen(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        popen(arg_arg1, arg_arg2)
    })
}
pub unsafe fn __srget(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __srget(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        __srget(arg_arg1)
    })
}
pub unsafe fn __svfscanf(
    arg_arg1: *mut FILE,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __svfscanf(
                arg_arg1: *mut FILE,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: va_list,
            ) -> ::std::os::raw::c_int;
        }
        __svfscanf(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn __swbuf(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __swbuf(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        __swbuf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn flockfile(arg_arg1: *mut FILE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn flockfile(arg_arg1: *mut FILE);
        }
        flockfile(arg_arg1)
    })
}
pub unsafe fn ftrylockfile(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ftrylockfile(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        ftrylockfile(arg_arg1)
    })
}
pub unsafe fn funlockfile(arg_arg1: *mut FILE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn funlockfile(arg_arg1: *mut FILE);
        }
        funlockfile(arg_arg1)
    })
}
pub unsafe fn getc_unlocked(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getc_unlocked(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        getc_unlocked(arg_arg1)
    })
}
pub unsafe fn getchar_unlocked() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getchar_unlocked() -> ::std::os::raw::c_int;
        }
        getchar_unlocked()
    })
}
pub unsafe fn putc_unlocked(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putc_unlocked(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        putc_unlocked(arg_arg1, arg_arg2)
    })
}
pub unsafe fn putchar_unlocked(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putchar_unlocked(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        putchar_unlocked(arg_arg1)
    })
}
pub unsafe fn getw(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getw(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        getw(arg_arg1)
    })
}
pub unsafe fn putw(arg_arg1: ::std::os::raw::c_int, arg_arg2: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putw(arg_arg1: ::std::os::raw::c_int, arg_arg2: *mut FILE) -> ::std::os::raw::c_int;
        }
        putw(arg_arg1, arg_arg2)
    })
}
pub unsafe fn tempnam(
    arg___dir: *const ::std::os::raw::c_char,
    arg___prefix: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tempnam(
                arg___dir: *const ::std::os::raw::c_char,
                arg___prefix: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        tempnam(arg___dir, arg___prefix)
    })
}
pub type off_t = __darwin_off_t;
pub unsafe fn fseeko(
    arg___stream: *mut FILE,
    arg___offset: off_t,
    arg___whence: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fseeko(
                arg___stream: *mut FILE,
                arg___offset: off_t,
                arg___whence: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        fseeko(arg___stream, arg___offset, arg___whence)
    })
}
pub unsafe fn ftello(arg___stream: *mut FILE) -> off_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ftello(arg___stream: *mut FILE) -> off_t;
        }
        ftello(arg___stream)
    })
}
pub unsafe fn snprintf(
    arg___str: *mut ::std::os::raw::c_char,
    arg___size: ::std::os::raw::c_ulong,
    arg___format: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn snprintf(
                arg___str: *mut ::std::os::raw::c_char,
                arg___size: ::std::os::raw::c_ulong,
                arg___format: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        snprintf(arg___str, arg___size, arg___format)
    })
}
pub unsafe fn vfscanf(
    arg___stream: *mut FILE,
    arg___format: *const ::std::os::raw::c_char,
    arg_arg1: __builtin_va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vfscanf(
                arg___stream: *mut FILE,
                arg___format: *const ::std::os::raw::c_char,
                arg_arg1: __builtin_va_list,
            ) -> ::std::os::raw::c_int;
        }
        vfscanf(arg___stream, arg___format, arg_arg1)
    })
}
pub unsafe fn vscanf(
    arg___format: *const ::std::os::raw::c_char,
    arg_arg1: __builtin_va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vscanf(
                arg___format: *const ::std::os::raw::c_char,
                arg_arg1: __builtin_va_list,
            ) -> ::std::os::raw::c_int;
        }
        vscanf(arg___format, arg_arg1)
    })
}
pub unsafe fn vsnprintf(
    arg___str: *mut ::std::os::raw::c_char,
    arg___size: ::std::os::raw::c_ulong,
    arg___format: *const ::std::os::raw::c_char,
    arg_arg1: __builtin_va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vsnprintf(
                arg___str: *mut ::std::os::raw::c_char,
                arg___size: ::std::os::raw::c_ulong,
                arg___format: *const ::std::os::raw::c_char,
                arg_arg1: __builtin_va_list,
            ) -> ::std::os::raw::c_int;
        }
        vsnprintf(arg___str, arg___size, arg___format, arg_arg1)
    })
}
pub unsafe fn vsscanf(
    arg___str: *const ::std::os::raw::c_char,
    arg___format: *const ::std::os::raw::c_char,
    arg_arg1: __builtin_va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vsscanf(
                arg___str: *const ::std::os::raw::c_char,
                arg___format: *const ::std::os::raw::c_char,
                arg_arg1: __builtin_va_list,
            ) -> ::std::os::raw::c_int;
        }
        vsscanf(arg___str, arg___format, arg_arg1)
    })
}
pub unsafe fn dprintf(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dprintf(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        dprintf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn vdprintf(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vdprintf(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: va_list,
            ) -> ::std::os::raw::c_int;
        }
        vdprintf(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn getdelim(
    arg___linep: *mut *mut ::std::os::raw::c_char,
    arg___linecapp: *mut usize,
    arg___delimiter: ::std::os::raw::c_int,
    arg___stream: *mut FILE,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getdelim(
                arg___linep: *mut *mut ::std::os::raw::c_char,
                arg___linecapp: *mut usize,
                arg___delimiter: ::std::os::raw::c_int,
                arg___stream: *mut FILE,
            ) -> isize;
        }
        getdelim(arg___linep, arg___linecapp, arg___delimiter, arg___stream)
    })
}
pub unsafe fn getline(
    arg___linep: *mut *mut ::std::os::raw::c_char,
    arg___linecapp: *mut usize,
    arg___stream: *mut FILE,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getline(
                arg___linep: *mut *mut ::std::os::raw::c_char,
                arg___linecapp: *mut usize,
                arg___stream: *mut FILE,
            ) -> isize;
        }
        getline(arg___linep, arg___linecapp, arg___stream)
    })
}
pub unsafe fn fmemopen(
    arg___buf: *mut ::std::os::raw::c_void,
    arg___size: usize,
    arg___mode: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmemopen(
                arg___buf: *mut ::std::os::raw::c_void,
                arg___size: usize,
                arg___mode: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        fmemopen(arg___buf, arg___size, arg___mode)
    })
}
pub unsafe fn open_memstream(
    arg___bufp: *mut *mut ::std::os::raw::c_char,
    arg___sizep: *mut usize,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn open_memstream(
                arg___bufp: *mut *mut ::std::os::raw::c_char,
                arg___sizep: *mut usize,
            ) -> *mut FILE;
        }
        open_memstream(arg___bufp, arg___sizep)
    })
}
extern "C" {
    pub static sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
pub unsafe fn asprintf(
    arg_arg1: *mut *mut ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asprintf(
                arg_arg1: *mut *mut ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        asprintf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn ctermid_r(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ctermid_r(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        ctermid_r(arg_arg1)
    })
}
pub unsafe fn fgetln(arg_arg1: *mut FILE, arg_arg2: *mut usize) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fgetln(arg_arg1: *mut FILE, arg_arg2: *mut usize) -> *mut ::std::os::raw::c_char;
        }
        fgetln(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fmtcheck(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmtcheck(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> *const ::std::os::raw::c_char;
        }
        fmtcheck(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fpurge(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fpurge(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        fpurge(arg_arg1)
    })
}
pub unsafe fn setbuffer(
    arg_arg1: *mut FILE,
    arg_arg2: *mut ::std::os::raw::c_char,
    arg_arg3: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setbuffer(
                arg_arg1: *mut FILE,
                arg_arg2: *mut ::std::os::raw::c_char,
                arg_arg3: ::std::os::raw::c_int,
            );
        }
        setbuffer(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn setlinebuf(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setlinebuf(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        setlinebuf(arg_arg1)
    })
}
pub unsafe fn vasprintf(
    arg_arg1: *mut *mut ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vasprintf(
                arg_arg1: *mut *mut ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: va_list,
            ) -> ::std::os::raw::c_int;
        }
        vasprintf(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn funopen(
    arg_arg1: *const ::std::os::raw::c_void,
    arg_arg2: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    arg_arg3: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    arg_arg4: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: fpos_t,
            arg3: ::std::os::raw::c_int,
        ) -> fpos_t,
    >,
    arg_arg5: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn funopen(
                arg_arg1: *const ::std::os::raw::c_void,
                arg_arg2: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *mut ::std::os::raw::c_void,
                        arg2: *mut ::std::os::raw::c_char,
                        arg3: ::std::os::raw::c_int,
                    ) -> ::std::os::raw::c_int,
                >,
                arg_arg3: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *mut ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_char,
                        arg3: ::std::os::raw::c_int,
                    ) -> ::std::os::raw::c_int,
                >,
                arg_arg4: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *mut ::std::os::raw::c_void,
                        arg2: fpos_t,
                        arg3: ::std::os::raw::c_int,
                    ) -> fpos_t,
                >,
                arg_arg5: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *mut ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            ) -> *mut FILE;
        }
        funopen(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5)
    })
}
pub unsafe fn __sprintf_chk(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: usize,
    arg_arg4: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sprintf_chk(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: usize,
                arg_arg4: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        __sprintf_chk(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn __snprintf_chk(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: usize,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: usize,
    arg_arg5: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __snprintf_chk(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: usize,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: usize,
                arg_arg5: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        __snprintf_chk(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5)
    })
}
pub unsafe fn __vsprintf_chk(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: usize,
    arg_arg4: *const ::std::os::raw::c_char,
    arg_arg5: va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __vsprintf_chk(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: usize,
                arg_arg4: *const ::std::os::raw::c_char,
                arg_arg5: va_list,
            ) -> ::std::os::raw::c_int;
        }
        __vsprintf_chk(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5)
    })
}
pub unsafe fn __vsnprintf_chk(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: usize,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: usize,
    arg_arg5: *const ::std::os::raw::c_char,
    arg_arg6: va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __vsnprintf_chk(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: usize,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: usize,
                arg_arg5: *const ::std::os::raw::c_char,
                arg_arg6: va_list,
            ) -> ::std::os::raw::c_int;
        }
        __vsnprintf_chk(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6)
    })
}
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = ::std::os::raw::c_uint;
pub type pid_t = __darwin_pid_t;
pub type id_t = __darwin_id_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_arm_exception_state {
    pub __exception: __uint32_t,
    pub __fsr: __uint32_t,
    pub __far: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_arm_exception_state64 {
    pub __far: __uint64_t,
    pub __esr: __uint32_t,
    pub __exception: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_arm_thread_state {
    pub __r: [__uint32_t; 13usize],
    pub __sp: __uint32_t,
    pub __lr: __uint32_t,
    pub __pc: __uint32_t,
    pub __cpsr: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_arm_thread_state64 {
    pub __x: [__uint64_t; 29usize],
    pub __fp: __uint64_t,
    pub __lr: __uint64_t,
    pub __sp: __uint64_t,
    pub __pc: __uint64_t,
    pub __cpsr: __uint32_t,
    pub __pad: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_arm_vfp_state {
    pub __r: [__uint32_t; 64usize],
    pub __fpscr: __uint32_t,
}
impl Default for __darwin_arm_vfp_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_arm_neon_state64 {
    pub __v: [__uint128_t; 32usize],
    pub __fpsr: __uint32_t,
    pub __fpcr: __uint32_t,
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_arm_neon_state {
    pub __v: [__uint128_t; 16usize],
    pub __fpsr: __uint32_t,
    pub __fpcr: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __arm_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __arm_legacy_debug_state {
    pub __bvr: [__uint32_t; 16usize],
    pub __bcr: [__uint32_t; 16usize],
    pub __wvr: [__uint32_t; 16usize],
    pub __wcr: [__uint32_t; 16usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_arm_debug_state32 {
    pub __bvr: [__uint32_t; 16usize],
    pub __bcr: [__uint32_t; 16usize],
    pub __wvr: [__uint32_t; 16usize],
    pub __wcr: [__uint32_t; 16usize],
    pub __mdscr_el1: __uint64_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_arm_debug_state64 {
    pub __bvr: [__uint64_t; 16usize],
    pub __bcr: [__uint64_t; 16usize],
    pub __wvr: [__uint64_t; 16usize],
    pub __wcr: [__uint64_t; 16usize],
    pub __mdscr_el1: __uint64_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_arm_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_arm_exception_state,
    pub __ss: __darwin_arm_thread_state,
    pub __fs: __darwin_arm_vfp_state,
}
impl Default for __darwin_mcontext32 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_arm_exception_state64,
    pub __ss: __darwin_arm_thread_state64,
    pub __ns: __darwin_arm_neon_state64,
}
pub type mcontext_t = *mut __darwin_mcontext64;
pub type pthread_attr_t = __darwin_pthread_attr_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
impl Default for __darwin_sigaltstack {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
impl Default for __darwin_ucontext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
pub type uid_t = __darwin_uid_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
impl Default for sigval {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
impl Default for sigevent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
impl Default for __siginfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut __siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
impl Default for __sigaction_u {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
impl Default for __sigaction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
impl Default for sigaction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
impl Default for sigstack {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn signal(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
) -> ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ),
> {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn signal(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
            ) -> ::std::option::Option<
                unsafe extern "C" fn(
                    arg1: ::std::os::raw::c_int,
                    arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
                ),
            >;
        }
        signal(arg_arg1, arg_arg2)
    })
}
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
pub type rlim_t = __uint64_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage {
    pub ru_utime: timeval,
    pub ru_stime: timeval,
    pub ru_maxrss: ::std::os::raw::c_long,
    pub ru_ixrss: ::std::os::raw::c_long,
    pub ru_idrss: ::std::os::raw::c_long,
    pub ru_isrss: ::std::os::raw::c_long,
    pub ru_minflt: ::std::os::raw::c_long,
    pub ru_majflt: ::std::os::raw::c_long,
    pub ru_nswap: ::std::os::raw::c_long,
    pub ru_inblock: ::std::os::raw::c_long,
    pub ru_oublock: ::std::os::raw::c_long,
    pub ru_msgsnd: ::std::os::raw::c_long,
    pub ru_msgrcv: ::std::os::raw::c_long,
    pub ru_nsignals: ::std::os::raw::c_long,
    pub ru_nvcsw: ::std::os::raw::c_long,
    pub ru_nivcsw: ::std::os::raw::c_long,
}
pub type rusage_info_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v0 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v1 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v2 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v3 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v4 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v5 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
    pub ri_flags: u64,
}
pub type rusage_info_current = rusage_info_v5;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rlimit {
    pub rlim_cur: rlim_t,
    pub rlim_max: rlim_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proc_rlimit_control_wakeupmon {
    pub wm_flags: u32,
    pub wm_rate: i32,
}
pub unsafe fn getpriority(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: id_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpriority(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: id_t,
            ) -> ::std::os::raw::c_int;
        }
        getpriority(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getiopolicy_np(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getiopolicy_np(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        getiopolicy_np(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getrlimit(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut rlimit,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrlimit(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut rlimit,
            ) -> ::std::os::raw::c_int;
        }
        getrlimit(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getrusage(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut rusage,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrusage(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut rusage,
            ) -> ::std::os::raw::c_int;
        }
        getrusage(arg_arg1, arg_arg2)
    })
}
pub unsafe fn setpriority(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: id_t,
    arg_arg3: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setpriority(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: id_t,
                arg_arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        setpriority(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn setiopolicy_np(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setiopolicy_np(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        setiopolicy_np(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn setrlimit(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const rlimit,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setrlimit(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const rlimit,
            ) -> ::std::os::raw::c_int;
        }
        setrlimit(arg_arg1, arg_arg2)
    })
}
#[repr(C, packed)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _OSUnalignedU16 {
    pub __val: u16,
}
#[repr(C, packed)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _OSUnalignedU32 {
    pub __val: u32,
}
#[repr(C, packed)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _OSUnalignedU64 {
    pub __val: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub w_T: wait__bindgen_ty_1,
    pub w_S: wait__bindgen_ty_2,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn w_Termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_w_Termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_w_Coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Termsig: ::std::os::raw::c_uint,
        w_Coredump: ::std::os::raw::c_uint,
        w_Retcode: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let w_Termsig: u32 = unsafe { ::std::mem::transmute(w_Termsig) };
            w_Termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let w_Coredump: u32 = unsafe { ::std::mem::transmute(w_Coredump) };
            w_Coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Retcode: u32 = unsafe { ::std::mem::transmute(w_Retcode) };
            w_Retcode as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn w_Stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Stopval: ::std::os::raw::c_uint,
        w_Stopsig: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let w_Stopval: u32 = unsafe { ::std::mem::transmute(w_Stopval) };
            w_Stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Stopsig: u32 = unsafe { ::std::mem::transmute(w_Stopsig) };
            w_Stopsig as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for wait {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn wait(arg_arg1: *mut ::std::os::raw::c_int) -> pid_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait(arg_arg1: *mut ::std::os::raw::c_int) -> pid_t;
        }
        wait(arg_arg1)
    })
}
pub unsafe fn waitpid(
    arg_arg1: pid_t,
    arg_arg2: *mut ::std::os::raw::c_int,
    arg_arg3: ::std::os::raw::c_int,
) -> pid_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn waitpid(
                arg_arg1: pid_t,
                arg_arg2: *mut ::std::os::raw::c_int,
                arg_arg3: ::std::os::raw::c_int,
            ) -> pid_t;
        }
        waitpid(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn waitid(
    arg_arg1: idtype_t,
    arg_arg2: id_t,
    arg_arg3: *mut siginfo_t,
    arg_arg4: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn waitid(
                arg_arg1: idtype_t,
                arg_arg2: id_t,
                arg_arg3: *mut siginfo_t,
                arg_arg4: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        waitid(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn wait3(
    arg_arg1: *mut ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: *mut rusage,
) -> pid_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait3(
                arg_arg1: *mut ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: *mut rusage,
            ) -> pid_t;
        }
        wait3(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn wait4(
    arg_arg1: pid_t,
    arg_arg2: *mut ::std::os::raw::c_int,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: *mut rusage,
) -> pid_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait4(
                arg_arg1: pid_t,
                arg_arg2: *mut ::std::os::raw::c_int,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: *mut rusage,
            ) -> pid_t;
        }
        wait4(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn alloca(arg_arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn alloca(arg_arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
        }
        alloca(arg_arg1)
    })
}
pub type ct_rune_t = __darwin_ct_rune_t;
pub type rune_t = __darwin_rune_t;
pub type wchar_t = __darwin_wchar_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
extern "C" {
    pub static mut __mb_cur_max: ::std::os::raw::c_int;
}
pub unsafe fn malloc(arg___size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn malloc(arg___size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
        }
        malloc(arg___size)
    })
}
pub unsafe fn calloc(
    arg___count: ::std::os::raw::c_ulong,
    arg___size: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn calloc(
                arg___count: ::std::os::raw::c_ulong,
                arg___size: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        calloc(arg___count, arg___size)
    })
}
pub unsafe fn free(arg_arg1: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn free(arg_arg1: *mut ::std::os::raw::c_void);
        }
        free(arg_arg1)
    })
}
pub unsafe fn realloc(
    arg___ptr: *mut ::std::os::raw::c_void,
    arg___size: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn realloc(
                arg___ptr: *mut ::std::os::raw::c_void,
                arg___size: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        realloc(arg___ptr, arg___size)
    })
}
pub unsafe fn valloc(arg_arg1: usize) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn valloc(arg_arg1: usize) -> *mut ::std::os::raw::c_void;
        }
        valloc(arg_arg1)
    })
}
pub unsafe fn aligned_alloc(
    arg___alignment: ::std::os::raw::c_ulong,
    arg___size: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn aligned_alloc(
                arg___alignment: ::std::os::raw::c_ulong,
                arg___size: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        aligned_alloc(arg___alignment, arg___size)
    })
}
pub unsafe fn posix_memalign(
    arg___memptr: *mut *mut ::std::os::raw::c_void,
    arg___alignment: usize,
    arg___size: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn posix_memalign(
                arg___memptr: *mut *mut ::std::os::raw::c_void,
                arg___alignment: usize,
                arg___size: usize,
            ) -> ::std::os::raw::c_int;
        }
        posix_memalign(arg___memptr, arg___alignment, arg___size)
    })
}
pub unsafe fn abort() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn abort();
        }
        abort()
    })
}
pub unsafe fn abs(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn abs(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        abs(arg_arg1)
    })
}
pub unsafe fn atexit(
    arg_arg1: ::std::option::Option<unsafe extern "C" fn()>,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atexit(
                arg_arg1: ::std::option::Option<unsafe extern "C" fn()>,
            ) -> ::std::os::raw::c_int;
        }
        atexit(arg_arg1)
    })
}
pub unsafe fn atof(arg_arg1: *const ::std::os::raw::c_char) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atof(arg_arg1: *const ::std::os::raw::c_char) -> f64;
        }
        atof(arg_arg1)
    })
}
pub unsafe fn atoi(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atoi(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        atoi(arg_arg1)
    })
}
pub unsafe fn atol(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atol(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
        }
        atol(arg_arg1)
    })
}
pub unsafe fn atoll(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atoll(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
        }
        atoll(arg_arg1)
    })
}
pub unsafe fn bsearch(
    arg___key: *const ::std::os::raw::c_void,
    arg___base: *const ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg___compar: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bsearch(
                arg___key: *const ::std::os::raw::c_void,
                arg___base: *const ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg___compar: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *const ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            ) -> *mut ::std::os::raw::c_void;
        }
        bsearch(arg___key, arg___base, arg___nel, arg___width, arg___compar)
    })
}
pub unsafe fn div(arg_arg1: ::std::os::raw::c_int, arg_arg2: ::std::os::raw::c_int) -> div_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn div(arg_arg1: ::std::os::raw::c_int, arg_arg2: ::std::os::raw::c_int) -> div_t;
        }
        div(arg_arg1, arg_arg2)
    })
}
pub unsafe fn exit(arg_arg1: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn exit(arg_arg1: ::std::os::raw::c_int);
        }
        exit(arg_arg1)
    })
}
pub unsafe fn getenv(arg_arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getenv(arg_arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        getenv(arg_arg1)
    })
}
pub unsafe fn labs(arg_arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn labs(arg_arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
        }
        labs(arg_arg1)
    })
}
pub unsafe fn ldiv(arg_arg1: ::std::os::raw::c_long, arg_arg2: ::std::os::raw::c_long) -> ldiv_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ldiv(arg_arg1: ::std::os::raw::c_long, arg_arg2: ::std::os::raw::c_long) -> ldiv_t;
        }
        ldiv(arg_arg1, arg_arg2)
    })
}
pub unsafe fn llabs(arg_arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llabs(arg_arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
        }
        llabs(arg_arg1)
    })
}
pub unsafe fn lldiv(
    arg_arg1: ::std::os::raw::c_longlong,
    arg_arg2: ::std::os::raw::c_longlong,
) -> lldiv_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lldiv(
                arg_arg1: ::std::os::raw::c_longlong,
                arg_arg2: ::std::os::raw::c_longlong,
            ) -> lldiv_t;
        }
        lldiv(arg_arg1, arg_arg2)
    })
}
pub unsafe fn mblen(
    arg___s: *const ::std::os::raw::c_char,
    arg___n: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mblen(
                arg___s: *const ::std::os::raw::c_char,
                arg___n: usize,
            ) -> ::std::os::raw::c_int;
        }
        mblen(arg___s, arg___n)
    })
}
pub unsafe fn mbstowcs(
    arg_arg1: *mut wchar_t,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: usize,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mbstowcs(
                arg_arg1: *mut wchar_t,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: usize,
            ) -> usize;
        }
        mbstowcs(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn mbtowc(
    arg_arg1: *mut wchar_t,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mbtowc(
                arg_arg1: *mut wchar_t,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: usize,
            ) -> ::std::os::raw::c_int;
        }
        mbtowc(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn qsort(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg___compar: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qsort(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg___compar: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *const ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            );
        }
        qsort(arg___base, arg___nel, arg___width, arg___compar)
    })
}
pub unsafe fn rand() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rand() -> ::std::os::raw::c_int;
        }
        rand()
    })
}
pub unsafe fn srand(arg_arg1: ::std::os::raw::c_uint) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn srand(arg_arg1: ::std::os::raw::c_uint);
        }
        srand(arg_arg1)
    })
}
pub unsafe fn strtod(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *mut *mut ::std::os::raw::c_char,
) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtod(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *mut *mut ::std::os::raw::c_char,
            ) -> f64;
        }
        strtod(arg_arg1, arg_arg2)
    })
}
pub unsafe fn strtof(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *mut *mut ::std::os::raw::c_char,
) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtof(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *mut *mut ::std::os::raw::c_char,
            ) -> f32;
        }
        strtof(arg_arg1, arg_arg2)
    })
}
pub unsafe fn strtol(
    arg___str: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtol(
                arg___str: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_long;
        }
        strtol(arg___str, arg___endptr, arg___base)
    })
}
pub unsafe fn strtold(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *mut *mut ::std::os::raw::c_char,
) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtold(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *mut *mut ::std::os::raw::c_char,
            ) -> f64;
        }
        strtold(arg_arg1, arg_arg2)
    })
}
pub unsafe fn strtoll(
    arg___str: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtoll(
                arg___str: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_longlong;
        }
        strtoll(arg___str, arg___endptr, arg___base)
    })
}
pub unsafe fn strtoul(
    arg___str: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtoul(
                arg___str: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_ulong;
        }
        strtoul(arg___str, arg___endptr, arg___base)
    })
}
pub unsafe fn strtoull(
    arg___str: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_ulonglong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtoull(
                arg___str: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_ulonglong;
        }
        strtoull(arg___str, arg___endptr, arg___base)
    })
}
pub unsafe fn system(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn system(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        system(arg_arg1)
    })
}
pub unsafe fn wcstombs(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: *const wchar_t,
    arg_arg3: usize,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wcstombs(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: *const wchar_t,
                arg_arg3: usize,
            ) -> usize;
        }
        wcstombs(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn wctomb(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: wchar_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wctomb(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: wchar_t,
            ) -> ::std::os::raw::c_int;
        }
        wctomb(arg_arg1, arg_arg2)
    })
}
pub unsafe fn _Exit(arg_arg1: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn _Exit(arg_arg1: ::std::os::raw::c_int);
        }
        _Exit(arg_arg1)
    })
}
pub unsafe fn a64l(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn a64l(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
        }
        a64l(arg_arg1)
    })
}
pub unsafe fn drand48() -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn drand48() -> f64;
        }
        drand48()
    })
}
pub unsafe fn ecvt(
    arg_arg1: f64,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: *mut ::std::os::raw::c_int,
    arg_arg4: *mut ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ecvt(
                arg_arg1: f64,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: *mut ::std::os::raw::c_int,
                arg_arg4: *mut ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        ecvt(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn erand48(arg_arg1: *mut ::std::os::raw::c_ushort) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erand48(arg_arg1: *mut ::std::os::raw::c_ushort) -> f64;
        }
        erand48(arg_arg1)
    })
}
pub unsafe fn fcvt(
    arg_arg1: f64,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: *mut ::std::os::raw::c_int,
    arg_arg4: *mut ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fcvt(
                arg_arg1: f64,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: *mut ::std::os::raw::c_int,
                arg_arg4: *mut ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        fcvt(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn gcvt(
    arg_arg1: f64,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gcvt(
                arg_arg1: f64,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        gcvt(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn getsubopt(
    arg_arg1: *mut *mut ::std::os::raw::c_char,
    arg_arg2: *const *mut ::std::os::raw::c_char,
    arg_arg3: *mut *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getsubopt(
                arg_arg1: *mut *mut ::std::os::raw::c_char,
                arg_arg2: *const *mut ::std::os::raw::c_char,
                arg_arg3: *mut *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        getsubopt(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn grantpt(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn grantpt(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        grantpt(arg_arg1)
    })
}
pub unsafe fn initstate(
    arg_arg1: ::std::os::raw::c_uint,
    arg_arg2: *mut ::std::os::raw::c_char,
    arg_arg3: usize,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn initstate(
                arg_arg1: ::std::os::raw::c_uint,
                arg_arg2: *mut ::std::os::raw::c_char,
                arg_arg3: usize,
            ) -> *mut ::std::os::raw::c_char;
        }
        initstate(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn jrand48(arg_arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn jrand48(arg_arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
        }
        jrand48(arg_arg1)
    })
}
pub unsafe fn l64a(arg_arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn l64a(arg_arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
        }
        l64a(arg_arg1)
    })
}
pub unsafe fn lcong48(arg_arg1: *mut ::std::os::raw::c_ushort) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcong48(arg_arg1: *mut ::std::os::raw::c_ushort);
        }
        lcong48(arg_arg1)
    })
}
pub unsafe fn lrand48() -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lrand48() -> ::std::os::raw::c_long;
        }
        lrand48()
    })
}
pub unsafe fn mktemp(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mktemp(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        mktemp(arg_arg1)
    })
}
pub unsafe fn mkstemp(arg_arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mkstemp(arg_arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        mkstemp(arg_arg1)
    })
}
pub unsafe fn mrand48() -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mrand48() -> ::std::os::raw::c_long;
        }
        mrand48()
    })
}
pub unsafe fn nrand48(arg_arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nrand48(arg_arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
        }
        nrand48(arg_arg1)
    })
}
pub unsafe fn posix_openpt(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn posix_openpt(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        posix_openpt(arg_arg1)
    })
}
pub unsafe fn ptsname(arg_arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ptsname(arg_arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
        }
        ptsname(arg_arg1)
    })
}
pub unsafe fn ptsname_r(
    arg_fildes: ::std::os::raw::c_int,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_buflen: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ptsname_r(
                arg_fildes: ::std::os::raw::c_int,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_buflen: usize,
            ) -> ::std::os::raw::c_int;
        }
        ptsname_r(arg_fildes, arg_buffer, arg_buflen)
    })
}
pub unsafe fn putenv(arg_arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putenv(arg_arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        putenv(arg_arg1)
    })
}
pub unsafe fn random() -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn random() -> ::std::os::raw::c_long;
        }
        random()
    })
}
pub unsafe fn rand_r(arg_arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rand_r(arg_arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
        }
        rand_r(arg_arg1)
    })
}
pub unsafe fn realpath(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn realpath(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        realpath(arg_arg1, arg_arg2)
    })
}
pub unsafe fn seed48(arg_arg1: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn seed48(arg_arg1: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
        }
        seed48(arg_arg1)
    })
}
pub unsafe fn setenv(
    arg___name: *const ::std::os::raw::c_char,
    arg___value: *const ::std::os::raw::c_char,
    arg___overwrite: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setenv(
                arg___name: *const ::std::os::raw::c_char,
                arg___value: *const ::std::os::raw::c_char,
                arg___overwrite: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        setenv(arg___name, arg___value, arg___overwrite)
    })
}
pub unsafe fn setkey(arg_arg1: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setkey(arg_arg1: *const ::std::os::raw::c_char);
        }
        setkey(arg_arg1)
    })
}
pub unsafe fn setstate(arg_arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setstate(arg_arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        setstate(arg_arg1)
    })
}
pub unsafe fn srand48(arg_arg1: ::std::os::raw::c_long) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn srand48(arg_arg1: ::std::os::raw::c_long);
        }
        srand48(arg_arg1)
    })
}
pub unsafe fn srandom(arg_arg1: ::std::os::raw::c_uint) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn srandom(arg_arg1: ::std::os::raw::c_uint);
        }
        srandom(arg_arg1)
    })
}
pub unsafe fn unlockpt(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn unlockpt(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        unlockpt(arg_arg1)
    })
}
pub unsafe fn unsetenv(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn unsetenv(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        unsetenv(arg_arg1)
    })
}
pub type dev_t = __darwin_dev_t;
pub type mode_t = __darwin_mode_t;
pub unsafe fn arc4random() -> u32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn arc4random() -> u32;
        }
        arc4random()
    })
}
pub unsafe fn arc4random_addrandom(
    arg_arg1: *mut ::std::os::raw::c_uchar,
    arg_arg2: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn arc4random_addrandom(
                arg_arg1: *mut ::std::os::raw::c_uchar,
                arg_arg2: ::std::os::raw::c_int,
            );
        }
        arc4random_addrandom(arg_arg1, arg_arg2)
    })
}
pub unsafe fn arc4random_buf(arg___buf: *mut ::std::os::raw::c_void, arg___nbytes: usize) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn arc4random_buf(arg___buf: *mut ::std::os::raw::c_void, arg___nbytes: usize);
        }
        arc4random_buf(arg___buf, arg___nbytes)
    })
}
pub unsafe fn arc4random_stir() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn arc4random_stir();
        }
        arc4random_stir()
    })
}
pub unsafe fn arc4random_uniform(arg___upper_bound: u32) -> u32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn arc4random_uniform(arg___upper_bound: u32) -> u32;
        }
        arc4random_uniform(arg___upper_bound)
    })
}
pub unsafe fn atexit_b(arg_arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atexit_b(arg_arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
        }
        atexit_b(arg_arg1)
    })
}
pub unsafe fn bsearch_b(
    arg___key: *const ::std::os::raw::c_void,
    arg___base: *const ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg___compar: *mut ::std::os::raw::c_void,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bsearch_b(
                arg___key: *const ::std::os::raw::c_void,
                arg___base: *const ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg___compar: *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void;
        }
        bsearch_b(arg___key, arg___base, arg___nel, arg___width, arg___compar)
    })
}
pub unsafe fn cgetcap(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cgetcap(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        cgetcap(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn cgetclose() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cgetclose() -> ::std::os::raw::c_int;
        }
        cgetclose()
    })
}
pub unsafe fn cgetent(
    arg_arg1: *mut *mut ::std::os::raw::c_char,
    arg_arg2: *mut *mut ::std::os::raw::c_char,
    arg_arg3: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cgetent(
                arg_arg1: *mut *mut ::std::os::raw::c_char,
                arg_arg2: *mut *mut ::std::os::raw::c_char,
                arg_arg3: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        cgetent(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn cgetfirst(
    arg_arg1: *mut *mut ::std::os::raw::c_char,
    arg_arg2: *mut *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cgetfirst(
                arg_arg1: *mut *mut ::std::os::raw::c_char,
                arg_arg2: *mut *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        cgetfirst(arg_arg1, arg_arg2)
    })
}
pub unsafe fn cgetmatch(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cgetmatch(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        cgetmatch(arg_arg1, arg_arg2)
    })
}
pub unsafe fn cgetnext(
    arg_arg1: *mut *mut ::std::os::raw::c_char,
    arg_arg2: *mut *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cgetnext(
                arg_arg1: *mut *mut ::std::os::raw::c_char,
                arg_arg2: *mut *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        cgetnext(arg_arg1, arg_arg2)
    })
}
pub unsafe fn cgetnum(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: *mut ::std::os::raw::c_long,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cgetnum(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: *mut ::std::os::raw::c_long,
            ) -> ::std::os::raw::c_int;
        }
        cgetnum(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn cgetset(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cgetset(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        cgetset(arg_arg1)
    })
}
pub unsafe fn cgetstr(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: *mut *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cgetstr(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: *mut *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        cgetstr(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn cgetustr(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: *mut *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cgetustr(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: *mut *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        cgetustr(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn daemon(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn daemon(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        daemon(arg_arg1, arg_arg2)
    })
}
pub unsafe fn devname(arg_arg1: dev_t, arg_arg2: mode_t) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn devname(arg_arg1: dev_t, arg_arg2: mode_t) -> *mut ::std::os::raw::c_char;
        }
        devname(arg_arg1, arg_arg2)
    })
}
pub unsafe fn devname_r(
    arg_arg1: dev_t,
    arg_arg2: mode_t,
    arg_buf: *mut ::std::os::raw::c_char,
    arg_len: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn devname_r(
                arg_arg1: dev_t,
                arg_arg2: mode_t,
                arg_buf: *mut ::std::os::raw::c_char,
                arg_len: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        devname_r(arg_arg1, arg_arg2, arg_buf, arg_len)
    })
}
pub unsafe fn getbsize(
    arg_arg1: *mut ::std::os::raw::c_int,
    arg_arg2: *mut ::std::os::raw::c_long,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getbsize(
                arg_arg1: *mut ::std::os::raw::c_int,
                arg_arg2: *mut ::std::os::raw::c_long,
            ) -> *mut ::std::os::raw::c_char;
        }
        getbsize(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getloadavg(
    arg_arg1: *mut f64,
    arg_arg2: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getloadavg(
                arg_arg1: *mut f64,
                arg_arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        getloadavg(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getprogname() -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getprogname() -> *const ::std::os::raw::c_char;
        }
        getprogname()
    })
}
pub unsafe fn setprogname(arg_arg1: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setprogname(arg_arg1: *const ::std::os::raw::c_char);
        }
        setprogname(arg_arg1)
    })
}
pub unsafe fn heapsort(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg___compar: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heapsort(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg___compar: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *const ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            ) -> ::std::os::raw::c_int;
        }
        heapsort(arg___base, arg___nel, arg___width, arg___compar)
    })
}
pub unsafe fn heapsort_b(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg___compar: *mut ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heapsort_b(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg___compar: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        heapsort_b(arg___base, arg___nel, arg___width, arg___compar)
    })
}
pub unsafe fn mergesort(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg___compar: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mergesort(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg___compar: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *const ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            ) -> ::std::os::raw::c_int;
        }
        mergesort(arg___base, arg___nel, arg___width, arg___compar)
    })
}
pub unsafe fn mergesort_b(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg___compar: *mut ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mergesort_b(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg___compar: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        mergesort_b(arg___base, arg___nel, arg___width, arg___compar)
    })
}
pub unsafe fn psort(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg___compar: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn psort(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg___compar: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *const ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            );
        }
        psort(arg___base, arg___nel, arg___width, arg___compar)
    })
}
pub unsafe fn psort_b(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg___compar: *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn psort_b(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg___compar: *mut ::std::os::raw::c_void,
            );
        }
        psort_b(arg___base, arg___nel, arg___width, arg___compar)
    })
}
pub unsafe fn psort_r(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg_arg1: *mut ::std::os::raw::c_void,
    arg___compar: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
            arg3: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn psort_r(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg_arg1: *mut ::std::os::raw::c_void,
                arg___compar: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *mut ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                        arg3: *const ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            );
        }
        psort_r(arg___base, arg___nel, arg___width, arg_arg1, arg___compar)
    })
}
pub unsafe fn qsort_b(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg___compar: *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qsort_b(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg___compar: *mut ::std::os::raw::c_void,
            );
        }
        qsort_b(arg___base, arg___nel, arg___width, arg___compar)
    })
}
pub unsafe fn qsort_r(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nel: usize,
    arg___width: usize,
    arg_arg1: *mut ::std::os::raw::c_void,
    arg___compar: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
            arg3: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qsort_r(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nel: usize,
                arg___width: usize,
                arg_arg1: *mut ::std::os::raw::c_void,
                arg___compar: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *mut ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                        arg3: *const ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            );
        }
        qsort_r(arg___base, arg___nel, arg___width, arg_arg1, arg___compar)
    })
}
pub unsafe fn radixsort(
    arg___base: *mut *const ::std::os::raw::c_uchar,
    arg___nel: ::std::os::raw::c_int,
    arg___table: *const ::std::os::raw::c_uchar,
    arg___endbyte: ::std::os::raw::c_uint,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn radixsort(
                arg___base: *mut *const ::std::os::raw::c_uchar,
                arg___nel: ::std::os::raw::c_int,
                arg___table: *const ::std::os::raw::c_uchar,
                arg___endbyte: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int;
        }
        radixsort(arg___base, arg___nel, arg___table, arg___endbyte)
    })
}
pub unsafe fn rpmatch(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rpmatch(arg_arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        rpmatch(arg_arg1)
    })
}
pub unsafe fn sradixsort(
    arg___base: *mut *const ::std::os::raw::c_uchar,
    arg___nel: ::std::os::raw::c_int,
    arg___table: *const ::std::os::raw::c_uchar,
    arg___endbyte: ::std::os::raw::c_uint,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sradixsort(
                arg___base: *mut *const ::std::os::raw::c_uchar,
                arg___nel: ::std::os::raw::c_int,
                arg___table: *const ::std::os::raw::c_uchar,
                arg___endbyte: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int;
        }
        sradixsort(arg___base, arg___nel, arg___table, arg___endbyte)
    })
}
pub unsafe fn sranddev() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sranddev();
        }
        sranddev()
    })
}
pub unsafe fn srandomdev() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn srandomdev();
        }
        srandomdev()
    })
}
pub unsafe fn reallocf(
    arg___ptr: *mut ::std::os::raw::c_void,
    arg___size: usize,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn reallocf(
                arg___ptr: *mut ::std::os::raw::c_void,
                arg___size: usize,
            ) -> *mut ::std::os::raw::c_void;
        }
        reallocf(arg___ptr, arg___size)
    })
}
pub unsafe fn strtonum(
    arg___numstr: *const ::std::os::raw::c_char,
    arg___minval: ::std::os::raw::c_longlong,
    arg___maxval: ::std::os::raw::c_longlong,
    arg___errstrp: *mut *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtonum(
                arg___numstr: *const ::std::os::raw::c_char,
                arg___minval: ::std::os::raw::c_longlong,
                arg___maxval: ::std::os::raw::c_longlong,
                arg___errstrp: *mut *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_longlong;
        }
        strtonum(arg___numstr, arg___minval, arg___maxval, arg___errstrp)
    })
}
pub unsafe fn strtoq(
    arg___str: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtoq(
                arg___str: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_longlong;
        }
        strtoq(arg___str, arg___endptr, arg___base)
    })
}
pub unsafe fn strtouq(
    arg___str: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_ulonglong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtouq(
                arg___str: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_ulonglong;
        }
        strtouq(arg___str, arg___endptr, arg___base)
    })
}
extern "C" {
    pub static mut suboptarg: *mut ::std::os::raw::c_char;
}
pub unsafe fn memchr(
    arg___s: *const ::std::os::raw::c_void,
    arg___c: ::std::os::raw::c_int,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memchr(
                arg___s: *const ::std::os::raw::c_void,
                arg___c: ::std::os::raw::c_int,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        memchr(arg___s, arg___c, arg___n)
    })
}
pub unsafe fn memcmp(
    arg___s1: *const ::std::os::raw::c_void,
    arg___s2: *const ::std::os::raw::c_void,
    arg___n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memcmp(
                arg___s1: *const ::std::os::raw::c_void,
                arg___s2: *const ::std::os::raw::c_void,
                arg___n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        memcmp(arg___s1, arg___s2, arg___n)
    })
}
pub unsafe fn memcpy(
    arg___dst: *mut ::std::os::raw::c_void,
    arg___src: *const ::std::os::raw::c_void,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memcpy(
                arg___dst: *mut ::std::os::raw::c_void,
                arg___src: *const ::std::os::raw::c_void,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        memcpy(arg___dst, arg___src, arg___n)
    })
}
pub unsafe fn memmove(
    arg___dst: *mut ::std::os::raw::c_void,
    arg___src: *const ::std::os::raw::c_void,
    arg___len: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memmove(
                arg___dst: *mut ::std::os::raw::c_void,
                arg___src: *const ::std::os::raw::c_void,
                arg___len: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        memmove(arg___dst, arg___src, arg___len)
    })
}
pub unsafe fn memset(
    arg___b: *mut ::std::os::raw::c_void,
    arg___c: ::std::os::raw::c_int,
    arg___len: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memset(
                arg___b: *mut ::std::os::raw::c_void,
                arg___c: ::std::os::raw::c_int,
                arg___len: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        memset(arg___b, arg___c, arg___len)
    })
}
pub unsafe fn strcat(
    arg___s1: *mut ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcat(
                arg___s1: *mut ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strcat(arg___s1, arg___s2)
    })
}
pub unsafe fn strchr(
    arg___s: *const ::std::os::raw::c_char,
    arg___c: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strchr(
                arg___s: *const ::std::os::raw::c_char,
                arg___c: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        strchr(arg___s, arg___c)
    })
}
pub unsafe fn strcmp(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcmp(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        strcmp(arg___s1, arg___s2)
    })
}
pub unsafe fn strcoll(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcoll(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        strcoll(arg___s1, arg___s2)
    })
}
pub unsafe fn strcpy(
    arg___dst: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcpy(
                arg___dst: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strcpy(arg___dst, arg___src)
    })
}
pub unsafe fn strcspn(
    arg___s: *const ::std::os::raw::c_char,
    arg___charset: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcspn(
                arg___s: *const ::std::os::raw::c_char,
                arg___charset: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_ulong;
        }
        strcspn(arg___s, arg___charset)
    })
}
pub unsafe fn strerror(arg___errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strerror(arg___errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
        }
        strerror(arg___errnum)
    })
}
pub unsafe fn strlen(arg___s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strlen(arg___s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
        }
        strlen(arg___s)
    })
}
pub unsafe fn strncat(
    arg___s1: *mut ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strncat(
                arg___s1: *mut ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_char;
        }
        strncat(arg___s1, arg___s2, arg___n)
    })
}
pub unsafe fn strncmp(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strncmp(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        strncmp(arg___s1, arg___s2, arg___n)
    })
}
pub unsafe fn strncpy(
    arg___dst: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strncpy(
                arg___dst: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_char;
        }
        strncpy(arg___dst, arg___src, arg___n)
    })
}
pub unsafe fn strpbrk(
    arg___s: *const ::std::os::raw::c_char,
    arg___charset: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strpbrk(
                arg___s: *const ::std::os::raw::c_char,
                arg___charset: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strpbrk(arg___s, arg___charset)
    })
}
pub unsafe fn strrchr(
    arg___s: *const ::std::os::raw::c_char,
    arg___c: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strrchr(
                arg___s: *const ::std::os::raw::c_char,
                arg___c: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        strrchr(arg___s, arg___c)
    })
}
pub unsafe fn strspn(
    arg___s: *const ::std::os::raw::c_char,
    arg___charset: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strspn(
                arg___s: *const ::std::os::raw::c_char,
                arg___charset: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_ulong;
        }
        strspn(arg___s, arg___charset)
    })
}
pub unsafe fn strstr(
    arg___big: *const ::std::os::raw::c_char,
    arg___little: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strstr(
                arg___big: *const ::std::os::raw::c_char,
                arg___little: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strstr(arg___big, arg___little)
    })
}
pub unsafe fn strtok(
    arg___str: *mut ::std::os::raw::c_char,
    arg___sep: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtok(
                arg___str: *mut ::std::os::raw::c_char,
                arg___sep: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strtok(arg___str, arg___sep)
    })
}
pub unsafe fn strxfrm(
    arg___s1: *mut ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strxfrm(
                arg___s1: *mut ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_ulong;
        }
        strxfrm(arg___s1, arg___s2, arg___n)
    })
}
pub unsafe fn strtok_r(
    arg___str: *mut ::std::os::raw::c_char,
    arg___sep: *const ::std::os::raw::c_char,
    arg___lasts: *mut *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtok_r(
                arg___str: *mut ::std::os::raw::c_char,
                arg___sep: *const ::std::os::raw::c_char,
                arg___lasts: *mut *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strtok_r(arg___str, arg___sep, arg___lasts)
    })
}
pub unsafe fn strerror_r(
    arg___errnum: ::std::os::raw::c_int,
    arg___strerrbuf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strerror_r(
                arg___errnum: ::std::os::raw::c_int,
                arg___strerrbuf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
            ) -> ::std::os::raw::c_int;
        }
        strerror_r(arg___errnum, arg___strerrbuf, arg___buflen)
    })
}
pub unsafe fn strdup(arg___s1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strdup(arg___s1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        strdup(arg___s1)
    })
}
pub unsafe fn memccpy(
    arg___dst: *mut ::std::os::raw::c_void,
    arg___src: *const ::std::os::raw::c_void,
    arg___c: ::std::os::raw::c_int,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memccpy(
                arg___dst: *mut ::std::os::raw::c_void,
                arg___src: *const ::std::os::raw::c_void,
                arg___c: ::std::os::raw::c_int,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        memccpy(arg___dst, arg___src, arg___c, arg___n)
    })
}
pub unsafe fn stpcpy(
    arg___dst: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn stpcpy(
                arg___dst: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        stpcpy(arg___dst, arg___src)
    })
}
pub unsafe fn stpncpy(
    arg___dst: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn stpncpy(
                arg___dst: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_char;
        }
        stpncpy(arg___dst, arg___src, arg___n)
    })
}
pub unsafe fn strndup(
    arg___s1: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strndup(
                arg___s1: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_char;
        }
        strndup(arg___s1, arg___n)
    })
}
pub unsafe fn strnlen(arg___s1: *const ::std::os::raw::c_char, arg___n: usize) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strnlen(arg___s1: *const ::std::os::raw::c_char, arg___n: usize) -> usize;
        }
        strnlen(arg___s1, arg___n)
    })
}
pub unsafe fn strsignal(arg___sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strsignal(arg___sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
        }
        strsignal(arg___sig)
    })
}
pub type rsize_t = __darwin_size_t;
pub type errno_t = ::std::os::raw::c_int;
pub unsafe fn memset_s(
    arg___s: *mut ::std::os::raw::c_void,
    arg___smax: rsize_t,
    arg___c: ::std::os::raw::c_int,
    arg___n: rsize_t,
) -> errno_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memset_s(
                arg___s: *mut ::std::os::raw::c_void,
                arg___smax: rsize_t,
                arg___c: ::std::os::raw::c_int,
                arg___n: rsize_t,
            ) -> errno_t;
        }
        memset_s(arg___s, arg___smax, arg___c, arg___n)
    })
}
pub unsafe fn memmem(
    arg___big: *const ::std::os::raw::c_void,
    arg___big_len: usize,
    arg___little: *const ::std::os::raw::c_void,
    arg___little_len: usize,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memmem(
                arg___big: *const ::std::os::raw::c_void,
                arg___big_len: usize,
                arg___little: *const ::std::os::raw::c_void,
                arg___little_len: usize,
            ) -> *mut ::std::os::raw::c_void;
        }
        memmem(arg___big, arg___big_len, arg___little, arg___little_len)
    })
}
pub unsafe fn memset_pattern4(
    arg___b: *mut ::std::os::raw::c_void,
    arg___pattern4: *const ::std::os::raw::c_void,
    arg___len: usize,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memset_pattern4(
                arg___b: *mut ::std::os::raw::c_void,
                arg___pattern4: *const ::std::os::raw::c_void,
                arg___len: usize,
            );
        }
        memset_pattern4(arg___b, arg___pattern4, arg___len)
    })
}
pub unsafe fn memset_pattern8(
    arg___b: *mut ::std::os::raw::c_void,
    arg___pattern8: *const ::std::os::raw::c_void,
    arg___len: usize,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memset_pattern8(
                arg___b: *mut ::std::os::raw::c_void,
                arg___pattern8: *const ::std::os::raw::c_void,
                arg___len: usize,
            );
        }
        memset_pattern8(arg___b, arg___pattern8, arg___len)
    })
}
pub unsafe fn memset_pattern16(
    arg___b: *mut ::std::os::raw::c_void,
    arg___pattern16: *const ::std::os::raw::c_void,
    arg___len: usize,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memset_pattern16(
                arg___b: *mut ::std::os::raw::c_void,
                arg___pattern16: *const ::std::os::raw::c_void,
                arg___len: usize,
            );
        }
        memset_pattern16(arg___b, arg___pattern16, arg___len)
    })
}
pub unsafe fn strcasestr(
    arg___big: *const ::std::os::raw::c_char,
    arg___little: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcasestr(
                arg___big: *const ::std::os::raw::c_char,
                arg___little: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strcasestr(arg___big, arg___little)
    })
}
pub unsafe fn strnstr(
    arg___big: *const ::std::os::raw::c_char,
    arg___little: *const ::std::os::raw::c_char,
    arg___len: usize,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strnstr(
                arg___big: *const ::std::os::raw::c_char,
                arg___little: *const ::std::os::raw::c_char,
                arg___len: usize,
            ) -> *mut ::std::os::raw::c_char;
        }
        strnstr(arg___big, arg___little, arg___len)
    })
}
pub unsafe fn strlcat(
    arg___dst: *mut ::std::os::raw::c_char,
    arg___source: *const ::std::os::raw::c_char,
    arg___size: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strlcat(
                arg___dst: *mut ::std::os::raw::c_char,
                arg___source: *const ::std::os::raw::c_char,
                arg___size: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_ulong;
        }
        strlcat(arg___dst, arg___source, arg___size)
    })
}
pub unsafe fn strlcpy(
    arg___dst: *mut ::std::os::raw::c_char,
    arg___source: *const ::std::os::raw::c_char,
    arg___size: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strlcpy(
                arg___dst: *mut ::std::os::raw::c_char,
                arg___source: *const ::std::os::raw::c_char,
                arg___size: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_ulong;
        }
        strlcpy(arg___dst, arg___source, arg___size)
    })
}
pub unsafe fn strmode(arg___mode: ::std::os::raw::c_int, arg___bp: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strmode(arg___mode: ::std::os::raw::c_int, arg___bp: *mut ::std::os::raw::c_char);
        }
        strmode(arg___mode, arg___bp)
    })
}
pub unsafe fn strsep(
    arg___stringp: *mut *mut ::std::os::raw::c_char,
    arg___delim: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strsep(
                arg___stringp: *mut *mut ::std::os::raw::c_char,
                arg___delim: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strsep(arg___stringp, arg___delim)
    })
}
pub unsafe fn swab(
    arg_arg1: *const ::std::os::raw::c_void,
    arg_arg2: *mut ::std::os::raw::c_void,
    arg_arg3: isize,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn swab(
                arg_arg1: *const ::std::os::raw::c_void,
                arg_arg2: *mut ::std::os::raw::c_void,
                arg_arg3: isize,
            );
        }
        swab(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn timingsafe_bcmp(
    arg___b1: *const ::std::os::raw::c_void,
    arg___b2: *const ::std::os::raw::c_void,
    arg___len: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timingsafe_bcmp(
                arg___b1: *const ::std::os::raw::c_void,
                arg___b2: *const ::std::os::raw::c_void,
                arg___len: usize,
            ) -> ::std::os::raw::c_int;
        }
        timingsafe_bcmp(arg___b1, arg___b2, arg___len)
    })
}
pub unsafe fn strsignal_r(
    arg___sig: ::std::os::raw::c_int,
    arg___strsignalbuf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strsignal_r(
                arg___sig: ::std::os::raw::c_int,
                arg___strsignalbuf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
            ) -> ::std::os::raw::c_int;
        }
        strsignal_r(arg___sig, arg___strsignalbuf, arg___buflen)
    })
}
pub unsafe fn bcmp(
    arg_arg1: *const ::std::os::raw::c_void,
    arg_arg2: *const ::std::os::raw::c_void,
    arg_arg3: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bcmp(
                arg_arg1: *const ::std::os::raw::c_void,
                arg_arg2: *const ::std::os::raw::c_void,
                arg_arg3: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        bcmp(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn bcopy(
    arg_arg1: *const ::std::os::raw::c_void,
    arg_arg2: *mut ::std::os::raw::c_void,
    arg_arg3: usize,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bcopy(
                arg_arg1: *const ::std::os::raw::c_void,
                arg_arg2: *mut ::std::os::raw::c_void,
                arg_arg3: usize,
            );
        }
        bcopy(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn bzero(arg_arg1: *mut ::std::os::raw::c_void, arg_arg2: ::std::os::raw::c_ulong) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bzero(arg_arg1: *mut ::std::os::raw::c_void, arg_arg2: ::std::os::raw::c_ulong);
        }
        bzero(arg_arg1, arg_arg2)
    })
}
pub unsafe fn index(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        index(arg_arg1, arg_arg2)
    })
}
pub unsafe fn rindex(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rindex(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        rindex(arg_arg1, arg_arg2)
    })
}
pub unsafe fn ffs(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ffs(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        ffs(arg_arg1)
    })
}
pub unsafe fn strcasecmp(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcasecmp(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        strcasecmp(arg_arg1, arg_arg2)
    })
}
pub unsafe fn strncasecmp(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strncasecmp(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        strncasecmp(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn ffsl(arg_arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ffsl(arg_arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
        }
        ffsl(arg_arg1)
    })
}
pub unsafe fn ffsll(arg_arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ffsll(arg_arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
        }
        ffsll(arg_arg1)
    })
}
pub unsafe fn fls(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fls(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        fls(arg_arg1)
    })
}
pub unsafe fn flsl(arg_arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn flsl(arg_arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
        }
        flsl(arg_arg1)
    })
}
pub unsafe fn flsll(arg_arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn flsll(arg_arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
        }
        flsll(arg_arg1)
    })
}
pub type max_align_t = f64;
pub type __gnuc_va_list = __builtin_va_list;
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_quad_t = u_int64_t;
pub type quad_t = i64;
pub type qaddr_t = *mut quad_t;
pub type caddr_t = *mut ::std::os::raw::c_char;
pub type daddr_t = i32;
pub type fixpt_t = u_int32_t;
pub type blkcnt_t = __darwin_blkcnt_t;
pub type blksize_t = __darwin_blksize_t;
pub type gid_t = __darwin_gid_t;
pub type in_addr_t = __uint32_t;
pub type in_port_t = __uint16_t;
pub type ino_t = __darwin_ino_t;
pub type ino64_t = __darwin_ino64_t;
pub type key_t = __int32_t;
pub type nlink_t = __uint16_t;
pub type segsz_t = i32;
pub type swblk_t = i32;
pub type clock_t = __darwin_clock_t;
pub type time_t = __darwin_time_t;
pub type useconds_t = __darwin_useconds_t;
pub type suseconds_t = __darwin_suseconds_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fd_set {
    pub fds_bits: [__int32_t; 32usize],
}
pub unsafe fn __darwin_check_fd_set_overflow(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_void,
    arg_arg3: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __darwin_check_fd_set_overflow(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_void,
                arg_arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        __darwin_check_fd_set_overflow(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub type fd_mask = __int32_t;
pub type pthread_cond_t = __darwin_pthread_cond_t;
pub type pthread_condattr_t = __darwin_pthread_condattr_t;
pub type pthread_mutex_t = __darwin_pthread_mutex_t;
pub type pthread_mutexattr_t = __darwin_pthread_mutexattr_t;
pub type pthread_once_t = __darwin_pthread_once_t;
pub type pthread_rwlock_t = __darwin_pthread_rwlock_t;
pub type pthread_rwlockattr_t = __darwin_pthread_rwlockattr_t;
pub type pthread_t = __darwin_pthread_t;
pub type pthread_key_t = __darwin_pthread_key_t;
pub type fsblkcnt_t = __darwin_fsblkcnt_t;
pub type fsfilcnt_t = __darwin_fsfilcnt_t;
pub unsafe fn __error() -> *mut ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __error() -> *mut ::std::os::raw::c_int;
        }
        __error()
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lconv {
    pub decimal_point: *mut ::std::os::raw::c_char,
    pub thousands_sep: *mut ::std::os::raw::c_char,
    pub grouping: *mut ::std::os::raw::c_char,
    pub int_curr_symbol: *mut ::std::os::raw::c_char,
    pub currency_symbol: *mut ::std::os::raw::c_char,
    pub mon_decimal_point: *mut ::std::os::raw::c_char,
    pub mon_thousands_sep: *mut ::std::os::raw::c_char,
    pub mon_grouping: *mut ::std::os::raw::c_char,
    pub positive_sign: *mut ::std::os::raw::c_char,
    pub negative_sign: *mut ::std::os::raw::c_char,
    pub int_frac_digits: ::std::os::raw::c_char,
    pub frac_digits: ::std::os::raw::c_char,
    pub p_cs_precedes: ::std::os::raw::c_char,
    pub p_sep_by_space: ::std::os::raw::c_char,
    pub n_cs_precedes: ::std::os::raw::c_char,
    pub n_sep_by_space: ::std::os::raw::c_char,
    pub p_sign_posn: ::std::os::raw::c_char,
    pub n_sign_posn: ::std::os::raw::c_char,
    pub int_p_cs_precedes: ::std::os::raw::c_char,
    pub int_n_cs_precedes: ::std::os::raw::c_char,
    pub int_p_sep_by_space: ::std::os::raw::c_char,
    pub int_n_sep_by_space: ::std::os::raw::c_char,
    pub int_p_sign_posn: ::std::os::raw::c_char,
    pub int_n_sign_posn: ::std::os::raw::c_char,
}
impl Default for lconv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn localeconv() -> *mut lconv {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn localeconv() -> *mut lconv;
        }
        localeconv()
    })
}
pub unsafe fn setlocale(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setlocale(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        setlocale(arg_arg1, arg_arg2)
    })
}
pub type pg_funcptr_t = ::std::option::Option<unsafe extern "C" fn()>;
pub type Pointer = *mut ::std::os::raw::c_char;
pub type int8 = ::std::os::raw::c_schar;
pub type int16 = ::std::os::raw::c_short;
pub type int32 = ::std::os::raw::c_int;
pub type uint8 = ::std::os::raw::c_uchar;
pub type uint16 = ::std::os::raw::c_ushort;
pub type uint32 = ::std::os::raw::c_uint;
pub type bits8 = uint8;
pub type bits16 = uint16;
pub type bits32 = uint32;
pub type int64 = ::std::os::raw::c_long;
pub type uint64 = ::std::os::raw::c_ulong;
pub type int128 = i128;
pub type uint128 = u128;
pub type Size = usize;
pub type Index = ::std::os::raw::c_uint;
pub type Offset = ::std::os::raw::c_int;
pub type float4 = f32;
pub type float8 = f64;
pub type regproc = Oid;
pub type RegProcedure = regproc;
pub type TransactionId = uint32;
pub type LocalTransactionId = uint32;
pub type SubTransactionId = uint32;
pub type MultiXactId = TransactionId;
pub type MultiXactOffset = uint32;
pub type CommandId = uint32;
#[repr(C)]
#[derive(Debug, Default)]
pub struct varlena {
    pub vl_len_: [::std::os::raw::c_char; 4usize],
    pub vl_dat: __IncompleteArrayField<::std::os::raw::c_char>,
}
pub type bytea = varlena;
pub type text = varlena;
pub type BpChar = varlena;
pub type VarChar = varlena;
#[repr(C)]
#[derive(Debug, Default)]
pub struct int2vector {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::std::os::raw::c_int,
    pub lbound1: ::std::os::raw::c_int,
    pub values: __IncompleteArrayField<int16>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct oidvector {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::std::os::raw::c_int,
    pub lbound1: ::std::os::raw::c_int,
    pub values: __IncompleteArrayField<Oid>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nameData {
    pub data: [::std::os::raw::c_char; 64usize],
}
impl Default for nameData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type NameData = nameData;
pub type Name = *mut NameData;
pub unsafe fn ExceptionalCondition(
    arg_conditionName: *const ::std::os::raw::c_char,
    arg_errorType: *const ::std::os::raw::c_char,
    arg_fileName: *const ::std::os::raw::c_char,
    arg_lineNumber: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExceptionalCondition(
                arg_conditionName: *const ::std::os::raw::c_char,
                arg_errorType: *const ::std::os::raw::c_char,
                arg_fileName: *const ::std::os::raw::c_char,
                arg_lineNumber: ::std::os::raw::c_int,
            );
        }
        ExceptionalCondition(
            arg_conditionName,
            arg_errorType,
            arg_fileName,
            arg_lineNumber,
        )
    })
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedBlock {
    pub data: [::std::os::raw::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedXLogBlock {
    pub data: [::std::os::raw::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedXLogBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn fdatasync(arg_fildes: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdatasync(arg_fildes: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        fdatasync(arg_fildes)
    })
}
pub type wint_t = __darwin_wint_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneEntry {
    pub __min: __darwin_rune_t,
    pub __max: __darwin_rune_t,
    pub __map: __darwin_rune_t,
    pub __types: *mut __uint32_t,
}
impl Default for _RuneEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneRange {
    pub __nranges: ::std::os::raw::c_int,
    pub __ranges: *mut _RuneEntry,
}
impl Default for _RuneRange {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _RuneCharClass {
    pub __name: [::std::os::raw::c_char; 14usize],
    pub __mask: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneLocale {
    pub __magic: [::std::os::raw::c_char; 8usize],
    pub __encoding: [::std::os::raw::c_char; 32usize],
    pub __sgetrune: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: __darwin_size_t,
            arg3: *mut *const ::std::os::raw::c_char,
        ) -> __darwin_rune_t,
    >,
    pub __sputrune: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: __darwin_rune_t,
            arg2: *mut ::std::os::raw::c_char,
            arg3: __darwin_size_t,
            arg4: *mut *mut ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
    pub __invalid_rune: __darwin_rune_t,
    pub __runetype: [__uint32_t; 256usize],
    pub __maplower: [__darwin_rune_t; 256usize],
    pub __mapupper: [__darwin_rune_t; 256usize],
    pub __runetype_ext: _RuneRange,
    pub __maplower_ext: _RuneRange,
    pub __mapupper_ext: _RuneRange,
    pub __variable: *mut ::std::os::raw::c_void,
    pub __variable_len: ::std::os::raw::c_int,
    pub __ncharclasses: ::std::os::raw::c_int,
    pub __charclasses: *mut _RuneCharClass,
}
impl Default for _RuneLocale {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut _DefaultRuneLocale: _RuneLocale;
}
extern "C" {
    pub static mut _CurrentRuneLocale: *mut _RuneLocale;
}
pub unsafe fn ___runetype(arg_arg1: __darwin_ct_rune_t) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ___runetype(arg_arg1: __darwin_ct_rune_t) -> ::std::os::raw::c_ulong;
        }
        ___runetype(arg_arg1)
    })
}
pub unsafe fn ___tolower(arg_arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ___tolower(arg_arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
        }
        ___tolower(arg_arg1)
    })
}
pub unsafe fn ___toupper(arg_arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ___toupper(arg_arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
        }
        ___toupper(arg_arg1)
    })
}
pub unsafe fn __maskrune(
    arg_arg1: __darwin_ct_rune_t,
    arg_arg2: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __maskrune(
                arg_arg1: __darwin_ct_rune_t,
                arg_arg2: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        __maskrune(arg_arg1, arg_arg2)
    })
}
pub unsafe fn __toupper(arg_arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __toupper(arg_arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
        }
        __toupper(arg_arg1)
    })
}
pub unsafe fn __tolower(arg_arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tolower(arg_arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
        }
        __tolower(arg_arg1)
    })
}
pub type socklen_t = __darwin_socklen_t;
pub type sa_family_t = __uint8_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: usize,
}
impl Default for iovec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type sae_associd_t = __uint32_t;
pub type sae_connid_t = __uint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sa_endpoints {
    pub sae_srcif: ::std::os::raw::c_uint,
    pub sae_srcaddr: *const sockaddr,
    pub sae_srcaddrlen: socklen_t,
    pub sae_dstaddr: *const sockaddr,
    pub sae_dstaddrlen: socklen_t,
}
impl Default for sa_endpoints {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type sa_endpoints_t = sa_endpoints;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct so_np_extensions {
    pub npx_flags: u_int32_t,
    pub npx_mask: u_int32_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockaddr {
    pub sa_len: __uint8_t,
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockproto {
    pub sp_family: __uint16_t,
    pub sp_protocol: __uint16_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_len: __uint8_t,
    pub ss_family: sa_family_t,
    pub __ss_pad1: [::std::os::raw::c_char; 6usize],
    pub __ss_align: __int64_t,
    pub __ss_pad2: [::std::os::raw::c_char; 112usize],
}
impl Default for sockaddr_storage {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: ::std::os::raw::c_int,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: socklen_t,
    pub msg_flags: ::std::os::raw::c_int,
}
impl Default for msghdr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct cmsghdr {
    pub cmsg_len: socklen_t,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sf_hdtr {
    pub headers: *mut iovec,
    pub hdr_cnt: ::std::os::raw::c_int,
    pub trailers: *mut iovec,
    pub trl_cnt: ::std::os::raw::c_int,
}
impl Default for sf_hdtr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn accept(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut sockaddr,
    arg_arg3: *mut socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn accept(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut sockaddr,
                arg_arg3: *mut socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        accept(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn bind(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const sockaddr,
    arg_arg3: socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bind(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const sockaddr,
                arg_arg3: socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        bind(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn connect(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const sockaddr,
    arg_arg3: socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn connect(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const sockaddr,
                arg_arg3: socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        connect(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn getpeername(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut sockaddr,
    arg_arg3: *mut socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpeername(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut sockaddr,
                arg_arg3: *mut socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        getpeername(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn getsockname(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut sockaddr,
    arg_arg3: *mut socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getsockname(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut sockaddr,
                arg_arg3: *mut socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        getsockname(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn getsockopt(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: *mut ::std::os::raw::c_void,
    arg_arg5: *mut socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getsockopt(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: *mut ::std::os::raw::c_void,
                arg_arg5: *mut socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        getsockopt(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5)
    })
}
pub unsafe fn listen(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn listen(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        listen(arg_arg1, arg_arg2)
    })
}
pub unsafe fn recv(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut ::std::os::raw::c_void,
    arg_arg3: usize,
    arg_arg4: ::std::os::raw::c_int,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn recv(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut ::std::os::raw::c_void,
                arg_arg3: usize,
                arg_arg4: ::std::os::raw::c_int,
            ) -> isize;
        }
        recv(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn recvfrom(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut ::std::os::raw::c_void,
    arg_arg3: usize,
    arg_arg4: ::std::os::raw::c_int,
    arg_arg5: *mut sockaddr,
    arg_arg6: *mut socklen_t,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn recvfrom(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut ::std::os::raw::c_void,
                arg_arg3: usize,
                arg_arg4: ::std::os::raw::c_int,
                arg_arg5: *mut sockaddr,
                arg_arg6: *mut socklen_t,
            ) -> isize;
        }
        recvfrom(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6)
    })
}
pub unsafe fn recvmsg(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut msghdr,
    arg_arg3: ::std::os::raw::c_int,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn recvmsg(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut msghdr,
                arg_arg3: ::std::os::raw::c_int,
            ) -> isize;
        }
        recvmsg(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn send(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_void,
    arg_arg3: usize,
    arg_arg4: ::std::os::raw::c_int,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn send(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_void,
                arg_arg3: usize,
                arg_arg4: ::std::os::raw::c_int,
            ) -> isize;
        }
        send(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn sendmsg(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const msghdr,
    arg_arg3: ::std::os::raw::c_int,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sendmsg(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const msghdr,
                arg_arg3: ::std::os::raw::c_int,
            ) -> isize;
        }
        sendmsg(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn sendto(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_void,
    arg_arg3: usize,
    arg_arg4: ::std::os::raw::c_int,
    arg_arg5: *const sockaddr,
    arg_arg6: socklen_t,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sendto(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_void,
                arg_arg3: usize,
                arg_arg4: ::std::os::raw::c_int,
                arg_arg5: *const sockaddr,
                arg_arg6: socklen_t,
            ) -> isize;
        }
        sendto(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6)
    })
}
pub unsafe fn setsockopt(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: *const ::std::os::raw::c_void,
    arg_arg5: socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setsockopt(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: *const ::std::os::raw::c_void,
                arg_arg5: socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        setsockopt(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5)
    })
}
pub unsafe fn shutdown(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn shutdown(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        shutdown(arg_arg1, arg_arg2)
    })
}
pub unsafe fn sockatmark(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sockatmark(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        sockatmark(arg_arg1)
    })
}
pub unsafe fn socket(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn socket(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        socket(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn socketpair(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn socketpair(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        socketpair(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn sendfile(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: off_t,
    arg_arg4: *mut off_t,
    arg_arg5: *mut sf_hdtr,
    arg_arg6: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sendfile(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: off_t,
                arg_arg4: *mut off_t,
                arg_arg5: *mut sf_hdtr,
                arg_arg6: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        sendfile(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6)
    })
}
pub unsafe fn pfctlinput(arg_arg1: ::std::os::raw::c_int, arg_arg2: *mut sockaddr) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pfctlinput(arg_arg1: ::std::os::raw::c_int, arg_arg2: *mut sockaddr);
        }
        pfctlinput(arg_arg1, arg_arg2)
    })
}
pub unsafe fn connectx(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const sa_endpoints_t,
    arg_arg3: sae_associd_t,
    arg_arg4: ::std::os::raw::c_uint,
    arg_arg5: *const iovec,
    arg_arg6: ::std::os::raw::c_uint,
    arg_arg7: *mut usize,
    arg_arg8: *mut sae_connid_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn connectx(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const sa_endpoints_t,
                arg_arg3: sae_associd_t,
                arg_arg4: ::std::os::raw::c_uint,
                arg_arg5: *const iovec,
                arg_arg6: ::std::os::raw::c_uint,
                arg_arg7: *mut usize,
                arg_arg8: *mut sae_connid_t,
            ) -> ::std::os::raw::c_int;
        }
        connectx(
            arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6, arg_arg7, arg_arg8,
        )
    })
}
pub unsafe fn disconnectx(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: sae_associd_t,
    arg_arg3: sae_connid_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn disconnectx(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: sae_associd_t,
                arg_arg3: sae_connid_t,
            ) -> ::std::os::raw::c_int;
        }
        disconnectx(arg_arg1, arg_arg2, arg_arg3)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct in_addr {
    pub s_addr: in_addr_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_len: __uint8_t,
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [::std::os::raw::c_char; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_opts {
    pub ip_dst: in_addr,
    pub ip_opts: [::std::os::raw::c_char; 40usize],
}
impl Default for ip_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreq {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreqn {
    pub imr_multiaddr: in_addr,
    pub imr_address: in_addr,
    pub imr_ifindex: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreq_source {
    pub imr_multiaddr: in_addr,
    pub imr_sourceaddr: in_addr,
    pub imr_interface: in_addr,
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct group_req {
    pub gr_interface: u32,
    pub gr_group: sockaddr_storage,
}
impl Default for group_req {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct group_source_req {
    pub gsr_interface: u32,
    pub gsr_group: sockaddr_storage,
    pub gsr_source: sockaddr_storage,
}
impl Default for group_source_req {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __msfilterreq {
    pub msfr_ifindex: u32,
    pub msfr_fmode: u32,
    pub msfr_nsrcs: u32,
    pub __msfr_align: u32,
    pub msfr_group: sockaddr_storage,
    pub msfr_srcs: *mut sockaddr_storage,
}
impl Default for __msfilterreq {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn setipv4sourcefilter(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: in_addr,
    arg_arg3: in_addr,
    arg_arg4: u32,
    arg_arg5: u32,
    arg_arg6: *mut in_addr,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setipv4sourcefilter(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: in_addr,
                arg_arg3: in_addr,
                arg_arg4: u32,
                arg_arg5: u32,
                arg_arg6: *mut in_addr,
            ) -> ::std::os::raw::c_int;
        }
        setipv4sourcefilter(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6)
    })
}
pub unsafe fn getipv4sourcefilter(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: in_addr,
    arg_arg3: in_addr,
    arg_arg4: *mut u32,
    arg_arg5: *mut u32,
    arg_arg6: *mut in_addr,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getipv4sourcefilter(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: in_addr,
                arg_arg3: in_addr,
                arg_arg4: *mut u32,
                arg_arg5: *mut u32,
                arg_arg6: *mut in_addr,
            ) -> ::std::os::raw::c_int;
        }
        getipv4sourcefilter(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6)
    })
}
pub unsafe fn setsourcefilter(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: u32,
    arg_arg3: *mut sockaddr,
    arg_arg4: socklen_t,
    arg_arg5: u32,
    arg_arg6: u32,
    arg_arg7: *mut sockaddr_storage,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setsourcefilter(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: u32,
                arg_arg3: *mut sockaddr,
                arg_arg4: socklen_t,
                arg_arg5: u32,
                arg_arg6: u32,
                arg_arg7: *mut sockaddr_storage,
            ) -> ::std::os::raw::c_int;
        }
        setsourcefilter(
            arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6, arg_arg7,
        )
    })
}
pub unsafe fn getsourcefilter(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: u32,
    arg_arg3: *mut sockaddr,
    arg_arg4: socklen_t,
    arg_arg5: *mut u32,
    arg_arg6: *mut u32,
    arg_arg7: *mut sockaddr_storage,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getsourcefilter(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: u32,
                arg_arg3: *mut sockaddr,
                arg_arg4: socklen_t,
                arg_arg5: *mut u32,
                arg_arg6: *mut u32,
                arg_arg7: *mut sockaddr_storage,
            ) -> ::std::os::raw::c_int;
        }
        getsourcefilter(
            arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6, arg_arg7,
        )
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct in_pktinfo {
    pub ipi_ifindex: ::std::os::raw::c_uint,
    pub ipi_spec_dst: in_addr,
    pub ipi_addr: in_addr,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub __u6_addr: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub __u6_addr8: [__uint8_t; 16usize],
    pub __u6_addr16: [__uint16_t; 8usize],
    pub __u6_addr32: [__uint32_t; 4usize],
}
impl Default for in6_addr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for in6_addr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type in6_addr_t = in6_addr;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_len: __uint8_t,
    pub sin6_family: sa_family_t,
    pub sin6_port: in_port_t,
    pub sin6_flowinfo: __uint32_t,
    pub sin6_addr: in6_addr,
    pub sin6_scope_id: __uint32_t,
}
impl Default for sockaddr_in6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static in6addr_any: in6_addr;
}
extern "C" {
    pub static in6addr_loopback: in6_addr;
}
extern "C" {
    pub static in6addr_nodelocal_allnodes: in6_addr;
}
extern "C" {
    pub static in6addr_linklocal_allnodes: in6_addr;
}
extern "C" {
    pub static in6addr_linklocal_allrouters: in6_addr;
}
extern "C" {
    pub static in6addr_linklocal_allv2routers: in6_addr;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ipv6_mreq {
    pub ipv6mr_multiaddr: in6_addr,
    pub ipv6mr_interface: ::std::os::raw::c_uint,
}
impl Default for ipv6_mreq {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_pktinfo {
    pub ipi6_addr: in6_addr,
    pub ipi6_ifindex: ::std::os::raw::c_uint,
}
impl Default for in6_pktinfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ip6_mtuinfo {
    pub ip6m_addr: sockaddr_in6,
    pub ip6m_mtu: u32,
}
impl Default for ip6_mtuinfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn inet6_option_space(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_option_space(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        inet6_option_space(arg_arg1)
    })
}
pub unsafe fn inet6_option_init(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: *mut *mut cmsghdr,
    arg_arg3: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_option_init(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: *mut *mut cmsghdr,
                arg_arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        inet6_option_init(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn inet6_option_append(
    arg_arg1: *mut cmsghdr,
    arg_arg2: *const __uint8_t,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_option_append(
                arg_arg1: *mut cmsghdr,
                arg_arg2: *const __uint8_t,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        inet6_option_append(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn inet6_option_alloc(
    arg_arg1: *mut cmsghdr,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: ::std::os::raw::c_int,
) -> *mut __uint8_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_option_alloc(
                arg_arg1: *mut cmsghdr,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: ::std::os::raw::c_int,
            ) -> *mut __uint8_t;
        }
        inet6_option_alloc(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn inet6_option_next(
    arg_arg1: *const cmsghdr,
    arg_arg2: *mut *mut __uint8_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_option_next(
                arg_arg1: *const cmsghdr,
                arg_arg2: *mut *mut __uint8_t,
            ) -> ::std::os::raw::c_int;
        }
        inet6_option_next(arg_arg1, arg_arg2)
    })
}
pub unsafe fn inet6_option_find(
    arg_arg1: *const cmsghdr,
    arg_arg2: *mut *mut __uint8_t,
    arg_arg3: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_option_find(
                arg_arg1: *const cmsghdr,
                arg_arg2: *mut *mut __uint8_t,
                arg_arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        inet6_option_find(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn inet6_rthdr_space(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rthdr_space(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
            ) -> usize;
        }
        inet6_rthdr_space(arg_arg1, arg_arg2)
    })
}
pub unsafe fn inet6_rthdr_init(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: ::std::os::raw::c_int,
) -> *mut cmsghdr {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rthdr_init(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: ::std::os::raw::c_int,
            ) -> *mut cmsghdr;
        }
        inet6_rthdr_init(arg_arg1, arg_arg2)
    })
}
pub unsafe fn inet6_rthdr_add(
    arg_arg1: *mut cmsghdr,
    arg_arg2: *const in6_addr,
    arg_arg3: ::std::os::raw::c_uint,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rthdr_add(
                arg_arg1: *mut cmsghdr,
                arg_arg2: *const in6_addr,
                arg_arg3: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int;
        }
        inet6_rthdr_add(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn inet6_rthdr_lasthop(
    arg_arg1: *mut cmsghdr,
    arg_arg2: ::std::os::raw::c_uint,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rthdr_lasthop(
                arg_arg1: *mut cmsghdr,
                arg_arg2: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int;
        }
        inet6_rthdr_lasthop(arg_arg1, arg_arg2)
    })
}
pub unsafe fn inet6_rthdr_segments(arg_arg1: *const cmsghdr) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rthdr_segments(arg_arg1: *const cmsghdr) -> ::std::os::raw::c_int;
        }
        inet6_rthdr_segments(arg_arg1)
    })
}
pub unsafe fn inet6_rthdr_getaddr(
    arg_arg1: *mut cmsghdr,
    arg_arg2: ::std::os::raw::c_int,
) -> *mut in6_addr {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rthdr_getaddr(
                arg_arg1: *mut cmsghdr,
                arg_arg2: ::std::os::raw::c_int,
            ) -> *mut in6_addr;
        }
        inet6_rthdr_getaddr(arg_arg1, arg_arg2)
    })
}
pub unsafe fn inet6_rthdr_getflags(
    arg_arg1: *const cmsghdr,
    arg_arg2: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rthdr_getflags(
                arg_arg1: *const cmsghdr,
                arg_arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        inet6_rthdr_getflags(arg_arg1, arg_arg2)
    })
}
pub unsafe fn inet6_opt_init(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_opt_init(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        inet6_opt_init(arg_arg1, arg_arg2)
    })
}
pub unsafe fn inet6_opt_append(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: socklen_t,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: __uint8_t,
    arg_arg5: socklen_t,
    arg_arg6: __uint8_t,
    arg_arg7: *mut *mut ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_opt_append(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: socklen_t,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: __uint8_t,
                arg_arg5: socklen_t,
                arg_arg6: __uint8_t,
                arg_arg7: *mut *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        inet6_opt_append(
            arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6, arg_arg7,
        )
    })
}
pub unsafe fn inet6_opt_finish(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: socklen_t,
    arg_arg3: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_opt_finish(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: socklen_t,
                arg_arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        inet6_opt_finish(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn inet6_opt_set_val(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: *mut ::std::os::raw::c_void,
    arg_arg4: socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_opt_set_val(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: *mut ::std::os::raw::c_void,
                arg_arg4: socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        inet6_opt_set_val(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn inet6_opt_next(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: socklen_t,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: *mut __uint8_t,
    arg_arg5: *mut socklen_t,
    arg_arg6: *mut *mut ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_opt_next(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: socklen_t,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: *mut __uint8_t,
                arg_arg5: *mut socklen_t,
                arg_arg6: *mut *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        inet6_opt_next(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6)
    })
}
pub unsafe fn inet6_opt_find(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: socklen_t,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: __uint8_t,
    arg_arg5: *mut socklen_t,
    arg_arg6: *mut *mut ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_opt_find(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: socklen_t,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: __uint8_t,
                arg_arg5: *mut socklen_t,
                arg_arg6: *mut *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        inet6_opt_find(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6)
    })
}
pub unsafe fn inet6_opt_get_val(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: *mut ::std::os::raw::c_void,
    arg_arg4: socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_opt_get_val(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: *mut ::std::os::raw::c_void,
                arg_arg4: socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        inet6_opt_get_val(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn inet6_rth_space(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
) -> socklen_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rth_space(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
            ) -> socklen_t;
        }
        inet6_rth_space(arg_arg1, arg_arg2)
    })
}
pub unsafe fn inet6_rth_init(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: socklen_t,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rth_init(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: socklen_t,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_void;
        }
        inet6_rth_init(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn inet6_rth_add(
    arg_arg1: *mut ::std::os::raw::c_void,
    arg_arg2: *const in6_addr,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rth_add(
                arg_arg1: *mut ::std::os::raw::c_void,
                arg_arg2: *const in6_addr,
            ) -> ::std::os::raw::c_int;
        }
        inet6_rth_add(arg_arg1, arg_arg2)
    })
}
pub unsafe fn inet6_rth_reverse(
    arg_arg1: *const ::std::os::raw::c_void,
    arg_arg2: *mut ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rth_reverse(
                arg_arg1: *const ::std::os::raw::c_void,
                arg_arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        inet6_rth_reverse(arg_arg1, arg_arg2)
    })
}
pub unsafe fn inet6_rth_segments(arg_arg1: *const ::std::os::raw::c_void) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rth_segments(arg_arg1: *const ::std::os::raw::c_void)
                -> ::std::os::raw::c_int;
        }
        inet6_rth_segments(arg_arg1)
    })
}
pub unsafe fn inet6_rth_getaddr(
    arg_arg1: *const ::std::os::raw::c_void,
    arg_arg2: ::std::os::raw::c_int,
) -> *mut in6_addr {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet6_rth_getaddr(
                arg_arg1: *const ::std::os::raw::c_void,
                arg_arg2: ::std::os::raw::c_int,
            ) -> *mut in6_addr;
        }
        inet6_rth_getaddr(arg_arg1, arg_arg2)
    })
}
pub unsafe fn bindresvport(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut sockaddr_in,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bindresvport(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut sockaddr_in,
            ) -> ::std::os::raw::c_int;
        }
        bindresvport(arg_arg1, arg_arg2)
    })
}
pub unsafe fn bindresvport_sa(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut sockaddr,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bindresvport_sa(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut sockaddr,
            ) -> ::std::os::raw::c_int;
        }
        bindresvport_sa(arg_arg1, arg_arg2)
    })
}
extern "C" {
    pub static mut h_errno: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hostent {
    pub h_name: *mut ::std::os::raw::c_char,
    pub h_aliases: *mut *mut ::std::os::raw::c_char,
    pub h_addrtype: ::std::os::raw::c_int,
    pub h_length: ::std::os::raw::c_int,
    pub h_addr_list: *mut *mut ::std::os::raw::c_char,
}
impl Default for hostent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct netent {
    pub n_name: *mut ::std::os::raw::c_char,
    pub n_aliases: *mut *mut ::std::os::raw::c_char,
    pub n_addrtype: ::std::os::raw::c_int,
    pub n_net: u32,
}
impl Default for netent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct servent {
    pub s_name: *mut ::std::os::raw::c_char,
    pub s_aliases: *mut *mut ::std::os::raw::c_char,
    pub s_port: ::std::os::raw::c_int,
    pub s_proto: *mut ::std::os::raw::c_char,
}
impl Default for servent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct protoent {
    pub p_name: *mut ::std::os::raw::c_char,
    pub p_aliases: *mut *mut ::std::os::raw::c_char,
    pub p_proto: ::std::os::raw::c_int,
}
impl Default for protoent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct addrinfo {
    pub ai_flags: ::std::os::raw::c_int,
    pub ai_family: ::std::os::raw::c_int,
    pub ai_socktype: ::std::os::raw::c_int,
    pub ai_protocol: ::std::os::raw::c_int,
    pub ai_addrlen: socklen_t,
    pub ai_canonname: *mut ::std::os::raw::c_char,
    pub ai_addr: *mut sockaddr,
    pub ai_next: *mut addrinfo,
}
impl Default for addrinfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rpcent {
    pub r_name: *mut ::std::os::raw::c_char,
    pub r_aliases: *mut *mut ::std::os::raw::c_char,
    pub r_number: ::std::os::raw::c_int,
}
impl Default for rpcent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn endhostent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endhostent();
        }
        endhostent()
    })
}
pub unsafe fn endnetent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endnetent();
        }
        endnetent()
    })
}
pub unsafe fn endprotoent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endprotoent();
        }
        endprotoent()
    })
}
pub unsafe fn endservent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endservent();
        }
        endservent()
    })
}
pub unsafe fn freeaddrinfo(arg_arg1: *mut addrinfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn freeaddrinfo(arg_arg1: *mut addrinfo);
        }
        freeaddrinfo(arg_arg1)
    })
}
pub unsafe fn gai_strerror(arg_arg1: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gai_strerror(arg_arg1: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
        }
        gai_strerror(arg_arg1)
    })
}
pub unsafe fn getaddrinfo(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: *const addrinfo,
    arg_arg4: *mut *mut addrinfo,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getaddrinfo(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: *const addrinfo,
                arg_arg4: *mut *mut addrinfo,
            ) -> ::std::os::raw::c_int;
        }
        getaddrinfo(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn gethostbyaddr(
    arg_arg1: *const ::std::os::raw::c_void,
    arg_arg2: socklen_t,
    arg_arg3: ::std::os::raw::c_int,
) -> *mut hostent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostbyaddr(
                arg_arg1: *const ::std::os::raw::c_void,
                arg_arg2: socklen_t,
                arg_arg3: ::std::os::raw::c_int,
            ) -> *mut hostent;
        }
        gethostbyaddr(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn gethostbyname(arg_arg1: *const ::std::os::raw::c_char) -> *mut hostent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostbyname(arg_arg1: *const ::std::os::raw::c_char) -> *mut hostent;
        }
        gethostbyname(arg_arg1)
    })
}
pub unsafe fn gethostent() -> *mut hostent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostent() -> *mut hostent;
        }
        gethostent()
    })
}
pub unsafe fn getnameinfo(
    arg_arg1: *const sockaddr,
    arg_arg2: socklen_t,
    arg_arg3: *mut ::std::os::raw::c_char,
    arg_arg4: socklen_t,
    arg_arg5: *mut ::std::os::raw::c_char,
    arg_arg6: socklen_t,
    arg_arg7: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnameinfo(
                arg_arg1: *const sockaddr,
                arg_arg2: socklen_t,
                arg_arg3: *mut ::std::os::raw::c_char,
                arg_arg4: socklen_t,
                arg_arg5: *mut ::std::os::raw::c_char,
                arg_arg6: socklen_t,
                arg_arg7: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        getnameinfo(
            arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5, arg_arg6, arg_arg7,
        )
    })
}
pub unsafe fn getnetbyaddr(arg_arg1: u32, arg_arg2: ::std::os::raw::c_int) -> *mut netent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetbyaddr(arg_arg1: u32, arg_arg2: ::std::os::raw::c_int) -> *mut netent;
        }
        getnetbyaddr(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getnetbyname(arg_arg1: *const ::std::os::raw::c_char) -> *mut netent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetbyname(arg_arg1: *const ::std::os::raw::c_char) -> *mut netent;
        }
        getnetbyname(arg_arg1)
    })
}
pub unsafe fn getnetent() -> *mut netent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetent() -> *mut netent;
        }
        getnetent()
    })
}
pub unsafe fn getprotobyname(arg_arg1: *const ::std::os::raw::c_char) -> *mut protoent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getprotobyname(arg_arg1: *const ::std::os::raw::c_char) -> *mut protoent;
        }
        getprotobyname(arg_arg1)
    })
}
pub unsafe fn getprotobynumber(arg_arg1: ::std::os::raw::c_int) -> *mut protoent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getprotobynumber(arg_arg1: ::std::os::raw::c_int) -> *mut protoent;
        }
        getprotobynumber(arg_arg1)
    })
}
pub unsafe fn getprotoent() -> *mut protoent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getprotoent() -> *mut protoent;
        }
        getprotoent()
    })
}
pub unsafe fn getservbyname(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
) -> *mut servent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getservbyname(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> *mut servent;
        }
        getservbyname(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getservbyport(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_char,
) -> *mut servent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getservbyport(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_char,
            ) -> *mut servent;
        }
        getservbyport(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getservent() -> *mut servent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getservent() -> *mut servent;
        }
        getservent()
    })
}
pub unsafe fn sethostent(arg_arg1: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sethostent(arg_arg1: ::std::os::raw::c_int);
        }
        sethostent(arg_arg1)
    })
}
pub unsafe fn setnetent(arg_arg1: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setnetent(arg_arg1: ::std::os::raw::c_int);
        }
        setnetent(arg_arg1)
    })
}
pub unsafe fn setprotoent(arg_arg1: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setprotoent(arg_arg1: ::std::os::raw::c_int);
        }
        setprotoent(arg_arg1)
    })
}
pub unsafe fn setservent(arg_arg1: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setservent(arg_arg1: ::std::os::raw::c_int);
        }
        setservent(arg_arg1)
    })
}
pub unsafe fn freehostent(arg_arg1: *mut hostent) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn freehostent(arg_arg1: *mut hostent);
        }
        freehostent(arg_arg1)
    })
}
pub unsafe fn gethostbyname2(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
) -> *mut hostent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostbyname2(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
            ) -> *mut hostent;
        }
        gethostbyname2(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getipnodebyaddr(
    arg_arg1: *const ::std::os::raw::c_void,
    arg_arg2: usize,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: *mut ::std::os::raw::c_int,
) -> *mut hostent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getipnodebyaddr(
                arg_arg1: *const ::std::os::raw::c_void,
                arg_arg2: usize,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: *mut ::std::os::raw::c_int,
            ) -> *mut hostent;
        }
        getipnodebyaddr(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn getipnodebyname(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: *mut ::std::os::raw::c_int,
) -> *mut hostent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getipnodebyname(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: *mut ::std::os::raw::c_int,
            ) -> *mut hostent;
        }
        getipnodebyname(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn getrpcbyname(arg_name: *const ::std::os::raw::c_char) -> *mut rpcent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrpcbyname(arg_name: *const ::std::os::raw::c_char) -> *mut rpcent;
        }
        getrpcbyname(arg_name)
    })
}
pub unsafe fn getrpcbynumber(arg_number: ::std::os::raw::c_int) -> *mut rpcent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrpcbynumber(arg_number: ::std::os::raw::c_int) -> *mut rpcent;
        }
        getrpcbynumber(arg_number)
    })
}
pub unsafe fn getrpcent() -> *mut rpcent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrpcent() -> *mut rpcent;
        }
        getrpcent()
    })
}
pub unsafe fn setrpcent(arg_stayopen: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setrpcent(arg_stayopen: ::std::os::raw::c_int);
        }
        setrpcent(arg_stayopen)
    })
}
pub unsafe fn endrpcent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endrpcent();
        }
        endrpcent()
    })
}
pub unsafe fn herror(arg_arg1: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn herror(arg_arg1: *const ::std::os::raw::c_char);
        }
        herror(arg_arg1)
    })
}
pub unsafe fn hstrerror(arg_arg1: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hstrerror(arg_arg1: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
        }
        hstrerror(arg_arg1)
    })
}
pub unsafe fn innetgr(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: *const ::std::os::raw::c_char,
    arg_arg4: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn innetgr(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: *const ::std::os::raw::c_char,
                arg_arg4: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        innetgr(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn getnetgrent(
    arg_arg1: *mut *mut ::std::os::raw::c_char,
    arg_arg2: *mut *mut ::std::os::raw::c_char,
    arg_arg3: *mut *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetgrent(
                arg_arg1: *mut *mut ::std::os::raw::c_char,
                arg_arg2: *mut *mut ::std::os::raw::c_char,
                arg_arg3: *mut *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        getnetgrent(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn endnetgrent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endnetgrent();
        }
        endnetgrent()
    })
}
pub unsafe fn setnetgrent(arg_arg1: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setnetgrent(arg_arg1: *const ::std::os::raw::c_char);
        }
        setnetgrent(arg_arg1)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct passwd {
    pub pw_name: *mut ::std::os::raw::c_char,
    pub pw_passwd: *mut ::std::os::raw::c_char,
    pub pw_uid: uid_t,
    pub pw_gid: gid_t,
    pub pw_change: __darwin_time_t,
    pub pw_class: *mut ::std::os::raw::c_char,
    pub pw_gecos: *mut ::std::os::raw::c_char,
    pub pw_dir: *mut ::std::os::raw::c_char,
    pub pw_shell: *mut ::std::os::raw::c_char,
    pub pw_expire: __darwin_time_t,
}
impl Default for passwd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn getpwuid(arg_arg1: uid_t) -> *mut passwd {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwuid(arg_arg1: uid_t) -> *mut passwd;
        }
        getpwuid(arg_arg1)
    })
}
pub unsafe fn getpwnam(arg_arg1: *const ::std::os::raw::c_char) -> *mut passwd {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwnam(arg_arg1: *const ::std::os::raw::c_char) -> *mut passwd;
        }
        getpwnam(arg_arg1)
    })
}
pub unsafe fn getpwuid_r(
    arg_arg1: uid_t,
    arg_arg2: *mut passwd,
    arg_arg3: *mut ::std::os::raw::c_char,
    arg_arg4: usize,
    arg_arg5: *mut *mut passwd,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwuid_r(
                arg_arg1: uid_t,
                arg_arg2: *mut passwd,
                arg_arg3: *mut ::std::os::raw::c_char,
                arg_arg4: usize,
                arg_arg5: *mut *mut passwd,
            ) -> ::std::os::raw::c_int;
        }
        getpwuid_r(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5)
    })
}
pub unsafe fn getpwnam_r(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *mut passwd,
    arg_arg3: *mut ::std::os::raw::c_char,
    arg_arg4: usize,
    arg_arg5: *mut *mut passwd,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwnam_r(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *mut passwd,
                arg_arg3: *mut ::std::os::raw::c_char,
                arg_arg4: usize,
                arg_arg5: *mut *mut passwd,
            ) -> ::std::os::raw::c_int;
        }
        getpwnam_r(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5)
    })
}
pub unsafe fn getpwent() -> *mut passwd {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwent() -> *mut passwd;
        }
        getpwent()
    })
}
pub unsafe fn setpwent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setpwent();
        }
        setpwent()
    })
}
pub unsafe fn endpwent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endpwent();
        }
        endpwent()
    })
}
pub type uuid_t = __darwin_uuid_t;
pub type uuid_string_t = __darwin_uuid_string_t;
extern "C" {
    pub static UUID_NULL: uuid_t;
}
pub unsafe fn uuid_clear(arg_uu: *mut ::std::os::raw::c_uchar) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_clear(arg_uu: *mut ::std::os::raw::c_uchar);
        }
        uuid_clear(arg_uu)
    })
}
pub unsafe fn uuid_compare(
    arg_uu1: *mut ::std::os::raw::c_uchar,
    arg_uu2: *mut ::std::os::raw::c_uchar,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_compare(
                arg_uu1: *mut ::std::os::raw::c_uchar,
                arg_uu2: *mut ::std::os::raw::c_uchar,
            ) -> ::std::os::raw::c_int;
        }
        uuid_compare(arg_uu1, arg_uu2)
    })
}
pub unsafe fn uuid_copy(
    arg_dst: *mut ::std::os::raw::c_uchar,
    arg_src: *mut ::std::os::raw::c_uchar,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_copy(
                arg_dst: *mut ::std::os::raw::c_uchar,
                arg_src: *mut ::std::os::raw::c_uchar,
            );
        }
        uuid_copy(arg_dst, arg_src)
    })
}
pub unsafe fn uuid_generate(arg_out: *mut ::std::os::raw::c_uchar) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_generate(arg_out: *mut ::std::os::raw::c_uchar);
        }
        uuid_generate(arg_out)
    })
}
pub unsafe fn uuid_generate_random(arg_out: *mut ::std::os::raw::c_uchar) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_generate_random(arg_out: *mut ::std::os::raw::c_uchar);
        }
        uuid_generate_random(arg_out)
    })
}
pub unsafe fn uuid_generate_time(arg_out: *mut ::std::os::raw::c_uchar) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_generate_time(arg_out: *mut ::std::os::raw::c_uchar);
        }
        uuid_generate_time(arg_out)
    })
}
pub unsafe fn uuid_is_null(arg_uu: *mut ::std::os::raw::c_uchar) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_is_null(arg_uu: *mut ::std::os::raw::c_uchar) -> ::std::os::raw::c_int;
        }
        uuid_is_null(arg_uu)
    })
}
pub unsafe fn uuid_parse(
    arg_in_: *mut ::std::os::raw::c_char,
    arg_uu: *mut ::std::os::raw::c_uchar,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_parse(
                arg_in_: *mut ::std::os::raw::c_char,
                arg_uu: *mut ::std::os::raw::c_uchar,
            ) -> ::std::os::raw::c_int;
        }
        uuid_parse(arg_in_, arg_uu)
    })
}
pub unsafe fn uuid_unparse(
    arg_uu: *mut ::std::os::raw::c_uchar,
    arg_out: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_unparse(
                arg_uu: *mut ::std::os::raw::c_uchar,
                arg_out: *mut ::std::os::raw::c_char,
            );
        }
        uuid_unparse(arg_uu, arg_out)
    })
}
pub unsafe fn uuid_unparse_lower(
    arg_uu: *mut ::std::os::raw::c_uchar,
    arg_out: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_unparse_lower(
                arg_uu: *mut ::std::os::raw::c_uchar,
                arg_out: *mut ::std::os::raw::c_char,
            );
        }
        uuid_unparse_lower(arg_uu, arg_out)
    })
}
pub unsafe fn uuid_unparse_upper(
    arg_uu: *mut ::std::os::raw::c_uchar,
    arg_out: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uuid_unparse_upper(
                arg_uu: *mut ::std::os::raw::c_uchar,
                arg_out: *mut ::std::os::raw::c_char,
            );
        }
        uuid_unparse_upper(arg_uu, arg_out)
    })
}
pub unsafe fn setpassent(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setpassent(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        setpassent(arg_arg1)
    })
}
pub unsafe fn user_from_uid(
    arg_arg1: uid_t,
    arg_arg2: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn user_from_uid(
                arg_arg1: uid_t,
                arg_arg2: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        user_from_uid(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getpwuuid(arg_arg1: *mut ::std::os::raw::c_uchar) -> *mut passwd {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwuuid(arg_arg1: *mut ::std::os::raw::c_uchar) -> *mut passwd;
        }
        getpwuuid(arg_arg1)
    })
}
pub unsafe fn getpwuuid_r(
    arg_arg1: *mut ::std::os::raw::c_uchar,
    arg_arg2: *mut passwd,
    arg_arg3: *mut ::std::os::raw::c_char,
    arg_arg4: usize,
    arg_arg5: *mut *mut passwd,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwuuid_r(
                arg_arg1: *mut ::std::os::raw::c_uchar,
                arg_arg2: *mut passwd,
                arg_arg3: *mut ::std::os::raw::c_char,
                arg_arg4: usize,
                arg_arg5: *mut *mut passwd,
            ) -> ::std::os::raw::c_int;
        }
        getpwuuid_r(arg_arg1, arg_arg2, arg_arg3, arg_arg4, arg_arg5)
    })
}
pub type pgsocket = ::std::os::raw::c_int;
pub unsafe fn pg_set_noblock(arg_sock: pgsocket) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_set_noblock(arg_sock: pgsocket) -> bool;
        }
        pg_set_noblock(arg_sock)
    })
}
pub unsafe fn pg_set_block(arg_sock: pgsocket) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_set_block(arg_sock: pgsocket) -> bool;
        }
        pg_set_block(arg_sock)
    })
}
pub unsafe fn has_drive_prefix(arg_filename: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn has_drive_prefix(arg_filename: *const ::std::os::raw::c_char) -> bool;
        }
        has_drive_prefix(arg_filename)
    })
}
pub unsafe fn first_dir_separator(
    arg_filename: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn first_dir_separator(
                arg_filename: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        first_dir_separator(arg_filename)
    })
}
pub unsafe fn last_dir_separator(
    arg_filename: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn last_dir_separator(
                arg_filename: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        last_dir_separator(arg_filename)
    })
}
pub unsafe fn first_path_var_separator(
    arg_pathlist: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn first_path_var_separator(
                arg_pathlist: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        first_path_var_separator(arg_pathlist)
    })
}
pub unsafe fn join_path_components(
    arg_ret_path: *mut ::std::os::raw::c_char,
    arg_head: *const ::std::os::raw::c_char,
    arg_tail: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn join_path_components(
                arg_ret_path: *mut ::std::os::raw::c_char,
                arg_head: *const ::std::os::raw::c_char,
                arg_tail: *const ::std::os::raw::c_char,
            );
        }
        join_path_components(arg_ret_path, arg_head, arg_tail)
    })
}
pub unsafe fn canonicalize_path(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn canonicalize_path(arg_path: *mut ::std::os::raw::c_char);
        }
        canonicalize_path(arg_path)
    })
}
pub unsafe fn make_native_path(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn make_native_path(arg_path: *mut ::std::os::raw::c_char);
        }
        make_native_path(arg_path)
    })
}
pub unsafe fn cleanup_path(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cleanup_path(arg_path: *mut ::std::os::raw::c_char);
        }
        cleanup_path(arg_path)
    })
}
pub unsafe fn path_contains_parent_reference(arg_path: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn path_contains_parent_reference(arg_path: *const ::std::os::raw::c_char) -> bool;
        }
        path_contains_parent_reference(arg_path)
    })
}
pub unsafe fn path_is_relative_and_below_cwd(arg_path: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn path_is_relative_and_below_cwd(arg_path: *const ::std::os::raw::c_char) -> bool;
        }
        path_is_relative_and_below_cwd(arg_path)
    })
}
pub unsafe fn path_is_prefix_of_path(
    arg_path1: *const ::std::os::raw::c_char,
    arg_path2: *const ::std::os::raw::c_char,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn path_is_prefix_of_path(
                arg_path1: *const ::std::os::raw::c_char,
                arg_path2: *const ::std::os::raw::c_char,
            ) -> bool;
        }
        path_is_prefix_of_path(arg_path1, arg_path2)
    })
}
pub unsafe fn make_absolute_path(
    arg_path: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn make_absolute_path(
                arg_path: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        make_absolute_path(arg_path)
    })
}
pub unsafe fn get_progname(
    arg_argv0: *const ::std::os::raw::c_char,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_progname(
                arg_argv0: *const ::std::os::raw::c_char,
            ) -> *const ::std::os::raw::c_char;
        }
        get_progname(arg_argv0)
    })
}
pub unsafe fn get_share_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_share_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_share_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_etc_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_etc_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_etc_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_include_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_include_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_include_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_pkginclude_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_pkginclude_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_pkginclude_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_includeserver_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_includeserver_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_includeserver_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_lib_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_lib_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_lib_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_pkglib_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_pkglib_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_pkglib_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_locale_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_locale_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_locale_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_doc_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_doc_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_doc_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_html_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_html_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_html_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_man_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_man_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_man_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_home_path(arg_ret_path: *mut ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_home_path(arg_ret_path: *mut ::std::os::raw::c_char) -> bool;
        }
        get_home_path(arg_ret_path)
    })
}
pub unsafe fn get_parent_directory(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_parent_directory(arg_path: *mut ::std::os::raw::c_char);
        }
        get_parent_directory(arg_path)
    })
}
pub unsafe fn pgfnames(
    arg_path: *const ::std::os::raw::c_char,
) -> *mut *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgfnames(
                arg_path: *const ::std::os::raw::c_char,
            ) -> *mut *mut ::std::os::raw::c_char;
        }
        pgfnames(arg_path)
    })
}
pub unsafe fn pgfnames_cleanup(arg_filenames: *mut *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgfnames_cleanup(arg_filenames: *mut *mut ::std::os::raw::c_char);
        }
        pgfnames_cleanup(arg_filenames)
    })
}
pub unsafe fn set_pglocale_pgservice(
    arg_argv0: *const ::std::os::raw::c_char,
    arg_app: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_pglocale_pgservice(
                arg_argv0: *const ::std::os::raw::c_char,
                arg_app: *const ::std::os::raw::c_char,
            );
        }
        set_pglocale_pgservice(arg_argv0, arg_app)
    })
}
pub unsafe fn validate_exec(arg_path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn validate_exec(arg_path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        validate_exec(arg_path)
    })
}
pub unsafe fn find_my_exec(
    arg_argv0: *const ::std::os::raw::c_char,
    arg_retpath: *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_my_exec(
                arg_argv0: *const ::std::os::raw::c_char,
                arg_retpath: *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        find_my_exec(arg_argv0, arg_retpath)
    })
}
pub unsafe fn find_other_exec(
    arg_argv0: *const ::std::os::raw::c_char,
    arg_target: *const ::std::os::raw::c_char,
    arg_versionstr: *const ::std::os::raw::c_char,
    arg_retpath: *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_other_exec(
                arg_argv0: *const ::std::os::raw::c_char,
                arg_target: *const ::std::os::raw::c_char,
                arg_versionstr: *const ::std::os::raw::c_char,
                arg_retpath: *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        find_other_exec(arg_argv0, arg_target, arg_versionstr, arg_retpath)
    })
}
pub unsafe fn pipe_read_line(
    arg_cmd: *mut ::std::os::raw::c_char,
    arg_line: *mut ::std::os::raw::c_char,
    arg_maxsize: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pipe_read_line(
                arg_cmd: *mut ::std::os::raw::c_char,
                arg_line: *mut ::std::os::raw::c_char,
                arg_maxsize: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        pipe_read_line(arg_cmd, arg_line, arg_maxsize)
    })
}
pub unsafe fn pg_usleep(arg_microsec: ::std::os::raw::c_long) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_usleep(arg_microsec: ::std::os::raw::c_long);
        }
        pg_usleep(arg_microsec)
    })
}
pub unsafe fn pg_strcasecmp(
    arg_s1: *const ::std::os::raw::c_char,
    arg_s2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strcasecmp(
                arg_s1: *const ::std::os::raw::c_char,
                arg_s2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_strcasecmp(arg_s1, arg_s2)
    })
}
pub unsafe fn pg_strncasecmp(
    arg_s1: *const ::std::os::raw::c_char,
    arg_s2: *const ::std::os::raw::c_char,
    arg_n: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strncasecmp(
                arg_s1: *const ::std::os::raw::c_char,
                arg_s2: *const ::std::os::raw::c_char,
                arg_n: usize,
            ) -> ::std::os::raw::c_int;
        }
        pg_strncasecmp(arg_s1, arg_s2, arg_n)
    })
}
pub unsafe fn pg_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_toupper(arg_ch)
    })
}
pub unsafe fn pg_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_tolower(arg_ch)
    })
}
pub unsafe fn pg_ascii_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_ascii_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_ascii_toupper(arg_ch)
    })
}
pub unsafe fn pg_ascii_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_ascii_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_ascii_tolower(arg_ch)
    })
}
pub unsafe fn pg_vsnprintf(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_count: usize,
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_vsnprintf(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_count: usize,
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: va_list,
            ) -> ::std::os::raw::c_int;
        }
        pg_vsnprintf(arg_str_, arg_count, arg_fmt, arg_args)
    })
}
pub unsafe fn pg_snprintf(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_count: usize,
    arg_fmt: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_snprintf(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_count: usize,
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_snprintf(arg_str_, arg_count, arg_fmt)
    })
}
pub unsafe fn pg_vsprintf(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_vsprintf(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: va_list,
            ) -> ::std::os::raw::c_int;
        }
        pg_vsprintf(arg_str_, arg_fmt, arg_args)
    })
}
pub unsafe fn pg_sprintf(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_fmt: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_sprintf(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_sprintf(arg_str_, arg_fmt)
    })
}
pub unsafe fn pg_vfprintf(
    arg_stream: *mut FILE,
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_vfprintf(
                arg_stream: *mut FILE,
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: va_list,
            ) -> ::std::os::raw::c_int;
        }
        pg_vfprintf(arg_stream, arg_fmt, arg_args)
    })
}
pub unsafe fn pg_fprintf(
    arg_stream: *mut FILE,
    arg_fmt: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fprintf(
                arg_stream: *mut FILE,
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_fprintf(arg_stream, arg_fmt)
    })
}
pub unsafe fn pg_vprintf(
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_vprintf(
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: va_list,
            ) -> ::std::os::raw::c_int;
        }
        pg_vprintf(arg_fmt, arg_args)
    })
}
pub unsafe fn pg_printf(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_printf(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        pg_printf(arg_fmt)
    })
}
pub unsafe fn pg_strfromd(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_count: usize,
    arg_precision: ::std::os::raw::c_int,
    arg_value: f64,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strfromd(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_count: usize,
                arg_precision: ::std::os::raw::c_int,
                arg_value: f64,
            ) -> ::std::os::raw::c_int;
        }
        pg_strfromd(arg_str_, arg_count, arg_precision, arg_value)
    })
}
pub unsafe fn pg_strerror(arg_errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strerror(arg_errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
        }
        pg_strerror(arg_errnum)
    })
}
pub unsafe fn pg_strerror_r(
    arg_errnum: ::std::os::raw::c_int,
    arg_buf: *mut ::std::os::raw::c_char,
    arg_buflen: usize,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strerror_r(
                arg_errnum: ::std::os::raw::c_int,
                arg_buf: *mut ::std::os::raw::c_char,
                arg_buflen: usize,
            ) -> *mut ::std::os::raw::c_char;
        }
        pg_strerror_r(arg_errnum, arg_buf, arg_buflen)
    })
}
pub unsafe fn pg_strsignal(arg_signum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strsignal(arg_signum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
        }
        pg_strsignal(arg_signum)
    })
}
pub unsafe fn pclose_check(arg_stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pclose_check(arg_stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        pclose_check(arg_stream)
    })
}
pub unsafe fn rmtree(arg_path: *const ::std::os::raw::c_char, arg_rmtopdir: bool) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rmtree(arg_path: *const ::std::os::raw::c_char, arg_rmtopdir: bool) -> bool;
        }
        rmtree(arg_path, arg_rmtopdir)
    })
}
pub unsafe fn pg_erand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_erand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> f64;
        }
        pg_erand48(arg_xseed)
    })
}
pub unsafe fn pg_lrand48() -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_lrand48() -> ::std::os::raw::c_long;
        }
        pg_lrand48()
    })
}
pub unsafe fn pg_jrand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_jrand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
        }
        pg_jrand48(arg_xseed)
    })
}
pub unsafe fn pg_srand48(arg_seed: ::std::os::raw::c_long) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_srand48(arg_seed: ::std::os::raw::c_long);
        }
        pg_srand48(arg_seed)
    })
}
pub type float_t = f32;
pub type double_t = f64;
pub unsafe fn __math_errhandling() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __math_errhandling() -> ::std::os::raw::c_int;
        }
        __math_errhandling()
    })
}
pub unsafe fn __fpclassifyf(arg_arg1: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fpclassifyf(arg_arg1: f32) -> ::std::os::raw::c_int;
        }
        __fpclassifyf(arg_arg1)
    })
}
pub unsafe fn __fpclassifyd(arg_arg1: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fpclassifyd(arg_arg1: f64) -> ::std::os::raw::c_int;
        }
        __fpclassifyd(arg_arg1)
    })
}
pub unsafe fn __fpclassifyl(arg_arg1: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fpclassifyl(arg_arg1: f64) -> ::std::os::raw::c_int;
        }
        __fpclassifyl(arg_arg1)
    })
}
pub unsafe fn acosf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acosf(arg_arg1: f32) -> f32;
        }
        acosf(arg_arg1)
    })
}
pub unsafe fn acos(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acos(arg_arg1: f64) -> f64;
        }
        acos(arg_arg1)
    })
}
pub unsafe fn acosl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acosl(arg_arg1: f64) -> f64;
        }
        acosl(arg_arg1)
    })
}
pub unsafe fn asinf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asinf(arg_arg1: f32) -> f32;
        }
        asinf(arg_arg1)
    })
}
pub unsafe fn asin(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asin(arg_arg1: f64) -> f64;
        }
        asin(arg_arg1)
    })
}
pub unsafe fn asinl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asinl(arg_arg1: f64) -> f64;
        }
        asinl(arg_arg1)
    })
}
pub unsafe fn atanf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atanf(arg_arg1: f32) -> f32;
        }
        atanf(arg_arg1)
    })
}
pub unsafe fn atan(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atan(arg_arg1: f64) -> f64;
        }
        atan(arg_arg1)
    })
}
pub unsafe fn atanl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atanl(arg_arg1: f64) -> f64;
        }
        atanl(arg_arg1)
    })
}
pub unsafe fn atan2f(arg_arg1: f32, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atan2f(arg_arg1: f32, arg_arg2: f32) -> f32;
        }
        atan2f(arg_arg1, arg_arg2)
    })
}
pub unsafe fn atan2(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atan2(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        atan2(arg_arg1, arg_arg2)
    })
}
pub unsafe fn atan2l(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atan2l(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        atan2l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn cosf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cosf(arg_arg1: f32) -> f32;
        }
        cosf(arg_arg1)
    })
}
pub unsafe fn cos(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cos(arg_arg1: f64) -> f64;
        }
        cos(arg_arg1)
    })
}
pub unsafe fn cosl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cosl(arg_arg1: f64) -> f64;
        }
        cosl(arg_arg1)
    })
}
pub unsafe fn sinf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sinf(arg_arg1: f32) -> f32;
        }
        sinf(arg_arg1)
    })
}
pub unsafe fn sin(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sin(arg_arg1: f64) -> f64;
        }
        sin(arg_arg1)
    })
}
pub unsafe fn sinl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sinl(arg_arg1: f64) -> f64;
        }
        sinl(arg_arg1)
    })
}
pub unsafe fn tanf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tanf(arg_arg1: f32) -> f32;
        }
        tanf(arg_arg1)
    })
}
pub unsafe fn tan(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tan(arg_arg1: f64) -> f64;
        }
        tan(arg_arg1)
    })
}
pub unsafe fn tanl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tanl(arg_arg1: f64) -> f64;
        }
        tanl(arg_arg1)
    })
}
pub unsafe fn acoshf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acoshf(arg_arg1: f32) -> f32;
        }
        acoshf(arg_arg1)
    })
}
pub unsafe fn acosh(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acosh(arg_arg1: f64) -> f64;
        }
        acosh(arg_arg1)
    })
}
pub unsafe fn acoshl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acoshl(arg_arg1: f64) -> f64;
        }
        acoshl(arg_arg1)
    })
}
pub unsafe fn asinhf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asinhf(arg_arg1: f32) -> f32;
        }
        asinhf(arg_arg1)
    })
}
pub unsafe fn asinh(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asinh(arg_arg1: f64) -> f64;
        }
        asinh(arg_arg1)
    })
}
pub unsafe fn asinhl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asinhl(arg_arg1: f64) -> f64;
        }
        asinhl(arg_arg1)
    })
}
pub unsafe fn atanhf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atanhf(arg_arg1: f32) -> f32;
        }
        atanhf(arg_arg1)
    })
}
pub unsafe fn atanh(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atanh(arg_arg1: f64) -> f64;
        }
        atanh(arg_arg1)
    })
}
pub unsafe fn atanhl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atanhl(arg_arg1: f64) -> f64;
        }
        atanhl(arg_arg1)
    })
}
pub unsafe fn coshf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn coshf(arg_arg1: f32) -> f32;
        }
        coshf(arg_arg1)
    })
}
pub unsafe fn cosh(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cosh(arg_arg1: f64) -> f64;
        }
        cosh(arg_arg1)
    })
}
pub unsafe fn coshl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn coshl(arg_arg1: f64) -> f64;
        }
        coshl(arg_arg1)
    })
}
pub unsafe fn sinhf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sinhf(arg_arg1: f32) -> f32;
        }
        sinhf(arg_arg1)
    })
}
pub unsafe fn sinh(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sinh(arg_arg1: f64) -> f64;
        }
        sinh(arg_arg1)
    })
}
pub unsafe fn sinhl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sinhl(arg_arg1: f64) -> f64;
        }
        sinhl(arg_arg1)
    })
}
pub unsafe fn tanhf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tanhf(arg_arg1: f32) -> f32;
        }
        tanhf(arg_arg1)
    })
}
pub unsafe fn tanh(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tanh(arg_arg1: f64) -> f64;
        }
        tanh(arg_arg1)
    })
}
pub unsafe fn tanhl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tanhl(arg_arg1: f64) -> f64;
        }
        tanhl(arg_arg1)
    })
}
pub unsafe fn expf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn expf(arg_arg1: f32) -> f32;
        }
        expf(arg_arg1)
    })
}
pub unsafe fn exp(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn exp(arg_arg1: f64) -> f64;
        }
        exp(arg_arg1)
    })
}
pub unsafe fn expl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn expl(arg_arg1: f64) -> f64;
        }
        expl(arg_arg1)
    })
}
pub unsafe fn exp2f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn exp2f(arg_arg1: f32) -> f32;
        }
        exp2f(arg_arg1)
    })
}
pub unsafe fn exp2(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn exp2(arg_arg1: f64) -> f64;
        }
        exp2(arg_arg1)
    })
}
pub unsafe fn exp2l(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn exp2l(arg_arg1: f64) -> f64;
        }
        exp2l(arg_arg1)
    })
}
pub unsafe fn expm1f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn expm1f(arg_arg1: f32) -> f32;
        }
        expm1f(arg_arg1)
    })
}
pub unsafe fn expm1(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn expm1(arg_arg1: f64) -> f64;
        }
        expm1(arg_arg1)
    })
}
pub unsafe fn expm1l(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn expm1l(arg_arg1: f64) -> f64;
        }
        expm1l(arg_arg1)
    })
}
pub unsafe fn logf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn logf(arg_arg1: f32) -> f32;
        }
        logf(arg_arg1)
    })
}
pub unsafe fn log(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log(arg_arg1: f64) -> f64;
        }
        log(arg_arg1)
    })
}
pub unsafe fn logl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn logl(arg_arg1: f64) -> f64;
        }
        logl(arg_arg1)
    })
}
pub unsafe fn log10f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log10f(arg_arg1: f32) -> f32;
        }
        log10f(arg_arg1)
    })
}
pub unsafe fn log10(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log10(arg_arg1: f64) -> f64;
        }
        log10(arg_arg1)
    })
}
pub unsafe fn log10l(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log10l(arg_arg1: f64) -> f64;
        }
        log10l(arg_arg1)
    })
}
pub unsafe fn log2f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log2f(arg_arg1: f32) -> f32;
        }
        log2f(arg_arg1)
    })
}
pub unsafe fn log2(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log2(arg_arg1: f64) -> f64;
        }
        log2(arg_arg1)
    })
}
pub unsafe fn log2l(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log2l(arg_arg1: f64) -> f64;
        }
        log2l(arg_arg1)
    })
}
pub unsafe fn log1pf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log1pf(arg_arg1: f32) -> f32;
        }
        log1pf(arg_arg1)
    })
}
pub unsafe fn log1p(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log1p(arg_arg1: f64) -> f64;
        }
        log1p(arg_arg1)
    })
}
pub unsafe fn log1pl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log1pl(arg_arg1: f64) -> f64;
        }
        log1pl(arg_arg1)
    })
}
pub unsafe fn logbf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn logbf(arg_arg1: f32) -> f32;
        }
        logbf(arg_arg1)
    })
}
pub unsafe fn logb(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn logb(arg_arg1: f64) -> f64;
        }
        logb(arg_arg1)
    })
}
pub unsafe fn logbl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn logbl(arg_arg1: f64) -> f64;
        }
        logbl(arg_arg1)
    })
}
pub unsafe fn modff(arg_arg1: f32, arg_arg2: *mut f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn modff(arg_arg1: f32, arg_arg2: *mut f32) -> f32;
        }
        modff(arg_arg1, arg_arg2)
    })
}
pub unsafe fn modf(arg_arg1: f64, arg_arg2: *mut f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn modf(arg_arg1: f64, arg_arg2: *mut f64) -> f64;
        }
        modf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn modfl(arg_arg1: f64, arg_arg2: *mut f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn modfl(arg_arg1: f64, arg_arg2: *mut f64) -> f64;
        }
        modfl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn ldexpf(arg_arg1: f32, arg_arg2: ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ldexpf(arg_arg1: f32, arg_arg2: ::std::os::raw::c_int) -> f32;
        }
        ldexpf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn ldexp(arg_arg1: f64, arg_arg2: ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ldexp(arg_arg1: f64, arg_arg2: ::std::os::raw::c_int) -> f64;
        }
        ldexp(arg_arg1, arg_arg2)
    })
}
pub unsafe fn ldexpl(arg_arg1: f64, arg_arg2: ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ldexpl(arg_arg1: f64, arg_arg2: ::std::os::raw::c_int) -> f64;
        }
        ldexpl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn frexpf(arg_arg1: f32, arg_arg2: *mut ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn frexpf(arg_arg1: f32, arg_arg2: *mut ::std::os::raw::c_int) -> f32;
        }
        frexpf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn frexp(arg_arg1: f64, arg_arg2: *mut ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn frexp(arg_arg1: f64, arg_arg2: *mut ::std::os::raw::c_int) -> f64;
        }
        frexp(arg_arg1, arg_arg2)
    })
}
pub unsafe fn frexpl(arg_arg1: f64, arg_arg2: *mut ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn frexpl(arg_arg1: f64, arg_arg2: *mut ::std::os::raw::c_int) -> f64;
        }
        frexpl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn ilogbf(arg_arg1: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ilogbf(arg_arg1: f32) -> ::std::os::raw::c_int;
        }
        ilogbf(arg_arg1)
    })
}
pub unsafe fn ilogb(arg_arg1: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ilogb(arg_arg1: f64) -> ::std::os::raw::c_int;
        }
        ilogb(arg_arg1)
    })
}
pub unsafe fn ilogbl(arg_arg1: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ilogbl(arg_arg1: f64) -> ::std::os::raw::c_int;
        }
        ilogbl(arg_arg1)
    })
}
pub unsafe fn scalbnf(arg_arg1: f32, arg_arg2: ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalbnf(arg_arg1: f32, arg_arg2: ::std::os::raw::c_int) -> f32;
        }
        scalbnf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn scalbn(arg_arg1: f64, arg_arg2: ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalbn(arg_arg1: f64, arg_arg2: ::std::os::raw::c_int) -> f64;
        }
        scalbn(arg_arg1, arg_arg2)
    })
}
pub unsafe fn scalbnl(arg_arg1: f64, arg_arg2: ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalbnl(arg_arg1: f64, arg_arg2: ::std::os::raw::c_int) -> f64;
        }
        scalbnl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn scalblnf(arg_arg1: f32, arg_arg2: ::std::os::raw::c_long) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalblnf(arg_arg1: f32, arg_arg2: ::std::os::raw::c_long) -> f32;
        }
        scalblnf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn scalbln(arg_arg1: f64, arg_arg2: ::std::os::raw::c_long) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalbln(arg_arg1: f64, arg_arg2: ::std::os::raw::c_long) -> f64;
        }
        scalbln(arg_arg1, arg_arg2)
    })
}
pub unsafe fn scalblnl(arg_arg1: f64, arg_arg2: ::std::os::raw::c_long) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalblnl(arg_arg1: f64, arg_arg2: ::std::os::raw::c_long) -> f64;
        }
        scalblnl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fabsf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fabsf(arg_arg1: f32) -> f32;
        }
        fabsf(arg_arg1)
    })
}
pub unsafe fn fabs(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fabs(arg_arg1: f64) -> f64;
        }
        fabs(arg_arg1)
    })
}
pub unsafe fn fabsl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fabsl(arg_arg1: f64) -> f64;
        }
        fabsl(arg_arg1)
    })
}
pub unsafe fn cbrtf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cbrtf(arg_arg1: f32) -> f32;
        }
        cbrtf(arg_arg1)
    })
}
pub unsafe fn cbrt(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cbrt(arg_arg1: f64) -> f64;
        }
        cbrt(arg_arg1)
    })
}
pub unsafe fn cbrtl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cbrtl(arg_arg1: f64) -> f64;
        }
        cbrtl(arg_arg1)
    })
}
pub unsafe fn hypotf(arg_arg1: f32, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hypotf(arg_arg1: f32, arg_arg2: f32) -> f32;
        }
        hypotf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn hypot(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hypot(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        hypot(arg_arg1, arg_arg2)
    })
}
pub unsafe fn hypotl(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hypotl(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        hypotl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn powf(arg_arg1: f32, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn powf(arg_arg1: f32, arg_arg2: f32) -> f32;
        }
        powf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn pow(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pow(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        pow(arg_arg1, arg_arg2)
    })
}
pub unsafe fn powl(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn powl(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        powl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn sqrtf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sqrtf(arg_arg1: f32) -> f32;
        }
        sqrtf(arg_arg1)
    })
}
pub unsafe fn sqrt(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sqrt(arg_arg1: f64) -> f64;
        }
        sqrt(arg_arg1)
    })
}
pub unsafe fn sqrtl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sqrtl(arg_arg1: f64) -> f64;
        }
        sqrtl(arg_arg1)
    })
}
pub unsafe fn erff(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erff(arg_arg1: f32) -> f32;
        }
        erff(arg_arg1)
    })
}
pub unsafe fn erf(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erf(arg_arg1: f64) -> f64;
        }
        erf(arg_arg1)
    })
}
pub unsafe fn erfl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erfl(arg_arg1: f64) -> f64;
        }
        erfl(arg_arg1)
    })
}
pub unsafe fn erfcf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erfcf(arg_arg1: f32) -> f32;
        }
        erfcf(arg_arg1)
    })
}
pub unsafe fn erfc(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erfc(arg_arg1: f64) -> f64;
        }
        erfc(arg_arg1)
    })
}
pub unsafe fn erfcl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erfcl(arg_arg1: f64) -> f64;
        }
        erfcl(arg_arg1)
    })
}
pub unsafe fn lgammaf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lgammaf(arg_arg1: f32) -> f32;
        }
        lgammaf(arg_arg1)
    })
}
pub unsafe fn lgamma(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lgamma(arg_arg1: f64) -> f64;
        }
        lgamma(arg_arg1)
    })
}
pub unsafe fn lgammal(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lgammal(arg_arg1: f64) -> f64;
        }
        lgammal(arg_arg1)
    })
}
pub unsafe fn tgammaf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tgammaf(arg_arg1: f32) -> f32;
        }
        tgammaf(arg_arg1)
    })
}
pub unsafe fn tgamma(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tgamma(arg_arg1: f64) -> f64;
        }
        tgamma(arg_arg1)
    })
}
pub unsafe fn tgammal(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tgammal(arg_arg1: f64) -> f64;
        }
        tgammal(arg_arg1)
    })
}
pub unsafe fn ceilf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ceilf(arg_arg1: f32) -> f32;
        }
        ceilf(arg_arg1)
    })
}
pub unsafe fn ceil(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ceil(arg_arg1: f64) -> f64;
        }
        ceil(arg_arg1)
    })
}
pub unsafe fn ceill(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ceill(arg_arg1: f64) -> f64;
        }
        ceill(arg_arg1)
    })
}
pub unsafe fn floorf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn floorf(arg_arg1: f32) -> f32;
        }
        floorf(arg_arg1)
    })
}
pub unsafe fn floor(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn floor(arg_arg1: f64) -> f64;
        }
        floor(arg_arg1)
    })
}
pub unsafe fn floorl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn floorl(arg_arg1: f64) -> f64;
        }
        floorl(arg_arg1)
    })
}
pub unsafe fn nearbyintf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nearbyintf(arg_arg1: f32) -> f32;
        }
        nearbyintf(arg_arg1)
    })
}
pub unsafe fn nearbyint(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nearbyint(arg_arg1: f64) -> f64;
        }
        nearbyint(arg_arg1)
    })
}
pub unsafe fn nearbyintl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nearbyintl(arg_arg1: f64) -> f64;
        }
        nearbyintl(arg_arg1)
    })
}
pub unsafe fn rintf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rintf(arg_arg1: f32) -> f32;
        }
        rintf(arg_arg1)
    })
}
pub unsafe fn rint(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rint(arg_arg1: f64) -> f64;
        }
        rint(arg_arg1)
    })
}
pub unsafe fn rintl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rintl(arg_arg1: f64) -> f64;
        }
        rintl(arg_arg1)
    })
}
pub unsafe fn lrintf(arg_arg1: f32) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lrintf(arg_arg1: f32) -> ::std::os::raw::c_long;
        }
        lrintf(arg_arg1)
    })
}
pub unsafe fn lrint(arg_arg1: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lrint(arg_arg1: f64) -> ::std::os::raw::c_long;
        }
        lrint(arg_arg1)
    })
}
pub unsafe fn lrintl(arg_arg1: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lrintl(arg_arg1: f64) -> ::std::os::raw::c_long;
        }
        lrintl(arg_arg1)
    })
}
pub unsafe fn roundf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn roundf(arg_arg1: f32) -> f32;
        }
        roundf(arg_arg1)
    })
}
pub unsafe fn round(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn round(arg_arg1: f64) -> f64;
        }
        round(arg_arg1)
    })
}
pub unsafe fn roundl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn roundl(arg_arg1: f64) -> f64;
        }
        roundl(arg_arg1)
    })
}
pub unsafe fn lroundf(arg_arg1: f32) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lroundf(arg_arg1: f32) -> ::std::os::raw::c_long;
        }
        lroundf(arg_arg1)
    })
}
pub unsafe fn lround(arg_arg1: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lround(arg_arg1: f64) -> ::std::os::raw::c_long;
        }
        lround(arg_arg1)
    })
}
pub unsafe fn lroundl(arg_arg1: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lroundl(arg_arg1: f64) -> ::std::os::raw::c_long;
        }
        lroundl(arg_arg1)
    })
}
pub unsafe fn llrintf(arg_arg1: f32) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llrintf(arg_arg1: f32) -> ::std::os::raw::c_longlong;
        }
        llrintf(arg_arg1)
    })
}
pub unsafe fn llrint(arg_arg1: f64) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llrint(arg_arg1: f64) -> ::std::os::raw::c_longlong;
        }
        llrint(arg_arg1)
    })
}
pub unsafe fn llrintl(arg_arg1: f64) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llrintl(arg_arg1: f64) -> ::std::os::raw::c_longlong;
        }
        llrintl(arg_arg1)
    })
}
pub unsafe fn llroundf(arg_arg1: f32) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llroundf(arg_arg1: f32) -> ::std::os::raw::c_longlong;
        }
        llroundf(arg_arg1)
    })
}
pub unsafe fn llround(arg_arg1: f64) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llround(arg_arg1: f64) -> ::std::os::raw::c_longlong;
        }
        llround(arg_arg1)
    })
}
pub unsafe fn llroundl(arg_arg1: f64) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llroundl(arg_arg1: f64) -> ::std::os::raw::c_longlong;
        }
        llroundl(arg_arg1)
    })
}
pub unsafe fn truncf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn truncf(arg_arg1: f32) -> f32;
        }
        truncf(arg_arg1)
    })
}
pub unsafe fn trunc(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn trunc(arg_arg1: f64) -> f64;
        }
        trunc(arg_arg1)
    })
}
pub unsafe fn truncl(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn truncl(arg_arg1: f64) -> f64;
        }
        truncl(arg_arg1)
    })
}
pub unsafe fn fmodf(arg_arg1: f32, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmodf(arg_arg1: f32, arg_arg2: f32) -> f32;
        }
        fmodf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fmod(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmod(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        fmod(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fmodl(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmodl(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        fmodl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn remainderf(arg_arg1: f32, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remainderf(arg_arg1: f32, arg_arg2: f32) -> f32;
        }
        remainderf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn remainder(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remainder(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        remainder(arg_arg1, arg_arg2)
    })
}
pub unsafe fn remainderl(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remainderl(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        remainderl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn remquof(arg_arg1: f32, arg_arg2: f32, arg_arg3: *mut ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remquof(arg_arg1: f32, arg_arg2: f32, arg_arg3: *mut ::std::os::raw::c_int) -> f32;
        }
        remquof(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn remquo(arg_arg1: f64, arg_arg2: f64, arg_arg3: *mut ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remquo(arg_arg1: f64, arg_arg2: f64, arg_arg3: *mut ::std::os::raw::c_int) -> f64;
        }
        remquo(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn remquol(arg_arg1: f64, arg_arg2: f64, arg_arg3: *mut ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remquol(arg_arg1: f64, arg_arg2: f64, arg_arg3: *mut ::std::os::raw::c_int) -> f64;
        }
        remquol(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn copysignf(arg_arg1: f32, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copysignf(arg_arg1: f32, arg_arg2: f32) -> f32;
        }
        copysignf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn copysign(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copysign(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        copysign(arg_arg1, arg_arg2)
    })
}
pub unsafe fn copysignl(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copysignl(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        copysignl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn nanf(arg_arg1: *const ::std::os::raw::c_char) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nanf(arg_arg1: *const ::std::os::raw::c_char) -> f32;
        }
        nanf(arg_arg1)
    })
}
pub unsafe fn nan(arg_arg1: *const ::std::os::raw::c_char) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nan(arg_arg1: *const ::std::os::raw::c_char) -> f64;
        }
        nan(arg_arg1)
    })
}
pub unsafe fn nanl(arg_arg1: *const ::std::os::raw::c_char) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nanl(arg_arg1: *const ::std::os::raw::c_char) -> f64;
        }
        nanl(arg_arg1)
    })
}
pub unsafe fn nextafterf(arg_arg1: f32, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nextafterf(arg_arg1: f32, arg_arg2: f32) -> f32;
        }
        nextafterf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn nextafter(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nextafter(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        nextafter(arg_arg1, arg_arg2)
    })
}
pub unsafe fn nextafterl(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nextafterl(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        nextafterl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn nexttoward(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nexttoward(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        nexttoward(arg_arg1, arg_arg2)
    })
}
pub unsafe fn nexttowardf(arg_arg1: f32, arg_arg2: f64) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nexttowardf(arg_arg1: f32, arg_arg2: f64) -> f32;
        }
        nexttowardf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn nexttowardl(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nexttowardl(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        nexttowardl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fdimf(arg_arg1: f32, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdimf(arg_arg1: f32, arg_arg2: f32) -> f32;
        }
        fdimf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fdim(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdim(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        fdim(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fdiml(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdiml(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        fdiml(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fmaxf(arg_arg1: f32, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmaxf(arg_arg1: f32, arg_arg2: f32) -> f32;
        }
        fmaxf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fmax(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmax(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        fmax(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fmaxl(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmaxl(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        fmaxl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fminf(arg_arg1: f32, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fminf(arg_arg1: f32, arg_arg2: f32) -> f32;
        }
        fminf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fmin(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmin(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        fmin(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fminl(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fminl(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        fminl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fmaf(arg_arg1: f32, arg_arg2: f32, arg_arg3: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmaf(arg_arg1: f32, arg_arg2: f32, arg_arg3: f32) -> f32;
        }
        fmaf(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn fma(arg_arg1: f64, arg_arg2: f64, arg_arg3: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fma(arg_arg1: f64, arg_arg2: f64, arg_arg3: f64) -> f64;
        }
        fma(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn fmal(arg_arg1: f64, arg_arg2: f64, arg_arg3: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmal(arg_arg1: f64, arg_arg2: f64, arg_arg3: f64) -> f64;
        }
        fmal(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn __exp10f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __exp10f(arg_arg1: f32) -> f32;
        }
        __exp10f(arg_arg1)
    })
}
pub unsafe fn __exp10(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __exp10(arg_arg1: f64) -> f64;
        }
        __exp10(arg_arg1)
    })
}
pub unsafe fn __cospif(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __cospif(arg_arg1: f32) -> f32;
        }
        __cospif(arg_arg1)
    })
}
pub unsafe fn __cospi(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __cospi(arg_arg1: f64) -> f64;
        }
        __cospi(arg_arg1)
    })
}
pub unsafe fn __sinpif(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sinpif(arg_arg1: f32) -> f32;
        }
        __sinpif(arg_arg1)
    })
}
pub unsafe fn __sinpi(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sinpi(arg_arg1: f64) -> f64;
        }
        __sinpi(arg_arg1)
    })
}
pub unsafe fn __tanpif(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tanpif(arg_arg1: f32) -> f32;
        }
        __tanpif(arg_arg1)
    })
}
pub unsafe fn __tanpi(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tanpi(arg_arg1: f64) -> f64;
        }
        __tanpi(arg_arg1)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __float2 {
    pub __sinval: f32,
    pub __cosval: f32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __double2 {
    pub __sinval: f64,
    pub __cosval: f64,
}
pub unsafe fn __sincosf_stret(arg_arg1: f32) -> __float2 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sincosf_stret(arg_arg1: f32) -> __float2;
        }
        __sincosf_stret(arg_arg1)
    })
}
pub unsafe fn __sincos_stret(arg_arg1: f64) -> __double2 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sincos_stret(arg_arg1: f64) -> __double2;
        }
        __sincos_stret(arg_arg1)
    })
}
pub unsafe fn __sincospif_stret(arg_arg1: f32) -> __float2 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sincospif_stret(arg_arg1: f32) -> __float2;
        }
        __sincospif_stret(arg_arg1)
    })
}
pub unsafe fn __sincospi_stret(arg_arg1: f64) -> __double2 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sincospi_stret(arg_arg1: f64) -> __double2;
        }
        __sincospi_stret(arg_arg1)
    })
}
pub unsafe fn j0(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn j0(arg_arg1: f64) -> f64;
        }
        j0(arg_arg1)
    })
}
pub unsafe fn j1(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn j1(arg_arg1: f64) -> f64;
        }
        j1(arg_arg1)
    })
}
pub unsafe fn jn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn jn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64;
        }
        jn(arg_arg1, arg_arg2)
    })
}
pub unsafe fn y0(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn y0(arg_arg1: f64) -> f64;
        }
        y0(arg_arg1)
    })
}
pub unsafe fn y1(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn y1(arg_arg1: f64) -> f64;
        }
        y1(arg_arg1)
    })
}
pub unsafe fn yn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn yn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64;
        }
        yn(arg_arg1, arg_arg2)
    })
}
pub unsafe fn scalb(arg_arg1: f64, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalb(arg_arg1: f64, arg_arg2: f64) -> f64;
        }
        scalb(arg_arg1, arg_arg2)
    })
}
extern "C" {
    pub static mut signgam: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct exception {
    pub type_: ::std::os::raw::c_int,
    pub name: *mut ::std::os::raw::c_char,
    pub arg1: f64,
    pub arg2: f64,
    pub retval: f64,
}
impl Default for exception {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn explicit_bzero(arg_buf: *mut ::std::os::raw::c_void, arg_len: usize) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn explicit_bzero(arg_buf: *mut ::std::os::raw::c_void, arg_len: usize);
        }
        explicit_bzero(arg_buf, arg_len)
    })
}
pub unsafe fn pqGetpwuid(
    arg_uid: uid_t,
    arg_resultbuf: *mut passwd,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_buflen: usize,
    arg_result: *mut *mut passwd,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pqGetpwuid(
                arg_uid: uid_t,
                arg_resultbuf: *mut passwd,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_buflen: usize,
                arg_result: *mut *mut passwd,
            ) -> ::std::os::raw::c_int;
        }
        pqGetpwuid(arg_uid, arg_resultbuf, arg_buffer, arg_buflen, arg_result)
    })
}
pub unsafe fn pqGethostbyname(
    arg_name: *const ::std::os::raw::c_char,
    arg_resultbuf: *mut hostent,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_buflen: usize,
    arg_result: *mut *mut hostent,
    arg_herrno: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pqGethostbyname(
                arg_name: *const ::std::os::raw::c_char,
                arg_resultbuf: *mut hostent,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_buflen: usize,
                arg_result: *mut *mut hostent,
                arg_herrno: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        pqGethostbyname(
            arg_name,
            arg_resultbuf,
            arg_buffer,
            arg_buflen,
            arg_result,
            arg_herrno,
        )
    })
}
pub unsafe fn pg_qsort(
    arg_base: *mut ::std::os::raw::c_void,
    arg_nel: usize,
    arg_elsize: usize,
    arg_cmp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_qsort(
                arg_base: *mut ::std::os::raw::c_void,
                arg_nel: usize,
                arg_elsize: usize,
                arg_cmp: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *const ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            );
        }
        pg_qsort(arg_base, arg_nel, arg_elsize, arg_cmp)
    })
}
pub unsafe fn pg_qsort_strcmp(
    arg_a: *const ::std::os::raw::c_void,
    arg_b: *const ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_qsort_strcmp(
                arg_a: *const ::std::os::raw::c_void,
                arg_b: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        pg_qsort_strcmp(arg_a, arg_b)
    })
}
pub type qsort_arg_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub unsafe fn qsort_arg(
    arg_base: *mut ::std::os::raw::c_void,
    arg_nel: usize,
    arg_elsize: usize,
    arg_cmp: qsort_arg_comparator,
    arg_arg: *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qsort_arg(
                arg_base: *mut ::std::os::raw::c_void,
                arg_nel: usize,
                arg_elsize: usize,
                arg_cmp: qsort_arg_comparator,
                arg_arg: *mut ::std::os::raw::c_void,
            );
        }
        qsort_arg(arg_base, arg_nel, arg_elsize, arg_cmp, arg_arg)
    })
}
pub unsafe fn bsearch_arg(
    arg_key: *const ::std::os::raw::c_void,
    arg_base: *const ::std::os::raw::c_void,
    arg_nmemb: usize,
    arg_size: usize,
    arg_compar: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
            arg3: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    arg_arg: *mut ::std::os::raw::c_void,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bsearch_arg(
                arg_key: *const ::std::os::raw::c_void,
                arg_base: *const ::std::os::raw::c_void,
                arg_nmemb: usize,
                arg_size: usize,
                arg_compar: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *const ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                        arg3: *mut ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
                arg_arg: *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void;
        }
        bsearch_arg(arg_key, arg_base, arg_nmemb, arg_size, arg_compar, arg_arg)
    })
}
pub unsafe fn pg_get_encoding_from_locale(
    arg_ctype: *const ::std::os::raw::c_char,
    arg_write_message: bool,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_get_encoding_from_locale(
                arg_ctype: *const ::std::os::raw::c_char,
                arg_write_message: bool,
            ) -> ::std::os::raw::c_int;
        }
        pg_get_encoding_from_locale(arg_ctype, arg_write_message)
    })
}
pub unsafe fn pg_inet_net_ntop(
    arg_af: ::std::os::raw::c_int,
    arg_src: *const ::std::os::raw::c_void,
    arg_bits: ::std::os::raw::c_int,
    arg_dst: *mut ::std::os::raw::c_char,
    arg_size: usize,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_inet_net_ntop(
                arg_af: ::std::os::raw::c_int,
                arg_src: *const ::std::os::raw::c_void,
                arg_bits: ::std::os::raw::c_int,
                arg_dst: *mut ::std::os::raw::c_char,
                arg_size: usize,
            ) -> *mut ::std::os::raw::c_char;
        }
        pg_inet_net_ntop(arg_af, arg_src, arg_bits, arg_dst, arg_size)
    })
}
pub unsafe fn pg_strong_random_init() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strong_random_init();
        }
        pg_strong_random_init()
    })
}
pub unsafe fn pg_strong_random(arg_buf: *mut ::std::os::raw::c_void, arg_len: usize) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strong_random(arg_buf: *mut ::std::os::raw::c_void, arg_len: usize) -> bool;
        }
        pg_strong_random(arg_buf, arg_len)
    })
}
pub unsafe fn pg_check_dir(arg_dir: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_check_dir(arg_dir: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        pg_check_dir(arg_dir)
    })
}
pub unsafe fn pg_mkdir_p(
    arg_path: *mut ::std::os::raw::c_char,
    arg_omode: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_mkdir_p(
                arg_path: *mut ::std::os::raw::c_char,
                arg_omode: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        pg_mkdir_p(arg_path, arg_omode)
    })
}
pub type pqsigfunc = ::std::option::Option<unsafe extern "C" fn(signo: ::std::os::raw::c_int)>;
pub unsafe fn pqsignal(arg_signo: ::std::os::raw::c_int, arg_func: pqsigfunc) -> pqsigfunc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pqsignal(arg_signo: ::std::os::raw::c_int, arg_func: pqsigfunc) -> pqsigfunc;
        }
        pqsignal(arg_signo, arg_func)
    })
}
pub unsafe fn escape_single_quotes_ascii(
    arg_src: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn escape_single_quotes_ascii(
                arg_src: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        escape_single_quotes_ascii(arg_src)
    })
}
pub unsafe fn wait_result_to_str(
    arg_exit_status: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait_result_to_str(
                arg_exit_status: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        wait_result_to_str(arg_exit_status)
    })
}
pub unsafe fn wait_result_is_signal(
    arg_exit_status: ::std::os::raw::c_int,
    arg_signum: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait_result_is_signal(
                arg_exit_status: ::std::os::raw::c_int,
                arg_signum: ::std::os::raw::c_int,
            ) -> bool;
        }
        wait_result_is_signal(arg_exit_status, arg_signum)
    })
}
pub unsafe fn wait_result_is_any_signal(
    arg_exit_status: ::std::os::raw::c_int,
    arg_include_command_not_found: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait_result_is_any_signal(
                arg_exit_status: ::std::os::raw::c_int,
                arg_include_command_not_found: bool,
            ) -> bool;
        }
        wait_result_is_any_signal(arg_exit_status, arg_include_command_not_found)
    })
}
pub type jmp_buf = [::std::os::raw::c_int; 48usize];
pub type sigjmp_buf = [::std::os::raw::c_int; 49usize];
pub unsafe fn setjmp(arg_arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setjmp(arg_arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        setjmp(arg_arg1)
    })
}
pub unsafe fn longjmp(arg_arg1: *mut ::std::os::raw::c_int, arg_arg2: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn longjmp(arg_arg1: *mut ::std::os::raw::c_int, arg_arg2: ::std::os::raw::c_int);
        }
        longjmp(arg_arg1, arg_arg2)
    })
}
pub unsafe fn _setjmp(arg_arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn _setjmp(arg_arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        _setjmp(arg_arg1)
    })
}
pub unsafe fn _longjmp(arg_arg1: *mut ::std::os::raw::c_int, arg_arg2: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn _longjmp(arg_arg1: *mut ::std::os::raw::c_int, arg_arg2: ::std::os::raw::c_int);
        }
        _longjmp(arg_arg1, arg_arg2)
    })
}
pub unsafe fn longjmperror() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn longjmperror();
        }
        longjmperror()
    })
}
pub unsafe fn message_level_is_interesting(arg_elevel: ::std::os::raw::c_int) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn message_level_is_interesting(arg_elevel: ::std::os::raw::c_int) -> bool;
        }
        message_level_is_interesting(arg_elevel)
    })
}
pub unsafe fn errstart(
    arg_elevel: ::std::os::raw::c_int,
    arg_domain: *const ::std::os::raw::c_char,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errstart(
                arg_elevel: ::std::os::raw::c_int,
                arg_domain: *const ::std::os::raw::c_char,
            ) -> bool;
        }
        errstart(arg_elevel, arg_domain)
    })
}
pub unsafe fn errstart_cold(
    arg_elevel: ::std::os::raw::c_int,
    arg_domain: *const ::std::os::raw::c_char,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errstart_cold(
                arg_elevel: ::std::os::raw::c_int,
                arg_domain: *const ::std::os::raw::c_char,
            ) -> bool;
        }
        errstart_cold(arg_elevel, arg_domain)
    })
}
pub unsafe fn errfinish(
    arg_filename: *const ::std::os::raw::c_char,
    arg_lineno: ::std::os::raw::c_int,
    arg_funcname: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errfinish(
                arg_filename: *const ::std::os::raw::c_char,
                arg_lineno: ::std::os::raw::c_int,
                arg_funcname: *const ::std::os::raw::c_char,
            );
        }
        errfinish(arg_filename, arg_lineno, arg_funcname)
    })
}
pub unsafe fn errcode(arg_sqlerrcode: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcode(arg_sqlerrcode: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        errcode(arg_sqlerrcode)
    })
}
pub unsafe fn errcode_for_file_access() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcode_for_file_access() -> ::std::os::raw::c_int;
        }
        errcode_for_file_access()
    })
}
pub unsafe fn errcode_for_socket_access() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcode_for_socket_access() -> ::std::os::raw::c_int;
        }
        errcode_for_socket_access()
    })
}
pub unsafe fn errmsg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errmsg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errmsg(arg_fmt)
    })
}
pub unsafe fn errmsg_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errmsg_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errmsg_internal(arg_fmt)
    })
}
pub unsafe fn errmsg_plural(
    arg_fmt_singular: *const ::std::os::raw::c_char,
    arg_fmt_plural: *const ::std::os::raw::c_char,
    arg_n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errmsg_plural(
                arg_fmt_singular: *const ::std::os::raw::c_char,
                arg_fmt_plural: *const ::std::os::raw::c_char,
                arg_n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        errmsg_plural(arg_fmt_singular, arg_fmt_plural, arg_n)
    })
}
pub unsafe fn errdetail(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errdetail(arg_fmt)
    })
}
pub unsafe fn errdetail_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errdetail_internal(arg_fmt)
    })
}
pub unsafe fn errdetail_log(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_log(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errdetail_log(arg_fmt)
    })
}
pub unsafe fn errdetail_log_plural(
    arg_fmt_singular: *const ::std::os::raw::c_char,
    arg_fmt_plural: *const ::std::os::raw::c_char,
    arg_n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_log_plural(
                arg_fmt_singular: *const ::std::os::raw::c_char,
                arg_fmt_plural: *const ::std::os::raw::c_char,
                arg_n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        errdetail_log_plural(arg_fmt_singular, arg_fmt_plural, arg_n)
    })
}
pub unsafe fn errdetail_plural(
    arg_fmt_singular: *const ::std::os::raw::c_char,
    arg_fmt_plural: *const ::std::os::raw::c_char,
    arg_n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_plural(
                arg_fmt_singular: *const ::std::os::raw::c_char,
                arg_fmt_plural: *const ::std::os::raw::c_char,
                arg_n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        errdetail_plural(arg_fmt_singular, arg_fmt_plural, arg_n)
    })
}
pub unsafe fn errhint(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errhint(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errhint(arg_fmt)
    })
}
pub unsafe fn errhint_plural(
    arg_fmt_singular: *const ::std::os::raw::c_char,
    arg_fmt_plural: *const ::std::os::raw::c_char,
    arg_n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errhint_plural(
                arg_fmt_singular: *const ::std::os::raw::c_char,
                arg_fmt_plural: *const ::std::os::raw::c_char,
                arg_n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        errhint_plural(arg_fmt_singular, arg_fmt_plural, arg_n)
    })
}
pub unsafe fn set_errcontext_domain(
    arg_domain: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_errcontext_domain(
                arg_domain: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        set_errcontext_domain(arg_domain)
    })
}
pub unsafe fn errcontext_msg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcontext_msg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errcontext_msg(arg_fmt)
    })
}
pub unsafe fn errhidestmt(arg_hide_stmt: bool) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errhidestmt(arg_hide_stmt: bool) -> ::std::os::raw::c_int;
        }
        errhidestmt(arg_hide_stmt)
    })
}
pub unsafe fn errhidecontext(arg_hide_ctx: bool) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errhidecontext(arg_hide_ctx: bool) -> ::std::os::raw::c_int;
        }
        errhidecontext(arg_hide_ctx)
    })
}
pub unsafe fn errbacktrace() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errbacktrace() -> ::std::os::raw::c_int;
        }
        errbacktrace()
    })
}
pub unsafe fn errposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        errposition(arg_cursorpos)
    })
}
pub unsafe fn internalerrposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn internalerrposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        internalerrposition(arg_cursorpos)
    })
}
pub unsafe fn internalerrquery(arg_query: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn internalerrquery(arg_query: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        internalerrquery(arg_query)
    })
}
pub unsafe fn err_generic_string(
    arg_field: ::std::os::raw::c_int,
    arg_str_: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn err_generic_string(
                arg_field: ::std::os::raw::c_int,
                arg_str_: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        err_generic_string(arg_field, arg_str_)
    })
}
pub unsafe fn geterrcode() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn geterrcode() -> ::std::os::raw::c_int;
        }
        geterrcode()
    })
}
pub unsafe fn geterrposition() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn geterrposition() -> ::std::os::raw::c_int;
        }
        geterrposition()
    })
}
pub unsafe fn getinternalerrposition() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getinternalerrposition() -> ::std::os::raw::c_int;
        }
        getinternalerrposition()
    })
}
pub unsafe fn pre_format_elog_string(
    arg_errnumber: ::std::os::raw::c_int,
    arg_domain: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pre_format_elog_string(
                arg_errnumber: ::std::os::raw::c_int,
                arg_domain: *const ::std::os::raw::c_char,
            );
        }
        pre_format_elog_string(arg_errnumber, arg_domain)
    })
}
pub unsafe fn format_elog_string(
    arg_fmt: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn format_elog_string(
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        format_elog_string(arg_fmt)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorContextCallback {
    pub previous: *mut ErrorContextCallback,
    pub callback: ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>,
    pub arg: *mut ::std::os::raw::c_void,
}
impl Default for ErrorContextCallback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut error_context_stack: *mut ErrorContextCallback;
}
extern "C" {
    pub static mut PG_exception_stack: *mut sigjmp_buf;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorData {
    pub elevel: ::std::os::raw::c_int,
    pub output_to_server: bool,
    pub output_to_client: bool,
    pub hide_stmt: bool,
    pub hide_ctx: bool,
    pub filename: *const ::std::os::raw::c_char,
    pub lineno: ::std::os::raw::c_int,
    pub funcname: *const ::std::os::raw::c_char,
    pub domain: *const ::std::os::raw::c_char,
    pub context_domain: *const ::std::os::raw::c_char,
    pub sqlerrcode: ::std::os::raw::c_int,
    pub message: *mut ::std::os::raw::c_char,
    pub detail: *mut ::std::os::raw::c_char,
    pub detail_log: *mut ::std::os::raw::c_char,
    pub hint: *mut ::std::os::raw::c_char,
    pub context: *mut ::std::os::raw::c_char,
    pub backtrace: *mut ::std::os::raw::c_char,
    pub message_id: *const ::std::os::raw::c_char,
    pub schema_name: *mut ::std::os::raw::c_char,
    pub table_name: *mut ::std::os::raw::c_char,
    pub column_name: *mut ::std::os::raw::c_char,
    pub datatype_name: *mut ::std::os::raw::c_char,
    pub constraint_name: *mut ::std::os::raw::c_char,
    pub cursorpos: ::std::os::raw::c_int,
    pub internalpos: ::std::os::raw::c_int,
    pub internalquery: *mut ::std::os::raw::c_char,
    pub saved_errno: ::std::os::raw::c_int,
    pub assoc_context: *mut MemoryContextData,
}
impl Default for ErrorData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn EmitErrorReport() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EmitErrorReport();
        }
        EmitErrorReport()
    })
}
pub unsafe fn CopyErrorData() -> *mut ErrorData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CopyErrorData() -> *mut ErrorData;
        }
        CopyErrorData()
    })
}
pub unsafe fn FreeErrorData(arg_edata: *mut ErrorData) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeErrorData(arg_edata: *mut ErrorData);
        }
        FreeErrorData(arg_edata)
    })
}
pub unsafe fn FlushErrorState() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FlushErrorState();
        }
        FlushErrorState()
    })
}
pub unsafe fn ReThrowError(arg_edata: *mut ErrorData) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReThrowError(arg_edata: *mut ErrorData);
        }
        ReThrowError(arg_edata)
    })
}
pub unsafe fn ThrowErrorData(arg_edata: *mut ErrorData) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ThrowErrorData(arg_edata: *mut ErrorData);
        }
        ThrowErrorData(arg_edata)
    })
}
pub unsafe fn GetErrorContextStack() -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetErrorContextStack() -> *mut ::std::os::raw::c_char;
        }
        GetErrorContextStack()
    })
}
pub type emit_log_hook_type = ::std::option::Option<unsafe extern "C" fn(edata: *mut ErrorData)>;
extern "C" {
    pub static mut emit_log_hook: emit_log_hook_type;
}
pub const PGErrorVerbosity_PGERROR_TERSE: PGErrorVerbosity = 0;
pub const PGErrorVerbosity_PGERROR_DEFAULT: PGErrorVerbosity = 1;
pub const PGErrorVerbosity_PGERROR_VERBOSE: PGErrorVerbosity = 2;
pub type PGErrorVerbosity = ::std::os::raw::c_uint;
extern "C" {
    pub static mut Log_error_verbosity: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut Log_line_prefix: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut Log_destination: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut Log_destination_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut syslog_sequence_numbers: bool;
}
extern "C" {
    pub static mut syslog_split_messages: bool;
}
pub unsafe fn DebugFileOpen() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DebugFileOpen();
        }
        DebugFileOpen()
    })
}
pub unsafe fn unpack_sql_state(
    arg_sql_state: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn unpack_sql_state(
                arg_sql_state: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        unpack_sql_state(arg_sql_state)
    })
}
pub unsafe fn in_error_recursion_trouble() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn in_error_recursion_trouble() -> bool;
        }
        in_error_recursion_trouble()
    })
}
pub unsafe fn set_syslog_parameters(
    arg_ident: *const ::std::os::raw::c_char,
    arg_facility: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_syslog_parameters(
                arg_ident: *const ::std::os::raw::c_char,
                arg_facility: ::std::os::raw::c_int,
            );
        }
        set_syslog_parameters(arg_ident, arg_facility)
    })
}
pub unsafe fn write_stderr(arg_fmt: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn write_stderr(arg_fmt: *const ::std::os::raw::c_char);
        }
        write_stderr(arg_fmt)
    })
}
pub type MemoryContext = *mut MemoryContextData;
pub type MemoryContextCallbackFunction =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryContextCallback {
    pub func: MemoryContextCallbackFunction,
    pub arg: *mut ::std::os::raw::c_void,
    pub next: *mut MemoryContextCallback,
}
impl Default for MemoryContextCallback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut CurrentMemoryContext: MemoryContext;
}
pub unsafe fn MemoryContextAlloc(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAlloc(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAlloc(arg_context, arg_size)
    })
}
pub unsafe fn MemoryContextAllocZero(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocZero(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocZero(arg_context, arg_size)
    })
}
pub unsafe fn MemoryContextAllocZeroAligned(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocZeroAligned(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocZeroAligned(arg_context, arg_size)
    })
}
pub unsafe fn MemoryContextAllocExtended(
    arg_context: MemoryContext,
    arg_size: Size,
    arg_flags: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocExtended(
                arg_context: MemoryContext,
                arg_size: Size,
                arg_flags: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocExtended(arg_context, arg_size, arg_flags)
    })
}
pub unsafe fn palloc(arg_size: Size) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn palloc(arg_size: Size) -> *mut ::std::os::raw::c_void;
        }
        palloc(arg_size)
    })
}
pub unsafe fn palloc0(arg_size: Size) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn palloc0(arg_size: Size) -> *mut ::std::os::raw::c_void;
        }
        palloc0(arg_size)
    })
}
pub unsafe fn palloc_extended(
    arg_size: Size,
    arg_flags: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn palloc_extended(
                arg_size: Size,
                arg_flags: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_void;
        }
        palloc_extended(arg_size, arg_flags)
    })
}
pub unsafe fn repalloc(
    arg_pointer: *mut ::std::os::raw::c_void,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn repalloc(
                arg_pointer: *mut ::std::os::raw::c_void,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        repalloc(arg_pointer, arg_size)
    })
}
pub unsafe fn pfree(arg_pointer: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pfree(arg_pointer: *mut ::std::os::raw::c_void);
        }
        pfree(arg_pointer)
    })
}
pub unsafe fn MemoryContextAllocHuge(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocHuge(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocHuge(arg_context, arg_size)
    })
}
pub unsafe fn repalloc_huge(
    arg_pointer: *mut ::std::os::raw::c_void,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn repalloc_huge(
                arg_pointer: *mut ::std::os::raw::c_void,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        repalloc_huge(arg_pointer, arg_size)
    })
}
pub unsafe fn MemoryContextRegisterResetCallback(
    arg_context: MemoryContext,
    arg_cb: *mut MemoryContextCallback,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextRegisterResetCallback(
                arg_context: MemoryContext,
                arg_cb: *mut MemoryContextCallback,
            );
        }
        MemoryContextRegisterResetCallback(arg_context, arg_cb)
    })
}
pub unsafe fn MemoryContextStrdup(
    arg_context: MemoryContext,
    arg_string: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextStrdup(
                arg_context: MemoryContext,
                arg_string: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        MemoryContextStrdup(arg_context, arg_string)
    })
}
pub unsafe fn pstrdup(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pstrdup(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        pstrdup(arg_in_)
    })
}
pub unsafe fn pnstrdup(
    arg_in_: *const ::std::os::raw::c_char,
    arg_len: Size,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pnstrdup(
                arg_in_: *const ::std::os::raw::c_char,
                arg_len: Size,
            ) -> *mut ::std::os::raw::c_char;
        }
        pnstrdup(arg_in_, arg_len)
    })
}
pub unsafe fn pchomp(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pchomp(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        pchomp(arg_in_)
    })
}
pub unsafe fn psprintf(arg_fmt: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn psprintf(arg_fmt: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        psprintf(arg_fmt)
    })
}
pub unsafe fn pvsnprintf(
    arg_buf: *mut ::std::os::raw::c_char,
    arg_len: usize,
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: va_list,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pvsnprintf(
                arg_buf: *mut ::std::os::raw::c_char,
                arg_len: usize,
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: va_list,
            ) -> usize;
        }
        pvsnprintf(arg_buf, arg_len, arg_fmt, arg_args)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct varatt_external {
    pub va_rawsize: int32,
    pub va_extinfo: uint32,
    pub va_valueid: Oid,
    pub va_toastrelid: Oid,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_indirect {
    pub pointer: *mut varlena,
}
impl Default for varatt_indirect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_expanded {
    pub eohptr: *mut ExpandedObjectHeader,
}
impl Default for varatt_expanded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const vartag_external_VARTAG_INDIRECT: vartag_external = 1;
pub const vartag_external_VARTAG_EXPANDED_RO: vartag_external = 2;
pub const vartag_external_VARTAG_EXPANDED_RW: vartag_external = 3;
pub const vartag_external_VARTAG_ONDISK: vartag_external = 18;
pub type vartag_external = ::std::os::raw::c_uint;
#[repr(C)]
pub struct varattrib_4b {
    pub va_4byte: __BindgenUnionField<varattrib_4b__bindgen_ty_1>,
    pub va_compressed: __BindgenUnionField<varattrib_4b__bindgen_ty_2>,
    pub bindgen_union_field: [u32; 2usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_1 {
    pub va_header: uint32,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_2 {
    pub va_header: uint32,
    pub va_tcinfo: uint32,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for varattrib_4b {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b {
    pub va_header: uint8,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b_e {
    pub va_header: uint8,
    pub va_tag: uint8,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
pub type Datum = usize;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct NullableDatum {
    pub value: Datum,
    pub isnull: bool,
}
pub type AttrNumber = int16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_attribute {
    pub attrelid: Oid,
    pub attname: NameData,
    pub atttypid: Oid,
    pub attstattarget: int32,
    pub attlen: int16,
    pub attnum: int16,
    pub attndims: int32,
    pub attcacheoff: int32,
    pub atttypmod: int32,
    pub attbyval: bool,
    pub attalign: ::std::os::raw::c_char,
    pub attstorage: ::std::os::raw::c_char,
    pub attcompression: ::std::os::raw::c_char,
    pub attnotnull: bool,
    pub atthasdef: bool,
    pub atthasmissing: bool,
    pub attidentity: ::std::os::raw::c_char,
    pub attgenerated: ::std::os::raw::c_char,
    pub attisdropped: bool,
    pub attislocal: bool,
    pub attinhcount: int32,
    pub attcollation: Oid,
}
impl Default for FormData_pg_attribute {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_attribute = *mut FormData_pg_attribute;
extern "C" {
    pub static mut no_such_variable: ::std::os::raw::c_int;
}
pub const NodeTag_T_Invalid: NodeTag = 0;
pub const NodeTag_T_IndexInfo: NodeTag = 1;
pub const NodeTag_T_ExprContext: NodeTag = 2;
pub const NodeTag_T_ProjectionInfo: NodeTag = 3;
pub const NodeTag_T_JunkFilter: NodeTag = 4;
pub const NodeTag_T_OnConflictSetState: NodeTag = 5;
pub const NodeTag_T_ResultRelInfo: NodeTag = 6;
pub const NodeTag_T_EState: NodeTag = 7;
pub const NodeTag_T_TupleTableSlot: NodeTag = 8;
pub const NodeTag_T_Plan: NodeTag = 9;
pub const NodeTag_T_Result: NodeTag = 10;
pub const NodeTag_T_ProjectSet: NodeTag = 11;
pub const NodeTag_T_ModifyTable: NodeTag = 12;
pub const NodeTag_T_Append: NodeTag = 13;
pub const NodeTag_T_MergeAppend: NodeTag = 14;
pub const NodeTag_T_RecursiveUnion: NodeTag = 15;
pub const NodeTag_T_BitmapAnd: NodeTag = 16;
pub const NodeTag_T_BitmapOr: NodeTag = 17;
pub const NodeTag_T_Scan: NodeTag = 18;
pub const NodeTag_T_SeqScan: NodeTag = 19;
pub const NodeTag_T_SampleScan: NodeTag = 20;
pub const NodeTag_T_IndexScan: NodeTag = 21;
pub const NodeTag_T_IndexOnlyScan: NodeTag = 22;
pub const NodeTag_T_BitmapIndexScan: NodeTag = 23;
pub const NodeTag_T_BitmapHeapScan: NodeTag = 24;
pub const NodeTag_T_TidScan: NodeTag = 25;
pub const NodeTag_T_TidRangeScan: NodeTag = 26;
pub const NodeTag_T_SubqueryScan: NodeTag = 27;
pub const NodeTag_T_FunctionScan: NodeTag = 28;
pub const NodeTag_T_ValuesScan: NodeTag = 29;
pub const NodeTag_T_TableFuncScan: NodeTag = 30;
pub const NodeTag_T_CteScan: NodeTag = 31;
pub const NodeTag_T_NamedTuplestoreScan: NodeTag = 32;
pub const NodeTag_T_WorkTableScan: NodeTag = 33;
pub const NodeTag_T_ForeignScan: NodeTag = 34;
pub const NodeTag_T_CustomScan: NodeTag = 35;
pub const NodeTag_T_Join: NodeTag = 36;
pub const NodeTag_T_NestLoop: NodeTag = 37;
pub const NodeTag_T_MergeJoin: NodeTag = 38;
pub const NodeTag_T_HashJoin: NodeTag = 39;
pub const NodeTag_T_Material: NodeTag = 40;
pub const NodeTag_T_Memoize: NodeTag = 41;
pub const NodeTag_T_Sort: NodeTag = 42;
pub const NodeTag_T_IncrementalSort: NodeTag = 43;
pub const NodeTag_T_Group: NodeTag = 44;
pub const NodeTag_T_Agg: NodeTag = 45;
pub const NodeTag_T_WindowAgg: NodeTag = 46;
pub const NodeTag_T_Unique: NodeTag = 47;
pub const NodeTag_T_Gather: NodeTag = 48;
pub const NodeTag_T_GatherMerge: NodeTag = 49;
pub const NodeTag_T_Hash: NodeTag = 50;
pub const NodeTag_T_SetOp: NodeTag = 51;
pub const NodeTag_T_LockRows: NodeTag = 52;
pub const NodeTag_T_Limit: NodeTag = 53;
pub const NodeTag_T_NestLoopParam: NodeTag = 54;
pub const NodeTag_T_PlanRowMark: NodeTag = 55;
pub const NodeTag_T_PartitionPruneInfo: NodeTag = 56;
pub const NodeTag_T_PartitionedRelPruneInfo: NodeTag = 57;
pub const NodeTag_T_PartitionPruneStepOp: NodeTag = 58;
pub const NodeTag_T_PartitionPruneStepCombine: NodeTag = 59;
pub const NodeTag_T_PlanInvalItem: NodeTag = 60;
pub const NodeTag_T_PlanState: NodeTag = 61;
pub const NodeTag_T_ResultState: NodeTag = 62;
pub const NodeTag_T_ProjectSetState: NodeTag = 63;
pub const NodeTag_T_ModifyTableState: NodeTag = 64;
pub const NodeTag_T_AppendState: NodeTag = 65;
pub const NodeTag_T_MergeAppendState: NodeTag = 66;
pub const NodeTag_T_RecursiveUnionState: NodeTag = 67;
pub const NodeTag_T_BitmapAndState: NodeTag = 68;
pub const NodeTag_T_BitmapOrState: NodeTag = 69;
pub const NodeTag_T_ScanState: NodeTag = 70;
pub const NodeTag_T_SeqScanState: NodeTag = 71;
pub const NodeTag_T_SampleScanState: NodeTag = 72;
pub const NodeTag_T_IndexScanState: NodeTag = 73;
pub const NodeTag_T_IndexOnlyScanState: NodeTag = 74;
pub const NodeTag_T_BitmapIndexScanState: NodeTag = 75;
pub const NodeTag_T_BitmapHeapScanState: NodeTag = 76;
pub const NodeTag_T_TidScanState: NodeTag = 77;
pub const NodeTag_T_TidRangeScanState: NodeTag = 78;
pub const NodeTag_T_SubqueryScanState: NodeTag = 79;
pub const NodeTag_T_FunctionScanState: NodeTag = 80;
pub const NodeTag_T_TableFuncScanState: NodeTag = 81;
pub const NodeTag_T_ValuesScanState: NodeTag = 82;
pub const NodeTag_T_CteScanState: NodeTag = 83;
pub const NodeTag_T_NamedTuplestoreScanState: NodeTag = 84;
pub const NodeTag_T_WorkTableScanState: NodeTag = 85;
pub const NodeTag_T_ForeignScanState: NodeTag = 86;
pub const NodeTag_T_CustomScanState: NodeTag = 87;
pub const NodeTag_T_JoinState: NodeTag = 88;
pub const NodeTag_T_NestLoopState: NodeTag = 89;
pub const NodeTag_T_MergeJoinState: NodeTag = 90;
pub const NodeTag_T_HashJoinState: NodeTag = 91;
pub const NodeTag_T_MaterialState: NodeTag = 92;
pub const NodeTag_T_MemoizeState: NodeTag = 93;
pub const NodeTag_T_SortState: NodeTag = 94;
pub const NodeTag_T_IncrementalSortState: NodeTag = 95;
pub const NodeTag_T_GroupState: NodeTag = 96;
pub const NodeTag_T_AggState: NodeTag = 97;
pub const NodeTag_T_WindowAggState: NodeTag = 98;
pub const NodeTag_T_UniqueState: NodeTag = 99;
pub const NodeTag_T_GatherState: NodeTag = 100;
pub const NodeTag_T_GatherMergeState: NodeTag = 101;
pub const NodeTag_T_HashState: NodeTag = 102;
pub const NodeTag_T_SetOpState: NodeTag = 103;
pub const NodeTag_T_LockRowsState: NodeTag = 104;
pub const NodeTag_T_LimitState: NodeTag = 105;
pub const NodeTag_T_Alias: NodeTag = 106;
pub const NodeTag_T_RangeVar: NodeTag = 107;
pub const NodeTag_T_TableFunc: NodeTag = 108;
pub const NodeTag_T_Expr: NodeTag = 109;
pub const NodeTag_T_Var: NodeTag = 110;
pub const NodeTag_T_Const: NodeTag = 111;
pub const NodeTag_T_Param: NodeTag = 112;
pub const NodeTag_T_Aggref: NodeTag = 113;
pub const NodeTag_T_GroupingFunc: NodeTag = 114;
pub const NodeTag_T_WindowFunc: NodeTag = 115;
pub const NodeTag_T_SubscriptingRef: NodeTag = 116;
pub const NodeTag_T_FuncExpr: NodeTag = 117;
pub const NodeTag_T_NamedArgExpr: NodeTag = 118;
pub const NodeTag_T_OpExpr: NodeTag = 119;
pub const NodeTag_T_DistinctExpr: NodeTag = 120;
pub const NodeTag_T_NullIfExpr: NodeTag = 121;
pub const NodeTag_T_ScalarArrayOpExpr: NodeTag = 122;
pub const NodeTag_T_BoolExpr: NodeTag = 123;
pub const NodeTag_T_SubLink: NodeTag = 124;
pub const NodeTag_T_SubPlan: NodeTag = 125;
pub const NodeTag_T_AlternativeSubPlan: NodeTag = 126;
pub const NodeTag_T_FieldSelect: NodeTag = 127;
pub const NodeTag_T_FieldStore: NodeTag = 128;
pub const NodeTag_T_RelabelType: NodeTag = 129;
pub const NodeTag_T_CoerceViaIO: NodeTag = 130;
pub const NodeTag_T_ArrayCoerceExpr: NodeTag = 131;
pub const NodeTag_T_ConvertRowtypeExpr: NodeTag = 132;
pub const NodeTag_T_CollateExpr: NodeTag = 133;
pub const NodeTag_T_CaseExpr: NodeTag = 134;
pub const NodeTag_T_CaseWhen: NodeTag = 135;
pub const NodeTag_T_CaseTestExpr: NodeTag = 136;
pub const NodeTag_T_ArrayExpr: NodeTag = 137;
pub const NodeTag_T_RowExpr: NodeTag = 138;
pub const NodeTag_T_RowCompareExpr: NodeTag = 139;
pub const NodeTag_T_CoalesceExpr: NodeTag = 140;
pub const NodeTag_T_MinMaxExpr: NodeTag = 141;
pub const NodeTag_T_SQLValueFunction: NodeTag = 142;
pub const NodeTag_T_XmlExpr: NodeTag = 143;
pub const NodeTag_T_NullTest: NodeTag = 144;
pub const NodeTag_T_BooleanTest: NodeTag = 145;
pub const NodeTag_T_CoerceToDomain: NodeTag = 146;
pub const NodeTag_T_CoerceToDomainValue: NodeTag = 147;
pub const NodeTag_T_SetToDefault: NodeTag = 148;
pub const NodeTag_T_CurrentOfExpr: NodeTag = 149;
pub const NodeTag_T_NextValueExpr: NodeTag = 150;
pub const NodeTag_T_InferenceElem: NodeTag = 151;
pub const NodeTag_T_TargetEntry: NodeTag = 152;
pub const NodeTag_T_RangeTblRef: NodeTag = 153;
pub const NodeTag_T_JoinExpr: NodeTag = 154;
pub const NodeTag_T_FromExpr: NodeTag = 155;
pub const NodeTag_T_OnConflictExpr: NodeTag = 156;
pub const NodeTag_T_IntoClause: NodeTag = 157;
pub const NodeTag_T_ExprState: NodeTag = 158;
pub const NodeTag_T_WindowFuncExprState: NodeTag = 159;
pub const NodeTag_T_SetExprState: NodeTag = 160;
pub const NodeTag_T_SubPlanState: NodeTag = 161;
pub const NodeTag_T_DomainConstraintState: NodeTag = 162;
pub const NodeTag_T_PlannerInfo: NodeTag = 163;
pub const NodeTag_T_PlannerGlobal: NodeTag = 164;
pub const NodeTag_T_RelOptInfo: NodeTag = 165;
pub const NodeTag_T_IndexOptInfo: NodeTag = 166;
pub const NodeTag_T_ForeignKeyOptInfo: NodeTag = 167;
pub const NodeTag_T_ParamPathInfo: NodeTag = 168;
pub const NodeTag_T_Path: NodeTag = 169;
pub const NodeTag_T_IndexPath: NodeTag = 170;
pub const NodeTag_T_BitmapHeapPath: NodeTag = 171;
pub const NodeTag_T_BitmapAndPath: NodeTag = 172;
pub const NodeTag_T_BitmapOrPath: NodeTag = 173;
pub const NodeTag_T_TidPath: NodeTag = 174;
pub const NodeTag_T_TidRangePath: NodeTag = 175;
pub const NodeTag_T_SubqueryScanPath: NodeTag = 176;
pub const NodeTag_T_ForeignPath: NodeTag = 177;
pub const NodeTag_T_CustomPath: NodeTag = 178;
pub const NodeTag_T_NestPath: NodeTag = 179;
pub const NodeTag_T_MergePath: NodeTag = 180;
pub const NodeTag_T_HashPath: NodeTag = 181;
pub const NodeTag_T_AppendPath: NodeTag = 182;
pub const NodeTag_T_MergeAppendPath: NodeTag = 183;
pub const NodeTag_T_GroupResultPath: NodeTag = 184;
pub const NodeTag_T_MaterialPath: NodeTag = 185;
pub const NodeTag_T_MemoizePath: NodeTag = 186;
pub const NodeTag_T_UniquePath: NodeTag = 187;
pub const NodeTag_T_GatherPath: NodeTag = 188;
pub const NodeTag_T_GatherMergePath: NodeTag = 189;
pub const NodeTag_T_ProjectionPath: NodeTag = 190;
pub const NodeTag_T_ProjectSetPath: NodeTag = 191;
pub const NodeTag_T_SortPath: NodeTag = 192;
pub const NodeTag_T_IncrementalSortPath: NodeTag = 193;
pub const NodeTag_T_GroupPath: NodeTag = 194;
pub const NodeTag_T_UpperUniquePath: NodeTag = 195;
pub const NodeTag_T_AggPath: NodeTag = 196;
pub const NodeTag_T_GroupingSetsPath: NodeTag = 197;
pub const NodeTag_T_MinMaxAggPath: NodeTag = 198;
pub const NodeTag_T_WindowAggPath: NodeTag = 199;
pub const NodeTag_T_SetOpPath: NodeTag = 200;
pub const NodeTag_T_RecursiveUnionPath: NodeTag = 201;
pub const NodeTag_T_LockRowsPath: NodeTag = 202;
pub const NodeTag_T_ModifyTablePath: NodeTag = 203;
pub const NodeTag_T_LimitPath: NodeTag = 204;
pub const NodeTag_T_EquivalenceClass: NodeTag = 205;
pub const NodeTag_T_EquivalenceMember: NodeTag = 206;
pub const NodeTag_T_PathKey: NodeTag = 207;
pub const NodeTag_T_PathTarget: NodeTag = 208;
pub const NodeTag_T_RestrictInfo: NodeTag = 209;
pub const NodeTag_T_IndexClause: NodeTag = 210;
pub const NodeTag_T_PlaceHolderVar: NodeTag = 211;
pub const NodeTag_T_SpecialJoinInfo: NodeTag = 212;
pub const NodeTag_T_AppendRelInfo: NodeTag = 213;
pub const NodeTag_T_RowIdentityVarInfo: NodeTag = 214;
pub const NodeTag_T_PlaceHolderInfo: NodeTag = 215;
pub const NodeTag_T_MinMaxAggInfo: NodeTag = 216;
pub const NodeTag_T_PlannerParamItem: NodeTag = 217;
pub const NodeTag_T_RollupData: NodeTag = 218;
pub const NodeTag_T_GroupingSetData: NodeTag = 219;
pub const NodeTag_T_StatisticExtInfo: NodeTag = 220;
pub const NodeTag_T_MemoryContext: NodeTag = 221;
pub const NodeTag_T_AllocSetContext: NodeTag = 222;
pub const NodeTag_T_SlabContext: NodeTag = 223;
pub const NodeTag_T_GenerationContext: NodeTag = 224;
pub const NodeTag_T_Value: NodeTag = 225;
pub const NodeTag_T_Integer: NodeTag = 226;
pub const NodeTag_T_Float: NodeTag = 227;
pub const NodeTag_T_String: NodeTag = 228;
pub const NodeTag_T_BitString: NodeTag = 229;
pub const NodeTag_T_Null: NodeTag = 230;
pub const NodeTag_T_List: NodeTag = 231;
pub const NodeTag_T_IntList: NodeTag = 232;
pub const NodeTag_T_OidList: NodeTag = 233;
pub const NodeTag_T_ExtensibleNode: NodeTag = 234;
pub const NodeTag_T_RawStmt: NodeTag = 235;
pub const NodeTag_T_Query: NodeTag = 236;
pub const NodeTag_T_PlannedStmt: NodeTag = 237;
pub const NodeTag_T_InsertStmt: NodeTag = 238;
pub const NodeTag_T_DeleteStmt: NodeTag = 239;
pub const NodeTag_T_UpdateStmt: NodeTag = 240;
pub const NodeTag_T_SelectStmt: NodeTag = 241;
pub const NodeTag_T_ReturnStmt: NodeTag = 242;
pub const NodeTag_T_PLAssignStmt: NodeTag = 243;
pub const NodeTag_T_AlterTableStmt: NodeTag = 244;
pub const NodeTag_T_AlterTableCmd: NodeTag = 245;
pub const NodeTag_T_AlterDomainStmt: NodeTag = 246;
pub const NodeTag_T_SetOperationStmt: NodeTag = 247;
pub const NodeTag_T_GrantStmt: NodeTag = 248;
pub const NodeTag_T_GrantRoleStmt: NodeTag = 249;
pub const NodeTag_T_AlterDefaultPrivilegesStmt: NodeTag = 250;
pub const NodeTag_T_ClosePortalStmt: NodeTag = 251;
pub const NodeTag_T_ClusterStmt: NodeTag = 252;
pub const NodeTag_T_CopyStmt: NodeTag = 253;
pub const NodeTag_T_CreateStmt: NodeTag = 254;
pub const NodeTag_T_DefineStmt: NodeTag = 255;
pub const NodeTag_T_DropStmt: NodeTag = 256;
pub const NodeTag_T_TruncateStmt: NodeTag = 257;
pub const NodeTag_T_CommentStmt: NodeTag = 258;
pub const NodeTag_T_FetchStmt: NodeTag = 259;
pub const NodeTag_T_IndexStmt: NodeTag = 260;
pub const NodeTag_T_CreateFunctionStmt: NodeTag = 261;
pub const NodeTag_T_AlterFunctionStmt: NodeTag = 262;
pub const NodeTag_T_DoStmt: NodeTag = 263;
pub const NodeTag_T_RenameStmt: NodeTag = 264;
pub const NodeTag_T_RuleStmt: NodeTag = 265;
pub const NodeTag_T_NotifyStmt: NodeTag = 266;
pub const NodeTag_T_ListenStmt: NodeTag = 267;
pub const NodeTag_T_UnlistenStmt: NodeTag = 268;
pub const NodeTag_T_TransactionStmt: NodeTag = 269;
pub const NodeTag_T_ViewStmt: NodeTag = 270;
pub const NodeTag_T_LoadStmt: NodeTag = 271;
pub const NodeTag_T_CreateDomainStmt: NodeTag = 272;
pub const NodeTag_T_CreatedbStmt: NodeTag = 273;
pub const NodeTag_T_DropdbStmt: NodeTag = 274;
pub const NodeTag_T_VacuumStmt: NodeTag = 275;
pub const NodeTag_T_ExplainStmt: NodeTag = 276;
pub const NodeTag_T_CreateTableAsStmt: NodeTag = 277;
pub const NodeTag_T_CreateSeqStmt: NodeTag = 278;
pub const NodeTag_T_AlterSeqStmt: NodeTag = 279;
pub const NodeTag_T_VariableSetStmt: NodeTag = 280;
pub const NodeTag_T_VariableShowStmt: NodeTag = 281;
pub const NodeTag_T_DiscardStmt: NodeTag = 282;
pub const NodeTag_T_CreateTrigStmt: NodeTag = 283;
pub const NodeTag_T_CreatePLangStmt: NodeTag = 284;
pub const NodeTag_T_CreateRoleStmt: NodeTag = 285;
pub const NodeTag_T_AlterRoleStmt: NodeTag = 286;
pub const NodeTag_T_DropRoleStmt: NodeTag = 287;
pub const NodeTag_T_LockStmt: NodeTag = 288;
pub const NodeTag_T_ConstraintsSetStmt: NodeTag = 289;
pub const NodeTag_T_ReindexStmt: NodeTag = 290;
pub const NodeTag_T_CheckPointStmt: NodeTag = 291;
pub const NodeTag_T_CreateSchemaStmt: NodeTag = 292;
pub const NodeTag_T_AlterDatabaseStmt: NodeTag = 293;
pub const NodeTag_T_AlterDatabaseSetStmt: NodeTag = 294;
pub const NodeTag_T_AlterRoleSetStmt: NodeTag = 295;
pub const NodeTag_T_CreateConversionStmt: NodeTag = 296;
pub const NodeTag_T_CreateCastStmt: NodeTag = 297;
pub const NodeTag_T_CreateOpClassStmt: NodeTag = 298;
pub const NodeTag_T_CreateOpFamilyStmt: NodeTag = 299;
pub const NodeTag_T_AlterOpFamilyStmt: NodeTag = 300;
pub const NodeTag_T_PrepareStmt: NodeTag = 301;
pub const NodeTag_T_ExecuteStmt: NodeTag = 302;
pub const NodeTag_T_DeallocateStmt: NodeTag = 303;
pub const NodeTag_T_DeclareCursorStmt: NodeTag = 304;
pub const NodeTag_T_CreateTableSpaceStmt: NodeTag = 305;
pub const NodeTag_T_DropTableSpaceStmt: NodeTag = 306;
pub const NodeTag_T_AlterObjectDependsStmt: NodeTag = 307;
pub const NodeTag_T_AlterObjectSchemaStmt: NodeTag = 308;
pub const NodeTag_T_AlterOwnerStmt: NodeTag = 309;
pub const NodeTag_T_AlterOperatorStmt: NodeTag = 310;
pub const NodeTag_T_AlterTypeStmt: NodeTag = 311;
pub const NodeTag_T_DropOwnedStmt: NodeTag = 312;
pub const NodeTag_T_ReassignOwnedStmt: NodeTag = 313;
pub const NodeTag_T_CompositeTypeStmt: NodeTag = 314;
pub const NodeTag_T_CreateEnumStmt: NodeTag = 315;
pub const NodeTag_T_CreateRangeStmt: NodeTag = 316;
pub const NodeTag_T_AlterEnumStmt: NodeTag = 317;
pub const NodeTag_T_AlterTSDictionaryStmt: NodeTag = 318;
pub const NodeTag_T_AlterTSConfigurationStmt: NodeTag = 319;
pub const NodeTag_T_CreateFdwStmt: NodeTag = 320;
pub const NodeTag_T_AlterFdwStmt: NodeTag = 321;
pub const NodeTag_T_CreateForeignServerStmt: NodeTag = 322;
pub const NodeTag_T_AlterForeignServerStmt: NodeTag = 323;
pub const NodeTag_T_CreateUserMappingStmt: NodeTag = 324;
pub const NodeTag_T_AlterUserMappingStmt: NodeTag = 325;
pub const NodeTag_T_DropUserMappingStmt: NodeTag = 326;
pub const NodeTag_T_AlterTableSpaceOptionsStmt: NodeTag = 327;
pub const NodeTag_T_AlterTableMoveAllStmt: NodeTag = 328;
pub const NodeTag_T_SecLabelStmt: NodeTag = 329;
pub const NodeTag_T_CreateForeignTableStmt: NodeTag = 330;
pub const NodeTag_T_ImportForeignSchemaStmt: NodeTag = 331;
pub const NodeTag_T_CreateExtensionStmt: NodeTag = 332;
pub const NodeTag_T_AlterExtensionStmt: NodeTag = 333;
pub const NodeTag_T_AlterExtensionContentsStmt: NodeTag = 334;
pub const NodeTag_T_CreateEventTrigStmt: NodeTag = 335;
pub const NodeTag_T_AlterEventTrigStmt: NodeTag = 336;
pub const NodeTag_T_RefreshMatViewStmt: NodeTag = 337;
pub const NodeTag_T_ReplicaIdentityStmt: NodeTag = 338;
pub const NodeTag_T_AlterSystemStmt: NodeTag = 339;
pub const NodeTag_T_CreatePolicyStmt: NodeTag = 340;
pub const NodeTag_T_AlterPolicyStmt: NodeTag = 341;
pub const NodeTag_T_CreateTransformStmt: NodeTag = 342;
pub const NodeTag_T_CreateAmStmt: NodeTag = 343;
pub const NodeTag_T_CreatePublicationStmt: NodeTag = 344;
pub const NodeTag_T_AlterPublicationStmt: NodeTag = 345;
pub const NodeTag_T_CreateSubscriptionStmt: NodeTag = 346;
pub const NodeTag_T_AlterSubscriptionStmt: NodeTag = 347;
pub const NodeTag_T_DropSubscriptionStmt: NodeTag = 348;
pub const NodeTag_T_CreateStatsStmt: NodeTag = 349;
pub const NodeTag_T_AlterCollationStmt: NodeTag = 350;
pub const NodeTag_T_CallStmt: NodeTag = 351;
pub const NodeTag_T_AlterStatsStmt: NodeTag = 352;
pub const NodeTag_T_A_Expr: NodeTag = 353;
pub const NodeTag_T_ColumnRef: NodeTag = 354;
pub const NodeTag_T_ParamRef: NodeTag = 355;
pub const NodeTag_T_A_Const: NodeTag = 356;
pub const NodeTag_T_FuncCall: NodeTag = 357;
pub const NodeTag_T_A_Star: NodeTag = 358;
pub const NodeTag_T_A_Indices: NodeTag = 359;
pub const NodeTag_T_A_Indirection: NodeTag = 360;
pub const NodeTag_T_A_ArrayExpr: NodeTag = 361;
pub const NodeTag_T_ResTarget: NodeTag = 362;
pub const NodeTag_T_MultiAssignRef: NodeTag = 363;
pub const NodeTag_T_TypeCast: NodeTag = 364;
pub const NodeTag_T_CollateClause: NodeTag = 365;
pub const NodeTag_T_SortBy: NodeTag = 366;
pub const NodeTag_T_WindowDef: NodeTag = 367;
pub const NodeTag_T_RangeSubselect: NodeTag = 368;
pub const NodeTag_T_RangeFunction: NodeTag = 369;
pub const NodeTag_T_RangeTableSample: NodeTag = 370;
pub const NodeTag_T_RangeTableFunc: NodeTag = 371;
pub const NodeTag_T_RangeTableFuncCol: NodeTag = 372;
pub const NodeTag_T_TypeName: NodeTag = 373;
pub const NodeTag_T_ColumnDef: NodeTag = 374;
pub const NodeTag_T_IndexElem: NodeTag = 375;
pub const NodeTag_T_StatsElem: NodeTag = 376;
pub const NodeTag_T_Constraint: NodeTag = 377;
pub const NodeTag_T_DefElem: NodeTag = 378;
pub const NodeTag_T_RangeTblEntry: NodeTag = 379;
pub const NodeTag_T_RangeTblFunction: NodeTag = 380;
pub const NodeTag_T_TableSampleClause: NodeTag = 381;
pub const NodeTag_T_WithCheckOption: NodeTag = 382;
pub const NodeTag_T_SortGroupClause: NodeTag = 383;
pub const NodeTag_T_GroupingSet: NodeTag = 384;
pub const NodeTag_T_WindowClause: NodeTag = 385;
pub const NodeTag_T_ObjectWithArgs: NodeTag = 386;
pub const NodeTag_T_AccessPriv: NodeTag = 387;
pub const NodeTag_T_CreateOpClassItem: NodeTag = 388;
pub const NodeTag_T_TableLikeClause: NodeTag = 389;
pub const NodeTag_T_FunctionParameter: NodeTag = 390;
pub const NodeTag_T_LockingClause: NodeTag = 391;
pub const NodeTag_T_RowMarkClause: NodeTag = 392;
pub const NodeTag_T_XmlSerialize: NodeTag = 393;
pub const NodeTag_T_WithClause: NodeTag = 394;
pub const NodeTag_T_InferClause: NodeTag = 395;
pub const NodeTag_T_OnConflictClause: NodeTag = 396;
pub const NodeTag_T_CTESearchClause: NodeTag = 397;
pub const NodeTag_T_CTECycleClause: NodeTag = 398;
pub const NodeTag_T_CommonTableExpr: NodeTag = 399;
pub const NodeTag_T_RoleSpec: NodeTag = 400;
pub const NodeTag_T_TriggerTransition: NodeTag = 401;
pub const NodeTag_T_PartitionElem: NodeTag = 402;
pub const NodeTag_T_PartitionSpec: NodeTag = 403;
pub const NodeTag_T_PartitionBoundSpec: NodeTag = 404;
pub const NodeTag_T_PartitionRangeDatum: NodeTag = 405;
pub const NodeTag_T_PartitionCmd: NodeTag = 406;
pub const NodeTag_T_VacuumRelation: NodeTag = 407;
pub const NodeTag_T_IdentifySystemCmd: NodeTag = 408;
pub const NodeTag_T_BaseBackupCmd: NodeTag = 409;
pub const NodeTag_T_CreateReplicationSlotCmd: NodeTag = 410;
pub const NodeTag_T_DropReplicationSlotCmd: NodeTag = 411;
pub const NodeTag_T_StartReplicationCmd: NodeTag = 412;
pub const NodeTag_T_TimeLineHistoryCmd: NodeTag = 413;
pub const NodeTag_T_SQLCmd: NodeTag = 414;
pub const NodeTag_T_TriggerData: NodeTag = 415;
pub const NodeTag_T_EventTriggerData: NodeTag = 416;
pub const NodeTag_T_ReturnSetInfo: NodeTag = 417;
pub const NodeTag_T_WindowObjectData: NodeTag = 418;
pub const NodeTag_T_TIDBitmap: NodeTag = 419;
pub const NodeTag_T_InlineCodeBlock: NodeTag = 420;
pub const NodeTag_T_FdwRoutine: NodeTag = 421;
pub const NodeTag_T_IndexAmRoutine: NodeTag = 422;
pub const NodeTag_T_TableAmRoutine: NodeTag = 423;
pub const NodeTag_T_TsmRoutine: NodeTag = 424;
pub const NodeTag_T_ForeignKeyCacheInfo: NodeTag = 425;
pub const NodeTag_T_CallContext: NodeTag = 426;
pub const NodeTag_T_SupportRequestSimplify: NodeTag = 427;
pub const NodeTag_T_SupportRequestSelectivity: NodeTag = 428;
pub const NodeTag_T_SupportRequestCost: NodeTag = 429;
pub const NodeTag_T_SupportRequestRows: NodeTag = 430;
pub const NodeTag_T_SupportRequestIndexCondition: NodeTag = 431;
pub type NodeTag = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Node {
    pub type_: NodeTag,
}
impl Default for Node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn outNode(arg_str_: *mut StringInfoData, arg_obj: *const ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outNode(arg_str_: *mut StringInfoData, arg_obj: *const ::std::os::raw::c_void);
        }
        outNode(arg_str_, arg_obj)
    })
}
pub unsafe fn outToken(arg_str_: *mut StringInfoData, arg_s: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outToken(arg_str_: *mut StringInfoData, arg_s: *const ::std::os::raw::c_char);
        }
        outToken(arg_str_, arg_s)
    })
}
pub unsafe fn outBitmapset(arg_str_: *mut StringInfoData, arg_bms: *const Bitmapset) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outBitmapset(arg_str_: *mut StringInfoData, arg_bms: *const Bitmapset);
        }
        outBitmapset(arg_str_, arg_bms)
    })
}
pub unsafe fn outDatum(
    arg_str_: *mut StringInfoData,
    arg_value: usize,
    arg_typlen: ::std::os::raw::c_int,
    arg_typbyval: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outDatum(
                arg_str_: *mut StringInfoData,
                arg_value: usize,
                arg_typlen: ::std::os::raw::c_int,
                arg_typbyval: bool,
            );
        }
        outDatum(arg_str_, arg_value, arg_typlen, arg_typbyval)
    })
}
pub unsafe fn nodeToString(arg_obj: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nodeToString(arg_obj: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_char;
        }
        nodeToString(arg_obj)
    })
}
pub unsafe fn bmsToString(arg_bms: *const Bitmapset) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bmsToString(arg_bms: *const Bitmapset) -> *mut ::std::os::raw::c_char;
        }
        bmsToString(arg_bms)
    })
}
pub unsafe fn stringToNode(arg_str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn stringToNode(arg_str_: *const ::std::os::raw::c_char)
                -> *mut ::std::os::raw::c_void;
        }
        stringToNode(arg_str_)
    })
}
pub unsafe fn readBitmapset() -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readBitmapset() -> *mut Bitmapset;
        }
        readBitmapset()
    })
}
pub unsafe fn readDatum(arg_typbyval: bool) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readDatum(arg_typbyval: bool) -> usize;
        }
        readDatum(arg_typbyval)
    })
}
pub unsafe fn readBoolCols(arg_numCols: ::std::os::raw::c_int) -> *mut bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readBoolCols(arg_numCols: ::std::os::raw::c_int) -> *mut bool;
        }
        readBoolCols(arg_numCols)
    })
}
pub unsafe fn readIntCols(arg_numCols: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readIntCols(arg_numCols: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_int;
        }
        readIntCols(arg_numCols)
    })
}
pub unsafe fn readOidCols(arg_numCols: ::std::os::raw::c_int) -> *mut Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readOidCols(arg_numCols: ::std::os::raw::c_int) -> *mut Oid;
        }
        readOidCols(arg_numCols)
    })
}
pub unsafe fn readAttrNumberCols(arg_numCols: ::std::os::raw::c_int) -> *mut int16 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readAttrNumberCols(arg_numCols: ::std::os::raw::c_int) -> *mut int16;
        }
        readAttrNumberCols(arg_numCols)
    })
}
pub unsafe fn copyObjectImpl(
    arg_obj: *const ::std::os::raw::c_void,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copyObjectImpl(
                arg_obj: *const ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void;
        }
        copyObjectImpl(arg_obj)
    })
}
pub unsafe fn equal(
    arg_a: *const ::std::os::raw::c_void,
    arg_b: *const ::std::os::raw::c_void,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn equal(
                arg_a: *const ::std::os::raw::c_void,
                arg_b: *const ::std::os::raw::c_void,
            ) -> bool;
        }
        equal(arg_a, arg_b)
    })
}
pub type Selectivity = f64;
pub type Cost = f64;
pub const CmdType_CMD_UNKNOWN: CmdType = 0;
pub const CmdType_CMD_SELECT: CmdType = 1;
pub const CmdType_CMD_UPDATE: CmdType = 2;
pub const CmdType_CMD_INSERT: CmdType = 3;
pub const CmdType_CMD_DELETE: CmdType = 4;
pub const CmdType_CMD_UTILITY: CmdType = 5;
pub const CmdType_CMD_NOTHING: CmdType = 6;
pub type CmdType = ::std::os::raw::c_uint;
pub const JoinType_JOIN_INNER: JoinType = 0;
pub const JoinType_JOIN_LEFT: JoinType = 1;
pub const JoinType_JOIN_FULL: JoinType = 2;
pub const JoinType_JOIN_RIGHT: JoinType = 3;
pub const JoinType_JOIN_SEMI: JoinType = 4;
pub const JoinType_JOIN_ANTI: JoinType = 5;
pub const JoinType_JOIN_UNIQUE_OUTER: JoinType = 6;
pub const JoinType_JOIN_UNIQUE_INNER: JoinType = 7;
pub type JoinType = ::std::os::raw::c_uint;
pub const AggStrategy_AGG_PLAIN: AggStrategy = 0;
pub const AggStrategy_AGG_SORTED: AggStrategy = 1;
pub const AggStrategy_AGG_HASHED: AggStrategy = 2;
pub const AggStrategy_AGG_MIXED: AggStrategy = 3;
pub type AggStrategy = ::std::os::raw::c_uint;
pub const AggSplit_AGGSPLIT_SIMPLE: AggSplit = 0;
pub const AggSplit_AGGSPLIT_INITIAL_SERIAL: AggSplit = 6;
pub const AggSplit_AGGSPLIT_FINAL_DESERIAL: AggSplit = 9;
pub type AggSplit = ::std::os::raw::c_uint;
pub const SetOpCmd_SETOPCMD_INTERSECT: SetOpCmd = 0;
pub const SetOpCmd_SETOPCMD_INTERSECT_ALL: SetOpCmd = 1;
pub const SetOpCmd_SETOPCMD_EXCEPT: SetOpCmd = 2;
pub const SetOpCmd_SETOPCMD_EXCEPT_ALL: SetOpCmd = 3;
pub type SetOpCmd = ::std::os::raw::c_uint;
pub const SetOpStrategy_SETOP_SORTED: SetOpStrategy = 0;
pub const SetOpStrategy_SETOP_HASHED: SetOpStrategy = 1;
pub type SetOpStrategy = ::std::os::raw::c_uint;
pub const OnConflictAction_ONCONFLICT_NONE: OnConflictAction = 0;
pub const OnConflictAction_ONCONFLICT_NOTHING: OnConflictAction = 1;
pub const OnConflictAction_ONCONFLICT_UPDATE: OnConflictAction = 2;
pub type OnConflictAction = ::std::os::raw::c_uint;
pub const LimitOption_LIMIT_OPTION_COUNT: LimitOption = 0;
pub const LimitOption_LIMIT_OPTION_WITH_TIES: LimitOption = 1;
pub const LimitOption_LIMIT_OPTION_DEFAULT: LimitOption = 2;
pub type LimitOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union ListCell {
    pub ptr_value: *mut ::std::os::raw::c_void,
    pub int_value: ::std::os::raw::c_int,
    pub oid_value: Oid,
}
impl Default for ListCell {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct List {
    pub type_: NodeTag,
    pub length: ::std::os::raw::c_int,
    pub max_length: ::std::os::raw::c_int,
    pub elements: *mut ListCell,
    pub initial_elements: __IncompleteArrayField<ListCell>,
}
impl Default for List {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForEachState {
    pub l: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForEachState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForBothState {
    pub l1: *const List,
    pub l2: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForBothState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForBothCellState {
    pub l1: *const List,
    pub l2: *const List,
    pub i1: ::std::os::raw::c_int,
    pub i2: ::std::os::raw::c_int,
}
impl Default for ForBothCellState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForThreeState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForThreeState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForFourState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub l4: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForFourState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForFiveState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub l4: *const List,
    pub l5: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForFiveState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn list_make1_impl(arg_t: NodeTag, arg_datum1: ListCell) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_make1_impl(arg_t: NodeTag, arg_datum1: ListCell) -> *mut List;
        }
        list_make1_impl(arg_t, arg_datum1)
    })
}
pub unsafe fn list_make2_impl(
    arg_t: NodeTag,
    arg_datum1: ListCell,
    arg_datum2: ListCell,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_make2_impl(
                arg_t: NodeTag,
                arg_datum1: ListCell,
                arg_datum2: ListCell,
            ) -> *mut List;
        }
        list_make2_impl(arg_t, arg_datum1, arg_datum2)
    })
}
pub unsafe fn list_make3_impl(
    arg_t: NodeTag,
    arg_datum1: ListCell,
    arg_datum2: ListCell,
    arg_datum3: ListCell,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_make3_impl(
                arg_t: NodeTag,
                arg_datum1: ListCell,
                arg_datum2: ListCell,
                arg_datum3: ListCell,
            ) -> *mut List;
        }
        list_make3_impl(arg_t, arg_datum1, arg_datum2, arg_datum3)
    })
}
pub unsafe fn list_make4_impl(
    arg_t: NodeTag,
    arg_datum1: ListCell,
    arg_datum2: ListCell,
    arg_datum3: ListCell,
    arg_datum4: ListCell,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_make4_impl(
                arg_t: NodeTag,
                arg_datum1: ListCell,
                arg_datum2: ListCell,
                arg_datum3: ListCell,
                arg_datum4: ListCell,
            ) -> *mut List;
        }
        list_make4_impl(arg_t, arg_datum1, arg_datum2, arg_datum3, arg_datum4)
    })
}
pub unsafe fn list_make5_impl(
    arg_t: NodeTag,
    arg_datum1: ListCell,
    arg_datum2: ListCell,
    arg_datum3: ListCell,
    arg_datum4: ListCell,
    arg_datum5: ListCell,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_make5_impl(
                arg_t: NodeTag,
                arg_datum1: ListCell,
                arg_datum2: ListCell,
                arg_datum3: ListCell,
                arg_datum4: ListCell,
                arg_datum5: ListCell,
            ) -> *mut List;
        }
        list_make5_impl(
            arg_t, arg_datum1, arg_datum2, arg_datum3, arg_datum4, arg_datum5,
        )
    })
}
pub unsafe fn lappend(arg_list: *mut List, arg_datum: *mut ::std::os::raw::c_void) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend(arg_list: *mut List, arg_datum: *mut ::std::os::raw::c_void) -> *mut List;
        }
        lappend(arg_list, arg_datum)
    })
}
pub unsafe fn lappend_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List;
        }
        lappend_int(arg_list, arg_datum)
    })
}
pub unsafe fn lappend_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List;
        }
        lappend_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_insert_nth(
    arg_list: *mut List,
    arg_pos: ::std::os::raw::c_int,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_insert_nth(
                arg_list: *mut List,
                arg_pos: ::std::os::raw::c_int,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_insert_nth(arg_list, arg_pos, arg_datum)
    })
}
pub unsafe fn list_insert_nth_int(
    arg_list: *mut List,
    arg_pos: ::std::os::raw::c_int,
    arg_datum: ::std::os::raw::c_int,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_insert_nth_int(
                arg_list: *mut List,
                arg_pos: ::std::os::raw::c_int,
                arg_datum: ::std::os::raw::c_int,
            ) -> *mut List;
        }
        list_insert_nth_int(arg_list, arg_pos, arg_datum)
    })
}
pub unsafe fn list_insert_nth_oid(
    arg_list: *mut List,
    arg_pos: ::std::os::raw::c_int,
    arg_datum: Oid,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_insert_nth_oid(
                arg_list: *mut List,
                arg_pos: ::std::os::raw::c_int,
                arg_datum: Oid,
            ) -> *mut List;
        }
        list_insert_nth_oid(arg_list, arg_pos, arg_datum)
    })
}
pub unsafe fn lcons(arg_datum: *mut ::std::os::raw::c_void, arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcons(arg_datum: *mut ::std::os::raw::c_void, arg_list: *mut List) -> *mut List;
        }
        lcons(arg_datum, arg_list)
    })
}
pub unsafe fn lcons_int(arg_datum: ::std::os::raw::c_int, arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcons_int(arg_datum: ::std::os::raw::c_int, arg_list: *mut List) -> *mut List;
        }
        lcons_int(arg_datum, arg_list)
    })
}
pub unsafe fn lcons_oid(arg_datum: Oid, arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcons_oid(arg_datum: Oid, arg_list: *mut List) -> *mut List;
        }
        lcons_oid(arg_datum, arg_list)
    })
}
pub unsafe fn list_concat(arg_list1: *mut List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat(arg_list1: *mut List, arg_list2: *const List) -> *mut List;
        }
        list_concat(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_copy(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_copy(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_concat_copy(arg_list1, arg_list2)
    })
}
pub unsafe fn list_truncate(arg_list: *mut List, arg_new_size: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_truncate(arg_list: *mut List, arg_new_size: ::std::os::raw::c_int)
                -> *mut List;
        }
        list_truncate(arg_list, arg_new_size)
    })
}
pub unsafe fn list_member(arg_list: *const List, arg_datum: *const ::std::os::raw::c_void) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member(arg_list: *const List, arg_datum: *const ::std::os::raw::c_void)
                -> bool;
        }
        list_member(arg_list, arg_datum)
    })
}
pub unsafe fn list_member_ptr(
    arg_list: *const List,
    arg_datum: *const ::std::os::raw::c_void,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member_ptr(
                arg_list: *const List,
                arg_datum: *const ::std::os::raw::c_void,
            ) -> bool;
        }
        list_member_ptr(arg_list, arg_datum)
    })
}
pub unsafe fn list_member_int(arg_list: *const List, arg_datum: ::std::os::raw::c_int) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member_int(arg_list: *const List, arg_datum: ::std::os::raw::c_int) -> bool;
        }
        list_member_int(arg_list, arg_datum)
    })
}
pub unsafe fn list_member_oid(arg_list: *const List, arg_datum: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member_oid(arg_list: *const List, arg_datum: Oid) -> bool;
        }
        list_member_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_delete(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_ptr(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_ptr(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_delete_ptr(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List;
        }
        list_delete_int(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List;
        }
        list_delete_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_first(arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_first(arg_list: *mut List) -> *mut List;
        }
        list_delete_first(arg_list)
    })
}
pub unsafe fn list_delete_last(arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_last(arg_list: *mut List) -> *mut List;
        }
        list_delete_last(arg_list)
    })
}
pub unsafe fn list_delete_first_n(arg_list: *mut List, arg_n: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_first_n(arg_list: *mut List, arg_n: ::std::os::raw::c_int) -> *mut List;
        }
        list_delete_first_n(arg_list, arg_n)
    })
}
pub unsafe fn list_delete_nth_cell(arg_list: *mut List, arg_n: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_nth_cell(arg_list: *mut List, arg_n: ::std::os::raw::c_int)
                -> *mut List;
        }
        list_delete_nth_cell(arg_list, arg_n)
    })
}
pub unsafe fn list_delete_cell(arg_list: *mut List, arg_cell: *mut ListCell) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_cell(arg_list: *mut List, arg_cell: *mut ListCell) -> *mut List;
        }
        list_delete_cell(arg_list, arg_cell)
    })
}
pub unsafe fn list_union(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union(arg_list1, arg_list2)
    })
}
pub unsafe fn list_union_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union_ptr(arg_list1, arg_list2)
    })
}
pub unsafe fn list_union_int(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union_int(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_union_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union_oid(arg_list1, arg_list2)
    })
}
pub unsafe fn list_intersection(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_intersection(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_intersection(arg_list1, arg_list2)
    })
}
pub unsafe fn list_intersection_int(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_intersection_int(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_intersection_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference_ptr(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference_int(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference_int(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference_oid(arg_list1, arg_list2)
    })
}
pub unsafe fn list_append_unique(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_append_unique(arg_list, arg_datum)
    })
}
pub unsafe fn list_append_unique_ptr(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique_ptr(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_append_unique_ptr(arg_list, arg_datum)
    })
}
pub unsafe fn list_append_unique_int(
    arg_list: *mut List,
    arg_datum: ::std::os::raw::c_int,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique_int(
                arg_list: *mut List,
                arg_datum: ::std::os::raw::c_int,
            ) -> *mut List;
        }
        list_append_unique_int(arg_list, arg_datum)
    })
}
pub unsafe fn list_append_unique_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List;
        }
        list_append_unique_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_concat_unique(arg_list1: *mut List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique(arg_list1: *mut List, arg_list2: *const List) -> *mut List;
        }
        list_concat_unique(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_unique_ptr(arg_list1: *mut List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique_ptr(arg_list1: *mut List, arg_list2: *const List) -> *mut List;
        }
        list_concat_unique_ptr(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_unique_int(arg_list1: *mut List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique_int(arg_list1: *mut List, arg_list2: *const List) -> *mut List;
        }
        list_concat_unique_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_unique_oid(arg_list1: *mut List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique_oid(arg_list1: *mut List, arg_list2: *const List) -> *mut List;
        }
        list_concat_unique_oid(arg_list1, arg_list2)
    })
}
pub unsafe fn list_deduplicate_oid(arg_list: *mut List) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_deduplicate_oid(arg_list: *mut List);
        }
        list_deduplicate_oid(arg_list)
    })
}
pub unsafe fn list_free(arg_list: *mut List) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_free(arg_list: *mut List);
        }
        list_free(arg_list)
    })
}
pub unsafe fn list_free_deep(arg_list: *mut List) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_free_deep(arg_list: *mut List);
        }
        list_free_deep(arg_list)
    })
}
pub unsafe fn list_copy(arg_list: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_copy(arg_list: *const List) -> *mut List;
        }
        list_copy(arg_list)
    })
}
pub unsafe fn list_copy_tail(arg_list: *const List, arg_nskip: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_copy_tail(arg_list: *const List, arg_nskip: ::std::os::raw::c_int)
                -> *mut List;
        }
        list_copy_tail(arg_list, arg_nskip)
    })
}
pub unsafe fn list_copy_deep(arg_oldlist: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_copy_deep(arg_oldlist: *const List) -> *mut List;
        }
        list_copy_deep(arg_oldlist)
    })
}
pub type list_sort_comparator = ::std::option::Option<
    unsafe extern "C" fn(a: *const ListCell, b: *const ListCell) -> ::std::os::raw::c_int,
>;
pub unsafe fn list_sort(arg_list: *mut List, arg_cmp: list_sort_comparator) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_sort(arg_list: *mut List, arg_cmp: list_sort_comparator);
        }
        list_sort(arg_list, arg_cmp)
    })
}
pub unsafe fn list_int_cmp(
    arg_p1: *const ListCell,
    arg_p2: *const ListCell,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_int_cmp(
                arg_p1: *const ListCell,
                arg_p2: *const ListCell,
            ) -> ::std::os::raw::c_int;
        }
        list_int_cmp(arg_p1, arg_p2)
    })
}
pub unsafe fn list_oid_cmp(
    arg_p1: *const ListCell,
    arg_p2: *const ListCell,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_oid_cmp(
                arg_p1: *const ListCell,
                arg_p2: *const ListCell,
            ) -> ::std::os::raw::c_int;
        }
        list_oid_cmp(arg_p1, arg_p2)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttrDefault {
    pub adnum: AttrNumber,
    pub adbin: *mut ::std::os::raw::c_char,
}
impl Default for AttrDefault {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConstrCheck {
    pub ccname: *mut ::std::os::raw::c_char,
    pub ccbin: *mut ::std::os::raw::c_char,
    pub ccvalid: bool,
    pub ccnoinherit: bool,
}
impl Default for ConstrCheck {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConstr {
    pub defval: *mut AttrDefault,
    pub check: *mut ConstrCheck,
    pub missing: *mut AttrMissing,
    pub num_defval: uint16,
    pub num_check: uint16,
    pub has_not_null: bool,
    pub has_generated_stored: bool,
}
impl Default for TupleConstr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct TupleDescData {
    pub natts: ::std::os::raw::c_int,
    pub tdtypeid: Oid,
    pub tdtypmod: int32,
    pub tdrefcount: ::std::os::raw::c_int,
    pub constr: *mut TupleConstr,
    pub attrs: __IncompleteArrayField<FormData_pg_attribute>,
}
impl Default for TupleDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleDesc = *mut TupleDescData;
pub unsafe fn CreateTemplateTupleDesc(arg_natts: ::std::os::raw::c_int) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTemplateTupleDesc(arg_natts: ::std::os::raw::c_int) -> TupleDesc;
        }
        CreateTemplateTupleDesc(arg_natts)
    })
}
pub unsafe fn CreateTupleDesc(
    arg_natts: ::std::os::raw::c_int,
    arg_attrs: *mut Form_pg_attribute,
) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTupleDesc(
                arg_natts: ::std::os::raw::c_int,
                arg_attrs: *mut Form_pg_attribute,
            ) -> TupleDesc;
        }
        CreateTupleDesc(arg_natts, arg_attrs)
    })
}
pub unsafe fn CreateTupleDescCopy(arg_tupdesc: TupleDesc) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTupleDescCopy(arg_tupdesc: TupleDesc) -> TupleDesc;
        }
        CreateTupleDescCopy(arg_tupdesc)
    })
}
pub unsafe fn CreateTupleDescCopyConstr(arg_tupdesc: TupleDesc) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTupleDescCopyConstr(arg_tupdesc: TupleDesc) -> TupleDesc;
        }
        CreateTupleDescCopyConstr(arg_tupdesc)
    })
}
pub unsafe fn TupleDescCopy(arg_dst: TupleDesc, arg_src: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescCopy(arg_dst: TupleDesc, arg_src: TupleDesc);
        }
        TupleDescCopy(arg_dst, arg_src)
    })
}
pub unsafe fn TupleDescCopyEntry(
    arg_dst: TupleDesc,
    arg_dstAttno: AttrNumber,
    arg_src: TupleDesc,
    arg_srcAttno: AttrNumber,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescCopyEntry(
                arg_dst: TupleDesc,
                arg_dstAttno: AttrNumber,
                arg_src: TupleDesc,
                arg_srcAttno: AttrNumber,
            );
        }
        TupleDescCopyEntry(arg_dst, arg_dstAttno, arg_src, arg_srcAttno)
    })
}
pub unsafe fn FreeTupleDesc(arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeTupleDesc(arg_tupdesc: TupleDesc);
        }
        FreeTupleDesc(arg_tupdesc)
    })
}
pub unsafe fn IncrTupleDescRefCount(arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn IncrTupleDescRefCount(arg_tupdesc: TupleDesc);
        }
        IncrTupleDescRefCount(arg_tupdesc)
    })
}
pub unsafe fn DecrTupleDescRefCount(arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DecrTupleDescRefCount(arg_tupdesc: TupleDesc);
        }
        DecrTupleDescRefCount(arg_tupdesc)
    })
}
pub unsafe fn equalTupleDescs(arg_tupdesc1: TupleDesc, arg_tupdesc2: TupleDesc) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn equalTupleDescs(arg_tupdesc1: TupleDesc, arg_tupdesc2: TupleDesc) -> bool;
        }
        equalTupleDescs(arg_tupdesc1, arg_tupdesc2)
    })
}
pub unsafe fn hashTupleDesc(arg_tupdesc: TupleDesc) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hashTupleDesc(arg_tupdesc: TupleDesc) -> uint32;
        }
        hashTupleDesc(arg_tupdesc)
    })
}
pub unsafe fn TupleDescInitEntry(
    arg_desc: TupleDesc,
    arg_attributeNumber: AttrNumber,
    arg_attributeName: *const ::std::os::raw::c_char,
    arg_oidtypeid: Oid,
    arg_typmod: int32,
    arg_attdim: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescInitEntry(
                arg_desc: TupleDesc,
                arg_attributeNumber: AttrNumber,
                arg_attributeName: *const ::std::os::raw::c_char,
                arg_oidtypeid: Oid,
                arg_typmod: int32,
                arg_attdim: ::std::os::raw::c_int,
            );
        }
        TupleDescInitEntry(
            arg_desc,
            arg_attributeNumber,
            arg_attributeName,
            arg_oidtypeid,
            arg_typmod,
            arg_attdim,
        )
    })
}
pub unsafe fn TupleDescInitBuiltinEntry(
    arg_desc: TupleDesc,
    arg_attributeNumber: AttrNumber,
    arg_attributeName: *const ::std::os::raw::c_char,
    arg_oidtypeid: Oid,
    arg_typmod: int32,
    arg_attdim: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescInitBuiltinEntry(
                arg_desc: TupleDesc,
                arg_attributeNumber: AttrNumber,
                arg_attributeName: *const ::std::os::raw::c_char,
                arg_oidtypeid: Oid,
                arg_typmod: int32,
                arg_attdim: ::std::os::raw::c_int,
            );
        }
        TupleDescInitBuiltinEntry(
            arg_desc,
            arg_attributeNumber,
            arg_attributeName,
            arg_oidtypeid,
            arg_typmod,
            arg_attdim,
        )
    })
}
pub unsafe fn TupleDescInitEntryCollation(
    arg_desc: TupleDesc,
    arg_attributeNumber: AttrNumber,
    arg_collationid: Oid,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescInitEntryCollation(
                arg_desc: TupleDesc,
                arg_attributeNumber: AttrNumber,
                arg_collationid: Oid,
            );
        }
        TupleDescInitEntryCollation(arg_desc, arg_attributeNumber, arg_collationid)
    })
}
pub unsafe fn BuildDescForRelation(arg_schema: *mut List) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildDescForRelation(arg_schema: *mut List) -> TupleDesc;
        }
        BuildDescForRelation(arg_schema)
    })
}
pub unsafe fn BuildDescFromLists(
    arg_names: *mut List,
    arg_types: *mut List,
    arg_typmods: *mut List,
    arg_collations: *mut List,
) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildDescFromLists(
                arg_names: *mut List,
                arg_types: *mut List,
                arg_typmods: *mut List,
                arg_collations: *mut List,
            ) -> TupleDesc;
        }
        BuildDescFromLists(arg_names, arg_types, arg_typmods, arg_collations)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttrMap {
    pub attnums: *mut AttrNumber,
    pub maplen: ::std::os::raw::c_int,
}
impl Default for AttrMap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn make_attrmap(arg_maplen: ::std::os::raw::c_int) -> *mut AttrMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn make_attrmap(arg_maplen: ::std::os::raw::c_int) -> *mut AttrMap;
        }
        make_attrmap(arg_maplen)
    })
}
pub unsafe fn free_attrmap(arg_map: *mut AttrMap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn free_attrmap(arg_map: *mut AttrMap);
        }
        free_attrmap(arg_map)
    })
}
pub unsafe fn build_attrmap_by_name(arg_indesc: TupleDesc, arg_outdesc: TupleDesc) -> *mut AttrMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn build_attrmap_by_name(arg_indesc: TupleDesc, arg_outdesc: TupleDesc)
                -> *mut AttrMap;
        }
        build_attrmap_by_name(arg_indesc, arg_outdesc)
    })
}
pub unsafe fn build_attrmap_by_name_if_req(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
) -> *mut AttrMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn build_attrmap_by_name_if_req(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
            ) -> *mut AttrMap;
        }
        build_attrmap_by_name_if_req(arg_indesc, arg_outdesc)
    })
}
pub unsafe fn build_attrmap_by_position(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
    arg_msg: *const ::std::os::raw::c_char,
) -> *mut AttrMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn build_attrmap_by_position(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
                arg_msg: *const ::std::os::raw::c_char,
            ) -> *mut AttrMap;
        }
        build_attrmap_by_position(arg_indesc, arg_outdesc, arg_msg)
    })
}
pub type BlockNumber = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BlockIdData {
    pub bi_hi: uint16,
    pub bi_lo: uint16,
}
pub type BlockId = *mut BlockIdData;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemIdData {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl ItemIdData {
    #[inline]
    pub fn lp_off(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_off(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn lp_flags(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_lp_flags(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn lp_len(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_len(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lp_off: ::std::os::raw::c_uint,
        lp_flags: ::std::os::raw::c_uint,
        lp_len: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 15u8, {
            let lp_off: u32 = unsafe { ::std::mem::transmute(lp_off) };
            lp_off as u64
        });
        __bindgen_bitfield_unit.set(15usize, 2u8, {
            let lp_flags: u32 = unsafe { ::std::mem::transmute(lp_flags) };
            lp_flags as u64
        });
        __bindgen_bitfield_unit.set(17usize, 15u8, {
            let lp_len: u32 = unsafe { ::std::mem::transmute(lp_len) };
            lp_len as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type ItemId = *mut ItemIdData;
pub type ItemOffset = uint16;
pub type ItemLength = uint16;
pub type OffsetNumber = uint16;
#[repr(C, packed(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemPointerData {
    pub ip_blkid: BlockIdData,
    pub ip_posid: OffsetNumber,
}
pub type ItemPointer = *mut ItemPointerData;
pub unsafe fn ItemPointerEquals(arg_pointer1: ItemPointer, arg_pointer2: ItemPointer) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ItemPointerEquals(arg_pointer1: ItemPointer, arg_pointer2: ItemPointer) -> bool;
        }
        ItemPointerEquals(arg_pointer1, arg_pointer2)
    })
}
pub unsafe fn ItemPointerCompare(arg_arg1: ItemPointer, arg_arg2: ItemPointer) -> int32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ItemPointerCompare(arg_arg1: ItemPointer, arg_arg2: ItemPointer) -> int32;
        }
        ItemPointerCompare(arg_arg1, arg_arg2)
    })
}
pub unsafe fn ItemPointerInc(arg_pointer: ItemPointer) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ItemPointerInc(arg_pointer: ItemPointer);
        }
        ItemPointerInc(arg_pointer)
    })
}
pub unsafe fn ItemPointerDec(arg_pointer: ItemPointer) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ItemPointerDec(arg_pointer: ItemPointer);
        }
        ItemPointerDec(arg_pointer)
    })
}
pub type HeapTupleHeader = *mut HeapTupleHeaderData;
pub type MinimalTuple = *mut MinimalTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleData {
    pub t_len: uint32,
    pub t_self: ItemPointerData,
    pub t_tableOid: Oid,
    pub t_data: HeapTupleHeader,
}
impl Default for HeapTupleData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HeapTuple = *mut HeapTupleData;
pub unsafe fn HeapTupleHeaderGetCmin(arg_tup: HeapTupleHeader) -> CommandId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleHeaderGetCmin(arg_tup: HeapTupleHeader) -> CommandId;
        }
        HeapTupleHeaderGetCmin(arg_tup)
    })
}
pub unsafe fn HeapTupleHeaderGetCmax(arg_tup: HeapTupleHeader) -> CommandId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleHeaderGetCmax(arg_tup: HeapTupleHeader) -> CommandId;
        }
        HeapTupleHeaderGetCmax(arg_tup)
    })
}
pub unsafe fn HeapTupleHeaderAdjustCmax(
    arg_tup: HeapTupleHeader,
    arg_cmax: *mut CommandId,
    arg_iscombo: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleHeaderAdjustCmax(
                arg_tup: HeapTupleHeader,
                arg_cmax: *mut CommandId,
                arg_iscombo: *mut bool,
            );
        }
        HeapTupleHeaderAdjustCmax(arg_tup, arg_cmax, arg_iscombo)
    })
}
pub unsafe fn HeapTupleGetUpdateXid(arg_tuple: HeapTupleHeader) -> TransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleGetUpdateXid(arg_tuple: HeapTupleHeader) -> TransactionId;
        }
        HeapTupleGetUpdateXid(arg_tuple)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct flock {
    pub l_start: off_t,
    pub l_len: off_t,
    pub l_pid: pid_t,
    pub l_type: ::std::os::raw::c_short,
    pub l_whence: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __darwin_time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct flocktimeout {
    pub fl: flock,
    pub timeout: timespec,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct radvisory {
    pub ra_offset: off_t,
    pub ra_count: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fsignatures {
    pub fs_file_start: off_t,
    pub fs_blob_start: *mut ::std::os::raw::c_void,
    pub fs_blob_size: usize,
    pub fs_fsignatures_size: usize,
    pub fs_cdhash: [::std::os::raw::c_char; 20usize],
    pub fs_hash_type: ::std::os::raw::c_int,
}
impl Default for fsignatures {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type fsignatures_t = fsignatures;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fsupplement {
    pub fs_file_start: off_t,
    pub fs_blob_start: off_t,
    pub fs_blob_size: usize,
    pub fs_orig_fd: ::std::os::raw::c_int,
}
pub type fsupplement_t = fsupplement;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fchecklv {
    pub lv_file_start: off_t,
    pub lv_error_message_size: usize,
    pub lv_error_message: *mut ::std::os::raw::c_void,
}
impl Default for fchecklv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type fchecklv_t = fchecklv;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fgetsigsinfo {
    pub fg_file_start: off_t,
    pub fg_info_request: ::std::os::raw::c_int,
    pub fg_sig_is_platform: ::std::os::raw::c_int,
}
pub type fgetsigsinfo_t = fgetsigsinfo;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fstore {
    pub fst_flags: ::std::os::raw::c_uint,
    pub fst_posmode: ::std::os::raw::c_int,
    pub fst_offset: off_t,
    pub fst_length: off_t,
    pub fst_bytesalloc: off_t,
}
pub type fstore_t = fstore;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fpunchhole {
    pub fp_flags: ::std::os::raw::c_uint,
    pub reserved: ::std::os::raw::c_uint,
    pub fp_offset: off_t,
    pub fp_length: off_t,
}
pub type fpunchhole_t = fpunchhole;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ftrimactivefile {
    pub fta_offset: off_t,
    pub fta_length: off_t,
}
pub type ftrimactivefile_t = ftrimactivefile;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fspecread {
    pub fsr_flags: ::std::os::raw::c_uint,
    pub reserved: ::std::os::raw::c_uint,
    pub fsr_offset: off_t,
    pub fsr_length: off_t,
}
pub type fspecread_t = fspecread;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fbootstraptransfer {
    pub fbt_offset: off_t,
    pub fbt_length: usize,
    pub fbt_buffer: *mut ::std::os::raw::c_void,
}
impl Default for fbootstraptransfer {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type fbootstraptransfer_t = fbootstraptransfer;
#[repr(C, packed(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct log2phys {
    pub l2p_flags: ::std::os::raw::c_uint,
    pub l2p_contigbytes: off_t,
    pub l2p_devoffset: off_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _filesec {
    _unused: [u8; 0],
}
pub type filesec_t = *mut _filesec;
pub const filesec_property_t_FILESEC_OWNER: filesec_property_t = 1;
pub const filesec_property_t_FILESEC_GROUP: filesec_property_t = 2;
pub const filesec_property_t_FILESEC_UUID: filesec_property_t = 3;
pub const filesec_property_t_FILESEC_MODE: filesec_property_t = 4;
pub const filesec_property_t_FILESEC_ACL: filesec_property_t = 5;
pub const filesec_property_t_FILESEC_GRPUUID: filesec_property_t = 6;
pub const filesec_property_t_FILESEC_ACL_RAW: filesec_property_t = 100;
pub const filesec_property_t_FILESEC_ACL_ALLOCSIZE: filesec_property_t = 101;
pub type filesec_property_t = ::std::os::raw::c_uint;
pub unsafe fn open(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn open(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        open(arg_arg1, arg_arg2)
    })
}
pub unsafe fn openat(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn openat(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        openat(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn creat(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: mode_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn creat(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: mode_t,
            ) -> ::std::os::raw::c_int;
        }
        creat(arg_arg1, arg_arg2)
    })
}
pub unsafe fn fcntl(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fcntl(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        fcntl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn openx_np(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: filesec_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn openx_np(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: filesec_t,
            ) -> ::std::os::raw::c_int;
        }
        openx_np(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn open_dprotected_np(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn open_dprotected_np(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        open_dprotected_np(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn flock(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn flock(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        flock(arg_arg1, arg_arg2)
    })
}
pub unsafe fn filesec_init() -> filesec_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn filesec_init() -> filesec_t;
        }
        filesec_init()
    })
}
pub unsafe fn filesec_dup(arg_arg1: filesec_t) -> filesec_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn filesec_dup(arg_arg1: filesec_t) -> filesec_t;
        }
        filesec_dup(arg_arg1)
    })
}
pub unsafe fn filesec_free(arg_arg1: filesec_t) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn filesec_free(arg_arg1: filesec_t);
        }
        filesec_free(arg_arg1)
    })
}
pub unsafe fn filesec_get_property(
    arg_arg1: filesec_t,
    arg_arg2: filesec_property_t,
    arg_arg3: *mut ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn filesec_get_property(
                arg_arg1: filesec_t,
                arg_arg2: filesec_property_t,
                arg_arg3: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        filesec_get_property(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn filesec_query_property(
    arg_arg1: filesec_t,
    arg_arg2: filesec_property_t,
    arg_arg3: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn filesec_query_property(
                arg_arg1: filesec_t,
                arg_arg2: filesec_property_t,
                arg_arg3: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        filesec_query_property(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn filesec_set_property(
    arg_arg1: filesec_t,
    arg_arg2: filesec_property_t,
    arg_arg3: *const ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn filesec_set_property(
                arg_arg1: filesec_t,
                arg_arg2: filesec_property_t,
                arg_arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        filesec_set_property(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn filesec_unset_property(
    arg_arg1: filesec_t,
    arg_arg2: filesec_property_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn filesec_unset_property(
                arg_arg1: filesec_t,
                arg_arg2: filesec_property_t,
            ) -> ::std::os::raw::c_int;
        }
        filesec_unset_property(arg_arg1, arg_arg2)
    })
}
pub type XLogRecPtr = uint64;
pub type XLogSegNo = uint64;
pub type TimeLineID = uint32;
pub type RepOriginId = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct FullTransactionId {
    pub value: uint64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct VariableCacheData {
    pub nextOid: Oid,
    pub oidCount: uint32,
    pub nextXid: FullTransactionId,
    pub oldestXid: TransactionId,
    pub xidVacLimit: TransactionId,
    pub xidWarnLimit: TransactionId,
    pub xidStopLimit: TransactionId,
    pub xidWrapLimit: TransactionId,
    pub oldestXidDB: Oid,
    pub oldestCommitTsXid: TransactionId,
    pub newestCommitTsXid: TransactionId,
    pub latestCompletedXid: FullTransactionId,
    pub xactCompletionCount: uint64,
    pub oldestClogXid: TransactionId,
}
pub type VariableCache = *mut VariableCacheData;
pub unsafe fn TransactionStartedDuringRecovery() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionStartedDuringRecovery() -> bool;
        }
        TransactionStartedDuringRecovery()
    })
}
extern "C" {
    pub static mut ShmemVariableCache: VariableCache;
}
pub unsafe fn TransactionIdDidCommit(arg_transactionId: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdDidCommit(arg_transactionId: TransactionId) -> bool;
        }
        TransactionIdDidCommit(arg_transactionId)
    })
}
pub unsafe fn TransactionIdDidAbort(arg_transactionId: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdDidAbort(arg_transactionId: TransactionId) -> bool;
        }
        TransactionIdDidAbort(arg_transactionId)
    })
}
pub unsafe fn TransactionIdIsKnownCompleted(arg_transactionId: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdIsKnownCompleted(arg_transactionId: TransactionId) -> bool;
        }
        TransactionIdIsKnownCompleted(arg_transactionId)
    })
}
pub unsafe fn TransactionIdCommitTree(
    arg_xid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *mut TransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdCommitTree(
                arg_xid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *mut TransactionId,
            );
        }
        TransactionIdCommitTree(arg_xid, arg_nxids, arg_xids)
    })
}
pub unsafe fn TransactionIdAsyncCommitTree(
    arg_xid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *mut TransactionId,
    arg_lsn: XLogRecPtr,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdAsyncCommitTree(
                arg_xid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *mut TransactionId,
                arg_lsn: XLogRecPtr,
            );
        }
        TransactionIdAsyncCommitTree(arg_xid, arg_nxids, arg_xids, arg_lsn)
    })
}
pub unsafe fn TransactionIdAbortTree(
    arg_xid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *mut TransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdAbortTree(
                arg_xid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *mut TransactionId,
            );
        }
        TransactionIdAbortTree(arg_xid, arg_nxids, arg_xids)
    })
}
pub unsafe fn TransactionIdPrecedes(arg_id1: TransactionId, arg_id2: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdPrecedes(arg_id1: TransactionId, arg_id2: TransactionId) -> bool;
        }
        TransactionIdPrecedes(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdPrecedesOrEquals(
    arg_id1: TransactionId,
    arg_id2: TransactionId,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdPrecedesOrEquals(
                arg_id1: TransactionId,
                arg_id2: TransactionId,
            ) -> bool;
        }
        TransactionIdPrecedesOrEquals(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdFollows(arg_id1: TransactionId, arg_id2: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdFollows(arg_id1: TransactionId, arg_id2: TransactionId) -> bool;
        }
        TransactionIdFollows(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdFollowsOrEquals(arg_id1: TransactionId, arg_id2: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdFollowsOrEquals(arg_id1: TransactionId, arg_id2: TransactionId)
                -> bool;
        }
        TransactionIdFollowsOrEquals(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdLatest(
    arg_mainxid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *const TransactionId,
) -> TransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdLatest(
                arg_mainxid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *const TransactionId,
            ) -> TransactionId;
        }
        TransactionIdLatest(arg_mainxid, arg_nxids, arg_xids)
    })
}
pub unsafe fn TransactionIdGetCommitLSN(arg_xid: TransactionId) -> XLogRecPtr {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdGetCommitLSN(arg_xid: TransactionId) -> XLogRecPtr;
        }
        TransactionIdGetCommitLSN(arg_xid)
    })
}
pub unsafe fn GetNewTransactionId(arg_isSubXact: bool) -> FullTransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetNewTransactionId(arg_isSubXact: bool) -> FullTransactionId;
        }
        GetNewTransactionId(arg_isSubXact)
    })
}
pub unsafe fn AdvanceNextFullTransactionIdPastXid(arg_xid: TransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AdvanceNextFullTransactionIdPastXid(arg_xid: TransactionId);
        }
        AdvanceNextFullTransactionIdPastXid(arg_xid)
    })
}
pub unsafe fn ReadNextFullTransactionId() -> FullTransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadNextFullTransactionId() -> FullTransactionId;
        }
        ReadNextFullTransactionId()
    })
}
pub unsafe fn SetTransactionIdLimit(
    arg_oldest_datfrozenxid: TransactionId,
    arg_oldest_datoid: Oid,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetTransactionIdLimit(
                arg_oldest_datfrozenxid: TransactionId,
                arg_oldest_datoid: Oid,
            );
        }
        SetTransactionIdLimit(arg_oldest_datfrozenxid, arg_oldest_datoid)
    })
}
pub unsafe fn AdvanceOldestClogXid(arg_oldest_datfrozenxid: TransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AdvanceOldestClogXid(arg_oldest_datfrozenxid: TransactionId);
        }
        AdvanceOldestClogXid(arg_oldest_datfrozenxid)
    })
}
pub unsafe fn ForceTransactionIdLimitUpdate() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ForceTransactionIdLimitUpdate() -> bool;
        }
        ForceTransactionIdLimitUpdate()
    })
}
pub unsafe fn GetNewObjectId() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetNewObjectId() -> Oid;
        }
        GetNewObjectId()
    })
}
pub unsafe fn AssertTransactionIdInAllowableRange(arg_xid: TransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AssertTransactionIdInAllowableRange(arg_xid: TransactionId);
        }
        AssertTransactionIdInAllowableRange(arg_xid)
    })
}
pub type Item = Pointer;
pub type Page = Pointer;
pub type LocationIndex = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PageXLogRecPtr {
    pub xlogid: uint32,
    pub xrecoff: uint32,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct PageHeaderData {
    pub pd_lsn: PageXLogRecPtr,
    pub pd_checksum: uint16,
    pub pd_flags: uint16,
    pub pd_lower: LocationIndex,
    pub pd_upper: LocationIndex,
    pub pd_special: LocationIndex,
    pub pd_pagesize_version: uint16,
    pub pd_prune_xid: TransactionId,
    pub pd_linp: __IncompleteArrayField<ItemIdData>,
}
pub type PageHeader = *mut PageHeaderData;
pub unsafe fn PageInit(arg_page: Page, arg_pageSize: Size, arg_specialSize: Size) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageInit(arg_page: Page, arg_pageSize: Size, arg_specialSize: Size);
        }
        PageInit(arg_page, arg_pageSize, arg_specialSize)
    })
}
pub unsafe fn PageIsVerifiedExtended(
    arg_page: Page,
    arg_blkno: BlockNumber,
    arg_flags: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIsVerifiedExtended(
                arg_page: Page,
                arg_blkno: BlockNumber,
                arg_flags: ::std::os::raw::c_int,
            ) -> bool;
        }
        PageIsVerifiedExtended(arg_page, arg_blkno, arg_flags)
    })
}
pub unsafe fn PageAddItemExtended(
    arg_page: Page,
    arg_item: Item,
    arg_size: Size,
    arg_offsetNumber: OffsetNumber,
    arg_flags: ::std::os::raw::c_int,
) -> OffsetNumber {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageAddItemExtended(
                arg_page: Page,
                arg_item: Item,
                arg_size: Size,
                arg_offsetNumber: OffsetNumber,
                arg_flags: ::std::os::raw::c_int,
            ) -> OffsetNumber;
        }
        PageAddItemExtended(arg_page, arg_item, arg_size, arg_offsetNumber, arg_flags)
    })
}
pub unsafe fn PageGetTempPage(arg_page: Page) -> Page {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetTempPage(arg_page: Page) -> Page;
        }
        PageGetTempPage(arg_page)
    })
}
pub unsafe fn PageGetTempPageCopy(arg_page: Page) -> Page {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetTempPageCopy(arg_page: Page) -> Page;
        }
        PageGetTempPageCopy(arg_page)
    })
}
pub unsafe fn PageGetTempPageCopySpecial(arg_page: Page) -> Page {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetTempPageCopySpecial(arg_page: Page) -> Page;
        }
        PageGetTempPageCopySpecial(arg_page)
    })
}
pub unsafe fn PageRestoreTempPage(arg_tempPage: Page, arg_oldPage: Page) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageRestoreTempPage(arg_tempPage: Page, arg_oldPage: Page);
        }
        PageRestoreTempPage(arg_tempPage, arg_oldPage)
    })
}
pub unsafe fn PageRepairFragmentation(arg_page: Page) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageRepairFragmentation(arg_page: Page);
        }
        PageRepairFragmentation(arg_page)
    })
}
pub unsafe fn PageTruncateLinePointerArray(arg_page: Page) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageTruncateLinePointerArray(arg_page: Page);
        }
        PageTruncateLinePointerArray(arg_page)
    })
}
pub unsafe fn PageGetFreeSpace(arg_page: Page) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetFreeSpace(arg_page: Page) -> Size;
        }
        PageGetFreeSpace(arg_page)
    })
}
pub unsafe fn PageGetFreeSpaceForMultipleTuples(
    arg_page: Page,
    arg_ntups: ::std::os::raw::c_int,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetFreeSpaceForMultipleTuples(
                arg_page: Page,
                arg_ntups: ::std::os::raw::c_int,
            ) -> Size;
        }
        PageGetFreeSpaceForMultipleTuples(arg_page, arg_ntups)
    })
}
pub unsafe fn PageGetExactFreeSpace(arg_page: Page) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetExactFreeSpace(arg_page: Page) -> Size;
        }
        PageGetExactFreeSpace(arg_page)
    })
}
pub unsafe fn PageGetHeapFreeSpace(arg_page: Page) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetHeapFreeSpace(arg_page: Page) -> Size;
        }
        PageGetHeapFreeSpace(arg_page)
    })
}
pub unsafe fn PageIndexTupleDelete(arg_page: Page, arg_offset: OffsetNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexTupleDelete(arg_page: Page, arg_offset: OffsetNumber);
        }
        PageIndexTupleDelete(arg_page, arg_offset)
    })
}
pub unsafe fn PageIndexMultiDelete(
    arg_page: Page,
    arg_itemnos: *mut OffsetNumber,
    arg_nitems: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexMultiDelete(
                arg_page: Page,
                arg_itemnos: *mut OffsetNumber,
                arg_nitems: ::std::os::raw::c_int,
            );
        }
        PageIndexMultiDelete(arg_page, arg_itemnos, arg_nitems)
    })
}
pub unsafe fn PageIndexTupleDeleteNoCompact(arg_page: Page, arg_offset: OffsetNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexTupleDeleteNoCompact(arg_page: Page, arg_offset: OffsetNumber);
        }
        PageIndexTupleDeleteNoCompact(arg_page, arg_offset)
    })
}
pub unsafe fn PageIndexTupleOverwrite(
    arg_page: Page,
    arg_offnum: OffsetNumber,
    arg_newtup: Item,
    arg_newsize: Size,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexTupleOverwrite(
                arg_page: Page,
                arg_offnum: OffsetNumber,
                arg_newtup: Item,
                arg_newsize: Size,
            ) -> bool;
        }
        PageIndexTupleOverwrite(arg_page, arg_offnum, arg_newtup, arg_newsize)
    })
}
pub unsafe fn PageSetChecksumCopy(
    arg_page: Page,
    arg_blkno: BlockNumber,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageSetChecksumCopy(
                arg_page: Page,
                arg_blkno: BlockNumber,
            ) -> *mut ::std::os::raw::c_char;
        }
        PageSetChecksumCopy(arg_page, arg_blkno)
    })
}
pub unsafe fn PageSetChecksumInplace(arg_page: Page, arg_blkno: BlockNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageSetChecksumInplace(arg_page: Page, arg_blkno: BlockNumber);
        }
        PageSetChecksumInplace(arg_page, arg_blkno)
    })
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct HeapTupleFields {
    pub t_xmin: TransactionId,
    pub t_xmax: TransactionId,
    pub t_field3: HeapTupleFields__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleFields__bindgen_ty_1 {
    pub t_cid: CommandId,
    pub t_xvac: TransactionId,
}
impl Default for HeapTupleFields__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleFields {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct DatumTupleFields {
    pub datum_len_: int32,
    pub datum_typmod: int32,
    pub datum_typeid: Oid,
}
#[repr(C)]
pub struct HeapTupleHeaderData {
    pub t_choice: HeapTupleHeaderData__bindgen_ty_1,
    pub t_ctid: ItemPointerData,
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleHeaderData__bindgen_ty_1 {
    pub t_heap: HeapTupleFields,
    pub t_datum: DatumTupleFields,
}
impl Default for HeapTupleHeaderData__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleHeaderData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct MinimalTupleData {
    pub t_len: uint32,
    pub mt_padding: [::std::os::raw::c_char; 6usize],
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
pub unsafe fn heap_compute_data_size(
    arg_tupleDesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_compute_data_size(
                arg_tupleDesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> Size;
        }
        heap_compute_data_size(arg_tupleDesc, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_fill_tuple(
    arg_tupleDesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
    arg_data: *mut ::std::os::raw::c_char,
    arg_data_size: Size,
    arg_infomask: *mut uint16,
    arg_bit: *mut bits8,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_fill_tuple(
                arg_tupleDesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
                arg_data: *mut ::std::os::raw::c_char,
                arg_data_size: Size,
                arg_infomask: *mut uint16,
                arg_bit: *mut bits8,
            );
        }
        heap_fill_tuple(
            arg_tupleDesc,
            arg_values,
            arg_isnull,
            arg_data,
            arg_data_size,
            arg_infomask,
            arg_bit,
        )
    })
}
pub unsafe fn heap_attisnull(
    arg_tup: HeapTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_tupleDesc: TupleDesc,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_attisnull(
                arg_tup: HeapTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_tupleDesc: TupleDesc,
            ) -> bool;
        }
        heap_attisnull(arg_tup, arg_attnum, arg_tupleDesc)
    })
}
pub unsafe fn nocachegetattr(
    arg_tup: HeapTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_att: TupleDesc,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nocachegetattr(
                arg_tup: HeapTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_att: TupleDesc,
            ) -> Datum;
        }
        nocachegetattr(arg_tup, arg_attnum, arg_att)
    })
}
pub unsafe fn heap_getsysattr(
    arg_tup: HeapTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_tupleDesc: TupleDesc,
    arg_isnull: *mut bool,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_getsysattr(
                arg_tup: HeapTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_tupleDesc: TupleDesc,
                arg_isnull: *mut bool,
            ) -> Datum;
        }
        heap_getsysattr(arg_tup, arg_attnum, arg_tupleDesc, arg_isnull)
    })
}
pub unsafe fn getmissingattr(
    arg_tupleDesc: TupleDesc,
    arg_attnum: ::std::os::raw::c_int,
    arg_isnull: *mut bool,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getmissingattr(
                arg_tupleDesc: TupleDesc,
                arg_attnum: ::std::os::raw::c_int,
                arg_isnull: *mut bool,
            ) -> Datum;
        }
        getmissingattr(arg_tupleDesc, arg_attnum, arg_isnull)
    })
}
pub unsafe fn heap_copytuple(arg_tuple: HeapTuple) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copytuple(arg_tuple: HeapTuple) -> HeapTuple;
        }
        heap_copytuple(arg_tuple)
    })
}
pub unsafe fn heap_copytuple_with_tuple(arg_src: HeapTuple, arg_dest: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copytuple_with_tuple(arg_src: HeapTuple, arg_dest: HeapTuple);
        }
        heap_copytuple_with_tuple(arg_src, arg_dest)
    })
}
pub unsafe fn heap_copy_tuple_as_datum(arg_tuple: HeapTuple, arg_tupleDesc: TupleDesc) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copy_tuple_as_datum(arg_tuple: HeapTuple, arg_tupleDesc: TupleDesc) -> Datum;
        }
        heap_copy_tuple_as_datum(arg_tuple, arg_tupleDesc)
    })
}
pub unsafe fn heap_form_tuple(
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_form_tuple(
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> HeapTuple;
        }
        heap_form_tuple(arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_modify_tuple(
    arg_tuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
    arg_replValues: *mut Datum,
    arg_replIsnull: *mut bool,
    arg_doReplace: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_modify_tuple(
                arg_tuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
                arg_replValues: *mut Datum,
                arg_replIsnull: *mut bool,
                arg_doReplace: *mut bool,
            ) -> HeapTuple;
        }
        heap_modify_tuple(
            arg_tuple,
            arg_tupleDesc,
            arg_replValues,
            arg_replIsnull,
            arg_doReplace,
        )
    })
}
pub unsafe fn heap_modify_tuple_by_cols(
    arg_tuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
    arg_nCols: ::std::os::raw::c_int,
    arg_replCols: *mut ::std::os::raw::c_int,
    arg_replValues: *mut Datum,
    arg_replIsnull: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_modify_tuple_by_cols(
                arg_tuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
                arg_nCols: ::std::os::raw::c_int,
                arg_replCols: *mut ::std::os::raw::c_int,
                arg_replValues: *mut Datum,
                arg_replIsnull: *mut bool,
            ) -> HeapTuple;
        }
        heap_modify_tuple_by_cols(
            arg_tuple,
            arg_tupleDesc,
            arg_nCols,
            arg_replCols,
            arg_replValues,
            arg_replIsnull,
        )
    })
}
pub unsafe fn heap_deform_tuple(
    arg_tuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_deform_tuple(
                arg_tuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        heap_deform_tuple(arg_tuple, arg_tupleDesc, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_freetuple(arg_htup: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_freetuple(arg_htup: HeapTuple);
        }
        heap_freetuple(arg_htup)
    })
}
pub unsafe fn heap_form_minimal_tuple(
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_form_minimal_tuple(
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> MinimalTuple;
        }
        heap_form_minimal_tuple(arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_free_minimal_tuple(arg_mtup: MinimalTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_free_minimal_tuple(arg_mtup: MinimalTuple);
        }
        heap_free_minimal_tuple(arg_mtup)
    })
}
pub unsafe fn heap_copy_minimal_tuple(arg_mtup: MinimalTuple) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copy_minimal_tuple(arg_mtup: MinimalTuple) -> MinimalTuple;
        }
        heap_copy_minimal_tuple(arg_mtup)
    })
}
pub unsafe fn heap_tuple_from_minimal_tuple(arg_mtup: MinimalTuple) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_tuple_from_minimal_tuple(arg_mtup: MinimalTuple) -> HeapTuple;
        }
        heap_tuple_from_minimal_tuple(arg_mtup)
    })
}
pub unsafe fn minimal_tuple_from_heap_tuple(arg_htup: HeapTuple) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn minimal_tuple_from_heap_tuple(arg_htup: HeapTuple) -> MinimalTuple;
        }
        minimal_tuple_from_heap_tuple(arg_htup)
    })
}
pub unsafe fn heap_expand_tuple(arg_sourceTuple: HeapTuple, arg_tupleDesc: TupleDesc) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_expand_tuple(arg_sourceTuple: HeapTuple, arg_tupleDesc: TupleDesc)
                -> HeapTuple;
        }
        heap_expand_tuple(arg_sourceTuple, arg_tupleDesc)
    })
}
pub unsafe fn minimal_expand_tuple(
    arg_sourceTuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn minimal_expand_tuple(
                arg_sourceTuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
            ) -> MinimalTuple;
        }
        minimal_expand_tuple(arg_sourceTuple, arg_tupleDesc)
    })
}
pub type Buffer = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferAccessStrategyData {
    _unused: [u8; 0],
}
pub type BufferAccessStrategy = *mut BufferAccessStrategyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleTableSlot {
    pub type_: NodeTag,
    pub tts_flags: uint16,
    pub tts_nvalid: AttrNumber,
    pub tts_ops: *const TupleTableSlotOps,
    pub tts_tupleDescriptor: TupleDesc,
    pub tts_values: *mut Datum,
    pub tts_isnull: *mut bool,
    pub tts_mcxt: MemoryContext,
    pub tts_tid: ItemPointerData,
    pub tts_tableOid: Oid,
}
impl Default for TupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TupleTableSlotOps {
    pub base_slot_size: usize,
    pub init: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub release: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub clear: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub getsomeattrs: ::std::option::Option<
        unsafe extern "C" fn(slot: *mut TupleTableSlot, natts: ::std::os::raw::c_int),
    >,
    pub getsysattr: ::std::option::Option<
        unsafe extern "C" fn(
            slot: *mut TupleTableSlot,
            attnum: ::std::os::raw::c_int,
            isnull: *mut bool,
        ) -> Datum,
    >,
    pub materialize: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub copyslot: ::std::option::Option<
        unsafe extern "C" fn(dstslot: *mut TupleTableSlot, srcslot: *mut TupleTableSlot),
    >,
    pub get_heap_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> HeapTuple>,
    pub get_minimal_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> MinimalTuple>,
    pub copy_heap_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> HeapTuple>,
    pub copy_minimal_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> MinimalTuple>,
}
extern "C" {
    pub static TTSOpsVirtual: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsHeapTuple: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsMinimalTuple: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsBufferHeapTuple: TupleTableSlotOps;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VirtualTupleTableSlot {
    pub base: TupleTableSlot,
    pub data: *mut ::std::os::raw::c_char,
}
impl Default for VirtualTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleTableSlot {
    pub base: TupleTableSlot,
    pub tuple: HeapTuple,
    pub off: uint32,
    pub tupdata: HeapTupleData,
}
impl Default for HeapTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferHeapTupleTableSlot {
    pub base: HeapTupleTableSlot,
    pub buffer: Buffer,
}
impl Default for BufferHeapTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinimalTupleTableSlot {
    pub base: TupleTableSlot,
    pub tuple: HeapTuple,
    pub mintuple: MinimalTuple,
    pub minhdr: HeapTupleData,
    pub off: uint32,
}
impl Default for MinimalTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn MakeTupleTableSlot(
    arg_tupleDesc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MakeTupleTableSlot(
                arg_tupleDesc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        MakeTupleTableSlot(arg_tupleDesc, arg_tts_ops)
    })
}
pub unsafe fn ExecAllocTableSlot(
    arg_tupleTable: *mut *mut List,
    arg_desc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecAllocTableSlot(
                arg_tupleTable: *mut *mut List,
                arg_desc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        ExecAllocTableSlot(arg_tupleTable, arg_desc, arg_tts_ops)
    })
}
pub unsafe fn ExecResetTupleTable(arg_tupleTable: *mut List, arg_shouldFree: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecResetTupleTable(arg_tupleTable: *mut List, arg_shouldFree: bool);
        }
        ExecResetTupleTable(arg_tupleTable, arg_shouldFree)
    })
}
pub unsafe fn MakeSingleTupleTableSlot(
    arg_tupdesc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MakeSingleTupleTableSlot(
                arg_tupdesc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        MakeSingleTupleTableSlot(arg_tupdesc, arg_tts_ops)
    })
}
pub unsafe fn ExecDropSingleTupleTableSlot(arg_slot: *mut TupleTableSlot) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecDropSingleTupleTableSlot(arg_slot: *mut TupleTableSlot);
        }
        ExecDropSingleTupleTableSlot(arg_slot)
    })
}
pub unsafe fn ExecSetSlotDescriptor(arg_slot: *mut TupleTableSlot, arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecSetSlotDescriptor(arg_slot: *mut TupleTableSlot, arg_tupdesc: TupleDesc);
        }
        ExecSetSlotDescriptor(arg_slot, arg_tupdesc)
    })
}
pub unsafe fn ExecStoreHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            ) -> *mut TupleTableSlot;
        }
        ExecStoreHeapTuple(arg_tuple, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecForceStoreHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecForceStoreHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            );
        }
        ExecForceStoreHeapTuple(arg_tuple, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecStoreBufferHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_buffer: Buffer,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreBufferHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_buffer: Buffer,
            ) -> *mut TupleTableSlot;
        }
        ExecStoreBufferHeapTuple(arg_tuple, arg_slot, arg_buffer)
    })
}
pub unsafe fn ExecStorePinnedBufferHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_buffer: Buffer,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStorePinnedBufferHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_buffer: Buffer,
            ) -> *mut TupleTableSlot;
        }
        ExecStorePinnedBufferHeapTuple(arg_tuple, arg_slot, arg_buffer)
    })
}
pub unsafe fn ExecStoreMinimalTuple(
    arg_mtup: MinimalTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreMinimalTuple(
                arg_mtup: MinimalTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            ) -> *mut TupleTableSlot;
        }
        ExecStoreMinimalTuple(arg_mtup, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecForceStoreMinimalTuple(
    arg_mtup: MinimalTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecForceStoreMinimalTuple(
                arg_mtup: MinimalTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            );
        }
        ExecForceStoreMinimalTuple(arg_mtup, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecStoreVirtualTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreVirtualTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
        }
        ExecStoreVirtualTuple(arg_slot)
    })
}
pub unsafe fn ExecStoreAllNullTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreAllNullTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
        }
        ExecStoreAllNullTuple(arg_slot)
    })
}
pub unsafe fn ExecStoreHeapTupleDatum(arg_data: Datum, arg_slot: *mut TupleTableSlot) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreHeapTupleDatum(arg_data: Datum, arg_slot: *mut TupleTableSlot);
        }
        ExecStoreHeapTupleDatum(arg_data, arg_slot)
    })
}
pub unsafe fn ExecFetchSlotHeapTuple(
    arg_slot: *mut TupleTableSlot,
    arg_materialize: bool,
    arg_shouldFree: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFetchSlotHeapTuple(
                arg_slot: *mut TupleTableSlot,
                arg_materialize: bool,
                arg_shouldFree: *mut bool,
            ) -> HeapTuple;
        }
        ExecFetchSlotHeapTuple(arg_slot, arg_materialize, arg_shouldFree)
    })
}
pub unsafe fn ExecFetchSlotMinimalTuple(
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: *mut bool,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFetchSlotMinimalTuple(
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: *mut bool,
            ) -> MinimalTuple;
        }
        ExecFetchSlotMinimalTuple(arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecFetchSlotHeapTupleDatum(arg_slot: *mut TupleTableSlot) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFetchSlotHeapTupleDatum(arg_slot: *mut TupleTableSlot) -> Datum;
        }
        ExecFetchSlotHeapTupleDatum(arg_slot)
    })
}
pub unsafe fn slot_getmissingattrs(
    arg_slot: *mut TupleTableSlot,
    arg_startAttNum: ::std::os::raw::c_int,
    arg_lastAttNum: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn slot_getmissingattrs(
                arg_slot: *mut TupleTableSlot,
                arg_startAttNum: ::std::os::raw::c_int,
                arg_lastAttNum: ::std::os::raw::c_int,
            );
        }
        slot_getmissingattrs(arg_slot, arg_startAttNum, arg_lastAttNum)
    })
}
pub unsafe fn slot_getsomeattrs_int(
    arg_slot: *mut TupleTableSlot,
    arg_attnum: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn slot_getsomeattrs_int(
                arg_slot: *mut TupleTableSlot,
                arg_attnum: ::std::os::raw::c_int,
            );
        }
        slot_getsomeattrs_int(arg_slot, arg_attnum)
    })
}
pub type bitmapword = uint64;
pub type signedbitmapword = int64;
#[repr(C)]
#[derive(Debug, Default)]
pub struct Bitmapset {
    pub nwords: ::std::os::raw::c_int,
    pub words: __IncompleteArrayField<bitmapword>,
}
pub const BMS_Comparison_BMS_EQUAL: BMS_Comparison = 0;
pub const BMS_Comparison_BMS_SUBSET1: BMS_Comparison = 1;
pub const BMS_Comparison_BMS_SUBSET2: BMS_Comparison = 2;
pub const BMS_Comparison_BMS_DIFFERENT: BMS_Comparison = 3;
pub type BMS_Comparison = ::std::os::raw::c_uint;
pub const BMS_Membership_BMS_EMPTY_SET: BMS_Membership = 0;
pub const BMS_Membership_BMS_SINGLETON: BMS_Membership = 1;
pub const BMS_Membership_BMS_MULTIPLE: BMS_Membership = 2;
pub type BMS_Membership = ::std::os::raw::c_uint;
pub unsafe fn bms_copy(arg_a: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_copy(arg_a: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_copy(arg_a)
    })
}
pub unsafe fn bms_equal(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_equal(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_equal(arg_a, arg_b)
    })
}
pub unsafe fn bms_compare(
    arg_a: *const Bitmapset,
    arg_b: *const Bitmapset,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_compare(
                arg_a: *const Bitmapset,
                arg_b: *const Bitmapset,
            ) -> ::std::os::raw::c_int;
        }
        bms_compare(arg_a, arg_b)
    })
}
pub unsafe fn bms_make_singleton(arg_x: ::std::os::raw::c_int) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_make_singleton(arg_x: ::std::os::raw::c_int) -> *mut Bitmapset;
        }
        bms_make_singleton(arg_x)
    })
}
pub unsafe fn bms_free(arg_a: *mut Bitmapset) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_free(arg_a: *mut Bitmapset);
        }
        bms_free(arg_a)
    })
}
pub unsafe fn bms_union(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_union(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_union(arg_a, arg_b)
    })
}
pub unsafe fn bms_intersect(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_intersect(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_intersect(arg_a, arg_b)
    })
}
pub unsafe fn bms_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_difference(arg_a, arg_b)
    })
}
pub unsafe fn bms_is_subset(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_is_subset(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_is_subset(arg_a, arg_b)
    })
}
pub unsafe fn bms_subset_compare(
    arg_a: *const Bitmapset,
    arg_b: *const Bitmapset,
) -> BMS_Comparison {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_subset_compare(
                arg_a: *const Bitmapset,
                arg_b: *const Bitmapset,
            ) -> BMS_Comparison;
        }
        bms_subset_compare(arg_a, arg_b)
    })
}
pub unsafe fn bms_is_member(arg_x: ::std::os::raw::c_int, arg_a: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_is_member(arg_x: ::std::os::raw::c_int, arg_a: *const Bitmapset) -> bool;
        }
        bms_is_member(arg_x, arg_a)
    })
}
pub unsafe fn bms_member_index(
    arg_a: *mut Bitmapset,
    arg_x: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_member_index(
                arg_a: *mut Bitmapset,
                arg_x: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        bms_member_index(arg_a, arg_x)
    })
}
pub unsafe fn bms_overlap(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_overlap(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_overlap(arg_a, arg_b)
    })
}
pub unsafe fn bms_overlap_list(arg_a: *const Bitmapset, arg_b: *const List) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_overlap_list(arg_a: *const Bitmapset, arg_b: *const List) -> bool;
        }
        bms_overlap_list(arg_a, arg_b)
    })
}
pub unsafe fn bms_nonempty_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_nonempty_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_nonempty_difference(arg_a, arg_b)
    })
}
pub unsafe fn bms_singleton_member(arg_a: *const Bitmapset) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_singleton_member(arg_a: *const Bitmapset) -> ::std::os::raw::c_int;
        }
        bms_singleton_member(arg_a)
    })
}
pub unsafe fn bms_get_singleton_member(
    arg_a: *const Bitmapset,
    arg_member: *mut ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_get_singleton_member(
                arg_a: *const Bitmapset,
                arg_member: *mut ::std::os::raw::c_int,
            ) -> bool;
        }
        bms_get_singleton_member(arg_a, arg_member)
    })
}
pub unsafe fn bms_num_members(arg_a: *const Bitmapset) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_num_members(arg_a: *const Bitmapset) -> ::std::os::raw::c_int;
        }
        bms_num_members(arg_a)
    })
}
pub unsafe fn bms_membership(arg_a: *const Bitmapset) -> BMS_Membership {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_membership(arg_a: *const Bitmapset) -> BMS_Membership;
        }
        bms_membership(arg_a)
    })
}
pub unsafe fn bms_is_empty(arg_a: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_is_empty(arg_a: *const Bitmapset) -> bool;
        }
        bms_is_empty(arg_a)
    })
}
pub unsafe fn bms_add_member(
    arg_a: *mut Bitmapset,
    arg_x: ::std::os::raw::c_int,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_add_member(
                arg_a: *mut Bitmapset,
                arg_x: ::std::os::raw::c_int,
            ) -> *mut Bitmapset;
        }
        bms_add_member(arg_a, arg_x)
    })
}
pub unsafe fn bms_del_member(
    arg_a: *mut Bitmapset,
    arg_x: ::std::os::raw::c_int,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_del_member(
                arg_a: *mut Bitmapset,
                arg_x: ::std::os::raw::c_int,
            ) -> *mut Bitmapset;
        }
        bms_del_member(arg_a, arg_x)
    })
}
pub unsafe fn bms_add_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_add_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_add_members(arg_a, arg_b)
    })
}
pub unsafe fn bms_add_range(
    arg_a: *mut Bitmapset,
    arg_lower: ::std::os::raw::c_int,
    arg_upper: ::std::os::raw::c_int,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_add_range(
                arg_a: *mut Bitmapset,
                arg_lower: ::std::os::raw::c_int,
                arg_upper: ::std::os::raw::c_int,
            ) -> *mut Bitmapset;
        }
        bms_add_range(arg_a, arg_lower, arg_upper)
    })
}
pub unsafe fn bms_int_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_int_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_int_members(arg_a, arg_b)
    })
}
pub unsafe fn bms_del_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_del_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_del_members(arg_a, arg_b)
    })
}
pub unsafe fn bms_join(arg_a: *mut Bitmapset, arg_b: *mut Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_join(arg_a: *mut Bitmapset, arg_b: *mut Bitmapset) -> *mut Bitmapset;
        }
        bms_join(arg_a, arg_b)
    })
}
pub unsafe fn bms_first_member(arg_a: *mut Bitmapset) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_first_member(arg_a: *mut Bitmapset) -> ::std::os::raw::c_int;
        }
        bms_first_member(arg_a)
    })
}
pub unsafe fn bms_next_member(
    arg_a: *const Bitmapset,
    arg_prevbit: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_next_member(
                arg_a: *const Bitmapset,
                arg_prevbit: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        bms_next_member(arg_a, arg_prevbit)
    })
}
pub unsafe fn bms_prev_member(
    arg_a: *const Bitmapset,
    arg_prevbit: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_prev_member(
                arg_a: *const Bitmapset,
                arg_prevbit: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        bms_prev_member(arg_a, arg_prevbit)
    })
}
pub unsafe fn bms_hash_value(arg_a: *const Bitmapset) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_hash_value(arg_a: *const Bitmapset) -> uint32;
        }
        bms_hash_value(arg_a)
    })
}
pub unsafe fn bitmap_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bitmap_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32;
        }
        bitmap_hash(arg_key, arg_keysize)
    })
}
pub unsafe fn bitmap_match(
    arg_key1: *const ::std::os::raw::c_void,
    arg_key2: *const ::std::os::raw::c_void,
    arg_keysize: Size,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bitmap_match(
                arg_key1: *const ::std::os::raw::c_void,
                arg_key2: *const ::std::os::raw::c_void,
                arg_keysize: Size,
            ) -> ::std::os::raw::c_int;
        }
        bitmap_match(arg_key1, arg_key2, arg_keysize)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConversionMap {
    pub indesc: TupleDesc,
    pub outdesc: TupleDesc,
    pub attrMap: *mut AttrMap,
    pub invalues: *mut Datum,
    pub inisnull: *mut bool,
    pub outvalues: *mut Datum,
    pub outisnull: *mut bool,
}
impl Default for TupleConversionMap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn convert_tuples_by_position(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
    arg_msg: *const ::std::os::raw::c_char,
) -> *mut TupleConversionMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn convert_tuples_by_position(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
                arg_msg: *const ::std::os::raw::c_char,
            ) -> *mut TupleConversionMap;
        }
        convert_tuples_by_position(arg_indesc, arg_outdesc, arg_msg)
    })
}
pub unsafe fn convert_tuples_by_name(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
) -> *mut TupleConversionMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn convert_tuples_by_name(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
            ) -> *mut TupleConversionMap;
        }
        convert_tuples_by_name(arg_indesc, arg_outdesc)
    })
}
pub unsafe fn execute_attr_map_tuple(
    arg_tuple: HeapTuple,
    arg_map: *mut TupleConversionMap,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execute_attr_map_tuple(
                arg_tuple: HeapTuple,
                arg_map: *mut TupleConversionMap,
            ) -> HeapTuple;
        }
        execute_attr_map_tuple(arg_tuple, arg_map)
    })
}
pub unsafe fn execute_attr_map_slot(
    arg_attrMap: *mut AttrMap,
    arg_in_slot: *mut TupleTableSlot,
    arg_out_slot: *mut TupleTableSlot,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execute_attr_map_slot(
                arg_attrMap: *mut AttrMap,
                arg_in_slot: *mut TupleTableSlot,
                arg_out_slot: *mut TupleTableSlot,
            ) -> *mut TupleTableSlot;
        }
        execute_attr_map_slot(arg_attrMap, arg_in_slot, arg_out_slot)
    })
}
pub unsafe fn execute_attr_map_cols(
    arg_attrMap: *mut AttrMap,
    arg_inbitmap: *mut Bitmapset,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execute_attr_map_cols(
                arg_attrMap: *mut AttrMap,
                arg_inbitmap: *mut Bitmapset,
            ) -> *mut Bitmapset;
        }
        execute_attr_map_cols(arg_attrMap, arg_inbitmap)
    })
}
pub unsafe fn free_conversion_map(arg_map: *mut TupleConversionMap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn free_conversion_map(arg_map: *mut TupleConversionMap);
        }
        free_conversion_map(arg_map)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *mut ::std::os::raw::c_char,
}
impl Default for tm {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut getdate_err: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
pub unsafe fn asctime(arg_arg1: *const tm) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asctime(arg_arg1: *const tm) -> *mut ::std::os::raw::c_char;
        }
        asctime(arg_arg1)
    })
}
pub unsafe fn clock() -> clock_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock() -> clock_t;
        }
        clock()
    })
}
pub unsafe fn ctime(arg_arg1: *const time_t) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ctime(arg_arg1: *const time_t) -> *mut ::std::os::raw::c_char;
        }
        ctime(arg_arg1)
    })
}
pub unsafe fn difftime(arg_arg1: time_t, arg_arg2: time_t) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn difftime(arg_arg1: time_t, arg_arg2: time_t) -> f64;
        }
        difftime(arg_arg1, arg_arg2)
    })
}
pub unsafe fn getdate(arg_arg1: *const ::std::os::raw::c_char) -> *mut tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getdate(arg_arg1: *const ::std::os::raw::c_char) -> *mut tm;
        }
        getdate(arg_arg1)
    })
}
pub unsafe fn gmtime(arg_arg1: *const time_t) -> *mut tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gmtime(arg_arg1: *const time_t) -> *mut tm;
        }
        gmtime(arg_arg1)
    })
}
pub unsafe fn localtime(arg_arg1: *const time_t) -> *mut tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn localtime(arg_arg1: *const time_t) -> *mut tm;
        }
        localtime(arg_arg1)
    })
}
pub unsafe fn mktime(arg_arg1: *mut tm) -> time_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mktime(arg_arg1: *mut tm) -> time_t;
        }
        mktime(arg_arg1)
    })
}
pub unsafe fn strftime(
    arg_arg1: *mut ::std::os::raw::c_char,
    arg_arg2: usize,
    arg_arg3: *const ::std::os::raw::c_char,
    arg_arg4: *const tm,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strftime(
                arg_arg1: *mut ::std::os::raw::c_char,
                arg_arg2: usize,
                arg_arg3: *const ::std::os::raw::c_char,
                arg_arg4: *const tm,
            ) -> usize;
        }
        strftime(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn strptime(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *const ::std::os::raw::c_char,
    arg_arg3: *mut tm,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strptime(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *const ::std::os::raw::c_char,
                arg_arg3: *mut tm,
            ) -> *mut ::std::os::raw::c_char;
        }
        strptime(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn time(arg_arg1: *mut time_t) -> time_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn time(arg_arg1: *mut time_t) -> time_t;
        }
        time(arg_arg1)
    })
}
pub unsafe fn tzset() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tzset();
        }
        tzset()
    })
}
pub unsafe fn asctime_r(
    arg_arg1: *const tm,
    arg_arg2: *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asctime_r(
                arg_arg1: *const tm,
                arg_arg2: *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        asctime_r(arg_arg1, arg_arg2)
    })
}
pub unsafe fn ctime_r(
    arg_arg1: *const time_t,
    arg_arg2: *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ctime_r(
                arg_arg1: *const time_t,
                arg_arg2: *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        ctime_r(arg_arg1, arg_arg2)
    })
}
pub unsafe fn gmtime_r(arg_arg1: *const time_t, arg_arg2: *mut tm) -> *mut tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gmtime_r(arg_arg1: *const time_t, arg_arg2: *mut tm) -> *mut tm;
        }
        gmtime_r(arg_arg1, arg_arg2)
    })
}
pub unsafe fn localtime_r(arg_arg1: *const time_t, arg_arg2: *mut tm) -> *mut tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn localtime_r(arg_arg1: *const time_t, arg_arg2: *mut tm) -> *mut tm;
        }
        localtime_r(arg_arg1, arg_arg2)
    })
}
pub unsafe fn posix2time(arg_arg1: time_t) -> time_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn posix2time(arg_arg1: time_t) -> time_t;
        }
        posix2time(arg_arg1)
    })
}
pub unsafe fn tzsetwall() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tzsetwall();
        }
        tzsetwall()
    })
}
pub unsafe fn time2posix(arg_arg1: time_t) -> time_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn time2posix(arg_arg1: time_t) -> time_t;
        }
        time2posix(arg_arg1)
    })
}
pub unsafe fn timelocal(arg_arg1: *mut tm) -> time_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timelocal(arg_arg1: *mut tm) -> time_t;
        }
        timelocal(arg_arg1)
    })
}
pub unsafe fn timegm(arg_arg1: *mut tm) -> time_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timegm(arg_arg1: *mut tm) -> time_t;
        }
        timegm(arg_arg1)
    })
}
pub unsafe fn nanosleep(
    arg___rqtp: *const timespec,
    arg___rmtp: *mut timespec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nanosleep(
                arg___rqtp: *const timespec,
                arg___rmtp: *mut timespec,
            ) -> ::std::os::raw::c_int;
        }
        nanosleep(arg___rqtp, arg___rmtp)
    })
}
pub const clockid_t__CLOCK_REALTIME: clockid_t = 0;
pub const clockid_t__CLOCK_MONOTONIC: clockid_t = 6;
pub const clockid_t__CLOCK_MONOTONIC_RAW: clockid_t = 4;
pub const clockid_t__CLOCK_MONOTONIC_RAW_APPROX: clockid_t = 5;
pub const clockid_t__CLOCK_UPTIME_RAW: clockid_t = 8;
pub const clockid_t__CLOCK_UPTIME_RAW_APPROX: clockid_t = 9;
pub const clockid_t__CLOCK_PROCESS_CPUTIME_ID: clockid_t = 12;
pub const clockid_t__CLOCK_THREAD_CPUTIME_ID: clockid_t = 16;
pub type clockid_t = ::std::os::raw::c_uint;
pub unsafe fn clock_getres(
    arg___clock_id: clockid_t,
    arg___res: *mut timespec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock_getres(
                arg___clock_id: clockid_t,
                arg___res: *mut timespec,
            ) -> ::std::os::raw::c_int;
        }
        clock_getres(arg___clock_id, arg___res)
    })
}
pub unsafe fn clock_gettime(
    arg___clock_id: clockid_t,
    arg___tp: *mut timespec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock_gettime(
                arg___clock_id: clockid_t,
                arg___tp: *mut timespec,
            ) -> ::std::os::raw::c_int;
        }
        clock_gettime(arg___clock_id, arg___tp)
    })
}
pub unsafe fn clock_gettime_nsec_np(arg___clock_id: clockid_t) -> __uint64_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock_gettime_nsec_np(arg___clock_id: clockid_t) -> __uint64_t;
        }
        clock_gettime_nsec_np(arg___clock_id)
    })
}
pub unsafe fn clock_settime(
    arg___clock_id: clockid_t,
    arg___tp: *const timespec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock_settime(
                arg___clock_id: clockid_t,
                arg___tp: *const timespec,
            ) -> ::std::os::raw::c_int;
        }
        clock_settime(arg___clock_id, arg___tp)
    })
}
pub unsafe fn timespec_get(
    arg_ts: *mut timespec,
    arg_base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timespec_get(
                arg_ts: *mut timespec,
                arg_base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        timespec_get(arg_ts, arg_base)
    })
}
pub type instr_time = timespec;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BufferUsage {
    pub shared_blks_hit: int64,
    pub shared_blks_read: int64,
    pub shared_blks_dirtied: int64,
    pub shared_blks_written: int64,
    pub local_blks_hit: int64,
    pub local_blks_read: int64,
    pub local_blks_dirtied: int64,
    pub local_blks_written: int64,
    pub temp_blks_read: int64,
    pub temp_blks_written: int64,
    pub blk_read_time: instr_time,
    pub blk_write_time: instr_time,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WalUsage {
    pub wal_records: int64,
    pub wal_fpi: int64,
    pub wal_bytes: uint64,
}
pub const InstrumentOption_INSTRUMENT_TIMER: InstrumentOption = 1;
pub const InstrumentOption_INSTRUMENT_BUFFERS: InstrumentOption = 2;
pub const InstrumentOption_INSTRUMENT_ROWS: InstrumentOption = 4;
pub const InstrumentOption_INSTRUMENT_WAL: InstrumentOption = 8;
pub const InstrumentOption_INSTRUMENT_ALL: InstrumentOption = 2147483647;
pub type InstrumentOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Instrumentation {
    pub need_timer: bool,
    pub need_bufusage: bool,
    pub need_walusage: bool,
    pub async_mode: bool,
    pub running: bool,
    pub starttime: instr_time,
    pub counter: instr_time,
    pub firsttuple: f64,
    pub tuplecount: f64,
    pub bufusage_start: BufferUsage,
    pub walusage_start: WalUsage,
    pub startup: f64,
    pub total: f64,
    pub ntuples: f64,
    pub ntuples2: f64,
    pub nloops: f64,
    pub nfiltered1: f64,
    pub nfiltered2: f64,
    pub bufusage: BufferUsage,
    pub walusage: WalUsage,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct WorkerInstrumentation {
    pub num_workers: ::std::os::raw::c_int,
    pub instrument: __IncompleteArrayField<Instrumentation>,
}
extern "C" {
    pub static mut pgBufferUsage: BufferUsage;
}
extern "C" {
    pub static mut pgWalUsage: WalUsage;
}
pub unsafe fn InstrAlloc(
    arg_n: ::std::os::raw::c_int,
    arg_instrument_options: ::std::os::raw::c_int,
    arg_async_mode: bool,
) -> *mut Instrumentation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrAlloc(
                arg_n: ::std::os::raw::c_int,
                arg_instrument_options: ::std::os::raw::c_int,
                arg_async_mode: bool,
            ) -> *mut Instrumentation;
        }
        InstrAlloc(arg_n, arg_instrument_options, arg_async_mode)
    })
}
pub unsafe fn InstrInit(
    arg_instr: *mut Instrumentation,
    arg_instrument_options: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrInit(
                arg_instr: *mut Instrumentation,
                arg_instrument_options: ::std::os::raw::c_int,
            );
        }
        InstrInit(arg_instr, arg_instrument_options)
    })
}
pub unsafe fn InstrStartNode(arg_instr: *mut Instrumentation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrStartNode(arg_instr: *mut Instrumentation);
        }
        InstrStartNode(arg_instr)
    })
}
pub unsafe fn InstrStopNode(arg_instr: *mut Instrumentation, arg_nTuples: f64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrStopNode(arg_instr: *mut Instrumentation, arg_nTuples: f64);
        }
        InstrStopNode(arg_instr, arg_nTuples)
    })
}
pub unsafe fn InstrUpdateTupleCount(arg_instr: *mut Instrumentation, arg_nTuples: f64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrUpdateTupleCount(arg_instr: *mut Instrumentation, arg_nTuples: f64);
        }
        InstrUpdateTupleCount(arg_instr, arg_nTuples)
    })
}
pub unsafe fn InstrEndLoop(arg_instr: *mut Instrumentation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrEndLoop(arg_instr: *mut Instrumentation);
        }
        InstrEndLoop(arg_instr)
    })
}
pub unsafe fn InstrAggNode(arg_dst: *mut Instrumentation, arg_add: *mut Instrumentation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrAggNode(arg_dst: *mut Instrumentation, arg_add: *mut Instrumentation);
        }
        InstrAggNode(arg_dst, arg_add)
    })
}
pub unsafe fn InstrStartParallelQuery() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrStartParallelQuery();
        }
        InstrStartParallelQuery()
    })
}
pub unsafe fn InstrEndParallelQuery(arg_bufusage: *mut BufferUsage, arg_walusage: *mut WalUsage) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrEndParallelQuery(arg_bufusage: *mut BufferUsage, arg_walusage: *mut WalUsage);
        }
        InstrEndParallelQuery(arg_bufusage, arg_walusage)
    })
}
pub unsafe fn InstrAccumParallelQuery(arg_bufusage: *mut BufferUsage, arg_walusage: *mut WalUsage) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrAccumParallelQuery(arg_bufusage: *mut BufferUsage, arg_walusage: *mut WalUsage);
        }
        InstrAccumParallelQuery(arg_bufusage, arg_walusage)
    })
}
pub unsafe fn BufferUsageAccumDiff(
    arg_dst: *mut BufferUsage,
    arg_add: *const BufferUsage,
    arg_sub: *const BufferUsage,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BufferUsageAccumDiff(
                arg_dst: *mut BufferUsage,
                arg_add: *const BufferUsage,
                arg_sub: *const BufferUsage,
            );
        }
        BufferUsageAccumDiff(arg_dst, arg_add, arg_sub)
    })
}
pub unsafe fn WalUsageAccumDiff(
    arg_dst: *mut WalUsage,
    arg_add: *const WalUsage,
    arg_sub: *const WalUsage,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn WalUsageAccumDiff(
                arg_dst: *mut WalUsage,
                arg_add: *const WalUsage,
                arg_sub: *const WalUsage,
            );
        }
        WalUsageAccumDiff(arg_dst, arg_add, arg_sub)
    })
}
pub type fmNodePtr = *mut Node;
pub type fmAggrefPtr = *mut Aggref;
pub type fmExprContextCallbackFunction = ::std::option::Option<unsafe extern "C" fn(arg: Datum)>;
pub type fmStringInfo = *mut StringInfoData;
pub type FunctionCallInfo = *mut FunctionCallInfoBaseData;
pub type PGFunction =
    ::std::option::Option<unsafe extern "C" fn(fcinfo: FunctionCallInfo) -> Datum>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FmgrInfo {
    pub fn_addr: PGFunction,
    pub fn_oid: Oid,
    pub fn_nargs: ::std::os::raw::c_short,
    pub fn_strict: bool,
    pub fn_retset: bool,
    pub fn_stats: ::std::os::raw::c_uchar,
    pub fn_extra: *mut ::std::os::raw::c_void,
    pub fn_mcxt: MemoryContext,
    pub fn_expr: fmNodePtr,
}
impl Default for FmgrInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct FunctionCallInfoBaseData {
    pub flinfo: *mut FmgrInfo,
    pub context: fmNodePtr,
    pub resultinfo: fmNodePtr,
    pub fncollation: Oid,
    pub isnull: bool,
    pub nargs: ::std::os::raw::c_short,
    pub args: __IncompleteArrayField<NullableDatum>,
}
impl Default for FunctionCallInfoBaseData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn fmgr_info(arg_functionId: Oid, arg_finfo: *mut FmgrInfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_info(arg_functionId: Oid, arg_finfo: *mut FmgrInfo);
        }
        fmgr_info(arg_functionId, arg_finfo)
    })
}
pub unsafe fn fmgr_info_cxt(
    arg_functionId: Oid,
    arg_finfo: *mut FmgrInfo,
    arg_mcxt: MemoryContext,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_info_cxt(
                arg_functionId: Oid,
                arg_finfo: *mut FmgrInfo,
                arg_mcxt: MemoryContext,
            );
        }
        fmgr_info_cxt(arg_functionId, arg_finfo, arg_mcxt)
    })
}
pub unsafe fn fmgr_info_copy(
    arg_dstinfo: *mut FmgrInfo,
    arg_srcinfo: *mut FmgrInfo,
    arg_destcxt: MemoryContext,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_info_copy(
                arg_dstinfo: *mut FmgrInfo,
                arg_srcinfo: *mut FmgrInfo,
                arg_destcxt: MemoryContext,
            );
        }
        fmgr_info_copy(arg_dstinfo, arg_srcinfo, arg_destcxt)
    })
}
pub unsafe fn fmgr_symbol(
    arg_functionId: Oid,
    arg_mod_: *mut *mut ::std::os::raw::c_char,
    arg_fn_: *mut *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_symbol(
                arg_functionId: Oid,
                arg_mod_: *mut *mut ::std::os::raw::c_char,
                arg_fn_: *mut *mut ::std::os::raw::c_char,
            );
        }
        fmgr_symbol(arg_functionId, arg_mod_, arg_fn_)
    })
}
pub unsafe fn pg_detoast_datum(arg_datum: *mut varlena) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum(arg_datum: *mut varlena) -> *mut varlena;
        }
        pg_detoast_datum(arg_datum)
    })
}
pub unsafe fn pg_detoast_datum_copy(arg_datum: *mut varlena) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum_copy(arg_datum: *mut varlena) -> *mut varlena;
        }
        pg_detoast_datum_copy(arg_datum)
    })
}
pub unsafe fn pg_detoast_datum_slice(
    arg_datum: *mut varlena,
    arg_first: int32,
    arg_count: int32,
) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum_slice(
                arg_datum: *mut varlena,
                arg_first: int32,
                arg_count: int32,
            ) -> *mut varlena;
        }
        pg_detoast_datum_slice(arg_datum, arg_first, arg_count)
    })
}
pub unsafe fn pg_detoast_datum_packed(arg_datum: *mut varlena) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum_packed(arg_datum: *mut varlena) -> *mut varlena;
        }
        pg_detoast_datum_packed(arg_datum)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_finfo_record {
    pub api_version: ::std::os::raw::c_int,
}
pub type PGFInfoFunction = ::std::option::Option<unsafe extern "C" fn() -> *const Pg_finfo_record>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_magic_struct {
    pub len: ::std::os::raw::c_int,
    pub version: ::std::os::raw::c_int,
    pub funcmaxargs: ::std::os::raw::c_int,
    pub indexmaxkeys: ::std::os::raw::c_int,
    pub namedatalen: ::std::os::raw::c_int,
    pub float8byval: ::std::os::raw::c_int,
}
pub type PGModuleMagicFunction =
    ::std::option::Option<unsafe extern "C" fn() -> *const Pg_magic_struct>;
pub unsafe fn DirectFunctionCall1Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall1Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        DirectFunctionCall1Coll(arg_func, arg_collation, arg_arg1)
    })
}
pub unsafe fn DirectFunctionCall2Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall2Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        DirectFunctionCall2Coll(arg_func, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn DirectFunctionCall3Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall3Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
            ) -> Datum;
        }
        DirectFunctionCall3Coll(arg_func, arg_collation, arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn DirectFunctionCall4Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall4Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
            ) -> Datum;
        }
        DirectFunctionCall4Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
        )
    })
}
pub unsafe fn DirectFunctionCall5Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall5Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
            ) -> Datum;
        }
        DirectFunctionCall5Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
        )
    })
}
pub unsafe fn DirectFunctionCall6Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall6Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
            ) -> Datum;
        }
        DirectFunctionCall6Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
        )
    })
}
pub unsafe fn DirectFunctionCall7Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall7Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
            ) -> Datum;
        }
        DirectFunctionCall7Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
        )
    })
}
pub unsafe fn DirectFunctionCall8Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall8Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
            ) -> Datum;
        }
        DirectFunctionCall8Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
        )
    })
}
pub unsafe fn DirectFunctionCall9Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
    arg_arg9: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall9Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
                arg_arg9: Datum,
            ) -> Datum;
        }
        DirectFunctionCall9Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
            arg_arg9,
        )
    })
}
pub unsafe fn CallerFInfoFunctionCall1(
    arg_func: PGFunction,
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CallerFInfoFunctionCall1(
                arg_func: PGFunction,
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        CallerFInfoFunctionCall1(arg_func, arg_flinfo, arg_collation, arg_arg1)
    })
}
pub unsafe fn CallerFInfoFunctionCall2(
    arg_func: PGFunction,
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CallerFInfoFunctionCall2(
                arg_func: PGFunction,
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        CallerFInfoFunctionCall2(arg_func, arg_flinfo, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn FunctionCall0Coll(arg_flinfo: *mut FmgrInfo, arg_collation: Oid) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall0Coll(arg_flinfo: *mut FmgrInfo, arg_collation: Oid) -> Datum;
        }
        FunctionCall0Coll(arg_flinfo, arg_collation)
    })
}
pub unsafe fn FunctionCall1Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall1Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        FunctionCall1Coll(arg_flinfo, arg_collation, arg_arg1)
    })
}
pub unsafe fn FunctionCall2Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall2Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        FunctionCall2Coll(arg_flinfo, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn FunctionCall3Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall3Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
            ) -> Datum;
        }
        FunctionCall3Coll(arg_flinfo, arg_collation, arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn FunctionCall4Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall4Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
            ) -> Datum;
        }
        FunctionCall4Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
        )
    })
}
pub unsafe fn FunctionCall5Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall5Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
            ) -> Datum;
        }
        FunctionCall5Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
        )
    })
}
pub unsafe fn FunctionCall6Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall6Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
            ) -> Datum;
        }
        FunctionCall6Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
        )
    })
}
pub unsafe fn FunctionCall7Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall7Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
            ) -> Datum;
        }
        FunctionCall7Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
        )
    })
}
pub unsafe fn FunctionCall8Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall8Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
            ) -> Datum;
        }
        FunctionCall8Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
        )
    })
}
pub unsafe fn FunctionCall9Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
    arg_arg9: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall9Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
                arg_arg9: Datum,
            ) -> Datum;
        }
        FunctionCall9Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
            arg_arg9,
        )
    })
}
pub unsafe fn OidFunctionCall0Coll(arg_functionId: Oid, arg_collation: Oid) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall0Coll(arg_functionId: Oid, arg_collation: Oid) -> Datum;
        }
        OidFunctionCall0Coll(arg_functionId, arg_collation)
    })
}
pub unsafe fn OidFunctionCall1Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall1Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        OidFunctionCall1Coll(arg_functionId, arg_collation, arg_arg1)
    })
}
pub unsafe fn OidFunctionCall2Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall2Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        OidFunctionCall2Coll(arg_functionId, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn OidFunctionCall3Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall3Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
            ) -> Datum;
        }
        OidFunctionCall3Coll(arg_functionId, arg_collation, arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn OidFunctionCall4Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall4Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
            ) -> Datum;
        }
        OidFunctionCall4Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
        )
    })
}
pub unsafe fn OidFunctionCall5Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall5Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
            ) -> Datum;
        }
        OidFunctionCall5Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
        )
    })
}
pub unsafe fn OidFunctionCall6Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall6Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
            ) -> Datum;
        }
        OidFunctionCall6Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
        )
    })
}
pub unsafe fn OidFunctionCall7Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall7Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
            ) -> Datum;
        }
        OidFunctionCall7Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
        )
    })
}
pub unsafe fn OidFunctionCall8Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall8Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
            ) -> Datum;
        }
        OidFunctionCall8Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
        )
    })
}
pub unsafe fn OidFunctionCall9Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
    arg_arg9: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall9Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
                arg_arg9: Datum,
            ) -> Datum;
        }
        OidFunctionCall9Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
            arg_arg9,
        )
    })
}
pub unsafe fn InputFunctionCall(
    arg_flinfo: *mut FmgrInfo,
    arg_str_: *mut ::std::os::raw::c_char,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InputFunctionCall(
                arg_flinfo: *mut FmgrInfo,
                arg_str_: *mut ::std::os::raw::c_char,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        InputFunctionCall(arg_flinfo, arg_str_, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn OidInputFunctionCall(
    arg_functionId: Oid,
    arg_str_: *mut ::std::os::raw::c_char,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidInputFunctionCall(
                arg_functionId: Oid,
                arg_str_: *mut ::std::os::raw::c_char,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        OidInputFunctionCall(arg_functionId, arg_str_, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn OutputFunctionCall(
    arg_flinfo: *mut FmgrInfo,
    arg_val: Datum,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OutputFunctionCall(
                arg_flinfo: *mut FmgrInfo,
                arg_val: Datum,
            ) -> *mut ::std::os::raw::c_char;
        }
        OutputFunctionCall(arg_flinfo, arg_val)
    })
}
pub unsafe fn OidOutputFunctionCall(
    arg_functionId: Oid,
    arg_val: Datum,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidOutputFunctionCall(
                arg_functionId: Oid,
                arg_val: Datum,
            ) -> *mut ::std::os::raw::c_char;
        }
        OidOutputFunctionCall(arg_functionId, arg_val)
    })
}
pub unsafe fn ReceiveFunctionCall(
    arg_flinfo: *mut FmgrInfo,
    arg_buf: fmStringInfo,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReceiveFunctionCall(
                arg_flinfo: *mut FmgrInfo,
                arg_buf: fmStringInfo,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        ReceiveFunctionCall(arg_flinfo, arg_buf, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn OidReceiveFunctionCall(
    arg_functionId: Oid,
    arg_buf: fmStringInfo,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidReceiveFunctionCall(
                arg_functionId: Oid,
                arg_buf: fmStringInfo,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        OidReceiveFunctionCall(arg_functionId, arg_buf, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn SendFunctionCall(arg_flinfo: *mut FmgrInfo, arg_val: Datum) -> *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SendFunctionCall(arg_flinfo: *mut FmgrInfo, arg_val: Datum) -> *mut bytea;
        }
        SendFunctionCall(arg_flinfo, arg_val)
    })
}
pub unsafe fn OidSendFunctionCall(arg_functionId: Oid, arg_val: Datum) -> *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidSendFunctionCall(arg_functionId: Oid, arg_val: Datum) -> *mut bytea;
        }
        OidSendFunctionCall(arg_functionId, arg_val)
    })
}
pub unsafe fn fetch_finfo_record(
    arg_filehandle: *mut ::std::os::raw::c_void,
    arg_funcname: *const ::std::os::raw::c_char,
) -> *const Pg_finfo_record {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fetch_finfo_record(
                arg_filehandle: *mut ::std::os::raw::c_void,
                arg_funcname: *const ::std::os::raw::c_char,
            ) -> *const Pg_finfo_record;
        }
        fetch_finfo_record(arg_filehandle, arg_funcname)
    })
}
pub unsafe fn clear_external_function_hash(arg_filehandle: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clear_external_function_hash(arg_filehandle: *mut ::std::os::raw::c_void);
        }
        clear_external_function_hash(arg_filehandle)
    })
}
pub unsafe fn fmgr_internal_function(arg_proname: *const ::std::os::raw::c_char) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_internal_function(arg_proname: *const ::std::os::raw::c_char) -> Oid;
        }
        fmgr_internal_function(arg_proname)
    })
}
pub unsafe fn get_fn_expr_rettype(arg_flinfo: *mut FmgrInfo) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_rettype(arg_flinfo: *mut FmgrInfo) -> Oid;
        }
        get_fn_expr_rettype(arg_flinfo)
    })
}
pub unsafe fn get_fn_expr_argtype(
    arg_flinfo: *mut FmgrInfo,
    arg_argnum: ::std::os::raw::c_int,
) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_argtype(
                arg_flinfo: *mut FmgrInfo,
                arg_argnum: ::std::os::raw::c_int,
            ) -> Oid;
        }
        get_fn_expr_argtype(arg_flinfo, arg_argnum)
    })
}
pub unsafe fn get_call_expr_argtype(arg_expr: fmNodePtr, arg_argnum: ::std::os::raw::c_int) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_call_expr_argtype(arg_expr: fmNodePtr, arg_argnum: ::std::os::raw::c_int)
                -> Oid;
        }
        get_call_expr_argtype(arg_expr, arg_argnum)
    })
}
pub unsafe fn get_fn_expr_arg_stable(
    arg_flinfo: *mut FmgrInfo,
    arg_argnum: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_arg_stable(
                arg_flinfo: *mut FmgrInfo,
                arg_argnum: ::std::os::raw::c_int,
            ) -> bool;
        }
        get_fn_expr_arg_stable(arg_flinfo, arg_argnum)
    })
}
pub unsafe fn get_call_expr_arg_stable(
    arg_expr: fmNodePtr,
    arg_argnum: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_call_expr_arg_stable(
                arg_expr: fmNodePtr,
                arg_argnum: ::std::os::raw::c_int,
            ) -> bool;
        }
        get_call_expr_arg_stable(arg_expr, arg_argnum)
    })
}
pub unsafe fn get_fn_expr_variadic(arg_flinfo: *mut FmgrInfo) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_variadic(arg_flinfo: *mut FmgrInfo) -> bool;
        }
        get_fn_expr_variadic(arg_flinfo)
    })
}
pub unsafe fn get_fn_opclass_options(arg_flinfo: *mut FmgrInfo) -> *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_opclass_options(arg_flinfo: *mut FmgrInfo) -> *mut bytea;
        }
        get_fn_opclass_options(arg_flinfo)
    })
}
pub unsafe fn has_fn_opclass_options(arg_flinfo: *mut FmgrInfo) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn has_fn_opclass_options(arg_flinfo: *mut FmgrInfo) -> bool;
        }
        has_fn_opclass_options(arg_flinfo)
    })
}
pub unsafe fn set_fn_opclass_options(arg_flinfo: *mut FmgrInfo, arg_options: *mut bytea) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_fn_opclass_options(arg_flinfo: *mut FmgrInfo, arg_options: *mut bytea);
        }
        set_fn_opclass_options(arg_flinfo, arg_options)
    })
}
pub unsafe fn CheckFunctionValidatorAccess(arg_validatorOid: Oid, arg_functionOid: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CheckFunctionValidatorAccess(arg_validatorOid: Oid, arg_functionOid: Oid) -> bool;
        }
        CheckFunctionValidatorAccess(arg_validatorOid, arg_functionOid)
    })
}
extern "C" {
    pub static mut Dynamic_library_path: *mut ::std::os::raw::c_char;
}
pub unsafe fn load_external_function(
    arg_filename: *const ::std::os::raw::c_char,
    arg_funcname: *const ::std::os::raw::c_char,
    arg_signalNotFound: bool,
    arg_filehandle: *mut *mut ::std::os::raw::c_void,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn load_external_function(
                arg_filename: *const ::std::os::raw::c_char,
                arg_funcname: *const ::std::os::raw::c_char,
                arg_signalNotFound: bool,
                arg_filehandle: *mut *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void;
        }
        load_external_function(
            arg_filename,
            arg_funcname,
            arg_signalNotFound,
            arg_filehandle,
        )
    })
}
pub unsafe fn lookup_external_function(
    arg_filehandle: *mut ::std::os::raw::c_void,
    arg_funcname: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lookup_external_function(
                arg_filehandle: *mut ::std::os::raw::c_void,
                arg_funcname: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_void;
        }
        lookup_external_function(arg_filehandle, arg_funcname)
    })
}
pub unsafe fn load_file(arg_filename: *const ::std::os::raw::c_char, arg_restricted: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn load_file(arg_filename: *const ::std::os::raw::c_char, arg_restricted: bool);
        }
        load_file(arg_filename, arg_restricted)
    })
}
pub unsafe fn find_rendezvous_variable(
    arg_varName: *const ::std::os::raw::c_char,
) -> *mut *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_rendezvous_variable(
                arg_varName: *const ::std::os::raw::c_char,
            ) -> *mut *mut ::std::os::raw::c_void;
        }
        find_rendezvous_variable(arg_varName)
    })
}
pub unsafe fn EstimateLibraryStateSpace() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EstimateLibraryStateSpace() -> Size;
        }
        EstimateLibraryStateSpace()
    })
}
pub unsafe fn SerializeLibraryState(
    arg_maxsize: Size,
    arg_start_address: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SerializeLibraryState(
                arg_maxsize: Size,
                arg_start_address: *mut ::std::os::raw::c_char,
            );
        }
        SerializeLibraryState(arg_maxsize, arg_start_address)
    })
}
pub unsafe fn RestoreLibraryState(arg_start_address: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RestoreLibraryState(arg_start_address: *mut ::std::os::raw::c_char);
        }
        RestoreLibraryState(arg_start_address)
    })
}
pub unsafe fn AggCheckCallContext(
    arg_fcinfo: FunctionCallInfo,
    arg_aggcontext: *mut MemoryContext,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggCheckCallContext(
                arg_fcinfo: FunctionCallInfo,
                arg_aggcontext: *mut MemoryContext,
            ) -> ::std::os::raw::c_int;
        }
        AggCheckCallContext(arg_fcinfo, arg_aggcontext)
    })
}
pub unsafe fn AggGetAggref(arg_fcinfo: FunctionCallInfo) -> fmAggrefPtr {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggGetAggref(arg_fcinfo: FunctionCallInfo) -> fmAggrefPtr;
        }
        AggGetAggref(arg_fcinfo)
    })
}
pub unsafe fn AggGetTempMemoryContext(arg_fcinfo: FunctionCallInfo) -> MemoryContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggGetTempMemoryContext(arg_fcinfo: FunctionCallInfo) -> MemoryContext;
        }
        AggGetTempMemoryContext(arg_fcinfo)
    })
}
pub unsafe fn AggStateIsShared(arg_fcinfo: FunctionCallInfo) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggStateIsShared(arg_fcinfo: FunctionCallInfo) -> bool;
        }
        AggStateIsShared(arg_fcinfo)
    })
}
pub unsafe fn AggRegisterCallback(
    arg_fcinfo: FunctionCallInfo,
    arg_func: fmExprContextCallbackFunction,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggRegisterCallback(
                arg_fcinfo: FunctionCallInfo,
                arg_func: fmExprContextCallbackFunction,
                arg_arg: Datum,
            );
        }
        AggRegisterCallback(arg_fcinfo, arg_func, arg_arg)
    })
}
pub const FmgrHookEventType_FHET_START: FmgrHookEventType = 0;
pub const FmgrHookEventType_FHET_END: FmgrHookEventType = 1;
pub const FmgrHookEventType_FHET_ABORT: FmgrHookEventType = 2;
pub type FmgrHookEventType = ::std::os::raw::c_uint;
pub type needs_fmgr_hook_type = ::std::option::Option<unsafe extern "C" fn(fn_oid: Oid) -> bool>;
pub type fmgr_hook_type = ::std::option::Option<
    unsafe extern "C" fn(event: FmgrHookEventType, flinfo: *mut FmgrInfo, arg: *mut Datum),
>;
extern "C" {
    pub static mut needs_fmgr_hook: needs_fmgr_hook_type;
}
extern "C" {
    pub static mut fmgr_hook: fmgr_hook_type;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_node {
    pub prev: *mut dlist_node,
    pub next: *mut dlist_node,
}
impl Default for dlist_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_head {
    pub head: dlist_node,
}
impl Default for dlist_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_iter {
    pub cur: *mut dlist_node,
    pub end: *mut dlist_node,
}
impl Default for dlist_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_mutable_iter {
    pub cur: *mut dlist_node,
    pub next: *mut dlist_node,
    pub end: *mut dlist_node,
}
impl Default for dlist_mutable_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_node {
    pub next: *mut slist_node,
}
impl Default for slist_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_head {
    pub head: slist_node,
}
impl Default for slist_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_iter {
    pub cur: *mut slist_node,
}
impl Default for slist_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_mutable_iter {
    pub cur: *mut slist_node,
    pub next: *mut slist_node,
    pub prev: *mut slist_node,
}
impl Default for slist_mutable_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn slist_delete(arg_head: *mut slist_head, arg_node: *mut slist_node) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn slist_delete(arg_head: *mut slist_head, arg_node: *mut slist_node);
        }
        slist_delete(arg_head, arg_node)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StringInfoData {
    pub data: *mut ::std::os::raw::c_char,
    pub len: ::std::os::raw::c_int,
    pub maxlen: ::std::os::raw::c_int,
    pub cursor: ::std::os::raw::c_int,
}
impl Default for StringInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type StringInfo = *mut StringInfoData;
pub unsafe fn makeStringInfo() -> StringInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeStringInfo() -> StringInfo;
        }
        makeStringInfo()
    })
}
pub unsafe fn initStringInfo(arg_str_: StringInfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn initStringInfo(arg_str_: StringInfo);
        }
        initStringInfo(arg_str_)
    })
}
pub unsafe fn resetStringInfo(arg_str_: StringInfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn resetStringInfo(arg_str_: StringInfo);
        }
        resetStringInfo(arg_str_)
    })
}
pub unsafe fn appendStringInfo(arg_str_: StringInfo, arg_fmt: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfo(arg_str_: StringInfo, arg_fmt: *const ::std::os::raw::c_char);
        }
        appendStringInfo(arg_str_, arg_fmt)
    })
}
pub unsafe fn appendStringInfoVA(
    arg_str_: StringInfo,
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: va_list,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoVA(
                arg_str_: StringInfo,
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: va_list,
            ) -> ::std::os::raw::c_int;
        }
        appendStringInfoVA(arg_str_, arg_fmt, arg_args)
    })
}
pub unsafe fn appendStringInfoString(arg_str_: StringInfo, arg_s: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoString(arg_str_: StringInfo, arg_s: *const ::std::os::raw::c_char);
        }
        appendStringInfoString(arg_str_, arg_s)
    })
}
pub unsafe fn appendStringInfoChar(arg_str_: StringInfo, arg_ch: ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoChar(arg_str_: StringInfo, arg_ch: ::std::os::raw::c_char);
        }
        appendStringInfoChar(arg_str_, arg_ch)
    })
}
pub unsafe fn appendStringInfoSpaces(arg_str_: StringInfo, arg_count: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoSpaces(arg_str_: StringInfo, arg_count: ::std::os::raw::c_int);
        }
        appendStringInfoSpaces(arg_str_, arg_count)
    })
}
pub unsafe fn appendBinaryStringInfo(
    arg_str_: StringInfo,
    arg_data: *const ::std::os::raw::c_char,
    arg_datalen: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendBinaryStringInfo(
                arg_str_: StringInfo,
                arg_data: *const ::std::os::raw::c_char,
                arg_datalen: ::std::os::raw::c_int,
            );
        }
        appendBinaryStringInfo(arg_str_, arg_data, arg_datalen)
    })
}
pub unsafe fn appendBinaryStringInfoNT(
    arg_str_: StringInfo,
    arg_data: *const ::std::os::raw::c_char,
    arg_datalen: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendBinaryStringInfoNT(
                arg_str_: StringInfo,
                arg_data: *const ::std::os::raw::c_char,
                arg_datalen: ::std::os::raw::c_int,
            );
        }
        appendBinaryStringInfoNT(arg_str_, arg_data, arg_datalen)
    })
}
pub unsafe fn enlargeStringInfo(arg_str_: StringInfo, arg_needed: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn enlargeStringInfo(arg_str_: StringInfo, arg_needed: ::std::os::raw::c_int);
        }
        enlargeStringInfo(arg_str_, arg_needed)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap_node {
    pub first_child: *mut pairingheap_node,
    pub next_sibling: *mut pairingheap_node,
    pub prev_or_parent: *mut pairingheap_node,
}
impl Default for pairingheap_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pairingheap_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const pairingheap_node,
        b: *const pairingheap_node,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap {
    pub ph_compare: pairingheap_comparator,
    pub ph_arg: *mut ::std::os::raw::c_void,
    pub ph_root: *mut pairingheap_node,
}
impl Default for pairingheap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn pairingheap_allocate(
    arg_compare: pairingheap_comparator,
    arg_arg: *mut ::std::os::raw::c_void,
) -> *mut pairingheap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_allocate(
                arg_compare: pairingheap_comparator,
                arg_arg: *mut ::std::os::raw::c_void,
            ) -> *mut pairingheap;
        }
        pairingheap_allocate(arg_compare, arg_arg)
    })
}
pub unsafe fn pairingheap_free(arg_heap: *mut pairingheap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_free(arg_heap: *mut pairingheap);
        }
        pairingheap_free(arg_heap)
    })
}
pub unsafe fn pairingheap_add(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_add(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node);
        }
        pairingheap_add(arg_heap, arg_node)
    })
}
pub unsafe fn pairingheap_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node;
        }
        pairingheap_first(arg_heap)
    })
}
pub unsafe fn pairingheap_remove_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_remove_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node;
        }
        pairingheap_remove_first(arg_heap)
    })
}
pub unsafe fn pairingheap_remove(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_remove(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node);
        }
        pairingheap_remove(arg_heap, arg_node)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ParamExternData {
    pub value: Datum,
    pub isnull: bool,
    pub pflags: uint16,
    pub ptype: Oid,
}
pub type ParamListInfo = *mut ParamListInfoData;
pub type ParamFetchHook = ::std::option::Option<
    unsafe extern "C" fn(
        params: ParamListInfo,
        paramid: ::std::os::raw::c_int,
        speculative: bool,
        workspace: *mut ParamExternData,
    ) -> *mut ParamExternData,
>;
pub type ParamCompileHook = ::std::option::Option<
    unsafe extern "C" fn(
        params: ParamListInfo,
        param: *mut Param,
        state: *mut ExprState,
        resv: *mut Datum,
        resnull: *mut bool,
    ),
>;
pub type ParserSetupHook = ::std::option::Option<
    unsafe extern "C" fn(pstate: *mut ParseState, arg: *mut ::std::os::raw::c_void),
>;
#[repr(C)]
#[derive(Debug)]
pub struct ParamListInfoData {
    pub paramFetch: ParamFetchHook,
    pub paramFetchArg: *mut ::std::os::raw::c_void,
    pub paramCompile: ParamCompileHook,
    pub paramCompileArg: *mut ::std::os::raw::c_void,
    pub parserSetup: ParserSetupHook,
    pub parserSetupArg: *mut ::std::os::raw::c_void,
    pub paramValuesStr: *mut ::std::os::raw::c_char,
    pub numParams: ::std::os::raw::c_int,
    pub params: __IncompleteArrayField<ParamExternData>,
}
impl Default for ParamListInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamExecData {
    pub execPlan: *mut ::std::os::raw::c_void,
    pub value: Datum,
    pub isnull: bool,
}
impl Default for ParamExecData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamsErrorCbData {
    pub portalName: *const ::std::os::raw::c_char,
    pub params: ParamListInfo,
}
impl Default for ParamsErrorCbData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn makeParamList(arg_numParams: ::std::os::raw::c_int) -> ParamListInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeParamList(arg_numParams: ::std::os::raw::c_int) -> ParamListInfo;
        }
        makeParamList(arg_numParams)
    })
}
pub unsafe fn copyParamList(arg_from: ParamListInfo) -> ParamListInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copyParamList(arg_from: ParamListInfo) -> ParamListInfo;
        }
        copyParamList(arg_from)
    })
}
pub unsafe fn EstimateParamListSpace(arg_paramLI: ParamListInfo) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EstimateParamListSpace(arg_paramLI: ParamListInfo) -> Size;
        }
        EstimateParamListSpace(arg_paramLI)
    })
}
pub unsafe fn SerializeParamList(
    arg_paramLI: ParamListInfo,
    arg_start_address: *mut *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SerializeParamList(
                arg_paramLI: ParamListInfo,
                arg_start_address: *mut *mut ::std::os::raw::c_char,
            );
        }
        SerializeParamList(arg_paramLI, arg_start_address)
    })
}
pub unsafe fn RestoreParamList(
    arg_start_address: *mut *mut ::std::os::raw::c_char,
) -> ParamListInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RestoreParamList(
                arg_start_address: *mut *mut ::std::os::raw::c_char,
            ) -> ParamListInfo;
        }
        RestoreParamList(arg_start_address)
    })
}
pub unsafe fn BuildParamLogString(
    arg_params: ParamListInfo,
    arg_paramTextValues: *mut *mut ::std::os::raw::c_char,
    arg_valueLen: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildParamLogString(
                arg_params: ParamListInfo,
                arg_paramTextValues: *mut *mut ::std::os::raw::c_char,
                arg_valueLen: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        BuildParamLogString(arg_params, arg_paramTextValues, arg_valueLen)
    })
}
pub unsafe fn ParamsErrorCallback(arg_arg: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ParamsErrorCallback(arg_arg: *mut ::std::os::raw::c_void);
        }
        ParamsErrorCallback(arg_arg)
    })
}
pub const ScanDirection_BackwardScanDirection: ScanDirection = -1;
pub const ScanDirection_NoMovementScanDirection: ScanDirection = 0;
pub const ScanDirection_ForwardScanDirection: ScanDirection = 1;
pub type ScanDirection = ::std::os::raw::c_int;
pub type StrategyNumber = uint16;
pub const LockClauseStrength_LCS_NONE: LockClauseStrength = 0;
pub const LockClauseStrength_LCS_FORKEYSHARE: LockClauseStrength = 1;
pub const LockClauseStrength_LCS_FORSHARE: LockClauseStrength = 2;
pub const LockClauseStrength_LCS_FORNOKEYUPDATE: LockClauseStrength = 3;
pub const LockClauseStrength_LCS_FORUPDATE: LockClauseStrength = 4;
pub type LockClauseStrength = ::std::os::raw::c_uint;
pub const LockWaitPolicy_LockWaitBlock: LockWaitPolicy = 0;
pub const LockWaitPolicy_LockWaitSkip: LockWaitPolicy = 1;
pub const LockWaitPolicy_LockWaitError: LockWaitPolicy = 2;
pub type LockWaitPolicy = ::std::os::raw::c_uint;
pub const LockTupleMode_LockTupleKeyShare: LockTupleMode = 0;
pub const LockTupleMode_LockTupleShare: LockTupleMode = 1;
pub const LockTupleMode_LockTupleNoKeyExclusive: LockTupleMode = 2;
pub const LockTupleMode_LockTupleExclusive: LockTupleMode = 3;
pub type LockTupleMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Alias {
    pub type_: NodeTag,
    pub aliasname: *mut ::std::os::raw::c_char,
    pub colnames: *mut List,
}
impl Default for Alias {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const OnCommitAction_ONCOMMIT_NOOP: OnCommitAction = 0;
pub const OnCommitAction_ONCOMMIT_PRESERVE_ROWS: OnCommitAction = 1;
pub const OnCommitAction_ONCOMMIT_DELETE_ROWS: OnCommitAction = 2;
pub const OnCommitAction_ONCOMMIT_DROP: OnCommitAction = 3;
pub type OnCommitAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeVar {
    pub type_: NodeTag,
    pub catalogname: *mut ::std::os::raw::c_char,
    pub schemaname: *mut ::std::os::raw::c_char,
    pub relname: *mut ::std::os::raw::c_char,
    pub inh: bool,
    pub relpersistence: ::std::os::raw::c_char,
    pub alias: *mut Alias,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeVar {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFunc {
    pub type_: NodeTag,
    pub ns_uris: *mut List,
    pub ns_names: *mut List,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub colnames: *mut List,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub notnulls: *mut Bitmapset,
    pub ordinalitycol: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for TableFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IntoClause {
    pub type_: NodeTag,
    pub rel: *mut RangeVar,
    pub colNames: *mut List,
    pub accessMethod: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub onCommit: OnCommitAction,
    pub tableSpaceName: *mut ::std::os::raw::c_char,
    pub viewQuery: *mut Node,
    pub skipData: bool,
}
impl Default for IntoClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Expr {
    pub type_: NodeTag,
}
impl Default for Expr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Var {
    pub xpr: Expr,
    pub varno: Index,
    pub varattno: AttrNumber,
    pub vartype: Oid,
    pub vartypmod: int32,
    pub varcollid: Oid,
    pub varlevelsup: Index,
    pub varnosyn: Index,
    pub varattnosyn: AttrNumber,
    pub location: ::std::os::raw::c_int,
}
impl Default for Var {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Const {
    pub xpr: Expr,
    pub consttype: Oid,
    pub consttypmod: int32,
    pub constcollid: Oid,
    pub constlen: ::std::os::raw::c_int,
    pub constvalue: Datum,
    pub constisnull: bool,
    pub constbyval: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for Const {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ParamKind_PARAM_EXTERN: ParamKind = 0;
pub const ParamKind_PARAM_EXEC: ParamKind = 1;
pub const ParamKind_PARAM_SUBLINK: ParamKind = 2;
pub const ParamKind_PARAM_MULTIEXPR: ParamKind = 3;
pub type ParamKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Param {
    pub xpr: Expr,
    pub paramkind: ParamKind,
    pub paramid: ::std::os::raw::c_int,
    pub paramtype: Oid,
    pub paramtypmod: int32,
    pub paramcollid: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for Param {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Aggref {
    pub xpr: Expr,
    pub aggfnoid: Oid,
    pub aggtype: Oid,
    pub aggcollid: Oid,
    pub inputcollid: Oid,
    pub aggtranstype: Oid,
    pub aggargtypes: *mut List,
    pub aggdirectargs: *mut List,
    pub args: *mut List,
    pub aggorder: *mut List,
    pub aggdistinct: *mut List,
    pub aggfilter: *mut Expr,
    pub aggstar: bool,
    pub aggvariadic: bool,
    pub aggkind: ::std::os::raw::c_char,
    pub agglevelsup: Index,
    pub aggsplit: AggSplit,
    pub aggno: ::std::os::raw::c_int,
    pub aggtransno: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for Aggref {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingFunc {
    pub xpr: Expr,
    pub args: *mut List,
    pub refs: *mut List,
    pub cols: *mut List,
    pub agglevelsup: Index,
    pub location: ::std::os::raw::c_int,
}
impl Default for GroupingFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFunc {
    pub xpr: Expr,
    pub winfnoid: Oid,
    pub wintype: Oid,
    pub wincollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub aggfilter: *mut Expr,
    pub winref: Index,
    pub winstar: bool,
    pub winagg: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for WindowFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubscriptingRef {
    pub xpr: Expr,
    pub refcontainertype: Oid,
    pub refelemtype: Oid,
    pub refrestype: Oid,
    pub reftypmod: int32,
    pub refcollid: Oid,
    pub refupperindexpr: *mut List,
    pub reflowerindexpr: *mut List,
    pub refexpr: *mut Expr,
    pub refassgnexpr: *mut Expr,
}
impl Default for SubscriptingRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CoercionContext_COERCION_IMPLICIT: CoercionContext = 0;
pub const CoercionContext_COERCION_ASSIGNMENT: CoercionContext = 1;
pub const CoercionContext_COERCION_PLPGSQL: CoercionContext = 2;
pub const CoercionContext_COERCION_EXPLICIT: CoercionContext = 3;
pub type CoercionContext = ::std::os::raw::c_uint;
pub const CoercionForm_COERCE_EXPLICIT_CALL: CoercionForm = 0;
pub const CoercionForm_COERCE_EXPLICIT_CAST: CoercionForm = 1;
pub const CoercionForm_COERCE_IMPLICIT_CAST: CoercionForm = 2;
pub const CoercionForm_COERCE_SQL_SYNTAX: CoercionForm = 3;
pub type CoercionForm = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncExpr {
    pub xpr: Expr,
    pub funcid: Oid,
    pub funcresulttype: Oid,
    pub funcretset: bool,
    pub funcvariadic: bool,
    pub funcformat: CoercionForm,
    pub funccollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for FuncExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedArgExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub name: *mut ::std::os::raw::c_char,
    pub argnumber: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for NamedArgExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub opresulttype: Oid,
    pub opretset: bool,
    pub opcollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for OpExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type DistinctExpr = OpExpr;
pub type NullIfExpr = OpExpr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScalarArrayOpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub hashfuncid: Oid,
    pub useOr: bool,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ScalarArrayOpExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BoolExprType_AND_EXPR: BoolExprType = 0;
pub const BoolExprType_OR_EXPR: BoolExprType = 1;
pub const BoolExprType_NOT_EXPR: BoolExprType = 2;
pub type BoolExprType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BoolExpr {
    pub xpr: Expr,
    pub boolop: BoolExprType,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for BoolExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SubLinkType_EXISTS_SUBLINK: SubLinkType = 0;
pub const SubLinkType_ALL_SUBLINK: SubLinkType = 1;
pub const SubLinkType_ANY_SUBLINK: SubLinkType = 2;
pub const SubLinkType_ROWCOMPARE_SUBLINK: SubLinkType = 3;
pub const SubLinkType_EXPR_SUBLINK: SubLinkType = 4;
pub const SubLinkType_MULTIEXPR_SUBLINK: SubLinkType = 5;
pub const SubLinkType_ARRAY_SUBLINK: SubLinkType = 6;
pub const SubLinkType_CTE_SUBLINK: SubLinkType = 7;
pub type SubLinkType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubLink {
    pub xpr: Expr,
    pub subLinkType: SubLinkType,
    pub subLinkId: ::std::os::raw::c_int,
    pub testexpr: *mut Node,
    pub operName: *mut List,
    pub subselect: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for SubLink {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlan {
    pub xpr: Expr,
    pub subLinkType: SubLinkType,
    pub testexpr: *mut Node,
    pub paramIds: *mut List,
    pub plan_id: ::std::os::raw::c_int,
    pub plan_name: *mut ::std::os::raw::c_char,
    pub firstColType: Oid,
    pub firstColTypmod: int32,
    pub firstColCollation: Oid,
    pub useHashTable: bool,
    pub unknownEqFalse: bool,
    pub parallel_safe: bool,
    pub setParam: *mut List,
    pub parParam: *mut List,
    pub args: *mut List,
    pub startup_cost: Cost,
    pub per_call_cost: Cost,
}
impl Default for SubPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlternativeSubPlan {
    pub xpr: Expr,
    pub subplans: *mut List,
}
impl Default for AlternativeSubPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldSelect {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub fieldnum: AttrNumber,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
}
impl Default for FieldSelect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldStore {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub newvals: *mut List,
    pub fieldnums: *mut List,
    pub resulttype: Oid,
}
impl Default for FieldStore {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelabelType {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub relabelformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for RelabelType {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceViaIO {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceViaIO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayCoerceExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub elemexpr: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for ArrayCoerceExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConvertRowtypeExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub convertformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for ConvertRowtypeExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub collOid: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for CollateExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseExpr {
    pub xpr: Expr,
    pub casetype: Oid,
    pub casecollid: Oid,
    pub arg: *mut Expr,
    pub args: *mut List,
    pub defresult: *mut Expr,
    pub location: ::std::os::raw::c_int,
}
impl Default for CaseExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseWhen {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub result: *mut Expr,
    pub location: ::std::os::raw::c_int,
}
impl Default for CaseWhen {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseTestExpr {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
}
impl Default for CaseTestExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayExpr {
    pub xpr: Expr,
    pub array_typeid: Oid,
    pub array_collid: Oid,
    pub element_typeid: Oid,
    pub elements: *mut List,
    pub multidims: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for ArrayExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowExpr {
    pub xpr: Expr,
    pub args: *mut List,
    pub row_typeid: Oid,
    pub row_format: CoercionForm,
    pub colnames: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for RowExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RowCompareType_ROWCOMPARE_LT: RowCompareType = 1;
pub const RowCompareType_ROWCOMPARE_LE: RowCompareType = 2;
pub const RowCompareType_ROWCOMPARE_EQ: RowCompareType = 3;
pub const RowCompareType_ROWCOMPARE_GE: RowCompareType = 4;
pub const RowCompareType_ROWCOMPARE_GT: RowCompareType = 5;
pub const RowCompareType_ROWCOMPARE_NE: RowCompareType = 6;
pub type RowCompareType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowCompareExpr {
    pub xpr: Expr,
    pub rctype: RowCompareType,
    pub opnos: *mut List,
    pub opfamilies: *mut List,
    pub inputcollids: *mut List,
    pub largs: *mut List,
    pub rargs: *mut List,
}
impl Default for RowCompareExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoalesceExpr {
    pub xpr: Expr,
    pub coalescetype: Oid,
    pub coalescecollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoalesceExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const MinMaxOp_IS_GREATEST: MinMaxOp = 0;
pub const MinMaxOp_IS_LEAST: MinMaxOp = 1;
pub type MinMaxOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinMaxExpr {
    pub xpr: Expr,
    pub minmaxtype: Oid,
    pub minmaxcollid: Oid,
    pub inputcollid: Oid,
    pub op: MinMaxOp,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for MinMaxExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SQLValueFunctionOp_SVFOP_CURRENT_DATE: SQLValueFunctionOp = 0;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIME: SQLValueFunctionOp = 1;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIME_N: SQLValueFunctionOp = 2;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIMESTAMP: SQLValueFunctionOp = 3;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIMESTAMP_N: SQLValueFunctionOp = 4;
pub const SQLValueFunctionOp_SVFOP_LOCALTIME: SQLValueFunctionOp = 5;
pub const SQLValueFunctionOp_SVFOP_LOCALTIME_N: SQLValueFunctionOp = 6;
pub const SQLValueFunctionOp_SVFOP_LOCALTIMESTAMP: SQLValueFunctionOp = 7;
pub const SQLValueFunctionOp_SVFOP_LOCALTIMESTAMP_N: SQLValueFunctionOp = 8;
pub const SQLValueFunctionOp_SVFOP_CURRENT_ROLE: SQLValueFunctionOp = 9;
pub const SQLValueFunctionOp_SVFOP_CURRENT_USER: SQLValueFunctionOp = 10;
pub const SQLValueFunctionOp_SVFOP_USER: SQLValueFunctionOp = 11;
pub const SQLValueFunctionOp_SVFOP_SESSION_USER: SQLValueFunctionOp = 12;
pub const SQLValueFunctionOp_SVFOP_CURRENT_CATALOG: SQLValueFunctionOp = 13;
pub const SQLValueFunctionOp_SVFOP_CURRENT_SCHEMA: SQLValueFunctionOp = 14;
pub type SQLValueFunctionOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SQLValueFunction {
    pub xpr: Expr,
    pub op: SQLValueFunctionOp,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::std::os::raw::c_int,
}
impl Default for SQLValueFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const XmlExprOp_IS_XMLCONCAT: XmlExprOp = 0;
pub const XmlExprOp_IS_XMLELEMENT: XmlExprOp = 1;
pub const XmlExprOp_IS_XMLFOREST: XmlExprOp = 2;
pub const XmlExprOp_IS_XMLPARSE: XmlExprOp = 3;
pub const XmlExprOp_IS_XMLPI: XmlExprOp = 4;
pub const XmlExprOp_IS_XMLROOT: XmlExprOp = 5;
pub const XmlExprOp_IS_XMLSERIALIZE: XmlExprOp = 6;
pub const XmlExprOp_IS_DOCUMENT: XmlExprOp = 7;
pub type XmlExprOp = ::std::os::raw::c_uint;
pub const XmlOptionType_XMLOPTION_DOCUMENT: XmlOptionType = 0;
pub const XmlOptionType_XMLOPTION_CONTENT: XmlOptionType = 1;
pub type XmlOptionType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlExpr {
    pub xpr: Expr,
    pub op: XmlExprOp,
    pub name: *mut ::std::os::raw::c_char,
    pub named_args: *mut List,
    pub arg_names: *mut List,
    pub args: *mut List,
    pub xmloption: XmlOptionType,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::std::os::raw::c_int,
}
impl Default for XmlExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const NullTestType_IS_NULL: NullTestType = 0;
pub const NullTestType_IS_NOT_NULL: NullTestType = 1;
pub type NullTestType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NullTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub nulltesttype: NullTestType,
    pub argisrow: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for NullTest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BoolTestType_IS_TRUE: BoolTestType = 0;
pub const BoolTestType_IS_NOT_TRUE: BoolTestType = 1;
pub const BoolTestType_IS_FALSE: BoolTestType = 2;
pub const BoolTestType_IS_NOT_FALSE: BoolTestType = 3;
pub const BoolTestType_IS_UNKNOWN: BoolTestType = 4;
pub const BoolTestType_IS_NOT_UNKNOWN: BoolTestType = 5;
pub type BoolTestType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BooleanTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub booltesttype: BoolTestType,
    pub location: ::std::os::raw::c_int,
}
impl Default for BooleanTest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomain {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coercionformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceToDomain {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomainValue {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceToDomainValue {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetToDefault {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for SetToDefault {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CurrentOfExpr {
    pub xpr: Expr,
    pub cvarno: Index,
    pub cursor_name: *mut ::std::os::raw::c_char,
    pub cursor_param: ::std::os::raw::c_int,
}
impl Default for CurrentOfExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NextValueExpr {
    pub xpr: Expr,
    pub seqid: Oid,
    pub typeId: Oid,
}
impl Default for NextValueExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferenceElem {
    pub xpr: Expr,
    pub expr: *mut Node,
    pub infercollid: Oid,
    pub inferopclass: Oid,
}
impl Default for InferenceElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TargetEntry {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub resno: AttrNumber,
    pub resname: *mut ::std::os::raw::c_char,
    pub ressortgroupref: Index,
    pub resorigtbl: Oid,
    pub resorigcol: AttrNumber,
    pub resjunk: bool,
}
impl Default for TargetEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblRef {
    pub type_: NodeTag,
    pub rtindex: ::std::os::raw::c_int,
}
impl Default for RangeTblRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinExpr {
    pub type_: NodeTag,
    pub jointype: JoinType,
    pub isNatural: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub usingClause: *mut List,
    pub join_using_alias: *mut Alias,
    pub quals: *mut Node,
    pub alias: *mut Alias,
    pub rtindex: ::std::os::raw::c_int,
}
impl Default for JoinExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FromExpr {
    pub type_: NodeTag,
    pub fromlist: *mut List,
    pub quals: *mut Node,
}
impl Default for FromExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictExpr {
    pub type_: NodeTag,
    pub action: OnConflictAction,
    pub arbiterElems: *mut List,
    pub arbiterWhere: *mut Node,
    pub constraint: Oid,
    pub onConflictSet: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelIndex: ::std::os::raw::c_int,
    pub exclRelTlist: *mut List,
}
impl Default for OnConflictExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlannedStmt {
    pub type_: NodeTag,
    pub commandType: CmdType,
    pub queryId: uint64,
    pub hasReturning: bool,
    pub hasModifyingCTE: bool,
    pub canSetTag: bool,
    pub transientPlan: bool,
    pub dependsOnRole: bool,
    pub parallelModeNeeded: bool,
    pub jitFlags: ::std::os::raw::c_int,
    pub planTree: *mut Plan,
    pub rtable: *mut List,
    pub resultRelations: *mut List,
    pub appendRelations: *mut List,
    pub subplans: *mut List,
    pub rewindPlanIDs: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub relationOids: *mut List,
    pub invalItems: *mut List,
    pub paramExecTypes: *mut List,
    pub utilityStmt: *mut Node,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for PlannedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Plan {
    pub type_: NodeTag,
    pub startup_cost: Cost,
    pub total_cost: Cost,
    pub plan_rows: f64,
    pub plan_width: ::std::os::raw::c_int,
    pub parallel_aware: bool,
    pub parallel_safe: bool,
    pub async_capable: bool,
    pub plan_node_id: ::std::os::raw::c_int,
    pub targetlist: *mut List,
    pub qual: *mut List,
    pub lefttree: *mut Plan,
    pub righttree: *mut Plan,
    pub initPlan: *mut List,
    pub extParam: *mut Bitmapset,
    pub allParam: *mut Bitmapset,
}
impl Default for Plan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Result {
    pub plan: Plan,
    pub resconstantqual: *mut Node,
}
impl Default for Result {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSet {
    pub plan: Plan,
}
impl Default for ProjectSet {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTable {
    pub plan: Plan,
    pub operation: CmdType,
    pub canSetTag: bool,
    pub nominalRelation: Index,
    pub rootRelation: Index,
    pub partColsUpdated: bool,
    pub resultRelations: *mut List,
    pub updateColnosLists: *mut List,
    pub withCheckOptionLists: *mut List,
    pub returningLists: *mut List,
    pub fdwPrivLists: *mut List,
    pub fdwDirectModifyPlans: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
    pub onConflictAction: OnConflictAction,
    pub arbiterIndexes: *mut List,
    pub onConflictSet: *mut List,
    pub onConflictCols: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelRTI: Index,
    pub exclRelTlist: *mut List,
}
impl Default for ModifyTable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Append {
    pub plan: Plan,
    pub apprelids: *mut Bitmapset,
    pub appendplans: *mut List,
    pub nasyncplans: ::std::os::raw::c_int,
    pub first_partial_plan: ::std::os::raw::c_int,
    pub part_prune_info: *mut PartitionPruneInfo,
}
impl Default for Append {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppend {
    pub plan: Plan,
    pub apprelids: *mut Bitmapset,
    pub mergeplans: *mut List,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
    pub part_prune_info: *mut PartitionPruneInfo,
}
impl Default for MergeAppend {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnion {
    pub plan: Plan,
    pub wtParam: ::std::os::raw::c_int,
    pub numCols: ::std::os::raw::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub dupCollations: *mut Oid,
    pub numGroups: ::std::os::raw::c_long,
}
impl Default for RecursiveUnion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAnd {
    pub plan: Plan,
    pub bitmapplans: *mut List,
}
impl Default for BitmapAnd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOr {
    pub plan: Plan,
    pub isshared: bool,
    pub bitmapplans: *mut List,
}
impl Default for BitmapOr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Scan {
    pub plan: Plan,
    pub scanrelid: Index,
}
impl Default for Scan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SeqScan = Scan;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScan {
    pub scan: Scan,
    pub tablesample: *mut TableSampleClause,
}
impl Default for SampleScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
    pub indexorderby: *mut List,
    pub indexorderbyorig: *mut List,
    pub indexorderbyops: *mut List,
    pub indexorderdir: ScanDirection,
}
impl Default for IndexScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexorderby: *mut List,
    pub indextlist: *mut List,
    pub indexorderdir: ScanDirection,
}
impl Default for IndexOnlyScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub isshared: bool,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
}
impl Default for BitmapIndexScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScan {
    pub scan: Scan,
    pub bitmapqualorig: *mut List,
}
impl Default for BitmapHeapScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScan {
    pub scan: Scan,
    pub tidquals: *mut List,
}
impl Default for TidScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidRangeScan {
    pub scan: Scan,
    pub tidrangequals: *mut List,
}
impl Default for TidRangeScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScan {
    pub scan: Scan,
    pub subplan: *mut Plan,
}
impl Default for SubqueryScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScan {
    pub scan: Scan,
    pub functions: *mut List,
    pub funcordinality: bool,
}
impl Default for FunctionScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScan {
    pub scan: Scan,
    pub values_lists: *mut List,
}
impl Default for ValuesScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScan {
    pub scan: Scan,
    pub tablefunc: *mut TableFunc,
}
impl Default for TableFuncScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScan {
    pub scan: Scan,
    pub ctePlanId: ::std::os::raw::c_int,
    pub cteParam: ::std::os::raw::c_int,
}
impl Default for CteScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScan {
    pub scan: Scan,
    pub enrname: *mut ::std::os::raw::c_char,
}
impl Default for NamedTuplestoreScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScan {
    pub scan: Scan,
    pub wtParam: ::std::os::raw::c_int,
}
impl Default for WorkTableScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScan {
    pub scan: Scan,
    pub operation: CmdType,
    pub resultRelation: Index,
    pub fs_server: Oid,
    pub fdw_exprs: *mut List,
    pub fdw_private: *mut List,
    pub fdw_scan_tlist: *mut List,
    pub fdw_recheck_quals: *mut List,
    pub fs_relids: *mut Bitmapset,
    pub fsSystemCol: bool,
}
impl Default for ForeignScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScan {
    pub scan: Scan,
    pub flags: uint32,
    pub custom_plans: *mut List,
    pub custom_exprs: *mut List,
    pub custom_private: *mut List,
    pub custom_scan_tlist: *mut List,
    pub custom_relids: *mut Bitmapset,
    pub methods: *const CustomScanMethods,
}
impl Default for CustomScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Join {
    pub plan: Plan,
    pub jointype: JoinType,
    pub inner_unique: bool,
    pub joinqual: *mut List,
}
impl Default for Join {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoop {
    pub join: Join,
    pub nestParams: *mut List,
}
impl Default for NestLoop {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopParam {
    pub type_: NodeTag,
    pub paramno: ::std::os::raw::c_int,
    pub paramval: *mut Var,
}
impl Default for NestLoopParam {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoin {
    pub join: Join,
    pub skip_mark_restore: bool,
    pub mergeclauses: *mut List,
    pub mergeFamilies: *mut Oid,
    pub mergeCollations: *mut Oid,
    pub mergeStrategies: *mut ::std::os::raw::c_int,
    pub mergeNullsFirst: *mut bool,
}
impl Default for MergeJoin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoin {
    pub join: Join,
    pub hashclauses: *mut List,
    pub hashoperators: *mut List,
    pub hashcollations: *mut List,
    pub hashkeys: *mut List,
}
impl Default for HashJoin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Material {
    pub plan: Plan,
}
impl Default for Material {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Memoize {
    pub plan: Plan,
    pub numKeys: ::std::os::raw::c_int,
    pub hashOperators: *mut Oid,
    pub collations: *mut Oid,
    pub param_exprs: *mut List,
    pub singlerow: bool,
    pub est_entries: uint32,
}
impl Default for Memoize {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sort {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
}
impl Default for Sort {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IncrementalSort {
    pub sort: Sort,
    pub nPresortedCols: ::std::os::raw::c_int,
}
impl Default for IncrementalSort {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Group {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub grpCollations: *mut Oid,
}
impl Default for Group {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Agg {
    pub plan: Plan,
    pub aggstrategy: AggStrategy,
    pub aggsplit: AggSplit,
    pub numCols: ::std::os::raw::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub grpCollations: *mut Oid,
    pub numGroups: ::std::os::raw::c_long,
    pub transitionSpace: uint64,
    pub aggParams: *mut Bitmapset,
    pub groupingSets: *mut List,
    pub chain: *mut List,
}
impl Default for Agg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAgg {
    pub plan: Plan,
    pub winref: Index,
    pub partNumCols: ::std::os::raw::c_int,
    pub partColIdx: *mut AttrNumber,
    pub partOperators: *mut Oid,
    pub partCollations: *mut Oid,
    pub ordNumCols: ::std::os::raw::c_int,
    pub ordColIdx: *mut AttrNumber,
    pub ordOperators: *mut Oid,
    pub ordCollations: *mut Oid,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub startInRangeFunc: Oid,
    pub endInRangeFunc: Oid,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
}
impl Default for WindowAgg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Unique {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub uniqColIdx: *mut AttrNumber,
    pub uniqOperators: *mut Oid,
    pub uniqCollations: *mut Oid,
}
impl Default for Unique {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Gather {
    pub plan: Plan,
    pub num_workers: ::std::os::raw::c_int,
    pub rescan_param: ::std::os::raw::c_int,
    pub single_copy: bool,
    pub invisible: bool,
    pub initParam: *mut Bitmapset,
}
impl Default for Gather {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMerge {
    pub plan: Plan,
    pub num_workers: ::std::os::raw::c_int,
    pub rescan_param: ::std::os::raw::c_int,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
    pub initParam: *mut Bitmapset,
}
impl Default for GatherMerge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Hash {
    pub plan: Plan,
    pub hashkeys: *mut List,
    pub skewTable: Oid,
    pub skewColumn: AttrNumber,
    pub skewInherit: bool,
    pub rows_total: f64,
}
impl Default for Hash {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOp {
    pub plan: Plan,
    pub cmd: SetOpCmd,
    pub strategy: SetOpStrategy,
    pub numCols: ::std::os::raw::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub dupCollations: *mut Oid,
    pub flagColIdx: AttrNumber,
    pub firstFlag: ::std::os::raw::c_int,
    pub numGroups: ::std::os::raw::c_long,
}
impl Default for SetOp {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRows {
    pub plan: Plan,
    pub rowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
}
impl Default for LockRows {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Limit {
    pub plan: Plan,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption,
    pub uniqNumCols: ::std::os::raw::c_int,
    pub uniqColIdx: *mut AttrNumber,
    pub uniqOperators: *mut Oid,
    pub uniqCollations: *mut Oid,
}
impl Default for Limit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RowMarkType_ROW_MARK_EXCLUSIVE: RowMarkType = 0;
pub const RowMarkType_ROW_MARK_NOKEYEXCLUSIVE: RowMarkType = 1;
pub const RowMarkType_ROW_MARK_SHARE: RowMarkType = 2;
pub const RowMarkType_ROW_MARK_KEYSHARE: RowMarkType = 3;
pub const RowMarkType_ROW_MARK_REFERENCE: RowMarkType = 4;
pub const RowMarkType_ROW_MARK_COPY: RowMarkType = 5;
pub type RowMarkType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanRowMark {
    pub type_: NodeTag,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType,
    pub allMarkTypes: ::std::os::raw::c_int,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub isParent: bool,
}
impl Default for PlanRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneInfo {
    pub type_: NodeTag,
    pub prune_infos: *mut List,
    pub other_subplans: *mut Bitmapset,
}
impl Default for PartitionPruneInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionedRelPruneInfo {
    pub type_: NodeTag,
    pub rtindex: Index,
    pub present_parts: *mut Bitmapset,
    pub nparts: ::std::os::raw::c_int,
    pub subplan_map: *mut ::std::os::raw::c_int,
    pub subpart_map: *mut ::std::os::raw::c_int,
    pub relid_map: *mut Oid,
    pub initial_pruning_steps: *mut List,
    pub exec_pruning_steps: *mut List,
    pub execparamids: *mut Bitmapset,
}
impl Default for PartitionedRelPruneInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStep {
    pub type_: NodeTag,
    pub step_id: ::std::os::raw::c_int,
}
impl Default for PartitionPruneStep {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStepOp {
    pub step: PartitionPruneStep,
    pub opstrategy: StrategyNumber,
    pub exprs: *mut List,
    pub cmpfns: *mut List,
    pub nullkeys: *mut Bitmapset,
}
impl Default for PartitionPruneStepOp {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const PartitionPruneCombineOp_PARTPRUNE_COMBINE_UNION: PartitionPruneCombineOp = 0;
pub const PartitionPruneCombineOp_PARTPRUNE_COMBINE_INTERSECT: PartitionPruneCombineOp = 1;
pub type PartitionPruneCombineOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStepCombine {
    pub step: PartitionPruneStep,
    pub combineOp: PartitionPruneCombineOp,
    pub source_stepids: *mut List,
}
impl Default for PartitionPruneStepCombine {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanInvalItem {
    pub type_: NodeTag,
    pub cacheId: ::std::os::raw::c_int,
    pub hashValue: uint32,
}
impl Default for PlanInvalItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_flag {
    pub value: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint32 {
    pub value: uint32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint64 {
    pub value: uint64,
}
extern "C" {
    pub static mut dynamic_shared_memory_type: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut min_dynamic_shared_memory: ::std::os::raw::c_int;
}
pub type dsm_handle = uint32;
pub const dsm_op_DSM_OP_CREATE: dsm_op = 0;
pub const dsm_op_DSM_OP_ATTACH: dsm_op = 1;
pub const dsm_op_DSM_OP_DETACH: dsm_op = 2;
pub const dsm_op_DSM_OP_DESTROY: dsm_op = 3;
pub type dsm_op = ::std::os::raw::c_uint;
pub unsafe fn dsm_impl_op(
    arg_op: dsm_op,
    arg_handle: dsm_handle,
    arg_request_size: Size,
    arg_impl_private: *mut *mut ::std::os::raw::c_void,
    arg_mapped_address: *mut *mut ::std::os::raw::c_void,
    arg_mapped_size: *mut Size,
    arg_elevel: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_impl_op(
                arg_op: dsm_op,
                arg_handle: dsm_handle,
                arg_request_size: Size,
                arg_impl_private: *mut *mut ::std::os::raw::c_void,
                arg_mapped_address: *mut *mut ::std::os::raw::c_void,
                arg_mapped_size: *mut Size,
                arg_elevel: ::std::os::raw::c_int,
            ) -> bool;
        }
        dsm_impl_op(
            arg_op,
            arg_handle,
            arg_request_size,
            arg_impl_private,
            arg_mapped_address,
            arg_mapped_size,
            arg_elevel,
        )
    })
}
pub unsafe fn dsm_impl_pin_segment(
    arg_handle: dsm_handle,
    arg_impl_private: *mut ::std::os::raw::c_void,
    arg_impl_private_pm_handle: *mut *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_impl_pin_segment(
                arg_handle: dsm_handle,
                arg_impl_private: *mut ::std::os::raw::c_void,
                arg_impl_private_pm_handle: *mut *mut ::std::os::raw::c_void,
            );
        }
        dsm_impl_pin_segment(arg_handle, arg_impl_private, arg_impl_private_pm_handle)
    })
}
pub unsafe fn dsm_impl_unpin_segment(
    arg_handle: dsm_handle,
    arg_impl_private: *mut *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_impl_unpin_segment(
                arg_handle: dsm_handle,
                arg_impl_private: *mut *mut ::std::os::raw::c_void,
            );
        }
        dsm_impl_unpin_segment(arg_handle, arg_impl_private)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsm_segment {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGShmemHeader {
    _unused: [u8; 0],
}
pub unsafe fn dsm_cleanup_using_control_segment(arg_old_control_handle: dsm_handle) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_cleanup_using_control_segment(arg_old_control_handle: dsm_handle);
        }
        dsm_cleanup_using_control_segment(arg_old_control_handle)
    })
}
pub unsafe fn dsm_postmaster_startup(arg_arg1: *mut PGShmemHeader) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_postmaster_startup(arg_arg1: *mut PGShmemHeader);
        }
        dsm_postmaster_startup(arg_arg1)
    })
}
pub unsafe fn dsm_backend_shutdown() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_backend_shutdown();
        }
        dsm_backend_shutdown()
    })
}
pub unsafe fn dsm_detach_all() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_detach_all();
        }
        dsm_detach_all()
    })
}
pub unsafe fn dsm_estimate_size() -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_estimate_size() -> usize;
        }
        dsm_estimate_size()
    })
}
pub unsafe fn dsm_shmem_init() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_shmem_init();
        }
        dsm_shmem_init()
    })
}
pub unsafe fn dsm_create(arg_size: Size, arg_flags: ::std::os::raw::c_int) -> *mut dsm_segment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_create(arg_size: Size, arg_flags: ::std::os::raw::c_int) -> *mut dsm_segment;
        }
        dsm_create(arg_size, arg_flags)
    })
}
pub unsafe fn dsm_attach(arg_h: dsm_handle) -> *mut dsm_segment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_attach(arg_h: dsm_handle) -> *mut dsm_segment;
        }
        dsm_attach(arg_h)
    })
}
pub unsafe fn dsm_detach(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_detach(arg_seg: *mut dsm_segment);
        }
        dsm_detach(arg_seg)
    })
}
pub unsafe fn dsm_pin_mapping(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_pin_mapping(arg_seg: *mut dsm_segment);
        }
        dsm_pin_mapping(arg_seg)
    })
}
pub unsafe fn dsm_unpin_mapping(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_unpin_mapping(arg_seg: *mut dsm_segment);
        }
        dsm_unpin_mapping(arg_seg)
    })
}
pub unsafe fn dsm_pin_segment(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_pin_segment(arg_seg: *mut dsm_segment);
        }
        dsm_pin_segment(arg_seg)
    })
}
pub unsafe fn dsm_unpin_segment(arg_h: dsm_handle) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_unpin_segment(arg_h: dsm_handle);
        }
        dsm_unpin_segment(arg_h)
    })
}
pub unsafe fn dsm_find_mapping(arg_h: dsm_handle) -> *mut dsm_segment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_find_mapping(arg_h: dsm_handle) -> *mut dsm_segment;
        }
        dsm_find_mapping(arg_h)
    })
}
pub unsafe fn dsm_segment_address(arg_seg: *mut dsm_segment) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_segment_address(arg_seg: *mut dsm_segment) -> *mut ::std::os::raw::c_void;
        }
        dsm_segment_address(arg_seg)
    })
}
pub unsafe fn dsm_segment_map_length(arg_seg: *mut dsm_segment) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_segment_map_length(arg_seg: *mut dsm_segment) -> Size;
        }
        dsm_segment_map_length(arg_seg)
    })
}
pub unsafe fn dsm_segment_handle(arg_seg: *mut dsm_segment) -> dsm_handle {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_segment_handle(arg_seg: *mut dsm_segment) -> dsm_handle;
        }
        dsm_segment_handle(arg_seg)
    })
}
pub type on_dsm_detach_callback =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut dsm_segment, arg: Datum)>;
pub unsafe fn on_dsm_detach(
    arg_seg: *mut dsm_segment,
    arg_function: on_dsm_detach_callback,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn on_dsm_detach(
                arg_seg: *mut dsm_segment,
                arg_function: on_dsm_detach_callback,
                arg_arg: Datum,
            );
        }
        on_dsm_detach(arg_seg, arg_function, arg_arg)
    })
}
pub unsafe fn cancel_on_dsm_detach(
    arg_seg: *mut dsm_segment,
    arg_function: on_dsm_detach_callback,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cancel_on_dsm_detach(
                arg_seg: *mut dsm_segment,
                arg_function: on_dsm_detach_callback,
                arg_arg: Datum,
            );
        }
        cancel_on_dsm_detach(arg_seg, arg_function, arg_arg)
    })
}
pub unsafe fn reset_on_dsm_detach() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn reset_on_dsm_detach();
        }
        reset_on_dsm_detach()
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsa_area {
    _unused: [u8; 0],
}
pub type dsa_pointer = uint64;
pub type dsa_pointer_atomic = pg_atomic_uint64;
pub type dsa_handle = dsm_handle;
pub unsafe fn dsa_create(arg_tranche_id: ::std::os::raw::c_int) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_create(arg_tranche_id: ::std::os::raw::c_int) -> *mut dsa_area;
        }
        dsa_create(arg_tranche_id)
    })
}
pub unsafe fn dsa_create_in_place(
    arg_place: *mut ::std::os::raw::c_void,
    arg_size: usize,
    arg_tranche_id: ::std::os::raw::c_int,
    arg_segment: *mut dsm_segment,
) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_create_in_place(
                arg_place: *mut ::std::os::raw::c_void,
                arg_size: usize,
                arg_tranche_id: ::std::os::raw::c_int,
                arg_segment: *mut dsm_segment,
            ) -> *mut dsa_area;
        }
        dsa_create_in_place(arg_place, arg_size, arg_tranche_id, arg_segment)
    })
}
pub unsafe fn dsa_attach(arg_handle: dsa_handle) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_attach(arg_handle: dsa_handle) -> *mut dsa_area;
        }
        dsa_attach(arg_handle)
    })
}
pub unsafe fn dsa_attach_in_place(
    arg_place: *mut ::std::os::raw::c_void,
    arg_segment: *mut dsm_segment,
) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_attach_in_place(
                arg_place: *mut ::std::os::raw::c_void,
                arg_segment: *mut dsm_segment,
            ) -> *mut dsa_area;
        }
        dsa_attach_in_place(arg_place, arg_segment)
    })
}
pub unsafe fn dsa_release_in_place(arg_place: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_release_in_place(arg_place: *mut ::std::os::raw::c_void);
        }
        dsa_release_in_place(arg_place)
    })
}
pub unsafe fn dsa_on_dsm_detach_release_in_place(arg_arg1: *mut dsm_segment, arg_arg2: Datum) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_on_dsm_detach_release_in_place(arg_arg1: *mut dsm_segment, arg_arg2: Datum);
        }
        dsa_on_dsm_detach_release_in_place(arg_arg1, arg_arg2)
    })
}
pub unsafe fn dsa_on_shmem_exit_release_in_place(arg_arg1: ::std::os::raw::c_int, arg_arg2: Datum) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_on_shmem_exit_release_in_place(arg_arg1: ::std::os::raw::c_int, arg_arg2: Datum);
        }
        dsa_on_shmem_exit_release_in_place(arg_arg1, arg_arg2)
    })
}
pub unsafe fn dsa_pin_mapping(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_pin_mapping(arg_area: *mut dsa_area);
        }
        dsa_pin_mapping(arg_area)
    })
}
pub unsafe fn dsa_detach(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_detach(arg_area: *mut dsa_area);
        }
        dsa_detach(arg_area)
    })
}
pub unsafe fn dsa_pin(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_pin(arg_area: *mut dsa_area);
        }
        dsa_pin(arg_area)
    })
}
pub unsafe fn dsa_unpin(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_unpin(arg_area: *mut dsa_area);
        }
        dsa_unpin(arg_area)
    })
}
pub unsafe fn dsa_set_size_limit(arg_area: *mut dsa_area, arg_limit: usize) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_set_size_limit(arg_area: *mut dsa_area, arg_limit: usize);
        }
        dsa_set_size_limit(arg_area, arg_limit)
    })
}
pub unsafe fn dsa_minimum_size() -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_minimum_size() -> usize;
        }
        dsa_minimum_size()
    })
}
pub unsafe fn dsa_get_handle(arg_area: *mut dsa_area) -> dsa_handle {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_get_handle(arg_area: *mut dsa_area) -> dsa_handle;
        }
        dsa_get_handle(arg_area)
    })
}
pub unsafe fn dsa_allocate_extended(
    arg_area: *mut dsa_area,
    arg_size: usize,
    arg_flags: ::std::os::raw::c_int,
) -> dsa_pointer {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_allocate_extended(
                arg_area: *mut dsa_area,
                arg_size: usize,
                arg_flags: ::std::os::raw::c_int,
            ) -> dsa_pointer;
        }
        dsa_allocate_extended(arg_area, arg_size, arg_flags)
    })
}
pub unsafe fn dsa_free(arg_area: *mut dsa_area, arg_dp: dsa_pointer) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_free(arg_area: *mut dsa_area, arg_dp: dsa_pointer);
        }
        dsa_free(arg_area, arg_dp)
    })
}
pub unsafe fn dsa_get_address(
    arg_area: *mut dsa_area,
    arg_dp: dsa_pointer,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_get_address(
                arg_area: *mut dsa_area,
                arg_dp: dsa_pointer,
            ) -> *mut ::std::os::raw::c_void;
        }
        dsa_get_address(arg_area, arg_dp)
    })
}
pub unsafe fn dsa_trim(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_trim(arg_area: *mut dsa_area);
        }
        dsa_trim(arg_area)
    })
}
pub unsafe fn dsa_dump(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_dump(arg_area: *mut dsa_area);
        }
        dsa_dump(arg_area)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TIDBitmap {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMSharedIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TBMIterateResult {
    pub blockno: BlockNumber,
    pub ntuples: ::std::os::raw::c_int,
    pub recheck: bool,
    pub offsets: __IncompleteArrayField<OffsetNumber>,
}
pub unsafe fn tbm_create(
    arg_maxbytes: ::std::os::raw::c_long,
    arg_dsa: *mut dsa_area,
) -> *mut TIDBitmap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_create(
                arg_maxbytes: ::std::os::raw::c_long,
                arg_dsa: *mut dsa_area,
            ) -> *mut TIDBitmap;
        }
        tbm_create(arg_maxbytes, arg_dsa)
    })
}
pub unsafe fn tbm_free(arg_tbm: *mut TIDBitmap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_free(arg_tbm: *mut TIDBitmap);
        }
        tbm_free(arg_tbm)
    })
}
pub unsafe fn tbm_free_shared_area(arg_dsa: *mut dsa_area, arg_dp: dsa_pointer) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_free_shared_area(arg_dsa: *mut dsa_area, arg_dp: dsa_pointer);
        }
        tbm_free_shared_area(arg_dsa, arg_dp)
    })
}
pub unsafe fn tbm_add_tuples(
    arg_tbm: *mut TIDBitmap,
    arg_tids: ItemPointer,
    arg_ntids: ::std::os::raw::c_int,
    arg_recheck: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_add_tuples(
                arg_tbm: *mut TIDBitmap,
                arg_tids: ItemPointer,
                arg_ntids: ::std::os::raw::c_int,
                arg_recheck: bool,
            );
        }
        tbm_add_tuples(arg_tbm, arg_tids, arg_ntids, arg_recheck)
    })
}
pub unsafe fn tbm_add_page(arg_tbm: *mut TIDBitmap, arg_pageno: BlockNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_add_page(arg_tbm: *mut TIDBitmap, arg_pageno: BlockNumber);
        }
        tbm_add_page(arg_tbm, arg_pageno)
    })
}
pub unsafe fn tbm_union(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_union(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap);
        }
        tbm_union(arg_a, arg_b)
    })
}
pub unsafe fn tbm_intersect(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_intersect(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap);
        }
        tbm_intersect(arg_a, arg_b)
    })
}
pub unsafe fn tbm_is_empty(arg_tbm: *const TIDBitmap) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_is_empty(arg_tbm: *const TIDBitmap) -> bool;
        }
        tbm_is_empty(arg_tbm)
    })
}
pub unsafe fn tbm_begin_iterate(arg_tbm: *mut TIDBitmap) -> *mut TBMIterator {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_begin_iterate(arg_tbm: *mut TIDBitmap) -> *mut TBMIterator;
        }
        tbm_begin_iterate(arg_tbm)
    })
}
pub unsafe fn tbm_prepare_shared_iterate(arg_tbm: *mut TIDBitmap) -> dsa_pointer {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_prepare_shared_iterate(arg_tbm: *mut TIDBitmap) -> dsa_pointer;
        }
        tbm_prepare_shared_iterate(arg_tbm)
    })
}
pub unsafe fn tbm_iterate(arg_iterator: *mut TBMIterator) -> *mut TBMIterateResult {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_iterate(arg_iterator: *mut TBMIterator) -> *mut TBMIterateResult;
        }
        tbm_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_shared_iterate(arg_iterator: *mut TBMSharedIterator) -> *mut TBMIterateResult {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_shared_iterate(arg_iterator: *mut TBMSharedIterator) -> *mut TBMIterateResult;
        }
        tbm_shared_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_end_iterate(arg_iterator: *mut TBMIterator) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_end_iterate(arg_iterator: *mut TBMIterator);
        }
        tbm_end_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_end_shared_iterate(arg_iterator: *mut TBMSharedIterator) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_end_shared_iterate(arg_iterator: *mut TBMSharedIterator);
        }
        tbm_end_shared_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_attach_shared_iterate(
    arg_dsa: *mut dsa_area,
    arg_dp: dsa_pointer,
) -> *mut TBMSharedIterator {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_attach_shared_iterate(
                arg_dsa: *mut dsa_area,
                arg_dp: dsa_pointer,
            ) -> *mut TBMSharedIterator;
        }
        tbm_attach_shared_iterate(arg_dsa, arg_dp)
    })
}
pub unsafe fn tbm_calculate_entries(arg_maxbytes: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_calculate_entries(arg_maxbytes: f64) -> ::std::os::raw::c_long;
        }
        tbm_calculate_entries(arg_maxbytes)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundInfoData {
    _unused: [u8; 0],
}
pub type PartitionBoundInfo = *mut PartitionBoundInfoData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionKeyData {
    _unused: [u8; 0],
}
pub type PartitionKey = *mut PartitionKeyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDescData {
    _unused: [u8; 0],
}
pub type PartitionDesc = *mut PartitionDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDirectoryData {
    _unused: [u8; 0],
}
pub type PartitionDirectory = *mut PartitionDirectoryData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_node {
    pub next: ::std::os::raw::c_int,
    pub prev: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_head {
    pub head: ::std::os::raw::c_int,
    pub tail: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_mutable_iter {
    pub cur: ::std::os::raw::c_int,
    pub next: ::std::os::raw::c_int,
}
pub type slock_t = ::std::os::raw::c_int;
extern "C" {
    pub static mut dummy_spinlock: slock_t;
}
pub unsafe fn s_lock(
    arg_lock: *mut slock_t,
    arg_file: *const ::std::os::raw::c_char,
    arg_line: ::std::os::raw::c_int,
    arg_func: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn s_lock(
                arg_lock: *mut slock_t,
                arg_file: *const ::std::os::raw::c_char,
                arg_line: ::std::os::raw::c_int,
                arg_func: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        s_lock(arg_lock, arg_file, arg_line, arg_func)
    })
}
pub unsafe fn set_spins_per_delay(arg_shared_spins_per_delay: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_spins_per_delay(arg_shared_spins_per_delay: ::std::os::raw::c_int);
        }
        set_spins_per_delay(arg_shared_spins_per_delay)
    })
}
pub unsafe fn update_spins_per_delay(
    arg_shared_spins_per_delay: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn update_spins_per_delay(
                arg_shared_spins_per_delay: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        update_spins_per_delay(arg_shared_spins_per_delay)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpinDelayStatus {
    pub spins: ::std::os::raw::c_int,
    pub delays: ::std::os::raw::c_int,
    pub cur_delay: ::std::os::raw::c_int,
    pub file: *const ::std::os::raw::c_char,
    pub line: ::std::os::raw::c_int,
    pub func: *const ::std::os::raw::c_char,
}
impl Default for SpinDelayStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn perform_spin_delay(arg_status: *mut SpinDelayStatus) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn perform_spin_delay(arg_status: *mut SpinDelayStatus);
        }
        perform_spin_delay(arg_status)
    })
}
pub unsafe fn finish_spin_delay(arg_status: *mut SpinDelayStatus) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn finish_spin_delay(arg_status: *mut SpinDelayStatus);
        }
        finish_spin_delay(arg_status)
    })
}
pub unsafe fn SpinlockSemas() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SpinlockSemas() -> ::std::os::raw::c_int;
        }
        SpinlockSemas()
    })
}
pub unsafe fn SpinlockSemaSize() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SpinlockSemaSize() -> Size;
        }
        SpinlockSemaSize()
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ConditionVariable {
    pub mutex: slock_t,
    pub wakeup: proclist_head,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ConditionVariableMinimallyPadded {
    pub cv: ConditionVariable,
    pub pad: [::std::os::raw::c_char; 16usize],
}
impl Default for ConditionVariableMinimallyPadded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn ConditionVariableInit(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableInit(arg_cv: *mut ConditionVariable);
        }
        ConditionVariableInit(arg_cv)
    })
}
pub unsafe fn ConditionVariableSleep(arg_cv: *mut ConditionVariable, arg_wait_event_info: uint32) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableSleep(arg_cv: *mut ConditionVariable, arg_wait_event_info: uint32);
        }
        ConditionVariableSleep(arg_cv, arg_wait_event_info)
    })
}
pub unsafe fn ConditionVariableTimedSleep(
    arg_cv: *mut ConditionVariable,
    arg_timeout: ::std::os::raw::c_long,
    arg_wait_event_info: uint32,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableTimedSleep(
                arg_cv: *mut ConditionVariable,
                arg_timeout: ::std::os::raw::c_long,
                arg_wait_event_info: uint32,
            ) -> bool;
        }
        ConditionVariableTimedSleep(arg_cv, arg_timeout, arg_wait_event_info)
    })
}
pub unsafe fn ConditionVariableCancelSleep() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableCancelSleep();
        }
        ConditionVariableCancelSleep()
    })
}
pub unsafe fn ConditionVariablePrepareToSleep(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariablePrepareToSleep(arg_cv: *mut ConditionVariable);
        }
        ConditionVariablePrepareToSleep(arg_cv)
    })
}
pub unsafe fn ConditionVariableSignal(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableSignal(arg_cv: *mut ConditionVariable);
        }
        ConditionVariableSignal(arg_cv)
    })
}
pub unsafe fn ConditionVariableBroadcast(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableBroadcast(arg_cv: *mut ConditionVariable);
        }
        ConditionVariableBroadcast(arg_cv)
    })
}
pub type HashValueFunc = ::std::option::Option<
    unsafe extern "C" fn(key: *const ::std::os::raw::c_void, keysize: Size) -> uint32,
>;
pub type HashCompareFunc = ::std::option::Option<
    unsafe extern "C" fn(
        key1: *const ::std::os::raw::c_void,
        key2: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> ::std::os::raw::c_int,
>;
pub type HashCopyFunc = ::std::option::Option<
    unsafe extern "C" fn(
        dest: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type HashAllocFunc =
    ::std::option::Option<unsafe extern "C" fn(request: Size) -> *mut ::std::os::raw::c_void>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHELEMENT {
    pub link: *mut HASHELEMENT,
    pub hashvalue: uint32,
}
impl Default for HASHELEMENT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHHDR {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTAB {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHCTL {
    pub num_partitions: ::std::os::raw::c_long,
    pub ssize: ::std::os::raw::c_long,
    pub dsize: ::std::os::raw::c_long,
    pub max_dsize: ::std::os::raw::c_long,
    pub keysize: Size,
    pub entrysize: Size,
    pub hash: HashValueFunc,
    pub match_: HashCompareFunc,
    pub keycopy: HashCopyFunc,
    pub alloc: HashAllocFunc,
    pub hcxt: MemoryContext,
    pub hctl: *mut HASHHDR,
}
impl Default for HASHCTL {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const HASHACTION_HASH_FIND: HASHACTION = 0;
pub const HASHACTION_HASH_ENTER: HASHACTION = 1;
pub const HASHACTION_HASH_REMOVE: HASHACTION = 2;
pub const HASHACTION_HASH_ENTER_NULL: HASHACTION = 3;
pub type HASHACTION = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASH_SEQ_STATUS {
    pub hashp: *mut HTAB,
    pub curBucket: uint32,
    pub curEntry: *mut HASHELEMENT,
}
impl Default for HASH_SEQ_STATUS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn hash_create(
    arg_tabname: *const ::std::os::raw::c_char,
    arg_nelem: ::std::os::raw::c_long,
    arg_info: *const HASHCTL,
    arg_flags: ::std::os::raw::c_int,
) -> *mut HTAB {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_create(
                arg_tabname: *const ::std::os::raw::c_char,
                arg_nelem: ::std::os::raw::c_long,
                arg_info: *const HASHCTL,
                arg_flags: ::std::os::raw::c_int,
            ) -> *mut HTAB;
        }
        hash_create(arg_tabname, arg_nelem, arg_info, arg_flags)
    })
}
pub unsafe fn hash_destroy(arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_destroy(arg_hashp: *mut HTAB);
        }
        hash_destroy(arg_hashp)
    })
}
pub unsafe fn hash_stats(arg_where_: *const ::std::os::raw::c_char, arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_stats(arg_where_: *const ::std::os::raw::c_char, arg_hashp: *mut HTAB);
        }
        hash_stats(arg_where_, arg_hashp)
    })
}
pub unsafe fn hash_search(
    arg_hashp: *mut HTAB,
    arg_keyPtr: *const ::std::os::raw::c_void,
    arg_action: HASHACTION,
    arg_foundPtr: *mut bool,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_search(
                arg_hashp: *mut HTAB,
                arg_keyPtr: *const ::std::os::raw::c_void,
                arg_action: HASHACTION,
                arg_foundPtr: *mut bool,
            ) -> *mut ::std::os::raw::c_void;
        }
        hash_search(arg_hashp, arg_keyPtr, arg_action, arg_foundPtr)
    })
}
pub unsafe fn get_hash_value(
    arg_hashp: *mut HTAB,
    arg_keyPtr: *const ::std::os::raw::c_void,
) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_hash_value(
                arg_hashp: *mut HTAB,
                arg_keyPtr: *const ::std::os::raw::c_void,
            ) -> uint32;
        }
        get_hash_value(arg_hashp, arg_keyPtr)
    })
}
pub unsafe fn hash_search_with_hash_value(
    arg_hashp: *mut HTAB,
    arg_keyPtr: *const ::std::os::raw::c_void,
    arg_hashvalue: uint32,
    arg_action: HASHACTION,
    arg_foundPtr: *mut bool,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_search_with_hash_value(
                arg_hashp: *mut HTAB,
                arg_keyPtr: *const ::std::os::raw::c_void,
                arg_hashvalue: uint32,
                arg_action: HASHACTION,
                arg_foundPtr: *mut bool,
            ) -> *mut ::std::os::raw::c_void;
        }
        hash_search_with_hash_value(
            arg_hashp,
            arg_keyPtr,
            arg_hashvalue,
            arg_action,
            arg_foundPtr,
        )
    })
}
pub unsafe fn hash_update_hash_key(
    arg_hashp: *mut HTAB,
    arg_existingEntry: *mut ::std::os::raw::c_void,
    arg_newKeyPtr: *const ::std::os::raw::c_void,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_update_hash_key(
                arg_hashp: *mut HTAB,
                arg_existingEntry: *mut ::std::os::raw::c_void,
                arg_newKeyPtr: *const ::std::os::raw::c_void,
            ) -> bool;
        }
        hash_update_hash_key(arg_hashp, arg_existingEntry, arg_newKeyPtr)
    })
}
pub unsafe fn hash_get_num_entries(arg_hashp: *mut HTAB) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_get_num_entries(arg_hashp: *mut HTAB) -> ::std::os::raw::c_long;
        }
        hash_get_num_entries(arg_hashp)
    })
}
pub unsafe fn hash_seq_init(arg_status: *mut HASH_SEQ_STATUS, arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_seq_init(arg_status: *mut HASH_SEQ_STATUS, arg_hashp: *mut HTAB);
        }
        hash_seq_init(arg_status, arg_hashp)
    })
}
pub unsafe fn hash_seq_search(arg_status: *mut HASH_SEQ_STATUS) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_seq_search(arg_status: *mut HASH_SEQ_STATUS) -> *mut ::std::os::raw::c_void;
        }
        hash_seq_search(arg_status)
    })
}
pub unsafe fn hash_seq_term(arg_status: *mut HASH_SEQ_STATUS) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_seq_term(arg_status: *mut HASH_SEQ_STATUS);
        }
        hash_seq_term(arg_status)
    })
}
pub unsafe fn hash_freeze(arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_freeze(arg_hashp: *mut HTAB);
        }
        hash_freeze(arg_hashp)
    })
}
pub unsafe fn hash_estimate_size(
    arg_num_entries: ::std::os::raw::c_long,
    arg_entrysize: Size,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_estimate_size(
                arg_num_entries: ::std::os::raw::c_long,
                arg_entrysize: Size,
            ) -> Size;
        }
        hash_estimate_size(arg_num_entries, arg_entrysize)
    })
}
pub unsafe fn hash_select_dirsize(
    arg_num_entries: ::std::os::raw::c_long,
) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_select_dirsize(
                arg_num_entries: ::std::os::raw::c_long,
            ) -> ::std::os::raw::c_long;
        }
        hash_select_dirsize(arg_num_entries)
    })
}
pub unsafe fn hash_get_shared_size(
    arg_info: *mut HASHCTL,
    arg_flags: ::std::os::raw::c_int,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_get_shared_size(
                arg_info: *mut HASHCTL,
                arg_flags: ::std::os::raw::c_int,
            ) -> Size;
        }
        hash_get_shared_size(arg_info, arg_flags)
    })
}
pub unsafe fn AtEOXact_HashTables(arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOXact_HashTables(arg_isCommit: bool);
        }
        AtEOXact_HashTables(arg_isCommit)
    })
}
pub unsafe fn AtEOSubXact_HashTables(arg_isCommit: bool, arg_nestDepth: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOSubXact_HashTables(arg_isCommit: bool, arg_nestDepth: ::std::os::raw::c_int);
        }
        AtEOSubXact_HashTables(arg_isCommit, arg_nestDepth)
    })
}
pub const EphemeralNameRelationType_ENR_NAMED_TUPLESTORE: EphemeralNameRelationType = 0;
pub type EphemeralNameRelationType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationMetadataData {
    pub name: *mut ::std::os::raw::c_char,
    pub reliddesc: Oid,
    pub tupdesc: TupleDesc,
    pub enrtype: EphemeralNameRelationType,
    pub enrtuples: f64,
}
impl Default for EphemeralNamedRelationMetadataData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelationMetadata = *mut EphemeralNamedRelationMetadataData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationData {
    pub md: EphemeralNamedRelationMetadataData,
    pub reldata: *mut ::std::os::raw::c_void,
}
impl Default for EphemeralNamedRelationData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelation = *mut EphemeralNamedRelationData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryEnvironment {
    _unused: [u8; 0],
}
pub unsafe fn create_queryEnv() -> *mut QueryEnvironment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn create_queryEnv() -> *mut QueryEnvironment;
        }
        create_queryEnv()
    })
}
pub unsafe fn get_visible_ENR_metadata(
    arg_queryEnv: *mut QueryEnvironment,
    arg_refname: *const ::std::os::raw::c_char,
) -> EphemeralNamedRelationMetadata {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_visible_ENR_metadata(
                arg_queryEnv: *mut QueryEnvironment,
                arg_refname: *const ::std::os::raw::c_char,
            ) -> EphemeralNamedRelationMetadata;
        }
        get_visible_ENR_metadata(arg_queryEnv, arg_refname)
    })
}
pub unsafe fn register_ENR(arg_queryEnv: *mut QueryEnvironment, arg_enr: EphemeralNamedRelation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn register_ENR(arg_queryEnv: *mut QueryEnvironment, arg_enr: EphemeralNamedRelation);
        }
        register_ENR(arg_queryEnv, arg_enr)
    })
}
pub unsafe fn unregister_ENR(
    arg_queryEnv: *mut QueryEnvironment,
    arg_name: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn unregister_ENR(
                arg_queryEnv: *mut QueryEnvironment,
                arg_name: *const ::std::os::raw::c_char,
            );
        }
        unregister_ENR(arg_queryEnv, arg_name)
    })
}
pub unsafe fn get_ENR(
    arg_queryEnv: *mut QueryEnvironment,
    arg_name: *const ::std::os::raw::c_char,
) -> EphemeralNamedRelation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_ENR(
                arg_queryEnv: *mut QueryEnvironment,
                arg_name: *const ::std::os::raw::c_char,
            ) -> EphemeralNamedRelation;
        }
        get_ENR(arg_queryEnv, arg_name)
    })
}
pub unsafe fn ENRMetadataGetTupDesc(arg_enrmd: EphemeralNamedRelationMetadata) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ENRMetadataGetTupDesc(arg_enrmd: EphemeralNamedRelationMetadata) -> TupleDesc;
        }
        ENRMetadataGetTupDesc(arg_enrmd)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Trigger {
    pub tgoid: Oid,
    pub tgname: *mut ::std::os::raw::c_char,
    pub tgfoid: Oid,
    pub tgtype: int16,
    pub tgenabled: ::std::os::raw::c_char,
    pub tgisinternal: bool,
    pub tgisclone: bool,
    pub tgconstrrelid: Oid,
    pub tgconstrindid: Oid,
    pub tgconstraint: Oid,
    pub tgdeferrable: bool,
    pub tginitdeferred: bool,
    pub tgnargs: int16,
    pub tgnattr: int16,
    pub tgattr: *mut int16,
    pub tgargs: *mut *mut ::std::os::raw::c_char,
    pub tgqual: *mut ::std::os::raw::c_char,
    pub tgoldtable: *mut ::std::os::raw::c_char,
    pub tgnewtable: *mut ::std::os::raw::c_char,
}
impl Default for Trigger {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerDesc {
    pub triggers: *mut Trigger,
    pub numtriggers: ::std::os::raw::c_int,
    pub trig_insert_before_row: bool,
    pub trig_insert_after_row: bool,
    pub trig_insert_instead_row: bool,
    pub trig_insert_before_statement: bool,
    pub trig_insert_after_statement: bool,
    pub trig_update_before_row: bool,
    pub trig_update_after_row: bool,
    pub trig_update_instead_row: bool,
    pub trig_update_before_statement: bool,
    pub trig_update_after_statement: bool,
    pub trig_delete_before_row: bool,
    pub trig_delete_after_row: bool,
    pub trig_delete_instead_row: bool,
    pub trig_delete_before_statement: bool,
    pub trig_delete_after_statement: bool,
    pub trig_truncate_before_statement: bool,
    pub trig_truncate_after_statement: bool,
    pub trig_insert_new_table: bool,
    pub trig_update_old_table: bool,
    pub trig_update_new_table: bool,
    pub trig_delete_old_table: bool,
}
impl Default for TriggerDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dirent {
    pub d_ino: __uint64_t,
    pub d_seekoff: __uint64_t,
    pub d_reclen: __uint16_t,
    pub d_namlen: __uint16_t,
    pub d_type: __uint8_t,
    pub d_name: [::std::os::raw::c_char; 1024usize],
}
impl Default for dirent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _telldir {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DIR {
    pub __dd_fd: ::std::os::raw::c_int,
    pub __dd_loc: ::std::os::raw::c_long,
    pub __dd_size: ::std::os::raw::c_long,
    pub __dd_buf: *mut ::std::os::raw::c_char,
    pub __dd_len: ::std::os::raw::c_int,
    pub __dd_seek: ::std::os::raw::c_long,
    pub __padding: ::std::os::raw::c_long,
    pub __dd_flags: ::std::os::raw::c_int,
    pub __dd_lock: __darwin_pthread_mutex_t,
    pub __dd_td: *mut _telldir,
}
impl Default for DIR {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn closedir(arg_arg1: *mut DIR) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn closedir(arg_arg1: *mut DIR) -> ::std::os::raw::c_int;
        }
        closedir(arg_arg1)
    })
}
pub unsafe fn opendir(arg_arg1: *const ::std::os::raw::c_char) -> *mut DIR {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn opendir(arg_arg1: *const ::std::os::raw::c_char) -> *mut DIR;
        }
        opendir(arg_arg1)
    })
}
pub unsafe fn readdir(arg_arg1: *mut DIR) -> *mut dirent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readdir(arg_arg1: *mut DIR) -> *mut dirent;
        }
        readdir(arg_arg1)
    })
}
pub unsafe fn readdir_r(
    arg_arg1: *mut DIR,
    arg_arg2: *mut dirent,
    arg_arg3: *mut *mut dirent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readdir_r(
                arg_arg1: *mut DIR,
                arg_arg2: *mut dirent,
                arg_arg3: *mut *mut dirent,
            ) -> ::std::os::raw::c_int;
        }
        readdir_r(arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn rewinddir(arg_arg1: *mut DIR) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rewinddir(arg_arg1: *mut DIR);
        }
        rewinddir(arg_arg1)
    })
}
pub unsafe fn seekdir(arg_arg1: *mut DIR, arg_arg2: ::std::os::raw::c_long) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn seekdir(arg_arg1: *mut DIR, arg_arg2: ::std::os::raw::c_long);
        }
        seekdir(arg_arg1, arg_arg2)
    })
}
pub unsafe fn telldir(arg_arg1: *mut DIR) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn telldir(arg_arg1: *mut DIR) -> ::std::os::raw::c_long;
        }
        telldir(arg_arg1)
    })
}
pub unsafe fn fdopendir(arg_arg1: ::std::os::raw::c_int) -> *mut DIR {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdopendir(arg_arg1: ::std::os::raw::c_int) -> *mut DIR;
        }
        fdopendir(arg_arg1)
    })
}
pub unsafe fn alphasort(
    arg_arg1: *mut *const dirent,
    arg_arg2: *mut *const dirent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn alphasort(
                arg_arg1: *mut *const dirent,
                arg_arg2: *mut *const dirent,
            ) -> ::std::os::raw::c_int;
        }
        alphasort(arg_arg1, arg_arg2)
    })
}
pub unsafe fn dirfd(arg_dirp: *mut DIR) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dirfd(arg_dirp: *mut DIR) -> ::std::os::raw::c_int;
        }
        dirfd(arg_dirp)
    })
}
pub unsafe fn scandir(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *mut *mut *mut dirent,
    arg_arg3: ::std::option::Option<
        unsafe extern "C" fn(arg1: *const dirent) -> ::std::os::raw::c_int,
    >,
    arg_arg4: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut *const dirent,
            arg2: *mut *const dirent,
        ) -> ::std::os::raw::c_int,
    >,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scandir(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *mut *mut *mut dirent,
                arg_arg3: ::std::option::Option<
                    unsafe extern "C" fn(arg1: *const dirent) -> ::std::os::raw::c_int,
                >,
                arg_arg4: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *mut *const dirent,
                        arg2: *mut *const dirent,
                    ) -> ::std::os::raw::c_int,
                >,
            ) -> ::std::os::raw::c_int;
        }
        scandir(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn scandir_b(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: *mut *mut *mut dirent,
    arg_arg3: *mut ::std::os::raw::c_void,
    arg_arg4: *mut ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scandir_b(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: *mut *mut *mut dirent,
                arg_arg3: *mut ::std::os::raw::c_void,
                arg_arg4: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        scandir_b(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn getdirentries(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: *mut ::std::os::raw::c_char,
    arg_arg3: ::std::os::raw::c_int,
    arg_arg4: *mut ::std::os::raw::c_long,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getdirentries(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: *mut ::std::os::raw::c_char,
                arg_arg3: ::std::os::raw::c_int,
                arg_arg4: *mut ::std::os::raw::c_long,
            ) -> ::std::os::raw::c_int;
        }
        getdirentries(arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn __opendir2(
    arg_arg1: *const ::std::os::raw::c_char,
    arg_arg2: ::std::os::raw::c_int,
) -> *mut DIR {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __opendir2(
                arg_arg1: *const ::std::os::raw::c_char,
                arg_arg2: ::std::os::raw::c_int,
            ) -> *mut DIR;
        }
        __opendir2(arg_arg1, arg_arg2)
    })
}
pub const RecoveryInitSyncMethod_RECOVERY_INIT_SYNC_METHOD_FSYNC: RecoveryInitSyncMethod = 0;
pub const RecoveryInitSyncMethod_RECOVERY_INIT_SYNC_METHOD_SYNCFS: RecoveryInitSyncMethod = 1;
pub type RecoveryInitSyncMethod = ::std::os::raw::c_uint;
pub type File = ::std::os::raw::c_int;
extern "C" {
    pub static mut max_files_per_process: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut data_sync_retry: bool;
}
extern "C" {
    pub static mut recovery_init_sync_method: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut max_safe_fds: ::std::os::raw::c_int;
}
pub unsafe fn PathNameOpenFile(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameOpenFile(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
            ) -> File;
        }
        PathNameOpenFile(arg_fileName, arg_fileFlags)
    })
}
pub unsafe fn PathNameOpenFilePerm(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
    arg_fileMode: mode_t,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameOpenFilePerm(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
                arg_fileMode: mode_t,
            ) -> File;
        }
        PathNameOpenFilePerm(arg_fileName, arg_fileFlags, arg_fileMode)
    })
}
pub unsafe fn OpenTemporaryFile(arg_interXact: bool) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenTemporaryFile(arg_interXact: bool) -> File;
        }
        OpenTemporaryFile(arg_interXact)
    })
}
pub unsafe fn FileClose(arg_file: File) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileClose(arg_file: File);
        }
        FileClose(arg_file)
    })
}
pub unsafe fn FilePrefetch(
    arg_file: File,
    arg_offset: off_t,
    arg_amount: ::std::os::raw::c_int,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FilePrefetch(
                arg_file: File,
                arg_offset: off_t,
                arg_amount: ::std::os::raw::c_int,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FilePrefetch(arg_file, arg_offset, arg_amount, arg_wait_event_info)
    })
}
pub unsafe fn FileRead(
    arg_file: File,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_amount: ::std::os::raw::c_int,
    arg_offset: off_t,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileRead(
                arg_file: File,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_amount: ::std::os::raw::c_int,
                arg_offset: off_t,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FileRead(
            arg_file,
            arg_buffer,
            arg_amount,
            arg_offset,
            arg_wait_event_info,
        )
    })
}
pub unsafe fn FileWrite(
    arg_file: File,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_amount: ::std::os::raw::c_int,
    arg_offset: off_t,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileWrite(
                arg_file: File,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_amount: ::std::os::raw::c_int,
                arg_offset: off_t,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FileWrite(
            arg_file,
            arg_buffer,
            arg_amount,
            arg_offset,
            arg_wait_event_info,
        )
    })
}
pub unsafe fn FileSync(arg_file: File, arg_wait_event_info: uint32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileSync(arg_file: File, arg_wait_event_info: uint32) -> ::std::os::raw::c_int;
        }
        FileSync(arg_file, arg_wait_event_info)
    })
}
pub unsafe fn FileSize(arg_file: File) -> off_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileSize(arg_file: File) -> off_t;
        }
        FileSize(arg_file)
    })
}
pub unsafe fn FileTruncate(
    arg_file: File,
    arg_offset: off_t,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileTruncate(
                arg_file: File,
                arg_offset: off_t,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FileTruncate(arg_file, arg_offset, arg_wait_event_info)
    })
}
pub unsafe fn FileWriteback(
    arg_file: File,
    arg_offset: off_t,
    arg_nbytes: off_t,
    arg_wait_event_info: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileWriteback(
                arg_file: File,
                arg_offset: off_t,
                arg_nbytes: off_t,
                arg_wait_event_info: uint32,
            );
        }
        FileWriteback(arg_file, arg_offset, arg_nbytes, arg_wait_event_info)
    })
}
pub unsafe fn FilePathName(arg_file: File) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FilePathName(arg_file: File) -> *mut ::std::os::raw::c_char;
        }
        FilePathName(arg_file)
    })
}
pub unsafe fn FileGetRawDesc(arg_file: File) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileGetRawDesc(arg_file: File) -> ::std::os::raw::c_int;
        }
        FileGetRawDesc(arg_file)
    })
}
pub unsafe fn FileGetRawFlags(arg_file: File) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileGetRawFlags(arg_file: File) -> ::std::os::raw::c_int;
        }
        FileGetRawFlags(arg_file)
    })
}
pub unsafe fn FileGetRawMode(arg_file: File) -> mode_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileGetRawMode(arg_file: File) -> mode_t;
        }
        FileGetRawMode(arg_file)
    })
}
pub unsafe fn PathNameCreateTemporaryFile(
    arg_name: *const ::std::os::raw::c_char,
    arg_error_on_failure: bool,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameCreateTemporaryFile(
                arg_name: *const ::std::os::raw::c_char,
                arg_error_on_failure: bool,
            ) -> File;
        }
        PathNameCreateTemporaryFile(arg_name, arg_error_on_failure)
    })
}
pub unsafe fn PathNameOpenTemporaryFile(
    arg_path: *const ::std::os::raw::c_char,
    arg_mode: ::std::os::raw::c_int,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameOpenTemporaryFile(
                arg_path: *const ::std::os::raw::c_char,
                arg_mode: ::std::os::raw::c_int,
            ) -> File;
        }
        PathNameOpenTemporaryFile(arg_path, arg_mode)
    })
}
pub unsafe fn PathNameDeleteTemporaryFile(
    arg_name: *const ::std::os::raw::c_char,
    arg_error_on_failure: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameDeleteTemporaryFile(
                arg_name: *const ::std::os::raw::c_char,
                arg_error_on_failure: bool,
            ) -> bool;
        }
        PathNameDeleteTemporaryFile(arg_name, arg_error_on_failure)
    })
}
pub unsafe fn PathNameCreateTemporaryDir(
    arg_base: *const ::std::os::raw::c_char,
    arg_name: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameCreateTemporaryDir(
                arg_base: *const ::std::os::raw::c_char,
                arg_name: *const ::std::os::raw::c_char,
            );
        }
        PathNameCreateTemporaryDir(arg_base, arg_name)
    })
}
pub unsafe fn PathNameDeleteTemporaryDir(arg_name: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameDeleteTemporaryDir(arg_name: *const ::std::os::raw::c_char);
        }
        PathNameDeleteTemporaryDir(arg_name)
    })
}
pub unsafe fn TempTablespacePath(arg_path: *mut ::std::os::raw::c_char, arg_tablespace: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TempTablespacePath(arg_path: *mut ::std::os::raw::c_char, arg_tablespace: Oid);
        }
        TempTablespacePath(arg_path, arg_tablespace)
    })
}
pub unsafe fn AllocateFile(
    arg_name: *const ::std::os::raw::c_char,
    arg_mode: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AllocateFile(
                arg_name: *const ::std::os::raw::c_char,
                arg_mode: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        AllocateFile(arg_name, arg_mode)
    })
}
pub unsafe fn FreeFile(arg_file: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeFile(arg_file: *mut FILE) -> ::std::os::raw::c_int;
        }
        FreeFile(arg_file)
    })
}
pub unsafe fn OpenPipeStream(
    arg_command: *const ::std::os::raw::c_char,
    arg_mode: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenPipeStream(
                arg_command: *const ::std::os::raw::c_char,
                arg_mode: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        OpenPipeStream(arg_command, arg_mode)
    })
}
pub unsafe fn ClosePipeStream(arg_file: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ClosePipeStream(arg_file: *mut FILE) -> ::std::os::raw::c_int;
        }
        ClosePipeStream(arg_file)
    })
}
pub unsafe fn AllocateDir(arg_dirname: *const ::std::os::raw::c_char) -> *mut DIR {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AllocateDir(arg_dirname: *const ::std::os::raw::c_char) -> *mut DIR;
        }
        AllocateDir(arg_dirname)
    })
}
pub unsafe fn ReadDir(
    arg_dir: *mut DIR,
    arg_dirname: *const ::std::os::raw::c_char,
) -> *mut dirent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadDir(
                arg_dir: *mut DIR,
                arg_dirname: *const ::std::os::raw::c_char,
            ) -> *mut dirent;
        }
        ReadDir(arg_dir, arg_dirname)
    })
}
pub unsafe fn ReadDirExtended(
    arg_dir: *mut DIR,
    arg_dirname: *const ::std::os::raw::c_char,
    arg_elevel: ::std::os::raw::c_int,
) -> *mut dirent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadDirExtended(
                arg_dir: *mut DIR,
                arg_dirname: *const ::std::os::raw::c_char,
                arg_elevel: ::std::os::raw::c_int,
            ) -> *mut dirent;
        }
        ReadDirExtended(arg_dir, arg_dirname, arg_elevel)
    })
}
pub unsafe fn FreeDir(arg_dir: *mut DIR) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeDir(arg_dir: *mut DIR) -> ::std::os::raw::c_int;
        }
        FreeDir(arg_dir)
    })
}
pub unsafe fn OpenTransientFile(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenTransientFile(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        OpenTransientFile(arg_fileName, arg_fileFlags)
    })
}
pub unsafe fn OpenTransientFilePerm(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
    arg_fileMode: mode_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenTransientFilePerm(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
                arg_fileMode: mode_t,
            ) -> ::std::os::raw::c_int;
        }
        OpenTransientFilePerm(arg_fileName, arg_fileFlags, arg_fileMode)
    })
}
pub unsafe fn CloseTransientFile(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CloseTransientFile(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        CloseTransientFile(arg_fd)
    })
}
pub unsafe fn BasicOpenFile(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BasicOpenFile(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        BasicOpenFile(arg_fileName, arg_fileFlags)
    })
}
pub unsafe fn BasicOpenFilePerm(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
    arg_fileMode: mode_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BasicOpenFilePerm(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
                arg_fileMode: mode_t,
            ) -> ::std::os::raw::c_int;
        }
        BasicOpenFilePerm(arg_fileName, arg_fileFlags, arg_fileMode)
    })
}
pub unsafe fn AcquireExternalFD() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AcquireExternalFD() -> bool;
        }
        AcquireExternalFD()
    })
}
pub unsafe fn ReserveExternalFD() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReserveExternalFD();
        }
        ReserveExternalFD()
    })
}
pub unsafe fn ReleaseExternalFD() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReleaseExternalFD();
        }
        ReleaseExternalFD()
    })
}
pub unsafe fn MakePGDirectory(
    arg_directoryName: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MakePGDirectory(
                arg_directoryName: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        MakePGDirectory(arg_directoryName)
    })
}
pub unsafe fn InitFileAccess() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitFileAccess();
        }
        InitFileAccess()
    })
}
pub unsafe fn set_max_safe_fds() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_max_safe_fds();
        }
        set_max_safe_fds()
    })
}
pub unsafe fn closeAllVfds() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn closeAllVfds();
        }
        closeAllVfds()
    })
}
pub unsafe fn SetTempTablespaces(arg_tableSpaces: *mut Oid, arg_numSpaces: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetTempTablespaces(arg_tableSpaces: *mut Oid, arg_numSpaces: ::std::os::raw::c_int);
        }
        SetTempTablespaces(arg_tableSpaces, arg_numSpaces)
    })
}
pub unsafe fn TempTablespacesAreSet() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TempTablespacesAreSet() -> bool;
        }
        TempTablespacesAreSet()
    })
}
pub unsafe fn GetTempTablespaces(
    arg_tableSpaces: *mut Oid,
    arg_numSpaces: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetTempTablespaces(
                arg_tableSpaces: *mut Oid,
                arg_numSpaces: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        GetTempTablespaces(arg_tableSpaces, arg_numSpaces)
    })
}
pub unsafe fn GetNextTempTableSpace() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetNextTempTableSpace() -> Oid;
        }
        GetNextTempTableSpace()
    })
}
pub unsafe fn AtEOXact_Files(arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOXact_Files(arg_isCommit: bool);
        }
        AtEOXact_Files(arg_isCommit)
    })
}
pub unsafe fn AtEOSubXact_Files(
    arg_isCommit: bool,
    arg_mySubid: SubTransactionId,
    arg_parentSubid: SubTransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOSubXact_Files(
                arg_isCommit: bool,
                arg_mySubid: SubTransactionId,
                arg_parentSubid: SubTransactionId,
            );
        }
        AtEOSubXact_Files(arg_isCommit, arg_mySubid, arg_parentSubid)
    })
}
pub unsafe fn RemovePgTempFiles() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RemovePgTempFiles();
        }
        RemovePgTempFiles()
    })
}
pub unsafe fn RemovePgTempFilesInDir(
    arg_tmpdirname: *const ::std::os::raw::c_char,
    arg_missing_ok: bool,
    arg_unlink_all: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RemovePgTempFilesInDir(
                arg_tmpdirname: *const ::std::os::raw::c_char,
                arg_missing_ok: bool,
                arg_unlink_all: bool,
            );
        }
        RemovePgTempFilesInDir(arg_tmpdirname, arg_missing_ok, arg_unlink_all)
    })
}
pub unsafe fn looks_like_temp_rel_name(arg_name: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn looks_like_temp_rel_name(arg_name: *const ::std::os::raw::c_char) -> bool;
        }
        looks_like_temp_rel_name(arg_name)
    })
}
pub unsafe fn pg_fsync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fsync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fsync(arg_fd)
    })
}
pub unsafe fn pg_fsync_no_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fsync_no_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fsync_no_writethrough(arg_fd)
    })
}
pub unsafe fn pg_fsync_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fsync_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fsync_writethrough(arg_fd)
    })
}
pub unsafe fn pg_fdatasync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fdatasync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fdatasync(arg_fd)
    })
}
pub unsafe fn pg_flush_data(arg_fd: ::std::os::raw::c_int, arg_offset: off_t, arg_amount: off_t) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_flush_data(arg_fd: ::std::os::raw::c_int, arg_offset: off_t, arg_amount: off_t);
        }
        pg_flush_data(arg_fd, arg_offset, arg_amount)
    })
}
pub unsafe fn pg_pwritev_with_retry(
    arg_fd: ::std::os::raw::c_int,
    arg_iov: *const iovec,
    arg_iovcnt: ::std::os::raw::c_int,
    arg_offset: off_t,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_pwritev_with_retry(
                arg_fd: ::std::os::raw::c_int,
                arg_iov: *const iovec,
                arg_iovcnt: ::std::os::raw::c_int,
                arg_offset: off_t,
            ) -> isize;
        }
        pg_pwritev_with_retry(arg_fd, arg_iov, arg_iovcnt, arg_offset)
    })
}
pub unsafe fn pg_truncate(
    arg_path: *const ::std::os::raw::c_char,
    arg_length: off_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_truncate(
                arg_path: *const ::std::os::raw::c_char,
                arg_length: off_t,
            ) -> ::std::os::raw::c_int;
        }
        pg_truncate(arg_path, arg_length)
    })
}
pub unsafe fn fsync_fname(arg_fname: *const ::std::os::raw::c_char, arg_isdir: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fsync_fname(arg_fname: *const ::std::os::raw::c_char, arg_isdir: bool);
        }
        fsync_fname(arg_fname, arg_isdir)
    })
}
pub unsafe fn fsync_fname_ext(
    arg_fname: *const ::std::os::raw::c_char,
    arg_isdir: bool,
    arg_ignore_perm: bool,
    arg_elevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fsync_fname_ext(
                arg_fname: *const ::std::os::raw::c_char,
                arg_isdir: bool,
                arg_ignore_perm: bool,
                arg_elevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        fsync_fname_ext(arg_fname, arg_isdir, arg_ignore_perm, arg_elevel)
    })
}
pub unsafe fn durable_rename(
    arg_oldfile: *const ::std::os::raw::c_char,
    arg_newfile: *const ::std::os::raw::c_char,
    arg_loglevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn durable_rename(
                arg_oldfile: *const ::std::os::raw::c_char,
                arg_newfile: *const ::std::os::raw::c_char,
                arg_loglevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        durable_rename(arg_oldfile, arg_newfile, arg_loglevel)
    })
}
pub unsafe fn durable_unlink(
    arg_fname: *const ::std::os::raw::c_char,
    arg_loglevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn durable_unlink(
                arg_fname: *const ::std::os::raw::c_char,
                arg_loglevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        durable_unlink(arg_fname, arg_loglevel)
    })
}
pub unsafe fn durable_rename_excl(
    arg_oldfile: *const ::std::os::raw::c_char,
    arg_newfile: *const ::std::os::raw::c_char,
    arg_loglevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn durable_rename_excl(
                arg_oldfile: *const ::std::os::raw::c_char,
                arg_newfile: *const ::std::os::raw::c_char,
                arg_loglevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        durable_rename_excl(arg_oldfile, arg_newfile, arg_loglevel)
    })
}
pub unsafe fn SyncDataDirectory() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SyncDataDirectory();
        }
        SyncDataDirectory()
    })
}
pub unsafe fn data_sync_elevel(arg_elevel: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn data_sync_elevel(arg_elevel: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        data_sync_elevel(arg_elevel)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SharedFileSet {
    pub creator_pid: pid_t,
    pub number: uint32,
    pub mutex: slock_t,
    pub refcnt: ::std::os::raw::c_int,
    pub ntablespaces: ::std::os::raw::c_int,
    pub tablespaces: [Oid; 8usize],
}
pub unsafe fn SharedFileSetInit(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetInit(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment);
        }
        SharedFileSetInit(arg_fileset, arg_seg)
    })
}
pub unsafe fn SharedFileSetAttach(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetAttach(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment);
        }
        SharedFileSetAttach(arg_fileset, arg_seg)
    })
}
pub unsafe fn SharedFileSetCreate(
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetCreate(
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
            ) -> File;
        }
        SharedFileSetCreate(arg_fileset, arg_name)
    })
}
pub unsafe fn SharedFileSetOpen(
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
    arg_mode: ::std::os::raw::c_int,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetOpen(
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
                arg_mode: ::std::os::raw::c_int,
            ) -> File;
        }
        SharedFileSetOpen(arg_fileset, arg_name, arg_mode)
    })
}
pub unsafe fn SharedFileSetDelete(
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
    arg_error_on_failure: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetDelete(
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
                arg_error_on_failure: bool,
            ) -> bool;
        }
        SharedFileSetDelete(arg_fileset, arg_name, arg_error_on_failure)
    })
}
pub unsafe fn SharedFileSetDeleteAll(arg_fileset: *mut SharedFileSet) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetDeleteAll(arg_fileset: *mut SharedFileSet);
        }
        SharedFileSetDeleteAll(arg_fileset)
    })
}
pub unsafe fn SharedFileSetUnregister(arg_input_fileset: *mut SharedFileSet) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetUnregister(arg_input_fileset: *mut SharedFileSet);
        }
        SharedFileSetUnregister(arg_input_fileset)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedTuplestore {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedTuplestoreAccessor {
    _unused: [u8; 0],
}
pub unsafe fn sts_estimate(arg_participants: ::std::os::raw::c_int) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_estimate(arg_participants: ::std::os::raw::c_int) -> usize;
        }
        sts_estimate(arg_participants)
    })
}
pub unsafe fn sts_initialize(
    arg_sts: *mut SharedTuplestore,
    arg_participants: ::std::os::raw::c_int,
    arg_my_participant_number: ::std::os::raw::c_int,
    arg_meta_data_size: usize,
    arg_flags: ::std::os::raw::c_int,
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
) -> *mut SharedTuplestoreAccessor {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_initialize(
                arg_sts: *mut SharedTuplestore,
                arg_participants: ::std::os::raw::c_int,
                arg_my_participant_number: ::std::os::raw::c_int,
                arg_meta_data_size: usize,
                arg_flags: ::std::os::raw::c_int,
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
            ) -> *mut SharedTuplestoreAccessor;
        }
        sts_initialize(
            arg_sts,
            arg_participants,
            arg_my_participant_number,
            arg_meta_data_size,
            arg_flags,
            arg_fileset,
            arg_name,
        )
    })
}
pub unsafe fn sts_attach(
    arg_sts: *mut SharedTuplestore,
    arg_my_participant_number: ::std::os::raw::c_int,
    arg_fileset: *mut SharedFileSet,
) -> *mut SharedTuplestoreAccessor {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_attach(
                arg_sts: *mut SharedTuplestore,
                arg_my_participant_number: ::std::os::raw::c_int,
                arg_fileset: *mut SharedFileSet,
            ) -> *mut SharedTuplestoreAccessor;
        }
        sts_attach(arg_sts, arg_my_participant_number, arg_fileset)
    })
}
pub unsafe fn sts_end_write(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_end_write(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_end_write(arg_accessor)
    })
}
pub unsafe fn sts_reinitialize(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_reinitialize(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_reinitialize(arg_accessor)
    })
}
pub unsafe fn sts_begin_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_begin_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_begin_parallel_scan(arg_accessor)
    })
}
pub unsafe fn sts_end_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_end_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_end_parallel_scan(arg_accessor)
    })
}
pub unsafe fn sts_puttuple(
    arg_accessor: *mut SharedTuplestoreAccessor,
    arg_meta_data: *mut ::std::os::raw::c_void,
    arg_tuple: MinimalTuple,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_puttuple(
                arg_accessor: *mut SharedTuplestoreAccessor,
                arg_meta_data: *mut ::std::os::raw::c_void,
                arg_tuple: MinimalTuple,
            );
        }
        sts_puttuple(arg_accessor, arg_meta_data, arg_tuple)
    })
}
pub unsafe fn sts_parallel_scan_next(
    arg_accessor: *mut SharedTuplestoreAccessor,
    arg_meta_data: *mut ::std::os::raw::c_void,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_parallel_scan_next(
                arg_accessor: *mut SharedTuplestoreAccessor,
                arg_meta_data: *mut ::std::os::raw::c_void,
            ) -> MinimalTuple;
        }
        sts_parallel_scan_next(arg_accessor, arg_meta_data)
    })
}
pub type Timestamp = int64;
pub type TimestampTz = int64;
pub type TimeOffset = int64;
pub type fsec_t = int32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Interval {
    pub time: TimeOffset,
    pub day: int32,
    pub month: int32,
}
pub const SnapshotType_SNAPSHOT_MVCC: SnapshotType = 0;
pub const SnapshotType_SNAPSHOT_SELF: SnapshotType = 1;
pub const SnapshotType_SNAPSHOT_ANY: SnapshotType = 2;
pub const SnapshotType_SNAPSHOT_TOAST: SnapshotType = 3;
pub const SnapshotType_SNAPSHOT_DIRTY: SnapshotType = 4;
pub const SnapshotType_SNAPSHOT_HISTORIC_MVCC: SnapshotType = 5;
pub const SnapshotType_SNAPSHOT_NON_VACUUMABLE: SnapshotType = 6;
pub type SnapshotType = ::std::os::raw::c_uint;
pub type Snapshot = *mut SnapshotData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SnapshotData {
    pub snapshot_type: SnapshotType,
    pub xmin: TransactionId,
    pub xmax: TransactionId,
    pub xip: *mut TransactionId,
    pub xcnt: uint32,
    pub subxip: *mut TransactionId,
    pub subxcnt: int32,
    pub suboverflowed: bool,
    pub takenDuringRecovery: bool,
    pub copied: bool,
    pub curcid: CommandId,
    pub speculativeToken: uint32,
    pub vistest: *mut GlobalVisState,
    pub active_count: uint32,
    pub regd_count: uint32,
    pub ph_node: pairingheap_node,
    pub whenTaken: TimestampTz,
    pub lsn: XLogRecPtr,
    pub snapXactCompletionCount: uint64,
}
impl Default for SnapshotData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Relation = *mut RelationData;
pub type RelationPtr = *mut Relation;
pub unsafe fn RelationIdGetRelation(arg_relationId: Oid) -> Relation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationIdGetRelation(arg_relationId: Oid) -> Relation;
        }
        RelationIdGetRelation(arg_relationId)
    })
}
pub unsafe fn RelationClose(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationClose(arg_relation: Relation);
        }
        RelationClose(arg_relation)
    })
}
pub unsafe fn RelationGetFKeyList(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetFKeyList(arg_relation: Relation) -> *mut List;
        }
        RelationGetFKeyList(arg_relation)
    })
}
pub unsafe fn RelationGetIndexList(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexList(arg_relation: Relation) -> *mut List;
        }
        RelationGetIndexList(arg_relation)
    })
}
pub unsafe fn RelationGetStatExtList(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetStatExtList(arg_relation: Relation) -> *mut List;
        }
        RelationGetStatExtList(arg_relation)
    })
}
pub unsafe fn RelationGetPrimaryKeyIndex(arg_relation: Relation) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetPrimaryKeyIndex(arg_relation: Relation) -> Oid;
        }
        RelationGetPrimaryKeyIndex(arg_relation)
    })
}
pub unsafe fn RelationGetReplicaIndex(arg_relation: Relation) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetReplicaIndex(arg_relation: Relation) -> Oid;
        }
        RelationGetReplicaIndex(arg_relation)
    })
}
pub unsafe fn RelationGetIndexExpressions(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexExpressions(arg_relation: Relation) -> *mut List;
        }
        RelationGetIndexExpressions(arg_relation)
    })
}
pub unsafe fn RelationGetDummyIndexExpressions(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetDummyIndexExpressions(arg_relation: Relation) -> *mut List;
        }
        RelationGetDummyIndexExpressions(arg_relation)
    })
}
pub unsafe fn RelationGetIndexPredicate(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexPredicate(arg_relation: Relation) -> *mut List;
        }
        RelationGetIndexPredicate(arg_relation)
    })
}
pub unsafe fn RelationGetIndexRawAttOptions(arg_relation: Relation) -> *mut Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexRawAttOptions(arg_relation: Relation) -> *mut Datum;
        }
        RelationGetIndexRawAttOptions(arg_relation)
    })
}
pub unsafe fn RelationGetIndexAttOptions(
    arg_relation: Relation,
    arg_copy: bool,
) -> *mut *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexAttOptions(
                arg_relation: Relation,
                arg_copy: bool,
            ) -> *mut *mut bytea;
        }
        RelationGetIndexAttOptions(arg_relation, arg_copy)
    })
}
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_ALL: IndexAttrBitmapKind = 0;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_KEY: IndexAttrBitmapKind = 1;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_PRIMARY_KEY: IndexAttrBitmapKind = 2;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_IDENTITY_KEY: IndexAttrBitmapKind = 3;
pub type IndexAttrBitmapKind = ::std::os::raw::c_uint;
pub unsafe fn RelationGetIndexAttrBitmap(
    arg_relation: Relation,
    arg_attrKind: IndexAttrBitmapKind,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexAttrBitmap(
                arg_relation: Relation,
                arg_attrKind: IndexAttrBitmapKind,
            ) -> *mut Bitmapset;
        }
        RelationGetIndexAttrBitmap(arg_relation, arg_attrKind)
    })
}
pub unsafe fn RelationGetIdentityKeyBitmap(arg_relation: Relation) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIdentityKeyBitmap(arg_relation: Relation) -> *mut Bitmapset;
        }
        RelationGetIdentityKeyBitmap(arg_relation)
    })
}
pub unsafe fn RelationGetExclusionInfo(
    arg_indexRelation: Relation,
    arg_operators: *mut *mut Oid,
    arg_procs: *mut *mut Oid,
    arg_strategies: *mut *mut uint16,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetExclusionInfo(
                arg_indexRelation: Relation,
                arg_operators: *mut *mut Oid,
                arg_procs: *mut *mut Oid,
                arg_strategies: *mut *mut uint16,
            );
        }
        RelationGetExclusionInfo(arg_indexRelation, arg_operators, arg_procs, arg_strategies)
    })
}
pub unsafe fn RelationInitIndexAccessInfo(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationInitIndexAccessInfo(arg_relation: Relation);
        }
        RelationInitIndexAccessInfo(arg_relation)
    })
}
pub unsafe fn GetRelationPublicationActions(arg_relation: Relation) -> *mut PublicationActions {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetRelationPublicationActions(arg_relation: Relation) -> *mut PublicationActions;
        }
        GetRelationPublicationActions(arg_relation)
    })
}
pub unsafe fn RelationInitTableAccessMethod(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationInitTableAccessMethod(arg_relation: Relation);
        }
        RelationInitTableAccessMethod(arg_relation)
    })
}
pub unsafe fn errtable(arg_rel: Relation) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtable(arg_rel: Relation) -> ::std::os::raw::c_int;
        }
        errtable(arg_rel)
    })
}
pub unsafe fn errtablecol(
    arg_rel: Relation,
    arg_attnum: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtablecol(
                arg_rel: Relation,
                arg_attnum: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        errtablecol(arg_rel, arg_attnum)
    })
}
pub unsafe fn errtablecolname(
    arg_rel: Relation,
    arg_colname: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtablecolname(
                arg_rel: Relation,
                arg_colname: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        errtablecolname(arg_rel, arg_colname)
    })
}
pub unsafe fn errtableconstraint(
    arg_rel: Relation,
    arg_conname: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtableconstraint(
                arg_rel: Relation,
                arg_conname: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        errtableconstraint(arg_rel, arg_conname)
    })
}
pub unsafe fn RelationCacheInitialize() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitialize();
        }
        RelationCacheInitialize()
    })
}
pub unsafe fn RelationCacheInitializePhase2() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitializePhase2();
        }
        RelationCacheInitializePhase2()
    })
}
pub unsafe fn RelationCacheInitializePhase3() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitializePhase3();
        }
        RelationCacheInitializePhase3()
    })
}
pub unsafe fn RelationBuildLocalRelation(
    arg_relname: *const ::std::os::raw::c_char,
    arg_relnamespace: Oid,
    arg_tupDesc: TupleDesc,
    arg_relid: Oid,
    arg_accessmtd: Oid,
    arg_relfilenode: Oid,
    arg_reltablespace: Oid,
    arg_shared_relation: bool,
    arg_mapped_relation: bool,
    arg_relpersistence: ::std::os::raw::c_char,
    arg_relkind: ::std::os::raw::c_char,
) -> Relation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationBuildLocalRelation(
                arg_relname: *const ::std::os::raw::c_char,
                arg_relnamespace: Oid,
                arg_tupDesc: TupleDesc,
                arg_relid: Oid,
                arg_accessmtd: Oid,
                arg_relfilenode: Oid,
                arg_reltablespace: Oid,
                arg_shared_relation: bool,
                arg_mapped_relation: bool,
                arg_relpersistence: ::std::os::raw::c_char,
                arg_relkind: ::std::os::raw::c_char,
            ) -> Relation;
        }
        RelationBuildLocalRelation(
            arg_relname,
            arg_relnamespace,
            arg_tupDesc,
            arg_relid,
            arg_accessmtd,
            arg_relfilenode,
            arg_reltablespace,
            arg_shared_relation,
            arg_mapped_relation,
            arg_relpersistence,
            arg_relkind,
        )
    })
}
pub unsafe fn RelationSetNewRelfilenode(
    arg_relation: Relation,
    arg_persistence: ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationSetNewRelfilenode(
                arg_relation: Relation,
                arg_persistence: ::std::os::raw::c_char,
            );
        }
        RelationSetNewRelfilenode(arg_relation, arg_persistence)
    })
}
pub unsafe fn RelationAssumeNewRelfilenode(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationAssumeNewRelfilenode(arg_relation: Relation);
        }
        RelationAssumeNewRelfilenode(arg_relation)
    })
}
pub unsafe fn RelationForgetRelation(arg_rid: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationForgetRelation(arg_rid: Oid);
        }
        RelationForgetRelation(arg_rid)
    })
}
pub unsafe fn RelationCacheInvalidateEntry(arg_relationId: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInvalidateEntry(arg_relationId: Oid);
        }
        RelationCacheInvalidateEntry(arg_relationId)
    })
}
pub unsafe fn RelationCacheInvalidate(arg_debug_discard: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInvalidate(arg_debug_discard: bool);
        }
        RelationCacheInvalidate(arg_debug_discard)
    })
}
pub unsafe fn RelationCloseSmgrByOid(arg_relationId: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCloseSmgrByOid(arg_relationId: Oid);
        }
        RelationCloseSmgrByOid(arg_relationId)
    })
}
pub unsafe fn AssertPendingSyncs_RelationCache() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AssertPendingSyncs_RelationCache();
        }
        AssertPendingSyncs_RelationCache()
    })
}
pub unsafe fn AtEOXact_RelationCache(arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOXact_RelationCache(arg_isCommit: bool);
        }
        AtEOXact_RelationCache(arg_isCommit)
    })
}
pub unsafe fn AtEOSubXact_RelationCache(
    arg_isCommit: bool,
    arg_mySubid: SubTransactionId,
    arg_parentSubid: SubTransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOSubXact_RelationCache(
                arg_isCommit: bool,
                arg_mySubid: SubTransactionId,
                arg_parentSubid: SubTransactionId,
            );
        }
        AtEOSubXact_RelationCache(arg_isCommit, arg_mySubid, arg_parentSubid)
    })
}
pub unsafe fn RelationIdIsInInitFile(arg_relationId: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationIdIsInInitFile(arg_relationId: Oid) -> bool;
        }
        RelationIdIsInInitFile(arg_relationId)
    })
}
pub unsafe fn RelationCacheInitFilePreInvalidate() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitFilePreInvalidate();
        }
        RelationCacheInitFilePreInvalidate()
    })
}
pub unsafe fn RelationCacheInitFilePostInvalidate() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitFilePostInvalidate();
        }
        RelationCacheInitFilePostInvalidate()
    })
}
pub unsafe fn RelationCacheInitFileRemove() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitFileRemove();
        }
        RelationCacheInitFileRemove()
    })
}
extern "C" {
    pub static mut criticalRelcachesBuilt: bool;
}
extern "C" {
    pub static mut criticalSharedRelcachesBuilt: bool;
}
pub type SortSupport = *mut SortSupportData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortSupportData {
    pub ssup_cxt: MemoryContext,
    pub ssup_collation: Oid,
    pub ssup_reverse: bool,
    pub ssup_nulls_first: bool,
    pub ssup_attno: AttrNumber,
    pub ssup_extra: *mut ::std::os::raw::c_void,
    pub comparator: ::std::option::Option<
        unsafe extern "C" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::std::os::raw::c_int,
    >,
    pub abbreviate: bool,
    pub abbrev_converter:
        ::std::option::Option<unsafe extern "C" fn(original: Datum, ssup: SortSupport) -> Datum>,
    pub abbrev_abort: ::std::option::Option<
        unsafe extern "C" fn(memtupcount: ::std::os::raw::c_int, ssup: SortSupport) -> bool,
    >,
    pub abbrev_full_comparator: ::std::option::Option<
        unsafe extern "C" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::std::os::raw::c_int,
    >,
}
impl Default for SortSupportData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn PrepareSortSupportComparisonShim(arg_cmpFunc: Oid, arg_ssup: SortSupport) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PrepareSortSupportComparisonShim(arg_cmpFunc: Oid, arg_ssup: SortSupport);
        }
        PrepareSortSupportComparisonShim(arg_cmpFunc, arg_ssup)
    })
}
pub unsafe fn PrepareSortSupportFromOrderingOp(arg_orderingOp: Oid, arg_ssup: SortSupport) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PrepareSortSupportFromOrderingOp(arg_orderingOp: Oid, arg_ssup: SortSupport);
        }
        PrepareSortSupportFromOrderingOp(arg_orderingOp, arg_ssup)
    })
}
pub unsafe fn PrepareSortSupportFromIndexRel(
    arg_indexRel: Relation,
    arg_strategy: int16,
    arg_ssup: SortSupport,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PrepareSortSupportFromIndexRel(
                arg_indexRel: Relation,
                arg_strategy: int16,
                arg_ssup: SortSupport,
            );
        }
        PrepareSortSupportFromIndexRel(arg_indexRel, arg_strategy, arg_ssup)
    })
}
pub unsafe fn PrepareSortSupportFromGistIndexRel(arg_indexRel: Relation, arg_ssup: SortSupport) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PrepareSortSupportFromGistIndexRel(arg_indexRel: Relation, arg_ssup: SortSupport);
        }
        PrepareSortSupportFromGistIndexRel(arg_indexRel, arg_ssup)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexTupleData {
    pub t_tid: ItemPointerData,
    pub t_info: ::std::os::raw::c_ushort,
}
pub type IndexTuple = *mut IndexTupleData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexAttributeBitMapData {
    pub bits: [bits8; 4usize],
}
pub type IndexAttributeBitMap = *mut IndexAttributeBitMapData;
pub unsafe fn index_form_tuple(
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_form_tuple(
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> IndexTuple;
        }
        index_form_tuple(arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn nocache_index_getattr(
    arg_tup: IndexTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_tupleDesc: TupleDesc,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nocache_index_getattr(
                arg_tup: IndexTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_tupleDesc: TupleDesc,
            ) -> Datum;
        }
        nocache_index_getattr(arg_tup, arg_attnum, arg_tupleDesc)
    })
}
pub unsafe fn index_deform_tuple(
    arg_tup: IndexTuple,
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_deform_tuple(
                arg_tup: IndexTuple,
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        index_deform_tuple(arg_tup, arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn index_deform_tuple_internal(
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
    arg_tp: *mut ::std::os::raw::c_char,
    arg_bp: *mut bits8,
    arg_hasnulls: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_deform_tuple_internal(
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
                arg_tp: *mut ::std::os::raw::c_char,
                arg_bp: *mut bits8,
                arg_hasnulls: ::std::os::raw::c_int,
            );
        }
        index_deform_tuple_internal(
            arg_tupleDescriptor,
            arg_values,
            arg_isnull,
            arg_tp,
            arg_bp,
            arg_hasnulls,
        )
    })
}
pub unsafe fn CopyIndexTuple(arg_source: IndexTuple) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CopyIndexTuple(arg_source: IndexTuple) -> IndexTuple;
        }
        CopyIndexTuple(arg_source)
    })
}
pub unsafe fn index_truncate_tuple(
    arg_sourceDescriptor: TupleDesc,
    arg_source: IndexTuple,
    arg_leavenatts: ::std::os::raw::c_int,
) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_truncate_tuple(
                arg_sourceDescriptor: TupleDesc,
                arg_source: IndexTuple,
                arg_leavenatts: ::std::os::raw::c_int,
            ) -> IndexTuple;
        }
        index_truncate_tuple(arg_sourceDescriptor, arg_source, arg_leavenatts)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplesortstate {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sharedsort {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortCoordinateData {
    pub isWorker: bool,
    pub nParticipants: ::std::os::raw::c_int,
    pub sharedsort: *mut Sharedsort,
}
impl Default for SortCoordinateData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SortCoordinate = *mut SortCoordinateData;
pub const TuplesortMethod_SORT_TYPE_STILL_IN_PROGRESS: TuplesortMethod = 0;
pub const TuplesortMethod_SORT_TYPE_TOP_N_HEAPSORT: TuplesortMethod = 1;
pub const TuplesortMethod_SORT_TYPE_QUICKSORT: TuplesortMethod = 2;
pub const TuplesortMethod_SORT_TYPE_EXTERNAL_SORT: TuplesortMethod = 4;
pub const TuplesortMethod_SORT_TYPE_EXTERNAL_MERGE: TuplesortMethod = 8;
pub type TuplesortMethod = ::std::os::raw::c_uint;
pub const TuplesortSpaceType_SORT_SPACE_TYPE_DISK: TuplesortSpaceType = 0;
pub const TuplesortSpaceType_SORT_SPACE_TYPE_MEMORY: TuplesortSpaceType = 1;
pub type TuplesortSpaceType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TuplesortInstrumentation {
    pub sortMethod: TuplesortMethod,
    pub spaceType: TuplesortSpaceType,
    pub spaceUsed: int64,
}
impl Default for TuplesortInstrumentation {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn tuplesort_begin_heap(
    arg_tupDesc: TupleDesc,
    arg_nkeys: ::std::os::raw::c_int,
    arg_attNums: *mut AttrNumber,
    arg_sortOperators: *mut Oid,
    arg_sortCollations: *mut Oid,
    arg_nullsFirstFlags: *mut bool,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_heap(
                arg_tupDesc: TupleDesc,
                arg_nkeys: ::std::os::raw::c_int,
                arg_attNums: *mut AttrNumber,
                arg_sortOperators: *mut Oid,
                arg_sortCollations: *mut Oid,
                arg_nullsFirstFlags: *mut bool,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_heap(
            arg_tupDesc,
            arg_nkeys,
            arg_attNums,
            arg_sortOperators,
            arg_sortCollations,
            arg_nullsFirstFlags,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_cluster(
    arg_tupDesc: TupleDesc,
    arg_indexRel: Relation,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_cluster(
                arg_tupDesc: TupleDesc,
                arg_indexRel: Relation,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_cluster(
            arg_tupDesc,
            arg_indexRel,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_index_btree(
    arg_heapRel: Relation,
    arg_indexRel: Relation,
    arg_enforceUnique: bool,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_index_btree(
                arg_heapRel: Relation,
                arg_indexRel: Relation,
                arg_enforceUnique: bool,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_index_btree(
            arg_heapRel,
            arg_indexRel,
            arg_enforceUnique,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_index_hash(
    arg_heapRel: Relation,
    arg_indexRel: Relation,
    arg_high_mask: uint32,
    arg_low_mask: uint32,
    arg_max_buckets: uint32,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_index_hash(
                arg_heapRel: Relation,
                arg_indexRel: Relation,
                arg_high_mask: uint32,
                arg_low_mask: uint32,
                arg_max_buckets: uint32,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_index_hash(
            arg_heapRel,
            arg_indexRel,
            arg_high_mask,
            arg_low_mask,
            arg_max_buckets,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_index_gist(
    arg_heapRel: Relation,
    arg_indexRel: Relation,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_index_gist(
                arg_heapRel: Relation,
                arg_indexRel: Relation,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_index_gist(
            arg_heapRel,
            arg_indexRel,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_datum(
    arg_datumType: Oid,
    arg_sortOperator: Oid,
    arg_sortCollation: Oid,
    arg_nullsFirstFlag: bool,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_datum(
                arg_datumType: Oid,
                arg_sortOperator: Oid,
                arg_sortCollation: Oid,
                arg_nullsFirstFlag: bool,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_datum(
            arg_datumType,
            arg_sortOperator,
            arg_sortCollation,
            arg_nullsFirstFlag,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_set_bound(arg_state: *mut Tuplesortstate, arg_bound: int64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_set_bound(arg_state: *mut Tuplesortstate, arg_bound: int64);
        }
        tuplesort_set_bound(arg_state, arg_bound)
    })
}
pub unsafe fn tuplesort_used_bound(arg_state: *mut Tuplesortstate) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_used_bound(arg_state: *mut Tuplesortstate) -> bool;
        }
        tuplesort_used_bound(arg_state)
    })
}
pub unsafe fn tuplesort_puttupleslot(
    arg_state: *mut Tuplesortstate,
    arg_slot: *mut TupleTableSlot,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_puttupleslot(
                arg_state: *mut Tuplesortstate,
                arg_slot: *mut TupleTableSlot,
            );
        }
        tuplesort_puttupleslot(arg_state, arg_slot)
    })
}
pub unsafe fn tuplesort_putheaptuple(arg_state: *mut Tuplesortstate, arg_tup: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_putheaptuple(arg_state: *mut Tuplesortstate, arg_tup: HeapTuple);
        }
        tuplesort_putheaptuple(arg_state, arg_tup)
    })
}
pub unsafe fn tuplesort_putindextuplevalues(
    arg_state: *mut Tuplesortstate,
    arg_rel: Relation,
    arg_self_: ItemPointer,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_putindextuplevalues(
                arg_state: *mut Tuplesortstate,
                arg_rel: Relation,
                arg_self_: ItemPointer,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        tuplesort_putindextuplevalues(arg_state, arg_rel, arg_self_, arg_values, arg_isnull)
    })
}
pub unsafe fn tuplesort_putdatum(arg_state: *mut Tuplesortstate, arg_val: Datum, arg_isNull: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_putdatum(arg_state: *mut Tuplesortstate, arg_val: Datum, arg_isNull: bool);
        }
        tuplesort_putdatum(arg_state, arg_val, arg_isNull)
    })
}
pub unsafe fn tuplesort_performsort(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_performsort(arg_state: *mut Tuplesortstate);
        }
        tuplesort_performsort(arg_state)
    })
}
pub unsafe fn tuplesort_gettupleslot(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
    arg_copy: bool,
    arg_slot: *mut TupleTableSlot,
    arg_abbrev: *mut Datum,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_gettupleslot(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
                arg_copy: bool,
                arg_slot: *mut TupleTableSlot,
                arg_abbrev: *mut Datum,
            ) -> bool;
        }
        tuplesort_gettupleslot(arg_state, arg_forward, arg_copy, arg_slot, arg_abbrev)
    })
}
pub unsafe fn tuplesort_getheaptuple(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_getheaptuple(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
            ) -> HeapTuple;
        }
        tuplesort_getheaptuple(arg_state, arg_forward)
    })
}
pub unsafe fn tuplesort_getindextuple(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_getindextuple(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
            ) -> IndexTuple;
        }
        tuplesort_getindextuple(arg_state, arg_forward)
    })
}
pub unsafe fn tuplesort_getdatum(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
    arg_val: *mut Datum,
    arg_isNull: *mut bool,
    arg_abbrev: *mut Datum,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_getdatum(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
                arg_val: *mut Datum,
                arg_isNull: *mut bool,
                arg_abbrev: *mut Datum,
            ) -> bool;
        }
        tuplesort_getdatum(arg_state, arg_forward, arg_val, arg_isNull, arg_abbrev)
    })
}
pub unsafe fn tuplesort_skiptuples(
    arg_state: *mut Tuplesortstate,
    arg_ntuples: int64,
    arg_forward: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_skiptuples(
                arg_state: *mut Tuplesortstate,
                arg_ntuples: int64,
                arg_forward: bool,
            ) -> bool;
        }
        tuplesort_skiptuples(arg_state, arg_ntuples, arg_forward)
    })
}
pub unsafe fn tuplesort_end(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_end(arg_state: *mut Tuplesortstate);
        }
        tuplesort_end(arg_state)
    })
}
pub unsafe fn tuplesort_reset(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_reset(arg_state: *mut Tuplesortstate);
        }
        tuplesort_reset(arg_state)
    })
}
pub unsafe fn tuplesort_get_stats(
    arg_state: *mut Tuplesortstate,
    arg_stats: *mut TuplesortInstrumentation,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_get_stats(
                arg_state: *mut Tuplesortstate,
                arg_stats: *mut TuplesortInstrumentation,
            );
        }
        tuplesort_get_stats(arg_state, arg_stats)
    })
}
pub unsafe fn tuplesort_method_name(arg_m: TuplesortMethod) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_method_name(arg_m: TuplesortMethod) -> *const ::std::os::raw::c_char;
        }
        tuplesort_method_name(arg_m)
    })
}
pub unsafe fn tuplesort_space_type_name(
    arg_t: TuplesortSpaceType,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_space_type_name(
                arg_t: TuplesortSpaceType,
            ) -> *const ::std::os::raw::c_char;
        }
        tuplesort_space_type_name(arg_t)
    })
}
pub unsafe fn tuplesort_merge_order(arg_allowedMem: int64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_merge_order(arg_allowedMem: int64) -> ::std::os::raw::c_int;
        }
        tuplesort_merge_order(arg_allowedMem)
    })
}
pub unsafe fn tuplesort_estimate_shared(arg_nworkers: ::std::os::raw::c_int) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_estimate_shared(arg_nworkers: ::std::os::raw::c_int) -> Size;
        }
        tuplesort_estimate_shared(arg_nworkers)
    })
}
pub unsafe fn tuplesort_initialize_shared(
    arg_shared: *mut Sharedsort,
    arg_nWorkers: ::std::os::raw::c_int,
    arg_seg: *mut dsm_segment,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_initialize_shared(
                arg_shared: *mut Sharedsort,
                arg_nWorkers: ::std::os::raw::c_int,
                arg_seg: *mut dsm_segment,
            );
        }
        tuplesort_initialize_shared(arg_shared, arg_nWorkers, arg_seg)
    })
}
pub unsafe fn tuplesort_attach_shared(arg_shared: *mut Sharedsort, arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_attach_shared(arg_shared: *mut Sharedsort, arg_seg: *mut dsm_segment);
        }
        tuplesort_attach_shared(arg_shared, arg_seg)
    })
}
pub unsafe fn tuplesort_rescan(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_rescan(arg_state: *mut Tuplesortstate);
        }
        tuplesort_rescan(arg_state)
    })
}
pub unsafe fn tuplesort_markpos(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_markpos(arg_state: *mut Tuplesortstate);
        }
        tuplesort_markpos(arg_state)
    })
}
pub unsafe fn tuplesort_restorepos(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_restorepos(arg_state: *mut Tuplesortstate);
        }
        tuplesort_restorepos(arg_state)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplestorestate {
    _unused: [u8; 0],
}
pub unsafe fn tuplestore_begin_heap(
    arg_randomAccess: bool,
    arg_interXact: bool,
    arg_maxKBytes: ::std::os::raw::c_int,
) -> *mut Tuplestorestate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_begin_heap(
                arg_randomAccess: bool,
                arg_interXact: bool,
                arg_maxKBytes: ::std::os::raw::c_int,
            ) -> *mut Tuplestorestate;
        }
        tuplestore_begin_heap(arg_randomAccess, arg_interXact, arg_maxKBytes)
    })
}
pub unsafe fn tuplestore_set_eflags(
    arg_state: *mut Tuplestorestate,
    arg_eflags: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_set_eflags(
                arg_state: *mut Tuplestorestate,
                arg_eflags: ::std::os::raw::c_int,
            );
        }
        tuplestore_set_eflags(arg_state, arg_eflags)
    })
}
pub unsafe fn tuplestore_puttupleslot(
    arg_state: *mut Tuplestorestate,
    arg_slot: *mut TupleTableSlot,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_puttupleslot(
                arg_state: *mut Tuplestorestate,
                arg_slot: *mut TupleTableSlot,
            );
        }
        tuplestore_puttupleslot(arg_state, arg_slot)
    })
}
pub unsafe fn tuplestore_puttuple(arg_state: *mut Tuplestorestate, arg_tuple: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_puttuple(arg_state: *mut Tuplestorestate, arg_tuple: HeapTuple);
        }
        tuplestore_puttuple(arg_state, arg_tuple)
    })
}
pub unsafe fn tuplestore_putvalues(
    arg_state: *mut Tuplestorestate,
    arg_tdesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_putvalues(
                arg_state: *mut Tuplestorestate,
                arg_tdesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        tuplestore_putvalues(arg_state, arg_tdesc, arg_values, arg_isnull)
    })
}
pub unsafe fn tuplestore_alloc_read_pointer(
    arg_state: *mut Tuplestorestate,
    arg_eflags: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_alloc_read_pointer(
                arg_state: *mut Tuplestorestate,
                arg_eflags: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        tuplestore_alloc_read_pointer(arg_state, arg_eflags)
    })
}
pub unsafe fn tuplestore_select_read_pointer(
    arg_state: *mut Tuplestorestate,
    arg_ptr: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_select_read_pointer(
                arg_state: *mut Tuplestorestate,
                arg_ptr: ::std::os::raw::c_int,
            );
        }
        tuplestore_select_read_pointer(arg_state, arg_ptr)
    })
}
pub unsafe fn tuplestore_copy_read_pointer(
    arg_state: *mut Tuplestorestate,
    arg_srcptr: ::std::os::raw::c_int,
    arg_destptr: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_copy_read_pointer(
                arg_state: *mut Tuplestorestate,
                arg_srcptr: ::std::os::raw::c_int,
                arg_destptr: ::std::os::raw::c_int,
            );
        }
        tuplestore_copy_read_pointer(arg_state, arg_srcptr, arg_destptr)
    })
}
pub unsafe fn tuplestore_trim(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_trim(arg_state: *mut Tuplestorestate);
        }
        tuplestore_trim(arg_state)
    })
}
pub unsafe fn tuplestore_in_memory(arg_state: *mut Tuplestorestate) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_in_memory(arg_state: *mut Tuplestorestate) -> bool;
        }
        tuplestore_in_memory(arg_state)
    })
}
pub unsafe fn tuplestore_gettupleslot(
    arg_state: *mut Tuplestorestate,
    arg_forward: bool,
    arg_copy: bool,
    arg_slot: *mut TupleTableSlot,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_gettupleslot(
                arg_state: *mut Tuplestorestate,
                arg_forward: bool,
                arg_copy: bool,
                arg_slot: *mut TupleTableSlot,
            ) -> bool;
        }
        tuplestore_gettupleslot(arg_state, arg_forward, arg_copy, arg_slot)
    })
}
pub unsafe fn tuplestore_advance(arg_state: *mut Tuplestorestate, arg_forward: bool) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_advance(arg_state: *mut Tuplestorestate, arg_forward: bool) -> bool;
        }
        tuplestore_advance(arg_state, arg_forward)
    })
}
pub unsafe fn tuplestore_skiptuples(
    arg_state: *mut Tuplestorestate,
    arg_ntuples: int64,
    arg_forward: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_skiptuples(
                arg_state: *mut Tuplestorestate,
                arg_ntuples: int64,
                arg_forward: bool,
            ) -> bool;
        }
        tuplestore_skiptuples(arg_state, arg_ntuples, arg_forward)
    })
}
pub unsafe fn tuplestore_tuple_count(arg_state: *mut Tuplestorestate) -> int64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_tuple_count(arg_state: *mut Tuplestorestate) -> int64;
        }
        tuplestore_tuple_count(arg_state)
    })
}
pub unsafe fn tuplestore_ateof(arg_state: *mut Tuplestorestate) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_ateof(arg_state: *mut Tuplestorestate) -> bool;
        }
        tuplestore_ateof(arg_state)
    })
}
pub unsafe fn tuplestore_rescan(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_rescan(arg_state: *mut Tuplestorestate);
        }
        tuplestore_rescan(arg_state)
    })
}
pub unsafe fn tuplestore_clear(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_clear(arg_state: *mut Tuplestorestate);
        }
        tuplestore_clear(arg_state)
    })
}
pub unsafe fn tuplestore_end(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_end(arg_state: *mut Tuplestorestate);
        }
        tuplestore_end(arg_state)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelHashJoinState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyMultiInsertBuffer {
    _unused: [u8; 0],
}
pub type ExprStateEvalFunc = ::std::option::Option<
    unsafe extern "C" fn(
        expression: *mut ExprState,
        econtext: *mut ExprContext,
        isNull: *mut bool,
    ) -> Datum,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprState {
    pub tag: NodeTag,
    pub flags: uint8,
    pub resnull: bool,
    pub resvalue: Datum,
    pub resultslot: *mut TupleTableSlot,
    pub steps: *mut ExprEvalStep,
    pub evalfunc: ExprStateEvalFunc,
    pub expr: *mut Expr,
    pub evalfunc_private: *mut ::std::os::raw::c_void,
    pub steps_len: ::std::os::raw::c_int,
    pub steps_alloc: ::std::os::raw::c_int,
    pub parent: *mut PlanState,
    pub ext_params: ParamListInfo,
    pub innermost_caseval: *mut Datum,
    pub innermost_casenull: *mut bool,
    pub innermost_domainval: *mut Datum,
    pub innermost_domainnull: *mut bool,
}
impl Default for ExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexInfo {
    pub type_: NodeTag,
    pub ii_NumIndexAttrs: ::std::os::raw::c_int,
    pub ii_NumIndexKeyAttrs: ::std::os::raw::c_int,
    pub ii_IndexAttrNumbers: [AttrNumber; 32usize],
    pub ii_Expressions: *mut List,
    pub ii_ExpressionsState: *mut List,
    pub ii_Predicate: *mut List,
    pub ii_PredicateState: *mut ExprState,
    pub ii_ExclusionOps: *mut Oid,
    pub ii_ExclusionProcs: *mut Oid,
    pub ii_ExclusionStrats: *mut uint16,
    pub ii_UniqueOps: *mut Oid,
    pub ii_UniqueProcs: *mut Oid,
    pub ii_UniqueStrats: *mut uint16,
    pub ii_OpclassOptions: *mut Datum,
    pub ii_Unique: bool,
    pub ii_ReadyForInserts: bool,
    pub ii_Concurrent: bool,
    pub ii_BrokenHotChain: bool,
    pub ii_ParallelWorkers: ::std::os::raw::c_int,
    pub ii_Am: Oid,
    pub ii_AmCache: *mut ::std::os::raw::c_void,
    pub ii_Context: MemoryContext,
}
impl Default for IndexInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExprContextCallbackFunction = ::std::option::Option<unsafe extern "C" fn(arg: Datum)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprContext_CB {
    pub next: *mut ExprContext_CB,
    pub function: ExprContextCallbackFunction,
    pub arg: Datum,
}
impl Default for ExprContext_CB {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprContext {
    pub type_: NodeTag,
    pub ecxt_scantuple: *mut TupleTableSlot,
    pub ecxt_innertuple: *mut TupleTableSlot,
    pub ecxt_outertuple: *mut TupleTableSlot,
    pub ecxt_per_query_memory: MemoryContext,
    pub ecxt_per_tuple_memory: MemoryContext,
    pub ecxt_param_exec_vals: *mut ParamExecData,
    pub ecxt_param_list_info: ParamListInfo,
    pub ecxt_aggvalues: *mut Datum,
    pub ecxt_aggnulls: *mut bool,
    pub caseValue_datum: Datum,
    pub caseValue_isNull: bool,
    pub domainValue_datum: Datum,
    pub domainValue_isNull: bool,
    pub ecxt_estate: *mut EState,
    pub ecxt_callbacks: *mut ExprContext_CB,
}
impl Default for ExprContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ExprDoneCond_ExprSingleResult: ExprDoneCond = 0;
pub const ExprDoneCond_ExprMultipleResult: ExprDoneCond = 1;
pub const ExprDoneCond_ExprEndResult: ExprDoneCond = 2;
pub type ExprDoneCond = ::std::os::raw::c_uint;
pub const SetFunctionReturnMode_SFRM_ValuePerCall: SetFunctionReturnMode = 1;
pub const SetFunctionReturnMode_SFRM_Materialize: SetFunctionReturnMode = 2;
pub const SetFunctionReturnMode_SFRM_Materialize_Random: SetFunctionReturnMode = 4;
pub const SetFunctionReturnMode_SFRM_Materialize_Preferred: SetFunctionReturnMode = 8;
pub type SetFunctionReturnMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReturnSetInfo {
    pub type_: NodeTag,
    pub econtext: *mut ExprContext,
    pub expectedDesc: TupleDesc,
    pub allowedModes: ::std::os::raw::c_int,
    pub returnMode: SetFunctionReturnMode,
    pub isDone: ExprDoneCond,
    pub setResult: *mut Tuplestorestate,
    pub setDesc: TupleDesc,
}
impl Default for ReturnSetInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectionInfo {
    pub type_: NodeTag,
    pub pi_state: ExprState,
    pub pi_exprContext: *mut ExprContext,
}
impl Default for ProjectionInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JunkFilter {
    pub type_: NodeTag,
    pub jf_targetList: *mut List,
    pub jf_cleanTupType: TupleDesc,
    pub jf_cleanMap: *mut AttrNumber,
    pub jf_resultSlot: *mut TupleTableSlot,
}
impl Default for JunkFilter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictSetState {
    pub type_: NodeTag,
    pub oc_Existing: *mut TupleTableSlot,
    pub oc_ProjSlot: *mut TupleTableSlot,
    pub oc_ProjInfo: *mut ProjectionInfo,
    pub oc_WhereClause: *mut ExprState,
}
impl Default for OnConflictSetState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultRelInfo {
    pub type_: NodeTag,
    pub ri_RangeTableIndex: Index,
    pub ri_RelationDesc: Relation,
    pub ri_NumIndices: ::std::os::raw::c_int,
    pub ri_IndexRelationDescs: RelationPtr,
    pub ri_IndexRelationInfo: *mut *mut IndexInfo,
    pub ri_RowIdAttNo: AttrNumber,
    pub ri_projectNew: *mut ProjectionInfo,
    pub ri_newTupleSlot: *mut TupleTableSlot,
    pub ri_oldTupleSlot: *mut TupleTableSlot,
    pub ri_projectNewInfoValid: bool,
    pub ri_TrigDesc: *mut TriggerDesc,
    pub ri_TrigFunctions: *mut FmgrInfo,
    pub ri_TrigWhenExprs: *mut *mut ExprState,
    pub ri_TrigInstrument: *mut Instrumentation,
    pub ri_ReturningSlot: *mut TupleTableSlot,
    pub ri_TrigOldSlot: *mut TupleTableSlot,
    pub ri_TrigNewSlot: *mut TupleTableSlot,
    pub ri_FdwRoutine: *mut FdwRoutine,
    pub ri_FdwState: *mut ::std::os::raw::c_void,
    pub ri_usesFdwDirectModify: bool,
    pub ri_NumSlots: ::std::os::raw::c_int,
    pub ri_NumSlotsInitialized: ::std::os::raw::c_int,
    pub ri_BatchSize: ::std::os::raw::c_int,
    pub ri_Slots: *mut *mut TupleTableSlot,
    pub ri_PlanSlots: *mut *mut TupleTableSlot,
    pub ri_WithCheckOptions: *mut List,
    pub ri_WithCheckOptionExprs: *mut List,
    pub ri_ConstraintExprs: *mut *mut ExprState,
    pub ri_GeneratedExprs: *mut *mut ExprState,
    pub ri_NumGeneratedNeeded: ::std::os::raw::c_int,
    pub ri_returningList: *mut List,
    pub ri_projectReturning: *mut ProjectionInfo,
    pub ri_onConflictArbiterIndexes: *mut List,
    pub ri_onConflict: *mut OnConflictSetState,
    pub ri_PartitionCheckExpr: *mut ExprState,
    pub ri_RootResultRelInfo: *mut ResultRelInfo,
    pub ri_RootToPartitionMap: *mut TupleConversionMap,
    pub ri_PartitionTupleSlot: *mut TupleTableSlot,
    pub ri_ChildToRootMap: *mut TupleConversionMap,
    pub ri_ChildToRootMapValid: bool,
    pub ri_CopyMultiInsertBuffer: *mut CopyMultiInsertBuffer,
}
impl Default for ResultRelInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AsyncRequest {
    pub requestor: *mut PlanState,
    pub requestee: *mut PlanState,
    pub request_index: ::std::os::raw::c_int,
    pub callback_pending: bool,
    pub request_complete: bool,
    pub result: *mut TupleTableSlot,
}
impl Default for AsyncRequest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EState {
    pub type_: NodeTag,
    pub es_direction: ScanDirection,
    pub es_snapshot: Snapshot,
    pub es_crosscheck_snapshot: Snapshot,
    pub es_range_table: *mut List,
    pub es_range_table_size: Index,
    pub es_relations: *mut Relation,
    pub es_rowmarks: *mut *mut ExecRowMark,
    pub es_plannedstmt: *mut PlannedStmt,
    pub es_sourceText: *const ::std::os::raw::c_char,
    pub es_junkFilter: *mut JunkFilter,
    pub es_output_cid: CommandId,
    pub es_result_relations: *mut *mut ResultRelInfo,
    pub es_opened_result_relations: *mut List,
    pub es_partition_directory: PartitionDirectory,
    pub es_tuple_routing_result_relations: *mut List,
    pub es_trig_target_relations: *mut List,
    pub es_param_list_info: ParamListInfo,
    pub es_param_exec_vals: *mut ParamExecData,
    pub es_queryEnv: *mut QueryEnvironment,
    pub es_query_cxt: MemoryContext,
    pub es_tupleTable: *mut List,
    pub es_processed: uint64,
    pub es_top_eflags: ::std::os::raw::c_int,
    pub es_instrument: ::std::os::raw::c_int,
    pub es_finished: bool,
    pub es_exprcontexts: *mut List,
    pub es_subplanstates: *mut List,
    pub es_auxmodifytables: *mut List,
    pub es_per_tuple_exprcontext: *mut ExprContext,
    pub es_epq_active: *mut EPQState,
    pub es_use_parallel_mode: bool,
    pub es_query_dsa: *mut dsa_area,
    pub es_jit_flags: ::std::os::raw::c_int,
    pub es_jit: *mut JitContext,
    pub es_jit_worker_instr: *mut JitInstrumentation,
}
impl Default for EState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecRowMark {
    pub relation: Relation,
    pub relid: Oid,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub ermActive: bool,
    pub curCtid: ItemPointerData,
    pub ermExtra: *mut ::std::os::raw::c_void,
}
impl Default for ExecRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecAuxRowMark {
    pub rowmark: *mut ExecRowMark,
    pub ctidAttNo: AttrNumber,
    pub toidAttNo: AttrNumber,
    pub wholeAttNo: AttrNumber,
}
impl Default for ExecAuxRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashEntry = *mut TupleHashEntryData;
pub type TupleHashTable = *mut TupleHashTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashEntryData {
    pub firstTuple: MinimalTuple,
    pub additional: *mut ::std::os::raw::c_void,
    pub status: uint32,
    pub hash: uint32,
}
impl Default for TupleHashEntryData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static pg_leftmost_one_pos: [uint8; 256usize];
}
extern "C" {
    pub static pg_rightmost_one_pos: [uint8; 256usize];
}
extern "C" {
    pub static pg_number_of_ones: [uint8; 256usize];
}
extern "C" {
    pub static mut pg_popcount32:
        ::std::option::Option<unsafe extern "C" fn(word: uint32) -> ::std::os::raw::c_int>;
}
extern "C" {
    pub static mut pg_popcount64:
        ::std::option::Option<unsafe extern "C" fn(word: uint64) -> ::std::os::raw::c_int>;
}
pub unsafe fn pg_popcount(
    arg_buf: *const ::std::os::raw::c_char,
    arg_bytes: ::std::os::raw::c_int,
) -> uint64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_popcount(
                arg_buf: *const ::std::os::raw::c_char,
                arg_bytes: ::std::os::raw::c_int,
            ) -> uint64;
        }
        pg_popcount(arg_buf, arg_bytes)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tuplehash_hash {
    pub size: uint64,
    pub members: uint32,
    pub sizemask: uint32,
    pub grow_threshold: uint32,
    pub data: *mut TupleHashEntryData,
    pub ctx: MemoryContext,
    pub private_data: *mut ::std::os::raw::c_void,
}
impl Default for tuplehash_hash {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const tuplehash_status_tuplehash_SH_EMPTY: tuplehash_status = 0;
pub const tuplehash_status_tuplehash_SH_IN_USE: tuplehash_status = 1;
pub type tuplehash_status = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct tuplehash_iterator {
    pub cur: uint32,
    pub end: uint32,
    pub done: bool,
}
pub unsafe fn tuplehash_create(
    arg_ctx: MemoryContext,
    arg_nelements: uint32,
    arg_private_data: *mut ::std::os::raw::c_void,
) -> *mut tuplehash_hash {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_create(
                arg_ctx: MemoryContext,
                arg_nelements: uint32,
                arg_private_data: *mut ::std::os::raw::c_void,
            ) -> *mut tuplehash_hash;
        }
        tuplehash_create(arg_ctx, arg_nelements, arg_private_data)
    })
}
pub unsafe fn tuplehash_destroy(arg_tb: *mut tuplehash_hash) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_destroy(arg_tb: *mut tuplehash_hash);
        }
        tuplehash_destroy(arg_tb)
    })
}
pub unsafe fn tuplehash_reset(arg_tb: *mut tuplehash_hash) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_reset(arg_tb: *mut tuplehash_hash);
        }
        tuplehash_reset(arg_tb)
    })
}
pub unsafe fn tuplehash_grow(arg_tb: *mut tuplehash_hash, arg_newsize: uint64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_grow(arg_tb: *mut tuplehash_hash, arg_newsize: uint64);
        }
        tuplehash_grow(arg_tb, arg_newsize)
    })
}
pub unsafe fn tuplehash_insert(
    arg_tb: *mut tuplehash_hash,
    arg_key: MinimalTuple,
    arg_found: *mut bool,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_insert(
                arg_tb: *mut tuplehash_hash,
                arg_key: MinimalTuple,
                arg_found: *mut bool,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_insert(arg_tb, arg_key, arg_found)
    })
}
pub unsafe fn tuplehash_insert_hash(
    arg_tb: *mut tuplehash_hash,
    arg_key: MinimalTuple,
    arg_hash: uint32,
    arg_found: *mut bool,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_insert_hash(
                arg_tb: *mut tuplehash_hash,
                arg_key: MinimalTuple,
                arg_hash: uint32,
                arg_found: *mut bool,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_insert_hash(arg_tb, arg_key, arg_hash, arg_found)
    })
}
pub unsafe fn tuplehash_lookup(
    arg_tb: *mut tuplehash_hash,
    arg_key: MinimalTuple,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_lookup(
                arg_tb: *mut tuplehash_hash,
                arg_key: MinimalTuple,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_lookup(arg_tb, arg_key)
    })
}
pub unsafe fn tuplehash_lookup_hash(
    arg_tb: *mut tuplehash_hash,
    arg_key: MinimalTuple,
    arg_hash: uint32,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_lookup_hash(
                arg_tb: *mut tuplehash_hash,
                arg_key: MinimalTuple,
                arg_hash: uint32,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_lookup_hash(arg_tb, arg_key, arg_hash)
    })
}
pub unsafe fn tuplehash_delete_item(
    arg_tb: *mut tuplehash_hash,
    arg_entry: *mut TupleHashEntryData,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_delete_item(
                arg_tb: *mut tuplehash_hash,
                arg_entry: *mut TupleHashEntryData,
            );
        }
        tuplehash_delete_item(arg_tb, arg_entry)
    })
}
pub unsafe fn tuplehash_delete(arg_tb: *mut tuplehash_hash, arg_key: MinimalTuple) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_delete(arg_tb: *mut tuplehash_hash, arg_key: MinimalTuple) -> bool;
        }
        tuplehash_delete(arg_tb, arg_key)
    })
}
pub unsafe fn tuplehash_start_iterate(
    arg_tb: *mut tuplehash_hash,
    arg_iter: *mut tuplehash_iterator,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_start_iterate(
                arg_tb: *mut tuplehash_hash,
                arg_iter: *mut tuplehash_iterator,
            );
        }
        tuplehash_start_iterate(arg_tb, arg_iter)
    })
}
pub unsafe fn tuplehash_start_iterate_at(
    arg_tb: *mut tuplehash_hash,
    arg_iter: *mut tuplehash_iterator,
    arg_at: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_start_iterate_at(
                arg_tb: *mut tuplehash_hash,
                arg_iter: *mut tuplehash_iterator,
                arg_at: uint32,
            );
        }
        tuplehash_start_iterate_at(arg_tb, arg_iter, arg_at)
    })
}
pub unsafe fn tuplehash_iterate(
    arg_tb: *mut tuplehash_hash,
    arg_iter: *mut tuplehash_iterator,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_iterate(
                arg_tb: *mut tuplehash_hash,
                arg_iter: *mut tuplehash_iterator,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_iterate(arg_tb, arg_iter)
    })
}
pub unsafe fn tuplehash_stat(arg_tb: *mut tuplehash_hash) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_stat(arg_tb: *mut tuplehash_hash);
        }
        tuplehash_stat(arg_tb)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashTableData {
    pub hashtab: *mut tuplehash_hash,
    pub numCols: ::std::os::raw::c_int,
    pub keyColIdx: *mut AttrNumber,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_func: *mut ExprState,
    pub tab_collations: *mut Oid,
    pub tablecxt: MemoryContext,
    pub tempcxt: MemoryContext,
    pub entrysize: Size,
    pub tableslot: *mut TupleTableSlot,
    pub inputslot: *mut TupleTableSlot,
    pub in_hash_funcs: *mut FmgrInfo,
    pub cur_eq_func: *mut ExprState,
    pub hash_iv: uint32,
    pub exprcontext: *mut ExprContext,
}
impl Default for TupleHashTableData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashIterator = tuplehash_iterator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFuncExprState {
    pub type_: NodeTag,
    pub wfunc: *mut WindowFunc,
    pub args: *mut List,
    pub aggfilter: *mut ExprState,
    pub wfuncno: ::std::os::raw::c_int,
}
impl Default for WindowFuncExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetExprState {
    pub type_: NodeTag,
    pub expr: *mut Expr,
    pub args: *mut List,
    pub elidedFuncState: *mut ExprState,
    pub func: FmgrInfo,
    pub funcResultStore: *mut Tuplestorestate,
    pub funcResultSlot: *mut TupleTableSlot,
    pub funcResultDesc: TupleDesc,
    pub funcReturnsTuple: bool,
    pub funcReturnsSet: bool,
    pub setArgsValid: bool,
    pub shutdown_reg: bool,
    pub fcinfo: FunctionCallInfo,
}
impl Default for SetExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlanState {
    pub type_: NodeTag,
    pub subplan: *mut SubPlan,
    pub planstate: *mut PlanState,
    pub parent: *mut PlanState,
    pub testexpr: *mut ExprState,
    pub args: *mut List,
    pub curTuple: HeapTuple,
    pub curArray: Datum,
    pub descRight: TupleDesc,
    pub projLeft: *mut ProjectionInfo,
    pub projRight: *mut ProjectionInfo,
    pub hashtable: TupleHashTable,
    pub hashnulls: TupleHashTable,
    pub havehashrows: bool,
    pub havenullrows: bool,
    pub hashtablecxt: MemoryContext,
    pub hashtempcxt: MemoryContext,
    pub innerecontext: *mut ExprContext,
    pub numCols: ::std::os::raw::c_int,
    pub keyColIdx: *mut AttrNumber,
    pub tab_eq_funcoids: *mut Oid,
    pub tab_collations: *mut Oid,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_funcs: *mut FmgrInfo,
    pub lhs_hash_funcs: *mut FmgrInfo,
    pub cur_eq_funcs: *mut FmgrInfo,
    pub cur_eq_comp: *mut ExprState,
}
impl Default for SubPlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DomainConstraintType_DOM_CONSTRAINT_NOTNULL: DomainConstraintType = 0;
pub const DomainConstraintType_DOM_CONSTRAINT_CHECK: DomainConstraintType = 1;
pub type DomainConstraintType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DomainConstraintState {
    pub type_: NodeTag,
    pub constrainttype: DomainConstraintType,
    pub name: *mut ::std::os::raw::c_char,
    pub check_expr: *mut Expr,
    pub check_exprstate: *mut ExprState,
}
impl Default for DomainConstraintState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExecProcNodeMtd =
    ::std::option::Option<unsafe extern "C" fn(pstate: *mut PlanState) -> *mut TupleTableSlot>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanState {
    pub type_: NodeTag,
    pub plan: *mut Plan,
    pub state: *mut EState,
    pub ExecProcNode: ExecProcNodeMtd,
    pub ExecProcNodeReal: ExecProcNodeMtd,
    pub instrument: *mut Instrumentation,
    pub worker_instrument: *mut WorkerInstrumentation,
    pub worker_jit_instrument: *mut SharedJitInstrumentation,
    pub qual: *mut ExprState,
    pub lefttree: *mut PlanState,
    pub righttree: *mut PlanState,
    pub initPlan: *mut List,
    pub subPlan: *mut List,
    pub chgParam: *mut Bitmapset,
    pub ps_ResultTupleDesc: TupleDesc,
    pub ps_ResultTupleSlot: *mut TupleTableSlot,
    pub ps_ExprContext: *mut ExprContext,
    pub ps_ProjInfo: *mut ProjectionInfo,
    pub async_capable: bool,
    pub scandesc: TupleDesc,
    pub scanops: *const TupleTableSlotOps,
    pub outerops: *const TupleTableSlotOps,
    pub innerops: *const TupleTableSlotOps,
    pub resultops: *const TupleTableSlotOps,
    pub scanopsfixed: bool,
    pub outeropsfixed: bool,
    pub inneropsfixed: bool,
    pub resultopsfixed: bool,
    pub scanopsset: bool,
    pub outeropsset: bool,
    pub inneropsset: bool,
    pub resultopsset: bool,
}
impl Default for PlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EPQState {
    pub parentestate: *mut EState,
    pub epqParam: ::std::os::raw::c_int,
    pub tuple_table: *mut List,
    pub relsubs_slot: *mut *mut TupleTableSlot,
    pub plan: *mut Plan,
    pub arowMarks: *mut List,
    pub origslot: *mut TupleTableSlot,
    pub recheckestate: *mut EState,
    pub relsubs_rowmark: *mut *mut ExecAuxRowMark,
    pub relsubs_done: *mut bool,
    pub recheckplanstate: *mut PlanState,
}
impl Default for EPQState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultState {
    pub ps: PlanState,
    pub resconstantqual: *mut ExprState,
    pub rs_done: bool,
    pub rs_checkqual: bool,
}
impl Default for ResultState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSetState {
    pub ps: PlanState,
    pub elems: *mut *mut Node,
    pub elemdone: *mut ExprDoneCond,
    pub nelems: ::std::os::raw::c_int,
    pub pending_srf_tuples: bool,
    pub argcontext: MemoryContext,
}
impl Default for ProjectSetState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTableState {
    pub ps: PlanState,
    pub operation: CmdType,
    pub canSetTag: bool,
    pub mt_done: bool,
    pub mt_nrels: ::std::os::raw::c_int,
    pub resultRelInfo: *mut ResultRelInfo,
    pub rootResultRelInfo: *mut ResultRelInfo,
    pub mt_epqstate: EPQState,
    pub fireBSTriggers: bool,
    pub mt_resultOidAttno: ::std::os::raw::c_int,
    pub mt_lastResultOid: Oid,
    pub mt_lastResultIndex: ::std::os::raw::c_int,
    pub mt_resultOidHash: *mut HTAB,
    pub mt_root_tuple_slot: *mut TupleTableSlot,
    pub mt_partition_tuple_routing: *mut PartitionTupleRouting,
    pub mt_transition_capture: *mut TransitionCaptureState,
    pub mt_oc_transition_capture: *mut TransitionCaptureState,
}
impl Default for ModifyTableState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelAppendState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AppendState {
    pub ps: PlanState,
    pub appendplans: *mut *mut PlanState,
    pub as_nplans: ::std::os::raw::c_int,
    pub as_whichplan: ::std::os::raw::c_int,
    pub as_begun: bool,
    pub as_asyncplans: *mut Bitmapset,
    pub as_nasyncplans: ::std::os::raw::c_int,
    pub as_asyncrequests: *mut *mut AsyncRequest,
    pub as_asyncresults: *mut *mut TupleTableSlot,
    pub as_nasyncresults: ::std::os::raw::c_int,
    pub as_syncdone: bool,
    pub as_nasyncremain: ::std::os::raw::c_int,
    pub as_needrequest: *mut Bitmapset,
    pub as_eventset: *mut WaitEventSet,
    pub as_first_partial_plan: ::std::os::raw::c_int,
    pub as_pstate: *mut ParallelAppendState,
    pub pstate_len: Size,
    pub as_prune_state: *mut PartitionPruneState,
    pub as_valid_subplans: *mut Bitmapset,
    pub as_valid_asyncplans: *mut Bitmapset,
    pub choose_next_subplan:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut AppendState) -> bool>,
}
impl Default for AppendState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppendState {
    pub ps: PlanState,
    pub mergeplans: *mut *mut PlanState,
    pub ms_nplans: ::std::os::raw::c_int,
    pub ms_nkeys: ::std::os::raw::c_int,
    pub ms_sortkeys: SortSupport,
    pub ms_slots: *mut *mut TupleTableSlot,
    pub ms_heap: *mut binaryheap,
    pub ms_initialized: bool,
    pub ms_prune_state: *mut PartitionPruneState,
    pub ms_valid_subplans: *mut Bitmapset,
}
impl Default for MergeAppendState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnionState {
    pub ps: PlanState,
    pub recursing: bool,
    pub intermediate_empty: bool,
    pub working_table: *mut Tuplestorestate,
    pub intermediate_table: *mut Tuplestorestate,
    pub eqfuncoids: *mut Oid,
    pub hashfunctions: *mut FmgrInfo,
    pub tempContext: MemoryContext,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
}
impl Default for RecursiveUnionState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAndState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::std::os::raw::c_int,
}
impl Default for BitmapAndState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOrState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::std::os::raw::c_int,
}
impl Default for BitmapOrState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScanState {
    pub ps: PlanState,
    pub ss_currentRelation: Relation,
    pub ss_currentScanDesc: *mut TableScanDescData,
    pub ss_ScanTupleSlot: *mut TupleTableSlot,
}
impl Default for ScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SeqScanState {
    pub ss: ScanState,
    pub pscan_len: Size,
}
impl Default for SeqScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScanState {
    pub ss: ScanState,
    pub args: *mut List,
    pub repeatable: *mut ExprState,
    pub tsmroutine: *mut TsmRoutine,
    pub tsm_state: *mut ::std::os::raw::c_void,
    pub use_bulkread: bool,
    pub use_pagemode: bool,
    pub begun: bool,
    pub seed: uint32,
    pub donetuples: int64,
    pub haveblock: bool,
    pub done: bool,
}
impl Default for SampleScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexRuntimeKeyInfo {
    pub scan_key: *mut ScanKeyData,
    pub key_expr: *mut ExprState,
    pub key_toastable: bool,
}
impl Default for IndexRuntimeKeyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexArrayKeyInfo {
    pub scan_key: *mut ScanKeyData,
    pub array_expr: *mut ExprState,
    pub next_elem: ::std::os::raw::c_int,
    pub num_elems: ::std::os::raw::c_int,
    pub elem_values: *mut Datum,
    pub elem_nulls: *mut bool,
}
impl Default for IndexArrayKeyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScanState {
    pub ss: ScanState,
    pub indexqualorig: *mut ExprState,
    pub indexorderbyorig: *mut List,
    pub iss_ScanKeys: *mut ScanKeyData,
    pub iss_NumScanKeys: ::std::os::raw::c_int,
    pub iss_OrderByKeys: *mut ScanKeyData,
    pub iss_NumOrderByKeys: ::std::os::raw::c_int,
    pub iss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub iss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub iss_RuntimeKeysReady: bool,
    pub iss_RuntimeContext: *mut ExprContext,
    pub iss_RelationDesc: Relation,
    pub iss_ScanDesc: *mut IndexScanDescData,
    pub iss_ReorderQueue: *mut pairingheap,
    pub iss_ReachedEnd: bool,
    pub iss_OrderByValues: *mut Datum,
    pub iss_OrderByNulls: *mut bool,
    pub iss_SortSupport: SortSupport,
    pub iss_OrderByTypByVals: *mut bool,
    pub iss_OrderByTypLens: *mut int16,
    pub iss_PscanLen: Size,
}
impl Default for IndexScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScanState {
    pub ss: ScanState,
    pub indexqual: *mut ExprState,
    pub ioss_ScanKeys: *mut ScanKeyData,
    pub ioss_NumScanKeys: ::std::os::raw::c_int,
    pub ioss_OrderByKeys: *mut ScanKeyData,
    pub ioss_NumOrderByKeys: ::std::os::raw::c_int,
    pub ioss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub ioss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub ioss_RuntimeKeysReady: bool,
    pub ioss_RuntimeContext: *mut ExprContext,
    pub ioss_RelationDesc: Relation,
    pub ioss_ScanDesc: *mut IndexScanDescData,
    pub ioss_TableSlot: *mut TupleTableSlot,
    pub ioss_VMBuffer: Buffer,
    pub ioss_PscanLen: Size,
}
impl Default for IndexOnlyScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScanState {
    pub ss: ScanState,
    pub biss_result: *mut TIDBitmap,
    pub biss_ScanKeys: *mut ScanKeyData,
    pub biss_NumScanKeys: ::std::os::raw::c_int,
    pub biss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub biss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub biss_ArrayKeys: *mut IndexArrayKeyInfo,
    pub biss_NumArrayKeys: ::std::os::raw::c_int,
    pub biss_RuntimeKeysReady: bool,
    pub biss_RuntimeContext: *mut ExprContext,
    pub biss_RelationDesc: Relation,
    pub biss_ScanDesc: *mut IndexScanDescData,
}
impl Default for BitmapIndexScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SharedBitmapState_BM_INITIAL: SharedBitmapState = 0;
pub const SharedBitmapState_BM_INPROGRESS: SharedBitmapState = 1;
pub const SharedBitmapState_BM_FINISHED: SharedBitmapState = 2;
pub type SharedBitmapState = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct ParallelBitmapHeapState {
    pub tbmiterator: dsa_pointer,
    pub prefetch_iterator: dsa_pointer,
    pub mutex: slock_t,
    pub prefetch_pages: ::std::os::raw::c_int,
    pub prefetch_target: ::std::os::raw::c_int,
    pub state: SharedBitmapState,
    pub cv: ConditionVariable,
    pub phs_snapshot_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for ParallelBitmapHeapState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScanState {
    pub ss: ScanState,
    pub bitmapqualorig: *mut ExprState,
    pub tbm: *mut TIDBitmap,
    pub tbmiterator: *mut TBMIterator,
    pub tbmres: *mut TBMIterateResult,
    pub can_skip_fetch: bool,
    pub return_empty_tuples: ::std::os::raw::c_int,
    pub vmbuffer: Buffer,
    pub pvmbuffer: Buffer,
    pub exact_pages: ::std::os::raw::c_long,
    pub lossy_pages: ::std::os::raw::c_long,
    pub prefetch_iterator: *mut TBMIterator,
    pub prefetch_pages: ::std::os::raw::c_int,
    pub prefetch_target: ::std::os::raw::c_int,
    pub prefetch_maximum: ::std::os::raw::c_int,
    pub pscan_len: Size,
    pub initialized: bool,
    pub shared_tbmiterator: *mut TBMSharedIterator,
    pub shared_prefetch_iterator: *mut TBMSharedIterator,
    pub pstate: *mut ParallelBitmapHeapState,
}
impl Default for BitmapHeapScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScanState {
    pub ss: ScanState,
    pub tss_tidexprs: *mut List,
    pub tss_isCurrentOf: bool,
    pub tss_NumTids: ::std::os::raw::c_int,
    pub tss_TidPtr: ::std::os::raw::c_int,
    pub tss_TidList: *mut ItemPointerData,
    pub tss_htup: HeapTupleData,
}
impl Default for TidScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidRangeScanState {
    pub ss: ScanState,
    pub trss_tidexprs: *mut List,
    pub trss_mintid: ItemPointerData,
    pub trss_maxtid: ItemPointerData,
    pub trss_inScan: bool,
}
impl Default for TidRangeScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScanState {
    pub ss: ScanState,
    pub subplan: *mut PlanState,
}
impl Default for SubqueryScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanPerFuncState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub ordinality: bool,
    pub simple: bool,
    pub ordinal: int64,
    pub nfuncs: ::std::os::raw::c_int,
    pub funcstates: *mut FunctionScanPerFuncState,
    pub argcontext: MemoryContext,
}
impl Default for FunctionScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScanState {
    pub ss: ScanState,
    pub rowcontext: *mut ExprContext,
    pub exprlists: *mut *mut List,
    pub exprstatelists: *mut *mut List,
    pub array_len: ::std::os::raw::c_int,
    pub curr_idx: ::std::os::raw::c_int,
}
impl Default for ValuesScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScanState {
    pub ss: ScanState,
    pub docexpr: *mut ExprState,
    pub rowexpr: *mut ExprState,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub ns_names: *mut List,
    pub ns_uris: *mut List,
    pub notnulls: *mut Bitmapset,
    pub opaque: *mut ::std::os::raw::c_void,
    pub routine: *mut TableFuncRoutine,
    pub in_functions: *mut FmgrInfo,
    pub typioparams: *mut Oid,
    pub ordinal: int64,
    pub perTableCxt: MemoryContext,
    pub tupstore: *mut Tuplestorestate,
}
impl Default for TableFuncScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScanState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub readptr: ::std::os::raw::c_int,
    pub cteplanstate: *mut PlanState,
    pub leader: *mut CteScanState,
    pub cte_table: *mut Tuplestorestate,
    pub eof_cte: bool,
}
impl Default for CteScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScanState {
    pub ss: ScanState,
    pub readptr: ::std::os::raw::c_int,
    pub tupdesc: TupleDesc,
    pub relation: *mut Tuplestorestate,
}
impl Default for NamedTuplestoreScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScanState {
    pub ss: ScanState,
    pub rustate: *mut RecursiveUnionState,
}
impl Default for WorkTableScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScanState {
    pub ss: ScanState,
    pub fdw_recheck_quals: *mut ExprState,
    pub pscan_len: Size,
    pub resultRelInfo: *mut ResultRelInfo,
    pub fdwroutine: *mut FdwRoutine,
    pub fdw_state: *mut ::std::os::raw::c_void,
}
impl Default for ForeignScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScanState {
    pub ss: ScanState,
    pub flags: uint32,
    pub custom_ps: *mut List,
    pub pscan_len: Size,
    pub methods: *const CustomExecMethods,
}
impl Default for CustomScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinState {
    pub ps: PlanState,
    pub jointype: JoinType,
    pub single_match: bool,
    pub joinqual: *mut ExprState,
}
impl Default for JoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopState {
    pub js: JoinState,
    pub nl_NeedNewOuter: bool,
    pub nl_MatchedOuter: bool,
    pub nl_NullInnerTupleSlot: *mut TupleTableSlot,
}
impl Default for NestLoopState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinClauseData {
    _unused: [u8; 0],
}
pub type MergeJoinClause = *mut MergeJoinClauseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinState {
    pub js: JoinState,
    pub mj_NumClauses: ::std::os::raw::c_int,
    pub mj_Clauses: MergeJoinClause,
    pub mj_JoinState: ::std::os::raw::c_int,
    pub mj_SkipMarkRestore: bool,
    pub mj_ExtraMarks: bool,
    pub mj_ConstFalseJoin: bool,
    pub mj_FillOuter: bool,
    pub mj_FillInner: bool,
    pub mj_MatchedOuter: bool,
    pub mj_MatchedInner: bool,
    pub mj_OuterTupleSlot: *mut TupleTableSlot,
    pub mj_InnerTupleSlot: *mut TupleTableSlot,
    pub mj_MarkedTupleSlot: *mut TupleTableSlot,
    pub mj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub mj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub mj_OuterEContext: *mut ExprContext,
    pub mj_InnerEContext: *mut ExprContext,
}
impl Default for MergeJoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTupleData {
    _unused: [u8; 0],
}
pub type HashJoinTuple = *mut HashJoinTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTableData {
    _unused: [u8; 0],
}
pub type HashJoinTable = *mut HashJoinTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinState {
    pub js: JoinState,
    pub hashclauses: *mut ExprState,
    pub hj_OuterHashKeys: *mut List,
    pub hj_HashOperators: *mut List,
    pub hj_Collations: *mut List,
    pub hj_HashTable: HashJoinTable,
    pub hj_CurHashValue: uint32,
    pub hj_CurBucketNo: ::std::os::raw::c_int,
    pub hj_CurSkewBucketNo: ::std::os::raw::c_int,
    pub hj_CurTuple: HashJoinTuple,
    pub hj_OuterTupleSlot: *mut TupleTableSlot,
    pub hj_HashTupleSlot: *mut TupleTableSlot,
    pub hj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub hj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub hj_FirstOuterTupleSlot: *mut TupleTableSlot,
    pub hj_JoinState: ::std::os::raw::c_int,
    pub hj_MatchedOuter: bool,
    pub hj_OuterNotEmpty: bool,
}
impl Default for HashJoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MaterialState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub eof_underlying: bool,
    pub tuplestorestate: *mut Tuplestorestate,
}
impl Default for MaterialState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoizeEntry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoizeTuple {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoizeKey {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct MemoizeInstrumentation {
    pub cache_hits: uint64,
    pub cache_misses: uint64,
    pub cache_evictions: uint64,
    pub cache_overflows: uint64,
    pub mem_peak: uint64,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedMemoizeInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinstrument: __IncompleteArrayField<MemoizeInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoizeState {
    pub ss: ScanState,
    pub mstatus: ::std::os::raw::c_int,
    pub nkeys: ::std::os::raw::c_int,
    pub hashtable: *mut memoize_hash,
    pub hashkeydesc: TupleDesc,
    pub tableslot: *mut TupleTableSlot,
    pub probeslot: *mut TupleTableSlot,
    pub cache_eq_expr: *mut ExprState,
    pub param_exprs: *mut *mut ExprState,
    pub hashfunctions: *mut FmgrInfo,
    pub collations: *mut Oid,
    pub mem_used: uint64,
    pub mem_limit: uint64,
    pub tableContext: MemoryContext,
    pub lru_list: dlist_head,
    pub last_tuple: *mut MemoizeTuple,
    pub entry: *mut MemoizeEntry,
    pub singlerow: bool,
    pub stats: MemoizeInstrumentation,
    pub shared_info: *mut SharedMemoizeInfo,
}
impl Default for MemoizeState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PresortedKeyData {
    pub flinfo: FmgrInfo,
    pub fcinfo: FunctionCallInfo,
    pub attno: OffsetNumber,
}
impl Default for PresortedKeyData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SharedSortInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinstrument: __IncompleteArrayField<TuplesortInstrumentation>,
}
impl Default for SharedSortInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortState {
    pub ss: ScanState,
    pub randomAccess: bool,
    pub bounded: bool,
    pub bound: int64,
    pub sort_Done: bool,
    pub bounded_Done: bool,
    pub bound_Done: int64,
    pub tuplesortstate: *mut ::std::os::raw::c_void,
    pub am_worker: bool,
    pub shared_info: *mut SharedSortInfo,
}
impl Default for SortState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IncrementalSortGroupInfo {
    pub groupCount: int64,
    pub maxDiskSpaceUsed: int64,
    pub totalDiskSpaceUsed: int64,
    pub maxMemorySpaceUsed: int64,
    pub totalMemorySpaceUsed: int64,
    pub sortMethods: bits32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IncrementalSortInfo {
    pub fullsortGroupInfo: IncrementalSortGroupInfo,
    pub prefixsortGroupInfo: IncrementalSortGroupInfo,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedIncrementalSortInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinfo: __IncompleteArrayField<IncrementalSortInfo>,
}
pub const IncrementalSortExecutionStatus_INCSORT_LOADFULLSORT: IncrementalSortExecutionStatus = 0;
pub const IncrementalSortExecutionStatus_INCSORT_LOADPREFIXSORT: IncrementalSortExecutionStatus = 1;
pub const IncrementalSortExecutionStatus_INCSORT_READFULLSORT: IncrementalSortExecutionStatus = 2;
pub const IncrementalSortExecutionStatus_INCSORT_READPREFIXSORT: IncrementalSortExecutionStatus = 3;
pub type IncrementalSortExecutionStatus = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IncrementalSortState {
    pub ss: ScanState,
    pub bounded: bool,
    pub bound: int64,
    pub outerNodeDone: bool,
    pub bound_Done: int64,
    pub execution_status: IncrementalSortExecutionStatus,
    pub n_fullsort_remaining: int64,
    pub fullsort_state: *mut Tuplesortstate,
    pub prefixsort_state: *mut Tuplesortstate,
    pub presorted_keys: *mut PresortedKeyData,
    pub incsort_info: IncrementalSortInfo,
    pub group_pivot: *mut TupleTableSlot,
    pub transfer_tuple: *mut TupleTableSlot,
    pub am_worker: bool,
    pub shared_info: *mut SharedIncrementalSortInfo,
}
impl Default for IncrementalSortState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupState {
    pub ss: ScanState,
    pub eqfunction: *mut ExprState,
    pub grp_done: bool,
}
impl Default for GroupState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AggregateInstrumentation {
    pub hash_mem_peak: Size,
    pub hash_disk_used: uint64,
    pub hash_batches_used: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedAggInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinstrument: __IncompleteArrayField<AggregateInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerAggData {
    _unused: [u8; 0],
}
pub type AggStatePerAgg = *mut AggStatePerAggData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerTransData {
    _unused: [u8; 0],
}
pub type AggStatePerTrans = *mut AggStatePerTransData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerGroupData {
    _unused: [u8; 0],
}
pub type AggStatePerGroup = *mut AggStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerPhaseData {
    _unused: [u8; 0],
}
pub type AggStatePerPhase = *mut AggStatePerPhaseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerHashData {
    _unused: [u8; 0],
}
pub type AggStatePerHash = *mut AggStatePerHashData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggState {
    pub ss: ScanState,
    pub aggs: *mut List,
    pub numaggs: ::std::os::raw::c_int,
    pub numtrans: ::std::os::raw::c_int,
    pub aggstrategy: AggStrategy,
    pub aggsplit: AggSplit,
    pub phase: AggStatePerPhase,
    pub numphases: ::std::os::raw::c_int,
    pub current_phase: ::std::os::raw::c_int,
    pub peragg: AggStatePerAgg,
    pub pertrans: AggStatePerTrans,
    pub hashcontext: *mut ExprContext,
    pub aggcontexts: *mut *mut ExprContext,
    pub tmpcontext: *mut ExprContext,
    pub curaggcontext: *mut ExprContext,
    pub curperagg: AggStatePerAgg,
    pub curpertrans: AggStatePerTrans,
    pub input_done: bool,
    pub agg_done: bool,
    pub projected_set: ::std::os::raw::c_int,
    pub current_set: ::std::os::raw::c_int,
    pub grouped_cols: *mut Bitmapset,
    pub all_grouped_cols: *mut List,
    pub colnos_needed: *mut Bitmapset,
    pub max_colno_needed: ::std::os::raw::c_int,
    pub all_cols_needed: bool,
    pub maxsets: ::std::os::raw::c_int,
    pub phases: AggStatePerPhase,
    pub sort_in: *mut Tuplesortstate,
    pub sort_out: *mut Tuplesortstate,
    pub sort_slot: *mut TupleTableSlot,
    pub pergroups: *mut AggStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub table_filled: bool,
    pub num_hashes: ::std::os::raw::c_int,
    pub hash_metacxt: MemoryContext,
    pub hash_tapeinfo: *mut HashTapeInfo,
    pub hash_spills: *mut HashAggSpill,
    pub hash_spill_rslot: *mut TupleTableSlot,
    pub hash_spill_wslot: *mut TupleTableSlot,
    pub hash_batches: *mut List,
    pub hash_ever_spilled: bool,
    pub hash_spill_mode: bool,
    pub hash_mem_limit: Size,
    pub hash_ngroups_limit: uint64,
    pub hash_planned_partitions: ::std::os::raw::c_int,
    pub hashentrysize: f64,
    pub hash_mem_peak: Size,
    pub hash_ngroups_current: uint64,
    pub hash_disk_used: uint64,
    pub hash_batches_used: ::std::os::raw::c_int,
    pub perhash: AggStatePerHash,
    pub hash_pergroup: *mut AggStatePerGroup,
    pub all_pergroups: *mut AggStatePerGroup,
    pub combinedproj: *mut ProjectionInfo,
    pub shared_info: *mut SharedAggInfo,
}
impl Default for AggState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerFuncData {
    _unused: [u8; 0],
}
pub type WindowStatePerFunc = *mut WindowStatePerFuncData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerAggData {
    _unused: [u8; 0],
}
pub type WindowStatePerAgg = *mut WindowStatePerAggData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAggState {
    pub ss: ScanState,
    pub funcs: *mut List,
    pub numfuncs: ::std::os::raw::c_int,
    pub numaggs: ::std::os::raw::c_int,
    pub perfunc: WindowStatePerFunc,
    pub peragg: WindowStatePerAgg,
    pub partEqfunction: *mut ExprState,
    pub ordEqfunction: *mut ExprState,
    pub buffer: *mut Tuplestorestate,
    pub current_ptr: ::std::os::raw::c_int,
    pub framehead_ptr: ::std::os::raw::c_int,
    pub frametail_ptr: ::std::os::raw::c_int,
    pub grouptail_ptr: ::std::os::raw::c_int,
    pub spooled_rows: int64,
    pub currentpos: int64,
    pub frameheadpos: int64,
    pub frametailpos: int64,
    pub agg_winobj: *mut WindowObjectData,
    pub aggregatedbase: int64,
    pub aggregatedupto: int64,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut ExprState,
    pub endOffset: *mut ExprState,
    pub startOffsetValue: Datum,
    pub endOffsetValue: Datum,
    pub startInRangeFunc: FmgrInfo,
    pub endInRangeFunc: FmgrInfo,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
    pub currentgroup: int64,
    pub frameheadgroup: int64,
    pub frametailgroup: int64,
    pub groupheadpos: int64,
    pub grouptailpos: int64,
    pub partcontext: MemoryContext,
    pub aggcontext: MemoryContext,
    pub curaggcontext: MemoryContext,
    pub tmpcontext: *mut ExprContext,
    pub all_first: bool,
    pub all_done: bool,
    pub partition_spooled: bool,
    pub more_partitions: bool,
    pub framehead_valid: bool,
    pub frametail_valid: bool,
    pub grouptail_valid: bool,
    pub first_part_slot: *mut TupleTableSlot,
    pub framehead_slot: *mut TupleTableSlot,
    pub frametail_slot: *mut TupleTableSlot,
    pub agg_row_slot: *mut TupleTableSlot,
    pub temp_slot_1: *mut TupleTableSlot,
    pub temp_slot_2: *mut TupleTableSlot,
}
impl Default for WindowAggState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UniqueState {
    pub ps: PlanState,
    pub eqfunction: *mut ExprState,
}
impl Default for UniqueState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherState {
    pub ps: PlanState,
    pub initialized: bool,
    pub need_to_scan_locally: bool,
    pub tuples_needed: int64,
    pub funnel_slot: *mut TupleTableSlot,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub nreaders: ::std::os::raw::c_int,
    pub nextreader: ::std::os::raw::c_int,
    pub reader: *mut *mut TupleQueueReader,
}
impl Default for GatherState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GMReaderTupleBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMergeState {
    pub ps: PlanState,
    pub initialized: bool,
    pub gm_initialized: bool,
    pub need_to_scan_locally: bool,
    pub tuples_needed: int64,
    pub tupDesc: TupleDesc,
    pub gm_nkeys: ::std::os::raw::c_int,
    pub gm_sortkeys: SortSupport,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub nreaders: ::std::os::raw::c_int,
    pub gm_slots: *mut *mut TupleTableSlot,
    pub reader: *mut *mut TupleQueueReader,
    pub gm_tuple_buffers: *mut GMReaderTupleBuffer,
    pub gm_heap: *mut binaryheap,
}
impl Default for GatherMergeState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct HashInstrumentation {
    pub nbuckets: ::std::os::raw::c_int,
    pub nbuckets_original: ::std::os::raw::c_int,
    pub nbatch: ::std::os::raw::c_int,
    pub nbatch_original: ::std::os::raw::c_int,
    pub space_peak: Size,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedHashInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub hinstrument: __IncompleteArrayField<HashInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashState {
    pub ps: PlanState,
    pub hashtable: HashJoinTable,
    pub hashkeys: *mut List,
    pub shared_info: *mut SharedHashInfo,
    pub hinstrument: *mut HashInstrumentation,
    pub parallel_state: *mut ParallelHashJoinState,
}
impl Default for HashState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpStatePerGroupData {
    _unused: [u8; 0],
}
pub type SetOpStatePerGroup = *mut SetOpStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpState {
    pub ps: PlanState,
    pub eqfunction: *mut ExprState,
    pub eqfuncoids: *mut Oid,
    pub hashfunctions: *mut FmgrInfo,
    pub setop_done: bool,
    pub numOutput: ::std::os::raw::c_long,
    pub pergroup: SetOpStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
    pub table_filled: bool,
    pub hashiter: TupleHashIterator,
}
impl Default for SetOpState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRowsState {
    pub ps: PlanState,
    pub lr_arowMarks: *mut List,
    pub lr_epqstate: EPQState,
}
impl Default for LockRowsState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const LimitStateCond_LIMIT_INITIAL: LimitStateCond = 0;
pub const LimitStateCond_LIMIT_RESCAN: LimitStateCond = 1;
pub const LimitStateCond_LIMIT_EMPTY: LimitStateCond = 2;
pub const LimitStateCond_LIMIT_INWINDOW: LimitStateCond = 3;
pub const LimitStateCond_LIMIT_WINDOWEND_TIES: LimitStateCond = 4;
pub const LimitStateCond_LIMIT_SUBPLANEOF: LimitStateCond = 5;
pub const LimitStateCond_LIMIT_WINDOWEND: LimitStateCond = 6;
pub const LimitStateCond_LIMIT_WINDOWSTART: LimitStateCond = 7;
pub type LimitStateCond = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LimitState {
    pub ps: PlanState,
    pub limitOffset: *mut ExprState,
    pub limitCount: *mut ExprState,
    pub limitOption: LimitOption,
    pub offset: int64,
    pub count: int64,
    pub noCount: bool,
    pub lstate: LimitStateCond,
    pub position: int64,
    pub subSlot: *mut TupleTableSlot,
    pub eqfunction: *mut ExprState,
    pub last_slot: *mut TupleTableSlot,
}
impl Default for LimitState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CommandTag_CMDTAG_UNKNOWN: CommandTag = 0;
pub const CommandTag_CMDTAG_ALTER_ACCESS_METHOD: CommandTag = 1;
pub const CommandTag_CMDTAG_ALTER_AGGREGATE: CommandTag = 2;
pub const CommandTag_CMDTAG_ALTER_CAST: CommandTag = 3;
pub const CommandTag_CMDTAG_ALTER_COLLATION: CommandTag = 4;
pub const CommandTag_CMDTAG_ALTER_CONSTRAINT: CommandTag = 5;
pub const CommandTag_CMDTAG_ALTER_CONVERSION: CommandTag = 6;
pub const CommandTag_CMDTAG_ALTER_DATABASE: CommandTag = 7;
pub const CommandTag_CMDTAG_ALTER_DEFAULT_PRIVILEGES: CommandTag = 8;
pub const CommandTag_CMDTAG_ALTER_DOMAIN: CommandTag = 9;
pub const CommandTag_CMDTAG_ALTER_EVENT_TRIGGER: CommandTag = 10;
pub const CommandTag_CMDTAG_ALTER_EXTENSION: CommandTag = 11;
pub const CommandTag_CMDTAG_ALTER_FOREIGN_DATA_WRAPPER: CommandTag = 12;
pub const CommandTag_CMDTAG_ALTER_FOREIGN_TABLE: CommandTag = 13;
pub const CommandTag_CMDTAG_ALTER_FUNCTION: CommandTag = 14;
pub const CommandTag_CMDTAG_ALTER_INDEX: CommandTag = 15;
pub const CommandTag_CMDTAG_ALTER_LANGUAGE: CommandTag = 16;
pub const CommandTag_CMDTAG_ALTER_LARGE_OBJECT: CommandTag = 17;
pub const CommandTag_CMDTAG_ALTER_MATERIALIZED_VIEW: CommandTag = 18;
pub const CommandTag_CMDTAG_ALTER_OPERATOR: CommandTag = 19;
pub const CommandTag_CMDTAG_ALTER_OPERATOR_CLASS: CommandTag = 20;
pub const CommandTag_CMDTAG_ALTER_OPERATOR_FAMILY: CommandTag = 21;
pub const CommandTag_CMDTAG_ALTER_POLICY: CommandTag = 22;
pub const CommandTag_CMDTAG_ALTER_PROCEDURE: CommandTag = 23;
pub const CommandTag_CMDTAG_ALTER_PUBLICATION: CommandTag = 24;
pub const CommandTag_CMDTAG_ALTER_ROLE: CommandTag = 25;
pub const CommandTag_CMDTAG_ALTER_ROUTINE: CommandTag = 26;
pub const CommandTag_CMDTAG_ALTER_RULE: CommandTag = 27;
pub const CommandTag_CMDTAG_ALTER_SCHEMA: CommandTag = 28;
pub const CommandTag_CMDTAG_ALTER_SEQUENCE: CommandTag = 29;
pub const CommandTag_CMDTAG_ALTER_SERVER: CommandTag = 30;
pub const CommandTag_CMDTAG_ALTER_STATISTICS: CommandTag = 31;
pub const CommandTag_CMDTAG_ALTER_SUBSCRIPTION: CommandTag = 32;
pub const CommandTag_CMDTAG_ALTER_SYSTEM: CommandTag = 33;
pub const CommandTag_CMDTAG_ALTER_TABLE: CommandTag = 34;
pub const CommandTag_CMDTAG_ALTER_TABLESPACE: CommandTag = 35;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_CONFIGURATION: CommandTag = 36;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_DICTIONARY: CommandTag = 37;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_PARSER: CommandTag = 38;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_TEMPLATE: CommandTag = 39;
pub const CommandTag_CMDTAG_ALTER_TRANSFORM: CommandTag = 40;
pub const CommandTag_CMDTAG_ALTER_TRIGGER: CommandTag = 41;
pub const CommandTag_CMDTAG_ALTER_TYPE: CommandTag = 42;
pub const CommandTag_CMDTAG_ALTER_USER_MAPPING: CommandTag = 43;
pub const CommandTag_CMDTAG_ALTER_VIEW: CommandTag = 44;
pub const CommandTag_CMDTAG_ANALYZE: CommandTag = 45;
pub const CommandTag_CMDTAG_BEGIN: CommandTag = 46;
pub const CommandTag_CMDTAG_CALL: CommandTag = 47;
pub const CommandTag_CMDTAG_CHECKPOINT: CommandTag = 48;
pub const CommandTag_CMDTAG_CLOSE: CommandTag = 49;
pub const CommandTag_CMDTAG_CLOSE_CURSOR: CommandTag = 50;
pub const CommandTag_CMDTAG_CLOSE_CURSOR_ALL: CommandTag = 51;
pub const CommandTag_CMDTAG_CLUSTER: CommandTag = 52;
pub const CommandTag_CMDTAG_COMMENT: CommandTag = 53;
pub const CommandTag_CMDTAG_COMMIT: CommandTag = 54;
pub const CommandTag_CMDTAG_COMMIT_PREPARED: CommandTag = 55;
pub const CommandTag_CMDTAG_COPY: CommandTag = 56;
pub const CommandTag_CMDTAG_COPY_FROM: CommandTag = 57;
pub const CommandTag_CMDTAG_CREATE_ACCESS_METHOD: CommandTag = 58;
pub const CommandTag_CMDTAG_CREATE_AGGREGATE: CommandTag = 59;
pub const CommandTag_CMDTAG_CREATE_CAST: CommandTag = 60;
pub const CommandTag_CMDTAG_CREATE_COLLATION: CommandTag = 61;
pub const CommandTag_CMDTAG_CREATE_CONSTRAINT: CommandTag = 62;
pub const CommandTag_CMDTAG_CREATE_CONVERSION: CommandTag = 63;
pub const CommandTag_CMDTAG_CREATE_DATABASE: CommandTag = 64;
pub const CommandTag_CMDTAG_CREATE_DOMAIN: CommandTag = 65;
pub const CommandTag_CMDTAG_CREATE_EVENT_TRIGGER: CommandTag = 66;
pub const CommandTag_CMDTAG_CREATE_EXTENSION: CommandTag = 67;
pub const CommandTag_CMDTAG_CREATE_FOREIGN_DATA_WRAPPER: CommandTag = 68;
pub const CommandTag_CMDTAG_CREATE_FOREIGN_TABLE: CommandTag = 69;
pub const CommandTag_CMDTAG_CREATE_FUNCTION: CommandTag = 70;
pub const CommandTag_CMDTAG_CREATE_INDEX: CommandTag = 71;
pub const CommandTag_CMDTAG_CREATE_LANGUAGE: CommandTag = 72;
pub const CommandTag_CMDTAG_CREATE_MATERIALIZED_VIEW: CommandTag = 73;
pub const CommandTag_CMDTAG_CREATE_OPERATOR: CommandTag = 74;
pub const CommandTag_CMDTAG_CREATE_OPERATOR_CLASS: CommandTag = 75;
pub const CommandTag_CMDTAG_CREATE_OPERATOR_FAMILY: CommandTag = 76;
pub const CommandTag_CMDTAG_CREATE_POLICY: CommandTag = 77;
pub const CommandTag_CMDTAG_CREATE_PROCEDURE: CommandTag = 78;
pub const CommandTag_CMDTAG_CREATE_PUBLICATION: CommandTag = 79;
pub const CommandTag_CMDTAG_CREATE_ROLE: CommandTag = 80;
pub const CommandTag_CMDTAG_CREATE_ROUTINE: CommandTag = 81;
pub const CommandTag_CMDTAG_CREATE_RULE: CommandTag = 82;
pub const CommandTag_CMDTAG_CREATE_SCHEMA: CommandTag = 83;
pub const CommandTag_CMDTAG_CREATE_SEQUENCE: CommandTag = 84;
pub const CommandTag_CMDTAG_CREATE_SERVER: CommandTag = 85;
pub const CommandTag_CMDTAG_CREATE_STATISTICS: CommandTag = 86;
pub const CommandTag_CMDTAG_CREATE_SUBSCRIPTION: CommandTag = 87;
pub const CommandTag_CMDTAG_CREATE_TABLE: CommandTag = 88;
pub const CommandTag_CMDTAG_CREATE_TABLE_AS: CommandTag = 89;
pub const CommandTag_CMDTAG_CREATE_TABLESPACE: CommandTag = 90;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_CONFIGURATION: CommandTag = 91;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_DICTIONARY: CommandTag = 92;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_PARSER: CommandTag = 93;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_TEMPLATE: CommandTag = 94;
pub const CommandTag_CMDTAG_CREATE_TRANSFORM: CommandTag = 95;
pub const CommandTag_CMDTAG_CREATE_TRIGGER: CommandTag = 96;
pub const CommandTag_CMDTAG_CREATE_TYPE: CommandTag = 97;
pub const CommandTag_CMDTAG_CREATE_USER_MAPPING: CommandTag = 98;
pub const CommandTag_CMDTAG_CREATE_VIEW: CommandTag = 99;
pub const CommandTag_CMDTAG_DEALLOCATE: CommandTag = 100;
pub const CommandTag_CMDTAG_DEALLOCATE_ALL: CommandTag = 101;
pub const CommandTag_CMDTAG_DECLARE_CURSOR: CommandTag = 102;
pub const CommandTag_CMDTAG_DELETE: CommandTag = 103;
pub const CommandTag_CMDTAG_DISCARD: CommandTag = 104;
pub const CommandTag_CMDTAG_DISCARD_ALL: CommandTag = 105;
pub const CommandTag_CMDTAG_DISCARD_PLANS: CommandTag = 106;
pub const CommandTag_CMDTAG_DISCARD_SEQUENCES: CommandTag = 107;
pub const CommandTag_CMDTAG_DISCARD_TEMP: CommandTag = 108;
pub const CommandTag_CMDTAG_DO: CommandTag = 109;
pub const CommandTag_CMDTAG_DROP_ACCESS_METHOD: CommandTag = 110;
pub const CommandTag_CMDTAG_DROP_AGGREGATE: CommandTag = 111;
pub const CommandTag_CMDTAG_DROP_CAST: CommandTag = 112;
pub const CommandTag_CMDTAG_DROP_COLLATION: CommandTag = 113;
pub const CommandTag_CMDTAG_DROP_CONSTRAINT: CommandTag = 114;
pub const CommandTag_CMDTAG_DROP_CONVERSION: CommandTag = 115;
pub const CommandTag_CMDTAG_DROP_DATABASE: CommandTag = 116;
pub const CommandTag_CMDTAG_DROP_DOMAIN: CommandTag = 117;
pub const CommandTag_CMDTAG_DROP_EVENT_TRIGGER: CommandTag = 118;
pub const CommandTag_CMDTAG_DROP_EXTENSION: CommandTag = 119;
pub const CommandTag_CMDTAG_DROP_FOREIGN_DATA_WRAPPER: CommandTag = 120;
pub const CommandTag_CMDTAG_DROP_FOREIGN_TABLE: CommandTag = 121;
pub const CommandTag_CMDTAG_DROP_FUNCTION: CommandTag = 122;
pub const CommandTag_CMDTAG_DROP_INDEX: CommandTag = 123;
pub const CommandTag_CMDTAG_DROP_LANGUAGE: CommandTag = 124;
pub const CommandTag_CMDTAG_DROP_MATERIALIZED_VIEW: CommandTag = 125;
pub const CommandTag_CMDTAG_DROP_OPERATOR: CommandTag = 126;
pub const CommandTag_CMDTAG_DROP_OPERATOR_CLASS: CommandTag = 127;
pub const CommandTag_CMDTAG_DROP_OPERATOR_FAMILY: CommandTag = 128;
pub const CommandTag_CMDTAG_DROP_OWNED: CommandTag = 129;
pub const CommandTag_CMDTAG_DROP_POLICY: CommandTag = 130;
pub const CommandTag_CMDTAG_DROP_PROCEDURE: CommandTag = 131;
pub const CommandTag_CMDTAG_DROP_PUBLICATION: CommandTag = 132;
pub const CommandTag_CMDTAG_DROP_ROLE: CommandTag = 133;
pub const CommandTag_CMDTAG_DROP_ROUTINE: CommandTag = 134;
pub const CommandTag_CMDTAG_DROP_RULE: CommandTag = 135;
pub const CommandTag_CMDTAG_DROP_SCHEMA: CommandTag = 136;
pub const CommandTag_CMDTAG_DROP_SEQUENCE: CommandTag = 137;
pub const CommandTag_CMDTAG_DROP_SERVER: CommandTag = 138;
pub const CommandTag_CMDTAG_DROP_STATISTICS: CommandTag = 139;
pub const CommandTag_CMDTAG_DROP_SUBSCRIPTION: CommandTag = 140;
pub const CommandTag_CMDTAG_DROP_TABLE: CommandTag = 141;
pub const CommandTag_CMDTAG_DROP_TABLESPACE: CommandTag = 142;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_CONFIGURATION: CommandTag = 143;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_DICTIONARY: CommandTag = 144;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_PARSER: CommandTag = 145;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_TEMPLATE: CommandTag = 146;
pub const CommandTag_CMDTAG_DROP_TRANSFORM: CommandTag = 147;
pub const CommandTag_CMDTAG_DROP_TRIGGER: CommandTag = 148;
pub const CommandTag_CMDTAG_DROP_TYPE: CommandTag = 149;
pub const CommandTag_CMDTAG_DROP_USER_MAPPING: CommandTag = 150;
pub const CommandTag_CMDTAG_DROP_VIEW: CommandTag = 151;
pub const CommandTag_CMDTAG_EXECUTE: CommandTag = 152;
pub const CommandTag_CMDTAG_EXPLAIN: CommandTag = 153;
pub const CommandTag_CMDTAG_FETCH: CommandTag = 154;
pub const CommandTag_CMDTAG_GRANT: CommandTag = 155;
pub const CommandTag_CMDTAG_GRANT_ROLE: CommandTag = 156;
pub const CommandTag_CMDTAG_IMPORT_FOREIGN_SCHEMA: CommandTag = 157;
pub const CommandTag_CMDTAG_INSERT: CommandTag = 158;
pub const CommandTag_CMDTAG_LISTEN: CommandTag = 159;
pub const CommandTag_CMDTAG_LOAD: CommandTag = 160;
pub const CommandTag_CMDTAG_LOCK_TABLE: CommandTag = 161;
pub const CommandTag_CMDTAG_MOVE: CommandTag = 162;
pub const CommandTag_CMDTAG_NOTIFY: CommandTag = 163;
pub const CommandTag_CMDTAG_PREPARE: CommandTag = 164;
pub const CommandTag_CMDTAG_PREPARE_TRANSACTION: CommandTag = 165;
pub const CommandTag_CMDTAG_REASSIGN_OWNED: CommandTag = 166;
pub const CommandTag_CMDTAG_REFRESH_MATERIALIZED_VIEW: CommandTag = 167;
pub const CommandTag_CMDTAG_REINDEX: CommandTag = 168;
pub const CommandTag_CMDTAG_RELEASE: CommandTag = 169;
pub const CommandTag_CMDTAG_RESET: CommandTag = 170;
pub const CommandTag_CMDTAG_REVOKE: CommandTag = 171;
pub const CommandTag_CMDTAG_REVOKE_ROLE: CommandTag = 172;
pub const CommandTag_CMDTAG_ROLLBACK: CommandTag = 173;
pub const CommandTag_CMDTAG_ROLLBACK_PREPARED: CommandTag = 174;
pub const CommandTag_CMDTAG_SAVEPOINT: CommandTag = 175;
pub const CommandTag_CMDTAG_SECURITY_LABEL: CommandTag = 176;
pub const CommandTag_CMDTAG_SELECT: CommandTag = 177;
pub const CommandTag_CMDTAG_SELECT_FOR_KEY_SHARE: CommandTag = 178;
pub const CommandTag_CMDTAG_SELECT_FOR_NO_KEY_UPDATE: CommandTag = 179;
pub const CommandTag_CMDTAG_SELECT_FOR_SHARE: CommandTag = 180;
pub const CommandTag_CMDTAG_SELECT_FOR_UPDATE: CommandTag = 181;
pub const CommandTag_CMDTAG_SELECT_INTO: CommandTag = 182;
pub const CommandTag_CMDTAG_SET: CommandTag = 183;
pub const CommandTag_CMDTAG_SET_CONSTRAINTS: CommandTag = 184;
pub const CommandTag_CMDTAG_SHOW: CommandTag = 185;
pub const CommandTag_CMDTAG_START_TRANSACTION: CommandTag = 186;
pub const CommandTag_CMDTAG_TRUNCATE_TABLE: CommandTag = 187;
pub const CommandTag_CMDTAG_UNLISTEN: CommandTag = 188;
pub const CommandTag_CMDTAG_UPDATE: CommandTag = 189;
pub const CommandTag_CMDTAG_VACUUM: CommandTag = 190;
pub const CommandTag_COMMAND_TAG_NEXTTAG: CommandTag = 191;
pub type CommandTag = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryCompletion {
    pub commandTag: CommandTag,
    pub nprocessed: uint64,
}
impl Default for QueryCompletion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn InitializeQueryCompletion(arg_qc: *mut QueryCompletion) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitializeQueryCompletion(arg_qc: *mut QueryCompletion);
        }
        InitializeQueryCompletion(arg_qc)
    })
}
pub unsafe fn GetCommandTagName(arg_commandTag: CommandTag) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetCommandTagName(arg_commandTag: CommandTag) -> *const ::std::os::raw::c_char;
        }
        GetCommandTagName(arg_commandTag)
    })
}
pub unsafe fn command_tag_display_rowcount(arg_commandTag: CommandTag) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn command_tag_display_rowcount(arg_commandTag: CommandTag) -> bool;
        }
        command_tag_display_rowcount(arg_commandTag)
    })
}
pub unsafe fn command_tag_event_trigger_ok(arg_commandTag: CommandTag) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn command_tag_event_trigger_ok(arg_commandTag: CommandTag) -> bool;
        }
        command_tag_event_trigger_ok(arg_commandTag)
    })
}
pub unsafe fn command_tag_table_rewrite_ok(arg_commandTag: CommandTag) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn command_tag_table_rewrite_ok(arg_commandTag: CommandTag) -> bool;
        }
        command_tag_table_rewrite_ok(arg_commandTag)
    })
}
pub unsafe fn GetCommandTagEnum(arg_tagname: *const ::std::os::raw::c_char) -> CommandTag {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetCommandTagEnum(arg_tagname: *const ::std::os::raw::c_char) -> CommandTag;
        }
        GetCommandTagEnum(arg_tagname)
    })
}
pub const CommandDest_DestNone: CommandDest = 0;
pub const CommandDest_DestDebug: CommandDest = 1;
pub const CommandDest_DestRemote: CommandDest = 2;
pub const CommandDest_DestRemoteExecute: CommandDest = 3;
pub const CommandDest_DestRemoteSimple: CommandDest = 4;
pub const CommandDest_DestSPI: CommandDest = 5;
pub const CommandDest_DestTuplestore: CommandDest = 6;
pub const CommandDest_DestIntoRel: CommandDest = 7;
pub const CommandDest_DestCopyOut: CommandDest = 8;
pub const CommandDest_DestSQLFunction: CommandDest = 9;
pub const CommandDest_DestTransientRel: CommandDest = 10;
pub const CommandDest_DestTupleQueue: CommandDest = 11;
pub type CommandDest = ::std::os::raw::c_uint;
pub type DestReceiver = _DestReceiver;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DestReceiver {
    pub receiveSlot: ::std::option::Option<
        unsafe extern "C" fn(slot: *mut TupleTableSlot, self_: *mut DestReceiver) -> bool,
    >,
    pub rStartup: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut DestReceiver,
            operation: ::std::os::raw::c_int,
            typeinfo: TupleDesc,
        ),
    >,
    pub rShutdown: ::std::option::Option<unsafe extern "C" fn(self_: *mut DestReceiver)>,
    pub rDestroy: ::std::option::Option<unsafe extern "C" fn(self_: *mut DestReceiver)>,
    pub mydest: CommandDest,
}
impl Default for _DestReceiver {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut None_Receiver: *mut DestReceiver;
}
pub unsafe fn BeginCommand(arg_commandTag: CommandTag, arg_dest: CommandDest) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BeginCommand(arg_commandTag: CommandTag, arg_dest: CommandDest);
        }
        BeginCommand(arg_commandTag, arg_dest)
    })
}
pub unsafe fn CreateDestReceiver(arg_dest: CommandDest) -> *mut DestReceiver {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateDestReceiver(arg_dest: CommandDest) -> *mut DestReceiver;
        }
        CreateDestReceiver(arg_dest)
    })
}
pub unsafe fn EndCommand(
    arg_qc: *const QueryCompletion,
    arg_dest: CommandDest,
    arg_force_undecorated_output: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EndCommand(
                arg_qc: *const QueryCompletion,
                arg_dest: CommandDest,
                arg_force_undecorated_output: bool,
            );
        }
        EndCommand(arg_qc, arg_dest, arg_force_undecorated_output)
    })
}
pub unsafe fn EndReplicationCommand(arg_commandTag: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EndReplicationCommand(arg_commandTag: *const ::std::os::raw::c_char);
        }
        EndReplicationCommand(arg_commandTag)
    })
}
pub unsafe fn NullCommand(arg_dest: CommandDest) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn NullCommand(arg_dest: CommandDest);
        }
        NullCommand(arg_dest)
    })
}
pub unsafe fn ReadyForQuery(arg_dest: CommandDest) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadyForQuery(arg_dest: CommandDest);
        }
        ReadyForQuery(arg_dest)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryDesc {
    pub operation: CmdType,
    pub plannedstmt: *mut PlannedStmt,
    pub sourceText: *const ::std::os::raw::c_char,
    pub snapshot: Snapshot,
    pub crosscheck_snapshot: Snapshot,
    pub dest: *mut DestReceiver,
    pub params: ParamListInfo,
    pub queryEnv: *mut QueryEnvironment,
    pub instrument_options: ::std::os::raw::c_int,
    pub tupDesc: TupleDesc,
    pub estate: *mut EState,
    pub planstate: *mut PlanState,
    pub already_executed: bool,
    pub totaltime: *mut Instrumentation,
}
impl Default for QueryDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn CreateQueryDesc(
    arg_plannedstmt: *mut PlannedStmt,
    arg_sourceText: *const ::std::os::raw::c_char,
    arg_snapshot: Snapshot,
    arg_crosscheck_snapshot: Snapshot,
    arg_dest: *mut DestReceiver,
    arg_params: ParamListInfo,
    arg_queryEnv: *mut QueryEnvironment,
    arg_instrument_options: ::std::os::raw::c_int,
) -> *mut QueryDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateQueryDesc(
                arg_plannedstmt: *mut PlannedStmt,
                arg_sourceText: *const ::std::os::raw::c_char,
                arg_snapshot: Snapshot,
                arg_crosscheck_snapshot: Snapshot,
                arg_dest: *mut DestReceiver,
                arg_params: ParamListInfo,
                arg_queryEnv: *mut QueryEnvironment,
                arg_instrument_options: ::std::os::raw::c_int,
            ) -> *mut QueryDesc;
        }
        CreateQueryDesc(
            arg_plannedstmt,
            arg_sourceText,
            arg_snapshot,
            arg_crosscheck_snapshot,
            arg_dest,
            arg_params,
            arg_queryEnv,
            arg_instrument_options,
        )
    })
}
pub unsafe fn FreeQueryDesc(arg_qdesc: *mut QueryDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeQueryDesc(arg_qdesc: *mut QueryDesc);
        }
        FreeQueryDesc(arg_qdesc)
    })
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Value {
    pub type_: NodeTag,
    pub val: Value_ValUnion,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union Value_ValUnion {
    pub ival: ::std::os::raw::c_int,
    pub str_: *mut ::std::os::raw::c_char,
}
impl Default for Value_ValUnion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for Value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn makeInteger(arg_i: ::std::os::raw::c_int) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeInteger(arg_i: ::std::os::raw::c_int) -> *mut Value;
        }
        makeInteger(arg_i)
    })
}
pub unsafe fn makeFloat(arg_numericStr: *mut ::std::os::raw::c_char) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeFloat(arg_numericStr: *mut ::std::os::raw::c_char) -> *mut Value;
        }
        makeFloat(arg_numericStr)
    })
}
pub unsafe fn makeString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value;
        }
        makeString(arg_str_)
    })
}
pub unsafe fn makeBitString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeBitString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value;
        }
        makeBitString(arg_str_)
    })
}
pub const OverridingKind_OVERRIDING_NOT_SET: OverridingKind = 0;
pub const OverridingKind_OVERRIDING_USER_VALUE: OverridingKind = 1;
pub const OverridingKind_OVERRIDING_SYSTEM_VALUE: OverridingKind = 2;
pub type OverridingKind = ::std::os::raw::c_uint;
pub const QuerySource_QSRC_ORIGINAL: QuerySource = 0;
pub const QuerySource_QSRC_PARSER: QuerySource = 1;
pub const QuerySource_QSRC_INSTEAD_RULE: QuerySource = 2;
pub const QuerySource_QSRC_QUAL_INSTEAD_RULE: QuerySource = 3;
pub const QuerySource_QSRC_NON_INSTEAD_RULE: QuerySource = 4;
pub type QuerySource = ::std::os::raw::c_uint;
pub const SortByDir_SORTBY_DEFAULT: SortByDir = 0;
pub const SortByDir_SORTBY_ASC: SortByDir = 1;
pub const SortByDir_SORTBY_DESC: SortByDir = 2;
pub const SortByDir_SORTBY_USING: SortByDir = 3;
pub type SortByDir = ::std::os::raw::c_uint;
pub const SortByNulls_SORTBY_NULLS_DEFAULT: SortByNulls = 0;
pub const SortByNulls_SORTBY_NULLS_FIRST: SortByNulls = 1;
pub const SortByNulls_SORTBY_NULLS_LAST: SortByNulls = 2;
pub type SortByNulls = ::std::os::raw::c_uint;
pub const SetQuantifier_SET_QUANTIFIER_DEFAULT: SetQuantifier = 0;
pub const SetQuantifier_SET_QUANTIFIER_ALL: SetQuantifier = 1;
pub const SetQuantifier_SET_QUANTIFIER_DISTINCT: SetQuantifier = 2;
pub type SetQuantifier = ::std::os::raw::c_uint;
pub type AclMode = uint32;
#[doc = "\tQuery Tree"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Query {
    pub type_: NodeTag,
    pub commandType: CmdType,
    pub querySource: QuerySource,
    pub queryId: uint64,
    pub canSetTag: bool,
    pub utilityStmt: *mut Node,
    pub resultRelation: ::std::os::raw::c_int,
    pub hasAggs: bool,
    pub hasWindowFuncs: bool,
    pub hasTargetSRFs: bool,
    pub hasSubLinks: bool,
    pub hasDistinctOn: bool,
    pub hasRecursive: bool,
    pub hasModifyingCTE: bool,
    pub hasForUpdate: bool,
    pub hasRowSecurity: bool,
    pub isReturn: bool,
    pub cteList: *mut List,
    pub rtable: *mut List,
    pub jointree: *mut FromExpr,
    pub targetList: *mut List,
    pub override_: OverridingKind,
    pub onConflict: *mut OnConflictExpr,
    pub returningList: *mut List,
    pub groupClause: *mut List,
    pub groupDistinct: bool,
    pub groupingSets: *mut List,
    pub havingQual: *mut Node,
    pub windowClause: *mut List,
    pub distinctClause: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption,
    pub rowMarks: *mut List,
    pub setOperations: *mut Node,
    pub constraintDeps: *mut List,
    pub withCheckOptions: *mut List,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for Query {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\tSupporting data structures for Parse Trees"]
#[doc = ""]
#[doc = "\tMost of these node types appear in raw parsetrees output by the grammar,"]
#[doc = "\tand get transformed to something else by the analyzer.  A few of them"]
#[doc = "\tare used as-is in transformed querytrees."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeName {
    pub type_: NodeTag,
    pub names: *mut List,
    pub typeOid: Oid,
    pub setof: bool,
    pub pct_type: bool,
    pub typmods: *mut List,
    pub typemod: int32,
    pub arrayBounds: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for TypeName {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnRef {
    pub type_: NodeTag,
    pub fields: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ColumnRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamRef {
    pub type_: NodeTag,
    pub number: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for ParamRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const A_Expr_Kind_AEXPR_OP: A_Expr_Kind = 0;
pub const A_Expr_Kind_AEXPR_OP_ANY: A_Expr_Kind = 1;
pub const A_Expr_Kind_AEXPR_OP_ALL: A_Expr_Kind = 2;
pub const A_Expr_Kind_AEXPR_DISTINCT: A_Expr_Kind = 3;
pub const A_Expr_Kind_AEXPR_NOT_DISTINCT: A_Expr_Kind = 4;
pub const A_Expr_Kind_AEXPR_NULLIF: A_Expr_Kind = 5;
pub const A_Expr_Kind_AEXPR_IN: A_Expr_Kind = 6;
pub const A_Expr_Kind_AEXPR_LIKE: A_Expr_Kind = 7;
pub const A_Expr_Kind_AEXPR_ILIKE: A_Expr_Kind = 8;
pub const A_Expr_Kind_AEXPR_SIMILAR: A_Expr_Kind = 9;
pub const A_Expr_Kind_AEXPR_BETWEEN: A_Expr_Kind = 10;
pub const A_Expr_Kind_AEXPR_NOT_BETWEEN: A_Expr_Kind = 11;
pub const A_Expr_Kind_AEXPR_BETWEEN_SYM: A_Expr_Kind = 12;
pub const A_Expr_Kind_AEXPR_NOT_BETWEEN_SYM: A_Expr_Kind = 13;
pub type A_Expr_Kind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Expr {
    pub type_: NodeTag,
    pub kind: A_Expr_Kind,
    pub name: *mut List,
    pub lexpr: *mut Node,
    pub rexpr: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_Expr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct A_Const {
    pub type_: NodeTag,
    pub val: Value,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_Const {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeCast {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::std::os::raw::c_int,
}
impl Default for TypeCast {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateClause {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub collname: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for CollateClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RoleSpecType_ROLESPEC_CSTRING: RoleSpecType = 0;
pub const RoleSpecType_ROLESPEC_CURRENT_ROLE: RoleSpecType = 1;
pub const RoleSpecType_ROLESPEC_CURRENT_USER: RoleSpecType = 2;
pub const RoleSpecType_ROLESPEC_SESSION_USER: RoleSpecType = 3;
pub const RoleSpecType_ROLESPEC_PUBLIC: RoleSpecType = 4;
pub type RoleSpecType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RoleSpec {
    pub type_: NodeTag,
    pub roletype: RoleSpecType,
    pub rolename: *mut ::std::os::raw::c_char,
    pub location: ::std::os::raw::c_int,
}
impl Default for RoleSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncCall {
    pub type_: NodeTag,
    pub funcname: *mut List,
    pub args: *mut List,
    pub agg_order: *mut List,
    pub agg_filter: *mut Node,
    pub over: *mut WindowDef,
    pub agg_within_group: bool,
    pub agg_star: bool,
    pub agg_distinct: bool,
    pub func_variadic: bool,
    pub funcformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for FuncCall {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Star {
    pub type_: NodeTag,
}
impl Default for A_Star {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indices {
    pub type_: NodeTag,
    pub is_slice: bool,
    pub lidx: *mut Node,
    pub uidx: *mut Node,
}
impl Default for A_Indices {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indirection {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub indirection: *mut List,
}
impl Default for A_Indirection {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_ArrayExpr {
    pub type_: NodeTag,
    pub elements: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_ArrayExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResTarget {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub indirection: *mut List,
    pub val: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for ResTarget {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MultiAssignRef {
    pub type_: NodeTag,
    pub source: *mut Node,
    pub colno: ::std::os::raw::c_int,
    pub ncolumns: ::std::os::raw::c_int,
}
impl Default for MultiAssignRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortBy {
    pub type_: NodeTag,
    pub node: *mut Node,
    pub sortby_dir: SortByDir,
    pub sortby_nulls: SortByNulls,
    pub useOp: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for SortBy {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowDef {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub refname: *mut ::std::os::raw::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for WindowDef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeSubselect {
    pub type_: NodeTag,
    pub lateral: bool,
    pub subquery: *mut Node,
    pub alias: *mut Alias,
}
impl Default for RangeSubselect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeFunction {
    pub type_: NodeTag,
    pub lateral: bool,
    pub ordinality: bool,
    pub is_rowsfrom: bool,
    pub functions: *mut List,
    pub alias: *mut Alias,
    pub coldeflist: *mut List,
}
impl Default for RangeFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFunc {
    pub type_: NodeTag,
    pub lateral: bool,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub namespaces: *mut List,
    pub columns: *mut List,
    pub alias: *mut Alias,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFuncCol {
    pub type_: NodeTag,
    pub colname: *mut ::std::os::raw::c_char,
    pub typeName: *mut TypeName,
    pub for_ordinality: bool,
    pub is_not_null: bool,
    pub colexpr: *mut Node,
    pub coldefexpr: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableFuncCol {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableSample {
    pub type_: NodeTag,
    pub relation: *mut Node,
    pub method: *mut List,
    pub args: *mut List,
    pub repeatable: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableSample {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnDef {
    pub type_: NodeTag,
    pub colname: *mut ::std::os::raw::c_char,
    pub typeName: *mut TypeName,
    pub compression: *mut ::std::os::raw::c_char,
    pub inhcount: ::std::os::raw::c_int,
    pub is_local: bool,
    pub is_not_null: bool,
    pub is_from_type: bool,
    pub storage: ::std::os::raw::c_char,
    pub raw_default: *mut Node,
    pub cooked_default: *mut Node,
    pub identity: ::std::os::raw::c_char,
    pub identitySequence: *mut RangeVar,
    pub generated: ::std::os::raw::c_char,
    pub collClause: *mut CollateClause,
    pub collOid: Oid,
    pub constraints: *mut List,
    pub fdwoptions: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ColumnDef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableLikeClause {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub options: bits32,
    pub relationOid: Oid,
}
impl Default for TableLikeClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TableLikeOption_CREATE_TABLE_LIKE_COMMENTS: TableLikeOption = 1;
pub const TableLikeOption_CREATE_TABLE_LIKE_COMPRESSION: TableLikeOption = 2;
pub const TableLikeOption_CREATE_TABLE_LIKE_CONSTRAINTS: TableLikeOption = 4;
pub const TableLikeOption_CREATE_TABLE_LIKE_DEFAULTS: TableLikeOption = 8;
pub const TableLikeOption_CREATE_TABLE_LIKE_GENERATED: TableLikeOption = 16;
pub const TableLikeOption_CREATE_TABLE_LIKE_IDENTITY: TableLikeOption = 32;
pub const TableLikeOption_CREATE_TABLE_LIKE_INDEXES: TableLikeOption = 64;
pub const TableLikeOption_CREATE_TABLE_LIKE_STATISTICS: TableLikeOption = 128;
pub const TableLikeOption_CREATE_TABLE_LIKE_STORAGE: TableLikeOption = 256;
pub const TableLikeOption_CREATE_TABLE_LIKE_ALL: TableLikeOption = 2147483647;
pub type TableLikeOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexElem {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub expr: *mut Node,
    pub indexcolname: *mut ::std::os::raw::c_char,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub opclassopts: *mut List,
    pub ordering: SortByDir,
    pub nulls_ordering: SortByNulls,
}
impl Default for IndexElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DefElemAction_DEFELEM_UNSPEC: DefElemAction = 0;
pub const DefElemAction_DEFELEM_SET: DefElemAction = 1;
pub const DefElemAction_DEFELEM_ADD: DefElemAction = 2;
pub const DefElemAction_DEFELEM_DROP: DefElemAction = 3;
pub type DefElemAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DefElem {
    pub type_: NodeTag,
    pub defnamespace: *mut ::std::os::raw::c_char,
    pub defname: *mut ::std::os::raw::c_char,
    pub arg: *mut Node,
    pub defaction: DefElemAction,
    pub location: ::std::os::raw::c_int,
}
impl Default for DefElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockingClause {
    pub type_: NodeTag,
    pub lockedRels: *mut List,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
}
impl Default for LockingClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlSerialize {
    pub type_: NodeTag,
    pub xmloption: XmlOptionType,
    pub expr: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::std::os::raw::c_int,
}
impl Default for XmlSerialize {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionElem {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub expr: *mut Node,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionSpec {
    pub type_: NodeTag,
    pub strategy: *mut ::std::os::raw::c_char,
    pub partParams: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundSpec {
    pub type_: NodeTag,
    pub strategy: ::std::os::raw::c_char,
    pub is_default: bool,
    pub modulus: ::std::os::raw::c_int,
    pub remainder: ::std::os::raw::c_int,
    pub listdatums: *mut List,
    pub lowerdatums: *mut List,
    pub upperdatums: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionBoundSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_MINVALUE: PartitionRangeDatumKind = -1;
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_VALUE: PartitionRangeDatumKind = 0;
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_MAXVALUE: PartitionRangeDatumKind = 1;
pub type PartitionRangeDatumKind = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionRangeDatum {
    pub type_: NodeTag,
    pub kind: PartitionRangeDatumKind,
    pub value: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionRangeDatum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionCmd {
    pub type_: NodeTag,
    pub name: *mut RangeVar,
    pub bound: *mut PartitionBoundSpec,
    pub concurrent: bool,
}
impl Default for PartitionCmd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RTEKind_RTE_RELATION: RTEKind = 0;
pub const RTEKind_RTE_SUBQUERY: RTEKind = 1;
pub const RTEKind_RTE_JOIN: RTEKind = 2;
pub const RTEKind_RTE_FUNCTION: RTEKind = 3;
pub const RTEKind_RTE_TABLEFUNC: RTEKind = 4;
pub const RTEKind_RTE_