#[derive(Copy, Clone, Eq, PartialEq, Hash, Ord, PartialOrd, Debug)]
pub enum PgBuiltInOids {
    BOOLOID = crate::BOOLOID as isize,
    BYTEAOID = crate::BYTEAOID as isize,
    CHAROID = crate::CHAROID as isize,
    NAMEOID = crate::NAMEOID as isize,
    INT8OID = crate::INT8OID as isize,
    INT2OID = crate::INT2OID as isize,
    INT2VECTOROID = crate::INT2VECTOROID as isize,
    INT4OID = crate::INT4OID as isize,
    REGPROCOID = crate::REGPROCOID as isize,
    TEXTOID = crate::TEXTOID as isize,
    OIDOID = crate::OIDOID as isize,
    TIDOID = crate::TIDOID as isize,
    XIDOID = crate::XIDOID as isize,
    CIDOID = crate::CIDOID as isize,
    OIDVECTOROID = crate::OIDVECTOROID as isize,
    JSONOID = crate::JSONOID as isize,
    XMLOID = crate::XMLOID as isize,
    PGNODETREEOID = crate::PGNODETREEOID as isize,
    PGNDISTINCTOID = crate::PGNDISTINCTOID as isize,
    PGDEPENDENCIESOID = crate::PGDEPENDENCIESOID as isize,
    PGDDLCOMMANDOID = crate::PGDDLCOMMANDOID as isize,
    POINTOID = crate::POINTOID as isize,
    LSEGOID = crate::LSEGOID as isize,
    PATHOID = crate::PATHOID as isize,
    BOXOID = crate::BOXOID as isize,
    POLYGONOID = crate::POLYGONOID as isize,
    LINEOID = crate::LINEOID as isize,
    FLOAT4OID = crate::FLOAT4OID as isize,
    FLOAT8OID = crate::FLOAT8OID as isize,
    ABSTIMEOID = crate::ABSTIMEOID as isize,
    RELTIMEOID = crate::RELTIMEOID as isize,
    TINTERVALOID = crate::TINTERVALOID as isize,
    UNKNOWNOID = crate::UNKNOWNOID as isize,
    CIRCLEOID = crate::CIRCLEOID as isize,
    CASHOID = crate::CASHOID as isize,
    MACADDROID = crate::MACADDROID as isize,
    INETOID = crate::INETOID as isize,
    CIDROID = crate::CIDROID as isize,
    MACADDR8OID = crate::MACADDR8OID as isize,
    INT2ARRAYOID = crate::INT2ARRAYOID as isize,
    INT4ARRAYOID = crate::INT4ARRAYOID as isize,
    TEXTARRAYOID = crate::TEXTARRAYOID as isize,
    OIDARRAYOID = crate::OIDARRAYOID as isize,
    FLOAT4ARRAYOID = crate::FLOAT4ARRAYOID as isize,
    ACLITEMOID = crate::ACLITEMOID as isize,
    CSTRINGARRAYOID = crate::CSTRINGARRAYOID as isize,
    BPCHAROID = crate::BPCHAROID as isize,
    VARCHAROID = crate::VARCHAROID as isize,
    DATEOID = crate::DATEOID as isize,
    TIMEOID = crate::TIMEOID as isize,
    TIMESTAMPOID = crate::TIMESTAMPOID as isize,
    TIMESTAMPTZOID = crate::TIMESTAMPTZOID as isize,
    INTERVALOID = crate::INTERVALOID as isize,
    TIMETZOID = crate::TIMETZOID as isize,
    BITOID = crate::BITOID as isize,
    VARBITOID = crate::VARBITOID as isize,
    NUMERICOID = crate::NUMERICOID as isize,
    REFCURSOROID = crate::REFCURSOROID as isize,
    REGPROCEDUREOID = crate::REGPROCEDUREOID as isize,
    REGOPEROID = crate::REGOPEROID as isize,
    REGOPERATOROID = crate::REGOPERATOROID as isize,
    REGCLASSOID = crate::REGCLASSOID as isize,
    REGTYPEOID = crate::REGTYPEOID as isize,
    REGROLEOID = crate::REGROLEOID as isize,
    REGNAMESPACEOID = crate::REGNAMESPACEOID as isize,
    REGTYPEARRAYOID = crate::REGTYPEARRAYOID as isize,
    UUIDOID = crate::UUIDOID as isize,
    LSNOID = crate::LSNOID as isize,
    TSVECTOROID = crate::TSVECTOROID as isize,
    GTSVECTOROID = crate::GTSVECTOROID as isize,
    TSQUERYOID = crate::TSQUERYOID as isize,
    REGCONFIGOID = crate::REGCONFIGOID as isize,
    REGDICTIONARYOID = crate::REGDICTIONARYOID as isize,
    JSONBOID = crate::JSONBOID as isize,
    INT4RANGEOID = crate::INT4RANGEOID as isize,
    RECORDOID = crate::RECORDOID as isize,
    RECORDARRAYOID = crate::RECORDARRAYOID as isize,
    CSTRINGOID = crate::CSTRINGOID as isize,
    ANYOID = crate::ANYOID as isize,
    ANYARRAYOID = crate::ANYARRAYOID as isize,
    VOIDOID = crate::VOIDOID as isize,
    TRIGGEROID = crate::TRIGGEROID as isize,
    EVTTRIGGEROID = crate::EVTTRIGGEROID as isize,
    LANGUAGE_HANDLEROID = crate::LANGUAGE_HANDLEROID as isize,
    INTERNALOID = crate::INTERNALOID as isize,
    OPAQUEOID = crate::OPAQUEOID as isize,
    ANYELEMENTOID = crate::ANYELEMENTOID as isize,
    ANYNONARRAYOID = crate::ANYNONARRAYOID as isize,
    ANYENUMOID = crate::ANYENUMOID as isize,
    FDW_HANDLEROID = crate::FDW_HANDLEROID as isize,
    INDEX_AM_HANDLEROID = crate::INDEX_AM_HANDLEROID as isize,
    TSM_HANDLEROID = crate::TSM_HANDLEROID as isize,
    ANYRANGEOID = crate::ANYRANGEOID as isize,
    AT_REWRITE_ALTER_OID = crate::AT_REWRITE_ALTER_OID as isize,
}
impl PgBuiltInOids {
    pub fn from(oid: crate::Oid) -> Option<PgBuiltInOids> {
        match oid {
            crate::BOOLOID => Some(crate::PgBuiltInOids::BOOLOID),
            crate::BYTEAOID => Some(crate::PgBuiltInOids::BYTEAOID),
            crate::CHAROID => Some(crate::PgBuiltInOids::CHAROID),
            crate::NAMEOID => Some(crate::PgBuiltInOids::NAMEOID),
            crate::INT8OID => Some(crate::PgBuiltInOids::INT8OID),
            crate::INT2OID => Some(crate::PgBuiltInOids::INT2OID),
            crate::INT2VECTOROID => Some(crate::PgBuiltInOids::INT2VECTOROID),
            crate::INT4OID => Some(crate::PgBuiltInOids::INT4OID),
            crate::REGPROCOID => Some(crate::PgBuiltInOids::REGPROCOID),
            crate::TEXTOID => Some(crate::PgBuiltInOids::TEXTOID),
            crate::OIDOID => Some(crate::PgBuiltInOids::OIDOID),
            crate::TIDOID => Some(crate::PgBuiltInOids::TIDOID),
            crate::XIDOID => Some(crate::PgBuiltInOids::XIDOID),
            crate::CIDOID => Some(crate::PgBuiltInOids::CIDOID),
            crate::OIDVECTOROID => Some(crate::PgBuiltInOids::OIDVECTOROID),
            crate::JSONOID => Some(crate::PgBuiltInOids::JSONOID),
            crate::XMLOID => Some(crate::PgBuiltInOids::XMLOID),
            crate::PGNODETREEOID => Some(crate::PgBuiltInOids::PGNODETREEOID),
            crate::PGNDISTINCTOID => Some(crate::PgBuiltInOids::PGNDISTINCTOID),
            crate::PGDEPENDENCIESOID => Some(crate::PgBuiltInOids::PGDEPENDENCIESOID),
            crate::PGDDLCOMMANDOID => Some(crate::PgBuiltInOids::PGDDLCOMMANDOID),
            crate::POINTOID => Some(crate::PgBuiltInOids::POINTOID),
            crate::LSEGOID => Some(crate::PgBuiltInOids::LSEGOID),
            crate::PATHOID => Some(crate::PgBuiltInOids::PATHOID),
            crate::BOXOID => Some(crate::PgBuiltInOids::BOXOID),
            crate::POLYGONOID => Some(crate::PgBuiltInOids::POLYGONOID),
            crate::LINEOID => Some(crate::PgBuiltInOids::LINEOID),
            crate::FLOAT4OID => Some(crate::PgBuiltInOids::FLOAT4OID),
            crate::FLOAT8OID => Some(crate::PgBuiltInOids::FLOAT8OID),
            crate::ABSTIMEOID => Some(crate::PgBuiltInOids::ABSTIMEOID),
            crate::RELTIMEOID => Some(crate::PgBuiltInOids::RELTIMEOID),
            crate::TINTERVALOID => Some(crate::PgBuiltInOids::TINTERVALOID),
            crate::UNKNOWNOID => Some(crate::PgBuiltInOids::UNKNOWNOID),
            crate::CIRCLEOID => Some(crate::PgBuiltInOids::CIRCLEOID),
            crate::CASHOID => Some(crate::PgBuiltInOids::CASHOID),
            crate::MACADDROID => Some(crate::PgBuiltInOids::MACADDROID),
            crate::INETOID => Some(crate::PgBuiltInOids::INETOID),
            crate::CIDROID => Some(crate::PgBuiltInOids::CIDROID),
            crate::MACADDR8OID => Some(crate::PgBuiltInOids::MACADDR8OID),
            crate::INT2ARRAYOID => Some(crate::PgBuiltInOids::INT2ARRAYOID),
            crate::INT4ARRAYOID => Some(crate::PgBuiltInOids::INT4ARRAYOID),
            crate::TEXTARRAYOID => Some(crate::PgBuiltInOids::TEXTARRAYOID),
            crate::OIDARRAYOID => Some(crate::PgBuiltInOids::OIDARRAYOID),
            crate::FLOAT4ARRAYOID => Some(crate::PgBuiltInOids::FLOAT4ARRAYOID),
            crate::ACLITEMOID => Some(crate::PgBuiltInOids::ACLITEMOID),
            crate::CSTRINGARRAYOID => Some(crate::PgBuiltInOids::CSTRINGARRAYOID),
            crate::BPCHAROID => Some(crate::PgBuiltInOids::BPCHAROID),
            crate::VARCHAROID => Some(crate::PgBuiltInOids::VARCHAROID),
            crate::DATEOID => Some(crate::PgBuiltInOids::DATEOID),
            crate::TIMEOID => Some(crate::PgBuiltInOids::TIMEOID),
            crate::TIMESTAMPOID => Some(crate::PgBuiltInOids::TIMESTAMPOID),
            crate::TIMESTAMPTZOID => Some(crate::PgBuiltInOids::TIMESTAMPTZOID),
            crate::INTERVALOID => Some(crate::PgBuiltInOids::INTERVALOID),
            crate::TIMETZOID => Some(crate::PgBuiltInOids::TIMETZOID),
            crate::BITOID => Some(crate::PgBuiltInOids::BITOID),
            crate::VARBITOID => Some(crate::PgBuiltInOids::VARBITOID),
            crate::NUMERICOID => Some(crate::PgBuiltInOids::NUMERICOID),
            crate::REFCURSOROID => Some(crate::PgBuiltInOids::REFCURSOROID),
            crate::REGPROCEDUREOID => Some(crate::PgBuiltInOids::REGPROCEDUREOID),
            crate::REGOPEROID => Some(crate::PgBuiltInOids::REGOPEROID),
            crate::REGOPERATOROID => Some(crate::PgBuiltInOids::REGOPERATOROID),
            crate::REGCLASSOID => Some(crate::PgBuiltInOids::REGCLASSOID),
            crate::REGTYPEOID => Some(crate::PgBuiltInOids::REGTYPEOID),
            crate::REGROLEOID => Some(crate::PgBuiltInOids::REGROLEOID),
            crate::REGNAMESPACEOID => Some(crate::PgBuiltInOids::REGNAMESPACEOID),
            crate::REGTYPEARRAYOID => Some(crate::PgBuiltInOids::REGTYPEARRAYOID),
            crate::UUIDOID => Some(crate::PgBuiltInOids::UUIDOID),
            crate::LSNOID => Some(crate::PgBuiltInOids::LSNOID),
            crate::TSVECTOROID => Some(crate::PgBuiltInOids::TSVECTOROID),
            crate::GTSVECTOROID => Some(crate::PgBuiltInOids::GTSVECTOROID),
            crate::TSQUERYOID => Some(crate::PgBuiltInOids::TSQUERYOID),
            crate::REGCONFIGOID => Some(crate::PgBuiltInOids::REGCONFIGOID),
            crate::REGDICTIONARYOID => Some(crate::PgBuiltInOids::REGDICTIONARYOID),
            crate::JSONBOID => Some(crate::PgBuiltInOids::JSONBOID),
            crate::INT4RANGEOID => Some(crate::PgBuiltInOids::INT4RANGEOID),
            crate::RECORDOID => Some(crate::PgBuiltInOids::RECORDOID),
            crate::RECORDARRAYOID => Some(crate::PgBuiltInOids::RECORDARRAYOID),
            crate::CSTRINGOID => Some(crate::PgBuiltInOids::CSTRINGOID),
            crate::ANYOID => Some(crate::PgBuiltInOids::ANYOID),
            crate::ANYARRAYOID => Some(crate::PgBuiltInOids::ANYARRAYOID),
            crate::VOIDOID => Some(crate::PgBuiltInOids::VOIDOID),
            crate::TRIGGEROID => Some(crate::PgBuiltInOids::TRIGGEROID),
            crate::EVTTRIGGEROID => Some(crate::PgBuiltInOids::EVTTRIGGEROID),
            crate::LANGUAGE_HANDLEROID => Some(crate::PgBuiltInOids::LANGUAGE_HANDLEROID),
            crate::INTERNALOID => Some(crate::PgBuiltInOids::INTERNALOID),
            crate::OPAQUEOID => Some(crate::PgBuiltInOids::OPAQUEOID),
            crate::ANYELEMENTOID => Some(crate::PgBuiltInOids::ANYELEMENTOID),
            crate::ANYNONARRAYOID => Some(crate::PgBuiltInOids::ANYNONARRAYOID),
            crate::ANYENUMOID => Some(crate::PgBuiltInOids::ANYENUMOID),
            crate::FDW_HANDLEROID => Some(crate::PgBuiltInOids::FDW_HANDLEROID),
            crate::INDEX_AM_HANDLEROID => Some(crate::PgBuiltInOids::INDEX_AM_HANDLEROID),
            crate::TSM_HANDLEROID => Some(crate::PgBuiltInOids::TSM_HANDLEROID),
            crate::ANYRANGEOID => Some(crate::PgBuiltInOids::ANYRANGEOID),
            crate::AT_REWRITE_ALTER_OID => Some(crate::PgBuiltInOids::AT_REWRITE_ALTER_OID),
            _ => None,
        }
    }
}
