use crate as pg_sys;
use crate::PgNode;
use pgx_macros::*;
#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const USE_STDBOOL: u32 = 1;
pub const PG_DIAG_SEVERITY: u8 = 83u8;
pub const PG_DIAG_SEVERITY_NONLOCALIZED: u8 = 86u8;
pub const PG_DIAG_SQLSTATE: u8 = 67u8;
pub const PG_DIAG_MESSAGE_PRIMARY: u8 = 77u8;
pub const PG_DIAG_MESSAGE_DETAIL: u8 = 68u8;
pub const PG_DIAG_MESSAGE_HINT: u8 = 72u8;
pub const PG_DIAG_STATEMENT_POSITION: u8 = 80u8;
pub const PG_DIAG_INTERNAL_POSITION: u8 = 112u8;
pub const PG_DIAG_INTERNAL_QUERY: u8 = 113u8;
pub const PG_DIAG_CONTEXT: u8 = 87u8;
pub const PG_DIAG_SCHEMA_NAME: u8 = 115u8;
pub const PG_DIAG_TABLE_NAME: u8 = 116u8;
pub const PG_DIAG_COLUMN_NAME: u8 = 99u8;
pub const PG_DIAG_DATATYPE_NAME: u8 = 100u8;
pub const PG_DIAG_CONSTRAINT_NAME: u8 = 110u8;
pub const PG_DIAG_SOURCE_FILE: u8 = 70u8;
pub const PG_DIAG_SOURCE_LINE: u8 = 76u8;
pub const PG_DIAG_SOURCE_FUNCTION: u8 = 82u8;
pub const ALIGNOF_DOUBLE: u32 = 8;
pub const ALIGNOF_INT: u32 = 4;
pub const ALIGNOF_LONG: u32 = 8;
pub const ALIGNOF_PG_INT128_TYPE: u32 = 16;
pub const ALIGNOF_SHORT: u32 = 2;
pub const BLCKSZ: u32 = 8192;
pub const DEF_PGPORT: u32 = 28810;
pub const DEF_PGPORT_STR: &'static [u8; 6usize] = b"28810\0";
pub const ENABLE_THREAD_SAFETY: u32 = 1;
pub const FLOAT4PASSBYVAL: u32 = 1;
pub const FLOAT8PASSBYVAL: u32 = 1;
pub const HAVE_ATOMICS: u32 = 1;
pub const HAVE_CBRT: u32 = 1;
pub const HAVE_CLOCK_GETTIME: u32 = 1;
pub const HAVE_COMPUTED_GOTO: u32 = 1;
pub const HAVE_CRYPT: u32 = 1;
pub const HAVE_DECL_FDATASYNC: u32 = 0;
pub const HAVE_DECL_F_FULLFSYNC: u32 = 1;
pub const HAVE_DECL_POSIX_FADVISE: u32 = 0;
pub const HAVE_DECL_SNPRINTF: u32 = 1;
pub const HAVE_DECL_STRLCAT: u32 = 1;
pub const HAVE_DECL_STRLCPY: u32 = 1;
pub const HAVE_DECL_STRNLEN: u32 = 1;
pub const HAVE_DECL_STRTOLL: u32 = 1;
pub const HAVE_DECL_STRTOULL: u32 = 1;
pub const HAVE_DECL_VSNPRINTF: u32 = 1;
pub const HAVE_DLOPEN: u32 = 1;
pub const HAVE_FDATASYNC: u32 = 1;
pub const HAVE_FLS: u32 = 1;
pub const HAVE_FSEEKO: u32 = 1;
pub const HAVE_FUNCNAME__FUNC: u32 = 1;
pub const HAVE_GCC__ATOMIC_INT32_CAS: u32 = 1;
pub const HAVE_GCC__ATOMIC_INT64_CAS: u32 = 1;
pub const HAVE_GCC__SYNC_CHAR_TAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT32_CAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT32_TAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT64_CAS: u32 = 1;
pub const HAVE_GETADDRINFO: u32 = 1;
pub const HAVE_GETIFADDRS: u32 = 1;
pub const HAVE_GETOPT: u32 = 1;
pub const HAVE_GETOPT_H: u32 = 1;
pub const HAVE_GETOPT_LONG: u32 = 1;
pub const HAVE_GETPEEREID: u32 = 1;
pub const HAVE_GETPWUID_R: u32 = 1;
pub const HAVE_GETRLIMIT: u32 = 1;
pub const HAVE_GETRUSAGE: u32 = 1;
pub const HAVE_HISTORY_TRUNCATE_FILE: u32 = 1;
pub const HAVE_IFADDRS_H: u32 = 1;
pub const HAVE_INET_ATON: u32 = 1;
pub const HAVE_INTPTR_T: u32 = 1;
pub const HAVE_INTTYPES_H: u32 = 1;
pub const HAVE_INT_OPTERR: u32 = 1;
pub const HAVE_INT_OPTRESET: u32 = 1;
pub const HAVE_INT_TIMEZONE: u32 = 1;
pub const HAVE_IPV6: u32 = 1;
pub const HAVE_ISINF: u32 = 1;
pub const HAVE_LANGINFO_H: u32 = 1;
pub const HAVE_LIBM: u32 = 1;
pub const HAVE_LIBREADLINE: u32 = 1;
pub const HAVE_LIBZ: u32 = 1;
pub const HAVE_LOCALE_T: u32 = 1;
pub const HAVE_LONG_INT_64: u32 = 1;
pub const HAVE_LONG_LONG_INT: u32 = 1;
pub const HAVE_MBSTOWCS_L: u32 = 1;
pub const HAVE_MEMMOVE: u32 = 1;
pub const HAVE_MEMORY_H: u32 = 1;
pub const HAVE_MKDTEMP: u32 = 1;
pub const HAVE_NETINET_TCP_H: u32 = 1;
pub const HAVE_NET_IF_H: u32 = 1;
pub const HAVE_POLL: u32 = 1;
pub const HAVE_POLL_H: u32 = 1;
pub const HAVE_PTHREAD: u32 = 1;
pub const HAVE_PTHREAD_IS_THREADED_NP: u32 = 1;
pub const HAVE_PTHREAD_PRIO_INHERIT: u32 = 1;
pub const HAVE_RANDOM: u32 = 1;
pub const HAVE_READLINE_HISTORY_H: u32 = 1;
pub const HAVE_READLINE_READLINE_H: u32 = 1;
pub const HAVE_READLINK: u32 = 1;
pub const HAVE_RINT: u32 = 1;
pub const HAVE_RL_COMPLETION_APPEND_CHARACTER: u32 = 1;
pub const HAVE_RL_COMPLETION_MATCHES: u32 = 1;
pub const HAVE_RL_FILENAME_COMPLETION_FUNCTION: u32 = 1;
pub const HAVE_SETSID: u32 = 1;
pub const HAVE_SHM_OPEN: u32 = 1;
pub const HAVE_SNPRINTF: u32 = 1;
pub const HAVE_SPINLOCKS: u32 = 1;
pub const HAVE_SRANDOM: u32 = 1;
pub const HAVE_STDINT_H: u32 = 1;
pub const HAVE_STDLIB_H: u32 = 1;
pub const HAVE_STRERROR: u32 = 1;
pub const HAVE_STRERROR_R: u32 = 1;
pub const HAVE_STRINGS_H: u32 = 1;
pub const HAVE_STRING_H: u32 = 1;
pub const HAVE_STRLCAT: u32 = 1;
pub const HAVE_STRLCPY: u32 = 1;
pub const HAVE_STRNLEN: u32 = 1;
pub const HAVE_STRONG_RANDOM: u32 = 1;
pub const HAVE_STRSIGNAL: u32 = 1;
pub const HAVE_STRTOLL: u32 = 1;
pub const HAVE_STRTOULL: u32 = 1;
pub const HAVE_STRUCT_ADDRINFO: u32 = 1;
pub const HAVE_STRUCT_OPTION: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_SA_LEN: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE_SS_FAMILY: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE_SS_LEN: u32 = 1;
pub const HAVE_STRUCT_TM_TM_ZONE: u32 = 1;
pub const HAVE_SYMLINK: u32 = 1;
pub const HAVE_SYSLOG: u32 = 1;
pub const HAVE_SYS_IPC_H: u32 = 1;
pub const HAVE_SYS_RESOURCE_H: u32 = 1;
pub const HAVE_SYS_SELECT_H: u32 = 1;
pub const HAVE_SYS_SEM_H: u32 = 1;
pub const HAVE_SYS_SHM_H: u32 = 1;
pub const HAVE_SYS_SOCKIO_H: u32 = 1;
pub const HAVE_SYS_STAT_H: u32 = 1;
pub const HAVE_SYS_TYPES_H: u32 = 1;
pub const HAVE_SYS_UCRED_H: u32 = 1;
pub const HAVE_SYS_UN_H: u32 = 1;
pub const HAVE_TERMIOS_H: u32 = 1;
pub const HAVE_TM_ZONE: u32 = 1;
pub const HAVE_TOWLOWER: u32 = 1;
pub const HAVE_TYPEOF: u32 = 1;
pub const HAVE_TZNAME: u32 = 1;
pub const HAVE_UINTPTR_T: u32 = 1;
pub const HAVE_UNION_SEMUN: u32 = 1;
pub const HAVE_UNISTD_H: u32 = 1;
pub const HAVE_UNIX_SOCKETS: u32 = 1;
pub const HAVE_UNSETENV: u32 = 1;
pub const HAVE_UNSIGNED_LONG_LONG_INT: u32 = 1;
pub const HAVE_USELOCALE: u32 = 1;
pub const HAVE_UTIME: u32 = 1;
pub const HAVE_UTIMES: u32 = 1;
pub const HAVE_UTIME_H: u32 = 1;
pub const HAVE_VSNPRINTF: u32 = 1;
pub const HAVE_WCHAR_H: u32 = 1;
pub const HAVE_WCSTOMBS: u32 = 1;
pub const HAVE_WCSTOMBS_L: u32 = 1;
pub const HAVE_WCTYPE_H: u32 = 1;
pub const HAVE__BUILTIN_BSWAP32: u32 = 1;
pub const HAVE__BUILTIN_BSWAP64: u32 = 1;
pub const HAVE__BUILTIN_CONSTANT_P: u32 = 1;
pub const HAVE__BUILTIN_TYPES_COMPATIBLE_P: u32 = 1;
pub const HAVE__BUILTIN_UNREACHABLE: u32 = 1;
pub const HAVE__GET_CPUID: u32 = 1;
pub const HAVE__STATIC_ASSERT: u32 = 1;
pub const HAVE__VA_ARGS: u32 = 1;
pub const INT64_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const LOCALE_T_IN_XLOCALE: u32 = 1;
pub const MAXIMUM_ALIGNOF: u32 = 8;
pub const MEMSET_LOOP_LIMIT: u32 = 1024;
pub const PACKAGE_BUGREPORT: &'static [u8; 26usize] = b"pgsql-bugs@postgresql.org\0";
pub const PACKAGE_NAME: &'static [u8; 11usize] = b"PostgreSQL\0";
pub const PACKAGE_STRING: &'static [u8; 17usize] = b"PostgreSQL 10.18\0";
pub const PACKAGE_TARNAME: &'static [u8; 11usize] = b"postgresql\0";
pub const PACKAGE_URL: &'static [u8; 1usize] = b"\0";
pub const PACKAGE_VERSION: &'static [u8; 6usize] = b"10.18\0";
pub const PG_KRB_SRVNAM: &'static [u8; 9usize] = b"postgres\0";
pub const PG_MAJORVERSION: &'static [u8; 3usize] = b"10\0";
pub const PG_VERSION: &'static [u8; 6usize] = b"10.18\0";
pub const PG_VERSION_NUM: u32 = 100018;
pub const PG_VERSION_STR : & 'static [u8 ; 114usize] = b"PostgreSQL 10.18 on x86_64-apple-darwin20.4.0, compiled by Apple clang version 13.0.0 (clang-1300.0.29.3), 64-bit\0" ;
pub const RELSEG_SIZE: u32 = 131072;
pub const SIZEOF_LONG: u32 = 8;
pub const SIZEOF_OFF_T: u32 = 8;
pub const SIZEOF_SIZE_T: u32 = 8;
pub const SIZEOF_VOID_P: u32 = 8;
pub const STDC_HEADERS: u32 = 1;
pub const STRERROR_R_INT: u32 = 1;
pub const USE_ASSERT_CHECKING: u32 = 1;
pub const USE_DEV_URANDOM: u32 = 1;
pub const USE_FLOAT4_BYVAL: u32 = 1;
pub const USE_FLOAT8_BYVAL: u32 = 1;
pub const USE_SSE42_CRC32C_WITH_RUNTIME_CHECK: u32 = 1;
pub const USE_SYSV_SEMAPHORES: u32 = 1;
pub const USE_SYSV_SHARED_MEMORY: u32 = 1;
pub const WCSTOMBS_L_IN_XLOCALE: u32 = 1;
pub const XLOG_BLCKSZ: u32 = 8192;
pub const XLOG_SEG_SIZE: u32 = 16777216;
pub const NAMEDATALEN: u32 = 64;
pub const FUNC_MAX_ARGS: u32 = 100;
pub const INDEX_MAX_KEYS: u32 = 32;
pub const PARTITION_MAX_KEYS: u32 = 32;
pub const NUM_SPINLOCK_SEMAPHORES: u32 = 128;
pub const NUM_ATOMICS_SEMAPHORES: u32 = 64;
pub const MAXPGPATH: u32 = 1024;
pub const PG_SOMAXCONN: u32 = 10000;
pub const BITS_PER_BYTE: u32 = 8;
pub const ALIGNOF_BUFFER: u32 = 32;
pub const HAVE_WORKING_LINK: u32 = 1;
pub const DEFAULT_BACKEND_FLUSH_AFTER: u32 = 0;
pub const DEFAULT_BGWRITER_FLUSH_AFTER: u32 = 0;
pub const DEFAULT_CHECKPOINT_FLUSH_AFTER: u32 = 0;
pub const WRITEBACK_MAX_PENDING_FLUSHES: u32 = 256;
pub const DEFAULT_PGSOCKET_DIR: &'static [u8; 5usize] = b"/tmp\0";
pub const DEFAULT_EVENT_SOURCE: &'static [u8; 11usize] = b"PostgreSQL\0";
pub const PG_CACHE_LINE_SIZE: u32 = 128;
pub const TRACE_SORT: u32 = 1;
pub const __darwin__: u32 = 1;
pub const __DARWIN_ONLY_64_BIT_INO_T: u32 = 0;
pub const __DARWIN_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const __DARWIN_ONLY_VERS_1050: u32 = 0;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_64_BIT_INO_T: &'static [u8; 9usize] = b"$INODE64\0";
pub const __DARWIN_SUF_1050: &'static [u8; 6usize] = b"$1050\0";
pub const __DARWIN_SUF_EXTSN: &'static [u8; 14usize] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __STDC_WANT_LIB_EXT1__: u32 = 1;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_14_6: u32 = 101406;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __MAC_10_16: u32 = 101600;
pub const __MAC_11_0: u32 = 110000;
pub const __MAC_11_1: u32 = 110100;
pub const __MAC_11_3: u32 = 110300;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_12_4: u32 = 120400;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __IPHONE_13_5: u32 = 130500;
pub const __IPHONE_13_6: u32 = 130600;
pub const __IPHONE_13_7: u32 = 130700;
pub const __IPHONE_14_0: u32 = 140000;
pub const __IPHONE_14_1: u32 = 140100;
pub const __IPHONE_14_2: u32 = 140200;
pub const __IPHONE_14_3: u32 = 140300;
pub const __IPHONE_14_5: u32 = 140500;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_12_4: u32 = 120400;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __TVOS_14_0: u32 = 140000;
pub const __TVOS_14_1: u32 = 140100;
pub const __TVOS_14_2: u32 = 140200;
pub const __TVOS_14_3: u32 = 140300;
pub const __TVOS_14_5: u32 = 140500;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_5_3: u32 = 50300;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __WATCHOS_7_0: u32 = 70000;
pub const __WATCHOS_7_1: u32 = 70100;
pub const __WATCHOS_7_2: u32 = 70200;
pub const __WATCHOS_7_3: u32 = 70300;
pub const __WATCHOS_7_4: u32 = 70400;
pub const MAC_OS_X_VERSION_10_0: u32 = 1000;
pub const MAC_OS_X_VERSION_10_1: u32 = 1010;
pub const MAC_OS_X_VERSION_10_2: u32 = 1020;
pub const MAC_OS_X_VERSION_10_3: u32 = 1030;
pub const MAC_OS_X_VERSION_10_4: u32 = 1040;
pub const MAC_OS_X_VERSION_10_5: u32 = 1050;
pub const MAC_OS_X_VERSION_10_6: u32 = 1060;
pub const MAC_OS_X_VERSION_10_7: u32 = 1070;
pub const MAC_OS_X_VERSION_10_8: u32 = 1080;
pub const MAC_OS_X_VERSION_10_9: u32 = 1090;
pub const MAC_OS_X_VERSION_10_10: u32 = 101000;
pub const MAC_OS_X_VERSION_10_10_2: u32 = 101002;
pub const MAC_OS_X_VERSION_10_10_3: u32 = 101003;
pub const MAC_OS_X_VERSION_10_11: u32 = 101100;
pub const MAC_OS_X_VERSION_10_11_2: u32 = 101102;
pub const MAC_OS_X_VERSION_10_11_3: u32 = 101103;
pub const MAC_OS_X_VERSION_10_11_4: u32 = 101104;
pub const MAC_OS_X_VERSION_10_12: u32 = 101200;
pub const MAC_OS_X_VERSION_10_12_1: u32 = 101201;
pub const MAC_OS_X_VERSION_10_12_2: u32 = 101202;
pub const MAC_OS_X_VERSION_10_12_4: u32 = 101204;
pub const MAC_OS_X_VERSION_10_13: u32 = 101300;
pub const MAC_OS_X_VERSION_10_13_1: u32 = 101301;
pub const MAC_OS_X_VERSION_10_13_2: u32 = 101302;
pub const MAC_OS_X_VERSION_10_13_4: u32 = 101304;
pub const MAC_OS_X_VERSION_10_14: u32 = 101400;
pub const MAC_OS_X_VERSION_10_14_1: u32 = 101401;
pub const MAC_OS_X_VERSION_10_14_4: u32 = 101404;
pub const MAC_OS_X_VERSION_10_14_6: u32 = 101406;
pub const MAC_OS_X_VERSION_10_15: u32 = 101500;
pub const MAC_OS_X_VERSION_10_15_1: u32 = 101501;
pub const MAC_OS_X_VERSION_10_16: u32 = 101600;
pub const MAC_OS_VERSION_11_0: u32 = 110000;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __DRIVERKIT_20_0: u32 = 200000;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 110300;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const RENAME_SECLUDE: u32 = 1;
pub const RENAME_SWAP: u32 = 2;
pub const RENAME_EXCL: u32 = 4;
pub const __SLBF: u32 = 1;
pub const __SNBF: u32 = 2;
pub const __SRD: u32 = 4;
pub const __SWR: u32 = 8;
pub const __SRW: u32 = 16;
pub const __SEOF: u32 = 32;
pub const __SERR: u32 = 64;
pub const __SMBF: u32 = 128;
pub const __SAPP: u32 = 256;
pub const __SSTR: u32 = 512;
pub const __SOPT: u32 = 1024;
pub const __SNPT: u32 = 2048;
pub const __SOFF: u32 = 4096;
pub const __SMOD: u32 = 8192;
pub const __SALC: u32 = 16384;
pub const __SIGN: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 1024;
pub const EOF: i32 = -1;
pub const FOPEN_MAX: u32 = 20;
pub const FILENAME_MAX: u32 = 1024;
pub const P_tmpdir: &'static [u8; 10usize] = b"/var/tmp/\0";
pub const L_tmpnam: u32 = 1024;
pub const TMP_MAX: u32 = 308915776;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const L_ctermid: u32 = 1024;
pub const _USE_FORTIFY_LEVEL: u32 = 2;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _I386_SIGNAL_H_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const FP_PREC_24B: u32 = 0;
pub const FP_PREC_53B: u32 = 2;
pub const FP_PREC_64B: u32 = 3;
pub const FP_RND_NEAR: u32 = 0;
pub const FP_RND_DOWN: u32 = 1;
pub const FP_RND_UP: u32 = 2;
pub const FP_CHOP: u32 = 3;
pub const FP_STATE_BYTES: u32 = 512;
pub const _X86_INSTRUCTION_STATE_MAX_INSN_BYTES: u32 = 2380;
pub const _X86_INSTRUCTION_STATE_CACHELINE_SIZE: u32 = 64;
pub const __LASTBRANCH_MAX: u32 = 32;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const __WORDSIZE: u32 = 64;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const RSIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const PRIO_PROCESS: u32 = 0;
pub const PRIO_PGRP: u32 = 1;
pub const PRIO_USER: u32 = 2;
pub const PRIO_DARWIN_THREAD: u32 = 3;
pub const PRIO_DARWIN_PROCESS: u32 = 4;
pub const PRIO_MIN: i32 = -20;
pub const PRIO_MAX: u32 = 20;
pub const PRIO_DARWIN_BG: u32 = 4096;
pub const PRIO_DARWIN_NONUI: u32 = 4097;
pub const RUSAGE_SELF: u32 = 0;
pub const RUSAGE_CHILDREN: i32 = -1;
pub const RUSAGE_INFO_V0: u32 = 0;
pub const RUSAGE_INFO_V1: u32 = 1;
pub const RUSAGE_INFO_V2: u32 = 2;
pub const RUSAGE_INFO_V3: u32 = 3;
pub const RUSAGE_INFO_V4: u32 = 4;
pub const RUSAGE_INFO_V5: u32 = 5;
pub const RUSAGE_INFO_CURRENT: u32 = 5;
pub const RU_PROC_RUNS_RESLIDE: u32 = 1;
pub const RLIMIT_CPU: u32 = 0;
pub const RLIMIT_FSIZE: u32 = 1;
pub const RLIMIT_DATA: u32 = 2;
pub const RLIMIT_STACK: u32 = 3;
pub const RLIMIT_CORE: u32 = 4;
pub const RLIMIT_AS: u32 = 5;
pub const RLIMIT_RSS: u32 = 5;
pub const RLIMIT_MEMLOCK: u32 = 6;
pub const RLIMIT_NPROC: u32 = 7;
pub const RLIMIT_NOFILE: u32 = 8;
pub const RLIM_NLIMITS: u32 = 9;
pub const _RLIMIT_POSIX_FLAG: u32 = 4096;
pub const RLIMIT_WAKEUPS_MONITOR: u32 = 1;
pub const RLIMIT_CPU_USAGE_MONITOR: u32 = 2;
pub const RLIMIT_THREAD_CPULIMITS: u32 = 3;
pub const RLIMIT_FOOTPRINT_INTERVAL: u32 = 4;
pub const WAKEMON_ENABLE: u32 = 1;
pub const WAKEMON_DISABLE: u32 = 2;
pub const WAKEMON_GET_PARAMS: u32 = 4;
pub const WAKEMON_SET_DEFAULTS: u32 = 8;
pub const WAKEMON_MAKE_FATAL: u32 = 16;
pub const CPUMON_MAKE_FATAL: u32 = 4096;
pub const FOOTPRINT_INTERVAL_RESET: u32 = 1;
pub const IOPOL_TYPE_DISK: u32 = 0;
pub const IOPOL_TYPE_VFS_ATIME_UPDATES: u32 = 2;
pub const IOPOL_TYPE_VFS_MATERIALIZE_DATALESS_FILES: u32 = 3;
pub const IOPOL_TYPE_VFS_STATFS_NO_DATA_VOLUME: u32 = 4;
pub const IOPOL_TYPE_VFS_TRIGGER_RESOLVE: u32 = 5;
pub const IOPOL_TYPE_VFS_IGNORE_CONTENT_PROTECTION: u32 = 6;
pub const IOPOL_TYPE_VFS_IGNORE_PERMISSIONS: u32 = 7;
pub const IOPOL_TYPE_VFS_SKIP_MTIME_UPDATE: u32 = 8;
pub const IOPOL_SCOPE_PROCESS: u32 = 0;
pub const IOPOL_SCOPE_THREAD: u32 = 1;
pub const IOPOL_SCOPE_DARWIN_BG: u32 = 2;
pub const IOPOL_DEFAULT: u32 = 0;
pub const IOPOL_IMPORTANT: u32 = 1;
pub const IOPOL_PASSIVE: u32 = 2;
pub const IOPOL_THROTTLE: u32 = 3;
pub const IOPOL_UTILITY: u32 = 4;
pub const IOPOL_STANDARD: u32 = 5;
pub const IOPOL_APPLICATION: u32 = 5;
pub const IOPOL_NORMAL: u32 = 1;
pub const IOPOL_ATIME_UPDATES_DEFAULT: u32 = 0;
pub const IOPOL_ATIME_UPDATES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_DEFAULT: u32 = 0;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_ON: u32 = 2;
pub const IOPOL_VFS_STATFS_NO_DATA_VOLUME_DEFAULT: u32 = 0;
pub const IOPOL_VFS_STATFS_FORCE_NO_DATA_VOLUME: u32 = 1;
pub const IOPOL_VFS_TRIGGER_RESOLVE_DEFAULT: u32 = 0;
pub const IOPOL_VFS_TRIGGER_RESOLVE_OFF: u32 = 1;
pub const IOPOL_VFS_CONTENT_PROTECTION_DEFAULT: u32 = 0;
pub const IOPOL_VFS_CONTENT_PROTECTION_IGNORE: u32 = 1;
pub const IOPOL_VFS_IGNORE_PERMISSIONS_OFF: u32 = 0;
pub const IOPOL_VFS_IGNORE_PERMISSIONS_ON: u32 = 1;
pub const IOPOL_VFS_SKIP_MTIME_UPDATE_OFF: u32 = 0;
pub const IOPOL_VFS_SKIP_MTIME_UPDATE_ON: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WCOREFLAG: u32 = 128;
pub const _WSTOPPED: u32 = 127;
pub const WEXITED: u32 = 4;
pub const WSTOPPED: u32 = 8;
pub const WCONTINUED: u32 = 16;
pub const WNOWAIT: u32 = 32;
pub const WAIT_ANY: i32 = -1;
pub const WAIT_MYPGRP: u32 = 0;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const RAND_MAX: u32 = 2147483647;
pub const __HAS_FIXED_CHK_PROTOTYPES: u32 = 1;
pub const __GNUC_VA_LIST: u32 = 1;
pub const __DARWIN_FD_SETSIZE: u32 = 1024;
pub const __DARWIN_NBBY: u32 = 8;
pub const NBBY: u32 = 8;
pub const FD_SETSIZE: u32 = 1024;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EDEADLK: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EAGAIN: u32 = 35;
pub const EWOULDBLOCK: u32 = 35;
pub const EINPROGRESS: u32 = 36;
pub const EALREADY: u32 = 37;
pub const ENOTSOCK: u32 = 38;
pub const EDESTADDRREQ: u32 = 39;
pub const EMSGSIZE: u32 = 40;
pub const EPROTOTYPE: u32 = 41;
pub const ENOPROTOOPT: u32 = 42;
pub const EPROTONOSUPPORT: u32 = 43;
pub const ESOCKTNOSUPPORT: u32 = 44;
pub const ENOTSUP: u32 = 45;
pub const EPFNOSUPPORT: u32 = 46;
pub const EAFNOSUPPORT: u32 = 47;
pub const EADDRINUSE: u32 = 48;
pub const EADDRNOTAVAIL: u32 = 49;
pub const ENETDOWN: u32 = 50;
pub const ENETUNREACH: u32 = 51;
pub const ENETRESET: u32 = 52;
pub const ECONNABORTED: u32 = 53;
pub const ECONNRESET: u32 = 54;
pub const ENOBUFS: u32 = 55;
pub const EISCONN: u32 = 56;
pub const ENOTCONN: u32 = 57;
pub const ESHUTDOWN: u32 = 58;
pub const ETOOMANYREFS: u32 = 59;
pub const ETIMEDOUT: u32 = 60;
pub const ECONNREFUSED: u32 = 61;
pub const ELOOP: u32 = 62;
pub const ENAMETOOLONG: u32 = 63;
pub const EHOSTDOWN: u32 = 64;
pub const EHOSTUNREACH: u32 = 65;
pub const ENOTEMPTY: u32 = 66;
pub const EPROCLIM: u32 = 67;
pub const EUSERS: u32 = 68;
pub const EDQUOT: u32 = 69;
pub const ESTALE: u32 = 70;
pub const EREMOTE: u32 = 71;
pub const EBADRPC: u32 = 72;
pub const ERPCMISMATCH: u32 = 73;
pub const EPROGUNAVAIL: u32 = 74;
pub const EPROGMISMATCH: u32 = 75;
pub const EPROCUNAVAIL: u32 = 76;
pub const ENOLCK: u32 = 77;
pub const ENOSYS: u32 = 78;
pub const EFTYPE: u32 = 79;
pub const EAUTH: u32 = 80;
pub const ENEEDAUTH: u32 = 81;
pub const EPWROFF: u32 = 82;
pub const EDEVERR: u32 = 83;
pub const EOVERFLOW: u32 = 84;
pub const EBADEXEC: u32 = 85;
pub const EBADARCH: u32 = 86;
pub const ESHLIBVERS: u32 = 87;
pub const EBADMACHO: u32 = 88;
pub const ECANCELED: u32 = 89;
pub const EIDRM: u32 = 90;
pub const ENOMSG: u32 = 91;
pub const EILSEQ: u32 = 92;
pub const ENOATTR: u32 = 93;
pub const EBADMSG: u32 = 94;
pub const EMULTIHOP: u32 = 95;
pub const ENODATA: u32 = 96;
pub const ENOLINK: u32 = 97;
pub const ENOSR: u32 = 98;
pub const ENOSTR: u32 = 99;
pub const EPROTO: u32 = 100;
pub const ETIME: u32 = 101;
pub const EOPNOTSUPP: u32 = 102;
pub const ENOPOLICY: u32 = 103;
pub const ENOTRECOVERABLE: u32 = 104;
pub const EOWNERDEAD: u32 = 105;
pub const EQFULL: u32 = 106;
pub const ELAST: u32 = 106;
pub const LC_ALL: u32 = 0;
pub const LC_COLLATE: u32 = 1;
pub const LC_CTYPE: u32 = 2;
pub const LC_MONETARY: u32 = 3;
pub const LC_NUMERIC: u32 = 4;
pub const LC_TIME: u32 = 5;
pub const LC_MESSAGES: u32 = 6;
pub const _LC_LAST: u32 = 7;
pub const HAVE_PG_ATTRIBUTE_NORETURN: u32 = 1;
pub const TRUE: u32 = 1;
pub const FALSE: u32 = 0;
pub const INT64_FORMAT: &'static [u8; 4usize] = b"%ld\0";
pub const UINT64_FORMAT: &'static [u8; 4usize] = b"%lu\0";
pub const HAVE_INT128: u32 = 1;
pub const PG_INT8_MIN: i32 = -128;
pub const PG_INT8_MAX: u32 = 127;
pub const PG_UINT8_MAX: u32 = 255;
pub const PG_INT16_MIN: i32 = -32768;
pub const PG_INT16_MAX: u32 = 32767;
pub const PG_UINT16_MAX: u32 = 65535;
pub const PG_INT32_MIN: i32 = -2147483648;
pub const PG_INT32_MAX: u32 = 2147483647;
pub const PG_UINT32_MAX: u32 = 4294967295;
pub const MAXDIM: u32 = 6;
pub const HIGHBIT: u32 = 128;
pub const ESCAPE_STRING_SYNTAX: u8 = 69u8;
pub const STATUS_OK: u32 = 0;
pub const STATUS_ERROR: i32 = -1;
pub const STATUS_EOF: i32 = -2;
pub const STATUS_FOUND: u32 = 1;
pub const STATUS_WAITING: u32 = 2;
pub const PG_BINARY: u32 = 0;
pub const PG_BINARY_A: &'static [u8; 2usize] = b"a\0";
pub const PG_BINARY_R: &'static [u8; 2usize] = b"r\0";
pub const PG_BINARY_W: &'static [u8; 2usize] = b"w\0";
pub const _CACHED_RUNES: u32 = 256;
pub const _CRMASK: i32 = -256;
pub const _RUNE_MAGIC_A: &'static [u8; 9usize] = b"RuneMagA\0";
pub const _CTYPE_A: u32 = 256;
pub const _CTYPE_C: u32 = 512;
pub const _CTYPE_D: u32 = 1024;
pub const _CTYPE_G: u32 = 2048;
pub const _CTYPE_L: u32 = 4096;
pub const _CTYPE_P: u32 = 8192;
pub const _CTYPE_S: u32 = 16384;
pub const _CTYPE_U: u32 = 32768;
pub const _CTYPE_X: u32 = 65536;
pub const _CTYPE_B: u32 = 131072;
pub const _CTYPE_R: u32 = 262144;
pub const _CTYPE_I: u32 = 524288;
pub const _CTYPE_T: u32 = 1048576;
pub const _CTYPE_Q: u32 = 2097152;
pub const _CTYPE_SW0: u32 = 536870912;
pub const _CTYPE_SW1: u32 = 1073741824;
pub const _CTYPE_SW2: u32 = 2147483648;
pub const _CTYPE_SW3: u32 = 3221225472;
pub const _CTYPE_SWM: u32 = 3758096384;
pub const _CTYPE_SWS: u32 = 30;
pub const KEV_INET_SUBCLASS: u32 = 1;
pub const KEV_INET_NEW_ADDR: u32 = 1;
pub const KEV_INET_CHANGED_ADDR: u32 = 2;
pub const KEV_INET_ADDR_DELETED: u32 = 3;
pub const KEV_INET_SIFDSTADDR: u32 = 4;
pub const KEV_INET_SIFBRDADDR: u32 = 5;
pub const KEV_INET_SIFNETMASK: u32 = 6;
pub const KEV_INET_ARPCOLLISION: u32 = 7;
pub const KEV_INET_PORTINUSE: u32 = 8;
pub const KEV_INET_ARPRTRFAILURE: u32 = 9;
pub const KEV_INET_ARPRTRALIVE: u32 = 10;
pub const KEV_DL_SUBCLASS: u32 = 2;
pub const KEV_DL_SIFFLAGS: u32 = 1;
pub const KEV_DL_SIFMETRICS: u32 = 2;
pub const KEV_DL_SIFMTU: u32 = 3;
pub const KEV_DL_SIFPHYS: u32 = 4;
pub const KEV_DL_SIFMEDIA: u32 = 5;
pub const KEV_DL_SIFGENERIC: u32 = 6;
pub const KEV_DL_ADDMULTI: u32 = 7;
pub const KEV_DL_DELMULTI: u32 = 8;
pub const KEV_DL_IF_ATTACHED: u32 = 9;
pub const KEV_DL_IF_DETACHING: u32 = 10;
pub const KEV_DL_IF_DETACHED: u32 = 11;
pub const KEV_DL_LINK_OFF: u32 = 12;
pub const KEV_DL_LINK_ON: u32 = 13;
pub const KEV_DL_PROTO_ATTACHED: u32 = 14;
pub const KEV_DL_PROTO_DETACHED: u32 = 15;
pub const KEV_DL_LINK_ADDRESS_CHANGED: u32 = 16;
pub const KEV_DL_WAKEFLAGS_CHANGED: u32 = 17;
pub const KEV_DL_IF_IDLE_ROUTE_REFCNT: u32 = 18;
pub const KEV_DL_IFCAP_CHANGED: u32 = 19;
pub const KEV_DL_LINK_QUALITY_METRIC_CHANGED: u32 = 20;
pub const KEV_DL_NODE_PRESENCE: u32 = 21;
pub const KEV_DL_NODE_ABSENCE: u32 = 22;
pub const KEV_DL_MASTER_ELECTED: u32 = 23;
pub const KEV_DL_ISSUES: u32 = 24;
pub const KEV_DL_IFDELEGATE_CHANGED: u32 = 25;
pub const KEV_DL_AWDL_RESTRICTED: u32 = 26;
pub const KEV_DL_AWDL_UNRESTRICTED: u32 = 27;
pub const KEV_DL_RRC_STATE_CHANGED: u32 = 28;
pub const KEV_DL_QOS_MODE_CHANGED: u32 = 29;
pub const KEV_DL_LOW_POWER_MODE_CHANGED: u32 = 30;
pub const KEV_INET6_SUBCLASS: u32 = 6;
pub const KEV_INET6_NEW_USER_ADDR: u32 = 1;
pub const KEV_INET6_CHANGED_ADDR: u32 = 2;
pub const KEV_INET6_ADDR_DELETED: u32 = 3;
pub const KEV_INET6_NEW_LL_ADDR: u32 = 4;
pub const KEV_INET6_NEW_RTADV_ADDR: u32 = 5;
pub const KEV_INET6_DEFROUTER: u32 = 6;
pub const KEV_INET6_REQUEST_NAT64_PREFIX: u32 = 7;
pub const SOCK_STREAM: u32 = 1;
pub const SOCK_DGRAM: u32 = 2;
pub const SOCK_RAW: u32 = 3;
pub const SOCK_RDM: u32 = 4;
pub const SOCK_SEQPACKET: u32 = 5;
pub const SO_DEBUG: u32 = 1;
pub const SO_ACCEPTCONN: u32 = 2;
pub const SO_REUSEADDR: u32 = 4;
pub const SO_KEEPALIVE: u32 = 8;
pub const SO_DONTROUTE: u32 = 16;
pub const SO_BROADCAST: u32 = 32;
pub const SO_USELOOPBACK: u32 = 64;
pub const SO_LINGER: u32 = 128;
pub const SO_OOBINLINE: u32 = 256;
pub const SO_REUSEPORT: u32 = 512;
pub const SO_TIMESTAMP: u32 = 1024;
pub const SO_TIMESTAMP_MONOTONIC: u32 = 2048;
pub const SO_DONTTRUNC: u32 = 8192;
pub const SO_WANTMORE: u32 = 16384;
pub const SO_WANTOOBFLAG: u32 = 32768;
pub const SO_SNDBUF: u32 = 4097;
pub const SO_RCVBUF: u32 = 4098;
pub const SO_SNDLOWAT: u32 = 4099;
pub const SO_RCVLOWAT: u32 = 4100;
pub const SO_SNDTIMEO: u32 = 4101;
pub const SO_RCVTIMEO: u32 = 4102;
pub const SO_ERROR: u32 = 4103;
pub const SO_TYPE: u32 = 4104;
pub const SO_LABEL: u32 = 4112;
pub const SO_PEERLABEL: u32 = 4113;
pub const SO_NREAD: u32 = 4128;
pub const SO_NKE: u32 = 4129;
pub const SO_NOSIGPIPE: u32 = 4130;
pub const SO_NOADDRERR: u32 = 4131;
pub const SO_NWRITE: u32 = 4132;
pub const SO_REUSESHAREUID: u32 = 4133;
pub const SO_NOTIFYCONFLICT: u32 = 4134;
pub const SO_UPCALLCLOSEWAIT: u32 = 4135;
pub const SO_LINGER_SEC: u32 = 4224;
pub const SO_RANDOMPORT: u32 = 4226;
pub const SO_NP_EXTENSIONS: u32 = 4227;
pub const SO_NUMRCVPKT: u32 = 4370;
pub const SO_NET_SERVICE_TYPE: u32 = 4374;
pub const SO_NETSVC_MARKING_LEVEL: u32 = 4377;
pub const NET_SERVICE_TYPE_BE: u32 = 0;
pub const NET_SERVICE_TYPE_BK: u32 = 1;
pub const NET_SERVICE_TYPE_SIG: u32 = 2;
pub const NET_SERVICE_TYPE_VI: u32 = 3;
pub const NET_SERVICE_TYPE_VO: u32 = 4;
pub const NET_SERVICE_TYPE_RV: u32 = 5;
pub const NET_SERVICE_TYPE_AV: u32 = 6;
pub const NET_SERVICE_TYPE_OAM: u32 = 7;
pub const NET_SERVICE_TYPE_RD: u32 = 8;
pub const NETSVC_MRKNG_UNKNOWN: u32 = 0;
pub const NETSVC_MRKNG_LVL_L2: u32 = 1;
pub const NETSVC_MRKNG_LVL_L3L2_ALL: u32 = 2;
pub const NETSVC_MRKNG_LVL_L3L2_BK: u32 = 3;
pub const SAE_ASSOCID_ANY: u32 = 0;
pub const SAE_CONNID_ANY: u32 = 0;
pub const CONNECT_RESUME_ON_READ_WRITE: u32 = 1;
pub const CONNECT_DATA_IDEMPOTENT: u32 = 2;
pub const CONNECT_DATA_AUTHENTICATED: u32 = 4;
pub const SONPX_SETOPTSHUT: u32 = 1;
pub const SOL_SOCKET: u32 = 65535;
pub const AF_UNSPEC: u32 = 0;
pub const AF_UNIX: u32 = 1;
pub const AF_LOCAL: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_IMPLINK: u32 = 3;
pub const AF_PUP: u32 = 4;
pub const AF_CHAOS: u32 = 5;
pub const AF_NS: u32 = 6;
pub const AF_ISO: u32 = 7;
pub const AF_OSI: u32 = 7;
pub const AF_ECMA: u32 = 8;
pub const AF_DATAKIT: u32 = 9;
pub const AF_CCITT: u32 = 10;
pub const AF_SNA: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_DLI: u32 = 13;
pub const AF_LAT: u32 = 14;
pub const AF_HYLINK: u32 = 15;
pub const AF_APPLETALK: u32 = 16;
pub const AF_ROUTE: u32 = 17;
pub const AF_LINK: u32 = 18;
pub const pseudo_AF_XTP: u32 = 19;
pub const AF_COIP: u32 = 20;
pub const AF_CNT: u32 = 21;
pub const pseudo_AF_RTIP: u32 = 22;
pub const AF_IPX: u32 = 23;
pub const AF_SIP: u32 = 24;
pub const pseudo_AF_PIP: u32 = 25;
pub const AF_NDRV: u32 = 27;
pub const AF_ISDN: u32 = 28;
pub const AF_E164: u32 = 28;
pub const pseudo_AF_KEY: u32 = 29;
pub const AF_INET6: u32 = 30;
pub const AF_NATM: u32 = 31;
pub const AF_SYSTEM: u32 = 32;
pub const AF_NETBIOS: u32 = 33;
pub const AF_PPP: u32 = 34;
pub const pseudo_AF_HDRCMPLT: u32 = 35;
pub const AF_RESERVED_36: u32 = 36;
pub const AF_IEEE80211: u32 = 37;
pub const AF_UTUN: u32 = 38;
pub const AF_VSOCK: u32 = 40;
pub const AF_MAX: u32 = 41;
pub const SOCK_MAXADDRLEN: u32 = 255;
pub const _SS_MAXSIZE: u32 = 128;
pub const PF_UNSPEC: u32 = 0;
pub const PF_LOCAL: u32 = 1;
pub const PF_UNIX: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_IMPLINK: u32 = 3;
pub const PF_PUP: u32 = 4;
pub const PF_CHAOS: u32 = 5;
pub const PF_NS: u32 = 6;
pub const PF_ISO: u32 = 7;
pub const PF_OSI: u32 = 7;
pub const PF_ECMA: u32 = 8;
pub const PF_DATAKIT: u32 = 9;
pub const PF_CCITT: u32 = 10;
pub const PF_SNA: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_DLI: u32 = 13;
pub const PF_LAT: u32 = 14;
pub const PF_HYLINK: u32 = 15;
pub const PF_APPLETALK: u32 = 16;
pub const PF_ROUTE: u32 = 17;
pub const PF_LINK: u32 = 18;
pub const PF_XTP: u32 = 19;
pub const PF_COIP: u32 = 20;
pub const PF_CNT: u32 = 21;
pub const PF_SIP: u32 = 24;
pub const PF_IPX: u32 = 23;
pub const PF_RTIP: u32 = 22;
pub const PF_PIP: u32 = 25;
pub const PF_NDRV: u32 = 27;
pub const PF_ISDN: u32 = 28;
pub const PF_KEY: u32 = 29;
pub const PF_INET6: u32 = 30;
pub const PF_NATM: u32 = 31;
pub const PF_SYSTEM: u32 = 32;
pub const PF_NETBIOS: u32 = 33;
pub const PF_PPP: u32 = 34;
pub const PF_RESERVED_36: u32 = 36;
pub const PF_UTUN: u32 = 38;
pub const PF_VSOCK: u32 = 40;
pub const PF_MAX: u32 = 41;
pub const NET_MAXID: u32 = 41;
pub const NET_RT_DUMP: u32 = 1;
pub const NET_RT_FLAGS: u32 = 2;
pub const NET_RT_IFLIST: u32 = 3;
pub const NET_RT_STAT: u32 = 4;
pub const NET_RT_TRASH: u32 = 5;
pub const NET_RT_IFLIST2: u32 = 6;
pub const NET_RT_DUMP2: u32 = 7;
pub const NET_RT_FLAGS_PRIV: u32 = 10;
pub const NET_RT_MAXID: u32 = 11;
pub const SOMAXCONN: u32 = 128;
pub const MSG_OOB: u32 = 1;
pub const MSG_PEEK: u32 = 2;
pub const MSG_DONTROUTE: u32 = 4;
pub const MSG_EOR: u32 = 8;
pub const MSG_TRUNC: u32 = 16;
pub const MSG_CTRUNC: u32 = 32;
pub const MSG_WAITALL: u32 = 64;
pub const MSG_DONTWAIT: u32 = 128;
pub const MSG_EOF: u32 = 256;
pub const MSG_WAITSTREAM: u32 = 512;
pub const MSG_FLUSH: u32 = 1024;
pub const MSG_HOLD: u32 = 2048;
pub const MSG_SEND: u32 = 4096;
pub const MSG_HAVEMORE: u32 = 8192;
pub const MSG_RCVMORE: u32 = 16384;
pub const MSG_NEEDSA: u32 = 65536;
pub const MSG_NOSIGNAL: u32 = 524288;
pub const SCM_RIGHTS: u32 = 1;
pub const SCM_TIMESTAMP: u32 = 2;
pub const SCM_CREDS: u32 = 3;
pub const SCM_TIMESTAMP_MONOTONIC: u32 = 4;
pub const SHUT_RD: u32 = 0;
pub const SHUT_WR: u32 = 1;
pub const SHUT_RDWR: u32 = 2;
pub const IPPROTO_IP: u32 = 0;
pub const IPPROTO_HOPOPTS: u32 = 0;
pub const IPPROTO_ICMP: u32 = 1;
pub const IPPROTO_IGMP: u32 = 2;
pub const IPPROTO_GGP: u32 = 3;
pub const IPPROTO_IPV4: u32 = 4;
pub const IPPROTO_IPIP: u32 = 4;
pub const IPPROTO_TCP: u32 = 6;
pub const IPPROTO_ST: u32 = 7;
pub const IPPROTO_EGP: u32 = 8;
pub const IPPROTO_PIGP: u32 = 9;
pub const IPPROTO_RCCMON: u32 = 10;
pub const IPPROTO_NVPII: u32 = 11;
pub const IPPROTO_PUP: u32 = 12;
pub const IPPROTO_ARGUS: u32 = 13;
pub const IPPROTO_EMCON: u32 = 14;
pub const IPPROTO_XNET: u32 = 15;
pub const IPPROTO_CHAOS: u32 = 16;
pub const IPPROTO_UDP: u32 = 17;
pub const IPPROTO_MUX: u32 = 18;
pub const IPPROTO_MEAS: u32 = 19;
pub const IPPROTO_HMP: u32 = 20;
pub const IPPROTO_PRM: u32 = 21;
pub const IPPROTO_IDP: u32 = 22;
pub const IPPROTO_TRUNK1: u32 = 23;
pub const IPPROTO_TRUNK2: u32 = 24;
pub const IPPROTO_LEAF1: u32 = 25;
pub const IPPROTO_LEAF2: u32 = 26;
pub const IPPROTO_RDP: u32 = 27;
pub const IPPROTO_IRTP: u32 = 28;
pub const IPPROTO_TP: u32 = 29;
pub const IPPROTO_BLT: u32 = 30;
pub const IPPROTO_NSP: u32 = 31;
pub const IPPROTO_INP: u32 = 32;
pub const IPPROTO_SEP: u32 = 33;
pub const IPPROTO_3PC: u32 = 34;
pub const IPPROTO_IDPR: u32 = 35;
pub const IPPROTO_XTP: u32 = 36;
pub const IPPROTO_DDP: u32 = 37;
pub const IPPROTO_CMTP: u32 = 38;
pub const IPPROTO_TPXX: u32 = 39;
pub const IPPROTO_IL: u32 = 40;
pub const IPPROTO_IPV6: u32 = 41;
pub const IPPROTO_SDRP: u32 = 42;
pub const IPPROTO_ROUTING: u32 = 43;
pub const IPPROTO_FRAGMENT: u32 = 44;
pub const IPPROTO_IDRP: u32 = 45;
pub const IPPROTO_RSVP: u32 = 46;
pub const IPPROTO_GRE: u32 = 47;
pub const IPPROTO_MHRP: u32 = 48;
pub const IPPROTO_BHA: u32 = 49;
pub const IPPROTO_ESP: u32 = 50;
pub const IPPROTO_AH: u32 = 51;
pub const IPPROTO_INLSP: u32 = 52;
pub const IPPROTO_SWIPE: u32 = 53;
pub const IPPROTO_NHRP: u32 = 54;
pub const IPPROTO_ICMPV6: u32 = 58;
pub const IPPROTO_NONE: u32 = 59;
pub const IPPROTO_DSTOPTS: u32 = 60;
pub const IPPROTO_AHIP: u32 = 61;
pub const IPPROTO_CFTP: u32 = 62;
pub const IPPROTO_HELLO: u32 = 63;
pub const IPPROTO_SATEXPAK: u32 = 64;
pub const IPPROTO_KRYPTOLAN: u32 = 65;
pub const IPPROTO_RVD: u32 = 66;
pub const IPPROTO_IPPC: u32 = 67;
pub const IPPROTO_ADFS: u32 = 68;
pub const IPPROTO_SATMON: u32 = 69;
pub const IPPROTO_VISA: u32 = 70;
pub const IPPROTO_IPCV: u32 = 71;
pub const IPPROTO_CPNX: u32 = 72;
pub const IPPROTO_CPHB: u32 = 73;
pub const IPPROTO_WSN: u32 = 74;
pub const IPPROTO_PVP: u32 = 75;
pub const IPPROTO_BRSATMON: u32 = 76;
pub const IPPROTO_ND: u32 = 77;
pub const IPPROTO_WBMON: u32 = 78;
pub const IPPROTO_WBEXPAK: u32 = 79;
pub const IPPROTO_EON: u32 = 80;
pub const IPPROTO_VMTP: u32 = 81;
pub const IPPROTO_SVMTP: u32 = 82;
pub const IPPROTO_VINES: u32 = 83;
pub const IPPROTO_TTP: u32 = 84;
pub const IPPROTO_IGP: u32 = 85;
pub const IPPROTO_DGP: u32 = 86;
pub const IPPROTO_TCF: u32 = 87;
pub const IPPROTO_IGRP: u32 = 88;
pub const IPPROTO_OSPFIGP: u32 = 89;
pub const IPPROTO_SRPC: u32 = 90;
pub const IPPROTO_LARP: u32 = 91;
pub const IPPROTO_MTP: u32 = 92;
pub const IPPROTO_AX25: u32 = 93;
pub const IPPROTO_IPEIP: u32 = 94;
pub const IPPROTO_MICP: u32 = 95;
pub const IPPROTO_SCCSP: u32 = 96;
pub const IPPROTO_ETHERIP: u32 = 97;
pub const IPPROTO_ENCAP: u32 = 98;
pub const IPPROTO_APES: u32 = 99;
pub const IPPROTO_GMTP: u32 = 100;
pub const IPPROTO_PIM: u32 = 103;
pub const IPPROTO_IPCOMP: u32 = 108;
pub const IPPROTO_PGM: u32 = 113;
pub const IPPROTO_SCTP: u32 = 132;
pub const IPPROTO_DIVERT: u32 = 254;
pub const IPPROTO_RAW: u32 = 255;
pub const IPPROTO_MAX: u32 = 256;
pub const IPPROTO_DONE: u32 = 257;
pub const __DARWIN_IPPORT_RESERVED: u32 = 1024;
pub const IPPORT_USERRESERVED: u32 = 5000;
pub const IPPORT_HIFIRSTAUTO: u32 = 49152;
pub const IPPORT_HILASTAUTO: u32 = 65535;
pub const IPPORT_RESERVEDSTART: u32 = 600;
pub const IN_CLASSA_NET: u32 = 4278190080;
pub const IN_CLASSA_NSHIFT: u32 = 24;
pub const IN_CLASSA_HOST: u32 = 16777215;
pub const IN_CLASSA_MAX: u32 = 128;
pub const IN_CLASSB_NET: u32 = 4294901760;
pub const IN_CLASSB_NSHIFT: u32 = 16;
pub const IN_CLASSB_HOST: u32 = 65535;
pub const IN_CLASSB_MAX: u32 = 65536;
pub const IN_CLASSC_NET: u32 = 4294967040;
pub const IN_CLASSC_NSHIFT: u32 = 8;
pub const IN_CLASSC_HOST: u32 = 255;
pub const IN_CLASSD_NET: u32 = 4026531840;
pub const IN_CLASSD_NSHIFT: u32 = 28;
pub const IN_CLASSD_HOST: u32 = 268435455;
pub const INADDR_NONE: u32 = 4294967295;
pub const IN_LOOPBACKNET: u32 = 127;
pub const INET_ADDRSTRLEN: u32 = 16;
pub const IP_OPTIONS: u32 = 1;
pub const IP_HDRINCL: u32 = 2;
pub const IP_TOS: u32 = 3;
pub const IP_TTL: u32 = 4;
pub const IP_RECVOPTS: u32 = 5;
pub const IP_RECVRETOPTS: u32 = 6;
pub const IP_RECVDSTADDR: u32 = 7;
pub const IP_RETOPTS: u32 = 8;
pub const IP_MULTICAST_IF: u32 = 9;
pub const IP_MULTICAST_TTL: u32 = 10;
pub const IP_MULTICAST_LOOP: u32 = 11;
pub const IP_ADD_MEMBERSHIP: u32 = 12;
pub const IP_DROP_MEMBERSHIP: u32 = 13;
pub const IP_MULTICAST_VIF: u32 = 14;
pub const IP_RSVP_ON: u32 = 15;
pub const IP_RSVP_OFF: u32 = 16;
pub const IP_RSVP_VIF_ON: u32 = 17;
pub const IP_RSVP_VIF_OFF: u32 = 18;
pub const IP_PORTRANGE: u32 = 19;
pub const IP_RECVIF: u32 = 20;
pub const IP_IPSEC_POLICY: u32 = 21;
pub const IP_FAITH: u32 = 22;
pub const IP_STRIPHDR: u32 = 23;
pub const IP_RECVTTL: u32 = 24;
pub const IP_BOUND_IF: u32 = 25;
pub const IP_PKTINFO: u32 = 26;
pub const IP_RECVPKTINFO: u32 = 26;
pub const IP_RECVTOS: u32 = 27;
pub const IP_DONTFRAG: u32 = 28;
pub const IP_FW_ADD: u32 = 40;
pub const IP_FW_DEL: u32 = 41;
pub const IP_FW_FLUSH: u32 = 42;
pub const IP_FW_ZERO: u32 = 43;
pub const IP_FW_GET: u32 = 44;
pub const IP_FW_RESETLOG: u32 = 45;
pub const IP_OLD_FW_ADD: u32 = 50;
pub const IP_OLD_FW_DEL: u32 = 51;
pub const IP_OLD_FW_FLUSH: u32 = 52;
pub const IP_OLD_FW_ZERO: u32 = 53;
pub const IP_OLD_FW_GET: u32 = 54;
pub const IP_NAT__XXX: u32 = 55;
pub const IP_OLD_FW_RESETLOG: u32 = 56;
pub const IP_DUMMYNET_CONFIGURE: u32 = 60;
pub const IP_DUMMYNET_DEL: u32 = 61;
pub const IP_DUMMYNET_FLUSH: u32 = 62;
pub const IP_DUMMYNET_GET: u32 = 64;
pub const IP_TRAFFIC_MGT_BACKGROUND: u32 = 65;
pub const IP_MULTICAST_IFINDEX: u32 = 66;
pub const IP_ADD_SOURCE_MEMBERSHIP: u32 = 70;
pub const IP_DROP_SOURCE_MEMBERSHIP: u32 = 71;
pub const IP_BLOCK_SOURCE: u32 = 72;
pub const IP_UNBLOCK_SOURCE: u32 = 73;
pub const IP_MSFILTER: u32 = 74;
pub const MCAST_JOIN_GROUP: u32 = 80;
pub const MCAST_LEAVE_GROUP: u32 = 81;
pub const MCAST_JOIN_SOURCE_GROUP: u32 = 82;
pub const MCAST_LEAVE_SOURCE_GROUP: u32 = 83;
pub const MCAST_BLOCK_SOURCE: u32 = 84;
pub const MCAST_UNBLOCK_SOURCE: u32 = 85;
pub const IP_DEFAULT_MULTICAST_TTL: u32 = 1;
pub const IP_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IP_MIN_MEMBERSHIPS: u32 = 31;
pub const IP_MAX_MEMBERSHIPS: u32 = 4095;
pub const IP_MAX_GROUP_SRC_FILTER: u32 = 512;
pub const IP_MAX_SOCK_SRC_FILTER: u32 = 128;
pub const IP_MAX_SOCK_MUTE_FILTER: u32 = 128;
pub const MCAST_UNDEFINED: u32 = 0;
pub const MCAST_INCLUDE: u32 = 1;
pub const MCAST_EXCLUDE: u32 = 2;
pub const IP_PORTRANGE_DEFAULT: u32 = 0;
pub const IP_PORTRANGE_HIGH: u32 = 1;
pub const IP_PORTRANGE_LOW: u32 = 2;
pub const IPPROTO_MAXID: u32 = 52;
pub const IPCTL_FORWARDING: u32 = 1;
pub const IPCTL_SENDREDIRECTS: u32 = 2;
pub const IPCTL_DEFTTL: u32 = 3;
pub const IPCTL_RTEXPIRE: u32 = 5;
pub const IPCTL_RTMINEXPIRE: u32 = 6;
pub const IPCTL_RTMAXCACHE: u32 = 7;
pub const IPCTL_SOURCEROUTE: u32 = 8;
pub const IPCTL_DIRECTEDBROADCAST: u32 = 9;
pub const IPCTL_INTRQMAXLEN: u32 = 10;
pub const IPCTL_INTRQDROPS: u32 = 11;
pub const IPCTL_STATS: u32 = 12;
pub const IPCTL_ACCEPTSOURCEROUTE: u32 = 13;
pub const IPCTL_FASTFORWARDING: u32 = 14;
pub const IPCTL_KEEPFAITH: u32 = 15;
pub const IPCTL_GIF_TTL: u32 = 16;
pub const IPCTL_MAXID: u32 = 17;
pub const __KAME_VERSION: &'static [u8; 18usize] = b"2009/apple-darwin\0";
pub const IPV6PORT_RESERVED: u32 = 1024;
pub const IPV6PORT_ANONMIN: u32 = 49152;
pub const IPV6PORT_ANONMAX: u32 = 65535;
pub const IPV6PORT_RESERVEDMIN: u32 = 600;
pub const IPV6PORT_RESERVEDMAX: u32 = 1023;
pub const INET6_ADDRSTRLEN: u32 = 46;
pub const __IPV6_ADDR_SCOPE_NODELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_INTFACELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_LINKLOCAL: u32 = 2;
pub const __IPV6_ADDR_SCOPE_SITELOCAL: u32 = 5;
pub const __IPV6_ADDR_SCOPE_ORGLOCAL: u32 = 8;
pub const __IPV6_ADDR_SCOPE_GLOBAL: u32 = 14;
pub const IPV6_ADDR_MC_FLAGS_TRANSIENT: u32 = 16;
pub const IPV6_ADDR_MC_FLAGS_PREFIX: u32 = 32;
pub const IPV6_ADDR_MC_FLAGS_UNICAST_BASED: u32 = 48;
pub const IPV6_SOCKOPT_RESERVED1: u32 = 3;
pub const IPV6_UNICAST_HOPS: u32 = 4;
pub const IPV6_MULTICAST_IF: u32 = 9;
pub const IPV6_MULTICAST_HOPS: u32 = 10;
pub const IPV6_MULTICAST_LOOP: u32 = 11;
pub const IPV6_JOIN_GROUP: u32 = 12;
pub const IPV6_LEAVE_GROUP: u32 = 13;
pub const IPV6_PORTRANGE: u32 = 14;
pub const ICMP6_FILTER: u32 = 18;
pub const IPV6_2292PKTINFO: u32 = 19;
pub const IPV6_2292HOPLIMIT: u32 = 20;
pub const IPV6_2292NEXTHOP: u32 = 21;
pub const IPV6_2292HOPOPTS: u32 = 22;
pub const IPV6_2292DSTOPTS: u32 = 23;
pub const IPV6_2292RTHDR: u32 = 24;
pub const IPV6_2292PKTOPTIONS: u32 = 25;
pub const IPV6_CHECKSUM: u32 = 26;
pub const IPV6_V6ONLY: u32 = 27;
pub const IPV6_BINDV6ONLY: u32 = 27;
pub const IPV6_IPSEC_POLICY: u32 = 28;
pub const IPV6_FAITH: u32 = 29;
pub const IPV6_FW_ADD: u32 = 30;
pub const IPV6_FW_DEL: u32 = 31;
pub const IPV6_FW_FLUSH: u32 = 32;
pub const IPV6_FW_ZERO: u32 = 33;
pub const IPV6_FW_GET: u32 = 34;
pub const IPV6_RECVTCLASS: u32 = 35;
pub const IPV6_TCLASS: u32 = 36;
pub const IPV6_BOUND_IF: u32 = 125;
pub const IPV6_RTHDR_LOOSE: u32 = 0;
pub const IPV6_RTHDR_STRICT: u32 = 1;
pub const IPV6_RTHDR_TYPE_0: u32 = 0;
pub const IPV6_DEFAULT_MULTICAST_HOPS: u32 = 1;
pub const IPV6_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IPV6_MIN_MEMBERSHIPS: u32 = 31;
pub const IPV6_MAX_MEMBERSHIPS: u32 = 4095;
pub const IPV6_MAX_GROUP_SRC_FILTER: u32 = 512;
pub const IPV6_MAX_SOCK_SRC_FILTER: u32 = 128;
pub const IPV6_PORTRANGE_DEFAULT: u32 = 0;
pub const IPV6_PORTRANGE_HIGH: u32 = 1;
pub const IPV6_PORTRANGE_LOW: u32 = 2;
pub const IPV6PROTO_MAXID: u32 = 104;
pub const IPV6CTL_FORWARDING: u32 = 1;
pub const IPV6CTL_SENDREDIRECTS: u32 = 2;
pub const IPV6CTL_DEFHLIM: u32 = 3;
pub const IPV6CTL_FORWSRCRT: u32 = 5;
pub const IPV6CTL_STATS: u32 = 6;
pub const IPV6CTL_MRTSTATS: u32 = 7;
pub const IPV6CTL_MRTPROTO: u32 = 8;
pub const IPV6CTL_MAXFRAGPACKETS: u32 = 9;
pub const IPV6CTL_SOURCECHECK: u32 = 10;
pub const IPV6CTL_SOURCECHECK_LOGINT: u32 = 11;
pub const IPV6CTL_ACCEPT_RTADV: u32 = 12;
pub const IPV6CTL_KEEPFAITH: u32 = 13;
pub const IPV6CTL_LOG_INTERVAL: u32 = 14;
pub const IPV6CTL_HDRNESTLIMIT: u32 = 15;
pub const IPV6CTL_DAD_COUNT: u32 = 16;
pub const IPV6CTL_AUTO_FLOWLABEL: u32 = 17;
pub const IPV6CTL_DEFMCASTHLIM: u32 = 18;
pub const IPV6CTL_GIF_HLIM: u32 = 19;
pub const IPV6CTL_KAME_VERSION: u32 = 20;
pub const IPV6CTL_USE_DEPRECATED: u32 = 21;
pub const IPV6CTL_RR_PRUNE: u32 = 22;
pub const IPV6CTL_V6ONLY: u32 = 24;
pub const IPV6CTL_RTEXPIRE: u32 = 25;
pub const IPV6CTL_RTMINEXPIRE: u32 = 26;
pub const IPV6CTL_RTMAXCACHE: u32 = 27;
pub const IPV6CTL_USETEMPADDR: u32 = 32;
pub const IPV6CTL_TEMPPLTIME: u32 = 33;
pub const IPV6CTL_TEMPVLTIME: u32 = 34;
pub const IPV6CTL_AUTO_LINKLOCAL: u32 = 35;
pub const IPV6CTL_RIP6STATS: u32 = 36;
pub const IPV6CTL_PREFER_TEMPADDR: u32 = 37;
pub const IPV6CTL_ADDRCTLPOLICY: u32 = 38;
pub const IPV6CTL_USE_DEFAULTZONE: u32 = 39;
pub const IPV6CTL_MAXFRAGS: u32 = 41;
pub const IPV6CTL_MCAST_PMTU: u32 = 44;
pub const IPV6CTL_NEIGHBORGCTHRESH: u32 = 46;
pub const IPV6CTL_MAXIFPREFIXES: u32 = 47;
pub const IPV6CTL_MAXIFDEFROUTERS: u32 = 48;
pub const IPV6CTL_MAXDYNROUTES: u32 = 49;
pub const ICMPV6CTL_ND6_ONLINKNSRFC4861: u32 = 50;
pub const IPV6CTL_MAXID: u32 = 51;
pub const _PATH_HEQUIV: &'static [u8; 17usize] = b"/etc/hosts.equiv\0";
pub const _PATH_HOSTS: &'static [u8; 11usize] = b"/etc/hosts\0";
pub const _PATH_NETWORKS: &'static [u8; 14usize] = b"/etc/networks\0";
pub const _PATH_PROTOCOLS: &'static [u8; 15usize] = b"/etc/protocols\0";
pub const _PATH_SERVICES: &'static [u8; 14usize] = b"/etc/services\0";
pub const NETDB_INTERNAL: i32 = -1;
pub const NETDB_SUCCESS: u32 = 0;
pub const HOST_NOT_FOUND: u32 = 1;
pub const TRY_AGAIN: u32 = 2;
pub const NO_RECOVERY: u32 = 3;
pub const NO_DATA: u32 = 4;
pub const NO_ADDRESS: u32 = 4;
pub const EAI_ADDRFAMILY: u32 = 1;
pub const EAI_AGAIN: u32 = 2;
pub const EAI_BADFLAGS: u32 = 3;
pub const EAI_FAIL: u32 = 4;
pub const EAI_FAMILY: u32 = 5;
pub const EAI_MEMORY: u32 = 6;
pub const EAI_NODATA: u32 = 7;
pub const EAI_NONAME: u32 = 8;
pub const EAI_SERVICE: u32 = 9;
pub const EAI_SOCKTYPE: u32 = 10;
pub const EAI_SYSTEM: u32 = 11;
pub const EAI_BADHINTS: u32 = 12;
pub const EAI_PROTOCOL: u32 = 13;
pub const EAI_OVERFLOW: u32 = 14;
pub const EAI_MAX: u32 = 15;
pub const AI_PASSIVE: u32 = 1;
pub const AI_CANONNAME: u32 = 2;
pub const AI_NUMERICHOST: u32 = 4;
pub const AI_NUMERICSERV: u32 = 4096;
pub const AI_ALL: u32 = 256;
pub const AI_V4MAPPED_CFG: u32 = 512;
pub const AI_ADDRCONFIG: u32 = 1024;
pub const AI_V4MAPPED: u32 = 2048;
pub const AI_DEFAULT: u32 = 1536;
pub const AI_UNUSABLE: u32 = 268435456;
pub const NI_MAXHOST: u32 = 1025;
pub const NI_MAXSERV: u32 = 32;
pub const NI_NOFQDN: u32 = 1;
pub const NI_NUMERICHOST: u32 = 2;
pub const NI_NAMEREQD: u32 = 4;
pub const NI_NUMERICSERV: u32 = 8;
pub const NI_NUMERICSCOPE: u32 = 256;
pub const NI_DGRAM: u32 = 16;
pub const NI_WITHSCOPEID: u32 = 32;
pub const SCOPE_DELIMITER: u8 = 37u8;
pub const _PATH_PWD: &'static [u8; 5usize] = b"/etc\0";
pub const _PATH_PASSWD: &'static [u8; 12usize] = b"/etc/passwd\0";
pub const _PASSWD: &'static [u8; 7usize] = b"passwd\0";
pub const _PATH_MASTERPASSWD: &'static [u8; 19usize] = b"/etc/master.passwd\0";
pub const _PATH_MASTERPASSWD_LOCK: &'static [u8; 10usize] = b"/etc/ptmp\0";
pub const _MASTERPASSWD: &'static [u8; 14usize] = b"master.passwd\0";
pub const _PATH_MP_DB: &'static [u8; 12usize] = b"/etc/pwd.db\0";
pub const _MP_DB: &'static [u8; 7usize] = b"pwd.db\0";
pub const _PATH_SMP_DB: &'static [u8; 13usize] = b"/etc/spwd.db\0";
pub const _SMP_DB: &'static [u8; 8usize] = b"spwd.db\0";
pub const _PATH_PWD_MKDB: &'static [u8; 19usize] = b"/usr/sbin/pwd_mkdb\0";
pub const _PW_KEYBYNAME: u8 = 49u8;
pub const _PW_KEYBYNUM: u8 = 50u8;
pub const _PW_KEYBYUID: u8 = 51u8;
pub const _PASSWORD_EFMT1: u8 = 95u8;
pub const _PASSWORD_LEN: u32 = 128;
pub const _PASSWORD_NOUID: u32 = 1;
pub const _PASSWORD_NOGID: u32 = 2;
pub const _PASSWORD_NOCHG: u32 = 4;
pub const _PASSWORD_NOEXP: u32 = 8;
pub const _PASSWORD_WARNDAYS: u32 = 14;
pub const _PASSWORD_CHGNOW: i32 = -1;
pub const PGINVALID_SOCKET: i32 = -1;
pub const PG_BACKEND_VERSIONSTR: &'static [u8; 29usize] = b"postgres (PostgreSQL) 10.18\n\0";
pub const EXE: &'static [u8; 1usize] = b"\0";
pub const DEVNULL: &'static [u8; 10usize] = b"/dev/null\0";
pub const PG_IOLBF: u32 = 1;
pub const _JBLEN: u32 = 37;
pub const DEBUG5: u32 = 10;
pub const DEBUG4: u32 = 11;
pub const DEBUG3: u32 = 12;
pub const DEBUG2: u32 = 13;
pub const DEBUG1: u32 = 14;
pub const LOG: u32 = 15;
pub const LOG_SERVER_ONLY: u32 = 16;
pub const COMMERROR: u32 = 16;
pub const INFO: u32 = 17;
pub const NOTICE: u32 = 18;
pub const WARNING: u32 = 19;
pub const ERROR: u32 = 20;
pub const FATAL: u32 = 21;
pub const PANIC: u32 = 22;
pub const LOG_DESTINATION_STDERR: u32 = 1;
pub const LOG_DESTINATION_SYSLOG: u32 = 2;
pub const LOG_DESTINATION_EVENTLOG: u32 = 4;
pub const LOG_DESTINATION_CSVLOG: u32 = 8;
pub const MCXT_ALLOC_HUGE: u32 = 1;
pub const MCXT_ALLOC_NO_OOM: u32 = 2;
pub const MCXT_ALLOC_ZERO: u32 = 4;
pub const VARATT_SHORT_MAX: u32 = 127;
pub const SIZEOF_DATUM: u32 = 8;
pub const PG_MAGIC_FUNCTION_NAME_STRING: &'static [u8; 14usize] = b"Pg_magic_func\0";
pub const AGG_CONTEXT_AGGREGATE: u32 = 1;
pub const AGG_CONTEXT_WINDOW: u32 = 2;
pub const InvalidAttrNumber: u32 = 0;
pub const MaxAttrNumber: u32 = 32767;
pub const AttributeRelationId: u32 = 1249;
pub const AttributeRelation_Rowtype_Id: u32 = 75;
pub const Natts_pg_attribute: u32 = 22;
pub const Anum_pg_attribute_attrelid: u32 = 1;
pub const Anum_pg_attribute_attname: u32 = 2;
pub const Anum_pg_attribute_atttypid: u32 = 3;
pub const Anum_pg_attribute_attstattarget: u32 = 4;
pub const Anum_pg_attribute_attlen: u32 = 5;
pub const Anum_pg_attribute_attnum: u32 = 6;
pub const Anum_pg_attribute_attndims: u32 = 7;
pub const Anum_pg_attribute_attcacheoff: u32 = 8;
pub const Anum_pg_attribute_atttypmod: u32 = 9;
pub const Anum_pg_attribute_attbyval: u32 = 10;
pub const Anum_pg_attribute_attstorage: u32 = 11;
pub const Anum_pg_attribute_attalign: u32 = 12;
pub const Anum_pg_attribute_attnotnull: u32 = 13;
pub const Anum_pg_attribute_atthasdef: u32 = 14;
pub const Anum_pg_attribute_attidentity: u32 = 15;
pub const Anum_pg_attribute_attisdropped: u32 = 16;
pub const Anum_pg_attribute_attislocal: u32 = 17;
pub const Anum_pg_attribute_attinhcount: u32 = 18;
pub const Anum_pg_attribute_attcollation: u32 = 19;
pub const Anum_pg_attribute_attacl: u32 = 20;
pub const Anum_pg_attribute_attoptions: u32 = 21;
pub const Anum_pg_attribute_attfdwoptions: u32 = 22;
pub const ATTRIBUTE_IDENTITY_ALWAYS: u8 = 97u8;
pub const ATTRIBUTE_IDENTITY_BY_DEFAULT: u8 = 100u8;
pub const AGGSPLITOP_COMBINE: u32 = 1;
pub const AGGSPLITOP_SKIPFINAL: u32 = 2;
pub const AGGSPLITOP_SERIALIZE: u32 = 4;
pub const AGGSPLITOP_DESERIALIZE: u32 = 8;
pub const LP_UNUSED: u32 = 0;
pub const LP_NORMAL: u32 = 1;
pub const LP_REDIRECT: u32 = 2;
pub const LP_DEAD: u32 = 3;
pub const OffsetNumberMask: u32 = 65535;
pub const InvalidBuffer: u32 = 0;
pub const BTLessStrategyNumber: u32 = 1;
pub const BTLessEqualStrategyNumber: u32 = 2;
pub const BTEqualStrategyNumber: u32 = 3;
pub const BTGreaterEqualStrategyNumber: u32 = 4;
pub const BTGreaterStrategyNumber: u32 = 5;
pub const BTMaxStrategyNumber: u32 = 5;
pub const RTLeftStrategyNumber: u32 = 1;
pub const RTOverLeftStrategyNumber: u32 = 2;
pub const RTOverlapStrategyNumber: u32 = 3;
pub const RTOverRightStrategyNumber: u32 = 4;
pub const RTRightStrategyNumber: u32 = 5;
pub const RTSameStrategyNumber: u32 = 6;
pub const RTContainsStrategyNumber: u32 = 7;
pub const RTContainedByStrategyNumber: u32 = 8;
pub const RTOverBelowStrategyNumber: u32 = 9;
pub const RTBelowStrategyNumber: u32 = 10;
pub const RTAboveStrategyNumber: u32 = 11;
pub const RTOverAboveStrategyNumber: u32 = 12;
pub const RTOldContainsStrategyNumber: u32 = 13;
pub const RTOldContainedByStrategyNumber: u32 = 14;
pub const RTKNNSearchStrategyNumber: u32 = 15;
pub const RTContainsElemStrategyNumber: u32 = 16;
pub const RTAdjacentStrategyNumber: u32 = 17;
pub const RTEqualStrategyNumber: u32 = 18;
pub const RTNotEqualStrategyNumber: u32 = 19;
pub const RTLessStrategyNumber: u32 = 20;
pub const RTLessEqualStrategyNumber: u32 = 21;
pub const RTGreaterStrategyNumber: u32 = 22;
pub const RTGreaterEqualStrategyNumber: u32 = 23;
pub const RTSubStrategyNumber: u32 = 24;
pub const RTSubEqualStrategyNumber: u32 = 25;
pub const RTSuperStrategyNumber: u32 = 26;
pub const RTSuperEqualStrategyNumber: u32 = 27;
pub const RTMaxStrategyNumber: u32 = 27;
pub const SK_ISNULL: u32 = 1;
pub const SK_UNARY: u32 = 2;
pub const SK_ROW_HEADER: u32 = 4;
pub const SK_ROW_MEMBER: u32 = 8;
pub const SK_ROW_END: u32 = 16;
pub const SK_SEARCHARRAY: u32 = 32;
pub const SK_SEARCHNULL: u32 = 64;
pub const SK_SEARCHNOTNULL: u32 = 128;
pub const SK_ORDER_BY: u32 = 256;
pub const __DARWIN_CLK_TCK: u32 = 100;
pub const CHAR_BIT: u32 = 8;
pub const MB_LEN_MAX: u32 = 6;
pub const CLK_TCK: u32 = 100;
pub const SCHAR_MAX: u32 = 127;
pub const SCHAR_MIN: i32 = -128;
pub const UCHAR_MAX: u32 = 255;
pub const CHAR_MAX: u32 = 127;
pub const CHAR_MIN: i32 = -128;
pub const USHRT_MAX: u32 = 65535;
pub const SHRT_MAX: u32 = 32767;
pub const SHRT_MIN: i32 = -32768;
pub const UINT_MAX: u32 = 4294967295;
pub const INT_MAX: u32 = 2147483647;
pub const INT_MIN: i32 = -2147483648;
pub const ULONG_MAX: i32 = -1;
pub const LONG_MAX: u64 = 9223372036854775807;
pub const LONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const LONG_BIT: u32 = 64;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const WORD_BIT: u32 = 32;
pub const SIZE_T_MAX: i32 = -1;
pub const UQUAD_MAX: i32 = -1;
pub const QUAD_MAX: u64 = 9223372036854775807;
pub const QUAD_MIN: i64 = -9223372036854775808;
pub const ARG_MAX: u32 = 1048576;
pub const CHILD_MAX: u32 = 266;
pub const GID_MAX: u32 = 2147483647;
pub const LINK_MAX: u32 = 32767;
pub const MAX_CANON: u32 = 1024;
pub const MAX_INPUT: u32 = 1024;
pub const NAME_MAX: u32 = 255;
pub const NGROUPS_MAX: u32 = 16;
pub const UID_MAX: u32 = 2147483647;
pub const OPEN_MAX: u32 = 10240;
pub const PATH_MAX: u32 = 1024;
pub const PIPE_BUF: u32 = 512;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const CHARCLASS_NAME_MAX: u32 = 14;
pub const COLL_WEIGHTS_MAX: u32 = 2;
pub const EQUIV_CLASS_MAX: u32 = 2;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 255;
pub const NZERO: u32 = 20;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_EQUIV_CLASS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_KEYS_MAX: u32 = 512;
pub const PTHREAD_STACK_MIN: u32 = 8192;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_SS_REPL_MAX: u32 = 4;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TRACE_EVENT_NAME_MAX: u32 = 30;
pub const _POSIX_TRACE_NAME_MAX: u32 = 8;
pub const _POSIX_TRACE_SYS_MAX: u32 = 8;
pub const _POSIX_TRACE_USER_EVENT_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const OFF_MIN: i64 = -9223372036854775808;
pub const OFF_MAX: u64 = 9223372036854775807;
pub const PASS_MAX: u32 = 128;
pub const NL_ARGMAX: u32 = 9;
pub const NL_LANGMAX: u32 = 14;
pub const NL_MSGMAX: u32 = 32767;
pub const NL_NMAX: u32 = 1;
pub const NL_SETMAX: u32 = 255;
pub const NL_TEXTMAX: u32 = 2048;
pub const _XOPEN_IOV_MAX: u32 = 16;
pub const IOV_MAX: u32 = 1024;
pub const _XOPEN_NAME_MAX: u32 = 255;
pub const _XOPEN_PATH_MAX: u32 = 1024;
pub const DSM_IMPL_NONE: u32 = 0;
pub const DSM_IMPL_POSIX: u32 = 1;
pub const DSM_IMPL_SYSV: u32 = 2;
pub const DSM_IMPL_WINDOWS: u32 = 3;
pub const DSM_IMPL_MMAP: u32 = 4;
pub const DEFAULT_DYNAMIC_SHARED_MEMORY_TYPE: u32 = 1;
pub const PG_DYNSHMEM_DIR: &'static [u8; 12usize] = b"pg_dynshmem\0";
pub const PG_DYNSHMEM_MMAP_FILE_PREFIX: &'static [u8; 6usize] = b"mmap.\0";
pub const DSM_CREATE_NULL_IF_MAXSEGMENTS: u32 = 1;
pub const DSM_HANDLE_INVALID: u32 = 0;
pub const SIZEOF_DSA_POINTER: u32 = 8;
pub const DSA_POINTER_FORMAT: &'static [u8; 7usize] = b"%016lx\0";
pub const DSA_ALLOC_HUGE: u32 = 1;
pub const DSA_ALLOC_NO_OOM: u32 = 2;
pub const DSA_ALLOC_ZERO: u32 = 4;
pub const NoLock: u32 = 0;
pub const AccessShareLock: u32 = 1;
pub const RowShareLock: u32 = 2;
pub const RowExclusiveLock: u32 = 3;
pub const ShareUpdateExclusiveLock: u32 = 4;
pub const ShareLock: u32 = 5;
pub const ShareRowExclusiveLock: u32 = 6;
pub const ExclusiveLock: u32 = 7;
pub const AccessExclusiveLock: u32 = 8;
pub const BITS_PER_BITMAPWORD: u32 = 32;
pub const O_RDONLY: u32 = 0;
pub const O_WRONLY: u32 = 1;
pub const O_RDWR: u32 = 2;
pub const O_ACCMODE: u32 = 3;
pub const FREAD: u32 = 1;
pub const FWRITE: u32 = 2;
pub const O_NONBLOCK: u32 = 4;
pub const O_APPEND: u32 = 8;
pub const O_SYNC: u32 = 128;
pub const O_SHLOCK: u32 = 16;
pub const O_EXLOCK: u32 = 32;
pub const O_ASYNC: u32 = 64;
pub const O_FSYNC: u32 = 128;
pub const O_NOFOLLOW: u32 = 256;
pub const O_CREAT: u32 = 512;
pub const O_TRUNC: u32 = 1024;
pub const O_EXCL: u32 = 2048;
pub const O_EVTONLY: u32 = 32768;
pub const O_NOCTTY: u32 = 131072;
pub const O_DIRECTORY: u32 = 1048576;
pub const O_SYMLINK: u32 = 2097152;
pub const O_DSYNC: u32 = 4194304;
pub const O_CLOEXEC: u32 = 16777216;
pub const O_NOFOLLOW_ANY: u32 = 536870912;
pub const AT_FDCWD: i32 = -2;
pub const AT_EACCESS: u32 = 16;
pub const AT_SYMLINK_NOFOLLOW: u32 = 32;
pub const AT_SYMLINK_FOLLOW: u32 = 64;
pub const AT_REMOVEDIR: u32 = 128;
pub const AT_REALDEV: u32 = 512;
pub const AT_FDONLY: u32 = 1024;
pub const O_DP_GETRAWENCRYPTED: u32 = 1;
pub const O_DP_GETRAWUNENCRYPTED: u32 = 2;
pub const FAPPEND: u32 = 8;
pub const FASYNC: u32 = 64;
pub const FFSYNC: u32 = 128;
pub const FFDSYNC: u32 = 4194304;
pub const FNONBLOCK: u32 = 4;
pub const FNDELAY: u32 = 4;
pub const O_NDELAY: u32 = 4;
pub const CPF_OVERWRITE: u32 = 1;
pub const CPF_IGNORE_MODE: u32 = 2;
pub const CPF_MASK: u32 = 3;
pub const F_DUPFD: u32 = 0;
pub const F_GETFD: u32 = 1;
pub const F_SETFD: u32 = 2;
pub const F_GETFL: u32 = 3;
pub const F_SETFL: u32 = 4;
pub const F_GETOWN: u32 = 5;
pub const F_SETOWN: u32 = 6;
pub const F_GETLK: u32 = 7;
pub const F_SETLK: u32 = 8;
pub const F_SETLKW: u32 = 9;
pub const F_SETLKWTIMEOUT: u32 = 10;
pub const F_FLUSH_DATA: u32 = 40;
pub const F_CHKCLEAN: u32 = 41;
pub const F_PREALLOCATE: u32 = 42;
pub const F_SETSIZE: u32 = 43;
pub const F_RDADVISE: u32 = 44;
pub const F_RDAHEAD: u32 = 45;
pub const F_NOCACHE: u32 = 48;
pub const F_LOG2PHYS: u32 = 49;
pub const F_GETPATH: u32 = 50;
pub const F_FULLFSYNC: u32 = 51;
pub const F_PATHPKG_CHECK: u32 = 52;
pub const F_FREEZE_FS: u32 = 53;
pub const F_THAW_FS: u32 = 54;
pub const F_GLOBAL_NOCACHE: u32 = 55;
pub const F_ADDSIGS: u32 = 59;
pub const F_ADDFILESIGS: u32 = 61;
pub const F_NODIRECT: u32 = 62;
pub const F_GETPROTECTIONCLASS: u32 = 63;
pub const F_SETPROTECTIONCLASS: u32 = 64;
pub const F_LOG2PHYS_EXT: u32 = 65;
pub const F_GETLKPID: u32 = 66;
pub const F_SETBACKINGSTORE: u32 = 70;
pub const F_GETPATH_MTMINFO: u32 = 71;
pub const F_GETCODEDIR: u32 = 72;
pub const F_SETNOSIGPIPE: u32 = 73;
pub const F_GETNOSIGPIPE: u32 = 74;
pub const F_TRANSCODEKEY: u32 = 75;
pub const F_SINGLE_WRITER: u32 = 76;
pub const F_GETPROTECTIONLEVEL: u32 = 77;
pub const F_FINDSIGS: u32 = 78;
pub const F_ADDFILESIGS_FOR_DYLD_SIM: u32 = 83;
pub const F_BARRIERFSYNC: u32 = 85;
pub const F_ADDFILESIGS_RETURN: u32 = 97;
pub const F_CHECK_LV: u32 = 98;
pub const F_PUNCHHOLE: u32 = 99;
pub const F_TRIM_ACTIVE_FILE: u32 = 100;
pub const F_SPECULATIVE_READ: u32 = 101;
pub const F_GETPATH_NOFIRMLINK: u32 = 102;
pub const F_ADDFILESIGS_INFO: u32 = 103;
pub const F_ADDFILESUPPL: u32 = 104;
pub const F_GETSIGSINFO: u32 = 105;
pub const FCNTL_FS_SPECIFIC_BASE: u32 = 65536;
pub const F_DUPFD_CLOEXEC: u32 = 67;
pub const FD_CLOEXEC: u32 = 1;
pub const F_RDLCK: u32 = 1;
pub const F_UNLCK: u32 = 2;
pub const F_WRLCK: u32 = 3;
pub const SEEK_HOLE: u32 = 3;
pub const SEEK_DATA: u32 = 4;
pub const S_IFMT: u32 = 61440;
pub const S_IFIFO: u32 = 4096;
pub const S_IFCHR: u32 = 8192;
pub const S_IFDIR: u32 = 16384;
pub const S_IFBLK: u32 = 24576;
pub const S_IFREG: u32 = 32768;
pub const S_IFLNK: u32 = 40960;
pub const S_IFSOCK: u32 = 49152;
pub const S_IFWHT: u32 = 57344;
pub const S_IRWXU: u32 = 448;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXG: u32 = 56;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXO: u32 = 7;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_ISTXT: u32 = 512;
pub const S_IREAD: u32 = 256;
pub const S_IWRITE: u32 = 128;
pub const S_IEXEC: u32 = 64;
pub const F_ALLOCATECONTIG: u32 = 2;
pub const F_ALLOCATEALL: u32 = 4;
pub const F_PEOFPOSMODE: u32 = 3;
pub const F_VOLPOSMODE: u32 = 4;
pub const USER_FSIGNATURES_CDHASH_LEN: u32 = 20;
pub const GETSIGSINFO_PLATFORM_BINARY: u32 = 1;
pub const LOCK_SH: u32 = 1;
pub const LOCK_EX: u32 = 2;
pub const LOCK_NB: u32 = 4;
pub const LOCK_UN: u32 = 8;
pub const O_POPUP: u32 = 2147483648;
pub const O_ALERT: u32 = 536870912;
pub const InvalidXLogRecPtr: u32 = 0;
pub const PG_O_DIRECT: u32 = 0;
pub const OPEN_SYNC_FLAG: u32 = 128;
pub const OPEN_DATASYNC_FLAG: u32 = 4194304;
pub const MAX_TIMESTAMP_PRECISION: u32 = 6;
pub const MAX_INTERVAL_PRECISION: u32 = 6;
pub const TS_PREC_INV: f64 = 1000000.0;
pub const DAYS_PER_YEAR: f64 = 365.25;
pub const MONTHS_PER_YEAR: u32 = 12;
pub const DAYS_PER_MONTH: u32 = 30;
pub const HOURS_PER_DAY: u32 = 24;
pub const SECS_PER_YEAR: u32 = 31557600;
pub const SECS_PER_DAY: u32 = 86400;
pub const SECS_PER_HOUR: u32 = 3600;
pub const SECS_PER_MINUTE: u32 = 60;
pub const MINS_PER_HOUR: u32 = 60;
pub const MAX_TZDISP_HOUR: u32 = 15;
pub const TZDISP_LIMIT: u32 = 57600;
pub const JULIAN_MINYEAR: i32 = -4713;
pub const JULIAN_MINMONTH: u32 = 11;
pub const JULIAN_MINDAY: u32 = 24;
pub const JULIAN_MAXYEAR: u32 = 5874898;
pub const JULIAN_MAXMONTH: u32 = 6;
pub const JULIAN_MAXDAY: u32 = 3;
pub const UNIX_EPOCH_JDATE: u32 = 2440588;
pub const POSTGRES_EPOCH_JDATE: u32 = 2451545;
pub const DATETIME_MIN_JULIAN: u32 = 0;
pub const DATE_END_JULIAN: u32 = 2147483494;
pub const TIMESTAMP_END_JULIAN: u32 = 109203528;
pub const INNER_VAR: u32 = 65000;
pub const OUTER_VAR: u32 = 65001;
pub const INDEX_VAR: u32 = 65002;
pub const PRS2_OLD_VARNO: u32 = 1;
pub const PRS2_NEW_VARNO: u32 = 2;
pub const PD_HAS_FREE_LINES: u32 = 1;
pub const PD_PAGE_FULL: u32 = 2;
pub const PD_ALL_VISIBLE: u32 = 4;
pub const PD_VALID_FLAG_BITS: u32 = 7;
pub const PG_PAGE_LAYOUT_VERSION: u32 = 4;
pub const PG_DATA_CHECKSUM_VERSION: u32 = 1;
pub const PAI_OVERWRITE: u32 = 1;
pub const PAI_IS_HEAP: u32 = 2;
pub const HEAP_INSERT_SKIP_WAL: u32 = 1;
pub const HEAP_INSERT_SKIP_FSM: u32 = 2;
pub const HEAP_INSERT_FROZEN: u32 = 4;
pub const HEAP_INSERT_SPECULATIVE: u32 = 8;
pub const HEAP_INSERT_NO_LOGICAL: u32 = 16;
pub const CLOCKS_PER_SEC: u32 = 1000000;
pub const TIME_UTC: u32 = 1;
pub const PARAM_FLAG_CONST: u32 = 1;
pub const HASH_PARTITION: u32 = 1;
pub const HASH_SEGMENT: u32 = 2;
pub const HASH_DIRSIZE: u32 = 4;
pub const HASH_FFACTOR: u32 = 8;
pub const HASH_ELEM: u32 = 16;
pub const HASH_BLOBS: u32 = 32;
pub const HASH_FUNCTION: u32 = 64;
pub const HASH_COMPARE: u32 = 128;
pub const HASH_KEYCOPY: u32 = 256;
pub const HASH_ALLOC: u32 = 512;
pub const HASH_CONTEXT: u32 = 1024;
pub const HASH_SHARED_MEM: u32 = 2048;
pub const HASH_ATTACH: u32 = 4096;
pub const HASH_FIXED_SIZE: u32 = 8192;
pub const NO_MAX_DSIZE: i32 = -1;
pub const INDEX_SIZE_MASK: u32 = 8191;
pub const INDEX_VAR_MASK: u32 = 16384;
pub const INDEX_NULL_MASK: u32 = 32768;
pub const DEFAULT_SPINS_PER_DELAY: u32 = 100;
pub const EEO_FLAG_IS_QUAL: u32 = 1;
pub const ACL_INSERT: u32 = 1;
pub const ACL_SELECT: u32 = 2;
pub const ACL_UPDATE: u32 = 4;
pub const ACL_DELETE: u32 = 8;
pub const ACL_TRUNCATE: u32 = 16;
pub const ACL_REFERENCES: u32 = 32;
pub const ACL_TRIGGER: u32 = 64;
pub const ACL_EXECUTE: u32 = 128;
pub const ACL_USAGE: u32 = 256;
pub const ACL_CREATE: u32 = 512;
pub const ACL_CREATE_TEMP: u32 = 1024;
pub const ACL_CONNECT: u32 = 2048;
pub const N_ACL_RIGHTS: u32 = 12;
pub const ACL_NO_RIGHTS: u32 = 0;
pub const ACL_SELECT_FOR_UPDATE: u32 = 4;
pub const FRAMEOPTION_NONDEFAULT: u32 = 1;
pub const FRAMEOPTION_RANGE: u32 = 2;
pub const FRAMEOPTION_ROWS: u32 = 4;
pub const FRAMEOPTION_BETWEEN: u32 = 8;
pub const FRAMEOPTION_START_UNBOUNDED_PRECEDING: u32 = 16;
pub const FRAMEOPTION_END_UNBOUNDED_PRECEDING: u32 = 32;
pub const FRAMEOPTION_START_UNBOUNDED_FOLLOWING: u32 = 64;
pub const FRAMEOPTION_END_UNBOUNDED_FOLLOWING: u32 = 128;
pub const FRAMEOPTION_START_CURRENT_ROW: u32 = 256;
pub const FRAMEOPTION_END_CURRENT_ROW: u32 = 512;
pub const FRAMEOPTION_START_VALUE_PRECEDING: u32 = 1024;
pub const FRAMEOPTION_END_VALUE_PRECEDING: u32 = 2048;
pub const FRAMEOPTION_START_VALUE_FOLLOWING: u32 = 4096;
pub const FRAMEOPTION_END_VALUE_FOLLOWING: u32 = 8192;
pub const FRAMEOPTION_START_VALUE: u32 = 5120;
pub const FRAMEOPTION_END_VALUE: u32 = 10240;
pub const FRAMEOPTION_DEFAULTS: u32 = 530;
pub const PARTITION_STRATEGY_LIST: u8 = 108u8;
pub const PARTITION_STRATEGY_RANGE: u8 = 114u8;
pub const FKCONSTR_ACTION_NOACTION: u8 = 97u8;
pub const FKCONSTR_ACTION_RESTRICT: u8 = 114u8;
pub const FKCONSTR_ACTION_CASCADE: u8 = 99u8;
pub const FKCONSTR_ACTION_SETNULL: u8 = 110u8;
pub const FKCONSTR_ACTION_SETDEFAULT: u8 = 100u8;
pub const FKCONSTR_MATCH_FULL: u8 = 102u8;
pub const FKCONSTR_MATCH_PARTIAL: u8 = 112u8;
pub const FKCONSTR_MATCH_SIMPLE: u8 = 115u8;
pub const OPCLASS_ITEM_OPERATOR: u32 = 1;
pub const OPCLASS_ITEM_FUNCTION: u32 = 2;
pub const OPCLASS_ITEM_STORAGETYPE: u32 = 3;
pub const CURSOR_OPT_BINARY: u32 = 1;
pub const CURSOR_OPT_SCROLL: u32 = 2;
pub const CURSOR_OPT_NO_SCROLL: u32 = 4;
pub const CURSOR_OPT_INSENSITIVE: u32 = 8;
pub const CURSOR_OPT_HOLD: u32 = 16;
pub const CURSOR_OPT_FAST_PLAN: u32 = 32;
pub const CURSOR_OPT_GENERIC_PLAN: u32 = 64;
pub const CURSOR_OPT_CUSTOM_PLAN: u32 = 128;
pub const CURSOR_OPT_PARALLEL_OK: u32 = 256;
pub const FETCH_ALL: u64 = 9223372036854775807;
pub const REINDEXOPT_VERBOSE: u32 = 1;
pub const FORKNAMECHARS: u32 = 4;
pub const InvalidBackendId: i32 = -1;
pub const XLR_NORMAL_MAX_BLOCK_ID: u32 = 4;
pub const XLR_NORMAL_RDATAS: u32 = 20;
pub const REGBUF_FORCE_IMAGE: u32 = 1;
pub const REGBUF_NO_IMAGE: u32 = 2;
pub const REGBUF_WILL_INIT: u32 = 6;
pub const REGBUF_STANDARD: u32 = 8;
pub const REGBUF_KEEP_DATA: u32 = 16;
pub const XLR_INFO_MASK: u32 = 15;
pub const XLR_RMGR_INFO_MASK: u32 = 240;
pub const XLR_SPECIAL_REL_UPDATE: u32 = 1;
pub const XLR_CHECK_CONSISTENCY: u32 = 2;
pub const BKPIMAGE_HAS_HOLE: u32 = 1;
pub const BKPIMAGE_IS_COMPRESSED: u32 = 2;
pub const BKPIMAGE_APPLY: u32 = 4;
pub const BKPBLOCK_FORK_MASK: u32 = 15;
pub const BKPBLOCK_FLAG_MASK: u32 = 240;
pub const BKPBLOCK_HAS_IMAGE: u32 = 16;
pub const BKPBLOCK_HAS_DATA: u32 = 32;
pub const BKPBLOCK_WILL_INIT: u32 = 64;
pub const BKPBLOCK_SAME_REL: u32 = 128;
pub const XLR_MAX_BLOCK_ID: u32 = 32;
pub const XLR_BLOCK_ID_DATA_SHORT: u32 = 255;
pub const XLR_BLOCK_ID_DATA_LONG: u32 = 254;
pub const XLR_BLOCK_ID_ORIGIN: u32 = 253;
pub const __DARWIN_MAXNAMLEN: u32 = 255;
pub const __DARWIN_MAXPATHLEN: u32 = 1024;
pub const MAXNAMLEN: u32 = 255;
pub const DT_UNKNOWN: u32 = 0;
pub const DT_FIFO: u32 = 1;
pub const DT_CHR: u32 = 2;
pub const DT_DIR: u32 = 4;
pub const DT_BLK: u32 = 6;
pub const DT_REG: u32 = 8;
pub const DT_LNK: u32 = 10;
pub const DT_SOCK: u32 = 12;
pub const DT_WHT: u32 = 14;
pub const DIRBLKSIZ: u32 = 1024;
pub const DTF_HIDEW: u32 = 1;
pub const DTF_NODUP: u32 = 2;
pub const DTF_REWIND: u32 = 4;
pub const __DTF_READALL: u32 = 8;
pub const __DTF_SKIPREAD: u32 = 16;
pub const __DTF_ATEND: u32 = 32;
pub const PG_TEMP_FILES_DIR: &'static [u8; 10usize] = b"pgsql_tmp\0";
pub const PG_TEMP_FILE_PREFIX: &'static [u8; 10usize] = b"pgsql_tmp\0";
pub const SYNC_METHOD_FSYNC: u32 = 0;
pub const SYNC_METHOD_FDATASYNC: u32 = 1;
pub const SYNC_METHOD_OPEN: u32 = 2;
pub const SYNC_METHOD_FSYNC_WRITETHROUGH: u32 = 3;
pub const SYNC_METHOD_OPEN_DSYNC: u32 = 4;
pub const CHECKPOINT_IS_SHUTDOWN: u32 = 1;
pub const CHECKPOINT_END_OF_RECOVERY: u32 = 2;
pub const CHECKPOINT_IMMEDIATE: u32 = 4;
pub const CHECKPOINT_FORCE: u32 = 8;
pub const CHECKPOINT_FLUSH_ALL: u32 = 16;
pub const CHECKPOINT_WAIT: u32 = 32;
pub const CHECKPOINT_CAUSE_XLOG: u32 = 64;
pub const CHECKPOINT_CAUSE_TIME: u32 = 128;
pub const CHECKPOINT_REQUESTED: u32 = 256;
pub const XLOG_INCLUDE_ORIGIN: u32 = 1;
pub const XLOG_MARK_UNIMPORTANT: u32 = 2;
pub const BACKUP_LABEL_FILE: &'static [u8; 13usize] = b"backup_label\0";
pub const BACKUP_LABEL_OLD: &'static [u8; 17usize] = b"backup_label.old\0";
pub const TABLESPACE_MAP: &'static [u8; 15usize] = b"tablespace_map\0";
pub const TABLESPACE_MAP_OLD: &'static [u8; 19usize] = b"tablespace_map.old\0";
pub const RelationRelationId: u32 = 1259;
pub const RelationRelation_Rowtype_Id: u32 = 83;
pub const Natts_pg_class: u32 = 33;
pub const Anum_pg_class_relname: u32 = 1;
pub const Anum_pg_class_relnamespace: u32 = 2;
pub const Anum_pg_class_reltype: u32 = 3;
pub const Anum_pg_class_reloftype: u32 = 4;
pub const Anum_pg_class_relowner: u32 = 5;
pub const Anum_pg_class_relam: u32 = 6;
pub const Anum_pg_class_relfilenode: u32 = 7;
pub const Anum_pg_class_reltablespace: u32 = 8;
pub const Anum_pg_class_relpages: u32 = 9;
pub const Anum_pg_class_reltuples: u32 = 10;
pub const Anum_pg_class_relallvisible: u32 = 11;
pub const Anum_pg_class_reltoastrelid: u32 = 12;
pub const Anum_pg_class_relhasindex: u32 = 13;
pub const Anum_pg_class_relisshared: u32 = 14;
pub const Anum_pg_class_relpersistence: u32 = 15;
pub const Anum_pg_class_relkind: u32 = 16;
pub const Anum_pg_class_relnatts: u32 = 17;
pub const Anum_pg_class_relchecks: u32 = 18;
pub const Anum_pg_class_relhasoids: u32 = 19;
pub const Anum_pg_class_relhaspkey: u32 = 20;
pub const Anum_pg_class_relhasrules: u32 = 21;
pub const Anum_pg_class_relhastriggers: u32 = 22;
pub const Anum_pg_class_relhassubclass: u32 = 23;
pub const Anum_pg_class_relrowsecurity: u32 = 24;
pub const Anum_pg_class_relforcerowsecurity: u32 = 25;
pub const Anum_pg_class_relispopulated: u32 = 26;
pub const Anum_pg_class_relreplident: u32 = 27;
pub const Anum_pg_class_relispartition: u32 = 28;
pub const Anum_pg_class_relfrozenxid: u32 = 29;
pub const Anum_pg_class_relminmxid: u32 = 30;
pub const Anum_pg_class_relacl: u32 = 31;
pub const Anum_pg_class_reloptions: u32 = 32;
pub const Anum_pg_class_relpartbound: u32 = 33;
pub const RELKIND_RELATION: u8 = 114u8;
pub const RELKIND_INDEX: u8 = 105u8;
pub const RELKIND_SEQUENCE: u8 = 83u8;
pub const RELKIND_TOASTVALUE: u8 = 116u8;
pub const RELKIND_VIEW: u8 = 118u8;
pub const RELKIND_MATVIEW: u8 = 109u8;
pub const RELKIND_COMPOSITE_TYPE: u8 = 99u8;
pub const RELKIND_FOREIGN_TABLE: u8 = 102u8;
pub const RELKIND_PARTITIONED_TABLE: u8 = 112u8;
pub const RELPERSISTENCE_PERMANENT: u8 = 112u8;
pub const RELPERSISTENCE_UNLOGGED: u8 = 117u8;
pub const RELPERSISTENCE_TEMP: u8 = 116u8;
pub const REPLICA_IDENTITY_DEFAULT: u8 = 100u8;
pub const REPLICA_IDENTITY_NOTHING: u8 = 110u8;
pub const REPLICA_IDENTITY_FULL: u8 = 102u8;
pub const REPLICA_IDENTITY_INDEX: u8 = 105u8;
pub const IndexRelationId: u32 = 2610;
pub const Natts_pg_index: u32 = 19;
pub const Anum_pg_index_indexrelid: u32 = 1;
pub const Anum_pg_index_indrelid: u32 = 2;
pub const Anum_pg_index_indnatts: u32 = 3;
pub const Anum_pg_index_indisunique: u32 = 4;
pub const Anum_pg_index_indisprimary: u32 = 5;
pub const Anum_pg_index_indisexclusion: u32 = 6;
pub const Anum_pg_index_indimmediate: u32 = 7;
pub const Anum_pg_index_indisclustered: u32 = 8;
pub const Anum_pg_index_indisvalid: u32 = 9;
pub const Anum_pg_index_indcheckxmin: u32 = 10;
pub const Anum_pg_index_indisready: u32 = 11;
pub const Anum_pg_index_indislive: u32 = 12;
pub const Anum_pg_index_indisreplident: u32 = 13;
pub const Anum_pg_index_indkey: u32 = 14;
pub const Anum_pg_index_indcollation: u32 = 15;
pub const Anum_pg_index_indclass: u32 = 16;
pub const Anum_pg_index_indoption: u32 = 17;
pub const Anum_pg_index_indexprs: u32 = 18;
pub const Anum_pg_index_indpred: u32 = 19;
pub const INDOPTION_DESC: u32 = 1;
pub const INDOPTION_NULLS_FIRST: u32 = 2;
pub const EOH_HEADER_MAGIC: i32 = -1;
pub const EA_MAGIC: u32 = 689375833;
pub const ACL_ID_PUBLIC: u32 = 0;
pub const ACL_MODECHG_ADD: u32 = 1;
pub const ACL_MODECHG_DEL: u32 = 2;
pub const ACL_MODECHG_EQL: u32 = 3;
pub const ACL_INSERT_CHR: u8 = 97u8;
pub const ACL_SELECT_CHR: u8 = 114u8;
pub const ACL_UPDATE_CHR: u8 = 119u8;
pub const ACL_DELETE_CHR: u8 = 100u8;
pub const ACL_TRUNCATE_CHR: u8 = 68u8;
pub const ACL_REFERENCES_CHR: u8 = 120u8;
pub const ACL_TRIGGER_CHR: u8 = 116u8;
pub const ACL_EXECUTE_CHR: u8 = 88u8;
pub const ACL_USAGE_CHR: u8 = 85u8;
pub const ACL_CREATE_CHR: u8 = 67u8;
pub const ACL_CREATE_TEMP_CHR: u8 = 84u8;
pub const ACL_CONNECT_CHR: u8 = 99u8;
pub const ACL_ALL_RIGHTS_STR: &'static [u8; 13usize] = b"arwdDxtXUCTc\0";
pub const ACL_ALL_RIGHTS_COLUMN: u32 = 39;
pub const ACL_ALL_RIGHTS_RELATION: u32 = 127;
pub const ACL_ALL_RIGHTS_SEQUENCE: u32 = 262;
pub const ACL_ALL_RIGHTS_DATABASE: u32 = 3584;
pub const ACL_ALL_RIGHTS_FDW: u32 = 256;
pub const ACL_ALL_RIGHTS_FOREIGN_SERVER: u32 = 256;
pub const ACL_ALL_RIGHTS_FUNCTION: u32 = 128;
pub const ACL_ALL_RIGHTS_LANGUAGE: u32 = 256;
pub const ACL_ALL_RIGHTS_LARGEOBJECT: u32 = 6;
pub const ACL_ALL_RIGHTS_NAMESPACE: u32 = 768;
pub const ACL_ALL_RIGHTS_TABLESPACE: u32 = 512;
pub const ACL_ALL_RIGHTS_TYPE: u32 = 256;
pub const PublicationRelationId: u32 = 6104;
pub const Natts_pg_publication: u32 = 6;
pub const Anum_pg_publication_pubname: u32 = 1;
pub const Anum_pg_publication_pubowner: u32 = 2;
pub const Anum_pg_publication_puballtables: u32 = 3;
pub const Anum_pg_publication_pubinsert: u32 = 4;
pub const Anum_pg_publication_pubupdate: u32 = 5;
pub const Anum_pg_publication_pubdelete: u32 = 6;
pub const HEAP_MIN_FILLFACTOR: u32 = 10;
pub const HEAP_DEFAULT_FILLFACTOR: u32 = 100;
pub const COMPLETION_TAG_BUFSIZE: u32 = 64;
pub const EXEC_FLAG_EXPLAIN_ONLY: u32 = 1;
pub const EXEC_FLAG_REWIND: u32 = 2;
pub const EXEC_FLAG_BACKWARD: u32 = 4;
pub const EXEC_FLAG_MARK: u32 = 8;
pub const EXEC_FLAG_SKIP_TRIGGERS: u32 = 16;
pub const EXEC_FLAG_WITH_OIDS: u32 = 32;
pub const EXEC_FLAG_WITHOUT_OIDS: u32 = 64;
pub const EXEC_FLAG_WITH_NO_DATA: u32 = 128;
pub const TZ_STRLEN_MAX: u32 = 255;
pub const InvalidPid: i32 = -1;
pub const USE_POSTGRES_DATES: u32 = 0;
pub const USE_ISO_DATES: u32 = 1;
pub const USE_SQL_DATES: u32 = 2;
pub const USE_GERMAN_DATES: u32 = 3;
pub const USE_XSD_DATES: u32 = 4;
pub const DATEORDER_YMD: u32 = 0;
pub const DATEORDER_DMY: u32 = 1;
pub const DATEORDER_MDY: u32 = 2;
pub const INTSTYLE_POSTGRES: u32 = 0;
pub const INTSTYLE_POSTGRES_VERBOSE: u32 = 1;
pub const INTSTYLE_SQL_STANDARD: u32 = 2;
pub const INTSTYLE_ISO_8601: u32 = 3;
pub const MAXTZLEN: u32 = 10;
pub const SECURITY_LOCAL_USERID_CHANGE: u32 = 1;
pub const SECURITY_RESTRICTED_OPERATION: u32 = 2;
pub const SECURITY_NOFORCE_RLS: u32 = 4;
pub const SOL_LOCAL: u32 = 0;
pub const LOCAL_PEERCRED: u32 = 1;
pub const LOCAL_PEERPID: u32 = 2;
pub const LOCAL_PEEREPID: u32 = 3;
pub const LOCAL_PEERUUID: u32 = 4;
pub const LOCAL_PEEREUUID: u32 = 5;
pub const LOCAL_PEERTOKEN: u32 = 6;
pub const SM_DATABASE: u32 = 64;
pub const SM_USER: u32 = 32;
pub const SM_DATABASE_USER: u32 = 97;
pub const SM_OPTIONS: u32 = 64;
pub const SM_UNUSED: u32 = 64;
pub const SM_TTY: u32 = 64;
pub const MAX_STARTUP_PACKET_LENGTH: u32 = 10000;
pub const AUTH_REQ_OK: u32 = 0;
pub const AUTH_REQ_KRB4: u32 = 1;
pub const AUTH_REQ_KRB5: u32 = 2;
pub const AUTH_REQ_PASSWORD: u32 = 3;
pub const AUTH_REQ_CRYPT: u32 = 4;
pub const AUTH_REQ_MD5: u32 = 5;
pub const AUTH_REQ_SCM_CREDS: u32 = 6;
pub const AUTH_REQ_GSS: u32 = 7;
pub const AUTH_REQ_GSS_CONT: u32 = 8;
pub const AUTH_REQ_SSPI: u32 = 9;
pub const AUTH_REQ_SASL: u32 = 10;
pub const AUTH_REQ_SASL_CONT: u32 = 11;
pub const AUTH_REQ_SASL_FIN: u32 = 12;
pub const MIN_XFN_CHARS: u32 = 16;
pub const MAX_XFN_CHARS: u32 = 40;
pub const VALID_XFN_CHARS: &'static [u8; 40usize] = b"0123456789ABCDEF.history.backup.partial\0";
pub const WL_LATCH_SET: u32 = 1;
pub const WL_SOCKET_READABLE: u32 = 2;
pub const WL_SOCKET_WRITEABLE: u32 = 4;
pub const WL_TIMEOUT: u32 = 8;
pub const WL_POSTMASTER_DEATH: u32 = 16;
pub const WL_SOCKET_CONNECTED: u32 = 4;
pub const WL_SOCKET_MASK: u32 = 6;
pub const LWLOCK_PADDED_SIZE: u32 = 128;
pub const NUM_INDIVIDUAL_LWLOCKS: u32 = 48;
pub const NUM_BUFFER_PARTITIONS: u32 = 128;
pub const LOG2_NUM_LOCK_PARTITIONS: u32 = 4;
pub const NUM_LOCK_PARTITIONS: u32 = 16;
pub const LOG2_NUM_PREDICATELOCK_PARTITIONS: u32 = 4;
pub const NUM_PREDICATELOCK_PARTITIONS: u32 = 16;
pub const BUFFER_MAPPING_LWLOCK_OFFSET: u32 = 48;
pub const LOCK_MANAGER_LWLOCK_OFFSET: u32 = 176;
pub const PREDICATELOCK_MANAGER_LWLOCK_OFFSET: u32 = 192;
pub const NUM_FIXED_LWLOCKS: u32 = 208;
pub const SHMEM_INDEX_KEYSIZE: u32 = 48;
pub const SHMEM_INDEX_SIZE: u32 = 64;
pub const InvalidLocalTransactionId: u32 = 0;
pub const MAX_LOCKMODES: u32 = 10;
pub const DEFAULT_LOCKMETHOD: u32 = 1;
pub const USER_LOCKMETHOD: u32 = 2;
pub const PGPROC_MAX_CACHED_SUBXIDS: u32 = 64;
pub const PROC_IS_AUTOVACUUM: u32 = 1;
pub const PROC_IN_VACUUM: u32 = 2;
pub const PROC_IN_ANALYZE: u32 = 4;
pub const PROC_VACUUM_FOR_WRAPAROUND: u32 = 8;
pub const PROC_IN_LOGICAL_DECODING: u32 = 16;
pub const PROC_RESERVED: u32 = 32;
pub const PROC_VACUUM_STATE_MASK: u32 = 14;
pub const FP_LOCK_SLOTS_PER_BACKEND: u32 = 16;
pub const INVALID_PGPROCNO: u32 = 2147483647;
pub const NUM_AUXILIARY_PROCS: u32 = 4;
pub const PGSTAT_STAT_PERMANENT_DIRECTORY: &'static [u8; 8usize] = b"pg_stat\0";
pub const PGSTAT_STAT_PERMANENT_FILENAME: &'static [u8; 20usize] = b"pg_stat/global.stat\0";
pub const PGSTAT_STAT_PERMANENT_TMPFILE: &'static [u8; 19usize] = b"pg_stat/global.tmp\0";
pub const PG_STAT_TMP_DIR: &'static [u8; 12usize] = b"pg_stat_tmp\0";
pub const PGSTAT_MAX_MSG_SIZE: u32 = 1000;
pub const PGSTAT_FILE_FORMAT_ID: u32 = 27638941;
pub const PG_WAIT_LWLOCK: u32 = 16777216;
pub const PG_WAIT_LOCK: u32 = 50331648;
pub const PG_WAIT_BUFFER_PIN: u32 = 67108864;
pub const PG_WAIT_ACTIVITY: u32 = 83886080;
pub const PG_WAIT_CLIENT: u32 = 100663296;
pub const PG_WAIT_EXTENSION: u32 = 117440512;
pub const PG_WAIT_IPC: u32 = 134217728;
pub const PG_WAIT_TIMEOUT: u32 = 150994944;
pub const PG_WAIT_IO: u32 = 167772160;
pub const PGSTAT_NUM_PROGRESS_PARAM: u32 = 10;
pub const GIN_COMPARE_PROC: u32 = 1;
pub const GIN_EXTRACTVALUE_PROC: u32 = 2;
pub const GIN_EXTRACTQUERY_PROC: u32 = 3;
pub const GIN_CONSISTENT_PROC: u32 = 4;
pub const GIN_COMPARE_PARTIAL_PROC: u32 = 5;
pub const GIN_TRICONSISTENT_PROC: u32 = 6;
pub const GINNProcs: u32 = 6;
pub const GIN_SEARCH_MODE_DEFAULT: u32 = 0;
pub const GIN_SEARCH_MODE_INCLUDE_EMPTY: u32 = 1;
pub const GIN_SEARCH_MODE_ALL: u32 = 2;
pub const GIN_SEARCH_MODE_EVERYTHING: u32 = 3;
pub const GIN_FALSE: u32 = 0;
pub const GIN_TRUE: u32 = 1;
pub const GIN_MAYBE: u32 = 2;
pub const GIST_CONSISTENT_PROC: u32 = 1;
pub const GIST_UNION_PROC: u32 = 2;
pub const GIST_COMPRESS_PROC: u32 = 3;
pub const GIST_DECOMPRESS_PROC: u32 = 4;
pub const GIST_PENALTY_PROC: u32 = 5;
pub const GIST_PICKSPLIT_PROC: u32 = 6;
pub const GIST_EQUAL_PROC: u32 = 7;
pub const GIST_DISTANCE_PROC: u32 = 8;
pub const GIST_FETCH_PROC: u32 = 9;
pub const GISTNProcs: u32 = 9;
pub const F_LEAF: u32 = 1;
pub const F_DELETED: u32 = 2;
pub const F_TUPLES_DELETED: u32 = 4;
pub const F_FOLLOW_RIGHT: u32 = 8;
pub const F_HAS_GARBAGE: u32 = 16;
pub const GIST_PAGE_ID: u32 = 65409;
pub const FirstBootstrapObjectId: u32 = 10000;
pub const FirstNormalObjectId: u32 = 16384;
pub const MaxTupleAttributeNumber: u32 = 1664;
pub const MaxHeapAttributeNumber: u32 = 1600;
pub const HEAP_HASNULL: u32 = 1;
pub const HEAP_HASVARWIDTH: u32 = 2;
pub const HEAP_HASEXTERNAL: u32 = 4;
pub const HEAP_HASOID: u32 = 8;
pub const HEAP_XMAX_KEYSHR_LOCK: u32 = 16;
pub const HEAP_COMBOCID: u32 = 32;
pub const HEAP_XMAX_EXCL_LOCK: u32 = 64;
pub const HEAP_XMAX_LOCK_ONLY: u32 = 128;
pub const HEAP_XMAX_SHR_LOCK: u32 = 80;
pub const HEAP_LOCK_MASK: u32 = 80;
pub const HEAP_XMIN_COMMITTED: u32 = 256;
pub const HEAP_XMIN_INVALID: u32 = 512;
pub const HEAP_XMIN_FROZEN: u32 = 768;
pub const HEAP_XMAX_COMMITTED: u32 = 1024;
pub const HEAP_XMAX_INVALID: u32 = 2048;
pub const HEAP_XMAX_IS_MULTI: u32 = 4096;
pub const HEAP_UPDATED: u32 = 8192;
pub const HEAP_MOVED_OFF: u32 = 16384;
pub const HEAP_MOVED_IN: u32 = 32768;
pub const HEAP_MOVED: u32 = 49152;
pub const HEAP_XACT_MASK: u32 = 65520;
pub const HEAP_XMAX_BITS: u32 = 7376;
pub const HEAP_NATTS_MASK: u32 = 2047;
pub const HEAP_KEYS_UPDATED: u32 = 8192;
pub const HEAP_HOT_UPDATED: u32 = 16384;
pub const HEAP_ONLY_TUPLE: u32 = 32768;
pub const HEAP2_XACT_MASK: u32 = 57344;
pub const HEAP_TUPLE_HAS_MATCH: u32 = 32768;
pub const SpecTokenOffsetNumber: u32 = 65534;
pub const MaxAttrSize: u32 = 10485760;
pub const SelfItemPointerAttributeNumber: i32 = -1;
pub const ObjectIdAttributeNumber: i32 = -2;
pub const MinTransactionIdAttributeNumber: i32 = -3;
pub const MinCommandIdAttributeNumber: i32 = -4;
pub const MaxTransactionIdAttributeNumber: i32 = -5;
pub const MaxCommandIdAttributeNumber: i32 = -6;
pub const TableOidAttributeNumber: i32 = -7;
pub const FirstLowInvalidHeapAttributeNumber: i32 = -8;
pub const SHAREDINVALCATALOG_ID: i32 = -1;
pub const SHAREDINVALRELCACHE_ID: i32 = -2;
pub const SHAREDINVALSMGR_ID: i32 = -3;
pub const SHAREDINVALRELMAP_ID: i32 = -4;
pub const SHAREDINVALSNAPSHOT_ID: i32 = -5;
pub const INTERVAL_FULL_RANGE: u32 = 32767;
pub const INTERVAL_RANGE_MASK: u32 = 32767;
pub const INTERVAL_FULL_PRECISION: u32 = 65535;
pub const INTERVAL_PRECISION_MASK: u32 = 65535;
pub const DAGO: &'static [u8; 4usize] = b"ago\0";
pub const DCURRENT: &'static [u8; 8usize] = b"current\0";
pub const EPOCH: &'static [u8; 6usize] = b"epoch\0";
pub const INVALID: &'static [u8; 8usize] = b"invalid\0";
pub const EARLY: &'static [u8; 10usize] = b"-infinity\0";
pub const LATE: &'static [u8; 9usize] = b"infinity\0";
pub const NOW: &'static [u8; 4usize] = b"now\0";
pub const TODAY: &'static [u8; 6usize] = b"today\0";
pub const TOMORROW: &'static [u8; 9usize] = b"tomorrow\0";
pub const YESTERDAY: &'static [u8; 10usize] = b"yesterday\0";
pub const ZULU: &'static [u8; 5usize] = b"zulu\0";
pub const DMICROSEC: &'static [u8; 8usize] = b"usecond\0";
pub const DMILLISEC: &'static [u8; 8usize] = b"msecond\0";
pub const DSECOND: &'static [u8; 7usize] = b"second\0";
pub const DMINUTE: &'static [u8; 7usize] = b"minute\0";
pub const DHOUR: &'static [u8; 5usize] = b"hour\0";
pub const DDAY: &'static [u8; 4usize] = b"day\0";
pub const DWEEK: &'static [u8; 5usize] = b"week\0";
pub const DMONTH: &'static [u8; 6usize] = b"month\0";
pub const DQUARTER: &'static [u8; 8usize] = b"quarter\0";
pub const DYEAR: &'static [u8; 5usize] = b"year\0";
pub const DDECADE: &'static [u8; 7usize] = b"decade\0";
pub const DCENTURY: &'static [u8; 8usize] = b"century\0";
pub const DMILLENNIUM: &'static [u8; 11usize] = b"millennium\0";
pub const DA_D: &'static [u8; 3usize] = b"ad\0";
pub const DB_C: &'static [u8; 3usize] = b"bc\0";
pub const DTIMEZONE: &'static [u8; 9usize] = b"timezone\0";
pub const AM: u32 = 0;
pub const PM: u32 = 1;
pub const HR24: u32 = 2;
pub const AD: u32 = 0;
pub const BC: u32 = 1;
pub const RESERV: u32 = 0;
pub const MONTH: u32 = 1;
pub const YEAR: u32 = 2;
pub const DAY: u32 = 3;
pub const JULIAN: u32 = 4;
pub const TZ: u32 = 5;
pub const DTZ: u32 = 6;
pub const DYNTZ: u32 = 7;
pub const IGNORE_DTF: u32 = 8;
pub const AMPM: u32 = 9;
pub const HOUR: u32 = 10;
pub const MINUTE: u32 = 11;
pub const SECOND: u32 = 12;
pub const MILLISECOND: u32 = 13;
pub const MICROSECOND: u32 = 14;
pub const DOY: u32 = 15;
pub const DOW: u32 = 16;
pub const UNITS: u32 = 17;
pub const ADBC: u32 = 18;
pub const AGO: u32 = 19;
pub const ABS_BEFORE: u32 = 20;
pub const ABS_AFTER: u32 = 21;
pub const ISODATE: u32 = 22;
pub const ISOTIME: u32 = 23;
pub const WEEK: u32 = 24;
pub const DECADE: u32 = 25;
pub const CENTURY: u32 = 26;
pub const MILLENNIUM: u32 = 27;
pub const DTZMOD: u32 = 28;
pub const UNKNOWN_FIELD: u32 = 31;
pub const DTK_NUMBER: u32 = 0;
pub const DTK_STRING: u32 = 1;
pub const DTK_DATE: u32 = 2;
pub const DTK_TIME: u32 = 3;
pub const DTK_TZ: u32 = 4;
pub const DTK_AGO: u32 = 5;
pub const DTK_SPECIAL: u32 = 6;
pub const DTK_INVALID: u32 = 7;
pub const DTK_CURRENT: u32 = 8;
pub const DTK_EARLY: u32 = 9;
pub const DTK_LATE: u32 = 10;
pub const DTK_EPOCH: u32 = 11;
pub const DTK_NOW: u32 = 12;
pub const DTK_YESTERDAY: u32 = 13;
pub const DTK_TODAY: u32 = 14;
pub const DTK_TOMORROW: u32 = 15;
pub const DTK_ZULU: u32 = 16;
pub const DTK_DELTA: u32 = 17;
pub const DTK_SECOND: u32 = 18;
pub const DTK_MINUTE: u32 = 19;
pub const DTK_HOUR: u32 = 20;
pub const DTK_DAY: u32 = 21;
pub const DTK_WEEK: u32 = 22;
pub const DTK_MONTH: u32 = 23;
pub const DTK_QUARTER: u32 = 24;
pub const DTK_YEAR: u32 = 25;
pub const DTK_DECADE: u32 = 26;
pub const DTK_CENTURY: u32 = 27;
pub const DTK_MILLENNIUM: u32 = 28;
pub const DTK_MILLISEC: u32 = 29;
pub const DTK_MICROSEC: u32 = 30;
pub const DTK_JULIAN: u32 = 31;
pub const DTK_DOW: u32 = 32;
pub const DTK_DOY: u32 = 33;
pub const DTK_TZ_HOUR: u32 = 34;
pub const DTK_TZ_MINUTE: u32 = 35;
pub const DTK_ISOYEAR: u32 = 36;
pub const DTK_ISODOW: u32 = 37;
pub const MAXDATELEN: u32 = 128;
pub const MAXDATEFIELDS: u32 = 25;
pub const TOKMAXLEN: u32 = 10;
pub const DTERR_BAD_FORMAT: i32 = -1;
pub const DTERR_FIELD_OVERFLOW: i32 = -2;
pub const DTERR_MD_FIELD_OVERFLOW: i32 = -3;
pub const DTERR_INTERVAL_OVERFLOW: i32 = -4;
pub const DTERR_TZDISP_OVERFLOW: i32 = -5;
pub const XACT_READ_UNCOMMITTED: u32 = 0;
pub const XACT_READ_COMMITTED: u32 = 1;
pub const XACT_REPEATABLE_READ: u32 = 2;
pub const XACT_SERIALIZABLE: u32 = 3;
pub const XACT_FLAGS_ACCESSEDTEMPREL: u32 = 1;
pub const XACT_FLAGS_ACQUIREDACCESSEXCLUSIVELOCK: u32 = 2;
pub const XACT_FLAGS_ACCESSEDTEMPNAMESPACE: u32 = 4;
pub const XLOG_XACT_COMMIT: u32 = 0;
pub const XLOG_XACT_PREPARE: u32 = 16;
pub const XLOG_XACT_ABORT: u32 = 32;
pub const XLOG_XACT_COMMIT_PREPARED: u32 = 48;
pub const XLOG_XACT_ABORT_PREPARED: u32 = 64;
pub const XLOG_XACT_ASSIGNMENT: u32 = 80;
pub const XLOG_XACT_OPMASK: u32 = 112;
pub const XLOG_XACT_HAS_INFO: u32 = 128;
pub const XACT_XINFO_HAS_DBINFO: u32 = 1;
pub const XACT_XINFO_HAS_SUBXACTS: u32 = 2;
pub const XACT_XINFO_HAS_RELFILENODES: u32 = 4;
pub const XACT_XINFO_HAS_INVALS: u32 = 8;
pub const XACT_XINFO_HAS_TWOPHASE: u32 = 16;
pub const XACT_XINFO_HAS_ORIGIN: u32 = 32;
pub const XACT_XINFO_HAS_AE_LOCKS: u32 = 64;
pub const XACT_COMPLETION_APPLY_FEEDBACK: u32 = 536870912;
pub const XACT_COMPLETION_UPDATE_RELCACHE_FILE: u32 = 1073741824;
pub const XACT_COMPLETION_FORCE_SYNC_COMMIT: u32 = 2147483648;
pub const PERFORM_DELETION_INTERNAL: u32 = 1;
pub const PERFORM_DELETION_CONCURRENTLY: u32 = 2;
pub const PERFORM_DELETION_QUIETLY: u32 = 4;
pub const PERFORM_DELETION_SKIP_ORIGINAL: u32 = 8;
pub const PERFORM_DELETION_SKIP_EXTENSIONS: u32 = 16;
pub const DEFAULT_INDEX_TYPE: &'static [u8; 6usize] = b"btree\0";
pub const REINDEX_REL_PROCESS_TOAST: u32 = 1;
pub const REINDEX_REL_SUPPRESS_INDEX_USE: u32 = 2;
pub const REINDEX_REL_CHECK_CONSTRAINTS: u32 = 4;
pub const REINDEX_REL_FORCE_INDEXES_UNLOGGED: u32 = 8;
pub const REINDEX_REL_FORCE_INDEXES_PERMANENT: u32 = 16;
pub const EnumRelationId: u32 = 3501;
pub const Natts_pg_enum: u32 = 3;
pub const Anum_pg_enum_enumtypid: u32 = 1;
pub const Anum_pg_enum_enumsortorder: u32 = 2;
pub const Anum_pg_enum_enumlabel: u32 = 3;
pub const ProcedureRelationId: u32 = 1255;
pub const ProcedureRelation_Rowtype_Id: u32 = 81;
pub const Natts_pg_proc: u32 = 29;
pub const Anum_pg_proc_proname: u32 = 1;
pub const Anum_pg_proc_pronamespace: u32 = 2;
pub const Anum_pg_proc_proowner: u32 = 3;
pub const Anum_pg_proc_prolang: u32 = 4;
pub const Anum_pg_proc_procost: u32 = 5;
pub const Anum_pg_proc_prorows: u32 = 6;
pub const Anum_pg_proc_provariadic: u32 = 7;
pub const Anum_pg_proc_protransform: u32 = 8;
pub const Anum_pg_proc_proisagg: u32 = 9;
pub const Anum_pg_proc_proiswindow: u32 = 10;
pub const Anum_pg_proc_prosecdef: u32 = 11;
pub const Anum_pg_proc_proleakproof: u32 = 12;
pub const Anum_pg_proc_proisstrict: u32 = 13;
pub const Anum_pg_proc_proretset: u32 = 14;
pub const Anum_pg_proc_provolatile: u32 = 15;
pub const Anum_pg_proc_proparallel: u32 = 16;
pub const Anum_pg_proc_pronargs: u32 = 17;
pub const Anum_pg_proc_pronargdefaults: u32 = 18;
pub const Anum_pg_proc_prorettype: u32 = 19;
pub const Anum_pg_proc_proargtypes: u32 = 20;
pub const Anum_pg_proc_proallargtypes: u32 = 21;
pub const Anum_pg_proc_proargmodes: u32 = 22;
pub const Anum_pg_proc_proargnames: u32 = 23;
pub const Anum_pg_proc_proargdefaults: u32 = 24;
pub const Anum_pg_proc_protrftypes: u32 = 25;
pub const Anum_pg_proc_prosrc: u32 = 26;
pub const Anum_pg_proc_probin: u32 = 27;
pub const Anum_pg_proc_proconfig: u32 = 28;
pub const Anum_pg_proc_proacl: u32 = 29;
pub const PROVOLATILE_IMMUTABLE: u8 = 105u8;
pub const PROVOLATILE_STABLE: u8 = 115u8;
pub const PROVOLATILE_VOLATILE: u8 = 118u8;
pub const PROPARALLEL_SAFE: u8 = 115u8;
pub const PROPARALLEL_RESTRICTED: u8 = 114u8;
pub const PROPARALLEL_UNSAFE: u8 = 117u8;
pub const PROARGMODE_IN: u8 = 105u8;
pub const PROARGMODE_OUT: u8 = 111u8;
pub const PROARGMODE_INOUT: u8 = 98u8;
pub const PROARGMODE_VARIADIC: u8 = 118u8;
pub const PROARGMODE_TABLE: u8 = 116u8;
pub const TriggerRelationId: u32 = 2620;
pub const Natts_pg_trigger: u32 = 17;
pub const Anum_pg_trigger_tgrelid: u32 = 1;
pub const Anum_pg_trigger_tgname: u32 = 2;
pub const Anum_pg_trigger_tgfoid: u32 = 3;
pub const Anum_pg_trigger_tgtype: u32 = 4;
pub const Anum_pg_trigger_tgenabled: u32 = 5;
pub const Anum_pg_trigger_tgisinternal: u32 = 6;
pub const Anum_pg_trigger_tgconstrrelid: u32 = 7;
pub const Anum_pg_trigger_tgconstrindid: u32 = 8;
pub const Anum_pg_trigger_tgconstraint: u32 = 9;
pub const Anum_pg_trigger_tgdeferrable: u32 = 10;
pub const Anum_pg_trigger_tginitdeferred: u32 = 11;
pub const Anum_pg_trigger_tgnargs: u32 = 12;
pub const Anum_pg_trigger_tgattr: u32 = 13;
pub const Anum_pg_trigger_tgargs: u32 = 14;
pub const Anum_pg_trigger_tgqual: u32 = 15;
pub const Anum_pg_trigger_tgoldtable: u32 = 16;
pub const Anum_pg_trigger_tgnewtable: u32 = 17;
pub const TRIGGER_TYPE_ROW: u32 = 1;
pub const TRIGGER_TYPE_BEFORE: u32 = 2;
pub const TRIGGER_TYPE_INSERT: u32 = 4;
pub const TRIGGER_TYPE_DELETE: u32 = 8;
pub const TRIGGER_TYPE_UPDATE: u32 = 16;
pub const TRIGGER_TYPE_TRUNCATE: u32 = 32;
pub const TRIGGER_TYPE_INSTEAD: u32 = 64;
pub const TRIGGER_TYPE_LEVEL_MASK: u32 = 1;
pub const TRIGGER_TYPE_STATEMENT: u32 = 0;
pub const TRIGGER_TYPE_TIMING_MASK: u32 = 66;
pub const TRIGGER_TYPE_AFTER: u32 = 0;
pub const TRIGGER_TYPE_EVENT_MASK: u32 = 60;
pub const TypeRelationId: u32 = 1247;
pub const TypeRelation_Rowtype_Id: u32 = 71;
pub const Natts_pg_type: u32 = 30;
pub const Anum_pg_type_typname: u32 = 1;
pub const Anum_pg_type_typnamespace: u32 = 2;
pub const Anum_pg_type_typowner: u32 = 3;
pub const Anum_pg_type_typlen: u32 = 4;
pub const Anum_pg_type_typbyval: u32 = 5;
pub const Anum_pg_type_typtype: u32 = 6;
pub const Anum_pg_type_typcategory: u32 = 7;
pub const Anum_pg_type_typispreferred: u32 = 8;
pub const Anum_pg_type_typisdefined: u32 = 9;
pub const Anum_pg_type_typdelim: u32 = 10;
pub const Anum_pg_type_typrelid: u32 = 11;
pub const Anum_pg_type_typelem: u32 = 12;
pub const Anum_pg_type_typarray: u32 = 13;
pub const Anum_pg_type_typinput: u32 = 14;
pub const Anum_pg_type_typoutput: u32 = 15;
pub const Anum_pg_type_typreceive: u32 = 16;
pub const Anum_pg_type_typsend: u32 = 17;
pub const Anum_pg_type_typmodin: u32 = 18;
pub const Anum_pg_type_typmodout: u32 = 19;
pub const Anum_pg_type_typanalyze: u32 = 20;
pub const Anum_pg_type_typalign: u32 = 21;
pub const Anum_pg_type_typstorage: u32 = 22;
pub const Anum_pg_type_typnotnull: u32 = 23;
pub const Anum_pg_type_typbasetype: u32 = 24;
pub const Anum_pg_type_typtypmod: u32 = 25;
pub const Anum_pg_type_typndims: u32 = 26;
pub const Anum_pg_type_typcollation: u32 = 27;
pub const Anum_pg_type_typdefaultbin: u32 = 28;
pub const Anum_pg_type_typdefault: u32 = 29;
pub const Anum_pg_type_typacl: u32 = 30;
pub const BOOLOID: u32 = 16;
pub const BYTEAOID: u32 = 17;
pub const CHAROID: u32 = 18;
pub const NAMEOID: u32 = 19;
pub const INT8OID: u32 = 20;
pub const INT2OID: u32 = 21;
pub const INT2VECTOROID: u32 = 22;
pub const INT4OID: u32 = 23;
pub const REGPROCOID: u32 = 24;
pub const TEXTOID: u32 = 25;
pub const OIDOID: u32 = 26;
pub const TIDOID: u32 = 27;
pub const XIDOID: u32 = 28;
pub const CIDOID: u32 = 29;
pub const OIDVECTOROID: u32 = 30;
pub const JSONOID: u32 = 114;
pub const XMLOID: u32 = 142;
pub const PGNODETREEOID: u32 = 194;
pub const PGNDISTINCTOID: u32 = 3361;
pub const PGDEPENDENCIESOID: u32 = 3402;
pub const PGDDLCOMMANDOID: u32 = 32;
pub const POINTOID: u32 = 600;
pub const LSEGOID: u32 = 601;
pub const PATHOID: u32 = 602;
pub const BOXOID: u32 = 603;
pub const POLYGONOID: u32 = 604;
pub const LINEOID: u32 = 628;
pub const FLOAT4OID: u32 = 700;
pub const FLOAT8OID: u32 = 701;
pub const ABSTIMEOID: u32 = 702;
pub const RELTIMEOID: u32 = 703;
pub const TINTERVALOID: u32 = 704;
pub const UNKNOWNOID: u32 = 705;
pub const CIRCLEOID: u32 = 718;
pub const CASHOID: u32 = 790;
pub const MACADDROID: u32 = 829;
pub const INETOID: u32 = 869;
pub const CIDROID: u32 = 650;
pub const MACADDR8OID: u32 = 774;
pub const INT2ARRAYOID: u32 = 1005;
pub const INT4ARRAYOID: u32 = 1007;
pub const TEXTARRAYOID: u32 = 1009;
pub const OIDARRAYOID: u32 = 1028;
pub const FLOAT4ARRAYOID: u32 = 1021;
pub const ACLITEMOID: u32 = 1033;
pub const CSTRINGARRAYOID: u32 = 1263;
pub const BPCHAROID: u32 = 1042;
pub const VARCHAROID: u32 = 1043;
pub const DATEOID: u32 = 1082;
pub const TIMEOID: u32 = 1083;
pub const TIMESTAMPOID: u32 = 1114;
pub const TIMESTAMPTZOID: u32 = 1184;
pub const INTERVALOID: u32 = 1186;
pub const TIMETZOID: u32 = 1266;
pub const BITOID: u32 = 1560;
pub const VARBITOID: u32 = 1562;
pub const NUMERICOID: u32 = 1700;
pub const REFCURSOROID: u32 = 1790;
pub const REGPROCEDUREOID: u32 = 2202;
pub const REGOPEROID: u32 = 2203;
pub const REGOPERATOROID: u32 = 2204;
pub const REGCLASSOID: u32 = 2205;
pub const REGTYPEOID: u32 = 2206;
pub const REGROLEOID: u32 = 4096;
pub const REGNAMESPACEOID: u32 = 4089;
pub const REGTYPEARRAYOID: u32 = 2211;
pub const UUIDOID: u32 = 2950;
pub const LSNOID: u32 = 3220;
pub const TSVECTOROID: u32 = 3614;
pub const GTSVECTOROID: u32 = 3642;
pub const TSQUERYOID: u32 = 3615;
pub const REGCONFIGOID: u32 = 3734;
pub const REGDICTIONARYOID: u32 = 3769;
pub const JSONBOID: u32 = 3802;
pub const INT4RANGEOID: u32 = 3904;
pub const RECORDOID: u32 = 2249;
pub const RECORDARRAYOID: u32 = 2287;
pub const CSTRINGOID: u32 = 2275;
pub const ANYOID: u32 = 2276;
pub const ANYARRAYOID: u32 = 2277;
pub const VOIDOID: u32 = 2278;
pub const TRIGGEROID: u32 = 2279;
pub const EVTTRIGGEROID: u32 = 3838;
pub const LANGUAGE_HANDLEROID: u32 = 2280;
pub const INTERNALOID: u32 = 2281;
pub const OPAQUEOID: u32 = 2282;
pub const ANYELEMENTOID: u32 = 2283;
pub const ANYNONARRAYOID: u32 = 2776;
pub const ANYENUMOID: u32 = 3500;
pub const FDW_HANDLEROID: u32 = 3115;
pub const INDEX_AM_HANDLEROID: u32 = 325;
pub const TSM_HANDLEROID: u32 = 3310;
pub const ANYRANGEOID: u32 = 3831;
pub const TYPTYPE_BASE: u8 = 98u8;
pub const TYPTYPE_COMPOSITE: u8 = 99u8;
pub const TYPTYPE_DOMAIN: u8 = 100u8;
pub const TYPTYPE_ENUM: u8 = 101u8;
pub const TYPTYPE_PSEUDO: u8 = 112u8;
pub const TYPTYPE_RANGE: u8 = 114u8;
pub const TYPCATEGORY_INVALID: u8 = 0u8;
pub const TYPCATEGORY_ARRAY: u8 = 65u8;
pub const TYPCATEGORY_BOOLEAN: u8 = 66u8;
pub const TYPCATEGORY_COMPOSITE: u8 = 67u8;
pub const TYPCATEGORY_DATETIME: u8 = 68u8;
pub const TYPCATEGORY_ENUM: u8 = 69u8;
pub const TYPCATEGORY_GEOMETRIC: u8 = 71u8;
pub const TYPCATEGORY_NETWORK: u8 = 73u8;
pub const TYPCATEGORY_NUMERIC: u8 = 78u8;
pub const TYPCATEGORY_PSEUDOTYPE: u8 = 80u8;
pub const TYPCATEGORY_RANGE: u8 = 82u8;
pub const TYPCATEGORY_STRING: u8 = 83u8;
pub const TYPCATEGORY_TIMESPAN: u8 = 84u8;
pub const TYPCATEGORY_USER: u8 = 85u8;
pub const TYPCATEGORY_BITSTRING: u8 = 86u8;
pub const TYPCATEGORY_UNKNOWN: u8 = 88u8;
pub const EventTriggerRelationId: u32 = 3466;
pub const Natts_pg_event_trigger: u32 = 6;
pub const Anum_pg_event_trigger_evtname: u32 = 1;
pub const Anum_pg_event_trigger_evtevent: u32 = 2;
pub const Anum_pg_event_trigger_evtowner: u32 = 3;
pub const Anum_pg_event_trigger_evtfoid: u32 = 4;
pub const Anum_pg_event_trigger_evtenabled: u32 = 5;
pub const Anum_pg_event_trigger_evttags: u32 = 6;
pub const AT_REWRITE_ALTER_PERSISTENCE: u32 = 1;
pub const AT_REWRITE_DEFAULT_VAL: u32 = 2;
pub const AT_REWRITE_COLUMN_REWRITE: u32 = 4;
pub const AT_REWRITE_ALTER_OID: u32 = 8;
pub const TRIGGER_EVENT_INSERT: u32 = 0;
pub const TRIGGER_EVENT_DELETE: u32 = 1;
pub const TRIGGER_EVENT_UPDATE: u32 = 2;
pub const TRIGGER_EVENT_TRUNCATE: u32 = 3;
pub const TRIGGER_EVENT_OPMASK: u32 = 3;
pub const TRIGGER_EVENT_ROW: u32 = 4;
pub const TRIGGER_EVENT_BEFORE: u32 = 8;
pub const TRIGGER_EVENT_AFTER: u32 = 0;
pub const TRIGGER_EVENT_INSTEAD: u32 = 16;
pub const TRIGGER_EVENT_TIMINGMASK: u32 = 24;
pub const AFTER_TRIGGER_DEFERRABLE: u32 = 32;
pub const AFTER_TRIGGER_INITDEFERRED: u32 = 64;
pub const SESSION_REPLICATION_ROLE_ORIGIN: u32 = 0;
pub const SESSION_REPLICATION_ROLE_REPLICA: u32 = 1;
pub const SESSION_REPLICATION_ROLE_LOCAL: u32 = 2;
pub const TRIGGER_FIRES_ON_ORIGIN: u8 = 79u8;
pub const TRIGGER_FIRES_ALWAYS: u8 = 65u8;
pub const TRIGGER_FIRES_ON_REPLICA: u8 = 82u8;
pub const TRIGGER_DISABLED: u8 = 68u8;
pub const RI_TRIGGER_PK: u32 = 1;
pub const RI_TRIGGER_FK: u32 = 2;
pub const RI_TRIGGER_NONE: u32 = 0;
pub const StatisticRelationId: u32 = 2619;
pub const STATISTIC_NUM_SLOTS: u32 = 5;
pub const Natts_pg_statistic: u32 = 26;
pub const Anum_pg_statistic_starelid: u32 = 1;
pub const Anum_pg_statistic_staattnum: u32 = 2;
pub const Anum_pg_statistic_stainherit: u32 = 3;
pub const Anum_pg_statistic_stanullfrac: u32 = 4;
pub const Anum_pg_statistic_stawidth: u32 = 5;
pub const Anum_pg_statistic_stadistinct: u32 = 6;
pub const Anum_pg_statistic_stakind1: u32 = 7;
pub const Anum_pg_statistic_stakind2: u32 = 8;
pub const Anum_pg_statistic_stakind3: u32 = 9;
pub const Anum_pg_statistic_stakind4: u32 = 10;
pub const Anum_pg_statistic_stakind5: u32 = 11;
pub const Anum_pg_statistic_staop1: u32 = 12;
pub const Anum_pg_statistic_staop2: u32 = 13;
pub const Anum_pg_statistic_staop3: u32 = 14;
pub const Anum_pg_statistic_staop4: u32 = 15;
pub const Anum_pg_statistic_staop5: u32 = 16;
pub const Anum_pg_statistic_stanumbers1: u32 = 17;
pub const Anum_pg_statistic_stanumbers2: u32 = 18;
pub const Anum_pg_statistic_stanumbers3: u32 = 19;
pub const Anum_pg_statistic_stanumbers4: u32 = 20;
pub const Anum_pg_statistic_stanumbers5: u32 = 21;
pub const Anum_pg_statistic_stavalues1: u32 = 22;
pub const Anum_pg_statistic_stavalues2: u32 = 23;
pub const Anum_pg_statistic_stavalues3: u32 = 24;
pub const Anum_pg_statistic_stavalues4: u32 = 25;
pub const Anum_pg_statistic_stavalues5: u32 = 26;
pub const STATISTIC_KIND_MCV: u32 = 1;
pub const STATISTIC_KIND_HISTOGRAM: u32 = 2;
pub const STATISTIC_KIND_CORRELATION: u32 = 3;
pub const STATISTIC_KIND_MCELEM: u32 = 4;
pub const STATISTIC_KIND_DECHIST: u32 = 5;
pub const STATISTIC_KIND_RANGE_LENGTH_HISTOGRAM: u32 = 6;
pub const STATISTIC_KIND_BOUNDS_HISTOGRAM: u32 = 7;
pub const CACHEDPLANSOURCE_MAGIC: u32 = 195726186;
pub const CACHEDPLAN_MAGIC: u32 = 953717834;
pub const SPI_ERROR_CONNECT: i32 = -1;
pub const SPI_ERROR_COPY: i32 = -2;
pub const SPI_ERROR_OPUNKNOWN: i32 = -3;
pub const SPI_ERROR_UNCONNECTED: i32 = -4;
pub const SPI_ERROR_CURSOR: i32 = -5;
pub const SPI_ERROR_ARGUMENT: i32 = -6;
pub const SPI_ERROR_PARAM: i32 = -7;
pub const SPI_ERROR_TRANSACTION: i32 = -8;
pub const SPI_ERROR_NOATTRIBUTE: i32 = -9;
pub const SPI_ERROR_NOOUTFUNC: i32 = -10;
pub const SPI_ERROR_TYPUNKNOWN: i32 = -11;
pub const SPI_ERROR_REL_DUPLICATE: i32 = -12;
pub const SPI_ERROR_REL_NOT_FOUND: i32 = -13;
pub const SPI_OK_CONNECT: u32 = 1;
pub const SPI_OK_FINISH: u32 = 2;
pub const SPI_OK_FETCH: u32 = 3;
pub const SPI_OK_UTILITY: u32 = 4;
pub const SPI_OK_SELECT: u32 = 5;
pub const SPI_OK_SELINTO: u32 = 6;
pub const SPI_OK_INSERT: u32 = 7;
pub const SPI_OK_DELETE: u32 = 8;
pub const SPI_OK_UPDATE: u32 = 9;
pub const SPI_OK_CURSOR: u32 = 10;
pub const SPI_OK_INSERT_RETURNING: u32 = 11;
pub const SPI_OK_DELETE_RETURNING: u32 = 12;
pub const SPI_OK_UPDATE_RETURNING: u32 = 13;
pub const SPI_OK_REWRITTEN: u32 = 14;
pub const SPI_OK_REL_REGISTER: u32 = 15;
pub const SPI_OK_REL_UNREGISTER: u32 = 16;
pub const SPI_OK_TD_REGISTER: u32 = 17;
pub const BGWORKER_SHMEM_ACCESS: u32 = 1;
pub const BGWORKER_BACKEND_DATABASE_CONNECTION: u32 = 2;
pub const BGWORKER_CLASS_PARALLEL: u32 = 16;
pub const BGW_DEFAULT_RESTART_INTERVAL: u32 = 60;
pub const BGW_NEVER_RESTART: i32 = -1;
pub const BGW_MAXLEN: u32 = 64;
pub const BGW_EXTRALEN: u32 = 128;
pub const EXTNODENAME_MAX_LEN: u32 = 64;
pub const CUSTOMPATH_SUPPORT_BACKWARD_SCAN: u32 = 1;
pub const CUSTOMPATH_SUPPORT_MARK_RESTORE: u32 = 2;
pub const QTW_IGNORE_RT_SUBQUERIES: u32 = 1;
pub const QTW_IGNORE_CTE_SUBQUERIES: u32 = 2;
pub const QTW_IGNORE_RC_SUBQUERIES: u32 = 3;
pub const QTW_IGNORE_JOINALIASES: u32 = 4;
pub const QTW_IGNORE_RANGE_TABLE: u32 = 8;
pub const QTW_EXAMINE_RTES: u32 = 16;
pub const QTW_DONT_COPY_QUERY: u32 = 32;
pub const QTW_EXAMINE_SORTGROUP: u32 = 128;
pub const DEFAULT_SEQ_PAGE_COST: f64 = 1.0;
pub const DEFAULT_RANDOM_PAGE_COST: f64 = 4.0;
pub const DEFAULT_CPU_TUPLE_COST: f64 = 0.01;
pub const DEFAULT_CPU_INDEX_TUPLE_COST: f64 = 0.005;
pub const DEFAULT_CPU_OPERATOR_COST: f64 = 0.0025;
pub const DEFAULT_PARALLEL_TUPLE_COST: f64 = 0.1;
pub const DEFAULT_PARALLEL_SETUP_COST: f64 = 1000.0;
pub const DEFAULT_EFFECTIVE_CACHE_SIZE: u32 = 524288;
pub const DEFAULT_CURSOR_TUPLE_FRACTION: f64 = 0.1;
pub const OLD_SNAPSHOT_PADDING_ENTRIES: u32 = 10;
pub const MAX_IO_CONCURRENCY: u32 = 1000;
pub const BUFFER_LOCK_UNLOCK: u32 = 0;
pub const BUFFER_LOCK_SHARE: u32 = 1;
pub const BUFFER_LOCK_EXCLUSIVE: u32 = 2;
pub const XLOG_STANDBY_LOCK: u32 = 0;
pub const XLOG_RUNNING_XACTS: u32 = 16;
pub const XLOG_INVALIDATIONS: u32 = 32;
pub const PROCARRAY_VACUUM_FLAG: u32 = 2;
pub const PROCARRAY_ANALYZE_FLAG: u32 = 4;
pub const PROCARRAY_LOGICAL_DECODING_FLAG: u32 = 16;
pub const PROCARRAY_SLOTS_XMIN: u32 = 32;
pub const PROCARRAY_PROC_FLAGS_MASK: u32 = 22;
pub const PROCARRAY_FLAGS_DEFAULT: u32 = 16;
pub const PROCARRAY_FLAGS_VACUUM: u32 = 18;
pub const PROCARRAY_FLAGS_ANALYZE: u32 = 20;
pub const PROCARRAY_FLAGS_VACUUM_ANALYZE: u32 = 22;
pub const MAX_KILOBYTES: u32 = 2147483647;
pub const PG_AUTOCONF_FILENAME: &'static [u8; 21usize] = b"postgresql.auto.conf\0";
pub const GUC_QUALIFIER_SEPARATOR: u8 = 46u8;
pub const GUC_LIST_INPUT: u32 = 1;
pub const GUC_LIST_QUOTE: u32 = 2;
pub const GUC_NO_SHOW_ALL: u32 = 4;
pub const GUC_NO_RESET_ALL: u32 = 8;
pub const GUC_REPORT: u32 = 16;
pub const GUC_NOT_IN_SAMPLE: u32 = 32;
pub const GUC_DISALLOW_IN_FILE: u32 = 64;
pub const GUC_CUSTOM_PLACEHOLDER: u32 = 128;
pub const GUC_SUPERUSER_ONLY: u32 = 256;
pub const GUC_IS_NAME: u32 = 512;
pub const GUC_NOT_WHILE_SEC_REST: u32 = 1024;
pub const GUC_DISALLOW_IN_AUTO_FILE: u32 = 2048;
pub const GUC_UNIT_KB: u32 = 4096;
pub const GUC_UNIT_BLOCKS: u32 = 8192;
pub const GUC_UNIT_XBLOCKS: u32 = 12288;
pub const GUC_UNIT_MB: u32 = 16384;
pub const GUC_UNIT_MEMORY: u32 = 61440;
pub const GUC_UNIT_MS: u32 = 65536;
pub const GUC_UNIT_S: u32 = 131072;
pub const GUC_UNIT_MIN: u32 = 196608;
pub const GUC_UNIT_TIME: u32 = 983040;
pub const GUC_UNIT: u32 = 1044480;
pub const STACK_DEPTH_SLOP: u32 = 524288;
pub const FP_SUPERNORMAL: u32 = 6;
pub const FP_ILOGB0: i32 = -2147483648;
pub const FP_ILOGBNAN: i32 = -2147483648;
pub const MATH_ERRNO: u32 = 1;
pub const MATH_ERREXCEPT: u32 = 2;
pub const M_E: f64 = 2.718281828459045;
pub const M_LOG2E: f64 = 1.4426950408889634;
pub const M_LOG10E: f64 = 0.4342944819032518;
pub const M_LN2: f64 = 0.6931471805599453;
pub const M_LN10: f64 = 2.302585092994046;
pub const M_PI: f64 = 3.141592653589793;
pub const M_PI_2: f64 = 1.5707963267948966;
pub const M_PI_4: f64 = 0.7853981633974483;
pub const M_1_PI: f64 = 0.3183098861837907;
pub const M_2_PI: f64 = 0.6366197723675814;
pub const M_2_SQRTPI: f64 = 1.1283791670955126;
pub const M_SQRT2: f64 = 1.4142135623730951;
pub const M_SQRT1_2: f64 = 0.7071067811865476;
pub const DOMAIN: u32 = 1;
pub const SING: u32 = 2;
pub const OVERFLOW: u32 = 3;
pub const UNDERFLOW: u32 = 4;
pub const TLOSS: u32 = 5;
pub const PLOSS: u32 = 6;
pub const MAX_TIME_PRECISION: u32 = 6;
pub const NUMERIC_MAX_PRECISION: u32 = 1000;
pub const NUMERIC_MAX_DISPLAY_SCALE: u32 = 1000;
pub const NUMERIC_MIN_DISPLAY_SCALE: u32 = 0;
pub const NUMERIC_MAX_RESULT_SCALE: u32 = 2000;
pub const NUMERIC_MIN_SIG_DIGITS: u32 = 16;
pub const JsonbContainsStrategyNumber: u32 = 7;
pub const JsonbExistsStrategyNumber: u32 = 9;
pub const JsonbExistsAnyStrategyNumber: u32 = 10;
pub const JsonbExistsAllStrategyNumber: u32 = 11;
pub const JGINFLAG_KEY: u32 = 1;
pub const JGINFLAG_NULL: u32 = 2;
pub const JGINFLAG_BOOL: u32 = 3;
pub const JGINFLAG_NUM: u32 = 4;
pub const JGINFLAG_STR: u32 = 5;
pub const JGINFLAG_HASHED: u32 = 16;
pub const JGIN_MAXLENGTH: u32 = 125;
pub const JENTRY_OFFLENMASK: u32 = 268435455;
pub const JENTRY_TYPEMASK: u32 = 1879048192;
pub const JENTRY_HAS_OFF: u32 = 2147483648;
pub const JENTRY_ISSTRING: u32 = 0;
pub const JENTRY_ISNUMERIC: u32 = 268435456;
pub const JENTRY_ISBOOL_FALSE: u32 = 536870912;
pub const JENTRY_ISBOOL_TRUE: u32 = 805306368;
pub const JENTRY_ISNULL: u32 = 1073741824;
pub const JENTRY_ISCONTAINER: u32 = 1342177280;
pub const JB_OFFSET_STRIDE: u32 = 32;
pub const JB_CMASK: u32 = 268435455;
pub const JB_FSCALAR: u32 = 268435456;
pub const JB_FOBJECT: u32 = 536870912;
pub const JB_FARRAY: u32 = 1073741824;
pub const ATTSTATSSLOT_VALUES: u32 = 1;
pub const ATTSTATSSLOT_NUMBERS: u32 = 2;
pub const MaxAllocHugeSize: u32 = 0;
pub const ALLOCSET_DEFAULT_MINSIZE: u32 = 0;
pub const ALLOCSET_DEFAULT_INITSIZE: u32 = 8192;
pub const ALLOCSET_DEFAULT_MAXSIZE: u32 = 8388608;
pub const ALLOCSET_SMALL_MINSIZE: u32 = 0;
pub const ALLOCSET_SMALL_INITSIZE: u32 = 1024;
pub const ALLOCSET_SMALL_MAXSIZE: u32 = 8192;
pub const ALLOCSET_SEPARATE_THRESHOLD: u32 = 8192;
pub const SLAB_DEFAULT_BLOCK_SIZE: u32 = 8192;
pub const SLAB_LARGE_BLOCK_SIZE: u32 = 8388608;
pub const DEFAULT_EQ_SEL: f64 = 0.005;
pub const DEFAULT_INEQ_SEL: f64 = 0.3333333333333333;
pub const DEFAULT_RANGE_INEQ_SEL: f64 = 0.005;
pub const DEFAULT_MATCH_SEL: f64 = 0.005;
pub const DEFAULT_NUM_DISTINCT: u32 = 200;
pub const DEFAULT_UNK_SEL: f64 = 0.005;
pub const DEFAULT_NOT_UNK_SEL: f64 = 0.995;
pub const TYPECACHE_EQ_OPR: u32 = 1;
pub const TYPECACHE_LT_OPR: u32 = 2;
pub const TYPECACHE_GT_OPR: u32 = 4;
pub const TYPECACHE_CMP_PROC: u32 = 8;
pub const TYPECACHE_HASH_PROC: u32 = 16;
pub const TYPECACHE_EQ_OPR_FINFO: u32 = 32;
pub const TYPECACHE_CMP_PROC_FINFO: u32 = 64;
pub const TYPECACHE_HASH_PROC_FINFO: u32 = 128;
pub const TYPECACHE_TUPDESC: u32 = 256;
pub const TYPECACHE_BTREE_OPFAMILY: u32 = 512;
pub const TYPECACHE_HASH_OPFAMILY: u32 = 1024;
pub const TYPECACHE_RANGE_INFO: u32 = 2048;
pub const TYPECACHE_DOMAIN_INFO: u32 = 4096;
pub type Oid = ::std::os::raw::c_uint;
pub type pg_int64 = ::std::os::raw::c_long;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
}
impl Default for __mbstate_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
impl Default for __darwin_pthread_handler_rec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
impl Default for _opaque_pthread_attr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
impl Default for _opaque_pthread_cond_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
impl Default for _opaque_pthread_mutex_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
impl Default for _opaque_pthread_rwlock_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
impl Default for _opaque_pthread_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
pub type va_list = __darwin_va_list;
#[pg_guard]
extern "C" {
    pub fn renameat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn renamex_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn renameatx_np(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
pub type fpos_t = __darwin_off_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sbuf {
    pub _base: *mut ::std::os::raw::c_uchar,
    pub _size: ::std::os::raw::c_int,
}
impl Default for __sbuf {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILEX {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILE {
    pub _p: *mut ::std::os::raw::c_uchar,
    pub _r: ::std::os::raw::c_int,
    pub _w: ::std::os::raw::c_int,
    pub _flags: ::std::os::raw::c_short,
    pub _file: ::std::os::raw::c_short,
    pub _bf: __sbuf,
    pub _lbfsize: ::std::os::raw::c_int,
    pub _cookie: *mut ::std::os::raw::c_void,
    pub _close: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub _read: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _seek: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: fpos_t,
            arg3: ::std::os::raw::c_int,
        ) -> fpos_t,
    >,
    pub _write: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _ub: __sbuf,
    pub _extra: *mut __sFILEX,
    pub _ur: ::std::os::raw::c_int,
    pub _ubuf: [::std::os::raw::c_uchar; 3usize],
    pub _nbuf: [::std::os::raw::c_uchar; 1usize],
    pub _lb: __sbuf,
    pub _blksize: ::std::os::raw::c_int,
    pub _offset: fpos_t,
}
impl Default for __sFILE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type FILE = __sFILE;
#[pg_guard]
extern "C" {
    pub static mut __stdinp: *mut FILE;
}
#[pg_guard]
extern "C" {
    pub static mut __stdoutp: *mut FILE;
}
#[pg_guard]
extern "C" {
    pub static mut __stderrp: *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn clearerr(arg1: *mut FILE);
}
#[pg_guard]
extern "C" {
    pub fn fclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn feof(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ferror(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fflush(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fgetc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fgetpos(arg1: *mut FILE, arg2: *mut fpos_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fgets(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn fprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fputc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fputs(arg1: *const ::std::os::raw::c_char, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __nitems: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
#[pg_guard]
extern "C" {
    pub fn freopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut FILE,
    ) -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn fscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fseek(
        arg1: *mut FILE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fsetpos(arg1: *mut FILE, arg2: *const fpos_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ftell(arg1: *mut FILE) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __nitems: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
#[pg_guard]
extern "C" {
    pub fn getc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn gets(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn perror(arg1: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn printf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn putc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn putchar(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn puts(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn remove(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn rewind(arg1: *mut FILE);
}
#[pg_guard]
extern "C" {
    pub fn scanf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn setbuf(arg1: *mut FILE, arg2: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn setvbuf(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: usize,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sscanf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn tmpnam(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn ungetc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn vfprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn vprintf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn vsprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ctermid(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn fdopen(arg1: ::std::os::raw::c_int, arg2: *const ::std::os::raw::c_char) -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn fileno(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn popen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn __srget(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn __svfscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn __swbuf(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn flockfile(arg1: *mut FILE);
}
#[pg_guard]
extern "C" {
    pub fn ftrylockfile(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn funlockfile(arg1: *mut FILE);
}
#[pg_guard]
extern "C" {
    pub fn getc_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn putc_unlocked(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn putchar_unlocked(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getw(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn putw(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __prefix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type off_t = __darwin_off_t;
#[pg_guard]
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __offset: off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> off_t;
}
#[pg_guard]
extern "C" {
    pub fn snprintf(
        __str: *mut ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn vfscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn vsnprintf(
        __str: *mut ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn vsscanf(
        __str: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn dprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn vdprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getdelim(
        __linep: *mut *mut ::std::os::raw::c_char,
        __linecapp: *mut usize,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> isize;
}
#[pg_guard]
extern "C" {
    pub fn getline(
        __linep: *mut *mut ::std::os::raw::c_char,
        __linecapp: *mut usize,
        __stream: *mut FILE,
    ) -> isize;
}
#[pg_guard]
extern "C" {
    pub fn fmemopen(
        __buf: *mut ::std::os::raw::c_void,
        __size: usize,
        __mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn open_memstream(
        __bufp: *mut *mut ::std::os::raw::c_char,
        __sizep: *mut usize,
    ) -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub static sys_nerr: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
#[pg_guard]
extern "C" {
    pub fn asprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ctermid_r(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn fgetln(arg1: *mut FILE, arg2: *mut usize) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn fmtcheck(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn fpurge(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn setbuffer(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn setlinebuf(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn vasprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn zopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn funopen(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: fpos_t,
                arg3: ::std::os::raw::c_int,
            ) -> fpos_t,
        >,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
        >,
    ) -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn __sprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: usize,
        arg4: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn __snprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: usize,
        arg3: ::std::os::raw::c_int,
        arg4: usize,
        arg5: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn __vsprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: usize,
        arg4: *const ::std::os::raw::c_char,
        arg5: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn __vsnprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: usize,
        arg3: ::std::os::raw::c_int,
        arg4: usize,
        arg5: *const ::std::os::raw::c_char,
        arg6: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = ::std::os::raw::c_uint;
pub type pid_t = __darwin_pid_t;
pub type id_t = __darwin_id_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_i386_thread_state {
    pub __eax: ::std::os::raw::c_uint,
    pub __ebx: ::std::os::raw::c_uint,
    pub __ecx: ::std::os::raw::c_uint,
    pub __edx: ::std::os::raw::c_uint,
    pub __edi: ::std::os::raw::c_uint,
    pub __esi: ::std::os::raw::c_uint,
    pub __ebp: ::std::os::raw::c_uint,
    pub __esp: ::std::os::raw::c_uint,
    pub __ss: ::std::os::raw::c_uint,
    pub __eflags: ::std::os::raw::c_uint,
    pub __eip: ::std::os::raw::c_uint,
    pub __cs: ::std::os::raw::c_uint,
    pub __ds: ::std::os::raw::c_uint,
    pub __es: ::std::os::raw::c_uint,
    pub __fs: ::std::os::raw::c_uint,
    pub __gs: ::std::os::raw::c_uint,
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_fp_control {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
impl __darwin_fp_control {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __pc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___pc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn __rc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___rc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __pc: ::std::os::raw::c_ushort,
        __rc: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let __pc: u16 = unsafe { ::std::mem::transmute(__pc) };
            __pc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let __rc: u16 = unsafe { ::std::mem::transmute(__rc) };
            __rc as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_control_t = __darwin_fp_control;
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_fp_status {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
impl __darwin_fp_status {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __stkflt(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___stkflt(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __errsumm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___errsumm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c0(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c0(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c1(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c1(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c2(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c2(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tos(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set___tos(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn __c3(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c3(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __busy(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___busy(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __stkflt: ::std::os::raw::c_ushort,
        __errsumm: ::std::os::raw::c_ushort,
        __c0: ::std::os::raw::c_ushort,
        __c1: ::std::os::raw::c_ushort,
        __c2: ::std::os::raw::c_ushort,
        __tos: ::std::os::raw::c_ushort,
        __c3: ::std::os::raw::c_ushort,
        __busy: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let __stkflt: u16 = unsafe { ::std::mem::transmute(__stkflt) };
            __stkflt as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __errsumm: u16 = unsafe { ::std::mem::transmute(__errsumm) };
            __errsumm as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let __c0: u16 = unsafe { ::std::mem::transmute(__c0) };
            __c0 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let __c1: u16 = unsafe { ::std::mem::transmute(__c1) };
            __c1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let __c2: u16 = unsafe { ::std::mem::transmute(__c2) };
            __c2 as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let __tos: u16 = unsafe { ::std::mem::transmute(__tos) };
            __tos as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let __c3: u16 = unsafe { ::std::mem::transmute(__c3) };
            __c3 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let __busy: u16 = unsafe { ::std::mem::transmute(__busy) };
            __busy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_status_t = __darwin_fp_status;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_mmst_reg {
    pub __mmst_reg: [::std::os::raw::c_char; 10usize],
    pub __mmst_rsrv: [::std::os::raw::c_char; 6usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_xmm_reg {
    pub __xmm_reg: [::std::os::raw::c_char; 16usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_ymm_reg {
    pub __ymm_reg: [::std::os::raw::c_char; 32usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_zmm_reg {
    pub __zmm_reg: [::std::os::raw::c_char; 64usize],
}
impl Default for __darwin_zmm_reg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_opmask_reg {
    pub __opmask_reg: [::std::os::raw::c_char; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_float_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
impl Default for __darwin_i386_float_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
}
impl Default for __darwin_i386_avx_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx512_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
}
impl Default for __darwin_i386_avx512_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_i386_exception_state {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_debug_state32 {
    pub __dr0: ::std::os::raw::c_uint,
    pub __dr1: ::std::os::raw::c_uint,
    pub __dr2: ::std::os::raw::c_uint,
    pub __dr3: ::std::os::raw::c_uint,
    pub __dr4: ::std::os::raw::c_uint,
    pub __dr5: ::std::os::raw::c_uint,
    pub __dr6: ::std::os::raw::c_uint,
    pub __dr7: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_instruction_state {
    pub __insn_stream_valid_bytes: ::std::os::raw::c_int,
    pub __insn_offset: ::std::os::raw::c_int,
    pub __out_of_synch: ::std::os::raw::c_int,
    pub __insn_bytes: [__uint8_t; 2380usize],
    pub __insn_cacheline: [__uint8_t; 64usize],
}
impl Default for __x86_instruction_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __last_branch_record {
    pub __from_ip: __uint64_t,
    pub __to_ip: __uint64_t,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u32,
}
impl __last_branch_record {
    #[inline]
    pub fn __mispredict(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___mispredict(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tsx_abort(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___tsx_abort(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __in_tsx(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___in_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __cycle_count(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set___cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 13u8) as u32) }
    }
    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 13u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __mispredict: __uint32_t,
        __tsx_abort: __uint32_t,
        __in_tsx: __uint32_t,
        __cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __mispredict: u32 = unsafe { ::std::mem::transmute(__mispredict) };
            __mispredict as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __tsx_abort: u32 = unsafe { ::std::mem::transmute(__tsx_abort) };
            __tsx_abort as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __in_tsx: u32 = unsafe { ::std::mem::transmute(__in_tsx) };
            __in_tsx as u64
        });
        __bindgen_bitfield_unit.set(3usize, 16u8, {
            let __cycle_count: u32 = unsafe { ::std::mem::transmute(__cycle_count) };
            __cycle_count as u64
        });
        __bindgen_bitfield_unit.set(19usize, 13u8, {
            let __reserved: u32 = unsafe { ::std::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __last_branch_state {
    pub __lbr_count: ::std::os::raw::c_int,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __lbrs: [__last_branch_record; 32usize],
}
impl __last_branch_state {
    #[inline]
    pub fn __lbr_supported_tsx(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___lbr_supported_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __lbr_supported_cycle_count(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___lbr_supported_cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __lbr_supported_tsx: __uint32_t,
        __lbr_supported_cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __lbr_supported_tsx: u32 = unsafe { ::std::mem::transmute(__lbr_supported_tsx) };
            __lbr_supported_tsx as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __lbr_supported_cycle_count: u32 =
                unsafe { ::std::mem::transmute(__lbr_supported_cycle_count) };
            __lbr_supported_cycle_count as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let __reserved: u32 = unsafe { ::std::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __x86_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_thread_full_state64 {
    pub __ss64: __darwin_x86_thread_state64,
    pub __ds: __uint64_t,
    pub __es: __uint64_t,
    pub __ss: __uint64_t,
    pub __gsbase: __uint64_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_float_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
impl Default for __darwin_x86_float_state64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
}
impl Default for __darwin_x86_avx_state64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx512_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
    pub __fpu_zmmh8: __darwin_ymm_reg,
    pub __fpu_zmmh9: __darwin_ymm_reg,
    pub __fpu_zmmh10: __darwin_ymm_reg,
    pub __fpu_zmmh11: __darwin_ymm_reg,
    pub __fpu_zmmh12: __darwin_ymm_reg,
    pub __fpu_zmmh13: __darwin_ymm_reg,
    pub __fpu_zmmh14: __darwin_ymm_reg,
    pub __fpu_zmmh15: __darwin_ymm_reg,
    pub __fpu_zmm16: __darwin_zmm_reg,
    pub __fpu_zmm17: __darwin_zmm_reg,
    pub __fpu_zmm18: __darwin_zmm_reg,
    pub __fpu_zmm19: __darwin_zmm_reg,
    pub __fpu_zmm20: __darwin_zmm_reg,
    pub __fpu_zmm21: __darwin_zmm_reg,
    pub __fpu_zmm22: __darwin_zmm_reg,
    pub __fpu_zmm23: __darwin_zmm_reg,
    pub __fpu_zmm24: __darwin_zmm_reg,
    pub __fpu_zmm25: __darwin_zmm_reg,
    pub __fpu_zmm26: __darwin_zmm_reg,
    pub __fpu_zmm27: __darwin_zmm_reg,
    pub __fpu_zmm28: __darwin_zmm_reg,
    pub __fpu_zmm29: __darwin_zmm_reg,
    pub __fpu_zmm30: __darwin_zmm_reg,
    pub __fpu_zmm31: __darwin_zmm_reg,
}
impl Default for __darwin_x86_avx512_state64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_exception_state64 {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint64_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_debug_state64 {
    pub __dr0: __uint64_t,
    pub __dr1: __uint64_t,
    pub __dr2: __uint64_t,
    pub __dr3: __uint64_t,
    pub __dr4: __uint64_t,
    pub __dr5: __uint64_t,
    pub __dr6: __uint64_t,
    pub __dr7: __uint64_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_float_state,
}
impl Default for __darwin_mcontext32 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx_state,
}
impl Default for __darwin_mcontext_avx32 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx512_state,
}
impl Default for __darwin_mcontext_avx512_32 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_float_state64,
}
impl Default for __darwin_mcontext64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_float_state64,
}
impl Default for __darwin_mcontext64_full {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx_state64,
}
impl Default for __darwin_mcontext_avx64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx_state64,
}
impl Default for __darwin_mcontext_avx64_full {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
impl Default for __darwin_mcontext_avx512_64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
impl Default for __darwin_mcontext_avx512_64_full {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type mcontext_t = *mut __darwin_mcontext64;
pub type pthread_attr_t = __darwin_pthread_attr_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
impl Default for __darwin_sigaltstack {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
impl Default for __darwin_ucontext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
pub type uid_t = __darwin_uid_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
impl Default for sigval {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
impl Default for sigevent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
impl Default for __siginfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut __siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
impl Default for __sigaction_u {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
impl Default for __sigaction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
impl Default for sigaction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
impl Default for sigstack {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
pub type rlim_t = __uint64_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage {
    pub ru_utime: timeval,
    pub ru_stime: timeval,
    pub ru_maxrss: ::std::os::raw::c_long,
    pub ru_ixrss: ::std::os::raw::c_long,
    pub ru_idrss: ::std::os::raw::c_long,
    pub ru_isrss: ::std::os::raw::c_long,
    pub ru_minflt: ::std::os::raw::c_long,
    pub ru_majflt: ::std::os::raw::c_long,
    pub ru_nswap: ::std::os::raw::c_long,
    pub ru_inblock: ::std::os::raw::c_long,
    pub ru_oublock: ::std::os::raw::c_long,
    pub ru_msgsnd: ::std::os::raw::c_long,
    pub ru_msgrcv: ::std::os::raw::c_long,
    pub ru_nsignals: ::std::os::raw::c_long,
    pub ru_nvcsw: ::std::os::raw::c_long,
    pub ru_nivcsw: ::std::os::raw::c_long,
}
pub type rusage_info_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v0 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v1 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v2 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v3 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v4 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v5 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
    pub ri_flags: u64,
}
pub type rusage_info_current = rusage_info_v5;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rlimit {
    pub rlim_cur: rlim_t,
    pub rlim_max: rlim_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proc_rlimit_control_wakeupmon {
    pub wm_flags: u32,
    pub wm_rate: i32,
}
#[pg_guard]
extern "C" {
    pub fn getpriority(arg1: ::std::os::raw::c_int, arg2: id_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getrlimit(arg1: ::std::os::raw::c_int, arg2: *mut rlimit) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getrusage(arg1: ::std::os::raw::c_int, arg2: *mut rusage) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn setpriority(
        arg1: ::std::os::raw::c_int,
        arg2: id_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn setiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn setrlimit(arg1: ::std::os::raw::c_int, arg2: *const rlimit) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub w_T: wait__bindgen_ty_1,
    pub w_S: wait__bindgen_ty_2,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn w_Termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_w_Termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_w_Coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Termsig: ::std::os::raw::c_uint,
        w_Coredump: ::std::os::raw::c_uint,
        w_Retcode: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let w_Termsig: u32 = unsafe { ::std::mem::transmute(w_Termsig) };
            w_Termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let w_Coredump: u32 = unsafe { ::std::mem::transmute(w_Coredump) };
            w_Coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Retcode: u32 = unsafe { ::std::mem::transmute(w_Retcode) };
            w_Retcode as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn w_Stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Stopval: ::std::os::raw::c_uint,
        w_Stopsig: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let w_Stopval: u32 = unsafe { ::std::mem::transmute(w_Stopval) };
            w_Stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Stopsig: u32 = unsafe { ::std::mem::transmute(w_Stopsig) };
            w_Stopsig as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for wait {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn wait(arg1: *mut ::std::os::raw::c_int) -> pid_t;
}
#[pg_guard]
extern "C" {
    pub fn waitpid(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> pid_t;
}
#[pg_guard]
extern "C" {
    pub fn waitid(
        arg1: idtype_t,
        arg2: id_t,
        arg3: *mut siginfo_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn wait3(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *mut rusage,
    ) -> pid_t;
}
#[pg_guard]
extern "C" {
    pub fn wait4(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut rusage,
    ) -> pid_t;
}
#[pg_guard]
extern "C" {
    pub fn alloca(arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
pub type ct_rune_t = __darwin_ct_rune_t;
pub type rune_t = __darwin_rune_t;
pub type wchar_t = __darwin_wchar_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[pg_guard]
extern "C" {
    pub static mut __mb_cur_max: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn calloc(
        __count: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn free(arg1: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn valloc(arg1: usize) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn aligned_alloc(__alignment: usize, __size: usize) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: usize,
        __size: usize,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn abort();
}
#[pg_guard]
extern "C" {
    pub fn abs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn atexit(arg1: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn atof(arg1: *const ::std::os::raw::c_char) -> f64;
}
#[pg_guard]
extern "C" {
    pub fn atoi(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn atol(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn atoll(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
#[pg_guard]
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn div(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> div_t;
}
#[pg_guard]
extern "C" {
    pub fn exit(arg1: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn getenv(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn labs(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn ldiv(arg1: ::std::os::raw::c_long, arg2: ::std::os::raw::c_long) -> ldiv_t;
}
#[pg_guard]
extern "C" {
    pub fn llabs(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
#[pg_guard]
extern "C" {
    pub fn lldiv(arg1: ::std::os::raw::c_longlong, arg2: ::std::os::raw::c_longlong) -> lldiv_t;
}
#[pg_guard]
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: usize) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn mbstowcs(arg1: *mut wchar_t, arg2: *const ::std::os::raw::c_char, arg3: usize) -> usize;
}
#[pg_guard]
extern "C" {
    pub fn mbtowc(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: usize,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
#[pg_guard]
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn srand(arg1: ::std::os::raw::c_uint);
}
#[pg_guard]
extern "C" {
    pub fn strtod(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
#[pg_guard]
extern "C" {
    pub fn strtof(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
#[pg_guard]
extern "C" {
    pub fn strtol(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn strtold(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
#[pg_guard]
extern "C" {
    pub fn strtoll(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
#[pg_guard]
extern "C" {
    pub fn strtoul(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
#[pg_guard]
extern "C" {
    pub fn strtoull(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
#[pg_guard]
extern "C" {
    pub fn system(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn wcstombs(arg1: *mut ::std::os::raw::c_char, arg2: *const wchar_t, arg3: usize) -> usize;
}
#[pg_guard]
extern "C" {
    pub fn wctomb(arg1: *mut ::std::os::raw::c_char, arg2: wchar_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn _Exit(arg1: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn a64l(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn drand48() -> f64;
}
#[pg_guard]
extern "C" {
    pub fn ecvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn erand48(arg1: *mut ::std::os::raw::c_ushort) -> f64;
}
#[pg_guard]
extern "C" {
    pub fn fcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn gcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn getsubopt(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn grantpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn initstate(
        arg1: ::std::os::raw::c_uint,
        arg2: *mut ::std::os::raw::c_char,
        arg3: usize,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn jrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn l64a(arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn lcong48(arg1: *mut ::std::os::raw::c_ushort);
}
#[pg_guard]
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn mktemp(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn mkstemp(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn nrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn posix_openpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ptsname(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn ptsname_r(
        fildes: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_char,
        buflen: usize,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn putenv(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn rand_r(arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_realpath$DARWIN_EXTSN"]
    pub fn realpath(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn seed48(arg1: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
#[pg_guard]
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __overwrite: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn setkey(arg1: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn setstate(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn srand48(arg1: ::std::os::raw::c_long);
}
#[pg_guard]
extern "C" {
    pub fn srandom(arg1: ::std::os::raw::c_uint);
}
#[pg_guard]
extern "C" {
    pub fn unlockpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn unsetenv(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
pub type dev_t = __darwin_dev_t;
pub type mode_t = __darwin_mode_t;
#[pg_guard]
extern "C" {
    pub fn arc4random() -> u32;
}
#[pg_guard]
extern "C" {
    pub fn arc4random_addrandom(arg1: *mut ::std::os::raw::c_uchar, arg2: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn arc4random_buf(__buf: *mut ::std::os::raw::c_void, __nbytes: usize);
}
#[pg_guard]
extern "C" {
    pub fn arc4random_stir();
}
#[pg_guard]
extern "C" {
    pub fn arc4random_uniform(__upper_bound: u32) -> u32;
}
#[pg_guard]
extern "C" {
    pub fn atexit_b(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn bsearch_b(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn cgetcap(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn cgetclose() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn cgetent(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn cgetfirst(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn cgetmatch(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn cgetnext(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn cgetnum(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn cgetset(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn cgetstr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn cgetustr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_daemon$1050"]
    pub fn daemon(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn devname(arg1: dev_t, arg2: mode_t) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn devname_r(
        arg1: dev_t,
        arg2: mode_t,
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn getbsize(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn getloadavg(arg1: *mut f64, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getprogname() -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn setprogname(arg1: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn heapsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn heapsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn mergesort(
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn mergesort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn psort(
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
#[pg_guard]
extern "C" {
    pub fn psort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: *mut ::std::os::raw::c_void,
    );
}
#[pg_guard]
extern "C" {
    pub fn psort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
#[pg_guard]
extern "C" {
    pub fn qsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        __compar: *mut ::std::os::raw::c_void,
    );
}
#[pg_guard]
extern "C" {
    pub fn qsort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: usize,
        __width: usize,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
#[pg_guard]
extern "C" {
    pub fn radixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn rpmatch(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sradixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sranddev();
}
#[pg_guard]
extern "C" {
    pub fn srandomdev();
}
#[pg_guard]
extern "C" {
    pub fn reallocf(
        __ptr: *mut ::std::os::raw::c_void,
        __size: usize,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn strtonum(
        __numstr: *const ::std::os::raw::c_char,
        __minval: ::std::os::raw::c_longlong,
        __maxval: ::std::os::raw::c_longlong,
        __errstrp: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_longlong;
}
#[pg_guard]
extern "C" {
    pub fn strtoq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
#[pg_guard]
extern "C" {
    pub fn strtouq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
#[pg_guard]
extern "C" {
    pub static mut suboptarg: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn memcpy(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn memmove(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn memset(
        __b: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn strcat(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn strcpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
#[pg_guard]
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
#[pg_guard]
extern "C" {
    pub fn strncat(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn strncpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
#[pg_guard]
extern "C" {
    pub fn strstr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strtok(
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strxfrm(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[pg_guard]
extern "C" {
    pub fn strtok_r(
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
        __lasts: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __strerrbuf: *mut ::std::os::raw::c_char,
        __buflen: usize,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn strdup(__s1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn memccpy(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn stpcpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn stpncpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strndup(
        __s1: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strnlen(__s1: *const ::std::os::raw::c_char, __n: usize) -> usize;
}
#[pg_guard]
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
pub type rsize_t = __darwin_size_t;
pub type errno_t = ::std::os::raw::c_int;
#[pg_guard]
extern "C" {
    pub fn memset_s(
        __s: *mut ::std::os::raw::c_void,
        __smax: rsize_t,
        __c: ::std::os::raw::c_int,
        __n: rsize_t,
    ) -> errno_t;
}
#[pg_guard]
extern "C" {
    pub fn memmem(
        __big: *const ::std::os::raw::c_void,
        __big_len: usize,
        __little: *const ::std::os::raw::c_void,
        __little_len: usize,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn memset_pattern4(
        __b: *mut ::std::os::raw::c_void,
        __pattern4: *const ::std::os::raw::c_void,
        __len: usize,
    );
}
#[pg_guard]
extern "C" {
    pub fn memset_pattern8(
        __b: *mut ::std::os::raw::c_void,
        __pattern8: *const ::std::os::raw::c_void,
        __len: usize,
    );
}
#[pg_guard]
extern "C" {
    pub fn memset_pattern16(
        __b: *mut ::std::os::raw::c_void,
        __pattern16: *const ::std::os::raw::c_void,
        __len: usize,
    );
}
#[pg_guard]
extern "C" {
    pub fn strcasestr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strnstr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
        __len: usize,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strlcat(
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[pg_guard]
extern "C" {
    pub fn strlcpy(
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[pg_guard]
extern "C" {
    pub fn strmode(__mode: ::std::os::raw::c_int, __bp: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn swab(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: isize,
    );
}
#[pg_guard]
extern "C" {
    pub fn timingsafe_bcmp(
        __b1: *const ::std::os::raw::c_void,
        __b2: *const ::std::os::raw::c_void,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn strsignal_r(
        __sig: ::std::os::raw::c_int,
        __strsignalbuf: *mut ::std::os::raw::c_char,
        __buflen: usize,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn bcmp(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn bcopy(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: usize,
    );
}
#[pg_guard]
extern "C" {
    pub fn bzero(arg1: *mut ::std::os::raw::c_void, arg2: ::std::os::raw::c_ulong);
}
#[pg_guard]
extern "C" {
    pub fn index(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn rindex(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn ffs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn strcasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn strncasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ffsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ffsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fls(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn flsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn flsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
pub type max_align_t = u128;
pub type __gnuc_va_list = __builtin_va_list;
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_quad_t = u_int64_t;
pub type quad_t = i64;
pub type qaddr_t = *mut quad_t;
pub type caddr_t = *mut ::std::os::raw::c_char;
pub type daddr_t = i32;
pub type fixpt_t = u_int32_t;
pub type blkcnt_t = __darwin_blkcnt_t;
pub type blksize_t = __darwin_blksize_t;
pub type gid_t = __darwin_gid_t;
pub type in_addr_t = __uint32_t;
pub type in_port_t = __uint16_t;
pub type ino_t = __darwin_ino_t;
pub type ino64_t = __darwin_ino64_t;
pub type key_t = __int32_t;
pub type nlink_t = __uint16_t;
pub type segsz_t = i32;
pub type swblk_t = i32;
pub type clock_t = __darwin_clock_t;
pub type time_t = __darwin_time_t;
pub type useconds_t = __darwin_useconds_t;
pub type suseconds_t = __darwin_suseconds_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fd_set {
    pub fds_bits: [__int32_t; 32usize],
}
#[pg_guard]
extern "C" {
    pub fn __darwin_check_fd_set_overflow(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type fd_mask = __int32_t;
pub type pthread_cond_t = __darwin_pthread_cond_t;
pub type pthread_condattr_t = __darwin_pthread_condattr_t;
pub type pthread_mutex_t = __darwin_pthread_mutex_t;
pub type pthread_mutexattr_t = __darwin_pthread_mutexattr_t;
pub type pthread_once_t = __darwin_pthread_once_t;
pub type pthread_rwlock_t = __darwin_pthread_rwlock_t;
pub type pthread_rwlockattr_t = __darwin_pthread_rwlockattr_t;
pub type pthread_t = __darwin_pthread_t;
pub type pthread_key_t = __darwin_pthread_key_t;
pub type fsblkcnt_t = __darwin_fsblkcnt_t;
pub type fsfilcnt_t = __darwin_fsfilcnt_t;
#[pg_guard]
extern "C" {
    pub fn __error() -> *mut ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lconv {
    pub decimal_point: *mut ::std::os::raw::c_char,
    pub thousands_sep: *mut ::std::os::raw::c_char,
    pub grouping: *mut ::std::os::raw::c_char,
    pub int_curr_symbol: *mut ::std::os::raw::c_char,
    pub currency_symbol: *mut ::std::os::raw::c_char,
    pub mon_decimal_point: *mut ::std::os::raw::c_char,
    pub mon_thousands_sep: *mut ::std::os::raw::c_char,
    pub mon_grouping: *mut ::std::os::raw::c_char,
    pub positive_sign: *mut ::std::os::raw::c_char,
    pub negative_sign: *mut ::std::os::raw::c_char,
    pub int_frac_digits: ::std::os::raw::c_char,
    pub frac_digits: ::std::os::raw::c_char,
    pub p_cs_precedes: ::std::os::raw::c_char,
    pub p_sep_by_space: ::std::os::raw::c_char,
    pub n_cs_precedes: ::std::os::raw::c_char,
    pub n_sep_by_space: ::std::os::raw::c_char,
    pub p_sign_posn: ::std::os::raw::c_char,
    pub n_sign_posn: ::std::os::raw::c_char,
    pub int_p_cs_precedes: ::std::os::raw::c_char,
    pub int_n_cs_precedes: ::std::os::raw::c_char,
    pub int_p_sep_by_space: ::std::os::raw::c_char,
    pub int_n_sep_by_space: ::std::os::raw::c_char,
    pub int_p_sign_posn: ::std::os::raw::c_char,
    pub int_n_sign_posn: ::std::os::raw::c_char,
}
impl Default for lconv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn localeconv() -> *mut lconv;
}
#[pg_guard]
extern "C" {
    pub fn setlocale(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type BoolPtr = *mut bool;
pub type Pointer = *mut ::std::os::raw::c_char;
pub type int8 = ::std::os::raw::c_schar;
pub type int16 = ::std::os::raw::c_short;
pub type int32 = ::std::os::raw::c_int;
pub type uint8 = ::std::os::raw::c_uchar;
pub type uint16 = ::std::os::raw::c_ushort;
pub type uint32 = ::std::os::raw::c_uint;
pub type bits8 = uint8;
pub type bits16 = uint16;
pub type bits32 = uint32;
pub type int64 = ::std::os::raw::c_long;
pub type uint64 = ::std::os::raw::c_ulong;
pub type int128 = i128;
pub type uint128 = u128;
pub type Size = usize;
pub type Index = ::std::os::raw::c_uint;
pub type Offset = ::std::os::raw::c_int;
pub type float4 = f32;
pub type float8 = f64;
pub type regproc = Oid;
pub type RegProcedure = regproc;
pub type TransactionId = uint32;
pub type LocalTransactionId = uint32;
pub type SubTransactionId = uint32;
pub type MultiXactId = TransactionId;
pub type MultiXactOffset = uint32;
pub type CommandId = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IntArray {
    pub indx: [::std::os::raw::c_int; 6usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varlena {
    pub vl_len_: [::std::os::raw::c_char; 4usize],
    pub vl_dat: __IncompleteArrayField<::std::os::raw::c_char>,
}
pub type bytea = varlena;
pub type text = varlena;
pub type BpChar = varlena;
pub type VarChar = varlena;
#[repr(C)]
#[derive(Debug, Default)]
pub struct int2vector {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::std::os::raw::c_int,
    pub lbound1: ::std::os::raw::c_int,
    pub values: __IncompleteArrayField<int16>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct oidvector {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::std::os::raw::c_int,
    pub lbound1: ::std::os::raw::c_int,
    pub values: __IncompleteArrayField<Oid>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nameData {
    pub data: [::std::os::raw::c_char; 64usize],
}
impl Default for nameData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type NameData = nameData;
pub type Name = *mut NameData;
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedBlock {
    pub data: [::std::os::raw::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedXLogBlock {
    pub data: [::std::os::raw::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedXLogBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn fdatasync(fildes: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
pub type wint_t = __darwin_wint_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneEntry {
    pub __min: __darwin_rune_t,
    pub __max: __darwin_rune_t,
    pub __map: __darwin_rune_t,
    pub __types: *mut __uint32_t,
}
impl Default for _RuneEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneRange {
    pub __nranges: ::std::os::raw::c_int,
    pub __ranges: *mut _RuneEntry,
}
impl Default for _RuneRange {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _RuneCharClass {
    pub __name: [::std::os::raw::c_char; 14usize],
    pub __mask: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneLocale {
    pub __magic: [::std::os::raw::c_char; 8usize],
    pub __encoding: [::std::os::raw::c_char; 32usize],
    pub __sgetrune: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: __darwin_size_t,
            arg3: *mut *const ::std::os::raw::c_char,
        ) -> __darwin_rune_t,
    >,
    pub __sputrune: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: __darwin_rune_t,
            arg2: *mut ::std::os::raw::c_char,
            arg3: __darwin_size_t,
            arg4: *mut *mut ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
    pub __invalid_rune: __darwin_rune_t,
    pub __runetype: [__uint32_t; 256usize],
    pub __maplower: [__darwin_rune_t; 256usize],
    pub __mapupper: [__darwin_rune_t; 256usize],
    pub __runetype_ext: _RuneRange,
    pub __maplower_ext: _RuneRange,
    pub __mapupper_ext: _RuneRange,
    pub __variable: *mut ::std::os::raw::c_void,
    pub __variable_len: ::std::os::raw::c_int,
    pub __ncharclasses: ::std::os::raw::c_int,
    pub __charclasses: *mut _RuneCharClass,
}
impl Default for _RuneLocale {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut _DefaultRuneLocale: _RuneLocale;
}
#[pg_guard]
extern "C" {
    pub static mut _CurrentRuneLocale: *mut _RuneLocale;
}
#[pg_guard]
extern "C" {
    pub fn ___runetype(arg1: __darwin_ct_rune_t) -> ::std::os::raw::c_ulong;
}
#[pg_guard]
extern "C" {
    pub fn ___tolower(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
#[pg_guard]
extern "C" {
    pub fn ___toupper(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
#[pg_guard]
extern "C" {
    pub fn __maskrune(
        arg1: __darwin_ct_rune_t,
        arg2: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn __toupper(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
#[pg_guard]
extern "C" {
    pub fn __tolower(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
pub type socklen_t = __darwin_socklen_t;
pub type sa_family_t = __uint8_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: usize,
}
impl Default for iovec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type sae_associd_t = __uint32_t;
pub type sae_connid_t = __uint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sa_endpoints {
    pub sae_srcif: ::std::os::raw::c_uint,
    pub sae_srcaddr: *const sockaddr,
    pub sae_srcaddrlen: socklen_t,
    pub sae_dstaddr: *const sockaddr,
    pub sae_dstaddrlen: socklen_t,
}
impl Default for sa_endpoints {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type sa_endpoints_t = sa_endpoints;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct so_np_extensions {
    pub npx_flags: u_int32_t,
    pub npx_mask: u_int32_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockaddr {
    pub sa_len: __uint8_t,
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockproto {
    pub sp_family: __uint16_t,
    pub sp_protocol: __uint16_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_len: __uint8_t,
    pub ss_family: sa_family_t,
    pub __ss_pad1: [::std::os::raw::c_char; 6usize],
    pub __ss_align: __int64_t,
    pub __ss_pad2: [::std::os::raw::c_char; 112usize],
}
impl Default for sockaddr_storage {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: ::std::os::raw::c_int,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: socklen_t,
    pub msg_flags: ::std::os::raw::c_int,
}
impl Default for msghdr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct cmsghdr {
    pub cmsg_len: socklen_t,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sf_hdtr {
    pub headers: *mut iovec,
    pub hdr_cnt: ::std::os::raw::c_int,
    pub trailers: *mut iovec,
    pub trl_cnt: ::std::os::raw::c_int,
}
impl Default for sf_hdtr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn accept(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn bind(
        arg1: ::std::os::raw::c_int,
        arg2: *const sockaddr,
        arg3: socklen_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn connect(
        arg1: ::std::os::raw::c_int,
        arg2: *const sockaddr,
        arg3: socklen_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getpeername(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getsockname(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_void,
        arg5: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn listen(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn recv(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
    ) -> isize;
}
#[pg_guard]
extern "C" {
    pub fn recvfrom(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
        arg5: *mut sockaddr,
        arg6: *mut socklen_t,
    ) -> isize;
}
#[pg_guard]
extern "C" {
    pub fn recvmsg(
        arg1: ::std::os::raw::c_int,
        arg2: *mut msghdr,
        arg3: ::std::os::raw::c_int,
    ) -> isize;
}
#[pg_guard]
extern "C" {
    pub fn send(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
    ) -> isize;
}
#[pg_guard]
extern "C" {
    pub fn sendmsg(
        arg1: ::std::os::raw::c_int,
        arg2: *const msghdr,
        arg3: ::std::os::raw::c_int,
    ) -> isize;
}
#[pg_guard]
extern "C" {
    pub fn sendto(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
        arg5: *const sockaddr,
        arg6: socklen_t,
    ) -> isize;
}
#[pg_guard]
extern "C" {
    pub fn setsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_void,
        arg5: socklen_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn shutdown(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sockatmark(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn socket(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn socketpair(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sendfile(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: off_t,
        arg4: *mut off_t,
        arg5: *mut sf_hdtr,
        arg6: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pfctlinput(arg1: ::std::os::raw::c_int, arg2: *mut sockaddr);
}
#[pg_guard]
extern "C" {
    pub fn connectx(
        arg1: ::std::os::raw::c_int,
        arg2: *const sa_endpoints_t,
        arg3: sae_associd_t,
        arg4: ::std::os::raw::c_uint,
        arg5: *const iovec,
        arg6: ::std::os::raw::c_uint,
        arg7: *mut usize,
        arg8: *mut sae_connid_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn disconnectx(
        arg1: ::std::os::raw::c_int,
        arg2: sae_associd_t,
        arg3: sae_connid_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct in_addr {
    pub s_addr: in_addr_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_len: __uint8_t,
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [::std::os::raw::c_char; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_opts {
    pub ip_dst: in_addr,
    pub ip_opts: [::std::os::raw::c_char; 40usize],
}
impl Default for ip_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreq {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreqn {
    pub imr_multiaddr: in_addr,
    pub imr_address: in_addr,
    pub imr_ifindex: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreq_source {
    pub imr_multiaddr: in_addr,
    pub imr_sourceaddr: in_addr,
    pub imr_interface: in_addr,
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct group_req {
    pub gr_interface: u32,
    pub gr_group: sockaddr_storage,
}
impl Default for group_req {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct group_source_req {
    pub gsr_interface: u32,
    pub gsr_group: sockaddr_storage,
    pub gsr_source: sockaddr_storage,
}
impl Default for group_source_req {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __msfilterreq {
    pub msfr_ifindex: u32,
    pub msfr_fmode: u32,
    pub msfr_nsrcs: u32,
    pub __msfr_align: u32,
    pub msfr_group: sockaddr_storage,
    pub msfr_srcs: *mut sockaddr_storage,
}
impl Default for __msfilterreq {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn setipv4sourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: in_addr,
        arg3: in_addr,
        arg4: u32,
        arg5: u32,
        arg6: *mut in_addr,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getipv4sourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: in_addr,
        arg3: in_addr,
        arg4: *mut u32,
        arg5: *mut u32,
        arg6: *mut in_addr,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn setsourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: u32,
        arg3: *mut sockaddr,
        arg4: socklen_t,
        arg5: u32,
        arg6: u32,
        arg7: *mut sockaddr_storage,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getsourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: u32,
        arg3: *mut sockaddr,
        arg4: socklen_t,
        arg5: *mut u32,
        arg6: *mut u32,
        arg7: *mut sockaddr_storage,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct in_pktinfo {
    pub ipi_ifindex: ::std::os::raw::c_uint,
    pub ipi_spec_dst: in_addr,
    pub ipi_addr: in_addr,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub __u6_addr: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub __u6_addr8: [__uint8_t; 16usize],
    pub __u6_addr16: [__uint16_t; 8usize],
    pub __u6_addr32: [__uint32_t; 4usize],
}
impl Default for in6_addr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for in6_addr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type in6_addr_t = in6_addr;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_len: __uint8_t,
    pub sin6_family: sa_family_t,
    pub sin6_port: in_port_t,
    pub sin6_flowinfo: __uint32_t,
    pub sin6_addr: in6_addr,
    pub sin6_scope_id: __uint32_t,
}
impl Default for sockaddr_in6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static in6addr_any: in6_addr;
}
#[pg_guard]
extern "C" {
    pub static in6addr_loopback: in6_addr;
}
#[pg_guard]
extern "C" {
    pub static in6addr_nodelocal_allnodes: in6_addr;
}
#[pg_guard]
extern "C" {
    pub static in6addr_linklocal_allnodes: in6_addr;
}
#[pg_guard]
extern "C" {
    pub static in6addr_linklocal_allrouters: in6_addr;
}
#[pg_guard]
extern "C" {
    pub static in6addr_linklocal_allv2routers: in6_addr;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ipv6_mreq {
    pub ipv6mr_multiaddr: in6_addr,
    pub ipv6mr_interface: ::std::os::raw::c_uint,
}
impl Default for ipv6_mreq {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_pktinfo {
    pub ipi6_addr: in6_addr,
    pub ipi6_ifindex: ::std::os::raw::c_uint,
}
impl Default for in6_pktinfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ip6_mtuinfo {
    pub ip6m_addr: sockaddr_in6,
    pub ip6m_mtu: u32,
}
impl Default for ip6_mtuinfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn inet6_option_space(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_option_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *mut *mut cmsghdr,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_option_append(
        arg1: *mut cmsghdr,
        arg2: *const __uint8_t,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_option_alloc(
        arg1: *mut cmsghdr,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> *mut __uint8_t;
}
#[pg_guard]
extern "C" {
    pub fn inet6_option_next(
        arg1: *const cmsghdr,
        arg2: *mut *mut __uint8_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_option_find(
        arg1: *const cmsghdr,
        arg2: *mut *mut __uint8_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rthdr_space(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> usize;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rthdr_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> *mut cmsghdr;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rthdr_add(
        arg1: *mut cmsghdr,
        arg2: *const in6_addr,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rthdr_lasthop(
        arg1: *mut cmsghdr,
        arg2: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rthdr_segments(arg1: *const cmsghdr) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rthdr_getaddr(arg1: *mut cmsghdr, arg2: ::std::os::raw::c_int) -> *mut in6_addr;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rthdr_getflags(
        arg1: *const cmsghdr,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_opt_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_opt_append(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: __uint8_t,
        arg5: socklen_t,
        arg6: __uint8_t,
        arg7: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_opt_finish(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_opt_set_val(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
        arg4: socklen_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_opt_next(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: *mut __uint8_t,
        arg5: *mut socklen_t,
        arg6: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_opt_find(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: __uint8_t,
        arg5: *mut socklen_t,
        arg6: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_opt_get_val(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
        arg4: socklen_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rth_space(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> socklen_t;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rth_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rth_add(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const in6_addr,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rth_reverse(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rth_segments(arg1: *const ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet6_rth_getaddr(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> *mut in6_addr;
}
#[pg_guard]
extern "C" {
    pub fn bindresvport(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr_in,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn bindresvport_sa(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut h_errno: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hostent {
    pub h_name: *mut ::std::os::raw::c_char,
    pub h_aliases: *mut *mut ::std::os::raw::c_char,
    pub h_addrtype: ::std::os::raw::c_int,
    pub h_length: ::std::os::raw::c_int,
    pub h_addr_list: *mut *mut ::std::os::raw::c_char,
}
impl Default for hostent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct netent {
    pub n_name: *mut ::std::os::raw::c_char,
    pub n_aliases: *mut *mut ::std::os::raw::c_char,
    pub n_addrtype: ::std::os::raw::c_int,
    pub n_net: u32,
}
impl Default for netent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct servent {
    pub s_name: *mut ::std::os::raw::c_char,
    pub s_aliases: *mut *mut ::std::os::raw::c_char,
    pub s_port: ::std::os::raw::c_int,
    pub s_proto: *mut ::std::os::raw::c_char,
}
impl Default for servent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct protoent {
    pub p_name: *mut ::std::os::raw::c_char,
    pub p_aliases: *mut *mut ::std::os::raw::c_char,
    pub p_proto: ::std::os::raw::c_int,
}
impl Default for protoent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct addrinfo {
    pub ai_flags: ::std::os::raw::c_int,
    pub ai_family: ::std::os::raw::c_int,
    pub ai_socktype: ::std::os::raw::c_int,
    pub ai_protocol: ::std::os::raw::c_int,
    pub ai_addrlen: socklen_t,
    pub ai_canonname: *mut ::std::os::raw::c_char,
    pub ai_addr: *mut sockaddr,
    pub ai_next: *mut addrinfo,
}
impl Default for addrinfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rpcent {
    pub r_name: *mut ::std::os::raw::c_char,
    pub r_aliases: *mut *mut ::std::os::raw::c_char,
    pub r_number: ::std::os::raw::c_int,
}
impl Default for rpcent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn endhostent();
}
#[pg_guard]
extern "C" {
    pub fn endnetent();
}
#[pg_guard]
extern "C" {
    pub fn endprotoent();
}
#[pg_guard]
extern "C" {
    pub fn endservent();
}
#[pg_guard]
extern "C" {
    pub fn freeaddrinfo(arg1: *mut addrinfo);
}
#[pg_guard]
extern "C" {
    pub fn gai_strerror(arg1: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn getaddrinfo(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const addrinfo,
        arg4: *mut *mut addrinfo,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn gethostbyaddr(
        arg1: *const ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
    ) -> *mut hostent;
}
#[pg_guard]
extern "C" {
    pub fn gethostbyname(arg1: *const ::std::os::raw::c_char) -> *mut hostent;
}
#[pg_guard]
extern "C" {
    pub fn gethostent() -> *mut hostent;
}
#[pg_guard]
extern "C" {
    pub fn getnameinfo(
        arg1: *const sockaddr,
        arg2: socklen_t,
        arg3: *mut ::std::os::raw::c_char,
        arg4: socklen_t,
        arg5: *mut ::std::os::raw::c_char,
        arg6: socklen_t,
        arg7: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getnetbyaddr(arg1: u32, arg2: ::std::os::raw::c_int) -> *mut netent;
}
#[pg_guard]
extern "C" {
    pub fn getnetbyname(arg1: *const ::std::os::raw::c_char) -> *mut netent;
}
#[pg_guard]
extern "C" {
    pub fn getnetent() -> *mut netent;
}
#[pg_guard]
extern "C" {
    pub fn getprotobyname(arg1: *const ::std::os::raw::c_char) -> *mut protoent;
}
#[pg_guard]
extern "C" {
    pub fn getprotobynumber(arg1: ::std::os::raw::c_int) -> *mut protoent;
}
#[pg_guard]
extern "C" {
    pub fn getprotoent() -> *mut protoent;
}
#[pg_guard]
extern "C" {
    pub fn getservbyname(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut servent;
}
#[pg_guard]
extern "C" {
    pub fn getservbyport(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut servent;
}
#[pg_guard]
extern "C" {
    pub fn getservent() -> *mut servent;
}
#[pg_guard]
extern "C" {
    pub fn sethostent(arg1: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn setnetent(arg1: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn setprotoent(arg1: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn setservent(arg1: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn freehostent(arg1: *mut hostent);
}
#[pg_guard]
extern "C" {
    pub fn gethostbyname2(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut hostent;
}
#[pg_guard]
extern "C" {
    pub fn getipnodebyaddr(
        arg1: *const ::std::os::raw::c_void,
        arg2: usize,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut hostent;
}
#[pg_guard]
extern "C" {
    pub fn getipnodebyname(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut hostent;
}
#[pg_guard]
extern "C" {
    pub fn getrpcbyname(name: *const ::std::os::raw::c_char) -> *mut rpcent;
}
#[pg_guard]
extern "C" {
    pub fn getrpcbynumber(number: ::std::os::raw::c_int) -> *mut rpcent;
}
#[pg_guard]
extern "C" {
    pub fn getrpcent() -> *mut rpcent;
}
#[pg_guard]
extern "C" {
    pub fn setrpcent(stayopen: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn endrpcent();
}
#[pg_guard]
extern "C" {
    pub fn herror(arg1: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn hstrerror(arg1: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn innetgr(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getnetgrent(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn endnetgrent();
}
#[pg_guard]
extern "C" {
    pub fn setnetgrent(arg1: *const ::std::os::raw::c_char);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct passwd {
    pub pw_name: *mut ::std::os::raw::c_char,
    pub pw_passwd: *mut ::std::os::raw::c_char,
    pub pw_uid: uid_t,
    pub pw_gid: gid_t,
    pub pw_change: __darwin_time_t,
    pub pw_class: *mut ::std::os::raw::c_char,
    pub pw_gecos: *mut ::std::os::raw::c_char,
    pub pw_dir: *mut ::std::os::raw::c_char,
    pub pw_shell: *mut ::std::os::raw::c_char,
    pub pw_expire: __darwin_time_t,
}
impl Default for passwd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn getpwuid(arg1: uid_t) -> *mut passwd;
}
#[pg_guard]
extern "C" {
    pub fn getpwnam(arg1: *const ::std::os::raw::c_char) -> *mut passwd;
}
#[pg_guard]
extern "C" {
    pub fn getpwuid_r(
        arg1: uid_t,
        arg2: *mut passwd,
        arg3: *mut ::std::os::raw::c_char,
        arg4: usize,
        arg5: *mut *mut passwd,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getpwnam_r(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut passwd,
        arg3: *mut ::std::os::raw::c_char,
        arg4: usize,
        arg5: *mut *mut passwd,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getpwent() -> *mut passwd;
}
#[pg_guard]
extern "C" {
    pub fn setpwent();
}
#[pg_guard]
extern "C" {
    pub fn endpwent();
}
pub type uuid_t = __darwin_uuid_t;
pub type uuid_string_t = __darwin_uuid_string_t;
#[pg_guard]
extern "C" {
    pub static UUID_NULL: uuid_t;
}
#[pg_guard]
extern "C" {
    pub fn uuid_clear(uu: *mut ::std::os::raw::c_uchar);
}
#[pg_guard]
extern "C" {
    pub fn uuid_compare(
        uu1: *mut ::std::os::raw::c_uchar,
        uu2: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn uuid_copy(dst: *mut ::std::os::raw::c_uchar, src: *mut ::std::os::raw::c_uchar);
}
#[pg_guard]
extern "C" {
    pub fn uuid_generate(out: *mut ::std::os::raw::c_uchar);
}
#[pg_guard]
extern "C" {
    pub fn uuid_generate_random(out: *mut ::std::os::raw::c_uchar);
}
#[pg_guard]
extern "C" {
    pub fn uuid_generate_time(out: *mut ::std::os::raw::c_uchar);
}
#[pg_guard]
extern "C" {
    pub fn uuid_generate_early_random(out: *mut ::std::os::raw::c_uchar);
}
#[pg_guard]
extern "C" {
    pub fn uuid_is_null(uu: *mut ::std::os::raw::c_uchar) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn uuid_parse(
        in_: *mut ::std::os::raw::c_char,
        uu: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn uuid_unparse(uu: *mut ::std::os::raw::c_uchar, out: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn uuid_unparse_lower(uu: *mut ::std::os::raw::c_uchar, out: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn uuid_unparse_upper(uu: *mut ::std::os::raw::c_uchar, out: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn setpassent(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn user_from_uid(arg1: uid_t, arg2: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn getpwuuid(arg1: *mut ::std::os::raw::c_uchar) -> *mut passwd;
}
#[pg_guard]
extern "C" {
    pub fn getpwuuid_r(
        arg1: *mut ::std::os::raw::c_uchar,
        arg2: *mut passwd,
        arg3: *mut ::std::os::raw::c_char,
        arg4: usize,
        arg5: *mut *mut passwd,
    ) -> ::std::os::raw::c_int;
}
pub type pgsocket = ::std::os::raw::c_int;
#[pg_guard]
extern "C" {
    pub fn pg_set_noblock(sock: pgsocket) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_set_block(sock: pgsocket) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn has_drive_prefix(filename: *const ::std::os::raw::c_char) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn first_dir_separator(
        filename: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn last_dir_separator(
        filename: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn first_path_var_separator(
        pathlist: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn join_path_components(
        ret_path: *mut ::std::os::raw::c_char,
        head: *const ::std::os::raw::c_char,
        tail: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn canonicalize_path(path: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn make_native_path(path: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn cleanup_path(path: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn path_contains_parent_reference(path: *const ::std::os::raw::c_char) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn path_is_relative_and_below_cwd(path: *const ::std::os::raw::c_char) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn path_is_prefix_of_path(
        path1: *const ::std::os::raw::c_char,
        path2: *const ::std::os::raw::c_char,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn make_absolute_path(path: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn get_progname(argv0: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn get_share_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_etc_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_include_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_pkginclude_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_includeserver_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_lib_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_pkglib_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_locale_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_doc_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_html_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_man_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_home_path(ret_path: *mut ::std::os::raw::c_char) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_parent_directory(path: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn pgfnames(path: *const ::std::os::raw::c_char) -> *mut *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pgfnames_cleanup(filenames: *mut *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn set_pglocale_pgservice(
        argv0: *const ::std::os::raw::c_char,
        app: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn find_my_exec(
        argv0: *const ::std::os::raw::c_char,
        retpath: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn find_other_exec(
        argv0: *const ::std::os::raw::c_char,
        target: *const ::std::os::raw::c_char,
        versionstr: *const ::std::os::raw::c_char,
        retpath: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pg_usleep(microsec: ::std::os::raw::c_long);
}
#[pg_guard]
extern "C" {
    pub fn pg_strcasecmp(
        s1: *const ::std::os::raw::c_char,
        s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pg_strncasecmp(
        s1: *const ::std::os::raw::c_char,
        s2: *const ::std::os::raw::c_char,
        n: usize,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pg_toupper(ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
#[pg_guard]
extern "C" {
    pub fn pg_tolower(ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
#[pg_guard]
extern "C" {
    pub fn pg_ascii_toupper(ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
#[pg_guard]
extern "C" {
    pub fn pg_ascii_tolower(ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
#[pg_guard]
extern "C" {
    pub fn pg_strsignal(signum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn simple_prompt(
        prompt: *const ::std::os::raw::c_char,
        destination: *mut ::std::os::raw::c_char,
        destlen: usize,
        echo: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn pclose_check(stream: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn rmtree(path: *const ::std::os::raw::c_char, rmtopdir: bool) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_erand48(xseed: *mut ::std::os::raw::c_ushort) -> f64;
}
#[pg_guard]
extern "C" {
    pub fn pg_lrand48() -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn pg_jrand48(xseed: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn pg_srand48(seed: ::std::os::raw::c_long);
}
#[pg_guard]
extern "C" {
    pub fn pqStrerror(
        errnum: ::std::os::raw::c_int,
        strerrbuf: *mut ::std::os::raw::c_char,
        buflen: usize,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pqGetpwuid(
        uid: uid_t,
        resultbuf: *mut passwd,
        buffer: *mut ::std::os::raw::c_char,
        buflen: usize,
        result: *mut *mut passwd,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pqGethostbyname(
        name: *const ::std::os::raw::c_char,
        resultbuf: *mut hostent,
        buffer: *mut ::std::os::raw::c_char,
        buflen: usize,
        result: *mut *mut hostent,
        herrno: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pg_qsort(
        base: *mut ::std::os::raw::c_void,
        nel: usize,
        elsize: usize,
        cmp: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
#[pg_guard]
extern "C" {
    pub fn pg_qsort_strcmp(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
pub type qsort_arg_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[pg_guard]
extern "C" {
    pub fn qsort_arg(
        base: *mut ::std::os::raw::c_void,
        nel: usize,
        elsize: usize,
        cmp: qsort_arg_comparator,
        arg: *mut ::std::os::raw::c_void,
    );
}
#[pg_guard]
extern "C" {
    pub fn pg_get_encoding_from_locale(
        ctype: *const ::std::os::raw::c_char,
        write_message: bool,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn inet_net_ntop(
        af: ::std::os::raw::c_int,
        src: *const ::std::os::raw::c_void,
        bits: ::std::os::raw::c_int,
        dst: *mut ::std::os::raw::c_char,
        size: usize,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pg_strong_random(buf: *mut ::std::os::raw::c_void, len: usize) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_check_dir(dir: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pg_mkdir_p(
        path: *mut ::std::os::raw::c_char,
        omode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type pqsigfunc = ::std::option::Option<unsafe extern "C" fn(signo: ::std::os::raw::c_int)>;
#[pg_guard]
extern "C" {
    pub fn pqsignal(signo: ::std::os::raw::c_int, func: pqsigfunc) -> pqsigfunc;
}
#[pg_guard]
extern "C" {
    pub fn escape_single_quotes_ascii(
        src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn wait_result_to_str(exit_status: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn wait_result_is_signal(
        exit_status: ::std::os::raw::c_int,
        signum: ::std::os::raw::c_int,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn wait_result_is_any_signal(
        exit_status: ::std::os::raw::c_int,
        include_command_not_found: bool,
    ) -> bool;
}
pub type jmp_buf = [::std::os::raw::c_int; 37usize];
pub type sigjmp_buf = [::std::os::raw::c_int; 38usize];
#[pg_guard]
extern "C" {
    pub fn setjmp(arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn longjmp(arg1: *mut ::std::os::raw::c_int, arg2: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn _setjmp(arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn _longjmp(arg1: *mut ::std::os::raw::c_int, arg2: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn longjmperror();
}
#[pg_guard]
extern "C" {
    pub fn errstart(
        elevel: ::std::os::raw::c_int,
        filename: *const ::std::os::raw::c_char,
        lineno: ::std::os::raw::c_int,
        funcname: *const ::std::os::raw::c_char,
        domain: *const ::std::os::raw::c_char,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn errfinish(dummy: ::std::os::raw::c_int, ...);
}
#[pg_guard]
extern "C" {
    pub fn errcode(sqlerrcode: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errcode_for_file_access() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errcode_for_socket_access() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errmsg(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errmsg_internal(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errmsg_plural(
        fmt_singular: *const ::std::os::raw::c_char,
        fmt_plural: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_ulong,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errdetail(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errdetail_internal(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errdetail_log(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errdetail_log_plural(
        fmt_singular: *const ::std::os::raw::c_char,
        fmt_plural: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_ulong,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errdetail_plural(
        fmt_singular: *const ::std::os::raw::c_char,
        fmt_plural: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_ulong,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errhint(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn set_errcontext_domain(domain: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errcontext_msg(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errhidestmt(hide_stmt: bool) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errhidecontext(hide_ctx: bool) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errfunction(funcname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errposition(cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn internalerrposition(cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn internalerrquery(query: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn err_generic_string(
        field: ::std::os::raw::c_int,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn geterrcode() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn geterrposition() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getinternalerrposition() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn elog_start(
        filename: *const ::std::os::raw::c_char,
        lineno: ::std::os::raw::c_int,
        funcname: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn elog_finish(elevel: ::std::os::raw::c_int, fmt: *const ::std::os::raw::c_char, ...);
}
#[pg_guard]
extern "C" {
    pub fn pre_format_elog_string(
        errnumber: ::std::os::raw::c_int,
        domain: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn format_elog_string(
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorContextCallback {
    pub previous: *mut ErrorContextCallback,
    pub callback: ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>,
    pub arg: *mut ::std::os::raw::c_void,
}
impl Default for ErrorContextCallback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut error_context_stack: *mut ErrorContextCallback;
}
#[pg_guard]
extern "C" {
    pub static mut PG_exception_stack: *mut sigjmp_buf;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorData {
    pub elevel: ::std::os::raw::c_int,
    pub output_to_server: bool,
    pub output_to_client: bool,
    pub show_funcname: bool,
    pub hide_stmt: bool,
    pub hide_ctx: bool,
    pub filename: *const ::std::os::raw::c_char,
    pub lineno: ::std::os::raw::c_int,
    pub funcname: *const ::std::os::raw::c_char,
    pub domain: *const ::std::os::raw::c_char,
    pub context_domain: *const ::std::os::raw::c_char,
    pub sqlerrcode: ::std::os::raw::c_int,
    pub message: *mut ::std::os::raw::c_char,
    pub detail: *mut ::std::os::raw::c_char,
    pub detail_log: *mut ::std::os::raw::c_char,
    pub hint: *mut ::std::os::raw::c_char,
    pub context: *mut ::std::os::raw::c_char,
    pub message_id: *const ::std::os::raw::c_char,
    pub schema_name: *mut ::std::os::raw::c_char,
    pub table_name: *mut ::std::os::raw::c_char,
    pub column_name: *mut ::std::os::raw::c_char,
    pub datatype_name: *mut ::std::os::raw::c_char,
    pub constraint_name: *mut ::std::os::raw::c_char,
    pub cursorpos: ::std::os::raw::c_int,
    pub internalpos: ::std::os::raw::c_int,
    pub internalquery: *mut ::std::os::raw::c_char,
    pub saved_errno: ::std::os::raw::c_int,
    pub assoc_context: *mut MemoryContextData,
}
impl Default for ErrorData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn EmitErrorReport();
}
#[pg_guard]
extern "C" {
    pub fn CopyErrorData() -> *mut ErrorData;
}
#[pg_guard]
extern "C" {
    pub fn FreeErrorData(edata: *mut ErrorData);
}
#[pg_guard]
extern "C" {
    pub fn FlushErrorState();
}
#[pg_guard]
extern "C" {
    pub fn ReThrowError(edata: *mut ErrorData);
}
#[pg_guard]
extern "C" {
    pub fn ThrowErrorData(edata: *mut ErrorData);
}
#[pg_guard]
extern "C" {
    pub fn GetErrorContextStack() -> *mut ::std::os::raw::c_char;
}
pub type emit_log_hook_type = ::std::option::Option<unsafe extern "C" fn(edata: *mut ErrorData)>;
#[pg_guard]
extern "C" {
    pub static mut emit_log_hook: emit_log_hook_type;
}
pub const PGErrorVerbosity_PGERROR_TERSE: PGErrorVerbosity = 0;
pub const PGErrorVerbosity_PGERROR_DEFAULT: PGErrorVerbosity = 1;
pub const PGErrorVerbosity_PGERROR_VERBOSE: PGErrorVerbosity = 2;
pub type PGErrorVerbosity = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub static mut Log_error_verbosity: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut Log_line_prefix: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub static mut Log_destination: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut Log_destination_string: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub static mut syslog_sequence_numbers: bool;
}
#[pg_guard]
extern "C" {
    pub static mut syslog_split_messages: bool;
}
#[pg_guard]
extern "C" {
    pub fn DebugFileOpen();
}
#[pg_guard]
extern "C" {
    pub fn unpack_sql_state(sql_state: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn in_error_recursion_trouble() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn set_syslog_parameters(
        ident: *const ::std::os::raw::c_char,
        facility: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn write_stderr(fmt: *const ::std::os::raw::c_char, ...);
}
pub type MemoryContext = *mut MemoryContextData;
pub type MemoryContextCallbackFunction =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryContextCallback {
    pub func: MemoryContextCallbackFunction,
    pub arg: *mut ::std::os::raw::c_void,
    pub next: *mut MemoryContextCallback,
}
impl Default for MemoryContextCallback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut CurrentMemoryContext: MemoryContext;
}
#[pg_guard]
extern "C" {
    pub fn MemoryContextAlloc(context: MemoryContext, size: Size) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn MemoryContextAllocZero(
        context: MemoryContext,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn MemoryContextAllocZeroAligned(
        context: MemoryContext,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn MemoryContextAllocExtended(
        context: MemoryContext,
        size: Size,
        flags: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn palloc(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn palloc0(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn palloc_extended(size: Size, flags: ::std::os::raw::c_int)
        -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn repalloc(
        pointer: *mut ::std::os::raw::c_void,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn pfree(pointer: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn MemoryContextAllocHuge(
        context: MemoryContext,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn repalloc_huge(
        pointer: *mut ::std::os::raw::c_void,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn MemoryContextRegisterResetCallback(
        context: MemoryContext,
        cb: *mut MemoryContextCallback,
    );
}
#[pg_guard]
extern "C" {
    pub fn MemoryContextStrdup(
        context: MemoryContext,
        string: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pstrdup(in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pnstrdup(in_: *const ::std::os::raw::c_char, len: Size) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pchomp(in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn psprintf(fmt: *const ::std::os::raw::c_char, ...) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pvsnprintf(
        buf: *mut ::std::os::raw::c_char,
        len: usize,
        fmt: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    ) -> usize;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct varatt_external {
    pub va_rawsize: int32,
    pub va_extsize: int32,
    pub va_valueid: Oid,
    pub va_toastrelid: Oid,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_indirect {
    pub pointer: *mut varlena,
}
impl Default for varatt_indirect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_expanded {
    pub eohptr: *mut ExpandedObjectHeader,
}
impl Default for varatt_expanded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const vartag_external_VARTAG_INDIRECT: vartag_external = 1;
pub const vartag_external_VARTAG_EXPANDED_RO: vartag_external = 2;
pub const vartag_external_VARTAG_EXPANDED_RW: vartag_external = 3;
pub const vartag_external_VARTAG_ONDISK: vartag_external = 18;
pub type vartag_external = ::std::os::raw::c_uint;
#[repr(C)]
pub struct varattrib_4b {
    pub va_4byte: __BindgenUnionField<varattrib_4b__bindgen_ty_1>,
    pub va_compressed: __BindgenUnionField<varattrib_4b__bindgen_ty_2>,
    pub bindgen_union_field: [u32; 2usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_1 {
    pub va_header: uint32,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_2 {
    pub va_header: uint32,
    pub va_rawsize: uint32,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for varattrib_4b {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b {
    pub va_header: uint8,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b_e {
    pub va_header: uint8,
    pub va_tag: uint8,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
pub type Datum = usize;
pub type DatumPtr = *mut Datum;
#[pg_guard]
extern "C" {
    pub fn ExceptionalCondition(
        conditionName: *const ::std::os::raw::c_char,
        errorType: *const ::std::os::raw::c_char,
        fileName: *const ::std::os::raw::c_char,
        lineNumber: ::std::os::raw::c_int,
    );
}
pub type fmNodePtr = *mut Node;
pub type fmAggrefPtr = *mut Aggref;
pub type fmExprContextCallbackFunction = ::std::option::Option<unsafe extern "C" fn(arg: Datum)>;
pub type fmStringInfo = *mut StringInfoData;
pub type FunctionCallInfo = *mut FunctionCallInfoData;
pub type PGFunction =
    ::std::option::Option<unsafe extern "C" fn(fcinfo: FunctionCallInfo) -> Datum>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FmgrInfo {
    pub fn_addr: PGFunction,
    pub fn_oid: Oid,
    pub fn_nargs: ::std::os::raw::c_short,
    pub fn_strict: bool,
    pub fn_retset: bool,
    pub fn_stats: ::std::os::raw::c_uchar,
    pub fn_extra: *mut ::std::os::raw::c_void,
    pub fn_mcxt: MemoryContext,
    pub fn_expr: fmNodePtr,
}
impl Default for FmgrInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionCallInfoData {
    pub flinfo: *mut FmgrInfo,
    pub context: fmNodePtr,
    pub resultinfo: fmNodePtr,
    pub fncollation: Oid,
    pub isnull: bool,
    pub nargs: ::std::os::raw::c_short,
    pub arg: [Datum; 100usize],
    pub argnull: [bool; 100usize],
}
impl Default for FunctionCallInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn fmgr_info(functionId: Oid, finfo: *mut FmgrInfo);
}
#[pg_guard]
extern "C" {
    pub fn fmgr_info_cxt(functionId: Oid, finfo: *mut FmgrInfo, mcxt: MemoryContext);
}
#[pg_guard]
extern "C" {
    pub fn fmgr_info_copy(dstinfo: *mut FmgrInfo, srcinfo: *mut FmgrInfo, destcxt: MemoryContext);
}
#[pg_guard]
extern "C" {
    pub fn pg_detoast_datum(datum: *mut varlena) -> *mut varlena;
}
#[pg_guard]
extern "C" {
    pub fn pg_detoast_datum_copy(datum: *mut varlena) -> *mut varlena;
}
#[pg_guard]
extern "C" {
    pub fn pg_detoast_datum_slice(datum: *mut varlena, first: int32, count: int32) -> *mut varlena;
}
#[pg_guard]
extern "C" {
    pub fn pg_detoast_datum_packed(datum: *mut varlena) -> *mut varlena;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_finfo_record {
    pub api_version: ::std::os::raw::c_int,
}
pub type PGFInfoFunction = ::std::option::Option<unsafe extern "C" fn() -> *const Pg_finfo_record>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_magic_struct {
    pub len: ::std::os::raw::c_int,
    pub version: ::std::os::raw::c_int,
    pub funcmaxargs: ::std::os::raw::c_int,
    pub indexmaxkeys: ::std::os::raw::c_int,
    pub namedatalen: ::std::os::raw::c_int,
    pub float4byval: ::std::os::raw::c_int,
    pub float8byval: ::std::os::raw::c_int,
}
pub type PGModuleMagicFunction =
    ::std::option::Option<unsafe extern "C" fn() -> *const Pg_magic_struct>;
#[pg_guard]
extern "C" {
    pub fn DirectFunctionCall1Coll(func: PGFunction, collation: Oid, arg1: Datum) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn DirectFunctionCall2Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn DirectFunctionCall3Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn DirectFunctionCall4Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn DirectFunctionCall5Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn DirectFunctionCall6Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn DirectFunctionCall7Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn DirectFunctionCall8Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn DirectFunctionCall9Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
        arg9: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn CallerFInfoFunctionCall1(
        func: PGFunction,
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn CallerFInfoFunctionCall2(
        func: PGFunction,
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn FunctionCall1Coll(flinfo: *mut FmgrInfo, collation: Oid, arg1: Datum) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn FunctionCall2Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn FunctionCall3Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn FunctionCall4Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn FunctionCall5Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn FunctionCall6Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn FunctionCall7Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn FunctionCall8Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn FunctionCall9Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
        arg9: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidFunctionCall0Coll(functionId: Oid, collation: Oid) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidFunctionCall1Coll(functionId: Oid, collation: Oid, arg1: Datum) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidFunctionCall2Coll(functionId: Oid, collation: Oid, arg1: Datum, arg2: Datum)
        -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidFunctionCall3Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidFunctionCall4Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidFunctionCall5Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidFunctionCall6Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidFunctionCall7Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidFunctionCall8Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidFunctionCall9Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
        arg9: Datum,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn InputFunctionCall(
        flinfo: *mut FmgrInfo,
        str_: *mut ::std::os::raw::c_char,
        typioparam: Oid,
        typmod: int32,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidInputFunctionCall(
        functionId: Oid,
        str_: *mut ::std::os::raw::c_char,
        typioparam: Oid,
        typmod: int32,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OutputFunctionCall(flinfo: *mut FmgrInfo, val: Datum) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn OidOutputFunctionCall(functionId: Oid, val: Datum) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn ReceiveFunctionCall(
        flinfo: *mut FmgrInfo,
        buf: fmStringInfo,
        typioparam: Oid,
        typmod: int32,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn OidReceiveFunctionCall(
        functionId: Oid,
        buf: fmStringInfo,
        typioparam: Oid,
        typmod: int32,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn SendFunctionCall(flinfo: *mut FmgrInfo, val: Datum) -> *mut bytea;
}
#[pg_guard]
extern "C" {
    pub fn OidSendFunctionCall(functionId: Oid, val: Datum) -> *mut bytea;
}
#[pg_guard]
extern "C" {
    pub fn fetch_finfo_record(
        filehandle: *mut ::std::os::raw::c_void,
        funcname: *const ::std::os::raw::c_char,
    ) -> *const Pg_finfo_record;
}
#[pg_guard]
extern "C" {
    pub fn clear_external_function_hash(filehandle: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn fmgr_internal_function(proname: *const ::std::os::raw::c_char) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_fn_expr_rettype(flinfo: *mut FmgrInfo) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_fn_expr_argtype(flinfo: *mut FmgrInfo, argnum: ::std::os::raw::c_int) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_call_expr_argtype(expr: fmNodePtr, argnum: ::std::os::raw::c_int) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_fn_expr_arg_stable(flinfo: *mut FmgrInfo, argnum: ::std::os::raw::c_int) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_call_expr_arg_stable(expr: fmNodePtr, argnum: ::std::os::raw::c_int) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_fn_expr_variadic(flinfo: *mut FmgrInfo) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn CheckFunctionValidatorAccess(validatorOid: Oid, functionOid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub static mut Dynamic_library_path: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn load_external_function(
        filename: *const ::std::os::raw::c_char,
        funcname: *const ::std::os::raw::c_char,
        signalNotFound: bool,
        filehandle: *mut *mut ::std::os::raw::c_void,
    ) -> PGFunction;
}
#[pg_guard]
extern "C" {
    pub fn lookup_external_function(
        filehandle: *mut ::std::os::raw::c_void,
        funcname: *const ::std::os::raw::c_char,
    ) -> PGFunction;
}
#[pg_guard]
extern "C" {
    pub fn load_file(filename: *const ::std::os::raw::c_char, restricted: bool);
}
#[pg_guard]
extern "C" {
    pub fn find_rendezvous_variable(
        varName: *const ::std::os::raw::c_char,
    ) -> *mut *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn EstimateLibraryStateSpace() -> Size;
}
#[pg_guard]
extern "C" {
    pub fn SerializeLibraryState(maxsize: Size, start_address: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn RestoreLibraryState(start_address: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn AggCheckCallContext(
        fcinfo: FunctionCallInfo,
        aggcontext: *mut MemoryContext,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn AggGetAggref(fcinfo: FunctionCallInfo) -> fmAggrefPtr;
}
#[pg_guard]
extern "C" {
    pub fn AggGetTempMemoryContext(fcinfo: FunctionCallInfo) -> MemoryContext;
}
#[pg_guard]
extern "C" {
    pub fn AggRegisterCallback(
        fcinfo: FunctionCallInfo,
        func: fmExprContextCallbackFunction,
        arg: Datum,
    );
}
pub const FmgrHookEventType_FHET_START: FmgrHookEventType = 0;
pub const FmgrHookEventType_FHET_END: FmgrHookEventType = 1;
pub const FmgrHookEventType_FHET_ABORT: FmgrHookEventType = 2;
pub type FmgrHookEventType = ::std::os::raw::c_uint;
pub type needs_fmgr_hook_type = ::std::option::Option<unsafe extern "C" fn(fn_oid: Oid) -> bool>;
pub type fmgr_hook_type = ::std::option::Option<
    unsafe extern "C" fn(event: FmgrHookEventType, flinfo: *mut FmgrInfo, arg: *mut Datum),
>;
#[pg_guard]
extern "C" {
    pub static mut needs_fmgr_hook: needs_fmgr_hook_type;
}
#[pg_guard]
extern "C" {
    pub static mut fmgr_hook: fmgr_hook_type;
}
#[pg_guard]
extern "C" {
    pub fn fmgr(procedureId: Oid, ...) -> *mut ::std::os::raw::c_char;
}
pub type AttrNumber = int16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_attribute {
    pub attrelid: Oid,
    pub attname: NameData,
    pub atttypid: Oid,
    pub attstattarget: int32,
    pub attlen: int16,
    pub attnum: int16,
    pub attndims: int32,
    pub attcacheoff: int32,
    pub atttypmod: int32,
    pub attbyval: bool,
    pub attstorage: ::std::os::raw::c_char,
    pub attalign: ::std::os::raw::c_char,
    pub attnotnull: bool,
    pub atthasdef: bool,
    pub attidentity: ::std::os::raw::c_char,
    pub attisdropped: bool,
    pub attislocal: bool,
    pub attinhcount: int32,
    pub attcollation: Oid,
}
impl Default for FormData_pg_attribute {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_attribute = *mut FormData_pg_attribute;
pub const NodeTag_T_Invalid: NodeTag = 0;
pub const NodeTag_T_IndexInfo: NodeTag = 1;
pub const NodeTag_T_ExprContext: NodeTag = 2;
pub const NodeTag_T_ProjectionInfo: NodeTag = 3;
pub const NodeTag_T_JunkFilter: NodeTag = 4;
pub const NodeTag_T_ResultRelInfo: NodeTag = 5;
pub const NodeTag_T_EState: NodeTag = 6;
pub const NodeTag_T_TupleTableSlot: NodeTag = 7;
pub const NodeTag_T_Plan: NodeTag = 8;
pub const NodeTag_T_Result: NodeTag = 9;
pub const NodeTag_T_ProjectSet: NodeTag = 10;
pub const NodeTag_T_ModifyTable: NodeTag = 11;
pub const NodeTag_T_Append: NodeTag = 12;
pub const NodeTag_T_MergeAppend: NodeTag = 13;
pub const NodeTag_T_RecursiveUnion: NodeTag = 14;
pub const NodeTag_T_BitmapAnd: NodeTag = 15;
pub const NodeTag_T_BitmapOr: NodeTag = 16;
pub const NodeTag_T_Scan: NodeTag = 17;
pub const NodeTag_T_SeqScan: NodeTag = 18;
pub const NodeTag_T_SampleScan: NodeTag = 19;
pub const NodeTag_T_IndexScan: NodeTag = 20;
pub const NodeTag_T_IndexOnlyScan: NodeTag = 21;
pub const NodeTag_T_BitmapIndexScan: NodeTag = 22;
pub const NodeTag_T_BitmapHeapScan: NodeTag = 23;
pub const NodeTag_T_TidScan: NodeTag = 24;
pub const NodeTag_T_SubqueryScan: NodeTag = 25;
pub const NodeTag_T_FunctionScan: NodeTag = 26;
pub const NodeTag_T_ValuesScan: NodeTag = 27;
pub const NodeTag_T_TableFuncScan: NodeTag = 28;
pub const NodeTag_T_CteScan: NodeTag = 29;
pub const NodeTag_T_NamedTuplestoreScan: NodeTag = 30;
pub const NodeTag_T_WorkTableScan: NodeTag = 31;
pub const NodeTag_T_ForeignScan: NodeTag = 32;
pub const NodeTag_T_CustomScan: NodeTag = 33;
pub const NodeTag_T_Join: NodeTag = 34;
pub const NodeTag_T_NestLoop: NodeTag = 35;
pub const NodeTag_T_MergeJoin: NodeTag = 36;
pub const NodeTag_T_HashJoin: NodeTag = 37;
pub const NodeTag_T_Material: NodeTag = 38;
pub const NodeTag_T_Sort: NodeTag = 39;
pub const NodeTag_T_Group: NodeTag = 40;
pub const NodeTag_T_Agg: NodeTag = 41;
pub const NodeTag_T_WindowAgg: NodeTag = 42;
pub const NodeTag_T_Unique: NodeTag = 43;
pub const NodeTag_T_Gather: NodeTag = 44;
pub const NodeTag_T_GatherMerge: NodeTag = 45;
pub const NodeTag_T_Hash: NodeTag = 46;
pub const NodeTag_T_SetOp: NodeTag = 47;
pub const NodeTag_T_LockRows: NodeTag = 48;
pub const NodeTag_T_Limit: NodeTag = 49;
pub const NodeTag_T_NestLoopParam: NodeTag = 50;
pub const NodeTag_T_PlanRowMark: NodeTag = 51;
pub const NodeTag_T_PlanInvalItem: NodeTag = 52;
pub const NodeTag_T_PlanState: NodeTag = 53;
pub const NodeTag_T_ResultState: NodeTag = 54;
pub const NodeTag_T_ProjectSetState: NodeTag = 55;
pub const NodeTag_T_ModifyTableState: NodeTag = 56;
pub const NodeTag_T_AppendState: NodeTag = 57;
pub const NodeTag_T_MergeAppendState: NodeTag = 58;
pub const NodeTag_T_RecursiveUnionState: NodeTag = 59;
pub const NodeTag_T_BitmapAndState: NodeTag = 60;
pub const NodeTag_T_BitmapOrState: NodeTag = 61;
pub const NodeTag_T_ScanState: NodeTag = 62;
pub const NodeTag_T_SeqScanState: NodeTag = 63;
pub const NodeTag_T_SampleScanState: NodeTag = 64;
pub const NodeTag_T_IndexScanState: NodeTag = 65;
pub const NodeTag_T_IndexOnlyScanState: NodeTag = 66;
pub const NodeTag_T_BitmapIndexScanState: NodeTag = 67;
pub const NodeTag_T_BitmapHeapScanState: NodeTag = 68;
pub const NodeTag_T_TidScanState: NodeTag = 69;
pub const NodeTag_T_SubqueryScanState: NodeTag = 70;
pub const NodeTag_T_FunctionScanState: NodeTag = 71;
pub const NodeTag_T_TableFuncScanState: NodeTag = 72;
pub const NodeTag_T_ValuesScanState: NodeTag = 73;
pub const NodeTag_T_CteScanState: NodeTag = 74;
pub const NodeTag_T_NamedTuplestoreScanState: NodeTag = 75;
pub const NodeTag_T_WorkTableScanState: NodeTag = 76;
pub const NodeTag_T_ForeignScanState: NodeTag = 77;
pub const NodeTag_T_CustomScanState: NodeTag = 78;
pub const NodeTag_T_JoinState: NodeTag = 79;
pub const NodeTag_T_NestLoopState: NodeTag = 80;
pub const NodeTag_T_MergeJoinState: NodeTag = 81;
pub const NodeTag_T_HashJoinState: NodeTag = 82;
pub const NodeTag_T_MaterialState: NodeTag = 83;
pub const NodeTag_T_SortState: NodeTag = 84;
pub const NodeTag_T_GroupState: NodeTag = 85;
pub const NodeTag_T_AggState: NodeTag = 86;
pub const NodeTag_T_WindowAggState: NodeTag = 87;
pub const NodeTag_T_UniqueState: NodeTag = 88;
pub const NodeTag_T_GatherState: NodeTag = 89;
pub const NodeTag_T_GatherMergeState: NodeTag = 90;
pub const NodeTag_T_HashState: NodeTag = 91;
pub const NodeTag_T_SetOpState: NodeTag = 92;
pub const NodeTag_T_LockRowsState: NodeTag = 93;
pub const NodeTag_T_LimitState: NodeTag = 94;
pub const NodeTag_T_Alias: NodeTag = 95;
pub const NodeTag_T_RangeVar: NodeTag = 96;
pub const NodeTag_T_TableFunc: NodeTag = 97;
pub const NodeTag_T_Expr: NodeTag = 98;
pub const NodeTag_T_Var: NodeTag = 99;
pub const NodeTag_T_Const: NodeTag = 100;
pub const NodeTag_T_Param: NodeTag = 101;
pub const NodeTag_T_Aggref: NodeTag = 102;
pub const NodeTag_T_GroupingFunc: NodeTag = 103;
pub const NodeTag_T_WindowFunc: NodeTag = 104;
pub const NodeTag_T_ArrayRef: NodeTag = 105;
pub const NodeTag_T_FuncExpr: NodeTag = 106;
pub const NodeTag_T_NamedArgExpr: NodeTag = 107;
pub const NodeTag_T_OpExpr: NodeTag = 108;
pub const NodeTag_T_DistinctExpr: NodeTag = 109;
pub const NodeTag_T_NullIfExpr: NodeTag = 110;
pub const NodeTag_T_ScalarArrayOpExpr: NodeTag = 111;
pub const NodeTag_T_BoolExpr: NodeTag = 112;
pub const NodeTag_T_SubLink: NodeTag = 113;
pub const NodeTag_T_SubPlan: NodeTag = 114;
pub const NodeTag_T_AlternativeSubPlan: NodeTag = 115;
pub const NodeTag_T_FieldSelect: NodeTag = 116;
pub const NodeTag_T_FieldStore: NodeTag = 117;
pub const NodeTag_T_RelabelType: NodeTag = 118;
pub const NodeTag_T_CoerceViaIO: NodeTag = 119;
pub const NodeTag_T_ArrayCoerceExpr: NodeTag = 120;
pub const NodeTag_T_ConvertRowtypeExpr: NodeTag = 121;
pub const NodeTag_T_CollateExpr: NodeTag = 122;
pub const NodeTag_T_CaseExpr: NodeTag = 123;
pub const NodeTag_T_CaseWhen: NodeTag = 124;
pub const NodeTag_T_CaseTestExpr: NodeTag = 125;
pub const NodeTag_T_ArrayExpr: NodeTag = 126;
pub const NodeTag_T_RowExpr: NodeTag = 127;
pub const NodeTag_T_RowCompareExpr: NodeTag = 128;
pub const NodeTag_T_CoalesceExpr: NodeTag = 129;
pub const NodeTag_T_MinMaxExpr: NodeTag = 130;
pub const NodeTag_T_SQLValueFunction: NodeTag = 131;
pub const NodeTag_T_XmlExpr: NodeTag = 132;
pub const NodeTag_T_NullTest: NodeTag = 133;
pub const NodeTag_T_BooleanTest: NodeTag = 134;
pub const NodeTag_T_CoerceToDomain: NodeTag = 135;
pub const NodeTag_T_CoerceToDomainValue: NodeTag = 136;
pub const NodeTag_T_SetToDefault: NodeTag = 137;
pub const NodeTag_T_CurrentOfExpr: NodeTag = 138;
pub const NodeTag_T_NextValueExpr: NodeTag = 139;
pub const NodeTag_T_InferenceElem: NodeTag = 140;
pub const NodeTag_T_TargetEntry: NodeTag = 141;
pub const NodeTag_T_RangeTblRef: NodeTag = 142;
pub const NodeTag_T_JoinExpr: NodeTag = 143;
pub const NodeTag_T_FromExpr: NodeTag = 144;
pub const NodeTag_T_OnConflictExpr: NodeTag = 145;
pub const NodeTag_T_IntoClause: NodeTag = 146;
pub const NodeTag_T_ExprState: NodeTag = 147;
pub const NodeTag_T_AggrefExprState: NodeTag = 148;
pub const NodeTag_T_WindowFuncExprState: NodeTag = 149;
pub const NodeTag_T_SetExprState: NodeTag = 150;
pub const NodeTag_T_SubPlanState: NodeTag = 151;
pub const NodeTag_T_AlternativeSubPlanState: NodeTag = 152;
pub const NodeTag_T_DomainConstraintState: NodeTag = 153;
pub const NodeTag_T_PlannerInfo: NodeTag = 154;
pub const NodeTag_T_PlannerGlobal: NodeTag = 155;
pub const NodeTag_T_RelOptInfo: NodeTag = 156;
pub const NodeTag_T_IndexOptInfo: NodeTag = 157;
pub const NodeTag_T_ForeignKeyOptInfo: NodeTag = 158;
pub const NodeTag_T_ParamPathInfo: NodeTag = 159;
pub const NodeTag_T_Path: NodeTag = 160;
pub const NodeTag_T_IndexPath: NodeTag = 161;
pub const NodeTag_T_BitmapHeapPath: NodeTag = 162;
pub const NodeTag_T_BitmapAndPath: NodeTag = 163;
pub const NodeTag_T_BitmapOrPath: NodeTag = 164;
pub const NodeTag_T_TidPath: NodeTag = 165;
pub const NodeTag_T_SubqueryScanPath: NodeTag = 166;
pub const NodeTag_T_ForeignPath: NodeTag = 167;
pub const NodeTag_T_CustomPath: NodeTag = 168;
pub const NodeTag_T_NestPath: NodeTag = 169;
pub const NodeTag_T_MergePath: NodeTag = 170;
pub const NodeTag_T_HashPath: NodeTag = 171;
pub const NodeTag_T_AppendPath: NodeTag = 172;
pub const NodeTag_T_MergeAppendPath: NodeTag = 173;
pub const NodeTag_T_ResultPath: NodeTag = 174;
pub const NodeTag_T_MaterialPath: NodeTag = 175;
pub const NodeTag_T_UniquePath: NodeTag = 176;
pub const NodeTag_T_GatherPath: NodeTag = 177;
pub const NodeTag_T_GatherMergePath: NodeTag = 178;
pub const NodeTag_T_ProjectionPath: NodeTag = 179;
pub const NodeTag_T_ProjectSetPath: NodeTag = 180;
pub const NodeTag_T_SortPath: NodeTag = 181;
pub const NodeTag_T_GroupPath: NodeTag = 182;
pub const NodeTag_T_UpperUniquePath: NodeTag = 183;
pub const NodeTag_T_AggPath: NodeTag = 184;
pub const NodeTag_T_GroupingSetsPath: NodeTag = 185;
pub const NodeTag_T_MinMaxAggPath: NodeTag = 186;
pub const NodeTag_T_WindowAggPath: NodeTag = 187;
pub const NodeTag_T_SetOpPath: NodeTag = 188;
pub const NodeTag_T_RecursiveUnionPath: NodeTag = 189;
pub const NodeTag_T_LockRowsPath: NodeTag = 190;
pub const NodeTag_T_ModifyTablePath: NodeTag = 191;
pub const NodeTag_T_LimitPath: NodeTag = 192;
pub const NodeTag_T_EquivalenceClass: NodeTag = 193;
pub const NodeTag_T_EquivalenceMember: NodeTag = 194;
pub const NodeTag_T_PathKey: NodeTag = 195;
pub const NodeTag_T_PathTarget: NodeTag = 196;
pub const NodeTag_T_RestrictInfo: NodeTag = 197;
pub const NodeTag_T_PlaceHolderVar: NodeTag = 198;
pub const NodeTag_T_SpecialJoinInfo: NodeTag = 199;
pub const NodeTag_T_AppendRelInfo: NodeTag = 200;
pub const NodeTag_T_PartitionedChildRelInfo: NodeTag = 201;
pub const NodeTag_T_PlaceHolderInfo: NodeTag = 202;
pub const NodeTag_T_MinMaxAggInfo: NodeTag = 203;
pub const NodeTag_T_PlannerParamItem: NodeTag = 204;
pub const NodeTag_T_RollupData: NodeTag = 205;
pub const NodeTag_T_GroupingSetData: NodeTag = 206;
pub const NodeTag_T_StatisticExtInfo: NodeTag = 207;
pub const NodeTag_T_MemoryContext: NodeTag = 208;
pub const NodeTag_T_AllocSetContext: NodeTag = 209;
pub const NodeTag_T_SlabContext: NodeTag = 210;
pub const NodeTag_T_Value: NodeTag = 211;
pub const NodeTag_T_Integer: NodeTag = 212;
pub const NodeTag_T_Float: NodeTag = 213;
pub const NodeTag_T_String: NodeTag = 214;
pub const NodeTag_T_BitString: NodeTag = 215;
pub const NodeTag_T_Null: NodeTag = 216;
pub const NodeTag_T_List: NodeTag = 217;
pub const NodeTag_T_IntList: NodeTag = 218;
pub const NodeTag_T_OidList: NodeTag = 219;
pub const NodeTag_T_ExtensibleNode: NodeTag = 220;
pub const NodeTag_T_RawStmt: NodeTag = 221;
pub const NodeTag_T_Query: NodeTag = 222;
pub const NodeTag_T_PlannedStmt: NodeTag = 223;
pub const NodeTag_T_InsertStmt: NodeTag = 224;
pub const NodeTag_T_DeleteStmt: NodeTag = 225;
pub const NodeTag_T_UpdateStmt: NodeTag = 226;
pub const NodeTag_T_SelectStmt: NodeTag = 227;
pub const NodeTag_T_AlterTableStmt: NodeTag = 228;
pub const NodeTag_T_AlterTableCmd: NodeTag = 229;
pub const NodeTag_T_AlterDomainStmt: NodeTag = 230;
pub const NodeTag_T_SetOperationStmt: NodeTag = 231;
pub const NodeTag_T_GrantStmt: NodeTag = 232;
pub const NodeTag_T_GrantRoleStmt: NodeTag = 233;
pub const NodeTag_T_AlterDefaultPrivilegesStmt: NodeTag = 234;
pub const NodeTag_T_ClosePortalStmt: NodeTag = 235;
pub const NodeTag_T_ClusterStmt: NodeTag = 236;
pub const NodeTag_T_CopyStmt: NodeTag = 237;
pub const NodeTag_T_CreateStmt: NodeTag = 238;
pub const NodeTag_T_DefineStmt: NodeTag = 239;
pub const NodeTag_T_DropStmt: NodeTag = 240;
pub const NodeTag_T_TruncateStmt: NodeTag = 241;
pub const NodeTag_T_CommentStmt: NodeTag = 242;
pub const NodeTag_T_FetchStmt: NodeTag = 243;
pub const NodeTag_T_IndexStmt: NodeTag = 244;
pub const NodeTag_T_CreateFunctionStmt: NodeTag = 245;
pub const NodeTag_T_AlterFunctionStmt: NodeTag = 246;
pub const NodeTag_T_DoStmt: NodeTag = 247;
pub const NodeTag_T_RenameStmt: NodeTag = 248;
pub const NodeTag_T_RuleStmt: NodeTag = 249;
pub const NodeTag_T_NotifyStmt: NodeTag = 250;
pub const NodeTag_T_ListenStmt: NodeTag = 251;
pub const NodeTag_T_UnlistenStmt: NodeTag = 252;
pub const NodeTag_T_TransactionStmt: NodeTag = 253;
pub const NodeTag_T_ViewStmt: NodeTag = 254;
pub const NodeTag_T_LoadStmt: NodeTag = 255;
pub const NodeTag_T_CreateDomainStmt: NodeTag = 256;
pub const NodeTag_T_CreatedbStmt: NodeTag = 257;
pub const NodeTag_T_DropdbStmt: NodeTag = 258;
pub const NodeTag_T_VacuumStmt: NodeTag = 259;
pub const NodeTag_T_ExplainStmt: NodeTag = 260;
pub const NodeTag_T_CreateTableAsStmt: NodeTag = 261;
pub const NodeTag_T_CreateSeqStmt: NodeTag = 262;
pub const NodeTag_T_AlterSeqStmt: NodeTag = 263;
pub const NodeTag_T_VariableSetStmt: NodeTag = 264;
pub const NodeTag_T_VariableShowStmt: NodeTag = 265;
pub const NodeTag_T_DiscardStmt: NodeTag = 266;
pub const NodeTag_T_CreateTrigStmt: NodeTag = 267;
pub const NodeTag_T_CreatePLangStmt: NodeTag = 268;
pub const NodeTag_T_CreateRoleStmt: NodeTag = 269;
pub const NodeTag_T_AlterRoleStmt: NodeTag = 270;
pub const NodeTag_T_DropRoleStmt: NodeTag = 271;
pub const NodeTag_T_LockStmt: NodeTag = 272;
pub const NodeTag_T_ConstraintsSetStmt: NodeTag = 273;
pub const NodeTag_T_ReindexStmt: NodeTag = 274;
pub const NodeTag_T_CheckPointStmt: NodeTag = 275;
pub const NodeTag_T_CreateSchemaStmt: NodeTag = 276;
pub const NodeTag_T_AlterDatabaseStmt: NodeTag = 277;
pub const NodeTag_T_AlterDatabaseSetStmt: NodeTag = 278;
pub const NodeTag_T_AlterRoleSetStmt: NodeTag = 279;
pub const NodeTag_T_CreateConversionStmt: NodeTag = 280;
pub const NodeTag_T_CreateCastStmt: NodeTag = 281;
pub const NodeTag_T_CreateOpClassStmt: NodeTag = 282;
pub const NodeTag_T_CreateOpFamilyStmt: NodeTag = 283;
pub const NodeTag_T_AlterOpFamilyStmt: NodeTag = 284;
pub const NodeTag_T_PrepareStmt: NodeTag = 285;
pub const NodeTag_T_ExecuteStmt: NodeTag = 286;
pub const NodeTag_T_DeallocateStmt: NodeTag = 287;
pub const NodeTag_T_DeclareCursorStmt: NodeTag = 288;
pub const NodeTag_T_CreateTableSpaceStmt: NodeTag = 289;
pub const NodeTag_T_DropTableSpaceStmt: NodeTag = 290;
pub const NodeTag_T_AlterObjectDependsStmt: NodeTag = 291;
pub const NodeTag_T_AlterObjectSchemaStmt: NodeTag = 292;
pub const NodeTag_T_AlterOwnerStmt: NodeTag = 293;
pub const NodeTag_T_AlterOperatorStmt: NodeTag = 294;
pub const NodeTag_T_DropOwnedStmt: NodeTag = 295;
pub const NodeTag_T_ReassignOwnedStmt: NodeTag = 296;
pub const NodeTag_T_CompositeTypeStmt: NodeTag = 297;
pub const NodeTag_T_CreateEnumStmt: NodeTag = 298;
pub const NodeTag_T_CreateRangeStmt: NodeTag = 299;
pub const NodeTag_T_AlterEnumStmt: NodeTag = 300;
pub const NodeTag_T_AlterTSDictionaryStmt: NodeTag = 301;
pub const NodeTag_T_AlterTSConfigurationStmt: NodeTag = 302;
pub const NodeTag_T_CreateFdwStmt: NodeTag = 303;
pub const NodeTag_T_AlterFdwStmt: NodeTag = 304;
pub const NodeTag_T_CreateForeignServerStmt: NodeTag = 305;
pub const NodeTag_T_AlterForeignServerStmt: NodeTag = 306;
pub const NodeTag_T_CreateUserMappingStmt: NodeTag = 307;
pub const NodeTag_T_AlterUserMappingStmt: NodeTag = 308;
pub const NodeTag_T_DropUserMappingStmt: NodeTag = 309;
pub const NodeTag_T_AlterTableSpaceOptionsStmt: NodeTag = 310;
pub const NodeTag_T_AlterTableMoveAllStmt: NodeTag = 311;
pub const NodeTag_T_SecLabelStmt: NodeTag = 312;
pub const NodeTag_T_CreateForeignTableStmt: NodeTag = 313;
pub const NodeTag_T_ImportForeignSchemaStmt: NodeTag = 314;
pub const NodeTag_T_CreateExtensionStmt: NodeTag = 315;
pub const NodeTag_T_AlterExtensionStmt: NodeTag = 316;
pub const NodeTag_T_AlterExtensionContentsStmt: NodeTag = 317;
pub const NodeTag_T_CreateEventTrigStmt: NodeTag = 318;
pub const NodeTag_T_AlterEventTrigStmt: NodeTag = 319;
pub const NodeTag_T_RefreshMatViewStmt: NodeTag = 320;
pub const NodeTag_T_ReplicaIdentityStmt: NodeTag = 321;
pub const NodeTag_T_AlterSystemStmt: NodeTag = 322;
pub const NodeTag_T_CreatePolicyStmt: NodeTag = 323;
pub const NodeTag_T_AlterPolicyStmt: NodeTag = 324;
pub const NodeTag_T_CreateTransformStmt: NodeTag = 325;
pub const NodeTag_T_CreateAmStmt: NodeTag = 326;
pub const NodeTag_T_CreatePublicationStmt: NodeTag = 327;
pub const NodeTag_T_AlterPublicationStmt: NodeTag = 328;
pub const NodeTag_T_CreateSubscriptionStmt: NodeTag = 329;
pub const NodeTag_T_AlterSubscriptionStmt: NodeTag = 330;
pub const NodeTag_T_DropSubscriptionStmt: NodeTag = 331;
pub const NodeTag_T_CreateStatsStmt: NodeTag = 332;
pub const NodeTag_T_AlterCollationStmt: NodeTag = 333;
pub const NodeTag_T_A_Expr: NodeTag = 334;
pub const NodeTag_T_ColumnRef: NodeTag = 335;
pub const NodeTag_T_ParamRef: NodeTag = 336;
pub const NodeTag_T_A_Const: NodeTag = 337;
pub const NodeTag_T_FuncCall: NodeTag = 338;
pub const NodeTag_T_A_Star: NodeTag = 339;
pub const NodeTag_T_A_Indices: NodeTag = 340;
pub const NodeTag_T_A_Indirection: NodeTag = 341;
pub const NodeTag_T_A_ArrayExpr: NodeTag = 342;
pub const NodeTag_T_ResTarget: NodeTag = 343;
pub const NodeTag_T_MultiAssignRef: NodeTag = 344;
pub const NodeTag_T_TypeCast: NodeTag = 345;
pub const NodeTag_T_CollateClause: NodeTag = 346;
pub const NodeTag_T_SortBy: NodeTag = 347;
pub const NodeTag_T_WindowDef: NodeTag = 348;
pub const NodeTag_T_RangeSubselect: NodeTag = 349;
pub const NodeTag_T_RangeFunction: NodeTag = 350;
pub const NodeTag_T_RangeTableSample: NodeTag = 351;
pub const NodeTag_T_RangeTableFunc: NodeTag = 352;
pub const NodeTag_T_RangeTableFuncCol: NodeTag = 353;
pub const NodeTag_T_TypeName: NodeTag = 354;
pub const NodeTag_T_ColumnDef: NodeTag = 355;
pub const NodeTag_T_IndexElem: NodeTag = 356;
pub const NodeTag_T_Constraint: NodeTag = 357;
pub const NodeTag_T_DefElem: NodeTag = 358;
pub const NodeTag_T_RangeTblEntry: NodeTag = 359;
pub const NodeTag_T_RangeTblFunction: NodeTag = 360;
pub const NodeTag_T_TableSampleClause: NodeTag = 361;
pub const NodeTag_T_WithCheckOption: NodeTag = 362;
pub const NodeTag_T_SortGroupClause: NodeTag = 363;
pub const NodeTag_T_GroupingSet: NodeTag = 364;
pub const NodeTag_T_WindowClause: NodeTag = 365;
pub const NodeTag_T_ObjectWithArgs: NodeTag = 366;
pub const NodeTag_T_AccessPriv: NodeTag = 367;
pub const NodeTag_T_CreateOpClassItem: NodeTag = 368;
pub const NodeTag_T_TableLikeClause: NodeTag = 369;
pub const NodeTag_T_FunctionParameter: NodeTag = 370;
pub const NodeTag_T_LockingClause: NodeTag = 371;
pub const NodeTag_T_RowMarkClause: NodeTag = 372;
pub const NodeTag_T_XmlSerialize: NodeTag = 373;
pub const NodeTag_T_WithClause: NodeTag = 374;
pub const NodeTag_T_InferClause: NodeTag = 375;
pub const NodeTag_T_OnConflictClause: NodeTag = 376;
pub const NodeTag_T_CommonTableExpr: NodeTag = 377;
pub const NodeTag_T_RoleSpec: NodeTag = 378;
pub const NodeTag_T_TriggerTransition: NodeTag = 379;
pub const NodeTag_T_PartitionElem: NodeTag = 380;
pub const NodeTag_T_PartitionSpec: NodeTag = 381;
pub const NodeTag_T_PartitionBoundSpec: NodeTag = 382;
pub const NodeTag_T_PartitionRangeDatum: NodeTag = 383;
pub const NodeTag_T_PartitionCmd: NodeTag = 384;
pub const NodeTag_T_IdentifySystemCmd: NodeTag = 385;
pub const NodeTag_T_BaseBackupCmd: NodeTag = 386;
pub const NodeTag_T_CreateReplicationSlotCmd: NodeTag = 387;
pub const NodeTag_T_DropReplicationSlotCmd: NodeTag = 388;
pub const NodeTag_T_StartReplicationCmd: NodeTag = 389;
pub const NodeTag_T_TimeLineHistoryCmd: NodeTag = 390;
pub const NodeTag_T_SQLCmd: NodeTag = 391;
pub const NodeTag_T_TriggerData: NodeTag = 392;
pub const NodeTag_T_EventTriggerData: NodeTag = 393;
pub const NodeTag_T_ReturnSetInfo: NodeTag = 394;
pub const NodeTag_T_WindowObjectData: NodeTag = 395;
pub const NodeTag_T_TIDBitmap: NodeTag = 396;
pub const NodeTag_T_InlineCodeBlock: NodeTag = 397;
pub const NodeTag_T_FdwRoutine: NodeTag = 398;
pub const NodeTag_T_IndexAmRoutine: NodeTag = 399;
pub const NodeTag_T_TsmRoutine: NodeTag = 400;
pub const NodeTag_T_ForeignKeyCacheInfo: NodeTag = 401;
pub type NodeTag = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Node {
    pub type_: NodeTag,
}
impl Default for Node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn outNode(str_: *mut StringInfoData, obj: *const ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn outToken(str_: *mut StringInfoData, s: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn outBitmapset(str_: *mut StringInfoData, bms: *const Bitmapset);
}
#[pg_guard]
extern "C" {
    pub fn outDatum(
        str_: *mut StringInfoData,
        value: usize,
        typlen: ::std::os::raw::c_int,
        typbyval: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn nodeToString(obj: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn bmsToString(bms: *const Bitmapset) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn stringToNode(str_: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn readBitmapset() -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn readDatum(typbyval: bool) -> usize;
}
#[pg_guard]
extern "C" {
    pub fn readBoolCols(numCols: ::std::os::raw::c_int) -> *mut bool;
}
#[pg_guard]
extern "C" {
    pub fn readIntCols(numCols: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn readOidCols(numCols: ::std::os::raw::c_int) -> *mut Oid;
}
#[pg_guard]
extern "C" {
    pub fn readAttrNumberCols(numCols: ::std::os::raw::c_int) -> *mut int16;
}
#[pg_guard]
extern "C" {
    pub fn copyObjectImpl(obj: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn equal(a: *const ::std::os::raw::c_void, b: *const ::std::os::raw::c_void) -> bool;
}
pub type Selectivity = f64;
pub type Cost = f64;
pub const CmdType_CMD_UNKNOWN: CmdType = 0;
pub const CmdType_CMD_SELECT: CmdType = 1;
pub const CmdType_CMD_UPDATE: CmdType = 2;
pub const CmdType_CMD_INSERT: CmdType = 3;
pub const CmdType_CMD_DELETE: CmdType = 4;
pub const CmdType_CMD_UTILITY: CmdType = 5;
pub const CmdType_CMD_NOTHING: CmdType = 6;
pub type CmdType = ::std::os::raw::c_uint;
pub const JoinType_JOIN_INNER: JoinType = 0;
pub const JoinType_JOIN_LEFT: JoinType = 1;
pub const JoinType_JOIN_FULL: JoinType = 2;
pub const JoinType_JOIN_RIGHT: JoinType = 3;
pub const JoinType_JOIN_SEMI: JoinType = 4;
pub const JoinType_JOIN_ANTI: JoinType = 5;
pub const JoinType_JOIN_UNIQUE_OUTER: JoinType = 6;
pub const JoinType_JOIN_UNIQUE_INNER: JoinType = 7;
pub type JoinType = ::std::os::raw::c_uint;
pub const AggStrategy_AGG_PLAIN: AggStrategy = 0;
pub const AggStrategy_AGG_SORTED: AggStrategy = 1;
pub const AggStrategy_AGG_HASHED: AggStrategy = 2;
pub const AggStrategy_AGG_MIXED: AggStrategy = 3;
pub type AggStrategy = ::std::os::raw::c_uint;
pub const AggSplit_AGGSPLIT_SIMPLE: AggSplit = 0;
pub const AggSplit_AGGSPLIT_INITIAL_SERIAL: AggSplit = 6;
pub const AggSplit_AGGSPLIT_FINAL_DESERIAL: AggSplit = 9;
pub type AggSplit = ::std::os::raw::c_uint;
pub const SetOpCmd_SETOPCMD_INTERSECT: SetOpCmd = 0;
pub const SetOpCmd_SETOPCMD_INTERSECT_ALL: SetOpCmd = 1;
pub const SetOpCmd_SETOPCMD_EXCEPT: SetOpCmd = 2;
pub const SetOpCmd_SETOPCMD_EXCEPT_ALL: SetOpCmd = 3;
pub type SetOpCmd = ::std::os::raw::c_uint;
pub const SetOpStrategy_SETOP_SORTED: SetOpStrategy = 0;
pub const SetOpStrategy_SETOP_HASHED: SetOpStrategy = 1;
pub type SetOpStrategy = ::std::os::raw::c_uint;
pub const OnConflictAction_ONCONFLICT_NONE: OnConflictAction = 0;
pub const OnConflictAction_ONCONFLICT_NOTHING: OnConflictAction = 1;
pub const OnConflictAction_ONCONFLICT_UPDATE: OnConflictAction = 2;
pub type OnConflictAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct List {
    pub type_: NodeTag,
    pub length: ::std::os::raw::c_int,
    pub head: *mut ListCell,
    pub tail: *mut ListCell,
}
impl Default for List {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ListCell {
    pub data: ListCell__bindgen_ty_1,
    pub next: *mut ListCell,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ListCell__bindgen_ty_1 {
    pub ptr_value: *mut ::std::os::raw::c_void,
    pub int_value: ::std::os::raw::c_int,
    pub oid_value: Oid,
}
impl Default for ListCell__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for ListCell {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn lappend(list: *mut List, datum: *mut ::std::os::raw::c_void) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn lappend_int(list: *mut List, datum: ::std::os::raw::c_int) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn lappend_oid(list: *mut List, datum: Oid) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn lappend_cell(
        list: *mut List,
        prev: *mut ListCell,
        datum: *mut ::std::os::raw::c_void,
    ) -> *mut ListCell;
}
#[pg_guard]
extern "C" {
    pub fn lappend_cell_int(
        list: *mut List,
        prev: *mut ListCell,
        datum: ::std::os::raw::c_int,
    ) -> *mut ListCell;
}
#[pg_guard]
extern "C" {
    pub fn lappend_cell_oid(list: *mut List, prev: *mut ListCell, datum: Oid) -> *mut ListCell;
}
#[pg_guard]
extern "C" {
    pub fn lcons(datum: *mut ::std::os::raw::c_void, list: *mut List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn lcons_int(datum: ::std::os::raw::c_int, list: *mut List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn lcons_oid(datum: Oid, list: *mut List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_concat(list1: *mut List, list2: *mut List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_truncate(list: *mut List, new_size: ::std::os::raw::c_int) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_nth_cell(list: *const List, n: ::std::os::raw::c_int) -> *mut ListCell;
}
#[pg_guard]
extern "C" {
    pub fn list_nth(list: *const List, n: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn list_nth_int(list: *const List, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn list_nth_oid(list: *const List, n: ::std::os::raw::c_int) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn list_member(list: *const List, datum: *const ::std::os::raw::c_void) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn list_member_ptr(list: *const List, datum: *const ::std::os::raw::c_void) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn list_member_int(list: *const List, datum: ::std::os::raw::c_int) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn list_member_oid(list: *const List, datum: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn list_delete(list: *mut List, datum: *mut ::std::os::raw::c_void) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_delete_ptr(list: *mut List, datum: *mut ::std::os::raw::c_void) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_delete_int(list: *mut List, datum: ::std::os::raw::c_int) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_delete_oid(list: *mut List, datum: Oid) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_delete_first(list: *mut List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_delete_cell(list: *mut List, cell: *mut ListCell, prev: *mut ListCell)
        -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_union(list1: *const List, list2: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_union_ptr(list1: *const List, list2: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_union_int(list1: *const List, list2: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_union_oid(list1: *const List, list2: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_intersection(list1: *const List, list2: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_intersection_int(list1: *const List, list2: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_difference(list1: *const List, list2: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_difference_ptr(list1: *const List, list2: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_difference_int(list1: *const List, list2: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_difference_oid(list1: *const List, list2: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_append_unique(list: *mut List, datum: *mut ::std::os::raw::c_void) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_append_unique_ptr(list: *mut List, datum: *mut ::std::os::raw::c_void)
        -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_append_unique_int(list: *mut List, datum: ::std::os::raw::c_int) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_append_unique_oid(list: *mut List, datum: Oid) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_concat_unique(list1: *mut List, list2: *mut List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_concat_unique_ptr(list1: *mut List, list2: *mut List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_concat_unique_int(list1: *mut List, list2: *mut List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_concat_unique_oid(list1: *mut List, list2: *mut List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_free(list: *mut List);
}
#[pg_guard]
extern "C" {
    pub fn list_free_deep(list: *mut List);
}
#[pg_guard]
extern "C" {
    pub fn list_copy(list: *const List) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn list_copy_tail(list: *const List, nskip: ::std::os::raw::c_int) -> *mut List;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct attrDefault {
    pub adnum: AttrNumber,
    pub adbin: *mut ::std::os::raw::c_char,
}
impl Default for attrDefault {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type AttrDefault = attrDefault;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct constrCheck {
    pub ccname: *mut ::std::os::raw::c_char,
    pub ccbin: *mut ::std::os::raw::c_char,
    pub ccvalid: bool,
    pub ccnoinherit: bool,
}
impl Default for constrCheck {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ConstrCheck = constrCheck;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tupleConstr {
    pub defval: *mut AttrDefault,
    pub check: *mut ConstrCheck,
    pub num_defval: uint16,
    pub num_check: uint16,
    pub has_not_null: bool,
}
impl Default for tupleConstr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleConstr = tupleConstr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tupleDesc {
    pub natts: ::std::os::raw::c_int,
    pub attrs: *mut Form_pg_attribute,
    pub constr: *mut TupleConstr,
    pub tdtypeid: Oid,
    pub tdtypmod: int32,
    pub tdhasoid: bool,
    pub tdrefcount: ::std::os::raw::c_int,
}
impl Default for tupleDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleDesc = *mut tupleDesc;
#[pg_guard]
extern "C" {
    pub fn CreateTemplateTupleDesc(natts: ::std::os::raw::c_int, hasoid: bool) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn CreateTupleDesc(
        natts: ::std::os::raw::c_int,
        hasoid: bool,
        attrs: *mut Form_pg_attribute,
    ) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn CreateTupleDescCopy(tupdesc: TupleDesc) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn CreateTupleDescCopyConstr(tupdesc: TupleDesc) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn TupleDescCopyEntry(
        dst: TupleDesc,
        dstAttno: AttrNumber,
        src: TupleDesc,
        srcAttno: AttrNumber,
    );
}
#[pg_guard]
extern "C" {
    pub fn FreeTupleDesc(tupdesc: TupleDesc);
}
#[pg_guard]
extern "C" {
    pub fn IncrTupleDescRefCount(tupdesc: TupleDesc);
}
#[pg_guard]
extern "C" {
    pub fn DecrTupleDescRefCount(tupdesc: TupleDesc);
}
#[pg_guard]
extern "C" {
    pub fn equalTupleDescs(tupdesc1: TupleDesc, tupdesc2: TupleDesc) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn TupleDescInitEntry(
        desc: TupleDesc,
        attributeNumber: AttrNumber,
        attributeName: *const ::std::os::raw::c_char,
        oidtypeid: Oid,
        typmod: int32,
        attdim: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn TupleDescInitBuiltinEntry(
        desc: TupleDesc,
        attributeNumber: AttrNumber,
        attributeName: *const ::std::os::raw::c_char,
        oidtypeid: Oid,
        typmod: int32,
        attdim: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn TupleDescInitEntryCollation(
        desc: TupleDesc,
        attributeNumber: AttrNumber,
        collationid: Oid,
    );
}
#[pg_guard]
extern "C" {
    pub fn BuildDescForRelation(schema: *mut List) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn BuildDescFromLists(
        names: *mut List,
        types: *mut List,
        typmods: *mut List,
        collations: *mut List,
    ) -> TupleDesc;
}
pub type BlockNumber = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BlockIdData {
    pub bi_hi: uint16,
    pub bi_lo: uint16,
}
pub type BlockId = *mut BlockIdData;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemIdData {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl ItemIdData {
    #[inline]
    pub fn lp_off(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_off(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn lp_flags(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_lp_flags(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn lp_len(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_len(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lp_off: ::std::os::raw::c_uint,
        lp_flags: ::std::os::raw::c_uint,
        lp_len: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 15u8, {
            let lp_off: u32 = unsafe { ::std::mem::transmute(lp_off) };
            lp_off as u64
        });
        __bindgen_bitfield_unit.set(15usize, 2u8, {
            let lp_flags: u32 = unsafe { ::std::mem::transmute(lp_flags) };
            lp_flags as u64
        });
        __bindgen_bitfield_unit.set(17usize, 15u8, {
            let lp_len: u32 = unsafe { ::std::mem::transmute(lp_len) };
            lp_len as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type ItemId = *mut ItemIdData;
pub type ItemOffset = uint16;
pub type ItemLength = uint16;
pub type OffsetNumber = uint16;
#[repr(C, packed(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemPointerData {
    pub ip_blkid: BlockIdData,
    pub ip_posid: OffsetNumber,
}
pub type ItemPointer = *mut ItemPointerData;
#[pg_guard]
extern "C" {
    pub fn ItemPointerEquals(pointer1: ItemPointer, pointer2: ItemPointer) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ItemPointerCompare(arg1: ItemPointer, arg2: ItemPointer) -> int32;
}
pub type HeapTupleHeader = *mut HeapTupleHeaderData;
pub type MinimalTuple = *mut MinimalTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleData {
    pub t_len: uint32,
    pub t_self: ItemPointerData,
    pub t_tableOid: Oid,
    pub t_data: HeapTupleHeader,
}
impl Default for HeapTupleData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HeapTuple = *mut HeapTupleData;
#[pg_guard]
extern "C" {
    pub fn HeapTupleHeaderGetCmin(tup: HeapTupleHeader) -> CommandId;
}
#[pg_guard]
extern "C" {
    pub fn HeapTupleHeaderGetCmax(tup: HeapTupleHeader) -> CommandId;
}
#[pg_guard]
extern "C" {
    pub fn HeapTupleHeaderAdjustCmax(
        tup: HeapTupleHeader,
        cmax: *mut CommandId,
        iscombo: *mut bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn HeapTupleGetUpdateXid(tuple: HeapTupleHeader) -> TransactionId;
}
pub type Buffer = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferAccessStrategyData {
    _unused: [u8; 0],
}
pub type BufferAccessStrategy = *mut BufferAccessStrategyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleTableSlot {
    pub type_: NodeTag,
    pub tts_isempty: bool,
    pub tts_shouldFree: bool,
    pub tts_shouldFreeMin: bool,
    pub tts_slow: bool,
    pub tts_tuple: HeapTuple,
    pub tts_tupleDescriptor: TupleDesc,
    pub tts_mcxt: MemoryContext,
    pub tts_buffer: Buffer,
    pub tts_nvalid: ::std::os::raw::c_int,
    pub tts_values: *mut Datum,
    pub tts_isnull: *mut bool,
    pub tts_mintuple: MinimalTuple,
    pub tts_minhdr: HeapTupleData,
    pub tts_off: ::std::os::raw::c_long,
}
impl Default for TupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn MakeTupleTableSlot() -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecAllocTableSlot(tupleTable: *mut *mut List) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecResetTupleTable(tupleTable: *mut List, shouldFree: bool);
}
#[pg_guard]
extern "C" {
    pub fn MakeSingleTupleTableSlot(tupdesc: TupleDesc) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecDropSingleTupleTableSlot(slot: *mut TupleTableSlot);
}
#[pg_guard]
extern "C" {
    pub fn ExecSetSlotDescriptor(slot: *mut TupleTableSlot, tupdesc: TupleDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExecStoreTuple(
        tuple: HeapTuple,
        slot: *mut TupleTableSlot,
        buffer: Buffer,
        shouldFree: bool,
    ) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecStoreMinimalTuple(
        mtup: MinimalTuple,
        slot: *mut TupleTableSlot,
        shouldFree: bool,
    ) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecClearTuple(slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecStoreVirtualTuple(slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecStoreAllNullTuple(slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecCopySlotTuple(slot: *mut TupleTableSlot) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn ExecCopySlotMinimalTuple(slot: *mut TupleTableSlot) -> MinimalTuple;
}
#[pg_guard]
extern "C" {
    pub fn ExecFetchSlotTuple(slot: *mut TupleTableSlot) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn ExecFetchSlotMinimalTuple(slot: *mut TupleTableSlot) -> MinimalTuple;
}
#[pg_guard]
extern "C" {
    pub fn ExecFetchSlotTupleDatum(slot: *mut TupleTableSlot) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn ExecMaterializeSlot(slot: *mut TupleTableSlot) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn ExecCopySlot(
        dstslot: *mut TupleTableSlot,
        srcslot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn slot_getattr(
        slot: *mut TupleTableSlot,
        attnum: ::std::os::raw::c_int,
        isnull: *mut bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn slot_getallattrs(slot: *mut TupleTableSlot);
}
#[pg_guard]
extern "C" {
    pub fn slot_getsomeattrs(slot: *mut TupleTableSlot, attnum: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn slot_attisnull(slot: *mut TupleTableSlot, attnum: ::std::os::raw::c_int) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn slot_getsysattr(
        slot: *mut TupleTableSlot,
        attnum: ::std::os::raw::c_int,
        value: *mut Datum,
        isnull: *mut bool,
    ) -> bool;
}
pub const ScanDirection_BackwardScanDirection: ScanDirection = -1;
pub const ScanDirection_NoMovementScanDirection: ScanDirection = 0;
pub const ScanDirection_ForwardScanDirection: ScanDirection = 1;
pub type ScanDirection = ::std::os::raw::c_int;
pub type StrategyNumber = uint16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScanKeyData {
    pub sk_flags: ::std::os::raw::c_int,
    pub sk_attno: AttrNumber,
    pub sk_strategy: StrategyNumber,
    pub sk_subtype: Oid,
    pub sk_collation: Oid,
    pub sk_func: FmgrInfo,
    pub sk_argument: Datum,
}
impl Default for ScanKeyData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ScanKey = *mut ScanKeyData;
#[pg_guard]
extern "C" {
    pub fn ScanKeyInit(
        entry: ScanKey,
        attributeNumber: AttrNumber,
        strategy: StrategyNumber,
        procedure: RegProcedure,
        argument: Datum,
    );
}
#[pg_guard]
extern "C" {
    pub fn ScanKeyEntryInitialize(
        entry: ScanKey,
        flags: ::std::os::raw::c_int,
        attributeNumber: AttrNumber,
        strategy: StrategyNumber,
        subtype: Oid,
        collation: Oid,
        procedure: RegProcedure,
        argument: Datum,
    );
}
#[pg_guard]
extern "C" {
    pub fn ScanKeyEntryInitializeWithInfo(
        entry: ScanKey,
        flags: ::std::os::raw::c_int,
        attributeNumber: AttrNumber,
        strategy: StrategyNumber,
        subtype: Oid,
        collation: Oid,
        finfo: *mut FmgrInfo,
        argument: Datum,
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_flag {
    pub value: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint32 {
    pub value: uint32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint64 {
    pub value: uint64,
}
#[pg_guard]
extern "C" {
    pub static mut dynamic_shared_memory_type: ::std::os::raw::c_int;
}
pub type dsm_handle = uint32;
pub const dsm_op_DSM_OP_CREATE: dsm_op = 0;
pub const dsm_op_DSM_OP_ATTACH: dsm_op = 1;
pub const dsm_op_DSM_OP_DETACH: dsm_op = 2;
pub const dsm_op_DSM_OP_RESIZE: dsm_op = 3;
pub const dsm_op_DSM_OP_DESTROY: dsm_op = 4;
pub type dsm_op = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn dsm_impl_op(
        op: dsm_op,
        handle: dsm_handle,
        request_size: Size,
        impl_private: *mut *mut ::std::os::raw::c_void,
        mapped_address: *mut *mut ::std::os::raw::c_void,
        mapped_size: *mut Size,
        elevel: ::std::os::raw::c_int,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn dsm_impl_can_resize() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn dsm_impl_pin_segment(
        handle: dsm_handle,
        impl_private: *mut ::std::os::raw::c_void,
        impl_private_pm_handle: *mut *mut ::std::os::raw::c_void,
    );
}
#[pg_guard]
extern "C" {
    pub fn dsm_impl_unpin_segment(
        handle: dsm_handle,
        impl_private: *mut *mut ::std::os::raw::c_void,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsm_segment {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGShmemHeader {
    _unused: [u8; 0],
}
#[pg_guard]
extern "C" {
    pub fn dsm_cleanup_using_control_segment(old_control_handle: dsm_handle);
}
#[pg_guard]
extern "C" {
    pub fn dsm_postmaster_startup(arg1: *mut PGShmemHeader);
}
#[pg_guard]
extern "C" {
    pub fn dsm_backend_shutdown();
}
#[pg_guard]
extern "C" {
    pub fn dsm_detach_all();
}
#[pg_guard]
extern "C" {
    pub fn dsm_create(size: Size, flags: ::std::os::raw::c_int) -> *mut dsm_segment;
}
#[pg_guard]
extern "C" {
    pub fn dsm_attach(h: dsm_handle) -> *mut dsm_segment;
}
#[pg_guard]
extern "C" {
    pub fn dsm_resize(seg: *mut dsm_segment, size: Size) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn dsm_remap(seg: *mut dsm_segment) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn dsm_detach(seg: *mut dsm_segment);
}
#[pg_guard]
extern "C" {
    pub fn dsm_pin_mapping(seg: *mut dsm_segment);
}
#[pg_guard]
extern "C" {
    pub fn dsm_unpin_mapping(seg: *mut dsm_segment);
}
#[pg_guard]
extern "C" {
    pub fn dsm_pin_segment(seg: *mut dsm_segment);
}
#[pg_guard]
extern "C" {
    pub fn dsm_unpin_segment(h: dsm_handle);
}
#[pg_guard]
extern "C" {
    pub fn dsm_find_mapping(h: dsm_handle) -> *mut dsm_segment;
}
#[pg_guard]
extern "C" {
    pub fn dsm_segment_address(seg: *mut dsm_segment) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn dsm_segment_map_length(seg: *mut dsm_segment) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn dsm_segment_handle(seg: *mut dsm_segment) -> dsm_handle;
}
pub type on_dsm_detach_callback =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut dsm_segment, arg: Datum)>;
#[pg_guard]
extern "C" {
    pub fn on_dsm_detach(seg: *mut dsm_segment, function: on_dsm_detach_callback, arg: Datum);
}
#[pg_guard]
extern "C" {
    pub fn cancel_on_dsm_detach(
        seg: *mut dsm_segment,
        function: on_dsm_detach_callback,
        arg: Datum,
    );
}
#[pg_guard]
extern "C" {
    pub fn reset_on_dsm_detach();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsa_area {
    _unused: [u8; 0],
}
pub type dsa_pointer = uint64;
pub type dsa_pointer_atomic = pg_atomic_uint64;
pub type dsa_handle = dsm_handle;
#[pg_guard]
extern "C" {
    pub fn dsa_startup();
}
#[pg_guard]
extern "C" {
    pub fn dsa_create(tranche_id: ::std::os::raw::c_int) -> *mut dsa_area;
}
#[pg_guard]
extern "C" {
    pub fn dsa_create_in_place(
        place: *mut ::std::os::raw::c_void,
        size: usize,
        tranche_id: ::std::os::raw::c_int,
        segment: *mut dsm_segment,
    ) -> *mut dsa_area;
}
#[pg_guard]
extern "C" {
    pub fn dsa_attach(handle: dsa_handle) -> *mut dsa_area;
}
#[pg_guard]
extern "C" {
    pub fn dsa_attach_in_place(
        place: *mut ::std::os::raw::c_void,
        segment: *mut dsm_segment,
    ) -> *mut dsa_area;
}
#[pg_guard]
extern "C" {
    pub fn dsa_release_in_place(place: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn dsa_on_dsm_detach_release_in_place(arg1: *mut dsm_segment, arg2: Datum);
}
#[pg_guard]
extern "C" {
    pub fn dsa_on_shmem_exit_release_in_place(arg1: ::std::os::raw::c_int, arg2: Datum);
}
#[pg_guard]
extern "C" {
    pub fn dsa_pin_mapping(area: *mut dsa_area);
}
#[pg_guard]
extern "C" {
    pub fn dsa_detach(area: *mut dsa_area);
}
#[pg_guard]
extern "C" {
    pub fn dsa_pin(area: *mut dsa_area);
}
#[pg_guard]
extern "C" {
    pub fn dsa_unpin(area: *mut dsa_area);
}
#[pg_guard]
extern "C" {
    pub fn dsa_set_size_limit(area: *mut dsa_area, limit: usize);
}
#[pg_guard]
extern "C" {
    pub fn dsa_minimum_size() -> usize;
}
#[pg_guard]
extern "C" {
    pub fn dsa_get_handle(area: *mut dsa_area) -> dsa_handle;
}
#[pg_guard]
extern "C" {
    pub fn dsa_allocate_extended(
        area: *mut dsa_area,
        size: usize,
        flags: ::std::os::raw::c_int,
    ) -> dsa_pointer;
}
#[pg_guard]
extern "C" {
    pub fn dsa_free(area: *mut dsa_area, dp: dsa_pointer);
}
#[pg_guard]
extern "C" {
    pub fn dsa_get_address(area: *mut dsa_area, dp: dsa_pointer) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn dsa_trim(area: *mut dsa_area);
}
#[pg_guard]
extern "C" {
    pub fn dsa_dump(area: *mut dsa_area);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TIDBitmap {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMSharedIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TBMIterateResult {
    pub blockno: BlockNumber,
    pub ntuples: ::std::os::raw::c_int,
    pub recheck: bool,
    pub offsets: __IncompleteArrayField<OffsetNumber>,
}
#[pg_guard]
extern "C" {
    pub fn tbm_create(maxbytes: ::std::os::raw::c_long, dsa: *mut dsa_area) -> *mut TIDBitmap;
}
#[pg_guard]
extern "C" {
    pub fn tbm_free(tbm: *mut TIDBitmap);
}
#[pg_guard]
extern "C" {
    pub fn tbm_free_shared_area(dsa: *mut dsa_area, dp: dsa_pointer);
}
#[pg_guard]
extern "C" {
    pub fn tbm_add_tuples(
        tbm: *mut TIDBitmap,
        tids: ItemPointer,
        ntids: ::std::os::raw::c_int,
        recheck: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn tbm_add_page(tbm: *mut TIDBitmap, pageno: BlockNumber);
}
#[pg_guard]
extern "C" {
    pub fn tbm_union(a: *mut TIDBitmap, b: *const TIDBitmap);
}
#[pg_guard]
extern "C" {
    pub fn tbm_intersect(a: *mut TIDBitmap, b: *const TIDBitmap);
}
#[pg_guard]
extern "C" {
    pub fn tbm_is_empty(tbm: *const TIDBitmap) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn tbm_begin_iterate(tbm: *mut TIDBitmap) -> *mut TBMIterator;
}
#[pg_guard]
extern "C" {
    pub fn tbm_prepare_shared_iterate(tbm: *mut TIDBitmap) -> dsa_pointer;
}
#[pg_guard]
extern "C" {
    pub fn tbm_iterate(iterator: *mut TBMIterator) -> *mut TBMIterateResult;
}
#[pg_guard]
extern "C" {
    pub fn tbm_shared_iterate(iterator: *mut TBMSharedIterator) -> *mut TBMIterateResult;
}
#[pg_guard]
extern "C" {
    pub fn tbm_end_iterate(iterator: *mut TBMIterator);
}
#[pg_guard]
extern "C" {
    pub fn tbm_end_shared_iterate(iterator: *mut TBMSharedIterator);
}
#[pg_guard]
extern "C" {
    pub fn tbm_attach_shared_iterate(dsa: *mut dsa_area, dp: dsa_pointer)
        -> *mut TBMSharedIterator;
}
pub type LOCKMASK = ::std::os::raw::c_int;
pub type LOCKMODE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_standby_lock {
    pub xid: TransactionId,
    pub dbOid: Oid,
    pub relOid: Oid,
}
pub type bitmapword = uint32;
pub type signedbitmapword = int32;
#[repr(C)]
#[derive(Debug, Default)]
pub struct Bitmapset {
    pub nwords: ::std::os::raw::c_int,
    pub words: __IncompleteArrayField<bitmapword>,
}
pub const BMS_Comparison_BMS_EQUAL: BMS_Comparison = 0;
pub const BMS_Comparison_BMS_SUBSET1: BMS_Comparison = 1;
pub const BMS_Comparison_BMS_SUBSET2: BMS_Comparison = 2;
pub const BMS_Comparison_BMS_DIFFERENT: BMS_Comparison = 3;
pub type BMS_Comparison = ::std::os::raw::c_uint;
pub const BMS_Membership_BMS_EMPTY_SET: BMS_Membership = 0;
pub const BMS_Membership_BMS_SINGLETON: BMS_Membership = 1;
pub const BMS_Membership_BMS_MULTIPLE: BMS_Membership = 2;
pub type BMS_Membership = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn bms_copy(a: *const Bitmapset) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_equal(a: *const Bitmapset, b: *const Bitmapset) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn bms_make_singleton(x: ::std::os::raw::c_int) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_free(a: *mut Bitmapset);
}
#[pg_guard]
extern "C" {
    pub fn bms_union(a: *const Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_intersect(a: *const Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_difference(a: *const Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_is_subset(a: *const Bitmapset, b: *const Bitmapset) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn bms_subset_compare(a: *const Bitmapset, b: *const Bitmapset) -> BMS_Comparison;
}
#[pg_guard]
extern "C" {
    pub fn bms_is_member(x: ::std::os::raw::c_int, a: *const Bitmapset) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn bms_overlap(a: *const Bitmapset, b: *const Bitmapset) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn bms_overlap_list(a: *const Bitmapset, b: *const List) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn bms_nonempty_difference(a: *const Bitmapset, b: *const Bitmapset) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn bms_singleton_member(a: *const Bitmapset) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn bms_get_singleton_member(
        a: *const Bitmapset,
        member: *mut ::std::os::raw::c_int,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn bms_num_members(a: *const Bitmapset) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn bms_membership(a: *const Bitmapset) -> BMS_Membership;
}
#[pg_guard]
extern "C" {
    pub fn bms_is_empty(a: *const Bitmapset) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn bms_add_member(a: *mut Bitmapset, x: ::std::os::raw::c_int) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_del_member(a: *mut Bitmapset, x: ::std::os::raw::c_int) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_add_members(a: *mut Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_int_members(a: *mut Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_del_members(a: *mut Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_join(a: *mut Bitmapset, b: *mut Bitmapset) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn bms_first_member(a: *mut Bitmapset) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn bms_next_member(
        a: *const Bitmapset,
        prevbit: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn bms_hash_value(a: *const Bitmapset) -> uint32;
}
pub type Relation = *mut RelationData;
pub type RelationPtr = *mut Relation;
#[pg_guard]
extern "C" {
    pub fn RelationIdGetRelation(relationId: Oid) -> Relation;
}
#[pg_guard]
extern "C" {
    pub fn RelationClose(relation: Relation);
}
#[pg_guard]
extern "C" {
    pub fn RelationGetFKeyList(relation: Relation) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetIndexList(relation: Relation) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetStatExtList(relation: Relation) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetOidIndex(relation: Relation) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetPrimaryKeyIndex(relation: Relation) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetReplicaIndex(relation: Relation) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetIndexExpressions(relation: Relation) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetDummyIndexExpressions(relation: Relation) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetIndexPredicate(relation: Relation) -> *mut List;
}
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_ALL: IndexAttrBitmapKind = 0;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_KEY: IndexAttrBitmapKind = 1;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_PRIMARY_KEY: IndexAttrBitmapKind = 2;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_IDENTITY_KEY: IndexAttrBitmapKind = 3;
pub type IndexAttrBitmapKind = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn RelationGetIndexAttrBitmap(
        relation: Relation,
        keyAttrs: IndexAttrBitmapKind,
    ) -> *mut Bitmapset;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetExclusionInfo(
        indexRelation: Relation,
        operators: *mut *mut Oid,
        procs: *mut *mut Oid,
        strategies: *mut *mut uint16,
    );
}
#[pg_guard]
extern "C" {
    pub fn RelationSetIndexList(relation: Relation, indexIds: *mut List, oidIndex: Oid);
}
#[pg_guard]
extern "C" {
    pub fn RelationInitIndexAccessInfo(relation: Relation);
}
#[pg_guard]
extern "C" {
    pub fn GetRelationPublicationActions(relation: Relation) -> *mut PublicationActions;
}
#[pg_guard]
extern "C" {
    pub fn errtable(rel: Relation) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errtablecol(rel: Relation, attnum: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errtablecolname(
        rel: Relation,
        colname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn errtableconstraint(
        rel: Relation,
        conname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn RelationCacheInitialize();
}
#[pg_guard]
extern "C" {
    pub fn RelationCacheInitializePhase2();
}
#[pg_guard]
extern "C" {
    pub fn RelationCacheInitializePhase3();
}
#[pg_guard]
extern "C" {
    pub fn RelationBuildLocalRelation(
        relname: *const ::std::os::raw::c_char,
        relnamespace: Oid,
        tupDesc: TupleDesc,
        relid: Oid,
        relfilenode: Oid,
        reltablespace: Oid,
        shared_relation: bool,
        mapped_relation: bool,
        relpersistence: ::std::os::raw::c_char,
        relkind: ::std::os::raw::c_char,
    ) -> Relation;
}
#[pg_guard]
extern "C" {
    pub fn RelationSetNewRelfilenode(
        relation: Relation,
        persistence: ::std::os::raw::c_char,
        freezeXid: TransactionId,
        minmulti: MultiXactId,
    );
}
#[pg_guard]
extern "C" {
    pub fn RelationForgetRelation(rid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn RelationCacheInvalidateEntry(relationId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn RelationCacheInvalidate();
}
#[pg_guard]
extern "C" {
    pub fn RelationCloseSmgrByOid(relationId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn AtEOXact_RelationCache(isCommit: bool);
}
#[pg_guard]
extern "C" {
    pub fn AtEOSubXact_RelationCache(
        isCommit: bool,
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
    );
}
#[pg_guard]
extern "C" {
    pub fn RelationIdIsInInitFile(relationId: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn RelationCacheInitFilePreInvalidate();
}
#[pg_guard]
extern "C" {
    pub fn RelationCacheInitFilePostInvalidate();
}
#[pg_guard]
extern "C" {
    pub fn RelationCacheInitFileRemove();
}
#[pg_guard]
extern "C" {
    pub static mut criticalRelcachesBuilt: bool;
}
#[pg_guard]
extern "C" {
    pub static mut criticalSharedRelcachesBuilt: bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct flock {
    pub l_start: off_t,
    pub l_len: off_t,
    pub l_pid: pid_t,
    pub l_type: ::std::os::raw::c_short,
    pub l_whence: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __darwin_time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct flocktimeout {
    pub fl: flock,
    pub timeout: timespec,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct radvisory {
    pub ra_offset: off_t,
    pub ra_count: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fsignatures {
    pub fs_file_start: off_t,
    pub fs_blob_start: *mut ::std::os::raw::c_void,
    pub fs_blob_size: usize,
    pub fs_fsignatures_size: usize,
    pub fs_cdhash: [::std::os::raw::c_char; 20usize],
    pub fs_hash_type: ::std::os::raw::c_int,
}
impl Default for fsignatures {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type fsignatures_t = fsignatures;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fsupplement {
    pub fs_file_start: off_t,
    pub fs_blob_start: off_t,
    pub fs_blob_size: usize,
    pub fs_orig_fd: ::std::os::raw::c_int,
}
pub type fsupplement_t = fsupplement;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fchecklv {
    pub lv_file_start: off_t,
    pub lv_error_message_size: usize,
    pub lv_error_message: *mut ::std::os::raw::c_void,
}
impl Default for fchecklv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type fchecklv_t = fchecklv;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fgetsigsinfo {
    pub fg_file_start: off_t,
    pub fg_info_request: ::std::os::raw::c_int,
    pub fg_sig_is_platform: ::std::os::raw::c_int,
}
pub type fgetsigsinfo_t = fgetsigsinfo;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fstore {
    pub fst_flags: ::std::os::raw::c_uint,
    pub fst_posmode: ::std::os::raw::c_int,
    pub fst_offset: off_t,
    pub fst_length: off_t,
    pub fst_bytesalloc: off_t,
}
pub type fstore_t = fstore;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fpunchhole {
    pub fp_flags: ::std::os::raw::c_uint,
    pub reserved: ::std::os::raw::c_uint,
    pub fp_offset: off_t,
    pub fp_length: off_t,
}
pub type fpunchhole_t = fpunchhole;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ftrimactivefile {
    pub fta_offset: off_t,
    pub fta_length: off_t,
}
pub type ftrimactivefile_t = ftrimactivefile;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fspecread {
    pub fsr_flags: ::std::os::raw::c_uint,
    pub reserved: ::std::os::raw::c_uint,
    pub fsr_offset: off_t,
    pub fsr_length: off_t,
}
pub type fspecread_t = fspecread;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fbootstraptransfer {
    pub fbt_offset: off_t,
    pub fbt_length: usize,
    pub fbt_buffer: *mut ::std::os::raw::c_void,
}
impl Default for fbootstraptransfer {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type fbootstraptransfer_t = fbootstraptransfer;
#[repr(C, packed(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct log2phys {
    pub l2p_flags: ::std::os::raw::c_uint,
    pub l2p_contigbytes: off_t,
    pub l2p_devoffset: off_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _filesec {
    _unused: [u8; 0],
}
pub type filesec_t = *mut _filesec;
pub const filesec_property_t_FILESEC_OWNER: filesec_property_t = 1;
pub const filesec_property_t_FILESEC_GROUP: filesec_property_t = 2;
pub const filesec_property_t_FILESEC_UUID: filesec_property_t = 3;
pub const filesec_property_t_FILESEC_MODE: filesec_property_t = 4;
pub const filesec_property_t_FILESEC_ACL: filesec_property_t = 5;
pub const filesec_property_t_FILESEC_GRPUUID: filesec_property_t = 6;
pub const filesec_property_t_FILESEC_ACL_RAW: filesec_property_t = 100;
pub const filesec_property_t_FILESEC_ACL_ALLOCSIZE: filesec_property_t = 101;
pub type filesec_property_t = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn open(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn openat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn creat(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn fcntl(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn openx_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn open_dprotected_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn flock(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn filesec_init() -> filesec_t;
}
#[pg_guard]
extern "C" {
    pub fn filesec_dup(arg1: filesec_t) -> filesec_t;
}
#[pg_guard]
extern "C" {
    pub fn filesec_free(arg1: filesec_t);
}
#[pg_guard]
extern "C" {
    pub fn filesec_get_property(
        arg1: filesec_t,
        arg2: filesec_property_t,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn filesec_query_property(
        arg1: filesec_t,
        arg2: filesec_property_t,
        arg3: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn filesec_set_property(
        arg1: filesec_t,
        arg2: filesec_property_t,
        arg3: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn filesec_unset_property(
        arg1: filesec_t,
        arg2: filesec_property_t,
    ) -> ::std::os::raw::c_int;
}
pub type XLogRecPtr = uint64;
pub type XLogSegNo = uint64;
pub type TimeLineID = uint32;
pub type RepOriginId = uint16;
pub type Timestamp = int64;
pub type TimestampTz = int64;
pub type TimeOffset = int64;
pub type fsec_t = int32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Interval {
    pub time: TimeOffset,
    pub day: int32,
    pub month: int32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StringInfoData {
    pub data: *mut ::std::os::raw::c_char,
    pub len: ::std::os::raw::c_int,
    pub maxlen: ::std::os::raw::c_int,
    pub cursor: ::std::os::raw::c_int,
}
impl Default for StringInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type StringInfo = *mut StringInfoData;
#[pg_guard]
extern "C" {
    pub fn makeStringInfo() -> StringInfo;
}
#[pg_guard]
extern "C" {
    pub fn initStringInfo(str_: StringInfo);
}
#[pg_guard]
extern "C" {
    pub fn resetStringInfo(str_: StringInfo);
}
#[pg_guard]
extern "C" {
    pub fn appendStringInfo(str_: StringInfo, fmt: *const ::std::os::raw::c_char, ...);
}
#[pg_guard]
extern "C" {
    pub fn appendStringInfoVA(
        str_: StringInfo,
        fmt: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn appendStringInfoString(str_: StringInfo, s: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn appendStringInfoChar(str_: StringInfo, ch: ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn appendStringInfoSpaces(str_: StringInfo, count: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn appendBinaryStringInfo(
        str_: StringInfo,
        data: *const ::std::os::raw::c_char,
        datalen: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn enlargeStringInfo(str_: StringInfo, needed: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap_node {
    pub first_child: *mut pairingheap_node,
    pub next_sibling: *mut pairingheap_node,
    pub prev_or_parent: *mut pairingheap_node,
}
impl Default for pairingheap_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pairingheap_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const pairingheap_node,
        b: *const pairingheap_node,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap {
    pub ph_compare: pairingheap_comparator,
    pub ph_arg: *mut ::std::os::raw::c_void,
    pub ph_root: *mut pairingheap_node,
}
impl Default for pairingheap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn pairingheap_allocate(
        compare: pairingheap_comparator,
        arg: *mut ::std::os::raw::c_void,
    ) -> *mut pairingheap;
}
#[pg_guard]
extern "C" {
    pub fn pairingheap_free(heap: *mut pairingheap);
}
#[pg_guard]
extern "C" {
    pub fn pairingheap_add(heap: *mut pairingheap, node: *mut pairingheap_node);
}
#[pg_guard]
extern "C" {
    pub fn pairingheap_first(heap: *mut pairingheap) -> *mut pairingheap_node;
}
#[pg_guard]
extern "C" {
    pub fn pairingheap_remove_first(heap: *mut pairingheap) -> *mut pairingheap_node;
}
#[pg_guard]
extern "C" {
    pub fn pairingheap_remove(heap: *mut pairingheap, node: *mut pairingheap_node);
}
pub type Snapshot = *mut SnapshotData;
pub type SnapshotSatisfiesFunc = ::std::option::Option<
    unsafe extern "C" fn(htup: HeapTuple, snapshot: Snapshot, buffer: Buffer) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SnapshotData {
    pub satisfies: SnapshotSatisfiesFunc,
    pub xmin: TransactionId,
    pub xmax: TransactionId,
    pub xip: *mut TransactionId,
    pub xcnt: uint32,
    pub subxip: *mut TransactionId,
    pub subxcnt: int32,
    pub suboverflowed: bool,
    pub takenDuringRecovery: bool,
    pub copied: bool,
    pub curcid: CommandId,
    pub speculativeToken: uint32,
    pub active_count: uint32,
    pub regd_count: uint32,
    pub ph_node: pairingheap_node,
    pub whenTaken: TimestampTz,
    pub lsn: XLogRecPtr,
}
impl Default for SnapshotData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const HTSU_Result_HeapTupleMayBeUpdated: HTSU_Result = 0;
pub const HTSU_Result_HeapTupleInvisible: HTSU_Result = 1;
pub const HTSU_Result_HeapTupleSelfUpdated: HTSU_Result = 2;
pub const HTSU_Result_HeapTupleUpdated: HTSU_Result = 3;
pub const HTSU_Result_HeapTupleBeingUpdated: HTSU_Result = 4;
pub const HTSU_Result_HeapTupleWouldBlock: HTSU_Result = 5;
pub type HTSU_Result = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexBuildResult {
    pub heap_tuples: f64,
    pub index_tuples: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexVacuumInfo {
    pub index: Relation,
    pub analyze_only: bool,
    pub estimated_count: bool,
    pub message_level: ::std::os::raw::c_int,
    pub num_heap_tuples: f64,
    pub strategy: BufferAccessStrategy,
}
impl Default for IndexVacuumInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexBulkDeleteResult {
    pub num_pages: BlockNumber,
    pub pages_removed: BlockNumber,
    pub estimated_count: bool,
    pub num_index_tuples: f64,
    pub tuples_removed: f64,
    pub pages_deleted: BlockNumber,
    pub pages_free: BlockNumber,
}
pub type IndexBulkDeleteCallback = ::std::option::Option<
    unsafe extern "C" fn(itemptr: ItemPointer, state: *mut ::std::os::raw::c_void) -> bool,
>;
pub type IndexScanDesc = *mut IndexScanDescData;
pub type SysScanDesc = *mut SysScanDescData;
pub type ParallelIndexScanDesc = *mut ParallelIndexScanDescData;
pub const IndexUniqueCheck_UNIQUE_CHECK_NO: IndexUniqueCheck = 0;
pub const IndexUniqueCheck_UNIQUE_CHECK_YES: IndexUniqueCheck = 1;
pub const IndexUniqueCheck_UNIQUE_CHECK_PARTIAL: IndexUniqueCheck = 2;
pub const IndexUniqueCheck_UNIQUE_CHECK_EXISTING: IndexUniqueCheck = 3;
pub type IndexUniqueCheck = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexOrderByDistance {
    pub value: f64,
    pub isnull: bool,
}
#[pg_guard]
extern "C" {
    pub fn index_open(relationId: Oid, lockmode: LOCKMODE) -> Relation;
}
#[pg_guard]
extern "C" {
    pub fn index_close(relation: Relation, lockmode: LOCKMODE);
}
#[pg_guard]
extern "C" {
    pub fn index_insert(
        indexRelation: Relation,
        values: *mut Datum,
        isnull: *mut bool,
        heap_t_ctid: ItemPointer,
        heapRelation: Relation,
        checkUnique: IndexUniqueCheck,
        indexInfo: *mut IndexInfo,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn index_beginscan(
        heapRelation: Relation,
        indexRelation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        norderbys: ::std::os::raw::c_int,
    ) -> IndexScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn index_beginscan_bitmap(
        indexRelation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
    ) -> IndexScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn index_rescan(
        scan: IndexScanDesc,
        keys: ScanKey,
        nkeys: ::std::os::raw::c_int,
        orderbys: ScanKey,
        norderbys: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn index_endscan(scan: IndexScanDesc);
}
#[pg_guard]
extern "C" {
    pub fn index_markpos(scan: IndexScanDesc);
}
#[pg_guard]
extern "C" {
    pub fn index_restrpos(scan: IndexScanDesc);
}
#[pg_guard]
extern "C" {
    pub fn index_parallelscan_estimate(indexrel: Relation, snapshot: Snapshot) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn index_parallelscan_initialize(
        heaprel: Relation,
        indexrel: Relation,
        snapshot: Snapshot,
        target: ParallelIndexScanDesc,
    );
}
#[pg_guard]
extern "C" {
    pub fn index_parallelrescan(scan: IndexScanDesc);
}
#[pg_guard]
extern "C" {
    pub fn index_beginscan_parallel(
        heaprel: Relation,
        indexrel: Relation,
        nkeys: ::std::os::raw::c_int,
        norderbys: ::std::os::raw::c_int,
        pscan: ParallelIndexScanDesc,
    ) -> IndexScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn index_getnext_tid(scan: IndexScanDesc, direction: ScanDirection) -> ItemPointer;
}
#[pg_guard]
extern "C" {
    pub fn index_fetch_heap(scan: IndexScanDesc) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn index_getnext(scan: IndexScanDesc, direction: ScanDirection) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn index_getbitmap(scan: IndexScanDesc, bitmap: *mut TIDBitmap) -> int64;
}
#[pg_guard]
extern "C" {
    pub fn index_bulk_delete(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
        callback: IndexBulkDeleteCallback,
        callback_state: *mut ::std::os::raw::c_void,
    ) -> *mut IndexBulkDeleteResult;
}
#[pg_guard]
extern "C" {
    pub fn index_vacuum_cleanup(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
    ) -> *mut IndexBulkDeleteResult;
}
#[pg_guard]
extern "C" {
    pub fn index_can_return(indexRelation: Relation, attno: ::std::os::raw::c_int) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn index_getprocid(irel: Relation, attnum: AttrNumber, procnum: uint16) -> RegProcedure;
}
#[pg_guard]
extern "C" {
    pub fn index_getprocinfo(irel: Relation, attnum: AttrNumber, procnum: uint16) -> *mut FmgrInfo;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetIndexScan(
        indexRelation: Relation,
        nkeys: ::std::os::raw::c_int,
        norderbys: ::std::os::raw::c_int,
    ) -> IndexScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn IndexScanEnd(scan: IndexScanDesc);
}
#[pg_guard]
extern "C" {
    pub fn BuildIndexValueDescription(
        indexRelation: Relation,
        values: *mut Datum,
        isnull: *mut bool,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn systable_beginscan(
        heapRelation: Relation,
        indexId: Oid,
        indexOK: bool,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        key: ScanKey,
    ) -> SysScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn systable_getnext(sysscan: SysScanDesc) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn systable_recheck_tuple(sysscan: SysScanDesc, tup: HeapTuple) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn systable_endscan(sysscan: SysScanDesc);
}
#[pg_guard]
extern "C" {
    pub fn systable_beginscan_ordered(
        heapRelation: Relation,
        indexRelation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        key: ScanKey,
    ) -> SysScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn systable_getnext_ordered(sysscan: SysScanDesc, direction: ScanDirection) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn systable_endscan_ordered(sysscan: SysScanDesc);
}
pub const LockClauseStrength_LCS_NONE: LockClauseStrength = 0;
pub const LockClauseStrength_LCS_FORKEYSHARE: LockClauseStrength = 1;
pub const LockClauseStrength_LCS_FORSHARE: LockClauseStrength = 2;
pub const LockClauseStrength_LCS_FORNOKEYUPDATE: LockClauseStrength = 3;
pub const LockClauseStrength_LCS_FORUPDATE: LockClauseStrength = 4;
pub type LockClauseStrength = ::std::os::raw::c_uint;
pub const LockWaitPolicy_LockWaitBlock: LockWaitPolicy = 0;
pub const LockWaitPolicy_LockWaitSkip: LockWaitPolicy = 1;
pub const LockWaitPolicy_LockWaitError: LockWaitPolicy = 2;
pub type LockWaitPolicy = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Alias {
    pub type_: NodeTag,
    pub aliasname: *mut ::std::os::raw::c_char,
    pub colnames: *mut List,
}
impl Default for Alias {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const OnCommitAction_ONCOMMIT_NOOP: OnCommitAction = 0;
pub const OnCommitAction_ONCOMMIT_PRESERVE_ROWS: OnCommitAction = 1;
pub const OnCommitAction_ONCOMMIT_DELETE_ROWS: OnCommitAction = 2;
pub const OnCommitAction_ONCOMMIT_DROP: OnCommitAction = 3;
pub type OnCommitAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeVar {
    pub type_: NodeTag,
    pub catalogname: *mut ::std::os::raw::c_char,
    pub schemaname: *mut ::std::os::raw::c_char,
    pub relname: *mut ::std::os::raw::c_char,
    pub inh: bool,
    pub relpersistence: ::std::os::raw::c_char,
    pub alias: *mut Alias,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeVar {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFunc {
    pub type_: NodeTag,
    pub ns_uris: *mut List,
    pub ns_names: *mut List,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub colnames: *mut List,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub notnulls: *mut Bitmapset,
    pub ordinalitycol: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for TableFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IntoClause {
    pub type_: NodeTag,
    pub rel: *mut RangeVar,
    pub colNames: *mut List,
    pub options: *mut List,
    pub onCommit: OnCommitAction,
    pub tableSpaceName: *mut ::std::os::raw::c_char,
    pub viewQuery: *mut Node,
    pub skipData: bool,
}
impl Default for IntoClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Expr {
    pub type_: NodeTag,
}
impl Default for Expr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Var {
    pub xpr: Expr,
    pub varno: Index,
    pub varattno: AttrNumber,
    pub vartype: Oid,
    pub vartypmod: int32,
    pub varcollid: Oid,
    pub varlevelsup: Index,
    pub varnoold: Index,
    pub varoattno: AttrNumber,
    pub location: ::std::os::raw::c_int,
}
impl Default for Var {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Const {
    pub xpr: Expr,
    pub consttype: Oid,
    pub consttypmod: int32,
    pub constcollid: Oid,
    pub constlen: ::std::os::raw::c_int,
    pub constvalue: Datum,
    pub constisnull: bool,
    pub constbyval: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for Const {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ParamKind_PARAM_EXTERN: ParamKind = 0;
pub const ParamKind_PARAM_EXEC: ParamKind = 1;
pub const ParamKind_PARAM_SUBLINK: ParamKind = 2;
pub const ParamKind_PARAM_MULTIEXPR: ParamKind = 3;
pub type ParamKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Param {
    pub xpr: Expr,
    pub paramkind: ParamKind,
    pub paramid: ::std::os::raw::c_int,
    pub paramtype: Oid,
    pub paramtypmod: int32,
    pub paramcollid: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for Param {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Aggref {
    pub xpr: Expr,
    pub aggfnoid: Oid,
    pub aggtype: Oid,
    pub aggcollid: Oid,
    pub inputcollid: Oid,
    pub aggtranstype: Oid,
    pub aggargtypes: *mut List,
    pub aggdirectargs: *mut List,
    pub args: *mut List,
    pub aggorder: *mut List,
    pub aggdistinct: *mut List,
    pub aggfilter: *mut Expr,
    pub aggstar: bool,
    pub aggvariadic: bool,
    pub aggkind: ::std::os::raw::c_char,
    pub agglevelsup: Index,
    pub aggsplit: AggSplit,
    pub location: ::std::os::raw::c_int,
}
impl Default for Aggref {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingFunc {
    pub xpr: Expr,
    pub args: *mut List,
    pub refs: *mut List,
    pub cols: *mut List,
    pub agglevelsup: Index,
    pub location: ::std::os::raw::c_int,
}
impl Default for GroupingFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFunc {
    pub xpr: Expr,
    pub winfnoid: Oid,
    pub wintype: Oid,
    pub wincollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub aggfilter: *mut Expr,
    pub winref: Index,
    pub winstar: bool,
    pub winagg: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for WindowFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayRef {
    pub xpr: Expr,
    pub refarraytype: Oid,
    pub refelemtype: Oid,
    pub reftypmod: int32,
    pub refcollid: Oid,
    pub refupperindexpr: *mut List,
    pub reflowerindexpr: *mut List,
    pub refexpr: *mut Expr,
    pub refassgnexpr: *mut Expr,
}
impl Default for ArrayRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CoercionContext_COERCION_IMPLICIT: CoercionContext = 0;
pub const CoercionContext_COERCION_ASSIGNMENT: CoercionContext = 1;
pub const CoercionContext_COERCION_EXPLICIT: CoercionContext = 2;
pub type CoercionContext = ::std::os::raw::c_uint;
pub const CoercionForm_COERCE_EXPLICIT_CALL: CoercionForm = 0;
pub const CoercionForm_COERCE_EXPLICIT_CAST: CoercionForm = 1;
pub const CoercionForm_COERCE_IMPLICIT_CAST: CoercionForm = 2;
pub type CoercionForm = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncExpr {
    pub xpr: Expr,
    pub funcid: Oid,
    pub funcresulttype: Oid,
    pub funcretset: bool,
    pub funcvariadic: bool,
    pub funcformat: CoercionForm,
    pub funccollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for FuncExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedArgExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub name: *mut ::std::os::raw::c_char,
    pub argnumber: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for NamedArgExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub opresulttype: Oid,
    pub opretset: bool,
    pub opcollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for OpExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type DistinctExpr = OpExpr;
pub type NullIfExpr = OpExpr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScalarArrayOpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub useOr: bool,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ScalarArrayOpExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BoolExprType_AND_EXPR: BoolExprType = 0;
pub const BoolExprType_OR_EXPR: BoolExprType = 1;
pub const BoolExprType_NOT_EXPR: BoolExprType = 2;
pub type BoolExprType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BoolExpr {
    pub xpr: Expr,
    pub boolop: BoolExprType,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for BoolExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SubLinkType_EXISTS_SUBLINK: SubLinkType = 0;
pub const SubLinkType_ALL_SUBLINK: SubLinkType = 1;
pub const SubLinkType_ANY_SUBLINK: SubLinkType = 2;
pub const SubLinkType_ROWCOMPARE_SUBLINK: SubLinkType = 3;
pub const SubLinkType_EXPR_SUBLINK: SubLinkType = 4;
pub const SubLinkType_MULTIEXPR_SUBLINK: SubLinkType = 5;
pub const SubLinkType_ARRAY_SUBLINK: SubLinkType = 6;
pub const SubLinkType_CTE_SUBLINK: SubLinkType = 7;
pub type SubLinkType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubLink {
    pub xpr: Expr,
    pub subLinkType: SubLinkType,
    pub subLinkId: ::std::os::raw::c_int,
    pub testexpr: *mut Node,
    pub operName: *mut List,
    pub subselect: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for SubLink {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlan {
    pub xpr: Expr,
    pub subLinkType: SubLinkType,
    pub testexpr: *mut Node,
    pub paramIds: *mut List,
    pub plan_id: ::std::os::raw::c_int,
    pub plan_name: *mut ::std::os::raw::c_char,
    pub firstColType: Oid,
    pub firstColTypmod: int32,
    pub firstColCollation: Oid,
    pub useHashTable: bool,
    pub unknownEqFalse: bool,
    pub parallel_safe: bool,
    pub setParam: *mut List,
    pub parParam: *mut List,
    pub args: *mut List,
    pub startup_cost: Cost,
    pub per_call_cost: Cost,
}
impl Default for SubPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlternativeSubPlan {
    pub xpr: Expr,
    pub subplans: *mut List,
}
impl Default for AlternativeSubPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldSelect {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub fieldnum: AttrNumber,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
}
impl Default for FieldSelect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldStore {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub newvals: *mut List,
    pub fieldnums: *mut List,
    pub resulttype: Oid,
}
impl Default for FieldStore {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelabelType {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub relabelformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for RelabelType {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceViaIO {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceViaIO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayCoerceExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub elemfuncid: Oid,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub isExplicit: bool,
    pub coerceformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for ArrayCoerceExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConvertRowtypeExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub convertformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for ConvertRowtypeExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub collOid: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for CollateExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseExpr {
    pub xpr: Expr,
    pub casetype: Oid,
    pub casecollid: Oid,
    pub arg: *mut Expr,
    pub args: *mut List,
    pub defresult: *mut Expr,
    pub location: ::std::os::raw::c_int,
}
impl Default for CaseExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseWhen {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub result: *mut Expr,
    pub location: ::std::os::raw::c_int,
}
impl Default for CaseWhen {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseTestExpr {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
}
impl Default for CaseTestExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayExpr {
    pub xpr: Expr,
    pub array_typeid: Oid,
    pub array_collid: Oid,
    pub element_typeid: Oid,
    pub elements: *mut List,
    pub multidims: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for ArrayExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowExpr {
    pub xpr: Expr,
    pub args: *mut List,
    pub row_typeid: Oid,
    pub row_format: CoercionForm,
    pub colnames: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for RowExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RowCompareType_ROWCOMPARE_LT: RowCompareType = 1;
pub const RowCompareType_ROWCOMPARE_LE: RowCompareType = 2;
pub const RowCompareType_ROWCOMPARE_EQ: RowCompareType = 3;
pub const RowCompareType_ROWCOMPARE_GE: RowCompareType = 4;
pub const RowCompareType_ROWCOMPARE_GT: RowCompareType = 5;
pub const RowCompareType_ROWCOMPARE_NE: RowCompareType = 6;
pub type RowCompareType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowCompareExpr {
    pub xpr: Expr,
    pub rctype: RowCompareType,
    pub opnos: *mut List,
    pub opfamilies: *mut List,
    pub inputcollids: *mut List,
    pub largs: *mut List,
    pub rargs: *mut List,
}
impl Default for RowCompareExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoalesceExpr {
    pub xpr: Expr,
    pub coalescetype: Oid,
    pub coalescecollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoalesceExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const MinMaxOp_IS_GREATEST: MinMaxOp = 0;
pub const MinMaxOp_IS_LEAST: MinMaxOp = 1;
pub type MinMaxOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinMaxExpr {
    pub xpr: Expr,
    pub minmaxtype: Oid,
    pub minmaxcollid: Oid,
    pub inputcollid: Oid,
    pub op: MinMaxOp,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for MinMaxExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SQLValueFunctionOp_SVFOP_CURRENT_DATE: SQLValueFunctionOp = 0;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIME: SQLValueFunctionOp = 1;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIME_N: SQLValueFunctionOp = 2;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIMESTAMP: SQLValueFunctionOp = 3;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIMESTAMP_N: SQLValueFunctionOp = 4;
pub const SQLValueFunctionOp_SVFOP_LOCALTIME: SQLValueFunctionOp = 5;
pub const SQLValueFunctionOp_SVFOP_LOCALTIME_N: SQLValueFunctionOp = 6;
pub const SQLValueFunctionOp_SVFOP_LOCALTIMESTAMP: SQLValueFunctionOp = 7;
pub const SQLValueFunctionOp_SVFOP_LOCALTIMESTAMP_N: SQLValueFunctionOp = 8;
pub const SQLValueFunctionOp_SVFOP_CURRENT_ROLE: SQLValueFunctionOp = 9;
pub const SQLValueFunctionOp_SVFOP_CURRENT_USER: SQLValueFunctionOp = 10;
pub const SQLValueFunctionOp_SVFOP_USER: SQLValueFunctionOp = 11;
pub const SQLValueFunctionOp_SVFOP_SESSION_USER: SQLValueFunctionOp = 12;
pub const SQLValueFunctionOp_SVFOP_CURRENT_CATALOG: SQLValueFunctionOp = 13;
pub const SQLValueFunctionOp_SVFOP_CURRENT_SCHEMA: SQLValueFunctionOp = 14;
pub type SQLValueFunctionOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SQLValueFunction {
    pub xpr: Expr,
    pub op: SQLValueFunctionOp,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::std::os::raw::c_int,
}
impl Default for SQLValueFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const XmlExprOp_IS_XMLCONCAT: XmlExprOp = 0;
pub const XmlExprOp_IS_XMLELEMENT: XmlExprOp = 1;
pub const XmlExprOp_IS_XMLFOREST: XmlExprOp = 2;
pub const XmlExprOp_IS_XMLPARSE: XmlExprOp = 3;
pub const XmlExprOp_IS_XMLPI: XmlExprOp = 4;
pub const XmlExprOp_IS_XMLROOT: XmlExprOp = 5;
pub const XmlExprOp_IS_XMLSERIALIZE: XmlExprOp = 6;
pub const XmlExprOp_IS_DOCUMENT: XmlExprOp = 7;
pub type XmlExprOp = ::std::os::raw::c_uint;
pub const XmlOptionType_XMLOPTION_DOCUMENT: XmlOptionType = 0;
pub const XmlOptionType_XMLOPTION_CONTENT: XmlOptionType = 1;
pub type XmlOptionType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlExpr {
    pub xpr: Expr,
    pub op: XmlExprOp,
    pub name: *mut ::std::os::raw::c_char,
    pub named_args: *mut List,
    pub arg_names: *mut List,
    pub args: *mut List,
    pub xmloption: XmlOptionType,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::std::os::raw::c_int,
}
impl Default for XmlExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const NullTestType_IS_NULL: NullTestType = 0;
pub const NullTestType_IS_NOT_NULL: NullTestType = 1;
pub type NullTestType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NullTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub nulltesttype: NullTestType,
    pub argisrow: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for NullTest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BoolTestType_IS_TRUE: BoolTestType = 0;
pub const BoolTestType_IS_NOT_TRUE: BoolTestType = 1;
pub const BoolTestType_IS_FALSE: BoolTestType = 2;
pub const BoolTestType_IS_NOT_FALSE: BoolTestType = 3;
pub const BoolTestType_IS_UNKNOWN: BoolTestType = 4;
pub const BoolTestType_IS_NOT_UNKNOWN: BoolTestType = 5;
pub type BoolTestType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BooleanTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub booltesttype: BoolTestType,
    pub location: ::std::os::raw::c_int,
}
impl Default for BooleanTest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomain {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coercionformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceToDomain {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomainValue {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceToDomainValue {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetToDefault {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for SetToDefault {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CurrentOfExpr {
    pub xpr: Expr,
    pub cvarno: Index,
    pub cursor_name: *mut ::std::os::raw::c_char,
    pub cursor_param: ::std::os::raw::c_int,
}
impl Default for CurrentOfExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NextValueExpr {
    pub xpr: Expr,
    pub seqid: Oid,
    pub typeId: Oid,
}
impl Default for NextValueExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferenceElem {
    pub xpr: Expr,
    pub expr: *mut Node,
    pub infercollid: Oid,
    pub inferopclass: Oid,
}
impl Default for InferenceElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TargetEntry {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub resno: AttrNumber,
    pub resname: *mut ::std::os::raw::c_char,
    pub ressortgroupref: Index,
    pub resorigtbl: Oid,
    pub resorigcol: AttrNumber,
    pub resjunk: bool,
}
impl Default for TargetEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblRef {
    pub type_: NodeTag,
    pub rtindex: ::std::os::raw::c_int,
}
impl Default for RangeTblRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinExpr {
    pub type_: NodeTag,
    pub jointype: JoinType,
    pub isNatural: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub usingClause: *mut List,
    pub quals: *mut Node,
    pub alias: *mut Alias,
    pub rtindex: ::std::os::raw::c_int,
}
impl Default for JoinExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FromExpr {
    pub type_: NodeTag,
    pub fromlist: *mut List,
    pub quals: *mut Node,
}
impl Default for FromExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictExpr {
    pub type_: NodeTag,
    pub action: OnConflictAction,
    pub arbiterElems: *mut List,
    pub arbiterWhere: *mut Node,
    pub constraint: Oid,
    pub onConflictSet: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelIndex: ::std::os::raw::c_int,
    pub exclRelTlist: *mut List,
}
impl Default for OnConflictExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Item = Pointer;
pub type Page = Pointer;
pub type LocationIndex = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PageXLogRecPtr {
    pub xlogid: uint32,
    pub xrecoff: uint32,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct PageHeaderData {
    pub pd_lsn: PageXLogRecPtr,
    pub pd_checksum: uint16,
    pub pd_flags: uint16,
    pub pd_lower: LocationIndex,
    pub pd_upper: LocationIndex,
    pub pd_special: LocationIndex,
    pub pd_pagesize_version: uint16,
    pub pd_prune_xid: TransactionId,
    pub pd_linp: __IncompleteArrayField<ItemIdData>,
}
pub type PageHeader = *mut PageHeaderData;
#[pg_guard]
extern "C" {
    pub fn PageInit(page: Page, pageSize: Size, specialSize: Size);
}
#[pg_guard]
extern "C" {
    pub fn PageIsVerified(page: Page, blkno: BlockNumber) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn PageAddItemExtended(
        page: Page,
        item: Item,
        size: Size,
        offsetNumber: OffsetNumber,
        flags: ::std::os::raw::c_int,
    ) -> OffsetNumber;
}
#[pg_guard]
extern "C" {
    pub fn PageGetTempPage(page: Page) -> Page;
}
#[pg_guard]
extern "C" {
    pub fn PageGetTempPageCopy(page: Page) -> Page;
}
#[pg_guard]
extern "C" {
    pub fn PageGetTempPageCopySpecial(page: Page) -> Page;
}
#[pg_guard]
extern "C" {
    pub fn PageRestoreTempPage(tempPage: Page, oldPage: Page);
}
#[pg_guard]
extern "C" {
    pub fn PageRepairFragmentation(page: Page);
}
#[pg_guard]
extern "C" {
    pub fn PageGetFreeSpace(page: Page) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn PageGetFreeSpaceForMultipleTuples(page: Page, ntups: ::std::os::raw::c_int) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn PageGetExactFreeSpace(page: Page) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn PageGetHeapFreeSpace(page: Page) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn PageIndexTupleDelete(page: Page, offset: OffsetNumber);
}
#[pg_guard]
extern "C" {
    pub fn PageIndexMultiDelete(
        page: Page,
        itemnos: *mut OffsetNumber,
        nitems: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn PageIndexTupleDeleteNoCompact(page: Page, offset: OffsetNumber);
}
#[pg_guard]
extern "C" {
    pub fn PageIndexTupleOverwrite(
        page: Page,
        offnum: OffsetNumber,
        newtup: Item,
        newsize: Size,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn PageSetChecksumCopy(page: Page, blkno: BlockNumber) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn PageSetChecksumInplace(page: Page, blkno: BlockNumber);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BulkInsertStateData {
    _unused: [u8; 0],
}
pub type BulkInsertState = *mut BulkInsertStateData;
pub const LockTupleMode_LockTupleKeyShare: LockTupleMode = 0;
pub const LockTupleMode_LockTupleShare: LockTupleMode = 1;
pub const LockTupleMode_LockTupleNoKeyExclusive: LockTupleMode = 2;
pub const LockTupleMode_LockTupleExclusive: LockTupleMode = 3;
pub type LockTupleMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct HeapUpdateFailureData {
    pub ctid: ItemPointerData,
    pub xmax: TransactionId,
    pub cmax: CommandId,
}
#[pg_guard]
extern "C" {
    pub fn relation_open(relationId: Oid, lockmode: LOCKMODE) -> Relation;
}
#[pg_guard]
extern "C" {
    pub fn try_relation_open(relationId: Oid, lockmode: LOCKMODE) -> Relation;
}
#[pg_guard]
extern "C" {
    pub fn relation_openrv(relation: *const RangeVar, lockmode: LOCKMODE) -> Relation;
}
#[pg_guard]
extern "C" {
    pub fn relation_openrv_extended(
        relation: *const RangeVar,
        lockmode: LOCKMODE,
        missing_ok: bool,
    ) -> Relation;
}
#[pg_guard]
extern "C" {
    pub fn relation_close(relation: Relation, lockmode: LOCKMODE);
}
#[pg_guard]
extern "C" {
    pub fn heap_open(relationId: Oid, lockmode: LOCKMODE) -> Relation;
}
#[pg_guard]
extern "C" {
    pub fn heap_openrv(relation: *const RangeVar, lockmode: LOCKMODE) -> Relation;
}
#[pg_guard]
extern "C" {
    pub fn heap_openrv_extended(
        relation: *const RangeVar,
        lockmode: LOCKMODE,
        missing_ok: bool,
    ) -> Relation;
}
pub type HeapScanDesc = *mut HeapScanDescData;
pub type ParallelHeapScanDesc = *mut ParallelHeapScanDescData;
#[pg_guard]
extern "C" {
    pub fn heap_beginscan(
        relation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        key: ScanKey,
    ) -> HeapScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn heap_beginscan_catalog(
        relation: Relation,
        nkeys: ::std::os::raw::c_int,
        key: ScanKey,
    ) -> HeapScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn heap_beginscan_strat(
        relation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        key: ScanKey,
        allow_strat: bool,
        allow_sync: bool,
    ) -> HeapScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn heap_beginscan_bm(
        relation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        key: ScanKey,
    ) -> HeapScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn heap_beginscan_sampling(
        relation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        key: ScanKey,
        allow_strat: bool,
        allow_sync: bool,
        allow_pagemode: bool,
    ) -> HeapScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn heap_setscanlimits(scan: HeapScanDesc, startBlk: BlockNumber, endBlk: BlockNumber);
}
#[pg_guard]
extern "C" {
    pub fn heapgetpage(scan: HeapScanDesc, page: BlockNumber);
}
#[pg_guard]
extern "C" {
    pub fn heap_rescan(scan: HeapScanDesc, key: ScanKey);
}
#[pg_guard]
extern "C" {
    pub fn heap_rescan_set_params(
        scan: HeapScanDesc,
        key: ScanKey,
        allow_strat: bool,
        allow_sync: bool,
        allow_pagemode: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn heap_endscan(scan: HeapScanDesc);
}
#[pg_guard]
extern "C" {
    pub fn heap_getnext(scan: HeapScanDesc, direction: ScanDirection) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn heap_parallelscan_estimate(snapshot: Snapshot) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn heap_parallelscan_initialize(
        target: ParallelHeapScanDesc,
        relation: Relation,
        snapshot: Snapshot,
    );
}
#[pg_guard]
extern "C" {
    pub fn heap_parallelscan_reinitialize(parallel_scan: ParallelHeapScanDesc);
}
#[pg_guard]
extern "C" {
    pub fn heap_beginscan_parallel(arg1: Relation, arg2: ParallelHeapScanDesc) -> HeapScanDesc;
}
#[pg_guard]
extern "C" {
    pub fn heap_fetch(
        relation: Relation,
        snapshot: Snapshot,
        tuple: HeapTuple,
        userbuf: *mut Buffer,
        keep_buf: bool,
        stats_relation: Relation,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn heap_hot_search_buffer(
        tid: ItemPointer,
        relation: Relation,
        buffer: Buffer,
        snapshot: Snapshot,
        heapTuple: HeapTuple,
        all_dead: *mut bool,
        first_call: bool,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn heap_hot_search(
        tid: ItemPointer,
        relation: Relation,
        snapshot: Snapshot,
        all_dead: *mut bool,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn heap_get_latest_tid(relation: Relation, snapshot: Snapshot, tid: ItemPointer);
}
#[pg_guard]
extern "C" {
    pub fn setLastTid(tid: ItemPointer);
}
#[pg_guard]
extern "C" {
    pub fn GetBulkInsertState() -> BulkInsertState;
}
#[pg_guard]
extern "C" {
    pub fn FreeBulkInsertState(arg1: BulkInsertState);
}
#[pg_guard]
extern "C" {
    pub fn ReleaseBulkInsertStatePin(bistate: BulkInsertState);
}
#[pg_guard]
extern "C" {
    pub fn heap_insert(
        relation: Relation,
        tup: HeapTuple,
        cid: CommandId,
        options: ::std::os::raw::c_int,
        bistate: BulkInsertState,
    ) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn heap_multi_insert(
        relation: Relation,
        tuples: *mut HeapTuple,
        ntuples: ::std::os::raw::c_int,
        cid: CommandId,
        options: ::std::os::raw::c_int,
        bistate: BulkInsertState,
    );
}
#[pg_guard]
extern "C" {
    pub fn heap_delete(
        relation: Relation,
        tid: ItemPointer,
        cid: CommandId,
        crosscheck: Snapshot,
        wait: bool,
        hufd: *mut HeapUpdateFailureData,
    ) -> HTSU_Result;
}
#[pg_guard]
extern "C" {
    pub fn heap_finish_speculative(relation: Relation, tuple: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn heap_abort_speculative(relation: Relation, tuple: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn heap_update(
        relation: Relation,
        otid: ItemPointer,
        newtup: HeapTuple,
        cid: CommandId,
        crosscheck: Snapshot,
        wait: bool,
        hufd: *mut HeapUpdateFailureData,
        lockmode: *mut LockTupleMode,
    ) -> HTSU_Result;
}
#[pg_guard]
extern "C" {
    pub fn heap_lock_tuple(
        relation: Relation,
        tuple: HeapTuple,
        cid: CommandId,
        mode: LockTupleMode,
        wait_policy: LockWaitPolicy,
        follow_update: bool,
        buffer: *mut Buffer,
        hufd: *mut HeapUpdateFailureData,
    ) -> HTSU_Result;
}
#[pg_guard]
extern "C" {
    pub fn heap_inplace_update(relation: Relation, tuple: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn heap_freeze_tuple(
        tuple: HeapTupleHeader,
        relfrozenxid: TransactionId,
        relminmxid: TransactionId,
        cutoff_xid: TransactionId,
        cutoff_multi: TransactionId,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn heap_tuple_needs_freeze(
        tuple: HeapTupleHeader,
        cutoff_xid: TransactionId,
        cutoff_multi: MultiXactId,
        buf: Buffer,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn heap_tuple_needs_eventual_freeze(tuple: HeapTupleHeader) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn simple_heap_insert(relation: Relation, tup: HeapTuple) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn simple_heap_delete(relation: Relation, tid: ItemPointer);
}
#[pg_guard]
extern "C" {
    pub fn simple_heap_update(relation: Relation, otid: ItemPointer, tup: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn heap_sync(relation: Relation);
}
#[pg_guard]
extern "C" {
    pub fn heap_update_snapshot(scan: HeapScanDesc, snapshot: Snapshot);
}
#[pg_guard]
extern "C" {
    pub fn heap_page_prune_opt(relation: Relation, buffer: Buffer);
}
#[pg_guard]
extern "C" {
    pub fn heap_page_prune(
        relation: Relation,
        buffer: Buffer,
        OldestXmin: TransactionId,
        report_stats: bool,
        latestRemovedXid: *mut TransactionId,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn heap_page_prune_execute(
        buffer: Buffer,
        redirected: *mut OffsetNumber,
        nredirected: ::std::os::raw::c_int,
        nowdead: *mut OffsetNumber,
        ndead: ::std::os::raw::c_int,
        nowunused: *mut OffsetNumber,
        nunused: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn heap_get_root_tuples(page: Page, root_offsets: *mut OffsetNumber);
}
#[pg_guard]
extern "C" {
    pub fn ss_report_location(rel: Relation, location: BlockNumber);
}
#[pg_guard]
extern "C" {
    pub fn ss_get_location(rel: Relation, relnblocks: BlockNumber) -> BlockNumber;
}
#[pg_guard]
extern "C" {
    pub fn SyncScanShmemInit();
}
#[pg_guard]
extern "C" {
    pub fn SyncScanShmemSize() -> Size;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConversionMap {
    pub indesc: TupleDesc,
    pub outdesc: TupleDesc,
    pub attrMap: *mut AttrNumber,
    pub invalues: *mut Datum,
    pub inisnull: *mut bool,
    pub outvalues: *mut Datum,
    pub outisnull: *mut bool,
}
impl Default for TupleConversionMap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn convert_tuples_by_position(
        indesc: TupleDesc,
        outdesc: TupleDesc,
        msg: *const ::std::os::raw::c_char,
    ) -> *mut TupleConversionMap;
}
#[pg_guard]
extern "C" {
    pub fn convert_tuples_by_name(
        indesc: TupleDesc,
        outdesc: TupleDesc,
        msg: *const ::std::os::raw::c_char,
    ) -> *mut TupleConversionMap;
}
#[pg_guard]
extern "C" {
    pub fn convert_tuples_by_name_map(
        indesc: TupleDesc,
        outdesc: TupleDesc,
        msg: *const ::std::os::raw::c_char,
    ) -> *mut AttrNumber;
}
#[pg_guard]
extern "C" {
    pub fn do_convert_tuple(tuple: HeapTuple, map: *mut TupleConversionMap) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn free_conversion_map(map: *mut TupleConversionMap);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *mut ::std::os::raw::c_char,
}
impl Default for tm {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 0usize];
}
#[pg_guard]
extern "C" {
    pub static mut getdate_err: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn asctime(arg1: *const tm) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn clock() -> clock_t;
}
#[pg_guard]
extern "C" {
    pub fn ctime(arg1: *const time_t) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn difftime(arg1: time_t, arg2: time_t) -> f64;
}
#[pg_guard]
extern "C" {
    pub fn getdate(arg1: *const ::std::os::raw::c_char) -> *mut tm;
}
#[pg_guard]
extern "C" {
    pub fn gmtime(arg1: *const time_t) -> *mut tm;
}
#[pg_guard]
extern "C" {
    pub fn localtime(arg1: *const time_t) -> *mut tm;
}
#[pg_guard]
extern "C" {
    pub fn mktime(arg1: *mut tm) -> time_t;
}
#[pg_guard]
extern "C" {
    pub fn strftime(
        arg1: *mut ::std::os::raw::c_char,
        arg2: usize,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const tm,
    ) -> usize;
}
#[pg_guard]
extern "C" {
    pub fn strptime(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut tm,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn time(arg1: *mut time_t) -> time_t;
}
#[pg_guard]
extern "C" {
    pub fn tzset();
}
#[pg_guard]
extern "C" {
    pub fn asctime_r(
        arg1: *const tm,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn ctime_r(
        arg1: *const time_t,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn gmtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
#[pg_guard]
extern "C" {
    pub fn localtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
#[pg_guard]
extern "C" {
    pub fn posix2time(arg1: time_t) -> time_t;
}
#[pg_guard]
extern "C" {
    pub fn tzsetwall();
}
#[pg_guard]
extern "C" {
    pub fn time2posix(arg1: time_t) -> time_t;
}
#[pg_guard]
extern "C" {
    pub fn timelocal(arg1: *mut tm) -> time_t;
}
#[pg_guard]
extern "C" {
    pub fn timegm(arg1: *mut tm) -> time_t;
}
#[pg_guard]
extern "C" {
    pub fn nanosleep(__rqtp: *const timespec, __rmtp: *mut timespec) -> ::std::os::raw::c_int;
}
pub const clockid_t__CLOCK_REALTIME: clockid_t = 0;
pub const clockid_t__CLOCK_MONOTONIC: clockid_t = 6;
pub const clockid_t__CLOCK_MONOTONIC_RAW: clockid_t = 4;
pub const clockid_t__CLOCK_MONOTONIC_RAW_APPROX: clockid_t = 5;
pub const clockid_t__CLOCK_UPTIME_RAW: clockid_t = 8;
pub const clockid_t__CLOCK_UPTIME_RAW_APPROX: clockid_t = 9;
pub const clockid_t__CLOCK_PROCESS_CPUTIME_ID: clockid_t = 12;
pub const clockid_t__CLOCK_THREAD_CPUTIME_ID: clockid_t = 16;
pub type clockid_t = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn clock_getres(__clock_id: clockid_t, __res: *mut timespec) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn clock_gettime(__clock_id: clockid_t, __tp: *mut timespec) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn clock_gettime_nsec_np(__clock_id: clockid_t) -> __uint64_t;
}
#[pg_guard]
extern "C" {
    pub fn clock_settime(__clock_id: clockid_t, __tp: *const timespec) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn timespec_get(ts: *mut timespec, base: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
pub type instr_time = timespec;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BufferUsage {
    pub shared_blks_hit: ::std::os::raw::c_long,
    pub shared_blks_read: ::std::os::raw::c_long,
    pub shared_blks_dirtied: ::std::os::raw::c_long,
    pub shared_blks_written: ::std::os::raw::c_long,
    pub local_blks_hit: ::std::os::raw::c_long,
    pub local_blks_read: ::std::os::raw::c_long,
    pub local_blks_dirtied: ::std::os::raw::c_long,
    pub local_blks_written: ::std::os::raw::c_long,
    pub temp_blks_read: ::std::os::raw::c_long,
    pub temp_blks_written: ::std::os::raw::c_long,
    pub blk_read_time: instr_time,
    pub blk_write_time: instr_time,
}
pub const InstrumentOption_INSTRUMENT_TIMER: InstrumentOption = 1;
pub const InstrumentOption_INSTRUMENT_BUFFERS: InstrumentOption = 2;
pub const InstrumentOption_INSTRUMENT_ROWS: InstrumentOption = 4;
pub const InstrumentOption_INSTRUMENT_ALL: InstrumentOption = 2147483647;
pub type InstrumentOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Instrumentation {
    pub need_timer: bool,
    pub need_bufusage: bool,
    pub running: bool,
    pub starttime: instr_time,
    pub counter: instr_time,
    pub firsttuple: f64,
    pub tuplecount: f64,
    pub bufusage_start: BufferUsage,
    pub startup: f64,
    pub total: f64,
    pub ntuples: f64,
    pub nloops: f64,
    pub nfiltered1: f64,
    pub nfiltered2: f64,
    pub bufusage: BufferUsage,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct WorkerInstrumentation {
    pub num_workers: ::std::os::raw::c_int,
    pub instrument: __IncompleteArrayField<Instrumentation>,
}
#[pg_guard]
extern "C" {
    pub static mut pgBufferUsage: BufferUsage;
}
#[pg_guard]
extern "C" {
    pub fn InstrAlloc(
        n: ::std::os::raw::c_int,
        instrument_options: ::std::os::raw::c_int,
    ) -> *mut Instrumentation;
}
#[pg_guard]
extern "C" {
    pub fn InstrInit(instr: *mut Instrumentation, instrument_options: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn InstrStartNode(instr: *mut Instrumentation);
}
#[pg_guard]
extern "C" {
    pub fn InstrStopNode(instr: *mut Instrumentation, nTuples: f64);
}
#[pg_guard]
extern "C" {
    pub fn InstrEndLoop(instr: *mut Instrumentation);
}
#[pg_guard]
extern "C" {
    pub fn InstrAggNode(dst: *mut Instrumentation, add: *mut Instrumentation);
}
#[pg_guard]
extern "C" {
    pub fn InstrStartParallelQuery();
}
#[pg_guard]
extern "C" {
    pub fn InstrEndParallelQuery(result: *mut BufferUsage);
}
#[pg_guard]
extern "C" {
    pub fn InstrAccumParallelQuery(result: *mut BufferUsage);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ParamExternData {
    pub value: Datum,
    pub isnull: bool,
    pub pflags: uint16,
    pub ptype: Oid,
}
pub type ParamListInfo = *mut ParamListInfoData;
pub type ParamFetchHook = ::std::option::Option<
    unsafe extern "C" fn(params: ParamListInfo, paramid: ::std::os::raw::c_int),
>;
pub type ParserSetupHook = ::std::option::Option<
    unsafe extern "C" fn(pstate: *mut ParseState, arg: *mut ::std::os::raw::c_void),
>;
#[repr(C)]
#[derive(Debug)]
pub struct ParamListInfoData {
    pub paramFetch: ParamFetchHook,
    pub paramFetchArg: *mut ::std::os::raw::c_void,
    pub parserSetup: ParserSetupHook,
    pub parserSetupArg: *mut ::std::os::raw::c_void,
    pub numParams: ::std::os::raw::c_int,
    pub paramMask: *mut Bitmapset,
    pub params: __IncompleteArrayField<ParamExternData>,
}
impl Default for ParamListInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamExecData {
    pub execPlan: *mut ::std::os::raw::c_void,
    pub value: Datum,
    pub isnull: bool,
}
impl Default for ParamExecData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn copyParamList(from: ParamListInfo) -> ParamListInfo;
}
#[pg_guard]
extern "C" {
    pub fn EstimateParamListSpace(paramLI: ParamListInfo) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn SerializeParamList(
        paramLI: ParamListInfo,
        start_address: *mut *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn RestoreParamList(start_address: *mut *mut ::std::os::raw::c_char) -> ParamListInfo;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlannedStmt {
    pub type_: NodeTag,
    pub commandType: CmdType,
    pub queryId: uint32,
    pub hasReturning: bool,
    pub hasModifyingCTE: bool,
    pub canSetTag: bool,
    pub transientPlan: bool,
    pub dependsOnRole: bool,
    pub parallelModeNeeded: bool,
    pub planTree: *mut Plan,
    pub rtable: *mut List,
    pub resultRelations: *mut List,
    pub nonleafResultRelations: *mut List,
    pub rootResultRelations: *mut List,
    pub subplans: *mut List,
    pub rewindPlanIDs: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub relationOids: *mut List,
    pub invalItems: *mut List,
    pub nParamExec: ::std::os::raw::c_int,
    pub utilityStmt: *mut Node,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for PlannedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Plan {
    pub type_: NodeTag,
    pub startup_cost: Cost,
    pub total_cost: Cost,
    pub plan_rows: f64,
    pub plan_width: ::std::os::raw::c_int,
    pub parallel_aware: bool,
    pub parallel_safe: bool,
    pub plan_node_id: ::std::os::raw::c_int,
    pub targetlist: *mut List,
    pub qual: *mut List,
    pub lefttree: *mut Plan,
    pub righttree: *mut Plan,
    pub initPlan: *mut List,
    pub extParam: *mut Bitmapset,
    pub allParam: *mut Bitmapset,
}
impl Default for Plan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Result {
    pub plan: Plan,
    pub resconstantqual: *mut Node,
}
impl Default for Result {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSet {
    pub plan: Plan,
}
impl Default for ProjectSet {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTable {
    pub plan: Plan,
    pub operation: CmdType,
    pub canSetTag: bool,
    pub nominalRelation: Index,
    pub partitioned_rels: *mut List,
    pub resultRelations: *mut List,
    pub resultRelIndex: ::std::os::raw::c_int,
    pub rootResultRelIndex: ::std::os::raw::c_int,
    pub plans: *mut List,
    pub withCheckOptionLists: *mut List,
    pub returningLists: *mut List,
    pub fdwPrivLists: *mut List,
    pub fdwDirectModifyPlans: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
    pub onConflictAction: OnConflictAction,
    pub arbiterIndexes: *mut List,
    pub onConflictSet: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelRTI: Index,
    pub exclRelTlist: *mut List,
}
impl Default for ModifyTable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Append {
    pub plan: Plan,
    pub partitioned_rels: *mut List,
    pub appendplans: *mut List,
}
impl Default for Append {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppend {
    pub plan: Plan,
    pub partitioned_rels: *mut List,
    pub mergeplans: *mut List,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
}
impl Default for MergeAppend {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnion {
    pub plan: Plan,
    pub wtParam: ::std::os::raw::c_int,
    pub numCols: ::std::os::raw::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub numGroups: ::std::os::raw::c_long,
}
impl Default for RecursiveUnion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAnd {
    pub plan: Plan,
    pub bitmapplans: *mut List,
}
impl Default for BitmapAnd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOr {
    pub plan: Plan,
    pub isshared: bool,
    pub bitmapplans: *mut List,
}
impl Default for BitmapOr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Scan {
    pub plan: Plan,
    pub scanrelid: Index,
}
impl Default for Scan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SeqScan = Scan;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScan {
    pub scan: Scan,
    pub tablesample: *mut TableSampleClause,
}
impl Default for SampleScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
    pub indexorderby: *mut List,
    pub indexorderbyorig: *mut List,
    pub indexorderbyops: *mut List,
    pub indexorderdir: ScanDirection,
}
impl Default for IndexScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexorderby: *mut List,
    pub indextlist: *mut List,
    pub indexorderdir: ScanDirection,
}
impl Default for IndexOnlyScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub isshared: bool,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
}
impl Default for BitmapIndexScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScan {
    pub scan: Scan,
    pub bitmapqualorig: *mut List,
}
impl Default for BitmapHeapScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScan {
    pub scan: Scan,
    pub tidquals: *mut List,
}
impl Default for TidScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScan {
    pub scan: Scan,
    pub subplan: *mut Plan,
}
impl Default for SubqueryScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScan {
    pub scan: Scan,
    pub functions: *mut List,
    pub funcordinality: bool,
}
impl Default for FunctionScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScan {
    pub scan: Scan,
    pub values_lists: *mut List,
}
impl Default for ValuesScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScan {
    pub scan: Scan,
    pub tablefunc: *mut TableFunc,
}
impl Default for TableFuncScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScan {
    pub scan: Scan,
    pub ctePlanId: ::std::os::raw::c_int,
    pub cteParam: ::std::os::raw::c_int,
}
impl Default for CteScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScan {
    pub scan: Scan,
    pub enrname: *mut ::std::os::raw::c_char,
}
impl Default for NamedTuplestoreScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScan {
    pub scan: Scan,
    pub wtParam: ::std::os::raw::c_int,
}
impl Default for WorkTableScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScan {
    pub scan: Scan,
    pub operation: CmdType,
    pub fs_server: Oid,
    pub fdw_exprs: *mut List,
    pub fdw_private: *mut List,
    pub fdw_scan_tlist: *mut List,
    pub fdw_recheck_quals: *mut List,
    pub fs_relids: *mut Bitmapset,
    pub fsSystemCol: bool,
}
impl Default for ForeignScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScan {
    pub scan: Scan,
    pub flags: uint32,
    pub custom_plans: *mut List,
    pub custom_exprs: *mut List,
    pub custom_private: *mut List,
    pub custom_scan_tlist: *mut List,
    pub custom_relids: *mut Bitmapset,
    pub methods: *const CustomScanMethods,
}
impl Default for CustomScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Join {
    pub plan: Plan,
    pub jointype: JoinType,
    pub inner_unique: bool,
    pub joinqual: *mut List,
}
impl Default for Join {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoop {
    pub join: Join,
    pub nestParams: *mut List,
}
impl Default for NestLoop {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopParam {
    pub type_: NodeTag,
    pub paramno: ::std::os::raw::c_int,
    pub paramval: *mut Var,
}
impl Default for NestLoopParam {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoin {
    pub join: Join,
    pub skip_mark_restore: bool,
    pub mergeclauses: *mut List,
    pub mergeFamilies: *mut Oid,
    pub mergeCollations: *mut Oid,
    pub mergeStrategies: *mut ::std::os::raw::c_int,
    pub mergeNullsFirst: *mut bool,
}
impl Default for MergeJoin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoin {
    pub join: Join,
    pub hashclauses: *mut List,
}
impl Default for HashJoin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Material {
    pub plan: Plan,
}
impl Default for Material {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sort {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
}
impl Default for Sort {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Group {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
}
impl Default for Group {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Agg {
    pub plan: Plan,
    pub aggstrategy: AggStrategy,
    pub aggsplit: AggSplit,
    pub numCols: ::std::os::raw::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub numGroups: ::std::os::raw::c_long,
    pub aggParams: *mut Bitmapset,
    pub groupingSets: *mut List,
    pub chain: *mut List,
}
impl Default for Agg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAgg {
    pub plan: Plan,
    pub winref: Index,
    pub partNumCols: ::std::os::raw::c_int,
    pub partColIdx: *mut AttrNumber,
    pub partOperators: *mut Oid,
    pub ordNumCols: ::std::os::raw::c_int,
    pub ordColIdx: *mut AttrNumber,
    pub ordOperators: *mut Oid,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
}
impl Default for WindowAgg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Unique {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub uniqColIdx: *mut AttrNumber,
    pub uniqOperators: *mut Oid,
}
impl Default for Unique {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Gather {
    pub plan: Plan,
    pub num_workers: ::std::os::raw::c_int,
    pub rescan_param: ::std::os::raw::c_int,
    pub single_copy: bool,
    pub invisible: bool,
}
impl Default for Gather {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMerge {
    pub plan: Plan,
    pub num_workers: ::std::os::raw::c_int,
    pub rescan_param: ::std::os::raw::c_int,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
}
impl Default for GatherMerge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Hash {
    pub plan: Plan,
    pub skewTable: Oid,
    pub skewColumn: AttrNumber,
    pub skewInherit: bool,
}
impl Default for Hash {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOp {
    pub plan: Plan,
    pub cmd: SetOpCmd,
    pub strategy: SetOpStrategy,
    pub numCols: ::std::os::raw::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub flagColIdx: AttrNumber,
    pub firstFlag: ::std::os::raw::c_int,
    pub numGroups: ::std::os::raw::c_long,
}
impl Default for SetOp {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRows {
    pub plan: Plan,
    pub rowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
}
impl Default for LockRows {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Limit {
    pub plan: Plan,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
}
impl Default for Limit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RowMarkType_ROW_MARK_EXCLUSIVE: RowMarkType = 0;
pub const RowMarkType_ROW_MARK_NOKEYEXCLUSIVE: RowMarkType = 1;
pub const RowMarkType_ROW_MARK_SHARE: RowMarkType = 2;
pub const RowMarkType_ROW_MARK_KEYSHARE: RowMarkType = 3;
pub const RowMarkType_ROW_MARK_REFERENCE: RowMarkType = 4;
pub const RowMarkType_ROW_MARK_COPY: RowMarkType = 5;
pub type RowMarkType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanRowMark {
    pub type_: NodeTag,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType,
    pub allMarkTypes: ::std::os::raw::c_int,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub isParent: bool,
}
impl Default for PlanRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanInvalItem {
    pub type_: NodeTag,
    pub cacheId: ::std::os::raw::c_int,
    pub hashValue: uint32,
}
impl Default for PlanInvalItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HashValueFunc = ::std::option::Option<
    unsafe extern "C" fn(key: *const ::std::os::raw::c_void, keysize: Size) -> uint32,
>;
pub type HashCompareFunc = ::std::option::Option<
    unsafe extern "C" fn(
        key1: *const ::std::os::raw::c_void,
        key2: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> ::std::os::raw::c_int,
>;
pub type HashCopyFunc = ::std::option::Option<
    unsafe extern "C" fn(
        dest: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type HashAllocFunc =
    ::std::option::Option<unsafe extern "C" fn(request: Size) -> *mut ::std::os::raw::c_void>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHELEMENT {
    pub link: *mut HASHELEMENT,
    pub hashvalue: uint32,
}
impl Default for HASHELEMENT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHHDR {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTAB {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHCTL {
    pub num_partitions: ::std::os::raw::c_long,
    pub ssize: ::std::os::raw::c_long,
    pub dsize: ::std::os::raw::c_long,
    pub max_dsize: ::std::os::raw::c_long,
    pub ffactor: ::std::os::raw::c_long,
    pub keysize: Size,
    pub entrysize: Size,
    pub hash: HashValueFunc,
    pub match_: HashCompareFunc,
    pub keycopy: HashCopyFunc,
    pub alloc: HashAllocFunc,
    pub hcxt: MemoryContext,
    pub hctl: *mut HASHHDR,
}
impl Default for HASHCTL {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const HASHACTION_HASH_FIND: HASHACTION = 0;
pub const HASHACTION_HASH_ENTER: HASHACTION = 1;
pub const HASHACTION_HASH_REMOVE: HASHACTION = 2;
pub const HASHACTION_HASH_ENTER_NULL: HASHACTION = 3;
pub type HASHACTION = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASH_SEQ_STATUS {
    pub hashp: *mut HTAB,
    pub curBucket: uint32,
    pub curEntry: *mut HASHELEMENT,
}
impl Default for HASH_SEQ_STATUS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn hash_create(
        tabname: *const ::std::os::raw::c_char,
        nelem: ::std::os::raw::c_long,
        info: *mut HASHCTL,
        flags: ::std::os::raw::c_int,
    ) -> *mut HTAB;
}
#[pg_guard]
extern "C" {
    pub fn hash_destroy(hashp: *mut HTAB);
}
#[pg_guard]
extern "C" {
    pub fn hash_stats(where_: *const ::std::os::raw::c_char, hashp: *mut HTAB);
}
#[pg_guard]
extern "C" {
    pub fn hash_search(
        hashp: *mut HTAB,
        keyPtr: *const ::std::os::raw::c_void,
        action: HASHACTION,
        foundPtr: *mut bool,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn get_hash_value(hashp: *mut HTAB, keyPtr: *const ::std::os::raw::c_void) -> uint32;
}
#[pg_guard]
extern "C" {
    pub fn hash_search_with_hash_value(
        hashp: *mut HTAB,
        keyPtr: *const ::std::os::raw::c_void,
        hashvalue: uint32,
        action: HASHACTION,
        foundPtr: *mut bool,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn hash_update_hash_key(
        hashp: *mut HTAB,
        existingEntry: *mut ::std::os::raw::c_void,
        newKeyPtr: *const ::std::os::raw::c_void,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn hash_get_num_entries(hashp: *mut HTAB) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn hash_seq_init(status: *mut HASH_SEQ_STATUS, hashp: *mut HTAB);
}
#[pg_guard]
extern "C" {
    pub fn hash_seq_search(status: *mut HASH_SEQ_STATUS) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn hash_seq_term(status: *mut HASH_SEQ_STATUS);
}
#[pg_guard]
extern "C" {
    pub fn hash_freeze(hashp: *mut HTAB);
}
#[pg_guard]
extern "C" {
    pub fn hash_estimate_size(num_entries: ::std::os::raw::c_long, entrysize: Size) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn hash_select_dirsize(num_entries: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn hash_get_shared_size(info: *mut HASHCTL, flags: ::std::os::raw::c_int) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn AtEOXact_HashTables(isCommit: bool);
}
#[pg_guard]
extern "C" {
    pub fn AtEOSubXact_HashTables(isCommit: bool, nestDepth: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn string_hash(key: *const ::std::os::raw::c_void, keysize: Size) -> uint32;
}
#[pg_guard]
extern "C" {
    pub fn tag_hash(key: *const ::std::os::raw::c_void, keysize: Size) -> uint32;
}
#[pg_guard]
extern "C" {
    pub fn uint32_hash(key: *const ::std::os::raw::c_void, keysize: Size) -> uint32;
}
#[pg_guard]
extern "C" {
    pub fn bitmap_hash(key: *const ::std::os::raw::c_void, keysize: Size) -> uint32;
}
#[pg_guard]
extern "C" {
    pub fn bitmap_match(
        key1: *const ::std::os::raw::c_void,
        key2: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> ::std::os::raw::c_int;
}
pub const EphemeralNameRelationType_ENR_NAMED_TUPLESTORE: EphemeralNameRelationType = 0;
pub type EphemeralNameRelationType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationMetadataData {
    pub name: *mut ::std::os::raw::c_char,
    pub reliddesc: Oid,
    pub tupdesc: TupleDesc,
    pub enrtype: EphemeralNameRelationType,
    pub enrtuples: f64,
}
impl Default for EphemeralNamedRelationMetadataData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelationMetadata = *mut EphemeralNamedRelationMetadataData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationData {
    pub md: EphemeralNamedRelationMetadataData,
    pub reldata: *mut ::std::os::raw::c_void,
}
impl Default for EphemeralNamedRelationData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelation = *mut EphemeralNamedRelationData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryEnvironment {
    _unused: [u8; 0],
}
#[pg_guard]
extern "C" {
    pub fn create_queryEnv() -> *mut QueryEnvironment;
}
#[pg_guard]
extern "C" {
    pub fn get_visible_ENR_metadata(
        queryEnv: *mut QueryEnvironment,
        refname: *const ::std::os::raw::c_char,
    ) -> EphemeralNamedRelationMetadata;
}
#[pg_guard]
extern "C" {
    pub fn register_ENR(queryEnv: *mut QueryEnvironment, enr: EphemeralNamedRelation);
}
#[pg_guard]
extern "C" {
    pub fn unregister_ENR(queryEnv: *mut QueryEnvironment, name: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn get_ENR(
        queryEnv: *mut QueryEnvironment,
        name: *const ::std::os::raw::c_char,
    ) -> EphemeralNamedRelation;
}
#[pg_guard]
extern "C" {
    pub fn ENRMetadataGetTupDesc(enrmd: EphemeralNamedRelationMetadata) -> TupleDesc;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Trigger {
    pub tgoid: Oid,
    pub tgname: *mut ::std::os::raw::c_char,
    pub tgfoid: Oid,
    pub tgtype: int16,
    pub tgenabled: ::std::os::raw::c_char,
    pub tgisinternal: bool,
    pub tgconstrrelid: Oid,
    pub tgconstrindid: Oid,
    pub tgconstraint: Oid,
    pub tgdeferrable: bool,
    pub tginitdeferred: bool,
    pub tgnargs: int16,
    pub tgnattr: int16,
    pub tgattr: *mut int16,
    pub tgargs: *mut *mut ::std::os::raw::c_char,
    pub tgqual: *mut ::std::os::raw::c_char,
    pub tgoldtable: *mut ::std::os::raw::c_char,
    pub tgnewtable: *mut ::std::os::raw::c_char,
}
impl Default for Trigger {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerDesc {
    pub triggers: *mut Trigger,
    pub numtriggers: ::std::os::raw::c_int,
    pub trig_insert_before_row: bool,
    pub trig_insert_after_row: bool,
    pub trig_insert_instead_row: bool,
    pub trig_insert_before_statement: bool,
    pub trig_insert_after_statement: bool,
    pub trig_update_before_row: bool,
    pub trig_update_after_row: bool,
    pub trig_update_instead_row: bool,
    pub trig_update_before_statement: bool,
    pub trig_update_after_statement: bool,
    pub trig_delete_before_row: bool,
    pub trig_delete_after_row: bool,
    pub trig_delete_instead_row: bool,
    pub trig_delete_before_statement: bool,
    pub trig_delete_after_statement: bool,
    pub trig_truncate_before_statement: bool,
    pub trig_truncate_after_statement: bool,
    pub trig_insert_new_table: bool,
    pub trig_update_old_table: bool,
    pub trig_update_new_table: bool,
    pub trig_delete_old_table: bool,
}
impl Default for TriggerDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SortSupport = *mut SortSupportData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortSupportData {
    pub ssup_cxt: MemoryContext,
    pub ssup_collation: Oid,
    pub ssup_reverse: bool,
    pub ssup_nulls_first: bool,
    pub ssup_attno: AttrNumber,
    pub ssup_extra: *mut ::std::os::raw::c_void,
    pub comparator: ::std::option::Option<
        unsafe extern "C" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::std::os::raw::c_int,
    >,
    pub abbreviate: bool,
    pub abbrev_converter:
        ::std::option::Option<unsafe extern "C" fn(original: Datum, ssup: SortSupport) -> Datum>,
    pub abbrev_abort: ::std::option::Option<
        unsafe extern "C" fn(memtupcount: ::std::os::raw::c_int, ssup: SortSupport) -> bool,
    >,
    pub abbrev_full_comparator: ::std::option::Option<
        unsafe extern "C" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::std::os::raw::c_int,
    >,
}
impl Default for SortSupportData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn PrepareSortSupportComparisonShim(cmpFunc: Oid, ssup: SortSupport);
}
#[pg_guard]
extern "C" {
    pub fn PrepareSortSupportFromOrderingOp(orderingOp: Oid, ssup: SortSupport);
}
#[pg_guard]
extern "C" {
    pub fn PrepareSortSupportFromIndexRel(indexRel: Relation, strategy: int16, ssup: SortSupport);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplestorestate {
    _unused: [u8; 0],
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_begin_heap(
        randomAccess: bool,
        interXact: bool,
        maxKBytes: ::std::os::raw::c_int,
    ) -> *mut Tuplestorestate;
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_set_eflags(state: *mut Tuplestorestate, eflags: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_puttupleslot(state: *mut Tuplestorestate, slot: *mut TupleTableSlot);
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_puttuple(state: *mut Tuplestorestate, tuple: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_putvalues(
        state: *mut Tuplestorestate,
        tdesc: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_alloc_read_pointer(
        state: *mut Tuplestorestate,
        eflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_select_read_pointer(state: *mut Tuplestorestate, ptr: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_copy_read_pointer(
        state: *mut Tuplestorestate,
        srcptr: ::std::os::raw::c_int,
        destptr: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_trim(state: *mut Tuplestorestate);
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_in_memory(state: *mut Tuplestorestate) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_gettupleslot(
        state: *mut Tuplestorestate,
        forward: bool,
        copy: bool,
        slot: *mut TupleTableSlot,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_advance(state: *mut Tuplestorestate, forward: bool) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_skiptuples(
        state: *mut Tuplestorestate,
        ntuples: int64,
        forward: bool,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_tuple_count(state: *mut Tuplestorestate) -> int64;
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_ateof(state: *mut Tuplestorestate) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_rescan(state: *mut Tuplestorestate);
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_clear(state: *mut Tuplestorestate);
}
#[pg_guard]
extern "C" {
    pub fn tuplestore_end(state: *mut Tuplestorestate);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexTupleData {
    pub t_tid: ItemPointerData,
    pub t_info: ::std::os::raw::c_ushort,
}
pub type IndexTuple = *mut IndexTupleData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexAttributeBitMapData {
    pub bits: [bits8; 4usize],
}
pub type IndexAttributeBitMap = *mut IndexAttributeBitMapData;
#[pg_guard]
extern "C" {
    pub fn index_form_tuple(
        tupleDescriptor: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    ) -> IndexTuple;
}
#[pg_guard]
extern "C" {
    pub fn nocache_index_getattr(
        tup: IndexTuple,
        attnum: ::std::os::raw::c_int,
        tupleDesc: TupleDesc,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn index_deform_tuple(
        tup: IndexTuple,
        tupleDescriptor: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn CopyIndexTuple(source: IndexTuple) -> IndexTuple;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplesortstate {
    _unused: [u8; 0],
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_begin_heap(
        tupDesc: TupleDesc,
        nkeys: ::std::os::raw::c_int,
        attNums: *mut AttrNumber,
        sortOperators: *mut Oid,
        sortCollations: *mut Oid,
        nullsFirstFlags: *mut bool,
        workMem: ::std::os::raw::c_int,
        randomAccess: bool,
    ) -> *mut Tuplesortstate;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_begin_cluster(
        tupDesc: TupleDesc,
        indexRel: Relation,
        workMem: ::std::os::raw::c_int,
        randomAccess: bool,
    ) -> *mut Tuplesortstate;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_begin_index_btree(
        heapRel: Relation,
        indexRel: Relation,
        enforceUnique: bool,
        workMem: ::std::os::raw::c_int,
        randomAccess: bool,
    ) -> *mut Tuplesortstate;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_begin_index_hash(
        heapRel: Relation,
        indexRel: Relation,
        high_mask: uint32,
        low_mask: uint32,
        max_buckets: uint32,
        workMem: ::std::os::raw::c_int,
        randomAccess: bool,
    ) -> *mut Tuplesortstate;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_begin_datum(
        datumType: Oid,
        sortOperator: Oid,
        sortCollation: Oid,
        nullsFirstFlag: bool,
        workMem: ::std::os::raw::c_int,
        randomAccess: bool,
    ) -> *mut Tuplesortstate;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_set_bound(state: *mut Tuplesortstate, bound: int64);
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_puttupleslot(state: *mut Tuplesortstate, slot: *mut TupleTableSlot);
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_putheaptuple(state: *mut Tuplesortstate, tup: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_putindextuplevalues(
        state: *mut Tuplesortstate,
        rel: Relation,
        self_: ItemPointer,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_putdatum(state: *mut Tuplesortstate, val: Datum, isNull: bool);
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_performsort(state: *mut Tuplesortstate);
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_gettupleslot(
        state: *mut Tuplesortstate,
        forward: bool,
        copy: bool,
        slot: *mut TupleTableSlot,
        abbrev: *mut Datum,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_getheaptuple(state: *mut Tuplesortstate, forward: bool) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_getindextuple(state: *mut Tuplesortstate, forward: bool) -> IndexTuple;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_getdatum(
        state: *mut Tuplesortstate,
        forward: bool,
        val: *mut Datum,
        isNull: *mut bool,
        abbrev: *mut Datum,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_skiptuples(state: *mut Tuplesortstate, ntuples: int64, forward: bool) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_end(state: *mut Tuplesortstate);
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_get_stats(
        state: *mut Tuplesortstate,
        sortMethod: *mut *const ::std::os::raw::c_char,
        spaceType: *mut *const ::std::os::raw::c_char,
        spaceUsed: *mut ::std::os::raw::c_long,
    );
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_merge_order(allowedMem: int64) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_rescan(state: *mut Tuplesortstate);
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_markpos(state: *mut Tuplesortstate);
}
#[pg_guard]
extern "C" {
    pub fn tuplesort_restorepos(state: *mut Tuplesortstate);
}
pub type slock_t = ::std::os::raw::c_uchar;
#[pg_guard]
extern "C" {
    pub static mut dummy_spinlock: slock_t;
}
#[pg_guard]
extern "C" {
    pub fn s_lock(
        lock: *mut slock_t,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn set_spins_per_delay(shared_spins_per_delay: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn update_spins_per_delay(
        shared_spins_per_delay: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpinDelayStatus {
    pub spins: ::std::os::raw::c_int,
    pub delays: ::std::os::raw::c_int,
    pub cur_delay: ::std::os::raw::c_int,
    pub file: *const ::std::os::raw::c_char,
    pub line: ::std::os::raw::c_int,
    pub func: *const ::std::os::raw::c_char,
}
impl Default for SpinDelayStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn perform_spin_delay(status: *mut SpinDelayStatus);
}
#[pg_guard]
extern "C" {
    pub fn finish_spin_delay(status: *mut SpinDelayStatus);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_node {
    pub next: ::std::os::raw::c_int,
    pub prev: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_head {
    pub head: ::std::os::raw::c_int,
    pub tail: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_mutable_iter {
    pub cur: ::std::os::raw::c_int,
    pub next: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ConditionVariable {
    pub mutex: slock_t,
    pub wakeup: proclist_head,
}
#[pg_guard]
extern "C" {
    pub fn ConditionVariableInit(arg1: *mut ConditionVariable);
}
#[pg_guard]
extern "C" {
    pub fn ConditionVariableSleep(arg1: *mut ConditionVariable, wait_event_info: uint32);
}
#[pg_guard]
extern "C" {
    pub fn ConditionVariableCancelSleep();
}
#[pg_guard]
extern "C" {
    pub fn ConditionVariablePrepareToSleep(arg1: *mut ConditionVariable);
}
#[pg_guard]
extern "C" {
    pub fn ConditionVariableSignal(arg1: *mut ConditionVariable) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ConditionVariableBroadcast(arg1: *mut ConditionVariable) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep {
    _unused: [u8; 0],
}
pub type ExprStateEvalFunc = ::std::option::Option<
    unsafe extern "C" fn(
        expression: *mut ExprState,
        econtext: *mut ExprContext,
        isNull: *mut bool,
    ) -> Datum,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprState {
    pub tag: Node,
    pub flags: uint8,
    pub resnull: bool,
    pub resvalue: Datum,
    pub resultslot: *mut TupleTableSlot,
    pub steps: *mut ExprEvalStep,
    pub evalfunc: ExprStateEvalFunc,
    pub expr: *mut Expr,
    pub steps_len: ::std::os::raw::c_int,
    pub steps_alloc: ::std::os::raw::c_int,
    pub innermost_caseval: *mut Datum,
    pub innermost_casenull: *mut bool,
    pub innermost_domainval: *mut Datum,
    pub innermost_domainnull: *mut bool,
}
impl Default for ExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexInfo {
    pub type_: NodeTag,
    pub ii_NumIndexAttrs: ::std::os::raw::c_int,
    pub ii_KeyAttrNumbers: [AttrNumber; 32usize],
    pub ii_Expressions: *mut List,
    pub ii_ExpressionsState: *mut List,
    pub ii_Predicate: *mut List,
    pub ii_PredicateState: *mut ExprState,
    pub ii_ExclusionOps: *mut Oid,
    pub ii_ExclusionProcs: *mut Oid,
    pub ii_ExclusionStrats: *mut uint16,
    pub ii_UniqueOps: *mut Oid,
    pub ii_UniqueProcs: *mut Oid,
    pub ii_UniqueStrats: *mut uint16,
    pub ii_Unique: bool,
    pub ii_ReadyForInserts: bool,
    pub ii_Concurrent: bool,
    pub ii_BrokenHotChain: bool,
    pub ii_AmCache: *mut ::std::os::raw::c_void,
    pub ii_Context: MemoryContext,
}
impl Default for IndexInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExprContextCallbackFunction = ::std::option::Option<unsafe extern "C" fn(arg: Datum)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprContext_CB {
    pub next: *mut ExprContext_CB,
    pub function: ExprContextCallbackFunction,
    pub arg: Datum,
}
impl Default for ExprContext_CB {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprContext {
    pub type_: NodeTag,
    pub ecxt_scantuple: *mut TupleTableSlot,
    pub ecxt_innertuple: *mut TupleTableSlot,
    pub ecxt_outertuple: *mut TupleTableSlot,
    pub ecxt_per_query_memory: MemoryContext,
    pub ecxt_per_tuple_memory: MemoryContext,
    pub ecxt_param_exec_vals: *mut ParamExecData,
    pub ecxt_param_list_info: ParamListInfo,
    pub ecxt_aggvalues: *mut Datum,
    pub ecxt_aggnulls: *mut bool,
    pub caseValue_datum: Datum,
    pub caseValue_isNull: bool,
    pub domainValue_datum: Datum,
    pub domainValue_isNull: bool,
    pub ecxt_estate: *mut EState,
    pub ecxt_callbacks: *mut ExprContext_CB,
}
impl Default for ExprContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ExprDoneCond_ExprSingleResult: ExprDoneCond = 0;
pub const ExprDoneCond_ExprMultipleResult: ExprDoneCond = 1;
pub const ExprDoneCond_ExprEndResult: ExprDoneCond = 2;
pub type ExprDoneCond = ::std::os::raw::c_uint;
pub const SetFunctionReturnMode_SFRM_ValuePerCall: SetFunctionReturnMode = 1;
pub const SetFunctionReturnMode_SFRM_Materialize: SetFunctionReturnMode = 2;
pub const SetFunctionReturnMode_SFRM_Materialize_Random: SetFunctionReturnMode = 4;
pub const SetFunctionReturnMode_SFRM_Materialize_Preferred: SetFunctionReturnMode = 8;
pub type SetFunctionReturnMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReturnSetInfo {
    pub type_: NodeTag,
    pub econtext: *mut ExprContext,
    pub expectedDesc: TupleDesc,
    pub allowedModes: ::std::os::raw::c_int,
    pub returnMode: SetFunctionReturnMode,
    pub isDone: ExprDoneCond,
    pub setResult: *mut Tuplestorestate,
    pub setDesc: TupleDesc,
}
impl Default for ReturnSetInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectionInfo {
    pub type_: NodeTag,
    pub pi_state: ExprState,
    pub pi_exprContext: *mut ExprContext,
}
impl Default for ProjectionInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JunkFilter {
    pub type_: NodeTag,
    pub jf_targetList: *mut List,
    pub jf_cleanTupType: TupleDesc,
    pub jf_cleanMap: *mut AttrNumber,
    pub jf_resultSlot: *mut TupleTableSlot,
    pub jf_junkAttNo: AttrNumber,
}
impl Default for JunkFilter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultRelInfo {
    pub type_: NodeTag,
    pub ri_RangeTableIndex: Index,
    pub ri_RelationDesc: Relation,
    pub ri_NumIndices: ::std::os::raw::c_int,
    pub ri_IndexRelationDescs: RelationPtr,
    pub ri_IndexRelationInfo: *mut *mut IndexInfo,
    pub ri_TrigDesc: *mut TriggerDesc,
    pub ri_TrigFunctions: *mut FmgrInfo,
    pub ri_TrigWhenExprs: *mut *mut ExprState,
    pub ri_TrigInstrument: *mut Instrumentation,
    pub ri_FdwRoutine: *mut FdwRoutine,
    pub ri_FdwState: *mut ::std::os::raw::c_void,
    pub ri_usesFdwDirectModify: bool,
    pub ri_WithCheckOptions: *mut List,
    pub ri_WithCheckOptionExprs: *mut List,
    pub ri_ConstraintExprs: *mut *mut ExprState,
    pub ri_junkFilter: *mut JunkFilter,
    pub ri_projectReturning: *mut ProjectionInfo,
    pub ri_onConflictSetProj: *mut ProjectionInfo,
    pub ri_onConflictSetWhere: *mut ExprState,
    pub ri_PartitionCheck: *mut List,
    pub ri_PartitionCheckExpr: *mut ExprState,
    pub ri_PartitionRoot: Relation,
}
impl Default for ResultRelInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EState {
    pub type_: NodeTag,
    pub es_direction: ScanDirection,
    pub es_snapshot: Snapshot,
    pub es_crosscheck_snapshot: Snapshot,
    pub es_range_table: *mut List,
    pub es_plannedstmt: *mut PlannedStmt,
    pub es_sourceText: *const ::std::os::raw::c_char,
    pub es_junkFilter: *mut JunkFilter,
    pub es_output_cid: CommandId,
    pub es_result_relations: *mut ResultRelInfo,
    pub es_num_result_relations: ::std::os::raw::c_int,
    pub es_result_relation_info: *mut ResultRelInfo,
    pub es_root_result_relations: *mut ResultRelInfo,
    pub es_num_root_result_relations: ::std::os::raw::c_int,
    pub es_leaf_result_relations: *mut List,
    pub es_trig_target_relations: *mut List,
    pub es_trig_tuple_slot: *mut TupleTableSlot,
    pub es_trig_oldtup_slot: *mut TupleTableSlot,
    pub es_trig_newtup_slot: *mut TupleTableSlot,
    pub es_param_list_info: ParamListInfo,
    pub es_param_exec_vals: *mut ParamExecData,
    pub es_queryEnv: *mut QueryEnvironment,
    pub es_query_cxt: MemoryContext,
    pub es_tupleTable: *mut List,
    pub es_rowMarks: *mut List,
    pub es_processed: uint64,
    pub es_lastoid: Oid,
    pub es_top_eflags: ::std::os::raw::c_int,
    pub es_instrument: ::std::os::raw::c_int,
    pub es_finished: bool,
    pub es_exprcontexts: *mut List,
    pub es_subplanstates: *mut List,
    pub es_auxmodifytables: *mut List,
    pub es_per_tuple_exprcontext: *mut ExprContext,
    pub es_epqTuple: *mut HeapTuple,
    pub es_epqTupleSet: *mut bool,
    pub es_epqScanDone: *mut bool,
    pub es_query_dsa: *mut dsa_area,
    pub es_use_parallel_mode: bool,
}
impl Default for EState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecRowMark {
    pub relation: Relation,
    pub relid: Oid,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub ermActive: bool,
    pub curCtid: ItemPointerData,
    pub ermExtra: *mut ::std::os::raw::c_void,
}
impl Default for ExecRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecAuxRowMark {
    pub rowmark: *mut ExecRowMark,
    pub ctidAttNo: AttrNumber,
    pub toidAttNo: AttrNumber,
    pub wholeAttNo: AttrNumber,
}
impl Default for ExecAuxRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashEntry = *mut TupleHashEntryData;
pub type TupleHashTable = *mut TupleHashTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashEntryData {
    pub firstTuple: MinimalTuple,
    pub additional: *mut ::std::os::raw::c_void,
    pub status: uint32,
    pub hash: uint32,
}
impl Default for TupleHashEntryData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tuplehash_hash {
    pub size: uint64,
    pub members: uint32,
    pub sizemask: uint32,
    pub grow_threshold: uint32,
    pub data: *mut TupleHashEntryData,
    pub ctx: MemoryContext,
    pub private_data: *mut ::std::os::raw::c_void,
}
impl Default for tuplehash_hash {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const tuplehash_status_tuplehash_EMPTY: tuplehash_status = 0;
pub const tuplehash_status_tuplehash_IN_USE: tuplehash_status = 1;
pub type tuplehash_status = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct tuplehash_iterator {
    pub cur: uint32,
    pub end: uint32,
    pub done: bool,
}
#[pg_guard]
extern "C" {
    pub fn tuplehash_create(
        ctx: MemoryContext,
        nelements: uint32,
        private_data: *mut ::std::os::raw::c_void,
    ) -> *mut tuplehash_hash;
}
#[pg_guard]
extern "C" {
    pub fn tuplehash_destroy(tb: *mut tuplehash_hash);
}
#[pg_guard]
extern "C" {
    pub fn tuplehash_grow(tb: *mut tuplehash_hash, newsize: uint32);
}
#[pg_guard]
extern "C" {
    pub fn tuplehash_insert(
        tb: *mut tuplehash_hash,
        key: MinimalTuple,
        found: *mut bool,
    ) -> *mut TupleHashEntryData;
}
#[pg_guard]
extern "C" {
    pub fn tuplehash_lookup(tb: *mut tuplehash_hash, key: MinimalTuple) -> *mut TupleHashEntryData;
}
#[pg_guard]
extern "C" {
    pub fn tuplehash_delete(tb: *mut tuplehash_hash, key: MinimalTuple) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn tuplehash_start_iterate(tb: *mut tuplehash_hash, iter: *mut tuplehash_iterator);
}
#[pg_guard]
extern "C" {
    pub fn tuplehash_start_iterate_at(
        tb: *mut tuplehash_hash,
        iter: *mut tuplehash_iterator,
        at: uint32,
    );
}
#[pg_guard]
extern "C" {
    pub fn tuplehash_iterate(
        tb: *mut tuplehash_hash,
        iter: *mut tuplehash_iterator,
    ) -> *mut TupleHashEntryData;
}
#[pg_guard]
extern "C" {
    pub fn tuplehash_stat(tb: *mut tuplehash_hash);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashTableData {
    pub hashtab: *mut tuplehash_hash,
    pub numCols: ::std::os::raw::c_int,
    pub keyColIdx: *mut AttrNumber,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_funcs: *mut FmgrInfo,
    pub tablecxt: MemoryContext,
    pub tempcxt: MemoryContext,
    pub entrysize: Size,
    pub tableslot: *mut TupleTableSlot,
    pub inputslot: *mut TupleTableSlot,
    pub in_hash_funcs: *mut FmgrInfo,
    pub cur_eq_funcs: *mut FmgrInfo,
    pub hash_iv: uint32,
}
impl Default for TupleHashTableData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashIterator = tuplehash_iterator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggrefExprState {
    pub type_: NodeTag,
    pub aggref: *mut Aggref,
    pub aggno: ::std::os::raw::c_int,
}
impl Default for AggrefExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFuncExprState {
    pub type_: NodeTag,
    pub wfunc: *mut WindowFunc,
    pub args: *mut List,
    pub aggfilter: *mut ExprState,
    pub wfuncno: ::std::os::raw::c_int,
}
impl Default for WindowFuncExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetExprState {
    pub type_: NodeTag,
    pub expr: *mut Expr,
    pub args: *mut List,
    pub elidedFuncState: *mut ExprState,
    pub func: FmgrInfo,
    pub funcResultStore: *mut Tuplestorestate,
    pub funcResultSlot: *mut TupleTableSlot,
    pub funcResultDesc: TupleDesc,
    pub funcReturnsTuple: bool,
    pub funcReturnsSet: bool,
    pub setArgsValid: bool,
    pub shutdown_reg: bool,
    pub fcinfo_data: FunctionCallInfoData,
}
impl Default for SetExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlanState {
    pub type_: NodeTag,
    pub subplan: *mut SubPlan,
    pub planstate: *mut PlanState,
    pub parent: *mut PlanState,
    pub testexpr: *mut ExprState,
    pub args: *mut List,
    pub curTuple: HeapTuple,
    pub curArray: Datum,
    pub projLeft: *mut ProjectionInfo,
    pub projRight: *mut ProjectionInfo,
    pub hashtable: TupleHashTable,
    pub hashnulls: TupleHashTable,
    pub havehashrows: bool,
    pub havenullrows: bool,
    pub hashtablecxt: MemoryContext,
    pub hashtempcxt: MemoryContext,
    pub innerecontext: *mut ExprContext,
    pub keyColIdx: *mut AttrNumber,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_funcs: *mut FmgrInfo,
    pub lhs_hash_funcs: *mut FmgrInfo,
    pub cur_eq_funcs: *mut FmgrInfo,
    pub numCols: ::std::os::raw::c_int,
}
impl Default for SubPlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlternativeSubPlanState {
    pub type_: NodeTag,
    pub subplan: *mut AlternativeSubPlan,
    pub subplans: *mut List,
    pub active: ::std::os::raw::c_int,
}
impl Default for AlternativeSubPlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DomainConstraintType_DOM_CONSTRAINT_NOTNULL: DomainConstraintType = 0;
pub const DomainConstraintType_DOM_CONSTRAINT_CHECK: DomainConstraintType = 1;
pub type DomainConstraintType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DomainConstraintState {
    pub type_: NodeTag,
    pub constrainttype: DomainConstraintType,
    pub name: *mut ::std::os::raw::c_char,
    pub check_expr: *mut Expr,
    pub check_exprstate: *mut ExprState,
}
impl Default for DomainConstraintState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExecProcNodeMtd =
    ::std::option::Option<unsafe extern "C" fn(pstate: *mut PlanState) -> *mut TupleTableSlot>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanState {
    pub type_: NodeTag,
    pub plan: *mut Plan,
    pub state: *mut EState,
    pub ExecProcNode: ExecProcNodeMtd,
    pub ExecProcNodeReal: ExecProcNodeMtd,
    pub instrument: *mut Instrumentation,
    pub worker_instrument: *mut WorkerInstrumentation,
    pub qual: *mut ExprState,
    pub lefttree: *mut PlanState,
    pub righttree: *mut PlanState,
    pub initPlan: *mut List,
    pub subPlan: *mut List,
    pub chgParam: *mut Bitmapset,
    pub ps_ResultTupleSlot: *mut TupleTableSlot,
    pub ps_ExprContext: *mut ExprContext,
    pub ps_ProjInfo: *mut ProjectionInfo,
}
impl Default for PlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EPQState {
    pub estate: *mut EState,
    pub planstate: *mut PlanState,
    pub origslot: *mut TupleTableSlot,
    pub plan: *mut Plan,
    pub arowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
}
impl Default for EPQState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultState {
    pub ps: PlanState,
    pub resconstantqual: *mut ExprState,
    pub rs_done: bool,
    pub rs_checkqual: bool,
}
impl Default for ResultState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSetState {
    pub ps: PlanState,
    pub elems: *mut *mut Node,
    pub elemdone: *mut ExprDoneCond,
    pub nelems: ::std::os::raw::c_int,
    pub pending_srf_tuples: bool,
}
impl Default for ProjectSetState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTableState {
    pub ps: PlanState,
    pub operation: CmdType,
    pub canSetTag: bool,
    pub mt_done: bool,
    pub mt_plans: *mut *mut PlanState,
    pub mt_nplans: ::std::os::raw::c_int,
    pub mt_whichplan: ::std::os::raw::c_int,
    pub resultRelInfo: *mut ResultRelInfo,
    pub rootResultRelInfo: *mut ResultRelInfo,
    pub mt_arowmarks: *mut *mut List,
    pub mt_epqstate: EPQState,
    pub fireBSTriggers: bool,
    pub mt_onconflict: OnConflictAction,
    pub mt_arbiterindexes: *mut List,
    pub mt_existing: *mut TupleTableSlot,
    pub mt_excludedtlist: *mut List,
    pub mt_conflproj: *mut TupleTableSlot,
    pub mt_partition_dispatch_info: *mut *mut PartitionDispatchData,
    pub mt_num_dispatch: ::std::os::raw::c_int,
    pub mt_num_partitions: ::std::os::raw::c_int,
    pub mt_partitions: *mut ResultRelInfo,
    pub mt_partition_tupconv_maps: *mut *mut TupleConversionMap,
    pub mt_partition_tuple_slot: *mut TupleTableSlot,
    pub mt_transition_capture: *mut TransitionCaptureState,
    pub mt_oc_transition_capture: *mut TransitionCaptureState,
    pub mt_transition_tupconv_maps: *mut *mut TupleConversionMap,
}
impl Default for ModifyTableState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AppendState {
    pub ps: PlanState,
    pub appendplans: *mut *mut PlanState,
    pub as_nplans: ::std::os::raw::c_int,
    pub as_whichplan: ::std::os::raw::c_int,
}
impl Default for AppendState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppendState {
    pub ps: PlanState,
    pub mergeplans: *mut *mut PlanState,
    pub ms_nplans: ::std::os::raw::c_int,
    pub ms_nkeys: ::std::os::raw::c_int,
    pub ms_sortkeys: SortSupport,
    pub ms_slots: *mut *mut TupleTableSlot,
    pub ms_heap: *mut binaryheap,
    pub ms_initialized: bool,
}
impl Default for MergeAppendState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnionState {
    pub ps: PlanState,
    pub recursing: bool,
    pub intermediate_empty: bool,
    pub working_table: *mut Tuplestorestate,
    pub intermediate_table: *mut Tuplestorestate,
    pub eqfunctions: *mut FmgrInfo,
    pub hashfunctions: *mut FmgrInfo,
    pub tempContext: MemoryContext,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
}
impl Default for RecursiveUnionState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAndState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::std::os::raw::c_int,
}
impl Default for BitmapAndState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOrState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::std::os::raw::c_int,
}
impl Default for BitmapOrState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScanState {
    pub ps: PlanState,
    pub ss_currentRelation: Relation,
    pub ss_currentScanDesc: HeapScanDesc,
    pub ss_ScanTupleSlot: *mut TupleTableSlot,
}
impl Default for ScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SeqScanState {
    pub ss: ScanState,
    pub pscan_len: Size,
}
impl Default for SeqScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScanState {
    pub ss: ScanState,
    pub args: *mut List,
    pub repeatable: *mut ExprState,
    pub tsmroutine: *mut TsmRoutine,
    pub tsm_state: *mut ::std::os::raw::c_void,
    pub use_bulkread: bool,
    pub use_pagemode: bool,
    pub begun: bool,
    pub seed: uint32,
}
impl Default for SampleScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexRuntimeKeyInfo {
    pub scan_key: ScanKey,
    pub key_expr: *mut ExprState,
    pub key_toastable: bool,
}
impl Default for IndexRuntimeKeyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexArrayKeyInfo {
    pub scan_key: ScanKey,
    pub array_expr: *mut ExprState,
    pub next_elem: ::std::os::raw::c_int,
    pub num_elems: ::std::os::raw::c_int,
    pub elem_values: *mut Datum,
    pub elem_nulls: *mut bool,
}
impl Default for IndexArrayKeyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScanState {
    pub ss: ScanState,
    pub indexqualorig: *mut ExprState,
    pub indexorderbyorig: *mut List,
    pub iss_ScanKeys: ScanKey,
    pub iss_NumScanKeys: ::std::os::raw::c_int,
    pub iss_OrderByKeys: ScanKey,
    pub iss_NumOrderByKeys: ::std::os::raw::c_int,
    pub iss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub iss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub iss_RuntimeKeysReady: bool,
    pub iss_RuntimeContext: *mut ExprContext,
    pub iss_RelationDesc: Relation,
    pub iss_ScanDesc: IndexScanDesc,
    pub iss_ReorderQueue: *mut pairingheap,
    pub iss_ReachedEnd: bool,
    pub iss_OrderByValues: *mut Datum,
    pub iss_OrderByNulls: *mut bool,
    pub iss_SortSupport: SortSupport,
    pub iss_OrderByTypByVals: *mut bool,
    pub iss_OrderByTypLens: *mut int16,
    pub iss_PscanLen: Size,
}
impl Default for IndexScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScanState {
    pub ss: ScanState,
    pub indexqual: *mut ExprState,
    pub ioss_ScanKeys: ScanKey,
    pub ioss_NumScanKeys: ::std::os::raw::c_int,
    pub ioss_OrderByKeys: ScanKey,
    pub ioss_NumOrderByKeys: ::std::os::raw::c_int,
    pub ioss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub ioss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub ioss_RuntimeKeysReady: bool,
    pub ioss_RuntimeContext: *mut ExprContext,
    pub ioss_RelationDesc: Relation,
    pub ioss_ScanDesc: IndexScanDesc,
    pub ioss_VMBuffer: Buffer,
    pub ioss_HeapFetches: ::std::os::raw::c_long,
    pub ioss_PscanLen: Size,
}
impl Default for IndexOnlyScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScanState {
    pub ss: ScanState,
    pub biss_result: *mut TIDBitmap,
    pub biss_ScanKeys: ScanKey,
    pub biss_NumScanKeys: ::std::os::raw::c_int,
    pub biss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub biss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub biss_ArrayKeys: *mut IndexArrayKeyInfo,
    pub biss_NumArrayKeys: ::std::os::raw::c_int,
    pub biss_RuntimeKeysReady: bool,
    pub biss_RuntimeContext: *mut ExprContext,
    pub biss_RelationDesc: Relation,
    pub biss_ScanDesc: IndexScanDesc,
}
impl Default for BitmapIndexScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SharedBitmapState_BM_INITIAL: SharedBitmapState = 0;
pub const SharedBitmapState_BM_INPROGRESS: SharedBitmapState = 1;
pub const SharedBitmapState_BM_FINISHED: SharedBitmapState = 2;
pub type SharedBitmapState = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct ParallelBitmapHeapState {
    pub tbmiterator: dsa_pointer,
    pub prefetch_iterator: dsa_pointer,
    pub mutex: slock_t,
    pub prefetch_pages: ::std::os::raw::c_int,
    pub prefetch_target: ::std::os::raw::c_int,
    pub state: SharedBitmapState,
    pub cv: ConditionVariable,
    pub phs_snapshot_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for ParallelBitmapHeapState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScanState {
    pub ss: ScanState,
    pub bitmapqualorig: *mut ExprState,
    pub tbm: *mut TIDBitmap,
    pub tbmiterator: *mut TBMIterator,
    pub tbmres: *mut TBMIterateResult,
    pub exact_pages: ::std::os::raw::c_long,
    pub lossy_pages: ::std::os::raw::c_long,
    pub prefetch_iterator: *mut TBMIterator,
    pub prefetch_pages: ::std::os::raw::c_int,
    pub prefetch_target: ::std::os::raw::c_int,
    pub prefetch_maximum: ::std::os::raw::c_int,
    pub pscan_len: Size,
    pub initialized: bool,
    pub shared_tbmiterator: *mut TBMSharedIterator,
    pub shared_prefetch_iterator: *mut TBMSharedIterator,
    pub pstate: *mut ParallelBitmapHeapState,
}
impl Default for BitmapHeapScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScanState {
    pub ss: ScanState,
    pub tss_tidexprs: *mut List,
    pub tss_isCurrentOf: bool,
    pub tss_NumTids: ::std::os::raw::c_int,
    pub tss_TidPtr: ::std::os::raw::c_int,
    pub tss_TidList: *mut ItemPointerData,
    pub tss_htup: HeapTupleData,
}
impl Default for TidScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScanState {
    pub ss: ScanState,
    pub subplan: *mut PlanState,
}
impl Default for SubqueryScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanPerFuncState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub ordinality: bool,
    pub simple: bool,
    pub ordinal: int64,
    pub nfuncs: ::std::os::raw::c_int,
    pub funcstates: *mut FunctionScanPerFuncState,
    pub argcontext: MemoryContext,
}
impl Default for FunctionScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScanState {
    pub ss: ScanState,
    pub rowcontext: *mut ExprContext,
    pub exprlists: *mut *mut List,
    pub array_len: ::std::os::raw::c_int,
    pub curr_idx: ::std::os::raw::c_int,
    pub exprstatelists: *mut *mut List,
}
impl Default for ValuesScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScanState {
    pub ss: ScanState,
    pub docexpr: *mut ExprState,
    pub rowexpr: *mut ExprState,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub ns_names: *mut List,
    pub ns_uris: *mut List,
    pub notnulls: *mut Bitmapset,
    pub opaque: *mut ::std::os::raw::c_void,
    pub routine: *mut TableFuncRoutine,
    pub in_functions: *mut FmgrInfo,
    pub typioparams: *mut Oid,
    pub ordinal: int64,
    pub perTableCxt: MemoryContext,
    pub tupstore: *mut Tuplestorestate,
}
impl Default for TableFuncScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScanState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub readptr: ::std::os::raw::c_int,
    pub cteplanstate: *mut PlanState,
    pub leader: *mut CteScanState,
    pub cte_table: *mut Tuplestorestate,
    pub eof_cte: bool,
}
impl Default for CteScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScanState {
    pub ss: ScanState,
    pub readptr: ::std::os::raw::c_int,
    pub tupdesc: TupleDesc,
    pub relation: *mut Tuplestorestate,
}
impl Default for NamedTuplestoreScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScanState {
    pub ss: ScanState,
    pub rustate: *mut RecursiveUnionState,
}
impl Default for WorkTableScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScanState {
    pub ss: ScanState,
    pub fdw_recheck_quals: *mut ExprState,
    pub pscan_len: Size,
    pub fdwroutine: *mut FdwRoutine,
    pub fdw_state: *mut ::std::os::raw::c_void,
}
impl Default for ForeignScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScanState {
    pub ss: ScanState,
    pub flags: uint32,
    pub custom_ps: *mut List,
    pub pscan_len: Size,
    pub methods: *const CustomExecMethods,
}
impl Default for CustomScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinState {
    pub ps: PlanState,
    pub jointype: JoinType,
    pub single_match: bool,
    pub joinqual: *mut ExprState,
}
impl Default for JoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopState {
    pub js: JoinState,
    pub nl_NeedNewOuter: bool,
    pub nl_MatchedOuter: bool,
    pub nl_NullInnerTupleSlot: *mut TupleTableSlot,
}
impl Default for NestLoopState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinClauseData {
    _unused: [u8; 0],
}
pub type MergeJoinClause = *mut MergeJoinClauseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinState {
    pub js: JoinState,
    pub mj_NumClauses: ::std::os::raw::c_int,
    pub mj_Clauses: MergeJoinClause,
    pub mj_JoinState: ::std::os::raw::c_int,
    pub mj_SkipMarkRestore: bool,
    pub mj_ExtraMarks: bool,
    pub mj_ConstFalseJoin: bool,
    pub mj_FillOuter: bool,
    pub mj_FillInner: bool,
    pub mj_MatchedOuter: bool,
    pub mj_MatchedInner: bool,
    pub mj_OuterTupleSlot: *mut TupleTableSlot,
    pub mj_InnerTupleSlot: *mut TupleTableSlot,
    pub mj_MarkedTupleSlot: *mut TupleTableSlot,
    pub mj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub mj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub mj_OuterEContext: *mut ExprContext,
    pub mj_InnerEContext: *mut ExprContext,
}
impl Default for MergeJoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTupleData {
    _unused: [u8; 0],
}
pub type HashJoinTuple = *mut HashJoinTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTableData {
    _unused: [u8; 0],
}
pub type HashJoinTable = *mut HashJoinTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinState {
    pub js: JoinState,
    pub hashclauses: *mut ExprState,
    pub hj_OuterHashKeys: *mut List,
    pub hj_InnerHashKeys: *mut List,
    pub hj_HashOperators: *mut List,
    pub hj_HashTable: HashJoinTable,
    pub hj_CurHashValue: uint32,
    pub hj_CurBucketNo: ::std::os::raw::c_int,
    pub hj_CurSkewBucketNo: ::std::os::raw::c_int,
    pub hj_CurTuple: HashJoinTuple,
    pub hj_OuterTupleSlot: *mut TupleTableSlot,
    pub hj_HashTupleSlot: *mut TupleTableSlot,
    pub hj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub hj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub hj_FirstOuterTupleSlot: *mut TupleTableSlot,
    pub hj_JoinState: ::std::os::raw::c_int,
    pub hj_MatchedOuter: bool,
    pub hj_OuterNotEmpty: bool,
}
impl Default for HashJoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MaterialState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub eof_underlying: bool,
    pub tuplestorestate: *mut Tuplestorestate,
}
impl Default for MaterialState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortState {
    pub ss: ScanState,
    pub randomAccess: bool,
    pub bounded: bool,
    pub bound: int64,
    pub sort_Done: bool,
    pub bounded_Done: bool,
    pub bound_Done: int64,
    pub tuplesortstate: *mut ::std::os::raw::c_void,
}
impl Default for SortState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupState {
    pub ss: ScanState,
    pub eqfunctions: *mut FmgrInfo,
    pub grp_done: bool,
}
impl Default for GroupState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerAggData {
    _unused: [u8; 0],
}
pub type AggStatePerAgg = *mut AggStatePerAggData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerTransData {
    _unused: [u8; 0],
}
pub type AggStatePerTrans = *mut AggStatePerTransData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerGroupData {
    _unused: [u8; 0],
}
pub type AggStatePerGroup = *mut AggStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerPhaseData {
    _unused: [u8; 0],
}
pub type AggStatePerPhase = *mut AggStatePerPhaseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerHashData {
    _unused: [u8; 0],
}
pub type AggStatePerHash = *mut AggStatePerHashData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggState {
    pub ss: ScanState,
    pub aggs: *mut List,
    pub numaggs: ::std::os::raw::c_int,
    pub numtrans: ::std::os::raw::c_int,
    pub aggstrategy: AggStrategy,
    pub aggsplit: AggSplit,
    pub phase: AggStatePerPhase,
    pub numphases: ::std::os::raw::c_int,
    pub current_phase: ::std::os::raw::c_int,
    pub peragg: AggStatePerAgg,
    pub pertrans: AggStatePerTrans,
    pub hashcontext: *mut ExprContext,
    pub aggcontexts: *mut *mut ExprContext,
    pub tmpcontext: *mut ExprContext,
    pub curaggcontext: *mut ExprContext,
    pub curpertrans: AggStatePerTrans,
    pub input_done: bool,
    pub agg_done: bool,
    pub projected_set: ::std::os::raw::c_int,
    pub current_set: ::std::os::raw::c_int,
    pub grouped_cols: *mut Bitmapset,
    pub all_grouped_cols: *mut List,
    pub maxsets: ::std::os::raw::c_int,
    pub phases: AggStatePerPhase,
    pub sort_in: *mut Tuplesortstate,
    pub sort_out: *mut Tuplesortstate,
    pub sort_slot: *mut TupleTableSlot,
    pub pergroup: AggStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub table_filled: bool,
    pub num_hashes: ::std::os::raw::c_int,
    pub perhash: AggStatePerHash,
    pub hash_pergroup: *mut AggStatePerGroup,
    pub combinedproj: *mut ProjectionInfo,
    pub curperagg: AggStatePerAgg,
}
impl Default for AggState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerFuncData {
    _unused: [u8; 0],
}
pub type WindowStatePerFunc = *mut WindowStatePerFuncData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerAggData {
    _unused: [u8; 0],
}
pub type WindowStatePerAgg = *mut WindowStatePerAggData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAggState {
    pub ss: ScanState,
    pub funcs: *mut List,
    pub numfuncs: ::std::os::raw::c_int,
    pub numaggs: ::std::os::raw::c_int,
    pub perfunc: WindowStatePerFunc,
    pub peragg: WindowStatePerAgg,
    pub partEqfunctions: *mut FmgrInfo,
    pub ordEqfunctions: *mut FmgrInfo,
    pub buffer: *mut Tuplestorestate,
    pub current_ptr: ::std::os::raw::c_int,
    pub spooled_rows: int64,
    pub currentpos: int64,
    pub frameheadpos: int64,
    pub frametailpos: int64,
    pub agg_winobj: *mut WindowObjectData,
    pub aggregatedbase: int64,
    pub aggregatedupto: int64,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut ExprState,
    pub endOffset: *mut ExprState,
    pub startOffsetValue: Datum,
    pub endOffsetValue: Datum,
    pub partcontext: MemoryContext,
    pub aggcontext: MemoryContext,
    pub curaggcontext: MemoryContext,
    pub tmpcontext: *mut ExprContext,
    pub all_first: bool,
    pub all_done: bool,
    pub partition_spooled: bool,
    pub more_partitions: bool,
    pub framehead_valid: bool,
    pub frametail_valid: bool,
    pub first_part_slot: *mut TupleTableSlot,
    pub agg_row_slot: *mut TupleTableSlot,
    pub temp_slot_1: *mut TupleTableSlot,
    pub temp_slot_2: *mut TupleTableSlot,
}
impl Default for WindowAggState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UniqueState {
    pub ps: PlanState,
    pub eqfunctions: *mut FmgrInfo,
    pub tempContext: MemoryContext,
}
impl Default for UniqueState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherState {
    pub ps: PlanState,
    pub initialized: bool,
    pub need_to_scan_locally: bool,
    pub funnel_slot: *mut TupleTableSlot,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub nreaders: ::std::os::raw::c_int,
    pub nextreader: ::std::os::raw::c_int,
    pub reader: *mut *mut TupleQueueReader,
}
impl Default for GatherState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GMReaderTupleBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMergeState {
    pub ps: PlanState,
    pub initialized: bool,
    pub gm_initialized: bool,
    pub need_to_scan_locally: bool,
    pub tupDesc: TupleDesc,
    pub gm_nkeys: ::std::os::raw::c_int,
    pub gm_sortkeys: SortSupport,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub nreaders: ::std::os::raw::c_int,
    pub gm_slots: *mut *mut TupleTableSlot,
    pub reader: *mut *mut TupleQueueReader,
    pub gm_tuple_buffers: *mut GMReaderTupleBuffer,
    pub gm_heap: *mut binaryheap,
}
impl Default for GatherMergeState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashState {
    pub ps: PlanState,
    pub hashtable: HashJoinTable,
    pub hashkeys: *mut List,
}
impl Default for HashState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpStatePerGroupData {
    _unused: [u8; 0],
}
pub type SetOpStatePerGroup = *mut SetOpStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpState {
    pub ps: PlanState,
    pub eqfunctions: *mut FmgrInfo,
    pub hashfunctions: *mut FmgrInfo,
    pub setop_done: bool,
    pub numOutput: ::std::os::raw::c_long,
    pub tempContext: MemoryContext,
    pub pergroup: SetOpStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
    pub table_filled: bool,
    pub hashiter: TupleHashIterator,
}
impl Default for SetOpState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRowsState {
    pub ps: PlanState,
    pub lr_arowMarks: *mut List,
    pub lr_epqstate: EPQState,
    pub lr_curtuples: *mut HeapTuple,
    pub lr_ntables: ::std::os::raw::c_int,
}
impl Default for LockRowsState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const LimitStateCond_LIMIT_INITIAL: LimitStateCond = 0;
pub const LimitStateCond_LIMIT_RESCAN: LimitStateCond = 1;
pub const LimitStateCond_LIMIT_EMPTY: LimitStateCond = 2;
pub const LimitStateCond_LIMIT_INWINDOW: LimitStateCond = 3;
pub const LimitStateCond_LIMIT_SUBPLANEOF: LimitStateCond = 4;
pub const LimitStateCond_LIMIT_WINDOWEND: LimitStateCond = 5;
pub const LimitStateCond_LIMIT_WINDOWSTART: LimitStateCond = 6;
pub type LimitStateCond = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LimitState {
    pub ps: PlanState,
    pub limitOffset: *mut ExprState,
    pub limitCount: *mut ExprState,
    pub offset: int64,
    pub count: int64,
    pub noCount: bool,
    pub lstate: LimitStateCond,
    pub position: int64,
    pub subSlot: *mut TupleTableSlot,
}
impl Default for LimitState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Value {
    pub type_: NodeTag,
    pub val: Value_ValUnion,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union Value_ValUnion {
    pub ival: ::std::os::raw::c_long,
    pub str_: *mut ::std::os::raw::c_char,
}
impl Default for Value_ValUnion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for Value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn makeInteger(i: ::std::os::raw::c_long) -> *mut Value;
}
#[pg_guard]
extern "C" {
    pub fn makeFloat(numericStr: *mut ::std::os::raw::c_char) -> *mut Value;
}
#[pg_guard]
extern "C" {
    pub fn makeString(str_: *mut ::std::os::raw::c_char) -> *mut Value;
}
#[pg_guard]
extern "C" {
    pub fn makeBitString(str_: *mut ::std::os::raw::c_char) -> *mut Value;
}
pub const OverridingKind_OVERRIDING_NOT_SET: OverridingKind = 0;
pub const OverridingKind_OVERRIDING_USER_VALUE: OverridingKind = 1;
pub const OverridingKind_OVERRIDING_SYSTEM_VALUE: OverridingKind = 2;
pub type OverridingKind = ::std::os::raw::c_uint;
pub const QuerySource_QSRC_ORIGINAL: QuerySource = 0;
pub const QuerySource_QSRC_PARSER: QuerySource = 1;
pub const QuerySource_QSRC_INSTEAD_RULE: QuerySource = 2;
pub const QuerySource_QSRC_QUAL_INSTEAD_RULE: QuerySource = 3;
pub const QuerySource_QSRC_NON_INSTEAD_RULE: QuerySource = 4;
pub type QuerySource = ::std::os::raw::c_uint;
pub const SortByDir_SORTBY_DEFAULT: SortByDir = 0;
pub const SortByDir_SORTBY_ASC: SortByDir = 1;
pub const SortByDir_SORTBY_DESC: SortByDir = 2;
pub const SortByDir_SORTBY_USING: SortByDir = 3;
pub type SortByDir = ::std::os::raw::c_uint;
pub const SortByNulls_SORTBY_NULLS_DEFAULT: SortByNulls = 0;
pub const SortByNulls_SORTBY_NULLS_FIRST: SortByNulls = 1;
pub const SortByNulls_SORTBY_NULLS_LAST: SortByNulls = 2;
pub type SortByNulls = ::std::os::raw::c_uint;
pub type AclMode = uint32;
#[doc = "\tQuery Tree"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Query {
    pub type_: NodeTag,
    pub commandType: CmdType,
    pub querySource: QuerySource,
    pub queryId: uint32,
    pub canSetTag: bool,
    pub utilityStmt: *mut Node,
    pub resultRelation: ::std::os::raw::c_int,
    pub hasAggs: bool,
    pub hasWindowFuncs: bool,
    pub hasTargetSRFs: bool,
    pub hasSubLinks: bool,
    pub hasDistinctOn: bool,
    pub hasRecursive: bool,
    pub hasModifyingCTE: bool,
    pub hasForUpdate: bool,
    pub hasRowSecurity: bool,
    pub cteList: *mut List,
    pub rtable: *mut List,
    pub jointree: *mut FromExpr,
    pub targetList: *mut List,
    pub override_: OverridingKind,
    pub onConflict: *mut OnConflictExpr,
    pub returningList: *mut List,
    pub groupClause: *mut List,
    pub groupingSets: *mut List,
    pub havingQual: *mut Node,
    pub windowClause: *mut List,
    pub distinctClause: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub rowMarks: *mut List,
    pub setOperations: *mut Node,
    pub constraintDeps: *mut List,
    pub withCheckOptions: *mut List,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for Query {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\tSupporting data structures for Parse Trees"]
#[doc = ""]
#[doc = "\tMost of these node types appear in raw parsetrees output by the grammar,"]
#[doc = "\tand get transformed to something else by the analyzer.  A few of them"]
#[doc = "\tare used as-is in transformed querytrees."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeName {
    pub type_: NodeTag,
    pub names: *mut List,
    pub typeOid: Oid,
    pub setof: bool,
    pub pct_type: bool,
    pub typmods: *mut List,
    pub typemod: int32,
    pub arrayBounds: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for TypeName {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnRef {
    pub type_: NodeTag,
    pub fields: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ColumnRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamRef {
    pub type_: NodeTag,
    pub number: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for ParamRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const A_Expr_Kind_AEXPR_OP: A_Expr_Kind = 0;
pub const A_Expr_Kind_AEXPR_OP_ANY: A_Expr_Kind = 1;
pub const A_Expr_Kind_AEXPR_OP_ALL: A_Expr_Kind = 2;
pub const A_Expr_Kind_AEXPR_DISTINCT: A_Expr_Kind = 3;
pub const A_Expr_Kind_AEXPR_NOT_DISTINCT: A_Expr_Kind = 4;
pub const A_Expr_Kind_AEXPR_NULLIF: A_Expr_Kind = 5;
pub const A_Expr_Kind_AEXPR_OF: A_Expr_Kind = 6;
pub const A_Expr_Kind_AEXPR_IN: A_Expr_Kind = 7;
pub const A_Expr_Kind_AEXPR_LIKE: A_Expr_Kind = 8;
pub const A_Expr_Kind_AEXPR_ILIKE: A_Expr_Kind = 9;
pub const A_Expr_Kind_AEXPR_SIMILAR: A_Expr_Kind = 10;
pub const A_Expr_Kind_AEXPR_BETWEEN: A_Expr_Kind = 11;
pub const A_Expr_Kind_AEXPR_NOT_BETWEEN: A_Expr_Kind = 12;
pub const A_Expr_Kind_AEXPR_BETWEEN_SYM: A_Expr_Kind = 13;
pub const A_Expr_Kind_AEXPR_NOT_BETWEEN_SYM: A_Expr_Kind = 14;
pub const A_Expr_Kind_AEXPR_PAREN: A_Expr_Kind = 15;
pub type A_Expr_Kind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Expr {
    pub type_: NodeTag,
    pub kind: A_Expr_Kind,
    pub name: *mut List,
    pub lexpr: *mut Node,
    pub rexpr: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_Expr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct A_Const {
    pub type_: NodeTag,
    pub val: Value,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_Const {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeCast {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::std::os::raw::c_int,
}
impl Default for TypeCast {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateClause {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub collname: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for CollateClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RoleSpecType_ROLESPEC_CSTRING: RoleSpecType = 0;
pub const RoleSpecType_ROLESPEC_CURRENT_USER: RoleSpecType = 1;
pub const RoleSpecType_ROLESPEC_SESSION_USER: RoleSpecType = 2;
pub const RoleSpecType_ROLESPEC_PUBLIC: RoleSpecType = 3;
pub type RoleSpecType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RoleSpec {
    pub type_: NodeTag,
    pub roletype: RoleSpecType,
    pub rolename: *mut ::std::os::raw::c_char,
    pub location: ::std::os::raw::c_int,
}
impl Default for RoleSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncCall {
    pub type_: NodeTag,
    pub funcname: *mut List,
    pub args: *mut List,
    pub agg_order: *mut List,
    pub agg_filter: *mut Node,
    pub agg_within_group: bool,
    pub agg_star: bool,
    pub agg_distinct: bool,
    pub func_variadic: bool,
    pub over: *mut WindowDef,
    pub location: ::std::os::raw::c_int,
}
impl Default for FuncCall {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Star {
    pub type_: NodeTag,
}
impl Default for A_Star {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indices {
    pub type_: NodeTag,
    pub is_slice: bool,
    pub lidx: *mut Node,
    pub uidx: *mut Node,
}
impl Default for A_Indices {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indirection {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub indirection: *mut List,
}
impl Default for A_Indirection {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_ArrayExpr {
    pub type_: NodeTag,
    pub elements: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_ArrayExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResTarget {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub indirection: *mut List,
    pub val: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for ResTarget {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MultiAssignRef {
    pub type_: NodeTag,
    pub source: *mut Node,
    pub colno: ::std::os::raw::c_int,
    pub ncolumns: ::std::os::raw::c_int,
}
impl Default for MultiAssignRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortBy {
    pub type_: NodeTag,
    pub node: *mut Node,
    pub sortby_dir: SortByDir,
    pub sortby_nulls: SortByNulls,
    pub useOp: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for SortBy {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowDef {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub refname: *mut ::std::os::raw::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for WindowDef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeSubselect {
    pub type_: NodeTag,
    pub lateral: bool,
    pub subquery: *mut Node,
    pub alias: *mut Alias,
}
impl Default for RangeSubselect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeFunction {
    pub type_: NodeTag,
    pub lateral: bool,
    pub ordinality: bool,
    pub is_rowsfrom: bool,
    pub functions: *mut List,
    pub alias: *mut Alias,
    pub coldeflist: *mut List,
}
impl Default for RangeFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFunc {
    pub type_: NodeTag,
    pub lateral: bool,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub namespaces: *mut List,
    pub columns: *mut List,
    pub alias: *mut Alias,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFuncCol {
    pub type_: NodeTag,
    pub colname: *mut ::std::os::raw::c_char,
    pub typeName: *mut TypeName,
    pub for_ordinality: bool,
    pub is_not_null: bool,
    pub colexpr: *mut Node,
    pub coldefexpr: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableFuncCol {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableSample {
    pub type_: NodeTag,
    pub relation: *mut Node,
    pub method: *mut List,
    pub args: *mut List,
    pub repeatable: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableSample {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnDef {
    pub type_: NodeTag,
    pub colname: *mut ::std::os::raw::c_char,
    pub typeName: *mut TypeName,
    pub inhcount: ::std::os::raw::c_int,
    pub is_local: bool,
    pub is_not_null: bool,
    pub is_from_type: bool,
    pub is_from_parent: bool,
    pub storage: ::std::os::raw::c_char,
    pub raw_default: *mut Node,
    pub cooked_default: *mut Node,
    pub identity: ::std::os::raw::c_char,
    pub identitySequence: *mut RangeVar,
    pub collClause: *mut CollateClause,
    pub collOid: Oid,
    pub constraints: *mut List,
    pub fdwoptions: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ColumnDef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableLikeClause {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub options: bits32,
    pub relationOid: Oid,
}
impl Default for TableLikeClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TableLikeOption_CREATE_TABLE_LIKE_DEFAULTS: TableLikeOption = 1;
pub const TableLikeOption_CREATE_TABLE_LIKE_CONSTRAINTS: TableLikeOption = 2;
pub const TableLikeOption_CREATE_TABLE_LIKE_IDENTITY: TableLikeOption = 4;
pub const TableLikeOption_CREATE_TABLE_LIKE_INDEXES: TableLikeOption = 8;
pub const TableLikeOption_CREATE_TABLE_LIKE_STORAGE: TableLikeOption = 16;
pub const TableLikeOption_CREATE_TABLE_LIKE_COMMENTS: TableLikeOption = 32;
pub const TableLikeOption_CREATE_TABLE_LIKE_STATISTICS: TableLikeOption = 64;
pub const TableLikeOption_CREATE_TABLE_LIKE_ALL: TableLikeOption = 2147483647;
pub type TableLikeOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexElem {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub expr: *mut Node,
    pub indexcolname: *mut ::std::os::raw::c_char,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub ordering: SortByDir,
    pub nulls_ordering: SortByNulls,
}
impl Default for IndexElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DefElemAction_DEFELEM_UNSPEC: DefElemAction = 0;
pub const DefElemAction_DEFELEM_SET: DefElemAction = 1;
pub const DefElemAction_DEFELEM_ADD: DefElemAction = 2;
pub const DefElemAction_DEFELEM_DROP: DefElemAction = 3;
pub type DefElemAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DefElem {
    pub type_: NodeTag,
    pub defnamespace: *mut ::std::os::raw::c_char,
    pub defname: *mut ::std::os::raw::c_char,
    pub arg: *mut Node,
    pub defaction: DefElemAction,
    pub location: ::std::os::raw::c_int,
}
impl Default for DefElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockingClause {
    pub type_: NodeTag,
    pub lockedRels: *mut List,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
}
impl Default for LockingClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlSerialize {
    pub type_: NodeTag,
    pub xmloption: XmlOptionType,
    pub expr: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::std::os::raw::c_int,
}
impl Default for XmlSerialize {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionElem {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub expr: *mut Node,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionSpec {
    pub type_: NodeTag,
    pub strategy: *mut ::std::os::raw::c_char,
    pub partParams: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundSpec {
    pub type_: NodeTag,
    pub strategy: ::std::os::raw::c_char,
    pub listdatums: *mut List,
    pub lowerdatums: *mut List,
    pub upperdatums: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionBoundSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_MINVALUE: PartitionRangeDatumKind = -1;
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_VALUE: PartitionRangeDatumKind = 0;
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_MAXVALUE: PartitionRangeDatumKind = 1;
pub type PartitionRangeDatumKind = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionRangeDatum {
    pub type_: NodeTag,
    pub kind: PartitionRangeDatumKind,
    pub value: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionRangeDatum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionCmd {
    pub type_: NodeTag,
    pub name: *mut RangeVar,
    pub bound: *mut PartitionBoundSpec,
}
impl Default for PartitionCmd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RTEKind_RTE_RELATION: RTEKind = 0;
pub const RTEKind_RTE_SUBQUERY: RTEKind = 1;
pub const RTEKind_RTE_JOIN: RTEKind = 2;
pub const RTEKind_RTE_FUNCTION: RTEKind = 3;
pub const RTEKind_RTE_TABLEFUNC: RTEKind = 4;
pub const RTEKind_RTE_VALUES: RTEKind = 5;
pub const RTEKind_RTE_CTE: RTEKind = 6;
pub const RTEKind_RTE_NAMEDTUPLESTORE: RTEKind = 7;
pub type RTEKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblEntry {
    pub type_: NodeTag,
    pub rtekind: RTEKind,
    pub relid: Oid,
    pub relkind: ::std::os::raw::c_char,
    pub tablesample: *mut TableSampleClause,
    pub subquery: *mut Query,
    pub security_barrier: bool,
    pub jointype: JoinType,
    pub joinaliasvars: *mut List,
    pub functions: *mut List,
    pub funcordinality: bool,
    pub tablefunc: *mut TableFunc,
    pub values_lists: *mut List,
    pub ctename: *mut ::std::os::raw::c_char,
    pub ctelevelsup: Index,
    pub self_reference: bool,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub enrname: *mut ::std::os::raw::c_char,
    pub enrtuples: f64,
    pub alias: *mut Alias,
    pub eref: *mut Alias,
    pub lateral: bool,
    pub inh: bool,
    pub inFromCl: bool,
    pub requiredPerms: AclMode,
    pub checkAsUser: Oid,
    pub selectedCols: *mut Bitmapset,
    pub insertedCols: *mut Bitmapset,
    pub updatedCols: *mut Bitmapset,
    pub securityQuals: *mut List,
}
impl Default for RangeTblEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblFunction {
    pub type_: NodeTag,
    pub funcexpr: *mut Node,
    pub funccolcount: ::std::os::raw::c_int,
    pub funccolnames: *mut List,
    pub funccoltypes: *mut List,
    pub funccoltypmods: *mut List,
    pub funccolcollations: *mut List,
    pub funcparams: *mut Bitmapset,
}
impl Default for RangeTblFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableSampleClause {
    pub type_: NodeTag,
    pub tsmhandler: Oid,
    pub args: *mut List,
    pub repeatable: *mut Expr,
}
impl Default for TableSampleClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const WCOKind_WCO_VIEW_CHECK: WCOKind = 0;
pub const WCOKind_WCO_RLS_INSERT_CHECK: WCOKind = 1;
pub const WCOKind_WCO_RLS_UPDATE_CHECK: WCOKind = 2;
pub const WCOKind_WCO_RLS_CONFLICT_CHECK: WCOKind = 3;
pub type WCOKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WithCheckOption {
    pub type_: NodeTag,
    pub kind: WCOKind,
    pub relname: *mut ::std::os::raw::c_char,
    pub polname: *mut ::std::os::raw::c_char,
    pub qual: *mut Node,
    pub cascaded: bool,
}
impl Default for WithCheckOption {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortGroupClause {
    pub type_: NodeTag,
    pub tleSortGroupRef: Index,
    pub eqop: Oid,
    pub sortop: Oid,
    pub nulls_first: bool,
    pub hashable: bool,
}
impl Default for SortGroupClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const GroupingSetKind_GROUPING_SET_EMPTY: GroupingSetKind = 0;
pub const GroupingSetKind_GROUPING_SET_SIMPLE: GroupingSetKind = 1;
pub const GroupingSetKind_GROUPING_SET_ROLLUP: GroupingSetKind = 2;
pub const GroupingSetKind_GROUPING_SET_CUBE: GroupingSetKind = 3;
pub const GroupingSetKind_GROUPING_SET_SETS: GroupingSetKind = 4;
pub type GroupingSetKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingSet {
    pub type_: NodeTag,
    pub kind: GroupingSetKind,
    pub content: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for GroupingSet {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowClause {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub refname: *mut ::std::os::raw::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub winref: Index,
    pub copiedOrder: bool,
}
impl Default for WindowClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowMarkClause {
    pub type_: NodeTag,
    pub rti: Index,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub pushedDown: bool,
}
impl Default for RowMarkClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WithClause {
    pub type_: NodeTag,
    pub ctes: *mut List,
    pub recursive: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for WithClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferClause {
    pub type_: NodeTag,
    pub indexElems: *mut List,
    pub whereClause: *mut Node,
    pub conname: *mut ::std::os::raw::c_char,
    pub location: ::std::os::raw::c_int,
}
impl Default for InferClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictClause {
    pub type_: NodeTag,
    pub action: OnConflictAction,
    pub infer: *mut InferClause,
    pub targetList: *mut List,
    pub whereClause: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for OnConflictClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommonTableExpr {
    pub type_: NodeTag,
    pub ctename: *mut ::std::os::raw::c_char,
    pub aliascolnames: *mut List,
    pub ctequery: *mut Node,
    pub location: ::std::os::raw::c_int,
    pub cterecursive: bool,
    pub cterefcount: ::std::os::raw::c_int,
    pub ctecolnames: *mut List,
    pub ctecoltypes: *mut List,
    pub ctecoltypmods: *mut List,
    pub ctecolcollations: *mut List,
}
impl Default for CommonTableExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerTransition {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub isNew: bool,
    pub isTable: bool,
}
impl Default for TriggerTransition {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\t\tRaw Grammar Output Statements"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RawStmt {
    pub type_: NodeTag,
    pub stmt: *mut Node,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for RawStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\t\tOptimizable Statements"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InsertStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub cols: *mut List,
    pub selectStmt: *mut Node,
    pub onConflictClause: *mut OnConflictClause,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
    pub override_: OverridingKind,
}
impl Default for InsertStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeleteStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub usingClause: *mut List,
    pub whereClause: *mut Node,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for DeleteStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UpdateStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub targetList: *mut List,
    pub whereClause: *mut Node,
    pub fromClause: *mut List,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for UpdateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SetOperation_SETOP_NONE: SetOperation = 0;
pub const SetOperation_SETOP_UNION: SetOperation = 1;
pub const SetOperation_SETOP_INTERSECT: SetOperation = 2;
pub const SetOperation_SETOP_EXCEPT: SetOperation = 3;
pub type SetOperation = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SelectStmt {
    pub type_: NodeTag,
    pub distinctClause: *mut List,
    pub intoClause: *mut IntoClause,
    pub targetList: *mut List,
    pub fromClause: *mut List,
    pub whereClause: *mut Node,
    pub groupClause: *mut List,
    pub havingClause: *mut Node,
    pub windowClause: *mut List,
    pub valuesLists: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub lockingClause: *mut List,
    pub withClause: *mut WithClause,
    pub op: SetOperation,
    pub all: bool,
    pub larg: *mut SelectStmt,
    pub rarg: *mut SelectStmt,
}
impl Default for SelectStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOperationStmt {
    pub type_: NodeTag,
    pub op: SetOperation,
    pub all: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub colTypes: *mut List,
    pub colTypmods: *mut List,
    pub colCollations: *mut List,
    pub groupClauses: *mut List,
}
impl Default for SetOperationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ObjectType_OBJECT_ACCESS_METHOD: ObjectType = 0;
pub const ObjectType_OBJECT_AGGREGATE: ObjectType = 1;
pub const ObjectType_OBJECT_AMOP: ObjectType = 2;
pub const ObjectType_OBJECT_AMPROC: ObjectType = 3;
pub const ObjectType_OBJECT_ATTRIBUTE: ObjectType = 4;
pub const ObjectType_OBJECT_CAST: ObjectType = 5;
pub const ObjectType_OBJECT_COLUMN: ObjectType = 6;
pub const ObjectType_OBJECT_COLLATION: ObjectType = 7;
pub const ObjectType_OBJECT_CONVERSION: ObjectType = 8;
pub const ObjectType_OBJECT_DATABASE: ObjectType = 9;
pub const ObjectType_OBJECT_DEFAULT: ObjectType = 10;
pub const ObjectType_OBJECT_DEFACL: ObjectType = 11;
pub const ObjectType_OBJECT_DOMAIN: ObjectType = 12;
pub const ObjectType_OBJECT_DOMCONSTRAINT: ObjectType = 13;
pub const ObjectType_OBJECT_EVENT_TRIGGER: ObjectType = 14;
pub const ObjectType_OBJECT_EXTENSION: ObjectType = 15;
pub const ObjectType_OBJECT_FDW: ObjectType = 16;
pub const ObjectType_OBJECT_FOREIGN_SERVER: ObjectType = 17;
pub const ObjectType_OBJECT_FOREIGN_TABLE: ObjectType = 18;
pub const ObjectType_OBJECT_FUNCTION: ObjectType = 19;
pub const ObjectType_OBJECT_INDEX: ObjectType = 20;
pub const ObjectType_OBJECT_LANGUAGE: ObjectType = 21;
pub const ObjectType_OBJECT_LARGEOBJECT: ObjectType = 22;
pub const ObjectType_OBJECT_MATVIEW: ObjectType = 23;
pub const ObjectType_OBJECT_OPCLASS: ObjectType = 24;
pub const ObjectType_OBJECT_OPERATOR: ObjectType = 25;
pub const ObjectType_OBJECT_OPFAMILY: ObjectType = 26;
pub const ObjectType_OBJECT_POLICY: ObjectType = 27;
pub const ObjectType_OBJECT_PUBLICATION: ObjectType = 28;
pub const ObjectType_OBJECT_PUBLICATION_REL: ObjectType = 29;
pub const ObjectType_OBJECT_ROLE: ObjectType = 30;
pub const ObjectType_OBJECT_RULE: ObjectType = 31;
pub const ObjectType_OBJECT_SCHEMA: ObjectType = 32;
pub const ObjectType_OBJECT_SEQUENCE: ObjectType = 33;
pub const ObjectType_OBJECT_SUBSCRIPTION: ObjectType = 34;
pub const ObjectType_OBJECT_STATISTIC_EXT: ObjectType = 35;
pub const ObjectType_OBJECT_TABCONSTRAINT: ObjectType = 36;
pub const ObjectType_OBJECT_TABLE: ObjectType = 37;
pub const ObjectType_OBJECT_TABLESPACE: ObjectType = 38;
pub const ObjectType_OBJECT_TRANSFORM: ObjectType = 39;
pub const ObjectType_OBJECT_TRIGGER: ObjectType = 40;
pub const ObjectType_OBJECT_TSCONFIGURATION: ObjectType = 41;
pub const ObjectType_OBJECT_TSDICTIONARY: ObjectType = 42;
pub const ObjectType_OBJECT_TSPARSER: ObjectType = 43;
pub const ObjectType_OBJECT_TSTEMPLATE: ObjectType = 44;
pub const ObjectType_OBJECT_TYPE: ObjectType = 45;
pub const ObjectType_OBJECT_USER_MAPPING: ObjectType = 46;
pub const ObjectType_OBJECT_VIEW: ObjectType = 47;
#[doc = "\t\tOther Statements (no optimizations required)"]
#[doc = ""]
#[doc = "\t\tThese are not touched by parser/analyze.c except to put them into"]
#[doc = "\t\tthe utilityStmt field of a Query.  This is eventually passed to"]
#[doc = "\t\tProcessUtility (by-passing rewriting and planning).  Some of the"]
#[doc = "\t\tstatements do need attention from parse analysis, and this is"]
#[doc = "\t\tdone by routines in parser/parse_utilcmd.c after ProcessUtility"]
#[doc = "\t\treceives the command for execution."]
#[doc = "\t\tDECLARE CURSOR, EXPLAIN, and CREATE TABLE AS are special cases:"]
#[doc = "\t\tthey contain optimizable statements, which get processed normally"]
#[doc = "\t\tby parser/analyze.c."]
pub type ObjectType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSchemaStmt {
    pub type_: NodeTag,
    pub schemaname: *mut ::std::os::raw::c_char,
    pub authrole: *mut RoleSpec,
    pub schemaElts: *mut List,
    pub if_not_exists: bool,
}
impl Default for CreateSchemaStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DropBehavior_DROP_RESTRICT: DropBehavior = 0;
pub const DropBehavior_DROP_CASCADE: DropBehavior = 1;
pub type DropBehavior = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub cmds: *mut List,
    pub relkind: ObjectType,
    pub missing_ok: bool,
}
impl Default for AlterTableStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AlterTableType_AT_AddColumn: AlterTableType = 0;
pub const AlterTableType_AT_AddColumnRecurse: AlterTableType = 1;
pub const AlterTableType_AT_AddColumnToView: AlterTableType = 2;
pub const AlterTableType_AT_ColumnDefault: AlterTableType = 3;
pub const AlterTableType_AT_DropNotNull: AlterTableType = 4;
pub const AlterTableType_AT_SetNotNull: AlterTableType = 5;
pub const AlterTableType_AT_SetStatistics: AlterTableType = 6;
pub const AlterTableType_AT_SetOptions: AlterTableType = 7;
pub const AlterTableType_AT_ResetOptions: AlterTableType = 8;
pub const AlterTableType_AT_SetStorage: AlterTableType = 9;
pub const AlterTableType_AT_DropColumn: AlterTableType = 10;
pub const AlterTableType_AT_DropColumnRecurse: AlterTableType = 11;
pub const AlterTableType_AT_AddIndex: AlterTableType = 12;
pub const AlterTableType_AT_ReAddIndex: AlterTableType = 13;
pub const AlterTableType_AT_AddConstraint: AlterTableType = 14;
pub const AlterTableType_AT_AddConstraintRecurse: AlterTableType = 15;
pub const AlterTableType_AT_ReAddConstraint: AlterTableType = 16;
pub const AlterTableType_AT_AlterConstraint: AlterTableType = 17;
pub const AlterTableType_AT_ValidateConstraint: AlterTableType = 18;
pub const AlterTableType_AT_ValidateConstraintRecurse: AlterTableType = 19;
pub const AlterTableType_AT_ProcessedConstraint: AlterTableType = 20;
pub const AlterTableType_AT_AddIndexConstraint: AlterTableType = 21;
pub const AlterTableType_AT_DropConstraint: AlterTableType = 22;
pub const AlterTableType_AT_DropConstraintRecurse: AlterTableType = 23;
pub const AlterTableType_AT_ReAddComment: AlterTableType = 24;
pub const AlterTableType_AT_AlterColumnType: AlterTableType = 25;
pub const AlterTableType_AT_AlterColumnGenericOptions: AlterTableType = 26;
pub const AlterTableType_AT_ChangeOwner: AlterTableType = 27;
pub const AlterTableType_AT_ClusterOn: AlterTableType = 28;
pub const AlterTableType_AT_DropCluster: AlterTableType = 29;
pub const AlterTableType_AT_SetLogged: AlterTableType = 30;
pub const AlterTableType_AT_SetUnLogged: AlterTableType = 31;
pub const AlterTableType_AT_AddOids: AlterTableType = 32;
pub const AlterTableType_AT_AddOidsRecurse: AlterTableType = 33;
pub const AlterTableType_AT_DropOids: AlterTableType = 34;
pub const AlterTableType_AT_SetTableSpace: AlterTableType = 35;
pub const AlterTableType_AT_SetRelOptions: AlterTableType = 36;
pub const AlterTableType_AT_ResetRelOptions: AlterTableType = 37;
pub const AlterTableType_AT_ReplaceRelOptions: AlterTableType = 38;
pub const AlterTableType_AT_EnableTrig: AlterTableType = 39;
pub const AlterTableType_AT_EnableAlwaysTrig: AlterTableType = 40;
pub const AlterTableType_AT_EnableReplicaTrig: AlterTableType = 41;
pub const AlterTableType_AT_DisableTrig: AlterTableType = 42;
pub const AlterTableType_AT_EnableTrigAll: AlterTableType = 43;
pub const AlterTableType_AT_DisableTrigAll: AlterTableType = 44;
pub const AlterTableType_AT_EnableTrigUser: AlterTableType = 45;
pub const AlterTableType_AT_DisableTrigUser: AlterTableType = 46;
pub const AlterTableType_AT_EnableRule: AlterTableType = 47;
pub const AlterTableType_AT_EnableAlwaysRule: AlterTableType = 48;
pub const AlterTableType_AT_EnableReplicaRule: AlterTableType = 49;
pub const AlterTableType_AT_DisableRule: AlterTableType = 50;
pub const AlterTableType_AT_AddInherit: AlterTableType = 51;
pub const AlterTableType_AT_DropInherit: AlterTableType = 52;
pub const AlterTableType_AT_AddOf: AlterTableType = 53;
pub const AlterTableType_AT_DropOf: AlterTableType = 54;
pub const AlterTableType_AT_ReplicaIdentity: AlterTableType = 55;
pub const AlterTableType_AT_EnableRowSecurity: AlterTableType = 56;
pub const AlterTableType_AT_DisableRowSecurity: AlterTableType = 57;
pub const AlterTableType_AT_ForceRowSecurity: AlterTableType = 58;
pub const AlterTableType_AT_NoForceRowSecurity: AlterTableType = 59;
pub const AlterTableType_AT_GenericOptions: AlterTableType = 60;
pub const AlterTableType_AT_AttachPartition: AlterTableType = 61;
pub const AlterTableType_AT_DetachPartition: AlterTableType = 62;
pub const AlterTableType_AT_AddIdentity: AlterTableType = 63;
pub const AlterTableType_AT_SetIdentity: AlterTableType = 64;
pub const AlterTableType_AT_DropIdentity: AlterTableType = 65;
pub type AlterTableType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReplicaIdentityStmt {
    pub type_: NodeTag,
    pub identity_type: ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for ReplicaIdentityStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableCmd {
    pub type_: NodeTag,
    pub subtype: AlterTableType,
    pub name: *mut ::std::os::raw::c_char,
    pub newowner: *mut RoleSpec,
    pub def: *mut Node,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
}
impl Default for AlterTableCmd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterCollationStmt {
    pub type_: NodeTag,
    pub collname: *mut List,
}
impl Default for AlterCollationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDomainStmt {
    pub type_: NodeTag,
    pub subtype: ::std::os::raw::c_char,
    pub typeName: *mut List,
    pub name: *mut ::std::os::raw::c_char,
    pub def: *mut Node,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
}
impl Default for AlterDomainStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const GrantTargetType_ACL_TARGET_OBJECT: GrantTargetType = 0;
pub const GrantTargetType_ACL_TARGET_ALL_IN_SCHEMA: GrantTargetType = 1;
pub const GrantTargetType_ACL_TARGET_DEFAULTS: GrantTargetType = 2;
pub type GrantTargetType = ::std::os::raw::c_uint;
pub const GrantObjectType_ACL_OBJECT_COLUMN: GrantObjectType = 0;
pub const GrantObjectType_ACL_OBJECT_RELATION: GrantObjectType = 1;
pub const GrantObjectType_ACL_OBJECT_SEQUENCE: GrantObjectType = 2;
pub const GrantObjectType_ACL_OBJECT_DATABASE: GrantObjectType = 3;
pub const GrantObjectType_ACL_OBJECT_DOMAIN: GrantObjectType = 4;
pub const GrantObjectType_ACL_OBJECT_FDW: GrantObjectType = 5;
pub const GrantObjectType_ACL_OBJECT_FOREIGN_SERVER: GrantObjectType = 6;
pub const GrantObjectType_ACL_OBJECT_FUNCTION: GrantObjectType = 7;
pub const GrantObjectType_ACL_OBJECT_LANGUAGE: GrantObjectType = 8;
pub const GrantObjectType_ACL_OBJECT_LARGEOBJECT: GrantObjectType = 9;
pub const GrantObjectType_ACL_OBJECT_NAMESPACE: GrantObjectType = 10;
pub const GrantObjectType_ACL_OBJECT_TABLESPACE: GrantObjectType = 11;
pub const GrantObjectType_ACL_OBJECT_TYPE: GrantObjectType = 12;
pub type GrantObjectType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrantStmt {
    pub type_: NodeTag,
    pub is_grant: bool,
    pub targtype: GrantTargetType,
    pub objtype: GrantObjectType,
    pub objects: *mut List,
    pub privileges: *mut List,
    pub grantees: *mut List,
    pub grant_option: bool,
    pub behavior: DropBehavior,
}
impl Default for GrantStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectWithArgs {
    pub type_: NodeTag,
    pub objname: *mut List,
    pub objargs: *mut List,
    pub args_unspecified: bool,
}
impl Default for ObjectWithArgs {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AccessPriv {
    pub type_: NodeTag,
    pub priv_name: *mut ::std::os::raw::c_char,
    pub cols: *mut List,
}
impl Default for AccessPriv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrantRoleStmt {
    pub type_: NodeTag,
    pub granted_roles: *mut List,
    pub grantee_roles: *mut List,
    pub is_grant: bool,
    pub admin_opt: bool,
    pub grantor: *mut RoleSpec,
    pub behavior: DropBehavior,
}
impl Default for GrantRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDefaultPrivilegesStmt {
    pub type_: NodeTag,
    pub options: *mut List,
    pub action: *mut GrantStmt,
}
impl Default for AlterDefaultPrivilegesStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub query: *mut Node,
    pub attlist: *mut List,
    pub is_from: bool,
    pub is_program: bool,
    pub filename: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CopyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const VariableSetKind_VAR_SET_VALUE: VariableSetKind = 0;
pub const VariableSetKind_VAR_SET_DEFAULT: VariableSetKind = 1;
pub const VariableSetKind_VAR_SET_CURRENT: VariableSetKind = 2;
pub const VariableSetKind_VAR_SET_MULTI: VariableSetKind = 3;
pub const VariableSetKind_VAR_RESET: VariableSetKind = 4;
pub const VariableSetKind_VAR_RESET_ALL: VariableSetKind = 5;
pub type VariableSetKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableSetStmt {
    pub type_: NodeTag,
    pub kind: VariableSetKind,
    pub name: *mut ::std::os::raw::c_char,
    pub args: *mut List,
    pub is_local: bool,
}
impl Default for VariableSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableShowStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for VariableShowStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub tableElts: *mut List,
    pub inhRelations: *mut List,
    pub partbound: *mut PartitionBoundSpec,
    pub partspec: *mut PartitionSpec,
    pub ofTypename: *mut TypeName,
    pub constraints: *mut List,
    pub options: *mut List,
    pub oncommit: OnCommitAction,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
}
impl Default for CreateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ConstrType_CONSTR_NULL: ConstrType = 0;
pub const ConstrType_CONSTR_NOTNULL: ConstrType = 1;
pub const ConstrType_CONSTR_DEFAULT: ConstrType = 2;
pub const ConstrType_CONSTR_IDENTITY: ConstrType = 3;
pub const ConstrType_CONSTR_CHECK: ConstrType = 4;
pub const ConstrType_CONSTR_PRIMARY: ConstrType = 5;
pub const ConstrType_CONSTR_UNIQUE: ConstrType = 6;
pub const ConstrType_CONSTR_EXCLUSION: ConstrType = 7;
pub const ConstrType_CONSTR_FOREIGN: ConstrType = 8;
pub const ConstrType_CONSTR_ATTR_DEFERRABLE: ConstrType = 9;
pub const ConstrType_CONSTR_ATTR_NOT_DEFERRABLE: ConstrType = 10;
pub const ConstrType_CONSTR_ATTR_DEFERRED: ConstrType = 11;
pub const ConstrType_CONSTR_ATTR_IMMEDIATE: ConstrType = 12;
pub type ConstrType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Constraint {
    pub type_: NodeTag,
    pub contype: ConstrType,
    pub conname: *mut ::std::os::raw::c_char,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub location: ::std::os::raw::c_int,
    pub is_no_inherit: bool,
    pub raw_expr: *mut Node,
    pub cooked_expr: *mut ::std::os::raw::c_char,
    pub generated_when: ::std::os::raw::c_char,
    pub keys: *mut List,
    pub exclusions: *mut List,
    pub options: *mut List,
    pub indexname: *mut ::std::os::raw::c_char,
    pub indexspace: *mut ::std::os::raw::c_char,
    pub access_method: *mut ::std::os::raw::c_char,
    pub where_clause: *mut Node,
    pub pktable: *mut RangeVar,
    pub fk_attrs: *mut List,
    pub pk_attrs: *mut List,
    pub fk_matchtype: ::std::os::raw::c_char,
    pub fk_upd_action: ::std::os::raw::c_char,
    pub fk_del_action: ::std::os::raw::c_char,
    pub old_conpfeqop: *mut List,
    pub old_pktable_oid: Oid,
    pub skip_validation: bool,
    pub initially_valid: bool,
}
impl Default for Constraint {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTableSpaceStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub owner: *mut RoleSpec,
    pub location: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreateTableSpaceStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropTableSpaceStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for DropTableSpaceStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableSpaceOptionsStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub isReset: bool,
}
impl Default for AlterTableSpaceOptionsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableMoveAllStmt {
    pub type_: NodeTag,
    pub orig_tablespacename: *mut ::std::os::raw::c_char,
    pub objtype: ObjectType,
    pub roles: *mut List,
    pub new_tablespacename: *mut ::std::os::raw::c_char,
    pub nowait: bool,
}
impl Default for AlterTableMoveAllStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateExtensionStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateExtensionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterExtensionStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for AlterExtensionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterExtensionContentsStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub action: ::std::os::raw::c_int,
    pub objtype: ObjectType,
    pub object: *mut Node,
}
impl Default for AlterExtensionContentsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateFdwStmt {
    pub type_: NodeTag,
    pub fdwname: *mut ::std::os::raw::c_char,
    pub func_options: *mut List,
    pub options: *mut List,
}
impl Default for CreateFdwStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterFdwStmt {
    pub type_: NodeTag,
    pub fdwname: *mut ::std::os::raw::c_char,
    pub func_options: *mut List,
    pub options: *mut List,
}
impl Default for AlterFdwStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateForeignServerStmt {
    pub type_: NodeTag,
    pub servername: *mut ::std::os::raw::c_char,
    pub servertype: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub fdwname: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateForeignServerStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterForeignServerStmt {
    pub type_: NodeTag,
    pub servername: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub has_version: bool,
}
impl Default for AlterForeignServerStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateForeignTableStmt {
    pub base: CreateStmt,
    pub servername: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreateForeignTableStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateUserMappingStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for AlterUserMappingStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for DropUserMappingStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImportForeignSchemaType_FDW_IMPORT_SCHEMA_ALL: ImportForeignSchemaType = 0;
pub const ImportForeignSchemaType_FDW_IMPORT_SCHEMA_LIMIT_TO: ImportForeignSchemaType = 1;
pub const ImportForeignSchemaType_FDW_IMPORT_SCHEMA_EXCEPT: ImportForeignSchemaType = 2;
pub type ImportForeignSchemaType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImportForeignSchemaStmt {
    pub type_: NodeTag,
    pub server_name: *mut ::std::os::raw::c_char,
    pub remote_schema: *mut ::std::os::raw::c_char,
    pub local_schema: *mut ::std::os::raw::c_char,
    pub list_type: ImportForeignSchemaType,
    pub table_list: *mut List,
    pub options: *mut List,
}
impl Default for ImportForeignSchemaStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePolicyStmt {
    pub type_: NodeTag,
    pub policy_name: *mut ::std::os::raw::c_char,
    pub table: *mut RangeVar,
    pub cmd_name: *mut ::std::os::raw::c_char,
    pub permissive: bool,
    pub roles: *mut List,
    pub qual: *mut Node,
    pub with_check: *mut Node,
}
impl Default for CreatePolicyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterPolicyStmt {
    pub type_: NodeTag,
    pub policy_name: *mut ::std::os::raw::c_char,
    pub table: *mut RangeVar,
    pub roles: *mut List,
    pub qual: *mut Node,
    pub with_check: *mut Node,
}
impl Default for AlterPolicyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateAmStmt {
    pub type_: NodeTag,
    pub amname: *mut ::std::os::raw::c_char,
    pub handler_name: *mut List,
    pub amtype: ::std::os::raw::c_char,
}
impl Default for CreateAmStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::std::os::raw::c_char,
    pub relation: *mut RangeVar,
    pub funcname: *mut List,
    pub args: *mut List,
    pub row: bool,
    pub timing: int16,
    pub events: int16,
    pub columns: *mut List,
    pub whenClause: *mut Node,
    pub isconstraint: bool,
    pub transitionRels: *mut List,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub constrrel: *mut RangeVar,
}
impl Default for CreateTrigStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateEventTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::std::os::raw::c_char,
    pub eventname: *mut ::std::os::raw::c_char,
    pub whenclause: *mut List,
    pub funcname: *mut List,
}
impl Default for CreateEventTrigStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterEventTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::std::os::raw::c_char,
    pub tgenabled: ::std::os::raw::c_char,
}
impl Default for AlterEventTrigStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePLangStmt {
    pub type_: NodeTag,
    pub replace: bool,
    pub plname: *mut ::std::os::raw::c_char,
    pub plhandler: *mut List,
    pub plinline: *mut List,
    pub plvalidator: *mut List,
    pub pltrusted: bool,
}
impl Default for CreatePLangStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RoleStmtType_ROLESTMT_ROLE: RoleStmtType = 0;
pub const RoleStmtType_ROLESTMT_USER: RoleStmtType = 1;
pub const RoleStmtType_ROLESTMT_GROUP: RoleStmtType = 2;
pub type RoleStmtType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateRoleStmt {
    pub type_: NodeTag,
    pub stmt_type: RoleStmtType,
    pub role: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreateRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterRoleStmt {
    pub type_: NodeTag,
    pub role: *mut RoleSpec,
    pub options: *mut List,
    pub action: ::std::os::raw::c_int,
}
impl Default for AlterRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterRoleSetStmt {
    pub type_: NodeTag,
    pub role: *mut RoleSpec,
    pub database: *mut ::std::os::raw::c_char,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterRoleSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropRoleStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub missing_ok: bool,
}
impl Default for DropRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSeqStmt {
    pub type_: NodeTag,
    pub sequence: *mut RangeVar,
    pub options: *mut List,
    pub ownerId: Oid,
    pub for_identity: bool,
    pub if_not_exists: bool,
}
impl Default for CreateSeqStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSeqStmt {
    pub type_: NodeTag,
    pub sequence: *mut RangeVar,
    pub options: *mut List,
    pub for_identity: bool,
    pub missing_ok: bool,
}
impl Default for AlterSeqStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DefineStmt {
    pub type_: NodeTag,
    pub kind: ObjectType,
    pub oldstyle: bool,
    pub defnames: *mut List,
    pub args: *mut List,
    pub definition: *mut List,
    pub if_not_exists: bool,
}
impl Default for DefineStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateDomainStmt {
    pub type_: NodeTag,
    pub domainname: *mut List,
    pub typeName: *mut TypeName,
    pub collClause: *mut CollateClause,
    pub constraints: *mut List,
}
impl Default for CreateDomainStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpClassStmt {
    pub type_: NodeTag,
    pub opclassname: *mut List,
    pub opfamilyname: *mut List,
    pub amname: *mut ::std::os::raw::c_char,
    pub datatype: *mut TypeName,
    pub items: *mut List,
    pub isDefault: bool,
}
impl Default for CreateOpClassStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpClassItem {
    pub type_: NodeTag,
    pub itemtype: ::std::os::raw::c_int,
    pub name: *mut ObjectWithArgs,
    pub number: ::std::os::raw::c_int,
    pub order_family: *mut List,
    pub class_args: *mut List,
    pub storedtype: *mut TypeName,
}
impl Default for CreateOpClassItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpFamilyStmt {
    pub type_: NodeTag,
    pub opfamilyname: *mut List,
    pub amname: *mut ::std::os::raw::c_char,
}
impl Default for CreateOpFamilyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOpFamilyStmt {
    pub type_: NodeTag,
    pub opfamilyname: *mut List,
    pub amname: *mut ::std::os::raw::c_char,
    pub isDrop: bool,
    pub items: *mut List,
}
impl Default for AlterOpFamilyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropStmt {
    pub type_: NodeTag,
    pub objects: *mut List,
    pub removeType: ObjectType,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
    pub concurrent: bool,
}
impl Default for DropStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TruncateStmt {
    pub type_: NodeTag,
    pub relations: *mut List,
    pub restart_seqs: bool,
    pub behavior: DropBehavior,
}
impl Default for TruncateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommentStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType,
    pub object: *mut Node,
    pub comment: *mut ::std::os::raw::c_char,
}
impl Default for CommentStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SecLabelStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType,
    pub object: *mut Node,
    pub provider: *mut ::std::os::raw::c_char,
    pub label: *mut ::std::os::raw::c_char,
}
impl Default for SecLabelStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeclareCursorStmt {
    pub type_: NodeTag,
    pub portalname: *mut ::std::os::raw::c_char,
    pub options: ::std::os::raw::c_int,
    pub query: *mut Node,
}
impl Default for DeclareCursorStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ClosePortalStmt {
    pub type_: NodeTag,
    pub portalname: *mut ::std::os::raw::c_char,
}
impl Default for ClosePortalStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const FetchDirection_FETCH_FORWARD: FetchDirection = 0;
pub const FetchDirection_FETCH_BACKWARD: FetchDirection = 1;
pub const FetchDirection_FETCH_ABSOLUTE: FetchDirection = 2;
pub const FetchDirection_FETCH_RELATIVE: FetchDirection = 3;
pub type FetchDirection = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FetchStmt {
    pub type_: NodeTag,
    pub direction: FetchDirection,
    pub howMany: ::std::os::raw::c_long,
    pub portalname: *mut ::std::os::raw::c_char,
    pub ismove: bool,
}
impl Default for FetchStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexStmt {
    pub type_: NodeTag,
    pub idxname: *mut ::std::os::raw::c_char,
    pub relation: *mut RangeVar,
    pub accessMethod: *mut ::std::os::raw::c_char,
    pub tableSpace: *mut ::std::os::raw::c_char,
    pub indexParams: *mut List,
    pub options: *mut List,
    pub whereClause: *mut Node,
    pub excludeOpNames: *mut List,
    pub idxcomment: *mut ::std::os::raw::c_char,
    pub indexOid: Oid,
    pub oldNode: Oid,
    pub unique: bool,
    pub primary: bool,
    pub isconstraint: bool,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub transformed: bool,
    pub concurrent: bool,
    pub if_not_exists: bool,
}
impl Default for IndexStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateStatsStmt {
    pub type_: NodeTag,
    pub defnames: *mut List,
    pub stat_types: *mut List,
    pub exprs: *mut List,
    pub relations: *mut List,
    pub if_not_exists: bool,
}
impl Default for CreateStatsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateFunctionStmt {
    pub type_: NodeTag,
    pub replace: bool,
    pub funcname: *mut List,
    pub parameters: *mut List,
    pub returnType: *mut TypeName,
    pub options: *mut List,
    pub withClause: *mut List,
}
impl Default for CreateFunctionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const FunctionParameterMode_FUNC_PARAM_IN: FunctionParameterMode = 105;
pub const FunctionParameterMode_FUNC_PARAM_OUT: FunctionParameterMode = 111;
pub const FunctionParameterMode_FUNC_PARAM_INOUT: FunctionParameterMode = 98;
pub const FunctionParameterMode_FUNC_PARAM_VARIADIC: FunctionParameterMode = 118;
pub const FunctionParameterMode_FUNC_PARAM_TABLE: FunctionParameterMode = 116;
pub type FunctionParameterMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionParameter {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub argType: *mut TypeName,
    pub mode: FunctionParameterMode,
    pub defexpr: *mut Node,
}
impl Default for FunctionParameter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterFunctionStmt {
    pub type_: NodeTag,
    pub func: *mut ObjectWithArgs,
    pub actions: *mut List,
}
impl Default for AlterFunctionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DoStmt {
    pub type_: NodeTag,
    pub args: *mut List,
}
impl Default for DoStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InlineCodeBlock {
    pub type_: NodeTag,
    pub source_text: *mut ::std::os::raw::c_char,
    pub langOid: Oid,
    pub langIsTrusted: bool,
}
impl Default for InlineCodeBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RenameStmt {
    pub type_: NodeTag,
    pub renameType: ObjectType,
    pub relationType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub subname: *mut ::std::os::raw::c_char,
    pub newname: *mut ::std::os::raw::c_char,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
}
impl Default for RenameStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterObjectDependsStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub extname: *mut Value,
}
impl Default for AlterObjectDependsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterObjectSchemaStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub newschema: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for AlterObjectSchemaStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOwnerStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub newowner: *mut RoleSpec,
}
impl Default for AlterOwnerStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOperatorStmt {
    pub type_: NodeTag,
    pub opername: *mut ObjectWithArgs,
    pub options: *mut List,
}
impl Default for AlterOperatorStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RuleStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub rulename: *mut ::std::os::raw::c_char,
    pub whereClause: *mut Node,
    pub event: CmdType,
    pub instead: bool,
    pub actions: *mut List,
    pub replace: bool,
}
impl Default for RuleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NotifyStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::std::os::raw::c_char,
    pub payload: *mut ::std::os::raw::c_char,
}
impl Default for NotifyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ListenStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::std::os::raw::c_char,
}
impl Default for ListenStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UnlistenStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::std::os::raw::c_char,
}
impl Default for UnlistenStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TransactionStmtKind_TRANS_STMT_BEGIN: TransactionStmtKind = 0;
pub const TransactionStmtKind_TRANS_STMT_START: TransactionStmtKind = 1;
pub const TransactionStmtKind_TRANS_STMT_COMMIT: TransactionStmtKind = 2;
pub const TransactionStmtKind_TRANS_STMT_ROLLBACK: TransactionStmtKind = 3;
pub const TransactionStmtKind_TRANS_STMT_SAVEPOINT: TransactionStmtKind = 4;
pub const TransactionStmtKind_TRANS_STMT_RELEASE: TransactionStmtKind = 5;
pub const TransactionStmtKind_TRANS_STMT_ROLLBACK_TO: TransactionStmtKind = 6;
pub const TransactionStmtKind_TRANS_STMT_PREPARE: TransactionStmtKind = 7;
pub const TransactionStmtKind_TRANS_STMT_COMMIT_PREPARED: TransactionStmtKind = 8;
pub const TransactionStmtKind_TRANS_STMT_ROLLBACK_PREPARED: TransactionStmtKind = 9;
pub type TransactionStmtKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TransactionStmt {
    pub type_: NodeTag,
    pub kind: TransactionStmtKind,
    pub options: *mut List,
    pub gid: *mut ::std::os::raw::c_char,
}
impl Default for TransactionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CompositeTypeStmt {
    pub type_: NodeTag,
    pub typevar: *mut RangeVar,
    pub coldeflist: *mut List,
}
impl Default for CompositeTypeStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateEnumStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub vals: *mut List,
}
impl Default for CreateEnumStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateRangeStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub params: *mut List,
}
impl Default for CreateRangeStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterEnumStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub oldVal: *mut ::std::os::raw::c_char,
    pub newVal: *mut ::std::os::raw::c_char,
    pub newValNeighbor: *mut ::std::os::raw::c_char,
    pub newValIsAfter: bool,
    pub skipIfNewValExists: bool,
}
impl Default for AlterEnumStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ViewCheckOption_NO_CHECK_OPTION: ViewCheckOption = 0;
pub const ViewCheckOption_LOCAL_CHECK_OPTION: ViewCheckOption = 1;
pub const ViewCheckOption_CASCADED_CHECK_OPTION: ViewCheckOption = 2;
pub type ViewCheckOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ViewStmt {
    pub type_: NodeTag,
    pub view: *mut RangeVar,
    pub aliases: *mut List,
    pub query: *mut Node,
    pub replace: bool,
    pub options: *mut List,
    pub withCheckOption: ViewCheckOption,
}
impl Default for ViewStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LoadStmt {
    pub type_: NodeTag,
    pub filename: *mut ::std::os::raw::c_char,
}
impl Default for LoadStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatedbStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreatedbStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDatabaseStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for AlterDatabaseStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDatabaseSetStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterDatabaseSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropdbStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for DropdbStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSystemStmt {
    pub type_: NodeTag,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterSystemStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ClusterStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub indexname: *mut ::std::os::raw::c_char,
    pub verbose: bool,
}
impl Default for ClusterStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const VacuumOption_VACOPT_VACUUM: VacuumOption = 1;
pub const VacuumOption_VACOPT_ANALYZE: VacuumOption = 2;
pub const VacuumOption_VACOPT_VERBOSE: VacuumOption = 4;
pub const VacuumOption_VACOPT_FREEZE: VacuumOption = 8;
pub const VacuumOption_VACOPT_FULL: VacuumOption = 16;
pub const VacuumOption_VACOPT_NOWAIT: VacuumOption = 32;
pub const VacuumOption_VACOPT_SKIPTOAST: VacuumOption = 64;
pub const VacuumOption_VACOPT_DISABLE_PAGE_SKIPPING: VacuumOption = 128;
pub type VacuumOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VacuumStmt {
    pub type_: NodeTag,
    pub options: ::std::os::raw::c_int,
    pub relation: *mut RangeVar,
    pub va_cols: *mut List,
}
impl Default for VacuumStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExplainStmt {
    pub type_: NodeTag,
    pub query: *mut Node,
    pub options: *mut List,
}
impl Default for ExplainStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTableAsStmt {
    pub type_: NodeTag,
    pub query: *mut Node,
    pub into: *mut IntoClause,
    pub relkind: ObjectType,
    pub is_select_into: bool,
    pub if_not_exists: bool,
}
impl Default for CreateTableAsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RefreshMatViewStmt {
    pub type_: NodeTag,
    pub concurrent: bool,
    pub skipData: bool,
    pub relation: *mut RangeVar,
}
impl Default for RefreshMatViewStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CheckPointStmt {
    pub type_: NodeTag,
}
impl Default for CheckPointStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DiscardMode_DISCARD_ALL: DiscardMode = 0;
pub const DiscardMode_DISCARD_PLANS: DiscardMode = 1;
pub const DiscardMode_DISCARD_SEQUENCES: DiscardMode = 2;
pub const DiscardMode_DISCARD_TEMP: DiscardMode = 3;
pub type DiscardMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DiscardStmt {
    pub type_: NodeTag,
    pub target: DiscardMode,
}
impl Default for DiscardStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockStmt {
    pub type_: NodeTag,
    pub relations: *mut List,
    pub mode: ::std::os::raw::c_int,
    pub nowait: bool,
}
impl Default for LockStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConstraintsSetStmt {
    pub type_: NodeTag,
    pub constraints: *mut List,
    pub deferred: bool,
}
impl Default for ConstraintsSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ReindexObjectType_REINDEX_OBJECT_INDEX: ReindexObjectType = 0;
pub const ReindexObjectType_REINDEX_OBJECT_TABLE: ReindexObjectType = 1;
pub const ReindexObjectType_REINDEX_OBJECT_SCHEMA: ReindexObjectType = 2;
pub const ReindexObjectType_REINDEX_OBJECT_SYSTEM: ReindexObjectType = 3;
pub const ReindexObjectType_REINDEX_OBJECT_DATABASE: ReindexObjectType = 4;
pub type ReindexObjectType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReindexStmt {
    pub type_: NodeTag,
    pub kind: ReindexObjectType,
    pub relation: *mut RangeVar,
    pub name: *const ::std::os::raw::c_char,
    pub options: ::std::os::raw::c_int,
}
impl Default for ReindexStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateConversionStmt {
    pub type_: NodeTag,
    pub conversion_name: *mut List,
    pub for_encoding_name: *mut ::std::os::raw::c_char,
    pub to_encoding_name: *mut ::std::os::raw::c_char,
    pub func_name: *mut List,
    pub def: bool,
}
impl Default for CreateConversionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateCastStmt {
    pub type_: NodeTag,
    pub sourcetype: *mut TypeName,
    pub targettype: *mut TypeName,
    pub func: *mut ObjectWithArgs,
    pub context: CoercionContext,
    pub inout: bool,
}
impl Default for CreateCastStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTransformStmt {
    pub type_: NodeTag,
    pub replace: bool,
    pub type_name: *mut TypeName,
    pub lang: *mut ::std::os::raw::c_char,
    pub fromsql: *mut ObjectWithArgs,
    pub tosql: *mut ObjectWithArgs,
}
impl Default for CreateTransformStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PrepareStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub argtypes: *mut List,
    pub query: *mut Node,
}
impl Default for PrepareStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecuteStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub params: *mut List,
}
impl Default for ExecuteStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeallocateStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for DeallocateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropOwnedStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub behavior: DropBehavior,
}
impl Default for DropOwnedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReassignOwnedStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub newrole: *mut RoleSpec,
}
impl Default for ReassignOwnedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTSDictionaryStmt {
    pub type_: NodeTag,
    pub dictname: *mut List,
    pub options: *mut List,
}
impl Default for AlterTSDictionaryStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AlterTSConfigType_ALTER_TSCONFIG_ADD_MAPPING: AlterTSConfigType = 0;
pub const AlterTSConfigType_ALTER_TSCONFIG_ALTER_MAPPING_FOR_TOKEN: AlterTSConfigType = 1;
pub const AlterTSConfigType_ALTER_TSCONFIG_REPLACE_DICT: AlterTSConfigType = 2;
pub const AlterTSConfigType_ALTER_TSCONFIG_REPLACE_DICT_FOR_TOKEN: AlterTSConfigType = 3;
pub const AlterTSConfigType_ALTER_TSCONFIG_DROP_MAPPING: AlterTSConfigType = 4;
pub type AlterTSConfigType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTSConfigurationStmt {
    pub type_: NodeTag,
    pub kind: AlterTSConfigType,
    pub cfgname: *mut List,
    pub tokentype: *mut List,
    pub dicts: *mut List,
    pub override_: bool,
    pub replace: bool,
    pub missing_ok: bool,
}
impl Default for AlterTSConfigurationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePublicationStmt {
    pub type_: NodeTag,
    pub pubname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub tables: *mut List,
    pub for_all_tables: bool,
}
impl Default for CreatePublicationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterPublicationStmt {
    pub type_: NodeTag,
    pub pubname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub tables: *mut List,
    pub for_all_tables: bool,
    pub tableAction: DefElemAction,
}
impl Default for AlterPublicationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSubscriptionStmt {
    pub type_: NodeTag,
    pub subname: *mut ::std::os::raw::c_char,
    pub conninfo: *mut ::std::os::raw::c_char,
    pub publication: *mut List,
    pub options: *mut List,
}
impl Default for CreateSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_OPTIONS: AlterSubscriptionType = 0;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_CONNECTION: AlterSubscriptionType = 1;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_PUBLICATION: AlterSubscriptionType = 2;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_REFRESH: AlterSubscriptionType = 3;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_ENABLED: AlterSubscriptionType = 4;
pub type AlterSubscriptionType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSubscriptionStmt {
    pub type_: NodeTag,
    pub kind: AlterSubscriptionType,
    pub subname: *mut ::std::os::raw::c_char,
    pub conninfo: *mut ::std::os::raw::c_char,
    pub publication: *mut List,
    pub options: *mut List,
}
impl Default for AlterSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropSubscriptionStmt {
    pub type_: NodeTag,
    pub subname: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
    pub behavior: DropBehavior,
}
impl Default for DropSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ParseExprKind_EXPR_KIND_NONE: ParseExprKind = 0;
pub const ParseExprKind_EXPR_KIND_OTHER: ParseExprKind = 1;
pub const ParseExprKind_EXPR_KIND_JOIN_ON: ParseExprKind = 2;
pub const ParseExprKind_EXPR_KIND_JOIN_USING: ParseExprKind = 3;
pub const ParseExprKind_EXPR_KIND_FROM_SUBSELECT: ParseExprKind = 4;
pub const ParseExprKind_EXPR_KIND_FROM_FUNCTION: ParseExprKind = 5;
pub const ParseExprKind_EXPR_KIND_WHERE: ParseExprKind = 6;
pub const ParseExprKind_EXPR_KIND_HAVING: ParseExprKind = 7;
pub const ParseExprKind_EXPR_KIND_FILTER: ParseExprKind = 8;
pub const ParseExprKind_EXPR_KIND_WINDOW_PARTITION: ParseExprKind = 9;
pub const ParseExprKind_EXPR_KIND_WINDOW_ORDER: ParseExprKind = 10;
pub const ParseExprKind_EXPR_KIND_WINDOW_FRAME_RANGE: ParseExprKind = 11;
pub const ParseExprKind_EXPR_KIND_WINDOW_FRAME_ROWS: ParseExprKind = 12;
pub const ParseExprKind_EXPR_KIND_SELECT_TARGET: ParseExprKind = 13;
pub const ParseExprKind_EXPR_KIND_INSERT_TARGET: ParseExprKind = 14;
pub const ParseExprKind_EXPR_KIND_UPDATE_SOURCE: ParseExprKind = 15;
pub const ParseExprKind_EXPR_KIND_UPDATE_TARGET: ParseExprKind = 16;
pub const ParseExprKind_EXPR_KIND_GROUP_BY: ParseExprKind = 17;
pub const ParseExprKind_EXPR_KIND_ORDER_BY: ParseExprKind = 18;
pub const ParseExprKind_EXPR_KIND_DISTINCT_ON: ParseExprKind = 19;
pub const ParseExprKind_EXPR_KIND_LIMIT: ParseExprKind = 20;
pub const ParseExprKind_EXPR_KIND_OFFSET: ParseExprKind = 21;
pub const ParseExprKind_EXPR_KIND_RETURNING: ParseExprKind = 22;
pub const ParseExprKind_EXPR_KIND_VALUES: ParseExprKind = 23;
pub const ParseExprKind_EXPR_KIND_VALUES_SINGLE: ParseExprKind = 24;
pub const ParseExprKind_EXPR_KIND_CHECK_CONSTRAINT: ParseExprKind = 25;
pub const ParseExprKind_EXPR_KIND_DOMAIN_CHECK: ParseExprKind = 26;
pub const ParseExprKind_EXPR_KIND_COLUMN_DEFAULT: ParseExprKind = 27;
pub const ParseExprKind_EXPR_KIND_FUNCTION_DEFAULT: ParseExprKind = 28;
pub const ParseExprKind_EXPR_KIND_INDEX_EXPRESSION: ParseExprKind = 29;
pub const ParseExprKind_EXPR_KIND_INDEX_PREDICATE: ParseExprKind = 30;
pub const ParseExprKind_EXPR_KIND_ALTER_COL_TRANSFORM: ParseExprKind = 31;
pub const ParseExprKind_EXPR_KIND_EXECUTE_PARAMETER: ParseExprKind = 32;
pub const ParseExprKind_EXPR_KIND_TRIGGER_WHEN: ParseExprKind = 33;
pub const ParseExprKind_EXPR_KIND_POLICY: ParseExprKind = 34;
pub const ParseExprKind_EXPR_KIND_PARTITION_EXPRESSION: ParseExprKind = 35;
pub type ParseExprKind = ::std::os::raw::c_uint;
pub type PreParseColumnRefHook = ::std::option::Option<
    unsafe extern "C" fn(pstate: *mut ParseState, cref: *mut ColumnRef) -> *mut Node,
>;
pub type PostParseColumnRefHook = ::std::option::Option<
    unsafe extern "C" fn(
        pstate: *mut ParseState,
        cref: *mut ColumnRef,
        var: *mut Node,
    ) -> *mut Node,
>;
pub type ParseParamRefHook = ::std::option::Option<
    unsafe extern "C" fn(pstate: *mut ParseState, pref: *mut ParamRef) -> *mut Node,
>;
pub type CoerceParamHook = ::std::option::Option<
    unsafe extern "C" fn(
        pstate: *mut ParseState,
        param: *mut Param,
        targetTypeId: Oid,
        targetTypeMod: int32,
        location: ::std::os::raw::c_int,
    ) -> *mut Node,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseState {
    pub parentParseState: *mut ParseState,
    pub p_sourcetext: *const ::std::os::raw::c_char,
    pub p_rtable: *mut List,
    pub p_joinexprs: *mut List,
    pub p_joinlist: *mut List,
    pub p_namespace: *mut List,
    pub p_lateral_active: bool,
    pub p_ctenamespace: *mut List,
    pub p_future_ctes: *mut List,
    pub p_parent_cte: *mut CommonTableExpr,
    pub p_target_relation: Relation,
    pub p_target_rangetblentry: *mut RangeTblEntry,
    pub p_is_insert: bool,
    pub p_windowdefs: *mut List,
    pub p_expr_kind: ParseExprKind,
    pub p_next_resno: ::std::os::raw::c_int,
    pub p_multiassign_exprs: *mut List,
    pub p_locking_clause: *mut List,
    pub p_locked_from_parent: bool,
    pub p_resolve_unknowns: bool,
    pub p_queryEnv: *mut QueryEnvironment,
    pub p_hasAggs: bool,
    pub p_hasWindowFuncs: bool,
    pub p_hasTargetSRFs: bool,
    pub p_hasSubLinks: bool,
    pub p_hasModifyingCTE: bool,
    pub p_last_srf: *mut Node,
    pub p_pre_columnref_hook: PreParseColumnRefHook,
    pub p_post_columnref_hook: PostParseColumnRefHook,
    pub p_paramref_hook: ParseParamRefHook,
    pub p_coerce_param_hook: CoerceParamHook,
    pub p_ref_hook_state: *mut ::std::os::raw::c_void,
}
impl Default for ParseState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseNamespaceItem {
    pub p_rte: *mut RangeTblEntry,
    pub p_rel_visible: bool,
    pub p_cols_visible: bool,
    pub p_lateral_only: bool,
    pub p_lateral_ok: bool,
}
impl Default for ParseNamespaceItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseCallbackState {
    pub pstate: *mut ParseState,
    pub location: ::std::os::raw::c_int,
    pub errcallback: ErrorContextCallback,
}
impl Default for ParseCallbackState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn make_parsestate(parentParseState: *mut ParseState) -> *mut ParseState;
}
#[pg_guard]
extern "C" {
    pub fn free_parsestate(pstate: *mut ParseState);
}
#[pg_guard]
extern "C" {
    pub fn parser_errposition(
        pstate: *mut ParseState,
        location: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn setup_parser_errposition_callback(
        pcbstate: *mut ParseCallbackState,
        pstate: *mut ParseState,
        location: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn cancel_parser_errposition_callback(pcbstate: *mut ParseCallbackState);
}
#[pg_guard]
extern "C" {
    pub fn make_var(
        pstate: *mut ParseState,
        rte: *mut RangeTblEntry,
        attrno: ::std::os::raw::c_int,
        location: ::std::os::raw::c_int,
    ) -> *mut Var;
}
#[pg_guard]
extern "C" {
    pub fn transformArrayType(arrayType: *mut Oid, arrayTypmod: *mut int32) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn transformArraySubscripts(
        pstate: *mut ParseState,
        arrayBase: *mut Node,
        arrayType: Oid,
        elementType: Oid,
        arrayTypMod: int32,
        indirection: *mut List,
        assignFrom: *mut Node,
    ) -> *mut ArrayRef;
}
#[pg_guard]
extern "C" {
    pub fn make_const(
        pstate: *mut ParseState,
        value: *mut Value,
        location: ::std::os::raw::c_int,
    ) -> *mut Const;
}
pub type RmgrId = uint8;
pub const RmgrIds_RM_XLOG_ID: RmgrIds = 0;
pub const RmgrIds_RM_XACT_ID: RmgrIds = 1;
pub const RmgrIds_RM_SMGR_ID: RmgrIds = 2;
pub const RmgrIds_RM_CLOG_ID: RmgrIds = 3;
pub const RmgrIds_RM_DBASE_ID: RmgrIds = 4;
pub const RmgrIds_RM_TBLSPC_ID: RmgrIds = 5;
pub const RmgrIds_RM_MULTIXACT_ID: RmgrIds = 6;
pub const RmgrIds_RM_RELMAP_ID: RmgrIds = 7;
pub const RmgrIds_RM_STANDBY_ID: RmgrIds = 8;
pub const RmgrIds_RM_HEAP2_ID: RmgrIds = 9;
pub const RmgrIds_RM_HEAP_ID: RmgrIds = 10;
pub const RmgrIds_RM_BTREE_ID: RmgrIds = 11;
pub const RmgrIds_RM_HASH_ID: RmgrIds = 12;
pub const RmgrIds_RM_GIN_ID: RmgrIds = 13;
pub const RmgrIds_RM_GIST_ID: RmgrIds = 14;
pub const RmgrIds_RM_SEQ_ID: RmgrIds = 15;
pub const RmgrIds_RM_SPGIST_ID: RmgrIds = 16;
pub const RmgrIds_RM_BRIN_ID: RmgrIds = 17;
pub const RmgrIds_RM_COMMIT_TS_ID: RmgrIds = 18;
pub const RmgrIds_RM_REPLORIGIN_ID: RmgrIds = 19;
pub const RmgrIds_RM_GENERIC_ID: RmgrIds = 20;
pub const RmgrIds_RM_LOGICALMSG_ID: RmgrIds = 21;
pub const RmgrIds_RM_NEXT_ID: RmgrIds = 22;
pub type RmgrIds = ::std::os::raw::c_uint;
pub const ForkNumber_InvalidForkNumber: ForkNumber = -1;
pub const ForkNumber_MAIN_FORKNUM: ForkNumber = 0;
pub const ForkNumber_FSM_FORKNUM: ForkNumber = 1;
pub const ForkNumber_VISIBILITYMAP_FORKNUM: ForkNumber = 2;
pub const ForkNumber_INIT_FORKNUM: ForkNumber = 3;
pub type ForkNumber = ::std::os::raw::c_int;
#[pg_guard]
extern "C" {
    pub static mut forkNames: [*const ::std::os::raw::c_char; 0usize];
}
#[pg_guard]
extern "C" {
    pub fn forkname_to_number(forkName: *const ::std::os::raw::c_char) -> ForkNumber;
}
#[pg_guard]
extern "C" {
    pub fn forkname_chars(
        str_: *const ::std::os::raw::c_char,
        fork: *mut ForkNumber,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn GetDatabasePath(dbNode: Oid, spcNode: Oid) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn GetRelationPath(
        dbNode: Oid,
        spcNode: Oid,
        relNode: Oid,
        backendId: ::std::os::raw::c_int,
        forkNumber: ForkNumber,
    ) -> *mut ::std::os::raw::c_char;
}
pub type BackendId = ::std::os::raw::c_int;
#[pg_guard]
extern "C" {
    pub static mut MyBackendId: BackendId;
}
#[pg_guard]
extern "C" {
    pub static mut ParallelMasterBackendId: BackendId;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct RelFileNode {
    pub spcNode: Oid,
    pub dbNode: Oid,
    pub relNode: Oid,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct RelFileNodeBackend {
    pub node: RelFileNode,
    pub backend: BackendId,
}
#[pg_guard]
extern "C" {
    pub fn XLogBeginInsert();
}
#[pg_guard]
extern "C" {
    pub fn XLogSetRecordFlags(flags: uint8);
}
#[pg_guard]
extern "C" {
    pub fn XLogInsert(rmid: RmgrId, info: uint8) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn XLogEnsureRecordSpace(nbuffers: ::std::os::raw::c_int, ndatas: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn XLogRegisterData(data: *mut ::std::os::raw::c_char, len: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn XLogRegisterBuffer(block_id: uint8, buffer: Buffer, flags: uint8);
}
#[pg_guard]
extern "C" {
    pub fn XLogRegisterBlock(
        block_id: uint8,
        rnode: *mut RelFileNode,
        forknum: ForkNumber,
        blknum: BlockNumber,
        page: *mut ::std::os::raw::c_char,
        flags: uint8,
    );
}
#[pg_guard]
extern "C" {
    pub fn XLogRegisterBufData(
        block_id: uint8,
        data: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn XLogResetInsertion();
}
#[pg_guard]
extern "C" {
    pub fn XLogCheckBufferNeedsBackup(buffer: Buffer) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn log_newpage(
        rnode: *mut RelFileNode,
        forkNum: ForkNumber,
        blk: BlockNumber,
        page: *mut ::std::os::raw::c_char,
        page_std: bool,
    ) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn log_newpage_buffer(buffer: Buffer, page_std: bool) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn log_newpage_range(
        rel: Relation,
        forkNum: ForkNumber,
        startblk: BlockNumber,
        endblk: BlockNumber,
        page_std: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn XLogSaveBufferForHint(buffer: Buffer, buffer_std: bool) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn InitXLogInsert();
}
pub type pg_crc32c = uint32;
#[pg_guard]
extern "C" {
    pub fn pg_comp_crc32c_sse42(
        crc: pg_crc32c,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> pg_crc32c;
}
#[pg_guard]
extern "C" {
    pub fn pg_comp_crc32c_sb8(
        crc: pg_crc32c,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> pg_crc32c;
}
#[pg_guard]
extern "C" {
    pub static mut pg_comp_crc32c: ::std::option::Option<
        unsafe extern "C" fn(
            crc: pg_crc32c,
            data: *const ::std::os::raw::c_void,
            len: usize,
        ) -> pg_crc32c,
    >;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecord {
    pub xl_tot_len: uint32,
    pub xl_xid: TransactionId,
    pub xl_prev: XLogRecPtr,
    pub xl_info: uint8,
    pub xl_rmid: RmgrId,
    pub xl_crc: pg_crc32c,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockHeader {
    pub id: uint8,
    pub fork_flags: uint8,
    pub data_length: uint16,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockImageHeader {
    pub length: uint16,
    pub hole_offset: uint16,
    pub bimg_info: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockCompressHeader {
    pub hole_length: uint16,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordDataHeaderShort {
    pub id: uint8,
    pub data_length: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordDataHeaderLong {
    pub id: uint8,
}
pub type XLogPageReadCB = ::std::option::Option<
    unsafe extern "C" fn(
        xlogreader: *mut XLogReaderState,
        targetPagePtr: XLogRecPtr,
        reqLen: ::std::os::raw::c_int,
        targetRecPtr: XLogRecPtr,
        readBuf: *mut ::std::os::raw::c_char,
        pageTLI: *mut TimeLineID,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DecodedBkpBlock {
    pub in_use: bool,
    pub rnode: RelFileNode,
    pub forknum: ForkNumber,
    pub blkno: BlockNumber,
    pub flags: uint8,
    pub has_image: bool,
    pub apply_image: bool,
    pub bkp_image: *mut ::std::os::raw::c_char,
    pub hole_offset: uint16,
    pub hole_length: uint16,
    pub bimg_len: uint16,
    pub bimg_info: uint8,
    pub has_data: bool,
    pub data: *mut ::std::os::raw::c_char,
    pub data_len: uint16,
    pub data_bufsz: uint16,
}
impl Default for DecodedBkpBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XLogReaderState {
    pub read_page: XLogPageReadCB,
    pub system_identifier: uint64,
    pub private_data: *mut ::std::os::raw::c_void,
    pub ReadRecPtr: XLogRecPtr,
    pub EndRecPtr: XLogRecPtr,
    pub decoded_record: *mut XLogRecord,
    pub main_data: *mut ::std::os::raw::c_char,
    pub main_data_len: uint32,
    pub main_data_bufsz: uint32,
    pub record_origin: RepOriginId,
    pub blocks: [DecodedBkpBlock; 33usize],
    pub max_block_id: ::std::os::raw::c_int,
    pub readBuf: *mut ::std::os::raw::c_char,
    pub readLen: uint32,
    pub readSegNo: XLogSegNo,
    pub readOff: uint32,
    pub readPageTLI: TimeLineID,
    pub latestPagePtr: XLogRecPtr,
    pub latestPageTLI: TimeLineID,
    pub currRecPtr: XLogRecPtr,
    pub currTLI: TimeLineID,
    pub currTLIValidUntil: XLogRecPtr,
    pub nextTLI: TimeLineID,
    pub readRecordBuf: *mut ::std::os::raw::c_char,
    pub readRecordBufSize: uint32,
    pub errormsg_buf: *mut ::std::os::raw::c_char,
}
impl Default for XLogReaderState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn XLogReaderAllocate(
        pagereadfunc: XLogPageReadCB,
        private_data: *mut ::std::os::raw::c_void,
    ) -> *mut XLogReaderState;
}
#[pg_guard]
extern "C" {
    pub fn XLogReaderFree(state: *mut XLogReaderState);
}
#[pg_guard]
extern "C" {
    pub fn XLogReadRecord(
        state: *mut XLogReaderState,
        recptr: XLogRecPtr,
        errormsg: *mut *mut ::std::os::raw::c_char,
    ) -> *mut XLogRecord;
}
#[pg_guard]
extern "C" {
    pub fn XLogReaderValidatePageHeader(
        state: *mut XLogReaderState,
        recptr: XLogRecPtr,
        phdr: *mut ::std::os::raw::c_char,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn XLogReaderInvalReadState(state: *mut XLogReaderState);
}
#[pg_guard]
extern "C" {
    pub fn DecodeXLogRecord(
        state: *mut XLogReaderState,
        record: *mut XLogRecord,
        errmsg: *mut *mut ::std::os::raw::c_char,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn RestoreBlockImage(
        recoder: *mut XLogReaderState,
        block_id: uint8,
        dst: *mut ::std::os::raw::c_char,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn XLogRecGetBlockData(
        record: *mut XLogReaderState,
        block_id: uint8,
        len: *mut Size,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn XLogRecGetBlockTag(
        record: *mut XLogReaderState,
        block_id: uint8,
        rnode: *mut RelFileNode,
        forknum: *mut ForkNumber,
        blknum: *mut BlockNumber,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dirent {
    pub d_ino: __uint64_t,
    pub d_seekoff: __uint64_t,
    pub d_reclen: __uint16_t,
    pub d_namlen: __uint16_t,
    pub d_type: __uint8_t,
    pub d_name: [::std::os::raw::c_char; 1024usize],
}
impl Default for dirent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _telldir {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DIR {
    pub __dd_fd: ::std::os::raw::c_int,
    pub __dd_loc: ::std::os::raw::c_long,
    pub __dd_size: ::std::os::raw::c_long,
    pub __dd_buf: *mut ::std::os::raw::c_char,
    pub __dd_len: ::std::os::raw::c_int,
    pub __dd_seek: ::std::os::raw::c_long,
    pub __padding: ::std::os::raw::c_long,
    pub __dd_flags: ::std::os::raw::c_int,
    pub __dd_lock: __darwin_pthread_mutex_t,
    pub __dd_td: *mut _telldir,
}
impl Default for DIR {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn closedir(arg1: *mut DIR) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_opendir$INODE64"]
    pub fn opendir(arg1: *const ::std::os::raw::c_char) -> *mut DIR;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_readdir$INODE64"]
    pub fn readdir(arg1: *mut DIR) -> *mut dirent;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_readdir_r$INODE64"]
    pub fn readdir_r(
        arg1: *mut DIR,
        arg2: *mut dirent,
        arg3: *mut *mut dirent,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_rewinddir$INODE64"]
    pub fn rewinddir(arg1: *mut DIR);
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_seekdir$INODE64"]
    pub fn seekdir(arg1: *mut DIR, arg2: ::std::os::raw::c_long);
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_telldir$INODE64"]
    pub fn telldir(arg1: *mut DIR) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_fdopendir$INODE64"]
    pub fn fdopendir(arg1: ::std::os::raw::c_int) -> *mut DIR;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_alphasort$INODE64"]
    pub fn alphasort(arg1: *mut *const dirent, arg2: *mut *const dirent) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn dirfd(dirp: *mut DIR) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_scandir$INODE64"]
    pub fn scandir(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut *mut dirent,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const dirent) -> ::std::os::raw::c_int,
        >,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut *const dirent,
                arg2: *mut *const dirent,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_scandir_b$INODE64"]
    pub fn scandir_b(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut *mut dirent,
        arg3: *mut ::std::os::raw::c_void,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}_getdirentries_is_not_available_when_64_bit_inodes_are_in_effect"]
    pub fn getdirentries(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    #[link_name = "\u{1}___opendir2$INODE64"]
    pub fn __opendir2(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_int)
        -> *mut DIR;
}
pub type FileName = *mut ::std::os::raw::c_char;
pub type File = ::std::os::raw::c_int;
#[pg_guard]
extern "C" {
    pub static mut max_files_per_process: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut data_sync_retry: bool;
}
#[pg_guard]
extern "C" {
    pub static mut max_safe_fds: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn PathNameOpenFile(
        fileName: FileName,
        fileFlags: ::std::os::raw::c_int,
        fileMode: ::std::os::raw::c_int,
    ) -> File;
}
#[pg_guard]
extern "C" {
    pub fn OpenTemporaryFile(interXact: bool) -> File;
}
#[pg_guard]
extern "C" {
    pub fn FileClose(file: File);
}
#[pg_guard]
extern "C" {
    pub fn FilePrefetch(
        file: File,
        offset: off_t,
        amount: ::std::os::raw::c_int,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn FileRead(
        file: File,
        buffer: *mut ::std::os::raw::c_char,
        amount: ::std::os::raw::c_int,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn FileWrite(
        file: File,
        buffer: *mut ::std::os::raw::c_char,
        amount: ::std::os::raw::c_int,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn FileSync(file: File, wait_event_info: uint32) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn FileSeek(file: File, offset: off_t, whence: ::std::os::raw::c_int) -> off_t;
}
#[pg_guard]
extern "C" {
    pub fn FileTruncate(
        file: File,
        offset: off_t,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn FileWriteback(file: File, offset: off_t, nbytes: off_t, wait_event_info: uint32);
}
#[pg_guard]
extern "C" {
    pub fn FilePathName(file: File) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn FileGetRawDesc(file: File) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn FileGetRawFlags(file: File) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn FileGetRawMode(file: File) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn AllocateFile(
        name: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn FreeFile(file: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn OpenPipeStream(
        command: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
#[pg_guard]
extern "C" {
    pub fn ClosePipeStream(file: *mut FILE) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn AllocateDir(dirname: *const ::std::os::raw::c_char) -> *mut DIR;
}
#[pg_guard]
extern "C" {
    pub fn ReadDir(dir: *mut DIR, dirname: *const ::std::os::raw::c_char) -> *mut dirent;
}
#[pg_guard]
extern "C" {
    pub fn ReadDirExtended(
        dir: *mut DIR,
        dirname: *const ::std::os::raw::c_char,
        elevel: ::std::os::raw::c_int,
    ) -> *mut dirent;
}
#[pg_guard]
extern "C" {
    pub fn FreeDir(dir: *mut DIR) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn OpenTransientFile(
        fileName: FileName,
        fileFlags: ::std::os::raw::c_int,
        fileMode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn CloseTransientFile(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn BasicOpenFile(
        fileName: FileName,
        fileFlags: ::std::os::raw::c_int,
        fileMode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn InitFileAccess();
}
#[pg_guard]
extern "C" {
    pub fn set_max_safe_fds();
}
#[pg_guard]
extern "C" {
    pub fn closeAllVfds();
}
#[pg_guard]
extern "C" {
    pub fn SetTempTablespaces(tableSpaces: *mut Oid, numSpaces: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn TempTablespacesAreSet() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetNextTempTableSpace() -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn AtEOXact_Files();
}
#[pg_guard]
extern "C" {
    pub fn AtEOSubXact_Files(
        isCommit: bool,
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
    );
}
#[pg_guard]
extern "C" {
    pub fn RemovePgTempFiles();
}
#[pg_guard]
extern "C" {
    pub fn pg_fsync(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pg_fsync_no_writethrough(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pg_fsync_writethrough(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pg_fdatasync(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pg_flush_data(fd: ::std::os::raw::c_int, offset: off_t, amount: off_t);
}
#[pg_guard]
extern "C" {
    pub fn fsync_fname(fname: *const ::std::os::raw::c_char, isdir: bool);
}
#[pg_guard]
extern "C" {
    pub fn durable_rename(
        oldfile: *const ::std::os::raw::c_char,
        newfile: *const ::std::os::raw::c_char,
        loglevel: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn durable_unlink(
        fname: *const ::std::os::raw::c_char,
        loglevel: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn durable_link_or_rename(
        oldfile: *const ::std::os::raw::c_char,
        newfile: *const ::std::os::raw::c_char,
        loglevel: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SyncDataDirectory();
}
#[pg_guard]
extern "C" {
    pub fn data_sync_elevel(elevel: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut sync_method: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut ThisTimeLineID: TimeLineID;
}
#[pg_guard]
extern "C" {
    pub static mut InRecovery: bool;
}
pub const HotStandbyState_STANDBY_DISABLED: HotStandbyState = 0;
pub const HotStandbyState_STANDBY_INITIALIZED: HotStandbyState = 1;
pub const HotStandbyState_STANDBY_SNAPSHOT_PENDING: HotStandbyState = 2;
pub const HotStandbyState_STANDBY_SNAPSHOT_READY: HotStandbyState = 3;
pub type HotStandbyState = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub static mut standbyState: HotStandbyState;
}
pub const RecoveryTargetType_RECOVERY_TARGET_UNSET: RecoveryTargetType = 0;
pub const RecoveryTargetType_RECOVERY_TARGET_XID: RecoveryTargetType = 1;
pub const RecoveryTargetType_RECOVERY_TARGET_TIME: RecoveryTargetType = 2;
pub const RecoveryTargetType_RECOVERY_TARGET_NAME: RecoveryTargetType = 3;
pub const RecoveryTargetType_RECOVERY_TARGET_LSN: RecoveryTargetType = 4;
pub const RecoveryTargetType_RECOVERY_TARGET_IMMEDIATE: RecoveryTargetType = 5;
pub type RecoveryTargetType = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub static mut ProcLastRecPtr: XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub static mut XactLastRecEnd: XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub static mut XactLastCommitEnd: XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub static mut reachedConsistency: bool;
}
#[pg_guard]
extern "C" {
    pub static mut min_wal_size_mb: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut max_wal_size_mb: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut wal_keep_segments: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut XLOGbuffers: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut XLogArchiveTimeout: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut wal_retrieve_retry_interval: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut XLogArchiveCommand: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub static mut EnableHotStandby: bool;
}
#[pg_guard]
extern "C" {
    pub static mut fullPageWrites: bool;
}
#[pg_guard]
extern "C" {
    pub static mut wal_log_hints: bool;
}
#[pg_guard]
extern "C" {
    pub static mut wal_compression: bool;
}
#[pg_guard]
extern "C" {
    pub static mut wal_consistency_checking: *mut bool;
}
#[pg_guard]
extern "C" {
    pub static mut wal_consistency_checking_string: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub static mut log_checkpoints: bool;
}
#[pg_guard]
extern "C" {
    pub static mut CheckPointSegments: ::std::os::raw::c_int;
}
pub const ArchiveMode_ARCHIVE_MODE_OFF: ArchiveMode = 0;
pub const ArchiveMode_ARCHIVE_MODE_ON: ArchiveMode = 1;
pub const ArchiveMode_ARCHIVE_MODE_ALWAYS: ArchiveMode = 2;
pub type ArchiveMode = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub static mut XLogArchiveMode: ::std::os::raw::c_int;
}
pub const WalLevel_WAL_LEVEL_MINIMAL: WalLevel = 0;
pub const WalLevel_WAL_LEVEL_REPLICA: WalLevel = 1;
pub const WalLevel_WAL_LEVEL_LOGICAL: WalLevel = 2;
pub type WalLevel = ::std::os::raw::c_uint;
pub const RecoveryState_RECOVERY_STATE_CRASH: RecoveryState = 0;
pub const RecoveryState_RECOVERY_STATE_ARCHIVE: RecoveryState = 1;
pub const RecoveryState_RECOVERY_STATE_DONE: RecoveryState = 2;
pub type RecoveryState = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub static mut wal_level: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CheckpointStatsData {
    pub ckpt_start_t: TimestampTz,
    pub ckpt_write_t: TimestampTz,
    pub ckpt_sync_t: TimestampTz,
    pub ckpt_sync_end_t: TimestampTz,
    pub ckpt_end_t: TimestampTz,
    pub ckpt_bufs_written: ::std::os::raw::c_int,
    pub ckpt_segs_added: ::std::os::raw::c_int,
    pub ckpt_segs_removed: ::std::os::raw::c_int,
    pub ckpt_segs_recycled: ::std::os::raw::c_int,
    pub ckpt_sync_rels: ::std::os::raw::c_int,
    pub ckpt_longest_sync: uint64,
    pub ckpt_agg_sync_time: uint64,
}
#[pg_guard]
extern "C" {
    pub static mut CheckpointStats: CheckpointStatsData;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XLogRecData {
    _unused: [u8; 0],
}
#[pg_guard]
extern "C" {
    pub fn XLogInsertRecord(
        rdata: *mut XLogRecData,
        fpw_lsn: XLogRecPtr,
        flags: uint8,
    ) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn XLogFlush(RecPtr: XLogRecPtr);
}
#[pg_guard]
extern "C" {
    pub fn XLogBackgroundFlush() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn XLogNeedsFlush(RecPtr: XLogRecPtr) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn XLogFileInit(
        segno: XLogSegNo,
        use_existent: *mut bool,
        use_lock: bool,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn XLogFileOpen(segno: XLogSegNo) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn CheckXLogRemoved(segno: XLogSegNo, tli: TimeLineID);
}
#[pg_guard]
extern "C" {
    pub fn XLogGetLastRemovedSegno() -> XLogSegNo;
}
#[pg_guard]
extern "C" {
    pub fn XLogSetAsyncXactLSN(record: XLogRecPtr);
}
#[pg_guard]
extern "C" {
    pub fn XLogSetReplicationSlotMinimumLSN(lsn: XLogRecPtr);
}
#[pg_guard]
extern "C" {
    pub fn xlog_redo(record: *mut XLogReaderState);
}
#[pg_guard]
extern "C" {
    pub fn xlog_desc(buf: StringInfo, record: *mut XLogReaderState);
}
#[pg_guard]
extern "C" {
    pub fn xlog_identify(info: uint8) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn issue_xlog_fsync(fd: ::std::os::raw::c_int, segno: XLogSegNo);
}
#[pg_guard]
extern "C" {
    pub fn RecoveryInProgress() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetRecoveryState() -> RecoveryState;
}
#[pg_guard]
extern "C" {
    pub fn HotStandbyActive() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn HotStandbyActiveInReplay() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn XLogInsertAllowed() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetXLogReceiptTime(rtime: *mut TimestampTz, fromStream: *mut bool);
}
#[pg_guard]
extern "C" {
    pub fn GetXLogReplayRecPtr(replayTLI: *mut TimeLineID) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn GetXLogInsertRecPtr() -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn GetXLogWriteRecPtr() -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn RecoveryIsPaused() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn SetRecoveryPause(recoveryPause: bool);
}
#[pg_guard]
extern "C" {
    pub fn GetLatestXTime() -> TimestampTz;
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentChunkReplayStartTime() -> TimestampTz;
}
#[pg_guard]
extern "C" {
    pub fn XLogFileNameP(tli: TimeLineID, segno: XLogSegNo) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn UpdateControlFile();
}
#[pg_guard]
extern "C" {
    pub fn GetSystemIdentifier() -> uint64;
}
#[pg_guard]
extern "C" {
    pub fn GetMockAuthenticationNonce() -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn DataChecksumsEnabled() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetFakeLSNForUnloggedRel() -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn XLOGShmemSize() -> Size;
}
#[pg_guard]
extern "C" {
    pub fn XLOGShmemInit();
}
#[pg_guard]
extern "C" {
    pub fn BootStrapXLOG();
}
#[pg_guard]
extern "C" {
    pub fn StartupXLOG();
}
#[pg_guard]
extern "C" {
    pub fn ShutdownXLOG(code: ::std::os::raw::c_int, arg: Datum);
}
#[pg_guard]
extern "C" {
    pub fn InitXLOGAccess();
}
#[pg_guard]
extern "C" {
    pub fn CreateCheckPoint(flags: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn CreateRestartPoint(flags: ::std::os::raw::c_int) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn XLogPutNextOid(nextOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn XLogRestorePoint(rpName: *const ::std::os::raw::c_char) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn UpdateFullPageWrites();
}
#[pg_guard]
extern "C" {
    pub fn GetFullPageWriteInfo(RedoRecPtr_p: *mut XLogRecPtr, doPageWrites_p: *mut bool);
}
#[pg_guard]
extern "C" {
    pub fn GetRedoRecPtr() -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn GetInsertRecPtr() -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn GetFlushRecPtr() -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn GetLastImportantRecPtr() -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn GetNextXidAndEpoch(xid: *mut TransactionId, epoch: *mut uint32);
}
#[pg_guard]
extern "C" {
    pub fn RemovePromoteSignalFiles();
}
#[pg_guard]
extern "C" {
    pub fn CheckPromoteSignal() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn WakeupRecovery();
}
#[pg_guard]
extern "C" {
    pub fn SetWalWriterSleeping(sleeping: bool);
}
#[pg_guard]
extern "C" {
    pub fn XLogRequestWalReceiverReply();
}
#[pg_guard]
extern "C" {
    pub fn assign_max_wal_size(newval: ::std::os::raw::c_int, extra: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn assign_checkpoint_completion_target(newval: f64, extra: *mut ::std::os::raw::c_void);
}
pub const SessionBackupState_SESSION_BACKUP_NONE: SessionBackupState = 0;
pub const SessionBackupState_SESSION_BACKUP_EXCLUSIVE: SessionBackupState = 1;
pub const SessionBackupState_SESSION_BACKUP_NON_EXCLUSIVE: SessionBackupState = 2;
pub type SessionBackupState = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn do_pg_start_backup(
        backupidstr: *const ::std::os::raw::c_char,
        fast: bool,
        starttli_p: *mut TimeLineID,
        labelfile: StringInfo,
        tblspcdir: *mut DIR,
        tablespaces: *mut *mut List,
        tblspcmapfile: StringInfo,
        infotbssize: bool,
        needtblspcmapfile: bool,
    ) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn do_pg_stop_backup(
        labelfile: *mut ::std::os::raw::c_char,
        waitforarchive: bool,
        stoptli_p: *mut TimeLineID,
    ) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn do_pg_abort_backup();
}
#[pg_guard]
extern "C" {
    pub fn get_backup_status() -> SessionBackupState;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_class {
    pub relname: NameData,
    pub relnamespace: Oid,
    pub reltype: Oid,
    pub reloftype: Oid,
    pub relowner: Oid,
    pub relam: Oid,
    pub relfilenode: Oid,
    pub reltablespace: Oid,
    pub relpages: int32,
    pub reltuples: float4,
    pub relallvisible: int32,
    pub reltoastrelid: Oid,
    pub relhasindex: bool,
    pub relisshared: bool,
    pub relpersistence: ::std::os::raw::c_char,
    pub relkind: ::std::os::raw::c_char,
    pub relnatts: int16,
    pub relchecks: int16,
    pub relhasoids: bool,
    pub relhaspkey: bool,
    pub relhasrules: bool,
    pub relhastriggers: bool,
    pub relhassubclass: bool,
    pub relrowsecurity: bool,
    pub relforcerowsecurity: bool,
    pub relispopulated: bool,
    pub relreplident: ::std::os::raw::c_char,
    pub relispartition: bool,
    pub relfrozenxid: TransactionId,
    pub relminmxid: TransactionId,
}
impl Default for FormData_pg_class {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_class = *mut FormData_pg_class;
#[pg_guard]
extern "C" {
    pub static mut no_such_variable: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct FormData_pg_index {
    pub indexrelid: Oid,
    pub indrelid: Oid,
    pub indnatts: int16,
    pub indisunique: bool,
    pub indisprimary: bool,
    pub indisexclusion: bool,
    pub indimmediate: bool,
    pub indisclustered: bool,
    pub indisvalid: bool,
    pub indcheckxmin: bool,
    pub indisready: bool,
    pub indislive: bool,
    pub indisreplident: bool,
    pub indkey: int2vector,
}
pub type Form_pg_index = *mut FormData_pg_index;
pub type EOM_get_flat_size_method =
    ::std::option::Option<unsafe extern "C" fn(eohptr: *mut ExpandedObjectHeader) -> Size>;
pub type EOM_flatten_into_method = ::std::option::Option<
    unsafe extern "C" fn(
        eohptr: *mut ExpandedObjectHeader,
        result: *mut ::std::os::raw::c_void,
        allocated_size: Size,
    ),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ExpandedObjectMethods {
    pub get_flat_size: EOM_get_flat_size_method,
    pub flatten_into: EOM_flatten_into_method,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExpandedObjectHeader {
    pub vl_len_: int32,
    pub eoh_methods: *const ExpandedObjectMethods,
    pub eoh_context: MemoryContext,
    pub eoh_rw_ptr: [::std::os::raw::c_char; 10usize],
    pub eoh_ro_ptr: [::std::os::raw::c_char; 10usize],
}
impl Default for ExpandedObjectHeader {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn DatumGetEOHP(d: Datum) -> *mut ExpandedObjectHeader;
}
#[pg_guard]
extern "C" {
    pub fn EOH_init_header(
        eohptr: *mut ExpandedObjectHeader,
        methods: *const ExpandedObjectMethods,
        obj_context: MemoryContext,
    );
}
#[pg_guard]
extern "C" {
    pub fn EOH_get_flat_size(eohptr: *mut ExpandedObjectHeader) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn EOH_flatten_into(
        eohptr: *mut ExpandedObjectHeader,
        result: *mut ::std::os::raw::c_void,
        allocated_size: Size,
    );
}
#[pg_guard]
extern "C" {
    pub fn MakeExpandedObjectReadOnlyInternal(d: Datum) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn TransferExpandedObject(d: Datum, new_parent: MemoryContext) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn DeleteExpandedObject(d: Datum);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ArrayType {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExpandedArrayHeader {
    pub hdr: ExpandedObjectHeader,
    pub ea_magic: ::std::os::raw::c_int,
    pub ndims: ::std::os::raw::c_int,
    pub dims: *mut ::std::os::raw::c_int,
    pub lbound: *mut ::std::os::raw::c_int,
    pub element_type: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::std::os::raw::c_char,
    pub dvalues: *mut Datum,
    pub dnulls: *mut bool,
    pub dvalueslen: ::std::os::raw::c_int,
    pub nelems: ::std::os::raw::c_int,
    pub flat_size: Size,
    pub fvalue: *mut ArrayType,
    pub fstartptr: *mut ::std::os::raw::c_char,
    pub fendptr: *mut ::std::os::raw::c_char,
}
impl Default for ExpandedArrayHeader {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union AnyArrayType {
    pub flt: ArrayType,
    pub xpn: ExpandedArrayHeader,
}
impl Default for AnyArrayType {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayBuildState {
    pub mcontext: MemoryContext,
    pub dvalues: *mut Datum,
    pub dnulls: *mut bool,
    pub alen: ::std::os::raw::c_int,
    pub nelems: ::std::os::raw::c_int,
    pub element_type: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::std::os::raw::c_char,
    pub private_cxt: bool,
}
impl Default for ArrayBuildState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayBuildStateArr {
    pub mcontext: MemoryContext,
    pub data: *mut ::std::os::raw::c_char,
    pub nullbitmap: *mut bits8,
    pub abytes: ::std::os::raw::c_int,
    pub nbytes: ::std::os::raw::c_int,
    pub aitems: ::std::os::raw::c_int,
    pub nitems: ::std::os::raw::c_int,
    pub ndims: ::std::os::raw::c_int,
    pub dims: [::std::os::raw::c_int; 6usize],
    pub lbs: [::std::os::raw::c_int; 6usize],
    pub array_type: Oid,
    pub element_type: Oid,
    pub private_cxt: bool,
}
impl Default for ArrayBuildStateArr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayBuildStateAny {
    pub scalarstate: *mut ArrayBuildState,
    pub arraystate: *mut ArrayBuildStateArr,
}
impl Default for ArrayBuildStateAny {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayMetaState {
    pub element_type: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::std::os::raw::c_char,
    pub typdelim: ::std::os::raw::c_char,
    pub typioparam: Oid,
    pub typiofunc: Oid,
    pub proc_: FmgrInfo,
}
impl Default for ArrayMetaState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayMapState {
    pub inp_extra: ArrayMetaState,
    pub ret_extra: ArrayMetaState,
}
impl Default for ArrayMapState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayIteratorData {
    _unused: [u8; 0],
}
pub type ArrayIterator = *mut ArrayIteratorData;
#[pg_guard]
extern "C" {
    pub static mut Array_nulls: bool;
}
#[pg_guard]
extern "C" {
    pub fn CopyArrayEls(
        array: *mut ArrayType,
        values: *mut Datum,
        nulls: *mut bool,
        nitems: ::std::os::raw::c_int,
        typlen: ::std::os::raw::c_int,
        typbyval: bool,
        typalign: ::std::os::raw::c_char,
        freedata: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn array_get_element(
        arraydatum: Datum,
        nSubscripts: ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
        isNull: *mut bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn array_set_element(
        arraydatum: Datum,
        nSubscripts: ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
        dataValue: Datum,
        isNull: bool,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn array_get_slice(
        arraydatum: Datum,
        nSubscripts: ::std::os::raw::c_int,
        upperIndx: *mut ::std::os::raw::c_int,
        lowerIndx: *mut ::std::os::raw::c_int,
        upperProvided: *mut bool,
        lowerProvided: *mut bool,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn array_set_slice(
        arraydatum: Datum,
        nSubscripts: ::std::os::raw::c_int,
        upperIndx: *mut ::std::os::raw::c_int,
        lowerIndx: *mut ::std::os::raw::c_int,
        upperProvided: *mut bool,
        lowerProvided: *mut bool,
        srcArrayDatum: Datum,
        isNull: bool,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn array_ref(
        array: *mut ArrayType,
        nSubscripts: ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
        isNull: *mut bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn array_set(
        array: *mut ArrayType,
        nSubscripts: ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
        dataValue: Datum,
        isNull: bool,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> *mut ArrayType;
}
#[pg_guard]
extern "C" {
    pub fn array_map(fcinfo: FunctionCallInfo, retType: Oid, amstate: *mut ArrayMapState) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn array_bitmap_copy(
        destbitmap: *mut bits8,
        destoffset: ::std::os::raw::c_int,
        srcbitmap: *const bits8,
        srcoffset: ::std::os::raw::c_int,
        nitems: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn construct_array(
        elems: *mut Datum,
        nelems: ::std::os::raw::c_int,
        elmtype: Oid,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> *mut ArrayType;
}
#[pg_guard]
extern "C" {
    pub fn construct_md_array(
        elems: *mut Datum,
        nulls: *mut bool,
        ndims: ::std::os::raw::c_int,
        dims: *mut ::std::os::raw::c_int,
        lbs: *mut ::std::os::raw::c_int,
        elmtype: Oid,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> *mut ArrayType;
}
#[pg_guard]
extern "C" {
    pub fn construct_empty_array(elmtype: Oid) -> *mut ArrayType;
}
#[pg_guard]
extern "C" {
    pub fn construct_empty_expanded_array(
        element_type: Oid,
        parentcontext: MemoryContext,
        metacache: *mut ArrayMetaState,
    ) -> *mut ExpandedArrayHeader;
}
#[pg_guard]
extern "C" {
    pub fn deconstruct_array(
        array: *mut ArrayType,
        elmtype: Oid,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
        elemsp: *mut *mut Datum,
        nullsp: *mut *mut bool,
        nelemsp: *mut ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn array_contains_nulls(array: *mut ArrayType) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn initArrayResult(
        element_type: Oid,
        rcontext: MemoryContext,
        subcontext: bool,
    ) -> *mut ArrayBuildState;
}
#[pg_guard]
extern "C" {
    pub fn accumArrayResult(
        astate: *mut ArrayBuildState,
        dvalue: Datum,
        disnull: bool,
        element_type: Oid,
        rcontext: MemoryContext,
    ) -> *mut ArrayBuildState;
}
#[pg_guard]
extern "C" {
    pub fn makeArrayResult(astate: *mut ArrayBuildState, rcontext: MemoryContext) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn makeMdArrayResult(
        astate: *mut ArrayBuildState,
        ndims: ::std::os::raw::c_int,
        dims: *mut ::std::os::raw::c_int,
        lbs: *mut ::std::os::raw::c_int,
        rcontext: MemoryContext,
        release: bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn initArrayResultArr(
        array_type: Oid,
        element_type: Oid,
        rcontext: MemoryContext,
        subcontext: bool,
    ) -> *mut ArrayBuildStateArr;
}
#[pg_guard]
extern "C" {
    pub fn accumArrayResultArr(
        astate: *mut ArrayBuildStateArr,
        dvalue: Datum,
        disnull: bool,
        array_type: Oid,
        rcontext: MemoryContext,
    ) -> *mut ArrayBuildStateArr;
}
#[pg_guard]
extern "C" {
    pub fn makeArrayResultArr(
        astate: *mut ArrayBuildStateArr,
        rcontext: MemoryContext,
        release: bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn initArrayResultAny(
        input_type: Oid,
        rcontext: MemoryContext,
        subcontext: bool,
    ) -> *mut ArrayBuildStateAny;
}
#[pg_guard]
extern "C" {
    pub fn accumArrayResultAny(
        astate: *mut ArrayBuildStateAny,
        dvalue: Datum,
        disnull: bool,
        input_type: Oid,
        rcontext: MemoryContext,
    ) -> *mut ArrayBuildStateAny;
}
#[pg_guard]
extern "C" {
    pub fn makeArrayResultAny(
        astate: *mut ArrayBuildStateAny,
        rcontext: MemoryContext,
        release: bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn array_create_iterator(
        arr: *mut ArrayType,
        slice_ndim: ::std::os::raw::c_int,
        mstate: *mut ArrayMetaState,
    ) -> ArrayIterator;
}
#[pg_guard]
extern "C" {
    pub fn array_iterate(iterator: ArrayIterator, value: *mut Datum, isnull: *mut bool) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn array_free_iterator(iterator: ArrayIterator);
}
#[pg_guard]
extern "C" {
    pub fn ArrayGetOffset(
        n: ::std::os::raw::c_int,
        dim: *const ::std::os::raw::c_int,
        lb: *const ::std::os::raw::c_int,
        indx: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ArrayGetOffset0(
        n: ::std::os::raw::c_int,
        tup: *const ::std::os::raw::c_int,
        scale: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ArrayGetNItems(
        ndim: ::std::os::raw::c_int,
        dims: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ArrayCheckBounds(
        ndim: ::std::os::raw::c_int,
        dims: *const ::std::os::raw::c_int,
        lb: *const ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn mda_get_range(
        n: ::std::os::raw::c_int,
        span: *mut ::std::os::raw::c_int,
        st: *const ::std::os::raw::c_int,
        endp: *const ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn mda_get_prod(
        n: ::std::os::raw::c_int,
        range: *const ::std::os::raw::c_int,
        prod: *mut ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn mda_get_offset_values(
        n: ::std::os::raw::c_int,
        dist: *mut ::std::os::raw::c_int,
        prod: *const ::std::os::raw::c_int,
        span: *const ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn mda_next_tuple(
        n: ::std::os::raw::c_int,
        curr: *mut ::std::os::raw::c_int,
        span: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ArrayGetIntegerTypmods(arr: *mut ArrayType, n: *mut ::std::os::raw::c_int)
        -> *mut int32;
}
#[pg_guard]
extern "C" {
    pub fn expand_array(
        arraydatum: Datum,
        parentcontext: MemoryContext,
        metacache: *mut ArrayMetaState,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn DatumGetExpandedArray(d: Datum) -> *mut ExpandedArrayHeader;
}
#[pg_guard]
extern "C" {
    pub fn DatumGetExpandedArrayX(
        d: Datum,
        metacache: *mut ArrayMetaState,
    ) -> *mut ExpandedArrayHeader;
}
#[pg_guard]
extern "C" {
    pub fn DatumGetAnyArray(d: Datum) -> *mut AnyArrayType;
}
#[pg_guard]
extern "C" {
    pub fn deconstruct_expanded_array(eah: *mut ExpandedArrayHeader);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AclItem {
    pub ai_grantee: Oid,
    pub ai_grantor: Oid,
    pub ai_privs: AclMode,
}
pub type Acl = ArrayType;
pub const AclMaskHow_ACLMASK_ALL: AclMaskHow = 0;
pub const AclMaskHow_ACLMASK_ANY: AclMaskHow = 1;
pub type AclMaskHow = ::std::os::raw::c_uint;
pub const AclResult_ACLCHECK_OK: AclResult = 0;
pub const AclResult_ACLCHECK_NO_PRIV: AclResult = 1;
pub const AclResult_ACLCHECK_NOT_OWNER: AclResult = 2;
pub type AclResult = ::std::os::raw::c_uint;
pub const AclObjectKind_ACL_KIND_COLUMN: AclObjectKind = 0;
pub const AclObjectKind_ACL_KIND_CLASS: AclObjectKind = 1;
pub const AclObjectKind_ACL_KIND_SEQUENCE: AclObjectKind = 2;
pub const AclObjectKind_ACL_KIND_DATABASE: AclObjectKind = 3;
pub const AclObjectKind_ACL_KIND_PROC: AclObjectKind = 4;
pub const AclObjectKind_ACL_KIND_OPER: AclObjectKind = 5;
pub const AclObjectKind_ACL_KIND_TYPE: AclObjectKind = 6;
pub const AclObjectKind_ACL_KIND_LANGUAGE: AclObjectKind = 7;
pub const AclObjectKind_ACL_KIND_LARGEOBJECT: AclObjectKind = 8;
pub const AclObjectKind_ACL_KIND_NAMESPACE: AclObjectKind = 9;
pub const AclObjectKind_ACL_KIND_OPCLASS: AclObjectKind = 10;
pub const AclObjectKind_ACL_KIND_OPFAMILY: AclObjectKind = 11;
pub const AclObjectKind_ACL_KIND_COLLATION: AclObjectKind = 12;
pub const AclObjectKind_ACL_KIND_CONVERSION: AclObjectKind = 13;
pub const AclObjectKind_ACL_KIND_STATISTICS: AclObjectKind = 14;
pub const AclObjectKind_ACL_KIND_TABLESPACE: AclObjectKind = 15;
pub const AclObjectKind_ACL_KIND_TSDICTIONARY: AclObjectKind = 16;
pub const AclObjectKind_ACL_KIND_TSCONFIGURATION: AclObjectKind = 17;
pub const AclObjectKind_ACL_KIND_FDW: AclObjectKind = 18;
pub const AclObjectKind_ACL_KIND_FOREIGN_SERVER: AclObjectKind = 19;
pub const AclObjectKind_ACL_KIND_EVENT_TRIGGER: AclObjectKind = 20;
pub const AclObjectKind_ACL_KIND_EXTENSION: AclObjectKind = 21;
pub const AclObjectKind_ACL_KIND_PUBLICATION: AclObjectKind = 22;
pub const AclObjectKind_ACL_KIND_SUBSCRIPTION: AclObjectKind = 23;
pub const AclObjectKind_MAX_ACL_KIND: AclObjectKind = 24;
pub type AclObjectKind = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn acldefault(objtype: GrantObjectType, ownerId: Oid) -> *mut Acl;
}
#[pg_guard]
extern "C" {
    pub fn get_user_default_acl(objtype: GrantObjectType, ownerId: Oid, nsp_oid: Oid) -> *mut Acl;
}
#[pg_guard]
extern "C" {
    pub fn recordDependencyOnNewAcl(
        classId: Oid,
        objectId: Oid,
        objsubId: int32,
        ownerId: Oid,
        acl: *mut Acl,
    );
}
#[pg_guard]
extern "C" {
    pub fn aclupdate(
        old_acl: *const Acl,
        mod_aip: *const AclItem,
        modechg: ::std::os::raw::c_int,
        ownerId: Oid,
        behavior: DropBehavior,
    ) -> *mut Acl;
}
#[pg_guard]
extern "C" {
    pub fn aclnewowner(old_acl: *const Acl, oldOwnerId: Oid, newOwnerId: Oid) -> *mut Acl;
}
#[pg_guard]
extern "C" {
    pub fn make_empty_acl() -> *mut Acl;
}
#[pg_guard]
extern "C" {
    pub fn aclcopy(orig_acl: *const Acl) -> *mut Acl;
}
#[pg_guard]
extern "C" {
    pub fn aclconcat(left_acl: *const Acl, right_acl: *const Acl) -> *mut Acl;
}
#[pg_guard]
extern "C" {
    pub fn aclmerge(left_acl: *const Acl, right_acl: *const Acl, ownerId: Oid) -> *mut Acl;
}
#[pg_guard]
extern "C" {
    pub fn aclitemsort(acl: *mut Acl);
}
#[pg_guard]
extern "C" {
    pub fn aclequal(left_acl: *const Acl, right_acl: *const Acl) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn aclmask(
        acl: *const Acl,
        roleid: Oid,
        ownerId: Oid,
        mask: AclMode,
        how: AclMaskHow,
    ) -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn aclmembers(acl: *const Acl, roleids: *mut *mut Oid) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn has_privs_of_role(member: Oid, role: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn is_member_of_role(member: Oid, role: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn is_member_of_role_nosuper(member: Oid, role: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn is_admin_of_role(member: Oid, role: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn check_is_member_of_role(member: Oid, role: Oid);
}
#[pg_guard]
extern "C" {
    pub fn get_role_oid(rolename: *const ::std::os::raw::c_char, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_role_oid_or_public(rolename: *const ::std::os::raw::c_char) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_rolespec_oid(role: *const RoleSpec, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn check_rolespec_name(role: *const RoleSpec, detail_msg: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn get_rolespec_tuple(role: *const RoleSpec) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn get_rolespec_name(role: *const RoleSpec) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn select_best_grantor(
        roleId: Oid,
        privileges: AclMode,
        acl: *const Acl,
        ownerId: Oid,
        grantorId: *mut Oid,
        grantOptions: *mut AclMode,
    );
}
#[pg_guard]
extern "C" {
    pub fn initialize_acl();
}
#[pg_guard]
extern "C" {
    pub fn ExecuteGrantStmt(stmt: *mut GrantStmt);
}
#[pg_guard]
extern "C" {
    pub fn ExecAlterDefaultPrivilegesStmt(
        pstate: *mut ParseState,
        stmt: *mut AlterDefaultPrivilegesStmt,
    );
}
#[pg_guard]
extern "C" {
    pub fn RemoveRoleFromObjectACL(roleid: Oid, classid: Oid, objid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn RemoveDefaultACLById(defaclOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn pg_attribute_aclmask(
        table_oid: Oid,
        attnum: AttrNumber,
        roleid: Oid,
        mask: AclMode,
        how: AclMaskHow,
    ) -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_class_aclmask(table_oid: Oid, roleid: Oid, mask: AclMode, how: AclMaskHow)
        -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_database_aclmask(db_oid: Oid, roleid: Oid, mask: AclMode, how: AclMaskHow)
        -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_proc_aclmask(proc_oid: Oid, roleid: Oid, mask: AclMode, how: AclMaskHow) -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_language_aclmask(
        lang_oid: Oid,
        roleid: Oid,
        mask: AclMode,
        how: AclMaskHow,
    ) -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_largeobject_aclmask_snapshot(
        lobj_oid: Oid,
        roleid: Oid,
        mask: AclMode,
        how: AclMaskHow,
        snapshot: Snapshot,
    ) -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_namespace_aclmask(
        nsp_oid: Oid,
        roleid: Oid,
        mask: AclMode,
        how: AclMaskHow,
    ) -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_tablespace_aclmask(
        spc_oid: Oid,
        roleid: Oid,
        mask: AclMode,
        how: AclMaskHow,
    ) -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_foreign_data_wrapper_aclmask(
        fdw_oid: Oid,
        roleid: Oid,
        mask: AclMode,
        how: AclMaskHow,
    ) -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_foreign_server_aclmask(
        srv_oid: Oid,
        roleid: Oid,
        mask: AclMode,
        how: AclMaskHow,
    ) -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_type_aclmask(type_oid: Oid, roleid: Oid, mask: AclMode, how: AclMaskHow) -> AclMode;
}
#[pg_guard]
extern "C" {
    pub fn pg_attribute_aclcheck(
        table_oid: Oid,
        attnum: AttrNumber,
        roleid: Oid,
        mode: AclMode,
    ) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_attribute_aclcheck_all(
        table_oid: Oid,
        roleid: Oid,
        mode: AclMode,
        how: AclMaskHow,
    ) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_class_aclcheck(table_oid: Oid, roleid: Oid, mode: AclMode) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_database_aclcheck(db_oid: Oid, roleid: Oid, mode: AclMode) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_proc_aclcheck(proc_oid: Oid, roleid: Oid, mode: AclMode) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_language_aclcheck(lang_oid: Oid, roleid: Oid, mode: AclMode) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_largeobject_aclcheck_snapshot(
        lang_oid: Oid,
        roleid: Oid,
        mode: AclMode,
        snapshot: Snapshot,
    ) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_namespace_aclcheck(nsp_oid: Oid, roleid: Oid, mode: AclMode) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_tablespace_aclcheck(spc_oid: Oid, roleid: Oid, mode: AclMode) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_foreign_data_wrapper_aclcheck(fdw_oid: Oid, roleid: Oid, mode: AclMode) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_foreign_server_aclcheck(srv_oid: Oid, roleid: Oid, mode: AclMode) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn pg_type_aclcheck(type_oid: Oid, roleid: Oid, mode: AclMode) -> AclResult;
}
#[pg_guard]
extern "C" {
    pub fn aclcheck_error(
        aclerr: AclResult,
        objectkind: AclObjectKind,
        objectname: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn aclcheck_error_col(
        aclerr: AclResult,
        objectkind: AclObjectKind,
        objectname: *const ::std::os::raw::c_char,
        colname: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn aclcheck_error_type(aclerr: AclResult, typeOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn recordExtObjInitPriv(objoid: Oid, classoid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn removeExtObjInitPriv(objoid: Oid, classoid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn pg_class_ownercheck(class_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_type_ownercheck(type_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_oper_ownercheck(oper_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_proc_ownercheck(proc_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_language_ownercheck(lan_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_largeobject_ownercheck(lobj_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_namespace_ownercheck(nsp_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_tablespace_ownercheck(spc_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_opclass_ownercheck(opc_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_opfamily_ownercheck(opf_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_database_ownercheck(db_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_collation_ownercheck(coll_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_conversion_ownercheck(conv_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_ts_dict_ownercheck(dict_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_ts_config_ownercheck(cfg_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_foreign_data_wrapper_ownercheck(srv_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_foreign_server_ownercheck(srv_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_event_trigger_ownercheck(et_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_extension_ownercheck(ext_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_publication_ownercheck(pub_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_subscription_ownercheck(sub_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_statistics_object_ownercheck(stat_oid: Oid, roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn has_createrole_privilege(roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn has_bypassrls_privilege(roleid: Oid) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ObjectAddress {
    pub classId: Oid,
    pub objectId: Oid,
    pub objectSubId: int32,
}
#[pg_guard]
extern "C" {
    pub static InvalidObjectAddress: ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn get_object_address(
        objtype: ObjectType,
        object: *mut Node,
        relp: *mut Relation,
        lockmode: LOCKMODE,
        missing_ok: bool,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn get_object_address_rv(
        objtype: ObjectType,
        rel: *mut RangeVar,
        object: *mut List,
        relp: *mut Relation,
        lockmode: LOCKMODE,
        missing_ok: bool,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn check_object_ownership(
        roleid: Oid,
        objtype: ObjectType,
        address: ObjectAddress,
        object: *mut Node,
        relation: Relation,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_object_namespace(address: *const ObjectAddress) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn is_objectclass_supported(class_id: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_object_oid_index(class_id: Oid) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_object_catcache_oid(class_id: Oid) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn get_object_catcache_name(class_id: Oid) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn get_object_attnum_name(class_id: Oid) -> AttrNumber;
}
#[pg_guard]
extern "C" {
    pub fn get_object_attnum_namespace(class_id: Oid) -> AttrNumber;
}
#[pg_guard]
extern "C" {
    pub fn get_object_attnum_owner(class_id: Oid) -> AttrNumber;
}
#[pg_guard]
extern "C" {
    pub fn get_object_attnum_acl(class_id: Oid) -> AttrNumber;
}
#[pg_guard]
extern "C" {
    pub fn get_object_aclkind(class_id: Oid) -> AclObjectKind;
}
#[pg_guard]
extern "C" {
    pub fn get_object_namensp_unique(class_id: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_catalog_object_by_oid(catalog: Relation, objectId: Oid) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn getObjectDescription(object: *const ObjectAddress) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn getObjectDescriptionOids(classid: Oid, objid: Oid) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn read_objtype_from_string(
        objtype: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn getObjectTypeDescription(object: *const ObjectAddress) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn getObjectIdentity(address: *const ObjectAddress) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn getObjectIdentityParts(
        address: *const ObjectAddress,
        objname: *mut *mut List,
        objargs: *mut *mut List,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn strlist_to_textarray(list: *mut List) -> *mut ArrayType;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_publication {
    pub pubname: NameData,
    pub pubowner: Oid,
    pub puballtables: bool,
    pub pubinsert: bool,
    pub pubupdate: bool,
    pub pubdelete: bool,
}
impl Default for FormData_pg_publication {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_publication = *mut FormData_pg_publication;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PublicationActions {
    pub pubinsert: bool,
    pub pubupdate: bool,
    pub pubdelete: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Publication {
    pub oid: Oid,
    pub name: *mut ::std::os::raw::c_char,
    pub alltables: bool,
    pub pubactions: PublicationActions,
}
impl Default for Publication {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn GetPublication(pubid: Oid) -> *mut Publication;
}
#[pg_guard]
extern "C" {
    pub fn GetPublicationByName(
        pubname: *const ::std::os::raw::c_char,
        missing_ok: bool,
    ) -> *mut Publication;
}
#[pg_guard]
extern "C" {
    pub fn GetRelationPublications(relid: Oid) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn GetPublicationRelations(pubid: Oid) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn GetAllTablesPublications() -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn GetAllTablesPublicationRelations() -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn is_publishable_relation(rel: Relation) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn publication_add_relation(
        pubid: Oid,
        targetrel: Relation,
        if_not_exists: bool,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn get_publication_oid(pubname: *const ::std::os::raw::c_char, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_publication_name(pubid: Oid) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pg_get_publication_tables(fcinfo: FunctionCallInfo) -> Datum;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RewriteRule {
    pub ruleId: Oid,
    pub event: CmdType,
    pub qual: *mut Node,
    pub actions: *mut List,
    pub enabled: ::std::os::raw::c_char,
    pub isInstead: bool,
}
impl Default for RewriteRule {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RuleLock {
    pub numLocks: ::std::os::raw::c_int,
    pub rules: *mut *mut RewriteRule,
}
impl Default for RuleLock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LockRelId {
    pub relId: Oid,
    pub dbId: Oid,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LockInfoData {
    pub lockRelId: LockRelId,
}
pub type LockInfo = *mut LockInfoData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionKeyData {
    pub strategy: ::std::os::raw::c_char,
    pub partnatts: int16,
    pub partattrs: *mut AttrNumber,
    pub partexprs: *mut List,
    pub partopfamily: *mut Oid,
    pub partopcintype: *mut Oid,
    pub partsupfunc: *mut FmgrInfo,
    pub partcollation: *mut Oid,
    pub parttypid: *mut Oid,
    pub parttypmod: *mut int32,
    pub parttyplen: *mut int16,
    pub parttypbyval: *mut bool,
    pub parttypalign: *mut ::std::os::raw::c_char,
    pub parttypcoll: *mut Oid,
}
impl Default for PartitionKeyData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PartitionKey = *mut PartitionKeyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelationData {
    pub rd_node: RelFileNode,
    pub rd_smgr: *mut SMgrRelationData,
    pub rd_refcnt: ::std::os::raw::c_int,
    pub rd_backend: BackendId,
    pub rd_islocaltemp: bool,
    pub rd_isnailed: bool,
    pub rd_isvalid: bool,
    pub rd_indexvalid: ::std::os::raw::c_char,
    pub rd_statvalid: bool,
    pub rd_createSubid: SubTransactionId,
    pub rd_newRelfilenodeSubid: SubTransactionId,
    pub rd_rel: Form_pg_class,
    pub rd_att: TupleDesc,
    pub rd_id: Oid,
    pub rd_lockInfo: LockInfoData,
    pub rd_rules: *mut RuleLock,
    pub rd_rulescxt: MemoryContext,
    pub trigdesc: *mut TriggerDesc,
    pub rd_rsdesc: *mut RowSecurityDesc,
    pub rd_fkeylist: *mut List,
    pub rd_fkeyvalid: bool,
    pub rd_partkeycxt: MemoryContext,
    pub rd_partkey: *mut PartitionKeyData,
    pub rd_pdcxt: MemoryContext,
    pub rd_partdesc: *mut PartitionDescData,
    pub rd_partcheck: *mut List,
    pub rd_indexlist: *mut List,
    pub rd_oidindex: Oid,
    pub rd_pkindex: Oid,
    pub rd_replidindex: Oid,
    pub rd_statlist: *mut List,
    pub rd_indexattr: *mut Bitmapset,
    pub rd_keyattr: *mut Bitmapset,
    pub rd_pkattr: *mut Bitmapset,
    pub rd_idattr: *mut Bitmapset,
    pub rd_pubactions: *mut PublicationActions,
    pub rd_options: *mut bytea,
    pub rd_index: Form_pg_index,
    pub rd_indextuple: *mut HeapTupleData,
    pub rd_amhandler: Oid,
    pub rd_indexcxt: MemoryContext,
    pub rd_amroutine: *mut IndexAmRoutine,
    pub rd_opfamily: *mut Oid,
    pub rd_opcintype: *mut Oid,
    pub rd_support: *mut RegProcedure,
    pub rd_supportinfo: *mut FmgrInfo,
    pub rd_indoption: *mut int16,
    pub rd_indexprs: *mut List,
    pub rd_indpred: *mut List,
    pub rd_exclops: *mut Oid,
    pub rd_exclprocs: *mut Oid,
    pub rd_exclstrats: *mut uint16,
    pub rd_amcache: *mut ::std::os::raw::c_void,
    pub rd_indcollation: *mut Oid,
    pub rd_fdwroutine: *mut FdwRoutine,
    pub rd_toastoid: Oid,
    pub pgstat_info: *mut PgStat_TableStatus,
    pub rd_partcheckvalid: bool,
    pub rd_partcheckcxt: MemoryContext,
}
impl Default for RelationData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignKeyCacheInfo {
    pub type_: NodeTag,
    pub conrelid: Oid,
    pub confrelid: Oid,
    pub nkeys: ::std::os::raw::c_int,
    pub conkey: [AttrNumber; 32usize],
    pub confkey: [AttrNumber; 32usize],
    pub conpfeqop: [Oid; 32usize],
}
impl Default for ForeignKeyCacheInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AutoVacOpts {
    pub enabled: bool,
    pub vacuum_threshold: ::std::os::raw::c_int,
    pub analyze_threshold: ::std::os::raw::c_int,
    pub vacuum_cost_delay: ::std::os::raw::c_int,
    pub vacuum_cost_limit: ::std::os::raw::c_int,
    pub freeze_min_age: ::std::os::raw::c_int,
    pub freeze_max_age: ::std::os::raw::c_int,
    pub freeze_table_age: ::std::os::raw::c_int,
    pub multixact_freeze_min_age: ::std::os::raw::c_int,
    pub multixact_freeze_max_age: ::std::os::raw::c_int,
    pub multixact_freeze_table_age: ::std::os::raw::c_int,
    pub log_min_duration: ::std::os::raw::c_int,
    pub vacuum_scale_factor: float8,
    pub analyze_scale_factor: float8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct StdRdOptions {
    pub vl_len_: int32,
    pub fillfactor: ::std::os::raw::c_int,
    pub autovacuum: AutoVacOpts,
    pub user_catalog_table: bool,
    pub parallel_workers: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ViewOptions {
    pub vl_len_: int32,
    pub security_barrier: bool,
    pub check_option_offset: ::std::os::raw::c_int,
}
#[pg_guard]
extern "C" {
    pub fn RelationIncrementReferenceCount(rel: Relation);
}
#[pg_guard]
extern "C" {
    pub fn RelationDecrementReferenceCount(rel: Relation);
}
#[pg_guard]
extern "C" {
    pub fn RelationGetRepsetList(rel: Relation) -> *mut List;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundInfoData {
    _unused: [u8; 0],
}
pub type PartitionBoundInfo = *mut PartitionBoundInfoData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDescData {
    pub nparts: ::std::os::raw::c_int,
    pub oids: *mut Oid,
    pub boundinfo: PartitionBoundInfo,
}
impl Default for PartitionDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PartitionDesc = *mut PartitionDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDispatchData {
    pub reldesc: Relation,
    pub key: PartitionKey,
    pub keystate: *mut List,
    pub partdesc: PartitionDesc,
    pub tupslot: *mut TupleTableSlot,
    pub tupmap: *mut TupleConversionMap,
    pub indexes: *mut ::std::os::raw::c_int,
}
impl Default for PartitionDispatchData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PartitionDispatch = *mut PartitionDispatchData;
#[pg_guard]
extern "C" {
    pub fn RelationBuildPartitionDesc(relation: Relation);
}
#[pg_guard]
extern "C" {
    pub fn partition_bounds_equal(
        key: PartitionKey,
        p1: PartitionBoundInfo,
        p2: PartitionBoundInfo,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn check_new_partition_bound(
        relname: *mut ::std::os::raw::c_char,
        parent: Relation,
        spec: *mut PartitionBoundSpec,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_partition_parent(relid: Oid) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_qual_from_partbound(
        rel: Relation,
        parent: Relation,
        spec: *mut PartitionBoundSpec,
    ) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn map_partition_varattnos(
        expr: *mut List,
        target_varno: ::std::os::raw::c_int,
        partrel: Relation,
        parent: Relation,
        found_whole_row: *mut bool,
    ) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetPartitionQual(rel: Relation) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn get_partition_qual_relid(relid: Oid) -> *mut Expr;
}
#[pg_guard]
extern "C" {
    pub fn RelationGetPartitionDispatchInfo(
        rel: Relation,
        num_parted: *mut ::std::os::raw::c_int,
        leaf_part_oids: *mut *mut List,
    ) -> *mut PartitionDispatch;
}
#[pg_guard]
extern "C" {
    pub fn FormPartitionKeyDatum(
        pd: PartitionDispatch,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_partition_for_tuple(
        pd: *mut PartitionDispatch,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
        failed_at: *mut *mut PartitionDispatchData,
        failed_slot: *mut *mut TupleTableSlot,
    ) -> ::std::os::raw::c_int;
}
pub const CommandDest_DestNone: CommandDest = 0;
pub const CommandDest_DestDebug: CommandDest = 1;
pub const CommandDest_DestRemote: CommandDest = 2;
pub const CommandDest_DestRemoteExecute: CommandDest = 3;
pub const CommandDest_DestRemoteSimple: CommandDest = 4;
pub const CommandDest_DestSPI: CommandDest = 5;
pub const CommandDest_DestTuplestore: CommandDest = 6;
pub const CommandDest_DestIntoRel: CommandDest = 7;
pub const CommandDest_DestCopyOut: CommandDest = 8;
pub const CommandDest_DestSQLFunction: CommandDest = 9;
pub const CommandDest_DestTransientRel: CommandDest = 10;
pub const CommandDest_DestTupleQueue: CommandDest = 11;
pub type CommandDest = ::std::os::raw::c_uint;
pub type DestReceiver = _DestReceiver;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DestReceiver {
    pub receiveSlot: ::std::option::Option<
        unsafe extern "C" fn(slot: *mut TupleTableSlot, self_: *mut DestReceiver) -> bool,
    >,
    pub rStartup: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut DestReceiver,
            operation: ::std::os::raw::c_int,
            typeinfo: TupleDesc,
        ),
    >,
    pub rShutdown: ::std::option::Option<unsafe extern "C" fn(self_: *mut DestReceiver)>,
    pub rDestroy: ::std::option::Option<unsafe extern "C" fn(self_: *mut DestReceiver)>,
    pub mydest: CommandDest,
}
impl Default for _DestReceiver {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut None_Receiver: *mut DestReceiver;
}
#[pg_guard]
extern "C" {
    pub fn BeginCommand(commandTag: *const ::std::os::raw::c_char, dest: CommandDest);
}
#[pg_guard]
extern "C" {
    pub fn CreateDestReceiver(dest: CommandDest) -> *mut DestReceiver;
}
#[pg_guard]
extern "C" {
    pub fn EndCommand(commandTag: *const ::std::os::raw::c_char, dest: CommandDest);
}
#[pg_guard]
extern "C" {
    pub fn NullCommand(dest: CommandDest);
}
#[pg_guard]
extern "C" {
    pub fn ReadyForQuery(dest: CommandDest);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryDesc {
    pub operation: CmdType,
    pub plannedstmt: *mut PlannedStmt,
    pub sourceText: *const ::std::os::raw::c_char,
    pub snapshot: Snapshot,
    pub crosscheck_snapshot: Snapshot,
    pub dest: *mut DestReceiver,
    pub params: ParamListInfo,
    pub queryEnv: *mut QueryEnvironment,
    pub instrument_options: ::std::os::raw::c_int,
    pub tupDesc: TupleDesc,
    pub estate: *mut EState,
    pub planstate: *mut PlanState,
    pub already_executed: bool,
    pub totaltime: *mut Instrumentation,
}
impl Default for QueryDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn CreateQueryDesc(
        plannedstmt: *mut PlannedStmt,
        sourceText: *const ::std::os::raw::c_char,
        snapshot: Snapshot,
        crosscheck_snapshot: Snapshot,
        dest: *mut DestReceiver,
        params: ParamListInfo,
        queryEnv: *mut QueryEnvironment,
        instrument_options: ::std::os::raw::c_int,
    ) -> *mut QueryDesc;
}
#[pg_guard]
extern "C" {
    pub fn FreeQueryDesc(qdesc: *mut QueryDesc);
}
pub type ExecutorStart_hook_type = ::std::option::Option<
    unsafe extern "C" fn(queryDesc: *mut QueryDesc, eflags: ::std::os::raw::c_int),
>;
#[pg_guard]
extern "C" {
    pub static mut ExecutorStart_hook: ExecutorStart_hook_type;
}
pub type ExecutorRun_hook_type = ::std::option::Option<
    unsafe extern "C" fn(
        queryDesc: *mut QueryDesc,
        direction: ScanDirection,
        count: uint64,
        execute_once: bool,
    ),
>;
#[pg_guard]
extern "C" {
    pub static mut ExecutorRun_hook: ExecutorRun_hook_type;
}
pub type ExecutorFinish_hook_type =
    ::std::option::Option<unsafe extern "C" fn(queryDesc: *mut QueryDesc)>;
#[pg_guard]
extern "C" {
    pub static mut ExecutorFinish_hook: ExecutorFinish_hook_type;
}
pub type ExecutorEnd_hook_type =
    ::std::option::Option<unsafe extern "C" fn(queryDesc: *mut QueryDesc)>;
#[pg_guard]
extern "C" {
    pub static mut ExecutorEnd_hook: ExecutorEnd_hook_type;
}
pub type ExecutorCheckPerms_hook_type =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut List, arg2: bool) -> bool>;
#[pg_guard]
extern "C" {
    pub static mut ExecutorCheckPerms_hook: ExecutorCheckPerms_hook_type;
}
#[pg_guard]
extern "C" {
    pub fn ExecReScan(node: *mut PlanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecMarkPos(node: *mut PlanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecRestrPos(node: *mut PlanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecSupportsMarkRestore(pathnode: *mut Path) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ExecSupportsBackwardScan(node: *mut Plan) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ExecMaterializesOutput(plantype: NodeTag) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn execCurrentOf(
        cexpr: *mut CurrentOfExpr,
        econtext: *mut ExprContext,
        table_oid: Oid,
        current_tid: ItemPointer,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn execTuplesMatch(
        slot1: *mut TupleTableSlot,
        slot2: *mut TupleTableSlot,
        numCols: ::std::os::raw::c_int,
        matchColIdx: *mut AttrNumber,
        eqfunctions: *mut FmgrInfo,
        evalContext: MemoryContext,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn execTuplesUnequal(
        slot1: *mut TupleTableSlot,
        slot2: *mut TupleTableSlot,
        numCols: ::std::os::raw::c_int,
        matchColIdx: *mut AttrNumber,
        eqfunctions: *mut FmgrInfo,
        evalContext: MemoryContext,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn execTuplesMatchPrepare(
        numCols: ::std::os::raw::c_int,
        eqOperators: *mut Oid,
    ) -> *mut FmgrInfo;
}
#[pg_guard]
extern "C" {
    pub fn execTuplesHashPrepare(
        numCols: ::std::os::raw::c_int,
        eqOperators: *mut Oid,
        eqFunctions: *mut *mut FmgrInfo,
        hashFunctions: *mut *mut FmgrInfo,
    );
}
#[pg_guard]
extern "C" {
    pub fn BuildTupleHashTable(
        numCols: ::std::os::raw::c_int,
        keyColIdx: *mut AttrNumber,
        eqfunctions: *mut FmgrInfo,
        hashfunctions: *mut FmgrInfo,
        nbuckets: ::std::os::raw::c_long,
        additionalsize: Size,
        tablecxt: MemoryContext,
        tempcxt: MemoryContext,
        use_variable_hash_iv: bool,
    ) -> TupleHashTable;
}
#[pg_guard]
extern "C" {
    pub fn LookupTupleHashEntry(
        hashtable: TupleHashTable,
        slot: *mut TupleTableSlot,
        isnew: *mut bool,
    ) -> TupleHashEntry;
}
#[pg_guard]
extern "C" {
    pub fn FindTupleHashEntry(
        hashtable: TupleHashTable,
        slot: *mut TupleTableSlot,
        eqfunctions: *mut FmgrInfo,
        hashfunctions: *mut FmgrInfo,
    ) -> TupleHashEntry;
}
#[pg_guard]
extern "C" {
    pub fn ExecInitJunkFilter(
        targetList: *mut List,
        hasoid: bool,
        slot: *mut TupleTableSlot,
    ) -> *mut JunkFilter;
}
#[pg_guard]
extern "C" {
    pub fn ExecInitJunkFilterConversion(
        targetList: *mut List,
        cleanTupType: TupleDesc,
        slot: *mut TupleTableSlot,
    ) -> *mut JunkFilter;
}
#[pg_guard]
extern "C" {
    pub fn ExecFindJunkAttribute(
        junkfilter: *mut JunkFilter,
        attrName: *const ::std::os::raw::c_char,
    ) -> AttrNumber;
}
#[pg_guard]
extern "C" {
    pub fn ExecFindJunkAttributeInTlist(
        targetlist: *mut List,
        attrName: *const ::std::os::raw::c_char,
    ) -> AttrNumber;
}
#[pg_guard]
extern "C" {
    pub fn ExecGetJunkAttribute(
        slot: *mut TupleTableSlot,
        attno: AttrNumber,
        isNull: *mut bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn ExecFilterJunk(
        junkfilter: *mut JunkFilter,
        slot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecutorStart(queryDesc: *mut QueryDesc, eflags: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn standard_ExecutorStart(queryDesc: *mut QueryDesc, eflags: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn ExecutorRun(
        queryDesc: *mut QueryDesc,
        direction: ScanDirection,
        count: uint64,
        execute_once: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn standard_ExecutorRun(
        queryDesc: *mut QueryDesc,
        direction: ScanDirection,
        count: uint64,
        execute_once: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecutorFinish(queryDesc: *mut QueryDesc);
}
#[pg_guard]
extern "C" {
    pub fn standard_ExecutorFinish(queryDesc: *mut QueryDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExecutorEnd(queryDesc: *mut QueryDesc);
}
#[pg_guard]
extern "C" {
    pub fn standard_ExecutorEnd(queryDesc: *mut QueryDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExecutorRewind(queryDesc: *mut QueryDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExecCheckRTPerms(rangeTable: *mut List, ereport_on_violation: bool) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn CheckValidResultRel(resultRelInfo: *mut ResultRelInfo, operation: CmdType);
}
#[pg_guard]
extern "C" {
    pub fn InitResultRelInfo(
        resultRelInfo: *mut ResultRelInfo,
        resultRelationDesc: Relation,
        resultRelationIndex: Index,
        partition_root: Relation,
        instrument_options: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecGetTriggerResultRel(estate: *mut EState, relid: Oid) -> *mut ResultRelInfo;
}
#[pg_guard]
extern "C" {
    pub fn ExecCleanUpTriggerState(estate: *mut EState);
}
#[pg_guard]
extern "C" {
    pub fn ExecContextForcesOids(planstate: *mut PlanState, hasoids: *mut bool) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ExecConstraints(
        resultRelInfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecWithCheckOptions(
        kind: WCOKind,
        resultRelInfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecUpdateLockMode(estate: *mut EState, relinfo: *mut ResultRelInfo) -> LockTupleMode;
}
#[pg_guard]
extern "C" {
    pub fn ExecFindRowMark(estate: *mut EState, rti: Index, missing_ok: bool) -> *mut ExecRowMark;
}
#[pg_guard]
extern "C" {
    pub fn ExecBuildAuxRowMark(erm: *mut ExecRowMark, targetlist: *mut List)
        -> *mut ExecAuxRowMark;
}
#[pg_guard]
extern "C" {
    pub fn EvalPlanQual(
        estate: *mut EState,
        epqstate: *mut EPQState,
        relation: Relation,
        rti: Index,
        lockmode: ::std::os::raw::c_int,
        tid: ItemPointer,
        priorXmax: TransactionId,
    ) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn EvalPlanQualFetch(
        estate: *mut EState,
        relation: Relation,
        lockmode: ::std::os::raw::c_int,
        wait_policy: LockWaitPolicy,
        tid: ItemPointer,
        priorXmax: TransactionId,
    ) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn EvalPlanQualInit(
        epqstate: *mut EPQState,
        estate: *mut EState,
        subplan: *mut Plan,
        auxrowmarks: *mut List,
        epqParam: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn EvalPlanQualSetPlan(epqstate: *mut EPQState, subplan: *mut Plan, auxrowmarks: *mut List);
}
#[pg_guard]
extern "C" {
    pub fn EvalPlanQualSetTuple(epqstate: *mut EPQState, rti: Index, tuple: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn EvalPlanQualGetTuple(epqstate: *mut EPQState, rti: Index) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn ExecSetupPartitionTupleRouting(
        rel: Relation,
        resultRTindex: Index,
        estate: *mut EState,
        pd: *mut *mut PartitionDispatch,
        partitions: *mut *mut ResultRelInfo,
        tup_conv_maps: *mut *mut *mut TupleConversionMap,
        partition_tuple_slot: *mut *mut TupleTableSlot,
        num_parted: *mut ::std::os::raw::c_int,
        num_partitions: *mut ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecFindPartition(
        resultRelInfo: *mut ResultRelInfo,
        pd: *mut PartitionDispatch,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn EvalPlanQualFetchRowMarks(epqstate: *mut EPQState);
}
#[pg_guard]
extern "C" {
    pub fn EvalPlanQualNext(epqstate: *mut EPQState) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn EvalPlanQualBegin(epqstate: *mut EPQState, parentestate: *mut EState);
}
#[pg_guard]
extern "C" {
    pub fn EvalPlanQualEnd(epqstate: *mut EPQState);
}
#[pg_guard]
extern "C" {
    pub fn ExecInitNode(
        node: *mut Plan,
        estate: *mut EState,
        eflags: ::std::os::raw::c_int,
    ) -> *mut PlanState;
}
#[pg_guard]
extern "C" {
    pub fn MultiExecProcNode(node: *mut PlanState) -> *mut Node;
}
#[pg_guard]
extern "C" {
    pub fn ExecEndNode(node: *mut PlanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecShutdownNode(node: *mut PlanState) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ExecInitExpr(node: *mut Expr, parent: *mut PlanState) -> *mut ExprState;
}
#[pg_guard]
extern "C" {
    pub fn ExecInitQual(qual: *mut List, parent: *mut PlanState) -> *mut ExprState;
}
#[pg_guard]
extern "C" {
    pub fn ExecInitCheck(qual: *mut List, parent: *mut PlanState) -> *mut ExprState;
}
#[pg_guard]
extern "C" {
    pub fn ExecInitExprList(nodes: *mut List, parent: *mut PlanState) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn ExecBuildProjectionInfo(
        targetList: *mut List,
        econtext: *mut ExprContext,
        slot: *mut TupleTableSlot,
        parent: *mut PlanState,
        inputDesc: TupleDesc,
    ) -> *mut ProjectionInfo;
}
#[pg_guard]
extern "C" {
    pub fn ExecBuildProjectionInfoExt(
        targetList: *mut List,
        econtext: *mut ExprContext,
        slot: *mut TupleTableSlot,
        assignJunkEntries: bool,
        parent: *mut PlanState,
        inputDesc: TupleDesc,
    ) -> *mut ProjectionInfo;
}
#[pg_guard]
extern "C" {
    pub fn ExecPrepareExpr(node: *mut Expr, estate: *mut EState) -> *mut ExprState;
}
#[pg_guard]
extern "C" {
    pub fn ExecPrepareQual(qual: *mut List, estate: *mut EState) -> *mut ExprState;
}
#[pg_guard]
extern "C" {
    pub fn ExecPrepareCheck(qual: *mut List, estate: *mut EState) -> *mut ExprState;
}
#[pg_guard]
extern "C" {
    pub fn ExecPrepareExprList(nodes: *mut List, estate: *mut EState) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn ExecCheck(state: *mut ExprState, context: *mut ExprContext) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ExecInitTableFunctionResult(
        expr: *mut Expr,
        econtext: *mut ExprContext,
        parent: *mut PlanState,
    ) -> *mut SetExprState;
}
#[pg_guard]
extern "C" {
    pub fn ExecMakeTableFunctionResult(
        setexpr: *mut SetExprState,
        econtext: *mut ExprContext,
        argContext: MemoryContext,
        expectedDesc: TupleDesc,
        randomAccess: bool,
    ) -> *mut Tuplestorestate;
}
#[pg_guard]
extern "C" {
    pub fn ExecInitFunctionResultSet(
        expr: *mut Expr,
        econtext: *mut ExprContext,
        parent: *mut PlanState,
    ) -> *mut SetExprState;
}
#[pg_guard]
extern "C" {
    pub fn ExecMakeFunctionResultSet(
        fcache: *mut SetExprState,
        econtext: *mut ExprContext,
        isNull: *mut bool,
        isDone: *mut ExprDoneCond,
    ) -> Datum;
}
pub type ExecScanAccessMtd =
    ::std::option::Option<unsafe extern "C" fn(node: *mut ScanState) -> *mut TupleTableSlot>;
pub type ExecScanRecheckMtd = ::std::option::Option<
    unsafe extern "C" fn(node: *mut ScanState, slot: *mut TupleTableSlot) -> bool,
>;
#[pg_guard]
extern "C" {
    pub fn ExecScan(
        node: *mut ScanState,
        accessMtd: ExecScanAccessMtd,
        recheckMtd: ExecScanRecheckMtd,
    ) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecAssignScanProjectionInfo(node: *mut ScanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecAssignScanProjectionInfoWithVarno(node: *mut ScanState, varno: Index);
}
#[pg_guard]
extern "C" {
    pub fn ExecScanReScan(node: *mut ScanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecInitResultTupleSlot(estate: *mut EState, planstate: *mut PlanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecInitScanTupleSlot(estate: *mut EState, scanstate: *mut ScanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecInitExtraTupleSlot(estate: *mut EState) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecInitNullTupleSlot(estate: *mut EState, tupType: TupleDesc) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecTypeFromTL(targetList: *mut List, hasoid: bool) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn ExecCleanTypeFromTL(targetList: *mut List, hasoid: bool) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn ExecTypeFromExprList(exprList: *mut List) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn ExecTypeSetColNames(typeInfo: TupleDesc, namesList: *mut List);
}
#[pg_guard]
extern "C" {
    pub fn UpdateChangedParamSet(node: *mut PlanState, newchg: *mut Bitmapset);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupOutputState {
    pub slot: *mut TupleTableSlot,
    pub dest: *mut DestReceiver,
}
impl Default for TupOutputState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn begin_tup_output_tupdesc(
        dest: *mut DestReceiver,
        tupdesc: TupleDesc,
    ) -> *mut TupOutputState;
}
#[pg_guard]
extern "C" {
    pub fn do_tup_output(tstate: *mut TupOutputState, values: *mut Datum, isnull: *mut bool);
}
#[pg_guard]
extern "C" {
    pub fn do_text_output_multiline(
        tstate: *mut TupOutputState,
        txt: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn end_tup_output(tstate: *mut TupOutputState);
}
#[pg_guard]
extern "C" {
    pub fn CreateExecutorState() -> *mut EState;
}
#[pg_guard]
extern "C" {
    pub fn FreeExecutorState(estate: *mut EState);
}
#[pg_guard]
extern "C" {
    pub fn CreateExprContext(estate: *mut EState) -> *mut ExprContext;
}
#[pg_guard]
extern "C" {
    pub fn CreateStandaloneExprContext() -> *mut ExprContext;
}
#[pg_guard]
extern "C" {
    pub fn FreeExprContext(econtext: *mut ExprContext, isCommit: bool);
}
#[pg_guard]
extern "C" {
    pub fn ReScanExprContext(econtext: *mut ExprContext);
}
#[pg_guard]
extern "C" {
    pub fn MakePerTupleExprContext(estate: *mut EState) -> *mut ExprContext;
}
#[pg_guard]
extern "C" {
    pub fn ExecAssignExprContext(estate: *mut EState, planstate: *mut PlanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecAssignResultType(planstate: *mut PlanState, tupDesc: TupleDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExecAssignResultTypeFromTL(planstate: *mut PlanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecGetResultType(planstate: *mut PlanState) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn ExecAssignProjectionInfo(planstate: *mut PlanState, inputDesc: TupleDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExecFreeExprContext(planstate: *mut PlanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecAssignScanType(scanstate: *mut ScanState, tupDesc: TupleDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExecAssignScanTypeFromOuterPlan(scanstate: *mut ScanState);
}
#[pg_guard]
extern "C" {
    pub fn ExecRelationIsTargetRelation(estate: *mut EState, scanrelid: Index) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ExecOpenScanRelation(
        estate: *mut EState,
        scanrelid: Index,
        eflags: ::std::os::raw::c_int,
    ) -> Relation;
}
#[pg_guard]
extern "C" {
    pub fn ExecCloseScanRelation(scanrel: Relation);
}
#[pg_guard]
extern "C" {
    pub fn executor_errposition(
        estate: *mut EState,
        location: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn RegisterExprContextCallback(
        econtext: *mut ExprContext,
        function: ExprContextCallbackFunction,
        arg: Datum,
    );
}
#[pg_guard]
extern "C" {
    pub fn UnregisterExprContextCallback(
        econtext: *mut ExprContext,
        function: ExprContextCallbackFunction,
        arg: Datum,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecLockNonLeafAppendTables(partitioned_rels: *mut List, estate: *mut EState);
}
#[pg_guard]
extern "C" {
    pub fn GetAttributeByName(
        tuple: HeapTupleHeader,
        attname: *const ::std::os::raw::c_char,
        isNull: *mut bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn GetAttributeByNum(
        tuple: HeapTupleHeader,
        attrno: AttrNumber,
        isNull: *mut bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn ExecTargetListLength(targetlist: *mut List) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ExecCleanTargetListLength(targetlist: *mut List) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ExecOpenIndices(resultRelInfo: *mut ResultRelInfo, speculative: bool);
}
#[pg_guard]
extern "C" {
    pub fn ExecCloseIndices(resultRelInfo: *mut ResultRelInfo);
}
#[pg_guard]
extern "C" {
    pub fn ExecInsertIndexTuples(
        slot: *mut TupleTableSlot,
        tupleid: ItemPointer,
        estate: *mut EState,
        noDupErr: bool,
        specConflict: *mut bool,
        arbiterIndexes: *mut List,
    ) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn ExecCheckIndexConstraints(
        slot: *mut TupleTableSlot,
        estate: *mut EState,
        conflictTid: ItemPointer,
        arbiterIndexes: *mut List,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn check_exclusion_constraint(
        heap: Relation,
        index: Relation,
        indexInfo: *mut IndexInfo,
        tupleid: ItemPointer,
        values: *mut Datum,
        isnull: *mut bool,
        estate: *mut EState,
        newIndex: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn RelationFindReplTupleByIndex(
        rel: Relation,
        idxoid: Oid,
        lockmode: LockTupleMode,
        searchslot: *mut TupleTableSlot,
        outslot: *mut TupleTableSlot,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn RelationFindReplTupleSeq(
        rel: Relation,
        lockmode: LockTupleMode,
        searchslot: *mut TupleTableSlot,
        outslot: *mut TupleTableSlot,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ExecSimpleRelationInsert(estate: *mut EState, slot: *mut TupleTableSlot);
}
#[pg_guard]
extern "C" {
    pub fn ExecSimpleRelationUpdate(
        estate: *mut EState,
        epqstate: *mut EPQState,
        searchslot: *mut TupleTableSlot,
        slot: *mut TupleTableSlot,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecSimpleRelationDelete(
        estate: *mut EState,
        epqstate: *mut EPQState,
        searchslot: *mut TupleTableSlot,
    );
}
#[pg_guard]
extern "C" {
    pub fn CheckCmdReplicaIdentity(rel: Relation, cmd: CmdType);
}
#[pg_guard]
extern "C" {
    pub fn CheckSubscriptionRelkind(
        relkind: ::std::os::raw::c_char,
        nspname: *const ::std::os::raw::c_char,
        relname: *const ::std::os::raw::c_char,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttInMetadata {
    pub tupdesc: TupleDesc,
    pub attinfuncs: *mut FmgrInfo,
    pub attioparams: *mut Oid,
    pub atttypmods: *mut int32,
}
impl Default for AttInMetadata {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncCallContext {
    pub call_cntr: uint64,
    pub max_calls: uint64,
    pub slot: *mut TupleTableSlot,
    pub user_fctx: *mut ::std::os::raw::c_void,
    pub attinmeta: *mut AttInMetadata,
    pub multi_call_memory_ctx: MemoryContext,
    pub tuple_desc: TupleDesc,
}
impl Default for FuncCallContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TypeFuncClass_TYPEFUNC_SCALAR: TypeFuncClass = 0;
pub const TypeFuncClass_TYPEFUNC_COMPOSITE: TypeFuncClass = 1;
pub const TypeFuncClass_TYPEFUNC_RECORD: TypeFuncClass = 2;
pub const TypeFuncClass_TYPEFUNC_OTHER: TypeFuncClass = 3;
pub type TypeFuncClass = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn get_call_result_type(
        fcinfo: FunctionCallInfo,
        resultTypeId: *mut Oid,
        resultTupleDesc: *mut TupleDesc,
    ) -> TypeFuncClass;
}
#[pg_guard]
extern "C" {
    pub fn get_expr_result_type(
        expr: *mut Node,
        resultTypeId: *mut Oid,
        resultTupleDesc: *mut TupleDesc,
    ) -> TypeFuncClass;
}
#[pg_guard]
extern "C" {
    pub fn get_func_result_type(
        functionId: Oid,
        resultTypeId: *mut Oid,
        resultTupleDesc: *mut TupleDesc,
    ) -> TypeFuncClass;
}
#[pg_guard]
extern "C" {
    pub fn resolve_polymorphic_argtypes(
        numargs: ::std::os::raw::c_int,
        argtypes: *mut Oid,
        argmodes: *mut ::std::os::raw::c_char,
        call_expr: *mut Node,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_func_arg_info(
        procTup: HeapTuple,
        p_argtypes: *mut *mut Oid,
        p_argnames: *mut *mut *mut ::std::os::raw::c_char,
        p_argmodes: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn get_func_input_arg_names(
        proargnames: Datum,
        proargmodes: Datum,
        arg_names: *mut *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn get_func_trftypes(
        procTup: HeapTuple,
        p_trftypes: *mut *mut Oid,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn get_func_result_name(functionId: Oid) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn build_function_result_tupdesc_d(
        proallargtypes: Datum,
        proargmodes: Datum,
        proargnames: Datum,
    ) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn build_function_result_tupdesc_t(procTuple: HeapTuple) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn RelationNameGetTupleDesc(relname: *const ::std::os::raw::c_char) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn TypeGetTupleDesc(typeoid: Oid, colaliases: *mut List) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn BlessTupleDesc(tupdesc: TupleDesc) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn TupleDescGetAttInMetadata(tupdesc: TupleDesc) -> *mut AttInMetadata;
}
#[pg_guard]
extern "C" {
    pub fn BuildTupleFromCStrings(
        attinmeta: *mut AttInMetadata,
        values: *mut *mut ::std::os::raw::c_char,
    ) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn HeapTupleHeaderGetDatum(tuple: HeapTupleHeader) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn TupleDescGetSlot(tupdesc: TupleDesc) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn init_MultiFuncCall(fcinfo: FunctionCallInfo) -> *mut FuncCallContext;
}
#[pg_guard]
extern "C" {
    pub fn per_MultiFuncCall(fcinfo: FunctionCallInfo) -> *mut FuncCallContext;
}
#[pg_guard]
extern "C" {
    pub fn end_MultiFuncCall(fcinfo: FunctionCallInfo, funcctx: *mut FuncCallContext);
}
#[pg_guard]
extern "C" {
    pub fn extract_variadic_args(
        fcinfo: FunctionCallInfo,
        variadic_start: ::std::os::raw::c_int,
        convert_unknown: bool,
        values: *mut *mut Datum,
        types: *mut *mut Oid,
        nulls: *mut *mut bool,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static sys_signame: [*const ::std::os::raw::c_char; 32usize];
}
#[pg_guard]
extern "C" {
    pub static sys_siglist: [*const ::std::os::raw::c_char; 32usize];
}
#[pg_guard]
extern "C" {
    pub fn raise(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn bsd_signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
#[pg_guard]
extern "C" {
    pub fn kill(arg1: pid_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn killpg(arg1: pid_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pthread_kill(arg1: pthread_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pthread_sigmask(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigset_t,
        arg3: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigaction(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigaction,
        arg3: *mut sigaction,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigaddset(arg1: *mut sigset_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigaltstack(arg1: *const stack_t, arg2: *mut stack_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigdelset(arg1: *mut sigset_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigemptyset(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigfillset(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sighold(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigignore(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn siginterrupt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigismember(arg1: *const sigset_t, arg2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigpause(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigpending(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigprocmask(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigset_t,
        arg3: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigrelse(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigset(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
#[pg_guard]
extern "C" {
    pub fn sigsuspend(arg1: *const sigset_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigwait(
        arg1: *const sigset_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn psignal(arg1: ::std::os::raw::c_uint, arg2: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn sigblock(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigsetmask(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn sigvec(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sigvec,
        arg3: *mut sigvec,
    ) -> ::std::os::raw::c_int;
}
pub type pg_time_t = int64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
impl Default for pg_tm {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tz {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tzenum {
    _unused: [u8; 0],
}
#[pg_guard]
extern "C" {
    pub fn pg_localtime(timep: *const pg_time_t, tz: *const pg_tz) -> *mut pg_tm;
}
#[pg_guard]
extern "C" {
    pub fn pg_gmtime(timep: *const pg_time_t) -> *mut pg_tm;
}
#[pg_guard]
extern "C" {
    pub fn pg_next_dst_boundary(
        timep: *const pg_time_t,
        before_gmtoff: *mut ::std::os::raw::c_long,
        before_isdst: *mut ::std::os::raw::c_int,
        boundary: *mut pg_time_t,
        after_gmtoff: *mut ::std::os::raw::c_long,
        after_isdst: *mut ::std::os::raw::c_int,
        tz: *const pg_tz,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pg_interpret_timezone_abbrev(
        abbrev: *const ::std::os::raw::c_char,
        timep: *const pg_time_t,
        gmtoff: *mut ::std::os::raw::c_long,
        isdst: *mut ::std::os::raw::c_int,
        tz: *const pg_tz,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_get_timezone_offset(tz: *const pg_tz, gmtoff: *mut ::std::os::raw::c_long) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_get_timezone_name(tz: *mut pg_tz) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pg_tz_acceptable(tz: *mut pg_tz) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn pg_strftime(
        s: *mut ::std::os::raw::c_char,
        max: usize,
        format: *const ::std::os::raw::c_char,
        tm: *const pg_tm,
    ) -> usize;
}
#[pg_guard]
extern "C" {
    pub static mut session_timezone: *mut pg_tz;
}
#[pg_guard]
extern "C" {
    pub static mut log_timezone: *mut pg_tz;
}
#[pg_guard]
extern "C" {
    pub fn pg_timezone_initialize();
}
#[pg_guard]
extern "C" {
    pub fn pg_tzset(tzname: *const ::std::os::raw::c_char) -> *mut pg_tz;
}
#[pg_guard]
extern "C" {
    pub fn pg_tzset_offset(gmtoffset: ::std::os::raw::c_long) -> *mut pg_tz;
}
#[pg_guard]
extern "C" {
    pub fn pg_tzenumerate_start() -> *mut pg_tzenum;
}
#[pg_guard]
extern "C" {
    pub fn pg_tzenumerate_next(dir: *mut pg_tzenum) -> *mut pg_tz;
}
#[pg_guard]
extern "C" {
    pub fn pg_tzenumerate_end(dir: *mut pg_tzenum);
}
#[pg_guard]
extern "C" {
    #[doc = "\t  System interrupt and critical section handling"]
    #[doc = ""]
    #[doc = " There are two types of interrupts that a running backend needs to accept"]
    #[doc = " without messing up its state: QueryCancel (SIGINT) and ProcDie (SIGTERM)."]
    #[doc = " In both cases, we need to be able to clean up the current transaction"]
    #[doc = " gracefully, so we can't respond to the interrupt instantaneously ---"]
    #[doc = " there's no guarantee that internal data structures would be self-consistent"]
    #[doc = " if the code is interrupted at an arbitrary instant.  Instead, the signal"]
    #[doc = " handlers set flags that are checked periodically during execution."]
    #[doc = ""]
    #[doc = " The CHECK_FOR_INTERRUPTS() macro is called at strategically located spots"]
    #[doc = " where it is normally safe to accept a cancel or die interrupt.  In some"]
    #[doc = " cases, we invoke CHECK_FOR_INTERRUPTS() inside low-level subroutines that"]
    #[doc = " might sometimes be called in contexts that do *not* want to allow a cancel"]
    #[doc = " or die interrupt.  The HOLD_INTERRUPTS() and RESUME_INTERRUPTS() macros"]
    #[doc = " allow code to ensure that no cancel or die interrupt will be accepted,"]
    #[doc = " even if CHECK_FOR_INTERRUPTS() gets called in a subroutine.  The interrupt"]
    #[doc = " will be held off until CHECK_FOR_INTERRUPTS() is done outside any"]
    #[doc = " HOLD_INTERRUPTS() ... RESUME_INTERRUPTS() section."]
    #[doc = ""]
    #[doc = " There is also a mechanism to prevent query cancel interrupts, while still"]
    #[doc = " allowing die interrupts: HOLD_CANCEL_INTERRUPTS() and"]
    #[doc = " RESUME_CANCEL_INTERRUPTS()."]
    #[doc = ""]
    #[doc = " Note that ProcessInterrupts() has also acquired a number of tasks that"]
    #[doc = " do not necessarily cause a query-cancel-or-die response.  Hence, it's"]
    #[doc = " possible that it will just clear InterruptPending and return."]
    #[doc = ""]
    #[doc = " INTERRUPTS_PENDING_CONDITION() can be checked to see whether an"]
    #[doc = " interrupt needs to be serviced, without trying to do so immediately."]
    #[doc = " Some callers are also interested in INTERRUPTS_CAN_BE_PROCESSED(),"]
    #[doc = " which tells whether ProcessInterrupts is sure to clear the interrupt."]
    #[doc = ""]
    #[doc = " Special mechanisms are used to let an interrupt be accepted when we are"]
    #[doc = " waiting for a lock or when we are waiting for command input (but, of"]
    #[doc = " course, only if the interrupt holdoff counter is zero).  See the"]
    #[doc = " related code for details."]
    #[doc = ""]
    #[doc = " A lost connection is handled similarly, although the loss of connection"]
    #[doc = " does not raise a signal, but is detected when we fail to write to the"]
    #[doc = " socket. If there was a signal for a broken connection, we could make use of"]
    #[doc = " it by setting ClientConnectionLost in the signal handler."]
    #[doc = ""]
    #[doc = " A related, but conceptually distinct, mechanism is the \"critical section\""]
    #[doc = " mechanism.  A critical section not only holds off cancel/die interrupts,"]
    #[doc = " but causes any ereport(ERROR) or ereport(FATAL) to become ereport(PANIC)"]
    #[doc = " --- that is, a system-wide reset is forced.  Needless to say, only really"]
    #[doc = " *critical* code should be marked as a critical section!\tCurrently, this"]
    #[doc = " mechanism is only used for XLOG-related code."]
    #[doc = ""]
    pub static mut InterruptPending: bool;
}
#[pg_guard]
extern "C" {
    pub static mut QueryCancelPending: bool;
}
#[pg_guard]
extern "C" {
    pub static mut ProcDiePending: bool;
}
#[pg_guard]
extern "C" {
    pub static mut IdleInTransactionSessionTimeoutPending: bool;
}
#[pg_guard]
extern "C" {
    pub static mut ConfigReloadPending: sig_atomic_t;
}
#[pg_guard]
extern "C" {
    pub static mut ClientConnectionLost: bool;
}
#[pg_guard]
extern "C" {
    pub static mut InterruptHoldoffCount: uint32;
}
#[pg_guard]
extern "C" {
    pub static mut QueryCancelHoldoffCount: uint32;
}
#[pg_guard]
extern "C" {
    pub static mut CritSectionCount: uint32;
}
#[pg_guard]
extern "C" {
    pub fn ProcessInterrupts();
}
#[pg_guard]
extern "C" {
    #[doc = "\t  globals.h --\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t *"]
    pub static mut PostmasterPid: pid_t;
}
#[pg_guard]
extern "C" {
    pub static mut IsPostmasterEnvironment: bool;
}
#[pg_guard]
extern "C" {
    pub static mut IsUnderPostmaster: bool;
}
#[pg_guard]
extern "C" {
    pub static mut IsBackgroundWorker: bool;
}
#[pg_guard]
extern "C" {
    pub static mut IsBinaryUpgrade: bool;
}
#[pg_guard]
extern "C" {
    pub static mut ExitOnAnyError: bool;
}
#[pg_guard]
extern "C" {
    pub static mut DataDir: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub static mut NBuffers: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut MaxBackends: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut MaxConnections: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut max_worker_processes: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut max_parallel_workers: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut MyProcPid: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut MyStartTime: pg_time_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Port {
    _unused: [u8; 0],
}
#[pg_guard]
extern "C" {
    pub static mut MyProcPort: *mut Port;
}
#[pg_guard]
extern "C" {
    pub static mut MyLatch: *mut Latch;
}
#[pg_guard]
extern "C" {
    pub static mut MyCancelKey: int32;
}
#[pg_guard]
extern "C" {
    pub static mut MyPMChildSlot: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut OutputFileName: [::std::os::raw::c_char; 0usize];
}
#[pg_guard]
extern "C" {
    pub static mut my_exec_path: [::std::os::raw::c_char; 0usize];
}
#[pg_guard]
extern "C" {
    pub static mut pkglib_path: [::std::os::raw::c_char; 0usize];
}
#[pg_guard]
extern "C" {
    pub static mut MyDatabaseId: Oid;
}
#[pg_guard]
extern "C" {
    pub static mut MyDatabaseTableSpace: Oid;
}
#[pg_guard]
extern "C" {
    pub static mut DateStyle: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut DateOrder: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut IntervalStyle: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut enableFsync: bool;
}
#[pg_guard]
extern "C" {
    pub static mut allowSystemTableMods: bool;
}
#[pg_guard]
extern "C" {
    pub static mut work_mem: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut maintenance_work_mem: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut replacement_sort_tuples: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut VacuumCostPageHit: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut VacuumCostPageMiss: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut VacuumCostPageDirty: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut VacuumCostLimit: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut VacuumCostDelay: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut VacuumPageHit: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut VacuumPageMiss: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut VacuumPageDirty: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut VacuumCostBalance: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut VacuumCostActive: bool;
}
pub type pg_stack_base_t = *mut ::std::os::raw::c_char;
#[pg_guard]
extern "C" {
    pub fn set_stack_base() -> pg_stack_base_t;
}
#[pg_guard]
extern "C" {
    pub fn restore_stack_base(base: pg_stack_base_t);
}
#[pg_guard]
extern "C" {
    pub fn check_stack_depth();
}
#[pg_guard]
extern "C" {
    pub fn stack_is_too_deep() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn PostgresSigHupHandler(postgres_signal_arg: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn PreventCommandIfReadOnly(cmdname: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn PreventCommandIfParallelMode(cmdname: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn PreventCommandDuringRecovery(cmdname: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub static mut trace_recovery_messages: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn trace_recovery(trace_level: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut DatabasePath: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn InitPostmasterChild();
}
#[pg_guard]
extern "C" {
    pub fn InitStandaloneProcess(argv0: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn SetDatabasePath(path: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn GetUserNameFromId(roleid: Oid, noerr: bool) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn GetUserId() -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn GetOuterUserId() -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn GetSessionUserId() -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn GetAuthenticatedUserId() -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn GetUserIdAndSecContext(userid: *mut Oid, sec_context: *mut ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn SetUserIdAndSecContext(userid: Oid, sec_context: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn InLocalUserIdChange() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn InSecurityRestrictedOperation() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn InNoForceRLSOperation() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetUserIdAndContext(userid: *mut Oid, sec_def_context: *mut bool);
}
#[pg_guard]
extern "C" {
    pub fn SetUserIdAndContext(userid: Oid, sec_def_context: bool);
}
#[pg_guard]
extern "C" {
    pub fn InitializeSessionUserId(rolename: *const ::std::os::raw::c_char, useroid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn InitializeSessionUserIdStandalone();
}
#[pg_guard]
extern "C" {
    pub fn SetSessionAuthorization(userid: Oid, is_superuser: bool);
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentRoleId() -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn SetCurrentRoleId(roleid: Oid, is_superuser: bool);
}
#[pg_guard]
extern "C" {
    pub fn SetDataDir(dir: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn ChangeToDataDir();
}
#[pg_guard]
extern "C" {
    pub fn SwitchToSharedLatch();
}
#[pg_guard]
extern "C" {
    pub fn SwitchBackToLocalLatch();
}
#[pg_guard]
extern "C" {
    pub fn superuser() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn superuser_arg(roleid: Oid) -> bool;
}
pub const ProcessingMode_BootstrapProcessing: ProcessingMode = 0;
pub const ProcessingMode_InitProcessing: ProcessingMode = 1;
pub const ProcessingMode_NormalProcessing: ProcessingMode = 2;
#[doc = "\t  pmod.h --\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t *"]
#[doc = "\t\t\tPOSTGRES processing mode definitions.                            *"]
pub type ProcessingMode = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub static mut Mode: ProcessingMode;
}
pub const AuxProcType_NotAnAuxProcess: AuxProcType = -1;
pub const AuxProcType_CheckerProcess: AuxProcType = 0;
pub const AuxProcType_BootstrapProcess: AuxProcType = 1;
pub const AuxProcType_StartupProcess: AuxProcType = 2;
pub const AuxProcType_BgWriterProcess: AuxProcType = 3;
pub const AuxProcType_CheckpointerProcess: AuxProcType = 4;
pub const AuxProcType_WalWriterProcess: AuxProcType = 5;
pub const AuxProcType_WalReceiverProcess: AuxProcType = 6;
pub const AuxProcType_NUM_AUXPROCTYPES: AuxProcType = 7;
pub type AuxProcType = ::std::os::raw::c_int;
#[pg_guard]
extern "C" {
    pub static mut MyAuxProcType: AuxProcType;
}
#[pg_guard]
extern "C" {
    #[doc = "\t  pinit.h --\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t *"]
    #[doc = "\t\t\tPOSTGRES initialization and cleanup definitions.                 *"]
    pub fn pg_split_opts(
        argv: *mut *mut ::std::os::raw::c_char,
        argcp: *mut ::std::os::raw::c_int,
        optstr: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn InitializeMaxBackends();
}
#[pg_guard]
extern "C" {
    pub fn InitPostgres(
        in_dbname: *const ::std::os::raw::c_char,
        dboid: Oid,
        username: *const ::std::os::raw::c_char,
        useroid: Oid,
        out_dbname: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn BaseInit();
}
#[pg_guard]
extern "C" {
    pub static mut IgnoreSystemIndexes: bool;
}
#[pg_guard]
extern "C" {
    pub static mut process_shared_preload_libraries_in_progress: bool;
}
#[pg_guard]
extern "C" {
    pub static mut session_preload_libraries_string: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub static mut shared_preload_libraries_string: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub static mut local_preload_libraries_string: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn CreateDataDirLockFile(amPostmaster: bool);
}
#[pg_guard]
extern "C" {
    pub fn CreateSocketLockFile(
        socketfile: *const ::std::os::raw::c_char,
        amPostmaster: bool,
        socketDir: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn TouchSocketLockFiles();
}
#[pg_guard]
extern "C" {
    pub fn AddToDataDirLockFile(
        target_line: ::std::os::raw::c_int,
        str_: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn RecheckDataDirLockFile() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ValidatePgVersion(path: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn process_shared_preload_libraries();
}
#[pg_guard]
extern "C" {
    pub fn process_session_preload_libraries();
}
#[pg_guard]
extern "C" {
    pub fn pg_bindtextdomain(domain: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn has_rolreplication(roleid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn BackupInProgress() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn CancelBackup();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_un {
    pub sun_len: ::std::os::raw::c_uchar,
    pub sun_family: sa_family_t,
    pub sun_path: [::std::os::raw::c_char; 104usize],
}
impl Default for sockaddr_un {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SockAddr {
    pub addr: sockaddr_storage,
    pub salen: socklen_t,
}
impl Default for SockAddr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ProtocolVersion = uint32;
pub type MsgType = ProtocolVersion;
pub type PacketLen = uint32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StartupPacket {
    pub protoVersion: ProtocolVersion,
    pub database: [::std::os::raw::c_char; 64usize],
    pub user: [::std::os::raw::c_char; 32usize],
    pub options: [::std::os::raw::c_char; 64usize],
    pub unused: [::std::os::raw::c_char; 64usize],
    pub tty: [::std::os::raw::c_char; 64usize],
}
impl Default for StartupPacket {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut Db_user_namespace: bool;
}
pub type AuthRequest = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CancelRequestPacket {
    pub cancelRequestCode: MsgType,
    pub backendPID: uint32,
    pub cancelAuthCode: uint32,
}
#[pg_guard]
extern "C" {
    pub fn pgarch_start() -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_node {
    pub prev: *mut dlist_node,
    pub next: *mut dlist_node,
}
impl Default for dlist_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_head {
    pub head: dlist_node,
}
impl Default for dlist_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_iter {
    pub cur: *mut dlist_node,
    pub end: *mut dlist_node,
}
impl Default for dlist_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_mutable_iter {
    pub cur: *mut dlist_node,
    pub next: *mut dlist_node,
    pub end: *mut dlist_node,
}
impl Default for dlist_mutable_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_node {
    pub next: *mut slist_node,
}
impl Default for slist_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_head {
    pub head: slist_node,
}
impl Default for slist_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_iter {
    pub cur: *mut slist_node,
}
impl Default for slist_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_mutable_iter {
    pub cur: *mut slist_node,
    pub next: *mut slist_node,
    pub prev: *mut slist_node,
}
impl Default for slist_mutable_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn slist_delete(head: *mut slist_head, node: *mut slist_node);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Latch {
    pub is_set: sig_atomic_t,
    pub is_shared: bool,
    pub owner_pid: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WaitEvent {
    pub pos: ::std::os::raw::c_int,
    pub events: uint32,
    pub fd: pgsocket,
    pub user_data: *mut ::std::os::raw::c_void,
}
impl Default for WaitEvent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WaitEventSet {
    _unused: [u8; 0],
}
#[pg_guard]
extern "C" {
    pub fn InitializeLatchSupport();
}
#[pg_guard]
extern "C" {
    pub fn InitLatch(latch: *mut Latch);
}
#[pg_guard]
extern "C" {
    pub fn InitSharedLatch(latch: *mut Latch);
}
#[pg_guard]
extern "C" {
    pub fn OwnLatch(latch: *mut Latch);
}
#[pg_guard]
extern "C" {
    pub fn DisownLatch(latch: *mut Latch);
}
#[pg_guard]
extern "C" {
    pub fn SetLatch(latch: *mut Latch);
}
#[pg_guard]
extern "C" {
    pub fn ResetLatch(latch: *mut Latch);
}
#[pg_guard]
extern "C" {
    pub fn CreateWaitEventSet(
        context: MemoryContext,
        nevents: ::std::os::raw::c_int,
    ) -> *mut WaitEventSet;
}
#[pg_guard]
extern "C" {
    pub fn FreeWaitEventSet(set: *mut WaitEventSet);
}
#[pg_guard]
extern "C" {
    pub fn AddWaitEventToSet(
        set: *mut WaitEventSet,
        events: uint32,
        fd: pgsocket,
        latch: *mut Latch,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ModifyWaitEvent(
        set: *mut WaitEventSet,
        pos: ::std::os::raw::c_int,
        events: uint32,
        latch: *mut Latch,
    );
}
#[pg_guard]
extern "C" {
    pub fn WaitEventSetWait(
        set: *mut WaitEventSet,
        timeout: ::std::os::raw::c_long,
        occurred_events: *mut WaitEvent,
        nevents: ::std::os::raw::c_int,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn WaitLatch(
        latch: *mut Latch,
        wakeEvents: ::std::os::raw::c_int,
        timeout: ::std::os::raw::c_long,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn WaitLatchOrSocket(
        latch: *mut Latch,
        wakeEvents: ::std::os::raw::c_int,
        sock: pgsocket,
        timeout: ::std::os::raw::c_long,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn latch_sigusr1_handler();
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LWLock {
    pub tranche: uint16,
    pub state: pg_atomic_uint32,
    pub waiters: proclist_head,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union LWLockPadded {
    pub lock: LWLock,
    pub pad: [::std::os::raw::c_char; 128usize],
}
impl Default for LWLockPadded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union LWLockMinimallyPadded {
    pub lock: LWLock,
    pub pad: [::std::os::raw::c_char; 32usize],
}
impl Default for LWLockMinimallyPadded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut MainLWLockArray: *mut LWLockPadded;
}
#[pg_guard]
extern "C" {
    pub static mut MainLWLockNames: [*mut ::std::os::raw::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedLWLockTranche {
    pub trancheId: ::std::os::raw::c_int,
    pub trancheName: *mut ::std::os::raw::c_char,
}
impl Default for NamedLWLockTranche {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut NamedLWLockTrancheArray: *mut NamedLWLockTranche;
}
#[pg_guard]
extern "C" {
    pub static mut NamedLWLockTrancheRequests: ::std::os::raw::c_int;
}
pub const LWLockMode_LW_EXCLUSIVE: LWLockMode = 0;
pub const LWLockMode_LW_SHARED: LWLockMode = 1;
pub const LWLockMode_LW_WAIT_UNTIL_FREE: LWLockMode = 2;
pub type LWLockMode = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn LWLockAcquire(lock: *mut LWLock, mode: LWLockMode) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn LWLockConditionalAcquire(lock: *mut LWLock, mode: LWLockMode) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn LWLockAcquireOrWait(lock: *mut LWLock, mode: LWLockMode) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn LWLockRelease(lock: *mut LWLock);
}
#[pg_guard]
extern "C" {
    pub fn LWLockReleaseClearVar(lock: *mut LWLock, valptr: *mut uint64, val: uint64);
}
#[pg_guard]
extern "C" {
    pub fn LWLockReleaseAll();
}
#[pg_guard]
extern "C" {
    pub fn LWLockHeldByMe(lock: *mut LWLock) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn LWLockHeldByMeInMode(lock: *mut LWLock, mode: LWLockMode) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn LWLockWaitForVar(
        lock: *mut LWLock,
        valptr: *mut uint64,
        oldval: uint64,
        newval: *mut uint64,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn LWLockUpdateVar(lock: *mut LWLock, valptr: *mut uint64, value: uint64);
}
#[pg_guard]
extern "C" {
    pub fn LWLockShmemSize() -> Size;
}
#[pg_guard]
extern "C" {
    pub fn CreateLWLocks();
}
#[pg_guard]
extern "C" {
    pub fn InitLWLockAccess();
}
#[pg_guard]
extern "C" {
    pub fn GetLWLockIdentifier(classId: uint32, eventId: uint16) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn RequestNamedLWLockTranche(
        tranche_name: *const ::std::os::raw::c_char,
        num_lwlocks: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn GetNamedLWLockTranche(tranche_name: *const ::std::os::raw::c_char) -> *mut LWLockPadded;
}
#[pg_guard]
extern "C" {
    pub fn LWLockNewTrancheId() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn LWLockRegisterTranche(
        tranche_id: ::std::os::raw::c_int,
        tranche_name: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn LWLockInitialize(lock: *mut LWLock, tranche_id: ::std::os::raw::c_int);
}
pub const BuiltinTrancheIds_LWTRANCHE_CLOG_BUFFERS: BuiltinTrancheIds = 48;
pub const BuiltinTrancheIds_LWTRANCHE_COMMITTS_BUFFERS: BuiltinTrancheIds = 49;
pub const BuiltinTrancheIds_LWTRANCHE_SUBTRANS_BUFFERS: BuiltinTrancheIds = 50;
pub const BuiltinTrancheIds_LWTRANCHE_MXACTOFFSET_BUFFERS: BuiltinTrancheIds = 51;
pub const BuiltinTrancheIds_LWTRANCHE_MXACTMEMBER_BUFFERS: BuiltinTrancheIds = 52;
pub const BuiltinTrancheIds_LWTRANCHE_ASYNC_BUFFERS: BuiltinTrancheIds = 53;
pub const BuiltinTrancheIds_LWTRANCHE_OLDSERXID_BUFFERS: BuiltinTrancheIds = 54;
pub const BuiltinTrancheIds_LWTRANCHE_WAL_INSERT: BuiltinTrancheIds = 55;
pub const BuiltinTrancheIds_LWTRANCHE_BUFFER_CONTENT: BuiltinTrancheIds = 56;
pub const BuiltinTrancheIds_LWTRANCHE_BUFFER_IO_IN_PROGRESS: BuiltinTrancheIds = 57;
pub const BuiltinTrancheIds_LWTRANCHE_REPLICATION_ORIGIN: BuiltinTrancheIds = 58;
pub const BuiltinTrancheIds_LWTRANCHE_REPLICATION_SLOT_IO_IN_PROGRESS: BuiltinTrancheIds = 59;
pub const BuiltinTrancheIds_LWTRANCHE_PROC: BuiltinTrancheIds = 60;
pub const BuiltinTrancheIds_LWTRANCHE_BUFFER_MAPPING: BuiltinTrancheIds = 61;
pub const BuiltinTrancheIds_LWTRANCHE_LOCK_MANAGER: BuiltinTrancheIds = 62;
pub const BuiltinTrancheIds_LWTRANCHE_PREDICATE_LOCK_MANAGER: BuiltinTrancheIds = 63;
pub const BuiltinTrancheIds_LWTRANCHE_PARALLEL_QUERY_DSA: BuiltinTrancheIds = 64;
pub const BuiltinTrancheIds_LWTRANCHE_TBM: BuiltinTrancheIds = 65;
pub const BuiltinTrancheIds_LWTRANCHE_FIRST_USER_DEFINED: BuiltinTrancheIds = 66;
pub type BuiltinTrancheIds = ::std::os::raw::c_uint;
pub type LWLockId = *mut LWLock;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SHM_QUEUE {
    pub prev: *mut SHM_QUEUE,
    pub next: *mut SHM_QUEUE,
}
impl Default for SHM_QUEUE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn InitShmemAccess(seghdr: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn InitShmemAllocation();
}
#[pg_guard]
extern "C" {
    pub fn ShmemAlloc(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn ShmemAllocNoError(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn ShmemAllocUnlocked(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn ShmemAddrIsValid(addr: *const ::std::os::raw::c_void) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn InitShmemIndex();
}
#[pg_guard]
extern "C" {
    pub fn ShmemInitHash(
        name: *const ::std::os::raw::c_char,
        init_size: ::std::os::raw::c_long,
        max_size: ::std::os::raw::c_long,
        infoP: *mut HASHCTL,
        hash_flags: ::std::os::raw::c_int,
    ) -> *mut HTAB;
}
#[pg_guard]
extern "C" {
    pub fn ShmemInitStruct(
        name: *const ::std::os::raw::c_char,
        size: Size,
        foundPtr: *mut bool,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn add_size(s1: Size, s2: Size) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn mul_size(s1: Size, s2: Size) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn RequestAddinShmemSpace(size: Size);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ShmemIndexEnt {
    pub key: [::std::os::raw::c_char; 48usize],
    pub location: *mut ::std::os::raw::c_void,
    pub size: Size,
}
impl Default for ShmemIndexEnt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn SHMQueueInit(queue: *mut SHM_QUEUE);
}
#[pg_guard]
extern "C" {
    pub fn SHMQueueElemInit(queue: *mut SHM_QUEUE);
}
#[pg_guard]
extern "C" {
    pub fn SHMQueueDelete(queue: *mut SHM_QUEUE);
}
#[pg_guard]
extern "C" {
    pub fn SHMQueueInsertBefore(queue: *mut SHM_QUEUE, elem: *mut SHM_QUEUE);
}
#[pg_guard]
extern "C" {
    pub fn SHMQueueInsertAfter(queue: *mut SHM_QUEUE, elem: *mut SHM_QUEUE);
}
#[pg_guard]
extern "C" {
    pub fn SHMQueueNext(
        queue: *const SHM_QUEUE,
        curElem: *const SHM_QUEUE,
        linkOffset: Size,
    ) -> Pointer;
}
#[pg_guard]
extern "C" {
    pub fn SHMQueuePrev(
        queue: *const SHM_QUEUE,
        curElem: *const SHM_QUEUE,
        linkOffset: Size,
    ) -> Pointer;
}
#[pg_guard]
extern "C" {
    pub fn SHMQueueEmpty(queue: *const SHM_QUEUE) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn SHMQueueIsDetached(queue: *const SHM_QUEUE) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROC_QUEUE {
    pub links: SHM_QUEUE,
    pub size: ::std::os::raw::c_int,
}
impl Default for PROC_QUEUE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut max_locks_per_xact: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct VirtualTransactionId {
    pub backendId: BackendId,
    pub localTransactionId: LocalTransactionId,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockMethodData {
    pub numLockModes: ::std::os::raw::c_int,
    pub conflictTab: *const LOCKMASK,
    pub lockModeNames: *const *const ::std::os::raw::c_char,
    pub trace_flag: *const bool,
}
impl Default for LockMethodData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LockMethod = *const LockMethodData;
pub type LOCKMETHODID = uint16;
pub const LockTagType_LOCKTAG_RELATION: LockTagType = 0;
pub const LockTagType_LOCKTAG_RELATION_EXTEND: LockTagType = 1;
pub const LockTagType_LOCKTAG_PAGE: LockTagType = 2;
pub const LockTagType_LOCKTAG_TUPLE: LockTagType = 3;
pub const LockTagType_LOCKTAG_TRANSACTION: LockTagType = 4;
pub const LockTagType_LOCKTAG_VIRTUALTRANSACTION: LockTagType = 5;
pub const LockTagType_LOCKTAG_SPECULATIVE_TOKEN: LockTagType = 6;
pub const LockTagType_LOCKTAG_OBJECT: LockTagType = 7;
pub const LockTagType_LOCKTAG_USERLOCK: LockTagType = 8;
pub const LockTagType_LOCKTAG_ADVISORY: LockTagType = 9;
pub const LockTagType_LOCKTAG_DATABASE_FROZEN_IDS: LockTagType = 10;
pub type LockTagType = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub static mut LockTagTypeNames: [*const ::std::os::raw::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LOCKTAG {
    pub locktag_field1: uint32,
    pub locktag_field2: uint32,
    pub locktag_field3: uint32,
    pub locktag_field4: uint16,
    pub locktag_type: uint8,
    pub locktag_lockmethodid: uint8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCK {
    pub tag: LOCKTAG,
    pub grantMask: LOCKMASK,
    pub waitMask: LOCKMASK,
    pub procLocks: SHM_QUEUE,
    pub waitProcs: PROC_QUEUE,
    pub requested: [::std::os::raw::c_int; 10usize],
    pub nRequested: ::std::os::raw::c_int,
    pub granted: [::std::os::raw::c_int; 10usize],
    pub nGranted: ::std::os::raw::c_int,
}
impl Default for LOCK {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROCLOCKTAG {
    pub myLock: *mut LOCK,
    pub myProc: *mut PGPROC,
}
impl Default for PROCLOCKTAG {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROCLOCK {
    pub tag: PROCLOCKTAG,
    pub groupLeader: *mut PGPROC,
    pub holdMask: LOCKMASK,
    pub releaseMask: LOCKMASK,
    pub lockLink: SHM_QUEUE,
    pub procLink: SHM_QUEUE,
}
impl Default for PROCLOCK {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LOCALLOCKTAG {
    pub lock: LOCKTAG,
    pub mode: LOCKMODE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCALLOCKOWNER {
    pub owner: *mut ResourceOwnerData,
    pub nLocks: int64,
}
impl Default for LOCALLOCKOWNER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCALLOCK {
    pub tag: LOCALLOCKTAG,
    pub lock: *mut LOCK,
    pub proclock: *mut PROCLOCK,
    pub hashcode: uint32,
    pub nLocks: int64,
    pub numLockOwners: ::std::os::raw::c_int,
    pub maxLockOwners: ::std::os::raw::c_int,
    pub holdsStrongLockCount: bool,
    pub lockCleared: bool,
    pub lockOwners: *mut LOCALLOCKOWNER,
}
impl Default for LOCALLOCK {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LockInstanceData {
    pub locktag: LOCKTAG,
    pub holdMask: LOCKMASK,
    pub waitLockMode: LOCKMODE,
    pub backend: BackendId,
    pub lxid: LocalTransactionId,
    pub pid: ::std::os::raw::c_int,
    pub leaderPid: ::std::os::raw::c_int,
    pub fastpath: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockData {
    pub nelements: ::std::os::raw::c_int,
    pub locks: *mut LockInstanceData,
}
impl Default for LockData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BlockedProcData {
    pub pid: ::std::os::raw::c_int,
    pub first_lock: ::std::os::raw::c_int,
    pub num_locks: ::std::os::raw::c_int,
    pub first_waiter: ::std::os::raw::c_int,
    pub num_waiters: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockedProcsData {
    pub procs: *mut BlockedProcData,
    pub locks: *mut LockInstanceData,
    pub waiter_pids: *mut ::std::os::raw::c_int,
    pub nprocs: ::std::os::raw::c_int,
    pub maxprocs: ::std::os::raw::c_int,
    pub nlocks: ::std::os::raw::c_int,
    pub maxlocks: ::std::os::raw::c_int,
    pub npids: ::std::os::raw::c_int,
    pub maxpids: ::std::os::raw::c_int,
}
impl Default for BlockedProcsData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const LockAcquireResult_LOCKACQUIRE_NOT_AVAIL: LockAcquireResult = 0;
pub const LockAcquireResult_LOCKACQUIRE_OK: LockAcquireResult = 1;
pub const LockAcquireResult_LOCKACQUIRE_ALREADY_HELD: LockAcquireResult = 2;
pub const LockAcquireResult_LOCKACQUIRE_ALREADY_CLEAR: LockAcquireResult = 3;
pub type LockAcquireResult = ::std::os::raw::c_uint;
pub const DeadLockState_DS_NOT_YET_CHECKED: DeadLockState = 0;
pub const DeadLockState_DS_NO_DEADLOCK: DeadLockState = 1;
pub const DeadLockState_DS_SOFT_DEADLOCK: DeadLockState = 2;
pub const DeadLockState_DS_HARD_DEADLOCK: DeadLockState = 3;
pub const DeadLockState_DS_BLOCKED_BY_AUTOVACUUM: DeadLockState = 4;
pub type DeadLockState = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn InitLocks();
}
#[pg_guard]
extern "C" {
    pub fn GetLocksMethodTable(lock: *const LOCK) -> LockMethod;
}
#[pg_guard]
extern "C" {
    pub fn GetLockTagsMethodTable(locktag: *const LOCKTAG) -> LockMethod;
}
#[pg_guard]
extern "C" {
    pub fn LockTagHashCode(locktag: *const LOCKTAG) -> uint32;
}
#[pg_guard]
extern "C" {
    pub fn DoLockModesConflict(mode1: LOCKMODE, mode2: LOCKMODE) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn LockAcquire(
        locktag: *const LOCKTAG,
        lockmode: LOCKMODE,
        sessionLock: bool,
        dontWait: bool,
    ) -> LockAcquireResult;
}
#[pg_guard]
extern "C" {
    pub fn LockAcquireExtended(
        locktag: *const LOCKTAG,
        lockmode: LOCKMODE,
        sessionLock: bool,
        dontWait: bool,
        reportMemoryError: bool,
        locallockp: *mut *mut LOCALLOCK,
    ) -> LockAcquireResult;
}
#[pg_guard]
extern "C" {
    pub fn AbortStrongLockAcquire();
}
#[pg_guard]
extern "C" {
    pub fn MarkLockClear(locallock: *mut LOCALLOCK);
}
#[pg_guard]
extern "C" {
    pub fn LockRelease(locktag: *const LOCKTAG, lockmode: LOCKMODE, sessionLock: bool) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn LockReleaseAll(lockmethodid: LOCKMETHODID, allLocks: bool);
}
#[pg_guard]
extern "C" {
    pub fn LockReleaseSession(lockmethodid: LOCKMETHODID);
}
#[pg_guard]
extern "C" {
    pub fn LockReleaseCurrentOwner(locallocks: *mut *mut LOCALLOCK, nlocks: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn LockReassignCurrentOwner(locallocks: *mut *mut LOCALLOCK, nlocks: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn LockHasWaiters(locktag: *const LOCKTAG, lockmode: LOCKMODE, sessionLock: bool) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetLockConflicts(
        locktag: *const LOCKTAG,
        lockmode: LOCKMODE,
    ) -> *mut VirtualTransactionId;
}
#[pg_guard]
extern "C" {
    pub fn AtPrepare_Locks();
}
#[pg_guard]
extern "C" {
    pub fn PostPrepare_Locks(xid: TransactionId);
}
#[pg_guard]
extern "C" {
    pub fn LockCheckConflicts(
        lockMethodTable: LockMethod,
        lockmode: LOCKMODE,
        lock: *mut LOCK,
        proclock: *mut PROCLOCK,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn GrantLock(lock: *mut LOCK, proclock: *mut PROCLOCK, lockmode: LOCKMODE);
}
#[pg_guard]
extern "C" {
    pub fn GrantAwaitedLock();
}
#[pg_guard]
extern "C" {
    pub fn RemoveFromWaitQueue(proc_: *mut PGPROC, hashcode: uint32);
}
#[pg_guard]
extern "C" {
    pub fn LockShmemSize() -> Size;
}
#[pg_guard]
extern "C" {
    pub fn GetLockStatusData() -> *mut LockData;
}
#[pg_guard]
extern "C" {
    pub fn GetBlockerStatusData(blocked_pid: ::std::os::raw::c_int) -> *mut BlockedProcsData;
}
#[pg_guard]
extern "C" {
    pub fn GetRunningTransactionLocks(nlocks: *mut ::std::os::raw::c_int) -> *mut xl_standby_lock;
}
#[pg_guard]
extern "C" {
    pub fn GetLockmodeName(
        lockmethodid: LOCKMETHODID,
        mode: LOCKMODE,
    ) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn lock_twophase_recover(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pg_guard]
extern "C" {
    pub fn lock_twophase_postcommit(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pg_guard]
extern "C" {
    pub fn lock_twophase_postabort(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pg_guard]
extern "C" {
    pub fn lock_twophase_standby_recover(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pg_guard]
extern "C" {
    pub fn DeadLockCheck(proc_: *mut PGPROC) -> DeadLockState;
}
#[pg_guard]
extern "C" {
    pub fn GetBlockingAutoVacuumPgproc() -> *mut PGPROC;
}
#[pg_guard]
extern "C" {
    pub fn DeadLockReport();
}
#[pg_guard]
extern "C" {
    pub fn RememberSimpleDeadLock(
        proc1: *mut PGPROC,
        lockmode: LOCKMODE,
        lock: *mut LOCK,
        proc2: *mut PGPROC,
    );
}
#[pg_guard]
extern "C" {
    pub fn InitDeadLockChecking();
}
#[pg_guard]
extern "C" {
    pub fn LockWaiterCount(locktag: *const LOCKTAG) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn VirtualXactLockTableInsert(vxid: VirtualTransactionId);
}
#[pg_guard]
extern "C" {
    pub fn VirtualXactLockTableCleanup();
}
#[pg_guard]
extern "C" {
    pub fn VirtualXactLock(vxid: VirtualTransactionId, wait: bool) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGSemaphoreData {
    _unused: [u8; 0],
}
pub type PGSemaphore = *mut PGSemaphoreData;
#[pg_guard]
extern "C" {
    pub fn PGSemaphoreShmemSize(maxSemas: ::std::os::raw::c_int) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn PGReserveSemaphores(maxSemas: ::std::os::raw::c_int, port: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn PGSemaphoreCreate() -> PGSemaphore;
}
#[pg_guard]
extern "C" {
    pub fn PGSemaphoreReset(sema: PGSemaphore);
}
#[pg_guard]
extern "C" {
    pub fn PGSemaphoreLock(sema: PGSemaphore);
}
#[pg_guard]
extern "C" {
    pub fn PGSemaphoreUnlock(sema: PGSemaphore);
}
#[pg_guard]
extern "C" {
    pub fn PGSemaphoreTryLock(sema: PGSemaphore) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XidCache {
    pub xids: [TransactionId; 64usize],
}
impl Default for XidCache {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGPROC {
    pub links: SHM_QUEUE,
    pub procgloballist: *mut *mut PGPROC,
    pub sem: PGSemaphore,
    pub waitStatus: ::std::os::raw::c_int,
    pub procLatch: Latch,
    pub lxid: LocalTransactionId,
    pub pid: ::std::os::raw::c_int,
    pub pgprocno: ::std::os::raw::c_int,
    pub backendId: BackendId,
    pub databaseId: Oid,
    pub roleId: Oid,
    pub isBackgroundWorker: bool,
    pub recoveryConflictPending: bool,
    pub lwWaiting: bool,
    pub lwWaitMode: uint8,
    pub lwWaitLink: proclist_node,
    pub cvWaitLink: proclist_node,
    pub waitLock: *mut LOCK,
    pub waitProcLock: *mut PROCLOCK,
    pub waitLockMode: LOCKMODE,
    pub heldLocks: LOCKMASK,
    pub waitLSN: XLogRecPtr,
    pub syncRepState: ::std::os::raw::c_int,
    pub syncRepLinks: SHM_QUEUE,
    pub myProcLocks: [SHM_QUEUE; 16usize],
    pub subxids: XidCache,
    pub procArrayGroupMember: bool,
    pub procArrayGroupNext: pg_atomic_uint32,
    pub procArrayGroupMemberXid: TransactionId,
    pub wait_event_info: uint32,
    pub backendLock: LWLock,
    pub fpLockBits: uint64,
    pub fpRelId: [Oid; 16usize],
    pub fpVXIDLock: bool,
    pub fpLocalTransactionId: LocalTransactionId,
    pub lockGroupLeader: *mut PGPROC,
    pub lockGroupMembers: dlist_head,
    pub lockGroupLink: dlist_node,
}
impl Default for PGPROC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut MyProc: *mut PGPROC;
}
#[pg_guard]
extern "C" {
    pub static mut MyPgXact: *mut PGXACT;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PGXACT {
    pub xid: TransactionId,
    pub xmin: TransactionId,
    pub vacuumFlags: uint8,
    pub overflowed: bool,
    pub delayChkpt: bool,
    pub nxids: uint8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROC_HDR {
    pub allProcs: *mut PGPROC,
    pub allPgXact: *mut PGXACT,
    pub allProcCount: uint32,
    pub freeProcs: *mut PGPROC,
    pub autovacFreeProcs: *mut PGPROC,
    pub bgworkerFreeProcs: *mut PGPROC,
    pub procArrayGroupFirst: pg_atomic_uint32,
    pub walwriterLatch: *mut Latch,
    pub checkpointerLatch: *mut Latch,
    pub spins_per_delay: ::std::os::raw::c_int,
    pub startupProc: *mut PGPROC,
    pub startupProcPid: ::std::os::raw::c_int,
    pub startupBufferPinWaitBufId: ::std::os::raw::c_int,
}
impl Default for PROC_HDR {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut ProcGlobal: *mut PROC_HDR;
}
#[pg_guard]
extern "C" {
    pub static mut PreparedXactProcs: *mut PGPROC;
}
#[pg_guard]
extern "C" {
    pub static mut DeadlockTimeout: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut StatementTimeout: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut LockTimeout: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut IdleInTransactionSessionTimeout: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut log_lock_waits: bool;
}
#[pg_guard]
extern "C" {
    pub fn ProcGlobalSemas() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ProcGlobalShmemSize() -> Size;
}
#[pg_guard]
extern "C" {
    pub fn InitProcGlobal();
}
#[pg_guard]
extern "C" {
    pub fn InitProcess();
}
#[pg_guard]
extern "C" {
    pub fn InitProcessPhase2();
}
#[pg_guard]
extern "C" {
    pub fn InitAuxiliaryProcess();
}
#[pg_guard]
extern "C" {
    pub fn PublishStartupProcessInformation();
}
#[pg_guard]
extern "C" {
    pub fn SetStartupBufferPinWaitBufId(bufid: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn GetStartupBufferPinWaitBufId() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn HaveNFreeProcs(n: ::std::os::raw::c_int) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ProcReleaseLocks(isCommit: bool);
}
#[pg_guard]
extern "C" {
    pub fn ProcQueueInit(queue: *mut PROC_QUEUE);
}
#[pg_guard]
extern "C" {
    pub fn ProcSleep(
        locallock: *mut LOCALLOCK,
        lockMethodTable: LockMethod,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ProcWakeup(proc_: *mut PGPROC, waitStatus: ::std::os::raw::c_int) -> *mut PGPROC;
}
#[pg_guard]
extern "C" {
    pub fn ProcLockWakeup(lockMethodTable: LockMethod, lock: *mut LOCK);
}
#[pg_guard]
extern "C" {
    pub fn CheckDeadLockAlert();
}
#[pg_guard]
extern "C" {
    pub fn IsWaitingForLock() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn LockErrorCleanup();
}
#[pg_guard]
extern "C" {
    pub fn ProcWaitForSignal(wait_event_info: uint32);
}
#[pg_guard]
extern "C" {
    pub fn ProcSendSignal(pid: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn AuxiliaryPidGetProc(pid: ::std::os::raw::c_int) -> *mut PGPROC;
}
#[pg_guard]
extern "C" {
    pub fn BecomeLockGroupLeader();
}
#[pg_guard]
extern "C" {
    pub fn BecomeLockGroupMember(leader: *mut PGPROC, pid: ::std::os::raw::c_int) -> bool;
}
pub const TrackFunctionsLevel_TRACK_FUNC_OFF: TrackFunctionsLevel = 0;
pub const TrackFunctionsLevel_TRACK_FUNC_PL: TrackFunctionsLevel = 1;
pub const TrackFunctionsLevel_TRACK_FUNC_ALL: TrackFunctionsLevel = 2;
pub type TrackFunctionsLevel = ::std::os::raw::c_uint;
pub const StatMsgType_PGSTAT_MTYPE_DUMMY: StatMsgType = 0;
pub const StatMsgType_PGSTAT_MTYPE_INQUIRY: StatMsgType = 1;
pub const StatMsgType_PGSTAT_MTYPE_TABSTAT: StatMsgType = 2;
pub const StatMsgType_PGSTAT_MTYPE_TABPURGE: StatMsgType = 3;
pub const StatMsgType_PGSTAT_MTYPE_DROPDB: StatMsgType = 4;
pub const StatMsgType_PGSTAT_MTYPE_RESETCOUNTER: StatMsgType = 5;
pub const StatMsgType_PGSTAT_MTYPE_RESETSHAREDCOUNTER: StatMsgType = 6;
pub const StatMsgType_PGSTAT_MTYPE_RESETSINGLECOUNTER: StatMsgType = 7;
pub const StatMsgType_PGSTAT_MTYPE_AUTOVAC_START: StatMsgType = 8;
pub const StatMsgType_PGSTAT_MTYPE_VACUUM: StatMsgType = 9;
pub const StatMsgType_PGSTAT_MTYPE_ANALYZE: StatMsgType = 10;
pub const StatMsgType_PGSTAT_MTYPE_ARCHIVER: StatMsgType = 11;
pub const StatMsgType_PGSTAT_MTYPE_BGWRITER: StatMsgType = 12;
pub const StatMsgType_PGSTAT_MTYPE_FUNCSTAT: StatMsgType = 13;
pub const StatMsgType_PGSTAT_MTYPE_FUNCPURGE: StatMsgType = 14;
pub const StatMsgType_PGSTAT_MTYPE_RECOVERYCONFLICT: StatMsgType = 15;
pub const StatMsgType_PGSTAT_MTYPE_TEMPFILE: StatMsgType = 16;
pub const StatMsgType_PGSTAT_MTYPE_DEADLOCK: StatMsgType = 17;
pub type StatMsgType = ::std::os::raw::c_uint;
pub type PgStat_Counter = int64;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_TableCounts {
    pub t_numscans: PgStat_Counter,
    pub t_tuples_returned: PgStat_Counter,
    pub t_tuples_fetched: PgStat_Counter,
    pub t_tuples_inserted: PgStat_Counter,
    pub t_tuples_updated: PgStat_Counter,
    pub t_tuples_deleted: PgStat_Counter,
    pub t_tuples_hot_updated: PgStat_Counter,
    pub t_truncated: bool,
    pub t_delta_live_tuples: PgStat_Counter,
    pub t_delta_dead_tuples: PgStat_Counter,
    pub t_changed_tuples: PgStat_Counter,
    pub t_blocks_fetched: PgStat_Counter,
    pub t_blocks_hit: PgStat_Counter,
}
pub const PgStat_Shared_Reset_Target_RESET_ARCHIVER: PgStat_Shared_Reset_Target = 0;
pub const PgStat_Shared_Reset_Target_RESET_BGWRITER: PgStat_Shared_Reset_Target = 1;
pub type PgStat_Shared_Reset_Target = ::std::os::raw::c_uint;
pub const PgStat_Single_Reset_Type_RESET_TABLE: PgStat_Single_Reset_Type = 0;
pub const PgStat_Single_Reset_Type_RESET_FUNCTION: PgStat_Single_Reset_Type = 1;
pub type PgStat_Single_Reset_Type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_TableStatus {
    pub t_id: Oid,
    pub t_shared: bool,
    pub trans: *mut PgStat_TableXactStatus,
    pub t_counts: PgStat_TableCounts,
}
impl Default for PgStat_TableStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_TableXactStatus {
    pub tuples_inserted: PgStat_Counter,
    pub tuples_updated: PgStat_Counter,
    pub tuples_deleted: PgStat_Counter,
    pub truncated: bool,
    pub inserted_pre_trunc: PgStat_Counter,
    pub updated_pre_trunc: PgStat_Counter,
    pub deleted_pre_trunc: PgStat_Counter,
    pub nest_level: ::std::os::raw::c_int,
    pub upper: *mut PgStat_TableXactStatus,
    pub parent: *mut PgStat_TableStatus,
    pub next: *mut PgStat_TableXactStatus,
}
impl Default for PgStat_TableXactStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgHdr {
    pub m_type: StatMsgType,
    pub m_size: ::std::os::raw::c_int,
}
impl Default for PgStat_MsgHdr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgDummy {
    pub m_hdr: PgStat_MsgHdr,
}
impl Default for PgStat_MsgDummy {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgInquiry {
    pub m_hdr: PgStat_MsgHdr,
    pub clock_time: TimestampTz,
    pub cutoff_time: TimestampTz,
    pub databaseid: Oid,
}
impl Default for PgStat_MsgInquiry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_TableEntry {
    pub t_id: Oid,
    pub t_counts: PgStat_TableCounts,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgTabstat {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_xact_commit: ::std::os::raw::c_int,
    pub m_xact_rollback: ::std::os::raw::c_int,
    pub m_block_read_time: PgStat_Counter,
    pub m_block_write_time: PgStat_Counter,
    pub m_entry: [PgStat_TableEntry; 8usize],
}
impl Default for PgStat_MsgTabstat {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgTabpurge {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_tableid: [Oid; 246usize],
}
impl Default for PgStat_MsgTabpurge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgDropdb {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
}
impl Default for PgStat_MsgDropdb {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetcounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
}
impl Default for PgStat_MsgResetcounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetsharedcounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_resettarget: PgStat_Shared_Reset_Target,
}
impl Default for PgStat_MsgResetsharedcounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetsinglecounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_resettype: PgStat_Single_Reset_Type,
    pub m_objectid: Oid,
}
impl Default for PgStat_MsgResetsinglecounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgAutovacStart {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_start_time: TimestampTz,
}
impl Default for PgStat_MsgAutovacStart {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgVacuum {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_tableoid: Oid,
    pub m_autovacuum: bool,
    pub m_vacuumtime: TimestampTz,
    pub m_live_tuples: PgStat_Counter,
    pub m_dead_tuples: PgStat_Counter,
}
impl Default for PgStat_MsgVacuum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgAnalyze {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_tableoid: Oid,
    pub m_autovacuum: bool,
    pub m_resetcounter: bool,
    pub m_analyzetime: TimestampTz,
    pub m_live_tuples: PgStat_Counter,
    pub m_dead_tuples: PgStat_Counter,
}
impl Default for PgStat_MsgAnalyze {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgArchiver {
    pub m_hdr: PgStat_MsgHdr,
    pub m_failed: bool,
    pub m_xlog: [::std::os::raw::c_char; 41usize],
    pub m_timestamp: TimestampTz,
}
impl Default for PgStat_MsgArchiver {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgBgWriter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_timed_checkpoints: PgStat_Counter,
    pub m_requested_checkpoints: PgStat_Counter,
    pub m_buf_written_checkpoints: PgStat_Counter,
    pub m_buf_written_clean: PgStat_Counter,
    pub m_maxwritten_clean: PgStat_Counter,
    pub m_buf_written_backend: PgStat_Counter,
    pub m_buf_fsync_backend: PgStat_Counter,
    pub m_buf_alloc: PgStat_Counter,
    pub m_checkpoint_write_time: PgStat_Counter,
    pub m_checkpoint_sync_time: PgStat_Counter,
}
impl Default for PgStat_MsgBgWriter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgRecoveryConflict {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_reason: ::std::os::raw::c_int,
}
impl Default for PgStat_MsgRecoveryConflict {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgTempFile {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_filesize: usize,
}
impl Default for PgStat_MsgTempFile {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_FunctionCounts {
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: instr_time,
    pub f_self_time: instr_time,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_BackendFunctionEntry {
    pub f_id: Oid,
    pub f_counts: PgStat_FunctionCounts,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_FunctionEntry {
    pub f_id: Oid,
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: PgStat_Counter,
    pub f_self_time: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgFuncstat {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_entry: [PgStat_FunctionEntry; 30usize],
}
impl Default for PgStat_MsgFuncstat {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgFuncpurge {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_functionid: [Oid; 246usize],
}
impl Default for PgStat_MsgFuncpurge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgDeadlock {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
}
impl Default for PgStat_MsgDeadlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PgStat_Msg {
    pub msg_hdr: PgStat_MsgHdr,
    pub msg_dummy: PgStat_MsgDummy,
    pub msg_inquiry: PgStat_MsgInquiry,
    pub msg_tabstat: PgStat_MsgTabstat,
    pub msg_tabpurge: PgStat_MsgTabpurge,
    pub msg_dropdb: PgStat_MsgDropdb,
    pub msg_resetcounter: PgStat_MsgResetcounter,
    pub msg_resetsharedcounter: PgStat_MsgResetsharedcounter,
    pub msg_resetsinglecounter: PgStat_MsgResetsinglecounter,
    pub msg_autovacuum: PgStat_MsgAutovacStart,
    pub msg_vacuum: PgStat_MsgVacuum,
    pub msg_analyze: PgStat_MsgAnalyze,
    pub msg_archiver: PgStat_MsgArchiver,
    pub msg_bgwriter: PgStat_MsgBgWriter,
    pub msg_funcstat: PgStat_MsgFuncstat,
    pub msg_funcpurge: PgStat_MsgFuncpurge,
    pub msg_recoveryconflict: PgStat_MsgRecoveryConflict,
    pub msg_deadlock: PgStat_MsgDeadlock,
}
impl Default for PgStat_Msg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_StatDBEntry {
    pub databaseid: Oid,
    pub n_xact_commit: PgStat_Counter,
    pub n_xact_rollback: PgStat_Counter,
    pub n_blocks_fetched: PgStat_Counter,
    pub n_blocks_hit: PgStat_Counter,
    pub n_tuples_returned: PgStat_Counter,
    pub n_tuples_fetched: PgStat_Counter,
    pub n_tuples_inserted: PgStat_Counter,
    pub n_tuples_updated: PgStat_Counter,
    pub n_tuples_deleted: PgStat_Counter,
    pub last_autovac_time: TimestampTz,
    pub n_conflict_tablespace: PgStat_Counter,
    pub n_conflict_lock: PgStat_Counter,
    pub n_conflict_snapshot: PgStat_Counter,
    pub n_conflict_bufferpin: PgStat_Counter,
    pub n_conflict_startup_deadlock: PgStat_Counter,
    pub n_temp_files: PgStat_Counter,
    pub n_temp_bytes: PgStat_Counter,
    pub n_deadlocks: PgStat_Counter,
    pub n_block_read_time: PgStat_Counter,
    pub n_block_write_time: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
    pub stats_timestamp: TimestampTz,
    pub tables: *mut HTAB,
    pub functions: *mut HTAB,
}
impl Default for PgStat_StatDBEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_StatTabEntry {
    pub tableid: Oid,
    pub numscans: PgStat_Counter,
    pub tuples_returned: PgStat_Counter,
    pub tuples_fetched: PgStat_Counter,
    pub tuples_inserted: PgStat_Counter,
    pub tuples_updated: PgStat_Counter,
    pub tuples_deleted: PgStat_Counter,
    pub tuples_hot_updated: PgStat_Counter,
    pub n_live_tuples: PgStat_Counter,
    pub n_dead_tuples: PgStat_Counter,
    pub changes_since_analyze: PgStat_Counter,
    pub blocks_fetched: PgStat_Counter,
    pub blocks_hit: PgStat_Counter,
    pub vacuum_timestamp: TimestampTz,
    pub vacuum_count: PgStat_Counter,
    pub autovac_vacuum_timestamp: TimestampTz,
    pub autovac_vacuum_count: PgStat_Counter,
    pub analyze_timestamp: TimestampTz,
    pub analyze_count: PgStat_Counter,
    pub autovac_analyze_timestamp: TimestampTz,
    pub autovac_analyze_count: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_StatFuncEntry {
    pub functionid: Oid,
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: PgStat_Counter,
    pub f_self_time: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_ArchiverStats {
    pub archived_count: PgStat_Counter,
    pub last_archived_wal: [::std::os::raw::c_char; 41usize],
    pub last_archived_timestamp: TimestampTz,
    pub failed_count: PgStat_Counter,
    pub last_failed_wal: [::std::os::raw::c_char; 41usize],
    pub last_failed_timestamp: TimestampTz,
    pub stat_reset_timestamp: TimestampTz,
}
impl Default for PgStat_ArchiverStats {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_GlobalStats {
    pub stats_timestamp: TimestampTz,
    pub timed_checkpoints: PgStat_Counter,
    pub requested_checkpoints: PgStat_Counter,
    pub checkpoint_write_time: PgStat_Counter,
    pub checkpoint_sync_time: PgStat_Counter,
    pub buf_written_checkpoints: PgStat_Counter,
    pub buf_written_clean: PgStat_Counter,
    pub maxwritten_clean: PgStat_Counter,
    pub buf_written_backend: PgStat_Counter,
    pub buf_fsync_backend: PgStat_Counter,
    pub buf_alloc: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
pub const BackendType_B_AUTOVAC_LAUNCHER: BackendType = 0;
pub const BackendType_B_AUTOVAC_WORKER: BackendType = 1;
pub const BackendType_B_BACKEND: BackendType = 2;
pub const BackendType_B_BG_WORKER: BackendType = 3;
pub const BackendType_B_BG_WRITER: BackendType = 4;
pub const BackendType_B_CHECKPOINTER: BackendType = 5;
pub const BackendType_B_STARTUP: BackendType = 6;
pub const BackendType_B_WAL_RECEIVER: BackendType = 7;
pub const BackendType_B_WAL_SENDER: BackendType = 8;
pub const BackendType_B_WAL_WRITER: BackendType = 9;
pub type BackendType = ::std::os::raw::c_uint;
pub const BackendState_STATE_UNDEFINED: BackendState = 0;
pub const BackendState_STATE_IDLE: BackendState = 1;
pub const BackendState_STATE_RUNNING: BackendState = 2;
pub const BackendState_STATE_IDLEINTRANSACTION: BackendState = 3;
pub const BackendState_STATE_FASTPATH: BackendState = 4;
pub const BackendState_STATE_IDLEINTRANSACTION_ABORTED: BackendState = 5;
pub const BackendState_STATE_DISABLED: BackendState = 6;
pub type BackendState = ::std::os::raw::c_uint;
pub const WaitEventActivity_WAIT_EVENT_ARCHIVER_MAIN: WaitEventActivity = 83886080;
pub const WaitEventActivity_WAIT_EVENT_AUTOVACUUM_MAIN: WaitEventActivity = 83886081;
pub const WaitEventActivity_WAIT_EVENT_BGWRITER_HIBERNATE: WaitEventActivity = 83886082;
pub const WaitEventActivity_WAIT_EVENT_BGWRITER_MAIN: WaitEventActivity = 83886083;
pub const WaitEventActivity_WAIT_EVENT_CHECKPOINTER_MAIN: WaitEventActivity = 83886084;
pub const WaitEventActivity_WAIT_EVENT_LOGICAL_LAUNCHER_MAIN: WaitEventActivity = 83886085;
pub const WaitEventActivity_WAIT_EVENT_LOGICAL_APPLY_MAIN: WaitEventActivity = 83886086;
pub const WaitEventActivity_WAIT_EVENT_PGSTAT_MAIN: WaitEventActivity = 83886087;
pub const WaitEventActivity_WAIT_EVENT_RECOVERY_WAL_ALL: WaitEventActivity = 83886088;
pub const WaitEventActivity_WAIT_EVENT_RECOVERY_WAL_STREAM: WaitEventActivity = 83886089;
pub const WaitEventActivity_WAIT_EVENT_SYSLOGGER_MAIN: WaitEventActivity = 83886090;
pub const WaitEventActivity_WAIT_EVENT_WAL_RECEIVER_MAIN: WaitEventActivity = 83886091;
pub const WaitEventActivity_WAIT_EVENT_WAL_SENDER_MAIN: WaitEventActivity = 83886092;
pub const WaitEventActivity_WAIT_EVENT_WAL_WRITER_MAIN: WaitEventActivity = 83886093;
pub type WaitEventActivity = ::std::os::raw::c_uint;
pub const WaitEventClient_WAIT_EVENT_CLIENT_READ: WaitEventClient = 100663296;
pub const WaitEventClient_WAIT_EVENT_CLIENT_WRITE: WaitEventClient = 100663297;
pub const WaitEventClient_WAIT_EVENT_LIBPQWALRECEIVER_CONNECT: WaitEventClient = 100663298;
pub const WaitEventClient_WAIT_EVENT_LIBPQWALRECEIVER_RECEIVE: WaitEventClient = 100663299;
pub const WaitEventClient_WAIT_EVENT_SSL_OPEN_SERVER: WaitEventClient = 100663300;
pub const WaitEventClient_WAIT_EVENT_WAL_RECEIVER_WAIT_START: WaitEventClient = 100663301;
pub const WaitEventClient_WAIT_EVENT_WAL_SENDER_WAIT_WAL: WaitEventClient = 100663302;
pub const WaitEventClient_WAIT_EVENT_WAL_SENDER_WRITE_DATA: WaitEventClient = 100663303;
pub type WaitEventClient = ::std::os::raw::c_uint;
pub const WaitEventIPC_WAIT_EVENT_BGWORKER_SHUTDOWN: WaitEventIPC = 134217728;
pub const WaitEventIPC_WAIT_EVENT_BGWORKER_STARTUP: WaitEventIPC = 134217729;
pub const WaitEventIPC_WAIT_EVENT_BTREE_PAGE: WaitEventIPC = 134217730;
pub const WaitEventIPC_WAIT_EVENT_EXECUTE_GATHER: WaitEventIPC = 134217731;
pub const WaitEventIPC_WAIT_EVENT_LOGICAL_SYNC_DATA: WaitEventIPC = 134217732;
pub const WaitEventIPC_WAIT_EVENT_LOGICAL_SYNC_STATE_CHANGE: WaitEventIPC = 134217733;
pub const WaitEventIPC_WAIT_EVENT_MQ_INTERNAL: WaitEventIPC = 134217734;
pub const WaitEventIPC_WAIT_EVENT_MQ_PUT_MESSAGE: WaitEventIPC = 134217735;
pub const WaitEventIPC_WAIT_EVENT_MQ_RECEIVE: WaitEventIPC = 134217736;
pub const WaitEventIPC_WAIT_EVENT_MQ_SEND: WaitEventIPC = 134217737;
pub const WaitEventIPC_WAIT_EVENT_PARALLEL_FINISH: WaitEventIPC = 134217738;
pub const WaitEventIPC_WAIT_EVENT_PARALLEL_BITMAP_SCAN: WaitEventIPC = 134217739;
pub const WaitEventIPC_WAIT_EVENT_PROCARRAY_GROUP_UPDATE: WaitEventIPC = 134217740;
pub const WaitEventIPC_WAIT_EVENT_REPLICATION_ORIGIN_DROP: WaitEventIPC = 134217741;
pub const WaitEventIPC_WAIT_EVENT_REPLICATION_SLOT_DROP: WaitEventIPC = 134217742;
pub const WaitEventIPC_WAIT_EVENT_SAFE_SNAPSHOT: WaitEventIPC = 134217743;
pub const WaitEventIPC_WAIT_EVENT_SYNC_REP: WaitEventIPC = 134217744;
pub type WaitEventIPC = ::std::os::raw::c_uint;
pub const WaitEventTimeout_WAIT_EVENT_BASE_BACKUP_THROTTLE: WaitEventTimeout = 150994944;
pub const WaitEventTimeout_WAIT_EVENT_PG_SLEEP: WaitEventTimeout = 150994945;
pub const WaitEventTimeout_WAIT_EVENT_RECOVERY_APPLY_DELAY: WaitEventTimeout = 150994946;
pub type WaitEventTimeout = ::std::os::raw::c_uint;
pub const WaitEventIO_WAIT_EVENT_BUFFILE_READ: WaitEventIO = 167772160;
pub const WaitEventIO_WAIT_EVENT_BUFFILE_WRITE: WaitEventIO = 167772161;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_READ: WaitEventIO = 167772162;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_SYNC: WaitEventIO = 167772163;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_SYNC_UPDATE: WaitEventIO = 167772164;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_WRITE: WaitEventIO = 167772165;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_WRITE_UPDATE: WaitEventIO = 167772166;
pub const WaitEventIO_WAIT_EVENT_COPY_FILE_READ: WaitEventIO = 167772167;
pub const WaitEventIO_WAIT_EVENT_COPY_FILE_WRITE: WaitEventIO = 167772168;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_EXTEND: WaitEventIO = 167772169;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_FLUSH: WaitEventIO = 167772170;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_IMMEDIATE_SYNC: WaitEventIO = 167772171;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_PREFETCH: WaitEventIO = 167772172;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_READ: WaitEventIO = 167772173;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_SYNC: WaitEventIO = 167772174;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_TRUNCATE: WaitEventIO = 167772175;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_WRITE: WaitEventIO = 167772176;
pub const WaitEventIO_WAIT_EVENT_DSM_FILL_ZERO_WRITE: WaitEventIO = 167772177;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_ADDTODATADIR_READ: WaitEventIO = 167772178;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_ADDTODATADIR_SYNC: WaitEventIO = 167772179;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_ADDTODATADIR_WRITE: WaitEventIO = 167772180;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_CREATE_READ: WaitEventIO = 167772181;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_CREATE_SYNC: WaitEventIO = 167772182;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_CREATE_WRITE: WaitEventIO = 167772183;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_RECHECKDATADIR_READ: WaitEventIO = 167772184;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_CHECKPOINT_SYNC: WaitEventIO = 167772185;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_MAPPING_SYNC: WaitEventIO = 167772186;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_MAPPING_WRITE: WaitEventIO = 167772187;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_SYNC: WaitEventIO = 167772188;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_TRUNCATE: WaitEventIO = 167772189;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_WRITE: WaitEventIO = 167772190;
pub const WaitEventIO_WAIT_EVENT_RELATION_MAP_READ: WaitEventIO = 167772191;
pub const WaitEventIO_WAIT_EVENT_RELATION_MAP_SYNC: WaitEventIO = 167772192;
pub const WaitEventIO_WAIT_EVENT_RELATION_MAP_WRITE: WaitEventIO = 167772193;
pub const WaitEventIO_WAIT_EVENT_REORDER_BUFFER_READ: WaitEventIO = 167772194;
pub const WaitEventIO_WAIT_EVENT_REORDER_BUFFER_WRITE: WaitEventIO = 167772195;
pub const WaitEventIO_WAIT_EVENT_REORDER_LOGICAL_MAPPING_READ: WaitEventIO = 167772196;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_READ: WaitEventIO = 167772197;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_RESTORE_SYNC: WaitEventIO = 167772198;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_SYNC: WaitEventIO = 167772199;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_WRITE: WaitEventIO = 167772200;
pub const WaitEventIO_WAIT_EVENT_SLRU_FLUSH_SYNC: WaitEventIO = 167772201;
pub const WaitEventIO_WAIT_EVENT_SLRU_READ: WaitEventIO = 167772202;
pub const WaitEventIO_WAIT_EVENT_SLRU_SYNC: WaitEventIO = 167772203;
pub const WaitEventIO_WAIT_EVENT_SLRU_WRITE: WaitEventIO = 167772204;
pub const WaitEventIO_WAIT_EVENT_SNAPBUILD_READ: WaitEventIO = 167772205;
pub const WaitEventIO_WAIT_EVENT_SNAPBUILD_SYNC: WaitEventIO = 167772206;
pub const WaitEventIO_WAIT_EVENT_SNAPBUILD_WRITE: WaitEventIO = 167772207;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_FILE_SYNC: WaitEventIO = 167772208;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_FILE_WRITE: WaitEventIO = 167772209;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_READ: WaitEventIO = 167772210;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_SYNC: WaitEventIO = 167772211;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_WRITE: WaitEventIO = 167772212;
pub const WaitEventIO_WAIT_EVENT_TWOPHASE_FILE_READ: WaitEventIO = 167772213;
pub const WaitEventIO_WAIT_EVENT_TWOPHASE_FILE_SYNC: WaitEventIO = 167772214;
pub const WaitEventIO_WAIT_EVENT_TWOPHASE_FILE_WRITE: WaitEventIO = 167772215;
pub const WaitEventIO_WAIT_EVENT_WALSENDER_TIMELINE_HISTORY_READ: WaitEventIO = 167772216;
pub const WaitEventIO_WAIT_EVENT_WAL_BOOTSTRAP_SYNC: WaitEventIO = 167772217;
pub const WaitEventIO_WAIT_EVENT_WAL_BOOTSTRAP_WRITE: WaitEventIO = 167772218;
pub const WaitEventIO_WAIT_EVENT_WAL_COPY_READ: WaitEventIO = 167772219;
pub const WaitEventIO_WAIT_EVENT_WAL_COPY_SYNC: WaitEventIO = 167772220;
pub const WaitEventIO_WAIT_EVENT_WAL_COPY_WRITE: WaitEventIO = 167772221;
pub const WaitEventIO_WAIT_EVENT_WAL_INIT_SYNC: WaitEventIO = 167772222;
pub const WaitEventIO_WAIT_EVENT_WAL_INIT_WRITE: WaitEventIO = 167772223;
pub const WaitEventIO_WAIT_EVENT_WAL_READ: WaitEventIO = 167772224;
pub const WaitEventIO_WAIT_EVENT_WAL_SYNC_METHOD_ASSIGN: WaitEventIO = 167772225;
pub const WaitEventIO_WAIT_EVENT_WAL_WRITE: WaitEventIO = 167772226;
pub type WaitEventIO = ::std::os::raw::c_uint;
pub const ProgressCommandType_PROGRESS_COMMAND_INVALID: ProgressCommandType = 0;
pub const ProgressCommandType_PROGRESS_COMMAND_VACUUM: ProgressCommandType = 1;
pub type ProgressCommandType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendSSLStatus {
    pub ssl_bits: ::std::os::raw::c_int,
    pub ssl_compression: bool,
    pub ssl_version: [::std::os::raw::c_char; 64usize],
    pub ssl_cipher: [::std::os::raw::c_char; 64usize],
    pub ssl_clientdn: [::std::os::raw::c_char; 64usize],
}
impl Default for PgBackendSSLStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendStatus {
    pub st_changecount: ::std::os::raw::c_int,
    pub st_procpid: ::std::os::raw::c_int,
    pub st_backendType: BackendType,
    pub st_proc_start_timestamp: TimestampTz,
    pub st_xact_start_timestamp: TimestampTz,
    pub st_activity_start_timestamp: TimestampTz,
    pub st_state_start_timestamp: TimestampTz,
    pub st_databaseid: Oid,
    pub st_userid: Oid,
    pub st_clientaddr: SockAddr,
    pub st_clienthostname: *mut ::std::os::raw::c_char,
    pub st_ssl: bool,
    pub st_sslstatus: *mut PgBackendSSLStatus,
    pub st_state: BackendState,
    pub st_appname: *mut ::std::os::raw::c_char,
    pub st_activity: *mut ::std::os::raw::c_char,
    pub st_progress_command: ProgressCommandType,
    pub st_progress_command_target: Oid,
    pub st_progress_param: [int64; 10usize],
}
impl Default for PgBackendStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LocalPgBackendStatus {
    pub backendStatus: PgBackendStatus,
    pub backend_xid: TransactionId,
    pub backend_xmin: TransactionId,
}
impl Default for LocalPgBackendStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_FunctionCallUsage {
    pub fs: *mut PgStat_FunctionCounts,
    pub save_f_total_time: instr_time,
    pub save_total: instr_time,
    pub f_start: instr_time,
}
impl Default for PgStat_FunctionCallUsage {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut pgstat_track_activities: bool;
}
#[pg_guard]
extern "C" {
    pub static mut pgstat_track_counts: bool;
}
#[pg_guard]
extern "C" {
    pub static mut pgstat_track_functions: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut pgstat_track_activity_query_size: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut pgstat_stat_directory: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub static mut pgstat_stat_tmpname: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub static mut pgstat_stat_filename: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub static mut BgWriterStats: PgStat_MsgBgWriter;
}
#[pg_guard]
extern "C" {
    pub static mut pgStatBlockReadTime: PgStat_Counter;
}
#[pg_guard]
extern "C" {
    pub static mut pgStatBlockWriteTime: PgStat_Counter;
}
#[pg_guard]
extern "C" {
    pub fn BackendStatusShmemSize() -> Size;
}
#[pg_guard]
extern "C" {
    pub fn CreateSharedBackendStatus();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_init();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_start() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_reset_all();
}
#[pg_guard]
extern "C" {
    pub fn allow_immediate_pgstat_restart();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_ping();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_report_stat(force: bool);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_vacuum_stat();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_drop_database(databaseid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_clear_snapshot();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_reset_counters();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_reset_shared_counters(arg1: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_reset_single_counter(objectid: Oid, type_: PgStat_Single_Reset_Type);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_report_autovac(dboid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_report_vacuum(
        tableoid: Oid,
        shared: bool,
        livetuples: PgStat_Counter,
        deadtuples: PgStat_Counter,
    );
}
#[pg_guard]
extern "C" {
    pub fn pgstat_report_analyze(
        rel: Relation,
        livetuples: PgStat_Counter,
        deadtuples: PgStat_Counter,
        resetcounter: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn pgstat_report_recovery_conflict(reason: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_report_deadlock();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_initialize();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_bestart();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_report_activity(state: BackendState, cmd_str: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_report_tempfile(filesize: usize);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_report_appname(appname: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_report_xact_timestamp(tstamp: TimestampTz);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_get_wait_event(wait_event_info: uint32) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_get_wait_event_type(wait_event_info: uint32) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_get_backend_current_activity(
        pid: ::std::os::raw::c_int,
        checkUser: bool,
    ) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_get_crashed_backend_activity(
        pid: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_char,
        buflen: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_get_backend_desc(backendType: BackendType) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_progress_start_command(cmdtype: ProgressCommandType, relid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_progress_update_param(index: ::std::os::raw::c_int, val: int64);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_progress_update_multi_param(
        nparam: ::std::os::raw::c_int,
        index: *const ::std::os::raw::c_int,
        val: *const int64,
    );
}
#[pg_guard]
extern "C" {
    pub fn pgstat_progress_end_command();
}
#[pg_guard]
extern "C" {
    pub fn find_tabstat_entry(rel_id: Oid) -> *mut PgStat_TableStatus;
}
#[pg_guard]
extern "C" {
    pub fn find_funcstat_entry(func_id: Oid) -> *mut PgStat_BackendFunctionEntry;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_initstats(rel: Relation);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_count_heap_insert(rel: Relation, n: PgStat_Counter);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_count_heap_update(rel: Relation, hot: bool);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_count_heap_delete(rel: Relation);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_count_truncate(rel: Relation);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_update_heap_dead_tuples(rel: Relation, delta: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_init_function_usage(
        fcinfo: *mut FunctionCallInfoData,
        fcu: *mut PgStat_FunctionCallUsage,
    );
}
#[pg_guard]
extern "C" {
    pub fn pgstat_end_function_usage(fcu: *mut PgStat_FunctionCallUsage, finalize: bool);
}
#[pg_guard]
extern "C" {
    pub fn AtEOXact_PgStat(isCommit: bool, parallel: bool);
}
#[pg_guard]
extern "C" {
    pub fn AtEOSubXact_PgStat(isCommit: bool, nestDepth: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn AtPrepare_PgStat();
}
#[pg_guard]
extern "C" {
    pub fn PostPrepare_PgStat();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_twophase_postcommit(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pg_guard]
extern "C" {
    pub fn pgstat_twophase_postabort(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pg_guard]
extern "C" {
    pub fn pgstat_send_archiver(xlog: *const ::std::os::raw::c_char, failed: bool);
}
#[pg_guard]
extern "C" {
    pub fn pgstat_send_bgwriter();
}
#[pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_dbentry(dbid: Oid) -> *mut PgStat_StatDBEntry;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_tabentry(relid: Oid) -> *mut PgStat_StatTabEntry;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_beentry(beid: ::std::os::raw::c_int) -> *mut PgBackendStatus;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_local_beentry(
        beid: ::std::os::raw::c_int,
    ) -> *mut LocalPgBackendStatus;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_funcentry(funcid: Oid) -> *mut PgStat_StatFuncEntry;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_numbackends() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_archiver() -> *mut PgStat_ArchiverStats;
}
#[pg_guard]
extern "C" {
    pub fn pgstat_fetch_global() -> *mut PgStat_GlobalStats;
}
pub const IndexAMProperty_AMPROP_UNKNOWN: IndexAMProperty = 0;
pub const IndexAMProperty_AMPROP_ASC: IndexAMProperty = 1;
pub const IndexAMProperty_AMPROP_DESC: IndexAMProperty = 2;
pub const IndexAMProperty_AMPROP_NULLS_FIRST: IndexAMProperty = 3;
pub const IndexAMProperty_AMPROP_NULLS_LAST: IndexAMProperty = 4;
pub const IndexAMProperty_AMPROP_ORDERABLE: IndexAMProperty = 5;
pub const IndexAMProperty_AMPROP_DISTANCE_ORDERABLE: IndexAMProperty = 6;
pub const IndexAMProperty_AMPROP_RETURNABLE: IndexAMProperty = 7;
pub const IndexAMProperty_AMPROP_SEARCH_ARRAY: IndexAMProperty = 8;
pub const IndexAMProperty_AMPROP_SEARCH_NULLS: IndexAMProperty = 9;
pub const IndexAMProperty_AMPROP_CLUSTERABLE: IndexAMProperty = 10;
pub const IndexAMProperty_AMPROP_INDEX_SCAN: IndexAMProperty = 11;
pub const IndexAMProperty_AMPROP_BITMAP_SCAN: IndexAMProperty = 12;
pub const IndexAMProperty_AMPROP_BACKWARD_SCAN: IndexAMProperty = 13;
pub const IndexAMProperty_AMPROP_CAN_ORDER: IndexAMProperty = 14;
pub const IndexAMProperty_AMPROP_CAN_UNIQUE: IndexAMProperty = 15;
pub const IndexAMProperty_AMPROP_CAN_MULTI_COL: IndexAMProperty = 16;
pub const IndexAMProperty_AMPROP_CAN_EXCLUDE: IndexAMProperty = 17;
pub type IndexAMProperty = ::std::os::raw::c_uint;
pub type ambuild_function = ::std::option::Option<
    unsafe extern "C" fn(
        heapRelation: Relation,
        indexRelation: Relation,
        indexInfo: *mut IndexInfo,
    ) -> *mut IndexBuildResult,
>;
pub type ambuildempty_function =
    ::std::option::Option<unsafe extern "C" fn(indexRelation: Relation)>;
pub type aminsert_function = ::std::option::Option<
    unsafe extern "C" fn(
        indexRelation: Relation,
        values: *mut Datum,
        isnull: *mut bool,
        heap_tid: ItemPointer,
        heapRelation: Relation,
        checkUnique: IndexUniqueCheck,
        indexInfo: *mut IndexInfo,
    ) -> bool,
>;
pub type ambulkdelete_function = ::std::option::Option<
    unsafe extern "C" fn(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
        callback: IndexBulkDeleteCallback,
        callback_state: *mut ::std::os::raw::c_void,
    ) -> *mut IndexBulkDeleteResult,
>;
pub type amvacuumcleanup_function = ::std::option::Option<
    unsafe extern "C" fn(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
    ) -> *mut IndexBulkDeleteResult,
>;
pub type amcanreturn_function = ::std::option::Option<
    unsafe extern "C" fn(indexRelation: Relation, attno: ::std::os::raw::c_int) -> bool,
>;
pub type amcostestimate_function = ::std::option::Option<
    unsafe extern "C" fn(
        root: *mut PlannerInfo,
        path: *mut IndexPath,
        loop_count: f64,
        indexStartupCost: *mut Cost,
        indexTotalCost: *mut Cost,
        indexSelectivity: *mut Selectivity,
        indexCorrelation: *mut f64,
        indexPages: *mut f64,
    ),
>;
pub type amoptions_function =
    ::std::option::Option<unsafe extern "C" fn(reloptions: Datum, validate: bool) -> *mut bytea>;
pub type amproperty_function = ::std::option::Option<
    unsafe extern "C" fn(
        index_oid: Oid,
        attno: ::std::os::raw::c_int,
        prop: IndexAMProperty,
        propname: *const ::std::os::raw::c_char,
        res: *mut bool,
        isnull: *mut bool,
    ) -> bool,
>;
pub type amvalidate_function = ::std::option::Option<unsafe extern "C" fn(opclassoid: Oid) -> bool>;
pub type ambeginscan_function = ::std::option::Option<
    unsafe extern "C" fn(
        indexRelation: Relation,
        nkeys: ::std::os::raw::c_int,
        norderbys: ::std::os::raw::c_int,
    ) -> IndexScanDesc,
>;
pub type amrescan_function = ::std::option::Option<
    unsafe extern "C" fn(
        scan: IndexScanDesc,
        keys: ScanKey,
        nkeys: ::std::os::raw::c_int,
        orderbys: ScanKey,
        norderbys: ::std::os::raw::c_int,
    ),
>;
pub type amgettuple_function = ::std::option::Option<
    unsafe extern "C" fn(scan: IndexScanDesc, direction: ScanDirection) -> bool,
>;
pub type amgetbitmap_function =
    ::std::option::Option<unsafe extern "C" fn(scan: IndexScanDesc, tbm: *mut TIDBitmap) -> int64>;
pub type amendscan_function = ::std::option::Option<unsafe extern "C" fn(scan: IndexScanDesc)>;
pub type ammarkpos_function = ::std::option::Option<unsafe extern "C" fn(scan: IndexScanDesc)>;
pub type amrestrpos_function = ::std::option::Option<unsafe extern "C" fn(scan: IndexScanDesc)>;
pub type amestimateparallelscan_function = ::std::option::Option<unsafe extern "C" fn() -> Size>;
pub type aminitparallelscan_function =
    ::std::option::Option<unsafe extern "C" fn(target: *mut ::std::os::raw::c_void)>;
pub type amparallelrescan_function =
    ::std::option::Option<unsafe extern "C" fn(scan: IndexScanDesc)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexAmRoutine {
    pub type_: NodeTag,
    pub amstrategies: uint16,
    pub amsupport: uint16,
    pub amcanorder: bool,
    pub amcanorderbyop: bool,
    pub amcanbackward: bool,
    pub amcanunique: bool,
    pub amcanmulticol: bool,
    pub amoptionalkey: bool,
    pub amsearcharray: bool,
    pub amsearchnulls: bool,
    pub amstorage: bool,
    pub amclusterable: bool,
    pub ampredlocks: bool,
    pub amcanparallel: bool,
    pub amkeytype: Oid,
    pub ambuild: ambuild_function,
    pub ambuildempty: ambuildempty_function,
    pub aminsert: aminsert_function,
    pub ambulkdelete: ambulkdelete_function,
    pub amvacuumcleanup: amvacuumcleanup_function,
    pub amcanreturn: amcanreturn_function,
    pub amcostestimate: amcostestimate_function,
    pub amoptions: amoptions_function,
    pub amproperty: amproperty_function,
    pub amvalidate: amvalidate_function,
    pub ambeginscan: ambeginscan_function,
    pub amrescan: amrescan_function,
    pub amgettuple: amgettuple_function,
    pub amgetbitmap: amgetbitmap_function,
    pub amendscan: amendscan_function,
    pub ammarkpos: ammarkpos_function,
    pub amrestrpos: amrestrpos_function,
    pub amestimateparallelscan: amestimateparallelscan_function,
    pub aminitparallelscan: aminitparallelscan_function,
    pub amparallelrescan: amparallelrescan_function,
}
impl Default for IndexAmRoutine {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn GetIndexAmRoutine(amhandler: Oid) -> *mut IndexAmRoutine;
}
#[pg_guard]
extern "C" {
    pub fn GetIndexAmRoutineByAmId(amoid: Oid, noerror: bool) -> *mut IndexAmRoutine;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct GinStatsData {
    pub nPendingPages: BlockNumber,
    pub nTotalPages: BlockNumber,
    pub nEntryPages: BlockNumber,
    pub nDataPages: BlockNumber,
    pub nEntries: int64,
    pub ginVersion: int32,
}
pub type GinTernaryValue = ::std::os::raw::c_char;
#[pg_guard]
extern "C" {
    pub static mut GinFuzzySearchLimit: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut gin_pending_list_limit: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ginGetStats(index: Relation, stats: *mut GinStatsData);
}
#[pg_guard]
extern "C" {
    pub fn ginUpdateStats(index: Relation, stats: *const GinStatsData);
}
pub type GistNSN = XLogRecPtr;
pub type PageGistNSN = PageXLogRecPtr;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct GISTPageOpaqueData {
    pub nsn: PageGistNSN,
    pub rightlink: BlockNumber,
    pub flags: uint16,
    pub gist_page_id: uint16,
}
pub type GISTPageOpaque = *mut GISTPageOpaqueData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GIST_SPLITVEC {
    pub spl_left: *mut OffsetNumber,
    pub spl_nleft: ::std::os::raw::c_int,
    pub spl_ldatum: Datum,
    pub spl_ldatum_exists: bool,
    pub spl_right: *mut OffsetNumber,
    pub spl_nright: ::std::os::raw::c_int,
    pub spl_rdatum: Datum,
    pub spl_rdatum_exists: bool,
}
impl Default for GIST_SPLITVEC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GISTENTRY {
    pub key: Datum,
    pub rel: Relation,
    pub page: Page,
    pub offset: OffsetNumber,
    pub leafkey: bool,
}
impl Default for GISTENTRY {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct GistEntryVector {
    pub n: int32,
    pub vector: __IncompleteArrayField<GISTENTRY>,
}
impl Default for GistEntryVector {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct VariableCacheData {
    pub nextOid: Oid,
    pub oidCount: uint32,
    pub nextXid: TransactionId,
    pub oldestXid: TransactionId,
    pub xidVacLimit: TransactionId,
    pub xidWarnLimit: TransactionId,
    pub xidStopLimit: TransactionId,
    pub xidWrapLimit: TransactionId,
    pub oldestXidDB: Oid,
    pub oldestCommitTsXid: TransactionId,
    pub newestCommitTsXid: TransactionId,
    pub latestCompletedXid: TransactionId,
    pub oldestClogXid: TransactionId,
}
pub type VariableCache = *mut VariableCacheData;
#[pg_guard]
extern "C" {
    pub fn TransactionStartedDuringRecovery() -> bool;
}
#[pg_guard]
extern "C" {
    pub static mut ShmemVariableCache: VariableCache;
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdDidCommit(transactionId: TransactionId) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdDidAbort(transactionId: TransactionId) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdIsKnownCompleted(transactionId: TransactionId) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdAbort(transactionId: TransactionId);
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdCommitTree(
        xid: TransactionId,
        nxids: ::std::os::raw::c_int,
        xids: *mut TransactionId,
    );
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdAsyncCommitTree(
        xid: TransactionId,
        nxids: ::std::os::raw::c_int,
        xids: *mut TransactionId,
        lsn: XLogRecPtr,
    );
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdAbortTree(
        xid: TransactionId,
        nxids: ::std::os::raw::c_int,
        xids: *mut TransactionId,
    );
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdPrecedes(id1: TransactionId, id2: TransactionId) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdPrecedesOrEquals(id1: TransactionId, id2: TransactionId) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdFollows(id1: TransactionId, id2: TransactionId) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdFollowsOrEquals(id1: TransactionId, id2: TransactionId) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdLatest(
        mainxid: TransactionId,
        nxids: ::std::os::raw::c_int,
        xids: *const TransactionId,
    ) -> TransactionId;
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdGetCommitLSN(xid: TransactionId) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn GetNewTransactionId(isSubXact: bool) -> TransactionId;
}
#[pg_guard]
extern "C" {
    pub fn ReadNewTransactionId() -> TransactionId;
}
#[pg_guard]
extern "C" {
    pub fn SetTransactionIdLimit(oldest_datfrozenxid: TransactionId, oldest_datoid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn AdvanceOldestClogXid(oldest_datfrozenxid: TransactionId);
}
#[pg_guard]
extern "C" {
    pub fn ForceTransactionIdLimitUpdate() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetNewObjectId() -> Oid;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct HeapTupleFields {
    pub t_xmin: TransactionId,
    pub t_xmax: TransactionId,
    pub t_field3: HeapTupleFields__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleFields__bindgen_ty_1 {
    pub t_cid: CommandId,
    pub t_xvac: TransactionId,
}
impl Default for HeapTupleFields__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleFields {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct DatumTupleFields {
    pub datum_len_: int32,
    pub datum_typmod: int32,
    pub datum_typeid: Oid,
}
#[repr(C)]
pub struct HeapTupleHeaderData {
    pub t_choice: HeapTupleHeaderData__bindgen_ty_1,
    pub t_ctid: ItemPointerData,
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleHeaderData__bindgen_ty_1 {
    pub t_heap: HeapTupleFields,
    pub t_datum: DatumTupleFields,
}
impl Default for HeapTupleHeaderData__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleHeaderData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct MinimalTupleData {
    pub t_len: uint32,
    pub mt_padding: [::std::os::raw::c_char; 6usize],
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
#[pg_guard]
extern "C" {
    pub fn heap_compute_data_size(
        tupleDesc: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    ) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn heap_fill_tuple(
        tupleDesc: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
        data: *mut ::std::os::raw::c_char,
        data_size: Size,
        infomask: *mut uint16,
        bit: *mut bits8,
    );
}
#[pg_guard]
extern "C" {
    pub fn heap_attisnull(tup: HeapTuple, attnum: ::std::os::raw::c_int) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn nocachegetattr(tup: HeapTuple, attnum: ::std::os::raw::c_int, att: TupleDesc) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn heap_getsysattr(
        tup: HeapTuple,
        attnum: ::std::os::raw::c_int,
        tupleDesc: TupleDesc,
        isnull: *mut bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn heap_copytuple(tuple: HeapTuple) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn heap_copytuple_with_tuple(src: HeapTuple, dest: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn heap_copy_tuple_as_datum(tuple: HeapTuple, tupleDesc: TupleDesc) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn heap_form_tuple(
        tupleDescriptor: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    ) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn heap_modify_tuple(
        tuple: HeapTuple,
        tupleDesc: TupleDesc,
        replValues: *mut Datum,
        replIsnull: *mut bool,
        doReplace: *mut bool,
    ) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn heap_modify_tuple_by_cols(
        tuple: HeapTuple,
        tupleDesc: TupleDesc,
        nCols: ::std::os::raw::c_int,
        replCols: *mut ::std::os::raw::c_int,
        replValues: *mut Datum,
        replIsnull: *mut bool,
    ) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn heap_deform_tuple(
        tuple: HeapTuple,
        tupleDesc: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn heap_freetuple(htup: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn heap_form_minimal_tuple(
        tupleDescriptor: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    ) -> MinimalTuple;
}
#[pg_guard]
extern "C" {
    pub fn heap_free_minimal_tuple(mtup: MinimalTuple);
}
#[pg_guard]
extern "C" {
    pub fn heap_copy_minimal_tuple(mtup: MinimalTuple) -> MinimalTuple;
}
#[pg_guard]
extern "C" {
    pub fn heap_tuple_from_minimal_tuple(mtup: MinimalTuple) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn minimal_tuple_from_heap_tuple(htup: HeapTuple) -> MinimalTuple;
}
pub const relopt_type_RELOPT_TYPE_BOOL: relopt_type = 0;
pub const relopt_type_RELOPT_TYPE_INT: relopt_type = 1;
pub const relopt_type_RELOPT_TYPE_REAL: relopt_type = 2;
pub const relopt_type_RELOPT_TYPE_STRING: relopt_type = 3;
pub type relopt_type = ::std::os::raw::c_uint;
pub const relopt_kind_RELOPT_KIND_HEAP: relopt_kind = 1;
pub const relopt_kind_RELOPT_KIND_TOAST: relopt_kind = 2;
pub const relopt_kind_RELOPT_KIND_BTREE: relopt_kind = 4;
pub const relopt_kind_RELOPT_KIND_HASH: relopt_kind = 8;
pub const relopt_kind_RELOPT_KIND_GIN: relopt_kind = 16;
pub const relopt_kind_RELOPT_KIND_GIST: relopt_kind = 32;
pub const relopt_kind_RELOPT_KIND_ATTRIBUTE: relopt_kind = 64;
pub const relopt_kind_RELOPT_KIND_TABLESPACE: relopt_kind = 128;
pub const relopt_kind_RELOPT_KIND_SPGIST: relopt_kind = 256;
pub const relopt_kind_RELOPT_KIND_VIEW: relopt_kind = 512;
pub const relopt_kind_RELOPT_KIND_BRIN: relopt_kind = 1024;
pub const relopt_kind_RELOPT_KIND_PARTITIONED: relopt_kind = 2048;
pub const relopt_kind_RELOPT_KIND_LAST_DEFAULT: relopt_kind = 2048;
pub const relopt_kind_RELOPT_KIND_MAX: relopt_kind = 1073741824;
pub type relopt_kind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_gen {
    pub name: *const ::std::os::raw::c_char,
    pub desc: *const ::std::os::raw::c_char,
    pub kinds: bits32,
    pub lockmode: LOCKMODE,
    pub namelen: ::std::os::raw::c_int,
    pub type_: relopt_type,
}
impl Default for relopt_gen {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct relopt_value {
    pub gen: *mut relopt_gen,
    pub isset: bool,
    pub values: relopt_value__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union relopt_value__bindgen_ty_1 {
    pub bool_val: bool,
    pub int_val: ::std::os::raw::c_int,
    pub real_val: f64,
    pub string_val: *mut ::std::os::raw::c_char,
}
impl Default for relopt_value__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for relopt_value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_bool {
    pub gen: relopt_gen,
    pub default_val: bool,
}
impl Default for relopt_bool {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_int {
    pub gen: relopt_gen,
    pub default_val: ::std::os::raw::c_int,
    pub min: ::std::os::raw::c_int,
    pub max: ::std::os::raw::c_int,
}
impl Default for relopt_int {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_real {
    pub gen: relopt_gen,
    pub default_val: f64,
    pub min: f64,
    pub max: f64,
}
impl Default for relopt_real {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type validate_string_relopt =
    ::std::option::Option<unsafe extern "C" fn(value: *mut ::std::os::raw::c_char)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_string {
    pub gen: relopt_gen,
    pub default_len: ::std::os::raw::c_int,
    pub default_isnull: bool,
    pub validate_cb: validate_string_relopt,
    pub default_val: *mut ::std::os::raw::c_char,
}
impl Default for relopt_string {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_parse_elt {
    pub optname: *const ::std::os::raw::c_char,
    pub opttype: relopt_type,
    pub offset: ::std::os::raw::c_int,
}
impl Default for relopt_parse_elt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn add_reloption_kind() -> relopt_kind;
}
#[pg_guard]
extern "C" {
    pub fn add_bool_reloption(
        kinds: bits32,
        name: *mut ::std::os::raw::c_char,
        desc: *mut ::std::os::raw::c_char,
        default_val: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn add_int_reloption(
        kinds: bits32,
        name: *mut ::std::os::raw::c_char,
        desc: *mut ::std::os::raw::c_char,
        default_val: ::std::os::raw::c_int,
        min_val: ::std::os::raw::c_int,
        max_val: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn add_real_reloption(
        kinds: bits32,
        name: *mut ::std::os::raw::c_char,
        desc: *mut ::std::os::raw::c_char,
        default_val: f64,
        min_val: f64,
        max_val: f64,
    );
}
#[pg_guard]
extern "C" {
    pub fn add_string_reloption(
        kinds: bits32,
        name: *mut ::std::os::raw::c_char,
        desc: *mut ::std::os::raw::c_char,
        default_val: *mut ::std::os::raw::c_char,
        validator: validate_string_relopt,
    );
}
#[pg_guard]
extern "C" {
    pub fn transformRelOptions(
        oldOptions: Datum,
        defList: *mut List,
        namspace: *mut ::std::os::raw::c_char,
        validnsps: *mut *mut ::std::os::raw::c_char,
        ignoreOids: bool,
        isReset: bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn untransformRelOptions(options: Datum) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn extractRelOptions(
        tuple: HeapTuple,
        tupdesc: TupleDesc,
        amoptions: amoptions_function,
    ) -> *mut bytea;
}
#[pg_guard]
extern "C" {
    pub fn parseRelOptions(
        options: Datum,
        validate: bool,
        kind: relopt_kind,
        numrelopts: *mut ::std::os::raw::c_int,
    ) -> *mut relopt_value;
}
#[pg_guard]
extern "C" {
    pub fn allocateReloptStruct(
        base: Size,
        options: *mut relopt_value,
        numoptions: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn fillRelOptions(
        rdopts: *mut ::std::os::raw::c_void,
        basesize: Size,
        options: *mut relopt_value,
        numoptions: ::std::os::raw::c_int,
        validate: bool,
        elems: *const relopt_parse_elt,
        nelems: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn default_reloptions(reloptions: Datum, validate: bool, kind: relopt_kind) -> *mut bytea;
}
#[pg_guard]
extern "C" {
    pub fn heap_reloptions(
        relkind: ::std::os::raw::c_char,
        reloptions: Datum,
        validate: bool,
    ) -> *mut bytea;
}
#[pg_guard]
extern "C" {
    pub fn view_reloptions(reloptions: Datum, validate: bool) -> *mut bytea;
}
#[pg_guard]
extern "C" {
    pub fn index_reloptions(
        amoptions: amoptions_function,
        reloptions: Datum,
        validate: bool,
    ) -> *mut bytea;
}
#[pg_guard]
extern "C" {
    pub fn attribute_reloptions(reloptions: Datum, validate: bool) -> *mut bytea;
}
#[pg_guard]
extern "C" {
    pub fn tablespace_reloptions(reloptions: Datum, validate: bool) -> *mut bytea;
}
#[pg_guard]
extern "C" {
    pub fn AlterTableGetRelOptionsLockLevel(defList: *mut List) -> LOCKMODE;
}
#[pg_guard]
extern "C" {
    pub fn SpinlockSemas() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SpinlockSemaSize() -> Size;
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct ParallelHeapScanDescData {
    pub phs_relid: Oid,
    pub phs_syncscan: bool,
    pub phs_nblocks: BlockNumber,
    pub phs_mutex: slock_t,
    pub phs_startblock: BlockNumber,
    pub phs_cblock: BlockNumber,
    pub phs_snapshot_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapScanDescData {
    pub rs_rd: Relation,
    pub rs_snapshot: Snapshot,
    pub rs_nkeys: ::std::os::raw::c_int,
    pub rs_key: ScanKey,
    pub rs_bitmapscan: bool,
    pub rs_samplescan: bool,
    pub rs_pageatatime: bool,
    pub rs_allow_strat: bool,
    pub rs_allow_sync: bool,
    pub rs_temp_snap: bool,
    pub rs_nblocks: BlockNumber,
    pub rs_startblock: BlockNumber,
    pub rs_numblocks: BlockNumber,
    pub rs_strategy: BufferAccessStrategy,
    pub rs_syncscan: bool,
    pub rs_inited: bool,
    pub rs_ctup: HeapTupleData,
    pub rs_cblock: BlockNumber,
    pub rs_cbuf: Buffer,
    pub rs_parallel: ParallelHeapScanDesc,
    pub rs_cindex: ::std::os::raw::c_int,
    pub rs_ntuples: ::std::os::raw::c_int,
    pub rs_vistuples: [OffsetNumber; 291usize],
}
impl Default for HeapScanDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScanDescData {
    pub heapRelation: Relation,
    pub indexRelation: Relation,
    pub xs_snapshot: Snapshot,
    pub numberOfKeys: ::std::os::raw::c_int,
    pub numberOfOrderBys: ::std::os::raw::c_int,
    pub keyData: ScanKey,
    pub orderByData: ScanKey,
    pub xs_want_itup: bool,
    pub xs_temp_snap: bool,
    pub kill_prior_tuple: bool,
    pub ignore_killed_tuples: bool,
    pub xactStartedInRecovery: bool,
    pub opaque: *mut ::std::os::raw::c_void,
    pub xs_itup: IndexTuple,
    pub xs_itupdesc: TupleDesc,
    pub xs_hitup: HeapTuple,
    pub xs_hitupdesc: TupleDesc,
    pub xs_ctup: HeapTupleData,
    pub xs_cbuf: Buffer,
    pub xs_recheck: bool,
    pub xs_orderbyvals: *mut Datum,
    pub xs_orderbynulls: *mut bool,
    pub xs_recheckorderby: bool,
    pub xs_continue_hot: bool,
    pub parallel_scan: ParallelIndexScanDesc,
}
impl Default for IndexScanDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct ParallelIndexScanDescData {
    pub ps_relid: Oid,
    pub ps_indexid: Oid,
    pub ps_offset: Size,
    pub ps_snapshot_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SysScanDescData {
    pub heap_rel: Relation,
    pub irel: Relation,
    pub scan: HeapScanDesc,
    pub iscan: IndexScanDesc,
    pub snapshot: Snapshot,
}
impl Default for SysScanDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SharedInvalCatcacheMsg {
    pub id: int8,
    pub dbId: Oid,
    pub hashValue: uint32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SharedInvalCatalogMsg {
    pub id: int8,
    pub dbId: Oid,
    pub catId: Oid,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SharedInvalRelcacheMsg {
    pub id: int8,
    pub dbId: Oid,
    pub relId: Oid,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SharedInvalSmgrMsg {
    pub id: int8,
    pub backend_hi: int8,
    pub backend_lo: uint16,
    pub rnode: RelFileNode,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SharedInvalRelmapMsg {
    pub id: int8,
    pub dbId: Oid,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SharedInvalSnapshotMsg {
    pub id: int8,
    pub dbId: Oid,
    pub relId: Oid,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union SharedInvalidationMessage {
    pub id: int8,
    pub cc: SharedInvalCatcacheMsg,
    pub cat: SharedInvalCatalogMsg,
    pub rc: SharedInvalRelcacheMsg,
    pub sm: SharedInvalSmgrMsg,
    pub rm: SharedInvalRelmapMsg,
    pub sn: SharedInvalSnapshotMsg,
}
impl Default for SharedInvalidationMessage {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut SharedInvalidMessageCounter: uint64;
}
#[pg_guard]
extern "C" {
    pub static mut catchupInterruptPending: sig_atomic_t;
}
#[pg_guard]
extern "C" {
    pub fn SendSharedInvalidMessages(
        msgs: *const SharedInvalidationMessage,
        n: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn ReceiveSharedInvalidMessages(
        invalFunction: ::std::option::Option<
            unsafe extern "C" fn(msg: *mut SharedInvalidationMessage),
        >,
        resetFunction: ::std::option::Option<unsafe extern "C" fn()>,
    );
}
#[pg_guard]
extern "C" {
    pub fn HandleCatchupInterrupt();
}
#[pg_guard]
extern "C" {
    pub fn ProcessCatchupInterrupt();
}
#[pg_guard]
extern "C" {
    pub fn xactGetCommittedInvalidationMessages(
        msgs: *mut *mut SharedInvalidationMessage,
        RelcacheInitFileInval: *mut bool,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ProcessCommittedInvalidationMessages(
        msgs: *mut SharedInvalidationMessage,
        nmsgs: ::std::os::raw::c_int,
        RelcacheInitFileInval: bool,
        dbid: Oid,
        tsid: Oid,
    );
}
#[pg_guard]
extern "C" {
    pub fn LocalExecuteInvalidationMessage(msg: *mut SharedInvalidationMessage);
}
#[pg_guard]
extern "C" {
    pub static mut PgStartTime: TimestampTz;
}
#[pg_guard]
extern "C" {
    pub static mut PgReloadTime: TimestampTz;
}
#[pg_guard]
extern "C" {
    pub fn anytimestamp_typmod_check(istz: bool, typmod: int32) -> int32;
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentTimestamp() -> TimestampTz;
}
#[pg_guard]
extern "C" {
    pub fn GetSQLCurrentTimestamp(typmod: int32) -> TimestampTz;
}
#[pg_guard]
extern "C" {
    pub fn GetSQLLocalTimestamp(typmod: int32) -> Timestamp;
}
#[pg_guard]
extern "C" {
    pub fn TimestampDifference(
        start_time: TimestampTz,
        stop_time: TimestampTz,
        secs: *mut ::std::os::raw::c_long,
        microsecs: *mut ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn TimestampDifferenceMilliseconds(
        start_time: TimestampTz,
        stop_time: TimestampTz,
    ) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn TimestampDifferenceExceeds(
        start_time: TimestampTz,
        stop_time: TimestampTz,
        msec: ::std::os::raw::c_int,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn time_t_to_timestamptz(tm: pg_time_t) -> TimestampTz;
}
#[pg_guard]
extern "C" {
    pub fn timestamptz_to_time_t(t: TimestampTz) -> pg_time_t;
}
#[pg_guard]
extern "C" {
    pub fn timestamptz_to_str(t: TimestampTz) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn tm2timestamp(
        tm: *mut pg_tm,
        fsec: fsec_t,
        tzp: *mut ::std::os::raw::c_int,
        dt: *mut Timestamp,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn timestamp2tm(
        dt: Timestamp,
        tzp: *mut ::std::os::raw::c_int,
        tm: *mut pg_tm,
        fsec: *mut fsec_t,
        tzn: *mut *const ::std::os::raw::c_char,
        attimezone: *mut pg_tz,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn dt2time(
        dt: Timestamp,
        hour: *mut ::std::os::raw::c_int,
        min: *mut ::std::os::raw::c_int,
        sec: *mut ::std::os::raw::c_int,
        fsec: *mut fsec_t,
    );
}
#[pg_guard]
extern "C" {
    pub fn interval2tm(span: Interval, tm: *mut pg_tm, fsec: *mut fsec_t) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn tm2interval(tm: *mut pg_tm, fsec: fsec_t, span: *mut Interval) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SetEpochTimestamp() -> Timestamp;
}
#[pg_guard]
extern "C" {
    pub fn GetEpochTime(tm: *mut pg_tm);
}
#[pg_guard]
extern "C" {
    pub fn timestamp_cmp_internal(dt1: Timestamp, dt2: Timestamp) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn isoweek2j(
        year: ::std::os::raw::c_int,
        week: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn isoweek2date(
        woy: ::std::os::raw::c_int,
        year: *mut ::std::os::raw::c_int,
        mon: *mut ::std::os::raw::c_int,
        mday: *mut ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn isoweekdate2date(
        isoweek: ::std::os::raw::c_int,
        wday: ::std::os::raw::c_int,
        year: *mut ::std::os::raw::c_int,
        mon: *mut ::std::os::raw::c_int,
        mday: *mut ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn date2isoweek(
        year: ::std::os::raw::c_int,
        mon: ::std::os::raw::c_int,
        mday: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn date2isoyear(
        year: ::std::os::raw::c_int,
        mon: ::std::os::raw::c_int,
        mday: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn date2isoyearday(
        year: ::std::os::raw::c_int,
        mon: ::std::os::raw::c_int,
        mday: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tzEntry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct datetkn {
    pub token: [::std::os::raw::c_char; 11usize],
    pub type_: ::std::os::raw::c_char,
    pub value: int32,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TimeZoneAbbrevTable {
    pub tblsize: Size,
    pub numabbrevs: ::std::os::raw::c_int,
    pub abbrevs: __IncompleteArrayField<datetkn>,
}
#[repr(C)]
#[derive(Debug)]
pub struct DynamicZoneAbbrev {
    pub tz: *mut pg_tz,
    pub zone: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for DynamicZoneAbbrev {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut months: [*const ::std::os::raw::c_char; 0usize];
}
#[pg_guard]
extern "C" {
    pub static mut days: [*const ::std::os::raw::c_char; 0usize];
}
#[pg_guard]
extern "C" {
    pub static mut day_tab: [[::std::os::raw::c_int; 13usize]; 2usize];
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentDateTime(tm: *mut pg_tm);
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentTimeUsec(tm: *mut pg_tm, fsec: *mut fsec_t, tzp: *mut ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn j2date(
        jd: ::std::os::raw::c_int,
        year: *mut ::std::os::raw::c_int,
        month: *mut ::std::os::raw::c_int,
        day: *mut ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn date2j(
        year: ::std::os::raw::c_int,
        month: ::std::os::raw::c_int,
        day: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ParseDateTime(
        timestr: *const ::std::os::raw::c_char,
        workbuf: *mut ::std::os::raw::c_char,
        buflen: usize,
        field: *mut *mut ::std::os::raw::c_char,
        ftype: *mut ::std::os::raw::c_int,
        maxfields: ::std::os::raw::c_int,
        numfields: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DecodeDateTime(
        field: *mut *mut ::std::os::raw::c_char,
        ftype: *mut ::std::os::raw::c_int,
        nf: ::std::os::raw::c_int,
        dtype: *mut ::std::os::raw::c_int,
        tm: *mut pg_tm,
        fsec: *mut fsec_t,
        tzp: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DecodeTimezone(
        str_: *mut ::std::os::raw::c_char,
        tzp: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DecodeTimeOnly(
        field: *mut *mut ::std::os::raw::c_char,
        ftype: *mut ::std::os::raw::c_int,
        nf: ::std::os::raw::c_int,
        dtype: *mut ::std::os::raw::c_int,
        tm: *mut pg_tm,
        fsec: *mut fsec_t,
        tzp: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DecodeInterval(
        field: *mut *mut ::std::os::raw::c_char,
        ftype: *mut ::std::os::raw::c_int,
        nf: ::std::os::raw::c_int,
        range: ::std::os::raw::c_int,
        dtype: *mut ::std::os::raw::c_int,
        tm: *mut pg_tm,
        fsec: *mut fsec_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DecodeISO8601Interval(
        str_: *mut ::std::os::raw::c_char,
        dtype: *mut ::std::os::raw::c_int,
        tm: *mut pg_tm,
        fsec: *mut fsec_t,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DateTimeParseError(
        dterr: ::std::os::raw::c_int,
        str_: *const ::std::os::raw::c_char,
        datatype: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn DetermineTimeZoneOffset(tm: *mut pg_tm, tzp: *mut pg_tz) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DetermineTimeZoneAbbrevOffset(
        tm: *mut pg_tm,
        abbr: *const ::std::os::raw::c_char,
        tzp: *mut pg_tz,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DetermineTimeZoneAbbrevOffsetTS(
        ts: TimestampTz,
        abbr: *const ::std::os::raw::c_char,
        tzp: *mut pg_tz,
        isdst: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn EncodeDateOnly(
        tm: *mut pg_tm,
        style: ::std::os::raw::c_int,
        str_: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn EncodeTimeOnly(
        tm: *mut pg_tm,
        fsec: fsec_t,
        print_tz: bool,
        tz: ::std::os::raw::c_int,
        style: ::std::os::raw::c_int,
        str_: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn EncodeDateTime(
        tm: *mut pg_tm,
        fsec: fsec_t,
        print_tz: bool,
        tz: ::std::os::raw::c_int,
        tzn: *const ::std::os::raw::c_char,
        style: ::std::os::raw::c_int,
        str_: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn EncodeInterval(
        tm: *mut pg_tm,
        fsec: fsec_t,
        style: ::std::os::raw::c_int,
        str_: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn EncodeSpecialTimestamp(dt: Timestamp, str_: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn ValidateDate(
        fmask: ::std::os::raw::c_int,
        isjulian: bool,
        is2digits: bool,
        bc: bool,
        tm: *mut pg_tm,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DecodeTimezoneAbbrev(
        field: ::std::os::raw::c_int,
        lowtoken: *mut ::std::os::raw::c_char,
        offset: *mut ::std::os::raw::c_int,
        tz: *mut *mut pg_tz,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DecodeSpecial(
        field: ::std::os::raw::c_int,
        lowtoken: *mut ::std::os::raw::c_char,
        val: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn DecodeUnits(
        field: ::std::os::raw::c_int,
        lowtoken: *mut ::std::os::raw::c_char,
        val: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn j2day(jd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn TemporalTransform(max_precis: int32, node: *mut Node) -> *mut Node;
}
#[pg_guard]
extern "C" {
    pub fn CheckDateTokenTables() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ConvertTimeZoneAbbrevs(
        abbrevs: *mut tzEntry,
        n: ::std::os::raw::c_int,
    ) -> *mut TimeZoneAbbrevTable;
}
#[pg_guard]
extern "C" {
    pub fn InstallTimeZoneAbbrevs(tbl: *mut TimeZoneAbbrevTable);
}
#[pg_guard]
extern "C" {
    pub static mut DefaultXactIsoLevel: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut XactIsoLevel: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut DefaultXactReadOnly: bool;
}
#[pg_guard]
extern "C" {
    pub static mut XactReadOnly: bool;
}
#[pg_guard]
extern "C" {
    pub static mut DefaultXactDeferrable: bool;
}
#[pg_guard]
extern "C" {
    pub static mut XactDeferrable: bool;
}
pub const SyncCommitLevel_SYNCHRONOUS_COMMIT_OFF: SyncCommitLevel = 0;
pub const SyncCommitLevel_SYNCHRONOUS_COMMIT_LOCAL_FLUSH: SyncCommitLevel = 1;
pub const SyncCommitLevel_SYNCHRONOUS_COMMIT_REMOTE_WRITE: SyncCommitLevel = 2;
pub const SyncCommitLevel_SYNCHRONOUS_COMMIT_REMOTE_FLUSH: SyncCommitLevel = 3;
pub const SyncCommitLevel_SYNCHRONOUS_COMMIT_REMOTE_APPLY: SyncCommitLevel = 4;
pub type SyncCommitLevel = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub static mut synchronous_commit: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut MyXactFlags: ::std::os::raw::c_int;
}
pub const XactEvent_XACT_EVENT_COMMIT: XactEvent = 0;
pub const XactEvent_XACT_EVENT_PARALLEL_COMMIT: XactEvent = 1;
pub const XactEvent_XACT_EVENT_ABORT: XactEvent = 2;
pub const XactEvent_XACT_EVENT_PARALLEL_ABORT: XactEvent = 3;
pub const XactEvent_XACT_EVENT_PREPARE: XactEvent = 4;
pub const XactEvent_XACT_EVENT_PRE_COMMIT: XactEvent = 5;
pub const XactEvent_XACT_EVENT_PARALLEL_PRE_COMMIT: XactEvent = 6;
pub const XactEvent_XACT_EVENT_PRE_PREPARE: XactEvent = 7;
pub type XactEvent = ::std::os::raw::c_uint;
pub type XactCallback =
    ::std::option::Option<unsafe extern "C" fn(event: XactEvent, arg: *mut ::std::os::raw::c_void)>;
pub const SubXactEvent_SUBXACT_EVENT_START_SUB: SubXactEvent = 0;
pub const SubXactEvent_SUBXACT_EVENT_COMMIT_SUB: SubXactEvent = 1;
pub const SubXactEvent_SUBXACT_EVENT_ABORT_SUB: SubXactEvent = 2;
pub const SubXactEvent_SUBXACT_EVENT_PRE_COMMIT_SUB: SubXactEvent = 3;
pub type SubXactEvent = ::std::os::raw::c_uint;
pub type SubXactCallback = ::std::option::Option<
    unsafe extern "C" fn(
        event: SubXactEvent,
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
        arg: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Default)]
pub struct xl_xact_assignment {
    pub xtop: TransactionId,
    pub nsubxacts: ::std::os::raw::c_int,
    pub xsub: __IncompleteArrayField<TransactionId>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_xinfo {
    pub xinfo: uint32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_dbinfo {
    pub dbId: Oid,
    pub tsId: Oid,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct xl_xact_subxacts {
    pub nsubxacts: ::std::os::raw::c_int,
    pub subxacts: __IncompleteArrayField<TransactionId>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct xl_xact_relfilenodes {
    pub nrels: ::std::os::raw::c_int,
    pub xnodes: __IncompleteArrayField<RelFileNode>,
}
#[repr(C)]
pub struct xl_xact_invals {
    pub nmsgs: ::std::os::raw::c_int,
    pub msgs: __IncompleteArrayField<SharedInvalidationMessage>,
}
impl Default for xl_xact_invals {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_twophase {
    pub xid: TransactionId,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_origin {
    pub origin_lsn: XLogRecPtr,
    pub origin_timestamp: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_commit {
    pub xact_time: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_abort {
    pub xact_time: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_parsed_commit {
    pub xact_time: TimestampTz,
    pub xinfo: uint32,
    pub dbId: Oid,
    pub tsId: Oid,
    pub nsubxacts: ::std::os::raw::c_int,
    pub subxacts: *mut TransactionId,
    pub nrels: ::std::os::raw::c_int,
    pub xnodes: *mut RelFileNode,
    pub nmsgs: ::std::os::raw::c_int,
    pub msgs: *mut SharedInvalidationMessage,
    pub twophase_xid: TransactionId,
    pub origin_lsn: XLogRecPtr,
    pub origin_timestamp: TimestampTz,
}
impl Default for xl_xact_parsed_commit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_parsed_abort {
    pub xact_time: TimestampTz,
    pub xinfo: uint32,
    pub nsubxacts: ::std::os::raw::c_int,
    pub subxacts: *mut TransactionId,
    pub nrels: ::std::os::raw::c_int,
    pub xnodes: *mut RelFileNode,
    pub twophase_xid: TransactionId,
}
impl Default for xl_xact_parsed_abort {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn IsTransactionState() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn IsAbortedTransactionBlockState() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetTopTransactionId() -> TransactionId;
}
#[pg_guard]
extern "C" {
    pub fn GetTopTransactionIdIfAny() -> TransactionId;
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentTransactionId() -> TransactionId;
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentTransactionIdIfAny() -> TransactionId;
}
#[pg_guard]
extern "C" {
    pub fn GetStableLatestTransactionId() -> TransactionId;
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentSubTransactionId() -> SubTransactionId;
}
#[pg_guard]
extern "C" {
    pub fn MarkCurrentTransactionIdLoggedIfAny();
}
#[pg_guard]
extern "C" {
    pub fn SubTransactionIsActive(subxid: SubTransactionId) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentCommandId(used: bool) -> CommandId;
}
#[pg_guard]
extern "C" {
    pub fn SetParallelStartTimestamps(xact_ts: TimestampTz, stmt_ts: TimestampTz);
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentTransactionStartTimestamp() -> TimestampTz;
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentStatementStartTimestamp() -> TimestampTz;
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentTransactionStopTimestamp() -> TimestampTz;
}
#[pg_guard]
extern "C" {
    pub fn SetCurrentStatementStartTimestamp();
}
#[pg_guard]
extern "C" {
    pub fn GetCurrentTransactionNestLevel() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn TransactionIdIsCurrentTransactionId(xid: TransactionId) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn CommandCounterIncrement();
}
#[pg_guard]
extern "C" {
    pub fn ForceSyncCommit();
}
#[pg_guard]
extern "C" {
    pub fn StartTransactionCommand();
}
#[pg_guard]
extern "C" {
    pub fn CommitTransactionCommand();
}
#[pg_guard]
extern "C" {
    pub fn AbortCurrentTransaction();
}
#[pg_guard]
extern "C" {
    pub fn BeginTransactionBlock();
}
#[pg_guard]
extern "C" {
    pub fn EndTransactionBlock() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn PrepareTransactionBlock(gid: *mut ::std::os::raw::c_char) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn UserAbortTransactionBlock();
}
#[pg_guard]
extern "C" {
    pub fn ReleaseSavepoint(options: *mut List);
}
#[pg_guard]
extern "C" {
    pub fn DefineSavepoint(name: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn RollbackToSavepoint(options: *mut List);
}
#[pg_guard]
extern "C" {
    pub fn BeginInternalSubTransaction(name: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn ReleaseCurrentSubTransaction();
}
#[pg_guard]
extern "C" {
    pub fn RollbackAndReleaseCurrentSubTransaction();
}
#[pg_guard]
extern "C" {
    pub fn IsSubTransaction() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn EstimateTransactionStateSpace() -> Size;
}
#[pg_guard]
extern "C" {
    pub fn SerializeTransactionState(maxsize: Size, start_address: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn StartParallelWorkerTransaction(tstatespace: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn EndParallelWorkerTransaction();
}
#[pg_guard]
extern "C" {
    pub fn IsTransactionBlock() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn IsTransactionOrTransactionBlock() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn TransactionBlockStatusCode() -> ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn AbortOutOfAnyTransaction();
}
#[pg_guard]
extern "C" {
    pub fn PreventTransactionChain(isTopLevel: bool, stmtType: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn RequireTransactionChain(isTopLevel: bool, stmtType: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn WarnNoTransactionChain(isTopLevel: bool, stmtType: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn IsInTransactionChain(isTopLevel: bool) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn RegisterXactCallback(callback: XactCallback, arg: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn UnregisterXactCallback(callback: XactCallback, arg: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn RegisterSubXactCallback(callback: SubXactCallback, arg: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn UnregisterSubXactCallback(callback: SubXactCallback, arg: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn xactGetCommittedChildren(ptr: *mut *mut TransactionId) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn XactLogCommitRecord(
        commit_time: TimestampTz,
        nsubxacts: ::std::os::raw::c_int,
        subxacts: *mut TransactionId,
        nrels: ::std::os::raw::c_int,
        rels: *mut RelFileNode,
        nmsgs: ::std::os::raw::c_int,
        msgs: *mut SharedInvalidationMessage,
        relcacheInval: bool,
        forceSync: bool,
        xactflags: ::std::os::raw::c_int,
        twophase_xid: TransactionId,
    ) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn XactLogAbortRecord(
        abort_time: TimestampTz,
        nsubxacts: ::std::os::raw::c_int,
        subxacts: *mut TransactionId,
        nrels: ::std::os::raw::c_int,
        rels: *mut RelFileNode,
        xactflags: ::std::os::raw::c_int,
        twophase_xid: TransactionId,
    ) -> XLogRecPtr;
}
#[pg_guard]
extern "C" {
    pub fn xact_redo(record: *mut XLogReaderState);
}
#[pg_guard]
extern "C" {
    pub fn xact_desc(buf: StringInfo, record: *mut XLogReaderState);
}
#[pg_guard]
extern "C" {
    pub fn xact_identify(info: uint8) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn ParseCommitRecord(
        info: uint8,
        xlrec: *mut xl_xact_commit,
        parsed: *mut xl_xact_parsed_commit,
    );
}
#[pg_guard]
extern "C" {
    pub fn ParseAbortRecord(
        info: uint8,
        xlrec: *mut xl_xact_abort,
        parsed: *mut xl_xact_parsed_abort,
    );
}
#[pg_guard]
extern "C" {
    pub fn EnterParallelMode();
}
#[pg_guard]
extern "C" {
    pub fn ExitParallelMode();
}
#[pg_guard]
extern "C" {
    pub fn IsInParallelMode() -> bool;
}
pub const DependencyType_DEPENDENCY_NORMAL: DependencyType = 110;
pub const DependencyType_DEPENDENCY_AUTO: DependencyType = 97;
pub const DependencyType_DEPENDENCY_INTERNAL: DependencyType = 105;
pub const DependencyType_DEPENDENCY_EXTENSION: DependencyType = 101;
pub const DependencyType_DEPENDENCY_AUTO_EXTENSION: DependencyType = 120;
pub const DependencyType_DEPENDENCY_PIN: DependencyType = 112;
pub type DependencyType = ::std::os::raw::c_uint;
pub const SharedDependencyType_SHARED_DEPENDENCY_PIN: SharedDependencyType = 112;
pub const SharedDependencyType_SHARED_DEPENDENCY_OWNER: SharedDependencyType = 111;
pub const SharedDependencyType_SHARED_DEPENDENCY_ACL: SharedDependencyType = 97;
pub const SharedDependencyType_SHARED_DEPENDENCY_POLICY: SharedDependencyType = 114;
pub const SharedDependencyType_SHARED_DEPENDENCY_INVALID: SharedDependencyType = 0;
pub type SharedDependencyType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectAddresses {
    _unused: [u8; 0],
}
pub const ObjectClass_OCLASS_CLASS: ObjectClass = 0;
pub const ObjectClass_OCLASS_PROC: ObjectClass = 1;
pub const ObjectClass_OCLASS_TYPE: ObjectClass = 2;
pub const ObjectClass_OCLASS_CAST: ObjectClass = 3;
pub const ObjectClass_OCLASS_COLLATION: ObjectClass = 4;
pub const ObjectClass_OCLASS_CONSTRAINT: ObjectClass = 5;
pub const ObjectClass_OCLASS_CONVERSION: ObjectClass = 6;
pub const ObjectClass_OCLASS_DEFAULT: ObjectClass = 7;
pub const ObjectClass_OCLASS_LANGUAGE: ObjectClass = 8;
pub const ObjectClass_OCLASS_LARGEOBJECT: ObjectClass = 9;
pub const ObjectClass_OCLASS_OPERATOR: ObjectClass = 10;
pub const ObjectClass_OCLASS_OPCLASS: ObjectClass = 11;
pub const ObjectClass_OCLASS_OPFAMILY: ObjectClass = 12;
pub const ObjectClass_OCLASS_AM: ObjectClass = 13;
pub const ObjectClass_OCLASS_AMOP: ObjectClass = 14;
pub const ObjectClass_OCLASS_AMPROC: ObjectClass = 15;
pub const ObjectClass_OCLASS_REWRITE: ObjectClass = 16;
pub const ObjectClass_OCLASS_TRIGGER: ObjectClass = 17;
pub const ObjectClass_OCLASS_SCHEMA: ObjectClass = 18;
pub const ObjectClass_OCLASS_STATISTIC_EXT: ObjectClass = 19;
pub const ObjectClass_OCLASS_TSPARSER: ObjectClass = 20;
pub const ObjectClass_OCLASS_TSDICT: ObjectClass = 21;
pub const ObjectClass_OCLASS_TSTEMPLATE: ObjectClass = 22;
pub const ObjectClass_OCLASS_TSCONFIG: ObjectClass = 23;
pub const ObjectClass_OCLASS_ROLE: ObjectClass = 24;
pub const ObjectClass_OCLASS_DATABASE: ObjectClass = 25;
pub const ObjectClass_OCLASS_TBLSPACE: ObjectClass = 26;
pub const ObjectClass_OCLASS_FDW: ObjectClass = 27;
pub const ObjectClass_OCLASS_FOREIGN_SERVER: ObjectClass = 28;
pub const ObjectClass_OCLASS_USER_MAPPING: ObjectClass = 29;
pub const ObjectClass_OCLASS_DEFACL: ObjectClass = 30;
pub const ObjectClass_OCLASS_EXTENSION: ObjectClass = 31;
pub const ObjectClass_OCLASS_EVENT_TRIGGER: ObjectClass = 32;
pub const ObjectClass_OCLASS_POLICY: ObjectClass = 33;
pub const ObjectClass_OCLASS_PUBLICATION: ObjectClass = 34;
pub const ObjectClass_OCLASS_PUBLICATION_REL: ObjectClass = 35;
pub const ObjectClass_OCLASS_SUBSCRIPTION: ObjectClass = 36;
pub const ObjectClass_OCLASS_TRANSFORM: ObjectClass = 37;
pub type ObjectClass = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn AcquireDeletionLock(object: *const ObjectAddress, flags: ::std::os::raw::c_int);
}
#[pg_guard]
extern "C" {
    pub fn ReleaseDeletionLock(object: *const ObjectAddress);
}
#[pg_guard]
extern "C" {
    pub fn performDeletion(
        object: *const ObjectAddress,
        behavior: DropBehavior,
        flags: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn performMultipleDeletions(
        objects: *const ObjectAddresses,
        behavior: DropBehavior,
        flags: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn recordDependencyOnExpr(
        depender: *const ObjectAddress,
        expr: *mut Node,
        rtable: *mut List,
        behavior: DependencyType,
    );
}
#[pg_guard]
extern "C" {
    pub fn recordDependencyOnSingleRelExpr(
        depender: *const ObjectAddress,
        expr: *mut Node,
        relId: Oid,
        behavior: DependencyType,
        self_behavior: DependencyType,
        reverse_self: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn getObjectClass(object: *const ObjectAddress) -> ObjectClass;
}
#[pg_guard]
extern "C" {
    pub fn new_object_addresses() -> *mut ObjectAddresses;
}
#[pg_guard]
extern "C" {
    pub fn add_exact_object_address(object: *const ObjectAddress, addrs: *mut ObjectAddresses);
}
#[pg_guard]
extern "C" {
    pub fn object_address_present(
        object: *const ObjectAddress,
        addrs: *const ObjectAddresses,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn record_object_address_dependencies(
        depender: *const ObjectAddress,
        referenced: *mut ObjectAddresses,
        behavior: DependencyType,
    );
}
#[pg_guard]
extern "C" {
    pub fn free_object_addresses(addrs: *mut ObjectAddresses);
}
#[pg_guard]
extern "C" {
    pub fn recordDependencyOn(
        depender: *const ObjectAddress,
        referenced: *const ObjectAddress,
        behavior: DependencyType,
    );
}
#[pg_guard]
extern "C" {
    pub fn recordMultipleDependencies(
        depender: *const ObjectAddress,
        referenced: *const ObjectAddress,
        nreferenced: ::std::os::raw::c_int,
        behavior: DependencyType,
    );
}
#[pg_guard]
extern "C" {
    pub fn recordDependencyOnCurrentExtension(object: *const ObjectAddress, isReplace: bool);
}
#[pg_guard]
extern "C" {
    pub fn deleteDependencyRecordsFor(
        classId: Oid,
        objectId: Oid,
        skipExtensionDeps: bool,
    ) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn deleteDependencyRecordsForClass(
        classId: Oid,
        objectId: Oid,
        refclassId: Oid,
        deptype: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn changeDependencyFor(
        classId: Oid,
        objectId: Oid,
        refClassId: Oid,
        oldRefObjectId: Oid,
        newRefObjectId: Oid,
    ) -> ::std::os::raw::c_long;
}
#[pg_guard]
extern "C" {
    pub fn getExtensionOfObject(classId: Oid, objectId: Oid) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn getAutoExtensionsOfObject(classId: Oid, objectId: Oid) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn sequenceIsOwned(
        seqId: Oid,
        deptype: ::std::os::raw::c_char,
        tableId: *mut Oid,
        colId: *mut int32,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn getOwnedSequences(relid: Oid, attnum: AttrNumber) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn getOwnedSequence(relid: Oid, attnum: AttrNumber) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_constraint_index(constraintId: Oid) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_index_constraint(indexId: Oid) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn recordSharedDependencyOn(
        depender: *mut ObjectAddress,
        referenced: *mut ObjectAddress,
        deptype: SharedDependencyType,
    );
}
#[pg_guard]
extern "C" {
    pub fn deleteSharedDependencyRecordsFor(classId: Oid, objectId: Oid, objectSubId: int32);
}
#[pg_guard]
extern "C" {
    pub fn recordDependencyOnOwner(classId: Oid, objectId: Oid, owner: Oid);
}
#[pg_guard]
extern "C" {
    pub fn changeDependencyOnOwner(classId: Oid, objectId: Oid, newOwnerId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn updateAclDependencies(
        classId: Oid,
        objectId: Oid,
        objectSubId: int32,
        ownerId: Oid,
        noldmembers: ::std::os::raw::c_int,
        oldmembers: *mut Oid,
        nnewmembers: ::std::os::raw::c_int,
        newmembers: *mut Oid,
    );
}
#[pg_guard]
extern "C" {
    pub fn checkSharedDependencies(
        classId: Oid,
        objectId: Oid,
        detail_msg: *mut *mut ::std::os::raw::c_char,
        detail_log_msg: *mut *mut ::std::os::raw::c_char,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn shdepLockAndCheckObject(classId: Oid, objectId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn copyTemplateDependencies(templateDbId: Oid, newDbId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn dropDatabaseDependencies(databaseId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn shdepDropOwned(relids: *mut List, behavior: DropBehavior);
}
#[pg_guard]
extern "C" {
    pub fn shdepReassignOwned(relids: *mut List, newrole: Oid);
}
pub type IndexBuildCallback = ::std::option::Option<
    unsafe extern "C" fn(
        index: Relation,
        htup: HeapTuple,
        values: *mut Datum,
        isnull: *mut bool,
        tupleIsAlive: bool,
        state: *mut ::std::os::raw::c_void,
    ),
>;
pub const IndexStateFlagsAction_INDEX_CREATE_SET_READY: IndexStateFlagsAction = 0;
pub const IndexStateFlagsAction_INDEX_CREATE_SET_VALID: IndexStateFlagsAction = 1;
pub const IndexStateFlagsAction_INDEX_DROP_CLEAR_VALID: IndexStateFlagsAction = 2;
pub const IndexStateFlagsAction_INDEX_DROP_SET_DEAD: IndexStateFlagsAction = 3;
pub type IndexStateFlagsAction = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn index_check_primary_key(
        heapRel: Relation,
        indexInfo: *mut IndexInfo,
        is_alter_table: bool,
        stmt: *mut IndexStmt,
    );
}
#[pg_guard]
extern "C" {
    pub fn index_create(
        heapRelation: Relation,
        indexRelationName: *const ::std::os::raw::c_char,
        indexRelationId: Oid,
        relFileNode: Oid,
        indexInfo: *mut IndexInfo,
        indexColNames: *mut List,
        accessMethodObjectId: Oid,
        tableSpaceId: Oid,
        collationObjectId: *mut Oid,
        classObjectId: *mut Oid,
        coloptions: *mut int16,
        reloptions: Datum,
        isprimary: bool,
        isconstraint: bool,
        deferrable: bool,
        initdeferred: bool,
        allow_system_table_mods: bool,
        skip_build: bool,
        concurrent: bool,
        is_internal: bool,
        if_not_exists: bool,
    ) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn index_constraint_create(
        heapRelation: Relation,
        indexRelationId: Oid,
        indexInfo: *mut IndexInfo,
        constraintName: *const ::std::os::raw::c_char,
        constraintType: ::std::os::raw::c_char,
        deferrable: bool,
        initdeferred: bool,
        mark_as_primary: bool,
        update_pgindex: bool,
        remove_old_dependencies: bool,
        allow_system_table_mods: bool,
        is_internal: bool,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn index_drop(indexId: Oid, concurrent: bool);
}
#[pg_guard]
extern "C" {
    pub fn BuildIndexInfo(index: Relation) -> *mut IndexInfo;
}
#[pg_guard]
extern "C" {
    pub fn BuildDummyIndexInfo(index: Relation) -> *mut IndexInfo;
}
#[pg_guard]
extern "C" {
    pub fn BuildSpeculativeIndexInfo(index: Relation, ii: *mut IndexInfo);
}
#[pg_guard]
extern "C" {
    pub fn FormIndexDatum(
        indexInfo: *mut IndexInfo,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn index_build(
        heapRelation: Relation,
        indexRelation: Relation,
        indexInfo: *mut IndexInfo,
        isprimary: bool,
        isreindex: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn IndexBuildHeapScan(
        heapRelation: Relation,
        indexRelation: Relation,
        indexInfo: *mut IndexInfo,
        allow_sync: bool,
        callback: IndexBuildCallback,
        callback_state: *mut ::std::os::raw::c_void,
    ) -> f64;
}
#[pg_guard]
extern "C" {
    pub fn IndexBuildHeapRangeScan(
        heapRelation: Relation,
        indexRelation: Relation,
        indexInfo: *mut IndexInfo,
        allow_sync: bool,
        anyvisible: bool,
        start_blockno: BlockNumber,
        end_blockno: BlockNumber,
        callback: IndexBuildCallback,
        callback_state: *mut ::std::os::raw::c_void,
    ) -> f64;
}
#[pg_guard]
extern "C" {
    pub fn validate_index(heapId: Oid, indexId: Oid, snapshot: Snapshot);
}
#[pg_guard]
extern "C" {
    pub fn index_set_state_flags(indexId: Oid, action: IndexStateFlagsAction);
}
#[pg_guard]
extern "C" {
    pub fn IndexGetRelation(indexId: Oid, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn reindex_index(
        indexId: Oid,
        skip_constraint_checks: bool,
        relpersistence: ::std::os::raw::c_char,
        options: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn reindex_relation(
        relid: Oid,
        flags: ::std::os::raw::c_int,
        options: ::std::os::raw::c_int,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ReindexIsProcessingHeap(heapOid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ReindexIsProcessingIndex(indexOid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ResetReindexState(nestLevel: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Debug)]
pub struct _FuncCandidateList {
    pub next: *mut _FuncCandidateList,
    pub pathpos: ::std::os::raw::c_int,
    pub oid: Oid,
    pub nargs: ::std::os::raw::c_int,
    pub nvargs: ::std::os::raw::c_int,
    pub ndargs: ::std::os::raw::c_int,
    pub argnumbers: *mut ::std::os::raw::c_int,
    pub args: __IncompleteArrayField<Oid>,
}
impl Default for _FuncCandidateList {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type FuncCandidateList = *mut _FuncCandidateList;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OverrideSearchPath {
    pub schemas: *mut List,
    pub addCatalog: bool,
    pub addTemp: bool,
}
impl Default for OverrideSearchPath {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type RangeVarGetRelidCallback = ::std::option::Option<
    unsafe extern "C" fn(
        relation: *const RangeVar,
        relId: Oid,
        oldRelId: Oid,
        callback_arg: *mut ::std::os::raw::c_void,
    ),
>;
#[pg_guard]
extern "C" {
    pub fn RangeVarGetRelidExtended(
        relation: *const RangeVar,
        lockmode: LOCKMODE,
        missing_ok: bool,
        nowait: bool,
        callback: RangeVarGetRelidCallback,
        callback_arg: *mut ::std::os::raw::c_void,
    ) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn RangeVarGetCreationNamespace(newRelation: *const RangeVar) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn RangeVarGetAndCheckCreationNamespace(
        newRelation: *mut RangeVar,
        lockmode: LOCKMODE,
        existing_relation_id: *mut Oid,
    ) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn RangeVarAdjustRelationPersistence(newRelation: *mut RangeVar, nspid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn RelnameGetRelid(relname: *const ::std::os::raw::c_char) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn RelationIsVisible(relid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn TypenameGetTypid(typname: *const ::std::os::raw::c_char) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn TypenameGetTypidExtended(typname: *const ::std::os::raw::c_char, temp_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn TypeIsVisible(typid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn FuncnameGetCandidates(
        names: *mut List,
        nargs: ::std::os::raw::c_int,
        argnames: *mut List,
        expand_variadic: bool,
        expand_defaults: bool,
        missing_ok: bool,
    ) -> FuncCandidateList;
}
#[pg_guard]
extern "C" {
    pub fn FunctionIsVisible(funcid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn OpernameGetOprid(names: *mut List, oprleft: Oid, oprright: Oid) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn OpernameGetCandidates(
        names: *mut List,
        oprkind: ::std::os::raw::c_char,
        missing_schema_ok: bool,
    ) -> FuncCandidateList;
}
#[pg_guard]
extern "C" {
    pub fn OperatorIsVisible(oprid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn OpclassnameGetOpcid(amid: Oid, opcname: *const ::std::os::raw::c_char) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn OpclassIsVisible(opcid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn OpfamilynameGetOpfid(amid: Oid, opfname: *const ::std::os::raw::c_char) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn OpfamilyIsVisible(opfid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn CollationGetCollid(collname: *const ::std::os::raw::c_char) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn CollationIsVisible(collid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ConversionGetConid(conname: *const ::std::os::raw::c_char) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn ConversionIsVisible(conid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_statistics_object_oid(names: *mut List, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn StatisticsObjIsVisible(stxid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_ts_parser_oid(names: *mut List, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn TSParserIsVisible(prsId: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_ts_dict_oid(names: *mut List, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn TSDictionaryIsVisible(dictId: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_ts_template_oid(names: *mut List, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn TSTemplateIsVisible(tmplId: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_ts_config_oid(names: *mut List, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn TSConfigIsVisible(cfgid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn DeconstructQualifiedName(
        names: *mut List,
        nspname_p: *mut *mut ::std::os::raw::c_char,
        objname_p: *mut *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn LookupNamespaceNoError(nspname: *const ::std::os::raw::c_char) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn LookupExplicitNamespace(nspname: *const ::std::os::raw::c_char, missing_ok: bool)
        -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_namespace_oid(nspname: *const ::std::os::raw::c_char, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn LookupCreationNamespace(nspname: *const ::std::os::raw::c_char) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn CheckSetNamespace(oldNspOid: Oid, nspOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn QualifiedNameGetCreationNamespace(
        names: *mut List,
        objname_p: *mut *mut ::std::os::raw::c_char,
    ) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn makeRangeVarFromNameList(names: *mut List) -> *mut RangeVar;
}
#[pg_guard]
extern "C" {
    pub fn NameListToString(names: *mut List) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn NameListToQuotedString(names: *mut List) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn isTempNamespace(namespaceId: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn isTempToastNamespace(namespaceId: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn isTempOrTempToastNamespace(namespaceId: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn isAnyTempNamespace(namespaceId: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn isOtherTempNamespace(namespaceId: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetTempNamespaceBackendId(namespaceId: Oid) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn GetTempToastNamespace() -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn GetTempNamespaceState(tempNamespaceId: *mut Oid, tempToastNamespaceId: *mut Oid);
}
#[pg_guard]
extern "C" {
    pub fn SetTempNamespaceState(tempNamespaceId: Oid, tempToastNamespaceId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn ResetTempTableNamespace();
}
#[pg_guard]
extern "C" {
    pub fn GetOverrideSearchPath(context: MemoryContext) -> *mut OverrideSearchPath;
}
#[pg_guard]
extern "C" {
    pub fn CopyOverrideSearchPath(path: *mut OverrideSearchPath) -> *mut OverrideSearchPath;
}
#[pg_guard]
extern "C" {
    pub fn OverrideSearchPathMatchesCurrent(path: *mut OverrideSearchPath) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn PushOverrideSearchPath(newpath: *mut OverrideSearchPath);
}
#[pg_guard]
extern "C" {
    pub fn PopOverrideSearchPath();
}
#[pg_guard]
extern "C" {
    pub fn get_collation_oid(collname: *mut List, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_conversion_oid(conname: *mut List, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn FindDefaultConversionProc(for_encoding: int32, to_encoding: int32) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn InitializeSearchPath();
}
#[pg_guard]
extern "C" {
    pub fn AtEOXact_Namespace(isCommit: bool, parallel: bool);
}
#[pg_guard]
extern "C" {
    pub fn AtEOSubXact_Namespace(
        isCommit: bool,
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
    );
}
#[pg_guard]
extern "C" {
    pub static mut namespace_search_path: *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn fetch_search_path(includeImplicit: bool) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn fetch_search_path_array(
        sarray: *mut Oid,
        sarray_len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_enum {
    pub enumtypid: Oid,
    pub enumsortorder: float4,
    pub enumlabel: NameData,
}
impl Default for FormData_pg_enum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_enum = *mut FormData_pg_enum;
#[pg_guard]
extern "C" {
    pub fn EnumValuesCreate(enumTypeOid: Oid, vals: *mut List);
}
#[pg_guard]
extern "C" {
    pub fn EnumValuesDelete(enumTypeOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn AddEnumLabel(
        enumTypeOid: Oid,
        newVal: *const ::std::os::raw::c_char,
        neighbor: *const ::std::os::raw::c_char,
        newValIsAfter: bool,
        skipIfExists: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn RenameEnumLabel(
        enumTypeOid: Oid,
        oldVal: *const ::std::os::raw::c_char,
        newVal: *const ::std::os::raw::c_char,
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct FormData_pg_proc {
    pub proname: NameData,
    pub pronamespace: Oid,
    pub proowner: Oid,
    pub prolang: Oid,
    pub procost: float4,
    pub prorows: float4,
    pub provariadic: Oid,
    pub protransform: regproc,
    pub proisagg: bool,
    pub proiswindow: bool,
    pub prosecdef: bool,
    pub proleakproof: bool,
    pub proisstrict: bool,
    pub proretset: bool,
    pub provolatile: ::std::os::raw::c_char,
    pub proparallel: ::std::os::raw::c_char,
    pub pronargs: int16,
    pub pronargdefaults: int16,
    pub prorettype: Oid,
    pub proargtypes: oidvector,
}
impl Default for FormData_pg_proc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_proc = *mut FormData_pg_proc;
#[repr(C)]
#[derive(Debug)]
pub struct FormData_pg_trigger {
    pub tgrelid: Oid,
    pub tgname: NameData,
    pub tgfoid: Oid,
    pub tgtype: int16,
    pub tgenabled: ::std::os::raw::c_char,
    pub tgisinternal: bool,
    pub tgconstrrelid: Oid,
    pub tgconstrindid: Oid,
    pub tgconstraint: Oid,
    pub tgdeferrable: bool,
    pub tginitdeferred: bool,
    pub tgnargs: int16,
    pub tgattr: int2vector,
}
impl Default for FormData_pg_trigger {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_trigger = *mut FormData_pg_trigger;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_type {
    pub typname: NameData,
    pub typnamespace: Oid,
    pub typowner: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typtype: ::std::os::raw::c_char,
    pub typcategory: ::std::os::raw::c_char,
    pub typispreferred: bool,
    pub typisdefined: bool,
    pub typdelim: ::std::os::raw::c_char,
    pub typrelid: Oid,
    pub typelem: Oid,
    pub typarray: Oid,
    pub typinput: regproc,
    pub typoutput: regproc,
    pub typreceive: regproc,
    pub typsend: regproc,
    pub typmodin: regproc,
    pub typmodout: regproc,
    pub typanalyze: regproc,
    pub typalign: ::std::os::raw::c_char,
    pub typstorage: ::std::os::raw::c_char,
    pub typnotnull: bool,
    pub typbasetype: Oid,
    pub typtypmod: int32,
    pub typndims: int32,
    pub typcollation: Oid,
}
impl Default for FormData_pg_type {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_type = *mut FormData_pg_type;
#[pg_guard]
extern "C" {
    pub fn CommentObject(stmt: *mut CommentStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn DeleteComments(oid: Oid, classoid: Oid, subid: int32);
}
#[pg_guard]
extern "C" {
    pub fn CreateComments(
        oid: Oid,
        classoid: Oid,
        subid: int32,
        comment: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn DeleteSharedComments(oid: Oid, classoid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn CreateSharedComments(oid: Oid, classoid: Oid, comment: *mut ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn GetComment(oid: Oid, classoid: Oid, subid: int32) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn createdb(pstate: *mut ParseState, stmt: *const CreatedbStmt) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn dropdb(dbname: *const ::std::os::raw::c_char, missing_ok: bool);
}
#[pg_guard]
extern "C" {
    pub fn RenameDatabase(
        oldname: *const ::std::os::raw::c_char,
        newname: *const ::std::os::raw::c_char,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn AlterDatabase(
        pstate: *mut ParseState,
        stmt: *mut AlterDatabaseStmt,
        isTopLevel: bool,
    ) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn AlterDatabaseSet(stmt: *mut AlterDatabaseSetStmt) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn AlterDatabaseOwner(
        dbname: *const ::std::os::raw::c_char,
        newOwnerId: Oid,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn get_database_oid(dbname: *const ::std::os::raw::c_char, missingok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_database_name(dbid: Oid) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn check_encoding_locale_matches(
        encoding: ::std::os::raw::c_int,
        collate: *const ::std::os::raw::c_char,
        ctype: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn RemoveObjects(stmt: *mut DropStmt);
}
#[pg_guard]
extern "C" {
    pub fn DefineIndex(
        relationId: Oid,
        stmt: *mut IndexStmt,
        indexRelationId: Oid,
        is_alter_table: bool,
        check_rights: bool,
        check_not_in_use: bool,
        skip_build: bool,
        quiet: bool,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn ReindexIndex(indexRelation: *mut RangeVar, options: ::std::os::raw::c_int) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn ReindexTable(relation: *mut RangeVar, options: ::std::os::raw::c_int) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn ReindexMultipleTables(
        objectName: *const ::std::os::raw::c_char,
        objectKind: ReindexObjectType,
        options: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn makeObjectName(
        name1: *const ::std::os::raw::c_char,
        name2: *const ::std::os::raw::c_char,
        label: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn ChooseRelationName(
        name1: *const ::std::os::raw::c_char,
        name2: *const ::std::os::raw::c_char,
        label: *const ::std::os::raw::c_char,
        namespaceid: Oid,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn CheckIndexCompatible(
        oldId: Oid,
        accessMethodName: *mut ::std::os::raw::c_char,
        attributeList: *mut List,
        exclusionOpNames: *mut List,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetDefaultOpClass(type_id: Oid, am_id: Oid) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn ResolveOpClass(
        opclass: *mut List,
        attrType: Oid,
        accessMethodName: *mut ::std::os::raw::c_char,
        accessMethodId: Oid,
    ) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn CreateFunction(pstate: *mut ParseState, stmt: *mut CreateFunctionStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveFunctionById(funcOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn SetFunctionReturnType(funcOid: Oid, newRetType: Oid);
}
#[pg_guard]
extern "C" {
    pub fn SetFunctionArgType(funcOid: Oid, argIndex: ::std::os::raw::c_int, newArgType: Oid);
}
#[pg_guard]
extern "C" {
    pub fn AlterFunction(pstate: *mut ParseState, stmt: *mut AlterFunctionStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn CreateCast(stmt: *mut CreateCastStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn DropCastById(castOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn CreateTransform(stmt: *mut CreateTransformStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn DropTransformById(transformOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn IsThereFunctionInNamespace(
        proname: *const ::std::os::raw::c_char,
        pronargs: ::std::os::raw::c_int,
        proargtypes: *mut oidvector,
        nspOid: Oid,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecuteDoStmt(stmt: *mut DoStmt);
}
#[pg_guard]
extern "C" {
    pub fn get_cast_oid(sourcetypeid: Oid, targettypeid: Oid, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_transform_oid(type_id: Oid, lang_id: Oid, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn interpret_function_parameter_list(
        pstate: *mut ParseState,
        parameters: *mut List,
        languageOid: Oid,
        is_aggregate: bool,
        parameterTypes: *mut *mut oidvector,
        allParameterTypes: *mut *mut ArrayType,
        parameterModes: *mut *mut ArrayType,
        parameterNames: *mut *mut ArrayType,
        parameterDefaults: *mut *mut List,
        variadicArgType: *mut Oid,
        requiredResultType: *mut Oid,
    );
}
#[pg_guard]
extern "C" {
    pub fn DefineOperator(names: *mut List, parameters: *mut List) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveOperatorById(operOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn AlterOperator(stmt: *mut AlterOperatorStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn CreateStatistics(stmt: *mut CreateStatsStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveStatisticsById(statsOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn UpdateStatisticsForTypeChange(
        statsOid: Oid,
        relationOid: Oid,
        attnum: ::std::os::raw::c_int,
        oldColumnType: Oid,
        newColumnType: Oid,
    );
}
#[pg_guard]
extern "C" {
    pub fn DefineAggregate(
        pstate: *mut ParseState,
        name: *mut List,
        args: *mut List,
        oldstyle: bool,
        parameters: *mut List,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn DefineOpClass(stmt: *mut CreateOpClassStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn DefineOpFamily(stmt: *mut CreateOpFamilyStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn AlterOpFamily(stmt: *mut AlterOpFamilyStmt) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn RemoveOpClassById(opclassOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn RemoveOpFamilyById(opfamilyOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn RemoveAmOpEntryById(entryOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn RemoveAmProcEntryById(entryOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn IsThereOpClassInNamespace(
        opcname: *const ::std::os::raw::c_char,
        opcmethod: Oid,
        opcnamespace: Oid,
    );
}
#[pg_guard]
extern "C" {
    pub fn IsThereOpFamilyInNamespace(
        opfname: *const ::std::os::raw::c_char,
        opfmethod: Oid,
        opfnamespace: Oid,
    );
}
#[pg_guard]
extern "C" {
    pub fn get_opclass_oid(amID: Oid, opclassname: *mut List, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_opfamily_oid(amID: Oid, opfamilyname: *mut List, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn DefineTSParser(names: *mut List, parameters: *mut List) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveTSParserById(prsId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn DefineTSDictionary(names: *mut List, parameters: *mut List) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveTSDictionaryById(dictId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn AlterTSDictionary(stmt: *mut AlterTSDictionaryStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn DefineTSTemplate(names: *mut List, parameters: *mut List) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveTSTemplateById(tmplId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn DefineTSConfiguration(
        names: *mut List,
        parameters: *mut List,
        copied: *mut ObjectAddress,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveTSConfigurationById(cfgId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn AlterTSConfiguration(stmt: *mut AlterTSConfigurationStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn serialize_deflist(deflist: *mut List) -> *mut text;
}
#[pg_guard]
extern "C" {
    pub fn deserialize_deflist(txt: Datum) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn AlterForeignServerOwner(
        name: *const ::std::os::raw::c_char,
        newOwnerId: Oid,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn AlterForeignServerOwner_oid(arg1: Oid, newOwnerId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn AlterForeignDataWrapperOwner(
        name: *const ::std::os::raw::c_char,
        newOwnerId: Oid,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn AlterForeignDataWrapperOwner_oid(fwdId: Oid, newOwnerId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn CreateForeignDataWrapper(stmt: *mut CreateFdwStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn AlterForeignDataWrapper(stmt: *mut AlterFdwStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveForeignDataWrapperById(fdwId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn CreateForeignServer(stmt: *mut CreateForeignServerStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn AlterForeignServer(stmt: *mut AlterForeignServerStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveForeignServerById(srvId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn CreateUserMapping(stmt: *mut CreateUserMappingStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn AlterUserMapping(stmt: *mut AlterUserMappingStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveUserMapping(stmt: *mut DropUserMappingStmt) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn RemoveUserMappingById(umId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn CreateForeignTable(stmt: *mut CreateForeignTableStmt, relid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn ImportForeignSchema(stmt: *mut ImportForeignSchemaStmt);
}
#[pg_guard]
extern "C" {
    pub fn transformGenericOptions(
        catalogId: Oid,
        oldOptions: Datum,
        options: *mut List,
        fdwvalidator: Oid,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn CreateAccessMethod(stmt: *mut CreateAmStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveAccessMethodById(amOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn get_index_am_oid(amname: *const ::std::os::raw::c_char, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_am_oid(amname: *const ::std::os::raw::c_char, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn get_am_name(amOid: Oid) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn defGetString(def: *mut DefElem) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn defGetNumeric(def: *mut DefElem) -> f64;
}
#[pg_guard]
extern "C" {
    pub fn defGetBoolean(def: *mut DefElem) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn defGetInt32(def: *mut DefElem) -> int32;
}
#[pg_guard]
extern "C" {
    pub fn defGetInt64(def: *mut DefElem) -> int64;
}
#[pg_guard]
extern "C" {
    pub fn defGetQualifiedName(def: *mut DefElem) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn defGetTypeName(def: *mut DefElem) -> *mut TypeName;
}
#[pg_guard]
extern "C" {
    pub fn defGetTypeLength(def: *mut DefElem) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn defGetStringList(def: *mut DefElem) -> *mut List;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_event_trigger {
    pub evtname: NameData,
    pub evtevent: NameData,
    pub evtowner: Oid,
    pub evtfoid: Oid,
    pub evtenabled: ::std::os::raw::c_char,
}
impl Default for FormData_pg_event_trigger {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_event_trigger = *mut FormData_pg_event_trigger;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InternalGrant {
    pub is_grant: bool,
    pub objtype: GrantObjectType,
    pub objects: *mut List,
    pub all_privs: bool,
    pub privileges: AclMode,
    pub col_privs: *mut List,
    pub grantees: *mut List,
    pub grant_option: bool,
    pub behavior: DropBehavior,
}
impl Default for InternalGrant {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CollectedCommandType_SCT_Simple: CollectedCommandType = 0;
pub const CollectedCommandType_SCT_AlterTable: CollectedCommandType = 1;
pub const CollectedCommandType_SCT_Grant: CollectedCommandType = 2;
pub const CollectedCommandType_SCT_AlterOpFamily: CollectedCommandType = 3;
pub const CollectedCommandType_SCT_AlterDefaultPrivileges: CollectedCommandType = 4;
pub const CollectedCommandType_SCT_CreateOpClass: CollectedCommandType = 5;
pub const CollectedCommandType_SCT_AlterTSConfig: CollectedCommandType = 6;
pub type CollectedCommandType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedATSubcmd {
    pub address: ObjectAddress,
    pub parsetree: *mut Node,
}
impl Default for CollectedATSubcmd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct CollectedCommand {
    pub type_: CollectedCommandType,
    pub in_extension: bool,
    pub parsetree: *mut Node,
    pub d: CollectedCommand__bindgen_ty_1,
    pub parent: *mut CollectedCommand,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CollectedCommand__bindgen_ty_1 {
    pub simple: CollectedCommand__bindgen_ty_1__bindgen_ty_1,
    pub alterTable: CollectedCommand__bindgen_ty_1__bindgen_ty_2,
    pub grant: CollectedCommand__bindgen_ty_1__bindgen_ty_3,
    pub opfam: CollectedCommand__bindgen_ty_1__bindgen_ty_4,
    pub createopc: CollectedCommand__bindgen_ty_1__bindgen_ty_5,
    pub atscfg: CollectedCommand__bindgen_ty_1__bindgen_ty_6,
    pub defprivs: CollectedCommand__bindgen_ty_1__bindgen_ty_7,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_1 {
    pub address: ObjectAddress,
    pub secondaryObject: ObjectAddress,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_2 {
    pub objectId: Oid,
    pub classId: Oid,
    pub subcmds: *mut List,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_3 {
    pub istmt: *mut InternalGrant,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_4 {
    pub address: ObjectAddress,
    pub operators: *mut List,
    pub procedures: *mut List,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_5 {
    pub address: ObjectAddress,
    pub operators: *mut List,
    pub procedures: *mut List,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_5 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_6 {
    pub address: ObjectAddress,
    pub dictIds: *mut Oid,
    pub ndicts: ::std::os::raw::c_int,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_7 {
    pub objtype: GrantObjectType,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_7 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for CollectedCommand__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for CollectedCommand {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EventTriggerData {
    pub type_: NodeTag,
    pub event: *const ::std::os::raw::c_char,
    pub parsetree: *mut Node,
    pub tag: *const ::std::os::raw::c_char,
}
impl Default for EventTriggerData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn CreateEventTrigger(stmt: *mut CreateEventTrigStmt) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn RemoveEventTriggerById(ctrigOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn get_event_trigger_oid(trigname: *const ::std::os::raw::c_char, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn AlterEventTrigger(stmt: *mut AlterEventTrigStmt) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn AlterEventTriggerOwner(
        name: *const ::std::os::raw::c_char,
        newOwnerId: Oid,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn AlterEventTriggerOwner_oid(arg1: Oid, newOwnerId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerSupportsObjectType(obtype: ObjectType) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerSupportsObjectClass(objclass: ObjectClass) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerSupportsGrantObjectType(objtype: GrantObjectType) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerDDLCommandStart(parsetree: *mut Node);
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerDDLCommandEnd(parsetree: *mut Node);
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerSQLDrop(parsetree: *mut Node);
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerTableRewrite(
        parsetree: *mut Node,
        tableOid: Oid,
        reason: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerBeginCompleteQuery() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerEndCompleteQuery();
}
#[pg_guard]
extern "C" {
    pub fn trackDroppedObjectsNeeded() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerSQLDropAddObject(object: *const ObjectAddress, original: bool, normal: bool);
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerInhibitCommandCollection();
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerUndoInhibitCommandCollection();
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerCollectSimpleCommand(
        address: ObjectAddress,
        secondaryObject: ObjectAddress,
        parsetree: *mut Node,
    );
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerAlterTableStart(parsetree: *mut Node);
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerAlterTableRelid(objectId: Oid);
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerCollectAlterTableSubcmd(subcmd: *mut Node, address: ObjectAddress);
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerAlterTableEnd();
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerCollectGrant(istmt: *mut InternalGrant);
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerCollectAlterOpFam(
        stmt: *mut AlterOpFamilyStmt,
        opfamoid: Oid,
        operators: *mut List,
        procedures: *mut List,
    );
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerCollectCreateOpClass(
        stmt: *mut CreateOpClassStmt,
        opcoid: Oid,
        operators: *mut List,
        procedures: *mut List,
    );
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerCollectAlterTSConfig(
        stmt: *mut AlterTSConfigurationStmt,
        cfgId: Oid,
        dictIds: *mut Oid,
        ndicts: ::std::os::raw::c_int,
    );
}
#[pg_guard]
extern "C" {
    pub fn EventTriggerCollectAlterDefPrivs(stmt: *mut AlterDefaultPrivilegesStmt);
}
pub const ExplainFormat_EXPLAIN_FORMAT_TEXT: ExplainFormat = 0;
pub const ExplainFormat_EXPLAIN_FORMAT_XML: ExplainFormat = 1;
pub const ExplainFormat_EXPLAIN_FORMAT_JSON: ExplainFormat = 2;
pub const ExplainFormat_EXPLAIN_FORMAT_YAML: ExplainFormat = 3;
pub type ExplainFormat = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExplainState {
    pub str_: StringInfo,
    pub verbose: bool,
    pub analyze: bool,
    pub costs: bool,
    pub buffers: bool,
    pub timing: bool,
    pub summary: bool,
    pub format: ExplainFormat,
    pub indent: ::std::os::raw::c_int,
    pub grouping_stack: *mut List,
    pub pstmt: *mut PlannedStmt,
    pub rtable: *mut List,
    pub rtable_names: *mut List,
    pub deparse_cxt: *mut List,
    pub printed_subplans: *mut Bitmapset,
}
impl Default for ExplainState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExplainOneQuery_hook_type = ::std::option::Option<
    unsafe extern "C" fn(
        query: *mut Query,
        cursorOptions: ::std::os::raw::c_int,
        into: *mut IntoClause,
        es: *mut ExplainState,
        queryString: *const ::std::os::raw::c_char,
        params: ParamListInfo,
    ),
>;
#[pg_guard]
extern "C" {
    pub static mut ExplainOneQuery_hook: ExplainOneQuery_hook_type;
}
pub type explain_get_index_name_hook_type =
    ::std::option::Option<unsafe extern "C" fn(indexId: Oid) -> *const ::std::os::raw::c_char>;
#[pg_guard]
extern "C" {
    pub static mut explain_get_index_name_hook: explain_get_index_name_hook_type;
}
#[pg_guard]
extern "C" {
    pub fn ExplainQuery(
        pstate: *mut ParseState,
        stmt: *mut ExplainStmt,
        queryString: *const ::std::os::raw::c_char,
        params: ParamListInfo,
        queryEnv: *mut QueryEnvironment,
        dest: *mut DestReceiver,
    );
}
#[pg_guard]
extern "C" {
    pub fn NewExplainState() -> *mut ExplainState;
}
#[pg_guard]
extern "C" {
    pub fn ExplainResultDesc(stmt: *mut ExplainStmt) -> TupleDesc;
}
#[pg_guard]
extern "C" {
    pub fn ExplainOneUtility(
        utilityStmt: *mut Node,
        into: *mut IntoClause,
        es: *mut ExplainState,
        queryString: *const ::std::os::raw::c_char,
        params: ParamListInfo,
        queryEnv: *mut QueryEnvironment,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExplainOnePlan(
        plannedstmt: *mut PlannedStmt,
        into: *mut IntoClause,
        es: *mut ExplainState,
        queryString: *const ::std::os::raw::c_char,
        params: ParamListInfo,
        queryEnv: *mut QueryEnvironment,
        planduration: *const instr_time,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExplainPrintPlan(es: *mut ExplainState, queryDesc: *mut QueryDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExplainPrintTriggers(es: *mut ExplainState, queryDesc: *mut QueryDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExplainQueryText(es: *mut ExplainState, queryDesc: *mut QueryDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExplainBeginOutput(es: *mut ExplainState);
}
#[pg_guard]
extern "C" {
    pub fn ExplainEndOutput(es: *mut ExplainState);
}
#[pg_guard]
extern "C" {
    pub fn ExplainSeparatePlans(es: *mut ExplainState);
}
#[pg_guard]
extern "C" {
    pub fn ExplainPropertyList(
        qlabel: *const ::std::os::raw::c_char,
        data: *mut List,
        es: *mut ExplainState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExplainPropertyListNested(
        qlabel: *const ::std::os::raw::c_char,
        data: *mut List,
        es: *mut ExplainState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExplainPropertyText(
        qlabel: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        es: *mut ExplainState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExplainPropertyInteger(
        qlabel: *const ::std::os::raw::c_char,
        value: ::std::os::raw::c_int,
        es: *mut ExplainState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExplainPropertyLong(
        qlabel: *const ::std::os::raw::c_char,
        value: ::std::os::raw::c_long,
        es: *mut ExplainState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExplainPropertyFloat(
        qlabel: *const ::std::os::raw::c_char,
        value: f64,
        ndigits: ::std::os::raw::c_int,
        es: *mut ExplainState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExplainPropertyBool(
        qlabel: *const ::std::os::raw::c_char,
        value: bool,
        es: *mut ExplainState,
    );
}
#[pg_guard]
extern "C" {
    pub fn CreateProceduralLanguage(stmt: *mut CreatePLangStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn DropProceduralLanguageById(langOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn PLTemplateExists(languageName: *const ::std::os::raw::c_char) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn get_language_oid(langname: *const ::std::os::raw::c_char, missing_ok: bool) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn DefineRelation(
        stmt: *mut CreateStmt,
        relkind: ::std::os::raw::c_char,
        ownerId: Oid,
        typaddress: *mut ObjectAddress,
        queryString: *const ::std::os::raw::c_char,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveRelations(drop: *mut DropStmt);
}
#[pg_guard]
extern "C" {
    pub fn AlterTableLookupRelation(stmt: *mut AlterTableStmt, lockmode: LOCKMODE) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn AlterTable(relid: Oid, lockmode: LOCKMODE, stmt: *mut AlterTableStmt);
}
#[pg_guard]
extern "C" {
    pub fn AlterTableGetLockLevel(cmds: *mut List) -> LOCKMODE;
}
#[pg_guard]
extern "C" {
    pub fn ATExecChangeOwner(
        relationOid: Oid,
        newOwnerId: Oid,
        recursing: bool,
        lockmode: LOCKMODE,
    );
}
#[pg_guard]
extern "C" {
    pub fn AlterTableInternal(relid: Oid, cmds: *mut List, recurse: bool);
}
#[pg_guard]
extern "C" {
    pub fn AlterTableMoveAll(stmt: *mut AlterTableMoveAllStmt) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn AlterTableNamespace(
        stmt: *mut AlterObjectSchemaStmt,
        oldschema: *mut Oid,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn AlterTableNamespaceInternal(
        rel: Relation,
        oldNspOid: Oid,
        nspOid: Oid,
        objsMoved: *mut ObjectAddresses,
    );
}
#[pg_guard]
extern "C" {
    pub fn AlterRelationNamespaceInternal(
        classRel: Relation,
        relOid: Oid,
        oldNspOid: Oid,
        newNspOid: Oid,
        hasDependEntry: bool,
        objsMoved: *mut ObjectAddresses,
    );
}
#[pg_guard]
extern "C" {
    pub fn CheckTableNotInUse(rel: Relation, stmt: *const ::std::os::raw::c_char);
}
#[pg_guard]
extern "C" {
    pub fn ExecuteTruncate(stmt: *mut TruncateStmt);
}
#[pg_guard]
extern "C" {
    pub fn SetRelationHasSubclass(relationId: Oid, relhassubclass: bool);
}
#[pg_guard]
extern "C" {
    pub fn renameatt(stmt: *mut RenameStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn renameatt_type(stmt: *mut RenameStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RenameConstraint(stmt: *mut RenameStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RenameRelation(stmt: *mut RenameStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RenameRelationInternal(
        myrelid: Oid,
        newrelname: *const ::std::os::raw::c_char,
        is_internal: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn find_composite_type_dependencies(
        typeOid: Oid,
        origRelation: Relation,
        origTypeName: *const ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn check_of_type(typetuple: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn register_on_commit_action(relid: Oid, action: OnCommitAction);
}
#[pg_guard]
extern "C" {
    pub fn remove_on_commit_action(relid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn PreCommit_on_commit_actions();
}
#[pg_guard]
extern "C" {
    pub fn AtEOXact_on_commit_actions(isCommit: bool);
}
#[pg_guard]
extern "C" {
    pub fn AtEOSubXact_on_commit_actions(
        isCommit: bool,
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
    );
}
#[pg_guard]
extern "C" {
    pub fn RangeVarCallbackOwnsTable(
        relation: *const RangeVar,
        relId: Oid,
        oldRelId: Oid,
        arg: *mut ::std::os::raw::c_void,
    );
}
#[pg_guard]
extern "C" {
    pub fn RangeVarCallbackOwnsRelation(
        relation: *const RangeVar,
        relId: Oid,
        oldRelId: Oid,
        noCatalogs: *mut ::std::os::raw::c_void,
    );
}
pub type TriggerEvent = uint32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerData {
    pub type_: NodeTag,
    pub tg_event: TriggerEvent,
    pub tg_relation: Relation,
    pub tg_trigtuple: HeapTuple,
    pub tg_newtuple: HeapTuple,
    pub tg_trigger: *mut Trigger,
    pub tg_trigtuplebuf: Buffer,
    pub tg_newtuplebuf: Buffer,
    pub tg_oldtable: *mut Tuplestorestate,
    pub tg_newtable: *mut Tuplestorestate,
}
impl Default for TriggerData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AfterTriggersTableData {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TransitionCaptureState {
    pub tcs_delete_old_table: bool,
    pub tcs_update_old_table: bool,
    pub tcs_update_new_table: bool,
    pub tcs_insert_new_table: bool,
    pub tcs_map: *mut TupleConversionMap,
    pub tcs_original_insert_tuple: HeapTuple,
    pub tcs_private: *mut AfterTriggersTableData,
}
impl Default for TransitionCaptureState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut SessionReplicationRole: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn CreateTrigger(
        stmt: *mut CreateTrigStmt,
        queryString: *const ::std::os::raw::c_char,
        relOid: Oid,
        refRelOid: Oid,
        constraintOid: Oid,
        indexOid: Oid,
        isInternal: bool,
    ) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn RemoveTriggerById(trigOid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn get_trigger_oid(
        relid: Oid,
        name: *const ::std::os::raw::c_char,
        missing_ok: bool,
    ) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn renametrig(stmt: *mut RenameStmt) -> ObjectAddress;
}
#[pg_guard]
extern "C" {
    pub fn EnableDisableTrigger(
        rel: Relation,
        tgname: *const ::std::os::raw::c_char,
        fires_when: ::std::os::raw::c_char,
        skip_system: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn RelationBuildTriggers(relation: Relation);
}
#[pg_guard]
extern "C" {
    pub fn CopyTriggerDesc(trigdesc: *mut TriggerDesc) -> *mut TriggerDesc;
}
#[pg_guard]
extern "C" {
    pub fn FindTriggerIncompatibleWithInheritance(
        trigdesc: *mut TriggerDesc,
    ) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn MakeTransitionCaptureState(
        trigdesc: *mut TriggerDesc,
        relid: Oid,
        cmdType: CmdType,
    ) -> *mut TransitionCaptureState;
}
#[pg_guard]
extern "C" {
    pub fn FreeTriggerDesc(trigdesc: *mut TriggerDesc);
}
#[pg_guard]
extern "C" {
    pub fn ExecBSInsertTriggers(estate: *mut EState, relinfo: *mut ResultRelInfo);
}
#[pg_guard]
extern "C" {
    pub fn ExecASInsertTriggers(
        estate: *mut EState,
        relinfo: *mut ResultRelInfo,
        transition_capture: *mut TransitionCaptureState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecBRInsertTriggers(
        estate: *mut EState,
        relinfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecARInsertTriggers(
        estate: *mut EState,
        relinfo: *mut ResultRelInfo,
        trigtuple: HeapTuple,
        recheckIndexes: *mut List,
        transition_capture: *mut TransitionCaptureState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecIRInsertTriggers(
        estate: *mut EState,
        relinfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecBSDeleteTriggers(estate: *mut EState, relinfo: *mut ResultRelInfo);
}
#[pg_guard]
extern "C" {
    pub fn ExecASDeleteTriggers(
        estate: *mut EState,
        relinfo: *mut ResultRelInfo,
        transition_capture: *mut TransitionCaptureState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecBRDeleteTriggers(
        estate: *mut EState,
        epqstate: *mut EPQState,
        relinfo: *mut ResultRelInfo,
        tupleid: ItemPointer,
        fdw_trigtuple: HeapTuple,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ExecARDeleteTriggers(
        estate: *mut EState,
        relinfo: *mut ResultRelInfo,
        tupleid: ItemPointer,
        fdw_trigtuple: HeapTuple,
        transition_capture: *mut TransitionCaptureState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecIRDeleteTriggers(
        estate: *mut EState,
        relinfo: *mut ResultRelInfo,
        trigtuple: HeapTuple,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn ExecBSUpdateTriggers(estate: *mut EState, relinfo: *mut ResultRelInfo);
}
#[pg_guard]
extern "C" {
    pub fn ExecASUpdateTriggers(
        estate: *mut EState,
        relinfo: *mut ResultRelInfo,
        transition_capture: *mut TransitionCaptureState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecBRUpdateTriggers(
        estate: *mut EState,
        epqstate: *mut EPQState,
        relinfo: *mut ResultRelInfo,
        tupleid: ItemPointer,
        fdw_trigtuple: HeapTuple,
        slot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecARUpdateTriggers(
        estate: *mut EState,
        relinfo: *mut ResultRelInfo,
        tupleid: ItemPointer,
        fdw_trigtuple: HeapTuple,
        newtuple: HeapTuple,
        recheckIndexes: *mut List,
        transition_capture: *mut TransitionCaptureState,
    );
}
#[pg_guard]
extern "C" {
    pub fn ExecIRUpdateTriggers(
        estate: *mut EState,
        relinfo: *mut ResultRelInfo,
        trigtuple: HeapTuple,
        slot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot;
}
#[pg_guard]
extern "C" {
    pub fn ExecBSTruncateTriggers(estate: *mut EState, relinfo: *mut ResultRelInfo);
}
#[pg_guard]
extern "C" {
    pub fn ExecASTruncateTriggers(estate: *mut EState, relinfo: *mut ResultRelInfo);
}
#[pg_guard]
extern "C" {
    pub fn AfterTriggerBeginXact();
}
#[pg_guard]
extern "C" {
    pub fn AfterTriggerBeginQuery();
}
#[pg_guard]
extern "C" {
    pub fn AfterTriggerEndQuery(estate: *mut EState);
}
#[pg_guard]
extern "C" {
    pub fn AfterTriggerFireDeferred();
}
#[pg_guard]
extern "C" {
    pub fn AfterTriggerEndXact(isCommit: bool);
}
#[pg_guard]
extern "C" {
    pub fn AfterTriggerBeginSubXact();
}
#[pg_guard]
extern "C" {
    pub fn AfterTriggerEndSubXact(isCommit: bool);
}
#[pg_guard]
extern "C" {
    pub fn AfterTriggerSetState(stmt: *mut ConstraintsSetStmt);
}
#[pg_guard]
extern "C" {
    pub fn AfterTriggerPendingOnRel(relid: Oid) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn RI_FKey_pk_upd_check_required(
        trigger: *mut Trigger,
        pk_rel: Relation,
        old_row: HeapTuple,
        new_row: HeapTuple,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn RI_FKey_fk_upd_check_required(
        trigger: *mut Trigger,
        fk_rel: Relation,
        old_row: HeapTuple,
        new_row: HeapTuple,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn RI_Initial_Check(trigger: *mut Trigger, fk_rel: Relation, pk_rel: Relation) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn RI_FKey_trigger_type(tgfoid: Oid) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct FormData_pg_statistic {
    pub starelid: Oid,
    pub staattnum: int16,
    pub stainherit: bool,
    pub stanullfrac: float4,
    pub stawidth: int32,
    pub stadistinct: float4,
    pub stakind1: int16,
    pub stakind2: int16,
    pub stakind3: int16,
    pub stakind4: int16,
    pub stakind5: int16,
    pub staop1: Oid,
    pub staop2: Oid,
    pub staop3: Oid,
    pub staop4: Oid,
    pub staop5: Oid,
}
pub type Form_pg_statistic = *mut FormData_pg_statistic;
pub type VacAttrStatsP = *mut VacAttrStats;
pub type AnalyzeAttrFetchFunc = ::std::option::Option<
    unsafe extern "C" fn(
        stats: VacAttrStatsP,
        rownum: ::std::os::raw::c_int,
        isNull: *mut bool,
    ) -> Datum,
>;
pub type AnalyzeAttrComputeStatsFunc = ::std::option::Option<
    unsafe extern "C" fn(
        stats: VacAttrStatsP,
        fetchfunc: AnalyzeAttrFetchFunc,
        samplerows: ::std::os::raw::c_int,
        totalrows: f64,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VacAttrStats {
    pub attr: Form_pg_attribute,
    pub attrtypid: Oid,
    pub attrtypmod: int32,
    pub attrtype: Form_pg_type,
    pub anl_context: MemoryContext,
    pub compute_stats: AnalyzeAttrComputeStatsFunc,
    pub minrows: ::std::os::raw::c_int,
    pub extra_data: *mut ::std::os::raw::c_void,
    pub stats_valid: bool,
    pub stanullfrac: float4,
    pub stawidth: int32,
    pub stadistinct: float4,
    pub stakind: [int16; 5usize],
    pub staop: [Oid; 5usize],
    pub numnumbers: [::std::os::raw::c_int; 5usize],
    pub stanumbers: [*mut float4; 5usize],
    pub numvalues: [::std::os::raw::c_int; 5usize],
    pub stavalues: [*mut Datum; 5usize],
    pub statypid: [Oid; 5usize],
    pub statyplen: [int16; 5usize],
    pub statypbyval: [bool; 5usize],
    pub statypalign: [::std::os::raw::c_char; 5usize],
    pub tupattnum: ::std::os::raw::c_int,
    pub rows: *mut HeapTuple,
    pub tupDesc: TupleDesc,
    pub exprvals: *mut Datum,
    pub exprnulls: *mut bool,
    pub rowstride: ::std::os::raw::c_int,
}
impl Default for VacAttrStats {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct VacuumParams {
    pub freeze_min_age: ::std::os::raw::c_int,
    pub freeze_table_age: ::std::os::raw::c_int,
    pub multixact_freeze_min_age: ::std::os::raw::c_int,
    pub multixact_freeze_table_age: ::std::os::raw::c_int,
    pub is_wraparound: bool,
    pub log_min_duration: ::std::os::raw::c_int,
}
#[pg_guard]
extern "C" {
    pub static mut default_statistics_target: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut vacuum_freeze_min_age: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut vacuum_freeze_table_age: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut vacuum_multixact_freeze_min_age: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut vacuum_multixact_freeze_table_age: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn ExecVacuum(vacstmt: *mut VacuumStmt, isTopLevel: bool);
}
#[pg_guard]
extern "C" {
    pub fn vacuum(
        options: ::std::os::raw::c_int,
        relation: *mut RangeVar,
        relid: Oid,
        params: *mut VacuumParams,
        va_cols: *mut List,
        bstrategy: BufferAccessStrategy,
        isTopLevel: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn vac_open_indexes(
        relation: Relation,
        lockmode: LOCKMODE,
        nindexes: *mut ::std::os::raw::c_int,
        Irel: *mut *mut Relation,
    );
}
#[pg_guard]
extern "C" {
    pub fn vac_close_indexes(
        nindexes: ::std::os::raw::c_int,
        Irel: *mut Relation,
        lockmode: LOCKMODE,
    );
}
#[pg_guard]
extern "C" {
    pub fn vac_estimate_reltuples(
        relation: Relation,
        is_analyze: bool,
        total_pages: BlockNumber,
        scanned_pages: BlockNumber,
        scanned_tuples: f64,
    ) -> f64;
}
#[pg_guard]
extern "C" {
    pub fn vac_update_relstats(
        relation: Relation,
        num_pages: BlockNumber,
        num_tuples: f64,
        num_all_visible_pages: BlockNumber,
        hasindex: bool,
        frozenxid: TransactionId,
        minmulti: MultiXactId,
        in_outer_xact: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn vacuum_set_xid_limits(
        rel: Relation,
        freeze_min_age: ::std::os::raw::c_int,
        freeze_table_age: ::std::os::raw::c_int,
        multixact_freeze_min_age: ::std::os::raw::c_int,
        multixact_freeze_table_age: ::std::os::raw::c_int,
        oldestXmin: *mut TransactionId,
        freezeLimit: *mut TransactionId,
        xidFullScanLimit: *mut TransactionId,
        multiXactCutoff: *mut MultiXactId,
        mxactFullScanLimit: *mut MultiXactId,
    );
}
#[pg_guard]
extern "C" {
    pub fn vac_update_datfrozenxid();
}
#[pg_guard]
extern "C" {
    pub fn vacuum_delay_point();
}
#[pg_guard]
extern "C" {
    pub fn lazy_vacuum_rel(
        onerel: Relation,
        options: ::std::os::raw::c_int,
        params: *mut VacuumParams,
        bstrategy: BufferAccessStrategy,
    );
}
#[pg_guard]
extern "C" {
    pub fn analyze_rel(
        relid: Oid,
        relation: *mut RangeVar,
        options: ::std::os::raw::c_int,
        params: *mut VacuumParams,
        va_cols: *mut List,
        in_outer_xact: bool,
        bstrategy: BufferAccessStrategy,
    );
}
#[pg_guard]
extern "C" {
    pub fn std_typanalyze(stats: *mut VacAttrStats) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn anl_random_fract() -> f64;
}
#[pg_guard]
extern "C" {
    pub fn anl_init_selection_state(n: ::std::os::raw::c_int) -> f64;
}
#[pg_guard]
extern "C" {
    pub fn anl_get_next_S(t: f64, n: ::std::os::raw::c_int, stateptr: *mut f64) -> f64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CachedPlanSource {
    pub magic: ::std::os::raw::c_int,
    pub raw_parse_tree: *mut RawStmt,
    pub query_string: *const ::std::os::raw::c_char,
    pub commandTag: *const ::std::os::raw::c_char,
    pub param_types: *mut Oid,
    pub num_params: ::std::os::raw::c_int,
    pub parserSetup: ParserSetupHook,
    pub parserSetupArg: *mut ::std::os::raw::c_void,
    pub cursor_options: ::std::os::raw::c_int,
    pub fixed_result: bool,
    pub resultDesc: TupleDesc,
    pub context: MemoryContext,
    pub query_list: *mut List,
    pub relationOids: *mut List,
    pub invalItems: *mut List,
    pub search_path: *mut OverrideSearchPath,
    pub query_context: MemoryContext,
    pub rewriteRoleId: Oid,
    pub rewriteRowSecurity: bool,
    pub dependsOnRLS: bool,
    pub gplan: *mut CachedPlan,
    pub is_oneshot: bool,
    pub is_complete: bool,
    pub is_saved: bool,
    pub is_valid: bool,
    pub generation: ::std::os::raw::c_int,
    pub next_saved: *mut CachedPlanSource,
    pub generic_cost: f64,
    pub total_custom_cost: f64,
    pub num_custom_plans: ::std::os::raw::c_int,
}
impl Default for CachedPlanSource {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CachedPlan {
    pub magic: ::std::os::raw::c_int,
    pub stmt_list: *mut List,
    pub is_oneshot: bool,
    pub is_saved: bool,
    pub is_valid: bool,
    pub planRoleId: Oid,
    pub dependsOnRole: bool,
    pub saved_xmin: TransactionId,
    pub generation: ::std::os::raw::c_int,
    pub refcount: ::std::os::raw::c_int,
    pub context: MemoryContext,
}
impl Default for CachedPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn InitPlanCache();
}
#[pg_guard]
extern "C" {
    pub fn ResetPlanCache();
}
#[pg_guard]
extern "C" {
    pub fn CreateCachedPlan(
        raw_parse_tree: *mut RawStmt,
        query_string: *const ::std::os::raw::c_char,
        commandTag: *const ::std::os::raw::c_char,
    ) -> *mut CachedPlanSource;
}
#[pg_guard]
extern "C" {
    pub fn CreateOneShotCachedPlan(
        raw_parse_tree: *mut RawStmt,
        query_string: *const ::std::os::raw::c_char,
        commandTag: *const ::std::os::raw::c_char,
    ) -> *mut CachedPlanSource;
}
#[pg_guard]
extern "C" {
    pub fn CompleteCachedPlan(
        plansource: *mut CachedPlanSource,
        querytree_list: *mut List,
        querytree_context: MemoryContext,
        param_types: *mut Oid,
        num_params: ::std::os::raw::c_int,
        parserSetup: ParserSetupHook,
        parserSetupArg: *mut ::std::os::raw::c_void,
        cursor_options: ::std::os::raw::c_int,
        fixed_result: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn SaveCachedPlan(plansource: *mut CachedPlanSource);
}
#[pg_guard]
extern "C" {
    pub fn DropCachedPlan(plansource: *mut CachedPlanSource);
}
#[pg_guard]
extern "C" {
    pub fn CachedPlanSetParentContext(plansource: *mut CachedPlanSource, newcontext: MemoryContext);
}
#[pg_guard]
extern "C" {
    pub fn CopyCachedPlan(plansource: *mut CachedPlanSource) -> *mut CachedPlanSource;
}
#[pg_guard]
extern "C" {
    pub fn CachedPlanIsValid(plansource: *mut CachedPlanSource) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn CachedPlanGetTargetList(
        plansource: *mut CachedPlanSource,
        queryEnv: *mut QueryEnvironment,
    ) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn GetCachedPlan(
        plansource: *mut CachedPlanSource,
        boundParams: ParamListInfo,
        useResOwner: bool,
        queryEnv: *mut QueryEnvironment,
    ) -> *mut CachedPlan;
}
#[pg_guard]
extern "C" {
    pub fn ReleaseCachedPlan(plan: *mut CachedPlan, useResOwner: bool);
}
pub type ResourceOwner = *mut ResourceOwnerData;
#[pg_guard]
extern "C" {
    pub static mut CurrentResourceOwner: ResourceOwner;
}
#[pg_guard]
extern "C" {
    pub static mut CurTransactionResourceOwner: ResourceOwner;
}
#[pg_guard]
extern "C" {
    pub static mut TopTransactionResourceOwner: ResourceOwner;
}
pub const ResourceReleasePhase_RESOURCE_RELEASE_BEFORE_LOCKS: ResourceReleasePhase = 0;
pub const ResourceReleasePhase_RESOURCE_RELEASE_LOCKS: ResourceReleasePhase = 1;
pub const ResourceReleasePhase_RESOURCE_RELEASE_AFTER_LOCKS: ResourceReleasePhase = 2;
pub type ResourceReleasePhase = ::std::os::raw::c_uint;
pub type ResourceReleaseCallback = ::std::option::Option<
    unsafe extern "C" fn(
        phase: ResourceReleasePhase,
        isCommit: bool,
        isTopLevel: bool,
        arg: *mut ::std::os::raw::c_void,
    ),
>;
#[pg_guard]
extern "C" {
    pub fn ResourceOwnerCreate(
        parent: ResourceOwner,
        name: *const ::std::os::raw::c_char,
    ) -> ResourceOwner;
}
#[pg_guard]
extern "C" {
    pub fn ResourceOwnerRelease(
        owner: ResourceOwner,
        phase: ResourceReleasePhase,
        isCommit: bool,
        isTopLevel: bool,
    );
}
#[pg_guard]
extern "C" {
    pub fn ResourceOwnerDelete(owner: ResourceOwner);
}
#[pg_guard]
extern "C" {
    pub fn ResourceOwnerGetParent(owner: ResourceOwner) -> ResourceOwner;
}
#[pg_guard]
extern "C" {
    pub fn ResourceOwnerNewParent(owner: ResourceOwner, newparent: ResourceOwner);
}
#[pg_guard]
extern "C" {
    pub fn RegisterResourceReleaseCallback(
        callback: ResourceReleaseCallback,
        arg: *mut ::std::os::raw::c_void,
    );
}
#[pg_guard]
extern "C" {
    pub fn UnregisterResourceReleaseCallback(
        callback: ResourceReleaseCallback,
        arg: *mut ::std::os::raw::c_void,
    );
}
pub const PortalStrategy_PORTAL_ONE_SELECT: PortalStrategy = 0;
pub const PortalStrategy_PORTAL_ONE_RETURNING: PortalStrategy = 1;
pub const PortalStrategy_PORTAL_ONE_MOD_WITH: PortalStrategy = 2;
pub const PortalStrategy_PORTAL_UTIL_SELECT: PortalStrategy = 3;
pub const PortalStrategy_PORTAL_MULTI_QUERY: PortalStrategy = 4;
pub type PortalStrategy = ::std::os::raw::c_uint;
pub const PortalStatus_PORTAL_NEW: PortalStatus = 0;
pub const PortalStatus_PORTAL_DEFINED: PortalStatus = 1;
pub const PortalStatus_PORTAL_READY: PortalStatus = 2;
pub const PortalStatus_PORTAL_ACTIVE: PortalStatus = 3;
pub const PortalStatus_PORTAL_DONE: PortalStatus = 4;
pub const PortalStatus_PORTAL_FAILED: PortalStatus = 5;
pub type PortalStatus = ::std::os::raw::c_uint;
pub type Portal = *mut PortalData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PortalData {
    pub name: *const ::std::os::raw::c_char,
    pub prepStmtName: *const ::std::os::raw::c_char,
    pub heap: MemoryContext,
    pub resowner: ResourceOwner,
    pub cleanup: ::std::option::Option<unsafe extern "C" fn(portal: Portal)>,
    pub createSubid: SubTransactionId,
    pub activeSubid: SubTransactionId,
    pub sourceText: *const ::std::os::raw::c_char,
    pub commandTag: *const ::std::os::raw::c_char,
    pub stmts: *mut List,
    pub cplan: *mut CachedPlan,
    pub portalParams: ParamListInfo,
    pub queryEnv: *mut QueryEnvironment,
    pub strategy: PortalStrategy,
    pub cursorOptions: ::std::os::raw::c_int,
    pub run_once: bool,
    pub status: PortalStatus,
    pub portalPinned: bool,
    pub queryDesc: *mut QueryDesc,
    pub tupDesc: TupleDesc,
    pub formats: *mut int16,
    pub holdStore: *mut Tuplestorestate,
    pub holdContext: MemoryContext,
    pub holdSnapshot: Snapshot,
    pub atStart: bool,
    pub atEnd: bool,
    pub portalPos: uint64,
    pub creation_time: TimestampTz,
    pub visible: bool,
}
impl Default for PortalData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub fn EnablePortalManager();
}
#[pg_guard]
extern "C" {
    pub fn PreCommit_Portals(isPrepare: bool) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn AtAbort_Portals();
}
#[pg_guard]
extern "C" {
    pub fn AtCleanup_Portals();
}
#[pg_guard]
extern "C" {
    pub fn AtSubCommit_Portals(
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
        parentXactOwner: ResourceOwner,
    );
}
#[pg_guard]
extern "C" {
    pub fn AtSubAbort_Portals(
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
        myXactOwner: ResourceOwner,
        parentXactOwner: ResourceOwner,
    );
}
#[pg_guard]
extern "C" {
    pub fn AtSubCleanup_Portals(mySubid: SubTransactionId);
}
#[pg_guard]
extern "C" {
    pub fn CreatePortal(
        name: *const ::std::os::raw::c_char,
        allowDup: bool,
        dupSilent: bool,
    ) -> Portal;
}
#[pg_guard]
extern "C" {
    pub fn CreateNewPortal() -> Portal;
}
#[pg_guard]
extern "C" {
    pub fn PinPortal(portal: Portal);
}
#[pg_guard]
extern "C" {
    pub fn UnpinPortal(portal: Portal);
}
#[pg_guard]
extern "C" {
    pub fn MarkPortalActive(portal: Portal);
}
#[pg_guard]
extern "C" {
    pub fn MarkPortalDone(portal: Portal);
}
#[pg_guard]
extern "C" {
    pub fn MarkPortalFailed(portal: Portal);
}
#[pg_guard]
extern "C" {
    pub fn PortalDrop(portal: Portal, isTopCommit: bool);
}
#[pg_guard]
extern "C" {
    pub fn GetPortalByName(name: *const ::std::os::raw::c_char) -> Portal;
}
#[pg_guard]
extern "C" {
    pub fn PortalDefineQuery(
        portal: Portal,
        prepStmtName: *const ::std::os::raw::c_char,
        sourceText: *const ::std::os::raw::c_char,
        commandTag: *const ::std::os::raw::c_char,
        stmts: *mut List,
        cplan: *mut CachedPlan,
    );
}
#[pg_guard]
extern "C" {
    pub fn PortalGetPrimaryStmt(portal: Portal) -> *mut PlannedStmt;
}
#[pg_guard]
extern "C" {
    pub fn PortalCreateHoldStore(portal: Portal);
}
#[pg_guard]
extern "C" {
    pub fn PortalHashTableDeleteAll();
}
#[pg_guard]
extern "C" {
    pub fn ThereAreNoReadyPortals() -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SPITupleTable {
    pub tuptabcxt: MemoryContext,
    pub alloced: uint64,
    pub free: uint64,
    pub tupdesc: TupleDesc,
    pub vals: *mut HeapTuple,
    pub next: slist_node,
    pub subid: SubTransactionId,
}
impl Default for SPITupleTable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _SPI_plan {
    _unused: [u8; 0],
}
pub type SPIPlanPtr = *mut _SPI_plan;
#[pg_guard]
extern "C" {
    pub static mut SPI_processed: uint64;
}
#[pg_guard]
extern "C" {
    pub static mut SPI_lastoid: Oid;
}
#[pg_guard]
extern "C" {
    pub static mut SPI_tuptable: *mut SPITupleTable;
}
#[pg_guard]
extern "C" {
    pub static mut SPI_result: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_connect() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_finish() -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_execute(
        src: *const ::std::os::raw::c_char,
        read_only: bool,
        tcount: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_execute_plan(
        plan: SPIPlanPtr,
        Values: *mut Datum,
        Nulls: *const ::std::os::raw::c_char,
        read_only: bool,
        tcount: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_execute_plan_with_paramlist(
        plan: SPIPlanPtr,
        params: ParamListInfo,
        read_only: bool,
        tcount: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_exec(
        src: *const ::std::os::raw::c_char,
        tcount: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_execp(
        plan: SPIPlanPtr,
        Values: *mut Datum,
        Nulls: *const ::std::os::raw::c_char,
        tcount: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_execute_snapshot(
        plan: SPIPlanPtr,
        Values: *mut Datum,
        Nulls: *const ::std::os::raw::c_char,
        snapshot: Snapshot,
        crosscheck_snapshot: Snapshot,
        read_only: bool,
        fire_triggers: bool,
        tcount: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_execute_with_args(
        src: *const ::std::os::raw::c_char,
        nargs: ::std::os::raw::c_int,
        argtypes: *mut Oid,
        Values: *mut Datum,
        Nulls: *const ::std::os::raw::c_char,
        read_only: bool,
        tcount: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_prepare(
        src: *const ::std::os::raw::c_char,
        nargs: ::std::os::raw::c_int,
        argtypes: *mut Oid,
    ) -> SPIPlanPtr;
}
#[pg_guard]
extern "C" {
    pub fn SPI_prepare_cursor(
        src: *const ::std::os::raw::c_char,
        nargs: ::std::os::raw::c_int,
        argtypes: *mut Oid,
        cursorOptions: ::std::os::raw::c_int,
    ) -> SPIPlanPtr;
}
#[pg_guard]
extern "C" {
    pub fn SPI_prepare_params(
        src: *const ::std::os::raw::c_char,
        parserSetup: ParserSetupHook,
        parserSetupArg: *mut ::std::os::raw::c_void,
        cursorOptions: ::std::os::raw::c_int,
    ) -> SPIPlanPtr;
}
#[pg_guard]
extern "C" {
    pub fn SPI_keepplan(plan: SPIPlanPtr) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_saveplan(plan: SPIPlanPtr) -> SPIPlanPtr;
}
#[pg_guard]
extern "C" {
    pub fn SPI_freeplan(plan: SPIPlanPtr) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_getargtypeid(plan: SPIPlanPtr, argIndex: ::std::os::raw::c_int) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn SPI_getargcount(plan: SPIPlanPtr) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_is_cursor_plan(plan: SPIPlanPtr) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn SPI_plan_is_valid(plan: SPIPlanPtr) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn SPI_result_code_string(code: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn SPI_plan_get_plan_sources(plan: SPIPlanPtr) -> *mut List;
}
#[pg_guard]
extern "C" {
    pub fn SPI_plan_get_cached_plan(plan: SPIPlanPtr) -> *mut CachedPlan;
}
#[pg_guard]
extern "C" {
    pub fn SPI_copytuple(tuple: HeapTuple) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn SPI_returntuple(tuple: HeapTuple, tupdesc: TupleDesc) -> HeapTupleHeader;
}
#[pg_guard]
extern "C" {
    pub fn SPI_modifytuple(
        rel: Relation,
        tuple: HeapTuple,
        natts: ::std::os::raw::c_int,
        attnum: *mut ::std::os::raw::c_int,
        Values: *mut Datum,
        Nulls: *const ::std::os::raw::c_char,
    ) -> HeapTuple;
}
#[pg_guard]
extern "C" {
    pub fn SPI_fnumber(
        tupdesc: TupleDesc,
        fname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_fname(
        tupdesc: TupleDesc,
        fnumber: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn SPI_getvalue(
        tuple: HeapTuple,
        tupdesc: TupleDesc,
        fnumber: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn SPI_getbinval(
        tuple: HeapTuple,
        tupdesc: TupleDesc,
        fnumber: ::std::os::raw::c_int,
        isnull: *mut bool,
    ) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn SPI_gettype(
        tupdesc: TupleDesc,
        fnumber: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn SPI_gettypeid(tupdesc: TupleDesc, fnumber: ::std::os::raw::c_int) -> Oid;
}
#[pg_guard]
extern "C" {
    pub fn SPI_getrelname(rel: Relation) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn SPI_getnspname(rel: Relation) -> *mut ::std::os::raw::c_char;
}
#[pg_guard]
extern "C" {
    pub fn SPI_palloc(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn SPI_repalloc(
        pointer: *mut ::std::os::raw::c_void,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn SPI_pfree(pointer: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn SPI_datumTransfer(value: Datum, typByVal: bool, typLen: ::std::os::raw::c_int) -> Datum;
}
#[pg_guard]
extern "C" {
    pub fn SPI_freetuple(pointer: HeapTuple);
}
#[pg_guard]
extern "C" {
    pub fn SPI_freetuptable(tuptable: *mut SPITupleTable);
}
#[pg_guard]
extern "C" {
    pub fn SPI_cursor_open(
        name: *const ::std::os::raw::c_char,
        plan: SPIPlanPtr,
        Values: *mut Datum,
        Nulls: *const ::std::os::raw::c_char,
        read_only: bool,
    ) -> Portal;
}
#[pg_guard]
extern "C" {
    pub fn SPI_cursor_open_with_args(
        name: *const ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
        nargs: ::std::os::raw::c_int,
        argtypes: *mut Oid,
        Values: *mut Datum,
        Nulls: *const ::std::os::raw::c_char,
        read_only: bool,
        cursorOptions: ::std::os::raw::c_int,
    ) -> Portal;
}
#[pg_guard]
extern "C" {
    pub fn SPI_cursor_open_with_paramlist(
        name: *const ::std::os::raw::c_char,
        plan: SPIPlanPtr,
        params: ParamListInfo,
        read_only: bool,
    ) -> Portal;
}
#[pg_guard]
extern "C" {
    pub fn SPI_cursor_find(name: *const ::std::os::raw::c_char) -> Portal;
}
#[pg_guard]
extern "C" {
    pub fn SPI_cursor_fetch(portal: Portal, forward: bool, count: ::std::os::raw::c_long);
}
#[pg_guard]
extern "C" {
    pub fn SPI_cursor_move(portal: Portal, forward: bool, count: ::std::os::raw::c_long);
}
#[pg_guard]
extern "C" {
    pub fn SPI_scroll_cursor_fetch(
        arg1: Portal,
        direction: FetchDirection,
        count: ::std::os::raw::c_long,
    );
}
#[pg_guard]
extern "C" {
    pub fn SPI_scroll_cursor_move(
        arg1: Portal,
        direction: FetchDirection,
        count: ::std::os::raw::c_long,
    );
}
#[pg_guard]
extern "C" {
    pub fn SPI_cursor_close(portal: Portal);
}
#[pg_guard]
extern "C" {
    pub fn SPI_register_relation(enr: EphemeralNamedRelation) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_unregister_relation(name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn SPI_register_trigger_data(tdata: *mut TriggerData) -> ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub fn AtEOXact_SPI(isCommit: bool);
}
#[pg_guard]
extern "C" {
    pub fn AtEOSubXact_SPI(isCommit: bool, mySubid: SubTransactionId);
}
pub type bgworker_main_type = ::std::option::Option<unsafe extern "C" fn(main_arg: Datum)>;
pub const BgWorkerStartTime_BgWorkerStart_PostmasterStart: BgWorkerStartTime = 0;
pub const BgWorkerStartTime_BgWorkerStart_ConsistentState: BgWorkerStartTime = 1;
pub const BgWorkerStartTime_BgWorkerStart_RecoveryFinished: BgWorkerStartTime = 2;
pub type BgWorkerStartTime = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BackgroundWorker {
    pub bgw_name: [::std::os::raw::c_char; 64usize],
    pub bgw_flags: ::std::os::raw::c_int,
    pub bgw_start_time: BgWorkerStartTime,
    pub bgw_restart_time: ::std::os::raw::c_int,
    pub bgw_library_name: [::std::os::raw::c_char; 64usize],
    pub bgw_function_name: [::std::os::raw::c_char; 64usize],
    pub bgw_main_arg: Datum,
    pub bgw_extra: [::std::os::raw::c_char; 128usize],
    pub bgw_notify_pid: pid_t,
}
impl Default for BackgroundWorker {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BgwHandleStatus_BGWH_STARTED: BgwHandleStatus = 0;
pub const BgwHandleStatus_BGWH_NOT_YET_STARTED: BgwHandleStatus = 1;
pub const BgwHandleStatus_BGWH_STOPPED: BgwHandleStatus = 2;
pub const BgwHandleStatus_BGWH_POSTMASTER_DIED: BgwHandleStatus = 3;
pub type BgwHandleStatus = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BackgroundWorkerHandle {
    _unused: [u8; 0],
}
#[pg_guard]
extern "C" {
    pub fn RegisterBackgroundWorker(worker: *mut BackgroundWorker);
}
#[pg_guard]
extern "C" {
    pub fn RegisterDynamicBackgroundWorker(
        worker: *mut BackgroundWorker,
        handle: *mut *mut BackgroundWorkerHandle,
    ) -> bool;
}
#[pg_guard]
extern "C" {
    pub fn GetBackgroundWorkerPid(
        handle: *mut BackgroundWorkerHandle,
        pidp: *mut pid_t,
    ) -> BgwHandleStatus;
}
#[pg_guard]
extern "C" {
    pub fn WaitForBackgroundWorkerStartup(
        handle: *mut BackgroundWorkerHandle,
        pid: *mut pid_t,
    ) -> BgwHandleStatus;
}
#[pg_guard]
extern "C" {
    pub fn WaitForBackgroundWorkerShutdown(arg1: *mut BackgroundWorkerHandle) -> BgwHandleStatus;
}
#[pg_guard]
extern "C" {
    pub fn TerminateBackgroundWorker(handle: *mut BackgroundWorkerHandle);
}
#[pg_guard]
extern "C" {
    pub static mut MyBgworkerEntry: *mut BackgroundWorker;
}
#[pg_guard]
extern "C" {
    pub fn BackgroundWorkerInitializeConnection(
        dbname: *mut ::std::os::raw::c_char,
        username: *mut ::std::os::raw::c_char,
    );
}
#[pg_guard]
extern "C" {
    pub fn BackgroundWorkerInitializeConnectionByOid(dboid: Oid, useroid: Oid);
}
#[pg_guard]
extern "C" {
    pub fn BackgroundWorkerBlockSignals();
}
#[pg_guard]
extern "C" {
    pub fn BackgroundWorkerUnblockSignals();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shm_mq {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shm_mq_handle {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shm_mq_iovec {
    pub data: *const ::std::os::raw::c_char,
    pub len: Size,
}
impl Default for shm_mq_iovec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const shm_mq_result_SHM_MQ_SUCCESS: shm_mq_result = 0;
pub const shm_mq_result_SHM_MQ_WOULD_BLOCK: shm_mq_result = 1;
pub const shm_mq_result_SHM_MQ_DETACHED: shm_mq_result = 2;
pub type shm_mq_result = ::std::os::raw::c_uint;
#[pg_guard]
extern "C" {
    pub fn shm_mq_create(address: *mut ::std::os::raw::c_void, size: Size) -> *mut shm_mq;
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_set_receiver(mq: *mut shm_mq, arg1: *mut PGPROC);
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_set_sender(mq: *mut shm_mq, arg1: *mut PGPROC);
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_get_receiver(arg1: *mut shm_mq) -> *mut PGPROC;
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_get_sender(arg1: *mut shm_mq) -> *mut PGPROC;
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_attach(
        mq: *mut shm_mq,
        seg: *mut dsm_segment,
        handle: *mut BackgroundWorkerHandle,
    ) -> *mut shm_mq_handle;
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_set_handle(arg1: *mut shm_mq_handle, arg2: *mut BackgroundWorkerHandle);
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_detach(mqh: *mut shm_mq_handle);
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_get_queue(mqh: *mut shm_mq_handle) -> *mut shm_mq;
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_send(
        mqh: *mut shm_mq_handle,
        nbytes: Size,
        data: *const ::std::os::raw::c_void,
        nowait: bool,
    ) -> shm_mq_result;
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_sendv(
        mqh: *mut shm_mq_handle,
        iov: *mut shm_mq_iovec,
        iovcnt: ::std::os::raw::c_int,
        nowait: bool,
    ) -> shm_mq_result;
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_receive(
        mqh: *mut shm_mq_handle,
        nbytesp: *mut Size,
        datap: *mut *mut ::std::os::raw::c_void,
        nowait: bool,
    ) -> shm_mq_result;
}
#[pg_guard]
extern "C" {
    pub fn shm_mq_wait_for_attach(mqh: *mut shm_mq_handle) -> shm_mq_result;
}
#[pg_guard]
extern "C" {
    pub static shm_mq_minimum_size: Size;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shm_toc {
    _unused: [u8; 0],
}
#[pg_guard]
extern "C" {
    pub fn shm_toc_create(
        magic: uint64,
        address: *mut ::std::os::raw::c_void,
        nbytes: Size,
    ) -> *mut shm_toc;
}
#[pg_guard]
extern "C" {
    pub fn shm_toc_attach(magic: uint64, address: *mut ::std::os::raw::c_void) -> *mut shm_toc;
}
#[pg_guard]
extern "C" {
    pub fn shm_toc_allocate(toc: *mut shm_toc, nbytes: Size) -> *mut ::std::os::raw::c_void;
}
#[pg_guard]
extern "C" {
    pub fn shm_toc_freespace(toc: *mut shm_toc) -> Size;
}
#[pg_guard]
extern "C" {
    pub fn shm_toc_insert(toc: *mut shm_toc, key: uint64, address: *mut ::std::os::raw::c_void);
}
#[pg_guard]
extern "C" {
    pub fn shm_toc_lookup(
        toc: *mut shm_toc,
        key: uint64,
        noError: bool,
    ) -> *mut ::std::os::raw::c_void;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct shm_toc_estimator {
    pub space_for_chunks: Size,
    pub number_of_keys: Size,
}
#[pg_guard]
extern "C" {
    pub fn shm_toc_estimate(e: *mut shm_toc_estimator) -> Size;
}
pub type parallel_worker_main_type =
    ::std::option::Option<unsafe extern "C" fn(seg: *mut dsm_segment, toc: *mut shm_toc)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelWorkerInfo {
    pub bgwhandle: *mut BackgroundWorkerHandle,
    pub error_mqh: *mut shm_mq_handle,
    pub pid: int32,
}
impl Default for ParallelWorkerInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelContext {
    pub node: dlist_node,
    pub subid: SubTransactionId,
    pub nworkers: ::std::os::raw::c_int,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub library_name: *mut ::std::os::raw::c_char,
    pub function_name: *mut ::std::os::raw::c_char,
    pub error_context_stack: *mut ErrorContextCallback,
    pub estimator: shm_toc_estimator,
    pub seg: *mut dsm_segment,
    pub private_memory: *mut ::std::os::raw::c_void,
    pub toc: *mut shm_toc,
    pub worker: *mut ParallelWorkerInfo,
    pub any_message_received: *mut bool,
}
impl Default for ParallelContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pg_guard]
extern "C" {
    pub static mut ParallelMessagePending: bool;
}
#[pg_guard]
extern "C" {
    pub static mut ParallelWorkerNumber: ::std::os::raw::c_int;
}
#[pg_guard]
extern "C" {
    pub static mut InitializingParallelWorker: bool;
}
#[pg_guard]
extern "C" {
    pub fn CreateParallelContext(
        library_name: *const ::std::os::raw::c_char,
        function_name: *const ::std::os::raw::c_char,
        nworkers: ::std::os::raw::c_int,
    ) -> *mut ParallelContext;
}
#[pg_guard]
extern "C" {
    pub fn InitializeParallelDSM(pcxt: *mut ParallelContext);
}
#[pg_guard]
extern "C" {
    pub fn ReinitializeParallelDSM(pcxt: *mut ParallelContext);
}
#[pg_guard]
extern "C" {
    pub fn LaunchParallelWorkers(pcxt: *mut ParallelContext);
}
#[pg_guard]
extern "C" {
    pub fn WaitForParallelWorkersToFinish(pcxt: *mut ParallelContext);
}
#[pg_guard]
extern "C" {
    pub fn DestroyParallelContext(pcxt: *mut ParallelContext);
}
#[pg_guard]
extern "C" {
    pub fn ParallelContextActive() -> bool;
}
#[pg_guard]
extern "C" {
    pub fn HandleParallelMessageInterrupt();
}
#[pg_guard]
extern "C" {
    pub fn HandleParallelMessages();
}
#[pg_guard]
extern "C" {
    pub fn AtEOXact_Parallel(isCommit: bool);
}
#[pg_guard]
extern "C" {
    pub fn AtEOSubXact_Parallel(isCommit: bool, mySubId: SubTransactionId);
}
#[pg_guard]
extern "C" {
    pub fn ParallelWorkerReportLastRecEnd(last_xlog_end: XLogRecPtr);
}
#[pg_guard]
extern "C" {
    pub fn ParallelWorkerMain(main_arg: Datum);
}
pub type Relids = *mut Bitmapset;
pub const CostSelector_STARTUP_COST: CostSelector = 0;
pub const CostSelector_TOTAL_COST: CostSelector = 1;
pub type CostSelector = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct QualCost {
    pub startup: Cost,
    pub per_tuple: Cost,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AggClauseCosts {
    pub numAggs: ::std::os::raw::c_int,
    pub numOrderedAggs: ::std::os::raw::c_int,
    pub hasNonPartial: bool,
    pub hasNonSerial: bool,
    pub transCost: QualCost,
    pub finalCost: Cost,
    pub transitionSpace: Size,
}
pub const UpperRelationKind_UPPERREL_SETOP: U