/*
 * @Author: venom
 * @Date: 2021-08-08 14:43:14
 * @LastEditors: venom
 * @LastEditTime: 2021-10-25 15:19:26
 * @Description: 
 * @FilePath: \pgbatis\tests\curd_test.rs
 * MIT
 */
 #[cfg(test)]
 mod test {
    
    // use std::collections::hash_map::RandomState;
    // use std::collections::HashMap;

    // use chrono::{DateTime, Utc};
    // use serde::de::DeserializeOwned;
    use serde::Deserialize;
    use serde::Serialize;
  //  use actix_rt;
    use pgbatis;
  //  use pgbatis::DATABASE_POOL;

    use pgbatis::pgmacro::PGCRUD;
    use pgbatis::Parameters;
    use pgbatis::tokio_postgres::types::ToSql;
    use pgbatis::tokio_postgres::Row;
    
  //  use pgbatis::Wrapper;
 
    #[derive(PGCRUD,Serialize, Deserialize, Clone, Debug,Default)]
    pub struct BizActivity {
        pub id: Option<String>,
        pub name: Option<String>,
        pub pc_link: Option<String>,
        pub h5_link: Option<String>,
        pub pc_banner_img: Option<String>,
        pub h5_banner_img: Option<String>,
        pub sort: Option<String>,
        pub status: Option<i32>,
        pub remark: Option<String>,
        pub create_time: Option<String>,
        pub version: Option<i32>,
        pub delete_flag: Option<i32>,
    }

    #[derive(PGCRUD,Serialize, Deserialize, Clone, Debug,Default)]
    pub struct Test1 {
      pub id: Option<String>,
      pub column1: Option<i32>,
      pub column2: Option<bool>,
      pub column3: Option<f32>,
  }



    //  #[actix_rt::test]
    //  async  fn test_ids() {
    //     let link = "postgresql://venom_db_admin:IUF76YUguiffy8FU@47.106.81.32/venom_database";
    //     DATABASE_POOL.link(link).await.unwrap(); 
    // }
    //打印语句输出，可以使用 cargo test test_with_fixture -- --nocapture：
    #[test]
    fn test_save() {
       let mut test = BizActivity::default();
       test.id = Some(String::from("1234567890"));
       test.name = Some(String::from("name_o"));
       let  (sql,args) = test.save("").unwrap();
       println!("sql :{}",sql);
       println!("args :{:?}",args);
    }

    #[test]
    fn test_update() {
       let mut test = BizActivity::default();
       test.id = Some(String::from("1234567890"));
       test.name = Some(String::from("name_o"));
       let  (sql,args,args_no) = test.update("").unwrap();
       println!("sql :{}",sql);
       println!("args :{:?}",args);
       println!("args_no :{:?}",args_no);
    }


    #[test]
    fn test_get_table_name() {
       let mut test = BizActivity::default();
       test.id = Some(String::from("1234567890"));
       test.name = Some(String::from("name_o"));
       let table_name = BizActivity::get_table_name("");
       println!("get_table_name :{}",table_name);
      
    }
    #[actix_rt::test]
    async fn save(){
      let mut test = Test1::default();
      test.id = Some(String::from("1234567890"));
      test.column1 = Some(999);
      test.column2 = Some(false);
      test.column3 = Some(9.9199);
     
     let _r =  pgbatis::link("127.0.0.1",5432,"venom_db_admin","12345677","venom_database",2).await;
     let r = pgbatis::save(test,"").await;
     println!("result:{:?}",r)
    }



    
  
}
