/*
 * @Author: venom
 * @Date: 2021-08-03 16:11:21
 * @LastEditors: venom
 * @LastEditTime: 2021-08-20 11:36:52
 * @Description:
 * @FilePath: \venom_server\dao\pgbatis\src\plugin\logic_delete.rs
 * MIT
 */
use std::fmt::Debug;
pub use tokio_postgres::types::ToSql;

pub trait LogicDelete: Send + Sync + Debug {
    ///the name
    // fn name(&self) -> &str {
    //     std::any::type_name::<Self>()
    // }
    fn is_exclusion_table(&self, table_name: &str) -> bool;
    /// database column
    fn column(&self) -> &str;
    /// deleted data,must be i16
    fn deleted(&self) -> i16;
    /// un deleted data,must be i16
    fn un_deleted(&self) ->i16;
   
   
}

#[derive(Debug)]
pub struct LogicDeletePlugin {
    pub exclusion_table: Vec<String>,
    pub column: String,
    pub deleted: i16,
    pub un_deleted: i16,
}

impl LogicDeletePlugin {
    pub fn new(column: &str) -> Self {
        Self {
            exclusion_table:vec![],
            column: column.to_string(),
            deleted: 1,
            un_deleted: 0,
        }
    }
    pub fn new_opt(
        column: &str,
        deleted: i16,
        un_deleted: i16,
        exclusion_table: Vec<String>,
    ) -> Self {
        if deleted == un_deleted {
            panic!("[Dbaits] deleted can not equal to un_deleted on RbatisLogicDeletePlugin::new_opt(column: &str, deleted: i32, un_deleted: i32)")
        }
        Self {
            exclusion_table,
            column: column.to_string(),
            deleted,
            un_deleted,
        }
    }
}

impl LogicDelete for LogicDeletePlugin {
    fn is_exclusion_table(&self, table_name: &str) -> bool {
        for i in self.exclusion_table.iter() {
            if table_name.eq(i) {
                return true;
            }
        }
        return false;
    }

    fn column(&self) -> &str {
        self.column.as_str()
    }

    fn deleted(&self) -> i16 {
        self.deleted
    }

    fn un_deleted(&self) -> i16 {
        self.un_deleted
    }
}
