/*
 * @Author: venom
 * @Date: 2021-08-08 11:41:38
 * @LastEditors: venom
 * @LastEditTime: 2021-08-08 13:43:20
 * @Description: 
 * @FilePath: \pgbatis\src\parameter.rs
 * MIT
 */

 use tokio_postgres::{
     types::ToSql,
     Row
 };
 pub trait Parameters {
     fn get_table_name() -> String;
     fn get_field_list() -> String;
     fn save(&self) -> Result<(String, Vec<&(dyn ToSql + Sync)>), String>;
     fn update(&self) -> Result<(String, Vec<&(dyn ToSql + Sync)>, u32), String>;
     fn return_one(rows: Row) -> Self;
 
     fn return_list(rows: Vec<Row>) -> Vec<Self>
     where
         Self: Sized,
     {
         let mut result_list = Vec::new();
         for row in rows {
             result_list.push(Self::return_one(row))
         }
 
         return result_list;
     }
 }
 
 pub trait FetchResult {
    fn get_table_name() -> String;
    fn get_field_list() -> String; 
    fn return_one(rows: Row) -> Self;
 
    fn return_list(rows: Vec<Row>) -> Vec<Self>
    where
        Self: Sized,
    {
        let mut result_list = Vec::new();
        for row in rows {
            result_list.push(Self::return_one(row))
        }

        return result_list;
    }
 }


 