use crate::errors::TerraRustTestingError;
use serde::{Deserialize, Serialize};
use terra_rust_api::tendermint_types::EventAttribute;
use terra_rust_api::Terra;

pub mod errors;
/// VERSION number of package
pub const VERSION: Option<&'static str> = option_env!("CARGO_PKG_VERSION");
/// NAME of package
pub const NAME: Option<&'static str> = option_env!("CARGO_PKG_NAME");

pub async fn get_attribute_tx(
    terra: &Terra,
    hash: &str,
    retries: usize,
    sleep: tokio::time::Duration,
    event_type: &str,
    attribute_key: &str,
) -> Result<String, TerraRustTestingError> {
    let tx = terra.tx().get_and_wait_v1(hash, retries, sleep).await?;
    let codes = tx
        .tx_response
        .get_attribute_from_logs(event_type, attribute_key);
    if let Some(code) = codes.first() {
        Ok(code.1.clone())
    } else {
        panic!("{}/{} not present in TX log", event_type, attribute_key)
    }
}
#[derive(Deserialize, Serialize, Debug)]
pub struct Event {
    pub attributes: Vec<EventAttribute>,
    #[serde(rename = "type")]
    pub s_type: String,
}
