#![allow(missing_docs)]

use glob::PatternError;
use std::num::{ParseFloatError, ParseIntError};
use terra_rust_api::errors::TerraRustAPIError;
use terra_rust_cli::errors::TerraRustCLIError;
use terra_rust_wallet::errors::TerraRustWalletError;
use thiserror::Error;

#[derive(Error, Debug)]
pub enum TerraRustTestingError {
    #[error("Bad Implementation. Missing CLI Argument {0}")]
    MissingArgument(String),
    #[error(transparent)]
    IOErr(#[from] ::std::io::Error),
    #[error(transparent)]
    NumberFloatErr(#[from] ParseFloatError),
    #[error(transparent)]
    NumberIntErr(#[from] ParseIntError),
    #[error(transparent)]
    TerraRustAPIError(#[from] TerraRustAPIError),
    #[error(transparent)]
    TerraRustCLIError(#[from] TerraRustCLIError),
    #[error(transparent)]
    TerraRustWalletError(#[from] TerraRustWalletError),
    #[error(transparent)]
    SerdeJson(#[from] ::serde_json::Error),
    #[error(transparent)]
    GlobError(#[from] ::glob::GlobError),
    #[error(transparent)]
    PatternError(#[from] PatternError),

    #[error("{0} is not a directory")]
    NotADirectory(String),
    #[error("{0} matches multiple wasms (or none). choose better")]
    TooManyMatches(String),
    #[error("query {0} {1} response mismatch {2} {3}")]
    QueryResponseFail(String, String, String, String),
    #[error("exec {0} {1} response mismatch {2} {3}/{4}")]
    ExecResponseFail(String, String, String, String, String),
    #[error("exec {0} {1} was supposed to fail {2}")]
    ExecResponseShouldHaveFailed(String, String, String),
    #[error("exec {0} {1} was supposed to fail  {2} {3}")]
    ExecResponseShouldHaveFailedMessage(String, String, String, String),
}
