# PFC-Tester
Testing multiple smart contracts is difficult.
Especially when you have multiple contracts all interacting with each other.
This suite of tools is focused on making integrating testing easier, and to supplement the unit testing being done.
It assumes you are using [terra-rust](https://github.com/PFC-Validator/terra-rust/) to create wallet/keys locally.

there are two components. PFC-Loader, and PFC-Replayer

# PFC-loader
will attempt to store and instantiate the WASM files in the directory specified (defaulting to ./resources) [resources](./resources) directory

For each WASM file it finds, it will look for a corresponding set of 'json' files
using the pattern ```&lt;xyz&gt;.wasm``` -&gt; ```&lt;xyz&gt;.*.init.json``` or ```&lt;xyz&gt;*.migrate.json``` and attempt to instantiate them.
This pattern allows you to instantiate multiple contracts using the same WASM file.

It will generate 2 files  'code_id.env' & 'contracts.env' file with name value pairs matching the filenames and their associated contract addresses.

for example
```shell
CW20_LEGACY=terra1....
CW20_LEGACY_2=terra1....
```
and
```shell
cw20_legacy_2_CONTRACT_CODE=52902
cw20_legacy_2=terra1c74qfh0z3zrh9kkxs5c29dtm33p5zj5ttjjpw9
cw20_legacy_CONTRACT_CODE=52902
cw20_legacy=terra13fccf5mdrrmta5ln22ca4w3patd2v34g6l927a
terra_peep721_CONTRACT_CODE=52901
terra_peep721=terra1ypknwvsjvrcvju38ydtqf0dygvlzccv0mf788j
```

these files can be hand modified, and are also read by the replayer, the values ready to be integrated into the replayer requests

## usage

most items can be read from the environment or the '.env' file if it is present
```shell
 $ pfc-loader --help
```
will display the arguments and usage.
a sample run, using the WASM files in the resources directory:
```shell
 $ pfc-loader --sender test --test_directory resources

[2022-03-16T01:01:40Z INFO  terra_rust_cli::cli_helpers] Using Gas price of 0.01133uluna
[2022-03-16T01:01:42Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:01:56Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:02:08Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:02:17Z INFO  pfc_loader] code_id.env stored
[2022-03-16T01:02:17Z INFO  pfc_loader] WASMs ["terra_peep721", "cw20_legacy", "pfc_XXXXXXX"]
[2022-03-16T01:02:17Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:02:22Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:02:30Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:02:34Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:02:41Z INFO  pfc_loader] contracts.env stored

$ cat code_id.env
# Generated 2022-03-16T01:02:17.092602700+00:00
# To force re-storage, remove the line. This will re-store the code, and do migrate
#
#
terra_peep721_CODE=53088
cw20_legacy_CODE=53089
pfc_XXXXXX_CODE=53087
$ cat contracts.env
# Generated 2022-03-16T01:02:41.753588900+00:00
# To force re-instantiation, remove the line. This will re-instantiation the code
#
#
pfc_XXXXXX_CONTRACT_CODE=53087
pfc_XXXXXX=terra1pje3hw3cufl3t6ayuu0xn827xcy783tr7248df
cw20_legacy_CONTRACT_CODE=53089
cw20_legacy=terra12m8wthgl9wjk90kx8gukrn4m7hsdrj07q4qk8c
terra_peep721_CONTRACT_CODE=53088
terra_peep721=terra1crc8ctl5fvtv9yqs4n7de9qz5y2qm37yle6fux
cw20_legacy_2_CONTRACT_CODE=53089
cw20_legacy_2=terra1xjg8nrj2qt9cykne5l3pa208tj0x69xk7cm9ld
```

If you find it too terse, change your *RUST_LOG* environment variable to 'info' or 'debug'

# PFC-replayer

The replayer takes an input files ending in *.test.json in a directory [example](./resources/cw20_load.test.json) and attempts to execute these commands and validate that the output matches.


There are currently 3 types of commands.
* Query ... run a query against a contract, and validate the JSON response
* Exec ... execute a smart contract action, and validate the attributes it returns
* Send ... send some native coins to a person/contract

## json replacement codes
inside the json files **PFC-replayer** will attempt to expand certain common variables that might appear in messages:

- **###SENDER###** - the account initiating the action
- **###CODE_ID###** - the code ID of the WASM (instantiate message only)
- **###ADMIN###** - the admin account (instantiate/migrate message only)
- **###CONTRACT###** - the contract address (migrate messages only)
- **###NEW_CODE_ID###** - the code ID of the new WASM (migrate messages only)
- **###E:XXXX###** - the contents of environment variable 'XXXX'
- **###A:XXXX###** - the account address of the private key 'XXXX' in your wallet
- **###O:XXXX###** - the operator address of the private key 'XXXX' in your wallet

## usage
most items can be read from the environment or the '.env' file if it is present
```shell
$ pfc-replayer --help
```

will display the arguments and usage.
a sample run, the [test script](./resources/cw20_load.test.json) in the resources directory.
The tool currently will run all files ending in *.test.json.
```shell
[2022-03-16T01:10:15Z INFO  terra_rust_cli::cli_helpers] Using Gas price of 0.01133uluna
[2022-03-16T01:10:15Z INFO  pfc_replayer] resources\cw20_load.test.json
[2022-03-16T01:10:16Z INFO  pfc_replayer] OK: Query - terra12m8wthgl9wjk90kx8gukrn4m7hsdrj07q4qk8c
[2022-03-16T01:10:16Z INFO  pfc_replayer] OK: Query test minter terra12m8wthgl9wjk90kx8gukrn4m7hsdrj07q4qk8c
[2022-03-16T01:10:16Z INFO  pfc_replayer] OK: Query balance terra12m8wthgl9wjk90kx8gukrn4m7hsdrj07q4qk8c
[2022-03-16T01:10:16Z INFO  pfc_replayer] OK: Query NFT tokens should be empty terra1crc8ctl5fvtv9yqs4n7de9qz5y2qm37yle6fux
[2022-03-16T01:10:17Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:10:27Z INFO  pfc_replayer] OK Bank Send send funds terra1n3g37dsdlv7ryqftlkef8mhgqj4ny7p8v78lg7-> terra1hlxy5gduv0mvm2kks0eamymuzm4c9xmmjklavj # 20uluna
[2022-03-16T01:10:28Z INFO  pfc_replayer] OK: Exec NFT config terra1crc8ctl5fvtv9yqs4n7de9qz5y2qm37yle6fux -- Error
[2022-03-16T01:10:29Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:10:45Z ERROR pfc_replayer] Transaction 34DBFB6C0C3EFFB19556D0399F2825526CA7C3B229CFF3840086DAA5201F7BFE not found after 5 attempts
```
in this case the test failed, as the chain was taking too long to return the TX.
re-running it with 'retries 10' resolved the issue
```shell
$ pfc-replayer --sender test --retries 10
[2022-03-16T01:12:27Z INFO  terra_rust_cli::cli_helpers] Using Gas price of 0.01133uluna
[2022-03-16T01:12:27Z INFO  pfc_replayer] resources\cw20_load.test.json
[2022-03-16T01:12:28Z INFO  pfc_replayer] OK: Query - terra12m8wthgl9wjk90kx8gukrn4m7hsdrj07q4qk8c
[2022-03-16T01:12:28Z INFO  pfc_replayer] OK: Query test minter terra12m8wthgl9wjk90kx8gukrn4m7hsdrj07q4qk8c
[2022-03-16T01:12:29Z INFO  pfc_replayer] OK: Query balance terra12m8wthgl9wjk90kx8gukrn4m7hsdrj07q4qk8c
[2022-03-16T01:12:29Z INFO  pfc_replayer] OK: Query NFT tokens should be empty terra1crc8ctl5fvtv9yqs4n7de9qz5y2qm37yle6fux
[2022-03-16T01:12:29Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:12:37Z INFO  pfc_replayer] OK Bank Send send funds terra1n3g37dsdlv7ryqftlkef8mhgqj4ny7p8v78lg7-> terra1hlxy5gduv0mvm2kks0eamymuzm4c9xmmjklavj # 20uluna
[2022-03-16T01:12:37Z INFO  pfc_replayer] OK: Exec NFT config terra1crc8ctl5fvtv9yqs4n7de9qz5y2qm37yle6fux -- Error
[2022-03-16T01:12:38Z INFO  terra_rust_api::client::tx] TX broadcast #messages =1
[2022-03-16T01:12:48Z INFO  pfc_replayer] OK: Exec NFT config terra1crc8ctl5fvtv9yqs4n7de9qz5y2qm37yle6fux
```

# License
ASL 2.0 - see [LICENSE](./LICENSE)

# PFC
If you think this was useful, feel free to delegate to the [PFC](https://station.terra.money/validator/terravaloper12g4nkvsjjnl0t7fvq3hdcw7y8dc9fq69nyeu9q) validator. It will help defray the costs.

[PFC](https://twitter.com/PFC_Validator) - As Terra is all about the Precious Fractional Choice right... feel free to drop me a line

