
#[repr(C)]
pub union pf_altq_pq
{
    cbq_opts: CbqOpts,
    codel_opts: CodelOpts,
    priq_opts: PriqOpts,
    hfsc_opts: HfscOptsV1,
    fairq_opts: FairqOpts
}

//https://github.com/freebsd/freebsd-src/blob/6b364a92fd790717fe7ea589df62dc1a653137dc/sys/netpfil/pf/pf_altq.h#L159
#[repr(C)]
pub struct pf_altq
{
    ifname: [i8; IFNAMSIZ],

    entries: *const pf_altq,

    // scheduler spec
    /// scheduler type
    scheduler: u8,
    /// tokenbucket regulator size
    tbrsize: u32,
    /// interface bandwidth
    ifbandwidth: u64,

    // queue spec
    /// queue name
    qname: [i8; PF_QNAME_SIZE],
    /// parent name
    parent: [i8; PF_QNAME_SIZE],
    /// parent queue id
    parent_qid: u32,
    /// queue bandwidth
    bandwidth: u64,
    /// priority
    priority: u8,
    /// dynamic interface, see _v0 
    local_flags: u8,
    /// queue size limit
    qlimit: u16,
    /// misc flags 
    flags: u16,
    pq_u: pf_altq_pq,
    /// return value
    qid: u32,
}

// v1
// https://github.com/freebsd/freebsd-src/blob/6b364a92fd790717fe7ea589df62dc1a653137dc/sys/net/pfvar.h#L1548
#[repr(C)]
pub struct pfioc_altq
{
    action: u32,
    ticket: u32,
    ne: u32,
    version: u32,

    altq: pf_altq,
}

// https://github.com/freebsd/freebsd-src/blob/6b364a92fd790717fe7ea589df62dc1a653137dc/sbin/pfctl/pfctl_parser.h#L78
pub struct pfctl
{
    dev: libc::c_int,
    opts: libc::c_int,
    optimize: libc::c_int,
    loadopt: libc::c_int,

    /// abchor stack depth
    asd: libc::c_int,

    /// brace number
    bn: libc::c_int,
    brace: libc::c_int,

    /// kernel dirty
    tdirty: libc::c_int,
    astack: [*const PfctlAnchor; 64],
    paddr: pfioc_pooladdr,
    paltq: pfioc_altq,
    pqueue: pfioc_queue,
    trans: pfr_buffer
}
