/*-
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (c) 2021 Aleksandr Morozov, RELKOM s.r.o
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

//! Pf-RS
//! 
//! Provides a userspace interface to the /sev/pf FreeBSD port of the OpenBSD's PF
//!
//! Supports:
//! - Add, Test, Delete multiple IP/IPv6/DNS
//! - Add, Test, Delete from file (directly)
//! - Kill state by source IP or by source and destination IP
//! 
//! This crate supports only FreeBSD 13.
//!
//! This is experimantal crate!
//!
//! The crate version is decoded:
//! - major version - is a FreeBSD major version
//! - minor version - is a FreebSd minor version
//! - build - is a patch of the crate
//! 
//! Files:
//! - pf.rs contains library code
//! - pf_tokenizer.rs a ip/domain list parser and tokenizer
//! - common.rs shared code
//! - portable - all portable and shared code is there


extern crate libc;
extern crate nix;

pub mod pf;
mod pf_tokenizer;
mod portable;

#[macro_use] pub mod common;
#[macro_use] pub mod runtime_exception;
