/********************************************************************************
 *   Prometheus exporter for monitoring network connectivity using icmp pings   *
 *                                                                              *
 *   Copyright (C) 2019-2020 Jan Christian Grünhage                             *
 *   Copyright (C) 2020 Famedly GmbH                                            *
 *                                                                              *
 *   This program is free software: you can redistribute it and/or modify       *
 *   it under the terms of the GNU Affero General Public License as             *
 *   published by the Free Software Foundation, either version 3 of the         *
 *   License, or (at your option) any later version.                            *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               *
 *   GNU Affero General Public License for more details.                        *
 *                                                                              *
 *   You should have received a copy of the GNU Affero General Public License   *
 *   along with this program.  If not, see <https://www.gnu.org/licenses/>.     *
 ********************************************************************************/
use anyhow::Result;
use async_anyhow_logger::catch;

mod config;
mod metrics;
mod ping;

use config::setup_app;
use metrics::start_serving_metrics;
use ping::start_pinging_hosts;

#[tokio::main]
async fn main() -> Result<()> {
    let config = setup_app()?;

    let ping_fut = catch(start_pinging_hosts(&config));
    let serve_fut = catch(start_serving_metrics(&config));

    futures::pin_mut!(ping_fut);
    futures::pin_mut!(serve_fut);

    futures::future::select(ping_fut, serve_fut).await;
    Ok(())
}
